// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AttachInstancesInput`](crate::input::AttachInstancesInput)
pub mod attach_instances_input {
    /// A builder for [`AttachInstancesInput`](crate::input::AttachInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachInstancesInput`](crate::input::AttachInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachInstancesInput {
                instance_ids: self.instance_ids,
                auto_scaling_group_name: self.auto_scaling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachInstancesInputOperationOutputAlias = crate::operation::AttachInstances;
#[doc(hidden)]
pub type AttachInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachInstancesInput {
    /// Consumes the builder and constructs an Operation<[`AttachInstances`](crate::operation::AttachInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_instances(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachInstances",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachInstancesInput`](crate::input::AttachInstancesInput)
    pub fn builder() -> crate::input::attach_instances_input::Builder {
        crate::input::attach_instances_input::Builder::default()
    }
}

/// See [`AttachLoadBalancersInput`](crate::input::AttachLoadBalancersInput)
pub mod attach_load_balancers_input {
    /// A builder for [`AttachLoadBalancersInput`](crate::input::AttachLoadBalancersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachLoadBalancersInput`](crate::input::AttachLoadBalancersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachLoadBalancersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachLoadBalancersInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                load_balancer_names: self.load_balancer_names,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachLoadBalancersInputOperationOutputAlias = crate::operation::AttachLoadBalancers;
#[doc(hidden)]
pub type AttachLoadBalancersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachLoadBalancersInput {
    /// Consumes the builder and constructs an Operation<[`AttachLoadBalancers`](crate::operation::AttachLoadBalancers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachLoadBalancers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachLoadBalancersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachLoadBalancersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_load_balancers(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachLoadBalancers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachLoadBalancers",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancersInput`](crate::input::AttachLoadBalancersInput)
    pub fn builder() -> crate::input::attach_load_balancers_input::Builder {
        crate::input::attach_load_balancers_input::Builder::default()
    }
}

/// See [`AttachLoadBalancerTargetGroupsInput`](crate::input::AttachLoadBalancerTargetGroupsInput)
pub mod attach_load_balancer_target_groups_input {
    /// A builder for [`AttachLoadBalancerTargetGroupsInput`](crate::input::AttachLoadBalancerTargetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `target_group_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_target_group_ar_ns`](Self::set_target_group_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups. To get the ARN of a target group, use the Elastic Load Balancing <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn target_group_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_group_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.target_group_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups. To get the ARN of a target group, use the Elastic Load Balancing <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_target_group_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_group_ar_ns = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachLoadBalancerTargetGroupsInput`](crate::input::AttachLoadBalancerTargetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachLoadBalancerTargetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachLoadBalancerTargetGroupsInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                target_group_ar_ns: self.target_group_ar_ns,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachLoadBalancerTargetGroupsInputOperationOutputAlias =
    crate::operation::AttachLoadBalancerTargetGroups;
#[doc(hidden)]
pub type AttachLoadBalancerTargetGroupsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AttachLoadBalancerTargetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`AttachLoadBalancerTargetGroups`](crate::operation::AttachLoadBalancerTargetGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachLoadBalancerTargetGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachLoadBalancerTargetGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachLoadBalancerTargetGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_load_balancer_target_groups(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachLoadBalancerTargetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachLoadBalancerTargetGroups",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancerTargetGroupsInput`](crate::input::AttachLoadBalancerTargetGroupsInput)
    pub fn builder() -> crate::input::attach_load_balancer_target_groups_input::Builder {
        crate::input::attach_load_balancer_target_groups_input::Builder::default()
    }
}

/// See [`BatchDeleteScheduledActionInput`](crate::input::BatchDeleteScheduledActionInput)
pub mod batch_delete_scheduled_action_input {
    /// A builder for [`BatchDeleteScheduledActionInput`](crate::input::BatchDeleteScheduledActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `scheduled_action_names`.
        ///
        /// To override the contents of this collection use [`set_scheduled_action_names`](Self::set_scheduled_action_names).
        ///
        /// <p>The names of the scheduled actions to delete. The maximum number allowed is 50. </p>
        pub fn scheduled_action_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.scheduled_action_names.unwrap_or_default();
            v.push(input.into());
            self.scheduled_action_names = Some(v);
            self
        }
        /// <p>The names of the scheduled actions to delete. The maximum number allowed is 50. </p>
        pub fn set_scheduled_action_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.scheduled_action_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteScheduledActionInput`](crate::input::BatchDeleteScheduledActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteScheduledActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteScheduledActionInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scheduled_action_names: self.scheduled_action_names,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteScheduledActionInputOperationOutputAlias =
    crate::operation::BatchDeleteScheduledAction;
#[doc(hidden)]
pub type BatchDeleteScheduledActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeleteScheduledActionInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteScheduledAction`](crate::operation::BatchDeleteScheduledAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteScheduledAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchDeleteScheduledActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchDeleteScheduledActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_scheduled_action(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteScheduledAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteScheduledAction",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteScheduledActionInput`](crate::input::BatchDeleteScheduledActionInput)
    pub fn builder() -> crate::input::batch_delete_scheduled_action_input::Builder {
        crate::input::batch_delete_scheduled_action_input::Builder::default()
    }
}

/// See [`BatchPutScheduledUpdateGroupActionInput`](crate::input::BatchPutScheduledUpdateGroupActionInput)
pub mod batch_put_scheduled_update_group_action_input {
    /// A builder for [`BatchPutScheduledUpdateGroupActionInput`](crate::input::BatchPutScheduledUpdateGroupActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_update_group_actions:
            std::option::Option<std::vec::Vec<crate::model::ScheduledUpdateGroupActionRequest>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `scheduled_update_group_actions`.
        ///
        /// To override the contents of this collection use [`set_scheduled_update_group_actions`](Self::set_scheduled_update_group_actions).
        ///
        /// <p>One or more scheduled actions. The maximum number allowed is 50.</p>
        pub fn scheduled_update_group_actions(
            mut self,
            input: crate::model::ScheduledUpdateGroupActionRequest,
        ) -> Self {
            let mut v = self.scheduled_update_group_actions.unwrap_or_default();
            v.push(input);
            self.scheduled_update_group_actions = Some(v);
            self
        }
        /// <p>One or more scheduled actions. The maximum number allowed is 50.</p>
        pub fn set_scheduled_update_group_actions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ScheduledUpdateGroupActionRequest>,
            >,
        ) -> Self {
            self.scheduled_update_group_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutScheduledUpdateGroupActionInput`](crate::input::BatchPutScheduledUpdateGroupActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchPutScheduledUpdateGroupActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchPutScheduledUpdateGroupActionInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scheduled_update_group_actions: self.scheduled_update_group_actions,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchPutScheduledUpdateGroupActionInputOperationOutputAlias =
    crate::operation::BatchPutScheduledUpdateGroupAction;
#[doc(hidden)]
pub type BatchPutScheduledUpdateGroupActionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchPutScheduledUpdateGroupActionInput {
    /// Consumes the builder and constructs an Operation<[`BatchPutScheduledUpdateGroupAction`](crate::operation::BatchPutScheduledUpdateGroupAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchPutScheduledUpdateGroupAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchPutScheduledUpdateGroupActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchPutScheduledUpdateGroupActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_put_scheduled_update_group_action(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchPutScheduledUpdateGroupAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchPutScheduledUpdateGroupAction",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchPutScheduledUpdateGroupActionInput`](crate::input::BatchPutScheduledUpdateGroupActionInput)
    pub fn builder() -> crate::input::batch_put_scheduled_update_group_action_input::Builder {
        crate::input::batch_put_scheduled_update_group_action_input::Builder::default()
    }
}

/// See [`CancelInstanceRefreshInput`](crate::input::CancelInstanceRefreshInput)
pub mod cancel_instance_refresh_input {
    /// A builder for [`CancelInstanceRefreshInput`](crate::input::CancelInstanceRefreshInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelInstanceRefreshInput`](crate::input::CancelInstanceRefreshInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelInstanceRefreshInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelInstanceRefreshInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelInstanceRefreshInputOperationOutputAlias = crate::operation::CancelInstanceRefresh;
#[doc(hidden)]
pub type CancelInstanceRefreshInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelInstanceRefreshInput {
    /// Consumes the builder and constructs an Operation<[`CancelInstanceRefresh`](crate::operation::CancelInstanceRefresh)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelInstanceRefresh,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelInstanceRefreshInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelInstanceRefreshInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_instance_refresh(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelInstanceRefresh::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelInstanceRefresh",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelInstanceRefreshInput`](crate::input::CancelInstanceRefreshInput)
    pub fn builder() -> crate::input::cancel_instance_refresh_input::Builder {
        crate::input::cancel_instance_refresh_input::Builder::default()
    }
}

/// See [`CompleteLifecycleActionInput`](crate::input::CompleteLifecycleActionInput)
pub mod complete_lifecycle_action_input {
    /// A builder for [`CompleteLifecycleActionInput`](crate::input::CompleteLifecycleActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_hook_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_action_token: std::option::Option<std::string::String>,
        pub(crate) lifecycle_action_result: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lifecycle hook.</p>
        pub fn lifecycle_hook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_hook_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle hook.</p>
        pub fn set_lifecycle_hook_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_hook_name = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.</p>
        pub fn lifecycle_action_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_action_token = Some(input.into());
            self
        }
        /// <p>A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.</p>
        pub fn set_lifecycle_action_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_action_token = input;
            self
        }
        /// <p>The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.</p>
        pub fn lifecycle_action_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_action_result = Some(input.into());
            self
        }
        /// <p>The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.</p>
        pub fn set_lifecycle_action_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_action_result = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CompleteLifecycleActionInput`](crate::input::CompleteLifecycleActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CompleteLifecycleActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CompleteLifecycleActionInput {
                lifecycle_hook_name: self.lifecycle_hook_name,
                auto_scaling_group_name: self.auto_scaling_group_name,
                lifecycle_action_token: self.lifecycle_action_token,
                lifecycle_action_result: self.lifecycle_action_result,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CompleteLifecycleActionInputOperationOutputAlias =
    crate::operation::CompleteLifecycleAction;
#[doc(hidden)]
pub type CompleteLifecycleActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CompleteLifecycleActionInput {
    /// Consumes the builder and constructs an Operation<[`CompleteLifecycleAction`](crate::operation::CompleteLifecycleAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CompleteLifecycleAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CompleteLifecycleActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CompleteLifecycleActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_complete_lifecycle_action(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CompleteLifecycleAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CompleteLifecycleAction",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CompleteLifecycleActionInput`](crate::input::CompleteLifecycleActionInput)
    pub fn builder() -> crate::input::complete_lifecycle_action_input::Builder {
        crate::input::complete_lifecycle_action_input::Builder::default()
    }
}

/// See [`CreateAutoScalingGroupInput`](crate::input::CreateAutoScalingGroupInput)
pub mod create_auto_scaling_group_input {
    /// A builder for [`CreateAutoScalingGroupInput`](crate::input::CreateAutoScalingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) default_cooldown: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) health_check_type: std::option::Option<std::string::String>,
        pub(crate) health_check_grace_period: std::option::Option<i32>,
        pub(crate) placement_group: std::option::Option<std::string::String>,
        pub(crate) vpc_zone_identifier: std::option::Option<std::string::String>,
        pub(crate) termination_policies: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) new_instances_protected_from_scale_in: std::option::Option<bool>,
        pub(crate) capacity_rebalance: std::option::Option<bool>,
        pub(crate) lifecycle_hook_specification_list:
            std::option::Option<std::vec::Vec<crate::model::LifecycleHookSpecification>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) service_linked_role_arn: std::option::Option<std::string::String>,
        pub(crate) max_instance_lifetime: std::option::Option<i32>,
        pub(crate) context: std::option::Option<std::string::String>,
        pub(crate) desired_capacity_type: std::option::Option<std::string::String>,
        pub(crate) default_instance_warmup: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group. This name must be unique per Region per account.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group. This name must be unique per Region per account.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of the launch configuration to use to launch instances. </p>
        /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration to use to launch instances. </p>
        /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>Parameters used to specify the launch template and version to use to launch instances. </p>
        /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p> <note>
        /// <p>The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// </note>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>Parameters used to specify the launch template and version to use to launch instances. </p>
        /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p> <note>
        /// <p>The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// </note>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// <p>An embedded object that specifies a mixed instances policy.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn mixed_instances_policy(mut self, input: crate::model::MixedInstancesPolicy) -> Self {
            self.mixed_instances_policy = Some(input);
            self
        }
        /// <p>An embedded object that specifies a mixed instances policy.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_mixed_instances_policy(
            mut self,
            input: std::option::Option<crate::model::MixedInstancesPolicy>,
        ) -> Self {
            self.mixed_instances_policy = input;
            self
        }
        /// <p>The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> API operation. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> API operation. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The minimum size of the group.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum size of the group.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum size of the group.</p> <note>
        /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
        /// </note>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum size of the group.</p> <note>
        /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
        /// </note>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.</p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.</p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
        /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Default: <code>300</code> seconds</p>
        pub fn default_cooldown(mut self, input: i32) -> Self {
            self.default_cooldown = Some(input);
            self
        }
        /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
        /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Default: <code>300</code> seconds</p>
        pub fn set_default_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.default_cooldown = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p>
        /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into EC2-Classic.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p>
        /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into EC2-Classic.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// Appends an item to `target_group_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_target_group_ar_ns`](Self::set_target_group_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn target_group_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_group_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.target_group_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_target_group_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_group_ar_ns = input;
            self
        }
        /// <p>The service to use for the health checks. The valid values are <code>EC2</code> (default) and <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn health_check_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_type = Some(input.into());
            self
        }
        /// <p>The service to use for the health checks. The valid values are <code>EC2</code> (default) and <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_health_check_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_type = input;
            self
        }
        /// <p> <i></i> </p>
        /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Default: <code>0</code> seconds</p>
        pub fn health_check_grace_period(mut self, input: i32) -> Self {
            self.health_check_grace_period = Some(input);
            self
        }
        /// <p> <i></i> </p>
        /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Default: <code>0</code> seconds</p>
        pub fn set_health_check_grace_period(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_grace_period = input;
            self
        }
        /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
        /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
        /// </note>
        pub fn placement_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_group = Some(input.into());
            self
        }
        /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
        /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
        /// </note>
        pub fn set_placement_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_group = input;
            self
        }
        /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
        /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into a VPC.</p>
        pub fn vpc_zone_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_zone_identifier = Some(input.into());
            self
        }
        /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
        /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into a VPC.</p>
        pub fn set_vpc_zone_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_zone_identifier = input;
            self
        }
        /// Appends an item to `termination_policies`.
        ///
        /// To override the contents of this collection use [`set_termination_policies`](Self::set_termination_policies).
        ///
        /// <p>A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn termination_policies(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.termination_policies.unwrap_or_default();
            v.push(input.into());
            self.termination_policies = Some(v);
            self
        }
        /// <p>A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_termination_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.termination_policies = input;
            self
        }
        /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn new_instances_protected_from_scale_in(mut self, input: bool) -> Self {
            self.new_instances_protected_from_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_new_instances_protected_from_scale_in(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.new_instances_protected_from_scale_in = input;
            self
        }
        /// <p>Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn capacity_rebalance(mut self, input: bool) -> Self {
            self.capacity_rebalance = Some(input);
            self
        }
        /// <p>Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_capacity_rebalance(mut self, input: std::option::Option<bool>) -> Self {
            self.capacity_rebalance = input;
            self
        }
        /// Appends an item to `lifecycle_hook_specification_list`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_hook_specification_list`](Self::set_lifecycle_hook_specification_list).
        ///
        /// <p>One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.</p>
        pub fn lifecycle_hook_specification_list(
            mut self,
            input: crate::model::LifecycleHookSpecification,
        ) -> Self {
            let mut v = self.lifecycle_hook_specification_list.unwrap_or_default();
            v.push(input);
            self.lifecycle_hook_specification_list = Some(v);
            self
        }
        /// <p>One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.</p>
        pub fn set_lifecycle_hook_specification_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LifecycleHookSpecification>>,
        ) -> Self {
            self.lifecycle_hook_specification_list = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn service_linked_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_linked_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_service_linked_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_linked_role_arn = input;
            self
        }
        /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn max_instance_lifetime(mut self, input: i32) -> Self {
            self.max_instance_lifetime = Some(input);
            self
        }
        /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_max_instance_lifetime(mut self, input: std::option::Option<i32>) -> Self {
            self.max_instance_lifetime = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
        /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
        pub fn desired_capacity_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.desired_capacity_type = Some(input.into());
            self
        }
        /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
        /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
        pub fn set_desired_capacity_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_capacity_type = input;
            self
        }
        /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
        /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
        /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
        /// </important>
        /// <p>Default: None </p>
        pub fn default_instance_warmup(mut self, input: i32) -> Self {
            self.default_instance_warmup = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
        /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
        /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
        /// </important>
        /// <p>Default: None </p>
        pub fn set_default_instance_warmup(mut self, input: std::option::Option<i32>) -> Self {
            self.default_instance_warmup = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAutoScalingGroupInput`](crate::input::CreateAutoScalingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAutoScalingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAutoScalingGroupInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                launch_configuration_name: self.launch_configuration_name,
                launch_template: self.launch_template,
                mixed_instances_policy: self.mixed_instances_policy,
                instance_id: self.instance_id,
                min_size: self.min_size,
                max_size: self.max_size,
                desired_capacity: self.desired_capacity,
                default_cooldown: self.default_cooldown,
                availability_zones: self.availability_zones,
                load_balancer_names: self.load_balancer_names,
                target_group_ar_ns: self.target_group_ar_ns,
                health_check_type: self.health_check_type,
                health_check_grace_period: self.health_check_grace_period,
                placement_group: self.placement_group,
                vpc_zone_identifier: self.vpc_zone_identifier,
                termination_policies: self.termination_policies,
                new_instances_protected_from_scale_in: self.new_instances_protected_from_scale_in,
                capacity_rebalance: self.capacity_rebalance,
                lifecycle_hook_specification_list: self.lifecycle_hook_specification_list,
                tags: self.tags,
                service_linked_role_arn: self.service_linked_role_arn,
                max_instance_lifetime: self.max_instance_lifetime,
                context: self.context,
                desired_capacity_type: self.desired_capacity_type,
                default_instance_warmup: self.default_instance_warmup,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAutoScalingGroupInputOperationOutputAlias = crate::operation::CreateAutoScalingGroup;
#[doc(hidden)]
pub type CreateAutoScalingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAutoScalingGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateAutoScalingGroup`](crate::operation::CreateAutoScalingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAutoScalingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAutoScalingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAutoScalingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_auto_scaling_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAutoScalingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAutoScalingGroup",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAutoScalingGroupInput`](crate::input::CreateAutoScalingGroupInput)
    pub fn builder() -> crate::input::create_auto_scaling_group_input::Builder {
        crate::input::create_auto_scaling_group_input::Builder::default()
    }
}

/// See [`CreateLaunchConfigurationInput`](crate::input::CreateLaunchConfigurationInput)
pub mod create_launch_configuration_input {
    /// A builder for [`CreateLaunchConfigurationInput`](crate::input::CreateLaunchConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) classic_link_vpc_id: std::option::Option<std::string::String>,
        pub(crate) classic_link_vpc_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_data: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) kernel_id: std::option::Option<std::string::String>,
        pub(crate) ramdisk_id: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        pub(crate) instance_monitoring: std::option::Option<crate::model::InstanceMonitoring>,
        pub(crate) spot_price: std::option::Option<std::string::String>,
        pub(crate) iam_instance_profile: std::option::Option<std::string::String>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) associate_public_ip_address: std::option::Option<bool>,
        pub(crate) placement_tenancy: std::option::Option<std::string::String>,
        pub(crate) metadata_options: std::option::Option<crate::model::InstanceMetadataOptions>,
    }
    impl Builder {
        /// <p>The name of the launch configuration. This name must be unique per Region per account.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration. This name must be unique per Region per account.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The name of the key pair. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.</p>
        /// <p>[EC2-VPC] Specify the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        /// <p>[EC2-Classic] Specify either the security group names or the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.</p>
        /// <p>[EC2-VPC] Specify the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
        /// <p>[EC2-Classic] Specify either the security group names or the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
        /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn classic_link_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.classic_link_vpc_id = Some(input.into());
            self
        }
        /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
        /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_classic_link_vpc_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classic_link_vpc_id = input;
            self
        }
        /// Appends an item to `classic_link_vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_classic_link_vpc_security_groups`](Self::set_classic_link_vpc_security_groups).
        ///
        /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
        /// <p>The IDs of one or more security groups for the specified ClassicLink-enabled VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>If you specify the <code>ClassicLinkVPCId</code> parameter, you must specify this parameter.</p>
        pub fn classic_link_vpc_security_groups(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.classic_link_vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.classic_link_vpc_security_groups = Some(v);
            self
        }
        /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
        /// <p>The IDs of one or more security groups for the specified ClassicLink-enabled VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>If you specify the <code>ClassicLinkVPCId</code> parameter, you must specify this parameter.</p>
        pub fn set_classic_link_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.classic_link_vpc_security_groups = input;
            self
        }
        /// <p>The user data to make available to the launched EC2 instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.</p>
        pub fn user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data = Some(input.into());
            self
        }
        /// <p>The user data to make available to the launched EC2 instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.</p>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_data = input;
            self
        }
        /// <p>The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping.</p>
        /// <p>To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html">Creating a launch configuration using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and <code>InstanceType</code>.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping.</p>
        /// <p>To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html">Creating a launch configuration using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and <code>InstanceType</code>.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Specifies the instance type of the EC2 instance.</p>
        /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>Specifies the instance type of the EC2 instance.</p>
        /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The ID of the kernel associated with the AMI.</p>
        pub fn kernel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kernel_id = Some(input.into());
            self
        }
        /// <p>The ID of the kernel associated with the AMI.</p>
        pub fn set_kernel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kernel_id = input;
            self
        }
        /// <p>The ID of the RAM disk to select.</p>
        pub fn ramdisk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ramdisk_id = Some(input.into());
            self
        }
        /// <p>The ID of the RAM disk to select.</p>
        pub fn set_ramdisk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ramdisk_id = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>A block device mapping, which specifies the block devices for the instance. You can specify virtual devices and EBS volumes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn block_device_mappings(mut self, input: crate::model::BlockDeviceMapping) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input);
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>A block device mapping, which specifies the block devices for the instance. You can specify virtual devices and EBS volumes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
        /// <p>The default value is <code>true</code> (enabled).</p> <important>
        /// <p>When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// </important>
        pub fn instance_monitoring(mut self, input: crate::model::InstanceMonitoring) -> Self {
            self.instance_monitoring = Some(input);
            self
        }
        /// <p>Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
        /// <p>The default value is <code>true</code> (enabled).</p> <important>
        /// <p>When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// </important>
        pub fn set_instance_monitoring(
            mut self,
            input: std::option::Option<crate::model::InstanceMonitoring>,
        ) -> Self {
            self.instance_monitoring = input;
            self
        }
        /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
        /// <p>When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.</p>
        /// </note>
        pub fn spot_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_price = Some(input.into());
            self
        }
        /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
        /// <p>When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.</p>
        /// </note>
        pub fn set_spot_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spot_price = input;
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn iam_instance_profile(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_instance_profile = Some(input.into());
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>The default value is <code>false</code>.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>For Auto Scaling groups that are running in a virtual private cloud (VPC), specifies whether to assign a public IP address to the group's instances. If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IP address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>If you specify this parameter, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p> <note>
        /// <p>If the instance is launched into a default subnet, the default is to assign a public IP address, unless you disabled the option to assign a public IP address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IP address, unless you enabled the option to assign a public IP address on the subnet.</p>
        /// </note>
        pub fn associate_public_ip_address(mut self, input: bool) -> Self {
            self.associate_public_ip_address = Some(input);
            self
        }
        /// <p>For Auto Scaling groups that are running in a virtual private cloud (VPC), specifies whether to assign a public IP address to the group's instances. If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IP address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>If you specify this parameter, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p> <note>
        /// <p>If the instance is launched into a default subnet, the default is to assign a public IP address, unless you disabled the option to assign a public IP address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IP address, unless you enabled the option to assign a public IP address on the subnet.</p>
        /// </note>
        pub fn set_associate_public_ip_address(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_public_ip_address = input;
            self
        }
        /// <p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.</p>
        /// <p>To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to <code>default</code>), you must set the value of this parameter to <code>dedicated</code>.</p>
        /// <p>If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring instance tenancy with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Valid Values: <code>default</code> | <code>dedicated</code> </p>
        pub fn placement_tenancy(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_tenancy = Some(input.into());
            self
        }
        /// <p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.</p>
        /// <p>To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to <code>default</code>), you must set the value of this parameter to <code>dedicated</code>.</p>
        /// <p>If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring instance tenancy with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Valid Values: <code>default</code> | <code>dedicated</code> </p>
        pub fn set_placement_tenancy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_tenancy = input;
            self
        }
        /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn metadata_options(mut self, input: crate::model::InstanceMetadataOptions) -> Self {
            self.metadata_options = Some(input);
            self
        }
        /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.metadata_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLaunchConfigurationInput`](crate::input::CreateLaunchConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLaunchConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLaunchConfigurationInput {
                launch_configuration_name: self.launch_configuration_name,
                image_id: self.image_id,
                key_name: self.key_name,
                security_groups: self.security_groups,
                classic_link_vpc_id: self.classic_link_vpc_id,
                classic_link_vpc_security_groups: self.classic_link_vpc_security_groups,
                user_data: self.user_data,
                instance_id: self.instance_id,
                instance_type: self.instance_type,
                kernel_id: self.kernel_id,
                ramdisk_id: self.ramdisk_id,
                block_device_mappings: self.block_device_mappings,
                instance_monitoring: self.instance_monitoring,
                spot_price: self.spot_price,
                iam_instance_profile: self.iam_instance_profile,
                ebs_optimized: self.ebs_optimized,
                associate_public_ip_address: self.associate_public_ip_address,
                placement_tenancy: self.placement_tenancy,
                metadata_options: self.metadata_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLaunchConfigurationInputOperationOutputAlias =
    crate::operation::CreateLaunchConfiguration;
#[doc(hidden)]
pub type CreateLaunchConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLaunchConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateLaunchConfiguration`](crate::operation::CreateLaunchConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLaunchConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLaunchConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLaunchConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_launch_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLaunchConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLaunchConfiguration",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLaunchConfigurationInput`](crate::input::CreateLaunchConfigurationInput)
    pub fn builder() -> crate::input::create_launch_configuration_input::Builder {
        crate::input::create_launch_configuration_input::Builder::default()
    }
}

/// See [`CreateOrUpdateTagsInput`](crate::input::CreateOrUpdateTagsInput)
pub mod create_or_update_tags_input {
    /// A builder for [`CreateOrUpdateTagsInput`](crate::input::CreateOrUpdateTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOrUpdateTagsInput`](crate::input::CreateOrUpdateTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOrUpdateTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOrUpdateTagsInput { tags: self.tags })
        }
    }
}
#[doc(hidden)]
pub type CreateOrUpdateTagsInputOperationOutputAlias = crate::operation::CreateOrUpdateTags;
#[doc(hidden)]
pub type CreateOrUpdateTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOrUpdateTagsInput {
    /// Consumes the builder and constructs an Operation<[`CreateOrUpdateTags`](crate::operation::CreateOrUpdateTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOrUpdateTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOrUpdateTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOrUpdateTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_or_update_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOrUpdateTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOrUpdateTags",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOrUpdateTagsInput`](crate::input::CreateOrUpdateTagsInput)
    pub fn builder() -> crate::input::create_or_update_tags_input::Builder {
        crate::input::create_or_update_tags_input::Builder::default()
    }
}

/// See [`DeleteAutoScalingGroupInput`](crate::input::DeleteAutoScalingGroupInput)
pub mod delete_auto_scaling_group_input {
    /// A builder for [`DeleteAutoScalingGroupInput`](crate::input::DeleteAutoScalingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>Specifies that the group is to be deleted along with all instances associated with the group, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the group.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>Specifies that the group is to be deleted along with all instances associated with the group, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the group.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAutoScalingGroupInput`](crate::input::DeleteAutoScalingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAutoScalingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAutoScalingGroupInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                force_delete: self.force_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAutoScalingGroupInputOperationOutputAlias = crate::operation::DeleteAutoScalingGroup;
#[doc(hidden)]
pub type DeleteAutoScalingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAutoScalingGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAutoScalingGroup`](crate::operation::DeleteAutoScalingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAutoScalingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAutoScalingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAutoScalingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_auto_scaling_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAutoScalingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAutoScalingGroup",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAutoScalingGroupInput`](crate::input::DeleteAutoScalingGroupInput)
    pub fn builder() -> crate::input::delete_auto_scaling_group_input::Builder {
        crate::input::delete_auto_scaling_group_input::Builder::default()
    }
}

/// See [`DeleteLaunchConfigurationInput`](crate::input::DeleteLaunchConfigurationInput)
pub mod delete_launch_configuration_input {
    /// A builder for [`DeleteLaunchConfigurationInput`](crate::input::DeleteLaunchConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the launch configuration.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLaunchConfigurationInput`](crate::input::DeleteLaunchConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLaunchConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLaunchConfigurationInput {
                launch_configuration_name: self.launch_configuration_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLaunchConfigurationInputOperationOutputAlias =
    crate::operation::DeleteLaunchConfiguration;
#[doc(hidden)]
pub type DeleteLaunchConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLaunchConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLaunchConfiguration`](crate::operation::DeleteLaunchConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLaunchConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLaunchConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLaunchConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_launch_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLaunchConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLaunchConfiguration",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLaunchConfigurationInput`](crate::input::DeleteLaunchConfigurationInput)
    pub fn builder() -> crate::input::delete_launch_configuration_input::Builder {
        crate::input::delete_launch_configuration_input::Builder::default()
    }
}

/// See [`DeleteLifecycleHookInput`](crate::input::DeleteLifecycleHookInput)
pub mod delete_lifecycle_hook_input {
    /// A builder for [`DeleteLifecycleHookInput`](crate::input::DeleteLifecycleHookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_hook_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lifecycle hook.</p>
        pub fn lifecycle_hook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_hook_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle hook.</p>
        pub fn set_lifecycle_hook_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_hook_name = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLifecycleHookInput`](crate::input::DeleteLifecycleHookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLifecycleHookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLifecycleHookInput {
                lifecycle_hook_name: self.lifecycle_hook_name,
                auto_scaling_group_name: self.auto_scaling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLifecycleHookInputOperationOutputAlias = crate::operation::DeleteLifecycleHook;
#[doc(hidden)]
pub type DeleteLifecycleHookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLifecycleHookInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLifecycleHook`](crate::operation::DeleteLifecycleHook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLifecycleHook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLifecycleHookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLifecycleHookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_lifecycle_hook(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLifecycleHook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLifecycleHook",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLifecycleHookInput`](crate::input::DeleteLifecycleHookInput)
    pub fn builder() -> crate::input::delete_lifecycle_hook_input::Builder {
        crate::input::delete_lifecycle_hook_input::Builder::default()
    }
}

/// See [`DeleteNotificationConfigurationInput`](crate::input::DeleteNotificationConfigurationInput)
pub mod delete_notification_configuration_input {
    /// A builder for [`DeleteNotificationConfigurationInput`](crate::input::DeleteNotificationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNotificationConfigurationInput`](crate::input::DeleteNotificationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNotificationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNotificationConfigurationInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                topic_arn: self.topic_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNotificationConfigurationInputOperationOutputAlias =
    crate::operation::DeleteNotificationConfiguration;
#[doc(hidden)]
pub type DeleteNotificationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteNotificationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNotificationConfiguration`](crate::operation::DeleteNotificationConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNotificationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteNotificationConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteNotificationConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_notification_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNotificationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNotificationConfiguration",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteNotificationConfigurationInput`](crate::input::DeleteNotificationConfigurationInput)
    pub fn builder() -> crate::input::delete_notification_configuration_input::Builder {
        crate::input::delete_notification_configuration_input::Builder::default()
    }
}

/// See [`DeletePolicyInput`](crate::input::DeletePolicyInput)
pub mod delete_policy_input {
    /// A builder for [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name or Amazon Resource Name (ARN) of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePolicyInput`](crate::input::DeletePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePolicyInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                policy_name: self.policy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePolicyInputOperationOutputAlias = crate::operation::DeletePolicy;
#[doc(hidden)]
pub type DeletePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeletePolicy`](crate::operation::DeletePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePolicy",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
}

/// See [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
pub mod delete_scheduled_action_input {
    /// A builder for [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of the action to delete.</p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the action to delete.</p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteScheduledActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteScheduledActionInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scheduled_action_name: self.scheduled_action_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteScheduledActionInputOperationOutputAlias = crate::operation::DeleteScheduledAction;
#[doc(hidden)]
pub type DeleteScheduledActionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteScheduledActionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteScheduledAction`](crate::operation::DeleteScheduledAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteScheduledAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteScheduledActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteScheduledActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_scheduled_action(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteScheduledAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteScheduledAction",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteScheduledActionInput`](crate::input::DeleteScheduledActionInput)
    pub fn builder() -> crate::input::delete_scheduled_action_input::Builder {
        crate::input::delete_scheduled_action_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput { tags: self.tags })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DeleteWarmPoolInput`](crate::input::DeleteWarmPoolInput)
pub mod delete_warm_pool_input {
    /// A builder for [`DeleteWarmPoolInput`](crate::input::DeleteWarmPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>Specifies that the warm pool is to be deleted along with all of its associated instances, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the warm pool instances.</p>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>Specifies that the warm pool is to be deleted along with all of its associated instances, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the warm pool instances.</p>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWarmPoolInput`](crate::input::DeleteWarmPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWarmPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWarmPoolInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                force_delete: self.force_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWarmPoolInputOperationOutputAlias = crate::operation::DeleteWarmPool;
#[doc(hidden)]
pub type DeleteWarmPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWarmPoolInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWarmPool`](crate::operation::DeleteWarmPool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWarmPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteWarmPoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteWarmPoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_warm_pool(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWarmPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWarmPool",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteWarmPoolInput`](crate::input::DeleteWarmPoolInput)
    pub fn builder() -> crate::input::delete_warm_pool_input::Builder {
        crate::input::delete_warm_pool_input::Builder::default()
    }
}

/// See [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
pub mod describe_account_limits_input {
    /// A builder for [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountLimitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountLimitsInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationOutputAlias = crate::operation::DescribeAccountLimits;
#[doc(hidden)]
pub type DescribeAccountLimitsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountLimitsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountLimits`](crate::operation::DescribeAccountLimits)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountLimits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountLimitsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountLimitsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_limits(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountLimits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountLimits",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountLimitsInput`](crate::input::DescribeAccountLimitsInput)
    pub fn builder() -> crate::input::describe_account_limits_input::Builder {
        crate::input::describe_account_limits_input::Builder::default()
    }
}

/// See [`DescribeAdjustmentTypesInput`](crate::input::DescribeAdjustmentTypesInput)
pub mod describe_adjustment_types_input {
    /// A builder for [`DescribeAdjustmentTypesInput`](crate::input::DescribeAdjustmentTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAdjustmentTypesInput`](crate::input::DescribeAdjustmentTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAdjustmentTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAdjustmentTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAdjustmentTypesInputOperationOutputAlias =
    crate::operation::DescribeAdjustmentTypes;
#[doc(hidden)]
pub type DescribeAdjustmentTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAdjustmentTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAdjustmentTypes`](crate::operation::DescribeAdjustmentTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAdjustmentTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAdjustmentTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAdjustmentTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_adjustment_types(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAdjustmentTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAdjustmentTypes",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAdjustmentTypesInput`](crate::input::DescribeAdjustmentTypesInput)
    pub fn builder() -> crate::input::describe_adjustment_types_input::Builder {
        crate::input::describe_adjustment_types_input::Builder::default()
    }
}

/// See [`DescribeAutoScalingGroupsInput`](crate::input::DescribeAutoScalingGroupsInput)
pub mod describe_auto_scaling_groups_input {
    /// A builder for [`DescribeAutoScalingGroupsInput`](crate::input::DescribeAutoScalingGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// Appends an item to `auto_scaling_group_names`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_group_names`](Self::set_auto_scaling_group_names).
        ///
        /// <p>The names of the Auto Scaling groups. By default, you can only specify up to 50 names. You can optionally increase this limit using the <code>MaxRecords</code> parameter.</p>
        /// <p>If you omit this parameter, all Auto Scaling groups are described.</p>
        pub fn auto_scaling_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_scaling_group_names.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_group_names = Some(v);
            self
        }
        /// <p>The names of the Auto Scaling groups. By default, you can only specify up to 50 names. You can optionally increase this limit using the <code>MaxRecords</code> parameter.</p>
        /// <p>If you omit this parameter, all Auto Scaling groups are described.</p>
        pub fn set_auto_scaling_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_scaling_group_names = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to limit the results based on specific tags. </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters to limit the results based on specific tags. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutoScalingGroupsInput`](crate::input::DescribeAutoScalingGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAutoScalingGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAutoScalingGroupsInput {
                auto_scaling_group_names: self.auto_scaling_group_names,
                next_token: self.next_token,
                max_records: self.max_records,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAutoScalingGroupsInputOperationOutputAlias =
    crate::operation::DescribeAutoScalingGroups;
#[doc(hidden)]
pub type DescribeAutoScalingGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAutoScalingGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAutoScalingGroups`](crate::operation::DescribeAutoScalingGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAutoScalingGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAutoScalingGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAutoScalingGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_auto_scaling_groups(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAutoScalingGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAutoScalingGroups",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingGroupsInput`](crate::input::DescribeAutoScalingGroupsInput)
    pub fn builder() -> crate::input::describe_auto_scaling_groups_input::Builder {
        crate::input::describe_auto_scaling_groups_input::Builder::default()
    }
}

/// See [`DescribeAutoScalingInstancesInput`](crate::input::DescribeAutoScalingInstancesInput)
pub mod describe_auto_scaling_instances_input {
    /// A builder for [`DescribeAutoScalingInstancesInput`](crate::input::DescribeAutoScalingInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The IDs of the instances. If you omit this parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.</p>
        /// <p>Array Members: Maximum number of 50 items.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The IDs of the instances. If you omit this parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.</p>
        /// <p>Array Members: Maximum number of 50 items.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>50</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>50</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutoScalingInstancesInput`](crate::input::DescribeAutoScalingInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAutoScalingInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAutoScalingInstancesInput {
                instance_ids: self.instance_ids,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAutoScalingInstancesInputOperationOutputAlias =
    crate::operation::DescribeAutoScalingInstances;
#[doc(hidden)]
pub type DescribeAutoScalingInstancesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAutoScalingInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAutoScalingInstances`](crate::operation::DescribeAutoScalingInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAutoScalingInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAutoScalingInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAutoScalingInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_auto_scaling_instances(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAutoScalingInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAutoScalingInstances",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingInstancesInput`](crate::input::DescribeAutoScalingInstancesInput)
    pub fn builder() -> crate::input::describe_auto_scaling_instances_input::Builder {
        crate::input::describe_auto_scaling_instances_input::Builder::default()
    }
}

/// See [`DescribeAutoScalingNotificationTypesInput`](crate::input::DescribeAutoScalingNotificationTypesInput)
pub mod describe_auto_scaling_notification_types_input {
    /// A builder for [`DescribeAutoScalingNotificationTypesInput`](crate::input::DescribeAutoScalingNotificationTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAutoScalingNotificationTypesInput`](crate::input::DescribeAutoScalingNotificationTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAutoScalingNotificationTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAutoScalingNotificationTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAutoScalingNotificationTypesInputOperationOutputAlias =
    crate::operation::DescribeAutoScalingNotificationTypes;
#[doc(hidden)]
pub type DescribeAutoScalingNotificationTypesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAutoScalingNotificationTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAutoScalingNotificationTypes`](crate::operation::DescribeAutoScalingNotificationTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAutoScalingNotificationTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAutoScalingNotificationTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAutoScalingNotificationTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_auto_scaling_notification_types(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAutoScalingNotificationTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAutoScalingNotificationTypes",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingNotificationTypesInput`](crate::input::DescribeAutoScalingNotificationTypesInput)
    pub fn builder() -> crate::input::describe_auto_scaling_notification_types_input::Builder {
        crate::input::describe_auto_scaling_notification_types_input::Builder::default()
    }
}

/// See [`DescribeInstanceRefreshesInput`](crate::input::DescribeInstanceRefreshesInput)
pub mod describe_instance_refreshes_input {
    /// A builder for [`DescribeInstanceRefreshesInput`](crate::input::DescribeInstanceRefreshesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) instance_refresh_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `instance_refresh_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_refresh_ids`](Self::set_instance_refresh_ids).
        ///
        /// <p>One or more instance refresh IDs.</p>
        pub fn instance_refresh_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_refresh_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_refresh_ids = Some(v);
            self
        }
        /// <p>One or more instance refresh IDs.</p>
        pub fn set_instance_refresh_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_refresh_ids = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceRefreshesInput`](crate::input::DescribeInstanceRefreshesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceRefreshesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceRefreshesInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                instance_refresh_ids: self.instance_refresh_ids,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceRefreshesInputOperationOutputAlias =
    crate::operation::DescribeInstanceRefreshes;
#[doc(hidden)]
pub type DescribeInstanceRefreshesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstanceRefreshesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceRefreshes`](crate::operation::DescribeInstanceRefreshes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceRefreshes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeInstanceRefreshesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeInstanceRefreshesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_instance_refreshes(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceRefreshes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceRefreshes",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceRefreshesInput`](crate::input::DescribeInstanceRefreshesInput)
    pub fn builder() -> crate::input::describe_instance_refreshes_input::Builder {
        crate::input::describe_instance_refreshes_input::Builder::default()
    }
}

/// See [`DescribeLaunchConfigurationsInput`](crate::input::DescribeLaunchConfigurationsInput)
pub mod describe_launch_configurations_input {
    /// A builder for [`DescribeLaunchConfigurationsInput`](crate::input::DescribeLaunchConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_configuration_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `launch_configuration_names`.
        ///
        /// To override the contents of this collection use [`set_launch_configuration_names`](Self::set_launch_configuration_names).
        ///
        /// <p>The launch configuration names. If you omit this parameter, all launch configurations are described.</p>
        /// <p>Array Members: Maximum number of 50 items.</p>
        pub fn launch_configuration_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.launch_configuration_names.unwrap_or_default();
            v.push(input.into());
            self.launch_configuration_names = Some(v);
            self
        }
        /// <p>The launch configuration names. If you omit this parameter, all launch configurations are described.</p>
        /// <p>Array Members: Maximum number of 50 items.</p>
        pub fn set_launch_configuration_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.launch_configuration_names = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLaunchConfigurationsInput`](crate::input::DescribeLaunchConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLaunchConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLaunchConfigurationsInput {
                launch_configuration_names: self.launch_configuration_names,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLaunchConfigurationsInputOperationOutputAlias =
    crate::operation::DescribeLaunchConfigurations;
#[doc(hidden)]
pub type DescribeLaunchConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeLaunchConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLaunchConfigurations`](crate::operation::DescribeLaunchConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLaunchConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeLaunchConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeLaunchConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_launch_configurations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLaunchConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLaunchConfigurations",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeLaunchConfigurationsInput`](crate::input::DescribeLaunchConfigurationsInput)
    pub fn builder() -> crate::input::describe_launch_configurations_input::Builder {
        crate::input::describe_launch_configurations_input::Builder::default()
    }
}

/// See [`DescribeLifecycleHooksInput`](crate::input::DescribeLifecycleHooksInput)
pub mod describe_lifecycle_hooks_input {
    /// A builder for [`DescribeLifecycleHooksInput`](crate::input::DescribeLifecycleHooksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_hook_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `lifecycle_hook_names`.
        ///
        /// To override the contents of this collection use [`set_lifecycle_hook_names`](Self::set_lifecycle_hook_names).
        ///
        /// <p>The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.</p>
        pub fn lifecycle_hook_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.lifecycle_hook_names.unwrap_or_default();
            v.push(input.into());
            self.lifecycle_hook_names = Some(v);
            self
        }
        /// <p>The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.</p>
        pub fn set_lifecycle_hook_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.lifecycle_hook_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLifecycleHooksInput`](crate::input::DescribeLifecycleHooksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLifecycleHooksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLifecycleHooksInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                lifecycle_hook_names: self.lifecycle_hook_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLifecycleHooksInputOperationOutputAlias = crate::operation::DescribeLifecycleHooks;
#[doc(hidden)]
pub type DescribeLifecycleHooksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeLifecycleHooksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLifecycleHooks`](crate::operation::DescribeLifecycleHooks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLifecycleHooks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeLifecycleHooksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeLifecycleHooksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_lifecycle_hooks(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLifecycleHooks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLifecycleHooks",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeLifecycleHooksInput`](crate::input::DescribeLifecycleHooksInput)
    pub fn builder() -> crate::input::describe_lifecycle_hooks_input::Builder {
        crate::input::describe_lifecycle_hooks_input::Builder::default()
    }
}

/// See [`DescribeLifecycleHookTypesInput`](crate::input::DescribeLifecycleHookTypesInput)
pub mod describe_lifecycle_hook_types_input {
    /// A builder for [`DescribeLifecycleHookTypesInput`](crate::input::DescribeLifecycleHookTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeLifecycleHookTypesInput`](crate::input::DescribeLifecycleHookTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLifecycleHookTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLifecycleHookTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeLifecycleHookTypesInputOperationOutputAlias =
    crate::operation::DescribeLifecycleHookTypes;
#[doc(hidden)]
pub type DescribeLifecycleHookTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeLifecycleHookTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLifecycleHookTypes`](crate::operation::DescribeLifecycleHookTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLifecycleHookTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeLifecycleHookTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeLifecycleHookTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_lifecycle_hook_types(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLifecycleHookTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLifecycleHookTypes",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeLifecycleHookTypesInput`](crate::input::DescribeLifecycleHookTypesInput)
    pub fn builder() -> crate::input::describe_lifecycle_hook_types_input::Builder {
        crate::input::describe_lifecycle_hook_types_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
pub mod describe_load_balancers_input {
    /// A builder for [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancersInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancersInputOperationOutputAlias = crate::operation::DescribeLoadBalancers;
#[doc(hidden)]
pub type DescribeLoadBalancersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeLoadBalancersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancers`](crate::operation::DescribeLoadBalancers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeLoadBalancersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeLoadBalancersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancers(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancers",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancersInput`](crate::input::DescribeLoadBalancersInput)
    pub fn builder() -> crate::input::describe_load_balancers_input::Builder {
        crate::input::describe_load_balancers_input::Builder::default()
    }
}

/// See [`DescribeLoadBalancerTargetGroupsInput`](crate::input::DescribeLoadBalancerTargetGroupsInput)
pub mod describe_load_balancer_target_groups_input {
    /// A builder for [`DescribeLoadBalancerTargetGroupsInput`](crate::input::DescribeLoadBalancerTargetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoadBalancerTargetGroupsInput`](crate::input::DescribeLoadBalancerTargetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeLoadBalancerTargetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeLoadBalancerTargetGroupsInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeLoadBalancerTargetGroupsInputOperationOutputAlias =
    crate::operation::DescribeLoadBalancerTargetGroups;
#[doc(hidden)]
pub type DescribeLoadBalancerTargetGroupsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeLoadBalancerTargetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeLoadBalancerTargetGroups`](crate::operation::DescribeLoadBalancerTargetGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeLoadBalancerTargetGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeLoadBalancerTargetGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeLoadBalancerTargetGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_load_balancer_target_groups(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeLoadBalancerTargetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeLoadBalancerTargetGroups",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeLoadBalancerTargetGroupsInput`](crate::input::DescribeLoadBalancerTargetGroupsInput)
    pub fn builder() -> crate::input::describe_load_balancer_target_groups_input::Builder {
        crate::input::describe_load_balancer_target_groups_input::Builder::default()
    }
}

/// See [`DescribeMetricCollectionTypesInput`](crate::input::DescribeMetricCollectionTypesInput)
pub mod describe_metric_collection_types_input {
    /// A builder for [`DescribeMetricCollectionTypesInput`](crate::input::DescribeMetricCollectionTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeMetricCollectionTypesInput`](crate::input::DescribeMetricCollectionTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMetricCollectionTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMetricCollectionTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeMetricCollectionTypesInputOperationOutputAlias =
    crate::operation::DescribeMetricCollectionTypes;
#[doc(hidden)]
pub type DescribeMetricCollectionTypesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMetricCollectionTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMetricCollectionTypes`](crate::operation::DescribeMetricCollectionTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMetricCollectionTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeMetricCollectionTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeMetricCollectionTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_metric_collection_types(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMetricCollectionTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMetricCollectionTypes",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeMetricCollectionTypesInput`](crate::input::DescribeMetricCollectionTypesInput)
    pub fn builder() -> crate::input::describe_metric_collection_types_input::Builder {
        crate::input::describe_metric_collection_types_input::Builder::default()
    }
}

/// See [`DescribeNotificationConfigurationsInput`](crate::input::DescribeNotificationConfigurationsInput)
pub mod describe_notification_configurations_input {
    /// A builder for [`DescribeNotificationConfigurationsInput`](crate::input::DescribeNotificationConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `auto_scaling_group_names`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_group_names`](Self::set_auto_scaling_group_names).
        ///
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.auto_scaling_group_names.unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_group_names = Some(v);
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.auto_scaling_group_names = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNotificationConfigurationsInput`](crate::input::DescribeNotificationConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeNotificationConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeNotificationConfigurationsInput {
                auto_scaling_group_names: self.auto_scaling_group_names,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeNotificationConfigurationsInputOperationOutputAlias =
    crate::operation::DescribeNotificationConfigurations;
#[doc(hidden)]
pub type DescribeNotificationConfigurationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeNotificationConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeNotificationConfigurations`](crate::operation::DescribeNotificationConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeNotificationConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeNotificationConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeNotificationConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_notification_configurations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeNotificationConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeNotificationConfigurations",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeNotificationConfigurationsInput`](crate::input::DescribeNotificationConfigurationsInput)
    pub fn builder() -> crate::input::describe_notification_configurations_input::Builder {
        crate::input::describe_notification_configurations_input::Builder::default()
    }
}

/// See [`DescribePoliciesInput`](crate::input::DescribePoliciesInput)
pub mod describe_policies_input {
    /// A builder for [`DescribePoliciesInput`](crate::input::DescribePoliciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) policy_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `policy_names`.
        ///
        /// To override the contents of this collection use [`set_policy_names`](Self::set_policy_names).
        ///
        /// <p>The names of one or more policies. If you omit this parameter, all policies are described. If a group name is provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no error.</p>
        /// <p>Array Members: Maximum number of 50 items.</p>
        pub fn policy_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_names.unwrap_or_default();
            v.push(input.into());
            self.policy_names = Some(v);
            self
        }
        /// <p>The names of one or more policies. If you omit this parameter, all policies are described. If a group name is provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no error.</p>
        /// <p>Array Members: Maximum number of 50 items.</p>
        pub fn set_policy_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_names = input;
            self
        }
        /// Appends an item to `policy_types`.
        ///
        /// To override the contents of this collection use [`set_policy_types`](Self::set_policy_types).
        ///
        /// <p>One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.</p>
        pub fn policy_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.policy_types.unwrap_or_default();
            v.push(input.into());
            self.policy_types = Some(v);
            self
        }
        /// <p>One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.</p>
        pub fn set_policy_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.policy_types = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to be returned with each call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to be returned with each call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePoliciesInput`](crate::input::DescribePoliciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePoliciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePoliciesInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                policy_names: self.policy_names,
                policy_types: self.policy_types,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePoliciesInputOperationOutputAlias = crate::operation::DescribePolicies;
#[doc(hidden)]
pub type DescribePoliciesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePoliciesInput {
    /// Consumes the builder and constructs an Operation<[`DescribePolicies`](crate::operation::DescribePolicies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePolicies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePoliciesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePoliciesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_policies(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePolicies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePolicies",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePoliciesInput`](crate::input::DescribePoliciesInput)
    pub fn builder() -> crate::input::describe_policies_input::Builder {
        crate::input::describe_policies_input::Builder::default()
    }
}

/// See [`DescribeScalingActivitiesInput`](crate::input::DescribeScalingActivitiesInput)
pub mod describe_scaling_activities_input {
    /// A builder for [`DescribeScalingActivitiesInput`](crate::input::DescribeScalingActivitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) include_deleted_groups: std::option::Option<bool>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `activity_ids`.
        ///
        /// To override the contents of this collection use [`set_activity_ids`](Self::set_activity_ids).
        ///
        /// <p>The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify an Auto Scaling group, the results are limited to that group.</p>
        /// <p>Array Members: Maximum number of 50 IDs.</p>
        pub fn activity_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.activity_ids.unwrap_or_default();
            v.push(input.into());
            self.activity_ids = Some(v);
            self
        }
        /// <p>The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify an Auto Scaling group, the results are limited to that group.</p>
        /// <p>Array Members: Maximum number of 50 IDs.</p>
        pub fn set_activity_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.activity_ids = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>Indicates whether to include scaling activity from deleted Auto Scaling groups.</p>
        pub fn include_deleted_groups(mut self, input: bool) -> Self {
            self.include_deleted_groups = Some(input);
            self
        }
        /// <p>Indicates whether to include scaling activity from deleted Auto Scaling groups.</p>
        pub fn set_include_deleted_groups(mut self, input: std::option::Option<bool>) -> Self {
            self.include_deleted_groups = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScalingActivitiesInput`](crate::input::DescribeScalingActivitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScalingActivitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScalingActivitiesInput {
                activity_ids: self.activity_ids,
                auto_scaling_group_name: self.auto_scaling_group_name,
                include_deleted_groups: self.include_deleted_groups,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScalingActivitiesInputOperationOutputAlias =
    crate::operation::DescribeScalingActivities;
#[doc(hidden)]
pub type DescribeScalingActivitiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeScalingActivitiesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScalingActivities`](crate::operation::DescribeScalingActivities)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScalingActivities,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeScalingActivitiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeScalingActivitiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_scaling_activities(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScalingActivities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScalingActivities",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeScalingActivitiesInput`](crate::input::DescribeScalingActivitiesInput)
    pub fn builder() -> crate::input::describe_scaling_activities_input::Builder {
        crate::input::describe_scaling_activities_input::Builder::default()
    }
}

/// See [`DescribeScalingProcessTypesInput`](crate::input::DescribeScalingProcessTypesInput)
pub mod describe_scaling_process_types_input {
    /// A builder for [`DescribeScalingProcessTypesInput`](crate::input::DescribeScalingProcessTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeScalingProcessTypesInput`](crate::input::DescribeScalingProcessTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScalingProcessTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScalingProcessTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeScalingProcessTypesInputOperationOutputAlias =
    crate::operation::DescribeScalingProcessTypes;
#[doc(hidden)]
pub type DescribeScalingProcessTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeScalingProcessTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScalingProcessTypes`](crate::operation::DescribeScalingProcessTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScalingProcessTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeScalingProcessTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeScalingProcessTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_scaling_process_types(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScalingProcessTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScalingProcessTypes",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeScalingProcessTypesInput`](crate::input::DescribeScalingProcessTypesInput)
    pub fn builder() -> crate::input::describe_scaling_process_types_input::Builder {
        crate::input::describe_scaling_process_types_input::Builder::default()
    }
}

/// See [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
pub mod describe_scheduled_actions_input {
    /// A builder for [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `scheduled_action_names`.
        ///
        /// To override the contents of this collection use [`set_scheduled_action_names`](Self::set_scheduled_action_names).
        ///
        /// <p>The names of one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you specify an unknown scheduled action, it is ignored with no error.</p>
        /// <p>Array Members: Maximum number of 50 actions.</p>
        pub fn scheduled_action_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.scheduled_action_names.unwrap_or_default();
            v.push(input.into());
            self.scheduled_action_names = Some(v);
            self
        }
        /// <p>The names of one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you specify an unknown scheduled action, it is ignored with no error.</p>
        /// <p>Array Members: Maximum number of 50 actions.</p>
        pub fn set_scheduled_action_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.scheduled_action_names = input;
            self
        }
        /// <p>The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeScheduledActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeScheduledActionsInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scheduled_action_names: self.scheduled_action_names,
                start_time: self.start_time,
                end_time: self.end_time,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeScheduledActionsInputOperationOutputAlias =
    crate::operation::DescribeScheduledActions;
#[doc(hidden)]
pub type DescribeScheduledActionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeScheduledActionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeScheduledActions`](crate::operation::DescribeScheduledActions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeScheduledActions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeScheduledActionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeScheduledActionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_scheduled_actions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeScheduledActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeScheduledActions",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeScheduledActionsInput`](crate::input::DescribeScheduledActionsInput)
    pub fn builder() -> crate::input::describe_scheduled_actions_input::Builder {
        crate::input::describe_scheduled_actions_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>One or more filters to scope the tags to return. The maximum number of filters per filter type (for example, <code>auto-scaling-group</code>) is 1000.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>One or more filters to scope the tags to return. The maximum number of filters per filter type (for example, <code>auto-scaling-group</code>) is 1000.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                filters: self.filters,
                next_token: self.next_token,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeTagsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeTagsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_tags(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`DescribeTerminationPolicyTypesInput`](crate::input::DescribeTerminationPolicyTypesInput)
pub mod describe_termination_policy_types_input {
    /// A builder for [`DescribeTerminationPolicyTypesInput`](crate::input::DescribeTerminationPolicyTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeTerminationPolicyTypesInput`](crate::input::DescribeTerminationPolicyTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTerminationPolicyTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTerminationPolicyTypesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeTerminationPolicyTypesInputOperationOutputAlias =
    crate::operation::DescribeTerminationPolicyTypes;
#[doc(hidden)]
pub type DescribeTerminationPolicyTypesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTerminationPolicyTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTerminationPolicyTypes`](crate::operation::DescribeTerminationPolicyTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTerminationPolicyTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeTerminationPolicyTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeTerminationPolicyTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_termination_policy_types(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTerminationPolicyTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTerminationPolicyTypes",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeTerminationPolicyTypesInput`](crate::input::DescribeTerminationPolicyTypesInput)
    pub fn builder() -> crate::input::describe_termination_policy_types_input::Builder {
        crate::input::describe_termination_policy_types_input::Builder::default()
    }
}

/// See [`DescribeWarmPoolInput`](crate::input::DescribeWarmPoolInput)
pub mod describe_warm_pool_input {
    /// A builder for [`DescribeWarmPoolInput`](crate::input::DescribeWarmPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The maximum number of instances to return with this call. The maximum value is <code>50</code>.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of instances to return with this call. The maximum value is <code>50</code>.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>The token for the next set of instances to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of instances to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeWarmPoolInput`](crate::input::DescribeWarmPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeWarmPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeWarmPoolInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                max_records: self.max_records,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeWarmPoolInputOperationOutputAlias = crate::operation::DescribeWarmPool;
#[doc(hidden)]
pub type DescribeWarmPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeWarmPoolInput {
    /// Consumes the builder and constructs an Operation<[`DescribeWarmPool`](crate::operation::DescribeWarmPool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeWarmPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeWarmPoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeWarmPoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_warm_pool(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeWarmPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeWarmPool",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeWarmPoolInput`](crate::input::DescribeWarmPoolInput)
    pub fn builder() -> crate::input::describe_warm_pool_input::Builder {
        crate::input::describe_warm_pool_input::Builder::default()
    }
}

/// See [`DetachInstancesInput`](crate::input::DetachInstancesInput)
pub mod detach_instances_input {
    /// A builder for [`DetachInstancesInput`](crate::input::DetachInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) should_decrement_desired_capacity: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances detached.</p>
        pub fn should_decrement_desired_capacity(mut self, input: bool) -> Self {
            self.should_decrement_desired_capacity = Some(input);
            self
        }
        /// <p>Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances detached.</p>
        pub fn set_should_decrement_desired_capacity(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.should_decrement_desired_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachInstancesInput`](crate::input::DetachInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachInstancesInput {
                instance_ids: self.instance_ids,
                auto_scaling_group_name: self.auto_scaling_group_name,
                should_decrement_desired_capacity: self.should_decrement_desired_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachInstancesInputOperationOutputAlias = crate::operation::DetachInstances;
#[doc(hidden)]
pub type DetachInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DetachInstances`](crate::operation::DetachInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_instances(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachInstances",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachInstancesInput`](crate::input::DetachInstancesInput)
    pub fn builder() -> crate::input::detach_instances_input::Builder {
        crate::input::detach_instances_input::Builder::default()
    }
}

/// See [`DetachLoadBalancersInput`](crate::input::DetachLoadBalancersInput)
pub mod detach_load_balancers_input {
    /// A builder for [`DetachLoadBalancersInput`](crate::input::DetachLoadBalancersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachLoadBalancersInput`](crate::input::DetachLoadBalancersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachLoadBalancersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachLoadBalancersInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                load_balancer_names: self.load_balancer_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachLoadBalancersInputOperationOutputAlias = crate::operation::DetachLoadBalancers;
#[doc(hidden)]
pub type DetachLoadBalancersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachLoadBalancersInput {
    /// Consumes the builder and constructs an Operation<[`DetachLoadBalancers`](crate::operation::DetachLoadBalancers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachLoadBalancers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachLoadBalancersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachLoadBalancersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_load_balancers(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachLoadBalancers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachLoadBalancers",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachLoadBalancersInput`](crate::input::DetachLoadBalancersInput)
    pub fn builder() -> crate::input::detach_load_balancers_input::Builder {
        crate::input::detach_load_balancers_input::Builder::default()
    }
}

/// See [`DetachLoadBalancerTargetGroupsInput`](crate::input::DetachLoadBalancerTargetGroupsInput)
pub mod detach_load_balancer_target_groups_input {
    /// A builder for [`DetachLoadBalancerTargetGroupsInput`](crate::input::DetachLoadBalancerTargetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `target_group_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_target_group_ar_ns`](Self::set_target_group_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups.</p>
        pub fn target_group_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_group_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.target_group_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups.</p>
        pub fn set_target_group_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_group_ar_ns = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachLoadBalancerTargetGroupsInput`](crate::input::DetachLoadBalancerTargetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachLoadBalancerTargetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachLoadBalancerTargetGroupsInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                target_group_ar_ns: self.target_group_ar_ns,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachLoadBalancerTargetGroupsInputOperationOutputAlias =
    crate::operation::DetachLoadBalancerTargetGroups;
#[doc(hidden)]
pub type DetachLoadBalancerTargetGroupsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DetachLoadBalancerTargetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DetachLoadBalancerTargetGroups`](crate::operation::DetachLoadBalancerTargetGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachLoadBalancerTargetGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachLoadBalancerTargetGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachLoadBalancerTargetGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_load_balancer_target_groups(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachLoadBalancerTargetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachLoadBalancerTargetGroups",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachLoadBalancerTargetGroupsInput`](crate::input::DetachLoadBalancerTargetGroupsInput)
    pub fn builder() -> crate::input::detach_load_balancer_target_groups_input::Builder {
        crate::input::detach_load_balancer_target_groups_input::Builder::default()
    }
}

/// See [`DisableMetricsCollectionInput`](crate::input::DisableMetricsCollectionInput)
pub mod disable_metrics_collection_input {
    /// A builder for [`DisableMetricsCollectionInput`](crate::input::DisableMetricsCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) metrics: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>Specifies one or more of the following metrics:</p>
        /// <ul>
        /// <li> <p> <code>GroupMinSize</code> </p> </li>
        /// <li> <p> <code>GroupMaxSize</code> </p> </li>
        /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
        /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
        /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
        /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
        /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
        /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all metrics are disabled. </p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>Specifies one or more of the following metrics:</p>
        /// <ul>
        /// <li> <p> <code>GroupMinSize</code> </p> </li>
        /// <li> <p> <code>GroupMaxSize</code> </p> </li>
        /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
        /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
        /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
        /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
        /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
        /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all metrics are disabled. </p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableMetricsCollectionInput`](crate::input::DisableMetricsCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableMetricsCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableMetricsCollectionInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                metrics: self.metrics,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableMetricsCollectionInputOperationOutputAlias =
    crate::operation::DisableMetricsCollection;
#[doc(hidden)]
pub type DisableMetricsCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableMetricsCollectionInput {
    /// Consumes the builder and constructs an Operation<[`DisableMetricsCollection`](crate::operation::DisableMetricsCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableMetricsCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisableMetricsCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisableMetricsCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disable_metrics_collection(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableMetricsCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableMetricsCollection",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisableMetricsCollectionInput`](crate::input::DisableMetricsCollectionInput)
    pub fn builder() -> crate::input::disable_metrics_collection_input::Builder {
        crate::input::disable_metrics_collection_input::Builder::default()
    }
}

/// See [`EnableMetricsCollectionInput`](crate::input::EnableMetricsCollectionInput)
pub mod enable_metrics_collection_input {
    /// A builder for [`EnableMetricsCollectionInput`](crate::input::EnableMetricsCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) metrics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) granularity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>Specifies which group-level metrics to start collecting. You can specify one or more of the following metrics:</p>
        /// <ul>
        /// <li> <p> <code>GroupMinSize</code> </p> </li>
        /// <li> <p> <code>GroupMaxSize</code> </p> </li>
        /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
        /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
        /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
        /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
        /// </ul>
        /// <p>The instance weighting feature supports the following additional metrics: </p>
        /// <ul>
        /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
        /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
        /// </ul>
        /// <p>The warm pools feature supports the following additional metrics: </p>
        /// <ul>
        /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all metrics are enabled. </p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>Specifies which group-level metrics to start collecting. You can specify one or more of the following metrics:</p>
        /// <ul>
        /// <li> <p> <code>GroupMinSize</code> </p> </li>
        /// <li> <p> <code>GroupMaxSize</code> </p> </li>
        /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
        /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
        /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
        /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
        /// </ul>
        /// <p>The instance weighting feature supports the following additional metrics: </p>
        /// <ul>
        /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
        /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
        /// </ul>
        /// <p>The warm pools feature supports the following additional metrics: </p>
        /// <ul>
        /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
        /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
        /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all metrics are enabled. </p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.</p>
        pub fn granularity(mut self, input: impl Into<std::string::String>) -> Self {
            self.granularity = Some(input.into());
            self
        }
        /// <p>The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.</p>
        pub fn set_granularity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.granularity = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableMetricsCollectionInput`](crate::input::EnableMetricsCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableMetricsCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableMetricsCollectionInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                metrics: self.metrics,
                granularity: self.granularity,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableMetricsCollectionInputOperationOutputAlias =
    crate::operation::EnableMetricsCollection;
#[doc(hidden)]
pub type EnableMetricsCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableMetricsCollectionInput {
    /// Consumes the builder and constructs an Operation<[`EnableMetricsCollection`](crate::operation::EnableMetricsCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableMetricsCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::EnableMetricsCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EnableMetricsCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_enable_metrics_collection(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableMetricsCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableMetricsCollection",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EnableMetricsCollectionInput`](crate::input::EnableMetricsCollectionInput)
    pub fn builder() -> crate::input::enable_metrics_collection_input::Builder {
        crate::input::enable_metrics_collection_input::Builder::default()
    }
}

/// See [`EnterStandbyInput`](crate::input::EnterStandbyInput)
pub mod enter_standby_input {
    /// A builder for [`EnterStandbyInput`](crate::input::EnterStandbyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) should_decrement_desired_capacity: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>Indicates whether to decrement the desired capacity of the Auto Scaling group by the number of instances moved to <code>Standby</code> mode.</p>
        pub fn should_decrement_desired_capacity(mut self, input: bool) -> Self {
            self.should_decrement_desired_capacity = Some(input);
            self
        }
        /// <p>Indicates whether to decrement the desired capacity of the Auto Scaling group by the number of instances moved to <code>Standby</code> mode.</p>
        pub fn set_should_decrement_desired_capacity(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.should_decrement_desired_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`EnterStandbyInput`](crate::input::EnterStandbyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnterStandbyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnterStandbyInput {
                instance_ids: self.instance_ids,
                auto_scaling_group_name: self.auto_scaling_group_name,
                should_decrement_desired_capacity: self.should_decrement_desired_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type EnterStandbyInputOperationOutputAlias = crate::operation::EnterStandby;
#[doc(hidden)]
pub type EnterStandbyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnterStandbyInput {
    /// Consumes the builder and constructs an Operation<[`EnterStandby`](crate::operation::EnterStandby)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnterStandby,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::EnterStandbyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EnterStandbyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_enter_standby(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnterStandby::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnterStandby",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EnterStandbyInput`](crate::input::EnterStandbyInput)
    pub fn builder() -> crate::input::enter_standby_input::Builder {
        crate::input::enter_standby_input::Builder::default()
    }
}

/// See [`ExecutePolicyInput`](crate::input::ExecutePolicyInput)
pub mod execute_policy_input {
    /// A builder for [`ExecutePolicyInput`](crate::input::ExecutePolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) honor_cooldown: std::option::Option<bool>,
        pub(crate) metric_value: std::option::Option<f64>,
        pub(crate) breach_threshold: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name or ARN of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.</p>
        /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn honor_cooldown(mut self, input: bool) -> Self {
            self.honor_cooldown = Some(input);
            self
        }
        /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.</p>
        /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_honor_cooldown(mut self, input: std::option::Option<bool>) -> Self {
            self.honor_cooldown = input;
            self
        }
        /// <p>The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.</p>
        /// <p>If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an error.</p>
        /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
        pub fn metric_value(mut self, input: f64) -> Self {
            self.metric_value = Some(input);
            self
        }
        /// <p>The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.</p>
        /// <p>If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an error.</p>
        /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
        pub fn set_metric_value(mut self, input: std::option::Option<f64>) -> Self {
            self.metric_value = input;
            self
        }
        /// <p>The breach threshold for the alarm.</p>
        /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
        pub fn breach_threshold(mut self, input: f64) -> Self {
            self.breach_threshold = Some(input);
            self
        }
        /// <p>The breach threshold for the alarm.</p>
        /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
        pub fn set_breach_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.breach_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutePolicyInput`](crate::input::ExecutePolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecutePolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecutePolicyInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                policy_name: self.policy_name,
                honor_cooldown: self.honor_cooldown,
                metric_value: self.metric_value,
                breach_threshold: self.breach_threshold,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecutePolicyInputOperationOutputAlias = crate::operation::ExecutePolicy;
#[doc(hidden)]
pub type ExecutePolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExecutePolicyInput {
    /// Consumes the builder and constructs an Operation<[`ExecutePolicy`](crate::operation::ExecutePolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecutePolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExecutePolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExecutePolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_execute_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecutePolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecutePolicy",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExecutePolicyInput`](crate::input::ExecutePolicyInput)
    pub fn builder() -> crate::input::execute_policy_input::Builder {
        crate::input::execute_policy_input::Builder::default()
    }
}

/// See [`ExitStandbyInput`](crate::input::ExitStandbyInput)
pub mod exit_standby_input {
    /// A builder for [`ExitStandbyInput`](crate::input::ExitStandbyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ExitStandbyInput`](crate::input::ExitStandbyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExitStandbyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExitStandbyInput {
                instance_ids: self.instance_ids,
                auto_scaling_group_name: self.auto_scaling_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ExitStandbyInputOperationOutputAlias = crate::operation::ExitStandby;
#[doc(hidden)]
pub type ExitStandbyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExitStandbyInput {
    /// Consumes the builder and constructs an Operation<[`ExitStandby`](crate::operation::ExitStandby)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExitStandby,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExitStandbyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExitStandbyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_exit_standby(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExitStandby::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExitStandby",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExitStandbyInput`](crate::input::ExitStandbyInput)
    pub fn builder() -> crate::input::exit_standby_input::Builder {
        crate::input::exit_standby_input::Builder::default()
    }
}

/// See [`GetPredictiveScalingForecastInput`](crate::input::GetPredictiveScalingForecastInput)
pub mod get_predictive_scaling_forecast_input {
    /// A builder for [`GetPredictiveScalingForecastInput`](crate::input::GetPredictiveScalingForecastInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The inclusive start time of the time range for the forecast data to get. At most, the date and time can be one year before the current date and time.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The inclusive start time of the time range for the forecast data to get. At most, the date and time can be one year before the current date and time.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is 30 days. </p>
        /// <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. Amazon EC2 Auto Scaling only issues forecasts for periods of two days in advance.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is 30 days. </p>
        /// <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. Amazon EC2 Auto Scaling only issues forecasts for periods of two days in advance.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPredictiveScalingForecastInput`](crate::input::GetPredictiveScalingForecastInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPredictiveScalingForecastInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPredictiveScalingForecastInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                policy_name: self.policy_name,
                start_time: self.start_time,
                end_time: self.end_time,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPredictiveScalingForecastInputOperationOutputAlias =
    crate::operation::GetPredictiveScalingForecast;
#[doc(hidden)]
pub type GetPredictiveScalingForecastInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetPredictiveScalingForecastInput {
    /// Consumes the builder and constructs an Operation<[`GetPredictiveScalingForecast`](crate::operation::GetPredictiveScalingForecast)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPredictiveScalingForecast,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetPredictiveScalingForecastInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetPredictiveScalingForecastInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_predictive_scaling_forecast(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPredictiveScalingForecast::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPredictiveScalingForecast",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetPredictiveScalingForecastInput`](crate::input::GetPredictiveScalingForecastInput)
    pub fn builder() -> crate::input::get_predictive_scaling_forecast_input::Builder {
        crate::input::get_predictive_scaling_forecast_input::Builder::default()
    }
}

/// See [`PutLifecycleHookInput`](crate::input::PutLifecycleHookInput)
pub mod put_lifecycle_hook_input {
    /// A builder for [`PutLifecycleHookInput`](crate::input::PutLifecycleHookInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_hook_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_transition: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) notification_target_arn: std::option::Option<std::string::String>,
        pub(crate) notification_metadata: std::option::Option<std::string::String>,
        pub(crate) heartbeat_timeout: std::option::Option<i32>,
        pub(crate) default_result: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lifecycle hook.</p>
        pub fn lifecycle_hook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_hook_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle hook.</p>
        pub fn set_lifecycle_hook_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_hook_name = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The instance state to which you want to attach the lifecycle hook. The valid values are:</p>
        /// <ul>
        /// <li> <p>autoscaling:EC2_INSTANCE_LAUNCHING</p> </li>
        /// <li> <p>autoscaling:EC2_INSTANCE_TERMINATING</p> </li>
        /// </ul>
        /// <p>Required for new lifecycle hooks, but optional when updating existing hooks.</p>
        pub fn lifecycle_transition(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_transition = Some(input.into());
            self
        }
        /// <p>The instance state to which you want to attach the lifecycle hook. The valid values are:</p>
        /// <ul>
        /// <li> <p>autoscaling:EC2_INSTANCE_LAUNCHING</p> </li>
        /// <li> <p>autoscaling:EC2_INSTANCE_TERMINATING</p> </li>
        /// </ul>
        /// <p>Required for new lifecycle hooks, but optional when updating existing hooks.</p>
        pub fn set_lifecycle_transition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_transition = input;
            self
        }
        /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p>
        /// <p>Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p>
        /// <p>Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in the transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic.</p>
        /// <p>If you specify an empty string, this overrides the current ARN.</p>
        /// <p>This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic.</p>
        /// <p>When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.</p>
        pub fn notification_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in the transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic.</p>
        /// <p>If you specify an empty string, this overrides the current ARN.</p>
        /// <p>This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic.</p>
        /// <p>When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.</p>
        pub fn set_notification_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target_arn = input;
            self
        }
        /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.</p>
        pub fn notification_metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_metadata = Some(input.into());
            self
        }
        /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.</p>
        pub fn set_notification_metadata(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_metadata = input;
            self
        }
        /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).</p>
        /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing out by calling the <code>RecordLifecycleActionHeartbeat</code> API.</p>
        pub fn heartbeat_timeout(mut self, input: i32) -> Self {
            self.heartbeat_timeout = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).</p>
        /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing out by calling the <code>RecordLifecycleActionHeartbeat</code> API.</p>
        pub fn set_heartbeat_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.heartbeat_timeout = input;
            self
        }
        /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
        pub fn default_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_result = Some(input.into());
            self
        }
        /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
        pub fn set_default_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_result = input;
            self
        }
        /// Consumes the builder and constructs a [`PutLifecycleHookInput`](crate::input::PutLifecycleHookInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutLifecycleHookInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutLifecycleHookInput {
                lifecycle_hook_name: self.lifecycle_hook_name,
                auto_scaling_group_name: self.auto_scaling_group_name,
                lifecycle_transition: self.lifecycle_transition,
                role_arn: self.role_arn,
                notification_target_arn: self.notification_target_arn,
                notification_metadata: self.notification_metadata,
                heartbeat_timeout: self.heartbeat_timeout,
                default_result: self.default_result,
            })
        }
    }
}
#[doc(hidden)]
pub type PutLifecycleHookInputOperationOutputAlias = crate::operation::PutLifecycleHook;
#[doc(hidden)]
pub type PutLifecycleHookInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutLifecycleHookInput {
    /// Consumes the builder and constructs an Operation<[`PutLifecycleHook`](crate::operation::PutLifecycleHook)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutLifecycleHook,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutLifecycleHookInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutLifecycleHookInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_lifecycle_hook(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutLifecycleHook::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutLifecycleHook",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutLifecycleHookInput`](crate::input::PutLifecycleHookInput)
    pub fn builder() -> crate::input::put_lifecycle_hook_input::Builder {
        crate::input::put_lifecycle_hook_input::Builder::default()
    }
}

/// See [`PutNotificationConfigurationInput`](crate::input::PutNotificationConfigurationInput)
pub mod put_notification_configuration_input {
    /// A builder for [`PutNotificationConfigurationInput`](crate::input::PutNotificationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) notification_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// Appends an item to `notification_types`.
        ///
        /// To override the contents of this collection use [`set_notification_types`](Self::set_notification_types).
        ///
        /// <p>The type of event that causes the notification to be sent. To query the notification types supported by Amazon EC2 Auto Scaling, call the <code>DescribeAutoScalingNotificationTypes</code> API.</p>
        pub fn notification_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.notification_types.unwrap_or_default();
            v.push(input.into());
            self.notification_types = Some(v);
            self
        }
        /// <p>The type of event that causes the notification to be sent. To query the notification types supported by Amazon EC2 Auto Scaling, call the <code>DescribeAutoScalingNotificationTypes</code> API.</p>
        pub fn set_notification_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.notification_types = input;
            self
        }
        /// Consumes the builder and constructs a [`PutNotificationConfigurationInput`](crate::input::PutNotificationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutNotificationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutNotificationConfigurationInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                topic_arn: self.topic_arn,
                notification_types: self.notification_types,
            })
        }
    }
}
#[doc(hidden)]
pub type PutNotificationConfigurationInputOperationOutputAlias =
    crate::operation::PutNotificationConfiguration;
#[doc(hidden)]
pub type PutNotificationConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutNotificationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutNotificationConfiguration`](crate::operation::PutNotificationConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutNotificationConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutNotificationConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutNotificationConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_notification_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutNotificationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutNotificationConfiguration",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutNotificationConfigurationInput`](crate::input::PutNotificationConfigurationInput)
    pub fn builder() -> crate::input::put_notification_configuration_input::Builder {
        crate::input::put_notification_configuration_input::Builder::default()
    }
}

/// See [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
pub mod put_scaling_policy_input {
    /// A builder for [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<std::string::String>,
        pub(crate) adjustment_type: std::option::Option<std::string::String>,
        pub(crate) min_adjustment_step: std::option::Option<i32>,
        pub(crate) min_adjustment_magnitude: std::option::Option<i32>,
        pub(crate) scaling_adjustment: std::option::Option<i32>,
        pub(crate) cooldown: std::option::Option<i32>,
        pub(crate) metric_aggregation_type: std::option::Option<std::string::String>,
        pub(crate) step_adjustments:
            std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
        pub(crate) estimated_instance_warmup: std::option::Option<i32>,
        pub(crate) target_tracking_configuration:
            std::option::Option<crate::model::TargetTrackingConfiguration>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) predictive_scaling_configuration:
            std::option::Option<crate::model::PredictiveScalingConfiguration>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of the policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>One of the following policy types: </p>
        /// <ul>
        /// <li> <p> <code>TargetTrackingScaling</code> </p> </li>
        /// <li> <p> <code>StepScaling</code> </p> </li>
        /// <li> <p> <code>SimpleScaling</code> (default)</p> </li>
        /// <li> <p> <code>PredictiveScaling</code> </p> </li>
        /// </ul>
        pub fn policy_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_type = Some(input.into());
            self
        }
        /// <p>One of the following policy types: </p>
        /// <ul>
        /// <li> <p> <code>TargetTrackingScaling</code> </p> </li>
        /// <li> <p> <code>StepScaling</code> </p> </li>
        /// <li> <p> <code>SimpleScaling</code> (default)</p> </li>
        /// <li> <p> <code>PredictiveScaling</code> </p> </li>
        /// </ul>
        pub fn set_policy_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
        /// <p>Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn adjustment_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.adjustment_type = Some(input.into());
            self
        }
        /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
        /// <p>Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_adjustment_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.adjustment_type = input;
            self
        }
        /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>
        pub fn min_adjustment_step(mut self, input: i32) -> Self {
            self.min_adjustment_step = Some(input);
            self
        }
        /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>
        pub fn set_min_adjustment_step(mut self, input: std::option::Option<i32>) -> Self {
            self.min_adjustment_step = input;
            self
        }
        /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.</p>
        /// <p>Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
        /// <p>Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.</p>
        /// </note>
        pub fn min_adjustment_magnitude(mut self, input: i32) -> Self {
            self.min_adjustment_magnitude = Some(input);
            self
        }
        /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.</p>
        /// <p>Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
        /// <p>Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.</p>
        /// </note>
        pub fn set_min_adjustment_magnitude(mut self, input: std::option::Option<i32>) -> Self {
            self.min_adjustment_magnitude = input;
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
        /// <p>Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.) </p>
        pub fn scaling_adjustment(mut self, input: i32) -> Self {
            self.scaling_adjustment = Some(input);
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
        /// <p>Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.) </p>
        pub fn set_scaling_adjustment(mut self, input: std::option::Option<i32>) -> Self {
            self.scaling_adjustment = input;
            self
        }
        /// <p>A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is specified here, it overrides the default cooldown.</p>
        /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Default: None</p>
        pub fn cooldown(mut self, input: i32) -> Self {
            self.cooldown = Some(input);
            self
        }
        /// <p>A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is specified here, it overrides the default cooldown.</p>
        /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>Default: None</p>
        pub fn set_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.cooldown = input;
            self
        }
        /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
        /// <p>Valid only if the policy type is <code>StepScaling</code>.</p>
        pub fn metric_aggregation_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_aggregation_type = Some(input.into());
            self
        }
        /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
        /// <p>Valid only if the policy type is <code>StepScaling</code>.</p>
        pub fn set_metric_aggregation_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_aggregation_type = input;
            self
        }
        /// Appends an item to `step_adjustments`.
        ///
        /// To override the contents of this collection use [`set_step_adjustments`](Self::set_step_adjustments).
        ///
        /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
        /// <p>Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.) </p>
        pub fn step_adjustments(mut self, input: crate::model::StepAdjustment) -> Self {
            let mut v = self.step_adjustments.unwrap_or_default();
            v.push(input);
            self.step_adjustments = Some(v);
            self
        }
        /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
        /// <p>Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.) </p>
        pub fn set_step_adjustments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
        ) -> Self {
            self.step_adjustments = input;
            self
        }
        /// <p> <i>Not needed if the default instance warmup is defined for the group.</i> </p>
        /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This warm-up period applies to instances launched due to a specific target tracking or step scaling policy. When a warm-up period is specified here, it overrides the default instance warmup.</p>
        /// <p>Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.</p> <note>
        /// <p>The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default cooldown.</p>
        /// </note>
        pub fn estimated_instance_warmup(mut self, input: i32) -> Self {
            self.estimated_instance_warmup = Some(input);
            self
        }
        /// <p> <i>Not needed if the default instance warmup is defined for the group.</i> </p>
        /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This warm-up period applies to instances launched due to a specific target tracking or step scaling policy. When a warm-up period is specified here, it overrides the default instance warmup.</p>
        /// <p>Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.</p> <note>
        /// <p>The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default cooldown.</p>
        /// </note>
        pub fn set_estimated_instance_warmup(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_instance_warmup = input;
            self
        }
        /// <p>A target tracking scaling policy. Provides support for predefined or custom metrics.</p>
        /// <p>The following predefined metrics are available:</p>
        /// <ul>
        /// <li> <p> <code>ASGAverageCPUUtilization</code> </p> </li>
        /// <li> <p> <code>ASGAverageNetworkIn</code> </p> </li>
        /// <li> <p> <code>ASGAverageNetworkOut</code> </p> </li>
        /// <li> <p> <code>ALBRequestCountPerTarget</code> </p> </li>
        /// </ul>
        /// <p>If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> parameter with the <code>PredefinedMetricSpecification</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html">TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
        /// <p>Required if the policy type is <code>TargetTrackingScaling</code>.</p>
        pub fn target_tracking_configuration(
            mut self,
            input: crate::model::TargetTrackingConfiguration,
        ) -> Self {
            self.target_tracking_configuration = Some(input);
            self
        }
        /// <p>A target tracking scaling policy. Provides support for predefined or custom metrics.</p>
        /// <p>The following predefined metrics are available:</p>
        /// <ul>
        /// <li> <p> <code>ASGAverageCPUUtilization</code> </p> </li>
        /// <li> <p> <code>ASGAverageNetworkIn</code> </p> </li>
        /// <li> <p> <code>ASGAverageNetworkOut</code> </p> </li>
        /// <li> <p> <code>ALBRequestCountPerTarget</code> </p> </li>
        /// </ul>
        /// <p>If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> parameter with the <code>PredefinedMetricSpecification</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html">TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
        /// <p>Required if the policy type is <code>TargetTrackingScaling</code>.</p>
        pub fn set_target_tracking_configuration(
            mut self,
            input: std::option::Option<crate::model::TargetTrackingConfiguration>,
        ) -> Self {
            self.target_tracking_configuration = input;
            self
        }
        /// <p>Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html">Disabling a scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html">Disabling a scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>A predictive scaling policy. Provides support for predefined and custom metrics.</p>
        /// <p>Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html">PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
        /// <p>Required if the policy type is <code>PredictiveScaling</code>.</p>
        pub fn predictive_scaling_configuration(
            mut self,
            input: crate::model::PredictiveScalingConfiguration,
        ) -> Self {
            self.predictive_scaling_configuration = Some(input);
            self
        }
        /// <p>A predictive scaling policy. Provides support for predefined and custom metrics.</p>
        /// <p>Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html">PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
        /// <p>Required if the policy type is <code>PredictiveScaling</code>.</p>
        pub fn set_predictive_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingConfiguration>,
        ) -> Self {
            self.predictive_scaling_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutScalingPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutScalingPolicyInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                policy_name: self.policy_name,
                policy_type: self.policy_type,
                adjustment_type: self.adjustment_type,
                min_adjustment_step: self.min_adjustment_step,
                min_adjustment_magnitude: self.min_adjustment_magnitude,
                scaling_adjustment: self.scaling_adjustment,
                cooldown: self.cooldown,
                metric_aggregation_type: self.metric_aggregation_type,
                step_adjustments: self.step_adjustments,
                estimated_instance_warmup: self.estimated_instance_warmup,
                target_tracking_configuration: self.target_tracking_configuration,
                enabled: self.enabled,
                predictive_scaling_configuration: self.predictive_scaling_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutScalingPolicyInputOperationOutputAlias = crate::operation::PutScalingPolicy;
#[doc(hidden)]
pub type PutScalingPolicyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutScalingPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutScalingPolicy`](crate::operation::PutScalingPolicy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutScalingPolicy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutScalingPolicyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutScalingPolicyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_scaling_policy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutScalingPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutScalingPolicy",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutScalingPolicyInput`](crate::input::PutScalingPolicyInput)
    pub fn builder() -> crate::input::put_scaling_policy_input::Builder {
        crate::input::put_scaling_policy_input::Builder::default()
    }
}

/// See [`PutScheduledUpdateGroupActionInput`](crate::input::PutScheduledUpdateGroupActionInput)
pub mod put_scheduled_update_group_action_input {
    /// A builder for [`PutScheduledUpdateGroupActionInput`](crate::input::PutScheduledUpdateGroupActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) recurrence: std::option::Option<std::string::String>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) time_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of this scaling action.</p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of this scaling action.</p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.time = Some(input);
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.time = input;
            self
        }
        /// <p>The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
        /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.</p>
        /// <p>If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
        /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.</p>
        /// <p>If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time for the recurring schedule to end, in UTC.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time for the recurring schedule to end, in UTC.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The recurring schedule for this action. This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
        /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action starts and stops.</p>
        /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
        pub fn recurrence(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurrence = Some(input.into());
            self
        }
        /// <p>The recurring schedule for this action. This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
        /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action starts and stops.</p>
        /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
        pub fn set_recurrence(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recurrence = input;
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions. </p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions. </p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default. </p>
        /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone = Some(input.into());
            self
        }
        /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default. </p>
        /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`PutScheduledUpdateGroupActionInput`](crate::input::PutScheduledUpdateGroupActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutScheduledUpdateGroupActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutScheduledUpdateGroupActionInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scheduled_action_name: self.scheduled_action_name,
                time: self.time,
                start_time: self.start_time,
                end_time: self.end_time,
                recurrence: self.recurrence,
                min_size: self.min_size,
                max_size: self.max_size,
                desired_capacity: self.desired_capacity,
                time_zone: self.time_zone,
            })
        }
    }
}
#[doc(hidden)]
pub type PutScheduledUpdateGroupActionInputOperationOutputAlias =
    crate::operation::PutScheduledUpdateGroupAction;
#[doc(hidden)]
pub type PutScheduledUpdateGroupActionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PutScheduledUpdateGroupActionInput {
    /// Consumes the builder and constructs an Operation<[`PutScheduledUpdateGroupAction`](crate::operation::PutScheduledUpdateGroupAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutScheduledUpdateGroupAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutScheduledUpdateGroupActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutScheduledUpdateGroupActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_scheduled_update_group_action(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutScheduledUpdateGroupAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutScheduledUpdateGroupAction",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutScheduledUpdateGroupActionInput`](crate::input::PutScheduledUpdateGroupActionInput)
    pub fn builder() -> crate::input::put_scheduled_update_group_action_input::Builder {
        crate::input::put_scheduled_update_group_action_input::Builder::default()
    }
}

/// See [`PutWarmPoolInput`](crate::input::PutWarmPoolInput)
pub mod put_warm_pool_input {
    /// A builder for [`PutWarmPoolInput`](crate::input::PutWarmPoolInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) max_group_prepared_capacity: std::option::Option<i32>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) pool_state: std::option::Option<crate::model::WarmPoolState>,
        pub(crate) instance_reuse_policy: std::option::Option<crate::model::InstanceReusePolicy>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity. </p> <important>
        /// <p>If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead. </p>
        /// <p>The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.</p>
        /// </important>
        /// <p>If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code>, the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code>. To remove a value that you previously set, include the property but specify -1 for the value. </p>
        pub fn max_group_prepared_capacity(mut self, input: i32) -> Self {
            self.max_group_prepared_capacity = Some(input);
            self
        }
        /// <p>Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity. </p> <important>
        /// <p>If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead. </p>
        /// <p>The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.</p>
        /// </important>
        /// <p>If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code>, the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code>. To remove a value that you previously set, include the property but specify -1 for the value. </p>
        pub fn set_max_group_prepared_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_group_prepared_capacity = input;
            self
        }
        /// <p>Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>Sets the instance state to transition to after the lifecycle actions are complete. Default is <code>Stopped</code>.</p>
        pub fn pool_state(mut self, input: crate::model::WarmPoolState) -> Self {
            self.pool_state = Some(input);
            self
        }
        /// <p>Sets the instance state to transition to after the lifecycle actions are complete. Default is <code>Stopped</code>.</p>
        pub fn set_pool_state(
            mut self,
            input: std::option::Option<crate::model::WarmPoolState>,
        ) -> Self {
            self.pool_state = input;
            self
        }
        /// <p>Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.</p>
        pub fn instance_reuse_policy(mut self, input: crate::model::InstanceReusePolicy) -> Self {
            self.instance_reuse_policy = Some(input);
            self
        }
        /// <p>Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.</p>
        pub fn set_instance_reuse_policy(
            mut self,
            input: std::option::Option<crate::model::InstanceReusePolicy>,
        ) -> Self {
            self.instance_reuse_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutWarmPoolInput`](crate::input::PutWarmPoolInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutWarmPoolInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutWarmPoolInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                max_group_prepared_capacity: self.max_group_prepared_capacity,
                min_size: self.min_size,
                pool_state: self.pool_state,
                instance_reuse_policy: self.instance_reuse_policy,
            })
        }
    }
}
#[doc(hidden)]
pub type PutWarmPoolInputOperationOutputAlias = crate::operation::PutWarmPool;
#[doc(hidden)]
pub type PutWarmPoolInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutWarmPoolInput {
    /// Consumes the builder and constructs an Operation<[`PutWarmPool`](crate::operation::PutWarmPool)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutWarmPool,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutWarmPoolInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutWarmPoolInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_warm_pool(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutWarmPool::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutWarmPool",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutWarmPoolInput`](crate::input::PutWarmPoolInput)
    pub fn builder() -> crate::input::put_warm_pool_input::Builder {
        crate::input::put_warm_pool_input::Builder::default()
    }
}

/// See [`RecordLifecycleActionHeartbeatInput`](crate::input::RecordLifecycleActionHeartbeatInput)
pub mod record_lifecycle_action_heartbeat_input {
    /// A builder for [`RecordLifecycleActionHeartbeatInput`](crate::input::RecordLifecycleActionHeartbeatInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_hook_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_action_token: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lifecycle hook.</p>
        pub fn lifecycle_hook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_hook_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle hook.</p>
        pub fn set_lifecycle_hook_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_hook_name = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target that you specified when you created the lifecycle hook.</p>
        pub fn lifecycle_action_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_action_token = Some(input.into());
            self
        }
        /// <p>A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target that you specified when you created the lifecycle hook.</p>
        pub fn set_lifecycle_action_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_action_token = input;
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RecordLifecycleActionHeartbeatInput`](crate::input::RecordLifecycleActionHeartbeatInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RecordLifecycleActionHeartbeatInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RecordLifecycleActionHeartbeatInput {
                lifecycle_hook_name: self.lifecycle_hook_name,
                auto_scaling_group_name: self.auto_scaling_group_name,
                lifecycle_action_token: self.lifecycle_action_token,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RecordLifecycleActionHeartbeatInputOperationOutputAlias =
    crate::operation::RecordLifecycleActionHeartbeat;
#[doc(hidden)]
pub type RecordLifecycleActionHeartbeatInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl RecordLifecycleActionHeartbeatInput {
    /// Consumes the builder and constructs an Operation<[`RecordLifecycleActionHeartbeat`](crate::operation::RecordLifecycleActionHeartbeat)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RecordLifecycleActionHeartbeat,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RecordLifecycleActionHeartbeatInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RecordLifecycleActionHeartbeatInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_record_lifecycle_action_heartbeat(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RecordLifecycleActionHeartbeat::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RecordLifecycleActionHeartbeat",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RecordLifecycleActionHeartbeatInput`](crate::input::RecordLifecycleActionHeartbeatInput)
    pub fn builder() -> crate::input::record_lifecycle_action_heartbeat_input::Builder {
        crate::input::record_lifecycle_action_heartbeat_input::Builder::default()
    }
}

/// See [`ResumeProcessesInput`](crate::input::ResumeProcessesInput)
pub mod resume_processes_input {
    /// A builder for [`ResumeProcessesInput`](crate::input::ResumeProcessesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scaling_processes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `scaling_processes`.
        ///
        /// To override the contents of this collection use [`set_scaling_processes`](Self::set_scaling_processes).
        ///
        /// <p>One or more of the following processes:</p>
        /// <ul>
        /// <li> <p> <code>Launch</code> </p> </li>
        /// <li> <p> <code>Terminate</code> </p> </li>
        /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
        /// <li> <p> <code>AlarmNotification</code> </p> </li>
        /// <li> <p> <code>AZRebalance</code> </p> </li>
        /// <li> <p> <code>HealthCheck</code> </p> </li>
        /// <li> <p> <code>InstanceRefresh</code> </p> </li>
        /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
        /// <li> <p> <code>ScheduledActions</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all processes are specified.</p>
        pub fn scaling_processes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.scaling_processes.unwrap_or_default();
            v.push(input.into());
            self.scaling_processes = Some(v);
            self
        }
        /// <p>One or more of the following processes:</p>
        /// <ul>
        /// <li> <p> <code>Launch</code> </p> </li>
        /// <li> <p> <code>Terminate</code> </p> </li>
        /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
        /// <li> <p> <code>AlarmNotification</code> </p> </li>
        /// <li> <p> <code>AZRebalance</code> </p> </li>
        /// <li> <p> <code>HealthCheck</code> </p> </li>
        /// <li> <p> <code>InstanceRefresh</code> </p> </li>
        /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
        /// <li> <p> <code>ScheduledActions</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all processes are specified.</p>
        pub fn set_scaling_processes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.scaling_processes = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeProcessesInput`](crate::input::ResumeProcessesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResumeProcessesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResumeProcessesInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scaling_processes: self.scaling_processes,
            })
        }
    }
}
#[doc(hidden)]
pub type ResumeProcessesInputOperationOutputAlias = crate::operation::ResumeProcesses;
#[doc(hidden)]
pub type ResumeProcessesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResumeProcessesInput {
    /// Consumes the builder and constructs an Operation<[`ResumeProcesses`](crate::operation::ResumeProcesses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResumeProcesses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ResumeProcessesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ResumeProcessesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_resume_processes(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResumeProcesses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResumeProcesses",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ResumeProcessesInput`](crate::input::ResumeProcessesInput)
    pub fn builder() -> crate::input::resume_processes_input::Builder {
        crate::input::resume_processes_input::Builder::default()
    }
}

/// See [`SetDesiredCapacityInput`](crate::input::SetDesiredCapacityInput)
pub mod set_desired_capacity_input {
    /// A builder for [`SetDesiredCapacityInput`](crate::input::SetDesiredCapacityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) honor_cooldown: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain.</p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain.</p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the cooldown period during manual scaling activities.</p>
        pub fn honor_cooldown(mut self, input: bool) -> Self {
            self.honor_cooldown = Some(input);
            self
        }
        /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the cooldown period during manual scaling activities.</p>
        pub fn set_honor_cooldown(mut self, input: std::option::Option<bool>) -> Self {
            self.honor_cooldown = input;
            self
        }
        /// Consumes the builder and constructs a [`SetDesiredCapacityInput`](crate::input::SetDesiredCapacityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetDesiredCapacityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetDesiredCapacityInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                desired_capacity: self.desired_capacity,
                honor_cooldown: self.honor_cooldown,
            })
        }
    }
}
#[doc(hidden)]
pub type SetDesiredCapacityInputOperationOutputAlias = crate::operation::SetDesiredCapacity;
#[doc(hidden)]
pub type SetDesiredCapacityInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetDesiredCapacityInput {
    /// Consumes the builder and constructs an Operation<[`SetDesiredCapacity`](crate::operation::SetDesiredCapacity)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetDesiredCapacity,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SetDesiredCapacityInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SetDesiredCapacityInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_desired_capacity(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetDesiredCapacity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetDesiredCapacity",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SetDesiredCapacityInput`](crate::input::SetDesiredCapacityInput)
    pub fn builder() -> crate::input::set_desired_capacity_input::Builder {
        crate::input::set_desired_capacity_input::Builder::default()
    }
}

/// See [`SetInstanceHealthInput`](crate::input::SetInstanceHealthInput)
pub mod set_instance_health_input {
    /// A builder for [`SetInstanceHealthInput`](crate::input::SetInstanceHealthInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) health_status: std::option::Option<std::string::String>,
        pub(crate) should_respect_grace_period: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The health status of the instance. Set to <code>Healthy</code> to have the instance remain in service. Set to <code>Unhealthy</code> to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.</p>
        pub fn health_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_status = Some(input.into());
            self
        }
        /// <p>The health status of the instance. Set to <code>Healthy</code> to have the instance remain in service. Set to <code>Unhealthy</code> to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the group, by default, this call respects the grace period. Set this to <code>False</code>, to have the call not respect the grace period associated with the group.</p>
        /// <p>For more information about the health check grace period, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html">CreateAutoScalingGroup</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
        pub fn should_respect_grace_period(mut self, input: bool) -> Self {
            self.should_respect_grace_period = Some(input);
            self
        }
        /// <p>If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the group, by default, this call respects the grace period. Set this to <code>False</code>, to have the call not respect the grace period associated with the group.</p>
        /// <p>For more information about the health check grace period, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html">CreateAutoScalingGroup</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
        pub fn set_should_respect_grace_period(mut self, input: std::option::Option<bool>) -> Self {
            self.should_respect_grace_period = input;
            self
        }
        /// Consumes the builder and constructs a [`SetInstanceHealthInput`](crate::input::SetInstanceHealthInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetInstanceHealthInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetInstanceHealthInput {
                instance_id: self.instance_id,
                health_status: self.health_status,
                should_respect_grace_period: self.should_respect_grace_period,
            })
        }
    }
}
#[doc(hidden)]
pub type SetInstanceHealthInputOperationOutputAlias = crate::operation::SetInstanceHealth;
#[doc(hidden)]
pub type SetInstanceHealthInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetInstanceHealthInput {
    /// Consumes the builder and constructs an Operation<[`SetInstanceHealth`](crate::operation::SetInstanceHealth)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetInstanceHealth,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SetInstanceHealthInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SetInstanceHealthInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_instance_health(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetInstanceHealth::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetInstanceHealth",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SetInstanceHealthInput`](crate::input::SetInstanceHealthInput)
    pub fn builder() -> crate::input::set_instance_health_input::Builder {
        crate::input::set_instance_health_input::Builder::default()
    }
}

/// See [`SetInstanceProtectionInput`](crate::input::SetInstanceProtectionInput)
pub mod set_instance_protection_input {
    /// A builder for [`SetInstanceProtectionInput`](crate::input::SetInstanceProtectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) protected_from_scale_in: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `instance_ids`.
        ///
        /// To override the contents of this collection use [`set_instance_ids`](Self::set_instance_ids).
        ///
        /// <p>One or more instance IDs. You can specify up to 50 instances.</p>
        pub fn instance_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_ids.unwrap_or_default();
            v.push(input.into());
            self.instance_ids = Some(v);
            self
        }
        /// <p>One or more instance IDs. You can specify up to 50 instances.</p>
        pub fn set_instance_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_ids = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>
        pub fn protected_from_scale_in(mut self, input: bool) -> Self {
            self.protected_from_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>
        pub fn set_protected_from_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.protected_from_scale_in = input;
            self
        }
        /// Consumes the builder and constructs a [`SetInstanceProtectionInput`](crate::input::SetInstanceProtectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SetInstanceProtectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SetInstanceProtectionInput {
                instance_ids: self.instance_ids,
                auto_scaling_group_name: self.auto_scaling_group_name,
                protected_from_scale_in: self.protected_from_scale_in,
            })
        }
    }
}
#[doc(hidden)]
pub type SetInstanceProtectionInputOperationOutputAlias = crate::operation::SetInstanceProtection;
#[doc(hidden)]
pub type SetInstanceProtectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SetInstanceProtectionInput {
    /// Consumes the builder and constructs an Operation<[`SetInstanceProtection`](crate::operation::SetInstanceProtection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SetInstanceProtection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SetInstanceProtectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SetInstanceProtectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_set_instance_protection(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SetInstanceProtection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SetInstanceProtection",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SetInstanceProtectionInput`](crate::input::SetInstanceProtectionInput)
    pub fn builder() -> crate::input::set_instance_protection_input::Builder {
        crate::input::set_instance_protection_input::Builder::default()
    }
}

/// See [`StartInstanceRefreshInput`](crate::input::StartInstanceRefreshInput)
pub mod start_instance_refresh_input {
    /// A builder for [`StartInstanceRefreshInput`](crate::input::StartInstanceRefreshInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) strategy: std::option::Option<crate::model::RefreshStrategy>,
        pub(crate) desired_configuration: std::option::Option<crate::model::DesiredConfiguration>,
        pub(crate) preferences: std::option::Option<crate::model::RefreshPreferences>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
        /// <p>A rolling update helps you update your instances gradually. A rolling update can fail due to failed health checks or if instances are on standby or are protected from scale in. If the rolling update process fails, any instances that are replaced are not rolled back to their previous configuration. </p>
        pub fn strategy(mut self, input: crate::model::RefreshStrategy) -> Self {
            self.strategy = Some(input);
            self
        }
        /// <p>The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
        /// <p>A rolling update helps you update your instances gradually. A rolling update can fail due to failed health checks or if instances are on standby or are protected from scale in. If the rolling update process fails, any instances that are replaced are not rolled back to their previous configuration. </p>
        pub fn set_strategy(
            mut self,
            input: std::option::Option<crate::model::RefreshStrategy>,
        ) -> Self {
            self.strategy = input;
            self
        }
        /// <p>The desired configuration. For example, the desired configuration can specify a new launch template or a new version of the current launch template.</p>
        /// <p>Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to reflect the new desired configuration. </p> <note>
        /// <p>When you specify a new launch template or a new version of the current launch template for your desired configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and version. This can help you reduce the number of replacements that are required to apply updates. </p>
        /// </note>
        pub fn desired_configuration(mut self, input: crate::model::DesiredConfiguration) -> Self {
            self.desired_configuration = Some(input);
            self
        }
        /// <p>The desired configuration. For example, the desired configuration can specify a new launch template or a new version of the current launch template.</p>
        /// <p>Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to reflect the new desired configuration. </p> <note>
        /// <p>When you specify a new launch template or a new version of the current launch template for your desired configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and version. This can help you reduce the number of replacements that are required to apply updates. </p>
        /// </note>
        pub fn set_desired_configuration(
            mut self,
            input: std::option::Option<crate::model::DesiredConfiguration>,
        ) -> Self {
            self.desired_configuration = input;
            self
        }
        /// <p>Set of preferences associated with the instance refresh request. If not provided, the default values are used.</p>
        pub fn preferences(mut self, input: crate::model::RefreshPreferences) -> Self {
            self.preferences = Some(input);
            self
        }
        /// <p>Set of preferences associated with the instance refresh request. If not provided, the default values are used.</p>
        pub fn set_preferences(
            mut self,
            input: std::option::Option<crate::model::RefreshPreferences>,
        ) -> Self {
            self.preferences = input;
            self
        }
        /// Consumes the builder and constructs a [`StartInstanceRefreshInput`](crate::input::StartInstanceRefreshInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartInstanceRefreshInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartInstanceRefreshInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                strategy: self.strategy,
                desired_configuration: self.desired_configuration,
                preferences: self.preferences,
            })
        }
    }
}
#[doc(hidden)]
pub type StartInstanceRefreshInputOperationOutputAlias = crate::operation::StartInstanceRefresh;
#[doc(hidden)]
pub type StartInstanceRefreshInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartInstanceRefreshInput {
    /// Consumes the builder and constructs an Operation<[`StartInstanceRefresh`](crate::operation::StartInstanceRefresh)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartInstanceRefresh,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartInstanceRefreshInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartInstanceRefreshInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_instance_refresh(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartInstanceRefresh::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartInstanceRefresh",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartInstanceRefreshInput`](crate::input::StartInstanceRefreshInput)
    pub fn builder() -> crate::input::start_instance_refresh_input::Builder {
        crate::input::start_instance_refresh_input::Builder::default()
    }
}

/// See [`SuspendProcessesInput`](crate::input::SuspendProcessesInput)
pub mod suspend_processes_input {
    /// A builder for [`SuspendProcessesInput`](crate::input::SuspendProcessesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scaling_processes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// Appends an item to `scaling_processes`.
        ///
        /// To override the contents of this collection use [`set_scaling_processes`](Self::set_scaling_processes).
        ///
        /// <p>One or more of the following processes:</p>
        /// <ul>
        /// <li> <p> <code>Launch</code> </p> </li>
        /// <li> <p> <code>Terminate</code> </p> </li>
        /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
        /// <li> <p> <code>AlarmNotification</code> </p> </li>
        /// <li> <p> <code>AZRebalance</code> </p> </li>
        /// <li> <p> <code>HealthCheck</code> </p> </li>
        /// <li> <p> <code>InstanceRefresh</code> </p> </li>
        /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
        /// <li> <p> <code>ScheduledActions</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all processes are specified.</p>
        pub fn scaling_processes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.scaling_processes.unwrap_or_default();
            v.push(input.into());
            self.scaling_processes = Some(v);
            self
        }
        /// <p>One or more of the following processes:</p>
        /// <ul>
        /// <li> <p> <code>Launch</code> </p> </li>
        /// <li> <p> <code>Terminate</code> </p> </li>
        /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
        /// <li> <p> <code>AlarmNotification</code> </p> </li>
        /// <li> <p> <code>AZRebalance</code> </p> </li>
        /// <li> <p> <code>HealthCheck</code> </p> </li>
        /// <li> <p> <code>InstanceRefresh</code> </p> </li>
        /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
        /// <li> <p> <code>ScheduledActions</code> </p> </li>
        /// </ul>
        /// <p>If you omit this parameter, all processes are specified.</p>
        pub fn set_scaling_processes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.scaling_processes = input;
            self
        }
        /// Consumes the builder and constructs a [`SuspendProcessesInput`](crate::input::SuspendProcessesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SuspendProcessesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SuspendProcessesInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scaling_processes: self.scaling_processes,
            })
        }
    }
}
#[doc(hidden)]
pub type SuspendProcessesInputOperationOutputAlias = crate::operation::SuspendProcesses;
#[doc(hidden)]
pub type SuspendProcessesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SuspendProcessesInput {
    /// Consumes the builder and constructs an Operation<[`SuspendProcesses`](crate::operation::SuspendProcesses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SuspendProcesses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SuspendProcessesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SuspendProcessesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_suspend_processes(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SuspendProcesses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SuspendProcesses",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SuspendProcessesInput`](crate::input::SuspendProcessesInput)
    pub fn builder() -> crate::input::suspend_processes_input::Builder {
        crate::input::suspend_processes_input::Builder::default()
    }
}

/// See [`TerminateInstanceInAutoScalingGroupInput`](crate::input::TerminateInstanceInAutoScalingGroupInput)
pub mod terminate_instance_in_auto_scaling_group_input {
    /// A builder for [`TerminateInstanceInAutoScalingGroupInput`](crate::input::TerminateInstanceInAutoScalingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) should_decrement_desired_capacity: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Indicates whether terminating the instance also decrements the size of the Auto Scaling group.</p>
        pub fn should_decrement_desired_capacity(mut self, input: bool) -> Self {
            self.should_decrement_desired_capacity = Some(input);
            self
        }
        /// <p>Indicates whether terminating the instance also decrements the size of the Auto Scaling group.</p>
        pub fn set_should_decrement_desired_capacity(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.should_decrement_desired_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateInstanceInAutoScalingGroupInput`](crate::input::TerminateInstanceInAutoScalingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TerminateInstanceInAutoScalingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TerminateInstanceInAutoScalingGroupInput {
                instance_id: self.instance_id,
                should_decrement_desired_capacity: self.should_decrement_desired_capacity,
            })
        }
    }
}
#[doc(hidden)]
pub type TerminateInstanceInAutoScalingGroupInputOperationOutputAlias =
    crate::operation::TerminateInstanceInAutoScalingGroup;
#[doc(hidden)]
pub type TerminateInstanceInAutoScalingGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl TerminateInstanceInAutoScalingGroupInput {
    /// Consumes the builder and constructs an Operation<[`TerminateInstanceInAutoScalingGroup`](crate::operation::TerminateInstanceInAutoScalingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TerminateInstanceInAutoScalingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TerminateInstanceInAutoScalingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TerminateInstanceInAutoScalingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_terminate_instance_in_auto_scaling_group(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TerminateInstanceInAutoScalingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TerminateInstanceInAutoScalingGroup",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TerminateInstanceInAutoScalingGroupInput`](crate::input::TerminateInstanceInAutoScalingGroupInput)
    pub fn builder() -> crate::input::terminate_instance_in_auto_scaling_group_input::Builder {
        crate::input::terminate_instance_in_auto_scaling_group_input::Builder::default()
    }
}

/// See [`UpdateAutoScalingGroupInput`](crate::input::UpdateAutoScalingGroupInput)
pub mod update_auto_scaling_group_input {
    /// A builder for [`UpdateAutoScalingGroupInput`](crate::input::UpdateAutoScalingGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) default_cooldown: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) health_check_type: std::option::Option<std::string::String>,
        pub(crate) health_check_grace_period: std::option::Option<i32>,
        pub(crate) placement_group: std::option::Option<std::string::String>,
        pub(crate) vpc_zone_identifier: std::option::Option<std::string::String>,
        pub(crate) termination_policies: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) new_instances_protected_from_scale_in: std::option::Option<bool>,
        pub(crate) service_linked_role_arn: std::option::Option<std::string::String>,
        pub(crate) max_instance_lifetime: std::option::Option<i32>,
        pub(crate) capacity_rebalance: std::option::Option<bool>,
        pub(crate) context: std::option::Option<std::string::String>,
        pub(crate) desired_capacity_type: std::option::Option<std::string::String>,
        pub(crate) default_instance_warmup: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update request, you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update request, you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in your update request, you can't specify <code>LaunchConfigurationName</code> or <code>MixedInstancesPolicy</code>.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in your update request, you can't specify <code>LaunchConfigurationName</code> or <code>MixedInstancesPolicy</code>.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// <p>An embedded object that specifies a mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn mixed_instances_policy(mut self, input: crate::model::MixedInstancesPolicy) -> Self {
            self.mixed_instances_policy = Some(input);
            self
        }
        /// <p>An embedded object that specifies a mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_mixed_instances_policy(
            mut self,
            input: std::option::Option<crate::model::MixedInstancesPolicy>,
        ) -> Self {
            self.mixed_instances_policy = input;
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p> <note>
        /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
        /// </note>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p> <note>
        /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
        /// </note>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.</p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.</p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
        /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn default_cooldown(mut self, input: i32) -> Self {
            self.default_cooldown = Some(input);
            self
        }
        /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
        /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_default_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.default_cooldown = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>One or more Availability Zones for the group.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>One or more Availability Zones for the group.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.</p>
        pub fn health_check_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_type = Some(input.into());
            self
        }
        /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.</p>
        pub fn set_health_check_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_type = input;
            self
        }
        /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn health_check_grace_period(mut self, input: i32) -> Self {
            self.health_check_grace_period = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_health_check_grace_period(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_grace_period = input;
            self
        }
        /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
        /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
        /// </note>
        pub fn placement_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_group = Some(input.into());
            self
        }
        /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
        /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
        /// </note>
        pub fn set_placement_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_group = input;
            self
        }
        /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
        pub fn vpc_zone_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_zone_identifier = Some(input.into());
            self
        }
        /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
        pub fn set_vpc_zone_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_zone_identifier = input;
            self
        }
        /// Appends an item to `termination_policies`.
        ///
        /// To override the contents of this collection use [`set_termination_policies`](Self::set_termination_policies).
        ///
        /// <p>A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn termination_policies(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.termination_policies.unwrap_or_default();
            v.push(input.into());
            self.termination_policies = Some(v);
            self
        }
        /// <p>A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_termination_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.termination_policies = input;
            self
        }
        /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn new_instances_protected_from_scale_in(mut self, input: bool) -> Self {
            self.new_instances_protected_from_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_new_instances_protected_from_scale_in(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.new_instances_protected_from_scale_in = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn service_linked_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_linked_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_service_linked_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_linked_role_arn = input;
            self
        }
        /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn max_instance_lifetime(mut self, input: i32) -> Self {
            self.max_instance_lifetime = Some(input);
            self
        }
        /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_max_instance_lifetime(mut self, input: std::option::Option<i32>) -> Self {
            self.max_instance_lifetime = input;
            self
        }
        /// <p>Enables or disables Capacity Rebalancing. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn capacity_rebalance(mut self, input: bool) -> Self {
            self.capacity_rebalance = Some(input);
            self
        }
        /// <p>Enables or disables Capacity Rebalancing. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_capacity_rebalance(mut self, input: std::option::Option<bool>) -> Self {
            self.capacity_rebalance = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
        /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
        pub fn desired_capacity_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.desired_capacity_type = Some(input.into());
            self
        }
        /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
        /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
        pub fn set_desired_capacity_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_capacity_type = input;
            self
        }
        /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
        /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
        /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
        /// </important>
        pub fn default_instance_warmup(mut self, input: i32) -> Self {
            self.default_instance_warmup = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
        /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
        /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
        /// </important>
        pub fn set_default_instance_warmup(mut self, input: std::option::Option<i32>) -> Self {
            self.default_instance_warmup = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAutoScalingGroupInput`](crate::input::UpdateAutoScalingGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAutoScalingGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAutoScalingGroupInput {
                auto_scaling_group_name: self.auto_scaling_group_name,
                launch_configuration_name: self.launch_configuration_name,
                launch_template: self.launch_template,
                mixed_instances_policy: self.mixed_instances_policy,
                min_size: self.min_size,
                max_size: self.max_size,
                desired_capacity: self.desired_capacity,
                default_cooldown: self.default_cooldown,
                availability_zones: self.availability_zones,
                health_check_type: self.health_check_type,
                health_check_grace_period: self.health_check_grace_period,
                placement_group: self.placement_group,
                vpc_zone_identifier: self.vpc_zone_identifier,
                termination_policies: self.termination_policies,
                new_instances_protected_from_scale_in: self.new_instances_protected_from_scale_in,
                service_linked_role_arn: self.service_linked_role_arn,
                max_instance_lifetime: self.max_instance_lifetime,
                capacity_rebalance: self.capacity_rebalance,
                context: self.context,
                desired_capacity_type: self.desired_capacity_type,
                default_instance_warmup: self.default_instance_warmup,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAutoScalingGroupInputOperationOutputAlias = crate::operation::UpdateAutoScalingGroup;
#[doc(hidden)]
pub type UpdateAutoScalingGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAutoScalingGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAutoScalingGroup`](crate::operation::UpdateAutoScalingGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAutoScalingGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateAutoScalingGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateAutoScalingGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_auto_scaling_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAutoScalingGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAutoScalingGroup",
            "autoscaling",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateAutoScalingGroupInput`](crate::input::UpdateAutoScalingGroupInput)
    pub fn builder() -> crate::input::update_auto_scaling_group_input::Builder {
        crate::input::update_auto_scaling_group_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAutoScalingGroupInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update request, you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in your update request, you can't specify <code>LaunchConfigurationName</code> or <code>MixedInstancesPolicy</code>.</p>
    pub launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>An embedded object that specifies a mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum size of the Auto Scaling group.</p> <note>
    /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
    /// </note>
    pub max_size: std::option::Option<i32>,
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.</p>
    pub desired_capacity: std::option::Option<i32>,
    /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
    /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub default_cooldown: std::option::Option<i32>,
    /// <p>One or more Availability Zones for the group.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.</p>
    pub health_check_type: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub health_check_grace_period: std::option::Option<i32>,
    /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
    /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
    /// </note>
    pub placement_group: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
    pub vpc_zone_identifier: std::option::Option<std::string::String>,
    /// <p>A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub termination_policies: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub new_instances_protected_from_scale_in: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub service_linked_role_arn: std::option::Option<std::string::String>,
    /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub max_instance_lifetime: std::option::Option<i32>,
    /// <p>Enables or disables Capacity Rebalancing. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub capacity_rebalance: std::option::Option<bool>,
    /// <p>Reserved.</p>
    pub context: std::option::Option<std::string::String>,
    /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
    /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
    pub desired_capacity_type: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
    /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
    /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
    /// </important>
    pub default_instance_warmup: std::option::Option<i32>,
}
impl UpdateAutoScalingGroupInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of the launch configuration. If you specify <code>LaunchConfigurationName</code> in your update request, you can't specify <code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>.</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
    /// <p>The launch template and version to use to specify the updates. If you specify <code>LaunchTemplate</code> in your update request, you can't specify <code>LaunchConfigurationName</code> or <code>MixedInstancesPolicy</code>.</p>
    pub fn launch_template(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template.as_ref()
    }
    /// <p>An embedded object that specifies a mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn mixed_instances_policy(
        &self,
    ) -> std::option::Option<&crate::model::MixedInstancesPolicy> {
        self.mixed_instances_policy.as_ref()
    }
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The maximum size of the Auto Scaling group.</p> <note>
    /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
    /// </note>
    pub fn max_size(&self) -> std::option::Option<i32> {
        self.max_size
    }
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group.</p>
    pub fn desired_capacity(&self) -> std::option::Option<i32> {
        self.desired_capacity
    }
    /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
    /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn default_cooldown(&self) -> std::option::Option<i32> {
        self.default_cooldown
    }
    /// <p>One or more Availability Zones for the group.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks.</p>
    pub fn health_check_type(&self) -> std::option::Option<&str> {
        self.health_check_type.as_deref()
    }
    /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn health_check_grace_period(&self) -> std::option::Option<i32> {
        self.health_check_grace_period
    }
    /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
    /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
    /// </note>
    pub fn placement_group(&self) -> std::option::Option<&str> {
        self.placement_group.as_deref()
    }
    /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC). If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
    pub fn vpc_zone_identifier(&self) -> std::option::Option<&str> {
        self.vpc_zone_identifier.as_deref()
    }
    /// <p>A policy or a list of policies that are used to select the instances to terminate. The policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn termination_policies(&self) -> std::option::Option<&[std::string::String]> {
        self.termination_policies.as_deref()
    }
    /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn new_instances_protected_from_scale_in(&self) -> std::option::Option<bool> {
        self.new_instances_protected_from_scale_in
    }
    /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn service_linked_role_arn(&self) -> std::option::Option<&str> {
        self.service_linked_role_arn.as_deref()
    }
    /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). To clear a previously set value, specify a new value of 0. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn max_instance_lifetime(&self) -> std::option::Option<i32> {
        self.max_instance_lifetime
    }
    /// <p>Enables or disables Capacity Rebalancing. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn capacity_rebalance(&self) -> std::option::Option<bool> {
        self.capacity_rebalance
    }
    /// <p>Reserved.</p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
    /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
    /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
    pub fn desired_capacity_type(&self) -> std::option::Option<&str> {
        self.desired_capacity_type.as_deref()
    }
    /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
    /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
    /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
    /// </important>
    pub fn default_instance_warmup(&self) -> std::option::Option<i32> {
        self.default_instance_warmup
    }
}
impl std::fmt::Debug for UpdateAutoScalingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAutoScalingGroupInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("launch_template", &self.launch_template);
        formatter.field("mixed_instances_policy", &self.mixed_instances_policy);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("default_cooldown", &self.default_cooldown);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("health_check_type", &self.health_check_type);
        formatter.field("health_check_grace_period", &self.health_check_grace_period);
        formatter.field("placement_group", &self.placement_group);
        formatter.field("vpc_zone_identifier", &self.vpc_zone_identifier);
        formatter.field("termination_policies", &self.termination_policies);
        formatter.field(
            "new_instances_protected_from_scale_in",
            &self.new_instances_protected_from_scale_in,
        );
        formatter.field("service_linked_role_arn", &self.service_linked_role_arn);
        formatter.field("max_instance_lifetime", &self.max_instance_lifetime);
        formatter.field("capacity_rebalance", &self.capacity_rebalance);
        formatter.field("context", &self.context);
        formatter.field("desired_capacity_type", &self.desired_capacity_type);
        formatter.field("default_instance_warmup", &self.default_instance_warmup);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateInstanceInAutoScalingGroupInput {
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>Indicates whether terminating the instance also decrements the size of the Auto Scaling group.</p>
    pub should_decrement_desired_capacity: std::option::Option<bool>,
}
impl TerminateInstanceInAutoScalingGroupInput {
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>Indicates whether terminating the instance also decrements the size of the Auto Scaling group.</p>
    pub fn should_decrement_desired_capacity(&self) -> std::option::Option<bool> {
        self.should_decrement_desired_capacity
    }
}
impl std::fmt::Debug for TerminateInstanceInAutoScalingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateInstanceInAutoScalingGroupInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field(
            "should_decrement_desired_capacity",
            &self.should_decrement_desired_capacity,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuspendProcessesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>One or more of the following processes:</p>
    /// <ul>
    /// <li> <p> <code>Launch</code> </p> </li>
    /// <li> <p> <code>Terminate</code> </p> </li>
    /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
    /// <li> <p> <code>AlarmNotification</code> </p> </li>
    /// <li> <p> <code>AZRebalance</code> </p> </li>
    /// <li> <p> <code>HealthCheck</code> </p> </li>
    /// <li> <p> <code>InstanceRefresh</code> </p> </li>
    /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
    /// <li> <p> <code>ScheduledActions</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all processes are specified.</p>
    pub scaling_processes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SuspendProcessesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>One or more of the following processes:</p>
    /// <ul>
    /// <li> <p> <code>Launch</code> </p> </li>
    /// <li> <p> <code>Terminate</code> </p> </li>
    /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
    /// <li> <p> <code>AlarmNotification</code> </p> </li>
    /// <li> <p> <code>AZRebalance</code> </p> </li>
    /// <li> <p> <code>HealthCheck</code> </p> </li>
    /// <li> <p> <code>InstanceRefresh</code> </p> </li>
    /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
    /// <li> <p> <code>ScheduledActions</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all processes are specified.</p>
    pub fn scaling_processes(&self) -> std::option::Option<&[std::string::String]> {
        self.scaling_processes.as_deref()
    }
}
impl std::fmt::Debug for SuspendProcessesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuspendProcessesInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("scaling_processes", &self.scaling_processes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartInstanceRefreshInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
    /// <p>A rolling update helps you update your instances gradually. A rolling update can fail due to failed health checks or if instances are on standby or are protected from scale in. If the rolling update process fails, any instances that are replaced are not rolled back to their previous configuration. </p>
    pub strategy: std::option::Option<crate::model::RefreshStrategy>,
    /// <p>The desired configuration. For example, the desired configuration can specify a new launch template or a new version of the current launch template.</p>
    /// <p>Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to reflect the new desired configuration. </p> <note>
    /// <p>When you specify a new launch template or a new version of the current launch template for your desired configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and version. This can help you reduce the number of replacements that are required to apply updates. </p>
    /// </note>
    pub desired_configuration: std::option::Option<crate::model::DesiredConfiguration>,
    /// <p>Set of preferences associated with the instance refresh request. If not provided, the default values are used.</p>
    pub preferences: std::option::Option<crate::model::RefreshPreferences>,
}
impl StartInstanceRefreshInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The strategy to use for the instance refresh. The only valid value is <code>Rolling</code>.</p>
    /// <p>A rolling update helps you update your instances gradually. A rolling update can fail due to failed health checks or if instances are on standby or are protected from scale in. If the rolling update process fails, any instances that are replaced are not rolled back to their previous configuration. </p>
    pub fn strategy(&self) -> std::option::Option<&crate::model::RefreshStrategy> {
        self.strategy.as_ref()
    }
    /// <p>The desired configuration. For example, the desired configuration can specify a new launch template or a new version of the current launch template.</p>
    /// <p>Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the settings of the Auto Scaling group to reflect the new desired configuration. </p> <note>
    /// <p>When you specify a new launch template or a new version of the current launch template for your desired configuration, consider enabling the <code>SkipMatching</code> property in preferences. If it's enabled, Amazon EC2 Auto Scaling skips replacing instances that already use the specified launch template and version. This can help you reduce the number of replacements that are required to apply updates. </p>
    /// </note>
    pub fn desired_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DesiredConfiguration> {
        self.desired_configuration.as_ref()
    }
    /// <p>Set of preferences associated with the instance refresh request. If not provided, the default values are used.</p>
    pub fn preferences(&self) -> std::option::Option<&crate::model::RefreshPreferences> {
        self.preferences.as_ref()
    }
}
impl std::fmt::Debug for StartInstanceRefreshInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartInstanceRefreshInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("strategy", &self.strategy);
        formatter.field("desired_configuration", &self.desired_configuration);
        formatter.field("preferences", &self.preferences);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetInstanceProtectionInput {
    /// <p>One or more instance IDs. You can specify up to 50 instances.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>
    pub protected_from_scale_in: std::option::Option<bool>,
}
impl SetInstanceProtectionInput {
    /// <p>One or more instance IDs. You can specify up to 50 instances.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling in.</p>
    pub fn protected_from_scale_in(&self) -> std::option::Option<bool> {
        self.protected_from_scale_in
    }
}
impl std::fmt::Debug for SetInstanceProtectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetInstanceProtectionInput");
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("protected_from_scale_in", &self.protected_from_scale_in);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetInstanceHealthInput {
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The health status of the instance. Set to <code>Healthy</code> to have the instance remain in service. Set to <code>Unhealthy</code> to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.</p>
    pub health_status: std::option::Option<std::string::String>,
    /// <p>If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the group, by default, this call respects the grace period. Set this to <code>False</code>, to have the call not respect the grace period associated with the group.</p>
    /// <p>For more information about the health check grace period, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html">CreateAutoScalingGroup</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
    pub should_respect_grace_period: std::option::Option<bool>,
}
impl SetInstanceHealthInput {
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The health status of the instance. Set to <code>Healthy</code> to have the instance remain in service. Set to <code>Unhealthy</code> to have the instance be out of service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy instance.</p>
    pub fn health_status(&self) -> std::option::Option<&str> {
        self.health_status.as_deref()
    }
    /// <p>If the Auto Scaling group of the specified instance has a <code>HealthCheckGracePeriod</code> specified for the group, by default, this call respects the grace period. Set this to <code>False</code>, to have the call not respect the grace period associated with the group.</p>
    /// <p>For more information about the health check grace period, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html">CreateAutoScalingGroup</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
    pub fn should_respect_grace_period(&self) -> std::option::Option<bool> {
        self.should_respect_grace_period
    }
}
impl std::fmt::Debug for SetInstanceHealthInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetInstanceHealthInput");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("health_status", &self.health_status);
        formatter.field(
            "should_respect_grace_period",
            &self.should_respect_grace_period,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetDesiredCapacityInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain.</p>
    pub desired_capacity: std::option::Option<i32>,
    /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the cooldown period during manual scaling activities.</p>
    pub honor_cooldown: std::option::Option<bool>,
}
impl SetDesiredCapacityInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after this operation completes and the capacity it attempts to maintain.</p>
    pub fn desired_capacity(&self) -> std::option::Option<i32> {
        self.desired_capacity
    }
    /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before initiating a scaling activity to set your Auto Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling does not honor the cooldown period during manual scaling activities.</p>
    pub fn honor_cooldown(&self) -> std::option::Option<bool> {
        self.honor_cooldown
    }
}
impl std::fmt::Debug for SetDesiredCapacityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetDesiredCapacityInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("honor_cooldown", &self.honor_cooldown);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResumeProcessesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>One or more of the following processes:</p>
    /// <ul>
    /// <li> <p> <code>Launch</code> </p> </li>
    /// <li> <p> <code>Terminate</code> </p> </li>
    /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
    /// <li> <p> <code>AlarmNotification</code> </p> </li>
    /// <li> <p> <code>AZRebalance</code> </p> </li>
    /// <li> <p> <code>HealthCheck</code> </p> </li>
    /// <li> <p> <code>InstanceRefresh</code> </p> </li>
    /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
    /// <li> <p> <code>ScheduledActions</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all processes are specified.</p>
    pub scaling_processes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ResumeProcessesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>One or more of the following processes:</p>
    /// <ul>
    /// <li> <p> <code>Launch</code> </p> </li>
    /// <li> <p> <code>Terminate</code> </p> </li>
    /// <li> <p> <code>AddToLoadBalancer</code> </p> </li>
    /// <li> <p> <code>AlarmNotification</code> </p> </li>
    /// <li> <p> <code>AZRebalance</code> </p> </li>
    /// <li> <p> <code>HealthCheck</code> </p> </li>
    /// <li> <p> <code>InstanceRefresh</code> </p> </li>
    /// <li> <p> <code>ReplaceUnhealthy</code> </p> </li>
    /// <li> <p> <code>ScheduledActions</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all processes are specified.</p>
    pub fn scaling_processes(&self) -> std::option::Option<&[std::string::String]> {
        self.scaling_processes.as_deref()
    }
}
impl std::fmt::Debug for ResumeProcessesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResumeProcessesInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("scaling_processes", &self.scaling_processes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecordLifecycleActionHeartbeatInput {
    /// <p>The name of the lifecycle hook.</p>
    pub lifecycle_hook_name: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target that you specified when you created the lifecycle hook.</p>
    pub lifecycle_action_token: std::option::Option<std::string::String>,
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl RecordLifecycleActionHeartbeatInput {
    /// <p>The name of the lifecycle hook.</p>
    pub fn lifecycle_hook_name(&self) -> std::option::Option<&str> {
        self.lifecycle_hook_name.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>A token that uniquely identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target that you specified when you created the lifecycle hook.</p>
    pub fn lifecycle_action_token(&self) -> std::option::Option<&str> {
        self.lifecycle_action_token.as_deref()
    }
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for RecordLifecycleActionHeartbeatInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecordLifecycleActionHeartbeatInput");
        formatter.field("lifecycle_hook_name", &self.lifecycle_hook_name);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("lifecycle_action_token", &self.lifecycle_action_token);
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutWarmPoolInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity. </p> <important>
    /// <p>If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead. </p>
    /// <p>The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.</p>
    /// </important>
    /// <p>If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code>, the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code>. To remove a value that you previously set, include the property but specify -1 for the value. </p>
    pub max_group_prepared_capacity: std::option::Option<i32>,
    /// <p>Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>Sets the instance state to transition to after the lifecycle actions are complete. Default is <code>Stopped</code>.</p>
    pub pool_state: std::option::Option<crate::model::WarmPoolState>,
    /// <p>Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.</p>
    pub instance_reuse_policy: std::option::Option<crate::model::InstanceReusePolicy>,
}
impl PutWarmPoolInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Specifies the maximum number of instances that are allowed to be in the warm pool or in any state except <code>Terminated</code> for the Auto Scaling group. This is an optional property. Specify it only if you do not want the warm pool size to be determined by the difference between the group's maximum capacity and its desired capacity. </p> <important>
    /// <p>If a value for <code>MaxGroupPreparedCapacity</code> is not specified, Amazon EC2 Auto Scaling launches and maintains the difference between the group's maximum capacity and its desired capacity. If you specify a value for <code>MaxGroupPreparedCapacity</code>, Amazon EC2 Auto Scaling uses the difference between the <code>MaxGroupPreparedCapacity</code> and the desired capacity instead. </p>
    /// <p>The size of the warm pool is dynamic. Only when <code>MaxGroupPreparedCapacity</code> and <code>MinSize</code> are set to the same value does the warm pool have an absolute size.</p>
    /// </important>
    /// <p>If the desired capacity of the Auto Scaling group is higher than the <code>MaxGroupPreparedCapacity</code>, the capacity of the warm pool is 0, unless you specify a value for <code>MinSize</code>. To remove a value that you previously set, include the property but specify -1 for the value. </p>
    pub fn max_group_prepared_capacity(&self) -> std::option::Option<i32> {
        self.max_group_prepared_capacity
    }
    /// <p>Specifies the minimum number of instances to maintain in the warm pool. This helps you to ensure that there is always a certain number of warmed instances available to handle traffic spikes. Defaults to 0 if not specified.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>Sets the instance state to transition to after the lifecycle actions are complete. Default is <code>Stopped</code>.</p>
    pub fn pool_state(&self) -> std::option::Option<&crate::model::WarmPoolState> {
        self.pool_state.as_ref()
    }
    /// <p>Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in. The default is to terminate instances in the Auto Scaling group when the group scales in.</p>
    pub fn instance_reuse_policy(&self) -> std::option::Option<&crate::model::InstanceReusePolicy> {
        self.instance_reuse_policy.as_ref()
    }
}
impl std::fmt::Debug for PutWarmPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutWarmPoolInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field(
            "max_group_prepared_capacity",
            &self.max_group_prepared_capacity,
        );
        formatter.field("min_size", &self.min_size);
        formatter.field("pool_state", &self.pool_state);
        formatter.field("instance_reuse_policy", &self.instance_reuse_policy);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutScheduledUpdateGroupActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of this scaling action.</p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>This parameter is no longer used.</p>
    pub time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
    /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.</p>
    /// <p>If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time for the recurring schedule to end, in UTC.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The recurring schedule for this action. This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
    /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action starts and stops.</p>
    /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
    pub recurrence: std::option::Option<std::string::String>,
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum size of the Auto Scaling group.</p>
    pub max_size: std::option::Option<i32>,
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions. </p>
    pub desired_capacity: std::option::Option<i32>,
    /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default. </p>
    /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
    pub time_zone: std::option::Option<std::string::String>,
}
impl PutScheduledUpdateGroupActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of this scaling action.</p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>This parameter is no longer used.</p>
    pub fn time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.time.as_ref()
    }
    /// <p>The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
    /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.</p>
    /// <p>If you try to schedule your action in the past, Amazon EC2 Auto Scaling returns an error message.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time for the recurring schedule to end, in UTC.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The recurring schedule for this action. This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
    /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code>, they form the boundaries of when the recurring action starts and stops.</p>
    /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
    pub fn recurrence(&self) -> std::option::Option<&str> {
        self.recurrence.as_deref()
    }
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The maximum size of the Auto Scaling group.</p>
    pub fn max_size(&self) -> std::option::Option<i32> {
        self.max_size
    }
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. It can scale beyond this capacity if you add more scaling conditions. </p>
    pub fn desired_capacity(&self) -> std::option::Option<i32> {
        self.desired_capacity
    }
    /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is used by default. </p>
    /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
    pub fn time_zone(&self) -> std::option::Option<&str> {
        self.time_zone.as_deref()
    }
}
impl std::fmt::Debug for PutScheduledUpdateGroupActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutScheduledUpdateGroupActionInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("time", &self.time);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("recurrence", &self.recurrence);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("time_zone", &self.time_zone);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutScalingPolicyInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>One of the following policy types: </p>
    /// <ul>
    /// <li> <p> <code>TargetTrackingScaling</code> </p> </li>
    /// <li> <p> <code>StepScaling</code> </p> </li>
    /// <li> <p> <code>SimpleScaling</code> (default)</p> </li>
    /// <li> <p> <code>PredictiveScaling</code> </p> </li>
    /// </ul>
    pub policy_type: std::option::Option<std::string::String>,
    /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
    /// <p>Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub adjustment_type: std::option::Option<std::string::String>,
    /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>
    pub min_adjustment_step: std::option::Option<i32>,
    /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.</p>
    /// <p>Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
    /// <p>Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.</p>
    /// </note>
    pub min_adjustment_magnitude: std::option::Option<i32>,
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
    /// <p>Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.) </p>
    pub scaling_adjustment: std::option::Option<i32>,
    /// <p>A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is specified here, it overrides the default cooldown.</p>
    /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Default: None</p>
    pub cooldown: std::option::Option<i32>,
    /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
    /// <p>Valid only if the policy type is <code>StepScaling</code>.</p>
    pub metric_aggregation_type: std::option::Option<std::string::String>,
    /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
    /// <p>Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.) </p>
    pub step_adjustments: std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
    /// <p> <i>Not needed if the default instance warmup is defined for the group.</i> </p>
    /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This warm-up period applies to instances launched due to a specific target tracking or step scaling policy. When a warm-up period is specified here, it overrides the default instance warmup.</p>
    /// <p>Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.</p> <note>
    /// <p>The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default cooldown.</p>
    /// </note>
    pub estimated_instance_warmup: std::option::Option<i32>,
    /// <p>A target tracking scaling policy. Provides support for predefined or custom metrics.</p>
    /// <p>The following predefined metrics are available:</p>
    /// <ul>
    /// <li> <p> <code>ASGAverageCPUUtilization</code> </p> </li>
    /// <li> <p> <code>ASGAverageNetworkIn</code> </p> </li>
    /// <li> <p> <code>ASGAverageNetworkOut</code> </p> </li>
    /// <li> <p> <code>ALBRequestCountPerTarget</code> </p> </li>
    /// </ul>
    /// <p>If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> parameter with the <code>PredefinedMetricSpecification</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html">TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
    /// <p>Required if the policy type is <code>TargetTrackingScaling</code>.</p>
    pub target_tracking_configuration:
        std::option::Option<crate::model::TargetTrackingConfiguration>,
    /// <p>Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html">Disabling a scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>A predictive scaling policy. Provides support for predefined and custom metrics.</p>
    /// <p>Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html">PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
    /// <p>Required if the policy type is <code>PredictiveScaling</code>.</p>
    pub predictive_scaling_configuration:
        std::option::Option<crate::model::PredictiveScalingConfiguration>,
}
impl PutScalingPolicyInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>One of the following policy types: </p>
    /// <ul>
    /// <li> <p> <code>TargetTrackingScaling</code> </p> </li>
    /// <li> <p> <code>StepScaling</code> </p> </li>
    /// <li> <p> <code>SimpleScaling</code> (default)</p> </li>
    /// <li> <p> <code>PredictiveScaling</code> </p> </li>
    /// </ul>
    pub fn policy_type(&self) -> std::option::Option<&str> {
        self.policy_type.as_deref()
    }
    /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number or a percentage). The valid values are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
    /// <p>Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn adjustment_type(&self) -> std::option::Option<&str> {
        self.adjustment_type.as_deref()
    }
    /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.</p>
    pub fn min_adjustment_step(&self) -> std::option::Option<i32> {
        self.min_adjustment_step
    }
    /// <p>The minimum value to scale by when the adjustment type is <code>PercentChangeInCapacity</code>. For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.</p>
    /// <p>Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
    /// <p>Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.</p>
    /// </note>
    pub fn min_adjustment_magnitude(&self) -> std::option::Option<i32> {
        self.min_adjustment_magnitude
    }
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.</p>
    /// <p>Required if the policy type is <code>SimpleScaling</code>. (Not used with any other policy type.) </p>
    pub fn scaling_adjustment(&self) -> std::option::Option<i32> {
        self.scaling_adjustment
    }
    /// <p>A cooldown period, in seconds, that applies to a specific simple scaling policy. When a cooldown period is specified here, it overrides the default cooldown.</p>
    /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Default: None</p>
    pub fn cooldown(&self) -> std::option::Option<i32> {
        self.cooldown
    }
    /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code>. If the aggregation type is null, the value is treated as <code>Average</code>.</p>
    /// <p>Valid only if the policy type is <code>StepScaling</code>.</p>
    pub fn metric_aggregation_type(&self) -> std::option::Option<&str> {
        self.metric_aggregation_type.as_deref()
    }
    /// <p>A set of adjustments that enable you to scale based on the size of the alarm breach.</p>
    /// <p>Required if the policy type is <code>StepScaling</code>. (Not used with any other policy type.) </p>
    pub fn step_adjustments(&self) -> std::option::Option<&[crate::model::StepAdjustment]> {
        self.step_adjustments.as_deref()
    }
    /// <p> <i>Not needed if the default instance warmup is defined for the group.</i> </p>
    /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics. This warm-up period applies to instances launched due to a specific target tracking or step scaling policy. When a warm-up period is specified here, it overrides the default instance warmup.</p>
    /// <p>Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code>.</p> <note>
    /// <p>The default is to use the value for the default instance warmup defined for the group. If default instance warmup is null, then <code>EstimatedInstanceWarmup</code> falls back to the value of default cooldown.</p>
    /// </note>
    pub fn estimated_instance_warmup(&self) -> std::option::Option<i32> {
        self.estimated_instance_warmup
    }
    /// <p>A target tracking scaling policy. Provides support for predefined or custom metrics.</p>
    /// <p>The following predefined metrics are available:</p>
    /// <ul>
    /// <li> <p> <code>ASGAverageCPUUtilization</code> </p> </li>
    /// <li> <p> <code>ASGAverageNetworkIn</code> </p> </li>
    /// <li> <p> <code>ASGAverageNetworkOut</code> </p> </li>
    /// <li> <p> <code>ALBRequestCountPerTarget</code> </p> </li>
    /// </ul>
    /// <p>If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> parameter with the <code>PredefinedMetricSpecification</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html">TargetTrackingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
    /// <p>Required if the policy type is <code>TargetTrackingScaling</code>.</p>
    pub fn target_tracking_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TargetTrackingConfiguration> {
        self.target_tracking_configuration.as_ref()
    }
    /// <p>Indicates whether the scaling policy is enabled or disabled. The default is enabled. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html">Disabling a scaling policy for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>A predictive scaling policy. Provides support for predefined and custom metrics.</p>
    /// <p>Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredictiveScalingConfiguration.html">PredictiveScalingConfiguration</a> in the <i>Amazon EC2 Auto Scaling API Reference</i>.</p>
    /// <p>Required if the policy type is <code>PredictiveScaling</code>.</p>
    pub fn predictive_scaling_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingConfiguration> {
        self.predictive_scaling_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutScalingPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutScalingPolicyInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_type", &self.policy_type);
        formatter.field("adjustment_type", &self.adjustment_type);
        formatter.field("min_adjustment_step", &self.min_adjustment_step);
        formatter.field("min_adjustment_magnitude", &self.min_adjustment_magnitude);
        formatter.field("scaling_adjustment", &self.scaling_adjustment);
        formatter.field("cooldown", &self.cooldown);
        formatter.field("metric_aggregation_type", &self.metric_aggregation_type);
        formatter.field("step_adjustments", &self.step_adjustments);
        formatter.field("estimated_instance_warmup", &self.estimated_instance_warmup);
        formatter.field(
            "target_tracking_configuration",
            &self.target_tracking_configuration,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "predictive_scaling_configuration",
            &self.predictive_scaling_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutNotificationConfigurationInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>The type of event that causes the notification to be sent. To query the notification types supported by Amazon EC2 Auto Scaling, call the <code>DescribeAutoScalingNotificationTypes</code> API.</p>
    pub notification_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PutNotificationConfigurationInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>The type of event that causes the notification to be sent. To query the notification types supported by Amazon EC2 Auto Scaling, call the <code>DescribeAutoScalingNotificationTypes</code> API.</p>
    pub fn notification_types(&self) -> std::option::Option<&[std::string::String]> {
        self.notification_types.as_deref()
    }
}
impl std::fmt::Debug for PutNotificationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutNotificationConfigurationInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("notification_types", &self.notification_types);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutLifecycleHookInput {
    /// <p>The name of the lifecycle hook.</p>
    pub lifecycle_hook_name: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The instance state to which you want to attach the lifecycle hook. The valid values are:</p>
    /// <ul>
    /// <li> <p>autoscaling:EC2_INSTANCE_LAUNCHING</p> </li>
    /// <li> <p>autoscaling:EC2_INSTANCE_TERMINATING</p> </li>
    /// </ul>
    /// <p>Required for new lifecycle hooks, but optional when updating existing hooks.</p>
    pub lifecycle_transition: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p>
    /// <p>Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in the transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic.</p>
    /// <p>If you specify an empty string, this overrides the current ARN.</p>
    /// <p>This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic.</p>
    /// <p>When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.</p>
    pub notification_target_arn: std::option::Option<std::string::String>,
    /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.</p>
    pub notification_metadata: std::option::Option<std::string::String>,
    /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).</p>
    /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing out by calling the <code>RecordLifecycleActionHeartbeat</code> API.</p>
    pub heartbeat_timeout: std::option::Option<i32>,
    /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
    pub default_result: std::option::Option<std::string::String>,
}
impl PutLifecycleHookInput {
    /// <p>The name of the lifecycle hook.</p>
    pub fn lifecycle_hook_name(&self) -> std::option::Option<&str> {
        self.lifecycle_hook_name.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The instance state to which you want to attach the lifecycle hook. The valid values are:</p>
    /// <ul>
    /// <li> <p>autoscaling:EC2_INSTANCE_LAUNCHING</p> </li>
    /// <li> <p>autoscaling:EC2_INSTANCE_TERMINATING</p> </li>
    /// </ul>
    /// <p>Required for new lifecycle hooks, but optional when updating existing hooks.</p>
    pub fn lifecycle_transition(&self) -> std::option::Option<&str> {
        self.lifecycle_transition.as_deref()
    }
    /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified notification target.</p>
    /// <p>Valid only if the notification target is an Amazon SNS topic or an Amazon SQS queue. Required for new lifecycle hooks, but optional when updating existing hooks.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the notification target that Amazon EC2 Auto Scaling uses to notify you when an instance is in the transition state for the lifecycle hook. This target can be either an SQS queue or an SNS topic.</p>
    /// <p>If you specify an empty string, this overrides the current ARN.</p>
    /// <p>This operation uses the JSON format when sending notifications to an Amazon SQS queue, and an email key-value pair format when sending notifications to an Amazon SNS topic.</p>
    /// <p>When you specify a notification target, Amazon EC2 Auto Scaling sends it a test message. Test messages contain the following additional key-value pair: <code>"Event": "autoscaling:TEST_NOTIFICATION"</code>.</p>
    pub fn notification_target_arn(&self) -> std::option::Option<&str> {
        self.notification_target_arn.as_deref()
    }
    /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to the notification target.</p>
    pub fn notification_metadata(&self) -> std::option::Option<&str> {
        self.notification_metadata.as_deref()
    }
    /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. The range is from <code>30</code> to <code>7200</code> seconds. The default value is <code>3600</code> seconds (1 hour).</p>
    /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing out by calling the <code>RecordLifecycleActionHeartbeat</code> API.</p>
    pub fn heartbeat_timeout(&self) -> std::option::Option<i32> {
        self.heartbeat_timeout
    }
    /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses or if an unexpected failure occurs. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
    pub fn default_result(&self) -> std::option::Option<&str> {
        self.default_result.as_deref()
    }
}
impl std::fmt::Debug for PutLifecycleHookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutLifecycleHookInput");
        formatter.field("lifecycle_hook_name", &self.lifecycle_hook_name);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("lifecycle_transition", &self.lifecycle_transition);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("notification_target_arn", &self.notification_target_arn);
        formatter.field("notification_metadata", &self.notification_metadata);
        formatter.field("heartbeat_timeout", &self.heartbeat_timeout);
        formatter.field("default_result", &self.default_result);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPredictiveScalingForecastInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The inclusive start time of the time range for the forecast data to get. At most, the date and time can be one year before the current date and time.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is 30 days. </p>
    /// <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. Amazon EC2 Auto Scaling only issues forecasts for periods of two days in advance.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetPredictiveScalingForecastInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The inclusive start time of the time range for the forecast data to get. At most, the date and time can be one year before the current date and time.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The exclusive end time of the time range for the forecast data to get. The maximum time duration between the start and end time is 30 days. </p>
    /// <p>Although this parameter can accept a date and time that is more than two days in the future, the availability of forecast data has limits. Amazon EC2 Auto Scaling only issues forecasts for periods of two days in advance.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for GetPredictiveScalingForecastInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPredictiveScalingForecastInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExitStandbyInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
}
impl ExitStandbyInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
}
impl std::fmt::Debug for ExitStandbyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExitStandbyInput");
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutePolicyInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.</p>
    /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub honor_cooldown: std::option::Option<bool>,
    /// <p>The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.</p>
    /// <p>If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an error.</p>
    /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
    pub metric_value: std::option::Option<f64>,
    /// <p>The breach threshold for the alarm.</p>
    /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
    pub breach_threshold: std::option::Option<f64>,
}
impl ExecutePolicyInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name or ARN of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period to complete before executing the policy.</p>
    /// <p>Valid only if the policy type is <code>SimpleScaling</code>. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn honor_cooldown(&self) -> std::option::Option<bool> {
        self.honor_cooldown
    }
    /// <p>The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric value to 59.</p>
    /// <p>If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an error.</p>
    /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
    pub fn metric_value(&self) -> std::option::Option<f64> {
        self.metric_value
    }
    /// <p>The breach threshold for the alarm.</p>
    /// <p>Required if the policy type is <code>StepScaling</code> and not supported otherwise.</p>
    pub fn breach_threshold(&self) -> std::option::Option<f64> {
        self.breach_threshold
    }
}
impl std::fmt::Debug for ExecutePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutePolicyInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("honor_cooldown", &self.honor_cooldown);
        formatter.field("metric_value", &self.metric_value);
        formatter.field("breach_threshold", &self.breach_threshold);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnterStandbyInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether to decrement the desired capacity of the Auto Scaling group by the number of instances moved to <code>Standby</code> mode.</p>
    pub should_decrement_desired_capacity: std::option::Option<bool>,
}
impl EnterStandbyInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Indicates whether to decrement the desired capacity of the Auto Scaling group by the number of instances moved to <code>Standby</code> mode.</p>
    pub fn should_decrement_desired_capacity(&self) -> std::option::Option<bool> {
        self.should_decrement_desired_capacity
    }
}
impl std::fmt::Debug for EnterStandbyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnterStandbyInput");
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field(
            "should_decrement_desired_capacity",
            &self.should_decrement_desired_capacity,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableMetricsCollectionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies which group-level metrics to start collecting. You can specify one or more of the following metrics:</p>
    /// <ul>
    /// <li> <p> <code>GroupMinSize</code> </p> </li>
    /// <li> <p> <code>GroupMaxSize</code> </p> </li>
    /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
    /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
    /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
    /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
    /// </ul>
    /// <p>The instance weighting feature supports the following additional metrics: </p>
    /// <ul>
    /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
    /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
    /// </ul>
    /// <p>The warm pools feature supports the following additional metrics: </p>
    /// <ul>
    /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all metrics are enabled. </p>
    pub metrics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.</p>
    pub granularity: std::option::Option<std::string::String>,
}
impl EnableMetricsCollectionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Specifies which group-level metrics to start collecting. You can specify one or more of the following metrics:</p>
    /// <ul>
    /// <li> <p> <code>GroupMinSize</code> </p> </li>
    /// <li> <p> <code>GroupMaxSize</code> </p> </li>
    /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
    /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
    /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
    /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
    /// </ul>
    /// <p>The instance weighting feature supports the following additional metrics: </p>
    /// <ul>
    /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
    /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
    /// </ul>
    /// <p>The warm pools feature supports the following additional metrics: </p>
    /// <ul>
    /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all metrics are enabled. </p>
    pub fn metrics(&self) -> std::option::Option<&[std::string::String]> {
        self.metrics.as_deref()
    }
    /// <p>The granularity to associate with the metrics to collect. The only valid value is <code>1Minute</code>.</p>
    pub fn granularity(&self) -> std::option::Option<&str> {
        self.granularity.as_deref()
    }
}
impl std::fmt::Debug for EnableMetricsCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableMetricsCollectionInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("metrics", &self.metrics);
        formatter.field("granularity", &self.granularity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableMetricsCollectionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies one or more of the following metrics:</p>
    /// <ul>
    /// <li> <p> <code>GroupMinSize</code> </p> </li>
    /// <li> <p> <code>GroupMaxSize</code> </p> </li>
    /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
    /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
    /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
    /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
    /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
    /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all metrics are disabled. </p>
    pub metrics: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DisableMetricsCollectionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Specifies one or more of the following metrics:</p>
    /// <ul>
    /// <li> <p> <code>GroupMinSize</code> </p> </li>
    /// <li> <p> <code>GroupMaxSize</code> </p> </li>
    /// <li> <p> <code>GroupDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupInServiceInstances</code> </p> </li>
    /// <li> <p> <code>GroupPendingInstances</code> </p> </li>
    /// <li> <p> <code>GroupStandbyInstances</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingInstances</code> </p> </li>
    /// <li> <p> <code>GroupTotalInstances</code> </p> </li>
    /// <li> <p> <code>GroupInServiceCapacity</code> </p> </li>
    /// <li> <p> <code>GroupPendingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupStandbyCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>GroupTotalCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolWarmedCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolPendingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTerminatingCapacity</code> </p> </li>
    /// <li> <p> <code>WarmPoolTotalCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolDesiredCapacity</code> </p> </li>
    /// <li> <p> <code>GroupAndWarmPoolTotalCapacity</code> </p> </li>
    /// </ul>
    /// <p>If you omit this parameter, all metrics are disabled. </p>
    pub fn metrics(&self) -> std::option::Option<&[std::string::String]> {
        self.metrics.as_deref()
    }
}
impl std::fmt::Debug for DisableMetricsCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableMetricsCollectionInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("metrics", &self.metrics);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachLoadBalancerTargetGroupsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups.</p>
    pub target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DetachLoadBalancerTargetGroupsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups.</p>
    pub fn target_group_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.target_group_ar_ns.as_deref()
    }
}
impl std::fmt::Debug for DetachLoadBalancerTargetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachLoadBalancerTargetGroupsInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("target_group_ar_ns", &self.target_group_ar_ns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachLoadBalancersInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DetachLoadBalancersInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
}
impl std::fmt::Debug for DetachLoadBalancersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachLoadBalancersInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetachInstancesInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances detached.</p>
    pub should_decrement_desired_capacity: std::option::Option<bool>,
}
impl DetachInstancesInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Indicates whether the Auto Scaling group decrements the desired capacity value by the number of instances detached.</p>
    pub fn should_decrement_desired_capacity(&self) -> std::option::Option<bool> {
        self.should_decrement_desired_capacity
    }
}
impl std::fmt::Debug for DetachInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetachInstancesInput");
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field(
            "should_decrement_desired_capacity",
            &self.should_decrement_desired_capacity,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeWarmPoolInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of instances to return with this call. The maximum value is <code>50</code>.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>The token for the next set of instances to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeWarmPoolInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The maximum number of instances to return with this call. The maximum value is <code>50</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>The token for the next set of instances to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeWarmPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeWarmPoolInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTerminationPolicyTypesInput {}
impl std::fmt::Debug for DescribeTerminationPolicyTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTerminationPolicyTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsInput {
    /// <p>One or more filters to scope the tags to return. The maximum number of filters per filter type (for example, <code>auto-scaling-group</code>) is 1000.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribeTagsInput {
    /// <p>One or more filters to scope the tags to return. The maximum number of filters per filter type (for example, <code>auto-scaling-group</code>) is 1000.</p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribeTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScheduledActionsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The names of one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you specify an unknown scheduled action, it is ignored with no error.</p>
    /// <p>Array Members: Maximum number of 50 actions.</p>
    pub scheduled_action_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribeScheduledActionsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The names of one or more scheduled actions. If you omit this parameter, all scheduled actions are described. If you specify an unknown scheduled action, it is ignored with no error.</p>
    /// <p>Array Members: Maximum number of 50 actions.</p>
    pub fn scheduled_action_names(&self) -> std::option::Option<&[std::string::String]> {
        self.scheduled_action_names.as_deref()
    }
    /// <p>The earliest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The latest scheduled start time to return. If scheduled action names are provided, this parameter is ignored.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribeScheduledActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScheduledActionsInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("scheduled_action_names", &self.scheduled_action_names);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScalingProcessTypesInput {}
impl std::fmt::Debug for DescribeScalingProcessTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScalingProcessTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScalingActivitiesInput {
    /// <p>The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify an Auto Scaling group, the results are limited to that group.</p>
    /// <p>Array Members: Maximum number of 50 IDs.</p>
    pub activity_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether to include scaling activity from deleted Auto Scaling groups.</p>
    pub include_deleted_groups: std::option::Option<bool>,
    /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeScalingActivitiesInput {
    /// <p>The activity IDs of the desired scaling activities. If you omit this parameter, all activities for the past six weeks are described. If unknown activities are requested, they are ignored with no error. If you specify an Auto Scaling group, the results are limited to that group.</p>
    /// <p>Array Members: Maximum number of 50 IDs.</p>
    pub fn activity_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.activity_ids.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Indicates whether to include scaling activity from deleted Auto Scaling groups.</p>
    pub fn include_deleted_groups(&self) -> std::option::Option<bool> {
        self.include_deleted_groups
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeScalingActivitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScalingActivitiesInput");
        formatter.field("activity_ids", &self.activity_ids);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("include_deleted_groups", &self.include_deleted_groups);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePoliciesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The names of one or more policies. If you omit this parameter, all policies are described. If a group name is provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no error.</p>
    /// <p>Array Members: Maximum number of 50 items.</p>
    pub policy_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.</p>
    pub policy_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to be returned with each call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribePoliciesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The names of one or more policies. If you omit this parameter, all policies are described. If a group name is provided, the results are limited to that group. If you specify an unknown policy name, it is ignored with no error.</p>
    /// <p>Array Members: Maximum number of 50 items.</p>
    pub fn policy_names(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_names.as_deref()
    }
    /// <p>One or more policy types. The valid values are <code>SimpleScaling</code>, <code>StepScaling</code>, <code>TargetTrackingScaling</code>, and <code>PredictiveScaling</code>.</p>
    pub fn policy_types(&self) -> std::option::Option<&[std::string::String]> {
        self.policy_types.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to be returned with each call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribePoliciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePoliciesInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("policy_names", &self.policy_names);
        formatter.field("policy_types", &self.policy_types);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNotificationConfigurationsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribeNotificationConfigurationsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_scaling_group_names.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribeNotificationConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNotificationConfigurationsInput");
        formatter.field("auto_scaling_group_names", &self.auto_scaling_group_names);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMetricCollectionTypesInput {}
impl std::fmt::Debug for DescribeMetricCollectionTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMetricCollectionTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancerTargetGroupsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribeLoadBalancerTargetGroupsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribeLoadBalancerTargetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancerTargetGroupsInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoadBalancersInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribeLoadBalancersInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>100</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribeLoadBalancersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoadBalancersInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLifecycleHookTypesInput {}
impl std::fmt::Debug for DescribeLifecycleHookTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLifecycleHookTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLifecycleHooksInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.</p>
    pub lifecycle_hook_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DescribeLifecycleHooksInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.</p>
    pub fn lifecycle_hook_names(&self) -> std::option::Option<&[std::string::String]> {
        self.lifecycle_hook_names.as_deref()
    }
}
impl std::fmt::Debug for DescribeLifecycleHooksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLifecycleHooksInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("lifecycle_hook_names", &self.lifecycle_hook_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLaunchConfigurationsInput {
    /// <p>The launch configuration names. If you omit this parameter, all launch configurations are described.</p>
    /// <p>Array Members: Maximum number of 50 items.</p>
    pub launch_configuration_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribeLaunchConfigurationsInput {
    /// <p>The launch configuration names. If you omit this parameter, all launch configurations are described.</p>
    /// <p>Array Members: Maximum number of 50 items.</p>
    pub fn launch_configuration_names(&self) -> std::option::Option<&[std::string::String]> {
        self.launch_configuration_names.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribeLaunchConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLaunchConfigurationsInput");
        formatter.field(
            "launch_configuration_names",
            &self.launch_configuration_names,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstanceRefreshesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>One or more instance refresh IDs.</p>
    pub instance_refresh_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
}
impl DescribeInstanceRefreshesInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>One or more instance refresh IDs.</p>
    pub fn instance_refresh_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_refresh_ids.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
}
impl std::fmt::Debug for DescribeInstanceRefreshesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstanceRefreshesInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("instance_refresh_ids", &self.instance_refresh_ids);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAutoScalingNotificationTypesInput {}
impl std::fmt::Debug for DescribeAutoScalingNotificationTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAutoScalingNotificationTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAutoScalingInstancesInput {
    /// <p>The IDs of the instances. If you omit this parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.</p>
    /// <p>Array Members: Maximum number of 50 items.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>50</code>.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAutoScalingInstancesInput {
    /// <p>The IDs of the instances. If you omit this parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.</p>
    /// <p>Array Members: Maximum number of 50 items.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>50</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAutoScalingInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAutoScalingInstancesInput");
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("max_records", &self.max_records);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAutoScalingGroupsInput {
    /// <p>The names of the Auto Scaling groups. By default, you can only specify up to 50 names. You can optionally increase this limit using the <code>MaxRecords</code> parameter.</p>
    /// <p>If you omit this parameter, all Auto Scaling groups are described.</p>
    pub auto_scaling_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>One or more filters to limit the results based on specific tags. </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl DescribeAutoScalingGroupsInput {
    /// <p>The names of the Auto Scaling groups. By default, you can only specify up to 50 names. You can optionally increase this limit using the <code>MaxRecords</code> parameter.</p>
    /// <p>If you omit this parameter, all Auto Scaling groups are described.</p>
    pub fn auto_scaling_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.auto_scaling_group_names.as_deref()
    }
    /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of items to return with this call. The default value is <code>50</code> and the maximum value is <code>100</code>.</p>
    pub fn max_records(&self) -> std::option::Option<i32> {
        self.max_records
    }
    /// <p>One or more filters to limit the results based on specific tags. </p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for DescribeAutoScalingGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAutoScalingGroupsInput");
        formatter.field("auto_scaling_group_names", &self.auto_scaling_group_names);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_records", &self.max_records);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAdjustmentTypesInput {}
impl std::fmt::Debug for DescribeAdjustmentTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAdjustmentTypesInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountLimitsInput {}
impl std::fmt::Debug for DescribeAccountLimitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountLimitsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWarmPoolInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies that the warm pool is to be deleted along with all of its associated instances, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the warm pool instances.</p>
    pub force_delete: std::option::Option<bool>,
}
impl DeleteWarmPoolInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Specifies that the warm pool is to be deleted along with all of its associated instances, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the warm pool instances.</p>
    pub fn force_delete(&self) -> std::option::Option<bool> {
        self.force_delete
    }
}
impl std::fmt::Debug for DeleteWarmPoolInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWarmPoolInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("force_delete", &self.force_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsInput {
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteTagsInput {
    /// <p>One or more tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for DeleteTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsInput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScheduledActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the action to delete.</p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
}
impl DeleteScheduledActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of the action to delete.</p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteScheduledActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScheduledActionInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name or Amazon Resource Name (ARN) of the policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
}
impl DeletePolicyInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name or Amazon Resource Name (ARN) of the policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
}
impl std::fmt::Debug for DeletePolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNotificationConfigurationInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
    pub topic_arn: std::option::Option<std::string::String>,
}
impl DeleteNotificationConfigurationInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteNotificationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNotificationConfigurationInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLifecycleHookInput {
    /// <p>The name of the lifecycle hook.</p>
    pub lifecycle_hook_name: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
}
impl DeleteLifecycleHookInput {
    /// <p>The name of the lifecycle hook.</p>
    pub fn lifecycle_hook_name(&self) -> std::option::Option<&str> {
        self.lifecycle_hook_name.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteLifecycleHookInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLifecycleHookInput");
        formatter.field("lifecycle_hook_name", &self.lifecycle_hook_name);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLaunchConfigurationInput {
    /// <p>The name of the launch configuration.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
}
impl DeleteLaunchConfigurationInput {
    /// <p>The name of the launch configuration.</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteLaunchConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLaunchConfigurationInput");
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAutoScalingGroupInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies that the group is to be deleted along with all instances associated with the group, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the group.</p>
    pub force_delete: std::option::Option<bool>,
}
impl DeleteAutoScalingGroupInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>Specifies that the group is to be deleted along with all instances associated with the group, without waiting for all instances to be terminated. This parameter also deletes any outstanding lifecycle actions associated with the group.</p>
    pub fn force_delete(&self) -> std::option::Option<bool> {
        self.force_delete
    }
}
impl std::fmt::Debug for DeleteAutoScalingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAutoScalingGroupInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("force_delete", &self.force_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOrUpdateTagsInput {
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateOrUpdateTagsInput {
    /// <p>One or more tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateOrUpdateTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOrUpdateTagsInput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLaunchConfigurationInput {
    /// <p>The name of the launch configuration. This name must be unique per Region per account.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The name of the key pair. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.</p>
    /// <p>[EC2-VPC] Specify the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    /// <p>[EC2-Classic] Specify either the security group names or the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
    /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub classic_link_vpc_id: std::option::Option<std::string::String>,
    /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
    /// <p>The IDs of one or more security groups for the specified ClassicLink-enabled VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>If you specify the <code>ClassicLinkVPCId</code> parameter, you must specify this parameter.</p>
    pub classic_link_vpc_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user data to make available to the launched EC2 instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.</p>
    pub user_data: std::option::Option<std::string::String>,
    /// <p>The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping.</p>
    /// <p>To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html">Creating a launch configuration using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and <code>InstanceType</code>.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>Specifies the instance type of the EC2 instance.</p>
    /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The ID of the kernel associated with the AMI.</p>
    pub kernel_id: std::option::Option<std::string::String>,
    /// <p>The ID of the RAM disk to select.</p>
    pub ramdisk_id: std::option::Option<std::string::String>,
    /// <p>A block device mapping, which specifies the block devices for the instance. You can specify virtual devices and EBS volumes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub block_device_mappings: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
    /// <p>Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
    /// <p>The default value is <code>true</code> (enabled).</p> <important>
    /// <p>When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// </important>
    pub instance_monitoring: std::option::Option<crate::model::InstanceMonitoring>,
    /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
    /// <p>When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.</p>
    /// </note>
    pub spot_price: std::option::Option<std::string::String>,
    /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub iam_instance_profile: std::option::Option<std::string::String>,
    /// <p>Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>The default value is <code>false</code>.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>For Auto Scaling groups that are running in a virtual private cloud (VPC), specifies whether to assign a public IP address to the group's instances. If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IP address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>If you specify this parameter, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p> <note>
    /// <p>If the instance is launched into a default subnet, the default is to assign a public IP address, unless you disabled the option to assign a public IP address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IP address, unless you enabled the option to assign a public IP address on the subnet.</p>
    /// </note>
    pub associate_public_ip_address: std::option::Option<bool>,
    /// <p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.</p>
    /// <p>To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to <code>default</code>), you must set the value of this parameter to <code>dedicated</code>.</p>
    /// <p>If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring instance tenancy with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Valid Values: <code>default</code> | <code>dedicated</code> </p>
    pub placement_tenancy: std::option::Option<std::string::String>,
    /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub metadata_options: std::option::Option<crate::model::InstanceMetadataOptions>,
}
impl CreateLaunchConfigurationInput {
    /// <p>The name of the launch configuration. This name must be unique per Region per account.</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
    /// <p>The ID of the Amazon Machine Image (AMI) that was assigned during registration. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>ImageId</code>.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The name of the key pair. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.</p>
    /// <p>[EC2-VPC] Specify the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your VPC</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
    /// <p>[EC2-Classic] Specify either the security group names or the security group IDs. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security Groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
    /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn classic_link_vpc_id(&self) -> std::option::Option<&str> {
        self.classic_link_vpc_id.as_deref()
    }
    /// <p> <i>EC2-Classic retires on August 15, 2022. This parameter is not supported after that date.</i> </p>
    /// <p>The IDs of one or more security groups for the specified ClassicLink-enabled VPC. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>If you specify the <code>ClassicLinkVPCId</code> parameter, you must specify this parameter.</p>
    pub fn classic_link_vpc_security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.classic_link_vpc_security_groups.as_deref()
    }
    /// <p>The user data to make available to the launched EC2 instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text. User data is limited to 16 KB.</p>
    pub fn user_data(&self) -> std::option::Option<&str> {
        self.user_data.as_deref()
    }
    /// <p>The ID of the instance to use to create the launch configuration. The new launch configuration derives attributes from the instance, except for the block device mapping.</p>
    /// <p>To create a launch configuration with a block device mapping or override any other instance attributes, specify them as part of the same request.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html">Creating a launch configuration using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>If you do not specify <code>InstanceId</code>, you must specify both <code>ImageId</code> and <code>InstanceType</code>.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>Specifies the instance type of the EC2 instance.</p>
    /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>If you do not specify <code>InstanceId</code>, you must specify <code>InstanceType</code>.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The ID of the kernel associated with the AMI.</p>
    pub fn kernel_id(&self) -> std::option::Option<&str> {
        self.kernel_id.as_deref()
    }
    /// <p>The ID of the RAM disk to select.</p>
    pub fn ramdisk_id(&self) -> std::option::Option<&str> {
        self.ramdisk_id.as_deref()
    }
    /// <p>A block device mapping, which specifies the block devices for the instance. You can specify virtual devices and EBS volumes. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::BlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>Controls whether instances in this group are launched with detailed (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
    /// <p>The default value is <code>true</code> (enabled).</p> <important>
    /// <p>When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure Monitoring for Auto Scaling Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// </important>
    pub fn instance_monitoring(&self) -> std::option::Option<&crate::model::InstanceMonitoring> {
        self.instance_monitoring.as_ref()
    }
    /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the request. Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <note>
    /// <p>When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.</p>
    /// </note>
    pub fn spot_price(&self) -> std::option::Option<&str> {
        self.spot_price.as_deref()
    }
    /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn iam_instance_profile(&self) -> std::option::Option<&str> {
        self.iam_instance_profile.as_deref()
    }
    /// <p>Specifies whether the launch configuration is optimized for EBS I/O (<code>true</code>) or not (<code>false</code>). The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon EBS-optimized instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>The default value is <code>false</code>.</p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>For Auto Scaling groups that are running in a virtual private cloud (VPC), specifies whether to assign a public IP address to the group's instances. If you specify <code>true</code>, each instance in the Auto Scaling group receives a unique public IP address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>If you specify this parameter, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p> <note>
    /// <p>If the instance is launched into a default subnet, the default is to assign a public IP address, unless you disabled the option to assign a public IP address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IP address, unless you enabled the option to assign a public IP address on the subnet.</p>
    /// </note>
    pub fn associate_public_ip_address(&self) -> std::option::Option<bool> {
        self.associate_public_ip_address
    }
    /// <p>The tenancy of the instance. An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.</p>
    /// <p>To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to <code>default</code>), you must set the value of this parameter to <code>dedicated</code>.</p>
    /// <p>If you specify <code>PlacementTenancy</code>, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring instance tenancy with Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Valid Values: <code>default</code> | <code>dedicated</code> </p>
    pub fn placement_tenancy(&self) -> std::option::Option<&str> {
        self.placement_tenancy.as_deref()
    }
    /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn metadata_options(&self) -> std::option::Option<&crate::model::InstanceMetadataOptions> {
        self.metadata_options.as_ref()
    }
}
impl std::fmt::Debug for CreateLaunchConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLaunchConfigurationInput");
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("image_id", &self.image_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("classic_link_vpc_id", &self.classic_link_vpc_id);
        formatter.field(
            "classic_link_vpc_security_groups",
            &self.classic_link_vpc_security_groups,
        );
        formatter.field("user_data", &self.user_data);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("kernel_id", &self.kernel_id);
        formatter.field("ramdisk_id", &self.ramdisk_id);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("instance_monitoring", &self.instance_monitoring);
        formatter.field("spot_price", &self.spot_price);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field(
            "associate_public_ip_address",
            &self.associate_public_ip_address,
        );
        formatter.field("placement_tenancy", &self.placement_tenancy);
        formatter.field("metadata_options", &self.metadata_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAutoScalingGroupInput {
    /// <p>The name of the Auto Scaling group. This name must be unique per Region per account.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the launch configuration to use to launch instances. </p>
    /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>Parameters used to specify the launch template and version to use to launch instances. </p>
    /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p> <note>
    /// <p>The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// </note>
    pub launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>An embedded object that specifies a mixed instances policy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
    /// <p>The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> API operation. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The minimum size of the group.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum size of the group.</p> <note>
    /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
    /// </note>
    pub max_size: std::option::Option<i32>,
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.</p>
    pub desired_capacity: std::option::Option<i32>,
    /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
    /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Default: <code>300</code> seconds</p>
    pub default_cooldown: std::option::Option<i32>,
    /// <p>A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p>
    /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into EC2-Classic.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The service to use for the health checks. The valid values are <code>EC2</code> (default) and <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub health_check_type: std::option::Option<std::string::String>,
    /// <p> <i></i> </p>
    /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Default: <code>0</code> seconds</p>
    pub health_check_grace_period: std::option::Option<i32>,
    /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
    /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
    /// </note>
    pub placement_group: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
    /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into a VPC.</p>
    pub vpc_zone_identifier: std::option::Option<std::string::String>,
    /// <p>A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub termination_policies: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub new_instances_protected_from_scale_in: std::option::Option<bool>,
    /// <p>Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub capacity_rebalance: std::option::Option<bool>,
    /// <p>One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.</p>
    pub lifecycle_hook_specification_list:
        std::option::Option<std::vec::Vec<crate::model::LifecycleHookSpecification>>,
    /// <p>One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub service_linked_role_arn: std::option::Option<std::string::String>,
    /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub max_instance_lifetime: std::option::Option<i32>,
    /// <p>Reserved.</p>
    pub context: std::option::Option<std::string::String>,
    /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
    /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
    pub desired_capacity_type: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
    /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
    /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
    /// </important>
    /// <p>Default: None </p>
    pub default_instance_warmup: std::option::Option<i32>,
}
impl CreateAutoScalingGroupInput {
    /// <p>The name of the Auto Scaling group. This name must be unique per Region per account.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of the launch configuration to use to launch instances. </p>
    /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
    /// <p>Parameters used to specify the launch template and version to use to launch instances. </p>
    /// <p>Conditional: You must specify either a launch template (<code>LaunchTemplate</code> or <code>MixedInstancesPolicy</code>) or a launch configuration (<code>LaunchConfigurationName</code> or <code>InstanceId</code>).</p> <note>
    /// <p>The launch template that is specified must be configured for use with an Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html">Creating a launch template for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// </note>
    pub fn launch_template(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template.as_ref()
    }
    /// <p>An embedded object that specifies a mixed instances policy.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn mixed_instances_policy(
        &self,
    ) -> std::option::Option<&crate::model::MixedInstancesPolicy> {
        self.mixed_instances_policy.as_ref()
    }
    /// <p>The ID of the instance used to base the launch configuration on. If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. To get the instance ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> API operation. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto Scaling group using an EC2 instance</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The minimum size of the group.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The maximum size of the group.</p> <note>
    /// <p>With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).</p>
    /// </note>
    pub fn max_size(&self) -> std::option::Option<i32> {
        self.max_size
    }
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain. It can scale beyond this capacity if you configure auto scaling. This number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity, the default is the minimum size of the group.</p>
    pub fn desired_capacity(&self) -> std::option::Option<i32> {
        self.desired_capacity
    }
    /// <p> <i>Only needed if you use simple scaling policies.</i> </p>
    /// <p>The amount of time, in seconds, between one scaling activity ending and another one starting due to simple scaling policies. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Default: <code>300</code> seconds</p>
    pub fn default_cooldown(&self) -> std::option::Option<i32> {
        self.default_cooldown
    }
    /// <p>A list of Availability Zones where instances in the Auto Scaling group can be created. This parameter is optional if you specify one or more subnets for <code>VPCZoneIdentifier</code>.</p>
    /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into EC2-Classic.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>A list of Classic Load Balancers associated with this Auto Scaling group. For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the target groups to associate with the Auto Scaling group. Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn target_group_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.target_group_ar_ns.as_deref()
    }
    /// <p>The service to use for the health checks. The valid values are <code>EC2</code> (default) and <code>ELB</code>. If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn health_check_type(&self) -> std::option::Option<&str> {
        self.health_check_type.as_deref()
    }
    /// <p> <i></i> </p>
    /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed Elastic Load Balancing or custom health check. This is useful if your instances do not immediately pass these health checks after they enter the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period">Health check grace period</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>Default: <code>0</code> seconds</p>
    pub fn health_check_grace_period(&self) -> std::option::Option<i32> {
        self.health_check_grace_period
    }
    /// <p>The name of an existing placement group into which to launch your instances. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note>
    /// <p>A <i>cluster</i> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group. </p>
    /// </note>
    pub fn placement_group(&self) -> std::option::Option<&str> {
        self.placement_group.as_deref()
    }
    /// <p>A comma-separated list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created. If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, the subnets that you specify for this parameter must reside in those Availability Zones.</p>
    /// <p>Conditional: If your account supports EC2-Classic and VPC, this parameter is required to launch instances into a VPC.</p>
    pub fn vpc_zone_identifier(&self) -> std::option::Option<&str> {
        self.vpc_zone_identifier.as_deref()
    }
    /// <p>A policy or a list of policies that are used to select the instance to terminate. These policies are executed in the order that you list them. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn termination_policies(&self) -> std::option::Option<&[std::string::String]> {
        self.termination_policies.as_deref()
    }
    /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in. For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html">Using instance scale-in protection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn new_instances_protected_from_scale_in(&self) -> std::option::Option<bool> {
        self.new_instances_protected_from_scale_in
    }
    /// <p>Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an elevated risk of interruption. After launching a new instance, it then terminates an old instance. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn capacity_rebalance(&self) -> std::option::Option<bool> {
        self.capacity_rebalance
    }
    /// <p>One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.</p>
    pub fn lifecycle_hook_specification_list(
        &self,
    ) -> std::option::Option<&[crate::model::LifecycleHookSpecification]> {
        self.lifecycle_hook_specification_list.as_deref()
    }
    /// <p>One or more tags. You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags in a launch template but use caution. If the launch template specifies an instance tag with a key that is also specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides the value of that instance tag with the value specified by the Auto Scaling group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other Amazon Web Services on your behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role named <code>AWSServiceRoleForAutoScaling</code>, which it creates if it does not exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn service_linked_role_arn(&self) -> std::option::Option<&str> {
        self.service_linked_role_arn.as_deref()
    }
    /// <p>The maximum amount of time, in seconds, that an instance can be in service. The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn max_instance_lifetime(&self) -> std::option::Option<i32> {
        self.max_instance_lifetime
    }
    /// <p>Reserved.</p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
    /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of instances.</p>
    /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code> </p>
    pub fn desired_capacity_type(&self) -> std::option::Option<&str> {
        self.desired_capacity_type.as_deref()
    }
    /// <p>The amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the <code>InService</code> state. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html">Set the default instance warmup for an Auto Scaling group</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p> <important>
    /// <p>To manage your warm-up settings at the group level, we recommend that you set the default instance warmup, <i>even if its value is set to 0 seconds</i>. This also optimizes the performance of scaling policies that scale continuously, such as target tracking and step scaling policies. </p>
    /// <p>If you need to remove a value that you previously set, include the property but specify <code>-1</code> for the value. However, we strongly recommend keeping the default instance warmup enabled by specifying a minimum value of <code>0</code>.</p>
    /// </important>
    /// <p>Default: None </p>
    pub fn default_instance_warmup(&self) -> std::option::Option<i32> {
        self.default_instance_warmup
    }
}
impl std::fmt::Debug for CreateAutoScalingGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAutoScalingGroupInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("launch_template", &self.launch_template);
        formatter.field("mixed_instances_policy", &self.mixed_instances_policy);
        formatter.field("instance_id", &self.instance_id);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("default_cooldown", &self.default_cooldown);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.field("target_group_ar_ns", &self.target_group_ar_ns);
        formatter.field("health_check_type", &self.health_check_type);
        formatter.field("health_check_grace_period", &self.health_check_grace_period);
        formatter.field("placement_group", &self.placement_group);
        formatter.field("vpc_zone_identifier", &self.vpc_zone_identifier);
        formatter.field("termination_policies", &self.termination_policies);
        formatter.field(
            "new_instances_protected_from_scale_in",
            &self.new_instances_protected_from_scale_in,
        );
        formatter.field("capacity_rebalance", &self.capacity_rebalance);
        formatter.field(
            "lifecycle_hook_specification_list",
            &self.lifecycle_hook_specification_list,
        );
        formatter.field("tags", &self.tags);
        formatter.field("service_linked_role_arn", &self.service_linked_role_arn);
        formatter.field("max_instance_lifetime", &self.max_instance_lifetime);
        formatter.field("context", &self.context);
        formatter.field("desired_capacity_type", &self.desired_capacity_type);
        formatter.field("default_instance_warmup", &self.default_instance_warmup);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteLifecycleActionInput {
    /// <p>The name of the lifecycle hook.</p>
    pub lifecycle_hook_name: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.</p>
    pub lifecycle_action_token: std::option::Option<std::string::String>,
    /// <p>The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.</p>
    pub lifecycle_action_result: std::option::Option<std::string::String>,
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
}
impl CompleteLifecycleActionInput {
    /// <p>The name of the lifecycle hook.</p>
    pub fn lifecycle_hook_name(&self) -> std::option::Option<&str> {
        self.lifecycle_hook_name.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>A universally unique identifier (UUID) that identifies a specific lifecycle action associated with an instance. Amazon EC2 Auto Scaling sends this token to the notification target you specified when you created the lifecycle hook.</p>
    pub fn lifecycle_action_token(&self) -> std::option::Option<&str> {
        self.lifecycle_action_token.as_deref()
    }
    /// <p>The action for the group to take. This parameter can be either <code>CONTINUE</code> or <code>ABANDON</code>.</p>
    pub fn lifecycle_action_result(&self) -> std::option::Option<&str> {
        self.lifecycle_action_result.as_deref()
    }
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
}
impl std::fmt::Debug for CompleteLifecycleActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteLifecycleActionInput");
        formatter.field("lifecycle_hook_name", &self.lifecycle_hook_name);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("lifecycle_action_token", &self.lifecycle_action_token);
        formatter.field("lifecycle_action_result", &self.lifecycle_action_result);
        formatter.field("instance_id", &self.instance_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelInstanceRefreshInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
}
impl CancelInstanceRefreshInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
}
impl std::fmt::Debug for CancelInstanceRefreshInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelInstanceRefreshInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutScheduledUpdateGroupActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>One or more scheduled actions. The maximum number allowed is 50.</p>
    pub scheduled_update_group_actions:
        std::option::Option<std::vec::Vec<crate::model::ScheduledUpdateGroupActionRequest>>,
}
impl BatchPutScheduledUpdateGroupActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>One or more scheduled actions. The maximum number allowed is 50.</p>
    pub fn scheduled_update_group_actions(
        &self,
    ) -> std::option::Option<&[crate::model::ScheduledUpdateGroupActionRequest]> {
        self.scheduled_update_group_actions.as_deref()
    }
}
impl std::fmt::Debug for BatchPutScheduledUpdateGroupActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutScheduledUpdateGroupActionInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field(
            "scheduled_update_group_actions",
            &self.scheduled_update_group_actions,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteScheduledActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The names of the scheduled actions to delete. The maximum number allowed is 50. </p>
    pub scheduled_action_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDeleteScheduledActionInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The names of the scheduled actions to delete. The maximum number allowed is 50. </p>
    pub fn scheduled_action_names(&self) -> std::option::Option<&[std::string::String]> {
        self.scheduled_action_names.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteScheduledActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteScheduledActionInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("scheduled_action_names", &self.scheduled_action_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachLoadBalancerTargetGroupsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups. To get the ARN of a target group, use the Elastic Load Balancing <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AttachLoadBalancerTargetGroupsInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the target groups. You can specify up to 10 target groups. To get the ARN of a target group, use the Elastic Load Balancing <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn target_group_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.target_group_ar_ns.as_deref()
    }
}
impl std::fmt::Debug for AttachLoadBalancerTargetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachLoadBalancerTargetGroupsInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("target_group_ar_ns", &self.target_group_ar_ns);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachLoadBalancersInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AttachLoadBalancersInput {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The names of the load balancers. You can specify up to 10 load balancers.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
}
impl std::fmt::Debug for AttachLoadBalancersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachLoadBalancersInput");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachInstancesInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub instance_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
}
impl AttachInstancesInput {
    /// <p>The IDs of the instances. You can specify up to 20 instances.</p>
    pub fn instance_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_ids.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
}
impl std::fmt::Debug for AttachInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachInstancesInput");
        formatter.field("instance_ids", &self.instance_ids);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.finish()
    }
}
