// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a mixed instances policy. A mixed instances policy contains the instance
/// types that Amazon EC2 Auto Scaling can launch and other information that Amazon EC2 Auto Scaling can use to launch
/// instances and help optimize your costs. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling
/// groups with multiple instance types and purchase options</a> in the
/// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MixedInstancesPolicy {
    /// <p>Specifies the launch template to use and the instance types (overrides) that are used
    /// to launch EC2 instances to fulfill On-Demand and Spot capacities. Required when creating
    /// a mixed instances policy.</p>
    pub launch_template: std::option::Option<crate::model::LaunchTemplate>,
    /// <p>Specifies the instances distribution.</p>
    pub instances_distribution: std::option::Option<crate::model::InstancesDistribution>,
}
impl MixedInstancesPolicy {
    /// <p>Specifies the launch template to use and the instance types (overrides) that are used
    /// to launch EC2 instances to fulfill On-Demand and Spot capacities. Required when creating
    /// a mixed instances policy.</p>
    pub fn launch_template(&self) -> std::option::Option<&crate::model::LaunchTemplate> {
        self.launch_template.as_ref()
    }
    /// <p>Specifies the instances distribution.</p>
    pub fn instances_distribution(
        &self,
    ) -> std::option::Option<&crate::model::InstancesDistribution> {
        self.instances_distribution.as_ref()
    }
}
impl std::fmt::Debug for MixedInstancesPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MixedInstancesPolicy");
        formatter.field("launch_template", &self.launch_template);
        formatter.field("instances_distribution", &self.instances_distribution);
        formatter.finish()
    }
}
/// See [`MixedInstancesPolicy`](crate::model::MixedInstancesPolicy)
pub mod mixed_instances_policy {
    /// A builder for [`MixedInstancesPolicy`](crate::model::MixedInstancesPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplate>,
        pub(crate) instances_distribution: std::option::Option<crate::model::InstancesDistribution>,
    }
    impl Builder {
        /// <p>Specifies the launch template to use and the instance types (overrides) that are used
        /// to launch EC2 instances to fulfill On-Demand and Spot capacities. Required when creating
        /// a mixed instances policy.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplate) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>Specifies the launch template to use and the instance types (overrides) that are used
        /// to launch EC2 instances to fulfill On-Demand and Spot capacities. Required when creating
        /// a mixed instances policy.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplate>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// <p>Specifies the instances distribution.</p>
        pub fn instances_distribution(
            mut self,
            input: crate::model::InstancesDistribution,
        ) -> Self {
            self.instances_distribution = Some(input);
            self
        }
        /// <p>Specifies the instances distribution.</p>
        pub fn set_instances_distribution(
            mut self,
            input: std::option::Option<crate::model::InstancesDistribution>,
        ) -> Self {
            self.instances_distribution = input;
            self
        }
        /// Consumes the builder and constructs a [`MixedInstancesPolicy`](crate::model::MixedInstancesPolicy)
        pub fn build(self) -> crate::model::MixedInstancesPolicy {
            crate::model::MixedInstancesPolicy {
                launch_template: self.launch_template,
                instances_distribution: self.instances_distribution,
            }
        }
    }
}
impl MixedInstancesPolicy {
    /// Creates a new builder-style object to manufacture [`MixedInstancesPolicy`](crate::model::MixedInstancesPolicy)
    pub fn builder() -> crate::model::mixed_instances_policy::Builder {
        crate::model::mixed_instances_policy::Builder::default()
    }
}

/// <p>Describes an instances distribution for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstancesDistribution {
    /// <p>The order of the launch template overrides to use in fulfilling On-Demand capacity. </p>
    /// <p>If you specify <code>lowest-price</code>, Amazon EC2 Auto Scaling uses price to determine the order,
    /// launching the lowest price first. </p>
    /// <p>If you specify <code>prioritized</code>, Amazon EC2 Auto Scaling uses the priority that you assigned
    /// to each launch template override, launching the highest priority first. If all your
    /// On-Demand capacity cannot be fulfilled using your highest priority instance, then
    /// Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so
    /// on.</p>
    /// <p>Default: <code>lowest-price</code> for Auto Scaling groups that specify <a>InstanceRequirements</a> in the overrides and <code>prioritized</code> for
    /// Auto Scaling groups that don't.</p>
    pub on_demand_allocation_strategy: std::option::Option<std::string::String>,
    /// <p>The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand
    /// Instances. This base portion is launched first as your group scales.</p>
    /// <p>If you specify weights for the instance types in the overrides, the base capacity is
    /// measured in the same unit of measurement as the instance types. If you specify <a>InstanceRequirements</a> in the overrides, the base capacity is measured in
    /// the same unit of measurement as your group's desired capacity.</p>
    /// <p>Default: <code>0</code>
    /// </p>
    pub on_demand_base_capacity: std::option::Option<i32>,
    /// <p>Controls the percentages of On-Demand Instances and Spot Instances for your additional
    /// capacity beyond <code>OnDemandBaseCapacity</code>. Expressed as a number (for example,
    /// 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand
    /// Instances are used.</p>
    /// <p>Default: <code>100</code>
    /// </p>
    pub on_demand_percentage_above_base_capacity: std::option::Option<i32>,
    /// <p>Indicates how to allocate instances across Spot Instance pools. </p>
    /// <p>If the allocation strategy is <code>lowest-price</code>, the Auto Scaling group launches
    /// instances using the Spot pools with the lowest price, and evenly allocates your
    /// instances across the number of Spot pools that you specify. </p>
    /// <p>If the allocation strategy is <code>capacity-optimized</code> (recommended), the Auto Scaling
    /// group launches instances using Spot pools that are optimally chosen based on the
    /// available Spot capacity. Alternatively, you can use
    /// <code>capacity-optimized-prioritized</code> and set the order of instance types in
    /// the list of launch template overrides from highest to lowest priority (from first to
    /// last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best-effort basis
    /// but optimizes for capacity first. </p>
    /// <p>Default: <code>lowest-price</code>
    /// </p>
    pub spot_allocation_strategy: std::option::Option<std::string::String>,
    /// <p>The number of Spot Instance pools across which to allocate your Spot Instances. The
    /// Spot pools are determined from the different instance types in the overrides. Valid only
    /// when the Spot allocation strategy is <code>lowest-price</code>. Value must be in the
    /// range of 1–20.</p>
    /// <p>Default: <code>2</code>
    /// </p>
    pub spot_instance_pools: std::option::Option<i32>,
    /// <p>The maximum price per unit hour that you are willing to pay for a Spot Instance. If
    /// you keep the value at its default (unspecified), Amazon EC2 Auto Scaling uses the On-Demand price as
    /// the maximum Spot price. To remove a value that you previously set, include the property
    /// but specify an empty string ("") for the value.</p>
    pub spot_max_price: std::option::Option<std::string::String>,
}
impl InstancesDistribution {
    /// <p>The order of the launch template overrides to use in fulfilling On-Demand capacity. </p>
    /// <p>If you specify <code>lowest-price</code>, Amazon EC2 Auto Scaling uses price to determine the order,
    /// launching the lowest price first. </p>
    /// <p>If you specify <code>prioritized</code>, Amazon EC2 Auto Scaling uses the priority that you assigned
    /// to each launch template override, launching the highest priority first. If all your
    /// On-Demand capacity cannot be fulfilled using your highest priority instance, then
    /// Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so
    /// on.</p>
    /// <p>Default: <code>lowest-price</code> for Auto Scaling groups that specify <a>InstanceRequirements</a> in the overrides and <code>prioritized</code> for
    /// Auto Scaling groups that don't.</p>
    pub fn on_demand_allocation_strategy(&self) -> std::option::Option<&str> {
        self.on_demand_allocation_strategy.as_deref()
    }
    /// <p>The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand
    /// Instances. This base portion is launched first as your group scales.</p>
    /// <p>If you specify weights for the instance types in the overrides, the base capacity is
    /// measured in the same unit of measurement as the instance types. If you specify <a>InstanceRequirements</a> in the overrides, the base capacity is measured in
    /// the same unit of measurement as your group's desired capacity.</p>
    /// <p>Default: <code>0</code>
    /// </p>
    pub fn on_demand_base_capacity(&self) -> std::option::Option<i32> {
        self.on_demand_base_capacity
    }
    /// <p>Controls the percentages of On-Demand Instances and Spot Instances for your additional
    /// capacity beyond <code>OnDemandBaseCapacity</code>. Expressed as a number (for example,
    /// 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand
    /// Instances are used.</p>
    /// <p>Default: <code>100</code>
    /// </p>
    pub fn on_demand_percentage_above_base_capacity(&self) -> std::option::Option<i32> {
        self.on_demand_percentage_above_base_capacity
    }
    /// <p>Indicates how to allocate instances across Spot Instance pools. </p>
    /// <p>If the allocation strategy is <code>lowest-price</code>, the Auto Scaling group launches
    /// instances using the Spot pools with the lowest price, and evenly allocates your
    /// instances across the number of Spot pools that you specify. </p>
    /// <p>If the allocation strategy is <code>capacity-optimized</code> (recommended), the Auto Scaling
    /// group launches instances using Spot pools that are optimally chosen based on the
    /// available Spot capacity. Alternatively, you can use
    /// <code>capacity-optimized-prioritized</code> and set the order of instance types in
    /// the list of launch template overrides from highest to lowest priority (from first to
    /// last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best-effort basis
    /// but optimizes for capacity first. </p>
    /// <p>Default: <code>lowest-price</code>
    /// </p>
    pub fn spot_allocation_strategy(&self) -> std::option::Option<&str> {
        self.spot_allocation_strategy.as_deref()
    }
    /// <p>The number of Spot Instance pools across which to allocate your Spot Instances. The
    /// Spot pools are determined from the different instance types in the overrides. Valid only
    /// when the Spot allocation strategy is <code>lowest-price</code>. Value must be in the
    /// range of 1–20.</p>
    /// <p>Default: <code>2</code>
    /// </p>
    pub fn spot_instance_pools(&self) -> std::option::Option<i32> {
        self.spot_instance_pools
    }
    /// <p>The maximum price per unit hour that you are willing to pay for a Spot Instance. If
    /// you keep the value at its default (unspecified), Amazon EC2 Auto Scaling uses the On-Demand price as
    /// the maximum Spot price. To remove a value that you previously set, include the property
    /// but specify an empty string ("") for the value.</p>
    pub fn spot_max_price(&self) -> std::option::Option<&str> {
        self.spot_max_price.as_deref()
    }
}
impl std::fmt::Debug for InstancesDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstancesDistribution");
        formatter.field(
            "on_demand_allocation_strategy",
            &self.on_demand_allocation_strategy,
        );
        formatter.field("on_demand_base_capacity", &self.on_demand_base_capacity);
        formatter.field(
            "on_demand_percentage_above_base_capacity",
            &self.on_demand_percentage_above_base_capacity,
        );
        formatter.field("spot_allocation_strategy", &self.spot_allocation_strategy);
        formatter.field("spot_instance_pools", &self.spot_instance_pools);
        formatter.field("spot_max_price", &self.spot_max_price);
        formatter.finish()
    }
}
/// See [`InstancesDistribution`](crate::model::InstancesDistribution)
pub mod instances_distribution {
    /// A builder for [`InstancesDistribution`](crate::model::InstancesDistribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) on_demand_allocation_strategy: std::option::Option<std::string::String>,
        pub(crate) on_demand_base_capacity: std::option::Option<i32>,
        pub(crate) on_demand_percentage_above_base_capacity: std::option::Option<i32>,
        pub(crate) spot_allocation_strategy: std::option::Option<std::string::String>,
        pub(crate) spot_instance_pools: std::option::Option<i32>,
        pub(crate) spot_max_price: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The order of the launch template overrides to use in fulfilling On-Demand capacity. </p>
        /// <p>If you specify <code>lowest-price</code>, Amazon EC2 Auto Scaling uses price to determine the order,
        /// launching the lowest price first. </p>
        /// <p>If you specify <code>prioritized</code>, Amazon EC2 Auto Scaling uses the priority that you assigned
        /// to each launch template override, launching the highest priority first. If all your
        /// On-Demand capacity cannot be fulfilled using your highest priority instance, then
        /// Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so
        /// on.</p>
        /// <p>Default: <code>lowest-price</code> for Auto Scaling groups that specify <a>InstanceRequirements</a> in the overrides and <code>prioritized</code> for
        /// Auto Scaling groups that don't.</p>
        pub fn on_demand_allocation_strategy(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.on_demand_allocation_strategy = Some(input.into());
            self
        }
        /// <p>The order of the launch template overrides to use in fulfilling On-Demand capacity. </p>
        /// <p>If you specify <code>lowest-price</code>, Amazon EC2 Auto Scaling uses price to determine the order,
        /// launching the lowest price first. </p>
        /// <p>If you specify <code>prioritized</code>, Amazon EC2 Auto Scaling uses the priority that you assigned
        /// to each launch template override, launching the highest priority first. If all your
        /// On-Demand capacity cannot be fulfilled using your highest priority instance, then
        /// Amazon EC2 Auto Scaling launches the remaining capacity using the second priority instance type, and so
        /// on.</p>
        /// <p>Default: <code>lowest-price</code> for Auto Scaling groups that specify <a>InstanceRequirements</a> in the overrides and <code>prioritized</code> for
        /// Auto Scaling groups that don't.</p>
        pub fn set_on_demand_allocation_strategy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_allocation_strategy = input;
            self
        }
        /// <p>The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand
        /// Instances. This base portion is launched first as your group scales.</p>
        /// <p>If you specify weights for the instance types in the overrides, the base capacity is
        /// measured in the same unit of measurement as the instance types. If you specify <a>InstanceRequirements</a> in the overrides, the base capacity is measured in
        /// the same unit of measurement as your group's desired capacity.</p>
        /// <p>Default: <code>0</code>
        /// </p>
        pub fn on_demand_base_capacity(mut self, input: i32) -> Self {
            self.on_demand_base_capacity = Some(input);
            self
        }
        /// <p>The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand
        /// Instances. This base portion is launched first as your group scales.</p>
        /// <p>If you specify weights for the instance types in the overrides, the base capacity is
        /// measured in the same unit of measurement as the instance types. If you specify <a>InstanceRequirements</a> in the overrides, the base capacity is measured in
        /// the same unit of measurement as your group's desired capacity.</p>
        /// <p>Default: <code>0</code>
        /// </p>
        pub fn set_on_demand_base_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.on_demand_base_capacity = input;
            self
        }
        /// <p>Controls the percentages of On-Demand Instances and Spot Instances for your additional
        /// capacity beyond <code>OnDemandBaseCapacity</code>. Expressed as a number (for example,
        /// 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand
        /// Instances are used.</p>
        /// <p>Default: <code>100</code>
        /// </p>
        pub fn on_demand_percentage_above_base_capacity(mut self, input: i32) -> Self {
            self.on_demand_percentage_above_base_capacity = Some(input);
            self
        }
        /// <p>Controls the percentages of On-Demand Instances and Spot Instances for your additional
        /// capacity beyond <code>OnDemandBaseCapacity</code>. Expressed as a number (for example,
        /// 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to 100, only On-Demand
        /// Instances are used.</p>
        /// <p>Default: <code>100</code>
        /// </p>
        pub fn set_on_demand_percentage_above_base_capacity(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.on_demand_percentage_above_base_capacity = input;
            self
        }
        /// <p>Indicates how to allocate instances across Spot Instance pools. </p>
        /// <p>If the allocation strategy is <code>lowest-price</code>, the Auto Scaling group launches
        /// instances using the Spot pools with the lowest price, and evenly allocates your
        /// instances across the number of Spot pools that you specify. </p>
        /// <p>If the allocation strategy is <code>capacity-optimized</code> (recommended), the Auto Scaling
        /// group launches instances using Spot pools that are optimally chosen based on the
        /// available Spot capacity. Alternatively, you can use
        /// <code>capacity-optimized-prioritized</code> and set the order of instance types in
        /// the list of launch template overrides from highest to lowest priority (from first to
        /// last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best-effort basis
        /// but optimizes for capacity first. </p>
        /// <p>Default: <code>lowest-price</code>
        /// </p>
        pub fn spot_allocation_strategy(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_allocation_strategy = Some(input.into());
            self
        }
        /// <p>Indicates how to allocate instances across Spot Instance pools. </p>
        /// <p>If the allocation strategy is <code>lowest-price</code>, the Auto Scaling group launches
        /// instances using the Spot pools with the lowest price, and evenly allocates your
        /// instances across the number of Spot pools that you specify. </p>
        /// <p>If the allocation strategy is <code>capacity-optimized</code> (recommended), the Auto Scaling
        /// group launches instances using Spot pools that are optimally chosen based on the
        /// available Spot capacity. Alternatively, you can use
        /// <code>capacity-optimized-prioritized</code> and set the order of instance types in
        /// the list of launch template overrides from highest to lowest priority (from first to
        /// last in the list). Amazon EC2 Auto Scaling honors the instance type priorities on a best-effort basis
        /// but optimizes for capacity first. </p>
        /// <p>Default: <code>lowest-price</code>
        /// </p>
        pub fn set_spot_allocation_strategy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spot_allocation_strategy = input;
            self
        }
        /// <p>The number of Spot Instance pools across which to allocate your Spot Instances. The
        /// Spot pools are determined from the different instance types in the overrides. Valid only
        /// when the Spot allocation strategy is <code>lowest-price</code>. Value must be in the
        /// range of 1–20.</p>
        /// <p>Default: <code>2</code>
        /// </p>
        pub fn spot_instance_pools(mut self, input: i32) -> Self {
            self.spot_instance_pools = Some(input);
            self
        }
        /// <p>The number of Spot Instance pools across which to allocate your Spot Instances. The
        /// Spot pools are determined from the different instance types in the overrides. Valid only
        /// when the Spot allocation strategy is <code>lowest-price</code>. Value must be in the
        /// range of 1–20.</p>
        /// <p>Default: <code>2</code>
        /// </p>
        pub fn set_spot_instance_pools(mut self, input: std::option::Option<i32>) -> Self {
            self.spot_instance_pools = input;
            self
        }
        /// <p>The maximum price per unit hour that you are willing to pay for a Spot Instance. If
        /// you keep the value at its default (unspecified), Amazon EC2 Auto Scaling uses the On-Demand price as
        /// the maximum Spot price. To remove a value that you previously set, include the property
        /// but specify an empty string ("") for the value.</p>
        pub fn spot_max_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_max_price = Some(input.into());
            self
        }
        /// <p>The maximum price per unit hour that you are willing to pay for a Spot Instance. If
        /// you keep the value at its default (unspecified), Amazon EC2 Auto Scaling uses the On-Demand price as
        /// the maximum Spot price. To remove a value that you previously set, include the property
        /// but specify an empty string ("") for the value.</p>
        pub fn set_spot_max_price(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spot_max_price = input;
            self
        }
        /// Consumes the builder and constructs a [`InstancesDistribution`](crate::model::InstancesDistribution)
        pub fn build(self) -> crate::model::InstancesDistribution {
            crate::model::InstancesDistribution {
                on_demand_allocation_strategy: self.on_demand_allocation_strategy,
                on_demand_base_capacity: self.on_demand_base_capacity,
                on_demand_percentage_above_base_capacity: self
                    .on_demand_percentage_above_base_capacity,
                spot_allocation_strategy: self.spot_allocation_strategy,
                spot_instance_pools: self.spot_instance_pools,
                spot_max_price: self.spot_max_price,
            }
        }
    }
}
impl InstancesDistribution {
    /// Creates a new builder-style object to manufacture [`InstancesDistribution`](crate::model::InstancesDistribution)
    pub fn builder() -> crate::model::instances_distribution::Builder {
        crate::model::instances_distribution::Builder::default()
    }
}

/// <p>Describes a launch template and overrides. You specify these properties as part of a
/// mixed instances policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplate {
    /// <p>The launch template to use.</p>
    pub launch_template_specification:
        std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>Any properties that you specify override the same properties in the launch template.
    /// If not provided, Amazon EC2 Auto Scaling uses the instance type or instance type requirements specified
    /// in the launch template when it launches an instance.</p>
    /// <p>The overrides can include either one or more instance types or a set of instance
    /// requirements, but not both.</p>
    pub overrides: std::option::Option<std::vec::Vec<crate::model::LaunchTemplateOverrides>>,
}
impl LaunchTemplate {
    /// <p>The launch template to use.</p>
    pub fn launch_template_specification(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template_specification.as_ref()
    }
    /// <p>Any properties that you specify override the same properties in the launch template.
    /// If not provided, Amazon EC2 Auto Scaling uses the instance type or instance type requirements specified
    /// in the launch template when it launches an instance.</p>
    /// <p>The overrides can include either one or more instance types or a set of instance
    /// requirements, but not both.</p>
    pub fn overrides(&self) -> std::option::Option<&[crate::model::LaunchTemplateOverrides]> {
        self.overrides.as_deref()
    }
}
impl std::fmt::Debug for LaunchTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplate");
        formatter.field(
            "launch_template_specification",
            &self.launch_template_specification,
        );
        formatter.field("overrides", &self.overrides);
        formatter.finish()
    }
}
/// See [`LaunchTemplate`](crate::model::LaunchTemplate)
pub mod launch_template {
    /// A builder for [`LaunchTemplate`](crate::model::LaunchTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_template_specification:
            std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) overrides:
            std::option::Option<std::vec::Vec<crate::model::LaunchTemplateOverrides>>,
    }
    impl Builder {
        /// <p>The launch template to use.</p>
        pub fn launch_template_specification(
            mut self,
            input: crate::model::LaunchTemplateSpecification,
        ) -> Self {
            self.launch_template_specification = Some(input);
            self
        }
        /// <p>The launch template to use.</p>
        pub fn set_launch_template_specification(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template_specification = input;
            self
        }
        /// Appends an item to `overrides`.
        ///
        /// To override the contents of this collection use [`set_overrides`](Self::set_overrides).
        ///
        /// <p>Any properties that you specify override the same properties in the launch template.
        /// If not provided, Amazon EC2 Auto Scaling uses the instance type or instance type requirements specified
        /// in the launch template when it launches an instance.</p>
        /// <p>The overrides can include either one or more instance types or a set of instance
        /// requirements, but not both.</p>
        pub fn overrides(
            mut self,
            input: impl Into<crate::model::LaunchTemplateOverrides>,
        ) -> Self {
            let mut v = self.overrides.unwrap_or_default();
            v.push(input.into());
            self.overrides = Some(v);
            self
        }
        /// <p>Any properties that you specify override the same properties in the launch template.
        /// If not provided, Amazon EC2 Auto Scaling uses the instance type or instance type requirements specified
        /// in the launch template when it launches an instance.</p>
        /// <p>The overrides can include either one or more instance types or a set of instance
        /// requirements, but not both.</p>
        pub fn set_overrides(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LaunchTemplateOverrides>>,
        ) -> Self {
            self.overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplate`](crate::model::LaunchTemplate)
        pub fn build(self) -> crate::model::LaunchTemplate {
            crate::model::LaunchTemplate {
                launch_template_specification: self.launch_template_specification,
                overrides: self.overrides,
            }
        }
    }
}
impl LaunchTemplate {
    /// Creates a new builder-style object to manufacture [`LaunchTemplate`](crate::model::LaunchTemplate)
    pub fn builder() -> crate::model::launch_template::Builder {
        crate::model::launch_template::Builder::default()
    }
}

/// <p>Describes an override for a launch template. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-override-options.html">Configuring overrides</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplateOverrides {
    /// <p>The instance type, such as <code>m3.xlarge</code>. You must use an instance type that
    /// is supported in your requested Region and Availability Zones. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon Elastic Compute Cloud User
    /// Guide</i>.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The number of capacity units provided by the instance type specified in
    /// <code>InstanceType</code> in terms of virtual CPUs, memory, storage, throughput, or
    /// other relative performance characteristic. When a Spot or On-Demand Instance is
    /// launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches
    /// instances until the desired capacity is totally fulfilled, even if this results in an
    /// overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling
    /// can only launch an instance with a <code>WeightedCapacity</code> of five units, the
    /// instance is launched, and the desired capacity is exceeded by three units. For more
    /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance weighting for
    /// Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the
    /// range of 1–999.</p>
    pub weighted_capacity: std::option::Option<std::string::String>,
    /// <p>Provides the launch template to be used when launching the instance type specified in
    /// <code>InstanceType</code>. For example, some instance types might require a launch
    /// template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's
    /// defined for your mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">Specifying a
    /// different launch template for an instance type</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
    pub launch_template_specification:
        std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds
    /// instance types that satisfy your requirements, and then uses your On-Demand and Spot
    /// allocation strategies to launch instances from these instance types, in the same way as
    /// when you specify a list of specific instance types. </p>
    pub instance_requirements: std::option::Option<crate::model::InstanceRequirements>,
}
impl LaunchTemplateOverrides {
    /// <p>The instance type, such as <code>m3.xlarge</code>. You must use an instance type that
    /// is supported in your requested Region and Availability Zones. For more information, see
    /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon Elastic Compute Cloud User
    /// Guide</i>.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The number of capacity units provided by the instance type specified in
    /// <code>InstanceType</code> in terms of virtual CPUs, memory, storage, throughput, or
    /// other relative performance characteristic. When a Spot or On-Demand Instance is
    /// launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches
    /// instances until the desired capacity is totally fulfilled, even if this results in an
    /// overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling
    /// can only launch an instance with a <code>WeightedCapacity</code> of five units, the
    /// instance is launched, and the desired capacity is exceeded by three units. For more
    /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance weighting for
    /// Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the
    /// range of 1–999.</p>
    pub fn weighted_capacity(&self) -> std::option::Option<&str> {
        self.weighted_capacity.as_deref()
    }
    /// <p>Provides the launch template to be used when launching the instance type specified in
    /// <code>InstanceType</code>. For example, some instance types might require a launch
    /// template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's
    /// defined for your mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">Specifying a
    /// different launch template for an instance type</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
    pub fn launch_template_specification(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template_specification.as_ref()
    }
    /// <p>The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds
    /// instance types that satisfy your requirements, and then uses your On-Demand and Spot
    /// allocation strategies to launch instances from these instance types, in the same way as
    /// when you specify a list of specific instance types. </p>
    pub fn instance_requirements(
        &self,
    ) -> std::option::Option<&crate::model::InstanceRequirements> {
        self.instance_requirements.as_ref()
    }
}
impl std::fmt::Debug for LaunchTemplateOverrides {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplateOverrides");
        formatter.field("instance_type", &self.instance_type);
        formatter.field("weighted_capacity", &self.weighted_capacity);
        formatter.field(
            "launch_template_specification",
            &self.launch_template_specification,
        );
        formatter.field("instance_requirements", &self.instance_requirements);
        formatter.finish()
    }
}
/// See [`LaunchTemplateOverrides`](crate::model::LaunchTemplateOverrides)
pub mod launch_template_overrides {
    /// A builder for [`LaunchTemplateOverrides`](crate::model::LaunchTemplateOverrides)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) weighted_capacity: std::option::Option<std::string::String>,
        pub(crate) launch_template_specification:
            std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) instance_requirements: std::option::Option<crate::model::InstanceRequirements>,
    }
    impl Builder {
        /// <p>The instance type, such as <code>m3.xlarge</code>. You must use an instance type that
        /// is supported in your requested Region and Availability Zones. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon Elastic Compute Cloud User
        /// Guide</i>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type, such as <code>m3.xlarge</code>. You must use an instance type that
        /// is supported in your requested Region and Availability Zones. For more information, see
        /// <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the <i>Amazon Elastic Compute Cloud User
        /// Guide</i>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The number of capacity units provided by the instance type specified in
        /// <code>InstanceType</code> in terms of virtual CPUs, memory, storage, throughput, or
        /// other relative performance characteristic. When a Spot or On-Demand Instance is
        /// launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches
        /// instances until the desired capacity is totally fulfilled, even if this results in an
        /// overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling
        /// can only launch an instance with a <code>WeightedCapacity</code> of five units, the
        /// instance is launched, and the desired capacity is exceeded by three units. For more
        /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance weighting for
        /// Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the
        /// range of 1–999.</p>
        pub fn weighted_capacity(mut self, input: impl Into<std::string::String>) -> Self {
            self.weighted_capacity = Some(input.into());
            self
        }
        /// <p>The number of capacity units provided by the instance type specified in
        /// <code>InstanceType</code> in terms of virtual CPUs, memory, storage, throughput, or
        /// other relative performance characteristic. When a Spot or On-Demand Instance is
        /// launched, the capacity units count toward the desired capacity. Amazon EC2 Auto Scaling launches
        /// instances until the desired capacity is totally fulfilled, even if this results in an
        /// overage. For example, if there are two units remaining to fulfill capacity, and Amazon EC2 Auto Scaling
        /// can only launch an instance with a <code>WeightedCapacity</code> of five units, the
        /// instance is launched, and the desired capacity is exceeded by three units. For more
        /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html">Instance weighting for
        /// Amazon EC2 Auto Scaling</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. Value must be in the
        /// range of 1–999.</p>
        pub fn set_weighted_capacity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weighted_capacity = input;
            self
        }
        /// <p>Provides the launch template to be used when launching the instance type specified in
        /// <code>InstanceType</code>. For example, some instance types might require a launch
        /// template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's
        /// defined for your mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">Specifying a
        /// different launch template for an instance type</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
        pub fn launch_template_specification(
            mut self,
            input: crate::model::LaunchTemplateSpecification,
        ) -> Self {
            self.launch_template_specification = Some(input);
            self
        }
        /// <p>Provides the launch template to be used when launching the instance type specified in
        /// <code>InstanceType</code>. For example, some instance types might require a launch
        /// template with a different AMI. If not provided, Amazon EC2 Auto Scaling uses the launch template that's
        /// defined for your mixed instances policy. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-template-overrides.html">Specifying a
        /// different launch template for an instance type</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
        pub fn set_launch_template_specification(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template_specification = input;
            self
        }
        /// <p>The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds
        /// instance types that satisfy your requirements, and then uses your On-Demand and Spot
        /// allocation strategies to launch instances from these instance types, in the same way as
        /// when you specify a list of specific instance types. </p>
        pub fn instance_requirements(mut self, input: crate::model::InstanceRequirements) -> Self {
            self.instance_requirements = Some(input);
            self
        }
        /// <p>The instance requirements. When you specify instance requirements, Amazon EC2 Auto Scaling finds
        /// instance types that satisfy your requirements, and then uses your On-Demand and Spot
        /// allocation strategies to launch instances from these instance types, in the same way as
        /// when you specify a list of specific instance types. </p>
        pub fn set_instance_requirements(
            mut self,
            input: std::option::Option<crate::model::InstanceRequirements>,
        ) -> Self {
            self.instance_requirements = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplateOverrides`](crate::model::LaunchTemplateOverrides)
        pub fn build(self) -> crate::model::LaunchTemplateOverrides {
            crate::model::LaunchTemplateOverrides {
                instance_type: self.instance_type,
                weighted_capacity: self.weighted_capacity,
                launch_template_specification: self.launch_template_specification,
                instance_requirements: self.instance_requirements,
            }
        }
    }
}
impl LaunchTemplateOverrides {
    /// Creates a new builder-style object to manufacture [`LaunchTemplateOverrides`](crate::model::LaunchTemplateOverrides)
    pub fn builder() -> crate::model::launch_template_overrides::Builder {
        crate::model::launch_template_overrides::Builder::default()
    }
}

/// <p>When you specify multiple parameters, you get instance types that satisfy all of the
/// specified parameters. If you specify multiple values for a parameter, you get instance
/// types that satisfy any of the specified values.</p>
///
///
/// <p>Represents requirements for the types of instances that can be launched. You
/// must specify <code>VCpuCount</code> and <code>MemoryMiB</code>, but all other parameters
/// are optional. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating
/// an Auto Scaling group using attribute-based instance type selection</a> in the
/// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRequirements {
    /// <p>The minimum and maximum number of vCPUs for an instance type.</p>
    pub v_cpu_count: std::option::Option<crate::model::VCpuCountRequest>,
    /// <p>The minimum and maximum instance memory size for an instance type, in MiB.</p>
    pub memory_mi_b: std::option::Option<crate::model::MemoryMiBRequest>,
    /// <p>Lists which specific CPU manufacturers to include.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with Intel CPUs, specify <code>intel</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with AMD CPUs, specify <code>amd</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Amazon Web Services CPUs, specify
    /// <code>amazon-web-services</code>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Don't confuse the CPU hardware manufacturer with the CPU hardware architecture.
    /// Instances will be launched with a compatible CPU architecture based on the Amazon
    /// Machine Image (AMI) that you specify in your launch template. </p>
    /// </note>
    /// <p>Default: Any manufacturer</p>
    pub cpu_manufacturers: std::option::Option<std::vec::Vec<crate::model::CpuManufacturer>>,
    /// <p>The minimum and maximum amount of memory per vCPU for an instance type, in GiB.</p>
    /// <p>Default: No minimum or maximum</p>
    pub memory_gi_b_per_v_cpu: std::option::Option<crate::model::MemoryGiBPerVCpuRequest>,
    /// <p>Lists which instance types to exclude. You can use strings with one or more wild
    /// cards, represented by an asterisk (<code>*</code>). The following are examples:
    /// <code>c5*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>. </p>
    /// <p>For example, if you specify <code>c5*</code>, you are excluding the entire C5 instance
    /// family, which includes all C5a and C5n instance types. If you specify
    /// <code>m5a.*</code>, you are excluding all the M5a instance types, but not the M5n
    /// instance types.</p>
    /// <p>Default: No excluded instance types</p>
    pub excluded_instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether current or previous generation instance types are included.</p>
    /// <ul>
    /// <li>
    /// <p>For current generation instance types, specify <code>current</code>. The
    /// current generation includes EC2 instance types currently recommended for use.
    /// This typically includes the latest two to three generations in each instance
    /// family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
    /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// </li>
    /// <li>
    /// <p>For previous generation instance types, specify <code>previous</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any current or previous generation</p>
    pub instance_generations: std::option::Option<std::vec::Vec<crate::model::InstanceGeneration>>,
    /// <p>The price protection threshold for Spot Instances. This is the maximum you’ll pay for
    /// a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance
    /// type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your
    /// attributes, we will exclude instance types whose price is higher than your threshold.
    /// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off
    /// price protection, specify a high value, such as <code>999999</code>. </p>
    /// <p>Default: <code>100</code>
    /// </p>
    pub spot_max_price_percentage_over_lowest_price: std::option::Option<i32>,
    /// <p>The price protection threshold for On-Demand Instances. This is the maximum you’ll pay
    /// for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R
    /// instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with
    /// your attributes, we will exclude instance types whose price is higher than your
    /// threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
    /// To turn off price protection, specify a high value, such as <code>999999</code>. </p>
    /// <p>Default: <code>20</code>
    /// </p>
    pub on_demand_max_price_percentage_over_lowest_price: std::option::Option<i32>,
    /// <p>Indicates whether bare metal instance types are included, excluded, or
    /// required.</p>
    /// <p>Default: <code>excluded</code>
    /// </p>
    pub bare_metal: std::option::Option<crate::model::BareMetal>,
    /// <p>Indicates whether burstable performance instance types are included, excluded, or
    /// required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
    /// performance instances</a> in the <i>Amazon EC2 User Guide for Linux
    /// Instances</i>.</p>
    /// <p>Default: <code>excluded</code>
    /// </p>
    pub burstable_performance: std::option::Option<crate::model::BurstablePerformance>,
    /// <p>Indicates whether instance types must provide On-Demand Instance hibernation
    /// support.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub require_hibernate_support: std::option::Option<bool>,
    /// <p>The minimum and maximum number of network interfaces for an instance type.</p>
    /// <p>Default: No minimum or maximum</p>
    pub network_interface_count: std::option::Option<crate::model::NetworkInterfaceCountRequest>,
    /// <p>Indicates whether instance types with instance store volumes are included, excluded,
    /// or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in
    /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>Default: <code>included</code>
    /// </p>
    pub local_storage: std::option::Option<crate::model::LocalStorage>,
    /// <p>Indicates the type of local storage that is required.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with hard disk drive (HDD) storage, specify
    /// <code>hdd</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with solid state drive (SSD) storage, specify
    /// <code>sdd</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any local storage type</p>
    pub local_storage_types: std::option::Option<std::vec::Vec<crate::model::LocalStorageType>>,
    /// <p>The minimum and maximum total local storage size for an instance type, in GB.</p>
    /// <p>Default: No minimum or maximum</p>
    pub total_local_storage_gb: std::option::Option<crate::model::TotalLocalStorageGbRequest>,
    /// <p>The minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
    /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a>
    /// in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>Default: No minimum or maximum</p>
    pub baseline_ebs_bandwidth_mbps:
        std::option::Option<crate::model::BaselineEbsBandwidthMbpsRequest>,
    /// <p>Lists the accelerator types that must be on an instance type.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with GPU accelerators, specify <code>gpu</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with FPGA accelerators, specify <code>fpga</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with inference accelerators, specify
    /// <code>inference</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any accelerator type</p>
    pub accelerator_types: std::option::Option<std::vec::Vec<crate::model::AcceleratorType>>,
    /// <p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia
    /// chips) for an instance type.</p>
    /// <p>To exclude accelerator-enabled instance types, set <code>Max</code> to
    /// <code>0</code>.</p>
    /// <p>Default: No minimum or maximum</p>
    pub accelerator_count: std::option::Option<crate::model::AcceleratorCountRequest>,
    /// <p>Indicates whether instance types must have accelerators by specific
    /// manufacturers.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with NVIDIA devices, specify <code>nvidia</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with AMD devices, specify <code>amd</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Amazon Web Services devices, specify
    /// <code>amazon-web-services</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Xilinx devices, specify <code>xilinx</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any manufacturer</p>
    pub accelerator_manufacturers:
        std::option::Option<std::vec::Vec<crate::model::AcceleratorManufacturer>>,
    /// <p>Lists the accelerators that must be on an instance type.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with NVIDIA A100 GPUs, specify <code>a100</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA V100 GPUs, specify <code>v100</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA K80 GPUs, specify <code>k80</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA T4 GPUs, specify <code>t4</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA M60 GPUs, specify <code>m60</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with AMD Radeon Pro V520 GPUs, specify
    /// <code>radeon-pro-v520</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any accelerator</p>
    pub accelerator_names: std::option::Option<std::vec::Vec<crate::model::AcceleratorName>>,
    /// <p>The minimum and maximum total memory size for the accelerators on an instance type, in
    /// MiB.</p>
    /// <p>Default: No minimum or maximum</p>
    pub accelerator_total_memory_mi_b:
        std::option::Option<crate::model::AcceleratorTotalMemoryMiBRequest>,
}
impl InstanceRequirements {
    /// <p>The minimum and maximum number of vCPUs for an instance type.</p>
    pub fn v_cpu_count(&self) -> std::option::Option<&crate::model::VCpuCountRequest> {
        self.v_cpu_count.as_ref()
    }
    /// <p>The minimum and maximum instance memory size for an instance type, in MiB.</p>
    pub fn memory_mi_b(&self) -> std::option::Option<&crate::model::MemoryMiBRequest> {
        self.memory_mi_b.as_ref()
    }
    /// <p>Lists which specific CPU manufacturers to include.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with Intel CPUs, specify <code>intel</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with AMD CPUs, specify <code>amd</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Amazon Web Services CPUs, specify
    /// <code>amazon-web-services</code>.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Don't confuse the CPU hardware manufacturer with the CPU hardware architecture.
    /// Instances will be launched with a compatible CPU architecture based on the Amazon
    /// Machine Image (AMI) that you specify in your launch template. </p>
    /// </note>
    /// <p>Default: Any manufacturer</p>
    pub fn cpu_manufacturers(&self) -> std::option::Option<&[crate::model::CpuManufacturer]> {
        self.cpu_manufacturers.as_deref()
    }
    /// <p>The minimum and maximum amount of memory per vCPU for an instance type, in GiB.</p>
    /// <p>Default: No minimum or maximum</p>
    pub fn memory_gi_b_per_v_cpu(
        &self,
    ) -> std::option::Option<&crate::model::MemoryGiBPerVCpuRequest> {
        self.memory_gi_b_per_v_cpu.as_ref()
    }
    /// <p>Lists which instance types to exclude. You can use strings with one or more wild
    /// cards, represented by an asterisk (<code>*</code>). The following are examples:
    /// <code>c5*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>. </p>
    /// <p>For example, if you specify <code>c5*</code>, you are excluding the entire C5 instance
    /// family, which includes all C5a and C5n instance types. If you specify
    /// <code>m5a.*</code>, you are excluding all the M5a instance types, but not the M5n
    /// instance types.</p>
    /// <p>Default: No excluded instance types</p>
    pub fn excluded_instance_types(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_instance_types.as_deref()
    }
    /// <p>Indicates whether current or previous generation instance types are included.</p>
    /// <ul>
    /// <li>
    /// <p>For current generation instance types, specify <code>current</code>. The
    /// current generation includes EC2 instance types currently recommended for use.
    /// This typically includes the latest two to three generations in each instance
    /// family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
    /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// </li>
    /// <li>
    /// <p>For previous generation instance types, specify <code>previous</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any current or previous generation</p>
    pub fn instance_generations(&self) -> std::option::Option<&[crate::model::InstanceGeneration]> {
        self.instance_generations.as_deref()
    }
    /// <p>The price protection threshold for Spot Instances. This is the maximum you’ll pay for
    /// a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance
    /// type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your
    /// attributes, we will exclude instance types whose price is higher than your threshold.
    /// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off
    /// price protection, specify a high value, such as <code>999999</code>. </p>
    /// <p>Default: <code>100</code>
    /// </p>
    pub fn spot_max_price_percentage_over_lowest_price(&self) -> std::option::Option<i32> {
        self.spot_max_price_percentage_over_lowest_price
    }
    /// <p>The price protection threshold for On-Demand Instances. This is the maximum you’ll pay
    /// for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R
    /// instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with
    /// your attributes, we will exclude instance types whose price is higher than your
    /// threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
    /// To turn off price protection, specify a high value, such as <code>999999</code>. </p>
    /// <p>Default: <code>20</code>
    /// </p>
    pub fn on_demand_max_price_percentage_over_lowest_price(&self) -> std::option::Option<i32> {
        self.on_demand_max_price_percentage_over_lowest_price
    }
    /// <p>Indicates whether bare metal instance types are included, excluded, or
    /// required.</p>
    /// <p>Default: <code>excluded</code>
    /// </p>
    pub fn bare_metal(&self) -> std::option::Option<&crate::model::BareMetal> {
        self.bare_metal.as_ref()
    }
    /// <p>Indicates whether burstable performance instance types are included, excluded, or
    /// required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
    /// performance instances</a> in the <i>Amazon EC2 User Guide for Linux
    /// Instances</i>.</p>
    /// <p>Default: <code>excluded</code>
    /// </p>
    pub fn burstable_performance(
        &self,
    ) -> std::option::Option<&crate::model::BurstablePerformance> {
        self.burstable_performance.as_ref()
    }
    /// <p>Indicates whether instance types must provide On-Demand Instance hibernation
    /// support.</p>
    /// <p>Default: <code>false</code>
    /// </p>
    pub fn require_hibernate_support(&self) -> std::option::Option<bool> {
        self.require_hibernate_support
    }
    /// <p>The minimum and maximum number of network interfaces for an instance type.</p>
    /// <p>Default: No minimum or maximum</p>
    pub fn network_interface_count(
        &self,
    ) -> std::option::Option<&crate::model::NetworkInterfaceCountRequest> {
        self.network_interface_count.as_ref()
    }
    /// <p>Indicates whether instance types with instance store volumes are included, excluded,
    /// or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in
    /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>Default: <code>included</code>
    /// </p>
    pub fn local_storage(&self) -> std::option::Option<&crate::model::LocalStorage> {
        self.local_storage.as_ref()
    }
    /// <p>Indicates the type of local storage that is required.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with hard disk drive (HDD) storage, specify
    /// <code>hdd</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with solid state drive (SSD) storage, specify
    /// <code>sdd</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any local storage type</p>
    pub fn local_storage_types(&self) -> std::option::Option<&[crate::model::LocalStorageType]> {
        self.local_storage_types.as_deref()
    }
    /// <p>The minimum and maximum total local storage size for an instance type, in GB.</p>
    /// <p>Default: No minimum or maximum</p>
    pub fn total_local_storage_gb(
        &self,
    ) -> std::option::Option<&crate::model::TotalLocalStorageGbRequest> {
        self.total_local_storage_gb.as_ref()
    }
    /// <p>The minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
    /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a>
    /// in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>Default: No minimum or maximum</p>
    pub fn baseline_ebs_bandwidth_mbps(
        &self,
    ) -> std::option::Option<&crate::model::BaselineEbsBandwidthMbpsRequest> {
        self.baseline_ebs_bandwidth_mbps.as_ref()
    }
    /// <p>Lists the accelerator types that must be on an instance type.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with GPU accelerators, specify <code>gpu</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with FPGA accelerators, specify <code>fpga</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with inference accelerators, specify
    /// <code>inference</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any accelerator type</p>
    pub fn accelerator_types(&self) -> std::option::Option<&[crate::model::AcceleratorType]> {
        self.accelerator_types.as_deref()
    }
    /// <p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia
    /// chips) for an instance type.</p>
    /// <p>To exclude accelerator-enabled instance types, set <code>Max</code> to
    /// <code>0</code>.</p>
    /// <p>Default: No minimum or maximum</p>
    pub fn accelerator_count(&self) -> std::option::Option<&crate::model::AcceleratorCountRequest> {
        self.accelerator_count.as_ref()
    }
    /// <p>Indicates whether instance types must have accelerators by specific
    /// manufacturers.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with NVIDIA devices, specify <code>nvidia</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with AMD devices, specify <code>amd</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Amazon Web Services devices, specify
    /// <code>amazon-web-services</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Xilinx devices, specify <code>xilinx</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any manufacturer</p>
    pub fn accelerator_manufacturers(
        &self,
    ) -> std::option::Option<&[crate::model::AcceleratorManufacturer]> {
        self.accelerator_manufacturers.as_deref()
    }
    /// <p>Lists the accelerators that must be on an instance type.</p>
    /// <ul>
    /// <li>
    /// <p>For instance types with NVIDIA A100 GPUs, specify <code>a100</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA V100 GPUs, specify <code>v100</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA K80 GPUs, specify <code>k80</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA T4 GPUs, specify <code>t4</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with NVIDIA M60 GPUs, specify <code>m60</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with AMD Radeon Pro V520 GPUs, specify
    /// <code>radeon-pro-v520</code>.</p>
    /// </li>
    /// <li>
    /// <p>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code>.</p>
    /// </li>
    /// </ul>
    /// <p>Default: Any accelerator</p>
    pub fn accelerator_names(&self) -> std::option::Option<&[crate::model::AcceleratorName]> {
        self.accelerator_names.as_deref()
    }
    /// <p>The minimum and maximum total memory size for the accelerators on an instance type, in
    /// MiB.</p>
    /// <p>Default: No minimum or maximum</p>
    pub fn accelerator_total_memory_mi_b(
        &self,
    ) -> std::option::Option<&crate::model::AcceleratorTotalMemoryMiBRequest> {
        self.accelerator_total_memory_mi_b.as_ref()
    }
}
impl std::fmt::Debug for InstanceRequirements {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRequirements");
        formatter.field("v_cpu_count", &self.v_cpu_count);
        formatter.field("memory_mi_b", &self.memory_mi_b);
        formatter.field("cpu_manufacturers", &self.cpu_manufacturers);
        formatter.field("memory_gi_b_per_v_cpu", &self.memory_gi_b_per_v_cpu);
        formatter.field("excluded_instance_types", &self.excluded_instance_types);
        formatter.field("instance_generations", &self.instance_generations);
        formatter.field(
            "spot_max_price_percentage_over_lowest_price",
            &self.spot_max_price_percentage_over_lowest_price,
        );
        formatter.field(
            "on_demand_max_price_percentage_over_lowest_price",
            &self.on_demand_max_price_percentage_over_lowest_price,
        );
        formatter.field("bare_metal", &self.bare_metal);
        formatter.field("burstable_performance", &self.burstable_performance);
        formatter.field("require_hibernate_support", &self.require_hibernate_support);
        formatter.field("network_interface_count", &self.network_interface_count);
        formatter.field("local_storage", &self.local_storage);
        formatter.field("local_storage_types", &self.local_storage_types);
        formatter.field("total_local_storage_gb", &self.total_local_storage_gb);
        formatter.field(
            "baseline_ebs_bandwidth_mbps",
            &self.baseline_ebs_bandwidth_mbps,
        );
        formatter.field("accelerator_types", &self.accelerator_types);
        formatter.field("accelerator_count", &self.accelerator_count);
        formatter.field("accelerator_manufacturers", &self.accelerator_manufacturers);
        formatter.field("accelerator_names", &self.accelerator_names);
        formatter.field(
            "accelerator_total_memory_mi_b",
            &self.accelerator_total_memory_mi_b,
        );
        formatter.finish()
    }
}
/// See [`InstanceRequirements`](crate::model::InstanceRequirements)
pub mod instance_requirements {
    /// A builder for [`InstanceRequirements`](crate::model::InstanceRequirements)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) v_cpu_count: std::option::Option<crate::model::VCpuCountRequest>,
        pub(crate) memory_mi_b: std::option::Option<crate::model::MemoryMiBRequest>,
        pub(crate) cpu_manufacturers:
            std::option::Option<std::vec::Vec<crate::model::CpuManufacturer>>,
        pub(crate) memory_gi_b_per_v_cpu:
            std::option::Option<crate::model::MemoryGiBPerVCpuRequest>,
        pub(crate) excluded_instance_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_generations:
            std::option::Option<std::vec::Vec<crate::model::InstanceGeneration>>,
        pub(crate) spot_max_price_percentage_over_lowest_price: std::option::Option<i32>,
        pub(crate) on_demand_max_price_percentage_over_lowest_price: std::option::Option<i32>,
        pub(crate) bare_metal: std::option::Option<crate::model::BareMetal>,
        pub(crate) burstable_performance: std::option::Option<crate::model::BurstablePerformance>,
        pub(crate) require_hibernate_support: std::option::Option<bool>,
        pub(crate) network_interface_count:
            std::option::Option<crate::model::NetworkInterfaceCountRequest>,
        pub(crate) local_storage: std::option::Option<crate::model::LocalStorage>,
        pub(crate) local_storage_types:
            std::option::Option<std::vec::Vec<crate::model::LocalStorageType>>,
        pub(crate) total_local_storage_gb:
            std::option::Option<crate::model::TotalLocalStorageGbRequest>,
        pub(crate) baseline_ebs_bandwidth_mbps:
            std::option::Option<crate::model::BaselineEbsBandwidthMbpsRequest>,
        pub(crate) accelerator_types:
            std::option::Option<std::vec::Vec<crate::model::AcceleratorType>>,
        pub(crate) accelerator_count: std::option::Option<crate::model::AcceleratorCountRequest>,
        pub(crate) accelerator_manufacturers:
            std::option::Option<std::vec::Vec<crate::model::AcceleratorManufacturer>>,
        pub(crate) accelerator_names:
            std::option::Option<std::vec::Vec<crate::model::AcceleratorName>>,
        pub(crate) accelerator_total_memory_mi_b:
            std::option::Option<crate::model::AcceleratorTotalMemoryMiBRequest>,
    }
    impl Builder {
        /// <p>The minimum and maximum number of vCPUs for an instance type.</p>
        pub fn v_cpu_count(mut self, input: crate::model::VCpuCountRequest) -> Self {
            self.v_cpu_count = Some(input);
            self
        }
        /// <p>The minimum and maximum number of vCPUs for an instance type.</p>
        pub fn set_v_cpu_count(
            mut self,
            input: std::option::Option<crate::model::VCpuCountRequest>,
        ) -> Self {
            self.v_cpu_count = input;
            self
        }
        /// <p>The minimum and maximum instance memory size for an instance type, in MiB.</p>
        pub fn memory_mi_b(mut self, input: crate::model::MemoryMiBRequest) -> Self {
            self.memory_mi_b = Some(input);
            self
        }
        /// <p>The minimum and maximum instance memory size for an instance type, in MiB.</p>
        pub fn set_memory_mi_b(
            mut self,
            input: std::option::Option<crate::model::MemoryMiBRequest>,
        ) -> Self {
            self.memory_mi_b = input;
            self
        }
        /// Appends an item to `cpu_manufacturers`.
        ///
        /// To override the contents of this collection use [`set_cpu_manufacturers`](Self::set_cpu_manufacturers).
        ///
        /// <p>Lists which specific CPU manufacturers to include.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with Intel CPUs, specify <code>intel</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with AMD CPUs, specify <code>amd</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Amazon Web Services CPUs, specify
        /// <code>amazon-web-services</code>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Don't confuse the CPU hardware manufacturer with the CPU hardware architecture.
        /// Instances will be launched with a compatible CPU architecture based on the Amazon
        /// Machine Image (AMI) that you specify in your launch template. </p>
        /// </note>
        /// <p>Default: Any manufacturer</p>
        pub fn cpu_manufacturers(
            mut self,
            input: impl Into<crate::model::CpuManufacturer>,
        ) -> Self {
            let mut v = self.cpu_manufacturers.unwrap_or_default();
            v.push(input.into());
            self.cpu_manufacturers = Some(v);
            self
        }
        /// <p>Lists which specific CPU manufacturers to include.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with Intel CPUs, specify <code>intel</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with AMD CPUs, specify <code>amd</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Amazon Web Services CPUs, specify
        /// <code>amazon-web-services</code>.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Don't confuse the CPU hardware manufacturer with the CPU hardware architecture.
        /// Instances will be launched with a compatible CPU architecture based on the Amazon
        /// Machine Image (AMI) that you specify in your launch template. </p>
        /// </note>
        /// <p>Default: Any manufacturer</p>
        pub fn set_cpu_manufacturers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CpuManufacturer>>,
        ) -> Self {
            self.cpu_manufacturers = input;
            self
        }
        /// <p>The minimum and maximum amount of memory per vCPU for an instance type, in GiB.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn memory_gi_b_per_v_cpu(
            mut self,
            input: crate::model::MemoryGiBPerVCpuRequest,
        ) -> Self {
            self.memory_gi_b_per_v_cpu = Some(input);
            self
        }
        /// <p>The minimum and maximum amount of memory per vCPU for an instance type, in GiB.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn set_memory_gi_b_per_v_cpu(
            mut self,
            input: std::option::Option<crate::model::MemoryGiBPerVCpuRequest>,
        ) -> Self {
            self.memory_gi_b_per_v_cpu = input;
            self
        }
        /// Appends an item to `excluded_instance_types`.
        ///
        /// To override the contents of this collection use [`set_excluded_instance_types`](Self::set_excluded_instance_types).
        ///
        /// <p>Lists which instance types to exclude. You can use strings with one or more wild
        /// cards, represented by an asterisk (<code>*</code>). The following are examples:
        /// <code>c5*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>. </p>
        /// <p>For example, if you specify <code>c5*</code>, you are excluding the entire C5 instance
        /// family, which includes all C5a and C5n instance types. If you specify
        /// <code>m5a.*</code>, you are excluding all the M5a instance types, but not the M5n
        /// instance types.</p>
        /// <p>Default: No excluded instance types</p>
        pub fn excluded_instance_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_instance_types.unwrap_or_default();
            v.push(input.into());
            self.excluded_instance_types = Some(v);
            self
        }
        /// <p>Lists which instance types to exclude. You can use strings with one or more wild
        /// cards, represented by an asterisk (<code>*</code>). The following are examples:
        /// <code>c5*</code>, <code>m5a.*</code>, <code>r*</code>, <code>*3*</code>. </p>
        /// <p>For example, if you specify <code>c5*</code>, you are excluding the entire C5 instance
        /// family, which includes all C5a and C5n instance types. If you specify
        /// <code>m5a.*</code>, you are excluding all the M5a instance types, but not the M5n
        /// instance types.</p>
        /// <p>Default: No excluded instance types</p>
        pub fn set_excluded_instance_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_instance_types = input;
            self
        }
        /// Appends an item to `instance_generations`.
        ///
        /// To override the contents of this collection use [`set_instance_generations`](Self::set_instance_generations).
        ///
        /// <p>Indicates whether current or previous generation instance types are included.</p>
        /// <ul>
        /// <li>
        /// <p>For current generation instance types, specify <code>current</code>. The
        /// current generation includes EC2 instance types currently recommended for use.
        /// This typically includes the latest two to three generations in each instance
        /// family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
        /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// </li>
        /// <li>
        /// <p>For previous generation instance types, specify <code>previous</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any current or previous generation</p>
        pub fn instance_generations(
            mut self,
            input: impl Into<crate::model::InstanceGeneration>,
        ) -> Self {
            let mut v = self.instance_generations.unwrap_or_default();
            v.push(input.into());
            self.instance_generations = Some(v);
            self
        }
        /// <p>Indicates whether current or previous generation instance types are included.</p>
        /// <ul>
        /// <li>
        /// <p>For current generation instance types, specify <code>current</code>. The
        /// current generation includes EC2 instance types currently recommended for use.
        /// This typically includes the latest two to three generations in each instance
        /// family. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
        /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// </li>
        /// <li>
        /// <p>For previous generation instance types, specify <code>previous</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any current or previous generation</p>
        pub fn set_instance_generations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceGeneration>>,
        ) -> Self {
            self.instance_generations = input;
            self
        }
        /// <p>The price protection threshold for Spot Instances. This is the maximum you’ll pay for
        /// a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance
        /// type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your
        /// attributes, we will exclude instance types whose price is higher than your threshold.
        /// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off
        /// price protection, specify a high value, such as <code>999999</code>. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        pub fn spot_max_price_percentage_over_lowest_price(mut self, input: i32) -> Self {
            self.spot_max_price_percentage_over_lowest_price = Some(input);
            self
        }
        /// <p>The price protection threshold for Spot Instances. This is the maximum you’ll pay for
        /// a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance
        /// type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your
        /// attributes, we will exclude instance types whose price is higher than your threshold.
        /// The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off
        /// price protection, specify a high value, such as <code>999999</code>. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        pub fn set_spot_max_price_percentage_over_lowest_price(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.spot_max_price_percentage_over_lowest_price = input;
            self
        }
        /// <p>The price protection threshold for On-Demand Instances. This is the maximum you’ll pay
        /// for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R
        /// instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with
        /// your attributes, we will exclude instance types whose price is higher than your
        /// threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
        /// To turn off price protection, specify a high value, such as <code>999999</code>. </p>
        /// <p>Default: <code>20</code>
        /// </p>
        pub fn on_demand_max_price_percentage_over_lowest_price(mut self, input: i32) -> Self {
            self.on_demand_max_price_percentage_over_lowest_price = Some(input);
            self
        }
        /// <p>The price protection threshold for On-Demand Instances. This is the maximum you’ll pay
        /// for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R
        /// instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with
        /// your attributes, we will exclude instance types whose price is higher than your
        /// threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage.
        /// To turn off price protection, specify a high value, such as <code>999999</code>. </p>
        /// <p>Default: <code>20</code>
        /// </p>
        pub fn set_on_demand_max_price_percentage_over_lowest_price(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.on_demand_max_price_percentage_over_lowest_price = input;
            self
        }
        /// <p>Indicates whether bare metal instance types are included, excluded, or
        /// required.</p>
        /// <p>Default: <code>excluded</code>
        /// </p>
        pub fn bare_metal(mut self, input: crate::model::BareMetal) -> Self {
            self.bare_metal = Some(input);
            self
        }
        /// <p>Indicates whether bare metal instance types are included, excluded, or
        /// required.</p>
        /// <p>Default: <code>excluded</code>
        /// </p>
        pub fn set_bare_metal(
            mut self,
            input: std::option::Option<crate::model::BareMetal>,
        ) -> Self {
            self.bare_metal = input;
            self
        }
        /// <p>Indicates whether burstable performance instance types are included, excluded, or
        /// required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
        /// performance instances</a> in the <i>Amazon EC2 User Guide for Linux
        /// Instances</i>.</p>
        /// <p>Default: <code>excluded</code>
        /// </p>
        pub fn burstable_performance(mut self, input: crate::model::BurstablePerformance) -> Self {
            self.burstable_performance = Some(input);
            self
        }
        /// <p>Indicates whether burstable performance instance types are included, excluded, or
        /// required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
        /// performance instances</a> in the <i>Amazon EC2 User Guide for Linux
        /// Instances</i>.</p>
        /// <p>Default: <code>excluded</code>
        /// </p>
        pub fn set_burstable_performance(
            mut self,
            input: std::option::Option<crate::model::BurstablePerformance>,
        ) -> Self {
            self.burstable_performance = input;
            self
        }
        /// <p>Indicates whether instance types must provide On-Demand Instance hibernation
        /// support.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn require_hibernate_support(mut self, input: bool) -> Self {
            self.require_hibernate_support = Some(input);
            self
        }
        /// <p>Indicates whether instance types must provide On-Demand Instance hibernation
        /// support.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_require_hibernate_support(mut self, input: std::option::Option<bool>) -> Self {
            self.require_hibernate_support = input;
            self
        }
        /// <p>The minimum and maximum number of network interfaces for an instance type.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn network_interface_count(
            mut self,
            input: crate::model::NetworkInterfaceCountRequest,
        ) -> Self {
            self.network_interface_count = Some(input);
            self
        }
        /// <p>The minimum and maximum number of network interfaces for an instance type.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn set_network_interface_count(
            mut self,
            input: std::option::Option<crate::model::NetworkInterfaceCountRequest>,
        ) -> Self {
            self.network_interface_count = input;
            self
        }
        /// <p>Indicates whether instance types with instance store volumes are included, excluded,
        /// or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in
        /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>Default: <code>included</code>
        /// </p>
        pub fn local_storage(mut self, input: crate::model::LocalStorage) -> Self {
            self.local_storage = Some(input);
            self
        }
        /// <p>Indicates whether instance types with instance store volumes are included, excluded,
        /// or required. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in
        /// the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>Default: <code>included</code>
        /// </p>
        pub fn set_local_storage(
            mut self,
            input: std::option::Option<crate::model::LocalStorage>,
        ) -> Self {
            self.local_storage = input;
            self
        }
        /// Appends an item to `local_storage_types`.
        ///
        /// To override the contents of this collection use [`set_local_storage_types`](Self::set_local_storage_types).
        ///
        /// <p>Indicates the type of local storage that is required.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with hard disk drive (HDD) storage, specify
        /// <code>hdd</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with solid state drive (SSD) storage, specify
        /// <code>sdd</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any local storage type</p>
        pub fn local_storage_types(
            mut self,
            input: impl Into<crate::model::LocalStorageType>,
        ) -> Self {
            let mut v = self.local_storage_types.unwrap_or_default();
            v.push(input.into());
            self.local_storage_types = Some(v);
            self
        }
        /// <p>Indicates the type of local storage that is required.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with hard disk drive (HDD) storage, specify
        /// <code>hdd</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with solid state drive (SSD) storage, specify
        /// <code>sdd</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any local storage type</p>
        pub fn set_local_storage_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LocalStorageType>>,
        ) -> Self {
            self.local_storage_types = input;
            self
        }
        /// <p>The minimum and maximum total local storage size for an instance type, in GB.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn total_local_storage_gb(
            mut self,
            input: crate::model::TotalLocalStorageGbRequest,
        ) -> Self {
            self.total_local_storage_gb = Some(input);
            self
        }
        /// <p>The minimum and maximum total local storage size for an instance type, in GB.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn set_total_local_storage_gb(
            mut self,
            input: std::option::Option<crate::model::TotalLocalStorageGbRequest>,
        ) -> Self {
            self.total_local_storage_gb = input;
            self
        }
        /// <p>The minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a>
        /// in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn baseline_ebs_bandwidth_mbps(
            mut self,
            input: crate::model::BaselineEbsBandwidthMbpsRequest,
        ) -> Self {
            self.baseline_ebs_bandwidth_mbps = Some(input);
            self
        }
        /// <p>The minimum and maximum baseline bandwidth performance for an instance type, in Mbps.
        /// For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS–optimized instances</a>
        /// in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn set_baseline_ebs_bandwidth_mbps(
            mut self,
            input: std::option::Option<crate::model::BaselineEbsBandwidthMbpsRequest>,
        ) -> Self {
            self.baseline_ebs_bandwidth_mbps = input;
            self
        }
        /// Appends an item to `accelerator_types`.
        ///
        /// To override the contents of this collection use [`set_accelerator_types`](Self::set_accelerator_types).
        ///
        /// <p>Lists the accelerator types that must be on an instance type.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with GPU accelerators, specify <code>gpu</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with FPGA accelerators, specify <code>fpga</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with inference accelerators, specify
        /// <code>inference</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any accelerator type</p>
        pub fn accelerator_types(
            mut self,
            input: impl Into<crate::model::AcceleratorType>,
        ) -> Self {
            let mut v = self.accelerator_types.unwrap_or_default();
            v.push(input.into());
            self.accelerator_types = Some(v);
            self
        }
        /// <p>Lists the accelerator types that must be on an instance type.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with GPU accelerators, specify <code>gpu</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with FPGA accelerators, specify <code>fpga</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with inference accelerators, specify
        /// <code>inference</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any accelerator type</p>
        pub fn set_accelerator_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AcceleratorType>>,
        ) -> Self {
            self.accelerator_types = input;
            self
        }
        /// <p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia
        /// chips) for an instance type.</p>
        /// <p>To exclude accelerator-enabled instance types, set <code>Max</code> to
        /// <code>0</code>.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn accelerator_count(mut self, input: crate::model::AcceleratorCountRequest) -> Self {
            self.accelerator_count = Some(input);
            self
        }
        /// <p>The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia
        /// chips) for an instance type.</p>
        /// <p>To exclude accelerator-enabled instance types, set <code>Max</code> to
        /// <code>0</code>.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn set_accelerator_count(
            mut self,
            input: std::option::Option<crate::model::AcceleratorCountRequest>,
        ) -> Self {
            self.accelerator_count = input;
            self
        }
        /// Appends an item to `accelerator_manufacturers`.
        ///
        /// To override the contents of this collection use [`set_accelerator_manufacturers`](Self::set_accelerator_manufacturers).
        ///
        /// <p>Indicates whether instance types must have accelerators by specific
        /// manufacturers.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with NVIDIA devices, specify <code>nvidia</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with AMD devices, specify <code>amd</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Amazon Web Services devices, specify
        /// <code>amazon-web-services</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Xilinx devices, specify <code>xilinx</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any manufacturer</p>
        pub fn accelerator_manufacturers(
            mut self,
            input: impl Into<crate::model::AcceleratorManufacturer>,
        ) -> Self {
            let mut v = self.accelerator_manufacturers.unwrap_or_default();
            v.push(input.into());
            self.accelerator_manufacturers = Some(v);
            self
        }
        /// <p>Indicates whether instance types must have accelerators by specific
        /// manufacturers.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with NVIDIA devices, specify <code>nvidia</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with AMD devices, specify <code>amd</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Amazon Web Services devices, specify
        /// <code>amazon-web-services</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Xilinx devices, specify <code>xilinx</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any manufacturer</p>
        pub fn set_accelerator_manufacturers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AcceleratorManufacturer>>,
        ) -> Self {
            self.accelerator_manufacturers = input;
            self
        }
        /// Appends an item to `accelerator_names`.
        ///
        /// To override the contents of this collection use [`set_accelerator_names`](Self::set_accelerator_names).
        ///
        /// <p>Lists the accelerators that must be on an instance type.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with NVIDIA A100 GPUs, specify <code>a100</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA V100 GPUs, specify <code>v100</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA K80 GPUs, specify <code>k80</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA T4 GPUs, specify <code>t4</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA M60 GPUs, specify <code>m60</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with AMD Radeon Pro V520 GPUs, specify
        /// <code>radeon-pro-v520</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any accelerator</p>
        pub fn accelerator_names(
            mut self,
            input: impl Into<crate::model::AcceleratorName>,
        ) -> Self {
            let mut v = self.accelerator_names.unwrap_or_default();
            v.push(input.into());
            self.accelerator_names = Some(v);
            self
        }
        /// <p>Lists the accelerators that must be on an instance type.</p>
        /// <ul>
        /// <li>
        /// <p>For instance types with NVIDIA A100 GPUs, specify <code>a100</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA V100 GPUs, specify <code>v100</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA K80 GPUs, specify <code>k80</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA T4 GPUs, specify <code>t4</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with NVIDIA M60 GPUs, specify <code>m60</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with AMD Radeon Pro V520 GPUs, specify
        /// <code>radeon-pro-v520</code>.</p>
        /// </li>
        /// <li>
        /// <p>For instance types with Xilinx VU9P FPGAs, specify <code>vu9p</code>.</p>
        /// </li>
        /// </ul>
        /// <p>Default: Any accelerator</p>
        pub fn set_accelerator_names(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AcceleratorName>>,
        ) -> Self {
            self.accelerator_names = input;
            self
        }
        /// <p>The minimum and maximum total memory size for the accelerators on an instance type, in
        /// MiB.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn accelerator_total_memory_mi_b(
            mut self,
            input: crate::model::AcceleratorTotalMemoryMiBRequest,
        ) -> Self {
            self.accelerator_total_memory_mi_b = Some(input);
            self
        }
        /// <p>The minimum and maximum total memory size for the accelerators on an instance type, in
        /// MiB.</p>
        /// <p>Default: No minimum or maximum</p>
        pub fn set_accelerator_total_memory_mi_b(
            mut self,
            input: std::option::Option<crate::model::AcceleratorTotalMemoryMiBRequest>,
        ) -> Self {
            self.accelerator_total_memory_mi_b = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRequirements`](crate::model::InstanceRequirements)
        pub fn build(self) -> crate::model::InstanceRequirements {
            crate::model::InstanceRequirements {
                v_cpu_count: self.v_cpu_count,
                memory_mi_b: self.memory_mi_b,
                cpu_manufacturers: self.cpu_manufacturers,
                memory_gi_b_per_v_cpu: self.memory_gi_b_per_v_cpu,
                excluded_instance_types: self.excluded_instance_types,
                instance_generations: self.instance_generations,
                spot_max_price_percentage_over_lowest_price: self
                    .spot_max_price_percentage_over_lowest_price,
                on_demand_max_price_percentage_over_lowest_price: self
                    .on_demand_max_price_percentage_over_lowest_price,
                bare_metal: self.bare_metal,
                burstable_performance: self.burstable_performance,
                require_hibernate_support: self.require_hibernate_support,
                network_interface_count: self.network_interface_count,
                local_storage: self.local_storage,
                local_storage_types: self.local_storage_types,
                total_local_storage_gb: self.total_local_storage_gb,
                baseline_ebs_bandwidth_mbps: self.baseline_ebs_bandwidth_mbps,
                accelerator_types: self.accelerator_types,
                accelerator_count: self.accelerator_count,
                accelerator_manufacturers: self.accelerator_manufacturers,
                accelerator_names: self.accelerator_names,
                accelerator_total_memory_mi_b: self.accelerator_total_memory_mi_b,
            }
        }
    }
}
impl InstanceRequirements {
    /// Creates a new builder-style object to manufacture [`InstanceRequirements`](crate::model::InstanceRequirements)
    pub fn builder() -> crate::model::instance_requirements::Builder {
        crate::model::instance_requirements::Builder::default()
    }
}

/// <p>Specifies the minimum and maximum for the <code>AcceleratorTotalMemoryMiB</code>
/// object when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceleratorTotalMemoryMiBRequest {
    /// <p>The memory minimum in MiB.</p>
    pub min: std::option::Option<i32>,
    /// <p>The memory maximum in MiB.</p>
    pub max: std::option::Option<i32>,
}
impl AcceleratorTotalMemoryMiBRequest {
    /// <p>The memory minimum in MiB.</p>
    pub fn min(&self) -> std::option::Option<i32> {
        self.min
    }
    /// <p>The memory maximum in MiB.</p>
    pub fn max(&self) -> std::option::Option<i32> {
        self.max
    }
}
impl std::fmt::Debug for AcceleratorTotalMemoryMiBRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceleratorTotalMemoryMiBRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`AcceleratorTotalMemoryMiBRequest`](crate::model::AcceleratorTotalMemoryMiBRequest)
pub mod accelerator_total_memory_mi_b_request {
    /// A builder for [`AcceleratorTotalMemoryMiBRequest`](crate::model::AcceleratorTotalMemoryMiBRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<i32>,
        pub(crate) max: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The memory minimum in MiB.</p>
        pub fn min(mut self, input: i32) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The memory minimum in MiB.</p>
        pub fn set_min(mut self, input: std::option::Option<i32>) -> Self {
            self.min = input;
            self
        }
        /// <p>The memory maximum in MiB.</p>
        pub fn max(mut self, input: i32) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The memory maximum in MiB.</p>
        pub fn set_max(mut self, input: std::option::Option<i32>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceleratorTotalMemoryMiBRequest`](crate::model::AcceleratorTotalMemoryMiBRequest)
        pub fn build(self) -> crate::model::AcceleratorTotalMemoryMiBRequest {
            crate::model::AcceleratorTotalMemoryMiBRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl AcceleratorTotalMemoryMiBRequest {
    /// Creates a new builder-style object to manufacture [`AcceleratorTotalMemoryMiBRequest`](crate::model::AcceleratorTotalMemoryMiBRequest)
    pub fn builder() -> crate::model::accelerator_total_memory_mi_b_request::Builder {
        crate::model::accelerator_total_memory_mi_b_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AcceleratorName {
    #[allow(missing_docs)] // documentation missing in model
    A100,
    #[allow(missing_docs)] // documentation missing in model
    K80,
    #[allow(missing_docs)] // documentation missing in model
    M60,
    #[allow(missing_docs)] // documentation missing in model
    RadeonProV520,
    #[allow(missing_docs)] // documentation missing in model
    T4,
    #[allow(missing_docs)] // documentation missing in model
    V100,
    #[allow(missing_docs)] // documentation missing in model
    Vu9P,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AcceleratorName {
    fn from(s: &str) -> Self {
        match s {
            "a100" => AcceleratorName::A100,
            "k80" => AcceleratorName::K80,
            "m60" => AcceleratorName::M60,
            "radeon-pro-v520" => AcceleratorName::RadeonProV520,
            "t4" => AcceleratorName::T4,
            "v100" => AcceleratorName::V100,
            "vu9p" => AcceleratorName::Vu9P,
            other => AcceleratorName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AcceleratorName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AcceleratorName::from(s))
    }
}
impl AcceleratorName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AcceleratorName::A100 => "a100",
            AcceleratorName::K80 => "k80",
            AcceleratorName::M60 => "m60",
            AcceleratorName::RadeonProV520 => "radeon-pro-v520",
            AcceleratorName::T4 => "t4",
            AcceleratorName::V100 => "v100",
            AcceleratorName::Vu9P => "vu9p",
            AcceleratorName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "a100",
            "k80",
            "m60",
            "radeon-pro-v520",
            "t4",
            "v100",
            "vu9p",
        ]
    }
}
impl AsRef<str> for AcceleratorName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AcceleratorManufacturer {
    #[allow(missing_docs)] // documentation missing in model
    AmazonWebServices,
    #[allow(missing_docs)] // documentation missing in model
    Amd,
    #[allow(missing_docs)] // documentation missing in model
    Nvidia,
    #[allow(missing_docs)] // documentation missing in model
    Xilinx,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AcceleratorManufacturer {
    fn from(s: &str) -> Self {
        match s {
            "amazon-web-services" => AcceleratorManufacturer::AmazonWebServices,
            "amd" => AcceleratorManufacturer::Amd,
            "nvidia" => AcceleratorManufacturer::Nvidia,
            "xilinx" => AcceleratorManufacturer::Xilinx,
            other => AcceleratorManufacturer::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AcceleratorManufacturer {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AcceleratorManufacturer::from(s))
    }
}
impl AcceleratorManufacturer {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AcceleratorManufacturer::AmazonWebServices => "amazon-web-services",
            AcceleratorManufacturer::Amd => "amd",
            AcceleratorManufacturer::Nvidia => "nvidia",
            AcceleratorManufacturer::Xilinx => "xilinx",
            AcceleratorManufacturer::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["amazon-web-services", "amd", "nvidia", "xilinx"]
    }
}
impl AsRef<str> for AcceleratorManufacturer {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the minimum and maximum for the <code>AcceleratorCount</code> object when
/// you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceleratorCountRequest {
    /// <p>The minimum value.</p>
    pub min: std::option::Option<i32>,
    /// <p>The maximum value.</p>
    pub max: std::option::Option<i32>,
}
impl AcceleratorCountRequest {
    /// <p>The minimum value.</p>
    pub fn min(&self) -> std::option::Option<i32> {
        self.min
    }
    /// <p>The maximum value.</p>
    pub fn max(&self) -> std::option::Option<i32> {
        self.max
    }
}
impl std::fmt::Debug for AcceleratorCountRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceleratorCountRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`AcceleratorCountRequest`](crate::model::AcceleratorCountRequest)
pub mod accelerator_count_request {
    /// A builder for [`AcceleratorCountRequest`](crate::model::AcceleratorCountRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<i32>,
        pub(crate) max: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum value.</p>
        pub fn min(mut self, input: i32) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The minimum value.</p>
        pub fn set_min(mut self, input: std::option::Option<i32>) -> Self {
            self.min = input;
            self
        }
        /// <p>The maximum value.</p>
        pub fn max(mut self, input: i32) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The maximum value.</p>
        pub fn set_max(mut self, input: std::option::Option<i32>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceleratorCountRequest`](crate::model::AcceleratorCountRequest)
        pub fn build(self) -> crate::model::AcceleratorCountRequest {
            crate::model::AcceleratorCountRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl AcceleratorCountRequest {
    /// Creates a new builder-style object to manufacture [`AcceleratorCountRequest`](crate::model::AcceleratorCountRequest)
    pub fn builder() -> crate::model::accelerator_count_request::Builder {
        crate::model::accelerator_count_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AcceleratorType {
    #[allow(missing_docs)] // documentation missing in model
    Fpga,
    #[allow(missing_docs)] // documentation missing in model
    Gpu,
    #[allow(missing_docs)] // documentation missing in model
    Inference,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AcceleratorType {
    fn from(s: &str) -> Self {
        match s {
            "fpga" => AcceleratorType::Fpga,
            "gpu" => AcceleratorType::Gpu,
            "inference" => AcceleratorType::Inference,
            other => AcceleratorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AcceleratorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AcceleratorType::from(s))
    }
}
impl AcceleratorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AcceleratorType::Fpga => "fpga",
            AcceleratorType::Gpu => "gpu",
            AcceleratorType::Inference => "inference",
            AcceleratorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["fpga", "gpu", "inference"]
    }
}
impl AsRef<str> for AcceleratorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the minimum and maximum for the <code>BaselineEbsBandwidthMbps</code> object
/// when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BaselineEbsBandwidthMbpsRequest {
    /// <p>The minimum value in Mbps.</p>
    pub min: std::option::Option<i32>,
    /// <p>The maximum value in Mbps.</p>
    pub max: std::option::Option<i32>,
}
impl BaselineEbsBandwidthMbpsRequest {
    /// <p>The minimum value in Mbps.</p>
    pub fn min(&self) -> std::option::Option<i32> {
        self.min
    }
    /// <p>The maximum value in Mbps.</p>
    pub fn max(&self) -> std::option::Option<i32> {
        self.max
    }
}
impl std::fmt::Debug for BaselineEbsBandwidthMbpsRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BaselineEbsBandwidthMbpsRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`BaselineEbsBandwidthMbpsRequest`](crate::model::BaselineEbsBandwidthMbpsRequest)
pub mod baseline_ebs_bandwidth_mbps_request {
    /// A builder for [`BaselineEbsBandwidthMbpsRequest`](crate::model::BaselineEbsBandwidthMbpsRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<i32>,
        pub(crate) max: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum value in Mbps.</p>
        pub fn min(mut self, input: i32) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The minimum value in Mbps.</p>
        pub fn set_min(mut self, input: std::option::Option<i32>) -> Self {
            self.min = input;
            self
        }
        /// <p>The maximum value in Mbps.</p>
        pub fn max(mut self, input: i32) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The maximum value in Mbps.</p>
        pub fn set_max(mut self, input: std::option::Option<i32>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`BaselineEbsBandwidthMbpsRequest`](crate::model::BaselineEbsBandwidthMbpsRequest)
        pub fn build(self) -> crate::model::BaselineEbsBandwidthMbpsRequest {
            crate::model::BaselineEbsBandwidthMbpsRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl BaselineEbsBandwidthMbpsRequest {
    /// Creates a new builder-style object to manufacture [`BaselineEbsBandwidthMbpsRequest`](crate::model::BaselineEbsBandwidthMbpsRequest)
    pub fn builder() -> crate::model::baseline_ebs_bandwidth_mbps_request::Builder {
        crate::model::baseline_ebs_bandwidth_mbps_request::Builder::default()
    }
}

/// <p>Specifies the minimum and maximum for the <code>TotalLocalStorageGB</code> object when
/// you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TotalLocalStorageGbRequest {
    /// <p>The storage minimum in GB.</p>
    pub min: std::option::Option<f64>,
    /// <p>The storage maximum in GB.</p>
    pub max: std::option::Option<f64>,
}
impl TotalLocalStorageGbRequest {
    /// <p>The storage minimum in GB.</p>
    pub fn min(&self) -> std::option::Option<f64> {
        self.min
    }
    /// <p>The storage maximum in GB.</p>
    pub fn max(&self) -> std::option::Option<f64> {
        self.max
    }
}
impl std::fmt::Debug for TotalLocalStorageGbRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TotalLocalStorageGbRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`TotalLocalStorageGbRequest`](crate::model::TotalLocalStorageGbRequest)
pub mod total_local_storage_gb_request {
    /// A builder for [`TotalLocalStorageGbRequest`](crate::model::TotalLocalStorageGbRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<f64>,
        pub(crate) max: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The storage minimum in GB.</p>
        pub fn min(mut self, input: f64) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The storage minimum in GB.</p>
        pub fn set_min(mut self, input: std::option::Option<f64>) -> Self {
            self.min = input;
            self
        }
        /// <p>The storage maximum in GB.</p>
        pub fn max(mut self, input: f64) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The storage maximum in GB.</p>
        pub fn set_max(mut self, input: std::option::Option<f64>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`TotalLocalStorageGbRequest`](crate::model::TotalLocalStorageGbRequest)
        pub fn build(self) -> crate::model::TotalLocalStorageGbRequest {
            crate::model::TotalLocalStorageGbRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl TotalLocalStorageGbRequest {
    /// Creates a new builder-style object to manufacture [`TotalLocalStorageGbRequest`](crate::model::TotalLocalStorageGbRequest)
    pub fn builder() -> crate::model::total_local_storage_gb_request::Builder {
        crate::model::total_local_storage_gb_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocalStorageType {
    #[allow(missing_docs)] // documentation missing in model
    Hdd,
    #[allow(missing_docs)] // documentation missing in model
    Ssd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocalStorageType {
    fn from(s: &str) -> Self {
        match s {
            "hdd" => LocalStorageType::Hdd,
            "ssd" => LocalStorageType::Ssd,
            other => LocalStorageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocalStorageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocalStorageType::from(s))
    }
}
impl LocalStorageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocalStorageType::Hdd => "hdd",
            LocalStorageType::Ssd => "ssd",
            LocalStorageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["hdd", "ssd"]
    }
}
impl AsRef<str> for LocalStorageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LocalStorage {
    #[allow(missing_docs)] // documentation missing in model
    Excluded,
    #[allow(missing_docs)] // documentation missing in model
    Included,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LocalStorage {
    fn from(s: &str) -> Self {
        match s {
            "excluded" => LocalStorage::Excluded,
            "included" => LocalStorage::Included,
            "required" => LocalStorage::Required,
            other => LocalStorage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LocalStorage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LocalStorage::from(s))
    }
}
impl LocalStorage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LocalStorage::Excluded => "excluded",
            LocalStorage::Included => "included",
            LocalStorage::Required => "required",
            LocalStorage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["excluded", "included", "required"]
    }
}
impl AsRef<str> for LocalStorage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the minimum and maximum for the <code>NetworkInterfaceCount</code> object
/// when you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterfaceCountRequest {
    /// <p>The minimum number of network interfaces.</p>
    pub min: std::option::Option<i32>,
    /// <p>The maximum number of network interfaces.</p>
    pub max: std::option::Option<i32>,
}
impl NetworkInterfaceCountRequest {
    /// <p>The minimum number of network interfaces.</p>
    pub fn min(&self) -> std::option::Option<i32> {
        self.min
    }
    /// <p>The maximum number of network interfaces.</p>
    pub fn max(&self) -> std::option::Option<i32> {
        self.max
    }
}
impl std::fmt::Debug for NetworkInterfaceCountRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterfaceCountRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`NetworkInterfaceCountRequest`](crate::model::NetworkInterfaceCountRequest)
pub mod network_interface_count_request {
    /// A builder for [`NetworkInterfaceCountRequest`](crate::model::NetworkInterfaceCountRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<i32>,
        pub(crate) max: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum number of network interfaces.</p>
        pub fn min(mut self, input: i32) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The minimum number of network interfaces.</p>
        pub fn set_min(mut self, input: std::option::Option<i32>) -> Self {
            self.min = input;
            self
        }
        /// <p>The maximum number of network interfaces.</p>
        pub fn max(mut self, input: i32) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The maximum number of network interfaces.</p>
        pub fn set_max(mut self, input: std::option::Option<i32>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterfaceCountRequest`](crate::model::NetworkInterfaceCountRequest)
        pub fn build(self) -> crate::model::NetworkInterfaceCountRequest {
            crate::model::NetworkInterfaceCountRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl NetworkInterfaceCountRequest {
    /// Creates a new builder-style object to manufacture [`NetworkInterfaceCountRequest`](crate::model::NetworkInterfaceCountRequest)
    pub fn builder() -> crate::model::network_interface_count_request::Builder {
        crate::model::network_interface_count_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BurstablePerformance {
    #[allow(missing_docs)] // documentation missing in model
    Excluded,
    #[allow(missing_docs)] // documentation missing in model
    Included,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BurstablePerformance {
    fn from(s: &str) -> Self {
        match s {
            "excluded" => BurstablePerformance::Excluded,
            "included" => BurstablePerformance::Included,
            "required" => BurstablePerformance::Required,
            other => BurstablePerformance::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BurstablePerformance {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BurstablePerformance::from(s))
    }
}
impl BurstablePerformance {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BurstablePerformance::Excluded => "excluded",
            BurstablePerformance::Included => "included",
            BurstablePerformance::Required => "required",
            BurstablePerformance::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["excluded", "included", "required"]
    }
}
impl AsRef<str> for BurstablePerformance {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BareMetal {
    #[allow(missing_docs)] // documentation missing in model
    Excluded,
    #[allow(missing_docs)] // documentation missing in model
    Included,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BareMetal {
    fn from(s: &str) -> Self {
        match s {
            "excluded" => BareMetal::Excluded,
            "included" => BareMetal::Included,
            "required" => BareMetal::Required,
            other => BareMetal::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BareMetal {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BareMetal::from(s))
    }
}
impl BareMetal {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BareMetal::Excluded => "excluded",
            BareMetal::Included => "included",
            BareMetal::Required => "required",
            BareMetal::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["excluded", "included", "required"]
    }
}
impl AsRef<str> for BareMetal {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceGeneration {
    #[allow(missing_docs)] // documentation missing in model
    Current,
    #[allow(missing_docs)] // documentation missing in model
    Previous,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceGeneration {
    fn from(s: &str) -> Self {
        match s {
            "current" => InstanceGeneration::Current,
            "previous" => InstanceGeneration::Previous,
            other => InstanceGeneration::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceGeneration {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceGeneration::from(s))
    }
}
impl InstanceGeneration {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceGeneration::Current => "current",
            InstanceGeneration::Previous => "previous",
            InstanceGeneration::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["current", "previous"]
    }
}
impl AsRef<str> for InstanceGeneration {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the minimum and maximum for the <code>MemoryGiBPerVCpu</code> object when
/// you specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemoryGiBPerVCpuRequest {
    /// <p>The memory minimum in GiB.</p>
    pub min: std::option::Option<f64>,
    /// <p>The memory maximum in GiB.</p>
    pub max: std::option::Option<f64>,
}
impl MemoryGiBPerVCpuRequest {
    /// <p>The memory minimum in GiB.</p>
    pub fn min(&self) -> std::option::Option<f64> {
        self.min
    }
    /// <p>The memory maximum in GiB.</p>
    pub fn max(&self) -> std::option::Option<f64> {
        self.max
    }
}
impl std::fmt::Debug for MemoryGiBPerVCpuRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemoryGiBPerVCpuRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`MemoryGiBPerVCpuRequest`](crate::model::MemoryGiBPerVCpuRequest)
pub mod memory_gi_b_per_v_cpu_request {
    /// A builder for [`MemoryGiBPerVCpuRequest`](crate::model::MemoryGiBPerVCpuRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<f64>,
        pub(crate) max: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The memory minimum in GiB.</p>
        pub fn min(mut self, input: f64) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The memory minimum in GiB.</p>
        pub fn set_min(mut self, input: std::option::Option<f64>) -> Self {
            self.min = input;
            self
        }
        /// <p>The memory maximum in GiB.</p>
        pub fn max(mut self, input: f64) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The memory maximum in GiB.</p>
        pub fn set_max(mut self, input: std::option::Option<f64>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`MemoryGiBPerVCpuRequest`](crate::model::MemoryGiBPerVCpuRequest)
        pub fn build(self) -> crate::model::MemoryGiBPerVCpuRequest {
            crate::model::MemoryGiBPerVCpuRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl MemoryGiBPerVCpuRequest {
    /// Creates a new builder-style object to manufacture [`MemoryGiBPerVCpuRequest`](crate::model::MemoryGiBPerVCpuRequest)
    pub fn builder() -> crate::model::memory_gi_b_per_v_cpu_request::Builder {
        crate::model::memory_gi_b_per_v_cpu_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CpuManufacturer {
    #[allow(missing_docs)] // documentation missing in model
    AmazonWebServices,
    #[allow(missing_docs)] // documentation missing in model
    Amd,
    #[allow(missing_docs)] // documentation missing in model
    Intel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CpuManufacturer {
    fn from(s: &str) -> Self {
        match s {
            "amazon-web-services" => CpuManufacturer::AmazonWebServices,
            "amd" => CpuManufacturer::Amd,
            "intel" => CpuManufacturer::Intel,
            other => CpuManufacturer::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CpuManufacturer {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CpuManufacturer::from(s))
    }
}
impl CpuManufacturer {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CpuManufacturer::AmazonWebServices => "amazon-web-services",
            CpuManufacturer::Amd => "amd",
            CpuManufacturer::Intel => "intel",
            CpuManufacturer::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["amazon-web-services", "amd", "intel"]
    }
}
impl AsRef<str> for CpuManufacturer {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the minimum and maximum for the <code>MemoryMiB</code> object when you
/// specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemoryMiBRequest {
    /// <p>The memory minimum in MiB.</p>
    pub min: std::option::Option<i32>,
    /// <p>The memory maximum in MiB.</p>
    pub max: std::option::Option<i32>,
}
impl MemoryMiBRequest {
    /// <p>The memory minimum in MiB.</p>
    pub fn min(&self) -> std::option::Option<i32> {
        self.min
    }
    /// <p>The memory maximum in MiB.</p>
    pub fn max(&self) -> std::option::Option<i32> {
        self.max
    }
}
impl std::fmt::Debug for MemoryMiBRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemoryMiBRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`MemoryMiBRequest`](crate::model::MemoryMiBRequest)
pub mod memory_mi_b_request {
    /// A builder for [`MemoryMiBRequest`](crate::model::MemoryMiBRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<i32>,
        pub(crate) max: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The memory minimum in MiB.</p>
        pub fn min(mut self, input: i32) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The memory minimum in MiB.</p>
        pub fn set_min(mut self, input: std::option::Option<i32>) -> Self {
            self.min = input;
            self
        }
        /// <p>The memory maximum in MiB.</p>
        pub fn max(mut self, input: i32) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The memory maximum in MiB.</p>
        pub fn set_max(mut self, input: std::option::Option<i32>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`MemoryMiBRequest`](crate::model::MemoryMiBRequest)
        pub fn build(self) -> crate::model::MemoryMiBRequest {
            crate::model::MemoryMiBRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl MemoryMiBRequest {
    /// Creates a new builder-style object to manufacture [`MemoryMiBRequest`](crate::model::MemoryMiBRequest)
    pub fn builder() -> crate::model::memory_mi_b_request::Builder {
        crate::model::memory_mi_b_request::Builder::default()
    }
}

/// <p>Specifies the minimum and maximum for the <code>VCpuCount</code> object when you
/// specify <a>InstanceRequirements</a> for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VCpuCountRequest {
    /// <p>The minimum number of vCPUs.</p>
    pub min: std::option::Option<i32>,
    /// <p>The maximum number of vCPUs.</p>
    pub max: std::option::Option<i32>,
}
impl VCpuCountRequest {
    /// <p>The minimum number of vCPUs.</p>
    pub fn min(&self) -> std::option::Option<i32> {
        self.min
    }
    /// <p>The maximum number of vCPUs.</p>
    pub fn max(&self) -> std::option::Option<i32> {
        self.max
    }
}
impl std::fmt::Debug for VCpuCountRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VCpuCountRequest");
        formatter.field("min", &self.min);
        formatter.field("max", &self.max);
        formatter.finish()
    }
}
/// See [`VCpuCountRequest`](crate::model::VCpuCountRequest)
pub mod v_cpu_count_request {
    /// A builder for [`VCpuCountRequest`](crate::model::VCpuCountRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min: std::option::Option<i32>,
        pub(crate) max: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum number of vCPUs.</p>
        pub fn min(mut self, input: i32) -> Self {
            self.min = Some(input);
            self
        }
        /// <p>The minimum number of vCPUs.</p>
        pub fn set_min(mut self, input: std::option::Option<i32>) -> Self {
            self.min = input;
            self
        }
        /// <p>The maximum number of vCPUs.</p>
        pub fn max(mut self, input: i32) -> Self {
            self.max = Some(input);
            self
        }
        /// <p>The maximum number of vCPUs.</p>
        pub fn set_max(mut self, input: std::option::Option<i32>) -> Self {
            self.max = input;
            self
        }
        /// Consumes the builder and constructs a [`VCpuCountRequest`](crate::model::VCpuCountRequest)
        pub fn build(self) -> crate::model::VCpuCountRequest {
            crate::model::VCpuCountRequest {
                min: self.min,
                max: self.max,
            }
        }
    }
}
impl VCpuCountRequest {
    /// Creates a new builder-style object to manufacture [`VCpuCountRequest`](crate::model::VCpuCountRequest)
    pub fn builder() -> crate::model::v_cpu_count_request::Builder {
        crate::model::v_cpu_count_request::Builder::default()
    }
}

/// <p>Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling
/// uses to launch Amazon EC2 instances. For more information about launch templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html">Launch
/// templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchTemplateSpecification {
    /// <p>The ID of the launch template. To get the template ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
    /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
    /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
    /// <code>LaunchTemplateName</code>.</p>
    pub launch_template_id: std::option::Option<std::string::String>,
    /// <p>The name of the launch template. To get the template name, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
    /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
    /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
    /// <code>LaunchTemplateName</code>.</p>
    pub launch_template_name: std::option::Option<std::string::String>,
    /// <p>The version number, <code>$Latest</code>, or <code>$Default</code>. To get the version
    /// number, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html">DescribeLaunchTemplateVersions</a> API operation. New launch template versions
    /// can be created using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html">CreateLaunchTemplateVersion</a> API. If the value is <code>$Latest</code>,
    /// Amazon EC2 Auto Scaling selects the latest version of the launch template when launching instances. If
    /// the value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch
    /// template when launching instances. The default value is <code>$Default</code>.</p>
    pub version: std::option::Option<std::string::String>,
}
impl LaunchTemplateSpecification {
    /// <p>The ID of the launch template. To get the template ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
    /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
    /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
    /// <code>LaunchTemplateName</code>.</p>
    pub fn launch_template_id(&self) -> std::option::Option<&str> {
        self.launch_template_id.as_deref()
    }
    /// <p>The name of the launch template. To get the template name, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
    /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
    /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
    /// <code>LaunchTemplateName</code>.</p>
    pub fn launch_template_name(&self) -> std::option::Option<&str> {
        self.launch_template_name.as_deref()
    }
    /// <p>The version number, <code>$Latest</code>, or <code>$Default</code>. To get the version
    /// number, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html">DescribeLaunchTemplateVersions</a> API operation. New launch template versions
    /// can be created using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html">CreateLaunchTemplateVersion</a> API. If the value is <code>$Latest</code>,
    /// Amazon EC2 Auto Scaling selects the latest version of the launch template when launching instances. If
    /// the value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch
    /// template when launching instances. The default value is <code>$Default</code>.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for LaunchTemplateSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchTemplateSpecification");
        formatter.field("launch_template_id", &self.launch_template_id);
        formatter.field("launch_template_name", &self.launch_template_name);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}
/// See [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
pub mod launch_template_specification {
    /// A builder for [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_template_id: std::option::Option<std::string::String>,
        pub(crate) launch_template_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the launch template. To get the template ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
        /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
        /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
        /// <code>LaunchTemplateName</code>.</p>
        pub fn launch_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the launch template. To get the template ID, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
        /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
        /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
        /// <code>LaunchTemplateName</code>.</p>
        pub fn set_launch_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_id = input;
            self
        }
        /// <p>The name of the launch template. To get the template name, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
        /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
        /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
        /// <code>LaunchTemplateName</code>.</p>
        pub fn launch_template_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_template_name = Some(input.into());
            self
        }
        /// <p>The name of the launch template. To get the template name, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html">DescribeLaunchTemplates</a> API operation. New launch templates can be created
        /// using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html">CreateLaunchTemplate</a> API. </p>
        /// <p>Conditional: You must specify either a <code>LaunchTemplateId</code> or a
        /// <code>LaunchTemplateName</code>.</p>
        pub fn set_launch_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_template_name = input;
            self
        }
        /// <p>The version number, <code>$Latest</code>, or <code>$Default</code>. To get the version
        /// number, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html">DescribeLaunchTemplateVersions</a> API operation. New launch template versions
        /// can be created using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html">CreateLaunchTemplateVersion</a> API. If the value is <code>$Latest</code>,
        /// Amazon EC2 Auto Scaling selects the latest version of the launch template when launching instances. If
        /// the value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch
        /// template when launching instances. The default value is <code>$Default</code>.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version number, <code>$Latest</code>, or <code>$Default</code>. To get the version
        /// number, use the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html">DescribeLaunchTemplateVersions</a> API operation. New launch template versions
        /// can be created using the Amazon EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html">CreateLaunchTemplateVersion</a> API. If the value is <code>$Latest</code>,
        /// Amazon EC2 Auto Scaling selects the latest version of the launch template when launching instances. If
        /// the value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch
        /// template when launching instances. The default value is <code>$Default</code>.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
        pub fn build(self) -> crate::model::LaunchTemplateSpecification {
            crate::model::LaunchTemplateSpecification {
                launch_template_id: self.launch_template_id,
                launch_template_name: self.launch_template_name,
                version: self.version,
            }
        }
    }
}
impl LaunchTemplateSpecification {
    /// Creates a new builder-style object to manufacture [`LaunchTemplateSpecification`](crate::model::LaunchTemplateSpecification)
    pub fn builder() -> crate::model::launch_template_specification::Builder {
        crate::model::launch_template_specification::Builder::default()
    }
}

/// <p>Describes scaling activity, which is a long-running process that represents a change
/// to your Auto Scaling group, such as changing its size or replacing an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Activity {
    /// <p>The ID of the activity.</p>
    pub activity_id: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>A friendly, more verbose description of the activity.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The reason the activity began.</p>
    pub cause: std::option::Option<std::string::String>,
    /// <p>The start time of the activity.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time of the activity.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The current status of the activity.</p>
    pub status_code: std::option::Option<crate::model::ScalingActivityStatusCode>,
    /// <p>A friendly, more verbose description of the activity status.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>A value between 0 and 100 that indicates the progress of the activity.</p>
    pub progress: i32,
    /// <p>The details about the activity.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>The state of the Auto Scaling group, which is either <code>InService</code> or
    /// <code>Deleted</code>.</p>
    pub auto_scaling_group_state: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
    pub auto_scaling_group_arn: std::option::Option<std::string::String>,
}
impl Activity {
    /// <p>The ID of the activity.</p>
    pub fn activity_id(&self) -> std::option::Option<&str> {
        self.activity_id.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>A friendly, more verbose description of the activity.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The reason the activity began.</p>
    pub fn cause(&self) -> std::option::Option<&str> {
        self.cause.as_deref()
    }
    /// <p>The start time of the activity.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the activity.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The current status of the activity.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::ScalingActivityStatusCode> {
        self.status_code.as_ref()
    }
    /// <p>A friendly, more verbose description of the activity status.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>A value between 0 and 100 that indicates the progress of the activity.</p>
    pub fn progress(&self) -> i32 {
        self.progress
    }
    /// <p>The details about the activity.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>The state of the Auto Scaling group, which is either <code>InService</code> or
    /// <code>Deleted</code>.</p>
    pub fn auto_scaling_group_state(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_state.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
    pub fn auto_scaling_group_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_arn.as_deref()
    }
}
impl std::fmt::Debug for Activity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Activity");
        formatter.field("activity_id", &self.activity_id);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("description", &self.description);
        formatter.field("cause", &self.cause);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("status_code", &self.status_code);
        formatter.field("status_message", &self.status_message);
        formatter.field("progress", &self.progress);
        formatter.field("details", &self.details);
        formatter.field("auto_scaling_group_state", &self.auto_scaling_group_state);
        formatter.field("auto_scaling_group_arn", &self.auto_scaling_group_arn);
        formatter.finish()
    }
}
/// See [`Activity`](crate::model::Activity)
pub mod activity {
    /// A builder for [`Activity`](crate::model::Activity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) activity_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) cause: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status_code: std::option::Option<crate::model::ScalingActivityStatusCode>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) progress: std::option::Option<i32>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_state: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the activity.</p>
        pub fn activity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_id = Some(input.into());
            self
        }
        /// <p>The ID of the activity.</p>
        pub fn set_activity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.activity_id = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>A friendly, more verbose description of the activity.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A friendly, more verbose description of the activity.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The reason the activity began.</p>
        pub fn cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.cause = Some(input.into());
            self
        }
        /// <p>The reason the activity began.</p>
        pub fn set_cause(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cause = input;
            self
        }
        /// <p>The start time of the activity.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the activity.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the activity.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the activity.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The current status of the activity.</p>
        pub fn status_code(mut self, input: crate::model::ScalingActivityStatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The current status of the activity.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::ScalingActivityStatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// <p>A friendly, more verbose description of the activity status.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>A friendly, more verbose description of the activity status.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>A value between 0 and 100 that indicates the progress of the activity.</p>
        pub fn progress(mut self, input: i32) -> Self {
            self.progress = Some(input);
            self
        }
        /// <p>A value between 0 and 100 that indicates the progress of the activity.</p>
        pub fn set_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.progress = input;
            self
        }
        /// <p>The details about the activity.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>The details about the activity.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>The state of the Auto Scaling group, which is either <code>InService</code> or
        /// <code>Deleted</code>.</p>
        pub fn auto_scaling_group_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_state = Some(input.into());
            self
        }
        /// <p>The state of the Auto Scaling group, which is either <code>InService</code> or
        /// <code>Deleted</code>.</p>
        pub fn set_auto_scaling_group_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_state = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
        pub fn auto_scaling_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Activity`](crate::model::Activity)
        pub fn build(self) -> crate::model::Activity {
            crate::model::Activity {
                activity_id: self.activity_id,
                auto_scaling_group_name: self.auto_scaling_group_name,
                description: self.description,
                cause: self.cause,
                start_time: self.start_time,
                end_time: self.end_time,
                status_code: self.status_code,
                status_message: self.status_message,
                progress: self.progress.unwrap_or_default(),
                details: self.details,
                auto_scaling_group_state: self.auto_scaling_group_state,
                auto_scaling_group_arn: self.auto_scaling_group_arn,
            }
        }
    }
}
impl Activity {
    /// Creates a new builder-style object to manufacture [`Activity`](crate::model::Activity)
    pub fn builder() -> crate::model::activity::Builder {
        crate::model::activity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingActivityStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    MidLifecycleAction,
    #[allow(missing_docs)] // documentation missing in model
    PendingSpotBidPlacement,
    #[allow(missing_docs)] // documentation missing in model
    PreInService,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    #[allow(missing_docs)] // documentation missing in model
    WaitingForElbConnectionDraining,
    #[allow(missing_docs)] // documentation missing in model
    WaitingForInstanceId,
    #[allow(missing_docs)] // documentation missing in model
    WaitingForInstanceWarmup,
    #[allow(missing_docs)] // documentation missing in model
    WaitingForSpotInstanceId,
    #[allow(missing_docs)] // documentation missing in model
    WaitingForSpotInstanceRequestId,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingActivityStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => ScalingActivityStatusCode::Cancelled,
            "Failed" => ScalingActivityStatusCode::Failed,
            "InProgress" => ScalingActivityStatusCode::InProgress,
            "MidLifecycleAction" => ScalingActivityStatusCode::MidLifecycleAction,
            "PendingSpotBidPlacement" => ScalingActivityStatusCode::PendingSpotBidPlacement,
            "PreInService" => ScalingActivityStatusCode::PreInService,
            "Successful" => ScalingActivityStatusCode::Successful,
            "WaitingForELBConnectionDraining" => {
                ScalingActivityStatusCode::WaitingForElbConnectionDraining
            }
            "WaitingForInstanceId" => ScalingActivityStatusCode::WaitingForInstanceId,
            "WaitingForInstanceWarmup" => ScalingActivityStatusCode::WaitingForInstanceWarmup,
            "WaitingForSpotInstanceId" => ScalingActivityStatusCode::WaitingForSpotInstanceId,
            "WaitingForSpotInstanceRequestId" => {
                ScalingActivityStatusCode::WaitingForSpotInstanceRequestId
            }
            other => ScalingActivityStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingActivityStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingActivityStatusCode::from(s))
    }
}
impl ScalingActivityStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingActivityStatusCode::Cancelled => "Cancelled",
            ScalingActivityStatusCode::Failed => "Failed",
            ScalingActivityStatusCode::InProgress => "InProgress",
            ScalingActivityStatusCode::MidLifecycleAction => "MidLifecycleAction",
            ScalingActivityStatusCode::PendingSpotBidPlacement => "PendingSpotBidPlacement",
            ScalingActivityStatusCode::PreInService => "PreInService",
            ScalingActivityStatusCode::Successful => "Successful",
            ScalingActivityStatusCode::WaitingForElbConnectionDraining => {
                "WaitingForELBConnectionDraining"
            }
            ScalingActivityStatusCode::WaitingForInstanceId => "WaitingForInstanceId",
            ScalingActivityStatusCode::WaitingForInstanceWarmup => "WaitingForInstanceWarmup",
            ScalingActivityStatusCode::WaitingForSpotInstanceId => "WaitingForSpotInstanceId",
            ScalingActivityStatusCode::WaitingForSpotInstanceRequestId => {
                "WaitingForSpotInstanceRequestId"
            }
            ScalingActivityStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Failed",
            "InProgress",
            "MidLifecycleAction",
            "PendingSpotBidPlacement",
            "PreInService",
            "Successful",
            "WaitingForELBConnectionDraining",
            "WaitingForInstanceId",
            "WaitingForInstanceWarmup",
            "WaitingForSpotInstanceId",
            "WaitingForSpotInstanceRequestId",
        ]
    }
}
impl AsRef<str> for ScalingActivityStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the preferences for an instance refresh.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshPreferences {
    /// <p>The amount of capacity in the Auto Scaling group that must remain healthy during an instance
    /// refresh to allow the operation to continue. The value is expressed as a percentage of
    /// the desired capacity of the Auto Scaling group (rounded up to the nearest integer). The default
    /// is <code>90</code>.</p>
    /// <p>Setting the minimum healthy percentage to 100 percent limits the rate of replacement
    /// to one instance at a time. In contrast, setting it to 0 percent has the effect of
    /// replacing all instances at the same time. </p>
    pub min_healthy_percentage: std::option::Option<i32>,
    /// <p>The number of seconds until a newly launched instance is configured and ready to use.
    /// During this time, Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The
    /// default is to use the value for the health check grace period defined for the
    /// group.</p>
    pub instance_warmup: std::option::Option<i32>,
    /// <p>Threshold values for each checkpoint in ascending order. Each number must be unique.
    /// To replace all instances in the Auto Scaling group, the last number in the array must be
    /// <code>100</code>.</p>
    /// <p>For usage examples, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html">Adding
    /// checkpoints to an instance refresh</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub checkpoint_percentages: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The amount of time, in seconds, to wait after a checkpoint before continuing. This
    /// property is optional, but if you specify a value for it, you must also specify a value
    /// for <code>CheckpointPercentages</code>. If you specify a value for
    /// <code>CheckpointPercentages</code> and not for <code>CheckpointDelay</code>, the
    /// <code>CheckpointDelay</code> defaults to <code>3600</code> (1 hour). </p>
    pub checkpoint_delay: std::option::Option<i32>,
    /// <p>A boolean value that indicates whether skip matching is enabled. If true, then
    /// Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired
    /// configuration is specified, then it skips replacing instances that have the same
    /// configuration that is already set on the group. The default is
    /// <code>false</code>.</p>
    pub skip_matching: std::option::Option<bool>,
}
impl RefreshPreferences {
    /// <p>The amount of capacity in the Auto Scaling group that must remain healthy during an instance
    /// refresh to allow the operation to continue. The value is expressed as a percentage of
    /// the desired capacity of the Auto Scaling group (rounded up to the nearest integer). The default
    /// is <code>90</code>.</p>
    /// <p>Setting the minimum healthy percentage to 100 percent limits the rate of replacement
    /// to one instance at a time. In contrast, setting it to 0 percent has the effect of
    /// replacing all instances at the same time. </p>
    pub fn min_healthy_percentage(&self) -> std::option::Option<i32> {
        self.min_healthy_percentage
    }
    /// <p>The number of seconds until a newly launched instance is configured and ready to use.
    /// During this time, Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The
    /// default is to use the value for the health check grace period defined for the
    /// group.</p>
    pub fn instance_warmup(&self) -> std::option::Option<i32> {
        self.instance_warmup
    }
    /// <p>Threshold values for each checkpoint in ascending order. Each number must be unique.
    /// To replace all instances in the Auto Scaling group, the last number in the array must be
    /// <code>100</code>.</p>
    /// <p>For usage examples, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html">Adding
    /// checkpoints to an instance refresh</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn checkpoint_percentages(&self) -> std::option::Option<&[i32]> {
        self.checkpoint_percentages.as_deref()
    }
    /// <p>The amount of time, in seconds, to wait after a checkpoint before continuing. This
    /// property is optional, but if you specify a value for it, you must also specify a value
    /// for <code>CheckpointPercentages</code>. If you specify a value for
    /// <code>CheckpointPercentages</code> and not for <code>CheckpointDelay</code>, the
    /// <code>CheckpointDelay</code> defaults to <code>3600</code> (1 hour). </p>
    pub fn checkpoint_delay(&self) -> std::option::Option<i32> {
        self.checkpoint_delay
    }
    /// <p>A boolean value that indicates whether skip matching is enabled. If true, then
    /// Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired
    /// configuration is specified, then it skips replacing instances that have the same
    /// configuration that is already set on the group. The default is
    /// <code>false</code>.</p>
    pub fn skip_matching(&self) -> std::option::Option<bool> {
        self.skip_matching
    }
}
impl std::fmt::Debug for RefreshPreferences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshPreferences");
        formatter.field("min_healthy_percentage", &self.min_healthy_percentage);
        formatter.field("instance_warmup", &self.instance_warmup);
        formatter.field("checkpoint_percentages", &self.checkpoint_percentages);
        formatter.field("checkpoint_delay", &self.checkpoint_delay);
        formatter.field("skip_matching", &self.skip_matching);
        formatter.finish()
    }
}
/// See [`RefreshPreferences`](crate::model::RefreshPreferences)
pub mod refresh_preferences {
    /// A builder for [`RefreshPreferences`](crate::model::RefreshPreferences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_healthy_percentage: std::option::Option<i32>,
        pub(crate) instance_warmup: std::option::Option<i32>,
        pub(crate) checkpoint_percentages: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) checkpoint_delay: std::option::Option<i32>,
        pub(crate) skip_matching: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The amount of capacity in the Auto Scaling group that must remain healthy during an instance
        /// refresh to allow the operation to continue. The value is expressed as a percentage of
        /// the desired capacity of the Auto Scaling group (rounded up to the nearest integer). The default
        /// is <code>90</code>.</p>
        /// <p>Setting the minimum healthy percentage to 100 percent limits the rate of replacement
        /// to one instance at a time. In contrast, setting it to 0 percent has the effect of
        /// replacing all instances at the same time. </p>
        pub fn min_healthy_percentage(mut self, input: i32) -> Self {
            self.min_healthy_percentage = Some(input);
            self
        }
        /// <p>The amount of capacity in the Auto Scaling group that must remain healthy during an instance
        /// refresh to allow the operation to continue. The value is expressed as a percentage of
        /// the desired capacity of the Auto Scaling group (rounded up to the nearest integer). The default
        /// is <code>90</code>.</p>
        /// <p>Setting the minimum healthy percentage to 100 percent limits the rate of replacement
        /// to one instance at a time. In contrast, setting it to 0 percent has the effect of
        /// replacing all instances at the same time. </p>
        pub fn set_min_healthy_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.min_healthy_percentage = input;
            self
        }
        /// <p>The number of seconds until a newly launched instance is configured and ready to use.
        /// During this time, Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The
        /// default is to use the value for the health check grace period defined for the
        /// group.</p>
        pub fn instance_warmup(mut self, input: i32) -> Self {
            self.instance_warmup = Some(input);
            self
        }
        /// <p>The number of seconds until a newly launched instance is configured and ready to use.
        /// During this time, Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The
        /// default is to use the value for the health check grace period defined for the
        /// group.</p>
        pub fn set_instance_warmup(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_warmup = input;
            self
        }
        /// Appends an item to `checkpoint_percentages`.
        ///
        /// To override the contents of this collection use [`set_checkpoint_percentages`](Self::set_checkpoint_percentages).
        ///
        /// <p>Threshold values for each checkpoint in ascending order. Each number must be unique.
        /// To replace all instances in the Auto Scaling group, the last number in the array must be
        /// <code>100</code>.</p>
        /// <p>For usage examples, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html">Adding
        /// checkpoints to an instance refresh</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn checkpoint_percentages(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.checkpoint_percentages.unwrap_or_default();
            v.push(input.into());
            self.checkpoint_percentages = Some(v);
            self
        }
        /// <p>Threshold values for each checkpoint in ascending order. Each number must be unique.
        /// To replace all instances in the Auto Scaling group, the last number in the array must be
        /// <code>100</code>.</p>
        /// <p>For usage examples, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html">Adding
        /// checkpoints to an instance refresh</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_checkpoint_percentages(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.checkpoint_percentages = input;
            self
        }
        /// <p>The amount of time, in seconds, to wait after a checkpoint before continuing. This
        /// property is optional, but if you specify a value for it, you must also specify a value
        /// for <code>CheckpointPercentages</code>. If you specify a value for
        /// <code>CheckpointPercentages</code> and not for <code>CheckpointDelay</code>, the
        /// <code>CheckpointDelay</code> defaults to <code>3600</code> (1 hour). </p>
        pub fn checkpoint_delay(mut self, input: i32) -> Self {
            self.checkpoint_delay = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, to wait after a checkpoint before continuing. This
        /// property is optional, but if you specify a value for it, you must also specify a value
        /// for <code>CheckpointPercentages</code>. If you specify a value for
        /// <code>CheckpointPercentages</code> and not for <code>CheckpointDelay</code>, the
        /// <code>CheckpointDelay</code> defaults to <code>3600</code> (1 hour). </p>
        pub fn set_checkpoint_delay(mut self, input: std::option::Option<i32>) -> Self {
            self.checkpoint_delay = input;
            self
        }
        /// <p>A boolean value that indicates whether skip matching is enabled. If true, then
        /// Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired
        /// configuration is specified, then it skips replacing instances that have the same
        /// configuration that is already set on the group. The default is
        /// <code>false</code>.</p>
        pub fn skip_matching(mut self, input: bool) -> Self {
            self.skip_matching = Some(input);
            self
        }
        /// <p>A boolean value that indicates whether skip matching is enabled. If true, then
        /// Amazon EC2 Auto Scaling skips replacing instances that match the desired configuration. If no desired
        /// configuration is specified, then it skips replacing instances that have the same
        /// configuration that is already set on the group. The default is
        /// <code>false</code>.</p>
        pub fn set_skip_matching(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_matching = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshPreferences`](crate::model::RefreshPreferences)
        pub fn build(self) -> crate::model::RefreshPreferences {
            crate::model::RefreshPreferences {
                min_healthy_percentage: self.min_healthy_percentage,
                instance_warmup: self.instance_warmup,
                checkpoint_percentages: self.checkpoint_percentages,
                checkpoint_delay: self.checkpoint_delay,
                skip_matching: self.skip_matching,
            }
        }
    }
}
impl RefreshPreferences {
    /// Creates a new builder-style object to manufacture [`RefreshPreferences`](crate::model::RefreshPreferences)
    pub fn builder() -> crate::model::refresh_preferences::Builder {
        crate::model::refresh_preferences::Builder::default()
    }
}

/// <p>Describes the desired configuration for an instance refresh. </p>
/// <p>If you specify a desired configuration, you must specify either a
/// <code>LaunchTemplate</code> or a <code>MixedInstancesPolicy</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DesiredConfiguration {
    /// <p>Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling
    /// uses to launch Amazon EC2 instances. For more information about launch templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html">Launch
    /// templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>Describes a mixed instances policy. A mixed instances policy contains the instance
    /// types that Amazon EC2 Auto Scaling can launch and other information that Amazon EC2 Auto Scaling can use to launch
    /// instances and help optimize your costs. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling
    /// groups with multiple instance types and purchase options</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
}
impl DesiredConfiguration {
    /// <p>Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling
    /// uses to launch Amazon EC2 instances. For more information about launch templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html">Launch
    /// templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn launch_template(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template.as_ref()
    }
    /// <p>Describes a mixed instances policy. A mixed instances policy contains the instance
    /// types that Amazon EC2 Auto Scaling can launch and other information that Amazon EC2 Auto Scaling can use to launch
    /// instances and help optimize your costs. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling
    /// groups with multiple instance types and purchase options</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn mixed_instances_policy(
        &self,
    ) -> std::option::Option<&crate::model::MixedInstancesPolicy> {
        self.mixed_instances_policy.as_ref()
    }
}
impl std::fmt::Debug for DesiredConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DesiredConfiguration");
        formatter.field("launch_template", &self.launch_template);
        formatter.field("mixed_instances_policy", &self.mixed_instances_policy);
        formatter.finish()
    }
}
/// See [`DesiredConfiguration`](crate::model::DesiredConfiguration)
pub mod desired_configuration {
    /// A builder for [`DesiredConfiguration`](crate::model::DesiredConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
    }
    impl Builder {
        /// <p>Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling
        /// uses to launch Amazon EC2 instances. For more information about launch templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html">Launch
        /// templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>Describes the launch template and the version of the launch template that Amazon EC2 Auto Scaling
        /// uses to launch Amazon EC2 instances. For more information about launch templates, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html">Launch
        /// templates</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// <p>Describes a mixed instances policy. A mixed instances policy contains the instance
        /// types that Amazon EC2 Auto Scaling can launch and other information that Amazon EC2 Auto Scaling can use to launch
        /// instances and help optimize your costs. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling
        /// groups with multiple instance types and purchase options</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn mixed_instances_policy(mut self, input: crate::model::MixedInstancesPolicy) -> Self {
            self.mixed_instances_policy = Some(input);
            self
        }
        /// <p>Describes a mixed instances policy. A mixed instances policy contains the instance
        /// types that Amazon EC2 Auto Scaling can launch and other information that Amazon EC2 Auto Scaling can use to launch
        /// instances and help optimize your costs. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html">Auto Scaling
        /// groups with multiple instance types and purchase options</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_mixed_instances_policy(
            mut self,
            input: std::option::Option<crate::model::MixedInstancesPolicy>,
        ) -> Self {
            self.mixed_instances_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DesiredConfiguration`](crate::model::DesiredConfiguration)
        pub fn build(self) -> crate::model::DesiredConfiguration {
            crate::model::DesiredConfiguration {
                launch_template: self.launch_template,
                mixed_instances_policy: self.mixed_instances_policy,
            }
        }
    }
}
impl DesiredConfiguration {
    /// Creates a new builder-style object to manufacture [`DesiredConfiguration`](crate::model::DesiredConfiguration)
    pub fn builder() -> crate::model::desired_configuration::Builder {
        crate::model::desired_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RefreshStrategy {
    #[allow(missing_docs)] // documentation missing in model
    Rolling,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RefreshStrategy {
    fn from(s: &str) -> Self {
        match s {
            "Rolling" => RefreshStrategy::Rolling,
            other => RefreshStrategy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RefreshStrategy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RefreshStrategy::from(s))
    }
}
impl RefreshStrategy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RefreshStrategy::Rolling => "Rolling",
            RefreshStrategy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Rolling"]
    }
}
impl AsRef<str> for RefreshStrategy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WarmPoolState {
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WarmPoolState {
    fn from(s: &str) -> Self {
        match s {
            "Running" => WarmPoolState::Running,
            "Stopped" => WarmPoolState::Stopped,
            other => WarmPoolState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WarmPoolState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WarmPoolState::from(s))
    }
}
impl WarmPoolState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WarmPoolState::Running => "Running",
            WarmPoolState::Stopped => "Stopped",
            WarmPoolState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Running", "Stopped"]
    }
}
impl AsRef<str> for WarmPoolState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alarm {
    /// <p>The name of the alarm.</p>
    pub alarm_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub alarm_arn: std::option::Option<std::string::String>,
}
impl Alarm {
    /// <p>The name of the alarm.</p>
    pub fn alarm_name(&self) -> std::option::Option<&str> {
        self.alarm_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub fn alarm_arn(&self) -> std::option::Option<&str> {
        self.alarm_arn.as_deref()
    }
}
impl std::fmt::Debug for Alarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alarm");
        formatter.field("alarm_name", &self.alarm_name);
        formatter.field("alarm_arn", &self.alarm_arn);
        formatter.finish()
    }
}
/// See [`Alarm`](crate::model::Alarm)
pub mod alarm {
    /// A builder for [`Alarm`](crate::model::Alarm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_name: std::option::Option<std::string::String>,
        pub(crate) alarm_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn alarm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn set_alarm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Alarm`](crate::model::Alarm)
        pub fn build(self) -> crate::model::Alarm {
            crate::model::Alarm {
                alarm_name: self.alarm_name,
                alarm_arn: self.alarm_arn,
            }
        }
    }
}
impl Alarm {
    /// Creates a new builder-style object to manufacture [`Alarm`](crate::model::Alarm)
    pub fn builder() -> crate::model::alarm::Builder {
        crate::model::alarm::Builder::default()
    }
}

/// <p>Represents a predictive scaling policy configuration to use with Amazon EC2 Auto Scaling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictiveScalingConfiguration {
    /// <p>This structure includes the metrics and target utilization to use for predictive
    /// scaling. </p>
    /// <p>This is an array, but we currently only support a single metric specification. That
    /// is, you can specify a target value and a single metric pair, or a target value and one
    /// scaling metric and one load metric.</p>
    pub metric_specifications:
        std::option::Option<std::vec::Vec<crate::model::PredictiveScalingMetricSpecification>>,
    /// <p>The predictive scaling mode. Defaults to <code>ForecastOnly</code> if not
    /// specified.</p>
    pub mode: std::option::Option<crate::model::PredictiveScalingMode>,
    /// <p>The amount of time, in seconds, by which the instance launch time can be advanced. For
    /// example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch
    /// instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The
    /// intention is to give resources time to be provisioned. It can take a few minutes to
    /// launch an EC2 instance. The actual amount of time required depends on several factors,
    /// such as the size of the instance and whether there are startup scripts to complete. </p>
    /// <p>The value must be less than the forecast interval duration of 3600 seconds (60
    /// minutes). Defaults to 300 seconds if not specified. </p>
    pub scheduling_buffer_time: std::option::Option<i32>,
    /// <p>Defines the behavior that should be applied if the forecast capacity approaches or
    /// exceeds the maximum capacity of the Auto Scaling group. Defaults to
    /// <code>HonorMaxCapacity</code> if not specified.</p>
    /// <p>The following are possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HonorMaxCapacity</code> - Amazon EC2 Auto Scaling cannot scale out capacity higher than
    /// the maximum capacity. The maximum capacity is enforced as a hard limit. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IncreaseMaxCapacity</code> - Amazon EC2 Auto Scaling can scale out capacity higher than
    /// the maximum capacity when the forecast capacity is close to or exceeds the
    /// maximum capacity. The upper limit is determined by the forecasted capacity and
    /// the value for <code>MaxCapacityBuffer</code>.</p>
    /// </li>
    /// </ul>
    pub max_capacity_breach_behavior:
        std::option::Option<crate::model::PredictiveScalingMaxCapacityBreachBehavior>,
    /// <p>The size of the capacity buffer to use when the forecast capacity is close to or
    /// exceeds the maximum capacity. The value is specified as a percentage relative to the
    /// forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer,
    /// such that if the forecast capacity is 50, and the maximum capacity is 40, then the
    /// effective maximum capacity is 55.</p>
    /// <p>If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but
    /// not exceed forecast capacity. </p>
    /// <p>Required if the <code>MaxCapacityBreachBehavior</code> property is set to
    /// <code>IncreaseMaxCapacity</code>, and cannot be used otherwise.</p>
    pub max_capacity_buffer: std::option::Option<i32>,
}
impl PredictiveScalingConfiguration {
    /// <p>This structure includes the metrics and target utilization to use for predictive
    /// scaling. </p>
    /// <p>This is an array, but we currently only support a single metric specification. That
    /// is, you can specify a target value and a single metric pair, or a target value and one
    /// scaling metric and one load metric.</p>
    pub fn metric_specifications(
        &self,
    ) -> std::option::Option<&[crate::model::PredictiveScalingMetricSpecification]> {
        self.metric_specifications.as_deref()
    }
    /// <p>The predictive scaling mode. Defaults to <code>ForecastOnly</code> if not
    /// specified.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::PredictiveScalingMode> {
        self.mode.as_ref()
    }
    /// <p>The amount of time, in seconds, by which the instance launch time can be advanced. For
    /// example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch
    /// instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The
    /// intention is to give resources time to be provisioned. It can take a few minutes to
    /// launch an EC2 instance. The actual amount of time required depends on several factors,
    /// such as the size of the instance and whether there are startup scripts to complete. </p>
    /// <p>The value must be less than the forecast interval duration of 3600 seconds (60
    /// minutes). Defaults to 300 seconds if not specified. </p>
    pub fn scheduling_buffer_time(&self) -> std::option::Option<i32> {
        self.scheduling_buffer_time
    }
    /// <p>Defines the behavior that should be applied if the forecast capacity approaches or
    /// exceeds the maximum capacity of the Auto Scaling group. Defaults to
    /// <code>HonorMaxCapacity</code> if not specified.</p>
    /// <p>The following are possible values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>HonorMaxCapacity</code> - Amazon EC2 Auto Scaling cannot scale out capacity higher than
    /// the maximum capacity. The maximum capacity is enforced as a hard limit. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IncreaseMaxCapacity</code> - Amazon EC2 Auto Scaling can scale out capacity higher than
    /// the maximum capacity when the forecast capacity is close to or exceeds the
    /// maximum capacity. The upper limit is determined by the forecasted capacity and
    /// the value for <code>MaxCapacityBuffer</code>.</p>
    /// </li>
    /// </ul>
    pub fn max_capacity_breach_behavior(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingMaxCapacityBreachBehavior> {
        self.max_capacity_breach_behavior.as_ref()
    }
    /// <p>The size of the capacity buffer to use when the forecast capacity is close to or
    /// exceeds the maximum capacity. The value is specified as a percentage relative to the
    /// forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer,
    /// such that if the forecast capacity is 50, and the maximum capacity is 40, then the
    /// effective maximum capacity is 55.</p>
    /// <p>If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but
    /// not exceed forecast capacity. </p>
    /// <p>Required if the <code>MaxCapacityBreachBehavior</code> property is set to
    /// <code>IncreaseMaxCapacity</code>, and cannot be used otherwise.</p>
    pub fn max_capacity_buffer(&self) -> std::option::Option<i32> {
        self.max_capacity_buffer
    }
}
impl std::fmt::Debug for PredictiveScalingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictiveScalingConfiguration");
        formatter.field("metric_specifications", &self.metric_specifications);
        formatter.field("mode", &self.mode);
        formatter.field("scheduling_buffer_time", &self.scheduling_buffer_time);
        formatter.field(
            "max_capacity_breach_behavior",
            &self.max_capacity_breach_behavior,
        );
        formatter.field("max_capacity_buffer", &self.max_capacity_buffer);
        formatter.finish()
    }
}
/// See [`PredictiveScalingConfiguration`](crate::model::PredictiveScalingConfiguration)
pub mod predictive_scaling_configuration {
    /// A builder for [`PredictiveScalingConfiguration`](crate::model::PredictiveScalingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_specifications:
            std::option::Option<std::vec::Vec<crate::model::PredictiveScalingMetricSpecification>>,
        pub(crate) mode: std::option::Option<crate::model::PredictiveScalingMode>,
        pub(crate) scheduling_buffer_time: std::option::Option<i32>,
        pub(crate) max_capacity_breach_behavior:
            std::option::Option<crate::model::PredictiveScalingMaxCapacityBreachBehavior>,
        pub(crate) max_capacity_buffer: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `metric_specifications`.
        ///
        /// To override the contents of this collection use [`set_metric_specifications`](Self::set_metric_specifications).
        ///
        /// <p>This structure includes the metrics and target utilization to use for predictive
        /// scaling. </p>
        /// <p>This is an array, but we currently only support a single metric specification. That
        /// is, you can specify a target value and a single metric pair, or a target value and one
        /// scaling metric and one load metric.</p>
        pub fn metric_specifications(
            mut self,
            input: impl Into<crate::model::PredictiveScalingMetricSpecification>,
        ) -> Self {
            let mut v = self.metric_specifications.unwrap_or_default();
            v.push(input.into());
            self.metric_specifications = Some(v);
            self
        }
        /// <p>This structure includes the metrics and target utilization to use for predictive
        /// scaling. </p>
        /// <p>This is an array, but we currently only support a single metric specification. That
        /// is, you can specify a target value and a single metric pair, or a target value and one
        /// scaling metric and one load metric.</p>
        pub fn set_metric_specifications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::PredictiveScalingMetricSpecification>,
            >,
        ) -> Self {
            self.metric_specifications = input;
            self
        }
        /// <p>The predictive scaling mode. Defaults to <code>ForecastOnly</code> if not
        /// specified.</p>
        pub fn mode(mut self, input: crate::model::PredictiveScalingMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The predictive scaling mode. Defaults to <code>ForecastOnly</code> if not
        /// specified.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>The amount of time, in seconds, by which the instance launch time can be advanced. For
        /// example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch
        /// instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The
        /// intention is to give resources time to be provisioned. It can take a few minutes to
        /// launch an EC2 instance. The actual amount of time required depends on several factors,
        /// such as the size of the instance and whether there are startup scripts to complete. </p>
        /// <p>The value must be less than the forecast interval duration of 3600 seconds (60
        /// minutes). Defaults to 300 seconds if not specified. </p>
        pub fn scheduling_buffer_time(mut self, input: i32) -> Self {
            self.scheduling_buffer_time = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, by which the instance launch time can be advanced. For
        /// example, the forecast says to add capacity at 10:00 AM, and you choose to pre-launch
        /// instances by 5 minutes. In that case, the instances will be launched at 9:55 AM. The
        /// intention is to give resources time to be provisioned. It can take a few minutes to
        /// launch an EC2 instance. The actual amount of time required depends on several factors,
        /// such as the size of the instance and whether there are startup scripts to complete. </p>
        /// <p>The value must be less than the forecast interval duration of 3600 seconds (60
        /// minutes). Defaults to 300 seconds if not specified. </p>
        pub fn set_scheduling_buffer_time(mut self, input: std::option::Option<i32>) -> Self {
            self.scheduling_buffer_time = input;
            self
        }
        /// <p>Defines the behavior that should be applied if the forecast capacity approaches or
        /// exceeds the maximum capacity of the Auto Scaling group. Defaults to
        /// <code>HonorMaxCapacity</code> if not specified.</p>
        /// <p>The following are possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HonorMaxCapacity</code> - Amazon EC2 Auto Scaling cannot scale out capacity higher than
        /// the maximum capacity. The maximum capacity is enforced as a hard limit. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IncreaseMaxCapacity</code> - Amazon EC2 Auto Scaling can scale out capacity higher than
        /// the maximum capacity when the forecast capacity is close to or exceeds the
        /// maximum capacity. The upper limit is determined by the forecasted capacity and
        /// the value for <code>MaxCapacityBuffer</code>.</p>
        /// </li>
        /// </ul>
        pub fn max_capacity_breach_behavior(
            mut self,
            input: crate::model::PredictiveScalingMaxCapacityBreachBehavior,
        ) -> Self {
            self.max_capacity_breach_behavior = Some(input);
            self
        }
        /// <p>Defines the behavior that should be applied if the forecast capacity approaches or
        /// exceeds the maximum capacity of the Auto Scaling group. Defaults to
        /// <code>HonorMaxCapacity</code> if not specified.</p>
        /// <p>The following are possible values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>HonorMaxCapacity</code> - Amazon EC2 Auto Scaling cannot scale out capacity higher than
        /// the maximum capacity. The maximum capacity is enforced as a hard limit. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IncreaseMaxCapacity</code> - Amazon EC2 Auto Scaling can scale out capacity higher than
        /// the maximum capacity when the forecast capacity is close to or exceeds the
        /// maximum capacity. The upper limit is determined by the forecasted capacity and
        /// the value for <code>MaxCapacityBuffer</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_max_capacity_breach_behavior(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingMaxCapacityBreachBehavior>,
        ) -> Self {
            self.max_capacity_breach_behavior = input;
            self
        }
        /// <p>The size of the capacity buffer to use when the forecast capacity is close to or
        /// exceeds the maximum capacity. The value is specified as a percentage relative to the
        /// forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer,
        /// such that if the forecast capacity is 50, and the maximum capacity is 40, then the
        /// effective maximum capacity is 55.</p>
        /// <p>If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but
        /// not exceed forecast capacity. </p>
        /// <p>Required if the <code>MaxCapacityBreachBehavior</code> property is set to
        /// <code>IncreaseMaxCapacity</code>, and cannot be used otherwise.</p>
        pub fn max_capacity_buffer(mut self, input: i32) -> Self {
            self.max_capacity_buffer = Some(input);
            self
        }
        /// <p>The size of the capacity buffer to use when the forecast capacity is close to or
        /// exceeds the maximum capacity. The value is specified as a percentage relative to the
        /// forecast capacity. For example, if the buffer is 10, this means a 10 percent buffer,
        /// such that if the forecast capacity is 50, and the maximum capacity is 40, then the
        /// effective maximum capacity is 55.</p>
        /// <p>If set to 0, Amazon EC2 Auto Scaling may scale capacity higher than the maximum capacity to equal but
        /// not exceed forecast capacity. </p>
        /// <p>Required if the <code>MaxCapacityBreachBehavior</code> property is set to
        /// <code>IncreaseMaxCapacity</code>, and cannot be used otherwise.</p>
        pub fn set_max_capacity_buffer(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity_buffer = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictiveScalingConfiguration`](crate::model::PredictiveScalingConfiguration)
        pub fn build(self) -> crate::model::PredictiveScalingConfiguration {
            crate::model::PredictiveScalingConfiguration {
                metric_specifications: self.metric_specifications,
                mode: self.mode,
                scheduling_buffer_time: self.scheduling_buffer_time,
                max_capacity_breach_behavior: self.max_capacity_breach_behavior,
                max_capacity_buffer: self.max_capacity_buffer,
            }
        }
    }
}
impl PredictiveScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`PredictiveScalingConfiguration`](crate::model::PredictiveScalingConfiguration)
    pub fn builder() -> crate::model::predictive_scaling_configuration::Builder {
        crate::model::predictive_scaling_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredictiveScalingMaxCapacityBreachBehavior {
    #[allow(missing_docs)] // documentation missing in model
    HonorMaxCapacity,
    #[allow(missing_docs)] // documentation missing in model
    IncreaseMaxCapacity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredictiveScalingMaxCapacityBreachBehavior {
    fn from(s: &str) -> Self {
        match s {
            "HonorMaxCapacity" => PredictiveScalingMaxCapacityBreachBehavior::HonorMaxCapacity,
            "IncreaseMaxCapacity" => {
                PredictiveScalingMaxCapacityBreachBehavior::IncreaseMaxCapacity
            }
            other => PredictiveScalingMaxCapacityBreachBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredictiveScalingMaxCapacityBreachBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredictiveScalingMaxCapacityBreachBehavior::from(s))
    }
}
impl PredictiveScalingMaxCapacityBreachBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredictiveScalingMaxCapacityBreachBehavior::HonorMaxCapacity => "HonorMaxCapacity",
            PredictiveScalingMaxCapacityBreachBehavior::IncreaseMaxCapacity => {
                "IncreaseMaxCapacity"
            }
            PredictiveScalingMaxCapacityBreachBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HonorMaxCapacity", "IncreaseMaxCapacity"]
    }
}
impl AsRef<str> for PredictiveScalingMaxCapacityBreachBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredictiveScalingMode {
    #[allow(missing_docs)] // documentation missing in model
    ForecastAndScale,
    #[allow(missing_docs)] // documentation missing in model
    ForecastOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredictiveScalingMode {
    fn from(s: &str) -> Self {
        match s {
            "ForecastAndScale" => PredictiveScalingMode::ForecastAndScale,
            "ForecastOnly" => PredictiveScalingMode::ForecastOnly,
            other => PredictiveScalingMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredictiveScalingMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredictiveScalingMode::from(s))
    }
}
impl PredictiveScalingMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredictiveScalingMode::ForecastAndScale => "ForecastAndScale",
            PredictiveScalingMode::ForecastOnly => "ForecastOnly",
            PredictiveScalingMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ForecastAndScale", "ForecastOnly"]
    }
}
impl AsRef<str> for PredictiveScalingMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure specifies the metrics and target utilization settings for a predictive
/// scaling policy. </p>
/// <p>You must specify either a metric pair, or a load metric and a scaling metric
/// individually. Specifying a metric pair instead of individual metrics provides a simpler
/// way to configure metrics for a scaling policy. You choose the metric pair, and the
/// policy automatically knows the correct sum and average statistics to use for the load
/// metric and the scaling metric.</p>
/// <p>Example</p>
/// <ul>
/// <li>
/// <p>You create a predictive scaling policy and specify
/// <code>ALBRequestCount</code> as the value for the metric pair and
/// <code>1000.0</code> as the target value. For this type of metric, you must
/// provide the metric dimension for the corresponding target group, so you also
/// provide a resource label for the Application Load Balancer target group that is
/// attached to your Auto Scaling group.</p>
/// </li>
/// <li>
/// <p>The number of requests the target group receives per minute provides the load
/// metric, and the request count averaged between the members of the target group
/// provides the scaling metric. In CloudWatch, this refers to the
/// <code>RequestCount</code> and <code>RequestCountPerTarget</code> metrics,
/// respectively.</p>
/// </li>
/// <li>
/// <p>For optimal use of predictive scaling, you adhere to the best practice of
/// using a dynamic scaling policy to automatically scale between the minimum
/// capacity and maximum capacity in response to real-time changes in resource
/// utilization.</p>
/// </li>
/// <li>
/// <p>Amazon EC2 Auto Scaling consumes data points for the load metric over the last 14 days and
/// creates an hourly load forecast for predictive scaling. (A minimum of 24 hours
/// of data is required.)</p>
/// </li>
/// <li>
/// <p>After creating the load forecast, Amazon EC2 Auto Scaling determines when to reduce or
/// increase the capacity of your Auto Scaling group in each hour of the forecast period so
/// that the average number of requests received by each instance is as close to
/// 1000 requests per minute as possible at all times.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictiveScalingMetricSpecification {
    /// <p>Specifies the target utilization.</p>
    pub target_value: std::option::Option<f64>,
    /// <p>The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling
    /// metric and load metric to use.</p>
    pub predefined_metric_pair_specification:
        std::option::Option<crate::model::PredictiveScalingPredefinedMetricPair>,
    /// <p>The scaling metric specification.</p>
    pub predefined_scaling_metric_specification:
        std::option::Option<crate::model::PredictiveScalingPredefinedScalingMetric>,
    /// <p>The load metric specification.</p>
    pub predefined_load_metric_specification:
        std::option::Option<crate::model::PredictiveScalingPredefinedLoadMetric>,
}
impl PredictiveScalingMetricSpecification {
    /// <p>Specifies the target utilization.</p>
    pub fn target_value(&self) -> std::option::Option<f64> {
        self.target_value
    }
    /// <p>The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling
    /// metric and load metric to use.</p>
    pub fn predefined_metric_pair_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingPredefinedMetricPair> {
        self.predefined_metric_pair_specification.as_ref()
    }
    /// <p>The scaling metric specification.</p>
    pub fn predefined_scaling_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingPredefinedScalingMetric> {
        self.predefined_scaling_metric_specification.as_ref()
    }
    /// <p>The load metric specification.</p>
    pub fn predefined_load_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingPredefinedLoadMetric> {
        self.predefined_load_metric_specification.as_ref()
    }
}
impl std::fmt::Debug for PredictiveScalingMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictiveScalingMetricSpecification");
        formatter.field("target_value", &self.target_value);
        formatter.field(
            "predefined_metric_pair_specification",
            &self.predefined_metric_pair_specification,
        );
        formatter.field(
            "predefined_scaling_metric_specification",
            &self.predefined_scaling_metric_specification,
        );
        formatter.field(
            "predefined_load_metric_specification",
            &self.predefined_load_metric_specification,
        );
        formatter.finish()
    }
}
/// See [`PredictiveScalingMetricSpecification`](crate::model::PredictiveScalingMetricSpecification)
pub mod predictive_scaling_metric_specification {
    /// A builder for [`PredictiveScalingMetricSpecification`](crate::model::PredictiveScalingMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_value: std::option::Option<f64>,
        pub(crate) predefined_metric_pair_specification:
            std::option::Option<crate::model::PredictiveScalingPredefinedMetricPair>,
        pub(crate) predefined_scaling_metric_specification:
            std::option::Option<crate::model::PredictiveScalingPredefinedScalingMetric>,
        pub(crate) predefined_load_metric_specification:
            std::option::Option<crate::model::PredictiveScalingPredefinedLoadMetric>,
    }
    impl Builder {
        /// <p>Specifies the target utilization.</p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>Specifies the target utilization.</p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// <p>The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling
        /// metric and load metric to use.</p>
        pub fn predefined_metric_pair_specification(
            mut self,
            input: crate::model::PredictiveScalingPredefinedMetricPair,
        ) -> Self {
            self.predefined_metric_pair_specification = Some(input);
            self
        }
        /// <p>The metric pair specification from which Amazon EC2 Auto Scaling determines the appropriate scaling
        /// metric and load metric to use.</p>
        pub fn set_predefined_metric_pair_specification(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingPredefinedMetricPair>,
        ) -> Self {
            self.predefined_metric_pair_specification = input;
            self
        }
        /// <p>The scaling metric specification.</p>
        pub fn predefined_scaling_metric_specification(
            mut self,
            input: crate::model::PredictiveScalingPredefinedScalingMetric,
        ) -> Self {
            self.predefined_scaling_metric_specification = Some(input);
            self
        }
        /// <p>The scaling metric specification.</p>
        pub fn set_predefined_scaling_metric_specification(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingPredefinedScalingMetric>,
        ) -> Self {
            self.predefined_scaling_metric_specification = input;
            self
        }
        /// <p>The load metric specification.</p>
        pub fn predefined_load_metric_specification(
            mut self,
            input: crate::model::PredictiveScalingPredefinedLoadMetric,
        ) -> Self {
            self.predefined_load_metric_specification = Some(input);
            self
        }
        /// <p>The load metric specification.</p>
        pub fn set_predefined_load_metric_specification(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingPredefinedLoadMetric>,
        ) -> Self {
            self.predefined_load_metric_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictiveScalingMetricSpecification`](crate::model::PredictiveScalingMetricSpecification)
        pub fn build(self) -> crate::model::PredictiveScalingMetricSpecification {
            crate::model::PredictiveScalingMetricSpecification {
                target_value: self.target_value,
                predefined_metric_pair_specification: self.predefined_metric_pair_specification,
                predefined_scaling_metric_specification: self
                    .predefined_scaling_metric_specification,
                predefined_load_metric_specification: self.predefined_load_metric_specification,
            }
        }
    }
}
impl PredictiveScalingMetricSpecification {
    /// Creates a new builder-style object to manufacture [`PredictiveScalingMetricSpecification`](crate::model::PredictiveScalingMetricSpecification)
    pub fn builder() -> crate::model::predictive_scaling_metric_specification::Builder {
        crate::model::predictive_scaling_metric_specification::Builder::default()
    }
}

/// <p>Describes a load metric for a predictive scaling policy.</p>
/// <p>When returned in the output of <code>DescribePolicies</code>, it indicates that a
/// predictive scaling policy uses individually specified load and scaling metrics instead
/// of a metric pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictiveScalingPredefinedLoadMetric {
    /// <p>The metric type.</p>
    pub predefined_metric_type: std::option::Option<crate::model::PredefinedLoadMetricType>,
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
    /// the request count served by your Auto Scaling group. You can't specify a resource label
    /// unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub resource_label: std::option::Option<std::string::String>,
}
impl PredictiveScalingPredefinedLoadMetric {
    /// <p>The metric type.</p>
    pub fn predefined_metric_type(
        &self,
    ) -> std::option::Option<&crate::model::PredefinedLoadMetricType> {
        self.predefined_metric_type.as_ref()
    }
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
    /// the request count served by your Auto Scaling group. You can't specify a resource label
    /// unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn resource_label(&self) -> std::option::Option<&str> {
        self.resource_label.as_deref()
    }
}
impl std::fmt::Debug for PredictiveScalingPredefinedLoadMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictiveScalingPredefinedLoadMetric");
        formatter.field("predefined_metric_type", &self.predefined_metric_type);
        formatter.field("resource_label", &self.resource_label);
        formatter.finish()
    }
}
/// See [`PredictiveScalingPredefinedLoadMetric`](crate::model::PredictiveScalingPredefinedLoadMetric)
pub mod predictive_scaling_predefined_load_metric {
    /// A builder for [`PredictiveScalingPredefinedLoadMetric`](crate::model::PredictiveScalingPredefinedLoadMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_metric_type:
            std::option::Option<crate::model::PredefinedLoadMetricType>,
        pub(crate) resource_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric type.</p>
        pub fn predefined_metric_type(
            mut self,
            input: crate::model::PredefinedLoadMetricType,
        ) -> Self {
            self.predefined_metric_type = Some(input);
            self
        }
        /// <p>The metric type.</p>
        pub fn set_predefined_metric_type(
            mut self,
            input: std::option::Option<crate::model::PredefinedLoadMetricType>,
        ) -> Self {
            self.predefined_metric_type = input;
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
        /// the request count served by your Auto Scaling group. You can't specify a resource label
        /// unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn resource_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_label = Some(input.into());
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
        /// the request count served by your Auto Scaling group. You can't specify a resource label
        /// unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_resource_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_label = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictiveScalingPredefinedLoadMetric`](crate::model::PredictiveScalingPredefinedLoadMetric)
        pub fn build(self) -> crate::model::PredictiveScalingPredefinedLoadMetric {
            crate::model::PredictiveScalingPredefinedLoadMetric {
                predefined_metric_type: self.predefined_metric_type,
                resource_label: self.resource_label,
            }
        }
    }
}
impl PredictiveScalingPredefinedLoadMetric {
    /// Creates a new builder-style object to manufacture [`PredictiveScalingPredefinedLoadMetric`](crate::model::PredictiveScalingPredefinedLoadMetric)
    pub fn builder() -> crate::model::predictive_scaling_predefined_load_metric::Builder {
        crate::model::predictive_scaling_predefined_load_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredefinedLoadMetricType {
    #[allow(missing_docs)] // documentation missing in model
    AlbTargetGroupRequestCount,
    #[allow(missing_docs)] // documentation missing in model
    AsgTotalCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    AsgTotalNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    AsgTotalNetworkOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredefinedLoadMetricType {
    fn from(s: &str) -> Self {
        match s {
            "ALBTargetGroupRequestCount" => PredefinedLoadMetricType::AlbTargetGroupRequestCount,
            "ASGTotalCPUUtilization" => PredefinedLoadMetricType::AsgTotalCpuUtilization,
            "ASGTotalNetworkIn" => PredefinedLoadMetricType::AsgTotalNetworkIn,
            "ASGTotalNetworkOut" => PredefinedLoadMetricType::AsgTotalNetworkOut,
            other => PredefinedLoadMetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredefinedLoadMetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredefinedLoadMetricType::from(s))
    }
}
impl PredefinedLoadMetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredefinedLoadMetricType::AlbTargetGroupRequestCount => "ALBTargetGroupRequestCount",
            PredefinedLoadMetricType::AsgTotalCpuUtilization => "ASGTotalCPUUtilization",
            PredefinedLoadMetricType::AsgTotalNetworkIn => "ASGTotalNetworkIn",
            PredefinedLoadMetricType::AsgTotalNetworkOut => "ASGTotalNetworkOut",
            PredefinedLoadMetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALBTargetGroupRequestCount",
            "ASGTotalCPUUtilization",
            "ASGTotalNetworkIn",
            "ASGTotalNetworkOut",
        ]
    }
}
impl AsRef<str> for PredefinedLoadMetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a scaling metric for a predictive scaling policy.</p>
/// <p>When returned in the output of <code>DescribePolicies</code>, it indicates that a
/// predictive scaling policy uses individually specified load and scaling metrics instead
/// of a metric pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictiveScalingPredefinedScalingMetric {
    /// <p>The metric type.</p>
    pub predefined_metric_type: std::option::Option<crate::model::PredefinedScalingMetricType>,
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
    /// the average request count served by your Auto Scaling group. You can't specify a resource
    /// label unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub resource_label: std::option::Option<std::string::String>,
}
impl PredictiveScalingPredefinedScalingMetric {
    /// <p>The metric type.</p>
    pub fn predefined_metric_type(
        &self,
    ) -> std::option::Option<&crate::model::PredefinedScalingMetricType> {
        self.predefined_metric_type.as_ref()
    }
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
    /// the average request count served by your Auto Scaling group. You can't specify a resource
    /// label unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn resource_label(&self) -> std::option::Option<&str> {
        self.resource_label.as_deref()
    }
}
impl std::fmt::Debug for PredictiveScalingPredefinedScalingMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictiveScalingPredefinedScalingMetric");
        formatter.field("predefined_metric_type", &self.predefined_metric_type);
        formatter.field("resource_label", &self.resource_label);
        formatter.finish()
    }
}
/// See [`PredictiveScalingPredefinedScalingMetric`](crate::model::PredictiveScalingPredefinedScalingMetric)
pub mod predictive_scaling_predefined_scaling_metric {
    /// A builder for [`PredictiveScalingPredefinedScalingMetric`](crate::model::PredictiveScalingPredefinedScalingMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_metric_type:
            std::option::Option<crate::model::PredefinedScalingMetricType>,
        pub(crate) resource_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric type.</p>
        pub fn predefined_metric_type(
            mut self,
            input: crate::model::PredefinedScalingMetricType,
        ) -> Self {
            self.predefined_metric_type = Some(input);
            self
        }
        /// <p>The metric type.</p>
        pub fn set_predefined_metric_type(
            mut self,
            input: std::option::Option<crate::model::PredefinedScalingMetricType>,
        ) -> Self {
            self.predefined_metric_type = input;
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
        /// the average request count served by your Auto Scaling group. You can't specify a resource
        /// label unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn resource_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_label = Some(input.into());
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
        /// the average request count served by your Auto Scaling group. You can't specify a resource
        /// label unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_resource_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_label = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictiveScalingPredefinedScalingMetric`](crate::model::PredictiveScalingPredefinedScalingMetric)
        pub fn build(self) -> crate::model::PredictiveScalingPredefinedScalingMetric {
            crate::model::PredictiveScalingPredefinedScalingMetric {
                predefined_metric_type: self.predefined_metric_type,
                resource_label: self.resource_label,
            }
        }
    }
}
impl PredictiveScalingPredefinedScalingMetric {
    /// Creates a new builder-style object to manufacture [`PredictiveScalingPredefinedScalingMetric`](crate::model::PredictiveScalingPredefinedScalingMetric)
    pub fn builder() -> crate::model::predictive_scaling_predefined_scaling_metric::Builder {
        crate::model::predictive_scaling_predefined_scaling_metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredefinedScalingMetricType {
    #[allow(missing_docs)] // documentation missing in model
    AlbRequestCountPerTarget,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageNetworkOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredefinedScalingMetricType {
    fn from(s: &str) -> Self {
        match s {
            "ALBRequestCountPerTarget" => PredefinedScalingMetricType::AlbRequestCountPerTarget,
            "ASGAverageCPUUtilization" => PredefinedScalingMetricType::AsgAverageCpuUtilization,
            "ASGAverageNetworkIn" => PredefinedScalingMetricType::AsgAverageNetworkIn,
            "ASGAverageNetworkOut" => PredefinedScalingMetricType::AsgAverageNetworkOut,
            other => PredefinedScalingMetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredefinedScalingMetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredefinedScalingMetricType::from(s))
    }
}
impl PredefinedScalingMetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredefinedScalingMetricType::AlbRequestCountPerTarget => "ALBRequestCountPerTarget",
            PredefinedScalingMetricType::AsgAverageCpuUtilization => "ASGAverageCPUUtilization",
            PredefinedScalingMetricType::AsgAverageNetworkIn => "ASGAverageNetworkIn",
            PredefinedScalingMetricType::AsgAverageNetworkOut => "ASGAverageNetworkOut",
            PredefinedScalingMetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALBRequestCountPerTarget",
            "ASGAverageCPUUtilization",
            "ASGAverageNetworkIn",
            "ASGAverageNetworkOut",
        ]
    }
}
impl AsRef<str> for PredefinedScalingMetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a metric pair for a predictive scaling policy. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictiveScalingPredefinedMetricPair {
    /// <p>Indicates which metrics to use. There are two different types of metrics for each
    /// metric type: one is a load metric and one is a scaling metric. For example, if the
    /// metric type is <code>ASGCPUUtilization</code>, the Auto Scaling group's total CPU metric is used
    /// as the load metric, and the average CPU metric is used for the scaling metric.</p>
    pub predefined_metric_type: std::option::Option<crate::model::PredefinedMetricPairType>,
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
    /// the total and average request count served by your Auto Scaling group. You can't specify a
    /// resource label unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub resource_label: std::option::Option<std::string::String>,
}
impl PredictiveScalingPredefinedMetricPair {
    /// <p>Indicates which metrics to use. There are two different types of metrics for each
    /// metric type: one is a load metric and one is a scaling metric. For example, if the
    /// metric type is <code>ASGCPUUtilization</code>, the Auto Scaling group's total CPU metric is used
    /// as the load metric, and the average CPU metric is used for the scaling metric.</p>
    pub fn predefined_metric_type(
        &self,
    ) -> std::option::Option<&crate::model::PredefinedMetricPairType> {
        self.predefined_metric_type.as_ref()
    }
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
    /// the total and average request count served by your Auto Scaling group. You can't specify a
    /// resource label unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn resource_label(&self) -> std::option::Option<&str> {
        self.resource_label.as_deref()
    }
}
impl std::fmt::Debug for PredictiveScalingPredefinedMetricPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictiveScalingPredefinedMetricPair");
        formatter.field("predefined_metric_type", &self.predefined_metric_type);
        formatter.field("resource_label", &self.resource_label);
        formatter.finish()
    }
}
/// See [`PredictiveScalingPredefinedMetricPair`](crate::model::PredictiveScalingPredefinedMetricPair)
pub mod predictive_scaling_predefined_metric_pair {
    /// A builder for [`PredictiveScalingPredefinedMetricPair`](crate::model::PredictiveScalingPredefinedMetricPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_metric_type:
            std::option::Option<crate::model::PredefinedMetricPairType>,
        pub(crate) resource_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates which metrics to use. There are two different types of metrics for each
        /// metric type: one is a load metric and one is a scaling metric. For example, if the
        /// metric type is <code>ASGCPUUtilization</code>, the Auto Scaling group's total CPU metric is used
        /// as the load metric, and the average CPU metric is used for the scaling metric.</p>
        pub fn predefined_metric_type(
            mut self,
            input: crate::model::PredefinedMetricPairType,
        ) -> Self {
            self.predefined_metric_type = Some(input);
            self
        }
        /// <p>Indicates which metrics to use. There are two different types of metrics for each
        /// metric type: one is a load metric and one is a scaling metric. For example, if the
        /// metric type is <code>ASGCPUUtilization</code>, the Auto Scaling group's total CPU metric is used
        /// as the load metric, and the average CPU metric is used for the scaling metric.</p>
        pub fn set_predefined_metric_type(
            mut self,
            input: std::option::Option<crate::model::PredefinedMetricPairType>,
        ) -> Self {
            self.predefined_metric_type = input;
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
        /// the total and average request count served by your Auto Scaling group. You can't specify a
        /// resource label unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn resource_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_label = Some(input.into());
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group from which to determine
        /// the total and average request count served by your Auto Scaling group. You can't specify a
        /// resource label unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_resource_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_label = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictiveScalingPredefinedMetricPair`](crate::model::PredictiveScalingPredefinedMetricPair)
        pub fn build(self) -> crate::model::PredictiveScalingPredefinedMetricPair {
            crate::model::PredictiveScalingPredefinedMetricPair {
                predefined_metric_type: self.predefined_metric_type,
                resource_label: self.resource_label,
            }
        }
    }
}
impl PredictiveScalingPredefinedMetricPair {
    /// Creates a new builder-style object to manufacture [`PredictiveScalingPredefinedMetricPair`](crate::model::PredictiveScalingPredefinedMetricPair)
    pub fn builder() -> crate::model::predictive_scaling_predefined_metric_pair::Builder {
        crate::model::predictive_scaling_predefined_metric_pair::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PredefinedMetricPairType {
    #[allow(missing_docs)] // documentation missing in model
    AlbRequestCount,
    #[allow(missing_docs)] // documentation missing in model
    AsgcpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    AsgNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    AsgNetworkOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PredefinedMetricPairType {
    fn from(s: &str) -> Self {
        match s {
            "ALBRequestCount" => PredefinedMetricPairType::AlbRequestCount,
            "ASGCPUUtilization" => PredefinedMetricPairType::AsgcpuUtilization,
            "ASGNetworkIn" => PredefinedMetricPairType::AsgNetworkIn,
            "ASGNetworkOut" => PredefinedMetricPairType::AsgNetworkOut,
            other => PredefinedMetricPairType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PredefinedMetricPairType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PredefinedMetricPairType::from(s))
    }
}
impl PredefinedMetricPairType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PredefinedMetricPairType::AlbRequestCount => "ALBRequestCount",
            PredefinedMetricPairType::AsgcpuUtilization => "ASGCPUUtilization",
            PredefinedMetricPairType::AsgNetworkIn => "ASGNetworkIn",
            PredefinedMetricPairType::AsgNetworkOut => "ASGNetworkOut",
            PredefinedMetricPairType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALBRequestCount",
            "ASGCPUUtilization",
            "ASGNetworkIn",
            "ASGNetworkOut",
        ]
    }
}
impl AsRef<str> for PredefinedMetricPairType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a target tracking scaling policy configuration to use with Amazon EC2 Auto Scaling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetTrackingConfiguration {
    /// <p>A predefined metric. You must specify either a predefined metric or a customized
    /// metric.</p>
    pub predefined_metric_specification:
        std::option::Option<crate::model::PredefinedMetricSpecification>,
    /// <p>A customized metric. You must specify either a predefined metric or a customized
    /// metric.</p>
    pub customized_metric_specification:
        std::option::Option<crate::model::CustomizedMetricSpecification>,
    /// <p>The target value for the metric.</p>
    pub target_value: std::option::Option<f64>,
    /// <p>Indicates whether scaling in by the target tracking scaling policy is disabled. If
    /// scaling in is disabled, the target tracking scaling policy doesn't remove instances from
    /// the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from
    /// the Auto Scaling group. The default is <code>false</code>.</p>
    pub disable_scale_in: std::option::Option<bool>,
}
impl TargetTrackingConfiguration {
    /// <p>A predefined metric. You must specify either a predefined metric or a customized
    /// metric.</p>
    pub fn predefined_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredefinedMetricSpecification> {
        self.predefined_metric_specification.as_ref()
    }
    /// <p>A customized metric. You must specify either a predefined metric or a customized
    /// metric.</p>
    pub fn customized_metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::CustomizedMetricSpecification> {
        self.customized_metric_specification.as_ref()
    }
    /// <p>The target value for the metric.</p>
    pub fn target_value(&self) -> std::option::Option<f64> {
        self.target_value
    }
    /// <p>Indicates whether scaling in by the target tracking scaling policy is disabled. If
    /// scaling in is disabled, the target tracking scaling policy doesn't remove instances from
    /// the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from
    /// the Auto Scaling group. The default is <code>false</code>.</p>
    pub fn disable_scale_in(&self) -> std::option::Option<bool> {
        self.disable_scale_in
    }
}
impl std::fmt::Debug for TargetTrackingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetTrackingConfiguration");
        formatter.field(
            "predefined_metric_specification",
            &self.predefined_metric_specification,
        );
        formatter.field(
            "customized_metric_specification",
            &self.customized_metric_specification,
        );
        formatter.field("target_value", &self.target_value);
        formatter.field("disable_scale_in", &self.disable_scale_in);
        formatter.finish()
    }
}
/// See [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
pub mod target_tracking_configuration {
    /// A builder for [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_metric_specification:
            std::option::Option<crate::model::PredefinedMetricSpecification>,
        pub(crate) customized_metric_specification:
            std::option::Option<crate::model::CustomizedMetricSpecification>,
        pub(crate) target_value: std::option::Option<f64>,
        pub(crate) disable_scale_in: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A predefined metric. You must specify either a predefined metric or a customized
        /// metric.</p>
        pub fn predefined_metric_specification(
            mut self,
            input: crate::model::PredefinedMetricSpecification,
        ) -> Self {
            self.predefined_metric_specification = Some(input);
            self
        }
        /// <p>A predefined metric. You must specify either a predefined metric or a customized
        /// metric.</p>
        pub fn set_predefined_metric_specification(
            mut self,
            input: std::option::Option<crate::model::PredefinedMetricSpecification>,
        ) -> Self {
            self.predefined_metric_specification = input;
            self
        }
        /// <p>A customized metric. You must specify either a predefined metric or a customized
        /// metric.</p>
        pub fn customized_metric_specification(
            mut self,
            input: crate::model::CustomizedMetricSpecification,
        ) -> Self {
            self.customized_metric_specification = Some(input);
            self
        }
        /// <p>A customized metric. You must specify either a predefined metric or a customized
        /// metric.</p>
        pub fn set_customized_metric_specification(
            mut self,
            input: std::option::Option<crate::model::CustomizedMetricSpecification>,
        ) -> Self {
            self.customized_metric_specification = input;
            self
        }
        /// <p>The target value for the metric.</p>
        pub fn target_value(mut self, input: f64) -> Self {
            self.target_value = Some(input);
            self
        }
        /// <p>The target value for the metric.</p>
        pub fn set_target_value(mut self, input: std::option::Option<f64>) -> Self {
            self.target_value = input;
            self
        }
        /// <p>Indicates whether scaling in by the target tracking scaling policy is disabled. If
        /// scaling in is disabled, the target tracking scaling policy doesn't remove instances from
        /// the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from
        /// the Auto Scaling group. The default is <code>false</code>.</p>
        pub fn disable_scale_in(mut self, input: bool) -> Self {
            self.disable_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether scaling in by the target tracking scaling policy is disabled. If
        /// scaling in is disabled, the target tracking scaling policy doesn't remove instances from
        /// the Auto Scaling group. Otherwise, the target tracking scaling policy can remove instances from
        /// the Auto Scaling group. The default is <code>false</code>.</p>
        pub fn set_disable_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_scale_in = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
        pub fn build(self) -> crate::model::TargetTrackingConfiguration {
            crate::model::TargetTrackingConfiguration {
                predefined_metric_specification: self.predefined_metric_specification,
                customized_metric_specification: self.customized_metric_specification,
                target_value: self.target_value,
                disable_scale_in: self.disable_scale_in,
            }
        }
    }
}
impl TargetTrackingConfiguration {
    /// Creates a new builder-style object to manufacture [`TargetTrackingConfiguration`](crate::model::TargetTrackingConfiguration)
    pub fn builder() -> crate::model::target_tracking_configuration::Builder {
        crate::model::target_tracking_configuration::Builder::default()
    }
}

/// <p>Represents a CloudWatch metric of your choosing for a target tracking scaling policy to use
/// with Amazon EC2 Auto Scaling.</p>
/// <p>To create your customized metric specification:</p>
/// <ul>
/// <li>
/// <p>Add values for each required parameter from CloudWatch. You can use an existing
/// metric, or a new metric that you create. To use your own metric, you must first
/// publish the metric to CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html">Publish
/// Custom Metrics</a> in the <i>Amazon CloudWatch User
/// Guide</i>.</p>
/// </li>
/// <li>
/// <p>Choose a metric that changes proportionally with capacity. The value of the
/// metric should increase or decrease in inverse proportion to the number of
/// capacity units. That is, the value of the metric should decrease when capacity
/// increases.</p>
/// </li>
/// </ul>
/// <p>For more information about CloudWatch, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html">Amazon CloudWatch
/// Concepts</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomizedMetricSpecification {
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the metric.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The dimensions of the metric.</p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same
    /// dimensions in your scaling policy.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
    /// <p>The statistic of the metric.</p>
    pub statistic: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The unit of the metric.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl CustomizedMetricSpecification {
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The namespace of the metric.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The dimensions of the metric.</p>
    /// <p>Conditional: If you published your metric with dimensions, you must specify the same
    /// dimensions in your scaling policy.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::MetricDimension]> {
        self.dimensions.as_deref()
    }
    /// <p>The statistic of the metric.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::MetricStatistic> {
        self.statistic.as_ref()
    }
    /// <p>The unit of the metric.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for CustomizedMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomizedMetricSpecification");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("statistic", &self.statistic);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
pub mod customized_metric_specification {
    /// A builder for [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        pub(crate) statistic: std::option::Option<crate::model::MetricStatistic>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions of the metric.</p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same
        /// dimensions in your scaling policy.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::MetricDimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions of the metric.</p>
        /// <p>Conditional: If you published your metric with dimensions, you must specify the same
        /// dimensions in your scaling policy.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The statistic of the metric.</p>
        pub fn statistic(mut self, input: crate::model::MetricStatistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic of the metric.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::MetricStatistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit of the metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
        pub fn build(self) -> crate::model::CustomizedMetricSpecification {
            crate::model::CustomizedMetricSpecification {
                metric_name: self.metric_name,
                namespace: self.namespace,
                dimensions: self.dimensions,
                statistic: self.statistic,
                unit: self.unit,
            }
        }
    }
}
impl CustomizedMetricSpecification {
    /// Creates a new builder-style object to manufacture [`CustomizedMetricSpecification`](crate::model::CustomizedMetricSpecification)
    pub fn builder() -> crate::model::customized_metric_specification::Builder {
        crate::model::customized_metric_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricStatistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricStatistic {
    fn from(s: &str) -> Self {
        match s {
            "Average" => MetricStatistic::Average,
            "Maximum" => MetricStatistic::Maximum,
            "Minimum" => MetricStatistic::Minimum,
            "SampleCount" => MetricStatistic::SampleCount,
            "Sum" => MetricStatistic::Sum,
            other => MetricStatistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricStatistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricStatistic::from(s))
    }
}
impl MetricStatistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricStatistic::Average => "Average",
            MetricStatistic::Maximum => "Maximum",
            MetricStatistic::Minimum => "Minimum",
            MetricStatistic::SampleCount => "SampleCount",
            MetricStatistic::Sum => "Sum",
            MetricStatistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum", "Minimum", "SampleCount", "Sum"]
    }
}
impl AsRef<str> for MetricStatistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the dimension of a metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDimension {
    /// <p>The name of the dimension.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the dimension.</p>
    pub value: std::option::Option<std::string::String>,
}
impl MetricDimension {
    /// <p>The name of the dimension.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the dimension.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MetricDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MetricDimension`](crate::model::MetricDimension)
pub mod metric_dimension {
    /// A builder for [`MetricDimension`](crate::model::MetricDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dimension.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dimension.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDimension`](crate::model::MetricDimension)
        pub fn build(self) -> crate::model::MetricDimension {
            crate::model::MetricDimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl MetricDimension {
    /// Creates a new builder-style object to manufacture [`MetricDimension`](crate::model::MetricDimension)
    pub fn builder() -> crate::model::metric_dimension::Builder {
        crate::model::metric_dimension::Builder::default()
    }
}

/// <p>Represents a predefined metric for a target tracking scaling policy to use with
/// Amazon EC2 Auto Scaling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredefinedMetricSpecification {
    /// <p>The metric type. The following predefined metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASGAverageCPUUtilization</code> - Average CPU utilization of the Auto Scaling
    /// group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ASGAverageNetworkIn</code> - Average number of bytes received on all
    /// network interfaces by the Auto Scaling group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ASGAverageNetworkOut</code> - Average number of bytes sent out on all
    /// network interfaces by the Auto Scaling group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALBRequestCountPerTarget</code> - Number of requests completed per
    /// target in an Application Load Balancer target group.</p>
    /// </li>
    /// </ul>
    pub predefined_metric_type: std::option::Option<crate::model::MetricType>,
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group
    /// from which to determine the average request count served by your Auto Scaling group. You can't
    /// specify a resource label unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub resource_label: std::option::Option<std::string::String>,
}
impl PredefinedMetricSpecification {
    /// <p>The metric type. The following predefined metrics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ASGAverageCPUUtilization</code> - Average CPU utilization of the Auto Scaling
    /// group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ASGAverageNetworkIn</code> - Average number of bytes received on all
    /// network interfaces by the Auto Scaling group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ASGAverageNetworkOut</code> - Average number of bytes sent out on all
    /// network interfaces by the Auto Scaling group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ALBRequestCountPerTarget</code> - Number of requests completed per
    /// target in an Application Load Balancer target group.</p>
    /// </li>
    /// </ul>
    pub fn predefined_metric_type(&self) -> std::option::Option<&crate::model::MetricType> {
        self.predefined_metric_type.as_ref()
    }
    /// <p>A label that uniquely identifies a specific Application Load Balancer target group
    /// from which to determine the average request count served by your Auto Scaling group. You can't
    /// specify a resource label unless the target group is attached to the Auto Scaling group.</p>
    /// <p>You create the resource label by appending the final portion of the load balancer ARN
    /// and the final portion of the target group ARN into a single value, separated by a forward
    /// slash (/). The format of the resource label is:</p>
    /// <p>
    /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
    /// <p>Where:</p>
    /// <ul>
    /// <li>
    /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
    /// the load balancer ARN</p>
    /// </li>
    /// <li>
    /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
    /// of the target group ARN.</p>
    /// </li>
    /// </ul>
    /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
    /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
    pub fn resource_label(&self) -> std::option::Option<&str> {
        self.resource_label.as_deref()
    }
}
impl std::fmt::Debug for PredefinedMetricSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredefinedMetricSpecification");
        formatter.field("predefined_metric_type", &self.predefined_metric_type);
        formatter.field("resource_label", &self.resource_label);
        formatter.finish()
    }
}
/// See [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
pub mod predefined_metric_specification {
    /// A builder for [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) predefined_metric_type: std::option::Option<crate::model::MetricType>,
        pub(crate) resource_label: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The metric type. The following predefined metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASGAverageCPUUtilization</code> - Average CPU utilization of the Auto Scaling
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ASGAverageNetworkIn</code> - Average number of bytes received on all
        /// network interfaces by the Auto Scaling group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ASGAverageNetworkOut</code> - Average number of bytes sent out on all
        /// network interfaces by the Auto Scaling group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALBRequestCountPerTarget</code> - Number of requests completed per
        /// target in an Application Load Balancer target group.</p>
        /// </li>
        /// </ul>
        pub fn predefined_metric_type(mut self, input: crate::model::MetricType) -> Self {
            self.predefined_metric_type = Some(input);
            self
        }
        /// <p>The metric type. The following predefined metrics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASGAverageCPUUtilization</code> - Average CPU utilization of the Auto Scaling
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ASGAverageNetworkIn</code> - Average number of bytes received on all
        /// network interfaces by the Auto Scaling group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ASGAverageNetworkOut</code> - Average number of bytes sent out on all
        /// network interfaces by the Auto Scaling group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ALBRequestCountPerTarget</code> - Number of requests completed per
        /// target in an Application Load Balancer target group.</p>
        /// </li>
        /// </ul>
        pub fn set_predefined_metric_type(
            mut self,
            input: std::option::Option<crate::model::MetricType>,
        ) -> Self {
            self.predefined_metric_type = input;
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group
        /// from which to determine the average request count served by your Auto Scaling group. You can't
        /// specify a resource label unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn resource_label(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_label = Some(input.into());
            self
        }
        /// <p>A label that uniquely identifies a specific Application Load Balancer target group
        /// from which to determine the average request count served by your Auto Scaling group. You can't
        /// specify a resource label unless the target group is attached to the Auto Scaling group.</p>
        /// <p>You create the resource label by appending the final portion of the load balancer ARN
        /// and the final portion of the target group ARN into a single value, separated by a forward
        /// slash (/). The format of the resource label is:</p>
        /// <p>
        /// <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.</p>
        /// <p>Where:</p>
        /// <ul>
        /// <li>
        /// <p>app/<load-balancer-name>/<load-balancer-id> is the final portion of
        /// the load balancer ARN</p>
        /// </li>
        /// <li>
        /// <p>targetgroup/<target-group-name>/<target-group-id> is the final portion
        /// of the target group ARN.</p>
        /// </li>
        /// </ul>
        /// <p>To find the ARN for an Application Load Balancer, use the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html">DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use
        /// the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html">DescribeTargetGroups</a> API operation.</p>
        pub fn set_resource_label(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_label = input;
            self
        }
        /// Consumes the builder and constructs a [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
        pub fn build(self) -> crate::model::PredefinedMetricSpecification {
            crate::model::PredefinedMetricSpecification {
                predefined_metric_type: self.predefined_metric_type,
                resource_label: self.resource_label,
            }
        }
    }
}
impl PredefinedMetricSpecification {
    /// Creates a new builder-style object to manufacture [`PredefinedMetricSpecification`](crate::model::PredefinedMetricSpecification)
    pub fn builder() -> crate::model::predefined_metric_specification::Builder {
        crate::model::predefined_metric_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricType {
    #[allow(missing_docs)] // documentation missing in model
    AlbRequestCountPerTarget,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageCpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageNetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    AsgAverageNetworkOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricType {
    fn from(s: &str) -> Self {
        match s {
            "ALBRequestCountPerTarget" => MetricType::AlbRequestCountPerTarget,
            "ASGAverageCPUUtilization" => MetricType::AsgAverageCpuUtilization,
            "ASGAverageNetworkIn" => MetricType::AsgAverageNetworkIn,
            "ASGAverageNetworkOut" => MetricType::AsgAverageNetworkOut,
            other => MetricType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricType::from(s))
    }
}
impl MetricType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricType::AlbRequestCountPerTarget => "ALBRequestCountPerTarget",
            MetricType::AsgAverageCpuUtilization => "ASGAverageCPUUtilization",
            MetricType::AsgAverageNetworkIn => "ASGAverageNetworkIn",
            MetricType::AsgAverageNetworkOut => "ASGAverageNetworkOut",
            MetricType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALBRequestCountPerTarget",
            "ASGAverageCPUUtilization",
            "ASGAverageNetworkIn",
            "ASGAverageNetworkOut",
        ]
    }
}
impl AsRef<str> for MetricType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes information used to create a step adjustment for a step scaling
/// policy.</p>
/// <p>For the following examples, suppose that you have an alarm with a breach threshold of
/// 50:</p>
/// <ul>
/// <li>
/// <p>To trigger the adjustment when the metric is greater than or equal to 50 and
/// less than 60, specify a lower bound of 0 and an upper bound of 10.</p>
/// </li>
/// <li>
/// <p>To trigger the adjustment when the metric is greater than 40 and less than or
/// equal to 50, specify a lower bound of -10 and an upper bound of 0.</p>
/// </li>
/// </ul>
/// <p>There are a few rules for the step adjustments for your step policy:</p>
/// <ul>
/// <li>
/// <p>The ranges of your step adjustments can't overlap or have a gap.</p>
/// </li>
/// <li>
/// <p>At most, one step adjustment can have a null lower bound. If one step
/// adjustment has a negative lower bound, then there must be a step adjustment with
/// a null lower bound.</p>
/// </li>
/// <li>
/// <p>At most, one step adjustment can have a null upper bound. If one step
/// adjustment has a positive upper bound, then there must be a step adjustment with
/// a null upper bound.</p>
/// </li>
/// <li>
/// <p>The upper and lower bound can't be null in the same step adjustment.</p>
/// </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps">Step
/// adjustments</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StepAdjustment {
    /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If
    /// the metric value is above the breach threshold, the lower bound is inclusive (the metric
    /// must be greater than or equal to the threshold plus the lower bound). Otherwise, it is
    /// exclusive (the metric must be greater than the threshold plus the lower bound). A null
    /// value indicates negative infinity.</p>
    pub metric_interval_lower_bound: std::option::Option<f64>,
    /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If
    /// the metric value is above the breach threshold, the upper bound is exclusive (the metric
    /// must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the
    /// metric must be less than or equal to the threshold plus the upper bound). A null value
    /// indicates positive infinity.</p>
    /// <p>The upper bound must be greater than the lower bound.</p>
    pub metric_interval_upper_bound: std::option::Option<f64>,
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
    /// adds to the current capacity while a negative number removes from the current
    /// capacity.</p>
    pub scaling_adjustment: std::option::Option<i32>,
}
impl StepAdjustment {
    /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If
    /// the metric value is above the breach threshold, the lower bound is inclusive (the metric
    /// must be greater than or equal to the threshold plus the lower bound). Otherwise, it is
    /// exclusive (the metric must be greater than the threshold plus the lower bound). A null
    /// value indicates negative infinity.</p>
    pub fn metric_interval_lower_bound(&self) -> std::option::Option<f64> {
        self.metric_interval_lower_bound
    }
    /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If
    /// the metric value is above the breach threshold, the upper bound is exclusive (the metric
    /// must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the
    /// metric must be less than or equal to the threshold plus the upper bound). A null value
    /// indicates positive infinity.</p>
    /// <p>The upper bound must be greater than the lower bound.</p>
    pub fn metric_interval_upper_bound(&self) -> std::option::Option<f64> {
        self.metric_interval_upper_bound
    }
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
    /// adds to the current capacity while a negative number removes from the current
    /// capacity.</p>
    pub fn scaling_adjustment(&self) -> std::option::Option<i32> {
        self.scaling_adjustment
    }
}
impl std::fmt::Debug for StepAdjustment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StepAdjustment");
        formatter.field(
            "metric_interval_lower_bound",
            &self.metric_interval_lower_bound,
        );
        formatter.field(
            "metric_interval_upper_bound",
            &self.metric_interval_upper_bound,
        );
        formatter.field("scaling_adjustment", &self.scaling_adjustment);
        formatter.finish()
    }
}
/// See [`StepAdjustment`](crate::model::StepAdjustment)
pub mod step_adjustment {
    /// A builder for [`StepAdjustment`](crate::model::StepAdjustment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_interval_lower_bound: std::option::Option<f64>,
        pub(crate) metric_interval_upper_bound: std::option::Option<f64>,
        pub(crate) scaling_adjustment: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If
        /// the metric value is above the breach threshold, the lower bound is inclusive (the metric
        /// must be greater than or equal to the threshold plus the lower bound). Otherwise, it is
        /// exclusive (the metric must be greater than the threshold plus the lower bound). A null
        /// value indicates negative infinity.</p>
        pub fn metric_interval_lower_bound(mut self, input: f64) -> Self {
            self.metric_interval_lower_bound = Some(input);
            self
        }
        /// <p>The lower bound for the difference between the alarm threshold and the CloudWatch metric. If
        /// the metric value is above the breach threshold, the lower bound is inclusive (the metric
        /// must be greater than or equal to the threshold plus the lower bound). Otherwise, it is
        /// exclusive (the metric must be greater than the threshold plus the lower bound). A null
        /// value indicates negative infinity.</p>
        pub fn set_metric_interval_lower_bound(mut self, input: std::option::Option<f64>) -> Self {
            self.metric_interval_lower_bound = input;
            self
        }
        /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If
        /// the metric value is above the breach threshold, the upper bound is exclusive (the metric
        /// must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the
        /// metric must be less than or equal to the threshold plus the upper bound). A null value
        /// indicates positive infinity.</p>
        /// <p>The upper bound must be greater than the lower bound.</p>
        pub fn metric_interval_upper_bound(mut self, input: f64) -> Self {
            self.metric_interval_upper_bound = Some(input);
            self
        }
        /// <p>The upper bound for the difference between the alarm threshold and the CloudWatch metric. If
        /// the metric value is above the breach threshold, the upper bound is exclusive (the metric
        /// must be less than the threshold plus the upper bound). Otherwise, it is inclusive (the
        /// metric must be less than or equal to the threshold plus the upper bound). A null value
        /// indicates positive infinity.</p>
        /// <p>The upper bound must be greater than the lower bound.</p>
        pub fn set_metric_interval_upper_bound(mut self, input: std::option::Option<f64>) -> Self {
            self.metric_interval_upper_bound = input;
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
        /// adds to the current capacity while a negative number removes from the current
        /// capacity.</p>
        pub fn scaling_adjustment(mut self, input: i32) -> Self {
            self.scaling_adjustment = Some(input);
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
        /// adds to the current capacity while a negative number removes from the current
        /// capacity.</p>
        pub fn set_scaling_adjustment(mut self, input: std::option::Option<i32>) -> Self {
            self.scaling_adjustment = input;
            self
        }
        /// Consumes the builder and constructs a [`StepAdjustment`](crate::model::StepAdjustment)
        pub fn build(self) -> crate::model::StepAdjustment {
            crate::model::StepAdjustment {
                metric_interval_lower_bound: self.metric_interval_lower_bound,
                metric_interval_upper_bound: self.metric_interval_upper_bound,
                scaling_adjustment: self.scaling_adjustment,
            }
        }
    }
}
impl StepAdjustment {
    /// Creates a new builder-style object to manufacture [`StepAdjustment`](crate::model::StepAdjustment)
    pub fn builder() -> crate::model::step_adjustment::Builder {
        crate::model::step_adjustment::Builder::default()
    }
}

/// <p>A <code>GetPredictiveScalingForecast</code> call returns the capacity forecast for a
/// predictive scaling policy. This structure includes the data points for that capacity
/// forecast, along with the timestamps of those data points. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityForecast {
    /// <p>The time stamps for the data points, in UTC format.</p>
    pub timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
    /// <p>The values of the data points.</p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
}
impl CapacityForecast {
    /// <p>The time stamps for the data points, in UTC format.</p>
    pub fn timestamps(&self) -> std::option::Option<&[aws_smithy_types::Instant]> {
        self.timestamps.as_deref()
    }
    /// <p>The values of the data points.</p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for CapacityForecast {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityForecast");
        formatter.field("timestamps", &self.timestamps);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`CapacityForecast`](crate::model::CapacityForecast)
pub mod capacity_forecast {
    /// A builder for [`CapacityForecast`](crate::model::CapacityForecast)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// Appends an item to `timestamps`.
        ///
        /// To override the contents of this collection use [`set_timestamps`](Self::set_timestamps).
        ///
        /// <p>The time stamps for the data points, in UTC format.</p>
        pub fn timestamps(mut self, input: impl Into<aws_smithy_types::Instant>) -> Self {
            let mut v = self.timestamps.unwrap_or_default();
            v.push(input.into());
            self.timestamps = Some(v);
            self
        }
        /// <p>The time stamps for the data points, in UTC format.</p>
        pub fn set_timestamps(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        ) -> Self {
            self.timestamps = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the data points.</p>
        pub fn values(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the data points.</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityForecast`](crate::model::CapacityForecast)
        pub fn build(self) -> crate::model::CapacityForecast {
            crate::model::CapacityForecast {
                timestamps: self.timestamps,
                values: self.values,
            }
        }
    }
}
impl CapacityForecast {
    /// Creates a new builder-style object to manufacture [`CapacityForecast`](crate::model::CapacityForecast)
    pub fn builder() -> crate::model::capacity_forecast::Builder {
        crate::model::capacity_forecast::Builder::default()
    }
}

/// <p>A <code>GetPredictiveScalingForecast</code> call returns the load forecast for a
/// predictive scaling policy. This structure includes the data points for that load
/// forecast, along with the timestamps of those data points and the metric specification.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadForecast {
    /// <p>The time stamps for the data points, in UTC format.</p>
    pub timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
    /// <p>The values of the data points.</p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The metric specification for the load forecast.</p>
    pub metric_specification:
        std::option::Option<crate::model::PredictiveScalingMetricSpecification>,
}
impl LoadForecast {
    /// <p>The time stamps for the data points, in UTC format.</p>
    pub fn timestamps(&self) -> std::option::Option<&[aws_smithy_types::Instant]> {
        self.timestamps.as_deref()
    }
    /// <p>The values of the data points.</p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
    /// <p>The metric specification for the load forecast.</p>
    pub fn metric_specification(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingMetricSpecification> {
        self.metric_specification.as_ref()
    }
}
impl std::fmt::Debug for LoadForecast {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadForecast");
        formatter.field("timestamps", &self.timestamps);
        formatter.field("values", &self.values);
        formatter.field("metric_specification", &self.metric_specification);
        formatter.finish()
    }
}
/// See [`LoadForecast`](crate::model::LoadForecast)
pub mod load_forecast {
    /// A builder for [`LoadForecast`](crate::model::LoadForecast)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) metric_specification:
            std::option::Option<crate::model::PredictiveScalingMetricSpecification>,
    }
    impl Builder {
        /// Appends an item to `timestamps`.
        ///
        /// To override the contents of this collection use [`set_timestamps`](Self::set_timestamps).
        ///
        /// <p>The time stamps for the data points, in UTC format.</p>
        pub fn timestamps(mut self, input: impl Into<aws_smithy_types::Instant>) -> Self {
            let mut v = self.timestamps.unwrap_or_default();
            v.push(input.into());
            self.timestamps = Some(v);
            self
        }
        /// <p>The time stamps for the data points, in UTC format.</p>
        pub fn set_timestamps(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        ) -> Self {
            self.timestamps = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values of the data points.</p>
        pub fn values(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values of the data points.</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// <p>The metric specification for the load forecast.</p>
        pub fn metric_specification(
            mut self,
            input: crate::model::PredictiveScalingMetricSpecification,
        ) -> Self {
            self.metric_specification = Some(input);
            self
        }
        /// <p>The metric specification for the load forecast.</p>
        pub fn set_metric_specification(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingMetricSpecification>,
        ) -> Self {
            self.metric_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadForecast`](crate::model::LoadForecast)
        pub fn build(self) -> crate::model::LoadForecast {
            crate::model::LoadForecast {
                timestamps: self.timestamps,
                values: self.values,
                metric_specification: self.metric_specification,
            }
        }
    }
}
impl LoadForecast {
    /// Creates a new builder-style object to manufacture [`LoadForecast`](crate::model::LoadForecast)
    pub fn builder() -> crate::model::load_forecast::Builder {
        crate::model::load_forecast::Builder::default()
    }
}

/// <p>Describes an EC2 instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The instance type of the EC2 instance.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The Availability Zone in which the instance is running.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>A description of the current lifecycle state. The <code>Quarantined</code> state is
    /// not used. For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
    /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
    pub lifecycle_state: std::option::Option<crate::model::LifecycleState>,
    /// <p>The last reported health status of the instance. "Healthy" means that the instance is
    /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
    /// and that Amazon EC2 Auto Scaling should terminate and replace it.</p>
    pub health_status: std::option::Option<std::string::String>,
    /// <p>The launch configuration associated with the instance.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>The launch template for the instance.</p>
    pub launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
    /// in.</p>
    pub protected_from_scale_in: std::option::Option<bool>,
    /// <p>The number of capacity units contributed by the instance based on its instance
    /// type.</p>
    /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
    pub weighted_capacity: std::option::Option<std::string::String>,
}
impl Instance {
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The instance type of the EC2 instance.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The Availability Zone in which the instance is running.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>A description of the current lifecycle state. The <code>Quarantined</code> state is
    /// not used. For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
    /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
    pub fn lifecycle_state(&self) -> std::option::Option<&crate::model::LifecycleState> {
        self.lifecycle_state.as_ref()
    }
    /// <p>The last reported health status of the instance. "Healthy" means that the instance is
    /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
    /// and that Amazon EC2 Auto Scaling should terminate and replace it.</p>
    pub fn health_status(&self) -> std::option::Option<&str> {
        self.health_status.as_deref()
    }
    /// <p>The launch configuration associated with the instance.</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
    /// <p>The launch template for the instance.</p>
    pub fn launch_template(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template.as_ref()
    }
    /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
    /// in.</p>
    pub fn protected_from_scale_in(&self) -> std::option::Option<bool> {
        self.protected_from_scale_in
    }
    /// <p>The number of capacity units contributed by the instance based on its instance
    /// type.</p>
    /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
    pub fn weighted_capacity(&self) -> std::option::Option<&str> {
        self.weighted_capacity.as_deref()
    }
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("lifecycle_state", &self.lifecycle_state);
        formatter.field("health_status", &self.health_status);
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("launch_template", &self.launch_template);
        formatter.field("protected_from_scale_in", &self.protected_from_scale_in);
        formatter.field("weighted_capacity", &self.weighted_capacity);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) lifecycle_state: std::option::Option<crate::model::LifecycleState>,
        pub(crate) health_status: std::option::Option<std::string::String>,
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) protected_from_scale_in: std::option::Option<bool>,
        pub(crate) weighted_capacity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The instance type of the EC2 instance.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type of the EC2 instance.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The Availability Zone in which the instance is running.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the instance is running.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>A description of the current lifecycle state. The <code>Quarantined</code> state is
        /// not used. For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
        /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
        pub fn lifecycle_state(mut self, input: crate::model::LifecycleState) -> Self {
            self.lifecycle_state = Some(input);
            self
        }
        /// <p>A description of the current lifecycle state. The <code>Quarantined</code> state is
        /// not used. For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
        /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
        pub fn set_lifecycle_state(
            mut self,
            input: std::option::Option<crate::model::LifecycleState>,
        ) -> Self {
            self.lifecycle_state = input;
            self
        }
        /// <p>The last reported health status of the instance. "Healthy" means that the instance is
        /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
        /// and that Amazon EC2 Auto Scaling should terminate and replace it.</p>
        pub fn health_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_status = Some(input.into());
            self
        }
        /// <p>The last reported health status of the instance. "Healthy" means that the instance is
        /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
        /// and that Amazon EC2 Auto Scaling should terminate and replace it.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The launch configuration associated with the instance.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The launch configuration associated with the instance.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>The launch template for the instance.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>The launch template for the instance.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
        /// in.</p>
        pub fn protected_from_scale_in(mut self, input: bool) -> Self {
            self.protected_from_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
        /// in.</p>
        pub fn set_protected_from_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.protected_from_scale_in = input;
            self
        }
        /// <p>The number of capacity units contributed by the instance based on its instance
        /// type.</p>
        /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
        pub fn weighted_capacity(mut self, input: impl Into<std::string::String>) -> Self {
            self.weighted_capacity = Some(input.into());
            self
        }
        /// <p>The number of capacity units contributed by the instance based on its instance
        /// type.</p>
        /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
        pub fn set_weighted_capacity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weighted_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                instance_id: self.instance_id,
                instance_type: self.instance_type,
                availability_zone: self.availability_zone,
                lifecycle_state: self.lifecycle_state,
                health_status: self.health_status,
                launch_configuration_name: self.launch_configuration_name,
                launch_template: self.launch_template,
                protected_from_scale_in: self.protected_from_scale_in,
                weighted_capacity: self.weighted_capacity,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LifecycleState {
    #[allow(missing_docs)] // documentation missing in model
    Detached,
    #[allow(missing_docs)] // documentation missing in model
    Detaching,
    #[allow(missing_docs)] // documentation missing in model
    EnteringStandby,
    #[allow(missing_docs)] // documentation missing in model
    InService,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingProceed,
    #[allow(missing_docs)] // documentation missing in model
    PendingWait,
    #[allow(missing_docs)] // documentation missing in model
    Quarantined,
    #[allow(missing_docs)] // documentation missing in model
    Standby,
    #[allow(missing_docs)] // documentation missing in model
    Terminated,
    #[allow(missing_docs)] // documentation missing in model
    Terminating,
    #[allow(missing_docs)] // documentation missing in model
    TerminatingProceed,
    #[allow(missing_docs)] // documentation missing in model
    TerminatingWait,
    #[allow(missing_docs)] // documentation missing in model
    WarmedPending,
    #[allow(missing_docs)] // documentation missing in model
    WarmedPendingProceed,
    #[allow(missing_docs)] // documentation missing in model
    WarmedPendingWait,
    #[allow(missing_docs)] // documentation missing in model
    WarmedRunning,
    #[allow(missing_docs)] // documentation missing in model
    WarmedStopped,
    #[allow(missing_docs)] // documentation missing in model
    WarmedTerminated,
    #[allow(missing_docs)] // documentation missing in model
    WarmedTerminating,
    #[allow(missing_docs)] // documentation missing in model
    WarmedTerminatingProceed,
    #[allow(missing_docs)] // documentation missing in model
    WarmedTerminatingWait,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LifecycleState {
    fn from(s: &str) -> Self {
        match s {
            "Detached" => LifecycleState::Detached,
            "Detaching" => LifecycleState::Detaching,
            "EnteringStandby" => LifecycleState::EnteringStandby,
            "InService" => LifecycleState::InService,
            "Pending" => LifecycleState::Pending,
            "Pending:Proceed" => LifecycleState::PendingProceed,
            "Pending:Wait" => LifecycleState::PendingWait,
            "Quarantined" => LifecycleState::Quarantined,
            "Standby" => LifecycleState::Standby,
            "Terminated" => LifecycleState::Terminated,
            "Terminating" => LifecycleState::Terminating,
            "Terminating:Proceed" => LifecycleState::TerminatingProceed,
            "Terminating:Wait" => LifecycleState::TerminatingWait,
            "Warmed:Pending" => LifecycleState::WarmedPending,
            "Warmed:Pending:Proceed" => LifecycleState::WarmedPendingProceed,
            "Warmed:Pending:Wait" => LifecycleState::WarmedPendingWait,
            "Warmed:Running" => LifecycleState::WarmedRunning,
            "Warmed:Stopped" => LifecycleState::WarmedStopped,
            "Warmed:Terminated" => LifecycleState::WarmedTerminated,
            "Warmed:Terminating" => LifecycleState::WarmedTerminating,
            "Warmed:Terminating:Proceed" => LifecycleState::WarmedTerminatingProceed,
            "Warmed:Terminating:Wait" => LifecycleState::WarmedTerminatingWait,
            other => LifecycleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LifecycleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LifecycleState::from(s))
    }
}
impl LifecycleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LifecycleState::Detached => "Detached",
            LifecycleState::Detaching => "Detaching",
            LifecycleState::EnteringStandby => "EnteringStandby",
            LifecycleState::InService => "InService",
            LifecycleState::Pending => "Pending",
            LifecycleState::PendingProceed => "Pending:Proceed",
            LifecycleState::PendingWait => "Pending:Wait",
            LifecycleState::Quarantined => "Quarantined",
            LifecycleState::Standby => "Standby",
            LifecycleState::Terminated => "Terminated",
            LifecycleState::Terminating => "Terminating",
            LifecycleState::TerminatingProceed => "Terminating:Proceed",
            LifecycleState::TerminatingWait => "Terminating:Wait",
            LifecycleState::WarmedPending => "Warmed:Pending",
            LifecycleState::WarmedPendingProceed => "Warmed:Pending:Proceed",
            LifecycleState::WarmedPendingWait => "Warmed:Pending:Wait",
            LifecycleState::WarmedRunning => "Warmed:Running",
            LifecycleState::WarmedStopped => "Warmed:Stopped",
            LifecycleState::WarmedTerminated => "Warmed:Terminated",
            LifecycleState::WarmedTerminating => "Warmed:Terminating",
            LifecycleState::WarmedTerminatingProceed => "Warmed:Terminating:Proceed",
            LifecycleState::WarmedTerminatingWait => "Warmed:Terminating:Wait",
            LifecycleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Detached",
            "Detaching",
            "EnteringStandby",
            "InService",
            "Pending",
            "Pending:Proceed",
            "Pending:Wait",
            "Quarantined",
            "Standby",
            "Terminated",
            "Terminating",
            "Terminating:Proceed",
            "Terminating:Wait",
            "Warmed:Pending",
            "Warmed:Pending:Proceed",
            "Warmed:Pending:Wait",
            "Warmed:Running",
            "Warmed:Stopped",
            "Warmed:Terminated",
            "Warmed:Terminating",
            "Warmed:Terminating:Proceed",
            "Warmed:Terminating:Wait",
        ]
    }
}
impl AsRef<str> for LifecycleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a warm pool configuration. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WarmPoolConfiguration {
    /// <p>The maximum number of instances that are allowed to be in the warm pool or in any
    /// state except <code>Terminated</code> for the Auto Scaling group.</p>
    pub max_group_prepared_capacity: std::option::Option<i32>,
    /// <p>The minimum number of instances to maintain in the warm pool.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The instance state to transition to after the lifecycle actions are complete.</p>
    pub pool_state: std::option::Option<crate::model::WarmPoolState>,
    /// <p>The status of a warm pool that is marked for deletion.</p>
    pub status: std::option::Option<crate::model::WarmPoolStatus>,
}
impl WarmPoolConfiguration {
    /// <p>The maximum number of instances that are allowed to be in the warm pool or in any
    /// state except <code>Terminated</code> for the Auto Scaling group.</p>
    pub fn max_group_prepared_capacity(&self) -> std::option::Option<i32> {
        self.max_group_prepared_capacity
    }
    /// <p>The minimum number of instances to maintain in the warm pool.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The instance state to transition to after the lifecycle actions are complete.</p>
    pub fn pool_state(&self) -> std::option::Option<&crate::model::WarmPoolState> {
        self.pool_state.as_ref()
    }
    /// <p>The status of a warm pool that is marked for deletion.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::WarmPoolStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for WarmPoolConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WarmPoolConfiguration");
        formatter.field(
            "max_group_prepared_capacity",
            &self.max_group_prepared_capacity,
        );
        formatter.field("min_size", &self.min_size);
        formatter.field("pool_state", &self.pool_state);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`WarmPoolConfiguration`](crate::model::WarmPoolConfiguration)
pub mod warm_pool_configuration {
    /// A builder for [`WarmPoolConfiguration`](crate::model::WarmPoolConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_group_prepared_capacity: std::option::Option<i32>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) pool_state: std::option::Option<crate::model::WarmPoolState>,
        pub(crate) status: std::option::Option<crate::model::WarmPoolStatus>,
    }
    impl Builder {
        /// <p>The maximum number of instances that are allowed to be in the warm pool or in any
        /// state except <code>Terminated</code> for the Auto Scaling group.</p>
        pub fn max_group_prepared_capacity(mut self, input: i32) -> Self {
            self.max_group_prepared_capacity = Some(input);
            self
        }
        /// <p>The maximum number of instances that are allowed to be in the warm pool or in any
        /// state except <code>Terminated</code> for the Auto Scaling group.</p>
        pub fn set_max_group_prepared_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_group_prepared_capacity = input;
            self
        }
        /// <p>The minimum number of instances to maintain in the warm pool.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum number of instances to maintain in the warm pool.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The instance state to transition to after the lifecycle actions are complete.</p>
        pub fn pool_state(mut self, input: crate::model::WarmPoolState) -> Self {
            self.pool_state = Some(input);
            self
        }
        /// <p>The instance state to transition to after the lifecycle actions are complete.</p>
        pub fn set_pool_state(
            mut self,
            input: std::option::Option<crate::model::WarmPoolState>,
        ) -> Self {
            self.pool_state = input;
            self
        }
        /// <p>The status of a warm pool that is marked for deletion.</p>
        pub fn status(mut self, input: crate::model::WarmPoolStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a warm pool that is marked for deletion.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::WarmPoolStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`WarmPoolConfiguration`](crate::model::WarmPoolConfiguration)
        pub fn build(self) -> crate::model::WarmPoolConfiguration {
            crate::model::WarmPoolConfiguration {
                max_group_prepared_capacity: self.max_group_prepared_capacity,
                min_size: self.min_size,
                pool_state: self.pool_state,
                status: self.status,
            }
        }
    }
}
impl WarmPoolConfiguration {
    /// Creates a new builder-style object to manufacture [`WarmPoolConfiguration`](crate::model::WarmPoolConfiguration)
    pub fn builder() -> crate::model::warm_pool_configuration::Builder {
        crate::model::warm_pool_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WarmPoolStatus {
    #[allow(missing_docs)] // documentation missing in model
    PendingDelete,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WarmPoolStatus {
    fn from(s: &str) -> Self {
        match s {
            "PendingDelete" => WarmPoolStatus::PendingDelete,
            other => WarmPoolStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WarmPoolStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WarmPoolStatus::from(s))
    }
}
impl WarmPoolStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WarmPoolStatus::PendingDelete => "PendingDelete",
            WarmPoolStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PendingDelete"]
    }
}
impl AsRef<str> for WarmPoolStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a tag for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagDescription {
    /// <p>The name of the group.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource. The only supported value is
    /// <code>auto-scaling-group</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Determines whether the tag is added to new instances as they are launched in the
    /// group.</p>
    pub propagate_at_launch: std::option::Option<bool>,
}
impl TagDescription {
    /// <p>The name of the group.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of resource. The only supported value is
    /// <code>auto-scaling-group</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>Determines whether the tag is added to new instances as they are launched in the
    /// group.</p>
    pub fn propagate_at_launch(&self) -> std::option::Option<bool> {
        self.propagate_at_launch
    }
}
impl std::fmt::Debug for TagDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagDescription");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("propagate_at_launch", &self.propagate_at_launch);
        formatter.finish()
    }
}
/// See [`TagDescription`](crate::model::TagDescription)
pub mod tag_description {
    /// A builder for [`TagDescription`](crate::model::TagDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) propagate_at_launch: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the group.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The name of the group.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of resource. The only supported value is
        /// <code>auto-scaling-group</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource. The only supported value is
        /// <code>auto-scaling-group</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Determines whether the tag is added to new instances as they are launched in the
        /// group.</p>
        pub fn propagate_at_launch(mut self, input: bool) -> Self {
            self.propagate_at_launch = Some(input);
            self
        }
        /// <p>Determines whether the tag is added to new instances as they are launched in the
        /// group.</p>
        pub fn set_propagate_at_launch(mut self, input: std::option::Option<bool>) -> Self {
            self.propagate_at_launch = input;
            self
        }
        /// Consumes the builder and constructs a [`TagDescription`](crate::model::TagDescription)
        pub fn build(self) -> crate::model::TagDescription {
            crate::model::TagDescription {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                key: self.key,
                value: self.value,
                propagate_at_launch: self.propagate_at_launch,
            }
        }
    }
}
impl TagDescription {
    /// Creates a new builder-style object to manufacture [`TagDescription`](crate::model::TagDescription)
    pub fn builder() -> crate::model::tag_description::Builder {
        crate::model::tag_description::Builder::default()
    }
}

/// <p>Describes a filter that is used to return a more specific list of results from a
/// describe operation.</p>
/// <p>If you specify multiple filters, the filters are automatically logically joined with
/// an <code>AND</code>, and the request returns only the results that match all of the
/// specified filters. </p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and
/// instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter.</p>
    /// <p>The valid values for <code>Name</code> depend on which API operation you're using with
    /// the filter (<a>DescribeAutoScalingGroups</a> or <a>DescribeTags</a>).</p>
    /// <p>
    /// <b>DescribeAutoScalingGroups</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tag-key</code> - Accepts tag keys. The results only include information
    /// about the Auto Scaling groups associated with these tag keys. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tag-value</code> - Accepts tag values. The results only include
    /// information about the Auto Scaling groups associated with these tag values. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tag:<key></code> - Accepts the key/value combination of the tag.
    /// Use the tag key in the filter name and the tag value as the filter value. The
    /// results only include information about the Auto Scaling groups associated with the
    /// specified key/value combination. </p>
    /// </li>
    /// </ul>
    /// <p>
    /// <b>DescribeTags</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>auto-scaling-group</code> - Accepts the names of Auto Scaling groups. The
    /// results only include information about the tags associated with these Auto Scaling
    /// groups. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>key</code> - Accepts tag keys. The results only include information
    /// about the tags associated with these tag keys. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>value</code> - Accepts tag values. The results only include information
    /// about the tags associated with these tag values. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>propagate-at-launch</code> - Accepts a Boolean value, which specifies
    /// whether tags propagate to instances at launch. The results only include
    /// information about the tags associated with the specified Boolean value. </p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more filter values. Filter values are case-sensitive. </p>
    /// <p>If you specify multiple values for a filter, the values are automatically logically
    /// joined with an <code>OR</code>, and the request returns all results that match any of
    /// the specified values. For example, specify "tag:environment" for the filter name and
    /// "production,development" for the filter values to find Auto Scaling groups with the tag
    /// "environment=production" or "environment=development".</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name of the filter.</p>
    /// <p>The valid values for <code>Name</code> depend on which API operation you're using with
    /// the filter (<a>DescribeAutoScalingGroups</a> or <a>DescribeTags</a>).</p>
    /// <p>
    /// <b>DescribeAutoScalingGroups</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tag-key</code> - Accepts tag keys. The results only include information
    /// about the Auto Scaling groups associated with these tag keys. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tag-value</code> - Accepts tag values. The results only include
    /// information about the Auto Scaling groups associated with these tag values. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>tag:<key></code> - Accepts the key/value combination of the tag.
    /// Use the tag key in the filter name and the tag value as the filter value. The
    /// results only include information about the Auto Scaling groups associated with the
    /// specified key/value combination. </p>
    /// </li>
    /// </ul>
    /// <p>
    /// <b>DescribeTags</b>
    /// </p>
    /// <p>Valid values for <code>Name</code> include the following: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>auto-scaling-group</code> - Accepts the names of Auto Scaling groups. The
    /// results only include information about the tags associated with these Auto Scaling
    /// groups. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>key</code> - Accepts tag keys. The results only include information
    /// about the tags associated with these tag keys. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>value</code> - Accepts tag values. The results only include information
    /// about the tags associated with these tag values. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>propagate-at-launch</code> - Accepts a Boolean value, which specifies
    /// whether tags propagate to instances at launch. The results only include
    /// information about the tags associated with the specified Boolean value. </p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more filter values. Filter values are case-sensitive. </p>
    /// <p>If you specify multiple values for a filter, the values are automatically logically
    /// joined with an <code>OR</code>, and the request returns all results that match any of
    /// the specified values. For example, specify "tag:environment" for the filter name and
    /// "production,development" for the filter values to find Auto Scaling groups with the tag
    /// "environment=production" or "environment=development".</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter.</p>
        /// <p>The valid values for <code>Name</code> depend on which API operation you're using with
        /// the filter (<a>DescribeAutoScalingGroups</a> or <a>DescribeTags</a>).</p>
        /// <p>
        /// <b>DescribeAutoScalingGroups</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tag-key</code> - Accepts tag keys. The results only include information
        /// about the Auto Scaling groups associated with these tag keys. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tag-value</code> - Accepts tag values. The results only include
        /// information about the Auto Scaling groups associated with these tag values. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tag:<key></code> - Accepts the key/value combination of the tag.
        /// Use the tag key in the filter name and the tag value as the filter value. The
        /// results only include information about the Auto Scaling groups associated with the
        /// specified key/value combination. </p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>DescribeTags</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>auto-scaling-group</code> - Accepts the names of Auto Scaling groups. The
        /// results only include information about the tags associated with these Auto Scaling
        /// groups. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>key</code> - Accepts tag keys. The results only include information
        /// about the tags associated with these tag keys. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>value</code> - Accepts tag values. The results only include information
        /// about the tags associated with these tag values. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>propagate-at-launch</code> - Accepts a Boolean value, which specifies
        /// whether tags propagate to instances at launch. The results only include
        /// information about the tags associated with the specified Boolean value. </p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter.</p>
        /// <p>The valid values for <code>Name</code> depend on which API operation you're using with
        /// the filter (<a>DescribeAutoScalingGroups</a> or <a>DescribeTags</a>).</p>
        /// <p>
        /// <b>DescribeAutoScalingGroups</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tag-key</code> - Accepts tag keys. The results only include information
        /// about the Auto Scaling groups associated with these tag keys. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tag-value</code> - Accepts tag values. The results only include
        /// information about the Auto Scaling groups associated with these tag values. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tag:<key></code> - Accepts the key/value combination of the tag.
        /// Use the tag key in the filter name and the tag value as the filter value. The
        /// results only include information about the Auto Scaling groups associated with the
        /// specified key/value combination. </p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>DescribeTags</b>
        /// </p>
        /// <p>Valid values for <code>Name</code> include the following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>auto-scaling-group</code> - Accepts the names of Auto Scaling groups. The
        /// results only include information about the tags associated with these Auto Scaling
        /// groups. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>key</code> - Accepts tag keys. The results only include information
        /// about the tags associated with these tag keys. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>value</code> - Accepts tag values. The results only include information
        /// about the tags associated with these tag values. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>propagate-at-launch</code> - Accepts a Boolean value, which specifies
        /// whether tags propagate to instances at launch. The results only include
        /// information about the tags associated with the specified Boolean value. </p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>One or more filter values. Filter values are case-sensitive. </p>
        /// <p>If you specify multiple values for a filter, the values are automatically logically
        /// joined with an <code>OR</code>, and the request returns all results that match any of
        /// the specified values. For example, specify "tag:environment" for the filter name and
        /// "production,development" for the filter values to find Auto Scaling groups with the tag
        /// "environment=production" or "environment=development".</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>One or more filter values. Filter values are case-sensitive. </p>
        /// <p>If you specify multiple values for a filter, the values are automatically logically
        /// joined with an <code>OR</code>, and the request returns all results that match any of
        /// the specified values. For example, specify "tag:environment" for the filter name and
        /// "production,development" for the filter values to find Auto Scaling groups with the tag
        /// "environment=production" or "environment=development".</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Describes a scheduled scaling
/// action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledUpdateGroupAction {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the scheduled action.</p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
    pub scheduled_action_arn: std::option::Option<std::string::String>,
    /// <p>This parameter is no longer used.</p>
    pub time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time in UTC for this action to start. For example,
    /// <code>"2019-06-01T00:00:00Z"</code>.
    /// </p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time in UTC for the recurring schedule to end. For example,
    /// <code>"2019-06-01T00:00:00Z"</code>.
    /// </p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The recurring schedule for the action, in Unix cron syntax format.</p>
    /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
    /// <code>Recurrence</code>, they form the boundaries of when the recurring action
    /// starts and stops.</p>
    pub recurrence: std::option::Option<std::string::String>,
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum size of the Auto Scaling group.</p>
    pub max_size: std::option::Option<i32>,
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
    /// action runs and the capacity it attempts to maintain.</p>
    pub desired_capacity: std::option::Option<i32>,
    /// <p>The time zone for the cron expression.</p>
    pub time_zone: std::option::Option<std::string::String>,
}
impl ScheduledUpdateGroupAction {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of the scheduled action.</p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
    pub fn scheduled_action_arn(&self) -> std::option::Option<&str> {
        self.scheduled_action_arn.as_deref()
    }
    /// <p>This parameter is no longer used.</p>
    pub fn time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.time.as_ref()
    }
    /// <p>The date and time in UTC for this action to start. For example,
    /// <code>"2019-06-01T00:00:00Z"</code>.
    /// </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The date and time in UTC for the recurring schedule to end. For example,
    /// <code>"2019-06-01T00:00:00Z"</code>.
    /// </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The recurring schedule for the action, in Unix cron syntax format.</p>
    /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
    /// <code>Recurrence</code>, they form the boundaries of when the recurring action
    /// starts and stops.</p>
    pub fn recurrence(&self) -> std::option::Option<&str> {
        self.recurrence.as_deref()
    }
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The maximum size of the Auto Scaling group.</p>
    pub fn max_size(&self) -> std::option::Option<i32> {
        self.max_size
    }
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
    /// action runs and the capacity it attempts to maintain.</p>
    pub fn desired_capacity(&self) -> std::option::Option<i32> {
        self.desired_capacity
    }
    /// <p>The time zone for the cron expression.</p>
    pub fn time_zone(&self) -> std::option::Option<&str> {
        self.time_zone.as_deref()
    }
}
impl std::fmt::Debug for ScheduledUpdateGroupAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledUpdateGroupAction");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("scheduled_action_arn", &self.scheduled_action_arn);
        formatter.field("time", &self.time);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("recurrence", &self.recurrence);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("time_zone", &self.time_zone);
        formatter.finish()
    }
}
/// See [`ScheduledUpdateGroupAction`](crate::model::ScheduledUpdateGroupAction)
pub mod scheduled_update_group_action {
    /// A builder for [`ScheduledUpdateGroupAction`](crate::model::ScheduledUpdateGroupAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_arn: std::option::Option<std::string::String>,
        pub(crate) time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) recurrence: std::option::Option<std::string::String>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) time_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of the scheduled action.</p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action.</p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
        pub fn scheduled_action_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the scheduled action.</p>
        pub fn set_scheduled_action_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_arn = input;
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.time = Some(input);
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.time = input;
            self
        }
        /// <p>The date and time in UTC for this action to start. For example,
        /// <code>"2019-06-01T00:00:00Z"</code>.
        /// </p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time in UTC for this action to start. For example,
        /// <code>"2019-06-01T00:00:00Z"</code>.
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time in UTC for the recurring schedule to end. For example,
        /// <code>"2019-06-01T00:00:00Z"</code>.
        /// </p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time in UTC for the recurring schedule to end. For example,
        /// <code>"2019-06-01T00:00:00Z"</code>.
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The recurring schedule for the action, in Unix cron syntax format.</p>
        /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
        /// <code>Recurrence</code>, they form the boundaries of when the recurring action
        /// starts and stops.</p>
        pub fn recurrence(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurrence = Some(input.into());
            self
        }
        /// <p>The recurring schedule for the action, in Unix cron syntax format.</p>
        /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
        /// <code>Recurrence</code>, they form the boundaries of when the recurring action
        /// starts and stops.</p>
        pub fn set_recurrence(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recurrence = input;
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
        /// action runs and the capacity it attempts to maintain.</p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
        /// action runs and the capacity it attempts to maintain.</p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p>The time zone for the cron expression.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone = Some(input.into());
            self
        }
        /// <p>The time zone for the cron expression.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledUpdateGroupAction`](crate::model::ScheduledUpdateGroupAction)
        pub fn build(self) -> crate::model::ScheduledUpdateGroupAction {
            crate::model::ScheduledUpdateGroupAction {
                auto_scaling_group_name: self.auto_scaling_group_name,
                scheduled_action_name: self.scheduled_action_name,
                scheduled_action_arn: self.scheduled_action_arn,
                time: self.time,
                start_time: self.start_time,
                end_time: self.end_time,
                recurrence: self.recurrence,
                min_size: self.min_size,
                max_size: self.max_size,
                desired_capacity: self.desired_capacity,
                time_zone: self.time_zone,
            }
        }
    }
}
impl ScheduledUpdateGroupAction {
    /// Creates a new builder-style object to manufacture [`ScheduledUpdateGroupAction`](crate::model::ScheduledUpdateGroupAction)
    pub fn builder() -> crate::model::scheduled_update_group_action::Builder {
        crate::model::scheduled_update_group_action::Builder::default()
    }
}

/// <p>Describes a process type.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types">Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProcessType {
    /// <p>One of the following processes:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Launch</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Terminate</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AddToLoadBalancer</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AlarmNotification</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AZRebalance</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HealthCheck</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InstanceRefresh</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReplaceUnhealthy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledActions</code>
    /// </p>
    /// </li>
    /// </ul>
    pub process_name: std::option::Option<std::string::String>,
}
impl ProcessType {
    /// <p>One of the following processes:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Launch</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Terminate</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AddToLoadBalancer</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AlarmNotification</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AZRebalance</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>HealthCheck</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InstanceRefresh</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ReplaceUnhealthy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ScheduledActions</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn process_name(&self) -> std::option::Option<&str> {
        self.process_name.as_deref()
    }
}
impl std::fmt::Debug for ProcessType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProcessType");
        formatter.field("process_name", &self.process_name);
        formatter.finish()
    }
}
/// See [`ProcessType`](crate::model::ProcessType)
pub mod process_type {
    /// A builder for [`ProcessType`](crate::model::ProcessType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) process_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One of the following processes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Launch</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AddToLoadBalancer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AlarmNotification</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AZRebalance</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HealthCheck</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InstanceRefresh</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReplaceUnhealthy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledActions</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn process_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.process_name = Some(input.into());
            self
        }
        /// <p>One of the following processes:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Launch</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Terminate</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AddToLoadBalancer</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AlarmNotification</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AZRebalance</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>HealthCheck</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InstanceRefresh</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ReplaceUnhealthy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ScheduledActions</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_process_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.process_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ProcessType`](crate::model::ProcessType)
        pub fn build(self) -> crate::model::ProcessType {
            crate::model::ProcessType {
                process_name: self.process_name,
            }
        }
    }
}
impl ProcessType {
    /// Creates a new builder-style object to manufacture [`ProcessType`](crate::model::ProcessType)
    pub fn builder() -> crate::model::process_type::Builder {
        crate::model::process_type::Builder::default()
    }
}

/// <p>Describes a scaling policy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingPolicy {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the scaling policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the policy.</p>
    pub policy_arn: std::option::Option<std::string::String>,
    /// <p>One of the following policy types: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TargetTrackingScaling</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>StepScaling</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SimpleScaling</code> (default)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictiveScaling</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
    /// scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
    /// policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub policy_type: std::option::Option<std::string::String>,
    /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number
    /// or a percentage). The valid values are <code>ChangeInCapacity</code>,
    /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
    pub adjustment_type: std::option::Option<std::string::String>,
    /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code>
    /// instead.</p>
    pub min_adjustment_step: std::option::Option<i32>,
    /// <p>The minimum value to scale by when the adjustment type is
    /// <code>PercentChangeInCapacity</code>. </p>
    pub min_adjustment_magnitude: std::option::Option<i32>,
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
    /// adds to the current capacity while a negative number removes from the current
    /// capacity.</p>
    pub scaling_adjustment: std::option::Option<i32>,
    /// <p>The duration of the policy's cooldown period, in seconds.</p>
    pub cooldown: std::option::Option<i32>,
    /// <p>A set of adjustments that enable you to scale based on the size of the alarm
    /// breach.</p>
    pub step_adjustments: std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
    /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
    /// <code>Maximum</code>, and <code>Average</code>.</p>
    pub metric_aggregation_type: std::option::Option<std::string::String>,
    /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the
    /// CloudWatch metrics.</p>
    pub estimated_instance_warmup: std::option::Option<i32>,
    /// <p>The CloudWatch alarms related to the policy.</p>
    pub alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
    /// <p>A target tracking scaling policy.</p>
    pub target_tracking_configuration:
        std::option::Option<crate::model::TargetTrackingConfiguration>,
    /// <p>Indicates whether the policy is enabled (<code>true</code>) or disabled
    /// (<code>false</code>).</p>
    pub enabled: std::option::Option<bool>,
    /// <p>A predictive scaling policy.</p>
    pub predictive_scaling_configuration:
        std::option::Option<crate::model::PredictiveScalingConfiguration>,
}
impl ScalingPolicy {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The name of the scaling policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the policy.</p>
    pub fn policy_arn(&self) -> std::option::Option<&str> {
        self.policy_arn.as_deref()
    }
    /// <p>One of the following policy types: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>TargetTrackingScaling</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>StepScaling</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SimpleScaling</code> (default)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictiveScaling</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
    /// scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
    /// policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn policy_type(&self) -> std::option::Option<&str> {
        self.policy_type.as_deref()
    }
    /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number
    /// or a percentage). The valid values are <code>ChangeInCapacity</code>,
    /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
    pub fn adjustment_type(&self) -> std::option::Option<&str> {
        self.adjustment_type.as_deref()
    }
    /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code>
    /// instead.</p>
    pub fn min_adjustment_step(&self) -> std::option::Option<i32> {
        self.min_adjustment_step
    }
    /// <p>The minimum value to scale by when the adjustment type is
    /// <code>PercentChangeInCapacity</code>. </p>
    pub fn min_adjustment_magnitude(&self) -> std::option::Option<i32> {
        self.min_adjustment_magnitude
    }
    /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
    /// adds to the current capacity while a negative number removes from the current
    /// capacity.</p>
    pub fn scaling_adjustment(&self) -> std::option::Option<i32> {
        self.scaling_adjustment
    }
    /// <p>The duration of the policy's cooldown period, in seconds.</p>
    pub fn cooldown(&self) -> std::option::Option<i32> {
        self.cooldown
    }
    /// <p>A set of adjustments that enable you to scale based on the size of the alarm
    /// breach.</p>
    pub fn step_adjustments(&self) -> std::option::Option<&[crate::model::StepAdjustment]> {
        self.step_adjustments.as_deref()
    }
    /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
    /// <code>Maximum</code>, and <code>Average</code>.</p>
    pub fn metric_aggregation_type(&self) -> std::option::Option<&str> {
        self.metric_aggregation_type.as_deref()
    }
    /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the
    /// CloudWatch metrics.</p>
    pub fn estimated_instance_warmup(&self) -> std::option::Option<i32> {
        self.estimated_instance_warmup
    }
    /// <p>The CloudWatch alarms related to the policy.</p>
    pub fn alarms(&self) -> std::option::Option<&[crate::model::Alarm]> {
        self.alarms.as_deref()
    }
    /// <p>A target tracking scaling policy.</p>
    pub fn target_tracking_configuration(
        &self,
    ) -> std::option::Option<&crate::model::TargetTrackingConfiguration> {
        self.target_tracking_configuration.as_ref()
    }
    /// <p>Indicates whether the policy is enabled (<code>true</code>) or disabled
    /// (<code>false</code>).</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
    /// <p>A predictive scaling policy.</p>
    pub fn predictive_scaling_configuration(
        &self,
    ) -> std::option::Option<&crate::model::PredictiveScalingConfiguration> {
        self.predictive_scaling_configuration.as_ref()
    }
}
impl std::fmt::Debug for ScalingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingPolicy");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_arn", &self.policy_arn);
        formatter.field("policy_type", &self.policy_type);
        formatter.field("adjustment_type", &self.adjustment_type);
        formatter.field("min_adjustment_step", &self.min_adjustment_step);
        formatter.field("min_adjustment_magnitude", &self.min_adjustment_magnitude);
        formatter.field("scaling_adjustment", &self.scaling_adjustment);
        formatter.field("cooldown", &self.cooldown);
        formatter.field("step_adjustments", &self.step_adjustments);
        formatter.field("metric_aggregation_type", &self.metric_aggregation_type);
        formatter.field("estimated_instance_warmup", &self.estimated_instance_warmup);
        formatter.field("alarms", &self.alarms);
        formatter.field(
            "target_tracking_configuration",
            &self.target_tracking_configuration,
        );
        formatter.field("enabled", &self.enabled);
        formatter.field(
            "predictive_scaling_configuration",
            &self.predictive_scaling_configuration,
        );
        formatter.finish()
    }
}
/// See [`ScalingPolicy`](crate::model::ScalingPolicy)
pub mod scaling_policy {
    /// A builder for [`ScalingPolicy`](crate::model::ScalingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_arn: std::option::Option<std::string::String>,
        pub(crate) policy_type: std::option::Option<std::string::String>,
        pub(crate) adjustment_type: std::option::Option<std::string::String>,
        pub(crate) min_adjustment_step: std::option::Option<i32>,
        pub(crate) min_adjustment_magnitude: std::option::Option<i32>,
        pub(crate) scaling_adjustment: std::option::Option<i32>,
        pub(crate) cooldown: std::option::Option<i32>,
        pub(crate) step_adjustments:
            std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
        pub(crate) metric_aggregation_type: std::option::Option<std::string::String>,
        pub(crate) estimated_instance_warmup: std::option::Option<i32>,
        pub(crate) alarms: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
        pub(crate) target_tracking_configuration:
            std::option::Option<crate::model::TargetTrackingConfiguration>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) predictive_scaling_configuration:
            std::option::Option<crate::model::PredictiveScalingConfiguration>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The name of the scaling policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy.</p>
        pub fn policy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the policy.</p>
        pub fn set_policy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_arn = input;
            self
        }
        /// <p>One of the following policy types: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TargetTrackingScaling</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>StepScaling</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SimpleScaling</code> (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictiveScaling</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
        /// scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
        /// policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn policy_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_type = Some(input.into());
            self
        }
        /// <p>One of the following policy types: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TargetTrackingScaling</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>StepScaling</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SimpleScaling</code> (default)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictiveScaling</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking
        /// scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling
        /// policies</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_policy_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_type = input;
            self
        }
        /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number
        /// or a percentage). The valid values are <code>ChangeInCapacity</code>,
        /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
        pub fn adjustment_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.adjustment_type = Some(input.into());
            self
        }
        /// <p>Specifies how the scaling adjustment is interpreted (for example, an absolute number
        /// or a percentage). The valid values are <code>ChangeInCapacity</code>,
        /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
        pub fn set_adjustment_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.adjustment_type = input;
            self
        }
        /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code>
        /// instead.</p>
        pub fn min_adjustment_step(mut self, input: i32) -> Self {
            self.min_adjustment_step = Some(input);
            self
        }
        /// <p>Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code>
        /// instead.</p>
        pub fn set_min_adjustment_step(mut self, input: std::option::Option<i32>) -> Self {
            self.min_adjustment_step = input;
            self
        }
        /// <p>The minimum value to scale by when the adjustment type is
        /// <code>PercentChangeInCapacity</code>. </p>
        pub fn min_adjustment_magnitude(mut self, input: i32) -> Self {
            self.min_adjustment_magnitude = Some(input);
            self
        }
        /// <p>The minimum value to scale by when the adjustment type is
        /// <code>PercentChangeInCapacity</code>. </p>
        pub fn set_min_adjustment_magnitude(mut self, input: std::option::Option<i32>) -> Self {
            self.min_adjustment_magnitude = input;
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
        /// adds to the current capacity while a negative number removes from the current
        /// capacity.</p>
        pub fn scaling_adjustment(mut self, input: i32) -> Self {
            self.scaling_adjustment = Some(input);
            self
        }
        /// <p>The amount by which to scale, based on the specified adjustment type. A positive value
        /// adds to the current capacity while a negative number removes from the current
        /// capacity.</p>
        pub fn set_scaling_adjustment(mut self, input: std::option::Option<i32>) -> Self {
            self.scaling_adjustment = input;
            self
        }
        /// <p>The duration of the policy's cooldown period, in seconds.</p>
        pub fn cooldown(mut self, input: i32) -> Self {
            self.cooldown = Some(input);
            self
        }
        /// <p>The duration of the policy's cooldown period, in seconds.</p>
        pub fn set_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.cooldown = input;
            self
        }
        /// Appends an item to `step_adjustments`.
        ///
        /// To override the contents of this collection use [`set_step_adjustments`](Self::set_step_adjustments).
        ///
        /// <p>A set of adjustments that enable you to scale based on the size of the alarm
        /// breach.</p>
        pub fn step_adjustments(mut self, input: impl Into<crate::model::StepAdjustment>) -> Self {
            let mut v = self.step_adjustments.unwrap_or_default();
            v.push(input.into());
            self.step_adjustments = Some(v);
            self
        }
        /// <p>A set of adjustments that enable you to scale based on the size of the alarm
        /// breach.</p>
        pub fn set_step_adjustments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StepAdjustment>>,
        ) -> Self {
            self.step_adjustments = input;
            self
        }
        /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
        /// <code>Maximum</code>, and <code>Average</code>.</p>
        pub fn metric_aggregation_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_aggregation_type = Some(input.into());
            self
        }
        /// <p>The aggregation type for the CloudWatch metrics. The valid values are <code>Minimum</code>,
        /// <code>Maximum</code>, and <code>Average</code>.</p>
        pub fn set_metric_aggregation_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_aggregation_type = input;
            self
        }
        /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the
        /// CloudWatch metrics.</p>
        pub fn estimated_instance_warmup(mut self, input: i32) -> Self {
            self.estimated_instance_warmup = Some(input);
            self
        }
        /// <p>The estimated time, in seconds, until a newly launched instance can contribute to the
        /// CloudWatch metrics.</p>
        pub fn set_estimated_instance_warmup(mut self, input: std::option::Option<i32>) -> Self {
            self.estimated_instance_warmup = input;
            self
        }
        /// Appends an item to `alarms`.
        ///
        /// To override the contents of this collection use [`set_alarms`](Self::set_alarms).
        ///
        /// <p>The CloudWatch alarms related to the policy.</p>
        pub fn alarms(mut self, input: impl Into<crate::model::Alarm>) -> Self {
            let mut v = self.alarms.unwrap_or_default();
            v.push(input.into());
            self.alarms = Some(v);
            self
        }
        /// <p>The CloudWatch alarms related to the policy.</p>
        pub fn set_alarms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Alarm>>,
        ) -> Self {
            self.alarms = input;
            self
        }
        /// <p>A target tracking scaling policy.</p>
        pub fn target_tracking_configuration(
            mut self,
            input: crate::model::TargetTrackingConfiguration,
        ) -> Self {
            self.target_tracking_configuration = Some(input);
            self
        }
        /// <p>A target tracking scaling policy.</p>
        pub fn set_target_tracking_configuration(
            mut self,
            input: std::option::Option<crate::model::TargetTrackingConfiguration>,
        ) -> Self {
            self.target_tracking_configuration = input;
            self
        }
        /// <p>Indicates whether the policy is enabled (<code>true</code>) or disabled
        /// (<code>false</code>).</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether the policy is enabled (<code>true</code>) or disabled
        /// (<code>false</code>).</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>A predictive scaling policy.</p>
        pub fn predictive_scaling_configuration(
            mut self,
            input: crate::model::PredictiveScalingConfiguration,
        ) -> Self {
            self.predictive_scaling_configuration = Some(input);
            self
        }
        /// <p>A predictive scaling policy.</p>
        pub fn set_predictive_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::PredictiveScalingConfiguration>,
        ) -> Self {
            self.predictive_scaling_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingPolicy`](crate::model::ScalingPolicy)
        pub fn build(self) -> crate::model::ScalingPolicy {
            crate::model::ScalingPolicy {
                auto_scaling_group_name: self.auto_scaling_group_name,
                policy_name: self.policy_name,
                policy_arn: self.policy_arn,
                policy_type: self.policy_type,
                adjustment_type: self.adjustment_type,
                min_adjustment_step: self.min_adjustment_step,
                min_adjustment_magnitude: self.min_adjustment_magnitude,
                scaling_adjustment: self.scaling_adjustment,
                cooldown: self.cooldown,
                step_adjustments: self.step_adjustments,
                metric_aggregation_type: self.metric_aggregation_type,
                estimated_instance_warmup: self.estimated_instance_warmup,
                alarms: self.alarms,
                target_tracking_configuration: self.target_tracking_configuration,
                enabled: self.enabled,
                predictive_scaling_configuration: self.predictive_scaling_configuration,
            }
        }
    }
}
impl ScalingPolicy {
    /// Creates a new builder-style object to manufacture [`ScalingPolicy`](crate::model::ScalingPolicy)
    pub fn builder() -> crate::model::scaling_policy::Builder {
        crate::model::scaling_policy::Builder::default()
    }
}

/// <p>Describes a notification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotificationConfiguration {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS)
    /// topic.</p>
    pub topic_arn: std::option::Option<std::string::String>,
    /// <p>One of the following event notification types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:TEST_NOTIFICATION</code>
    /// </p>
    /// </li>
    /// </ul>
    pub notification_type: std::option::Option<std::string::String>,
}
impl NotificationConfiguration {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS)
    /// topic.</p>
    pub fn topic_arn(&self) -> std::option::Option<&str> {
        self.topic_arn.as_deref()
    }
    /// <p>One of the following event notification types:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>autoscaling:TEST_NOTIFICATION</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn notification_type(&self) -> std::option::Option<&str> {
        self.notification_type.as_deref()
    }
}
impl std::fmt::Debug for NotificationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotificationConfiguration");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("topic_arn", &self.topic_arn);
        formatter.field("notification_type", &self.notification_type);
        formatter.finish()
    }
}
/// See [`NotificationConfiguration`](crate::model::NotificationConfiguration)
pub mod notification_configuration {
    /// A builder for [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) topic_arn: std::option::Option<std::string::String>,
        pub(crate) notification_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS)
        /// topic.</p>
        pub fn topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (Amazon SNS)
        /// topic.</p>
        pub fn set_topic_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic_arn = input;
            self
        }
        /// <p>One of the following event notification types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:TEST_NOTIFICATION</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn notification_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_type = Some(input.into());
            self
        }
        /// <p>One of the following event notification types:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_LAUNCH</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_LAUNCH_ERROR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_TERMINATE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:EC2_INSTANCE_TERMINATE_ERROR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>autoscaling:TEST_NOTIFICATION</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_notification_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_type = input;
            self
        }
        /// Consumes the builder and constructs a [`NotificationConfiguration`](crate::model::NotificationConfiguration)
        pub fn build(self) -> crate::model::NotificationConfiguration {
            crate::model::NotificationConfiguration {
                auto_scaling_group_name: self.auto_scaling_group_name,
                topic_arn: self.topic_arn,
                notification_type: self.notification_type,
            }
        }
    }
}
impl NotificationConfiguration {
    /// Creates a new builder-style object to manufacture [`NotificationConfiguration`](crate::model::NotificationConfiguration)
    pub fn builder() -> crate::model::notification_configuration::Builder {
        crate::model::notification_configuration::Builder::default()
    }
}

/// <p>Describes a granularity of a metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricGranularityType {
    /// <p>The granularity. The only valid value is <code>1Minute</code>.</p>
    pub granularity: std::option::Option<std::string::String>,
}
impl MetricGranularityType {
    /// <p>The granularity. The only valid value is <code>1Minute</code>.</p>
    pub fn granularity(&self) -> std::option::Option<&str> {
        self.granularity.as_deref()
    }
}
impl std::fmt::Debug for MetricGranularityType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricGranularityType");
        formatter.field("granularity", &self.granularity);
        formatter.finish()
    }
}
/// See [`MetricGranularityType`](crate::model::MetricGranularityType)
pub mod metric_granularity_type {
    /// A builder for [`MetricGranularityType`](crate::model::MetricGranularityType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) granularity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The granularity. The only valid value is <code>1Minute</code>.</p>
        pub fn granularity(mut self, input: impl Into<std::string::String>) -> Self {
            self.granularity = Some(input.into());
            self
        }
        /// <p>The granularity. The only valid value is <code>1Minute</code>.</p>
        pub fn set_granularity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.granularity = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricGranularityType`](crate::model::MetricGranularityType)
        pub fn build(self) -> crate::model::MetricGranularityType {
            crate::model::MetricGranularityType {
                granularity: self.granularity,
            }
        }
    }
}
impl MetricGranularityType {
    /// Creates a new builder-style object to manufacture [`MetricGranularityType`](crate::model::MetricGranularityType)
    pub fn builder() -> crate::model::metric_granularity_type::Builder {
        crate::model::metric_granularity_type::Builder::default()
    }
}

/// <p>Describes a metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricCollectionType {
    /// <p>One of the following metrics:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GroupMinSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupMaxSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolWarmedCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// </ul>
    pub metric: std::option::Option<std::string::String>,
}
impl MetricCollectionType {
    /// <p>One of the following metrics:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GroupMinSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupMaxSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolWarmedCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
}
impl std::fmt::Debug for MetricCollectionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricCollectionType");
        formatter.field("metric", &self.metric);
        formatter.finish()
    }
}
/// See [`MetricCollectionType`](crate::model::MetricCollectionType)
pub mod metric_collection_type {
    /// A builder for [`MetricCollectionType`](crate::model::MetricCollectionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One of the following metrics:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GroupMinSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupMaxSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolWarmedCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>One of the following metrics:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GroupMinSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupMaxSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolWarmedCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricCollectionType`](crate::model::MetricCollectionType)
        pub fn build(self) -> crate::model::MetricCollectionType {
            crate::model::MetricCollectionType {
                metric: self.metric,
            }
        }
    }
}
impl MetricCollectionType {
    /// Creates a new builder-style object to manufacture [`MetricCollectionType`](crate::model::MetricCollectionType)
    pub fn builder() -> crate::model::metric_collection_type::Builder {
        crate::model::metric_collection_type::Builder::default()
    }
}

/// <p>Describes the state of a target group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerTargetGroupState {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub load_balancer_target_group_arn: std::option::Option<std::string::String>,
    /// <p>The state of the target group.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Adding</code> - The Auto Scaling instances are being registered with the target
    /// group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Added</code> - All Auto Scaling instances are registered with the target
    /// group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
    /// health check.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
    /// target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight
    /// requests to complete before deregistering the instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removed</code> - All Auto Scaling instances are deregistered from the target
    /// group.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<std::string::String>,
}
impl LoadBalancerTargetGroupState {
    /// <p>The Amazon Resource Name (ARN) of the target group.</p>
    pub fn load_balancer_target_group_arn(&self) -> std::option::Option<&str> {
        self.load_balancer_target_group_arn.as_deref()
    }
    /// <p>The state of the target group.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Adding</code> - The Auto Scaling instances are being registered with the target
    /// group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Added</code> - All Auto Scaling instances are registered with the target
    /// group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
    /// health check.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
    /// target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight
    /// requests to complete before deregistering the instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removed</code> - All Auto Scaling instances are deregistered from the target
    /// group.</p>
    /// </li>
    /// </ul>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
}
impl std::fmt::Debug for LoadBalancerTargetGroupState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerTargetGroupState");
        formatter.field(
            "load_balancer_target_group_arn",
            &self.load_balancer_target_group_arn,
        );
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`LoadBalancerTargetGroupState`](crate::model::LoadBalancerTargetGroupState)
pub mod load_balancer_target_group_state {
    /// A builder for [`LoadBalancerTargetGroupState`](crate::model::LoadBalancerTargetGroupState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_target_group_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn load_balancer_target_group_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.load_balancer_target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target group.</p>
        pub fn set_load_balancer_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_target_group_arn = input;
            self
        }
        /// <p>The state of the target group.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Adding</code> - The Auto Scaling instances are being registered with the target
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Added</code> - All Auto Scaling instances are registered with the target
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
        /// health check.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
        /// target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight
        /// requests to complete before deregistering the instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removed</code> - All Auto Scaling instances are deregistered from the target
        /// group.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the target group.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Adding</code> - The Auto Scaling instances are being registered with the target
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Added</code> - All Auto Scaling instances are registered with the target
        /// group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
        /// health check.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
        /// target group. If connection draining is enabled, Elastic Load Balancing waits for in-flight
        /// requests to complete before deregistering the instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removed</code> - All Auto Scaling instances are deregistered from the target
        /// group.</p>
        /// </li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerTargetGroupState`](crate::model::LoadBalancerTargetGroupState)
        pub fn build(self) -> crate::model::LoadBalancerTargetGroupState {
            crate::model::LoadBalancerTargetGroupState {
                load_balancer_target_group_arn: self.load_balancer_target_group_arn,
                state: self.state,
            }
        }
    }
}
impl LoadBalancerTargetGroupState {
    /// Creates a new builder-style object to manufacture [`LoadBalancerTargetGroupState`](crate::model::LoadBalancerTargetGroupState)
    pub fn builder() -> crate::model::load_balancer_target_group_state::Builder {
        crate::model::load_balancer_target_group_state::Builder::default()
    }
}

/// <p>Describes the state of a Classic Load Balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerState {
    /// <p>The name of the load balancer.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>One of the following load balancer states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Adding</code> - The Auto Scaling instances are being registered with the load
    /// balancer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Added</code> - All Auto Scaling instances are registered with the load
    /// balancer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
    /// health check.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
    /// load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight
    /// requests to complete before deregistering the instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removed</code> - All Auto Scaling instances are deregistered from the load
    /// balancer.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<std::string::String>,
}
impl LoadBalancerState {
    /// <p>The name of the load balancer.</p>
    pub fn load_balancer_name(&self) -> std::option::Option<&str> {
        self.load_balancer_name.as_deref()
    }
    /// <p>One of the following load balancer states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Adding</code> - The Auto Scaling instances are being registered with the load
    /// balancer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Added</code> - All Auto Scaling instances are registered with the load
    /// balancer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
    /// health check.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
    /// load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight
    /// requests to complete before deregistering the instances.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Removed</code> - All Auto Scaling instances are deregistered from the load
    /// balancer.</p>
    /// </li>
    /// </ul>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
}
impl std::fmt::Debug for LoadBalancerState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerState");
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`LoadBalancerState`](crate::model::LoadBalancerState)
pub mod load_balancer_state {
    /// A builder for [`LoadBalancerState`](crate::model::LoadBalancerState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>One of the following load balancer states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Adding</code> - The Auto Scaling instances are being registered with the load
        /// balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Added</code> - All Auto Scaling instances are registered with the load
        /// balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
        /// health check.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
        /// load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight
        /// requests to complete before deregistering the instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removed</code> - All Auto Scaling instances are deregistered from the load
        /// balancer.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>One of the following load balancer states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Adding</code> - The Auto Scaling instances are being registered with the load
        /// balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Added</code> - All Auto Scaling instances are registered with the load
        /// balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InService</code> - At least one Auto Scaling instance passed an <code>ELB</code>
        /// health check.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removing</code> - The Auto Scaling instances are being deregistered from the
        /// load balancer. If connection draining is enabled, Elastic Load Balancing waits for in-flight
        /// requests to complete before deregistering the instances.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Removed</code> - All Auto Scaling instances are deregistered from the load
        /// balancer.</p>
        /// </li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerState`](crate::model::LoadBalancerState)
        pub fn build(self) -> crate::model::LoadBalancerState {
            crate::model::LoadBalancerState {
                load_balancer_name: self.load_balancer_name,
                state: self.state,
            }
        }
    }
}
impl LoadBalancerState {
    /// Creates a new builder-style object to manufacture [`LoadBalancerState`](crate::model::LoadBalancerState)
    pub fn builder() -> crate::model::load_balancer_state::Builder {
        crate::model::load_balancer_state::Builder::default()
    }
}

/// <p>Describes a lifecycle hook, which tells Amazon EC2 Auto Scaling that you want to perform an action
/// whenever it launches instances or terminates
/// instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleHook {
    /// <p>The name of the lifecycle hook.</p>
    pub lifecycle_hook_name: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group for the lifecycle hook.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The state of the EC2 instance to which to attach the lifecycle hook. The following are
    /// possible values:</p>
    /// <ul>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
    /// </li>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
    /// </li>
    /// </ul>
    pub lifecycle_transition: std::option::Option<std::string::String>,
    /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
    /// transition state for the lifecycle hook. The notification target can be either an SQS
    /// queue or an SNS topic.</p>
    pub notification_target_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
    /// notification target.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Additional information that is included any time Amazon EC2 Auto Scaling sends a message to the
    /// notification target.</p>
    pub notification_metadata: std::option::Option<std::string::String>,
    /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. If
    /// the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the
    /// <code>DefaultResult</code> parameter.</p>
    pub heartbeat_timeout: std::option::Option<i32>,
    /// <p>The maximum time, in seconds, that an instance can remain in a
    /// <code>Pending:Wait</code> or <code>Terminating:Wait</code> state. The maximum is
    /// 172800 seconds (48 hours) or 100 times <code>HeartbeatTimeout</code>, whichever is
    /// smaller.</p>
    pub global_timeout: std::option::Option<i32>,
    /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
    /// or if an unexpected failure occurs. The possible values are <code>CONTINUE</code> and
    /// <code>ABANDON</code>.</p>
    pub default_result: std::option::Option<std::string::String>,
}
impl LifecycleHook {
    /// <p>The name of the lifecycle hook.</p>
    pub fn lifecycle_hook_name(&self) -> std::option::Option<&str> {
        self.lifecycle_hook_name.as_deref()
    }
    /// <p>The name of the Auto Scaling group for the lifecycle hook.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The state of the EC2 instance to which to attach the lifecycle hook. The following are
    /// possible values:</p>
    /// <ul>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
    /// </li>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
    /// </li>
    /// </ul>
    pub fn lifecycle_transition(&self) -> std::option::Option<&str> {
        self.lifecycle_transition.as_deref()
    }
    /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
    /// transition state for the lifecycle hook. The notification target can be either an SQS
    /// queue or an SNS topic.</p>
    pub fn notification_target_arn(&self) -> std::option::Option<&str> {
        self.notification_target_arn.as_deref()
    }
    /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
    /// notification target.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Additional information that is included any time Amazon EC2 Auto Scaling sends a message to the
    /// notification target.</p>
    pub fn notification_metadata(&self) -> std::option::Option<&str> {
        self.notification_metadata.as_deref()
    }
    /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. If
    /// the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the
    /// <code>DefaultResult</code> parameter.</p>
    pub fn heartbeat_timeout(&self) -> std::option::Option<i32> {
        self.heartbeat_timeout
    }
    /// <p>The maximum time, in seconds, that an instance can remain in a
    /// <code>Pending:Wait</code> or <code>Terminating:Wait</code> state. The maximum is
    /// 172800 seconds (48 hours) or 100 times <code>HeartbeatTimeout</code>, whichever is
    /// smaller.</p>
    pub fn global_timeout(&self) -> std::option::Option<i32> {
        self.global_timeout
    }
    /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
    /// or if an unexpected failure occurs. The possible values are <code>CONTINUE</code> and
    /// <code>ABANDON</code>.</p>
    pub fn default_result(&self) -> std::option::Option<&str> {
        self.default_result.as_deref()
    }
}
impl std::fmt::Debug for LifecycleHook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleHook");
        formatter.field("lifecycle_hook_name", &self.lifecycle_hook_name);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("lifecycle_transition", &self.lifecycle_transition);
        formatter.field("notification_target_arn", &self.notification_target_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("notification_metadata", &self.notification_metadata);
        formatter.field("heartbeat_timeout", &self.heartbeat_timeout);
        formatter.field("global_timeout", &self.global_timeout);
        formatter.field("default_result", &self.default_result);
        formatter.finish()
    }
}
/// See [`LifecycleHook`](crate::model::LifecycleHook)
pub mod lifecycle_hook {
    /// A builder for [`LifecycleHook`](crate::model::LifecycleHook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_hook_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_transition: std::option::Option<std::string::String>,
        pub(crate) notification_target_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) notification_metadata: std::option::Option<std::string::String>,
        pub(crate) heartbeat_timeout: std::option::Option<i32>,
        pub(crate) global_timeout: std::option::Option<i32>,
        pub(crate) default_result: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lifecycle hook.</p>
        pub fn lifecycle_hook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_hook_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle hook.</p>
        pub fn set_lifecycle_hook_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_hook_name = input;
            self
        }
        /// <p>The name of the Auto Scaling group for the lifecycle hook.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group for the lifecycle hook.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The state of the EC2 instance to which to attach the lifecycle hook. The following are
        /// possible values:</p>
        /// <ul>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
        /// </li>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
        /// </li>
        /// </ul>
        pub fn lifecycle_transition(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_transition = Some(input.into());
            self
        }
        /// <p>The state of the EC2 instance to which to attach the lifecycle hook. The following are
        /// possible values:</p>
        /// <ul>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
        /// </li>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle_transition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_transition = input;
            self
        }
        /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
        /// transition state for the lifecycle hook. The notification target can be either an SQS
        /// queue or an SNS topic.</p>
        pub fn notification_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
        /// transition state for the lifecycle hook. The notification target can be either an SQS
        /// queue or an SNS topic.</p>
        pub fn set_notification_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target_arn = input;
            self
        }
        /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
        /// notification target.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
        /// notification target.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Additional information that is included any time Amazon EC2 Auto Scaling sends a message to the
        /// notification target.</p>
        pub fn notification_metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_metadata = Some(input.into());
            self
        }
        /// <p>Additional information that is included any time Amazon EC2 Auto Scaling sends a message to the
        /// notification target.</p>
        pub fn set_notification_metadata(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_metadata = input;
            self
        }
        /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. If
        /// the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the
        /// <code>DefaultResult</code> parameter.</p>
        pub fn heartbeat_timeout(mut self, input: i32) -> Self {
            self.heartbeat_timeout = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times out. If
        /// the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in the
        /// <code>DefaultResult</code> parameter.</p>
        pub fn set_heartbeat_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.heartbeat_timeout = input;
            self
        }
        /// <p>The maximum time, in seconds, that an instance can remain in a
        /// <code>Pending:Wait</code> or <code>Terminating:Wait</code> state. The maximum is
        /// 172800 seconds (48 hours) or 100 times <code>HeartbeatTimeout</code>, whichever is
        /// smaller.</p>
        pub fn global_timeout(mut self, input: i32) -> Self {
            self.global_timeout = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, that an instance can remain in a
        /// <code>Pending:Wait</code> or <code>Terminating:Wait</code> state. The maximum is
        /// 172800 seconds (48 hours) or 100 times <code>HeartbeatTimeout</code>, whichever is
        /// smaller.</p>
        pub fn set_global_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.global_timeout = input;
            self
        }
        /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
        /// or if an unexpected failure occurs. The possible values are <code>CONTINUE</code> and
        /// <code>ABANDON</code>.</p>
        pub fn default_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_result = Some(input.into());
            self
        }
        /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
        /// or if an unexpected failure occurs. The possible values are <code>CONTINUE</code> and
        /// <code>ABANDON</code>.</p>
        pub fn set_default_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_result = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleHook`](crate::model::LifecycleHook)
        pub fn build(self) -> crate::model::LifecycleHook {
            crate::model::LifecycleHook {
                lifecycle_hook_name: self.lifecycle_hook_name,
                auto_scaling_group_name: self.auto_scaling_group_name,
                lifecycle_transition: self.lifecycle_transition,
                notification_target_arn: self.notification_target_arn,
                role_arn: self.role_arn,
                notification_metadata: self.notification_metadata,
                heartbeat_timeout: self.heartbeat_timeout,
                global_timeout: self.global_timeout,
                default_result: self.default_result,
            }
        }
    }
}
impl LifecycleHook {
    /// Creates a new builder-style object to manufacture [`LifecycleHook`](crate::model::LifecycleHook)
    pub fn builder() -> crate::model::lifecycle_hook::Builder {
        crate::model::lifecycle_hook::Builder::default()
    }
}

/// <p>Describes a launch configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LaunchConfiguration {
    /// <p>The name of the launch configuration.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the launch configuration.</p>
    pub launch_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub image_id: std::option::Option<std::string::String>,
    /// <p>The name of the key pair.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
    /// VPC</a> in the <i>Amazon Virtual Private Cloud User
    /// Guide</i>.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
    /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub classic_link_vpc_id: std::option::Option<std::string::String>,
    /// <p>The IDs of one or more security groups for the VPC specified in
    /// <code>ClassicLinkVPCId</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
    /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub classic_link_vpc_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The user data to make available to the launched EC2 instances. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and
    /// user data</a> (Windows). If you are using a command line tool, base64-encoding
    /// is performed for you, and you can load the text from a file. Otherwise, you must provide
    /// base64-encoded text. User data is limited to 16 KB.</p>
    pub user_data: std::option::Option<std::string::String>,
    /// <p>The instance type for the instances.</p>
    /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
    /// Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The ID of the kernel associated with the AMI.</p>
    pub kernel_id: std::option::Option<std::string::String>,
    /// <p>The ID of the RAM disk associated with the AMI.</p>
    pub ramdisk_id: std::option::Option<std::string::String>,
    /// <p>A block device mapping, which specifies the block devices for the instance. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
    /// Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub block_device_mappings: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
    /// <p>Controls whether instances in this group are launched with detailed
    /// (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
    /// Monitoring for Auto Scaling Instances</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub instance_monitoring: std::option::Option<crate::model::InstanceMonitoring>,
    /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the
    /// request. Spot Instances are launched when the price you specify exceeds the current Spot
    /// price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot
    /// Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub spot_price: std::option::Option<std::string::String>,
    /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the
    /// IAM role for the instance. The instance profile contains the IAM role. For more
    /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run
    /// on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub iam_instance_profile: std::option::Option<std::string::String>,
    /// <p>The creation date and time for the launch configuration.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies whether the launch configuration is optimized for EBS I/O
    /// (<code>true</code>) or not (<code>false</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon
    /// EBS-Optimized Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub ebs_optimized: std::option::Option<bool>,
    /// <p>For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP
    /// address to the group's instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a
    /// VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub associate_public_ip_address: std::option::Option<bool>,
    /// <p>The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An
    /// instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware
    /// and can only be launched into a VPC.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring
    /// instance tenancy with Amazon EC2 Auto Scaling</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub placement_tenancy: std::option::Option<std::string::String>,
    /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub metadata_options: std::option::Option<crate::model::InstanceMetadataOptions>,
}
impl LaunchConfiguration {
    /// <p>The name of the launch configuration.</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the launch configuration.</p>
    pub fn launch_configuration_arn(&self) -> std::option::Option<&str> {
        self.launch_configuration_arn.as_deref()
    }
    /// <p>The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn image_id(&self) -> std::option::Option<&str> {
        self.image_id.as_deref()
    }
    /// <p>The name of the key pair.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
    /// VPC</a> in the <i>Amazon Virtual Private Cloud User
    /// Guide</i>.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
    /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn classic_link_vpc_id(&self) -> std::option::Option<&str> {
        self.classic_link_vpc_id.as_deref()
    }
    /// <p>The IDs of one or more security groups for the VPC specified in
    /// <code>ClassicLinkVPCId</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
    /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn classic_link_vpc_security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.classic_link_vpc_security_groups.as_deref()
    }
    /// <p>The user data to make available to the launched EC2 instances. For more information,
    /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and
    /// user data</a> (Windows). If you are using a command line tool, base64-encoding
    /// is performed for you, and you can load the text from a file. Otherwise, you must provide
    /// base64-encoded text. User data is limited to 16 KB.</p>
    pub fn user_data(&self) -> std::option::Option<&str> {
        self.user_data.as_deref()
    }
    /// <p>The instance type for the instances.</p>
    /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
    /// Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The ID of the kernel associated with the AMI.</p>
    pub fn kernel_id(&self) -> std::option::Option<&str> {
        self.kernel_id.as_deref()
    }
    /// <p>The ID of the RAM disk associated with the AMI.</p>
    pub fn ramdisk_id(&self) -> std::option::Option<&str> {
        self.ramdisk_id.as_deref()
    }
    /// <p>A block device mapping, which specifies the block devices for the instance. For more
    /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
    /// Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn block_device_mappings(
        &self,
    ) -> std::option::Option<&[crate::model::BlockDeviceMapping]> {
        self.block_device_mappings.as_deref()
    }
    /// <p>Controls whether instances in this group are launched with detailed
    /// (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
    /// Monitoring for Auto Scaling Instances</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn instance_monitoring(&self) -> std::option::Option<&crate::model::InstanceMonitoring> {
        self.instance_monitoring.as_ref()
    }
    /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the
    /// request. Spot Instances are launched when the price you specify exceeds the current Spot
    /// price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot
    /// Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn spot_price(&self) -> std::option::Option<&str> {
        self.spot_price.as_deref()
    }
    /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the
    /// IAM role for the instance. The instance profile contains the IAM role. For more
    /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run
    /// on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn iam_instance_profile(&self) -> std::option::Option<&str> {
        self.iam_instance_profile.as_deref()
    }
    /// <p>The creation date and time for the launch configuration.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>Specifies whether the launch configuration is optimized for EBS I/O
    /// (<code>true</code>) or not (<code>false</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon
    /// EBS-Optimized Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn ebs_optimized(&self) -> std::option::Option<bool> {
        self.ebs_optimized
    }
    /// <p>For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP
    /// address to the group's instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a
    /// VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn associate_public_ip_address(&self) -> std::option::Option<bool> {
        self.associate_public_ip_address
    }
    /// <p>The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An
    /// instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware
    /// and can only be launched into a VPC.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring
    /// instance tenancy with Amazon EC2 Auto Scaling</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn placement_tenancy(&self) -> std::option::Option<&str> {
        self.placement_tenancy.as_deref()
    }
    /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    pub fn metadata_options(&self) -> std::option::Option<&crate::model::InstanceMetadataOptions> {
        self.metadata_options.as_ref()
    }
}
impl std::fmt::Debug for LaunchConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LaunchConfiguration");
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("launch_configuration_arn", &self.launch_configuration_arn);
        formatter.field("image_id", &self.image_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("classic_link_vpc_id", &self.classic_link_vpc_id);
        formatter.field(
            "classic_link_vpc_security_groups",
            &self.classic_link_vpc_security_groups,
        );
        formatter.field("user_data", &self.user_data);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("kernel_id", &self.kernel_id);
        formatter.field("ramdisk_id", &self.ramdisk_id);
        formatter.field("block_device_mappings", &self.block_device_mappings);
        formatter.field("instance_monitoring", &self.instance_monitoring);
        formatter.field("spot_price", &self.spot_price);
        formatter.field("iam_instance_profile", &self.iam_instance_profile);
        formatter.field("created_time", &self.created_time);
        formatter.field("ebs_optimized", &self.ebs_optimized);
        formatter.field(
            "associate_public_ip_address",
            &self.associate_public_ip_address,
        );
        formatter.field("placement_tenancy", &self.placement_tenancy);
        formatter.field("metadata_options", &self.metadata_options);
        formatter.finish()
    }
}
/// See [`LaunchConfiguration`](crate::model::LaunchConfiguration)
pub mod launch_configuration {
    /// A builder for [`LaunchConfiguration`](crate::model::LaunchConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) launch_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) image_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) classic_link_vpc_id: std::option::Option<std::string::String>,
        pub(crate) classic_link_vpc_security_groups:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) user_data: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) kernel_id: std::option::Option<std::string::String>,
        pub(crate) ramdisk_id: std::option::Option<std::string::String>,
        pub(crate) block_device_mappings:
            std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        pub(crate) instance_monitoring: std::option::Option<crate::model::InstanceMonitoring>,
        pub(crate) spot_price: std::option::Option<std::string::String>,
        pub(crate) iam_instance_profile: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ebs_optimized: std::option::Option<bool>,
        pub(crate) associate_public_ip_address: std::option::Option<bool>,
        pub(crate) placement_tenancy: std::option::Option<std::string::String>,
        pub(crate) metadata_options: std::option::Option<crate::model::InstanceMetadataOptions>,
    }
    impl Builder {
        /// <p>The name of the launch configuration.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the launch configuration.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the launch configuration.</p>
        pub fn launch_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the launch configuration.</p>
        pub fn set_launch_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_arn = input;
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn image_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding an AMI</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_image_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_id = input;
            self
        }
        /// <p>The name of the key pair.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 Key Pairs</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
        /// VPC</a> in the <i>Amazon Virtual Private Cloud User
        /// Guide</i>.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list that contains the security groups to assign to the instances in the Auto Scaling group.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Security Groups for Your
        /// VPC</a> in the <i>Amazon Virtual Private Cloud User
        /// Guide</i>.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
        /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn classic_link_vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.classic_link_vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
        /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_classic_link_vpc_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.classic_link_vpc_id = input;
            self
        }
        /// Appends an item to `classic_link_vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_classic_link_vpc_security_groups`](Self::set_classic_link_vpc_security_groups).
        ///
        /// <p>The IDs of one or more security groups for the VPC specified in
        /// <code>ClassicLinkVPCId</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
        /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn classic_link_vpc_security_groups(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.classic_link_vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.classic_link_vpc_security_groups = Some(v);
            self
        }
        /// <p>The IDs of one or more security groups for the VPC specified in
        /// <code>ClassicLinkVPCId</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html">ClassicLink</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink">Linking EC2-Classic
        /// instances to a VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_classic_link_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.classic_link_vpc_security_groups = input;
            self
        }
        /// <p>The user data to make available to the launched EC2 instances. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and
        /// user data</a> (Windows). If you are using a command line tool, base64-encoding
        /// is performed for you, and you can load the text from a file. Otherwise, you must provide
        /// base64-encoded text. User data is limited to 16 KB.</p>
        pub fn user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data = Some(input.into());
            self
        }
        /// <p>The user data to make available to the launched EC2 instances. For more information,
        /// see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> (Linux) and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html">Instance metadata and
        /// user data</a> (Windows). If you are using a command line tool, base64-encoding
        /// is performed for you, and you can load the text from a file. Otherwise, you must provide
        /// base64-encoded text. User data is limited to 16 KB.</p>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_data = input;
            self
        }
        /// <p>The instance type for the instances.</p>
        /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
        /// Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type for the instances.</p>
        /// <p>For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
        /// Instance Types</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The ID of the kernel associated with the AMI.</p>
        pub fn kernel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kernel_id = Some(input.into());
            self
        }
        /// <p>The ID of the kernel associated with the AMI.</p>
        pub fn set_kernel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kernel_id = input;
            self
        }
        /// <p>The ID of the RAM disk associated with the AMI.</p>
        pub fn ramdisk_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ramdisk_id = Some(input.into());
            self
        }
        /// <p>The ID of the RAM disk associated with the AMI.</p>
        pub fn set_ramdisk_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ramdisk_id = input;
            self
        }
        /// Appends an item to `block_device_mappings`.
        ///
        /// To override the contents of this collection use [`set_block_device_mappings`](Self::set_block_device_mappings).
        ///
        /// <p>A block device mapping, which specifies the block devices for the instance. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
        /// Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn block_device_mappings(
            mut self,
            input: impl Into<crate::model::BlockDeviceMapping>,
        ) -> Self {
            let mut v = self.block_device_mappings.unwrap_or_default();
            v.push(input.into());
            self.block_device_mappings = Some(v);
            self
        }
        /// <p>A block device mapping, which specifies the block devices for the instance. For more
        /// information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
        /// Mapping</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_block_device_mappings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BlockDeviceMapping>>,
        ) -> Self {
            self.block_device_mappings = input;
            self
        }
        /// <p>Controls whether instances in this group are launched with detailed
        /// (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
        /// Monitoring for Auto Scaling Instances</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn instance_monitoring(mut self, input: crate::model::InstanceMonitoring) -> Self {
            self.instance_monitoring = Some(input);
            self
        }
        /// <p>Controls whether instances in this group are launched with detailed
        /// (<code>true</code>) or basic (<code>false</code>) monitoring.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure
        /// Monitoring for Auto Scaling Instances</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_instance_monitoring(
            mut self,
            input: std::option::Option<crate::model::InstanceMonitoring>,
        ) -> Self {
            self.instance_monitoring = input;
            self
        }
        /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the
        /// request. Spot Instances are launched when the price you specify exceeds the current Spot
        /// price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot
        /// Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn spot_price(mut self, input: impl Into<std::string::String>) -> Self {
            self.spot_price = Some(input.into());
            self
        }
        /// <p>The maximum hourly price to be paid for any Spot Instance launched to fulfill the
        /// request. Spot Instances are launched when the price you specify exceeds the current Spot
        /// price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html">Requesting Spot
        /// Instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_spot_price(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.spot_price = input;
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the
        /// IAM role for the instance. The instance profile contains the IAM role. For more
        /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run
        /// on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn iam_instance_profile(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_instance_profile = Some(input.into());
            self
        }
        /// <p>The name or the Amazon Resource Name (ARN) of the instance profile associated with the
        /// IAM role for the instance. The instance profile contains the IAM role. For more
        /// information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run
        /// on Amazon EC2 instances</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_instance_profile = input;
            self
        }
        /// <p>The creation date and time for the launch configuration.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The creation date and time for the launch configuration.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Specifies whether the launch configuration is optimized for EBS I/O
        /// (<code>true</code>) or not (<code>false</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon
        /// EBS-Optimized Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn ebs_optimized(mut self, input: bool) -> Self {
            self.ebs_optimized = Some(input);
            self
        }
        /// <p>Specifies whether the launch configuration is optimized for EBS I/O
        /// (<code>true</code>) or not (<code>false</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html">Amazon
        /// EBS-Optimized Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_ebs_optimized(mut self, input: std::option::Option<bool>) -> Self {
            self.ebs_optimized = input;
            self
        }
        /// <p>For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP
        /// address to the group's instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a
        /// VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn associate_public_ip_address(mut self, input: bool) -> Self {
            self.associate_public_ip_address = Some(input);
            self
        }
        /// <p>For Auto Scaling groups that are running in a VPC, specifies whether to assign a public IP
        /// address to the group's instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Launching Auto Scaling instances in a
        /// VPC</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_associate_public_ip_address(mut self, input: std::option::Option<bool>) -> Self {
            self.associate_public_ip_address = input;
            self
        }
        /// <p>The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An
        /// instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware
        /// and can only be launched into a VPC.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring
        /// instance tenancy with Amazon EC2 Auto Scaling</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn placement_tenancy(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_tenancy = Some(input.into());
            self
        }
        /// <p>The tenancy of the instance, either <code>default</code> or <code>dedicated</code>. An
        /// instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware
        /// and can only be launched into a VPC.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html">Configuring
        /// instance tenancy with Amazon EC2 Auto Scaling</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_placement_tenancy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_tenancy = input;
            self
        }
        /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn metadata_options(mut self, input: crate::model::InstanceMetadataOptions) -> Self {
            self.metadata_options = Some(input);
            self
        }
        /// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        pub fn set_metadata_options(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataOptions>,
        ) -> Self {
            self.metadata_options = input;
            self
        }
        /// Consumes the builder and constructs a [`LaunchConfiguration`](crate::model::LaunchConfiguration)
        pub fn build(self) -> crate::model::LaunchConfiguration {
            crate::model::LaunchConfiguration {
                launch_configuration_name: self.launch_configuration_name,
                launch_configuration_arn: self.launch_configuration_arn,
                image_id: self.image_id,
                key_name: self.key_name,
                security_groups: self.security_groups,
                classic_link_vpc_id: self.classic_link_vpc_id,
                classic_link_vpc_security_groups: self.classic_link_vpc_security_groups,
                user_data: self.user_data,
                instance_type: self.instance_type,
                kernel_id: self.kernel_id,
                ramdisk_id: self.ramdisk_id,
                block_device_mappings: self.block_device_mappings,
                instance_monitoring: self.instance_monitoring,
                spot_price: self.spot_price,
                iam_instance_profile: self.iam_instance_profile,
                created_time: self.created_time,
                ebs_optimized: self.ebs_optimized,
                associate_public_ip_address: self.associate_public_ip_address,
                placement_tenancy: self.placement_tenancy,
                metadata_options: self.metadata_options,
            }
        }
    }
}
impl LaunchConfiguration {
    /// Creates a new builder-style object to manufacture [`LaunchConfiguration`](crate::model::LaunchConfiguration)
    pub fn builder() -> crate::model::launch_configuration::Builder {
        crate::model::launch_configuration::Builder::default()
    }
}

/// <p>The metadata options for the instances. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configuring the Instance Metadata Options</a> in the
/// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMetadataOptions {
    /// <p>The state of token usage for your instance metadata requests. If the parameter is not
    /// specified in the request, the default state is <code>optional</code>.</p>
    /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata
    /// with or without a signed token header on your request. If you retrieve the IAM role
    /// credentials without a token, the version 1.0 role credentials are returned. If you
    /// retrieve the IAM role credentials using a valid signed token, the version 2.0 role
    /// credentials are returned.</p>
    /// <p>If the state is <code>required</code>, you must send a signed token header with any
    /// instance metadata retrieval requests. In this state, retrieving the IAM role credentials
    /// always returns the version 2.0 credentials; the version 1.0 credentials are not
    /// available.</p>
    pub http_tokens: std::option::Option<crate::model::InstanceMetadataHttpTokensState>,
    /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the
    /// number, the further instance metadata requests can travel.</p>
    /// <p>Default: 1</p>
    pub http_put_response_hop_limit: std::option::Option<i32>,
    /// <p>This parameter enables or disables the HTTP metadata endpoint on your instances. If
    /// the parameter is not specified, the default state is <code>enabled</code>.</p>
    /// <note>
    /// <p>If you specify a value of <code>disabled</code>, you will not be able to access
    /// your instance metadata. </p>
    /// </note>
    pub http_endpoint: std::option::Option<crate::model::InstanceMetadataEndpointState>,
}
impl InstanceMetadataOptions {
    /// <p>The state of token usage for your instance metadata requests. If the parameter is not
    /// specified in the request, the default state is <code>optional</code>.</p>
    /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata
    /// with or without a signed token header on your request. If you retrieve the IAM role
    /// credentials without a token, the version 1.0 role credentials are returned. If you
    /// retrieve the IAM role credentials using a valid signed token, the version 2.0 role
    /// credentials are returned.</p>
    /// <p>If the state is <code>required</code>, you must send a signed token header with any
    /// instance metadata retrieval requests. In this state, retrieving the IAM role credentials
    /// always returns the version 2.0 credentials; the version 1.0 credentials are not
    /// available.</p>
    pub fn http_tokens(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataHttpTokensState> {
        self.http_tokens.as_ref()
    }
    /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the
    /// number, the further instance metadata requests can travel.</p>
    /// <p>Default: 1</p>
    pub fn http_put_response_hop_limit(&self) -> std::option::Option<i32> {
        self.http_put_response_hop_limit
    }
    /// <p>This parameter enables or disables the HTTP metadata endpoint on your instances. If
    /// the parameter is not specified, the default state is <code>enabled</code>.</p>
    /// <note>
    /// <p>If you specify a value of <code>disabled</code>, you will not be able to access
    /// your instance metadata. </p>
    /// </note>
    pub fn http_endpoint(
        &self,
    ) -> std::option::Option<&crate::model::InstanceMetadataEndpointState> {
        self.http_endpoint.as_ref()
    }
}
impl std::fmt::Debug for InstanceMetadataOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMetadataOptions");
        formatter.field("http_tokens", &self.http_tokens);
        formatter.field(
            "http_put_response_hop_limit",
            &self.http_put_response_hop_limit,
        );
        formatter.field("http_endpoint", &self.http_endpoint);
        formatter.finish()
    }
}
/// See [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
pub mod instance_metadata_options {
    /// A builder for [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_tokens: std::option::Option<crate::model::InstanceMetadataHttpTokensState>,
        pub(crate) http_put_response_hop_limit: std::option::Option<i32>,
        pub(crate) http_endpoint: std::option::Option<crate::model::InstanceMetadataEndpointState>,
    }
    impl Builder {
        /// <p>The state of token usage for your instance metadata requests. If the parameter is not
        /// specified in the request, the default state is <code>optional</code>.</p>
        /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata
        /// with or without a signed token header on your request. If you retrieve the IAM role
        /// credentials without a token, the version 1.0 role credentials are returned. If you
        /// retrieve the IAM role credentials using a valid signed token, the version 2.0 role
        /// credentials are returned.</p>
        /// <p>If the state is <code>required</code>, you must send a signed token header with any
        /// instance metadata retrieval requests. In this state, retrieving the IAM role credentials
        /// always returns the version 2.0 credentials; the version 1.0 credentials are not
        /// available.</p>
        pub fn http_tokens(mut self, input: crate::model::InstanceMetadataHttpTokensState) -> Self {
            self.http_tokens = Some(input);
            self
        }
        /// <p>The state of token usage for your instance metadata requests. If the parameter is not
        /// specified in the request, the default state is <code>optional</code>.</p>
        /// <p>If the state is <code>optional</code>, you can choose to retrieve instance metadata
        /// with or without a signed token header on your request. If you retrieve the IAM role
        /// credentials without a token, the version 1.0 role credentials are returned. If you
        /// retrieve the IAM role credentials using a valid signed token, the version 2.0 role
        /// credentials are returned.</p>
        /// <p>If the state is <code>required</code>, you must send a signed token header with any
        /// instance metadata retrieval requests. In this state, retrieving the IAM role credentials
        /// always returns the version 2.0 credentials; the version 1.0 credentials are not
        /// available.</p>
        pub fn set_http_tokens(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataHttpTokensState>,
        ) -> Self {
            self.http_tokens = input;
            self
        }
        /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the
        /// number, the further instance metadata requests can travel.</p>
        /// <p>Default: 1</p>
        pub fn http_put_response_hop_limit(mut self, input: i32) -> Self {
            self.http_put_response_hop_limit = Some(input);
            self
        }
        /// <p>The desired HTTP PUT response hop limit for instance metadata requests. The larger the
        /// number, the further instance metadata requests can travel.</p>
        /// <p>Default: 1</p>
        pub fn set_http_put_response_hop_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.http_put_response_hop_limit = input;
            self
        }
        /// <p>This parameter enables or disables the HTTP metadata endpoint on your instances. If
        /// the parameter is not specified, the default state is <code>enabled</code>.</p>
        /// <note>
        /// <p>If you specify a value of <code>disabled</code>, you will not be able to access
        /// your instance metadata. </p>
        /// </note>
        pub fn http_endpoint(mut self, input: crate::model::InstanceMetadataEndpointState) -> Self {
            self.http_endpoint = Some(input);
            self
        }
        /// <p>This parameter enables or disables the HTTP metadata endpoint on your instances. If
        /// the parameter is not specified, the default state is <code>enabled</code>.</p>
        /// <note>
        /// <p>If you specify a value of <code>disabled</code>, you will not be able to access
        /// your instance metadata. </p>
        /// </note>
        pub fn set_http_endpoint(
            mut self,
            input: std::option::Option<crate::model::InstanceMetadataEndpointState>,
        ) -> Self {
            self.http_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
        pub fn build(self) -> crate::model::InstanceMetadataOptions {
            crate::model::InstanceMetadataOptions {
                http_tokens: self.http_tokens,
                http_put_response_hop_limit: self.http_put_response_hop_limit,
                http_endpoint: self.http_endpoint,
            }
        }
    }
}
impl InstanceMetadataOptions {
    /// Creates a new builder-style object to manufacture [`InstanceMetadataOptions`](crate::model::InstanceMetadataOptions)
    pub fn builder() -> crate::model::instance_metadata_options::Builder {
        crate::model::instance_metadata_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceMetadataEndpointState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceMetadataEndpointState {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => InstanceMetadataEndpointState::Disabled,
            "enabled" => InstanceMetadataEndpointState::Enabled,
            other => InstanceMetadataEndpointState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceMetadataEndpointState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceMetadataEndpointState::from(s))
    }
}
impl InstanceMetadataEndpointState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceMetadataEndpointState::Disabled => "disabled",
            InstanceMetadataEndpointState::Enabled => "enabled",
            InstanceMetadataEndpointState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "enabled"]
    }
}
impl AsRef<str> for InstanceMetadataEndpointState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceMetadataHttpTokensState {
    #[allow(missing_docs)] // documentation missing in model
    Optional,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceMetadataHttpTokensState {
    fn from(s: &str) -> Self {
        match s {
            "optional" => InstanceMetadataHttpTokensState::Optional,
            "required" => InstanceMetadataHttpTokensState::Required,
            other => InstanceMetadataHttpTokensState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceMetadataHttpTokensState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceMetadataHttpTokensState::from(s))
    }
}
impl InstanceMetadataHttpTokensState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceMetadataHttpTokensState::Optional => "optional",
            InstanceMetadataHttpTokensState::Required => "required",
            InstanceMetadataHttpTokensState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["optional", "required"]
    }
}
impl AsRef<str> for InstanceMetadataHttpTokensState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes whether detailed monitoring is enabled for the Auto Scaling instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceMonitoring {
    /// <p>If <code>true</code>, detailed monitoring is enabled. Otherwise, basic monitoring is
    /// enabled.</p>
    pub enabled: std::option::Option<bool>,
}
impl InstanceMonitoring {
    /// <p>If <code>true</code>, detailed monitoring is enabled. Otherwise, basic monitoring is
    /// enabled.</p>
    pub fn enabled(&self) -> std::option::Option<bool> {
        self.enabled
    }
}
impl std::fmt::Debug for InstanceMonitoring {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceMonitoring");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`InstanceMonitoring`](crate::model::InstanceMonitoring)
pub mod instance_monitoring {
    /// A builder for [`InstanceMonitoring`](crate::model::InstanceMonitoring)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>If <code>true</code>, detailed monitoring is enabled. Otherwise, basic monitoring is
        /// enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, detailed monitoring is enabled. Otherwise, basic monitoring is
        /// enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceMonitoring`](crate::model::InstanceMonitoring)
        pub fn build(self) -> crate::model::InstanceMonitoring {
            crate::model::InstanceMonitoring {
                enabled: self.enabled,
            }
        }
    }
}
impl InstanceMonitoring {
    /// Creates a new builder-style object to manufacture [`InstanceMonitoring`](crate::model::InstanceMonitoring)
    pub fn builder() -> crate::model::instance_monitoring::Builder {
        crate::model::instance_monitoring::Builder::default()
    }
}

/// <p>Describes a block device mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockDeviceMapping {
    /// <p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>
    /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
    /// both.</p>
    pub virtual_name: std::option::Option<std::string::String>,
    /// <p>The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or
    /// <code>xvdh</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming on Linux
    /// Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub device_name: std::option::Option<std::string::String>,
    /// <p>Parameters used to automatically set up EBS volumes when an instance is
    /// launched.</p>
    /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
    /// both.</p>
    pub ebs: std::option::Option<crate::model::Ebs>,
    /// <p>Setting this value to <code>true</code> suppresses the specified device included in
    /// the block device mapping of the AMI.</p>
    /// <p>If <code>NoDevice</code> is <code>true</code> for the root device, instances might
    /// fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches replacement instances.</p>
    /// <p>If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.</p>
    pub no_device: std::option::Option<bool>,
}
impl BlockDeviceMapping {
    /// <p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>
    /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
    /// both.</p>
    pub fn virtual_name(&self) -> std::option::Option<&str> {
        self.virtual_name.as_deref()
    }
    /// <p>The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or
    /// <code>xvdh</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming on Linux
    /// Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    pub fn device_name(&self) -> std::option::Option<&str> {
        self.device_name.as_deref()
    }
    /// <p>Parameters used to automatically set up EBS volumes when an instance is
    /// launched.</p>
    /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
    /// both.</p>
    pub fn ebs(&self) -> std::option::Option<&crate::model::Ebs> {
        self.ebs.as_ref()
    }
    /// <p>Setting this value to <code>true</code> suppresses the specified device included in
    /// the block device mapping of the AMI.</p>
    /// <p>If <code>NoDevice</code> is <code>true</code> for the root device, instances might
    /// fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches replacement instances.</p>
    /// <p>If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.</p>
    pub fn no_device(&self) -> std::option::Option<bool> {
        self.no_device
    }
}
impl std::fmt::Debug for BlockDeviceMapping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockDeviceMapping");
        formatter.field("virtual_name", &self.virtual_name);
        formatter.field("device_name", &self.device_name);
        formatter.field("ebs", &self.ebs);
        formatter.field("no_device", &self.no_device);
        formatter.finish()
    }
}
/// See [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
pub mod block_device_mapping {
    /// A builder for [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_name: std::option::Option<std::string::String>,
        pub(crate) device_name: std::option::Option<std::string::String>,
        pub(crate) ebs: std::option::Option<crate::model::Ebs>,
        pub(crate) no_device: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>
        /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
        /// both.</p>
        pub fn virtual_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual device (for example, <code>ephemeral0</code>).</p>
        /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
        /// both.</p>
        pub fn set_virtual_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.virtual_name = input;
            self
        }
        /// <p>The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or
        /// <code>xvdh</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming on Linux
        /// Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn device_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_name = Some(input.into());
            self
        }
        /// <p>The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or
        /// <code>xvdh</code>). For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html">Device Naming on Linux
        /// Instances</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        pub fn set_device_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_name = input;
            self
        }
        /// <p>Parameters used to automatically set up EBS volumes when an instance is
        /// launched.</p>
        /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
        /// both.</p>
        pub fn ebs(mut self, input: crate::model::Ebs) -> Self {
            self.ebs = Some(input);
            self
        }
        /// <p>Parameters used to automatically set up EBS volumes when an instance is
        /// launched.</p>
        /// <p>You can specify either <code>VirtualName</code> or <code>Ebs</code>, but not
        /// both.</p>
        pub fn set_ebs(mut self, input: std::option::Option<crate::model::Ebs>) -> Self {
            self.ebs = input;
            self
        }
        /// <p>Setting this value to <code>true</code> suppresses the specified device included in
        /// the block device mapping of the AMI.</p>
        /// <p>If <code>NoDevice</code> is <code>true</code> for the root device, instances might
        /// fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches replacement instances.</p>
        /// <p>If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.</p>
        pub fn no_device(mut self, input: bool) -> Self {
            self.no_device = Some(input);
            self
        }
        /// <p>Setting this value to <code>true</code> suppresses the specified device included in
        /// the block device mapping of the AMI.</p>
        /// <p>If <code>NoDevice</code> is <code>true</code> for the root device, instances might
        /// fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches replacement instances.</p>
        /// <p>If you specify <code>NoDevice</code>, you cannot specify <code>Ebs</code>.</p>
        pub fn set_no_device(mut self, input: std::option::Option<bool>) -> Self {
            self.no_device = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
        pub fn build(self) -> crate::model::BlockDeviceMapping {
            crate::model::BlockDeviceMapping {
                virtual_name: self.virtual_name,
                device_name: self.device_name,
                ebs: self.ebs,
                no_device: self.no_device,
            }
        }
    }
}
impl BlockDeviceMapping {
    /// Creates a new builder-style object to manufacture [`BlockDeviceMapping`](crate::model::BlockDeviceMapping)
    pub fn builder() -> crate::model::block_device_mapping::Builder {
        crate::model::block_device_mapping::Builder::default()
    }
}

/// <p>Describes information used to set up an Amazon EBS volume specified in a block device
/// mapping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ebs {
    /// <p>The snapshot ID of the volume to use.</p>
    /// <p>You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.</p>
    pub snapshot_id: std::option::Option<std::string::String>,
    /// <p>The volume size, in GiBs. The following are the supported volumes sizes for each
    /// volume type: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>gp2</code> and <code>gp3</code>: 1-16,384</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code>: 4-16,384</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>st1</code> and <code>sc1</code>: 125-16,384</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>standard</code>: 1-1,024</p>
    /// </li>
    /// </ul>
    /// <p>You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you
    /// specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must
    /// be equal or greater than the size of the snapshot.</p>
    pub volume_size: std::option::Option<i32>,
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> |
    /// <code>st1</code> | <code>sc1</code> | <code>gp3</code>
    /// </p>
    pub volume_type: std::option::Option<std::string::String>,
    /// <p>Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the
    /// default value is <code>true</code>.</p>
    pub delete_on_termination: std::option::Option<bool>,
    /// <p>The number of input/output (I/O) operations per second (IOPS) to provision for the
    /// volume. For <code>gp3</code> and <code>io1</code> volumes, this represents the number of
    /// IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents
    /// the baseline performance of the volume and the rate at which the volume accumulates I/O
    /// credits for bursting. </p>
    /// <p>The following are the supported values for each volume type: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>gp3</code>: 3,000-16,000 IOPS</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code>: 100-64,000 IOPS</p>
    /// </li>
    /// </ul>
    ///
    /// <p>For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances
    /// built on the Nitro System</a>. Other instance families guarantee performance up
    /// to 32,000 IOPS. </p>
    /// <p>
    /// <code>Iops</code> is supported when the volume type is <code>gp3</code> or
    /// <code>io1</code> and required only when the volume type is <code>io1</code>. (Not
    /// used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code>
    /// volumes.) </p>
    pub iops: std::option::Option<i32>,
    /// <p>Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be
    /// attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>. If your AMI uses encrypted volumes, you can also
    /// only launch it on supported instance types.</p>
    /// <note>
    /// <p>If you are creating a volume from a snapshot, you cannot create an unencrypted
    /// volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when using
    /// a launch configuration.</p>
    /// <p>If you enable encryption by default, the EBS volumes that you create are always
    /// encrypted, either using the Amazon Web Services managed KMS key or a customer-managed KMS key,
    /// regardless of whether the snapshot was encrypted. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption">Using Amazon Web Services KMS keys to encrypt Amazon EBS volumes</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// </note>
    pub encrypted: std::option::Option<bool>,
    /// <p>The throughput (MiBps) to provision for a <code>gp3</code> volume.</p>
    pub throughput: std::option::Option<i32>,
}
impl Ebs {
    /// <p>The snapshot ID of the volume to use.</p>
    /// <p>You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.</p>
    pub fn snapshot_id(&self) -> std::option::Option<&str> {
        self.snapshot_id.as_deref()
    }
    /// <p>The volume size, in GiBs. The following are the supported volumes sizes for each
    /// volume type: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>gp2</code> and <code>gp3</code>: 1-16,384</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code>: 4-16,384</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>st1</code> and <code>sc1</code>: 125-16,384</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>standard</code>: 1-1,024</p>
    /// </li>
    /// </ul>
    /// <p>You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you
    /// specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must
    /// be equal or greater than the size of the snapshot.</p>
    pub fn volume_size(&self) -> std::option::Option<i32> {
        self.volume_size
    }
    /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the
    /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
    /// <p>Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> |
    /// <code>st1</code> | <code>sc1</code> | <code>gp3</code>
    /// </p>
    pub fn volume_type(&self) -> std::option::Option<&str> {
        self.volume_type.as_deref()
    }
    /// <p>Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the
    /// default value is <code>true</code>.</p>
    pub fn delete_on_termination(&self) -> std::option::Option<bool> {
        self.delete_on_termination
    }
    /// <p>The number of input/output (I/O) operations per second (IOPS) to provision for the
    /// volume. For <code>gp3</code> and <code>io1</code> volumes, this represents the number of
    /// IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents
    /// the baseline performance of the volume and the rate at which the volume accumulates I/O
    /// credits for bursting. </p>
    /// <p>The following are the supported values for each volume type: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>gp3</code>: 3,000-16,000 IOPS</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>io1</code>: 100-64,000 IOPS</p>
    /// </li>
    /// </ul>
    ///
    /// <p>For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances
    /// built on the Nitro System</a>. Other instance families guarantee performance up
    /// to 32,000 IOPS. </p>
    /// <p>
    /// <code>Iops</code> is supported when the volume type is <code>gp3</code> or
    /// <code>io1</code> and required only when the volume type is <code>io1</code>. (Not
    /// used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code>
    /// volumes.) </p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be
    /// attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>. If your AMI uses encrypted volumes, you can also
    /// only launch it on supported instance types.</p>
    /// <note>
    /// <p>If you are creating a volume from a snapshot, you cannot create an unencrypted
    /// volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when using
    /// a launch configuration.</p>
    /// <p>If you enable encryption by default, the EBS volumes that you create are always
    /// encrypted, either using the Amazon Web Services managed KMS key or a customer-managed KMS key,
    /// regardless of whether the snapshot was encrypted. </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption">Using Amazon Web Services KMS keys to encrypt Amazon EBS volumes</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// </note>
    pub fn encrypted(&self) -> std::option::Option<bool> {
        self.encrypted
    }
    /// <p>The throughput (MiBps) to provision for a <code>gp3</code> volume.</p>
    pub fn throughput(&self) -> std::option::Option<i32> {
        self.throughput
    }
}
impl std::fmt::Debug for Ebs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ebs");
        formatter.field("snapshot_id", &self.snapshot_id);
        formatter.field("volume_size", &self.volume_size);
        formatter.field("volume_type", &self.volume_type);
        formatter.field("delete_on_termination", &self.delete_on_termination);
        formatter.field("iops", &self.iops);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("throughput", &self.throughput);
        formatter.finish()
    }
}
/// See [`Ebs`](crate::model::Ebs)
pub mod ebs {
    /// A builder for [`Ebs`](crate::model::Ebs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_id: std::option::Option<std::string::String>,
        pub(crate) volume_size: std::option::Option<i32>,
        pub(crate) volume_type: std::option::Option<std::string::String>,
        pub(crate) delete_on_termination: std::option::Option<bool>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) throughput: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The snapshot ID of the volume to use.</p>
        /// <p>You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.</p>
        pub fn snapshot_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_id = Some(input.into());
            self
        }
        /// <p>The snapshot ID of the volume to use.</p>
        /// <p>You must specify either a <code>VolumeSize</code> or a <code>SnapshotId</code>.</p>
        pub fn set_snapshot_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.snapshot_id = input;
            self
        }
        /// <p>The volume size, in GiBs. The following are the supported volumes sizes for each
        /// volume type: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>gp2</code> and <code>gp3</code>: 1-16,384</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code>: 4-16,384</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>st1</code> and <code>sc1</code>: 125-16,384</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>standard</code>: 1-1,024</p>
        /// </li>
        /// </ul>
        /// <p>You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you
        /// specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must
        /// be equal or greater than the size of the snapshot.</p>
        pub fn volume_size(mut self, input: i32) -> Self {
            self.volume_size = Some(input);
            self
        }
        /// <p>The volume size, in GiBs. The following are the supported volumes sizes for each
        /// volume type: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>gp2</code> and <code>gp3</code>: 1-16,384</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code>: 4-16,384</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>st1</code> and <code>sc1</code>: 125-16,384</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>standard</code>: 1-1,024</p>
        /// </li>
        /// </ul>
        /// <p>You must specify either a <code>SnapshotId</code> or a <code>VolumeSize</code>. If you
        /// specify both <code>SnapshotId</code> and <code>VolumeSize</code>, the volume size must
        /// be equal or greater than the size of the snapshot.</p>
        pub fn set_volume_size(mut self, input: std::option::Option<i32>) -> Self {
            self.volume_size = input;
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> |
        /// <code>st1</code> | <code>sc1</code> | <code>gp3</code>
        /// </p>
        pub fn volume_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.volume_type = Some(input.into());
            self
        }
        /// <p>The volume type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the
        /// <i>Amazon EC2 User Guide for Linux Instances</i>.</p>
        /// <p>Valid Values: <code>standard</code> | <code>io1</code> | <code>gp2</code> |
        /// <code>st1</code> | <code>sc1</code> | <code>gp3</code>
        /// </p>
        pub fn set_volume_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.volume_type = input;
            self
        }
        /// <p>Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the
        /// default value is <code>true</code>.</p>
        pub fn delete_on_termination(mut self, input: bool) -> Self {
            self.delete_on_termination = Some(input);
            self
        }
        /// <p>Indicates whether the volume is deleted on instance termination. For Amazon EC2 Auto Scaling, the
        /// default value is <code>true</code>.</p>
        pub fn set_delete_on_termination(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_on_termination = input;
            self
        }
        /// <p>The number of input/output (I/O) operations per second (IOPS) to provision for the
        /// volume. For <code>gp3</code> and <code>io1</code> volumes, this represents the number of
        /// IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents
        /// the baseline performance of the volume and the rate at which the volume accumulates I/O
        /// credits for bursting. </p>
        /// <p>The following are the supported values for each volume type: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>gp3</code>: 3,000-16,000 IOPS</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code>: 100-64,000 IOPS</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances
        /// built on the Nitro System</a>. Other instance families guarantee performance up
        /// to 32,000 IOPS. </p>
        /// <p>
        /// <code>Iops</code> is supported when the volume type is <code>gp3</code> or
        /// <code>io1</code> and required only when the volume type is <code>io1</code>. (Not
        /// used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code>
        /// volumes.) </p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The number of input/output (I/O) operations per second (IOPS) to provision for the
        /// volume. For <code>gp3</code> and <code>io1</code> volumes, this represents the number of
        /// IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents
        /// the baseline performance of the volume and the rate at which the volume accumulates I/O
        /// credits for bursting. </p>
        /// <p>The following are the supported values for each volume type: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>gp3</code>: 3,000-16,000 IOPS</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>io1</code>: 100-64,000 IOPS</p>
        /// </li>
        /// </ul>
        ///
        /// <p>For <code>io1</code> volumes, we guarantee 64,000 IOPS only for <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances
        /// built on the Nitro System</a>. Other instance families guarantee performance up
        /// to 32,000 IOPS. </p>
        /// <p>
        /// <code>Iops</code> is supported when the volume type is <code>gp3</code> or
        /// <code>io1</code> and required only when the volume type is <code>io1</code>. (Not
        /// used with <code>standard</code>, <code>gp2</code>, <code>st1</code>, or <code>sc1</code>
        /// volumes.) </p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be
        /// attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>. If your AMI uses encrypted volumes, you can also
        /// only launch it on supported instance types.</p>
        /// <note>
        /// <p>If you are creating a volume from a snapshot, you cannot create an unencrypted
        /// volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when using
        /// a launch configuration.</p>
        /// <p>If you enable encryption by default, the EBS volumes that you create are always
        /// encrypted, either using the Amazon Web Services managed KMS key or a customer-managed KMS key,
        /// regardless of whether the snapshot was encrypted. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption">Using Amazon Web Services KMS keys to encrypt Amazon EBS volumes</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// </note>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the volume should be encrypted. Encrypted EBS volumes can only be
        /// attached to instances that support Amazon EBS encryption. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported instance types</a>. If your AMI uses encrypted volumes, you can also
        /// only launch it on supported instance types.</p>
        /// <note>
        /// <p>If you are creating a volume from a snapshot, you cannot create an unencrypted
        /// volume from an encrypted snapshot. Also, you cannot specify a KMS key ID when using
        /// a launch configuration.</p>
        /// <p>If you enable encryption by default, the EBS volumes that you create are always
        /// encrypted, either using the Amazon Web Services managed KMS key or a customer-managed KMS key,
        /// regardless of whether the snapshot was encrypted. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption">Using Amazon Web Services KMS keys to encrypt Amazon EBS volumes</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// </note>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The throughput (MiBps) to provision for a <code>gp3</code> volume.</p>
        pub fn throughput(mut self, input: i32) -> Self {
            self.throughput = Some(input);
            self
        }
        /// <p>The throughput (MiBps) to provision for a <code>gp3</code> volume.</p>
        pub fn set_throughput(mut self, input: std::option::Option<i32>) -> Self {
            self.throughput = input;
            self
        }
        /// Consumes the builder and constructs a [`Ebs`](crate::model::Ebs)
        pub fn build(self) -> crate::model::Ebs {
            crate::model::Ebs {
                snapshot_id: self.snapshot_id,
                volume_size: self.volume_size,
                volume_type: self.volume_type,
                delete_on_termination: self.delete_on_termination,
                iops: self.iops,
                encrypted: self.encrypted,
                throughput: self.throughput,
            }
        }
    }
}
impl Ebs {
    /// Creates a new builder-style object to manufacture [`Ebs`](crate::model::Ebs)
    pub fn builder() -> crate::model::ebs::Builder {
        crate::model::ebs::Builder::default()
    }
}

/// <p>Describes an instance refresh for an Auto Scaling group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRefresh {
    /// <p>The instance refresh ID.</p>
    pub instance_refresh_id: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The current status for the instance refresh operation:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Pending</code> - The request was created, but the operation has not
    /// started.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InProgress</code> - The operation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Successful</code> - The operation completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - The operation failed to complete. You can troubleshoot
    /// using the status reason and the scaling activities. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Cancelling</code> - An ongoing operation is being cancelled.
    /// Cancellation does not roll back any replacements that have already been
    /// completed, but it prevents new replacements from being started. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Cancelled</code> - The operation is cancelled. </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::InstanceRefreshStatus>,
    /// <p>Provides more details about the current status of the instance refresh. </p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>The date and time at which the instance refresh began.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time at which the instance refresh ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The percentage of the instance refresh that is complete. For each instance
    /// replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the
    /// instance's health status changes to healthy and the specified warm-up time passes, the
    /// instance is considered updated and is added to the percentage complete.</p>
    pub percentage_complete: std::option::Option<i32>,
    /// <p>The number of instances remaining to update before the instance refresh is
    /// complete.</p>
    pub instances_to_update: std::option::Option<i32>,
    /// <p>Additional progress details for an Auto Scaling group that has a warm pool.</p>
    pub progress_details: std::option::Option<crate::model::InstanceRefreshProgressDetails>,
    /// <p>Describes the preferences for an instance refresh.</p>
    pub preferences: std::option::Option<crate::model::RefreshPreferences>,
    /// <p>Describes the specific update you want to deploy.</p>
    pub desired_configuration: std::option::Option<crate::model::DesiredConfiguration>,
}
impl InstanceRefresh {
    /// <p>The instance refresh ID.</p>
    pub fn instance_refresh_id(&self) -> std::option::Option<&str> {
        self.instance_refresh_id.as_deref()
    }
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The current status for the instance refresh operation:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Pending</code> - The request was created, but the operation has not
    /// started.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InProgress</code> - The operation is in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Successful</code> - The operation completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - The operation failed to complete. You can troubleshoot
    /// using the status reason and the scaling activities. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Cancelling</code> - An ongoing operation is being cancelled.
    /// Cancellation does not roll back any replacements that have already been
    /// completed, but it prevents new replacements from being started. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Cancelled</code> - The operation is cancelled. </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::InstanceRefreshStatus> {
        self.status.as_ref()
    }
    /// <p>Provides more details about the current status of the instance refresh. </p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>The date and time at which the instance refresh began.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The date and time at which the instance refresh ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The percentage of the instance refresh that is complete. For each instance
    /// replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the
    /// instance's health status changes to healthy and the specified warm-up time passes, the
    /// instance is considered updated and is added to the percentage complete.</p>
    pub fn percentage_complete(&self) -> std::option::Option<i32> {
        self.percentage_complete
    }
    /// <p>The number of instances remaining to update before the instance refresh is
    /// complete.</p>
    pub fn instances_to_update(&self) -> std::option::Option<i32> {
        self.instances_to_update
    }
    /// <p>Additional progress details for an Auto Scaling group that has a warm pool.</p>
    pub fn progress_details(
        &self,
    ) -> std::option::Option<&crate::model::InstanceRefreshProgressDetails> {
        self.progress_details.as_ref()
    }
    /// <p>Describes the preferences for an instance refresh.</p>
    pub fn preferences(&self) -> std::option::Option<&crate::model::RefreshPreferences> {
        self.preferences.as_ref()
    }
    /// <p>Describes the specific update you want to deploy.</p>
    pub fn desired_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DesiredConfiguration> {
        self.desired_configuration.as_ref()
    }
}
impl std::fmt::Debug for InstanceRefresh {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRefresh");
        formatter.field("instance_refresh_id", &self.instance_refresh_id);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("percentage_complete", &self.percentage_complete);
        formatter.field("instances_to_update", &self.instances_to_update);
        formatter.field("progress_details", &self.progress_details);
        formatter.field("preferences", &self.preferences);
        formatter.field("desired_configuration", &self.desired_configuration);
        formatter.finish()
    }
}
/// See [`InstanceRefresh`](crate::model::InstanceRefresh)
pub mod instance_refresh {
    /// A builder for [`InstanceRefresh`](crate::model::InstanceRefresh)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_refresh_id: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::InstanceRefreshStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) percentage_complete: std::option::Option<i32>,
        pub(crate) instances_to_update: std::option::Option<i32>,
        pub(crate) progress_details:
            std::option::Option<crate::model::InstanceRefreshProgressDetails>,
        pub(crate) preferences: std::option::Option<crate::model::RefreshPreferences>,
        pub(crate) desired_configuration: std::option::Option<crate::model::DesiredConfiguration>,
    }
    impl Builder {
        /// <p>The instance refresh ID.</p>
        pub fn instance_refresh_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_refresh_id = Some(input.into());
            self
        }
        /// <p>The instance refresh ID.</p>
        pub fn set_instance_refresh_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_refresh_id = input;
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The current status for the instance refresh operation:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code> - The request was created, but the operation has not
        /// started.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code> - The operation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Successful</code> - The operation completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The operation failed to complete. You can troubleshoot
        /// using the status reason and the scaling activities. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelling</code> - An ongoing operation is being cancelled.
        /// Cancellation does not roll back any replacements that have already been
        /// completed, but it prevents new replacements from being started. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelled</code> - The operation is cancelled. </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::InstanceRefreshStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status for the instance refresh operation:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Pending</code> - The request was created, but the operation has not
        /// started.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InProgress</code> - The operation is in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Successful</code> - The operation completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The operation failed to complete. You can troubleshoot
        /// using the status reason and the scaling activities. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelling</code> - An ongoing operation is being cancelled.
        /// Cancellation does not roll back any replacements that have already been
        /// completed, but it prevents new replacements from being started. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Cancelled</code> - The operation is cancelled. </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InstanceRefreshStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides more details about the current status of the instance refresh. </p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>Provides more details about the current status of the instance refresh. </p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>The date and time at which the instance refresh began.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time at which the instance refresh began.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time at which the instance refresh ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time at which the instance refresh ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The percentage of the instance refresh that is complete. For each instance
        /// replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the
        /// instance's health status changes to healthy and the specified warm-up time passes, the
        /// instance is considered updated and is added to the percentage complete.</p>
        pub fn percentage_complete(mut self, input: i32) -> Self {
            self.percentage_complete = Some(input);
            self
        }
        /// <p>The percentage of the instance refresh that is complete. For each instance
        /// replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time. When the
        /// instance's health status changes to healthy and the specified warm-up time passes, the
        /// instance is considered updated and is added to the percentage complete.</p>
        pub fn set_percentage_complete(mut self, input: std::option::Option<i32>) -> Self {
            self.percentage_complete = input;
            self
        }
        /// <p>The number of instances remaining to update before the instance refresh is
        /// complete.</p>
        pub fn instances_to_update(mut self, input: i32) -> Self {
            self.instances_to_update = Some(input);
            self
        }
        /// <p>The number of instances remaining to update before the instance refresh is
        /// complete.</p>
        pub fn set_instances_to_update(mut self, input: std::option::Option<i32>) -> Self {
            self.instances_to_update = input;
            self
        }
        /// <p>Additional progress details for an Auto Scaling group that has a warm pool.</p>
        pub fn progress_details(
            mut self,
            input: crate::model::InstanceRefreshProgressDetails,
        ) -> Self {
            self.progress_details = Some(input);
            self
        }
        /// <p>Additional progress details for an Auto Scaling group that has a warm pool.</p>
        pub fn set_progress_details(
            mut self,
            input: std::option::Option<crate::model::InstanceRefreshProgressDetails>,
        ) -> Self {
            self.progress_details = input;
            self
        }
        /// <p>Describes the preferences for an instance refresh.</p>
        pub fn preferences(mut self, input: crate::model::RefreshPreferences) -> Self {
            self.preferences = Some(input);
            self
        }
        /// <p>Describes the preferences for an instance refresh.</p>
        pub fn set_preferences(
            mut self,
            input: std::option::Option<crate::model::RefreshPreferences>,
        ) -> Self {
            self.preferences = input;
            self
        }
        /// <p>Describes the specific update you want to deploy.</p>
        pub fn desired_configuration(mut self, input: crate::model::DesiredConfiguration) -> Self {
            self.desired_configuration = Some(input);
            self
        }
        /// <p>Describes the specific update you want to deploy.</p>
        pub fn set_desired_configuration(
            mut self,
            input: std::option::Option<crate::model::DesiredConfiguration>,
        ) -> Self {
            self.desired_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRefresh`](crate::model::InstanceRefresh)
        pub fn build(self) -> crate::model::InstanceRefresh {
            crate::model::InstanceRefresh {
                instance_refresh_id: self.instance_refresh_id,
                auto_scaling_group_name: self.auto_scaling_group_name,
                status: self.status,
                status_reason: self.status_reason,
                start_time: self.start_time,
                end_time: self.end_time,
                percentage_complete: self.percentage_complete,
                instances_to_update: self.instances_to_update,
                progress_details: self.progress_details,
                preferences: self.preferences,
                desired_configuration: self.desired_configuration,
            }
        }
    }
}
impl InstanceRefresh {
    /// Creates a new builder-style object to manufacture [`InstanceRefresh`](crate::model::InstanceRefresh)
    pub fn builder() -> crate::model::instance_refresh::Builder {
        crate::model::instance_refresh::Builder::default()
    }
}

/// <p>Reports the progress of an instance refresh on an Auto Scaling group that has a warm pool.
/// This includes separate details for instances in the warm pool and instances in the Auto Scaling
/// group (the live pool).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRefreshProgressDetails {
    /// <p>Indicates the progress of an instance refresh on instances that are in the Auto Scaling
    /// group.</p>
    pub live_pool_progress: std::option::Option<crate::model::InstanceRefreshLivePoolProgress>,
    /// <p>Indicates the progress of an instance refresh on instances that are in the warm
    /// pool.</p>
    pub warm_pool_progress: std::option::Option<crate::model::InstanceRefreshWarmPoolProgress>,
}
impl InstanceRefreshProgressDetails {
    /// <p>Indicates the progress of an instance refresh on instances that are in the Auto Scaling
    /// group.</p>
    pub fn live_pool_progress(
        &self,
    ) -> std::option::Option<&crate::model::InstanceRefreshLivePoolProgress> {
        self.live_pool_progress.as_ref()
    }
    /// <p>Indicates the progress of an instance refresh on instances that are in the warm
    /// pool.</p>
    pub fn warm_pool_progress(
        &self,
    ) -> std::option::Option<&crate::model::InstanceRefreshWarmPoolProgress> {
        self.warm_pool_progress.as_ref()
    }
}
impl std::fmt::Debug for InstanceRefreshProgressDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRefreshProgressDetails");
        formatter.field("live_pool_progress", &self.live_pool_progress);
        formatter.field("warm_pool_progress", &self.warm_pool_progress);
        formatter.finish()
    }
}
/// See [`InstanceRefreshProgressDetails`](crate::model::InstanceRefreshProgressDetails)
pub mod instance_refresh_progress_details {
    /// A builder for [`InstanceRefreshProgressDetails`](crate::model::InstanceRefreshProgressDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) live_pool_progress:
            std::option::Option<crate::model::InstanceRefreshLivePoolProgress>,
        pub(crate) warm_pool_progress:
            std::option::Option<crate::model::InstanceRefreshWarmPoolProgress>,
    }
    impl Builder {
        /// <p>Indicates the progress of an instance refresh on instances that are in the Auto Scaling
        /// group.</p>
        pub fn live_pool_progress(
            mut self,
            input: crate::model::InstanceRefreshLivePoolProgress,
        ) -> Self {
            self.live_pool_progress = Some(input);
            self
        }
        /// <p>Indicates the progress of an instance refresh on instances that are in the Auto Scaling
        /// group.</p>
        pub fn set_live_pool_progress(
            mut self,
            input: std::option::Option<crate::model::InstanceRefreshLivePoolProgress>,
        ) -> Self {
            self.live_pool_progress = input;
            self
        }
        /// <p>Indicates the progress of an instance refresh on instances that are in the warm
        /// pool.</p>
        pub fn warm_pool_progress(
            mut self,
            input: crate::model::InstanceRefreshWarmPoolProgress,
        ) -> Self {
            self.warm_pool_progress = Some(input);
            self
        }
        /// <p>Indicates the progress of an instance refresh on instances that are in the warm
        /// pool.</p>
        pub fn set_warm_pool_progress(
            mut self,
            input: std::option::Option<crate::model::InstanceRefreshWarmPoolProgress>,
        ) -> Self {
            self.warm_pool_progress = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRefreshProgressDetails`](crate::model::InstanceRefreshProgressDetails)
        pub fn build(self) -> crate::model::InstanceRefreshProgressDetails {
            crate::model::InstanceRefreshProgressDetails {
                live_pool_progress: self.live_pool_progress,
                warm_pool_progress: self.warm_pool_progress,
            }
        }
    }
}
impl InstanceRefreshProgressDetails {
    /// Creates a new builder-style object to manufacture [`InstanceRefreshProgressDetails`](crate::model::InstanceRefreshProgressDetails)
    pub fn builder() -> crate::model::instance_refresh_progress_details::Builder {
        crate::model::instance_refresh_progress_details::Builder::default()
    }
}

/// <p>Reports the progress of an instance refresh on instances that are in the warm
/// pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRefreshWarmPoolProgress {
    /// <p>The percentage of instances in the warm pool that have been replaced. For each
    /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
    /// When the instance's health status changes to healthy and the specified warm-up time
    /// passes, the instance is considered updated and is added to the percentage
    /// complete.</p>
    pub percentage_complete: std::option::Option<i32>,
    /// <p>The number of instances remaining to update.</p>
    pub instances_to_update: std::option::Option<i32>,
}
impl InstanceRefreshWarmPoolProgress {
    /// <p>The percentage of instances in the warm pool that have been replaced. For each
    /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
    /// When the instance's health status changes to healthy and the specified warm-up time
    /// passes, the instance is considered updated and is added to the percentage
    /// complete.</p>
    pub fn percentage_complete(&self) -> std::option::Option<i32> {
        self.percentage_complete
    }
    /// <p>The number of instances remaining to update.</p>
    pub fn instances_to_update(&self) -> std::option::Option<i32> {
        self.instances_to_update
    }
}
impl std::fmt::Debug for InstanceRefreshWarmPoolProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRefreshWarmPoolProgress");
        formatter.field("percentage_complete", &self.percentage_complete);
        formatter.field("instances_to_update", &self.instances_to_update);
        formatter.finish()
    }
}
/// See [`InstanceRefreshWarmPoolProgress`](crate::model::InstanceRefreshWarmPoolProgress)
pub mod instance_refresh_warm_pool_progress {
    /// A builder for [`InstanceRefreshWarmPoolProgress`](crate::model::InstanceRefreshWarmPoolProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percentage_complete: std::option::Option<i32>,
        pub(crate) instances_to_update: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The percentage of instances in the warm pool that have been replaced. For each
        /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
        /// When the instance's health status changes to healthy and the specified warm-up time
        /// passes, the instance is considered updated and is added to the percentage
        /// complete.</p>
        pub fn percentage_complete(mut self, input: i32) -> Self {
            self.percentage_complete = Some(input);
            self
        }
        /// <p>The percentage of instances in the warm pool that have been replaced. For each
        /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
        /// When the instance's health status changes to healthy and the specified warm-up time
        /// passes, the instance is considered updated and is added to the percentage
        /// complete.</p>
        pub fn set_percentage_complete(mut self, input: std::option::Option<i32>) -> Self {
            self.percentage_complete = input;
            self
        }
        /// <p>The number of instances remaining to update.</p>
        pub fn instances_to_update(mut self, input: i32) -> Self {
            self.instances_to_update = Some(input);
            self
        }
        /// <p>The number of instances remaining to update.</p>
        pub fn set_instances_to_update(mut self, input: std::option::Option<i32>) -> Self {
            self.instances_to_update = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRefreshWarmPoolProgress`](crate::model::InstanceRefreshWarmPoolProgress)
        pub fn build(self) -> crate::model::InstanceRefreshWarmPoolProgress {
            crate::model::InstanceRefreshWarmPoolProgress {
                percentage_complete: self.percentage_complete,
                instances_to_update: self.instances_to_update,
            }
        }
    }
}
impl InstanceRefreshWarmPoolProgress {
    /// Creates a new builder-style object to manufacture [`InstanceRefreshWarmPoolProgress`](crate::model::InstanceRefreshWarmPoolProgress)
    pub fn builder() -> crate::model::instance_refresh_warm_pool_progress::Builder {
        crate::model::instance_refresh_warm_pool_progress::Builder::default()
    }
}

/// <p>Reports the progress of an instance refresh on instances that are in the Auto Scaling
/// group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceRefreshLivePoolProgress {
    /// <p>The percentage of instances in the Auto Scaling group that have been replaced. For each
    /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
    /// When the instance's health status changes to healthy and the specified warm-up time
    /// passes, the instance is considered updated and is added to the percentage
    /// complete.</p>
    pub percentage_complete: std::option::Option<i32>,
    /// <p>The number of instances remaining to update.</p>
    pub instances_to_update: std::option::Option<i32>,
}
impl InstanceRefreshLivePoolProgress {
    /// <p>The percentage of instances in the Auto Scaling group that have been replaced. For each
    /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
    /// When the instance's health status changes to healthy and the specified warm-up time
    /// passes, the instance is considered updated and is added to the percentage
    /// complete.</p>
    pub fn percentage_complete(&self) -> std::option::Option<i32> {
        self.percentage_complete
    }
    /// <p>The number of instances remaining to update.</p>
    pub fn instances_to_update(&self) -> std::option::Option<i32> {
        self.instances_to_update
    }
}
impl std::fmt::Debug for InstanceRefreshLivePoolProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceRefreshLivePoolProgress");
        formatter.field("percentage_complete", &self.percentage_complete);
        formatter.field("instances_to_update", &self.instances_to_update);
        formatter.finish()
    }
}
/// See [`InstanceRefreshLivePoolProgress`](crate::model::InstanceRefreshLivePoolProgress)
pub mod instance_refresh_live_pool_progress {
    /// A builder for [`InstanceRefreshLivePoolProgress`](crate::model::InstanceRefreshLivePoolProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) percentage_complete: std::option::Option<i32>,
        pub(crate) instances_to_update: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The percentage of instances in the Auto Scaling group that have been replaced. For each
        /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
        /// When the instance's health status changes to healthy and the specified warm-up time
        /// passes, the instance is considered updated and is added to the percentage
        /// complete.</p>
        pub fn percentage_complete(mut self, input: i32) -> Self {
            self.percentage_complete = Some(input);
            self
        }
        /// <p>The percentage of instances in the Auto Scaling group that have been replaced. For each
        /// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health status and warm-up time.
        /// When the instance's health status changes to healthy and the specified warm-up time
        /// passes, the instance is considered updated and is added to the percentage
        /// complete.</p>
        pub fn set_percentage_complete(mut self, input: std::option::Option<i32>) -> Self {
            self.percentage_complete = input;
            self
        }
        /// <p>The number of instances remaining to update.</p>
        pub fn instances_to_update(mut self, input: i32) -> Self {
            self.instances_to_update = Some(input);
            self
        }
        /// <p>The number of instances remaining to update.</p>
        pub fn set_instances_to_update(mut self, input: std::option::Option<i32>) -> Self {
            self.instances_to_update = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceRefreshLivePoolProgress`](crate::model::InstanceRefreshLivePoolProgress)
        pub fn build(self) -> crate::model::InstanceRefreshLivePoolProgress {
            crate::model::InstanceRefreshLivePoolProgress {
                percentage_complete: self.percentage_complete,
                instances_to_update: self.instances_to_update,
            }
        }
    }
}
impl InstanceRefreshLivePoolProgress {
    /// Creates a new builder-style object to manufacture [`InstanceRefreshLivePoolProgress`](crate::model::InstanceRefreshLivePoolProgress)
    pub fn builder() -> crate::model::instance_refresh_live_pool_progress::Builder {
        crate::model::instance_refresh_live_pool_progress::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceRefreshStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceRefreshStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => InstanceRefreshStatus::Cancelled,
            "Cancelling" => InstanceRefreshStatus::Cancelling,
            "Failed" => InstanceRefreshStatus::Failed,
            "InProgress" => InstanceRefreshStatus::InProgress,
            "Pending" => InstanceRefreshStatus::Pending,
            "Successful" => InstanceRefreshStatus::Successful,
            other => InstanceRefreshStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceRefreshStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceRefreshStatus::from(s))
    }
}
impl InstanceRefreshStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceRefreshStatus::Cancelled => "Cancelled",
            InstanceRefreshStatus::Cancelling => "Cancelling",
            InstanceRefreshStatus::Failed => "Failed",
            InstanceRefreshStatus::InProgress => "InProgress",
            InstanceRefreshStatus::Pending => "Pending",
            InstanceRefreshStatus::Successful => "Successful",
            InstanceRefreshStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Cancelling",
            "Failed",
            "InProgress",
            "Pending",
            "Successful",
        ]
    }
}
impl AsRef<str> for InstanceRefreshStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an EC2 instance associated with an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingInstanceDetails {
    /// <p>The ID of the instance.</p>
    pub instance_id: std::option::Option<std::string::String>,
    /// <p>The instance type of the EC2 instance.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The name of the Auto Scaling group for the instance.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The Availability Zone for the instance.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The lifecycle state for the instance. The <code>Quarantined</code> state is not used.
    /// For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
    /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
    /// <p>Valid Values: <code>Pending</code> | <code>Pending:Wait</code> |
    /// <code>Pending:Proceed</code> | <code>Quarantined</code> | <code>InService</code> |
    /// <code>Terminating</code> | <code>Terminating:Wait</code> |
    /// <code>Terminating:Proceed</code> | <code>Terminated</code> | <code>Detaching</code>
    /// | <code>Detached</code> | <code>EnteringStandby</code> | <code>Standby</code> |
    /// <code>Warmed:Pending</code> | <code>Warmed:Pending:Wait</code> |
    /// <code>Warmed:Pending:Proceed</code> | <code>Warmed:Terminating</code> |
    /// <code>Warmed:Terminating:Wait</code> | <code>Warmed:Terminating:Proceed</code> |
    /// <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code> |
    /// <code>Warmed:Running</code>
    /// </p>
    pub lifecycle_state: std::option::Option<std::string::String>,
    /// <p>The last reported health status of this instance. "Healthy" means that the instance is
    /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
    /// and Amazon EC2 Auto Scaling should terminate and replace it.</p>
    pub health_status: std::option::Option<std::string::String>,
    /// <p>The launch configuration used to launch the instance. This value is not available if
    /// you attached the instance to the Auto Scaling group.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>The launch template for the instance.</p>
    pub launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
    /// in.</p>
    pub protected_from_scale_in: std::option::Option<bool>,
    /// <p>The number of capacity units contributed by the instance based on its instance
    /// type.</p>
    /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
    pub weighted_capacity: std::option::Option<std::string::String>,
}
impl AutoScalingInstanceDetails {
    /// <p>The ID of the instance.</p>
    pub fn instance_id(&self) -> std::option::Option<&str> {
        self.instance_id.as_deref()
    }
    /// <p>The instance type of the EC2 instance.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The name of the Auto Scaling group for the instance.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The Availability Zone for the instance.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The lifecycle state for the instance. The <code>Quarantined</code> state is not used.
    /// For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
    /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
    /// <p>Valid Values: <code>Pending</code> | <code>Pending:Wait</code> |
    /// <code>Pending:Proceed</code> | <code>Quarantined</code> | <code>InService</code> |
    /// <code>Terminating</code> | <code>Terminating:Wait</code> |
    /// <code>Terminating:Proceed</code> | <code>Terminated</code> | <code>Detaching</code>
    /// | <code>Detached</code> | <code>EnteringStandby</code> | <code>Standby</code> |
    /// <code>Warmed:Pending</code> | <code>Warmed:Pending:Wait</code> |
    /// <code>Warmed:Pending:Proceed</code> | <code>Warmed:Terminating</code> |
    /// <code>Warmed:Terminating:Wait</code> | <code>Warmed:Terminating:Proceed</code> |
    /// <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code> |
    /// <code>Warmed:Running</code>
    /// </p>
    pub fn lifecycle_state(&self) -> std::option::Option<&str> {
        self.lifecycle_state.as_deref()
    }
    /// <p>The last reported health status of this instance. "Healthy" means that the instance is
    /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
    /// and Amazon EC2 Auto Scaling should terminate and replace it.</p>
    pub fn health_status(&self) -> std::option::Option<&str> {
        self.health_status.as_deref()
    }
    /// <p>The launch configuration used to launch the instance. This value is not available if
    /// you attached the instance to the Auto Scaling group.</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
    /// <p>The launch template for the instance.</p>
    pub fn launch_template(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template.as_ref()
    }
    /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
    /// in.</p>
    pub fn protected_from_scale_in(&self) -> std::option::Option<bool> {
        self.protected_from_scale_in
    }
    /// <p>The number of capacity units contributed by the instance based on its instance
    /// type.</p>
    /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
    pub fn weighted_capacity(&self) -> std::option::Option<&str> {
        self.weighted_capacity.as_deref()
    }
}
impl std::fmt::Debug for AutoScalingInstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingInstanceDetails");
        formatter.field("instance_id", &self.instance_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("lifecycle_state", &self.lifecycle_state);
        formatter.field("health_status", &self.health_status);
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("launch_template", &self.launch_template);
        formatter.field("protected_from_scale_in", &self.protected_from_scale_in);
        formatter.field("weighted_capacity", &self.weighted_capacity);
        formatter.finish()
    }
}
/// See [`AutoScalingInstanceDetails`](crate::model::AutoScalingInstanceDetails)
pub mod auto_scaling_instance_details {
    /// A builder for [`AutoScalingInstanceDetails`](crate::model::AutoScalingInstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) lifecycle_state: std::option::Option<std::string::String>,
        pub(crate) health_status: std::option::Option<std::string::String>,
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) protected_from_scale_in: std::option::Option<bool>,
        pub(crate) weighted_capacity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The ID of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The instance type of the EC2 instance.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type of the EC2 instance.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The name of the Auto Scaling group for the instance.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group for the instance.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The Availability Zone for the instance.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone for the instance.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The lifecycle state for the instance. The <code>Quarantined</code> state is not used.
        /// For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
        /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
        /// <p>Valid Values: <code>Pending</code> | <code>Pending:Wait</code> |
        /// <code>Pending:Proceed</code> | <code>Quarantined</code> | <code>InService</code> |
        /// <code>Terminating</code> | <code>Terminating:Wait</code> |
        /// <code>Terminating:Proceed</code> | <code>Terminated</code> | <code>Detaching</code>
        /// | <code>Detached</code> | <code>EnteringStandby</code> | <code>Standby</code> |
        /// <code>Warmed:Pending</code> | <code>Warmed:Pending:Wait</code> |
        /// <code>Warmed:Pending:Proceed</code> | <code>Warmed:Terminating</code> |
        /// <code>Warmed:Terminating:Wait</code> | <code>Warmed:Terminating:Proceed</code> |
        /// <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code> |
        /// <code>Warmed:Running</code>
        /// </p>
        pub fn lifecycle_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_state = Some(input.into());
            self
        }
        /// <p>The lifecycle state for the instance. The <code>Quarantined</code> state is not used.
        /// For information about lifecycle states, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html">Instance
        /// lifecycle</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>. </p>
        /// <p>Valid Values: <code>Pending</code> | <code>Pending:Wait</code> |
        /// <code>Pending:Proceed</code> | <code>Quarantined</code> | <code>InService</code> |
        /// <code>Terminating</code> | <code>Terminating:Wait</code> |
        /// <code>Terminating:Proceed</code> | <code>Terminated</code> | <code>Detaching</code>
        /// | <code>Detached</code> | <code>EnteringStandby</code> | <code>Standby</code> |
        /// <code>Warmed:Pending</code> | <code>Warmed:Pending:Wait</code> |
        /// <code>Warmed:Pending:Proceed</code> | <code>Warmed:Terminating</code> |
        /// <code>Warmed:Terminating:Wait</code> | <code>Warmed:Terminating:Proceed</code> |
        /// <code>Warmed:Terminated</code> | <code>Warmed:Stopped</code> |
        /// <code>Warmed:Running</code>
        /// </p>
        pub fn set_lifecycle_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_state = input;
            self
        }
        /// <p>The last reported health status of this instance. "Healthy" means that the instance is
        /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
        /// and Amazon EC2 Auto Scaling should terminate and replace it.</p>
        pub fn health_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_status = Some(input.into());
            self
        }
        /// <p>The last reported health status of this instance. "Healthy" means that the instance is
        /// healthy and should remain in service. "Unhealthy" means that the instance is unhealthy
        /// and Amazon EC2 Auto Scaling should terminate and replace it.</p>
        pub fn set_health_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_status = input;
            self
        }
        /// <p>The launch configuration used to launch the instance. This value is not available if
        /// you attached the instance to the Auto Scaling group.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The launch configuration used to launch the instance. This value is not available if
        /// you attached the instance to the Auto Scaling group.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>The launch template for the instance.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>The launch template for the instance.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
        /// in.</p>
        pub fn protected_from_scale_in(mut self, input: bool) -> Self {
            self.protected_from_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether the instance is protected from termination by Amazon EC2 Auto Scaling when scaling
        /// in.</p>
        pub fn set_protected_from_scale_in(mut self, input: std::option::Option<bool>) -> Self {
            self.protected_from_scale_in = input;
            self
        }
        /// <p>The number of capacity units contributed by the instance based on its instance
        /// type.</p>
        /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
        pub fn weighted_capacity(mut self, input: impl Into<std::string::String>) -> Self {
            self.weighted_capacity = Some(input.into());
            self
        }
        /// <p>The number of capacity units contributed by the instance based on its instance
        /// type.</p>
        /// <p>Valid Range: Minimum value of 1. Maximum value of 999.</p>
        pub fn set_weighted_capacity(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.weighted_capacity = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingInstanceDetails`](crate::model::AutoScalingInstanceDetails)
        pub fn build(self) -> crate::model::AutoScalingInstanceDetails {
            crate::model::AutoScalingInstanceDetails {
                instance_id: self.instance_id,
                instance_type: self.instance_type,
                auto_scaling_group_name: self.auto_scaling_group_name,
                availability_zone: self.availability_zone,
                lifecycle_state: self.lifecycle_state,
                health_status: self.health_status,
                launch_configuration_name: self.launch_configuration_name,
                launch_template: self.launch_template,
                protected_from_scale_in: self.protected_from_scale_in,
                weighted_capacity: self.weighted_capacity,
            }
        }
    }
}
impl AutoScalingInstanceDetails {
    /// Creates a new builder-style object to manufacture [`AutoScalingInstanceDetails`](crate::model::AutoScalingInstanceDetails)
    pub fn builder() -> crate::model::auto_scaling_instance_details::Builder {
        crate::model::auto_scaling_instance_details::Builder::default()
    }
}

/// <p>Describes an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingGroup {
    /// <p>The name of the Auto Scaling group.</p>
    pub auto_scaling_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
    pub auto_scaling_group_arn: std::option::Option<std::string::String>,
    /// <p>The name of the associated launch configuration.</p>
    pub launch_configuration_name: std::option::Option<std::string::String>,
    /// <p>The launch template for the group.</p>
    pub launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
    /// <p>The mixed instances policy for the group.</p>
    pub mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
    /// <p>The minimum size of the group.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum size of the group.</p>
    pub max_size: std::option::Option<i32>,
    /// <p>The desired size of the group.</p>
    pub desired_capacity: std::option::Option<i32>,
    /// <p>The predicted capacity of the group when it has a predictive scaling policy.</p>
    pub predicted_capacity: std::option::Option<i32>,
    /// <p>The duration of the default cooldown period, in seconds.</p>
    pub default_cooldown: std::option::Option<i32>,
    /// <p>One or more Availability Zones for the group.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more load balancers associated with the group.</p>
    pub load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Names (ARN) of the target groups for your load balancer.</p>
    pub target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and
    /// <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health
    /// checks, it considers the instance unhealthy if it fails either the EC2 status checks or
    /// the load balancer health checks.</p>
    pub health_check_type: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status
    /// of an EC2 instance that has come into service.</p>
    pub health_check_grace_period: std::option::Option<i32>,
    /// <p>The EC2 instances associated with the group.</p>
    pub instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
    /// <p>The date and time the group was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The suspended processes associated with the group.</p>
    pub suspended_processes: std::option::Option<std::vec::Vec<crate::model::SuspendedProcess>>,
    /// <p>The name of the placement group into which to launch your instances, if any.</p>
    pub placement_group: std::option::Option<std::string::String>,
    /// <p>One or more subnet IDs, if applicable, separated by commas.</p>
    pub vpc_zone_identifier: std::option::Option<std::string::String>,
    /// <p>The metrics enabled for the group.</p>
    pub enabled_metrics: std::option::Option<std::vec::Vec<crate::model::EnabledMetric>>,
    /// <p>The current state of the group when the <a>DeleteAutoScalingGroup</a>
    /// operation is in progress.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The tags for the group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagDescription>>,
    /// <p>The termination policies for the group.</p>
    pub termination_policies: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
    /// when scaling in.</p>
    pub new_instances_protected_from_scale_in: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to
    /// call other Amazon Web Services on your behalf.</p>
    pub service_linked_role_arn: std::option::Option<std::string::String>,
    /// <p>The maximum amount of time, in seconds, that an instance can be in service.</p>
    /// <p>Valid Range: Minimum value of 0.</p>
    pub max_instance_lifetime: std::option::Option<i32>,
    /// <p>Indicates whether Capacity Rebalancing is enabled.</p>
    pub capacity_rebalance: std::option::Option<bool>,
    /// <p>The warm pool for the group.</p>
    pub warm_pool_configuration: std::option::Option<crate::model::WarmPoolConfiguration>,
    /// <p>The current size of the warm pool.</p>
    pub warm_pool_size: std::option::Option<i32>,
    /// <p>Reserved.</p>
    pub context: std::option::Option<std::string::String>,
    /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling
    /// supports <code>DesiredCapacityType</code> for attribute-based instance type selection
    /// only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating
    /// an Auto Scaling group using attribute-based instance type selection</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
    /// instances.</p>
    /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
    /// </p>
    pub desired_capacity_type: std::option::Option<std::string::String>,
}
impl AutoScalingGroup {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn auto_scaling_group_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
    pub fn auto_scaling_group_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_group_arn.as_deref()
    }
    /// <p>The name of the associated launch configuration.</p>
    pub fn launch_configuration_name(&self) -> std::option::Option<&str> {
        self.launch_configuration_name.as_deref()
    }
    /// <p>The launch template for the group.</p>
    pub fn launch_template(
        &self,
    ) -> std::option::Option<&crate::model::LaunchTemplateSpecification> {
        self.launch_template.as_ref()
    }
    /// <p>The mixed instances policy for the group.</p>
    pub fn mixed_instances_policy(
        &self,
    ) -> std::option::Option<&crate::model::MixedInstancesPolicy> {
        self.mixed_instances_policy.as_ref()
    }
    /// <p>The minimum size of the group.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The maximum size of the group.</p>
    pub fn max_size(&self) -> std::option::Option<i32> {
        self.max_size
    }
    /// <p>The desired size of the group.</p>
    pub fn desired_capacity(&self) -> std::option::Option<i32> {
        self.desired_capacity
    }
    /// <p>The predicted capacity of the group when it has a predictive scaling policy.</p>
    pub fn predicted_capacity(&self) -> std::option::Option<i32> {
        self.predicted_capacity
    }
    /// <p>The duration of the default cooldown period, in seconds.</p>
    pub fn default_cooldown(&self) -> std::option::Option<i32> {
        self.default_cooldown
    }
    /// <p>One or more Availability Zones for the group.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>One or more load balancers associated with the group.</p>
    pub fn load_balancer_names(&self) -> std::option::Option<&[std::string::String]> {
        self.load_balancer_names.as_deref()
    }
    /// <p>The Amazon Resource Names (ARN) of the target groups for your load balancer.</p>
    pub fn target_group_ar_ns(&self) -> std::option::Option<&[std::string::String]> {
        self.target_group_ar_ns.as_deref()
    }
    /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and
    /// <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health
    /// checks, it considers the instance unhealthy if it fails either the EC2 status checks or
    /// the load balancer health checks.</p>
    pub fn health_check_type(&self) -> std::option::Option<&str> {
        self.health_check_type.as_deref()
    }
    /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status
    /// of an EC2 instance that has come into service.</p>
    pub fn health_check_grace_period(&self) -> std::option::Option<i32> {
        self.health_check_grace_period
    }
    /// <p>The EC2 instances associated with the group.</p>
    pub fn instances(&self) -> std::option::Option<&[crate::model::Instance]> {
        self.instances.as_deref()
    }
    /// <p>The date and time the group was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>The suspended processes associated with the group.</p>
    pub fn suspended_processes(&self) -> std::option::Option<&[crate::model::SuspendedProcess]> {
        self.suspended_processes.as_deref()
    }
    /// <p>The name of the placement group into which to launch your instances, if any.</p>
    pub fn placement_group(&self) -> std::option::Option<&str> {
        self.placement_group.as_deref()
    }
    /// <p>One or more subnet IDs, if applicable, separated by commas.</p>
    pub fn vpc_zone_identifier(&self) -> std::option::Option<&str> {
        self.vpc_zone_identifier.as_deref()
    }
    /// <p>The metrics enabled for the group.</p>
    pub fn enabled_metrics(&self) -> std::option::Option<&[crate::model::EnabledMetric]> {
        self.enabled_metrics.as_deref()
    }
    /// <p>The current state of the group when the <a>DeleteAutoScalingGroup</a>
    /// operation is in progress.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The tags for the group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagDescription]> {
        self.tags.as_deref()
    }
    /// <p>The termination policies for the group.</p>
    pub fn termination_policies(&self) -> std::option::Option<&[std::string::String]> {
        self.termination_policies.as_deref()
    }
    /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
    /// when scaling in.</p>
    pub fn new_instances_protected_from_scale_in(&self) -> std::option::Option<bool> {
        self.new_instances_protected_from_scale_in
    }
    /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to
    /// call other Amazon Web Services on your behalf.</p>
    pub fn service_linked_role_arn(&self) -> std::option::Option<&str> {
        self.service_linked_role_arn.as_deref()
    }
    /// <p>The maximum amount of time, in seconds, that an instance can be in service.</p>
    /// <p>Valid Range: Minimum value of 0.</p>
    pub fn max_instance_lifetime(&self) -> std::option::Option<i32> {
        self.max_instance_lifetime
    }
    /// <p>Indicates whether Capacity Rebalancing is enabled.</p>
    pub fn capacity_rebalance(&self) -> std::option::Option<bool> {
        self.capacity_rebalance
    }
    /// <p>The warm pool for the group.</p>
    pub fn warm_pool_configuration(
        &self,
    ) -> std::option::Option<&crate::model::WarmPoolConfiguration> {
        self.warm_pool_configuration.as_ref()
    }
    /// <p>The current size of the warm pool.</p>
    pub fn warm_pool_size(&self) -> std::option::Option<i32> {
        self.warm_pool_size
    }
    /// <p>Reserved.</p>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
    /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling
    /// supports <code>DesiredCapacityType</code> for attribute-based instance type selection
    /// only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating
    /// an Auto Scaling group using attribute-based instance type selection</a> in the
    /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
    /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
    /// instances.</p>
    /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
    /// </p>
    pub fn desired_capacity_type(&self) -> std::option::Option<&str> {
        self.desired_capacity_type.as_deref()
    }
}
impl std::fmt::Debug for AutoScalingGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingGroup");
        formatter.field("auto_scaling_group_name", &self.auto_scaling_group_name);
        formatter.field("auto_scaling_group_arn", &self.auto_scaling_group_arn);
        formatter.field("launch_configuration_name", &self.launch_configuration_name);
        formatter.field("launch_template", &self.launch_template);
        formatter.field("mixed_instances_policy", &self.mixed_instances_policy);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("predicted_capacity", &self.predicted_capacity);
        formatter.field("default_cooldown", &self.default_cooldown);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("load_balancer_names", &self.load_balancer_names);
        formatter.field("target_group_ar_ns", &self.target_group_ar_ns);
        formatter.field("health_check_type", &self.health_check_type);
        formatter.field("health_check_grace_period", &self.health_check_grace_period);
        formatter.field("instances", &self.instances);
        formatter.field("created_time", &self.created_time);
        formatter.field("suspended_processes", &self.suspended_processes);
        formatter.field("placement_group", &self.placement_group);
        formatter.field("vpc_zone_identifier", &self.vpc_zone_identifier);
        formatter.field("enabled_metrics", &self.enabled_metrics);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.field("termination_policies", &self.termination_policies);
        formatter.field(
            "new_instances_protected_from_scale_in",
            &self.new_instances_protected_from_scale_in,
        );
        formatter.field("service_linked_role_arn", &self.service_linked_role_arn);
        formatter.field("max_instance_lifetime", &self.max_instance_lifetime);
        formatter.field("capacity_rebalance", &self.capacity_rebalance);
        formatter.field("warm_pool_configuration", &self.warm_pool_configuration);
        formatter.field("warm_pool_size", &self.warm_pool_size);
        formatter.field("context", &self.context);
        formatter.field("desired_capacity_type", &self.desired_capacity_type);
        formatter.finish()
    }
}
/// See [`AutoScalingGroup`](crate::model::AutoScalingGroup)
pub mod auto_scaling_group {
    /// A builder for [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_group_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_group_arn: std::option::Option<std::string::String>,
        pub(crate) launch_configuration_name: std::option::Option<std::string::String>,
        pub(crate) launch_template: std::option::Option<crate::model::LaunchTemplateSpecification>,
        pub(crate) mixed_instances_policy: std::option::Option<crate::model::MixedInstancesPolicy>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) predicted_capacity: std::option::Option<i32>,
        pub(crate) default_cooldown: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) load_balancer_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_group_ar_ns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) health_check_type: std::option::Option<std::string::String>,
        pub(crate) health_check_grace_period: std::option::Option<i32>,
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) suspended_processes:
            std::option::Option<std::vec::Vec<crate::model::SuspendedProcess>>,
        pub(crate) placement_group: std::option::Option<std::string::String>,
        pub(crate) vpc_zone_identifier: std::option::Option<std::string::String>,
        pub(crate) enabled_metrics: std::option::Option<std::vec::Vec<crate::model::EnabledMetric>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagDescription>>,
        pub(crate) termination_policies: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) new_instances_protected_from_scale_in: std::option::Option<bool>,
        pub(crate) service_linked_role_arn: std::option::Option<std::string::String>,
        pub(crate) max_instance_lifetime: std::option::Option<i32>,
        pub(crate) capacity_rebalance: std::option::Option<bool>,
        pub(crate) warm_pool_configuration:
            std::option::Option<crate::model::WarmPoolConfiguration>,
        pub(crate) warm_pool_size: std::option::Option<i32>,
        pub(crate) context: std::option::Option<std::string::String>,
        pub(crate) desired_capacity_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn auto_scaling_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_name = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
        pub fn auto_scaling_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.auto_scaling_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>
        pub fn set_auto_scaling_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_group_arn = input;
            self
        }
        /// <p>The name of the associated launch configuration.</p>
        pub fn launch_configuration_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_configuration_name = Some(input.into());
            self
        }
        /// <p>The name of the associated launch configuration.</p>
        pub fn set_launch_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_configuration_name = input;
            self
        }
        /// <p>The launch template for the group.</p>
        pub fn launch_template(mut self, input: crate::model::LaunchTemplateSpecification) -> Self {
            self.launch_template = Some(input);
            self
        }
        /// <p>The launch template for the group.</p>
        pub fn set_launch_template(
            mut self,
            input: std::option::Option<crate::model::LaunchTemplateSpecification>,
        ) -> Self {
            self.launch_template = input;
            self
        }
        /// <p>The mixed instances policy for the group.</p>
        pub fn mixed_instances_policy(mut self, input: crate::model::MixedInstancesPolicy) -> Self {
            self.mixed_instances_policy = Some(input);
            self
        }
        /// <p>The mixed instances policy for the group.</p>
        pub fn set_mixed_instances_policy(
            mut self,
            input: std::option::Option<crate::model::MixedInstancesPolicy>,
        ) -> Self {
            self.mixed_instances_policy = input;
            self
        }
        /// <p>The minimum size of the group.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum size of the group.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum size of the group.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum size of the group.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The desired size of the group.</p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired size of the group.</p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p>The predicted capacity of the group when it has a predictive scaling policy.</p>
        pub fn predicted_capacity(mut self, input: i32) -> Self {
            self.predicted_capacity = Some(input);
            self
        }
        /// <p>The predicted capacity of the group when it has a predictive scaling policy.</p>
        pub fn set_predicted_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.predicted_capacity = input;
            self
        }
        /// <p>The duration of the default cooldown period, in seconds.</p>
        pub fn default_cooldown(mut self, input: i32) -> Self {
            self.default_cooldown = Some(input);
            self
        }
        /// <p>The duration of the default cooldown period, in seconds.</p>
        pub fn set_default_cooldown(mut self, input: std::option::Option<i32>) -> Self {
            self.default_cooldown = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>One or more Availability Zones for the group.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>One or more Availability Zones for the group.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `load_balancer_names`.
        ///
        /// To override the contents of this collection use [`set_load_balancer_names`](Self::set_load_balancer_names).
        ///
        /// <p>One or more load balancers associated with the group.</p>
        pub fn load_balancer_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.load_balancer_names.unwrap_or_default();
            v.push(input.into());
            self.load_balancer_names = Some(v);
            self
        }
        /// <p>One or more load balancers associated with the group.</p>
        pub fn set_load_balancer_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.load_balancer_names = input;
            self
        }
        /// Appends an item to `target_group_ar_ns`.
        ///
        /// To override the contents of this collection use [`set_target_group_ar_ns`](Self::set_target_group_ar_ns).
        ///
        /// <p>The Amazon Resource Names (ARN) of the target groups for your load balancer.</p>
        pub fn target_group_ar_ns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.target_group_ar_ns.unwrap_or_default();
            v.push(input.into());
            self.target_group_ar_ns = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARN) of the target groups for your load balancer.</p>
        pub fn set_target_group_ar_ns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.target_group_ar_ns = input;
            self
        }
        /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and
        /// <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health
        /// checks, it considers the instance unhealthy if it fails either the EC2 status checks or
        /// the load balancer health checks.</p>
        pub fn health_check_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_type = Some(input.into());
            self
        }
        /// <p>The service to use for the health checks. The valid values are <code>EC2</code> and
        /// <code>ELB</code>. If you configure an Auto Scaling group to use <code>ELB</code> health
        /// checks, it considers the instance unhealthy if it fails either the EC2 status checks or
        /// the load balancer health checks.</p>
        pub fn set_health_check_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_type = input;
            self
        }
        /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status
        /// of an EC2 instance that has come into service.</p>
        pub fn health_check_grace_period(mut self, input: i32) -> Self {
            self.health_check_grace_period = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status
        /// of an EC2 instance that has come into service.</p>
        pub fn set_health_check_grace_period(mut self, input: std::option::Option<i32>) -> Self {
            self.health_check_grace_period = input;
            self
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>The EC2 instances associated with the group.</p>
        pub fn instances(mut self, input: impl Into<crate::model::Instance>) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input.into());
            self.instances = Some(v);
            self
        }
        /// <p>The EC2 instances associated with the group.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Instance>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// <p>The date and time the group was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time the group was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Appends an item to `suspended_processes`.
        ///
        /// To override the contents of this collection use [`set_suspended_processes`](Self::set_suspended_processes).
        ///
        /// <p>The suspended processes associated with the group.</p>
        pub fn suspended_processes(
            mut self,
            input: impl Into<crate::model::SuspendedProcess>,
        ) -> Self {
            let mut v = self.suspended_processes.unwrap_or_default();
            v.push(input.into());
            self.suspended_processes = Some(v);
            self
        }
        /// <p>The suspended processes associated with the group.</p>
        pub fn set_suspended_processes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SuspendedProcess>>,
        ) -> Self {
            self.suspended_processes = input;
            self
        }
        /// <p>The name of the placement group into which to launch your instances, if any.</p>
        pub fn placement_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.placement_group = Some(input.into());
            self
        }
        /// <p>The name of the placement group into which to launch your instances, if any.</p>
        pub fn set_placement_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.placement_group = input;
            self
        }
        /// <p>One or more subnet IDs, if applicable, separated by commas.</p>
        pub fn vpc_zone_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_zone_identifier = Some(input.into());
            self
        }
        /// <p>One or more subnet IDs, if applicable, separated by commas.</p>
        pub fn set_vpc_zone_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_zone_identifier = input;
            self
        }
        /// Appends an item to `enabled_metrics`.
        ///
        /// To override the contents of this collection use [`set_enabled_metrics`](Self::set_enabled_metrics).
        ///
        /// <p>The metrics enabled for the group.</p>
        pub fn enabled_metrics(mut self, input: impl Into<crate::model::EnabledMetric>) -> Self {
            let mut v = self.enabled_metrics.unwrap_or_default();
            v.push(input.into());
            self.enabled_metrics = Some(v);
            self
        }
        /// <p>The metrics enabled for the group.</p>
        pub fn set_enabled_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnabledMetric>>,
        ) -> Self {
            self.enabled_metrics = input;
            self
        }
        /// <p>The current state of the group when the <a>DeleteAutoScalingGroup</a>
        /// operation is in progress.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current state of the group when the <a>DeleteAutoScalingGroup</a>
        /// operation is in progress.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags for the group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::TagDescription>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags for the group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagDescription>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `termination_policies`.
        ///
        /// To override the contents of this collection use [`set_termination_policies`](Self::set_termination_policies).
        ///
        /// <p>The termination policies for the group.</p>
        pub fn termination_policies(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.termination_policies.unwrap_or_default();
            v.push(input.into());
            self.termination_policies = Some(v);
            self
        }
        /// <p>The termination policies for the group.</p>
        pub fn set_termination_policies(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.termination_policies = input;
            self
        }
        /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
        /// when scaling in.</p>
        pub fn new_instances_protected_from_scale_in(mut self, input: bool) -> Self {
            self.new_instances_protected_from_scale_in = Some(input);
            self
        }
        /// <p>Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling
        /// when scaling in.</p>
        pub fn set_new_instances_protected_from_scale_in(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.new_instances_protected_from_scale_in = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to
        /// call other Amazon Web Services on your behalf.</p>
        pub fn service_linked_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_linked_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to
        /// call other Amazon Web Services on your behalf.</p>
        pub fn set_service_linked_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_linked_role_arn = input;
            self
        }
        /// <p>The maximum amount of time, in seconds, that an instance can be in service.</p>
        /// <p>Valid Range: Minimum value of 0.</p>
        pub fn max_instance_lifetime(mut self, input: i32) -> Self {
            self.max_instance_lifetime = Some(input);
            self
        }
        /// <p>The maximum amount of time, in seconds, that an instance can be in service.</p>
        /// <p>Valid Range: Minimum value of 0.</p>
        pub fn set_max_instance_lifetime(mut self, input: std::option::Option<i32>) -> Self {
            self.max_instance_lifetime = input;
            self
        }
        /// <p>Indicates whether Capacity Rebalancing is enabled.</p>
        pub fn capacity_rebalance(mut self, input: bool) -> Self {
            self.capacity_rebalance = Some(input);
            self
        }
        /// <p>Indicates whether Capacity Rebalancing is enabled.</p>
        pub fn set_capacity_rebalance(mut self, input: std::option::Option<bool>) -> Self {
            self.capacity_rebalance = input;
            self
        }
        /// <p>The warm pool for the group.</p>
        pub fn warm_pool_configuration(
            mut self,
            input: crate::model::WarmPoolConfiguration,
        ) -> Self {
            self.warm_pool_configuration = Some(input);
            self
        }
        /// <p>The warm pool for the group.</p>
        pub fn set_warm_pool_configuration(
            mut self,
            input: std::option::Option<crate::model::WarmPoolConfiguration>,
        ) -> Self {
            self.warm_pool_configuration = input;
            self
        }
        /// <p>The current size of the warm pool.</p>
        pub fn warm_pool_size(mut self, input: i32) -> Self {
            self.warm_pool_size = Some(input);
            self
        }
        /// <p>The current size of the warm pool.</p>
        pub fn set_warm_pool_size(mut self, input: std::option::Option<i32>) -> Self {
            self.warm_pool_size = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling
        /// supports <code>DesiredCapacityType</code> for attribute-based instance type selection
        /// only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating
        /// an Auto Scaling group using attribute-based instance type selection</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
        /// instances.</p>
        /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
        /// </p>
        pub fn desired_capacity_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.desired_capacity_type = Some(input.into());
            self
        }
        /// <p>The unit of measurement for the value specified for desired capacity. Amazon EC2 Auto Scaling
        /// supports <code>DesiredCapacityType</code> for attribute-based instance type selection
        /// only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating
        /// an Auto Scaling group using attribute-based instance type selection</a> in the
        /// <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
        /// <p>By default, Amazon EC2 Auto Scaling specifies <code>units</code>, which translates into number of
        /// instances.</p>
        /// <p>Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
        /// </p>
        pub fn set_desired_capacity_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.desired_capacity_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingGroup`](crate::model::AutoScalingGroup)
        pub fn build(self) -> crate::model::AutoScalingGroup {
            crate::model::AutoScalingGroup {
                auto_scaling_group_name: self.auto_scaling_group_name,
                auto_scaling_group_arn: self.auto_scaling_group_arn,
                launch_configuration_name: self.launch_configuration_name,
                launch_template: self.launch_template,
                mixed_instances_policy: self.mixed_instances_policy,
                min_size: self.min_size,
                max_size: self.max_size,
                desired_capacity: self.desired_capacity,
                predicted_capacity: self.predicted_capacity,
                default_cooldown: self.default_cooldown,
                availability_zones: self.availability_zones,
                load_balancer_names: self.load_balancer_names,
                target_group_ar_ns: self.target_group_ar_ns,
                health_check_type: self.health_check_type,
                health_check_grace_period: self.health_check_grace_period,
                instances: self.instances,
                created_time: self.created_time,
                suspended_processes: self.suspended_processes,
                placement_group: self.placement_group,
                vpc_zone_identifier: self.vpc_zone_identifier,
                enabled_metrics: self.enabled_metrics,
                status: self.status,
                tags: self.tags,
                termination_policies: self.termination_policies,
                new_instances_protected_from_scale_in: self.new_instances_protected_from_scale_in,
                service_linked_role_arn: self.service_linked_role_arn,
                max_instance_lifetime: self.max_instance_lifetime,
                capacity_rebalance: self.capacity_rebalance,
                warm_pool_configuration: self.warm_pool_configuration,
                warm_pool_size: self.warm_pool_size,
                context: self.context,
                desired_capacity_type: self.desired_capacity_type,
            }
        }
    }
}
impl AutoScalingGroup {
    /// Creates a new builder-style object to manufacture [`AutoScalingGroup`](crate::model::AutoScalingGroup)
    pub fn builder() -> crate::model::auto_scaling_group::Builder {
        crate::model::auto_scaling_group::Builder::default()
    }
}

/// <p>Describes an enabled metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnabledMetric {
    /// <p>One of the following metrics:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GroupMinSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupMaxSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolWarmedCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// </ul>
    pub metric: std::option::Option<std::string::String>,
    /// <p>The granularity of the metric. The only valid value is <code>1Minute</code>.</p>
    pub granularity: std::option::Option<std::string::String>,
}
impl EnabledMetric {
    /// <p>One of the following metrics:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GroupMinSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupMaxSize</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalInstances</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupInServiceCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupStandbyCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolWarmedCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolPendingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTerminatingCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>WarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolDesiredCapacity</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GroupAndWarmPoolTotalCapacity</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn metric(&self) -> std::option::Option<&str> {
        self.metric.as_deref()
    }
    /// <p>The granularity of the metric. The only valid value is <code>1Minute</code>.</p>
    pub fn granularity(&self) -> std::option::Option<&str> {
        self.granularity.as_deref()
    }
}
impl std::fmt::Debug for EnabledMetric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnabledMetric");
        formatter.field("metric", &self.metric);
        formatter.field("granularity", &self.granularity);
        formatter.finish()
    }
}
/// See [`EnabledMetric`](crate::model::EnabledMetric)
pub mod enabled_metric {
    /// A builder for [`EnabledMetric`](crate::model::EnabledMetric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<std::string::String>,
        pub(crate) granularity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One of the following metrics:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GroupMinSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupMaxSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolWarmedCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn metric(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric = Some(input.into());
            self
        }
        /// <p>One of the following metrics:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GroupMinSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupMaxSize</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalInstances</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupInServiceCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupStandbyCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolWarmedCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolPendingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTerminatingCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>WarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolDesiredCapacity</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GroupAndWarmPoolTotalCapacity</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_metric(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The granularity of the metric. The only valid value is <code>1Minute</code>.</p>
        pub fn granularity(mut self, input: impl Into<std::string::String>) -> Self {
            self.granularity = Some(input.into());
            self
        }
        /// <p>The granularity of the metric. The only valid value is <code>1Minute</code>.</p>
        pub fn set_granularity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.granularity = input;
            self
        }
        /// Consumes the builder and constructs a [`EnabledMetric`](crate::model::EnabledMetric)
        pub fn build(self) -> crate::model::EnabledMetric {
            crate::model::EnabledMetric {
                metric: self.metric,
                granularity: self.granularity,
            }
        }
    }
}
impl EnabledMetric {
    /// Creates a new builder-style object to manufacture [`EnabledMetric`](crate::model::EnabledMetric)
    pub fn builder() -> crate::model::enabled_metric::Builder {
        crate::model::enabled_metric::Builder::default()
    }
}

/// <p>Describes an auto scaling process that has been suspended.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types">Scaling processes</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuspendedProcess {
    /// <p>The name of the suspended process.</p>
    pub process_name: std::option::Option<std::string::String>,
    /// <p>The reason that the process was suspended.</p>
    pub suspension_reason: std::option::Option<std::string::String>,
}
impl SuspendedProcess {
    /// <p>The name of the suspended process.</p>
    pub fn process_name(&self) -> std::option::Option<&str> {
        self.process_name.as_deref()
    }
    /// <p>The reason that the process was suspended.</p>
    pub fn suspension_reason(&self) -> std::option::Option<&str> {
        self.suspension_reason.as_deref()
    }
}
impl std::fmt::Debug for SuspendedProcess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuspendedProcess");
        formatter.field("process_name", &self.process_name);
        formatter.field("suspension_reason", &self.suspension_reason);
        formatter.finish()
    }
}
/// See [`SuspendedProcess`](crate::model::SuspendedProcess)
pub mod suspended_process {
    /// A builder for [`SuspendedProcess`](crate::model::SuspendedProcess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) process_name: std::option::Option<std::string::String>,
        pub(crate) suspension_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the suspended process.</p>
        pub fn process_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.process_name = Some(input.into());
            self
        }
        /// <p>The name of the suspended process.</p>
        pub fn set_process_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.process_name = input;
            self
        }
        /// <p>The reason that the process was suspended.</p>
        pub fn suspension_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.suspension_reason = Some(input.into());
            self
        }
        /// <p>The reason that the process was suspended.</p>
        pub fn set_suspension_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.suspension_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`SuspendedProcess`](crate::model::SuspendedProcess)
        pub fn build(self) -> crate::model::SuspendedProcess {
            crate::model::SuspendedProcess {
                process_name: self.process_name,
                suspension_reason: self.suspension_reason,
            }
        }
    }
}
impl SuspendedProcess {
    /// Creates a new builder-style object to manufacture [`SuspendedProcess`](crate::model::SuspendedProcess)
    pub fn builder() -> crate::model::suspended_process::Builder {
        crate::model::suspended_process::Builder::default()
    }
}

/// <p>Describes a policy adjustment type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdjustmentType {
    /// <p>The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
    /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
    pub adjustment_type: std::option::Option<std::string::String>,
}
impl AdjustmentType {
    /// <p>The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
    /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
    pub fn adjustment_type(&self) -> std::option::Option<&str> {
        self.adjustment_type.as_deref()
    }
}
impl std::fmt::Debug for AdjustmentType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdjustmentType");
        formatter.field("adjustment_type", &self.adjustment_type);
        formatter.finish()
    }
}
/// See [`AdjustmentType`](crate::model::AdjustmentType)
pub mod adjustment_type {
    /// A builder for [`AdjustmentType`](crate::model::AdjustmentType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adjustment_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
        /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
        pub fn adjustment_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.adjustment_type = Some(input.into());
            self
        }
        /// <p>The policy adjustment type. The valid values are <code>ChangeInCapacity</code>,
        /// <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.</p>
        pub fn set_adjustment_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.adjustment_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AdjustmentType`](crate::model::AdjustmentType)
        pub fn build(self) -> crate::model::AdjustmentType {
            crate::model::AdjustmentType {
                adjustment_type: self.adjustment_type,
            }
        }
    }
}
impl AdjustmentType {
    /// Creates a new builder-style object to manufacture [`AdjustmentType`](crate::model::AdjustmentType)
    pub fn builder() -> crate::model::adjustment_type::Builder {
        crate::model::adjustment_type::Builder::default()
    }
}

/// <p>Describes a tag for an Auto Scaling group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The name of the Auto Scaling group.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of resource. The only supported value is
    /// <code>auto-scaling-group</code>.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Determines whether the tag is added to new instances as they are launched in the
    /// group.</p>
    pub propagate_at_launch: std::option::Option<bool>,
}
impl Tag {
    /// <p>The name of the Auto Scaling group.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of resource. The only supported value is
    /// <code>auto-scaling-group</code>.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>Determines whether the tag is added to new instances as they are launched in the
    /// group.</p>
    pub fn propagate_at_launch(&self) -> std::option::Option<bool> {
        self.propagate_at_launch
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("propagate_at_launch", &self.propagate_at_launch);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) propagate_at_launch: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the Auto Scaling group.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The name of the Auto Scaling group.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of resource. The only supported value is
        /// <code>auto-scaling-group</code>.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource. The only supported value is
        /// <code>auto-scaling-group</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Determines whether the tag is added to new instances as they are launched in the
        /// group.</p>
        pub fn propagate_at_launch(mut self, input: bool) -> Self {
            self.propagate_at_launch = Some(input);
            self
        }
        /// <p>Determines whether the tag is added to new instances as they are launched in the
        /// group.</p>
        pub fn set_propagate_at_launch(mut self, input: std::option::Option<bool>) -> Self {
            self.propagate_at_launch = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                key: self.key,
                value: self.value,
                propagate_at_launch: self.propagate_at_launch,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Describes information used to specify a lifecycle hook for an Auto Scaling
/// group.</p>
/// <p>A lifecycle hook tells Amazon EC2 Auto Scaling to perform an action on an instance when the instance
/// launches (before it is put into service) or as the instance terminates (before it is
/// fully terminated).</p>
/// <p>This step is a part of the procedure for creating a lifecycle hook for an Auto Scaling
/// group:</p>
/// <ol>
/// <li>
/// <p>(Optional) Create a Lambda function and a rule that allows CloudWatch Events to
/// invoke your Lambda function when Amazon EC2 Auto Scaling launches or terminates
/// instances.</p>
/// </li>
/// <li>
/// <p>(Optional) Create a notification target and an IAM role. The target can be
/// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to
/// publish lifecycle notifications to the target.</p>
/// </li>
/// <li>
/// <p>
/// <b>Create the lifecycle hook. Specify whether the hook is
/// used when the instances launch or terminate.</b>
/// </p>
/// </li>
/// <li>
/// <p>If you need more time, record the lifecycle action heartbeat to keep the
/// instance in a pending state.</p>
/// </li>
/// <li>
/// <p>If you finish before the timeout period ends, complete the lifecycle
/// action.</p>
/// </li>
/// </ol>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 Auto Scaling lifecycle
/// hooks</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LifecycleHookSpecification {
    /// <p>The name of the lifecycle hook.</p>
    pub lifecycle_hook_name: std::option::Option<std::string::String>,
    /// <p>The state of the EC2 instance to which you want to attach the lifecycle hook. The
    /// valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
    /// </li>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
    /// </li>
    /// </ul>
    pub lifecycle_transition: std::option::Option<std::string::String>,
    /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to
    /// the notification target.</p>
    pub notification_metadata: std::option::Option<std::string::String>,
    /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times
    /// out.</p>
    /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in
    /// the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing
    /// out by calling <a>RecordLifecycleActionHeartbeat</a>.</p>
    pub heartbeat_timeout: std::option::Option<i32>,
    /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
    /// or if an unexpected failure occurs. The valid values are <code>CONTINUE</code> and
    /// <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
    pub default_result: std::option::Option<std::string::String>,
    /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
    /// transition state for the lifecycle hook. The notification target can be either an SQS
    /// queue or an SNS topic.</p>
    pub notification_target_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
    /// notification target, for example, an Amazon SNS topic or an Amazon SQS queue.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl LifecycleHookSpecification {
    /// <p>The name of the lifecycle hook.</p>
    pub fn lifecycle_hook_name(&self) -> std::option::Option<&str> {
        self.lifecycle_hook_name.as_deref()
    }
    /// <p>The state of the EC2 instance to which you want to attach the lifecycle hook. The
    /// valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
    /// </li>
    /// <li>
    /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
    /// </li>
    /// </ul>
    pub fn lifecycle_transition(&self) -> std::option::Option<&str> {
        self.lifecycle_transition.as_deref()
    }
    /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to
    /// the notification target.</p>
    pub fn notification_metadata(&self) -> std::option::Option<&str> {
        self.notification_metadata.as_deref()
    }
    /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times
    /// out.</p>
    /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in
    /// the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing
    /// out by calling <a>RecordLifecycleActionHeartbeat</a>.</p>
    pub fn heartbeat_timeout(&self) -> std::option::Option<i32> {
        self.heartbeat_timeout
    }
    /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
    /// or if an unexpected failure occurs. The valid values are <code>CONTINUE</code> and
    /// <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
    pub fn default_result(&self) -> std::option::Option<&str> {
        self.default_result.as_deref()
    }
    /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
    /// transition state for the lifecycle hook. The notification target can be either an SQS
    /// queue or an SNS topic.</p>
    pub fn notification_target_arn(&self) -> std::option::Option<&str> {
        self.notification_target_arn.as_deref()
    }
    /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
    /// notification target, for example, an Amazon SNS topic or an Amazon SQS queue.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for LifecycleHookSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LifecycleHookSpecification");
        formatter.field("lifecycle_hook_name", &self.lifecycle_hook_name);
        formatter.field("lifecycle_transition", &self.lifecycle_transition);
        formatter.field("notification_metadata", &self.notification_metadata);
        formatter.field("heartbeat_timeout", &self.heartbeat_timeout);
        formatter.field("default_result", &self.default_result);
        formatter.field("notification_target_arn", &self.notification_target_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`LifecycleHookSpecification`](crate::model::LifecycleHookSpecification)
pub mod lifecycle_hook_specification {
    /// A builder for [`LifecycleHookSpecification`](crate::model::LifecycleHookSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lifecycle_hook_name: std::option::Option<std::string::String>,
        pub(crate) lifecycle_transition: std::option::Option<std::string::String>,
        pub(crate) notification_metadata: std::option::Option<std::string::String>,
        pub(crate) heartbeat_timeout: std::option::Option<i32>,
        pub(crate) default_result: std::option::Option<std::string::String>,
        pub(crate) notification_target_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the lifecycle hook.</p>
        pub fn lifecycle_hook_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_hook_name = Some(input.into());
            self
        }
        /// <p>The name of the lifecycle hook.</p>
        pub fn set_lifecycle_hook_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_hook_name = input;
            self
        }
        /// <p>The state of the EC2 instance to which you want to attach the lifecycle hook. The
        /// valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
        /// </li>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
        /// </li>
        /// </ul>
        pub fn lifecycle_transition(mut self, input: impl Into<std::string::String>) -> Self {
            self.lifecycle_transition = Some(input.into());
            self
        }
        /// <p>The state of the EC2 instance to which you want to attach the lifecycle hook. The
        /// valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_LAUNCHING</p>
        /// </li>
        /// <li>
        /// <p>autoscaling:EC2_INSTANCE_TERMINATING</p>
        /// </li>
        /// </ul>
        pub fn set_lifecycle_transition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lifecycle_transition = input;
            self
        }
        /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to
        /// the notification target.</p>
        pub fn notification_metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_metadata = Some(input.into());
            self
        }
        /// <p>Additional information that you want to include any time Amazon EC2 Auto Scaling sends a message to
        /// the notification target.</p>
        pub fn set_notification_metadata(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_metadata = input;
            self
        }
        /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times
        /// out.</p>
        /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in
        /// the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing
        /// out by calling <a>RecordLifecycleActionHeartbeat</a>.</p>
        pub fn heartbeat_timeout(mut self, input: i32) -> Self {
            self.heartbeat_timeout = Some(input);
            self
        }
        /// <p>The maximum time, in seconds, that can elapse before the lifecycle hook times
        /// out.</p>
        /// <p>If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the action that you specified in
        /// the <code>DefaultResult</code> parameter. You can prevent the lifecycle hook from timing
        /// out by calling <a>RecordLifecycleActionHeartbeat</a>.</p>
        pub fn set_heartbeat_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.heartbeat_timeout = input;
            self
        }
        /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
        /// or if an unexpected failure occurs. The valid values are <code>CONTINUE</code> and
        /// <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
        pub fn default_result(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_result = Some(input.into());
            self
        }
        /// <p>Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses
        /// or if an unexpected failure occurs. The valid values are <code>CONTINUE</code> and
        /// <code>ABANDON</code>. The default value is <code>ABANDON</code>.</p>
        pub fn set_default_result(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_result = input;
            self
        }
        /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
        /// transition state for the lifecycle hook. The notification target can be either an SQS
        /// queue or an SNS topic.</p>
        pub fn notification_target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.notification_target_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when an instance is in the
        /// transition state for the lifecycle hook. The notification target can be either an SQS
        /// queue or an SNS topic.</p>
        pub fn set_notification_target_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.notification_target_arn = input;
            self
        }
        /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
        /// notification target, for example, an Amazon SNS topic or an Amazon SQS queue.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that allows the Auto Scaling group to publish to the specified
        /// notification target, for example, an Amazon SNS topic or an Amazon SQS queue.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LifecycleHookSpecification`](crate::model::LifecycleHookSpecification)
        pub fn build(self) -> crate::model::LifecycleHookSpecification {
            crate::model::LifecycleHookSpecification {
                lifecycle_hook_name: self.lifecycle_hook_name,
                lifecycle_transition: self.lifecycle_transition,
                notification_metadata: self.notification_metadata,
                heartbeat_timeout: self.heartbeat_timeout,
                default_result: self.default_result,
                notification_target_arn: self.notification_target_arn,
                role_arn: self.role_arn,
            }
        }
    }
}
impl LifecycleHookSpecification {
    /// Creates a new builder-style object to manufacture [`LifecycleHookSpecification`](crate::model::LifecycleHookSpecification)
    pub fn builder() -> crate::model::lifecycle_hook_specification::Builder {
        crate::model::lifecycle_hook_specification::Builder::default()
    }
}

/// <p>Describes a scheduled action that could not be created, updated, or deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedScheduledUpdateGroupActionRequest {
    /// <p>The name of the scheduled action.</p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message accompanying the error code.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FailedScheduledUpdateGroupActionRequest {
    /// <p>The name of the scheduled action.</p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message accompanying the error code.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FailedScheduledUpdateGroupActionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedScheduledUpdateGroupActionRequest");
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailedScheduledUpdateGroupActionRequest`](crate::model::FailedScheduledUpdateGroupActionRequest)
pub mod failed_scheduled_update_group_action_request {
    /// A builder for [`FailedScheduledUpdateGroupActionRequest`](crate::model::FailedScheduledUpdateGroupActionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scheduled action.</p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action.</p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message accompanying the error code.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message accompanying the error code.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedScheduledUpdateGroupActionRequest`](crate::model::FailedScheduledUpdateGroupActionRequest)
        pub fn build(self) -> crate::model::FailedScheduledUpdateGroupActionRequest {
            crate::model::FailedScheduledUpdateGroupActionRequest {
                scheduled_action_name: self.scheduled_action_name,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl FailedScheduledUpdateGroupActionRequest {
    /// Creates a new builder-style object to manufacture [`FailedScheduledUpdateGroupActionRequest`](crate::model::FailedScheduledUpdateGroupActionRequest)
    pub fn builder() -> crate::model::failed_scheduled_update_group_action_request::Builder {
        crate::model::failed_scheduled_update_group_action_request::Builder::default()
    }
}

/// <p>Describes information used for one or more scheduled scaling action updates in a <a>BatchPutScheduledUpdateGroupAction</a> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledUpdateGroupActionRequest {
    /// <p>The name of the scaling action.</p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT
    /// only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
    /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs
    /// the action at this time, and then performs the action based on the specified
    /// recurrence.</p>
    /// <p>If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error
    /// message.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time for the recurring schedule to end, in UTC.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The recurring schedule for the action, in Unix cron syntax format. This format
    /// consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month]
    /// [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1
    /// 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
    /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
    /// <code>Recurrence</code>, they form the boundaries of when the recurring action
    /// starts and stops.</p>
    /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
    pub recurrence: std::option::Option<std::string::String>,
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub min_size: std::option::Option<i32>,
    /// <p>The maximum size of the Auto Scaling group.</p>
    pub max_size: std::option::Option<i32>,
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
    /// action runs and the capacity it attempts to maintain.</p>
    pub desired_capacity: std::option::Option<i32>,
    /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is
    /// used by default. </p>
    /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA
    /// Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For
    /// more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
    pub time_zone: std::option::Option<std::string::String>,
}
impl ScheduledUpdateGroupActionRequest {
    /// <p>The name of the scaling action.</p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT
    /// only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
    /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs
    /// the action at this time, and then performs the action based on the specified
    /// recurrence.</p>
    /// <p>If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error
    /// message.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The date and time for the recurring schedule to end, in UTC.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
    /// <p>The recurring schedule for the action, in Unix cron syntax format. This format
    /// consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month]
    /// [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1
    /// 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
    /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
    /// <code>Recurrence</code>, they form the boundaries of when the recurring action
    /// starts and stops.</p>
    /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
    pub fn recurrence(&self) -> std::option::Option<&str> {
        self.recurrence.as_deref()
    }
    /// <p>The minimum size of the Auto Scaling group.</p>
    pub fn min_size(&self) -> std::option::Option<i32> {
        self.min_size
    }
    /// <p>The maximum size of the Auto Scaling group.</p>
    pub fn max_size(&self) -> std::option::Option<i32> {
        self.max_size
    }
    /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
    /// action runs and the capacity it attempts to maintain.</p>
    pub fn desired_capacity(&self) -> std::option::Option<i32> {
        self.desired_capacity
    }
    /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is
    /// used by default. </p>
    /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA
    /// Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For
    /// more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
    pub fn time_zone(&self) -> std::option::Option<&str> {
        self.time_zone.as_deref()
    }
}
impl std::fmt::Debug for ScheduledUpdateGroupActionRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledUpdateGroupActionRequest");
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("recurrence", &self.recurrence);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("desired_capacity", &self.desired_capacity);
        formatter.field("time_zone", &self.time_zone);
        formatter.finish()
    }
}
/// See [`ScheduledUpdateGroupActionRequest`](crate::model::ScheduledUpdateGroupActionRequest)
pub mod scheduled_update_group_action_request {
    /// A builder for [`ScheduledUpdateGroupActionRequest`](crate::model::ScheduledUpdateGroupActionRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) recurrence: std::option::Option<std::string::String>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) desired_capacity: std::option::Option<i32>,
        pub(crate) time_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the scaling action.</p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scaling action.</p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT
        /// only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
        /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs
        /// the action at this time, and then performs the action based on the specified
        /// recurrence.</p>
        /// <p>If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error
        /// message.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT
        /// only and in quotes (for example, <code>"2019-06-01T00:00:00Z"</code>).</p>
        /// <p>If you specify <code>Recurrence</code> and <code>StartTime</code>, Amazon EC2 Auto Scaling performs
        /// the action at this time, and then performs the action based on the specified
        /// recurrence.</p>
        /// <p>If you try to schedule the action in the past, Amazon EC2 Auto Scaling returns an error
        /// message.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time for the recurring schedule to end, in UTC.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time for the recurring schedule to end, in UTC.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The recurring schedule for the action, in Unix cron syntax format. This format
        /// consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month]
        /// [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1
        /// 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
        /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
        /// <code>Recurrence</code>, they form the boundaries of when the recurring action
        /// starts and stops.</p>
        /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
        pub fn recurrence(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurrence = Some(input.into());
            self
        }
        /// <p>The recurring schedule for the action, in Unix cron syntax format. This format
        /// consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month]
        /// [Month_of_Year] [Day_of_Week]. The value must be in quotes (for example, <code>"30 0 1
        /// 1,6,12 *"</code>). For more information about this format, see <a href="http://crontab.org">Crontab</a>.</p>
        /// <p>When <code>StartTime</code> and <code>EndTime</code> are specified with
        /// <code>Recurrence</code>, they form the boundaries of when the recurring action
        /// starts and stops.</p>
        /// <p>Cron expressions use Universal Coordinated Time (UTC) by default.</p>
        pub fn set_recurrence(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recurrence = input;
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum size of the Auto Scaling group.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum size of the Auto Scaling group.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
        /// action runs and the capacity it attempts to maintain.</p>
        pub fn desired_capacity(mut self, input: i32) -> Self {
            self.desired_capacity = Some(input);
            self
        }
        /// <p>The desired capacity is the initial capacity of the Auto Scaling group after the scheduled
        /// action runs and the capacity it attempts to maintain.</p>
        pub fn set_desired_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_capacity = input;
            self
        }
        /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is
        /// used by default. </p>
        /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA
        /// Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For
        /// more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone = Some(input.into());
            self
        }
        /// <p>Specifies the time zone for a cron expression. If a time zone is not provided, UTC is
        /// used by default. </p>
        /// <p>Valid values are the canonical names of the IANA time zones, derived from the IANA
        /// Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code>). For
        /// more information, see <a href="https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a>.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledUpdateGroupActionRequest`](crate::model::ScheduledUpdateGroupActionRequest)
        pub fn build(self) -> crate::model::ScheduledUpdateGroupActionRequest {
            crate::model::ScheduledUpdateGroupActionRequest {
                scheduled_action_name: self.scheduled_action_name,
                start_time: self.start_time,
                end_time: self.end_time,
                recurrence: self.recurrence,
                min_size: self.min_size,
                max_size: self.max_size,
                desired_capacity: self.desired_capacity,
                time_zone: self.time_zone,
            }
        }
    }
}
impl ScheduledUpdateGroupActionRequest {
    /// Creates a new builder-style object to manufacture [`ScheduledUpdateGroupActionRequest`](crate::model::ScheduledUpdateGroupActionRequest)
    pub fn builder() -> crate::model::scheduled_update_group_action_request::Builder {
        crate::model::scheduled_update_group_action_request::Builder::default()
    }
}
