// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Audit Manager
///
/// Client for invoking operations on AWS Audit Manager. Each operation on AWS Audit Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_auditmanager::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_auditmanager::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_auditmanager::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateAssessmentReportEvidenceFolder`](crate::client::fluent_builders::AssociateAssessmentReportEvidenceFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAssessmentReportEvidenceFolder::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::AssociateAssessmentReportEvidenceFolder::set_assessment_id): <p> The identifier for the assessment. </p>
    ///   - [`evidence_folder_id(impl Into<String>)`](crate::client::fluent_builders::AssociateAssessmentReportEvidenceFolder::evidence_folder_id) / [`set_evidence_folder_id(Option<String>)`](crate::client::fluent_builders::AssociateAssessmentReportEvidenceFolder::set_evidence_folder_id): <p> The identifier for the folder that the evidence is stored in. </p>
    /// - On success, responds with [`AssociateAssessmentReportEvidenceFolderOutput`](crate::output::AssociateAssessmentReportEvidenceFolderOutput)

    /// - On failure, responds with [`SdkError<AssociateAssessmentReportEvidenceFolderError>`](crate::error::AssociateAssessmentReportEvidenceFolderError)
    pub fn associate_assessment_report_evidence_folder(
        &self,
    ) -> fluent_builders::AssociateAssessmentReportEvidenceFolder {
        fluent_builders::AssociateAssessmentReportEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchAssociateAssessmentReportEvidence`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence::set_assessment_id): <p> The identifier for the assessment. </p>
    ///   - [`evidence_folder_id(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence::evidence_folder_id) / [`set_evidence_folder_id(Option<String>)`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence::set_evidence_folder_id): <p> The identifier for the folder that the evidence is stored in. </p>
    ///   - [`evidence_ids(Vec<String>)`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence::evidence_ids) / [`set_evidence_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence::set_evidence_ids): <p> The list of evidence identifiers. </p>
    /// - On success, responds with [`BatchAssociateAssessmentReportEvidenceOutput`](crate::output::BatchAssociateAssessmentReportEvidenceOutput) with field(s):
    ///   - [`evidence_ids(Option<Vec<String>>)`](crate::output::BatchAssociateAssessmentReportEvidenceOutput::evidence_ids): <p> The list of evidence identifiers. </p>
    ///   - [`errors(Option<Vec<AssessmentReportEvidenceError>>)`](crate::output::BatchAssociateAssessmentReportEvidenceOutput::errors): <p> A list of errors that the <code>BatchAssociateAssessmentReportEvidence</code> API returned. </p>
    /// - On failure, responds with [`SdkError<BatchAssociateAssessmentReportEvidenceError>`](crate::error::BatchAssociateAssessmentReportEvidenceError)
    pub fn batch_associate_assessment_report_evidence(
        &self,
    ) -> fluent_builders::BatchAssociateAssessmentReportEvidence {
        fluent_builders::BatchAssociateAssessmentReportEvidence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchCreateDelegationByAssessment`](crate::client::fluent_builders::BatchCreateDelegationByAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`create_delegation_requests(Vec<CreateDelegationRequest>)`](crate::client::fluent_builders::BatchCreateDelegationByAssessment::create_delegation_requests) / [`set_create_delegation_requests(Option<Vec<CreateDelegationRequest>>)`](crate::client::fluent_builders::BatchCreateDelegationByAssessment::set_create_delegation_requests): <p> The API request to batch create delegations in Audit Manager. </p>
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::BatchCreateDelegationByAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::BatchCreateDelegationByAssessment::set_assessment_id): <p> The identifier for the assessment. </p>
    /// - On success, responds with [`BatchCreateDelegationByAssessmentOutput`](crate::output::BatchCreateDelegationByAssessmentOutput) with field(s):
    ///   - [`delegations(Option<Vec<Delegation>>)`](crate::output::BatchCreateDelegationByAssessmentOutput::delegations): <p> The delegations that are associated with the assessment. </p>
    ///   - [`errors(Option<Vec<BatchCreateDelegationByAssessmentError>>)`](crate::output::BatchCreateDelegationByAssessmentOutput::errors): <p> A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned. </p>
    /// - On failure, responds with [`SdkError<BatchCreateDelegationByAssessmentError>`](crate::error::BatchCreateDelegationByAssessmentError)
    pub fn batch_create_delegation_by_assessment(
        &self,
    ) -> fluent_builders::BatchCreateDelegationByAssessment {
        fluent_builders::BatchCreateDelegationByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDeleteDelegationByAssessment`](crate::client::fluent_builders::BatchDeleteDelegationByAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`delegation_ids(Vec<String>)`](crate::client::fluent_builders::BatchDeleteDelegationByAssessment::delegation_ids) / [`set_delegation_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDeleteDelegationByAssessment::set_delegation_ids): <p> The identifiers for the delegations. </p>
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::BatchDeleteDelegationByAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::BatchDeleteDelegationByAssessment::set_assessment_id): <p> The identifier for the assessment. </p>
    /// - On success, responds with [`BatchDeleteDelegationByAssessmentOutput`](crate::output::BatchDeleteDelegationByAssessmentOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchDeleteDelegationByAssessmentError>>)`](crate::output::BatchDeleteDelegationByAssessmentOutput::errors): <p> A list of errors that the <code>BatchDeleteDelegationByAssessment</code> API returned. </p>
    /// - On failure, responds with [`SdkError<BatchDeleteDelegationByAssessmentError>`](crate::error::BatchDeleteDelegationByAssessmentError)
    pub fn batch_delete_delegation_by_assessment(
        &self,
    ) -> fluent_builders::BatchDeleteDelegationByAssessment {
        fluent_builders::BatchDeleteDelegationByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDisassociateAssessmentReportEvidence`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence::set_assessment_id): <p> The identifier for the assessment. </p>
    ///   - [`evidence_folder_id(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence::evidence_folder_id) / [`set_evidence_folder_id(Option<String>)`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence::set_evidence_folder_id): <p> The identifier for the folder that the evidence is stored in. </p>
    ///   - [`evidence_ids(Vec<String>)`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence::evidence_ids) / [`set_evidence_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence::set_evidence_ids): <p> The list of evidence identifiers. </p>
    /// - On success, responds with [`BatchDisassociateAssessmentReportEvidenceOutput`](crate::output::BatchDisassociateAssessmentReportEvidenceOutput) with field(s):
    ///   - [`evidence_ids(Option<Vec<String>>)`](crate::output::BatchDisassociateAssessmentReportEvidenceOutput::evidence_ids): <p> The identifier for the evidence. </p>
    ///   - [`errors(Option<Vec<AssessmentReportEvidenceError>>)`](crate::output::BatchDisassociateAssessmentReportEvidenceOutput::errors): <p> A list of errors that the <code>BatchDisassociateAssessmentReportEvidence</code> API returned. </p>
    /// - On failure, responds with [`SdkError<BatchDisassociateAssessmentReportEvidenceError>`](crate::error::BatchDisassociateAssessmentReportEvidenceError)
    pub fn batch_disassociate_assessment_report_evidence(
        &self,
    ) -> fluent_builders::BatchDisassociateAssessmentReportEvidence {
        fluent_builders::BatchDisassociateAssessmentReportEvidence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchImportEvidenceToAssessmentControl`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::set_assessment_id): <p> The identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::set_control_set_id): <p> The identifier for the control set. </p>
    ///   - [`control_id(impl Into<String>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::control_id) / [`set_control_id(Option<String>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::set_control_id): <p> The identifier for the control. </p>
    ///   - [`manual_evidence(Vec<ManualEvidence>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::manual_evidence) / [`set_manual_evidence(Option<Vec<ManualEvidence>>)`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl::set_manual_evidence): <p> The list of manual evidence objects. </p>
    /// - On success, responds with [`BatchImportEvidenceToAssessmentControlOutput`](crate::output::BatchImportEvidenceToAssessmentControlOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchImportEvidenceToAssessmentControlError>>)`](crate::output::BatchImportEvidenceToAssessmentControlOutput::errors): <p> A list of errors that the <code>BatchImportEvidenceToAssessmentControl</code> API returned. </p>
    /// - On failure, responds with [`SdkError<BatchImportEvidenceToAssessmentControlError>`](crate::error::BatchImportEvidenceToAssessmentControlError)
    pub fn batch_import_evidence_to_assessment_control(
        &self,
    ) -> fluent_builders::BatchImportEvidenceToAssessmentControl {
        fluent_builders::BatchImportEvidenceToAssessmentControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssessment`](crate::client::fluent_builders::CreateAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAssessment::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAssessment::set_name): <p> The name of the assessment to be created. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAssessment::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAssessment::set_description): <p> The optional description of the assessment to be created. </p>
    ///   - [`assessment_reports_destination(AssessmentReportsDestination)`](crate::client::fluent_builders::CreateAssessment::assessment_reports_destination) / [`set_assessment_reports_destination(Option<AssessmentReportsDestination>)`](crate::client::fluent_builders::CreateAssessment::set_assessment_reports_destination): <p> The assessment report storage destination for the assessment that's being created. </p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::CreateAssessment::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::CreateAssessment::set_scope): <p> The wrapper that contains the Amazon Web Services accounts and services that are in scope for the assessment. </p>
    ///   - [`roles(Vec<Role>)`](crate::client::fluent_builders::CreateAssessment::roles) / [`set_roles(Option<Vec<Role>>)`](crate::client::fluent_builders::CreateAssessment::set_roles): <p> The list of roles for the assessment. </p>
    ///   - [`framework_id(impl Into<String>)`](crate::client::fluent_builders::CreateAssessment::framework_id) / [`set_framework_id(Option<String>)`](crate::client::fluent_builders::CreateAssessment::set_framework_id): <p> The identifier for the framework that the assessment will be created from. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAssessment::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAssessment::set_tags): <p> The tags that are associated with the assessment. </p>
    /// - On success, responds with [`CreateAssessmentOutput`](crate::output::CreateAssessmentOutput) with field(s):
    ///   - [`assessment(Option<Assessment>)`](crate::output::CreateAssessmentOutput::assessment): <p> An entity that defines the scope of audit evidence collected by Audit Manager. An Audit Manager assessment is an implementation of an Audit Manager framework. </p>
    /// - On failure, responds with [`SdkError<CreateAssessmentError>`](crate::error::CreateAssessmentError)
    pub fn create_assessment(&self) -> fluent_builders::CreateAssessment {
        fluent_builders::CreateAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssessmentFramework`](crate::client::fluent_builders::CreateAssessmentFramework) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentFramework::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAssessmentFramework::set_name): <p> The name of the new custom framework. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentFramework::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAssessmentFramework::set_description): <p> An optional description for the new custom framework. </p>
    ///   - [`compliance_type(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentFramework::compliance_type) / [`set_compliance_type(Option<String>)`](crate::client::fluent_builders::CreateAssessmentFramework::set_compliance_type): <p> The compliance type that the new custom framework supports, such as CIS or HIPAA. </p>
    ///   - [`control_sets(Vec<CreateAssessmentFrameworkControlSet>)`](crate::client::fluent_builders::CreateAssessmentFramework::control_sets) / [`set_control_sets(Option<Vec<CreateAssessmentFrameworkControlSet>>)`](crate::client::fluent_builders::CreateAssessmentFramework::set_control_sets): <p> The control sets that are associated with the framework. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAssessmentFramework::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAssessmentFramework::set_tags): <p> The tags that are associated with the framework. </p>
    /// - On success, responds with [`CreateAssessmentFrameworkOutput`](crate::output::CreateAssessmentFrameworkOutput) with field(s):
    ///   - [`framework(Option<Framework>)`](crate::output::CreateAssessmentFrameworkOutput::framework): <p> The name of the new framework that the <code>CreateAssessmentFramework</code> API returned. </p>
    /// - On failure, responds with [`SdkError<CreateAssessmentFrameworkError>`](crate::error::CreateAssessmentFrameworkError)
    pub fn create_assessment_framework(&self) -> fluent_builders::CreateAssessmentFramework {
        fluent_builders::CreateAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAssessmentReport`](crate::client::fluent_builders::CreateAssessmentReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentReport::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAssessmentReport::set_name): <p> The name of the new assessment report. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentReport::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAssessmentReport::set_description): <p> The description of the assessment report. </p>
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::CreateAssessmentReport::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::CreateAssessmentReport::set_assessment_id): <p> The identifier for the assessment. </p>
    /// - On success, responds with [`CreateAssessmentReportOutput`](crate::output::CreateAssessmentReportOutput) with field(s):
    ///   - [`assessment_report(Option<AssessmentReport>)`](crate::output::CreateAssessmentReportOutput::assessment_report): <p> The new assessment report that the <code>CreateAssessmentReport</code> API returned. </p>
    /// - On failure, responds with [`SdkError<CreateAssessmentReportError>`](crate::error::CreateAssessmentReportError)
    pub fn create_assessment_report(&self) -> fluent_builders::CreateAssessmentReport {
        fluent_builders::CreateAssessmentReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateControl`](crate::client::fluent_builders::CreateControl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateControl::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateControl::set_name): <p> The name of the control. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateControl::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateControl::set_description): <p> The description of the control. </p>
    ///   - [`testing_information(impl Into<String>)`](crate::client::fluent_builders::CreateControl::testing_information) / [`set_testing_information(Option<String>)`](crate::client::fluent_builders::CreateControl::set_testing_information): <p> The steps to follow to determine if the control is satisfied. </p>
    ///   - [`action_plan_title(impl Into<String>)`](crate::client::fluent_builders::CreateControl::action_plan_title) / [`set_action_plan_title(Option<String>)`](crate::client::fluent_builders::CreateControl::set_action_plan_title): <p> The title of the action plan for remediating the control. </p>
    ///   - [`action_plan_instructions(impl Into<String>)`](crate::client::fluent_builders::CreateControl::action_plan_instructions) / [`set_action_plan_instructions(Option<String>)`](crate::client::fluent_builders::CreateControl::set_action_plan_instructions): <p> The recommended actions to carry out if the control isn't fulfilled. </p>
    ///   - [`control_mapping_sources(Vec<CreateControlMappingSource>)`](crate::client::fluent_builders::CreateControl::control_mapping_sources) / [`set_control_mapping_sources(Option<Vec<CreateControlMappingSource>>)`](crate::client::fluent_builders::CreateControl::set_control_mapping_sources): <p> The data mapping sources for the control. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateControl::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateControl::set_tags): <p> The tags that are associated with the control. </p>
    /// - On success, responds with [`CreateControlOutput`](crate::output::CreateControlOutput) with field(s):
    ///   - [`control(Option<Control>)`](crate::output::CreateControlOutput::control): <p> The new control that the <code>CreateControl</code> API returned. </p>
    /// - On failure, responds with [`SdkError<CreateControlError>`](crate::error::CreateControlError)
    pub fn create_control(&self) -> fluent_builders::CreateControl {
        fluent_builders::CreateControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssessment`](crate::client::fluent_builders::DeleteAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::DeleteAssessment::set_assessment_id): <p> The identifier for the assessment. </p>
    /// - On success, responds with [`DeleteAssessmentOutput`](crate::output::DeleteAssessmentOutput)

    /// - On failure, responds with [`SdkError<DeleteAssessmentError>`](crate::error::DeleteAssessmentError)
    pub fn delete_assessment(&self) -> fluent_builders::DeleteAssessment {
        fluent_builders::DeleteAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssessmentFramework`](crate::client::fluent_builders::DeleteAssessmentFramework) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`framework_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessmentFramework::framework_id) / [`set_framework_id(Option<String>)`](crate::client::fluent_builders::DeleteAssessmentFramework::set_framework_id): <p> The identifier for the custom framework. </p>
    /// - On success, responds with [`DeleteAssessmentFrameworkOutput`](crate::output::DeleteAssessmentFrameworkOutput)

    /// - On failure, responds with [`SdkError<DeleteAssessmentFrameworkError>`](crate::error::DeleteAssessmentFrameworkError)
    pub fn delete_assessment_framework(&self) -> fluent_builders::DeleteAssessmentFramework {
        fluent_builders::DeleteAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssessmentFrameworkShare`](crate::client::fluent_builders::DeleteAssessmentFrameworkShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`request_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessmentFrameworkShare::request_id) / [`set_request_id(Option<String>)`](crate::client::fluent_builders::DeleteAssessmentFrameworkShare::set_request_id): <p>The unique identifier for the share request to be deleted.</p>
    ///   - [`request_type(ShareRequestType)`](crate::client::fluent_builders::DeleteAssessmentFrameworkShare::request_type) / [`set_request_type(Option<ShareRequestType>)`](crate::client::fluent_builders::DeleteAssessmentFrameworkShare::set_request_type): <p>Specifies whether the share request is a sent request or a received request.</p>
    /// - On success, responds with [`DeleteAssessmentFrameworkShareOutput`](crate::output::DeleteAssessmentFrameworkShareOutput)

    /// - On failure, responds with [`SdkError<DeleteAssessmentFrameworkShareError>`](crate::error::DeleteAssessmentFrameworkShareError)
    pub fn delete_assessment_framework_share(
        &self,
    ) -> fluent_builders::DeleteAssessmentFrameworkShare {
        fluent_builders::DeleteAssessmentFrameworkShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAssessmentReport`](crate::client::fluent_builders::DeleteAssessmentReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessmentReport::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::DeleteAssessmentReport::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`assessment_report_id(impl Into<String>)`](crate::client::fluent_builders::DeleteAssessmentReport::assessment_report_id) / [`set_assessment_report_id(Option<String>)`](crate::client::fluent_builders::DeleteAssessmentReport::set_assessment_report_id): <p> The unique identifier for the assessment report. </p>
    /// - On success, responds with [`DeleteAssessmentReportOutput`](crate::output::DeleteAssessmentReportOutput)

    /// - On failure, responds with [`SdkError<DeleteAssessmentReportError>`](crate::error::DeleteAssessmentReportError)
    pub fn delete_assessment_report(&self) -> fluent_builders::DeleteAssessmentReport {
        fluent_builders::DeleteAssessmentReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteControl`](crate::client::fluent_builders::DeleteControl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`control_id(impl Into<String>)`](crate::client::fluent_builders::DeleteControl::control_id) / [`set_control_id(Option<String>)`](crate::client::fluent_builders::DeleteControl::set_control_id): <p> The unique identifier for the control. </p>
    /// - On success, responds with [`DeleteControlOutput`](crate::output::DeleteControlOutput)

    /// - On failure, responds with [`SdkError<DeleteControlError>`](crate::error::DeleteControlError)
    pub fn delete_control(&self) -> fluent_builders::DeleteControl {
        fluent_builders::DeleteControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterAccount`](crate::client::fluent_builders::DeregisterAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeregisterAccount::send) it.

    /// - On success, responds with [`DeregisterAccountOutput`](crate::output::DeregisterAccountOutput) with field(s):
    ///   - [`status(Option<AccountStatus>)`](crate::output::DeregisterAccountOutput::status): <p> The registration status of the account. </p>
    /// - On failure, responds with [`SdkError<DeregisterAccountError>`](crate::error::DeregisterAccountError)
    pub fn deregister_account(&self) -> fluent_builders::DeregisterAccount {
        fluent_builders::DeregisterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterOrganizationAdminAccount`](crate::client::fluent_builders::DeregisterOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_account_id(impl Into<String>)`](crate::client::fluent_builders::DeregisterOrganizationAdminAccount::admin_account_id) / [`set_admin_account_id(Option<String>)`](crate::client::fluent_builders::DeregisterOrganizationAdminAccount::set_admin_account_id): <p> The identifier for the administrator account. </p>
    /// - On success, responds with [`DeregisterOrganizationAdminAccountOutput`](crate::output::DeregisterOrganizationAdminAccountOutput)

    /// - On failure, responds with [`SdkError<DeregisterOrganizationAdminAccountError>`](crate::error::DeregisterOrganizationAdminAccountError)
    pub fn deregister_organization_admin_account(
        &self,
    ) -> fluent_builders::DeregisterOrganizationAdminAccount {
        fluent_builders::DeregisterOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateAssessmentReportEvidenceFolder`](crate::client::fluent_builders::DisassociateAssessmentReportEvidenceFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateAssessmentReportEvidenceFolder::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::DisassociateAssessmentReportEvidenceFolder::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`evidence_folder_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateAssessmentReportEvidenceFolder::evidence_folder_id) / [`set_evidence_folder_id(Option<String>)`](crate::client::fluent_builders::DisassociateAssessmentReportEvidenceFolder::set_evidence_folder_id): <p> The unique identifier for the folder that the evidence is stored in. </p>
    /// - On success, responds with [`DisassociateAssessmentReportEvidenceFolderOutput`](crate::output::DisassociateAssessmentReportEvidenceFolderOutput)

    /// - On failure, responds with [`SdkError<DisassociateAssessmentReportEvidenceFolderError>`](crate::error::DisassociateAssessmentReportEvidenceFolderError)
    pub fn disassociate_assessment_report_evidence_folder(
        &self,
    ) -> fluent_builders::DisassociateAssessmentReportEvidenceFolder {
        fluent_builders::DisassociateAssessmentReportEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccountStatus`](crate::client::fluent_builders::GetAccountStatus) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAccountStatus::send) it.

    /// - On success, responds with [`GetAccountStatusOutput`](crate::output::GetAccountStatusOutput) with field(s):
    ///   - [`status(Option<AccountStatus>)`](crate::output::GetAccountStatusOutput::status): <p> The status of the Amazon Web Services account. </p>
    /// - On failure, responds with [`SdkError<GetAccountStatusError>`](crate::error::GetAccountStatusError)
    pub fn get_account_status(&self) -> fluent_builders::GetAccountStatus {
        fluent_builders::GetAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssessment`](crate::client::fluent_builders::GetAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetAssessment::set_assessment_id): <p>The unique identifier for the assessment. </p>
    /// - On success, responds with [`GetAssessmentOutput`](crate::output::GetAssessmentOutput) with field(s):
    ///   - [`assessment(Option<Assessment>)`](crate::output::GetAssessmentOutput::assessment): <p> An entity that defines the scope of audit evidence collected by Audit Manager. An Audit Manager assessment is an implementation of an Audit Manager framework. </p>
    ///   - [`user_role(Option<Role>)`](crate::output::GetAssessmentOutput::user_role): <p> The wrapper that contains the Audit Manager role information of the current user. This includes the role type and IAM Amazon Resource Name (ARN). </p>
    /// - On failure, responds with [`SdkError<GetAssessmentError>`](crate::error::GetAssessmentError)
    pub fn get_assessment(&self) -> fluent_builders::GetAssessment {
        fluent_builders::GetAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssessmentFramework`](crate::client::fluent_builders::GetAssessmentFramework) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`framework_id(impl Into<String>)`](crate::client::fluent_builders::GetAssessmentFramework::framework_id) / [`set_framework_id(Option<String>)`](crate::client::fluent_builders::GetAssessmentFramework::set_framework_id): <p> The identifier for the framework. </p>
    /// - On success, responds with [`GetAssessmentFrameworkOutput`](crate::output::GetAssessmentFrameworkOutput) with field(s):
    ///   - [`framework(Option<Framework>)`](crate::output::GetAssessmentFrameworkOutput::framework): <p> The framework that the <code>GetAssessmentFramework</code> API returned. </p>
    /// - On failure, responds with [`SdkError<GetAssessmentFrameworkError>`](crate::error::GetAssessmentFrameworkError)
    pub fn get_assessment_framework(&self) -> fluent_builders::GetAssessmentFramework {
        fluent_builders::GetAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAssessmentReportUrl`](crate::client::fluent_builders::GetAssessmentReportUrl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_report_id(impl Into<String>)`](crate::client::fluent_builders::GetAssessmentReportUrl::assessment_report_id) / [`set_assessment_report_id(Option<String>)`](crate::client::fluent_builders::GetAssessmentReportUrl::set_assessment_report_id): <p> The unique identifier for the assessment report. </p>
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetAssessmentReportUrl::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetAssessmentReportUrl::set_assessment_id): <p> The unique identifier for the assessment. </p>
    /// - On success, responds with [`GetAssessmentReportUrlOutput`](crate::output::GetAssessmentReportUrlOutput) with field(s):
    ///   - [`pre_signed_url(Option<Url>)`](crate::output::GetAssessmentReportUrlOutput::pre_signed_url): <p> Short for uniform resource locator. A URL is used as a unique identifier to locate a resource on the internet. </p>
    /// - On failure, responds with [`SdkError<GetAssessmentReportUrlError>`](crate::error::GetAssessmentReportUrlError)
    pub fn get_assessment_report_url(&self) -> fluent_builders::GetAssessmentReportUrl {
        fluent_builders::GetAssessmentReportUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetChangeLogs`](crate::client::fluent_builders::GetChangeLogs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetChangeLogs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetChangeLogs::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetChangeLogs::set_assessment_id): <p>The unique identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::GetChangeLogs::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::GetChangeLogs::set_control_set_id): <p> The unique identifier for the control set. </p>
    ///   - [`control_id(impl Into<String>)`](crate::client::fluent_builders::GetChangeLogs::control_id) / [`set_control_id(Option<String>)`](crate::client::fluent_builders::GetChangeLogs::set_control_id): <p> The unique identifier for the control. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetChangeLogs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetChangeLogs::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetChangeLogs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetChangeLogs::set_max_results): <p>Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`GetChangeLogsOutput`](crate::output::GetChangeLogsOutput) with field(s):
    ///   - [`change_logs(Option<Vec<ChangeLog>>)`](crate::output::GetChangeLogsOutput::change_logs): <p>The list of user activity for the control. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetChangeLogsOutput::next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<GetChangeLogsError>`](crate::error::GetChangeLogsError)
    pub fn get_change_logs(&self) -> fluent_builders::GetChangeLogs {
        fluent_builders::GetChangeLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetControl`](crate::client::fluent_builders::GetControl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`control_id(impl Into<String>)`](crate::client::fluent_builders::GetControl::control_id) / [`set_control_id(Option<String>)`](crate::client::fluent_builders::GetControl::set_control_id): <p> The identifier for the control. </p>
    /// - On success, responds with [`GetControlOutput`](crate::output::GetControlOutput) with field(s):
    ///   - [`control(Option<Control>)`](crate::output::GetControlOutput::control): <p> The name of the control that the <code>GetControl</code> API returned. </p>
    /// - On failure, responds with [`SdkError<GetControlError>`](crate::error::GetControlError)
    pub fn get_control(&self) -> fluent_builders::GetControl {
        fluent_builders::GetControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDelegations`](crate::client::fluent_builders::GetDelegations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDelegations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDelegations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDelegations::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDelegations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetDelegations::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`GetDelegationsOutput`](crate::output::GetDelegationsOutput) with field(s):
    ///   - [`delegations(Option<Vec<DelegationMetadata>>)`](crate::output::GetDelegationsOutput::delegations): <p> The list of delegations that the <code>GetDelegations</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDelegationsOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<GetDelegationsError>`](crate::error::GetDelegationsError)
    pub fn get_delegations(&self) -> fluent_builders::GetDelegations {
        fluent_builders::GetDelegations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEvidence`](crate::client::fluent_builders::GetEvidence) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidence::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetEvidence::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidence::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::GetEvidence::set_control_set_id): <p> The unique identifier for the control set. </p>
    ///   - [`evidence_folder_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidence::evidence_folder_id) / [`set_evidence_folder_id(Option<String>)`](crate::client::fluent_builders::GetEvidence::set_evidence_folder_id): <p> The unique identifier for the folder that the evidence is stored in. </p>
    ///   - [`evidence_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidence::evidence_id) / [`set_evidence_id(Option<String>)`](crate::client::fluent_builders::GetEvidence::set_evidence_id): <p> The unique identifier for the evidence. </p>
    /// - On success, responds with [`GetEvidenceOutput`](crate::output::GetEvidenceOutput) with field(s):
    ///   - [`evidence(Option<Evidence>)`](crate::output::GetEvidenceOutput::evidence): <p> The evidence that the <code>GetEvidenceResponse</code> API returned. </p>
    /// - On failure, responds with [`SdkError<GetEvidenceError>`](crate::error::GetEvidenceError)
    pub fn get_evidence(&self) -> fluent_builders::GetEvidence {
        fluent_builders::GetEvidence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEvidenceByEvidenceFolder`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::set_assessment_id): <p> The identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::set_control_set_id): <p> The identifier for the control set. </p>
    ///   - [`evidence_folder_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::evidence_folder_id) / [`set_evidence_folder_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::set_evidence_folder_id): <p> The unique identifier for the folder that the evidence is stored in. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`GetEvidenceByEvidenceFolderOutput`](crate::output::GetEvidenceByEvidenceFolderOutput) with field(s):
    ///   - [`evidence(Option<Vec<Evidence>>)`](crate::output::GetEvidenceByEvidenceFolderOutput::evidence): <p> The list of evidence that the <code>GetEvidenceByEvidenceFolder</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetEvidenceByEvidenceFolderOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<GetEvidenceByEvidenceFolderError>`](crate::error::GetEvidenceByEvidenceFolderError)
    pub fn get_evidence_by_evidence_folder(&self) -> fluent_builders::GetEvidenceByEvidenceFolder {
        fluent_builders::GetEvidenceByEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEvidenceFolder`](crate::client::fluent_builders::GetEvidenceFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFolder::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceFolder::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFolder::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceFolder::set_control_set_id): <p> The unique identifier for the control set. </p>
    ///   - [`evidence_folder_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFolder::evidence_folder_id) / [`set_evidence_folder_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceFolder::set_evidence_folder_id): <p> The unique identifier for the folder that the evidence is stored in. </p>
    /// - On success, responds with [`GetEvidenceFolderOutput`](crate::output::GetEvidenceFolderOutput) with field(s):
    ///   - [`evidence_folder(Option<AssessmentEvidenceFolder>)`](crate::output::GetEvidenceFolderOutput::evidence_folder): <p> The folder that the evidence is stored in. </p>
    /// - On failure, responds with [`SdkError<GetEvidenceFolderError>`](crate::error::GetEvidenceFolderError)
    pub fn get_evidence_folder(&self) -> fluent_builders::GetEvidenceFolder {
        fluent_builders::GetEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEvidenceFoldersByAssessment`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`GetEvidenceFoldersByAssessmentOutput`](crate::output::GetEvidenceFoldersByAssessmentOutput) with field(s):
    ///   - [`evidence_folders(Option<Vec<AssessmentEvidenceFolder>>)`](crate::output::GetEvidenceFoldersByAssessmentOutput::evidence_folders): <p> The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetEvidenceFoldersByAssessmentOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<GetEvidenceFoldersByAssessmentError>`](crate::error::GetEvidenceFoldersByAssessmentError)
    pub fn get_evidence_folders_by_assessment(
        &self,
    ) -> fluent_builders::GetEvidenceFoldersByAssessment {
        fluent_builders::GetEvidenceFoldersByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEvidenceFoldersByAssessmentControl`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::set_assessment_id): <p> The identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::set_control_set_id): <p> The identifier for the control set. </p>
    ///   - [`control_id(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::control_id) / [`set_control_id(Option<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::set_control_id): <p> The identifier for the control. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`GetEvidenceFoldersByAssessmentControlOutput`](crate::output::GetEvidenceFoldersByAssessmentControlOutput) with field(s):
    ///   - [`evidence_folders(Option<Vec<AssessmentEvidenceFolder>>)`](crate::output::GetEvidenceFoldersByAssessmentControlOutput::evidence_folders): <p> The list of evidence folders that the <code>GetEvidenceFoldersByAssessmentControl</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetEvidenceFoldersByAssessmentControlOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<GetEvidenceFoldersByAssessmentControlError>`](crate::error::GetEvidenceFoldersByAssessmentControlError)
    pub fn get_evidence_folders_by_assessment_control(
        &self,
    ) -> fluent_builders::GetEvidenceFoldersByAssessmentControl {
        fluent_builders::GetEvidenceFoldersByAssessmentControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsights`](crate::client::fluent_builders::GetInsights) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetInsights::send) it.

    /// - On success, responds with [`GetInsightsOutput`](crate::output::GetInsightsOutput) with field(s):
    ///   - [`insights(Option<Insights>)`](crate::output::GetInsightsOutput::insights): <p>The analytics data that the <code>GetInsights</code> API returned. </p>
    /// - On failure, responds with [`SdkError<GetInsightsError>`](crate::error::GetInsightsError)
    pub fn get_insights(&self) -> fluent_builders::GetInsights {
        fluent_builders::GetInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInsightsByAssessment`](crate::client::fluent_builders::GetInsightsByAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::GetInsightsByAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::GetInsightsByAssessment::set_assessment_id): <p>The unique identifier for the assessment. </p>
    /// - On success, responds with [`GetInsightsByAssessmentOutput`](crate::output::GetInsightsByAssessmentOutput) with field(s):
    ///   - [`insights(Option<InsightsByAssessment>)`](crate::output::GetInsightsByAssessmentOutput::insights): <p> The assessment analytics data that the <code>GetInsightsByAssessment</code> API returned. </p>
    /// - On failure, responds with [`SdkError<GetInsightsByAssessmentError>`](crate::error::GetInsightsByAssessmentError)
    pub fn get_insights_by_assessment(&self) -> fluent_builders::GetInsightsByAssessment {
        fluent_builders::GetInsightsByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetOrganizationAdminAccount`](crate::client::fluent_builders::GetOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetOrganizationAdminAccount::send) it.

    /// - On success, responds with [`GetOrganizationAdminAccountOutput`](crate::output::GetOrganizationAdminAccountOutput) with field(s):
    ///   - [`admin_account_id(Option<String>)`](crate::output::GetOrganizationAdminAccountOutput::admin_account_id): <p> The identifier for the administrator account. </p>
    ///   - [`organization_id(Option<String>)`](crate::output::GetOrganizationAdminAccountOutput::organization_id): <p> The identifier for the organization. </p>
    /// - On failure, responds with [`SdkError<GetOrganizationAdminAccountError>`](crate::error::GetOrganizationAdminAccountError)
    pub fn get_organization_admin_account(&self) -> fluent_builders::GetOrganizationAdminAccount {
        fluent_builders::GetOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServicesInScope`](crate::client::fluent_builders::GetServicesInScope) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetServicesInScope::send) it.

    /// - On success, responds with [`GetServicesInScopeOutput`](crate::output::GetServicesInScopeOutput) with field(s):
    ///   - [`service_metadata(Option<Vec<ServiceMetadata>>)`](crate::output::GetServicesInScopeOutput::service_metadata): <p> The metadata that's associated with the Amazon Web Service. </p>
    /// - On failure, responds with [`SdkError<GetServicesInScopeError>`](crate::error::GetServicesInScopeError)
    pub fn get_services_in_scope(&self) -> fluent_builders::GetServicesInScope {
        fluent_builders::GetServicesInScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSettings`](crate::client::fluent_builders::GetSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute(SettingAttribute)`](crate::client::fluent_builders::GetSettings::attribute) / [`set_attribute(Option<SettingAttribute>)`](crate::client::fluent_builders::GetSettings::set_attribute): <p> The list of <code>SettingAttribute</code> enum values. </p>
    /// - On success, responds with [`GetSettingsOutput`](crate::output::GetSettingsOutput) with field(s):
    ///   - [`settings(Option<Settings>)`](crate::output::GetSettingsOutput::settings): <p> The settings object that holds all supported Audit Manager settings. </p>
    /// - On failure, responds with [`SdkError<GetSettingsError>`](crate::error::GetSettingsError)
    pub fn get_settings(&self) -> fluent_builders::GetSettings {
        fluent_builders::GetSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentControlInsightsByControlDomain`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`control_domain_id(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::control_domain_id) / [`set_control_domain_id(Option<String>)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::set_control_domain_id): <p>The unique identifier for the control domain. </p>
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::set_assessment_id): <p>The unique identifier for the active assessment. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::set_next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentControlInsightsByControlDomain::set_max_results): <p>Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListAssessmentControlInsightsByControlDomainOutput`](crate::output::ListAssessmentControlInsightsByControlDomainOutput) with field(s):
    ///   - [`control_insights_by_assessment(Option<Vec<ControlInsightsMetadataByAssessmentItem>>)`](crate::output::ListAssessmentControlInsightsByControlDomainOutput::control_insights_by_assessment): <p>The assessment control analytics data that the <code>ListAssessmentControlInsightsByControlDomain</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentControlInsightsByControlDomainOutput::next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListAssessmentControlInsightsByControlDomainError>`](crate::error::ListAssessmentControlInsightsByControlDomainError)
    pub fn list_assessment_control_insights_by_control_domain(
        &self,
    ) -> fluent_builders::ListAssessmentControlInsightsByControlDomain {
        fluent_builders::ListAssessmentControlInsightsByControlDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentFrameworks`](crate::client::fluent_builders::ListAssessmentFrameworks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentFrameworks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`framework_type(FrameworkType)`](crate::client::fluent_builders::ListAssessmentFrameworks::framework_type) / [`set_framework_type(Option<FrameworkType>)`](crate::client::fluent_builders::ListAssessmentFrameworks::set_framework_type): <p> The type of framework, such as a standard framework or a custom framework. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentFrameworks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentFrameworks::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentFrameworks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentFrameworks::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListAssessmentFrameworksOutput`](crate::output::ListAssessmentFrameworksOutput) with field(s):
    ///   - [`framework_metadata_list(Option<Vec<AssessmentFrameworkMetadata>>)`](crate::output::ListAssessmentFrameworksOutput::framework_metadata_list): <p> The list of metadata objects for the framework. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentFrameworksOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListAssessmentFrameworksError>`](crate::error::ListAssessmentFrameworksError)
    pub fn list_assessment_frameworks(&self) -> fluent_builders::ListAssessmentFrameworks {
        fluent_builders::ListAssessmentFrameworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentFrameworkShareRequests`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`request_type(ShareRequestType)`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests::request_type) / [`set_request_type(Option<ShareRequestType>)`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests::set_request_type): <p> Specifies whether the share request is a sent request or a received request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentFrameworkShareRequests::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListAssessmentFrameworkShareRequestsOutput`](crate::output::ListAssessmentFrameworkShareRequestsOutput) with field(s):
    ///   - [`assessment_framework_share_requests(Option<Vec<AssessmentFrameworkShareRequest>>)`](crate::output::ListAssessmentFrameworkShareRequestsOutput::assessment_framework_share_requests): <p> The list of share requests that the <code>ListAssessmentFrameworkShareRequests</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentFrameworkShareRequestsOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListAssessmentFrameworkShareRequestsError>`](crate::error::ListAssessmentFrameworkShareRequestsError)
    pub fn list_assessment_framework_share_requests(
        &self,
    ) -> fluent_builders::ListAssessmentFrameworkShareRequests {
        fluent_builders::ListAssessmentFrameworkShareRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessmentReports`](crate::client::fluent_builders::ListAssessmentReports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessmentReports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessmentReports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessmentReports::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessmentReports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessmentReports::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListAssessmentReportsOutput`](crate::output::ListAssessmentReportsOutput) with field(s):
    ///   - [`assessment_reports(Option<Vec<AssessmentReportMetadata>>)`](crate::output::ListAssessmentReportsOutput::assessment_reports): <p> The list of assessment reports that the <code>ListAssessmentReports</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentReportsOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListAssessmentReportsError>`](crate::error::ListAssessmentReportsError)
    pub fn list_assessment_reports(&self) -> fluent_builders::ListAssessmentReports {
        fluent_builders::ListAssessmentReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssessments`](crate::client::fluent_builders::ListAssessments) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssessments::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`status(AssessmentStatus)`](crate::client::fluent_builders::ListAssessments::status) / [`set_status(Option<AssessmentStatus>)`](crate::client::fluent_builders::ListAssessments::set_status): <p> The current status of the assessment.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssessments::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssessments::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssessments::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssessments::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListAssessmentsOutput`](crate::output::ListAssessmentsOutput) with field(s):
    ///   - [`assessment_metadata(Option<Vec<AssessmentMetadataItem>>)`](crate::output::ListAssessmentsOutput::assessment_metadata): <p> The metadata that's associated with the assessment. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssessmentsOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListAssessmentsError>`](crate::error::ListAssessmentsError)
    pub fn list_assessments(&self) -> fluent_builders::ListAssessments {
        fluent_builders::ListAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListControlDomainInsights`](crate::client::fluent_builders::ListControlDomainInsights) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListControlDomainInsights::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListControlDomainInsights::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListControlDomainInsights::set_next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListControlDomainInsights::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListControlDomainInsights::set_max_results): <p>Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListControlDomainInsightsOutput`](crate::output::ListControlDomainInsightsOutput) with field(s):
    ///   - [`control_domain_insights(Option<Vec<ControlDomainInsights>>)`](crate::output::ListControlDomainInsightsOutput::control_domain_insights): <p>The control domain analytics data that the <code>ListControlDomainInsights</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListControlDomainInsightsOutput::next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListControlDomainInsightsError>`](crate::error::ListControlDomainInsightsError)
    pub fn list_control_domain_insights(&self) -> fluent_builders::ListControlDomainInsights {
        fluent_builders::ListControlDomainInsights::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListControlDomainInsightsByAssessment`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment::set_assessment_id): <p>The unique identifier for the active assessment. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment::set_next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListControlDomainInsightsByAssessment::set_max_results): <p>Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListControlDomainInsightsByAssessmentOutput`](crate::output::ListControlDomainInsightsByAssessmentOutput) with field(s):
    ///   - [`control_domain_insights(Option<Vec<ControlDomainInsights>>)`](crate::output::ListControlDomainInsightsByAssessmentOutput::control_domain_insights): <p>The control domain analytics data that the <code>ListControlDomainInsightsByAssessment</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListControlDomainInsightsByAssessmentOutput::next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListControlDomainInsightsByAssessmentError>`](crate::error::ListControlDomainInsightsByAssessmentError)
    pub fn list_control_domain_insights_by_assessment(
        &self,
    ) -> fluent_builders::ListControlDomainInsightsByAssessment {
        fluent_builders::ListControlDomainInsightsByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListControlInsightsByControlDomain`](crate::client::fluent_builders::ListControlInsightsByControlDomain) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListControlInsightsByControlDomain::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`control_domain_id(impl Into<String>)`](crate::client::fluent_builders::ListControlInsightsByControlDomain::control_domain_id) / [`set_control_domain_id(Option<String>)`](crate::client::fluent_builders::ListControlInsightsByControlDomain::set_control_domain_id): <p>The unique identifier for the control domain. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListControlInsightsByControlDomain::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListControlInsightsByControlDomain::set_next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListControlInsightsByControlDomain::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListControlInsightsByControlDomain::set_max_results): <p>Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListControlInsightsByControlDomainOutput`](crate::output::ListControlInsightsByControlDomainOutput) with field(s):
    ///   - [`control_insights_metadata(Option<Vec<ControlInsightsMetadataItem>>)`](crate::output::ListControlInsightsByControlDomainOutput::control_insights_metadata): <p>The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListControlInsightsByControlDomainOutput::next_token): <p>The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListControlInsightsByControlDomainError>`](crate::error::ListControlInsightsByControlDomainError)
    pub fn list_control_insights_by_control_domain(
        &self,
    ) -> fluent_builders::ListControlInsightsByControlDomain {
        fluent_builders::ListControlInsightsByControlDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListControls`](crate::client::fluent_builders::ListControls) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListControls::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`control_type(ControlType)`](crate::client::fluent_builders::ListControls::control_type) / [`set_control_type(Option<ControlType>)`](crate::client::fluent_builders::ListControls::set_control_type): <p> The type of control, such as a standard control or a custom control. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListControls::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListControls::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListControls::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListControls::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListControlsOutput`](crate::output::ListControlsOutput) with field(s):
    ///   - [`control_metadata_list(Option<Vec<ControlMetadata>>)`](crate::output::ListControlsOutput::control_metadata_list): <p> The list of control metadata objects that the <code>ListControls</code> API returned. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListControlsOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListControlsError>`](crate::error::ListControlsError)
    pub fn list_controls(&self) -> fluent_builders::ListControls {
        fluent_builders::ListControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListKeywordsForDataSource`](crate::client::fluent_builders::ListKeywordsForDataSource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListKeywordsForDataSource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`source(SourceType)`](crate::client::fluent_builders::ListKeywordsForDataSource::source) / [`set_source(Option<SourceType>)`](crate::client::fluent_builders::ListKeywordsForDataSource::set_source): <p> The control mapping data source that the keywords apply to. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListKeywordsForDataSource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListKeywordsForDataSource::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListKeywordsForDataSource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListKeywordsForDataSource::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListKeywordsForDataSourceOutput`](crate::output::ListKeywordsForDataSourceOutput) with field(s):
    ///   - [`keywords(Option<Vec<String>>)`](crate::output::ListKeywordsForDataSourceOutput::keywords): <p> The list of keywords for the event mapping source. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListKeywordsForDataSourceOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListKeywordsForDataSourceError>`](crate::error::ListKeywordsForDataSourceError)
    pub fn list_keywords_for_data_source(&self) -> fluent_builders::ListKeywordsForDataSource {
        fluent_builders::ListKeywordsForDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNotifications`](crate::client::fluent_builders::ListNotifications) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNotifications::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNotifications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNotifications::set_next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNotifications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNotifications::set_max_results): <p> Represents the maximum number of results on a page or for an API request call. </p>
    /// - On success, responds with [`ListNotificationsOutput`](crate::output::ListNotificationsOutput) with field(s):
    ///   - [`notifications(Option<Vec<Notification>>)`](crate::output::ListNotificationsOutput::notifications): <p> The returned list of notifications. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNotificationsOutput::next_token): <p> The pagination token that's used to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListNotificationsError>`](crate::error::ListNotificationsError)
    pub fn list_notifications(&self) -> fluent_builders::ListNotifications {
        fluent_builders::ListNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the resource. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p> The list of tags that the <code>ListTagsForResource</code> API returned. </p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterAccount`](crate::client::fluent_builders::RegisterAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::RegisterAccount::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::RegisterAccount::set_kms_key): <p> The KMS key details. </p>
    ///   - [`delegated_admin_account(impl Into<String>)`](crate::client::fluent_builders::RegisterAccount::delegated_admin_account) / [`set_delegated_admin_account(Option<String>)`](crate::client::fluent_builders::RegisterAccount::set_delegated_admin_account): <p> The delegated administrator account for Audit Manager. </p>
    /// - On success, responds with [`RegisterAccountOutput`](crate::output::RegisterAccountOutput) with field(s):
    ///   - [`status(Option<AccountStatus>)`](crate::output::RegisterAccountOutput::status): <p> The status of the account registration request. </p>
    /// - On failure, responds with [`SdkError<RegisterAccountError>`](crate::error::RegisterAccountError)
    pub fn register_account(&self) -> fluent_builders::RegisterAccount {
        fluent_builders::RegisterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterOrganizationAdminAccount`](crate::client::fluent_builders::RegisterOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_account_id(impl Into<String>)`](crate::client::fluent_builders::RegisterOrganizationAdminAccount::admin_account_id) / [`set_admin_account_id(Option<String>)`](crate::client::fluent_builders::RegisterOrganizationAdminAccount::set_admin_account_id): <p> The identifier for the delegated administrator account. </p>
    /// - On success, responds with [`RegisterOrganizationAdminAccountOutput`](crate::output::RegisterOrganizationAdminAccountOutput) with field(s):
    ///   - [`admin_account_id(Option<String>)`](crate::output::RegisterOrganizationAdminAccountOutput::admin_account_id): <p> The identifier for the delegated administrator account. </p>
    ///   - [`organization_id(Option<String>)`](crate::output::RegisterOrganizationAdminAccountOutput::organization_id): <p> The identifier for the organization. </p>
    /// - On failure, responds with [`SdkError<RegisterOrganizationAdminAccountError>`](crate::error::RegisterOrganizationAdminAccountError)
    pub fn register_organization_admin_account(
        &self,
    ) -> fluent_builders::RegisterOrganizationAdminAccount {
        fluent_builders::RegisterOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartAssessmentFrameworkShare`](crate::client::fluent_builders::StartAssessmentFrameworkShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`framework_id(impl Into<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::framework_id) / [`set_framework_id(Option<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::set_framework_id): <p> The unique identifier for the custom framework to be shared. </p>
    ///   - [`destination_account(impl Into<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::destination_account) / [`set_destination_account(Option<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::set_destination_account): <p> The Amazon Web Services account of the recipient. </p>
    ///   - [`destination_region(impl Into<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::destination_region) / [`set_destination_region(Option<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::set_destination_region): <p> The Amazon Web Services Region of the recipient. </p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::StartAssessmentFrameworkShare::set_comment): <p> An optional comment from the sender about the share request. </p>
    /// - On success, responds with [`StartAssessmentFrameworkShareOutput`](crate::output::StartAssessmentFrameworkShareOutput) with field(s):
    ///   - [`assessment_framework_share_request(Option<AssessmentFrameworkShareRequest>)`](crate::output::StartAssessmentFrameworkShareOutput::assessment_framework_share_request): <p> The share request that's created by the <code>StartAssessmentFrameworkShare</code> API. </p>
    /// - On failure, responds with [`SdkError<StartAssessmentFrameworkShareError>`](crate::error::StartAssessmentFrameworkShareError)
    pub fn start_assessment_framework_share(
        &self,
    ) -> fluent_builders::StartAssessmentFrameworkShare {
        fluent_builders::StartAssessmentFrameworkShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the resource. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p> The tags that are associated with the resource. </p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p> The Amazon Resource Name (ARN) of the specified resource. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p> The name or key of the tag. </p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssessment`](crate::client::fluent_builders::UpdateAssessment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessment::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessment::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`assessment_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessment::assessment_name) / [`set_assessment_name(Option<String>)`](crate::client::fluent_builders::UpdateAssessment::set_assessment_name): <p> The name of the assessment to be updated. </p>
    ///   - [`assessment_description(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessment::assessment_description) / [`set_assessment_description(Option<String>)`](crate::client::fluent_builders::UpdateAssessment::set_assessment_description): <p> The description of the assessment. </p>
    ///   - [`scope(Scope)`](crate::client::fluent_builders::UpdateAssessment::scope) / [`set_scope(Option<Scope>)`](crate::client::fluent_builders::UpdateAssessment::set_scope): <p> The scope of the assessment. </p>
    ///   - [`assessment_reports_destination(AssessmentReportsDestination)`](crate::client::fluent_builders::UpdateAssessment::assessment_reports_destination) / [`set_assessment_reports_destination(Option<AssessmentReportsDestination>)`](crate::client::fluent_builders::UpdateAssessment::set_assessment_reports_destination): <p> The assessment report storage destination for the assessment that's being updated. </p>
    ///   - [`roles(Vec<Role>)`](crate::client::fluent_builders::UpdateAssessment::roles) / [`set_roles(Option<Vec<Role>>)`](crate::client::fluent_builders::UpdateAssessment::set_roles): <p> The list of roles for the assessment. </p>
    /// - On success, responds with [`UpdateAssessmentOutput`](crate::output::UpdateAssessmentOutput) with field(s):
    ///   - [`assessment(Option<Assessment>)`](crate::output::UpdateAssessmentOutput::assessment): <p> The response object for the <code>UpdateAssessmentRequest</code> API. This is the name of the updated assessment.</p>
    /// - On failure, responds with [`SdkError<UpdateAssessmentError>`](crate::error::UpdateAssessmentError)
    pub fn update_assessment(&self) -> fluent_builders::UpdateAssessment {
        fluent_builders::UpdateAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssessmentControl`](crate::client::fluent_builders::UpdateAssessmentControl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::set_control_set_id): <p> The unique identifier for the control set. </p>
    ///   - [`control_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::control_id) / [`set_control_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::set_control_id): <p> The unique identifier for the control. </p>
    ///   - [`control_status(ControlStatus)`](crate::client::fluent_builders::UpdateAssessmentControl::control_status) / [`set_control_status(Option<ControlStatus>)`](crate::client::fluent_builders::UpdateAssessmentControl::set_control_status): <p> The status of the control. </p>
    ///   - [`comment_body(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::comment_body) / [`set_comment_body(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentControl::set_comment_body): <p> The comment body text for the control. </p>
    /// - On success, responds with [`UpdateAssessmentControlOutput`](crate::output::UpdateAssessmentControlOutput) with field(s):
    ///   - [`control(Option<AssessmentControl>)`](crate::output::UpdateAssessmentControlOutput::control): <p> The name of the updated control set that the <code>UpdateAssessmentControl</code> API returned. </p>
    /// - On failure, responds with [`SdkError<UpdateAssessmentControlError>`](crate::error::UpdateAssessmentControlError)
    pub fn update_assessment_control(&self) -> fluent_builders::UpdateAssessmentControl {
        fluent_builders::UpdateAssessmentControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssessmentControlSetStatus`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`control_set_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::control_set_id) / [`set_control_set_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::set_control_set_id): <p> The unique identifier for the control set. </p>
    ///   - [`status(ControlSetStatus)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::status) / [`set_status(Option<ControlSetStatus>)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::set_status): <p> The status of the control set that's being updated. </p>
    ///   - [`comment(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::comment) / [`set_comment(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus::set_comment): <p> The comment that's related to the status update. </p>
    /// - On success, responds with [`UpdateAssessmentControlSetStatusOutput`](crate::output::UpdateAssessmentControlSetStatusOutput) with field(s):
    ///   - [`control_set(Option<AssessmentControlSet>)`](crate::output::UpdateAssessmentControlSetStatusOutput::control_set): <p> The name of the updated control set that the <code>UpdateAssessmentControlSetStatus</code> API returned. </p>
    /// - On failure, responds with [`SdkError<UpdateAssessmentControlSetStatusError>`](crate::error::UpdateAssessmentControlSetStatusError)
    pub fn update_assessment_control_set_status(
        &self,
    ) -> fluent_builders::UpdateAssessmentControlSetStatus {
        fluent_builders::UpdateAssessmentControlSetStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssessmentFramework`](crate::client::fluent_builders::UpdateAssessmentFramework) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`framework_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::framework_id) / [`set_framework_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::set_framework_id): <p> The unique identifier for the framework. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::set_name): <p> The name of the framework to be updated. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::set_description): <p> The description of the updated framework. </p>
    ///   - [`compliance_type(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::compliance_type) / [`set_compliance_type(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentFramework::set_compliance_type): <p> The compliance type that the new custom framework supports, such as CIS or HIPAA. </p>
    ///   - [`control_sets(Vec<UpdateAssessmentFrameworkControlSet>)`](crate::client::fluent_builders::UpdateAssessmentFramework::control_sets) / [`set_control_sets(Option<Vec<UpdateAssessmentFrameworkControlSet>>)`](crate::client::fluent_builders::UpdateAssessmentFramework::set_control_sets): <p> The control sets that are associated with the framework. </p>
    /// - On success, responds with [`UpdateAssessmentFrameworkOutput`](crate::output::UpdateAssessmentFrameworkOutput) with field(s):
    ///   - [`framework(Option<Framework>)`](crate::output::UpdateAssessmentFrameworkOutput::framework): <p> The name of the framework. </p>
    /// - On failure, responds with [`SdkError<UpdateAssessmentFrameworkError>`](crate::error::UpdateAssessmentFrameworkError)
    pub fn update_assessment_framework(&self) -> fluent_builders::UpdateAssessmentFramework {
        fluent_builders::UpdateAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssessmentFrameworkShare`](crate::client::fluent_builders::UpdateAssessmentFrameworkShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`request_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentFrameworkShare::request_id) / [`set_request_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentFrameworkShare::set_request_id): <p> The unique identifier for the share request. </p>
    ///   - [`request_type(ShareRequestType)`](crate::client::fluent_builders::UpdateAssessmentFrameworkShare::request_type) / [`set_request_type(Option<ShareRequestType>)`](crate::client::fluent_builders::UpdateAssessmentFrameworkShare::set_request_type): <p>Specifies whether the share request is a sent request or a received request.</p>
    ///   - [`action(ShareRequestAction)`](crate::client::fluent_builders::UpdateAssessmentFrameworkShare::action) / [`set_action(Option<ShareRequestAction>)`](crate::client::fluent_builders::UpdateAssessmentFrameworkShare::set_action): <p>Specifies the update action for the share request.</p>
    /// - On success, responds with [`UpdateAssessmentFrameworkShareOutput`](crate::output::UpdateAssessmentFrameworkShareOutput) with field(s):
    ///   - [`assessment_framework_share_request(Option<AssessmentFrameworkShareRequest>)`](crate::output::UpdateAssessmentFrameworkShareOutput::assessment_framework_share_request): <p> The updated share request that's returned by the <code>UpdateAssessmentFrameworkShare</code> operation. </p>
    /// - On failure, responds with [`SdkError<UpdateAssessmentFrameworkShareError>`](crate::error::UpdateAssessmentFrameworkShareError)
    pub fn update_assessment_framework_share(
        &self,
    ) -> fluent_builders::UpdateAssessmentFrameworkShare {
        fluent_builders::UpdateAssessmentFrameworkShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAssessmentStatus`](crate::client::fluent_builders::UpdateAssessmentStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`assessment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAssessmentStatus::assessment_id) / [`set_assessment_id(Option<String>)`](crate::client::fluent_builders::UpdateAssessmentStatus::set_assessment_id): <p> The unique identifier for the assessment. </p>
    ///   - [`status(AssessmentStatus)`](crate::client::fluent_builders::UpdateAssessmentStatus::status) / [`set_status(Option<AssessmentStatus>)`](crate::client::fluent_builders::UpdateAssessmentStatus::set_status): <p> The current status of the assessment. </p>
    /// - On success, responds with [`UpdateAssessmentStatusOutput`](crate::output::UpdateAssessmentStatusOutput) with field(s):
    ///   - [`assessment(Option<Assessment>)`](crate::output::UpdateAssessmentStatusOutput::assessment): <p> The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API returned. </p>
    /// - On failure, responds with [`SdkError<UpdateAssessmentStatusError>`](crate::error::UpdateAssessmentStatusError)
    pub fn update_assessment_status(&self) -> fluent_builders::UpdateAssessmentStatus {
        fluent_builders::UpdateAssessmentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateControl`](crate::client::fluent_builders::UpdateControl) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`control_id(impl Into<String>)`](crate::client::fluent_builders::UpdateControl::control_id) / [`set_control_id(Option<String>)`](crate::client::fluent_builders::UpdateControl::set_control_id): <p> The identifier for the control. </p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateControl::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateControl::set_name): <p> The name of the updated control. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateControl::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateControl::set_description): <p> The optional description of the control. </p>
    ///   - [`testing_information(impl Into<String>)`](crate::client::fluent_builders::UpdateControl::testing_information) / [`set_testing_information(Option<String>)`](crate::client::fluent_builders::UpdateControl::set_testing_information): <p> The steps that you should follow to determine if the control is met. </p>
    ///   - [`action_plan_title(impl Into<String>)`](crate::client::fluent_builders::UpdateControl::action_plan_title) / [`set_action_plan_title(Option<String>)`](crate::client::fluent_builders::UpdateControl::set_action_plan_title): <p> The title of the action plan for remediating the control. </p>
    ///   - [`action_plan_instructions(impl Into<String>)`](crate::client::fluent_builders::UpdateControl::action_plan_instructions) / [`set_action_plan_instructions(Option<String>)`](crate::client::fluent_builders::UpdateControl::set_action_plan_instructions): <p> The recommended actions to carry out if the control isn't fulfilled. </p>
    ///   - [`control_mapping_sources(Vec<ControlMappingSource>)`](crate::client::fluent_builders::UpdateControl::control_mapping_sources) / [`set_control_mapping_sources(Option<Vec<ControlMappingSource>>)`](crate::client::fluent_builders::UpdateControl::set_control_mapping_sources): <p> The data mapping sources for the control. </p>
    /// - On success, responds with [`UpdateControlOutput`](crate::output::UpdateControlOutput) with field(s):
    ///   - [`control(Option<Control>)`](crate::output::UpdateControlOutput::control): <p> The name of the updated control set that the <code>UpdateControl</code> API returned. </p>
    /// - On failure, responds with [`SdkError<UpdateControlError>`](crate::error::UpdateControlError)
    pub fn update_control(&self) -> fluent_builders::UpdateControl {
        fluent_builders::UpdateControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSettings`](crate::client::fluent_builders::UpdateSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`sns_topic(impl Into<String>)`](crate::client::fluent_builders::UpdateSettings::sns_topic) / [`set_sns_topic(Option<String>)`](crate::client::fluent_builders::UpdateSettings::set_sns_topic): <p> The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to. </p>
    ///   - [`default_assessment_reports_destination(AssessmentReportsDestination)`](crate::client::fluent_builders::UpdateSettings::default_assessment_reports_destination) / [`set_default_assessment_reports_destination(Option<AssessmentReportsDestination>)`](crate::client::fluent_builders::UpdateSettings::set_default_assessment_reports_destination): <p> The default storage destination for assessment reports. </p>
    ///   - [`default_process_owners(Vec<Role>)`](crate::client::fluent_builders::UpdateSettings::default_process_owners) / [`set_default_process_owners(Option<Vec<Role>>)`](crate::client::fluent_builders::UpdateSettings::set_default_process_owners): <p> A list of the default audit owners. </p>
    ///   - [`kms_key(impl Into<String>)`](crate::client::fluent_builders::UpdateSettings::kms_key) / [`set_kms_key(Option<String>)`](crate::client::fluent_builders::UpdateSettings::set_kms_key): <p> The KMS key details. </p>
    /// - On success, responds with [`UpdateSettingsOutput`](crate::output::UpdateSettingsOutput) with field(s):
    ///   - [`settings(Option<Settings>)`](crate::output::UpdateSettingsOutput::settings): <p> The current list of settings. </p>
    /// - On failure, responds with [`SdkError<UpdateSettingsError>`](crate::error::UpdateSettingsError)
    pub fn update_settings(&self) -> fluent_builders::UpdateSettings {
        fluent_builders::UpdateSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ValidateAssessmentReportIntegrity`](crate::client::fluent_builders::ValidateAssessmentReportIntegrity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`s3_relative_path(impl Into<String>)`](crate::client::fluent_builders::ValidateAssessmentReportIntegrity::s3_relative_path) / [`set_s3_relative_path(Option<String>)`](crate::client::fluent_builders::ValidateAssessmentReportIntegrity::set_s3_relative_path): <p> The relative path of the Amazon S3 bucket that the assessment report is stored in. </p>
    /// - On success, responds with [`ValidateAssessmentReportIntegrityOutput`](crate::output::ValidateAssessmentReportIntegrityOutput) with field(s):
    ///   - [`signature_valid(Option<bool>)`](crate::output::ValidateAssessmentReportIntegrityOutput::signature_valid): <p> Specifies whether the signature key is valid. </p>
    ///   - [`signature_algorithm(Option<String>)`](crate::output::ValidateAssessmentReportIntegrityOutput::signature_algorithm): <p> The signature algorithm that's used to code sign the assessment report file. </p>
    ///   - [`signature_date_time(Option<String>)`](crate::output::ValidateAssessmentReportIntegrityOutput::signature_date_time): <p> The date and time signature that specifies when the assessment report was created. </p>
    ///   - [`signature_key_id(Option<String>)`](crate::output::ValidateAssessmentReportIntegrityOutput::signature_key_id): <p> The unique identifier for the validation signature key. </p>
    ///   - [`validation_errors(Option<Vec<String>>)`](crate::output::ValidateAssessmentReportIntegrityOutput::validation_errors): <p> Represents any errors that occurred when validating the assessment report. </p>
    /// - On failure, responds with [`SdkError<ValidateAssessmentReportIntegrityError>`](crate::error::ValidateAssessmentReportIntegrityError)
    pub fn validate_assessment_report_integrity(
        &self,
    ) -> fluent_builders::ValidateAssessmentReportIntegrity {
        fluent_builders::ValidateAssessmentReportIntegrity::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAssessmentReportEvidenceFolder`.
    ///
    /// <p> Associates an evidence folder to an assessment report in a Audit Manager assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateAssessmentReportEvidenceFolder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_assessment_report_evidence_folder_input::Builder,
    }
    impl AssociateAssessmentReportEvidenceFolder {
        /// Creates a new `AssociateAssessmentReportEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAssessmentReportEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateAssessmentReportEvidenceFolderError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateAssessmentReportEvidence`.
    ///
    /// <p> Associates a list of evidence to an assessment report in an Audit Manager assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchAssociateAssessmentReportEvidence {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_associate_assessment_report_evidence_input::Builder,
    }
    impl BatchAssociateAssessmentReportEvidence {
        /// Creates a new `BatchAssociateAssessmentReportEvidence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateAssessmentReportEvidenceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchAssociateAssessmentReportEvidenceError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// Appends an item to `evidenceIds`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p> The list of evidence identifiers. </p>
        pub fn evidence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_ids(input.into());
            self
        }
        /// <p> The list of evidence identifiers. </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_evidence_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateDelegationByAssessment`.
    ///
    /// <p> Creates a batch of delegations for an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchCreateDelegationByAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_create_delegation_by_assessment_input::Builder,
    }
    impl BatchCreateDelegationByAssessment {
        /// Creates a new `BatchCreateDelegationByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateDelegationByAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateDelegationByAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `createDelegationRequests`.
        ///
        /// To override the contents of this collection use [`set_create_delegation_requests`](Self::set_create_delegation_requests).
        ///
        /// <p> The API request to batch create delegations in Audit Manager. </p>
        pub fn create_delegation_requests(
            mut self,
            input: crate::model::CreateDelegationRequest,
        ) -> Self {
            self.inner = self.inner.create_delegation_requests(input);
            self
        }
        /// <p> The API request to batch create delegations in Audit Manager. </p>
        pub fn set_create_delegation_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateDelegationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_create_delegation_requests(input);
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteDelegationByAssessment`.
    ///
    /// <p> Deletes a batch of delegations for an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteDelegationByAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_delegation_by_assessment_input::Builder,
    }
    impl BatchDeleteDelegationByAssessment {
        /// Creates a new `BatchDeleteDelegationByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteDelegationByAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteDelegationByAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `delegationIds`.
        ///
        /// To override the contents of this collection use [`set_delegation_ids`](Self::set_delegation_ids).
        ///
        /// <p> The identifiers for the delegations. </p>
        pub fn delegation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_ids(input.into());
            self
        }
        /// <p> The identifiers for the delegations. </p>
        pub fn set_delegation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_delegation_ids(input);
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateAssessmentReportEvidence`.
    ///
    /// <p> Disassociates a list of evidence from an assessment report in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisassociateAssessmentReportEvidence {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_disassociate_assessment_report_evidence_input::Builder,
    }
    impl BatchDisassociateAssessmentReportEvidence {
        /// Creates a new `BatchDisassociateAssessmentReportEvidence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateAssessmentReportEvidenceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchDisassociateAssessmentReportEvidenceError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// Appends an item to `evidenceIds`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p> The list of evidence identifiers. </p>
        pub fn evidence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_ids(input.into());
            self
        }
        /// <p> The list of evidence identifiers. </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_evidence_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchImportEvidenceToAssessmentControl`.
    ///
    /// <p> Uploads one or more pieces of evidence to a control in an Audit Manager assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchImportEvidenceToAssessmentControl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_import_evidence_to_assessment_control_input::Builder,
    }
    impl BatchImportEvidenceToAssessmentControl {
        /// Creates a new `BatchImportEvidenceToAssessmentControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchImportEvidenceToAssessmentControlOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchImportEvidenceToAssessmentControlError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// Appends an item to `manualEvidence`.
        ///
        /// To override the contents of this collection use [`set_manual_evidence`](Self::set_manual_evidence).
        ///
        /// <p> The list of manual evidence objects. </p>
        pub fn manual_evidence(mut self, input: crate::model::ManualEvidence) -> Self {
            self.inner = self.inner.manual_evidence(input);
            self
        }
        /// <p> The list of manual evidence objects. </p>
        pub fn set_manual_evidence(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManualEvidence>>,
        ) -> Self {
            self.inner = self.inner.set_manual_evidence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessment`.
    ///
    /// <p> Creates an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_assessment_input::Builder,
    }
    impl CreateAssessment {
        /// Creates a new `CreateAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the assessment to be created. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the assessment to be created. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The optional description of the assessment to be created. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The optional description of the assessment to be created. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being created. </p>
        pub fn assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.inner = self.inner.assessment_reports_destination(input);
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being created. </p>
        pub fn set_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.inner = self.inner.set_assessment_reports_destination(input);
            self
        }
        /// <p> The wrapper that contains the Amazon Web Services accounts and services that are in scope for the assessment. </p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p> The wrapper that contains the Amazon Web Services accounts and services that are in scope for the assessment. </p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p> The list of roles for the assessment. </p>
        pub fn roles(mut self, input: crate::model::Role) -> Self {
            self.inner = self.inner.roles(input);
            self
        }
        /// <p> The list of roles for the assessment. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.inner = self.inner.set_roles(input);
            self
        }
        /// <p> The identifier for the framework that the assessment will be created from. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(input.into());
            self
        }
        /// <p> The identifier for the framework that the assessment will be created from. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the assessment. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags that are associated with the assessment. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentFramework`.
    ///
    /// <p> Creates a custom framework in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssessmentFramework {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_assessment_framework_input::Builder,
    }
    impl CreateAssessmentFramework {
        /// Creates a new `CreateAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentFrameworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the new custom framework. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the new custom framework. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> An optional description for the new custom framework. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> An optional description for the new custom framework. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA. </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compliance_type(input.into());
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA. </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compliance_type(input);
            self
        }
        /// Appends an item to `controlSets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p> The control sets that are associated with the framework. </p>
        pub fn control_sets(
            mut self,
            input: crate::model::CreateAssessmentFrameworkControlSet,
        ) -> Self {
            self.inner = self.inner.control_sets(input);
            self
        }
        /// <p> The control sets that are associated with the framework. </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssessmentFrameworkControlSet>,
            >,
        ) -> Self {
            self.inner = self.inner.set_control_sets(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the framework. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags that are associated with the framework. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentReport`.
    ///
    /// <p> Creates an assessment report for the specified assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAssessmentReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_assessment_report_input::Builder,
    }
    impl CreateAssessmentReport {
        /// Creates a new `CreateAssessmentReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the new assessment report. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the new assessment report. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the assessment report. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the assessment report. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateControl`.
    ///
    /// <p> Creates a new custom control in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateControl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_control_input::Builder,
    }
    impl CreateControl {
        /// Creates a new `CreateControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateControlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateControlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the control. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the control. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the control. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the control. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The steps to follow to determine if the control is satisfied. </p>
        pub fn testing_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.testing_information(input.into());
            self
        }
        /// <p> The steps to follow to determine if the control is satisfied. </p>
        pub fn set_testing_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_testing_information(input);
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn action_plan_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_title(input.into());
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn set_action_plan_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_title(input);
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn action_plan_instructions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_instructions(input.into());
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn set_action_plan_instructions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_instructions(input);
            self
        }
        /// Appends an item to `controlMappingSources`.
        ///
        /// To override the contents of this collection use [`set_control_mapping_sources`](Self::set_control_mapping_sources).
        ///
        /// <p> The data mapping sources for the control. </p>
        pub fn control_mapping_sources(
            mut self,
            input: crate::model::CreateControlMappingSource,
        ) -> Self {
            self.inner = self.inner.control_mapping_sources(input);
            self
        }
        /// <p> The data mapping sources for the control. </p>
        pub fn set_control_mapping_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateControlMappingSource>>,
        ) -> Self {
            self.inner = self.inner.set_control_mapping_sources(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the control. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags that are associated with the control. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessment`.
    ///
    /// <p> Deletes an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assessment_input::Builder,
    }
    impl DeleteAssessment {
        /// Creates a new `DeleteAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentFramework`.
    ///
    /// <p> Deletes a custom framework in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssessmentFramework {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assessment_framework_input::Builder,
    }
    impl DeleteAssessmentFramework {
        /// Creates a new `DeleteAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentFrameworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the custom framework. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(input.into());
            self
        }
        /// <p> The identifier for the custom framework. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentFrameworkShare`.
    ///
    /// <p> Deletes a share request for a custom framework in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssessmentFrameworkShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assessment_framework_share_input::Builder,
    }
    impl DeleteAssessmentFrameworkShare {
        /// Creates a new `DeleteAssessmentFrameworkShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentFrameworkShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentFrameworkShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the share request to be deleted.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(input.into());
            self
        }
        /// <p>The unique identifier for the share request to be deleted.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn request_type(mut self, input: crate::model::ShareRequestType) -> Self {
            self.inner = self.inner.request_type(input);
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn set_request_type(
            mut self,
            input: std::option::Option<crate::model::ShareRequestType>,
        ) -> Self {
            self.inner = self.inner.set_request_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentReport`.
    ///
    /// <p> Deletes an assessment report from an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAssessmentReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_assessment_report_input::Builder,
    }
    impl DeleteAssessmentReport {
        /// Creates a new `DeleteAssessmentReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentReportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn assessment_report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_report_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn set_assessment_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteControl`.
    ///
    /// <p> Deletes a custom control in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteControl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_control_input::Builder,
    }
    impl DeleteControl {
        /// Creates a new `DeleteControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteControlOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteControlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(input.into());
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterAccount`.
    ///
    /// <p> Deregisters an account in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_account_input::Builder,
    }
    impl DeregisterAccount {
        /// Creates a new `DeregisterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeregisterOrganizationAdminAccount`.
    ///
    /// <p>Removes the specified member Amazon Web Services account as a delegated administrator for Audit Manager. </p> <important>
    /// <p>When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the evidence that you previously collected under that account. This is also the case when you deregister a delegated administrator from Audit Manager. However, Audit Manager will stop collecting and attaching evidence to that delegated administrator account moving forward.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeregisterOrganizationAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deregister_organization_admin_account_input::Builder,
    }
    impl DeregisterOrganizationAdminAccount {
        /// Creates a new `DeregisterOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterOrganizationAdminAccountError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the administrator account. </p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(input.into());
            self
        }
        /// <p> The identifier for the administrator account. </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAssessmentReportEvidenceFolder`.
    ///
    /// <p> Disassociates an evidence folder from the specified assessment report in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateAssessmentReportEvidenceFolder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_assessment_report_evidence_folder_input::Builder,
    }
    impl DisassociateAssessmentReportEvidenceFolder {
        /// Creates a new `DisassociateAssessmentReportEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAssessmentReportEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateAssessmentReportEvidenceFolderError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(input.into());
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountStatus`.
    ///
    /// <p> Returns the registration status of an account in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccountStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_account_status_input::Builder,
    }
    impl GetAccountStatus {
        /// Creates a new `GetAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAssessment`.
    ///
    /// <p>Returns an assessment from Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assessment_input::Builder,
    }
    impl GetAssessment {
        /// Creates a new `GetAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p>The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessmentFramework`.
    ///
    /// <p>Returns a framework from Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssessmentFramework {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assessment_framework_input::Builder,
    }
    impl GetAssessmentFramework {
        /// Creates a new `GetAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentFrameworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the framework. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(input.into());
            self
        }
        /// <p> The identifier for the framework. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessmentReportUrl`.
    ///
    /// <p> Returns the URL of an assessment report in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAssessmentReportUrl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_assessment_report_url_input::Builder,
    }
    impl GetAssessmentReportUrl {
        /// Creates a new `GetAssessmentReportUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentReportUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentReportUrlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn assessment_report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_report_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn set_assessment_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_report_id(input);
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChangeLogs`.
    ///
    /// <p> Returns a list of changelogs from Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetChangeLogs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_change_logs_input::Builder,
    }
    impl GetChangeLogs {
        /// Creates a new `GetChangeLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeLogsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetChangeLogsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetChangeLogsPaginator {
            crate::paginator::GetChangeLogsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p>The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(input.into());
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetControl`.
    ///
    /// <p> Returns a control from Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetControl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_control_input::Builder,
    }
    impl GetControl {
        /// Creates a new `GetControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetControlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetControlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDelegations`.
    ///
    /// <p> Returns a list of delegations from an audit owner to a delegate. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDelegations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_delegations_input::Builder,
    }
    impl GetDelegations {
        /// Creates a new `GetDelegations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDelegationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDelegationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDelegationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDelegationsPaginator {
            crate::paginator::GetDelegationsPaginator::new(self.handle, self.inner)
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidence`.
    ///
    /// <p> Returns evidence from Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEvidence {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_evidence_input::Builder,
    }
    impl GetEvidence {
        /// Creates a new `GetEvidence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(input.into());
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// <p> The unique identifier for the evidence. </p>
        pub fn evidence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_id(input.into());
            self
        }
        /// <p> The unique identifier for the evidence. </p>
        pub fn set_evidence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_evidence_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceByEvidenceFolder`.
    ///
    /// <p> Returns all evidence from a specified evidence folder in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEvidenceByEvidenceFolder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_evidence_by_evidence_folder_input::Builder,
    }
    impl GetEvidenceByEvidenceFolder {
        /// Creates a new `GetEvidenceByEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceByEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceByEvidenceFolderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetEvidenceByEvidenceFolderPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetEvidenceByEvidenceFolderPaginator {
            crate::paginator::GetEvidenceByEvidenceFolderPaginator::new(self.handle, self.inner)
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(input.into());
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceFolder`.
    ///
    /// <p> Returns an evidence folder from the specified assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEvidenceFolder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_evidence_folder_input::Builder,
    }
    impl GetEvidenceFolder {
        /// Creates a new `GetEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceFolderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(input.into());
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceFoldersByAssessment`.
    ///
    /// <p> Returns the evidence folders from a specified assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEvidenceFoldersByAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_evidence_folders_by_assessment_input::Builder,
    }
    impl GetEvidenceFoldersByAssessment {
        /// Creates a new `GetEvidenceFoldersByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceFoldersByAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceFoldersByAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetEvidenceFoldersByAssessmentPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetEvidenceFoldersByAssessmentPaginator {
            crate::paginator::GetEvidenceFoldersByAssessmentPaginator::new(self.handle, self.inner)
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceFoldersByAssessmentControl`.
    ///
    /// <p> Returns a list of evidence folders that are associated with a specified control of an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEvidenceFoldersByAssessmentControl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_evidence_folders_by_assessment_control_input::Builder,
    }
    impl GetEvidenceFoldersByAssessmentControl {
        /// Creates a new `GetEvidenceFoldersByAssessmentControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceFoldersByAssessmentControlOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetEvidenceFoldersByAssessmentControlError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetEvidenceFoldersByAssessmentControlPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetEvidenceFoldersByAssessmentControlPaginator {
            crate::paginator::GetEvidenceFoldersByAssessmentControlPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInsights`.
    ///
    /// <p>Gets the latest analytics data for all your current active assessments. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_insights_input::Builder,
    }
    impl GetInsights {
        /// Creates a new `GetInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetInsightsByAssessment`.
    ///
    /// <p>Gets the latest analytics data for a specific active assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInsightsByAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_insights_by_assessment_input::Builder,
    }
    impl GetInsightsByAssessment {
        /// Creates a new `GetInsightsByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInsightsByAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInsightsByAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p>The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOrganizationAdminAccount`.
    ///
    /// <p> Returns the name of the delegated Amazon Web Services administrator account for the organization. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetOrganizationAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_organization_admin_account_input::Builder,
    }
    impl GetOrganizationAdminAccount {
        /// Creates a new `GetOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOrganizationAdminAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetServicesInScope`.
    ///
    /// <p> Returns a list of the in-scope Amazon Web Services services for the specified assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServicesInScope {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_services_in_scope_input::Builder,
    }
    impl GetServicesInScope {
        /// Creates a new `GetServicesInScope`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServicesInScopeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServicesInScopeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSettings`.
    ///
    /// <p> Returns the settings for the specified Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_settings_input::Builder,
    }
    impl GetSettings {
        /// Creates a new `GetSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The list of <code>SettingAttribute</code> enum values. </p>
        pub fn attribute(mut self, input: crate::model::SettingAttribute) -> Self {
            self.inner = self.inner.attribute(input);
            self
        }
        /// <p> The list of <code>SettingAttribute</code> enum values. </p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::SettingAttribute>,
        ) -> Self {
            self.inner = self.inner.set_attribute(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentControlInsightsByControlDomain`.
    ///
    /// <p>Lists the latest analytics data for controls within a specific control domain and a specific active assessment.</p> <note>
    /// <p>Control insights are listed only if the control belongs to the control domain and assessment that was specified. Moreover, the control must have collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsByAssessment</code>. If neither of these conditions are met, no data is listed for that control. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentControlInsightsByControlDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_control_insights_by_control_domain_input::Builder,
    }
    impl ListAssessmentControlInsightsByControlDomain {
        /// Creates a new `ListAssessmentControlInsightsByControlDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentControlInsightsByControlDomainOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAssessmentControlInsightsByControlDomainError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentControlInsightsByControlDomainPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAssessmentControlInsightsByControlDomainPaginator {
            crate::paginator::ListAssessmentControlInsightsByControlDomainPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The unique identifier for the control domain. </p>
        pub fn control_domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_domain_id(input.into());
            self
        }
        /// <p>The unique identifier for the control domain. </p>
        pub fn set_control_domain_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_domain_id(input);
            self
        }
        /// <p>The unique identifier for the active assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p>The unique identifier for the active assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentFrameworks`.
    ///
    /// <p> Returns a list of the frameworks that are available in the Audit Manager framework library. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentFrameworks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_frameworks_input::Builder,
    }
    impl ListAssessmentFrameworks {
        /// Creates a new `ListAssessmentFrameworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentFrameworksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentFrameworksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentFrameworksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssessmentFrameworksPaginator {
            crate::paginator::ListAssessmentFrameworksPaginator::new(self.handle, self.inner)
        }
        /// <p> The type of framework, such as a standard framework or a custom framework. </p>
        pub fn framework_type(mut self, input: crate::model::FrameworkType) -> Self {
            self.inner = self.inner.framework_type(input);
            self
        }
        /// <p> The type of framework, such as a standard framework or a custom framework. </p>
        pub fn set_framework_type(
            mut self,
            input: std::option::Option<crate::model::FrameworkType>,
        ) -> Self {
            self.inner = self.inner.set_framework_type(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentFrameworkShareRequests`.
    ///
    /// <p> Returns a list of sent or received share requests for custom frameworks in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentFrameworkShareRequests {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_framework_share_requests_input::Builder,
    }
    impl ListAssessmentFrameworkShareRequests {
        /// Creates a new `ListAssessmentFrameworkShareRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentFrameworkShareRequestsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAssessmentFrameworkShareRequestsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentFrameworkShareRequestsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAssessmentFrameworkShareRequestsPaginator {
            crate::paginator::ListAssessmentFrameworkShareRequestsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p> Specifies whether the share request is a sent request or a received request.</p>
        pub fn request_type(mut self, input: crate::model::ShareRequestType) -> Self {
            self.inner = self.inner.request_type(input);
            self
        }
        /// <p> Specifies whether the share request is a sent request or a received request.</p>
        pub fn set_request_type(
            mut self,
            input: std::option::Option<crate::model::ShareRequestType>,
        ) -> Self {
            self.inner = self.inner.set_request_type(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentReports`.
    ///
    /// <p> Returns a list of assessment reports created in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessmentReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessment_reports_input::Builder,
    }
    impl ListAssessmentReports {
        /// Creates a new `ListAssessmentReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentReportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssessmentReportsPaginator {
            crate::paginator::ListAssessmentReportsPaginator::new(self.handle, self.inner)
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessments`.
    ///
    /// <p> Returns a list of current and past assessments from Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssessments {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_assessments_input::Builder,
    }
    impl ListAssessments {
        /// Creates a new `ListAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssessmentsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAssessmentsPaginator {
            crate::paginator::ListAssessmentsPaginator::new(self.handle, self.inner)
        }
        /// <p> The current status of the assessment.</p>
        pub fn status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p> The current status of the assessment.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListControlDomainInsights`.
    ///
    /// <p>Lists the latest analytics data for control domains across all of your active assessments. </p> <note>
    /// <p>A control domain is listed only if at least one of the controls within that domain collected evidence on the <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is listed for that control domain.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListControlDomainInsights {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_control_domain_insights_input::Builder,
    }
    impl ListControlDomainInsights {
        /// Creates a new `ListControlDomainInsights`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListControlDomainInsightsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListControlDomainInsightsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListControlDomainInsightsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListControlDomainInsightsPaginator {
            crate::paginator::ListControlDomainInsightsPaginator::new(self.handle, self.inner)
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListControlDomainInsightsByAssessment`.
    ///
    /// <p>Lists analytics data for control domains within a specified active assessment.</p> <note>
    /// <p>A control domain is listed only if at least one of the controls within that domain collected evidence on the <code>lastUpdated</code> date of <code>controlDomainInsights</code>. If this condition isn’t met, no data is listed for that domain.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListControlDomainInsightsByAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_control_domain_insights_by_assessment_input::Builder,
    }
    impl ListControlDomainInsightsByAssessment {
        /// Creates a new `ListControlDomainInsightsByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListControlDomainInsightsByAssessmentOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListControlDomainInsightsByAssessmentError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListControlDomainInsightsByAssessmentPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListControlDomainInsightsByAssessmentPaginator {
            crate::paginator::ListControlDomainInsightsByAssessmentPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The unique identifier for the active assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p>The unique identifier for the active assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListControlInsightsByControlDomain`.
    ///
    /// <p>Lists the latest analytics data for controls within a specific control domain across all active assessments.</p> <note>
    /// <p>Control insights are listed only if the control belongs to the control domain that was specified and the control collected evidence on the <code>lastUpdated</code> date of <code>controlInsightsMetadata</code>. If neither of these conditions are met, no data is listed for that control. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListControlInsightsByControlDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_control_insights_by_control_domain_input::Builder,
    }
    impl ListControlInsightsByControlDomain {
        /// Creates a new `ListControlInsightsByControlDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListControlInsightsByControlDomainOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListControlInsightsByControlDomainError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListControlInsightsByControlDomainPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListControlInsightsByControlDomainPaginator {
            crate::paginator::ListControlInsightsByControlDomainPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The unique identifier for the control domain. </p>
        pub fn control_domain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_domain_id(input.into());
            self
        }
        /// <p>The unique identifier for the control domain. </p>
        pub fn set_control_domain_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_domain_id(input);
            self
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListControls`.
    ///
    /// <p> Returns a list of controls from Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListControls {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_controls_input::Builder,
    }
    impl ListControls {
        /// Creates a new `ListControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListControlsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListControlsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListControlsPaginator {
            crate::paginator::ListControlsPaginator::new(self.handle, self.inner)
        }
        /// <p> The type of control, such as a standard control or a custom control. </p>
        pub fn control_type(mut self, input: crate::model::ControlType) -> Self {
            self.inner = self.inner.control_type(input);
            self
        }
        /// <p> The type of control, such as a standard control or a custom control. </p>
        pub fn set_control_type(
            mut self,
            input: std::option::Option<crate::model::ControlType>,
        ) -> Self {
            self.inner = self.inner.set_control_type(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeywordsForDataSource`.
    ///
    /// <p> Returns a list of keywords that are pre-mapped to the specified control data source. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListKeywordsForDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_keywords_for_data_source_input::Builder,
    }
    impl ListKeywordsForDataSource {
        /// Creates a new `ListKeywordsForDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeywordsForDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeywordsForDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListKeywordsForDataSourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListKeywordsForDataSourcePaginator {
            crate::paginator::ListKeywordsForDataSourcePaginator::new(self.handle, self.inner)
        }
        /// <p> The control mapping data source that the keywords apply to. </p>
        pub fn source(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p> The control mapping data source that the keywords apply to. </p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::SourceType>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotifications`.
    ///
    /// <p> Returns a list of all Audit Manager notifications. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNotifications {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_notifications_input::Builder,
    }
    impl ListNotifications {
        /// Creates a new `ListNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNotificationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNotificationsPaginator {
            crate::paginator::ListNotificationsPaginator::new(self.handle, self.inner)
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p> Returns a list of tags for the specified resource in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterAccount`.
    ///
    /// <p> Enables Audit Manager for the specified Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_account_input::Builder,
    }
    impl RegisterAccount {
        /// Creates a new `RegisterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The KMS key details. </p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p> The KMS key details. </p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p> The delegated administrator account for Audit Manager. </p>
        pub fn delegated_admin_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegated_admin_account(input.into());
            self
        }
        /// <p> The delegated administrator account for Audit Manager. </p>
        pub fn set_delegated_admin_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegated_admin_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterOrganizationAdminAccount`.
    ///
    /// <p> Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RegisterOrganizationAdminAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::register_organization_admin_account_input::Builder,
    }
    impl RegisterOrganizationAdminAccount {
        /// Creates a new `RegisterOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterOrganizationAdminAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the delegated administrator account. </p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(input.into());
            self
        }
        /// <p> The identifier for the delegated administrator account. </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAssessmentFrameworkShare`.
    ///
    /// <p> Creates a share request for a custom framework in Audit Manager. </p>
    /// <p>The share request specifies a recipient and notifies them that a custom framework is available. Recipients have 120 days to accept or decline the request. If no action is taken, the share request expires.</p> <important>
    /// <p>When you invoke the <code>StartAssessmentFrameworkShare</code> API, you are about to share a custom framework with another Amazon Web Services account. You may not share a custom framework that is derived from a standard framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you have obtained permission to do so from the owner of the standard framework. To learn more about which standard frameworks are eligible for sharing, see <a href="https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility">Framework sharing eligibility</a> in the <i>Audit Manager User Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartAssessmentFrameworkShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_assessment_framework_share_input::Builder,
    }
    impl StartAssessmentFrameworkShare {
        /// Creates a new `StartAssessmentFrameworkShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAssessmentFrameworkShareOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAssessmentFrameworkShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the custom framework to be shared. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(input.into());
            self
        }
        /// <p> The unique identifier for the custom framework to be shared. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
        /// <p> The Amazon Web Services account of the recipient. </p>
        pub fn destination_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_account(input.into());
            self
        }
        /// <p> The Amazon Web Services account of the recipient. </p>
        pub fn set_destination_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_account(input);
            self
        }
        /// <p> The Amazon Web Services Region of the recipient. </p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(input.into());
            self
        }
        /// <p> The Amazon Web Services Region of the recipient. </p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p> An optional comment from the sender about the share request. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p> An optional comment from the sender about the share request. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p> Tags the specified resource in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p> The tags that are associated with the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p> Removes a tag from a resource in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the specified resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the specified resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The name or key of the tag. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p> The name or key of the tag. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessment`.
    ///
    /// <p> Edits an Audit Manager assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssessment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_assessment_input::Builder,
    }
    impl UpdateAssessment {
        /// Creates a new `UpdateAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The name of the assessment to be updated. </p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_name(input.into());
            self
        }
        /// <p> The name of the assessment to be updated. </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_name(input);
            self
        }
        /// <p> The description of the assessment. </p>
        pub fn assessment_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_description(input.into());
            self
        }
        /// <p> The description of the assessment. </p>
        pub fn set_assessment_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_description(input);
            self
        }
        /// <p> The scope of the assessment. </p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(input);
            self
        }
        /// <p> The scope of the assessment. </p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being updated. </p>
        pub fn assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.inner = self.inner.assessment_reports_destination(input);
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being updated. </p>
        pub fn set_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.inner = self.inner.set_assessment_reports_destination(input);
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p> The list of roles for the assessment. </p>
        pub fn roles(mut self, input: crate::model::Role) -> Self {
            self.inner = self.inner.roles(input);
            self
        }
        /// <p> The list of roles for the assessment. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.inner = self.inner.set_roles(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentControl`.
    ///
    /// <p> Updates a control within an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssessmentControl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_assessment_control_input::Builder,
    }
    impl UpdateAssessmentControl {
        /// Creates a new `UpdateAssessmentControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentControlOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentControlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(input.into());
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p> The status of the control. </p>
        pub fn control_status(mut self, input: crate::model::ControlStatus) -> Self {
            self.inner = self.inner.control_status(input);
            self
        }
        /// <p> The status of the control. </p>
        pub fn set_control_status(
            mut self,
            input: std::option::Option<crate::model::ControlStatus>,
        ) -> Self {
            self.inner = self.inner.set_control_status(input);
            self
        }
        /// <p> The comment body text for the control. </p>
        pub fn comment_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_body(input.into());
            self
        }
        /// <p> The comment body text for the control. </p>
        pub fn set_comment_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentControlSetStatus`.
    ///
    /// <p> Updates the status of a control set in an Audit Manager assessment. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssessmentControlSetStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_assessment_control_set_status_input::Builder,
    }
    impl UpdateAssessmentControlSetStatus {
        /// Creates a new `UpdateAssessmentControlSetStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentControlSetStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentControlSetStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(input.into());
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p> The status of the control set that's being updated. </p>
        pub fn status(mut self, input: crate::model::ControlSetStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p> The status of the control set that's being updated. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ControlSetStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p> The comment that's related to the status update. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(input.into());
            self
        }
        /// <p> The comment that's related to the status update. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentFramework`.
    ///
    /// <p> Updates a custom framework in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssessmentFramework {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_assessment_framework_input::Builder,
    }
    impl UpdateAssessmentFramework {
        /// Creates a new `UpdateAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentFrameworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the framework. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(input.into());
            self
        }
        /// <p> The unique identifier for the framework. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
        /// <p> The name of the framework to be updated. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the framework to be updated. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The description of the updated framework. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The description of the updated framework. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA. </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compliance_type(input.into());
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA. </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compliance_type(input);
            self
        }
        /// Appends an item to `controlSets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p> The control sets that are associated with the framework. </p>
        pub fn control_sets(
            mut self,
            input: crate::model::UpdateAssessmentFrameworkControlSet,
        ) -> Self {
            self.inner = self.inner.control_sets(input);
            self
        }
        /// <p> The control sets that are associated with the framework. </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::UpdateAssessmentFrameworkControlSet>,
            >,
        ) -> Self {
            self.inner = self.inner.set_control_sets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentFrameworkShare`.
    ///
    /// <p> Updates a share request for a custom framework in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssessmentFrameworkShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_assessment_framework_share_input::Builder,
    }
    impl UpdateAssessmentFrameworkShare {
        /// Creates a new `UpdateAssessmentFrameworkShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentFrameworkShareOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentFrameworkShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the share request. </p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_id(input.into());
            self
        }
        /// <p> The unique identifier for the share request. </p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_request_id(input);
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn request_type(mut self, input: crate::model::ShareRequestType) -> Self {
            self.inner = self.inner.request_type(input);
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn set_request_type(
            mut self,
            input: std::option::Option<crate::model::ShareRequestType>,
        ) -> Self {
            self.inner = self.inner.set_request_type(input);
            self
        }
        /// <p>Specifies the update action for the share request.</p>
        pub fn action(mut self, input: crate::model::ShareRequestAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>Specifies the update action for the share request.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ShareRequestAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentStatus`.
    ///
    /// <p> Updates the status of an assessment in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAssessmentStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_assessment_status_input::Builder,
    }
    impl UpdateAssessmentStatus {
        /// Creates a new `UpdateAssessmentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p> The current status of the assessment. </p>
        pub fn status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p> The current status of the assessment. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateControl`.
    ///
    /// <p> Updates a custom control in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateControl {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_control_input::Builder,
    }
    impl UpdateControl {
        /// Creates a new `UpdateControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateControlOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateControlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p> The name of the updated control. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the updated control. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The optional description of the control. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> The optional description of the control. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p> The steps that you should follow to determine if the control is met. </p>
        pub fn testing_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.testing_information(input.into());
            self
        }
        /// <p> The steps that you should follow to determine if the control is met. </p>
        pub fn set_testing_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_testing_information(input);
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn action_plan_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_title(input.into());
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn set_action_plan_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_title(input);
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn action_plan_instructions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_instructions(input.into());
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn set_action_plan_instructions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_instructions(input);
            self
        }
        /// Appends an item to `controlMappingSources`.
        ///
        /// To override the contents of this collection use [`set_control_mapping_sources`](Self::set_control_mapping_sources).
        ///
        /// <p> The data mapping sources for the control. </p>
        pub fn control_mapping_sources(
            mut self,
            input: crate::model::ControlMappingSource,
        ) -> Self {
            self.inner = self.inner.control_mapping_sources(input);
            self
        }
        /// <p> The data mapping sources for the control. </p>
        pub fn set_control_mapping_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
        ) -> Self {
            self.inner = self.inner.set_control_mapping_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSettings`.
    ///
    /// <p> Updates Audit Manager settings for the current user account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSettings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_settings_input::Builder,
    }
    impl UpdateSettings {
        /// Creates a new `UpdateSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSettingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to. </p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic(input.into());
            self
        }
        /// <p> The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to. </p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sns_topic(input);
            self
        }
        /// <p> The default storage destination for assessment reports. </p>
        pub fn default_assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.inner = self.inner.default_assessment_reports_destination(input);
            self
        }
        /// <p> The default storage destination for assessment reports. </p>
        pub fn set_default_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.inner = self.inner.set_default_assessment_reports_destination(input);
            self
        }
        /// Appends an item to `defaultProcessOwners`.
        ///
        /// To override the contents of this collection use [`set_default_process_owners`](Self::set_default_process_owners).
        ///
        /// <p> A list of the default audit owners. </p>
        pub fn default_process_owners(mut self, input: crate::model::Role) -> Self {
            self.inner = self.inner.default_process_owners(input);
            self
        }
        /// <p> A list of the default audit owners. </p>
        pub fn set_default_process_owners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.inner = self.inner.set_default_process_owners(input);
            self
        }
        /// <p> The KMS key details. </p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(input.into());
            self
        }
        /// <p> The KMS key details. </p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateAssessmentReportIntegrity`.
    ///
    /// <p> Validates the integrity of an assessment report in Audit Manager. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ValidateAssessmentReportIntegrity {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::validate_assessment_report_integrity_input::Builder,
    }
    impl ValidateAssessmentReportIntegrity {
        /// Creates a new `ValidateAssessmentReportIntegrity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateAssessmentReportIntegrityOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateAssessmentReportIntegrityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The relative path of the Amazon S3 bucket that the assessment report is stored in. </p>
        pub fn s3_relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_relative_path(input.into());
            self
        }
        /// <p> The relative path of the Amazon S3 bucket that the assessment report is stored in. </p>
        pub fn set_s3_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_relative_path(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
