// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateAssessmentReportEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateAssessmentReportEvidenceFolderError {
    /// Kind of error that occurred.
    pub kind: AssociateAssessmentReportEvidenceFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateAssessmentReportEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateAssessmentReportEvidenceFolderErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateAssessmentReportEvidenceFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateAssessmentReportEvidenceFolderError {
    fn code(&self) -> Option<&str> {
        AssociateAssessmentReportEvidenceFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateAssessmentReportEvidenceFolderError {
    /// Creates a new `AssociateAssessmentReportEvidenceFolderError`.
    pub fn new(
        kind: AssociateAssessmentReportEvidenceFolderErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateAssessmentReportEvidenceFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateAssessmentReportEvidenceFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateAssessmentReportEvidenceFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateAssessmentReportEvidenceFolderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAssessmentReportEvidenceFolderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssessmentReportEvidenceFolderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateAssessmentReportEvidenceFolderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateAssessmentReportEvidenceFolderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateAssessmentReportEvidenceFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            AssociateAssessmentReportEvidenceFolderErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchAssociateAssessmentReportEvidence` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAssociateAssessmentReportEvidenceError {
    /// Kind of error that occurred.
    pub kind: BatchAssociateAssessmentReportEvidenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAssociateAssessmentReportEvidence` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAssociateAssessmentReportEvidenceErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAssociateAssessmentReportEvidenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAssociateAssessmentReportEvidenceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchAssociateAssessmentReportEvidenceError {
    fn code(&self) -> Option<&str> {
        BatchAssociateAssessmentReportEvidenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAssociateAssessmentReportEvidenceError {
    /// Creates a new `BatchAssociateAssessmentReportEvidenceError`.
    pub fn new(
        kind: BatchAssociateAssessmentReportEvidenceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAssociateAssessmentReportEvidenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAssociateAssessmentReportEvidenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAssociateAssessmentReportEvidenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAssociateAssessmentReportEvidenceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchAssociateAssessmentReportEvidenceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateAssessmentReportEvidenceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateAssessmentReportEvidenceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateAssessmentReportEvidenceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateAssessmentReportEvidenceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateAssessmentReportEvidenceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchAssociateAssessmentReportEvidenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAssociateAssessmentReportEvidenceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchAssociateAssessmentReportEvidenceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchCreateDelegationByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchCreateDelegationByAssessmentError {
    /// Kind of error that occurred.
    pub kind: BatchCreateDelegationByAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchCreateDelegationByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchCreateDelegationByAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchCreateDelegationByAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchCreateDelegationByAssessmentErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateDelegationByAssessmentErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateDelegationByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateDelegationByAssessmentErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchCreateDelegationByAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchCreateDelegationByAssessmentError {
    fn code(&self) -> Option<&str> {
        BatchCreateDelegationByAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchCreateDelegationByAssessmentError {
    /// Creates a new `BatchCreateDelegationByAssessmentError`.
    pub fn new(
        kind: BatchCreateDelegationByAssessmentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchCreateDelegationByAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchCreateDelegationByAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchCreateDelegationByAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchCreateDelegationByAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchCreateDelegationByAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateDelegationByAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateDelegationByAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateDelegationByAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateDelegationByAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateDelegationByAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchCreateDelegationByAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchCreateDelegationByAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchCreateDelegationByAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchCreateDelegationByAssessmentErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchCreateDelegationByAssessmentErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            BatchCreateDelegationByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchCreateDelegationByAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            BatchCreateDelegationByAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteDelegationByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteDelegationByAssessmentError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteDelegationByAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteDelegationByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteDelegationByAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteDelegationByAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteDelegationByAssessmentErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchDeleteDelegationByAssessmentErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchDeleteDelegationByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchDeleteDelegationByAssessmentErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchDeleteDelegationByAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteDelegationByAssessmentError {
    fn code(&self) -> Option<&str> {
        BatchDeleteDelegationByAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteDelegationByAssessmentError {
    /// Creates a new `BatchDeleteDelegationByAssessmentError`.
    pub fn new(
        kind: BatchDeleteDelegationByAssessmentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteDelegationByAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteDelegationByAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteDelegationByAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteDelegationByAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteDelegationByAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDelegationByAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDelegationByAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDelegationByAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDelegationByAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDelegationByAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDeleteDelegationByAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteDelegationByAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchDeleteDelegationByAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteDelegationByAssessmentErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchDeleteDelegationByAssessmentErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            BatchDeleteDelegationByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchDeleteDelegationByAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            BatchDeleteDelegationByAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDisassociateAssessmentReportEvidence` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisassociateAssessmentReportEvidenceError {
    /// Kind of error that occurred.
    pub kind: BatchDisassociateAssessmentReportEvidenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisassociateAssessmentReportEvidence` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisassociateAssessmentReportEvidenceErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisassociateAssessmentReportEvidenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisassociateAssessmentReportEvidenceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateAssessmentReportEvidenceErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            BatchDisassociateAssessmentReportEvidenceErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateAssessmentReportEvidenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDisassociateAssessmentReportEvidenceError {
    fn code(&self) -> Option<&str> {
        BatchDisassociateAssessmentReportEvidenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisassociateAssessmentReportEvidenceError {
    /// Creates a new `BatchDisassociateAssessmentReportEvidenceError`.
    pub fn new(
        kind: BatchDisassociateAssessmentReportEvidenceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisassociateAssessmentReportEvidenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisassociateAssessmentReportEvidenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisassociateAssessmentReportEvidenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisassociateAssessmentReportEvidenceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDisassociateAssessmentReportEvidenceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateAssessmentReportEvidenceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateAssessmentReportEvidenceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateAssessmentReportEvidenceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateAssessmentReportEvidenceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateAssessmentReportEvidenceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchDisassociateAssessmentReportEvidenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisassociateAssessmentReportEvidenceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateAssessmentReportEvidenceErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateAssessmentReportEvidenceErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            BatchDisassociateAssessmentReportEvidenceErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateAssessmentReportEvidenceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchImportEvidenceToAssessmentControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchImportEvidenceToAssessmentControlError {
    /// Kind of error that occurred.
    pub kind: BatchImportEvidenceToAssessmentControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchImportEvidenceToAssessmentControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchImportEvidenceToAssessmentControlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchImportEvidenceToAssessmentControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchImportEvidenceToAssessmentControlErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchImportEvidenceToAssessmentControlError {
    fn code(&self) -> Option<&str> {
        BatchImportEvidenceToAssessmentControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchImportEvidenceToAssessmentControlError {
    /// Creates a new `BatchImportEvidenceToAssessmentControlError`.
    pub fn new(
        kind: BatchImportEvidenceToAssessmentControlErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchImportEvidenceToAssessmentControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchImportEvidenceToAssessmentControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchImportEvidenceToAssessmentControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchImportEvidenceToAssessmentControlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchImportEvidenceToAssessmentControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchImportEvidenceToAssessmentControlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchImportEvidenceToAssessmentControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchImportEvidenceToAssessmentControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchImportEvidenceToAssessmentControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchImportEvidenceToAssessmentControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchImportEvidenceToAssessmentControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchImportEvidenceToAssessmentControlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchImportEvidenceToAssessmentControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchImportEvidenceToAssessmentControlErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            BatchImportEvidenceToAssessmentControlErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssessmentError {
    /// Kind of error that occurred.
    pub kind: CreateAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateAssessmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAssessmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssessmentError {
    fn code(&self) -> Option<&str> {
        CreateAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssessmentError {
    /// Creates a new `CreateAssessmentError`.
    pub fn new(kind: CreateAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateAssessmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            CreateAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssessmentFrameworkError {
    /// Kind of error that occurred.
    pub kind: CreateAssessmentFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssessmentFrameworkErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssessmentFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAssessmentFrameworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAssessmentFrameworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateAssessmentFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssessmentFrameworkError {
    fn code(&self) -> Option<&str> {
        CreateAssessmentFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssessmentFrameworkError {
    /// Creates a new `CreateAssessmentFrameworkError`.
    pub fn new(kind: CreateAssessmentFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssessmentFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssessmentFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssessmentFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssessmentFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssessmentFrameworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentFrameworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentFrameworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentFrameworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentFrameworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentFrameworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentFrameworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentFrameworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateAssessmentFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAssessmentFrameworkErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAssessmentFrameworkErrorKind::ValidationException(_inner) => Some(_inner),
            CreateAssessmentFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAssessmentReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAssessmentReportError {
    /// Kind of error that occurred.
    pub kind: CreateAssessmentReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAssessmentReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAssessmentReportErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAssessmentReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAssessmentReportErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAssessmentReportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateAssessmentReportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAssessmentReportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateAssessmentReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAssessmentReportError {
    fn code(&self) -> Option<&str> {
        CreateAssessmentReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAssessmentReportError {
    /// Creates a new `CreateAssessmentReportError`.
    pub fn new(kind: CreateAssessmentReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAssessmentReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAssessmentReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAssessmentReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAssessmentReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAssessmentReportErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentReportErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentReportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentReportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentReportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAssessmentReportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAssessmentReportErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateAssessmentReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAssessmentReportErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAssessmentReportErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateAssessmentReportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAssessmentReportErrorKind::ValidationException(_inner) => Some(_inner),
            CreateAssessmentReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateControlError {
    /// Kind of error that occurred.
    pub kind: CreateControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateControlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateControlError {
    fn code(&self) -> Option<&str> {
        CreateControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateControlError {
    /// Creates a new `CreateControlError`.
    pub fn new(kind: CreateControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateControlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateControlErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateControlErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateControlErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateControlErrorKind::ValidationException(_inner) => Some(_inner),
            CreateControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssessmentError {
    /// Kind of error that occurred.
    pub kind: DeleteAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAssessmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAssessmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssessmentError {
    fn code(&self) -> Option<&str> {
        DeleteAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssessmentError {
    /// Creates a new `DeleteAssessmentError`.
    pub fn new(kind: DeleteAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAssessmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssessmentFrameworkError {
    /// Kind of error that occurred.
    pub kind: DeleteAssessmentFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssessmentFrameworkErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssessmentFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssessmentFrameworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAssessmentFrameworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAssessmentFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssessmentFrameworkError {
    fn code(&self) -> Option<&str> {
        DeleteAssessmentFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssessmentFrameworkError {
    /// Creates a new `DeleteAssessmentFrameworkError`.
    pub fn new(kind: DeleteAssessmentFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssessmentFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssessmentFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssessmentFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssessmentFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAssessmentFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssessmentFrameworkErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAssessmentFrameworkErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAssessmentFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssessmentFrameworkShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssessmentFrameworkShareError {
    /// Kind of error that occurred.
    pub kind: DeleteAssessmentFrameworkShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssessmentFrameworkShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssessmentFrameworkShareErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssessmentFrameworkShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssessmentFrameworkShareErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssessmentFrameworkShareErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAssessmentFrameworkShareErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAssessmentFrameworkShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssessmentFrameworkShareError {
    fn code(&self) -> Option<&str> {
        DeleteAssessmentFrameworkShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssessmentFrameworkShareError {
    /// Creates a new `DeleteAssessmentFrameworkShareError`.
    pub fn new(
        kind: DeleteAssessmentFrameworkShareErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssessmentFrameworkShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssessmentFrameworkShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssessmentFrameworkShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssessmentFrameworkShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkShareErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkShareErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkShareErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkShareErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentFrameworkShareErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentFrameworkShareErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAssessmentFrameworkShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssessmentFrameworkShareErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssessmentFrameworkShareErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteAssessmentFrameworkShareErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAssessmentFrameworkShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAssessmentReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAssessmentReportError {
    /// Kind of error that occurred.
    pub kind: DeleteAssessmentReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAssessmentReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAssessmentReportErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAssessmentReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAssessmentReportErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAssessmentReportErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAssessmentReportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAssessmentReportErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAssessmentReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAssessmentReportError {
    fn code(&self) -> Option<&str> {
        DeleteAssessmentReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAssessmentReportError {
    /// Creates a new `DeleteAssessmentReportError`.
    pub fn new(kind: DeleteAssessmentReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAssessmentReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAssessmentReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAssessmentReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAssessmentReportErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAssessmentReportErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentReportErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentReportErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentReportErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentReportErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAssessmentReportErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAssessmentReportErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAssessmentReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAssessmentReportErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAssessmentReportErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAssessmentReportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAssessmentReportErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAssessmentReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteControlError {
    /// Kind of error that occurred.
    pub kind: DeleteControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteControlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteControlError {
    fn code(&self) -> Option<&str> {
        DeleteControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteControlError {
    /// Creates a new `DeleteControlError`.
    pub fn new(kind: DeleteControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteControlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteControlErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteControlErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteControlErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteControlErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterAccountError {
    /// Kind of error that occurred.
    pub kind: DeregisterAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterAccountErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeregisterAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeregisterAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeregisterAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeregisterAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterAccountError {
    fn code(&self) -> Option<&str> {
        DeregisterAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterAccountError {
    /// Creates a new `DeregisterAccountError`.
    pub fn new(kind: DeregisterAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeregisterAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeregisterAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            DeregisterAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeregisterAccountErrorKind::ValidationException(_inner) => Some(_inner),
            DeregisterAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterOrganizationAdminAccountError {
    /// Kind of error that occurred.
    pub kind: DeregisterOrganizationAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterOrganizationAdminAccountErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterOrganizationAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterOrganizationAdminAccountErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeregisterOrganizationAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterOrganizationAdminAccountError {
    fn code(&self) -> Option<&str> {
        DeregisterOrganizationAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterOrganizationAdminAccountError {
    /// Creates a new `DeregisterOrganizationAdminAccountError`.
    pub fn new(
        kind: DeregisterOrganizationAdminAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterOrganizationAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterOrganizationAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterOrganizationAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterOrganizationAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterOrganizationAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterOrganizationAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterOrganizationAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterOrganizationAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterOrganizationAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterOrganizationAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterOrganizationAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterOrganizationAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeregisterOrganizationAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeregisterOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeregisterOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeregisterOrganizationAdminAccountErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeregisterOrganizationAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateAssessmentReportEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateAssessmentReportEvidenceFolderError {
    /// Kind of error that occurred.
    pub kind: DisassociateAssessmentReportEvidenceFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateAssessmentReportEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateAssessmentReportEvidenceFolderErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateAssessmentReportEvidenceFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateAssessmentReportEvidenceFolderErrorKind::InternalServerException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateAssessmentReportEvidenceFolderErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateAssessmentReportEvidenceFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateAssessmentReportEvidenceFolderError {
    fn code(&self) -> Option<&str> {
        DisassociateAssessmentReportEvidenceFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateAssessmentReportEvidenceFolderError {
    /// Creates a new `DisassociateAssessmentReportEvidenceFolderError`.
    pub fn new(
        kind: DisassociateAssessmentReportEvidenceFolderErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateAssessmentReportEvidenceFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateAssessmentReportEvidenceFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateAssessmentReportEvidenceFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateAssessmentReportEvidenceFolderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAssessmentReportEvidenceFolderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssessmentReportEvidenceFolderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateAssessmentReportEvidenceFolderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateAssessmentReportEvidenceFolderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateAssessmentReportEvidenceFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateAssessmentReportEvidenceFolderErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateAssessmentReportEvidenceFolderErrorKind::InternalServerException(
                _inner,
            ) => Some(_inner),
            DisassociateAssessmentReportEvidenceFolderErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            DisassociateAssessmentReportEvidenceFolderErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateAssessmentReportEvidenceFolderErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccountStatusError {
    /// Kind of error that occurred.
    pub kind: GetAccountStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccountStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccountStatusErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccountStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccountStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAccountStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccountStatusError {
    fn code(&self) -> Option<&str> {
        GetAccountStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccountStatusError {
    /// Creates a new `GetAccountStatusError`.
    pub fn new(kind: GetAccountStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccountStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccountStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccountStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccountStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccountStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccountStatusErrorKind::InternalServerException(_)
        )
    }
}
impl std::error::Error for GetAccountStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccountStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAccountStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssessmentError {
    /// Kind of error that occurred.
    pub kind: GetAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssessmentError {
    fn code(&self) -> Option<&str> {
        GetAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssessmentError {
    /// Creates a new `GetAssessmentError`.
    pub fn new(kind: GetAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetAssessmentErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetAssessmentErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAssessmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssessmentFrameworkError {
    /// Kind of error that occurred.
    pub kind: GetAssessmentFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssessmentFrameworkErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssessmentFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAssessmentFrameworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAssessmentFrameworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAssessmentFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssessmentFrameworkError {
    fn code(&self) -> Option<&str> {
        GetAssessmentFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssessmentFrameworkError {
    /// Creates a new `GetAssessmentFrameworkError`.
    pub fn new(kind: GetAssessmentFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssessmentFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssessmentFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssessmentFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssessmentFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAssessmentFrameworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentFrameworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentFrameworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentFrameworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentFrameworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentFrameworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentFrameworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentFrameworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAssessmentFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAssessmentFrameworkErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAssessmentFrameworkErrorKind::ValidationException(_inner) => Some(_inner),
            GetAssessmentFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAssessmentReportUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAssessmentReportUrlError {
    /// Kind of error that occurred.
    pub kind: GetAssessmentReportUrlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAssessmentReportUrl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAssessmentReportUrlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAssessmentReportUrlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAssessmentReportUrlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAssessmentReportUrlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAssessmentReportUrlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAssessmentReportUrlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAssessmentReportUrlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAssessmentReportUrlError {
    fn code(&self) -> Option<&str> {
        GetAssessmentReportUrlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAssessmentReportUrlError {
    /// Creates a new `GetAssessmentReportUrlError`.
    pub fn new(kind: GetAssessmentReportUrlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAssessmentReportUrlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAssessmentReportUrlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAssessmentReportUrlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAssessmentReportUrlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAssessmentReportUrlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportUrlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportUrlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportUrlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportUrlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportUrlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAssessmentReportUrlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAssessmentReportUrlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAssessmentReportUrlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAssessmentReportUrlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAssessmentReportUrlErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAssessmentReportUrlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAssessmentReportUrlErrorKind::ValidationException(_inner) => Some(_inner),
            GetAssessmentReportUrlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetChangeLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetChangeLogsError {
    /// Kind of error that occurred.
    pub kind: GetChangeLogsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetChangeLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetChangeLogsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetChangeLogsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetChangeLogsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetChangeLogsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetChangeLogsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetChangeLogsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetChangeLogsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetChangeLogsError {
    fn code(&self) -> Option<&str> {
        GetChangeLogsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetChangeLogsError {
    /// Creates a new `GetChangeLogsError`.
    pub fn new(kind: GetChangeLogsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetChangeLogsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetChangeLogsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetChangeLogsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetChangeLogsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetChangeLogsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetChangeLogsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetChangeLogsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChangeLogsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChangeLogsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetChangeLogsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetChangeLogsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetChangeLogsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetChangeLogsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetChangeLogsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetChangeLogsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetChangeLogsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetChangeLogsErrorKind::ValidationException(_inner) => Some(_inner),
            GetChangeLogsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetControlError {
    /// Kind of error that occurred.
    pub kind: GetControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetControlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetControlError {
    fn code(&self) -> Option<&str> {
        GetControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetControlError {
    /// Creates a new `GetControlError`.
    pub fn new(kind: GetControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetControlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetControlErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetControlErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetControlErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetControlErrorKind::InternalServerException(_inner) => Some(_inner),
            GetControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetControlErrorKind::ValidationException(_inner) => Some(_inner),
            GetControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDelegations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDelegationsError {
    /// Kind of error that occurred.
    pub kind: GetDelegationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDelegations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDelegationsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDelegationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDelegationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDelegationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDelegationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDelegationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDelegationsError {
    fn code(&self) -> Option<&str> {
        GetDelegationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDelegationsError {
    /// Creates a new `GetDelegationsError`.
    pub fn new(kind: GetDelegationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDelegationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDelegationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDelegationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDelegationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDelegationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDelegationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDelegationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDelegationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDelegationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetDelegationsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetDelegationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDelegationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDelegationsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDelegationsErrorKind::ValidationException(_inner) => Some(_inner),
            GetDelegationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEvidence` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEvidenceError {
    /// Kind of error that occurred.
    pub kind: GetEvidenceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEvidence` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEvidenceErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEvidenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEvidenceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEvidenceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEvidenceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEvidenceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEvidenceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEvidenceError {
    fn code(&self) -> Option<&str> {
        GetEvidenceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEvidenceError {
    /// Creates a new `GetEvidenceError`.
    pub fn new(kind: GetEvidenceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEvidenceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEvidenceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEvidenceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEvidenceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEvidenceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetEvidenceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetEvidenceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetEvidenceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetEvidenceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetEvidenceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetEvidenceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEvidenceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEvidenceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEvidenceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEvidenceErrorKind::ValidationException(_inner) => Some(_inner),
            GetEvidenceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEvidenceByEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEvidenceByEvidenceFolderError {
    /// Kind of error that occurred.
    pub kind: GetEvidenceByEvidenceFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEvidenceByEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEvidenceByEvidenceFolderErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEvidenceByEvidenceFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEvidenceByEvidenceFolderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEvidenceByEvidenceFolderErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEvidenceByEvidenceFolderErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetEvidenceByEvidenceFolderErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEvidenceByEvidenceFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEvidenceByEvidenceFolderError {
    fn code(&self) -> Option<&str> {
        GetEvidenceByEvidenceFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEvidenceByEvidenceFolderError {
    /// Creates a new `GetEvidenceByEvidenceFolderError`.
    pub fn new(kind: GetEvidenceByEvidenceFolderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEvidenceByEvidenceFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEvidenceByEvidenceFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEvidenceByEvidenceFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEvidenceByEvidenceFolderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEvidenceByEvidenceFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceByEvidenceFolderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceByEvidenceFolderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceByEvidenceFolderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceByEvidenceFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceByEvidenceFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceByEvidenceFolderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceByEvidenceFolderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEvidenceByEvidenceFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEvidenceByEvidenceFolderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEvidenceByEvidenceFolderErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEvidenceByEvidenceFolderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEvidenceByEvidenceFolderErrorKind::ValidationException(_inner) => Some(_inner),
            GetEvidenceByEvidenceFolderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEvidenceFolderError {
    /// Kind of error that occurred.
    pub kind: GetEvidenceFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEvidenceFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEvidenceFolderErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEvidenceFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEvidenceFolderErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEvidenceFolderErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEvidenceFolderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEvidenceFolderErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEvidenceFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEvidenceFolderError {
    fn code(&self) -> Option<&str> {
        GetEvidenceFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEvidenceFolderError {
    /// Creates a new `GetEvidenceFolderError`.
    pub fn new(kind: GetEvidenceFolderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEvidenceFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEvidenceFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEvidenceFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEvidenceFolderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEvidenceFolderErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFolderErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFolderErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFolderErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFolderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFolderErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFolderErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFolderErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEvidenceFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEvidenceFolderErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEvidenceFolderErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEvidenceFolderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEvidenceFolderErrorKind::ValidationException(_inner) => Some(_inner),
            GetEvidenceFolderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEvidenceFoldersByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEvidenceFoldersByAssessmentError {
    /// Kind of error that occurred.
    pub kind: GetEvidenceFoldersByAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEvidenceFoldersByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEvidenceFoldersByAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEvidenceFoldersByAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEvidenceFoldersByAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetEvidenceFoldersByAssessmentErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetEvidenceFoldersByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetEvidenceFoldersByAssessmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetEvidenceFoldersByAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEvidenceFoldersByAssessmentError {
    fn code(&self) -> Option<&str> {
        GetEvidenceFoldersByAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEvidenceFoldersByAssessmentError {
    /// Creates a new `GetEvidenceFoldersByAssessmentError`.
    pub fn new(
        kind: GetEvidenceFoldersByAssessmentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEvidenceFoldersByAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEvidenceFoldersByAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEvidenceFoldersByAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEvidenceFoldersByAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEvidenceFoldersByAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEvidenceFoldersByAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetEvidenceFoldersByAssessmentErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetEvidenceFoldersByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetEvidenceFoldersByAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetEvidenceFoldersByAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEvidenceFoldersByAssessmentControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEvidenceFoldersByAssessmentControlError {
    /// Kind of error that occurred.
    pub kind: GetEvidenceFoldersByAssessmentControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEvidenceFoldersByAssessmentControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEvidenceFoldersByAssessmentControlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEvidenceFoldersByAssessmentControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEvidenceFoldersByAssessmentControlErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEvidenceFoldersByAssessmentControlError {
    fn code(&self) -> Option<&str> {
        GetEvidenceFoldersByAssessmentControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEvidenceFoldersByAssessmentControlError {
    /// Creates a new `GetEvidenceFoldersByAssessmentControlError`.
    pub fn new(
        kind: GetEvidenceFoldersByAssessmentControlErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEvidenceFoldersByAssessmentControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEvidenceFoldersByAssessmentControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEvidenceFoldersByAssessmentControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEvidenceFoldersByAssessmentControlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentControlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvidenceFoldersByAssessmentControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvidenceFoldersByAssessmentControlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetEvidenceFoldersByAssessmentControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEvidenceFoldersByAssessmentControlErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            GetEvidenceFoldersByAssessmentControlErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightsError {
    /// Kind of error that occurred.
    pub kind: GetInsightsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInsightsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetInsightsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightsError {
    fn code(&self) -> Option<&str> {
        GetInsightsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightsError {
    /// Creates a new `GetInsightsError`.
    pub fn new(kind: GetInsightsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetInsightsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetInsightsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetInsightsErrorKind::InternalServerException(_))
    }
}
impl std::error::Error for GetInsightsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInsightsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetInsightsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInsightsByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightsByAssessmentError {
    /// Kind of error that occurred.
    pub kind: GetInsightsByAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsightsByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightsByAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightsByAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightsByAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInsightsByAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetInsightsByAssessmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetInsightsByAssessmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetInsightsByAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightsByAssessmentError {
    fn code(&self) -> Option<&str> {
        GetInsightsByAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightsByAssessmentError {
    /// Creates a new `GetInsightsByAssessmentError`.
    pub fn new(kind: GetInsightsByAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightsByAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightsByAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightsByAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightsByAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightsByAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightsByAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightsByAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightsByAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightsByAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightsByAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightsByAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightsByAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetInsightsByAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightsByAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInsightsByAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            GetInsightsByAssessmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetInsightsByAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            GetInsightsByAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOrganizationAdminAccountError {
    /// Kind of error that occurred.
    pub kind: GetOrganizationAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOrganizationAdminAccountErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOrganizationAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetOrganizationAdminAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetOrganizationAdminAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetOrganizationAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOrganizationAdminAccountError {
    fn code(&self) -> Option<&str> {
        GetOrganizationAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOrganizationAdminAccountError {
    /// Creates a new `GetOrganizationAdminAccountError`.
    pub fn new(kind: GetOrganizationAdminAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOrganizationAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOrganizationAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOrganizationAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOrganizationAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOrganizationAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOrganizationAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOrganizationAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetOrganizationAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetOrganizationAdminAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            GetOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetOrganizationAdminAccountErrorKind::ValidationException(_inner) => Some(_inner),
            GetOrganizationAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServicesInScope` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServicesInScopeError {
    /// Kind of error that occurred.
    pub kind: GetServicesInScopeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServicesInScope` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServicesInScopeErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServicesInScopeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServicesInScopeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServicesInScopeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetServicesInScopeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetServicesInScopeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServicesInScopeError {
    fn code(&self) -> Option<&str> {
        GetServicesInScopeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServicesInScopeError {
    /// Creates a new `GetServicesInScopeError`.
    pub fn new(kind: GetServicesInScopeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServicesInScopeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServicesInScopeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServicesInScopeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServicesInScopeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServicesInScopeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServicesInScopeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServicesInScopeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServicesInScopeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServicesInScopeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServicesInScopeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetServicesInScopeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServicesInScopeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServicesInScopeErrorKind::InternalServerException(_inner) => Some(_inner),
            GetServicesInScopeErrorKind::ValidationException(_inner) => Some(_inner),
            GetServicesInScopeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSettingsError {
    /// Kind of error that occurred.
    pub kind: GetSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSettingsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSettingsError {
    fn code(&self) -> Option<&str> {
        GetSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSettingsError {
    /// Creates a new `GetSettingsError`.
    pub fn new(kind: GetSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSettingsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetSettingsErrorKind::InternalServerException(_))
    }
}
impl std::error::Error for GetSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssessmentControlInsightsByControlDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentControlInsightsByControlDomainError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentControlInsightsByControlDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentControlInsightsByControlDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentControlInsightsByControlDomainErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentControlInsightsByControlDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentControlInsightsByControlDomainErrorKind::AccessDeniedException(
                _inner,
            ) => _inner.fmt(f),
            ListAssessmentControlInsightsByControlDomainErrorKind::InternalServerException(
                _inner,
            ) => _inner.fmt(f),
            ListAssessmentControlInsightsByControlDomainErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            ListAssessmentControlInsightsByControlDomainErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListAssessmentControlInsightsByControlDomainErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for ListAssessmentControlInsightsByControlDomainError
{
    fn code(&self) -> Option<&str> {
        ListAssessmentControlInsightsByControlDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentControlInsightsByControlDomainError {
    /// Creates a new `ListAssessmentControlInsightsByControlDomainError`.
    pub fn new(
        kind: ListAssessmentControlInsightsByControlDomainErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentControlInsightsByControlDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentControlInsightsByControlDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentControlInsightsByControlDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentControlInsightsByControlDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentControlInsightsByControlDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentControlInsightsByControlDomainErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentControlInsightsByControlDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentControlInsightsByControlDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentControlInsightsByControlDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentControlInsightsByControlDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentControlInsightsByControlDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentControlInsightsByControlDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAssessmentControlInsightsByControlDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentControlInsightsByControlDomainErrorKind::AccessDeniedException(
                _inner,
            ) => Some(_inner),
            ListAssessmentControlInsightsByControlDomainErrorKind::InternalServerException(
                _inner,
            ) => Some(_inner),
            ListAssessmentControlInsightsByControlDomainErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            ListAssessmentControlInsightsByControlDomainErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListAssessmentControlInsightsByControlDomainErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListAssessmentFrameworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentFrameworksError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentFrameworksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentFrameworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentFrameworksErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentFrameworksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentFrameworksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAssessmentFrameworksErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAssessmentFrameworksErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAssessmentFrameworksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentFrameworksError {
    fn code(&self) -> Option<&str> {
        ListAssessmentFrameworksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentFrameworksError {
    /// Creates a new `ListAssessmentFrameworksError`.
    pub fn new(kind: ListAssessmentFrameworksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentFrameworksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentFrameworksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentFrameworksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentFrameworksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentFrameworksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentFrameworksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentFrameworksErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentFrameworksErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentFrameworksErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentFrameworksErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAssessmentFrameworksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentFrameworksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAssessmentFrameworksErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAssessmentFrameworksErrorKind::ValidationException(_inner) => Some(_inner),
            ListAssessmentFrameworksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssessmentFrameworkShareRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentFrameworkShareRequestsError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentFrameworkShareRequestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentFrameworkShareRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentFrameworkShareRequestsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentFrameworkShareRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentFrameworkShareRequestsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListAssessmentFrameworkShareRequestsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListAssessmentFrameworkShareRequestsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListAssessmentFrameworkShareRequestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentFrameworkShareRequestsError {
    fn code(&self) -> Option<&str> {
        ListAssessmentFrameworkShareRequestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentFrameworkShareRequestsError {
    /// Creates a new `ListAssessmentFrameworkShareRequestsError`.
    pub fn new(
        kind: ListAssessmentFrameworkShareRequestsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentFrameworkShareRequestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentFrameworkShareRequestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentFrameworkShareRequestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentFrameworkShareRequestsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentFrameworkShareRequestsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentFrameworkShareRequestsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentFrameworkShareRequestsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentFrameworkShareRequestsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentFrameworkShareRequestsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentFrameworkShareRequestsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAssessmentFrameworkShareRequestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentFrameworkShareRequestsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListAssessmentFrameworkShareRequestsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListAssessmentFrameworkShareRequestsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListAssessmentFrameworkShareRequestsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListAssessmentReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentReportsError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentReportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessmentReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentReportsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentReportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentReportsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAssessmentReportsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAssessmentReportsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAssessmentReportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentReportsError {
    fn code(&self) -> Option<&str> {
        ListAssessmentReportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentReportsError {
    /// Creates a new `ListAssessmentReportsError`.
    pub fn new(kind: ListAssessmentReportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentReportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentReportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentReportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentReportsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentReportsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentReportsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentReportsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentReportsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentReportsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentReportsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAssessmentReportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentReportsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAssessmentReportsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAssessmentReportsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAssessmentReportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssessments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssessmentsError {
    /// Kind of error that occurred.
    pub kind: ListAssessmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssessments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssessmentsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssessmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssessmentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAssessmentsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAssessmentsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAssessmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssessmentsError {
    fn code(&self) -> Option<&str> {
        ListAssessmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssessmentsError {
    /// Creates a new `ListAssessmentsError`.
    pub fn new(kind: ListAssessmentsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssessmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssessmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssessmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssessmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssessmentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssessmentsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssessmentsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListAssessmentsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListAssessmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssessmentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAssessmentsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAssessmentsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAssessmentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListControlDomainInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListControlDomainInsightsError {
    /// Kind of error that occurred.
    pub kind: ListControlDomainInsightsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListControlDomainInsights` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListControlDomainInsightsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListControlDomainInsightsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListControlDomainInsightsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListControlDomainInsightsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListControlDomainInsightsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListControlDomainInsightsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListControlDomainInsightsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListControlDomainInsightsError {
    fn code(&self) -> Option<&str> {
        ListControlDomainInsightsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListControlDomainInsightsError {
    /// Creates a new `ListControlDomainInsightsError`.
    pub fn new(kind: ListControlDomainInsightsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListControlDomainInsightsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListControlDomainInsightsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListControlDomainInsightsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListControlDomainInsightsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListControlDomainInsightsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListControlDomainInsightsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListControlDomainInsightsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListControlDomainInsightsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListControlDomainInsightsErrorKind::ValidationException(_inner) => Some(_inner),
            ListControlDomainInsightsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListControlDomainInsightsByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListControlDomainInsightsByAssessmentError {
    /// Kind of error that occurred.
    pub kind: ListControlDomainInsightsByAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListControlDomainInsightsByAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListControlDomainInsightsByAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListControlDomainInsightsByAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListControlDomainInsightsByAssessmentErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListControlDomainInsightsByAssessmentErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListControlDomainInsightsByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListControlDomainInsightsByAssessmentErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListControlDomainInsightsByAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListControlDomainInsightsByAssessmentError {
    fn code(&self) -> Option<&str> {
        ListControlDomainInsightsByAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListControlDomainInsightsByAssessmentError {
    /// Creates a new `ListControlDomainInsightsByAssessmentError`.
    pub fn new(
        kind: ListControlDomainInsightsByAssessmentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListControlDomainInsightsByAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListControlDomainInsightsByAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListControlDomainInsightsByAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListControlDomainInsightsByAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsByAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsByAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsByAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsByAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsByAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsByAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlDomainInsightsByAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlDomainInsightsByAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListControlDomainInsightsByAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListControlDomainInsightsByAssessmentErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListControlDomainInsightsByAssessmentErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListControlDomainInsightsByAssessmentErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListControlDomainInsightsByAssessmentErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListControlDomainInsightsByAssessmentErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListControlInsightsByControlDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListControlInsightsByControlDomainError {
    /// Kind of error that occurred.
    pub kind: ListControlInsightsByControlDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListControlInsightsByControlDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListControlInsightsByControlDomainErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListControlInsightsByControlDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListControlInsightsByControlDomainErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListControlInsightsByControlDomainErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListControlInsightsByControlDomainErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListControlInsightsByControlDomainErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListControlInsightsByControlDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListControlInsightsByControlDomainError {
    fn code(&self) -> Option<&str> {
        ListControlInsightsByControlDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListControlInsightsByControlDomainError {
    /// Creates a new `ListControlInsightsByControlDomainError`.
    pub fn new(
        kind: ListControlInsightsByControlDomainErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListControlInsightsByControlDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListControlInsightsByControlDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListControlInsightsByControlDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListControlInsightsByControlDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListControlInsightsByControlDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlInsightsByControlDomainErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlInsightsByControlDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlInsightsByControlDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlInsightsByControlDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlInsightsByControlDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlInsightsByControlDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlInsightsByControlDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListControlInsightsByControlDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListControlInsightsByControlDomainErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListControlInsightsByControlDomainErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListControlInsightsByControlDomainErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListControlInsightsByControlDomainErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListControlInsightsByControlDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListControls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListControlsError {
    /// Kind of error that occurred.
    pub kind: ListControlsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListControls` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListControlsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListControlsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListControlsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListControlsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListControlsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListControlsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListControlsError {
    fn code(&self) -> Option<&str> {
        ListControlsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListControlsError {
    /// Creates a new `ListControlsError`.
    pub fn new(kind: ListControlsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListControlsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListControlsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListControlsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListControlsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListControlsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListControlsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListControlsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListControlsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListControlsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListControlsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListControlsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListControlsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListControlsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListControlsErrorKind::ValidationException(_inner) => Some(_inner),
            ListControlsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListKeywordsForDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListKeywordsForDataSourceError {
    /// Kind of error that occurred.
    pub kind: ListKeywordsForDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListKeywordsForDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListKeywordsForDataSourceErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListKeywordsForDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListKeywordsForDataSourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListKeywordsForDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListKeywordsForDataSourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListKeywordsForDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListKeywordsForDataSourceError {
    fn code(&self) -> Option<&str> {
        ListKeywordsForDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListKeywordsForDataSourceError {
    /// Creates a new `ListKeywordsForDataSourceError`.
    pub fn new(kind: ListKeywordsForDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListKeywordsForDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListKeywordsForDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListKeywordsForDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListKeywordsForDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListKeywordsForDataSourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeywordsForDataSourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeywordsForDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeywordsForDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListKeywordsForDataSourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListKeywordsForDataSourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListKeywordsForDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListKeywordsForDataSourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListKeywordsForDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListKeywordsForDataSourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListKeywordsForDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNotificationsError {
    /// Kind of error that occurred.
    pub kind: ListNotificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNotifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNotificationsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNotificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNotificationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNotificationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListNotificationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListNotificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNotificationsError {
    fn code(&self) -> Option<&str> {
        ListNotificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNotificationsError {
    /// Creates a new `ListNotificationsError`.
    pub fn new(kind: ListNotificationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNotificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNotificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNotificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNotificationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNotificationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNotificationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNotificationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNotificationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListNotificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNotificationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNotificationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListNotificationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListNotificationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterAccountError {
    /// Kind of error that occurred.
    pub kind: RegisterAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterAccountErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            RegisterAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RegisterAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RegisterAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterAccountError {
    fn code(&self) -> Option<&str> {
        RegisterAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterAccountError {
    /// Creates a new `RegisterAccountError`.
    pub fn new(kind: RegisterAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, RegisterAccountErrorKind::ValidationException(_))
    }
}
impl std::error::Error for RegisterAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            RegisterAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RegisterAccountErrorKind::ValidationException(_inner) => Some(_inner),
            RegisterAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterOrganizationAdminAccountError {
    /// Kind of error that occurred.
    pub kind: RegisterOrganizationAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterOrganizationAdminAccountErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterOrganizationAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            RegisterOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            RegisterOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            RegisterOrganizationAdminAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RegisterOrganizationAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterOrganizationAdminAccountError {
    fn code(&self) -> Option<&str> {
        RegisterOrganizationAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterOrganizationAdminAccountError {
    /// Creates a new `RegisterOrganizationAdminAccountError`.
    pub fn new(
        kind: RegisterOrganizationAdminAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterOrganizationAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterOrganizationAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterOrganizationAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterOrganizationAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterOrganizationAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterOrganizationAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterOrganizationAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterOrganizationAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterOrganizationAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterOrganizationAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterOrganizationAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterOrganizationAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for RegisterOrganizationAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            RegisterOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            RegisterOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            RegisterOrganizationAdminAccountErrorKind::ValidationException(_inner) => Some(_inner),
            RegisterOrganizationAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartAssessmentFrameworkShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartAssessmentFrameworkShareError {
    /// Kind of error that occurred.
    pub kind: StartAssessmentFrameworkShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartAssessmentFrameworkShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartAssessmentFrameworkShareErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartAssessmentFrameworkShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartAssessmentFrameworkShareErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartAssessmentFrameworkShareErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            StartAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            StartAssessmentFrameworkShareErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartAssessmentFrameworkShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartAssessmentFrameworkShareError {
    fn code(&self) -> Option<&str> {
        StartAssessmentFrameworkShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartAssessmentFrameworkShareError {
    /// Creates a new `StartAssessmentFrameworkShareError`.
    pub fn new(
        kind: StartAssessmentFrameworkShareErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartAssessmentFrameworkShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartAssessmentFrameworkShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartAssessmentFrameworkShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartAssessmentFrameworkShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartAssessmentFrameworkShareErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentFrameworkShareErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentFrameworkShareErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentFrameworkShareErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentFrameworkShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartAssessmentFrameworkShareErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartAssessmentFrameworkShareErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for StartAssessmentFrameworkShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartAssessmentFrameworkShareErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartAssessmentFrameworkShareErrorKind::InternalServerException(_inner) => Some(_inner),
            StartAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            StartAssessmentFrameworkShareErrorKind::ValidationException(_inner) => Some(_inner),
            StartAssessmentFrameworkShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssessmentError {
    /// Kind of error that occurred.
    pub kind: UpdateAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssessmentErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssessmentErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAssessmentErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAssessmentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssessmentErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssessmentError {
    fn code(&self) -> Option<&str> {
        UpdateAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssessmentError {
    /// Creates a new `UpdateAssessmentError`.
    pub fn new(kind: UpdateAssessmentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssessmentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssessmentErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAssessmentErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAssessmentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssessmentErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssessmentControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssessmentControlError {
    /// Kind of error that occurred.
    pub kind: UpdateAssessmentControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssessmentControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssessmentControlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssessmentControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssessmentControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAssessmentControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAssessmentControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssessmentControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAssessmentControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssessmentControlError {
    fn code(&self) -> Option<&str> {
        UpdateAssessmentControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssessmentControlError {
    /// Creates a new `UpdateAssessmentControlError`.
    pub fn new(kind: UpdateAssessmentControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssessmentControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssessmentControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssessmentControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssessmentControlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAssessmentControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssessmentControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAssessmentControlErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAssessmentControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssessmentControlErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAssessmentControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssessmentControlSetStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssessmentControlSetStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateAssessmentControlSetStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssessmentControlSetStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssessmentControlSetStatusErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssessmentControlSetStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssessmentControlSetStatusErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAssessmentControlSetStatusErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAssessmentControlSetStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAssessmentControlSetStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAssessmentControlSetStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssessmentControlSetStatusError {
    fn code(&self) -> Option<&str> {
        UpdateAssessmentControlSetStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssessmentControlSetStatusError {
    /// Creates a new `UpdateAssessmentControlSetStatusError`.
    pub fn new(
        kind: UpdateAssessmentControlSetStatusErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssessmentControlSetStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssessmentControlSetStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssessmentControlSetStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssessmentControlSetStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlSetStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlSetStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlSetStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlSetStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlSetStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlSetStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentControlSetStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentControlSetStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAssessmentControlSetStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssessmentControlSetStatusErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateAssessmentControlSetStatusErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateAssessmentControlSetStatusErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateAssessmentControlSetStatusErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAssessmentControlSetStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssessmentFrameworkError {
    /// Kind of error that occurred.
    pub kind: UpdateAssessmentFrameworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssessmentFramework` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssessmentFrameworkErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssessmentFrameworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAssessmentFrameworkErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssessmentFrameworkErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAssessmentFrameworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssessmentFrameworkError {
    fn code(&self) -> Option<&str> {
        UpdateAssessmentFrameworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssessmentFrameworkError {
    /// Creates a new `UpdateAssessmentFrameworkError`.
    pub fn new(kind: UpdateAssessmentFrameworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssessmentFrameworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssessmentFrameworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssessmentFrameworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssessmentFrameworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAssessmentFrameworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssessmentFrameworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAssessmentFrameworkErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAssessmentFrameworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssessmentFrameworkErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAssessmentFrameworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssessmentFrameworkShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssessmentFrameworkShareError {
    /// Kind of error that occurred.
    pub kind: UpdateAssessmentFrameworkShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssessmentFrameworkShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssessmentFrameworkShareErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssessmentFrameworkShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssessmentFrameworkShareErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAssessmentFrameworkShareErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAssessmentFrameworkShareErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAssessmentFrameworkShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssessmentFrameworkShareError {
    fn code(&self) -> Option<&str> {
        UpdateAssessmentFrameworkShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssessmentFrameworkShareError {
    /// Creates a new `UpdateAssessmentFrameworkShareError`.
    pub fn new(
        kind: UpdateAssessmentFrameworkShareErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssessmentFrameworkShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssessmentFrameworkShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssessmentFrameworkShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssessmentFrameworkShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkShareErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkShareErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkShareErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkShareErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkShareErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentFrameworkShareErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentFrameworkShareErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAssessmentFrameworkShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssessmentFrameworkShareErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAssessmentFrameworkShareErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateAssessmentFrameworkShareErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateAssessmentFrameworkShareErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAssessmentFrameworkShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAssessmentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAssessmentStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateAssessmentStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAssessmentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAssessmentStatusErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAssessmentStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAssessmentStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAssessmentStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAssessmentStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAssessmentStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAssessmentStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAssessmentStatusError {
    fn code(&self) -> Option<&str> {
        UpdateAssessmentStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAssessmentStatusError {
    /// Creates a new `UpdateAssessmentStatusError`.
    pub fn new(kind: UpdateAssessmentStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAssessmentStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAssessmentStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAssessmentStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAssessmentStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAssessmentStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAssessmentStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAssessmentStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAssessmentStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAssessmentStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAssessmentStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAssessmentStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAssessmentStatusErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAssessmentStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateControlError {
    /// Kind of error that occurred.
    pub kind: UpdateControlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateControl` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateControlErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateControlErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateControlErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateControlErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateControlErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateControlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateControlError {
    fn code(&self) -> Option<&str> {
        UpdateControlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateControlError {
    /// Creates a new `UpdateControlError`.
    pub fn new(kind: UpdateControlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateControlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateControlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateControlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateControlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateControlErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateControlErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateControlErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateControlErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateControlErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateControlErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateControlErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateControlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateControlErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateControlErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateControlErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateControlErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateControlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSettingsErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateSettingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateSettingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSettingsError {
    /// Creates a new `UpdateSettingsError`.
    pub fn new(kind: UpdateSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSettingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSettingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSettingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateSettingsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateSettingsErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateSettingsErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ValidateAssessmentReportIntegrity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ValidateAssessmentReportIntegrityError {
    /// Kind of error that occurred.
    pub kind: ValidateAssessmentReportIntegrityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ValidateAssessmentReportIntegrity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ValidateAssessmentReportIntegrityErrorKind {
    /// <p> Your account isn't registered with Audit Manager. Check the delegated
    /// administrator setup on the Audit Manager settings page, and try again. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> An internal service error occurred during the processing of your request. Try again
    /// later. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The resource that's specified in the request can't be found. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The request has invalid or missing parameters. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ValidateAssessmentReportIntegrityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ValidateAssessmentReportIntegrityErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ValidateAssessmentReportIntegrityErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ValidateAssessmentReportIntegrityErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ValidateAssessmentReportIntegrityErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ValidateAssessmentReportIntegrityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ValidateAssessmentReportIntegrityError {
    fn code(&self) -> Option<&str> {
        ValidateAssessmentReportIntegrityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ValidateAssessmentReportIntegrityError {
    /// Creates a new `ValidateAssessmentReportIntegrityError`.
    pub fn new(
        kind: ValidateAssessmentReportIntegrityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ValidateAssessmentReportIntegrityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ValidateAssessmentReportIntegrityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ValidateAssessmentReportIntegrityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ValidateAssessmentReportIntegrityErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ValidateAssessmentReportIntegrityErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateAssessmentReportIntegrityErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ValidateAssessmentReportIntegrityErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateAssessmentReportIntegrityErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ValidateAssessmentReportIntegrityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateAssessmentReportIntegrityErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ValidateAssessmentReportIntegrityErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ValidateAssessmentReportIntegrityErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ValidateAssessmentReportIntegrityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ValidateAssessmentReportIntegrityErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ValidateAssessmentReportIntegrityErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ValidateAssessmentReportIntegrityErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ValidateAssessmentReportIntegrityErrorKind::ValidationException(_inner) => Some(_inner),
            ValidateAssessmentReportIntegrityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p> The request has invalid or missing parameters. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p> The reason the request failed validation. </p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p> The fields that caused the error, if applicable. </p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p> The reason the request failed validation. </p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p> The fields that caused the error, if applicable. </p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The reason the request failed validation. </p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p> The reason the request failed validation. </p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p> The fields that caused the error, if applicable. </p>
        pub fn fields(mut self, input: impl Into<crate::model::ValidationExceptionField>) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input.into());
            self.fields = Some(v);
            self
        }
        /// <p> The fields that caused the error, if applicable. </p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p> The resource that's specified in the request can't be found. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the resource. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p> The type of resource that's affected by the error. </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p> The unique identifier for the resource. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p> The type of resource that's affected by the error. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The unique identifier for the resource. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the resource. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p> The type of resource that's affected by the error. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p> The type of resource that's affected by the error. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p> An internal service error occurred during the processing of your request. Try again
/// later. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p> Your account isn't registered with Audit Manager. Check the delegated
/// administrator setup on the Audit Manager settings page, and try again. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
