// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateAssessmentReportIntegrityOutput {
    /// <p> Specifies whether the signature key is valid. </p>
    pub signature_valid: std::option::Option<bool>,
    /// <p> The signature algorithm that's used to code sign the assessment report file. </p>
    pub signature_algorithm: std::option::Option<std::string::String>,
    /// <p> The date and time signature that specifies when the assessment report was created.
    /// </p>
    pub signature_date_time: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the validation signature key. </p>
    pub signature_key_id: std::option::Option<std::string::String>,
    /// <p> Represents any errors that occurred when validating the assessment report. </p>
    pub validation_errors: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ValidateAssessmentReportIntegrityOutput {
    /// <p> Specifies whether the signature key is valid. </p>
    pub fn signature_valid(&self) -> std::option::Option<bool> {
        self.signature_valid
    }
    /// <p> The signature algorithm that's used to code sign the assessment report file. </p>
    pub fn signature_algorithm(&self) -> std::option::Option<&str> {
        self.signature_algorithm.as_deref()
    }
    /// <p> The date and time signature that specifies when the assessment report was created.
    /// </p>
    pub fn signature_date_time(&self) -> std::option::Option<&str> {
        self.signature_date_time.as_deref()
    }
    /// <p> The unique identifier for the validation signature key. </p>
    pub fn signature_key_id(&self) -> std::option::Option<&str> {
        self.signature_key_id.as_deref()
    }
    /// <p> Represents any errors that occurred when validating the assessment report. </p>
    pub fn validation_errors(&self) -> std::option::Option<&[std::string::String]> {
        self.validation_errors.as_deref()
    }
}
impl std::fmt::Debug for ValidateAssessmentReportIntegrityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateAssessmentReportIntegrityOutput");
        formatter.field("signature_valid", &self.signature_valid);
        formatter.field("signature_algorithm", &self.signature_algorithm);
        formatter.field("signature_date_time", &self.signature_date_time);
        formatter.field("signature_key_id", &self.signature_key_id);
        formatter.field("validation_errors", &self.validation_errors);
        formatter.finish()
    }
}
/// See [`ValidateAssessmentReportIntegrityOutput`](crate::output::ValidateAssessmentReportIntegrityOutput)
pub mod validate_assessment_report_integrity_output {
    /// A builder for [`ValidateAssessmentReportIntegrityOutput`](crate::output::ValidateAssessmentReportIntegrityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signature_valid: std::option::Option<bool>,
        pub(crate) signature_algorithm: std::option::Option<std::string::String>,
        pub(crate) signature_date_time: std::option::Option<std::string::String>,
        pub(crate) signature_key_id: std::option::Option<std::string::String>,
        pub(crate) validation_errors: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> Specifies whether the signature key is valid. </p>
        pub fn signature_valid(mut self, input: bool) -> Self {
            self.signature_valid = Some(input);
            self
        }
        /// <p> Specifies whether the signature key is valid. </p>
        pub fn set_signature_valid(mut self, input: std::option::Option<bool>) -> Self {
            self.signature_valid = input;
            self
        }
        /// <p> The signature algorithm that's used to code sign the assessment report file. </p>
        pub fn signature_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_algorithm = Some(input.into());
            self
        }
        /// <p> The signature algorithm that's used to code sign the assessment report file. </p>
        pub fn set_signature_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_algorithm = input;
            self
        }
        /// <p> The date and time signature that specifies when the assessment report was created.
        /// </p>
        pub fn signature_date_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_date_time = Some(input.into());
            self
        }
        /// <p> The date and time signature that specifies when the assessment report was created.
        /// </p>
        pub fn set_signature_date_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_date_time = input;
            self
        }
        /// <p> The unique identifier for the validation signature key. </p>
        pub fn signature_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_key_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the validation signature key. </p>
        pub fn set_signature_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_key_id = input;
            self
        }
        /// Appends an item to `validation_errors`.
        ///
        /// To override the contents of this collection use [`set_validation_errors`](Self::set_validation_errors).
        ///
        /// <p> Represents any errors that occurred when validating the assessment report. </p>
        pub fn validation_errors(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.validation_errors.unwrap_or_default();
            v.push(input.into());
            self.validation_errors = Some(v);
            self
        }
        /// <p> Represents any errors that occurred when validating the assessment report. </p>
        pub fn set_validation_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.validation_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateAssessmentReportIntegrityOutput`](crate::output::ValidateAssessmentReportIntegrityOutput)
        pub fn build(self) -> crate::output::ValidateAssessmentReportIntegrityOutput {
            crate::output::ValidateAssessmentReportIntegrityOutput {
                signature_valid: self.signature_valid,
                signature_algorithm: self.signature_algorithm,
                signature_date_time: self.signature_date_time,
                signature_key_id: self.signature_key_id,
                validation_errors: self.validation_errors,
            }
        }
    }
}
impl ValidateAssessmentReportIntegrityOutput {
    /// Creates a new builder-style object to manufacture [`ValidateAssessmentReportIntegrityOutput`](crate::output::ValidateAssessmentReportIntegrityOutput)
    pub fn builder() -> crate::output::validate_assessment_report_integrity_output::Builder {
        crate::output::validate_assessment_report_integrity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSettingsOutput {
    /// <p> The current list of settings. </p>
    pub settings: std::option::Option<crate::model::Settings>,
}
impl UpdateSettingsOutput {
    /// <p> The current list of settings. </p>
    pub fn settings(&self) -> std::option::Option<&crate::model::Settings> {
        self.settings.as_ref()
    }
}
impl std::fmt::Debug for UpdateSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSettingsOutput");
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}
/// See [`UpdateSettingsOutput`](crate::output::UpdateSettingsOutput)
pub mod update_settings_output {
    /// A builder for [`UpdateSettingsOutput`](crate::output::UpdateSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) settings: std::option::Option<crate::model::Settings>,
    }
    impl Builder {
        /// <p> The current list of settings. </p>
        pub fn settings(mut self, input: crate::model::Settings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p> The current list of settings. </p>
        pub fn set_settings(mut self, input: std::option::Option<crate::model::Settings>) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSettingsOutput`](crate::output::UpdateSettingsOutput)
        pub fn build(self) -> crate::output::UpdateSettingsOutput {
            crate::output::UpdateSettingsOutput {
                settings: self.settings,
            }
        }
    }
}
impl UpdateSettingsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateSettingsOutput`](crate::output::UpdateSettingsOutput)
    pub fn builder() -> crate::output::update_settings_output::Builder {
        crate::output::update_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateControlOutput {
    /// <p> The name of the updated control set that the <code>UpdateControl</code> API returned.
    /// </p>
    pub control: std::option::Option<crate::model::Control>,
}
impl UpdateControlOutput {
    /// <p> The name of the updated control set that the <code>UpdateControl</code> API returned.
    /// </p>
    pub fn control(&self) -> std::option::Option<&crate::model::Control> {
        self.control.as_ref()
    }
}
impl std::fmt::Debug for UpdateControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateControlOutput");
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`UpdateControlOutput`](crate::output::UpdateControlOutput)
pub mod update_control_output {
    /// A builder for [`UpdateControlOutput`](crate::output::UpdateControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control: std::option::Option<crate::model::Control>,
    }
    impl Builder {
        /// <p> The name of the updated control set that the <code>UpdateControl</code> API returned.
        /// </p>
        pub fn control(mut self, input: crate::model::Control) -> Self {
            self.control = Some(input);
            self
        }
        /// <p> The name of the updated control set that the <code>UpdateControl</code> API returned.
        /// </p>
        pub fn set_control(mut self, input: std::option::Option<crate::model::Control>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateControlOutput`](crate::output::UpdateControlOutput)
        pub fn build(self) -> crate::output::UpdateControlOutput {
            crate::output::UpdateControlOutput {
                control: self.control,
            }
        }
    }
}
impl UpdateControlOutput {
    /// Creates a new builder-style object to manufacture [`UpdateControlOutput`](crate::output::UpdateControlOutput)
    pub fn builder() -> crate::output::update_control_output::Builder {
        crate::output::update_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentStatusOutput {
    /// <p> The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API
    /// returned. </p>
    pub assessment: std::option::Option<crate::model::Assessment>,
}
impl UpdateAssessmentStatusOutput {
    /// <p> The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API
    /// returned. </p>
    pub fn assessment(&self) -> std::option::Option<&crate::model::Assessment> {
        self.assessment.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssessmentStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentStatusOutput");
        formatter.field("assessment", &self.assessment);
        formatter.finish()
    }
}
/// See [`UpdateAssessmentStatusOutput`](crate::output::UpdateAssessmentStatusOutput)
pub mod update_assessment_status_output {
    /// A builder for [`UpdateAssessmentStatusOutput`](crate::output::UpdateAssessmentStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment: std::option::Option<crate::model::Assessment>,
    }
    impl Builder {
        /// <p> The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API
        /// returned. </p>
        pub fn assessment(mut self, input: crate::model::Assessment) -> Self {
            self.assessment = Some(input);
            self
        }
        /// <p> The name of the updated assessment that the <code>UpdateAssessmentStatus</code> API
        /// returned. </p>
        pub fn set_assessment(
            mut self,
            input: std::option::Option<crate::model::Assessment>,
        ) -> Self {
            self.assessment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentStatusOutput`](crate::output::UpdateAssessmentStatusOutput)
        pub fn build(self) -> crate::output::UpdateAssessmentStatusOutput {
            crate::output::UpdateAssessmentStatusOutput {
                assessment: self.assessment,
            }
        }
    }
}
impl UpdateAssessmentStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentStatusOutput`](crate::output::UpdateAssessmentStatusOutput)
    pub fn builder() -> crate::output::update_assessment_status_output::Builder {
        crate::output::update_assessment_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentFrameworkShareOutput {
    /// <p> The updated share request that's returned by the
    /// <code>UpdateAssessmentFrameworkShare</code> operation. </p>
    pub assessment_framework_share_request:
        std::option::Option<crate::model::AssessmentFrameworkShareRequest>,
}
impl UpdateAssessmentFrameworkShareOutput {
    /// <p> The updated share request that's returned by the
    /// <code>UpdateAssessmentFrameworkShare</code> operation. </p>
    pub fn assessment_framework_share_request(
        &self,
    ) -> std::option::Option<&crate::model::AssessmentFrameworkShareRequest> {
        self.assessment_framework_share_request.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssessmentFrameworkShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentFrameworkShareOutput");
        formatter.field(
            "assessment_framework_share_request",
            &self.assessment_framework_share_request,
        );
        formatter.finish()
    }
}
/// See [`UpdateAssessmentFrameworkShareOutput`](crate::output::UpdateAssessmentFrameworkShareOutput)
pub mod update_assessment_framework_share_output {
    /// A builder for [`UpdateAssessmentFrameworkShareOutput`](crate::output::UpdateAssessmentFrameworkShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_framework_share_request:
            std::option::Option<crate::model::AssessmentFrameworkShareRequest>,
    }
    impl Builder {
        /// <p> The updated share request that's returned by the
        /// <code>UpdateAssessmentFrameworkShare</code> operation. </p>
        pub fn assessment_framework_share_request(
            mut self,
            input: crate::model::AssessmentFrameworkShareRequest,
        ) -> Self {
            self.assessment_framework_share_request = Some(input);
            self
        }
        /// <p> The updated share request that's returned by the
        /// <code>UpdateAssessmentFrameworkShare</code> operation. </p>
        pub fn set_assessment_framework_share_request(
            mut self,
            input: std::option::Option<crate::model::AssessmentFrameworkShareRequest>,
        ) -> Self {
            self.assessment_framework_share_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentFrameworkShareOutput`](crate::output::UpdateAssessmentFrameworkShareOutput)
        pub fn build(self) -> crate::output::UpdateAssessmentFrameworkShareOutput {
            crate::output::UpdateAssessmentFrameworkShareOutput {
                assessment_framework_share_request: self.assessment_framework_share_request,
            }
        }
    }
}
impl UpdateAssessmentFrameworkShareOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentFrameworkShareOutput`](crate::output::UpdateAssessmentFrameworkShareOutput)
    pub fn builder() -> crate::output::update_assessment_framework_share_output::Builder {
        crate::output::update_assessment_framework_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentFrameworkOutput {
    /// <p> The name of the framework. </p>
    pub framework: std::option::Option<crate::model::Framework>,
}
impl UpdateAssessmentFrameworkOutput {
    /// <p> The name of the framework. </p>
    pub fn framework(&self) -> std::option::Option<&crate::model::Framework> {
        self.framework.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssessmentFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentFrameworkOutput");
        formatter.field("framework", &self.framework);
        formatter.finish()
    }
}
/// See [`UpdateAssessmentFrameworkOutput`](crate::output::UpdateAssessmentFrameworkOutput)
pub mod update_assessment_framework_output {
    /// A builder for [`UpdateAssessmentFrameworkOutput`](crate::output::UpdateAssessmentFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework: std::option::Option<crate::model::Framework>,
    }
    impl Builder {
        /// <p> The name of the framework. </p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p> The name of the framework. </p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentFrameworkOutput`](crate::output::UpdateAssessmentFrameworkOutput)
        pub fn build(self) -> crate::output::UpdateAssessmentFrameworkOutput {
            crate::output::UpdateAssessmentFrameworkOutput {
                framework: self.framework,
            }
        }
    }
}
impl UpdateAssessmentFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentFrameworkOutput`](crate::output::UpdateAssessmentFrameworkOutput)
    pub fn builder() -> crate::output::update_assessment_framework_output::Builder {
        crate::output::update_assessment_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentControlSetStatusOutput {
    /// <p> The name of the updated control set that the
    /// <code>UpdateAssessmentControlSetStatus</code> API returned. </p>
    pub control_set: std::option::Option<crate::model::AssessmentControlSet>,
}
impl UpdateAssessmentControlSetStatusOutput {
    /// <p> The name of the updated control set that the
    /// <code>UpdateAssessmentControlSetStatus</code> API returned. </p>
    pub fn control_set(&self) -> std::option::Option<&crate::model::AssessmentControlSet> {
        self.control_set.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssessmentControlSetStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentControlSetStatusOutput");
        formatter.field("control_set", &self.control_set);
        formatter.finish()
    }
}
/// See [`UpdateAssessmentControlSetStatusOutput`](crate::output::UpdateAssessmentControlSetStatusOutput)
pub mod update_assessment_control_set_status_output {
    /// A builder for [`UpdateAssessmentControlSetStatusOutput`](crate::output::UpdateAssessmentControlSetStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_set: std::option::Option<crate::model::AssessmentControlSet>,
    }
    impl Builder {
        /// <p> The name of the updated control set that the
        /// <code>UpdateAssessmentControlSetStatus</code> API returned. </p>
        pub fn control_set(mut self, input: crate::model::AssessmentControlSet) -> Self {
            self.control_set = Some(input);
            self
        }
        /// <p> The name of the updated control set that the
        /// <code>UpdateAssessmentControlSetStatus</code> API returned. </p>
        pub fn set_control_set(
            mut self,
            input: std::option::Option<crate::model::AssessmentControlSet>,
        ) -> Self {
            self.control_set = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentControlSetStatusOutput`](crate::output::UpdateAssessmentControlSetStatusOutput)
        pub fn build(self) -> crate::output::UpdateAssessmentControlSetStatusOutput {
            crate::output::UpdateAssessmentControlSetStatusOutput {
                control_set: self.control_set,
            }
        }
    }
}
impl UpdateAssessmentControlSetStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentControlSetStatusOutput`](crate::output::UpdateAssessmentControlSetStatusOutput)
    pub fn builder() -> crate::output::update_assessment_control_set_status_output::Builder {
        crate::output::update_assessment_control_set_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentControlOutput {
    /// <p> The name of the updated control set that the <code>UpdateAssessmentControl</code> API
    /// returned. </p>
    pub control: std::option::Option<crate::model::AssessmentControl>,
}
impl UpdateAssessmentControlOutput {
    /// <p> The name of the updated control set that the <code>UpdateAssessmentControl</code> API
    /// returned. </p>
    pub fn control(&self) -> std::option::Option<&crate::model::AssessmentControl> {
        self.control.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssessmentControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentControlOutput");
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`UpdateAssessmentControlOutput`](crate::output::UpdateAssessmentControlOutput)
pub mod update_assessment_control_output {
    /// A builder for [`UpdateAssessmentControlOutput`](crate::output::UpdateAssessmentControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control: std::option::Option<crate::model::AssessmentControl>,
    }
    impl Builder {
        /// <p> The name of the updated control set that the <code>UpdateAssessmentControl</code> API
        /// returned. </p>
        pub fn control(mut self, input: crate::model::AssessmentControl) -> Self {
            self.control = Some(input);
            self
        }
        /// <p> The name of the updated control set that the <code>UpdateAssessmentControl</code> API
        /// returned. </p>
        pub fn set_control(
            mut self,
            input: std::option::Option<crate::model::AssessmentControl>,
        ) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentControlOutput`](crate::output::UpdateAssessmentControlOutput)
        pub fn build(self) -> crate::output::UpdateAssessmentControlOutput {
            crate::output::UpdateAssessmentControlOutput {
                control: self.control,
            }
        }
    }
}
impl UpdateAssessmentControlOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentControlOutput`](crate::output::UpdateAssessmentControlOutput)
    pub fn builder() -> crate::output::update_assessment_control_output::Builder {
        crate::output::update_assessment_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentOutput {
    /// <p> The response object for the <code>UpdateAssessmentRequest</code> API. This is the name
    /// of the updated assessment.</p>
    pub assessment: std::option::Option<crate::model::Assessment>,
}
impl UpdateAssessmentOutput {
    /// <p> The response object for the <code>UpdateAssessmentRequest</code> API. This is the name
    /// of the updated assessment.</p>
    pub fn assessment(&self) -> std::option::Option<&crate::model::Assessment> {
        self.assessment.as_ref()
    }
}
impl std::fmt::Debug for UpdateAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentOutput");
        formatter.field("assessment", &self.assessment);
        formatter.finish()
    }
}
/// See [`UpdateAssessmentOutput`](crate::output::UpdateAssessmentOutput)
pub mod update_assessment_output {
    /// A builder for [`UpdateAssessmentOutput`](crate::output::UpdateAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment: std::option::Option<crate::model::Assessment>,
    }
    impl Builder {
        /// <p> The response object for the <code>UpdateAssessmentRequest</code> API. This is the name
        /// of the updated assessment.</p>
        pub fn assessment(mut self, input: crate::model::Assessment) -> Self {
            self.assessment = Some(input);
            self
        }
        /// <p> The response object for the <code>UpdateAssessmentRequest</code> API. This is the name
        /// of the updated assessment.</p>
        pub fn set_assessment(
            mut self,
            input: std::option::Option<crate::model::Assessment>,
        ) -> Self {
            self.assessment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentOutput`](crate::output::UpdateAssessmentOutput)
        pub fn build(self) -> crate::output::UpdateAssessmentOutput {
            crate::output::UpdateAssessmentOutput {
                assessment: self.assessment,
            }
        }
    }
}
impl UpdateAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentOutput`](crate::output::UpdateAssessmentOutput)
    pub fn builder() -> crate::output::update_assessment_output::Builder {
        crate::output::update_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAssessmentFrameworkShareOutput {
    /// <p> The share request that's created by the <code>StartAssessmentFrameworkShare</code> API.
    /// </p>
    pub assessment_framework_share_request:
        std::option::Option<crate::model::AssessmentFrameworkShareRequest>,
}
impl StartAssessmentFrameworkShareOutput {
    /// <p> The share request that's created by the <code>StartAssessmentFrameworkShare</code> API.
    /// </p>
    pub fn assessment_framework_share_request(
        &self,
    ) -> std::option::Option<&crate::model::AssessmentFrameworkShareRequest> {
        self.assessment_framework_share_request.as_ref()
    }
}
impl std::fmt::Debug for StartAssessmentFrameworkShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAssessmentFrameworkShareOutput");
        formatter.field(
            "assessment_framework_share_request",
            &self.assessment_framework_share_request,
        );
        formatter.finish()
    }
}
/// See [`StartAssessmentFrameworkShareOutput`](crate::output::StartAssessmentFrameworkShareOutput)
pub mod start_assessment_framework_share_output {
    /// A builder for [`StartAssessmentFrameworkShareOutput`](crate::output::StartAssessmentFrameworkShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_framework_share_request:
            std::option::Option<crate::model::AssessmentFrameworkShareRequest>,
    }
    impl Builder {
        /// <p> The share request that's created by the <code>StartAssessmentFrameworkShare</code> API.
        /// </p>
        pub fn assessment_framework_share_request(
            mut self,
            input: crate::model::AssessmentFrameworkShareRequest,
        ) -> Self {
            self.assessment_framework_share_request = Some(input);
            self
        }
        /// <p> The share request that's created by the <code>StartAssessmentFrameworkShare</code> API.
        /// </p>
        pub fn set_assessment_framework_share_request(
            mut self,
            input: std::option::Option<crate::model::AssessmentFrameworkShareRequest>,
        ) -> Self {
            self.assessment_framework_share_request = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAssessmentFrameworkShareOutput`](crate::output::StartAssessmentFrameworkShareOutput)
        pub fn build(self) -> crate::output::StartAssessmentFrameworkShareOutput {
            crate::output::StartAssessmentFrameworkShareOutput {
                assessment_framework_share_request: self.assessment_framework_share_request,
            }
        }
    }
}
impl StartAssessmentFrameworkShareOutput {
    /// Creates a new builder-style object to manufacture [`StartAssessmentFrameworkShareOutput`](crate::output::StartAssessmentFrameworkShareOutput)
    pub fn builder() -> crate::output::start_assessment_framework_share_output::Builder {
        crate::output::start_assessment_framework_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterOrganizationAdminAccountOutput {
    /// <p> The identifier for the delegated administrator account. </p>
    pub admin_account_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the organization. </p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl RegisterOrganizationAdminAccountOutput {
    /// <p> The identifier for the delegated administrator account. </p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
    /// <p> The identifier for the organization. </p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for RegisterOrganizationAdminAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterOrganizationAdminAccountOutput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}
/// See [`RegisterOrganizationAdminAccountOutput`](crate::output::RegisterOrganizationAdminAccountOutput)
pub mod register_organization_admin_account_output {
    /// A builder for [`RegisterOrganizationAdminAccountOutput`](crate::output::RegisterOrganizationAdminAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the delegated administrator account. </p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p> The identifier for the delegated administrator account. </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// <p> The identifier for the organization. </p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p> The identifier for the organization. </p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterOrganizationAdminAccountOutput`](crate::output::RegisterOrganizationAdminAccountOutput)
        pub fn build(self) -> crate::output::RegisterOrganizationAdminAccountOutput {
            crate::output::RegisterOrganizationAdminAccountOutput {
                admin_account_id: self.admin_account_id,
                organization_id: self.organization_id,
            }
        }
    }
}
impl RegisterOrganizationAdminAccountOutput {
    /// Creates a new builder-style object to manufacture [`RegisterOrganizationAdminAccountOutput`](crate::output::RegisterOrganizationAdminAccountOutput)
    pub fn builder() -> crate::output::register_organization_admin_account_output::Builder {
        crate::output::register_organization_admin_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterAccountOutput {
    /// <p> The status of the account registration request. </p>
    pub status: std::option::Option<crate::model::AccountStatus>,
}
impl RegisterAccountOutput {
    /// <p> The status of the account registration request. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::AccountStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for RegisterAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterAccountOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RegisterAccountOutput`](crate::output::RegisterAccountOutput)
pub mod register_account_output {
    /// A builder for [`RegisterAccountOutput`](crate::output::RegisterAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AccountStatus>,
    }
    impl Builder {
        /// <p> The status of the account registration request. </p>
        pub fn status(mut self, input: crate::model::AccountStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the account registration request. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccountStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterAccountOutput`](crate::output::RegisterAccountOutput)
        pub fn build(self) -> crate::output::RegisterAccountOutput {
            crate::output::RegisterAccountOutput {
                status: self.status,
            }
        }
    }
}
impl RegisterAccountOutput {
    /// Creates a new builder-style object to manufacture [`RegisterAccountOutput`](crate::output::RegisterAccountOutput)
    pub fn builder() -> crate::output::register_account_output::Builder {
        crate::output::register_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p> The list of tags that the <code>ListTagsForResource</code> API returned. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p> The list of tags that the <code>ListTagsForResource</code> API returned. </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The list of tags that the <code>ListTagsForResource</code> API returned. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The list of tags that the <code>ListTagsForResource</code> API returned. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotificationsOutput {
    /// <p> The returned list of notifications. </p>
    pub notifications: std::option::Option<std::vec::Vec<crate::model::Notification>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNotificationsOutput {
    /// <p> The returned list of notifications. </p>
    pub fn notifications(&self) -> std::option::Option<&[crate::model::Notification]> {
        self.notifications.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNotificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotificationsOutput");
        formatter.field("notifications", &self.notifications);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
pub mod list_notifications_output {
    /// A builder for [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) notifications: std::option::Option<std::vec::Vec<crate::model::Notification>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `notifications`.
        ///
        /// To override the contents of this collection use [`set_notifications`](Self::set_notifications).
        ///
        /// <p> The returned list of notifications. </p>
        pub fn notifications(mut self, input: impl Into<crate::model::Notification>) -> Self {
            let mut v = self.notifications.unwrap_or_default();
            v.push(input.into());
            self.notifications = Some(v);
            self
        }
        /// <p> The returned list of notifications. </p>
        pub fn set_notifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Notification>>,
        ) -> Self {
            self.notifications = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
        pub fn build(self) -> crate::output::ListNotificationsOutput {
            crate::output::ListNotificationsOutput {
                notifications: self.notifications,
                next_token: self.next_token,
            }
        }
    }
}
impl ListNotificationsOutput {
    /// Creates a new builder-style object to manufacture [`ListNotificationsOutput`](crate::output::ListNotificationsOutput)
    pub fn builder() -> crate::output::list_notifications_output::Builder {
        crate::output::list_notifications_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeywordsForDataSourceOutput {
    /// <p> The list of keywords for the event mapping source. </p>
    pub keywords: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListKeywordsForDataSourceOutput {
    /// <p> The list of keywords for the event mapping source. </p>
    pub fn keywords(&self) -> std::option::Option<&[std::string::String]> {
        self.keywords.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListKeywordsForDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeywordsForDataSourceOutput");
        formatter.field("keywords", &self.keywords);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListKeywordsForDataSourceOutput`](crate::output::ListKeywordsForDataSourceOutput)
pub mod list_keywords_for_data_source_output {
    /// A builder for [`ListKeywordsForDataSourceOutput`](crate::output::ListKeywordsForDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keywords: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p> The list of keywords for the event mapping source. </p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keywords.unwrap_or_default();
            v.push(input.into());
            self.keywords = Some(v);
            self
        }
        /// <p> The list of keywords for the event mapping source. </p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keywords = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeywordsForDataSourceOutput`](crate::output::ListKeywordsForDataSourceOutput)
        pub fn build(self) -> crate::output::ListKeywordsForDataSourceOutput {
            crate::output::ListKeywordsForDataSourceOutput {
                keywords: self.keywords,
                next_token: self.next_token,
            }
        }
    }
}
impl ListKeywordsForDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`ListKeywordsForDataSourceOutput`](crate::output::ListKeywordsForDataSourceOutput)
    pub fn builder() -> crate::output::list_keywords_for_data_source_output::Builder {
        crate::output::list_keywords_for_data_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListControlsOutput {
    /// <p> The list of control metadata objects that the <code>ListControls</code> API returned.
    /// </p>
    pub control_metadata_list: std::option::Option<std::vec::Vec<crate::model::ControlMetadata>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListControlsOutput {
    /// <p> The list of control metadata objects that the <code>ListControls</code> API returned.
    /// </p>
    pub fn control_metadata_list(&self) -> std::option::Option<&[crate::model::ControlMetadata]> {
        self.control_metadata_list.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListControlsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListControlsOutput");
        formatter.field("control_metadata_list", &self.control_metadata_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListControlsOutput`](crate::output::ListControlsOutput)
pub mod list_controls_output {
    /// A builder for [`ListControlsOutput`](crate::output::ListControlsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_metadata_list:
            std::option::Option<std::vec::Vec<crate::model::ControlMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `control_metadata_list`.
        ///
        /// To override the contents of this collection use [`set_control_metadata_list`](Self::set_control_metadata_list).
        ///
        /// <p> The list of control metadata objects that the <code>ListControls</code> API returned.
        /// </p>
        pub fn control_metadata_list(
            mut self,
            input: impl Into<crate::model::ControlMetadata>,
        ) -> Self {
            let mut v = self.control_metadata_list.unwrap_or_default();
            v.push(input.into());
            self.control_metadata_list = Some(v);
            self
        }
        /// <p> The list of control metadata objects that the <code>ListControls</code> API returned.
        /// </p>
        pub fn set_control_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlMetadata>>,
        ) -> Self {
            self.control_metadata_list = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListControlsOutput`](crate::output::ListControlsOutput)
        pub fn build(self) -> crate::output::ListControlsOutput {
            crate::output::ListControlsOutput {
                control_metadata_list: self.control_metadata_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListControlsOutput {
    /// Creates a new builder-style object to manufacture [`ListControlsOutput`](crate::output::ListControlsOutput)
    pub fn builder() -> crate::output::list_controls_output::Builder {
        crate::output::list_controls_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentsOutput {
    /// <p> The metadata that's associated with the assessment. </p>
    pub assessment_metadata:
        std::option::Option<std::vec::Vec<crate::model::AssessmentMetadataItem>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssessmentsOutput {
    /// <p> The metadata that's associated with the assessment. </p>
    pub fn assessment_metadata(
        &self,
    ) -> std::option::Option<&[crate::model::AssessmentMetadataItem]> {
        self.assessment_metadata.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssessmentsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentsOutput");
        formatter.field("assessment_metadata", &self.assessment_metadata);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssessmentsOutput`](crate::output::ListAssessmentsOutput)
pub mod list_assessments_output {
    /// A builder for [`ListAssessmentsOutput`](crate::output::ListAssessmentsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_metadata:
            std::option::Option<std::vec::Vec<crate::model::AssessmentMetadataItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `assessment_metadata`.
        ///
        /// To override the contents of this collection use [`set_assessment_metadata`](Self::set_assessment_metadata).
        ///
        /// <p> The metadata that's associated with the assessment. </p>
        pub fn assessment_metadata(
            mut self,
            input: impl Into<crate::model::AssessmentMetadataItem>,
        ) -> Self {
            let mut v = self.assessment_metadata.unwrap_or_default();
            v.push(input.into());
            self.assessment_metadata = Some(v);
            self
        }
        /// <p> The metadata that's associated with the assessment. </p>
        pub fn set_assessment_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentMetadataItem>>,
        ) -> Self {
            self.assessment_metadata = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentsOutput`](crate::output::ListAssessmentsOutput)
        pub fn build(self) -> crate::output::ListAssessmentsOutput {
            crate::output::ListAssessmentsOutput {
                assessment_metadata: self.assessment_metadata,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssessmentsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssessmentsOutput`](crate::output::ListAssessmentsOutput)
    pub fn builder() -> crate::output::list_assessments_output::Builder {
        crate::output::list_assessments_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentReportsOutput {
    /// <p> The list of assessment reports that the <code>ListAssessmentReports</code> API
    /// returned. </p>
    pub assessment_reports:
        std::option::Option<std::vec::Vec<crate::model::AssessmentReportMetadata>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssessmentReportsOutput {
    /// <p> The list of assessment reports that the <code>ListAssessmentReports</code> API
    /// returned. </p>
    pub fn assessment_reports(
        &self,
    ) -> std::option::Option<&[crate::model::AssessmentReportMetadata]> {
        self.assessment_reports.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssessmentReportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentReportsOutput");
        formatter.field("assessment_reports", &self.assessment_reports);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssessmentReportsOutput`](crate::output::ListAssessmentReportsOutput)
pub mod list_assessment_reports_output {
    /// A builder for [`ListAssessmentReportsOutput`](crate::output::ListAssessmentReportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_reports:
            std::option::Option<std::vec::Vec<crate::model::AssessmentReportMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `assessment_reports`.
        ///
        /// To override the contents of this collection use [`set_assessment_reports`](Self::set_assessment_reports).
        ///
        /// <p> The list of assessment reports that the <code>ListAssessmentReports</code> API
        /// returned. </p>
        pub fn assessment_reports(
            mut self,
            input: impl Into<crate::model::AssessmentReportMetadata>,
        ) -> Self {
            let mut v = self.assessment_reports.unwrap_or_default();
            v.push(input.into());
            self.assessment_reports = Some(v);
            self
        }
        /// <p> The list of assessment reports that the <code>ListAssessmentReports</code> API
        /// returned. </p>
        pub fn set_assessment_reports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentReportMetadata>>,
        ) -> Self {
            self.assessment_reports = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentReportsOutput`](crate::output::ListAssessmentReportsOutput)
        pub fn build(self) -> crate::output::ListAssessmentReportsOutput {
            crate::output::ListAssessmentReportsOutput {
                assessment_reports: self.assessment_reports,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssessmentReportsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssessmentReportsOutput`](crate::output::ListAssessmentReportsOutput)
    pub fn builder() -> crate::output::list_assessment_reports_output::Builder {
        crate::output::list_assessment_reports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentFrameworkShareRequestsOutput {
    /// <p> The list of share requests that the <code>ListAssessmentFrameworkShareRequests</code>
    /// API returned. </p>
    pub assessment_framework_share_requests:
        std::option::Option<std::vec::Vec<crate::model::AssessmentFrameworkShareRequest>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssessmentFrameworkShareRequestsOutput {
    /// <p> The list of share requests that the <code>ListAssessmentFrameworkShareRequests</code>
    /// API returned. </p>
    pub fn assessment_framework_share_requests(
        &self,
    ) -> std::option::Option<&[crate::model::AssessmentFrameworkShareRequest]> {
        self.assessment_framework_share_requests.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssessmentFrameworkShareRequestsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentFrameworkShareRequestsOutput");
        formatter.field(
            "assessment_framework_share_requests",
            &self.assessment_framework_share_requests,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssessmentFrameworkShareRequestsOutput`](crate::output::ListAssessmentFrameworkShareRequestsOutput)
pub mod list_assessment_framework_share_requests_output {
    /// A builder for [`ListAssessmentFrameworkShareRequestsOutput`](crate::output::ListAssessmentFrameworkShareRequestsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_framework_share_requests:
            std::option::Option<std::vec::Vec<crate::model::AssessmentFrameworkShareRequest>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `assessment_framework_share_requests`.
        ///
        /// To override the contents of this collection use [`set_assessment_framework_share_requests`](Self::set_assessment_framework_share_requests).
        ///
        /// <p> The list of share requests that the <code>ListAssessmentFrameworkShareRequests</code>
        /// API returned. </p>
        pub fn assessment_framework_share_requests(
            mut self,
            input: impl Into<crate::model::AssessmentFrameworkShareRequest>,
        ) -> Self {
            let mut v = self.assessment_framework_share_requests.unwrap_or_default();
            v.push(input.into());
            self.assessment_framework_share_requests = Some(v);
            self
        }
        /// <p> The list of share requests that the <code>ListAssessmentFrameworkShareRequests</code>
        /// API returned. </p>
        pub fn set_assessment_framework_share_requests(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AssessmentFrameworkShareRequest>,
            >,
        ) -> Self {
            self.assessment_framework_share_requests = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentFrameworkShareRequestsOutput`](crate::output::ListAssessmentFrameworkShareRequestsOutput)
        pub fn build(self) -> crate::output::ListAssessmentFrameworkShareRequestsOutput {
            crate::output::ListAssessmentFrameworkShareRequestsOutput {
                assessment_framework_share_requests: self.assessment_framework_share_requests,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssessmentFrameworkShareRequestsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssessmentFrameworkShareRequestsOutput`](crate::output::ListAssessmentFrameworkShareRequestsOutput)
    pub fn builder() -> crate::output::list_assessment_framework_share_requests_output::Builder {
        crate::output::list_assessment_framework_share_requests_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentFrameworksOutput {
    /// <p> The list of metadata objects for the framework. </p>
    pub framework_metadata_list:
        std::option::Option<std::vec::Vec<crate::model::AssessmentFrameworkMetadata>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssessmentFrameworksOutput {
    /// <p> The list of metadata objects for the framework. </p>
    pub fn framework_metadata_list(
        &self,
    ) -> std::option::Option<&[crate::model::AssessmentFrameworkMetadata]> {
        self.framework_metadata_list.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssessmentFrameworksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentFrameworksOutput");
        formatter.field("framework_metadata_list", &self.framework_metadata_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssessmentFrameworksOutput`](crate::output::ListAssessmentFrameworksOutput)
pub mod list_assessment_frameworks_output {
    /// A builder for [`ListAssessmentFrameworksOutput`](crate::output::ListAssessmentFrameworksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_metadata_list:
            std::option::Option<std::vec::Vec<crate::model::AssessmentFrameworkMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `framework_metadata_list`.
        ///
        /// To override the contents of this collection use [`set_framework_metadata_list`](Self::set_framework_metadata_list).
        ///
        /// <p> The list of metadata objects for the framework. </p>
        pub fn framework_metadata_list(
            mut self,
            input: impl Into<crate::model::AssessmentFrameworkMetadata>,
        ) -> Self {
            let mut v = self.framework_metadata_list.unwrap_or_default();
            v.push(input.into());
            self.framework_metadata_list = Some(v);
            self
        }
        /// <p> The list of metadata objects for the framework. </p>
        pub fn set_framework_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentFrameworkMetadata>>,
        ) -> Self {
            self.framework_metadata_list = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentFrameworksOutput`](crate::output::ListAssessmentFrameworksOutput)
        pub fn build(self) -> crate::output::ListAssessmentFrameworksOutput {
            crate::output::ListAssessmentFrameworksOutput {
                framework_metadata_list: self.framework_metadata_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssessmentFrameworksOutput {
    /// Creates a new builder-style object to manufacture [`ListAssessmentFrameworksOutput`](crate::output::ListAssessmentFrameworksOutput)
    pub fn builder() -> crate::output::list_assessment_frameworks_output::Builder {
        crate::output::list_assessment_frameworks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSettingsOutput {
    /// <p> The settings object that holds all supported Audit Manager settings. </p>
    pub settings: std::option::Option<crate::model::Settings>,
}
impl GetSettingsOutput {
    /// <p> The settings object that holds all supported Audit Manager settings. </p>
    pub fn settings(&self) -> std::option::Option<&crate::model::Settings> {
        self.settings.as_ref()
    }
}
impl std::fmt::Debug for GetSettingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSettingsOutput");
        formatter.field("settings", &self.settings);
        formatter.finish()
    }
}
/// See [`GetSettingsOutput`](crate::output::GetSettingsOutput)
pub mod get_settings_output {
    /// A builder for [`GetSettingsOutput`](crate::output::GetSettingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) settings: std::option::Option<crate::model::Settings>,
    }
    impl Builder {
        /// <p> The settings object that holds all supported Audit Manager settings. </p>
        pub fn settings(mut self, input: crate::model::Settings) -> Self {
            self.settings = Some(input);
            self
        }
        /// <p> The settings object that holds all supported Audit Manager settings. </p>
        pub fn set_settings(mut self, input: std::option::Option<crate::model::Settings>) -> Self {
            self.settings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSettingsOutput`](crate::output::GetSettingsOutput)
        pub fn build(self) -> crate::output::GetSettingsOutput {
            crate::output::GetSettingsOutput {
                settings: self.settings,
            }
        }
    }
}
impl GetSettingsOutput {
    /// Creates a new builder-style object to manufacture [`GetSettingsOutput`](crate::output::GetSettingsOutput)
    pub fn builder() -> crate::output::get_settings_output::Builder {
        crate::output::get_settings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServicesInScopeOutput {
    /// <p> The metadata that's associated with the Amazon Web Service. </p>
    pub service_metadata: std::option::Option<std::vec::Vec<crate::model::ServiceMetadata>>,
}
impl GetServicesInScopeOutput {
    /// <p> The metadata that's associated with the Amazon Web Service. </p>
    pub fn service_metadata(&self) -> std::option::Option<&[crate::model::ServiceMetadata]> {
        self.service_metadata.as_deref()
    }
}
impl std::fmt::Debug for GetServicesInScopeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServicesInScopeOutput");
        formatter.field("service_metadata", &self.service_metadata);
        formatter.finish()
    }
}
/// See [`GetServicesInScopeOutput`](crate::output::GetServicesInScopeOutput)
pub mod get_services_in_scope_output {
    /// A builder for [`GetServicesInScopeOutput`](crate::output::GetServicesInScopeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_metadata:
            std::option::Option<std::vec::Vec<crate::model::ServiceMetadata>>,
    }
    impl Builder {
        /// Appends an item to `service_metadata`.
        ///
        /// To override the contents of this collection use [`set_service_metadata`](Self::set_service_metadata).
        ///
        /// <p> The metadata that's associated with the Amazon Web Service. </p>
        pub fn service_metadata(mut self, input: impl Into<crate::model::ServiceMetadata>) -> Self {
            let mut v = self.service_metadata.unwrap_or_default();
            v.push(input.into());
            self.service_metadata = Some(v);
            self
        }
        /// <p> The metadata that's associated with the Amazon Web Service. </p>
        pub fn set_service_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceMetadata>>,
        ) -> Self {
            self.service_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetServicesInScopeOutput`](crate::output::GetServicesInScopeOutput)
        pub fn build(self) -> crate::output::GetServicesInScopeOutput {
            crate::output::GetServicesInScopeOutput {
                service_metadata: self.service_metadata,
            }
        }
    }
}
impl GetServicesInScopeOutput {
    /// Creates a new builder-style object to manufacture [`GetServicesInScopeOutput`](crate::output::GetServicesInScopeOutput)
    pub fn builder() -> crate::output::get_services_in_scope_output::Builder {
        crate::output::get_services_in_scope_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOrganizationAdminAccountOutput {
    /// <p> The identifier for the administrator account. </p>
    pub admin_account_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the organization. </p>
    pub organization_id: std::option::Option<std::string::String>,
}
impl GetOrganizationAdminAccountOutput {
    /// <p> The identifier for the administrator account. </p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
    /// <p> The identifier for the organization. </p>
    pub fn organization_id(&self) -> std::option::Option<&str> {
        self.organization_id.as_deref()
    }
}
impl std::fmt::Debug for GetOrganizationAdminAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOrganizationAdminAccountOutput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.field("organization_id", &self.organization_id);
        formatter.finish()
    }
}
/// See [`GetOrganizationAdminAccountOutput`](crate::output::GetOrganizationAdminAccountOutput)
pub mod get_organization_admin_account_output {
    /// A builder for [`GetOrganizationAdminAccountOutput`](crate::output::GetOrganizationAdminAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
        pub(crate) organization_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the administrator account. </p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p> The identifier for the administrator account. </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// <p> The identifier for the organization. </p>
        pub fn organization_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.organization_id = Some(input.into());
            self
        }
        /// <p> The identifier for the organization. </p>
        pub fn set_organization_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organization_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOrganizationAdminAccountOutput`](crate::output::GetOrganizationAdminAccountOutput)
        pub fn build(self) -> crate::output::GetOrganizationAdminAccountOutput {
            crate::output::GetOrganizationAdminAccountOutput {
                admin_account_id: self.admin_account_id,
                organization_id: self.organization_id,
            }
        }
    }
}
impl GetOrganizationAdminAccountOutput {
    /// Creates a new builder-style object to manufacture [`GetOrganizationAdminAccountOutput`](crate::output::GetOrganizationAdminAccountOutput)
    pub fn builder() -> crate::output::get_organization_admin_account_output::Builder {
        crate::output::get_organization_admin_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceFoldersByAssessmentControlOutput {
    /// <p> The list of evidence folders that the
    /// <code>GetEvidenceFoldersByAssessmentControl</code> API returned. </p>
    pub evidence_folders:
        std::option::Option<std::vec::Vec<crate::model::AssessmentEvidenceFolder>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetEvidenceFoldersByAssessmentControlOutput {
    /// <p> The list of evidence folders that the
    /// <code>GetEvidenceFoldersByAssessmentControl</code> API returned. </p>
    pub fn evidence_folders(
        &self,
    ) -> std::option::Option<&[crate::model::AssessmentEvidenceFolder]> {
        self.evidence_folders.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetEvidenceFoldersByAssessmentControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceFoldersByAssessmentControlOutput");
        formatter.field("evidence_folders", &self.evidence_folders);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetEvidenceFoldersByAssessmentControlOutput`](crate::output::GetEvidenceFoldersByAssessmentControlOutput)
pub mod get_evidence_folders_by_assessment_control_output {
    /// A builder for [`GetEvidenceFoldersByAssessmentControlOutput`](crate::output::GetEvidenceFoldersByAssessmentControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence_folders:
            std::option::Option<std::vec::Vec<crate::model::AssessmentEvidenceFolder>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `evidence_folders`.
        ///
        /// To override the contents of this collection use [`set_evidence_folders`](Self::set_evidence_folders).
        ///
        /// <p> The list of evidence folders that the
        /// <code>GetEvidenceFoldersByAssessmentControl</code> API returned. </p>
        pub fn evidence_folders(
            mut self,
            input: impl Into<crate::model::AssessmentEvidenceFolder>,
        ) -> Self {
            let mut v = self.evidence_folders.unwrap_or_default();
            v.push(input.into());
            self.evidence_folders = Some(v);
            self
        }
        /// <p> The list of evidence folders that the
        /// <code>GetEvidenceFoldersByAssessmentControl</code> API returned. </p>
        pub fn set_evidence_folders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentEvidenceFolder>>,
        ) -> Self {
            self.evidence_folders = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceFoldersByAssessmentControlOutput`](crate::output::GetEvidenceFoldersByAssessmentControlOutput)
        pub fn build(self) -> crate::output::GetEvidenceFoldersByAssessmentControlOutput {
            crate::output::GetEvidenceFoldersByAssessmentControlOutput {
                evidence_folders: self.evidence_folders,
                next_token: self.next_token,
            }
        }
    }
}
impl GetEvidenceFoldersByAssessmentControlOutput {
    /// Creates a new builder-style object to manufacture [`GetEvidenceFoldersByAssessmentControlOutput`](crate::output::GetEvidenceFoldersByAssessmentControlOutput)
    pub fn builder() -> crate::output::get_evidence_folders_by_assessment_control_output::Builder {
        crate::output::get_evidence_folders_by_assessment_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceFoldersByAssessmentOutput {
    /// <p> The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API
    /// returned. </p>
    pub evidence_folders:
        std::option::Option<std::vec::Vec<crate::model::AssessmentEvidenceFolder>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetEvidenceFoldersByAssessmentOutput {
    /// <p> The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API
    /// returned. </p>
    pub fn evidence_folders(
        &self,
    ) -> std::option::Option<&[crate::model::AssessmentEvidenceFolder]> {
        self.evidence_folders.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetEvidenceFoldersByAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceFoldersByAssessmentOutput");
        formatter.field("evidence_folders", &self.evidence_folders);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetEvidenceFoldersByAssessmentOutput`](crate::output::GetEvidenceFoldersByAssessmentOutput)
pub mod get_evidence_folders_by_assessment_output {
    /// A builder for [`GetEvidenceFoldersByAssessmentOutput`](crate::output::GetEvidenceFoldersByAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence_folders:
            std::option::Option<std::vec::Vec<crate::model::AssessmentEvidenceFolder>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `evidence_folders`.
        ///
        /// To override the contents of this collection use [`set_evidence_folders`](Self::set_evidence_folders).
        ///
        /// <p> The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API
        /// returned. </p>
        pub fn evidence_folders(
            mut self,
            input: impl Into<crate::model::AssessmentEvidenceFolder>,
        ) -> Self {
            let mut v = self.evidence_folders.unwrap_or_default();
            v.push(input.into());
            self.evidence_folders = Some(v);
            self
        }
        /// <p> The list of evidence folders that the <code>GetEvidenceFoldersByAssessment</code> API
        /// returned. </p>
        pub fn set_evidence_folders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentEvidenceFolder>>,
        ) -> Self {
            self.evidence_folders = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceFoldersByAssessmentOutput`](crate::output::GetEvidenceFoldersByAssessmentOutput)
        pub fn build(self) -> crate::output::GetEvidenceFoldersByAssessmentOutput {
            crate::output::GetEvidenceFoldersByAssessmentOutput {
                evidence_folders: self.evidence_folders,
                next_token: self.next_token,
            }
        }
    }
}
impl GetEvidenceFoldersByAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`GetEvidenceFoldersByAssessmentOutput`](crate::output::GetEvidenceFoldersByAssessmentOutput)
    pub fn builder() -> crate::output::get_evidence_folders_by_assessment_output::Builder {
        crate::output::get_evidence_folders_by_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceFolderOutput {
    /// <p> The folder that the evidence is stored in. </p>
    pub evidence_folder: std::option::Option<crate::model::AssessmentEvidenceFolder>,
}
impl GetEvidenceFolderOutput {
    /// <p> The folder that the evidence is stored in. </p>
    pub fn evidence_folder(&self) -> std::option::Option<&crate::model::AssessmentEvidenceFolder> {
        self.evidence_folder.as_ref()
    }
}
impl std::fmt::Debug for GetEvidenceFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceFolderOutput");
        formatter.field("evidence_folder", &self.evidence_folder);
        formatter.finish()
    }
}
/// See [`GetEvidenceFolderOutput`](crate::output::GetEvidenceFolderOutput)
pub mod get_evidence_folder_output {
    /// A builder for [`GetEvidenceFolderOutput`](crate::output::GetEvidenceFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence_folder: std::option::Option<crate::model::AssessmentEvidenceFolder>,
    }
    impl Builder {
        /// <p> The folder that the evidence is stored in. </p>
        pub fn evidence_folder(mut self, input: crate::model::AssessmentEvidenceFolder) -> Self {
            self.evidence_folder = Some(input);
            self
        }
        /// <p> The folder that the evidence is stored in. </p>
        pub fn set_evidence_folder(
            mut self,
            input: std::option::Option<crate::model::AssessmentEvidenceFolder>,
        ) -> Self {
            self.evidence_folder = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceFolderOutput`](crate::output::GetEvidenceFolderOutput)
        pub fn build(self) -> crate::output::GetEvidenceFolderOutput {
            crate::output::GetEvidenceFolderOutput {
                evidence_folder: self.evidence_folder,
            }
        }
    }
}
impl GetEvidenceFolderOutput {
    /// Creates a new builder-style object to manufacture [`GetEvidenceFolderOutput`](crate::output::GetEvidenceFolderOutput)
    pub fn builder() -> crate::output::get_evidence_folder_output::Builder {
        crate::output::get_evidence_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceByEvidenceFolderOutput {
    /// <p> The list of evidence that the <code>GetEvidenceByEvidenceFolder</code> API returned.
    /// </p>
    pub evidence: std::option::Option<std::vec::Vec<crate::model::Evidence>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetEvidenceByEvidenceFolderOutput {
    /// <p> The list of evidence that the <code>GetEvidenceByEvidenceFolder</code> API returned.
    /// </p>
    pub fn evidence(&self) -> std::option::Option<&[crate::model::Evidence]> {
        self.evidence.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetEvidenceByEvidenceFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceByEvidenceFolderOutput");
        formatter.field("evidence", &self.evidence);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetEvidenceByEvidenceFolderOutput`](crate::output::GetEvidenceByEvidenceFolderOutput)
pub mod get_evidence_by_evidence_folder_output {
    /// A builder for [`GetEvidenceByEvidenceFolderOutput`](crate::output::GetEvidenceByEvidenceFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence: std::option::Option<std::vec::Vec<crate::model::Evidence>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `evidence`.
        ///
        /// To override the contents of this collection use [`set_evidence`](Self::set_evidence).
        ///
        /// <p> The list of evidence that the <code>GetEvidenceByEvidenceFolder</code> API returned.
        /// </p>
        pub fn evidence(mut self, input: impl Into<crate::model::Evidence>) -> Self {
            let mut v = self.evidence.unwrap_or_default();
            v.push(input.into());
            self.evidence = Some(v);
            self
        }
        /// <p> The list of evidence that the <code>GetEvidenceByEvidenceFolder</code> API returned.
        /// </p>
        pub fn set_evidence(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Evidence>>,
        ) -> Self {
            self.evidence = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceByEvidenceFolderOutput`](crate::output::GetEvidenceByEvidenceFolderOutput)
        pub fn build(self) -> crate::output::GetEvidenceByEvidenceFolderOutput {
            crate::output::GetEvidenceByEvidenceFolderOutput {
                evidence: self.evidence,
                next_token: self.next_token,
            }
        }
    }
}
impl GetEvidenceByEvidenceFolderOutput {
    /// Creates a new builder-style object to manufacture [`GetEvidenceByEvidenceFolderOutput`](crate::output::GetEvidenceByEvidenceFolderOutput)
    pub fn builder() -> crate::output::get_evidence_by_evidence_folder_output::Builder {
        crate::output::get_evidence_by_evidence_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceOutput {
    /// <p> The evidence that the <code>GetEvidenceResponse</code> API returned. </p>
    pub evidence: std::option::Option<crate::model::Evidence>,
}
impl GetEvidenceOutput {
    /// <p> The evidence that the <code>GetEvidenceResponse</code> API returned. </p>
    pub fn evidence(&self) -> std::option::Option<&crate::model::Evidence> {
        self.evidence.as_ref()
    }
}
impl std::fmt::Debug for GetEvidenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceOutput");
        formatter.field("evidence", &self.evidence);
        formatter.finish()
    }
}
/// See [`GetEvidenceOutput`](crate::output::GetEvidenceOutput)
pub mod get_evidence_output {
    /// A builder for [`GetEvidenceOutput`](crate::output::GetEvidenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence: std::option::Option<crate::model::Evidence>,
    }
    impl Builder {
        /// <p> The evidence that the <code>GetEvidenceResponse</code> API returned. </p>
        pub fn evidence(mut self, input: crate::model::Evidence) -> Self {
            self.evidence = Some(input);
            self
        }
        /// <p> The evidence that the <code>GetEvidenceResponse</code> API returned. </p>
        pub fn set_evidence(mut self, input: std::option::Option<crate::model::Evidence>) -> Self {
            self.evidence = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceOutput`](crate::output::GetEvidenceOutput)
        pub fn build(self) -> crate::output::GetEvidenceOutput {
            crate::output::GetEvidenceOutput {
                evidence: self.evidence,
            }
        }
    }
}
impl GetEvidenceOutput {
    /// Creates a new builder-style object to manufacture [`GetEvidenceOutput`](crate::output::GetEvidenceOutput)
    pub fn builder() -> crate::output::get_evidence_output::Builder {
        crate::output::get_evidence_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDelegationsOutput {
    /// <p> The list of delegations that the <code>GetDelegations</code> API returned. </p>
    pub delegations: std::option::Option<std::vec::Vec<crate::model::DelegationMetadata>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDelegationsOutput {
    /// <p> The list of delegations that the <code>GetDelegations</code> API returned. </p>
    pub fn delegations(&self) -> std::option::Option<&[crate::model::DelegationMetadata]> {
        self.delegations.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDelegationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDelegationsOutput");
        formatter.field("delegations", &self.delegations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDelegationsOutput`](crate::output::GetDelegationsOutput)
pub mod get_delegations_output {
    /// A builder for [`GetDelegationsOutput`](crate::output::GetDelegationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegations:
            std::option::Option<std::vec::Vec<crate::model::DelegationMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `delegations`.
        ///
        /// To override the contents of this collection use [`set_delegations`](Self::set_delegations).
        ///
        /// <p> The list of delegations that the <code>GetDelegations</code> API returned. </p>
        pub fn delegations(mut self, input: impl Into<crate::model::DelegationMetadata>) -> Self {
            let mut v = self.delegations.unwrap_or_default();
            v.push(input.into());
            self.delegations = Some(v);
            self
        }
        /// <p> The list of delegations that the <code>GetDelegations</code> API returned. </p>
        pub fn set_delegations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DelegationMetadata>>,
        ) -> Self {
            self.delegations = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDelegationsOutput`](crate::output::GetDelegationsOutput)
        pub fn build(self) -> crate::output::GetDelegationsOutput {
            crate::output::GetDelegationsOutput {
                delegations: self.delegations,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDelegationsOutput {
    /// Creates a new builder-style object to manufacture [`GetDelegationsOutput`](crate::output::GetDelegationsOutput)
    pub fn builder() -> crate::output::get_delegations_output::Builder {
        crate::output::get_delegations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetControlOutput {
    /// <p> The name of the control that the <code>GetControl</code> API returned. </p>
    pub control: std::option::Option<crate::model::Control>,
}
impl GetControlOutput {
    /// <p> The name of the control that the <code>GetControl</code> API returned. </p>
    pub fn control(&self) -> std::option::Option<&crate::model::Control> {
        self.control.as_ref()
    }
}
impl std::fmt::Debug for GetControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetControlOutput");
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`GetControlOutput`](crate::output::GetControlOutput)
pub mod get_control_output {
    /// A builder for [`GetControlOutput`](crate::output::GetControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control: std::option::Option<crate::model::Control>,
    }
    impl Builder {
        /// <p> The name of the control that the <code>GetControl</code> API returned. </p>
        pub fn control(mut self, input: crate::model::Control) -> Self {
            self.control = Some(input);
            self
        }
        /// <p> The name of the control that the <code>GetControl</code> API returned. </p>
        pub fn set_control(mut self, input: std::option::Option<crate::model::Control>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`GetControlOutput`](crate::output::GetControlOutput)
        pub fn build(self) -> crate::output::GetControlOutput {
            crate::output::GetControlOutput {
                control: self.control,
            }
        }
    }
}
impl GetControlOutput {
    /// Creates a new builder-style object to manufacture [`GetControlOutput`](crate::output::GetControlOutput)
    pub fn builder() -> crate::output::get_control_output::Builder {
        crate::output::get_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangeLogsOutput {
    /// <p> The list of user activity for the control. </p>
    pub change_logs: std::option::Option<std::vec::Vec<crate::model::ChangeLog>>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetChangeLogsOutput {
    /// <p> The list of user activity for the control. </p>
    pub fn change_logs(&self) -> std::option::Option<&[crate::model::ChangeLog]> {
        self.change_logs.as_deref()
    }
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetChangeLogsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangeLogsOutput");
        formatter.field("change_logs", &self.change_logs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetChangeLogsOutput`](crate::output::GetChangeLogsOutput)
pub mod get_change_logs_output {
    /// A builder for [`GetChangeLogsOutput`](crate::output::GetChangeLogsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_logs: std::option::Option<std::vec::Vec<crate::model::ChangeLog>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `change_logs`.
        ///
        /// To override the contents of this collection use [`set_change_logs`](Self::set_change_logs).
        ///
        /// <p> The list of user activity for the control. </p>
        pub fn change_logs(mut self, input: impl Into<crate::model::ChangeLog>) -> Self {
            let mut v = self.change_logs.unwrap_or_default();
            v.push(input.into());
            self.change_logs = Some(v);
            self
        }
        /// <p> The list of user activity for the control. </p>
        pub fn set_change_logs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChangeLog>>,
        ) -> Self {
            self.change_logs = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangeLogsOutput`](crate::output::GetChangeLogsOutput)
        pub fn build(self) -> crate::output::GetChangeLogsOutput {
            crate::output::GetChangeLogsOutput {
                change_logs: self.change_logs,
                next_token: self.next_token,
            }
        }
    }
}
impl GetChangeLogsOutput {
    /// Creates a new builder-style object to manufacture [`GetChangeLogsOutput`](crate::output::GetChangeLogsOutput)
    pub fn builder() -> crate::output::get_change_logs_output::Builder {
        crate::output::get_change_logs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssessmentReportUrlOutput {
    /// <p> Short for uniform resource locator. A URL is used as a unique identifier to locate a
    /// resource on the internet. </p>
    pub pre_signed_url: std::option::Option<crate::model::Url>,
}
impl GetAssessmentReportUrlOutput {
    /// <p> Short for uniform resource locator. A URL is used as a unique identifier to locate a
    /// resource on the internet. </p>
    pub fn pre_signed_url(&self) -> std::option::Option<&crate::model::Url> {
        self.pre_signed_url.as_ref()
    }
}
impl std::fmt::Debug for GetAssessmentReportUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssessmentReportUrlOutput");
        formatter.field("pre_signed_url", &self.pre_signed_url);
        formatter.finish()
    }
}
/// See [`GetAssessmentReportUrlOutput`](crate::output::GetAssessmentReportUrlOutput)
pub mod get_assessment_report_url_output {
    /// A builder for [`GetAssessmentReportUrlOutput`](crate::output::GetAssessmentReportUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pre_signed_url: std::option::Option<crate::model::Url>,
    }
    impl Builder {
        /// <p> Short for uniform resource locator. A URL is used as a unique identifier to locate a
        /// resource on the internet. </p>
        pub fn pre_signed_url(mut self, input: crate::model::Url) -> Self {
            self.pre_signed_url = Some(input);
            self
        }
        /// <p> Short for uniform resource locator. A URL is used as a unique identifier to locate a
        /// resource on the internet. </p>
        pub fn set_pre_signed_url(mut self, input: std::option::Option<crate::model::Url>) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssessmentReportUrlOutput`](crate::output::GetAssessmentReportUrlOutput)
        pub fn build(self) -> crate::output::GetAssessmentReportUrlOutput {
            crate::output::GetAssessmentReportUrlOutput {
                pre_signed_url: self.pre_signed_url,
            }
        }
    }
}
impl GetAssessmentReportUrlOutput {
    /// Creates a new builder-style object to manufacture [`GetAssessmentReportUrlOutput`](crate::output::GetAssessmentReportUrlOutput)
    pub fn builder() -> crate::output::get_assessment_report_url_output::Builder {
        crate::output::get_assessment_report_url_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssessmentFrameworkOutput {
    /// <p> The framework that the <code>GetAssessmentFramework</code> API returned. </p>
    pub framework: std::option::Option<crate::model::Framework>,
}
impl GetAssessmentFrameworkOutput {
    /// <p> The framework that the <code>GetAssessmentFramework</code> API returned. </p>
    pub fn framework(&self) -> std::option::Option<&crate::model::Framework> {
        self.framework.as_ref()
    }
}
impl std::fmt::Debug for GetAssessmentFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssessmentFrameworkOutput");
        formatter.field("framework", &self.framework);
        formatter.finish()
    }
}
/// See [`GetAssessmentFrameworkOutput`](crate::output::GetAssessmentFrameworkOutput)
pub mod get_assessment_framework_output {
    /// A builder for [`GetAssessmentFrameworkOutput`](crate::output::GetAssessmentFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework: std::option::Option<crate::model::Framework>,
    }
    impl Builder {
        /// <p> The framework that the <code>GetAssessmentFramework</code> API returned. </p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p> The framework that the <code>GetAssessmentFramework</code> API returned. </p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssessmentFrameworkOutput`](crate::output::GetAssessmentFrameworkOutput)
        pub fn build(self) -> crate::output::GetAssessmentFrameworkOutput {
            crate::output::GetAssessmentFrameworkOutput {
                framework: self.framework,
            }
        }
    }
}
impl GetAssessmentFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`GetAssessmentFrameworkOutput`](crate::output::GetAssessmentFrameworkOutput)
    pub fn builder() -> crate::output::get_assessment_framework_output::Builder {
        crate::output::get_assessment_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssessmentOutput {
    /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
    /// An Audit Manager assessment is an implementation of an Audit Manager
    /// framework. </p>
    pub assessment: std::option::Option<crate::model::Assessment>,
    /// <p> The wrapper that contains the Audit Manager role information of the current
    /// user. This includes the role type and IAM Amazon Resource Name (ARN).
    /// </p>
    pub user_role: std::option::Option<crate::model::Role>,
}
impl GetAssessmentOutput {
    /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
    /// An Audit Manager assessment is an implementation of an Audit Manager
    /// framework. </p>
    pub fn assessment(&self) -> std::option::Option<&crate::model::Assessment> {
        self.assessment.as_ref()
    }
    /// <p> The wrapper that contains the Audit Manager role information of the current
    /// user. This includes the role type and IAM Amazon Resource Name (ARN).
    /// </p>
    pub fn user_role(&self) -> std::option::Option<&crate::model::Role> {
        self.user_role.as_ref()
    }
}
impl std::fmt::Debug for GetAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssessmentOutput");
        formatter.field("assessment", &self.assessment);
        formatter.field("user_role", &self.user_role);
        formatter.finish()
    }
}
/// See [`GetAssessmentOutput`](crate::output::GetAssessmentOutput)
pub mod get_assessment_output {
    /// A builder for [`GetAssessmentOutput`](crate::output::GetAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment: std::option::Option<crate::model::Assessment>,
        pub(crate) user_role: std::option::Option<crate::model::Role>,
    }
    impl Builder {
        /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
        /// An Audit Manager assessment is an implementation of an Audit Manager
        /// framework. </p>
        pub fn assessment(mut self, input: crate::model::Assessment) -> Self {
            self.assessment = Some(input);
            self
        }
        /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
        /// An Audit Manager assessment is an implementation of an Audit Manager
        /// framework. </p>
        pub fn set_assessment(
            mut self,
            input: std::option::Option<crate::model::Assessment>,
        ) -> Self {
            self.assessment = input;
            self
        }
        /// <p> The wrapper that contains the Audit Manager role information of the current
        /// user. This includes the role type and IAM Amazon Resource Name (ARN).
        /// </p>
        pub fn user_role(mut self, input: crate::model::Role) -> Self {
            self.user_role = Some(input);
            self
        }
        /// <p> The wrapper that contains the Audit Manager role information of the current
        /// user. This includes the role type and IAM Amazon Resource Name (ARN).
        /// </p>
        pub fn set_user_role(mut self, input: std::option::Option<crate::model::Role>) -> Self {
            self.user_role = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssessmentOutput`](crate::output::GetAssessmentOutput)
        pub fn build(self) -> crate::output::GetAssessmentOutput {
            crate::output::GetAssessmentOutput {
                assessment: self.assessment,
                user_role: self.user_role,
            }
        }
    }
}
impl GetAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`GetAssessmentOutput`](crate::output::GetAssessmentOutput)
    pub fn builder() -> crate::output::get_assessment_output::Builder {
        crate::output::get_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountStatusOutput {
    /// <p> The status of the Amazon Web Services account. </p>
    pub status: std::option::Option<crate::model::AccountStatus>,
}
impl GetAccountStatusOutput {
    /// <p> The status of the Amazon Web Services account. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::AccountStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for GetAccountStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountStatusOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`GetAccountStatusOutput`](crate::output::GetAccountStatusOutput)
pub mod get_account_status_output {
    /// A builder for [`GetAccountStatusOutput`](crate::output::GetAccountStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AccountStatus>,
    }
    impl Builder {
        /// <p> The status of the Amazon Web Services account. </p>
        pub fn status(mut self, input: crate::model::AccountStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the Amazon Web Services account. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccountStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccountStatusOutput`](crate::output::GetAccountStatusOutput)
        pub fn build(self) -> crate::output::GetAccountStatusOutput {
            crate::output::GetAccountStatusOutput {
                status: self.status,
            }
        }
    }
}
impl GetAccountStatusOutput {
    /// Creates a new builder-style object to manufacture [`GetAccountStatusOutput`](crate::output::GetAccountStatusOutput)
    pub fn builder() -> crate::output::get_account_status_output::Builder {
        crate::output::get_account_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAssessmentReportEvidenceFolderOutput {}
impl std::fmt::Debug for DisassociateAssessmentReportEvidenceFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAssessmentReportEvidenceFolderOutput");
        formatter.finish()
    }
}
/// See [`DisassociateAssessmentReportEvidenceFolderOutput`](crate::output::DisassociateAssessmentReportEvidenceFolderOutput)
pub mod disassociate_assessment_report_evidence_folder_output {
    /// A builder for [`DisassociateAssessmentReportEvidenceFolderOutput`](crate::output::DisassociateAssessmentReportEvidenceFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateAssessmentReportEvidenceFolderOutput`](crate::output::DisassociateAssessmentReportEvidenceFolderOutput)
        pub fn build(self) -> crate::output::DisassociateAssessmentReportEvidenceFolderOutput {
            crate::output::DisassociateAssessmentReportEvidenceFolderOutput {}
        }
    }
}
impl DisassociateAssessmentReportEvidenceFolderOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateAssessmentReportEvidenceFolderOutput`](crate::output::DisassociateAssessmentReportEvidenceFolderOutput)
    pub fn builder() -> crate::output::disassociate_assessment_report_evidence_folder_output::Builder
    {
        crate::output::disassociate_assessment_report_evidence_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterOrganizationAdminAccountOutput {}
impl std::fmt::Debug for DeregisterOrganizationAdminAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterOrganizationAdminAccountOutput");
        formatter.finish()
    }
}
/// See [`DeregisterOrganizationAdminAccountOutput`](crate::output::DeregisterOrganizationAdminAccountOutput)
pub mod deregister_organization_admin_account_output {
    /// A builder for [`DeregisterOrganizationAdminAccountOutput`](crate::output::DeregisterOrganizationAdminAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterOrganizationAdminAccountOutput`](crate::output::DeregisterOrganizationAdminAccountOutput)
        pub fn build(self) -> crate::output::DeregisterOrganizationAdminAccountOutput {
            crate::output::DeregisterOrganizationAdminAccountOutput {}
        }
    }
}
impl DeregisterOrganizationAdminAccountOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterOrganizationAdminAccountOutput`](crate::output::DeregisterOrganizationAdminAccountOutput)
    pub fn builder() -> crate::output::deregister_organization_admin_account_output::Builder {
        crate::output::deregister_organization_admin_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterAccountOutput {
    /// <p> The registration status of the account. </p>
    pub status: std::option::Option<crate::model::AccountStatus>,
}
impl DeregisterAccountOutput {
    /// <p> The registration status of the account. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::AccountStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DeregisterAccountOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterAccountOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeregisterAccountOutput`](crate::output::DeregisterAccountOutput)
pub mod deregister_account_output {
    /// A builder for [`DeregisterAccountOutput`](crate::output::DeregisterAccountOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::AccountStatus>,
    }
    impl Builder {
        /// <p> The registration status of the account. </p>
        pub fn status(mut self, input: crate::model::AccountStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The registration status of the account. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AccountStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterAccountOutput`](crate::output::DeregisterAccountOutput)
        pub fn build(self) -> crate::output::DeregisterAccountOutput {
            crate::output::DeregisterAccountOutput {
                status: self.status,
            }
        }
    }
}
impl DeregisterAccountOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterAccountOutput`](crate::output::DeregisterAccountOutput)
    pub fn builder() -> crate::output::deregister_account_output::Builder {
        crate::output::deregister_account_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteControlOutput {}
impl std::fmt::Debug for DeleteControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteControlOutput");
        formatter.finish()
    }
}
/// See [`DeleteControlOutput`](crate::output::DeleteControlOutput)
pub mod delete_control_output {
    /// A builder for [`DeleteControlOutput`](crate::output::DeleteControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteControlOutput`](crate::output::DeleteControlOutput)
        pub fn build(self) -> crate::output::DeleteControlOutput {
            crate::output::DeleteControlOutput {}
        }
    }
}
impl DeleteControlOutput {
    /// Creates a new builder-style object to manufacture [`DeleteControlOutput`](crate::output::DeleteControlOutput)
    pub fn builder() -> crate::output::delete_control_output::Builder {
        crate::output::delete_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentReportOutput {}
impl std::fmt::Debug for DeleteAssessmentReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentReportOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssessmentReportOutput`](crate::output::DeleteAssessmentReportOutput)
pub mod delete_assessment_report_output {
    /// A builder for [`DeleteAssessmentReportOutput`](crate::output::DeleteAssessmentReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssessmentReportOutput`](crate::output::DeleteAssessmentReportOutput)
        pub fn build(self) -> crate::output::DeleteAssessmentReportOutput {
            crate::output::DeleteAssessmentReportOutput {}
        }
    }
}
impl DeleteAssessmentReportOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentReportOutput`](crate::output::DeleteAssessmentReportOutput)
    pub fn builder() -> crate::output::delete_assessment_report_output::Builder {
        crate::output::delete_assessment_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentFrameworkShareOutput {}
impl std::fmt::Debug for DeleteAssessmentFrameworkShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentFrameworkShareOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssessmentFrameworkShareOutput`](crate::output::DeleteAssessmentFrameworkShareOutput)
pub mod delete_assessment_framework_share_output {
    /// A builder for [`DeleteAssessmentFrameworkShareOutput`](crate::output::DeleteAssessmentFrameworkShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssessmentFrameworkShareOutput`](crate::output::DeleteAssessmentFrameworkShareOutput)
        pub fn build(self) -> crate::output::DeleteAssessmentFrameworkShareOutput {
            crate::output::DeleteAssessmentFrameworkShareOutput {}
        }
    }
}
impl DeleteAssessmentFrameworkShareOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentFrameworkShareOutput`](crate::output::DeleteAssessmentFrameworkShareOutput)
    pub fn builder() -> crate::output::delete_assessment_framework_share_output::Builder {
        crate::output::delete_assessment_framework_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentFrameworkOutput {}
impl std::fmt::Debug for DeleteAssessmentFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentFrameworkOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssessmentFrameworkOutput`](crate::output::DeleteAssessmentFrameworkOutput)
pub mod delete_assessment_framework_output {
    /// A builder for [`DeleteAssessmentFrameworkOutput`](crate::output::DeleteAssessmentFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssessmentFrameworkOutput`](crate::output::DeleteAssessmentFrameworkOutput)
        pub fn build(self) -> crate::output::DeleteAssessmentFrameworkOutput {
            crate::output::DeleteAssessmentFrameworkOutput {}
        }
    }
}
impl DeleteAssessmentFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentFrameworkOutput`](crate::output::DeleteAssessmentFrameworkOutput)
    pub fn builder() -> crate::output::delete_assessment_framework_output::Builder {
        crate::output::delete_assessment_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentOutput {}
impl std::fmt::Debug for DeleteAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentOutput");
        formatter.finish()
    }
}
/// See [`DeleteAssessmentOutput`](crate::output::DeleteAssessmentOutput)
pub mod delete_assessment_output {
    /// A builder for [`DeleteAssessmentOutput`](crate::output::DeleteAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAssessmentOutput`](crate::output::DeleteAssessmentOutput)
        pub fn build(self) -> crate::output::DeleteAssessmentOutput {
            crate::output::DeleteAssessmentOutput {}
        }
    }
}
impl DeleteAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentOutput`](crate::output::DeleteAssessmentOutput)
    pub fn builder() -> crate::output::delete_assessment_output::Builder {
        crate::output::delete_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateControlOutput {
    /// <p> The new control that the <code>CreateControl</code> API returned. </p>
    pub control: std::option::Option<crate::model::Control>,
}
impl CreateControlOutput {
    /// <p> The new control that the <code>CreateControl</code> API returned. </p>
    pub fn control(&self) -> std::option::Option<&crate::model::Control> {
        self.control.as_ref()
    }
}
impl std::fmt::Debug for CreateControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateControlOutput");
        formatter.field("control", &self.control);
        formatter.finish()
    }
}
/// See [`CreateControlOutput`](crate::output::CreateControlOutput)
pub mod create_control_output {
    /// A builder for [`CreateControlOutput`](crate::output::CreateControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control: std::option::Option<crate::model::Control>,
    }
    impl Builder {
        /// <p> The new control that the <code>CreateControl</code> API returned. </p>
        pub fn control(mut self, input: crate::model::Control) -> Self {
            self.control = Some(input);
            self
        }
        /// <p> The new control that the <code>CreateControl</code> API returned. </p>
        pub fn set_control(mut self, input: std::option::Option<crate::model::Control>) -> Self {
            self.control = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateControlOutput`](crate::output::CreateControlOutput)
        pub fn build(self) -> crate::output::CreateControlOutput {
            crate::output::CreateControlOutput {
                control: self.control,
            }
        }
    }
}
impl CreateControlOutput {
    /// Creates a new builder-style object to manufacture [`CreateControlOutput`](crate::output::CreateControlOutput)
    pub fn builder() -> crate::output::create_control_output::Builder {
        crate::output::create_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentReportOutput {
    /// <p> The new assessment report that the <code>CreateAssessmentReport</code> API returned.
    /// </p>
    pub assessment_report: std::option::Option<crate::model::AssessmentReport>,
}
impl CreateAssessmentReportOutput {
    /// <p> The new assessment report that the <code>CreateAssessmentReport</code> API returned.
    /// </p>
    pub fn assessment_report(&self) -> std::option::Option<&crate::model::AssessmentReport> {
        self.assessment_report.as_ref()
    }
}
impl std::fmt::Debug for CreateAssessmentReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentReportOutput");
        formatter.field("assessment_report", &self.assessment_report);
        formatter.finish()
    }
}
/// See [`CreateAssessmentReportOutput`](crate::output::CreateAssessmentReportOutput)
pub mod create_assessment_report_output {
    /// A builder for [`CreateAssessmentReportOutput`](crate::output::CreateAssessmentReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_report: std::option::Option<crate::model::AssessmentReport>,
    }
    impl Builder {
        /// <p> The new assessment report that the <code>CreateAssessmentReport</code> API returned.
        /// </p>
        pub fn assessment_report(mut self, input: crate::model::AssessmentReport) -> Self {
            self.assessment_report = Some(input);
            self
        }
        /// <p> The new assessment report that the <code>CreateAssessmentReport</code> API returned.
        /// </p>
        pub fn set_assessment_report(
            mut self,
            input: std::option::Option<crate::model::AssessmentReport>,
        ) -> Self {
            self.assessment_report = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentReportOutput`](crate::output::CreateAssessmentReportOutput)
        pub fn build(self) -> crate::output::CreateAssessmentReportOutput {
            crate::output::CreateAssessmentReportOutput {
                assessment_report: self.assessment_report,
            }
        }
    }
}
impl CreateAssessmentReportOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentReportOutput`](crate::output::CreateAssessmentReportOutput)
    pub fn builder() -> crate::output::create_assessment_report_output::Builder {
        crate::output::create_assessment_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentFrameworkOutput {
    /// <p> The name of the new framework that the <code>CreateAssessmentFramework</code> API
    /// returned. </p>
    pub framework: std::option::Option<crate::model::Framework>,
}
impl CreateAssessmentFrameworkOutput {
    /// <p> The name of the new framework that the <code>CreateAssessmentFramework</code> API
    /// returned. </p>
    pub fn framework(&self) -> std::option::Option<&crate::model::Framework> {
        self.framework.as_ref()
    }
}
impl std::fmt::Debug for CreateAssessmentFrameworkOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentFrameworkOutput");
        formatter.field("framework", &self.framework);
        formatter.finish()
    }
}
/// See [`CreateAssessmentFrameworkOutput`](crate::output::CreateAssessmentFrameworkOutput)
pub mod create_assessment_framework_output {
    /// A builder for [`CreateAssessmentFrameworkOutput`](crate::output::CreateAssessmentFrameworkOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework: std::option::Option<crate::model::Framework>,
    }
    impl Builder {
        /// <p> The name of the new framework that the <code>CreateAssessmentFramework</code> API
        /// returned. </p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p> The name of the new framework that the <code>CreateAssessmentFramework</code> API
        /// returned. </p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentFrameworkOutput`](crate::output::CreateAssessmentFrameworkOutput)
        pub fn build(self) -> crate::output::CreateAssessmentFrameworkOutput {
            crate::output::CreateAssessmentFrameworkOutput {
                framework: self.framework,
            }
        }
    }
}
impl CreateAssessmentFrameworkOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentFrameworkOutput`](crate::output::CreateAssessmentFrameworkOutput)
    pub fn builder() -> crate::output::create_assessment_framework_output::Builder {
        crate::output::create_assessment_framework_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentOutput {
    /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
    /// An Audit Manager assessment is an implementation of an Audit Manager
    /// framework. </p>
    pub assessment: std::option::Option<crate::model::Assessment>,
}
impl CreateAssessmentOutput {
    /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
    /// An Audit Manager assessment is an implementation of an Audit Manager
    /// framework. </p>
    pub fn assessment(&self) -> std::option::Option<&crate::model::Assessment> {
        self.assessment.as_ref()
    }
}
impl std::fmt::Debug for CreateAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentOutput");
        formatter.field("assessment", &self.assessment);
        formatter.finish()
    }
}
/// See [`CreateAssessmentOutput`](crate::output::CreateAssessmentOutput)
pub mod create_assessment_output {
    /// A builder for [`CreateAssessmentOutput`](crate::output::CreateAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment: std::option::Option<crate::model::Assessment>,
    }
    impl Builder {
        /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
        /// An Audit Manager assessment is an implementation of an Audit Manager
        /// framework. </p>
        pub fn assessment(mut self, input: crate::model::Assessment) -> Self {
            self.assessment = Some(input);
            self
        }
        /// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
        /// An Audit Manager assessment is an implementation of an Audit Manager
        /// framework. </p>
        pub fn set_assessment(
            mut self,
            input: std::option::Option<crate::model::Assessment>,
        ) -> Self {
            self.assessment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentOutput`](crate::output::CreateAssessmentOutput)
        pub fn build(self) -> crate::output::CreateAssessmentOutput {
            crate::output::CreateAssessmentOutput {
                assessment: self.assessment,
            }
        }
    }
}
impl CreateAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentOutput`](crate::output::CreateAssessmentOutput)
    pub fn builder() -> crate::output::create_assessment_output::Builder {
        crate::output::create_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchImportEvidenceToAssessmentControlOutput {
    /// <p> A list of errors that the <code>BatchImportEvidenceToAssessmentControl</code> API
    /// returned. </p>
    pub errors: std::option::Option<
        std::vec::Vec<crate::model::BatchImportEvidenceToAssessmentControlError>,
    >,
}
impl BatchImportEvidenceToAssessmentControlOutput {
    /// <p> A list of errors that the <code>BatchImportEvidenceToAssessmentControl</code> API
    /// returned. </p>
    pub fn errors(
        &self,
    ) -> std::option::Option<&[crate::model::BatchImportEvidenceToAssessmentControlError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchImportEvidenceToAssessmentControlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchImportEvidenceToAssessmentControlOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchImportEvidenceToAssessmentControlOutput`](crate::output::BatchImportEvidenceToAssessmentControlOutput)
pub mod batch_import_evidence_to_assessment_control_output {
    /// A builder for [`BatchImportEvidenceToAssessmentControlOutput`](crate::output::BatchImportEvidenceToAssessmentControlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<
            std::vec::Vec<crate::model::BatchImportEvidenceToAssessmentControlError>,
        >,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p> A list of errors that the <code>BatchImportEvidenceToAssessmentControl</code> API
        /// returned. </p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchImportEvidenceToAssessmentControlError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p> A list of errors that the <code>BatchImportEvidenceToAssessmentControl</code> API
        /// returned. </p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchImportEvidenceToAssessmentControlError>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchImportEvidenceToAssessmentControlOutput`](crate::output::BatchImportEvidenceToAssessmentControlOutput)
        pub fn build(self) -> crate::output::BatchImportEvidenceToAssessmentControlOutput {
            crate::output::BatchImportEvidenceToAssessmentControlOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchImportEvidenceToAssessmentControlOutput {
    /// Creates a new builder-style object to manufacture [`BatchImportEvidenceToAssessmentControlOutput`](crate::output::BatchImportEvidenceToAssessmentControlOutput)
    pub fn builder() -> crate::output::batch_import_evidence_to_assessment_control_output::Builder {
        crate::output::batch_import_evidence_to_assessment_control_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateAssessmentReportEvidenceOutput {
    /// <p> The identifier for the evidence. </p>
    pub evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A list of errors that the <code>BatchDisassociateAssessmentReportEvidence</code> API
    /// returned. </p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::AssessmentReportEvidenceError>>,
}
impl BatchDisassociateAssessmentReportEvidenceOutput {
    /// <p> The identifier for the evidence. </p>
    pub fn evidence_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.evidence_ids.as_deref()
    }
    /// <p> A list of errors that the <code>BatchDisassociateAssessmentReportEvidence</code> API
    /// returned. </p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::AssessmentReportEvidenceError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateAssessmentReportEvidenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateAssessmentReportEvidenceOutput");
        formatter.field("evidence_ids", &self.evidence_ids);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDisassociateAssessmentReportEvidenceOutput`](crate::output::BatchDisassociateAssessmentReportEvidenceOutput)
pub mod batch_disassociate_assessment_report_evidence_output {
    /// A builder for [`BatchDisassociateAssessmentReportEvidenceOutput`](crate::output::BatchDisassociateAssessmentReportEvidenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::AssessmentReportEvidenceError>>,
    }
    impl Builder {
        /// Appends an item to `evidence_ids`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p> The identifier for the evidence. </p>
        pub fn evidence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.evidence_ids.unwrap_or_default();
            v.push(input.into());
            self.evidence_ids = Some(v);
            self
        }
        /// <p> The identifier for the evidence. </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.evidence_ids = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p> A list of errors that the <code>BatchDisassociateAssessmentReportEvidence</code> API
        /// returned. </p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::AssessmentReportEvidenceError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p> A list of errors that the <code>BatchDisassociateAssessmentReportEvidence</code> API
        /// returned. </p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentReportEvidenceError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateAssessmentReportEvidenceOutput`](crate::output::BatchDisassociateAssessmentReportEvidenceOutput)
        pub fn build(self) -> crate::output::BatchDisassociateAssessmentReportEvidenceOutput {
            crate::output::BatchDisassociateAssessmentReportEvidenceOutput {
                evidence_ids: self.evidence_ids,
                errors: self.errors,
            }
        }
    }
}
impl BatchDisassociateAssessmentReportEvidenceOutput {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateAssessmentReportEvidenceOutput`](crate::output::BatchDisassociateAssessmentReportEvidenceOutput)
    pub fn builder() -> crate::output::batch_disassociate_assessment_report_evidence_output::Builder
    {
        crate::output::batch_disassociate_assessment_report_evidence_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDelegationByAssessmentOutput {
    /// <p> A list of errors that the <code>BatchDeleteDelegationByAssessment</code> API returned.
    /// </p>
    pub errors:
        std::option::Option<std::vec::Vec<crate::model::BatchDeleteDelegationByAssessmentError>>,
}
impl BatchDeleteDelegationByAssessmentOutput {
    /// <p> A list of errors that the <code>BatchDeleteDelegationByAssessment</code> API returned.
    /// </p>
    pub fn errors(
        &self,
    ) -> std::option::Option<&[crate::model::BatchDeleteDelegationByAssessmentError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteDelegationByAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDelegationByAssessmentOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteDelegationByAssessmentOutput`](crate::output::BatchDeleteDelegationByAssessmentOutput)
pub mod batch_delete_delegation_by_assessment_output {
    /// A builder for [`BatchDeleteDelegationByAssessmentOutput`](crate::output::BatchDeleteDelegationByAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<
            std::vec::Vec<crate::model::BatchDeleteDelegationByAssessmentError>,
        >,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p> A list of errors that the <code>BatchDeleteDelegationByAssessment</code> API returned.
        /// </p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchDeleteDelegationByAssessmentError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p> A list of errors that the <code>BatchDeleteDelegationByAssessment</code> API returned.
        /// </p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchDeleteDelegationByAssessmentError>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDelegationByAssessmentOutput`](crate::output::BatchDeleteDelegationByAssessmentOutput)
        pub fn build(self) -> crate::output::BatchDeleteDelegationByAssessmentOutput {
            crate::output::BatchDeleteDelegationByAssessmentOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteDelegationByAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDelegationByAssessmentOutput`](crate::output::BatchDeleteDelegationByAssessmentOutput)
    pub fn builder() -> crate::output::batch_delete_delegation_by_assessment_output::Builder {
        crate::output::batch_delete_delegation_by_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateDelegationByAssessmentOutput {
    /// <p> The delegations that are associated with the assessment. </p>
    pub delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
    /// <p> A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
    /// </p>
    pub errors:
        std::option::Option<std::vec::Vec<crate::model::BatchCreateDelegationByAssessmentError>>,
}
impl BatchCreateDelegationByAssessmentOutput {
    /// <p> The delegations that are associated with the assessment. </p>
    pub fn delegations(&self) -> std::option::Option<&[crate::model::Delegation]> {
        self.delegations.as_deref()
    }
    /// <p> A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
    /// </p>
    pub fn errors(
        &self,
    ) -> std::option::Option<&[crate::model::BatchCreateDelegationByAssessmentError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchCreateDelegationByAssessmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateDelegationByAssessmentOutput");
        formatter.field("delegations", &self.delegations);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchCreateDelegationByAssessmentOutput`](crate::output::BatchCreateDelegationByAssessmentOutput)
pub mod batch_create_delegation_by_assessment_output {
    /// A builder for [`BatchCreateDelegationByAssessmentOutput`](crate::output::BatchCreateDelegationByAssessmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        pub(crate) errors: std::option::Option<
            std::vec::Vec<crate::model::BatchCreateDelegationByAssessmentError>,
        >,
    }
    impl Builder {
        /// Appends an item to `delegations`.
        ///
        /// To override the contents of this collection use [`set_delegations`](Self::set_delegations).
        ///
        /// <p> The delegations that are associated with the assessment. </p>
        pub fn delegations(mut self, input: impl Into<crate::model::Delegation>) -> Self {
            let mut v = self.delegations.unwrap_or_default();
            v.push(input.into());
            self.delegations = Some(v);
            self
        }
        /// <p> The delegations that are associated with the assessment. </p>
        pub fn set_delegations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        ) -> Self {
            self.delegations = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p> A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
        /// </p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchCreateDelegationByAssessmentError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p> A list of errors that the <code>BatchCreateDelegationByAssessment</code> API returned.
        /// </p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchCreateDelegationByAssessmentError>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateDelegationByAssessmentOutput`](crate::output::BatchCreateDelegationByAssessmentOutput)
        pub fn build(self) -> crate::output::BatchCreateDelegationByAssessmentOutput {
            crate::output::BatchCreateDelegationByAssessmentOutput {
                delegations: self.delegations,
                errors: self.errors,
            }
        }
    }
}
impl BatchCreateDelegationByAssessmentOutput {
    /// Creates a new builder-style object to manufacture [`BatchCreateDelegationByAssessmentOutput`](crate::output::BatchCreateDelegationByAssessmentOutput)
    pub fn builder() -> crate::output::batch_create_delegation_by_assessment_output::Builder {
        crate::output::batch_create_delegation_by_assessment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateAssessmentReportEvidenceOutput {
    /// <p> The list of evidence identifiers. </p>
    pub evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A list of errors that the <code>BatchAssociateAssessmentReportEvidence</code> API
    /// returned. </p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::AssessmentReportEvidenceError>>,
}
impl BatchAssociateAssessmentReportEvidenceOutput {
    /// <p> The list of evidence identifiers. </p>
    pub fn evidence_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.evidence_ids.as_deref()
    }
    /// <p> A list of errors that the <code>BatchAssociateAssessmentReportEvidence</code> API
    /// returned. </p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::AssessmentReportEvidenceError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateAssessmentReportEvidenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateAssessmentReportEvidenceOutput");
        formatter.field("evidence_ids", &self.evidence_ids);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchAssociateAssessmentReportEvidenceOutput`](crate::output::BatchAssociateAssessmentReportEvidenceOutput)
pub mod batch_associate_assessment_report_evidence_output {
    /// A builder for [`BatchAssociateAssessmentReportEvidenceOutput`](crate::output::BatchAssociateAssessmentReportEvidenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::AssessmentReportEvidenceError>>,
    }
    impl Builder {
        /// Appends an item to `evidence_ids`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p> The list of evidence identifiers. </p>
        pub fn evidence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.evidence_ids.unwrap_or_default();
            v.push(input.into());
            self.evidence_ids = Some(v);
            self
        }
        /// <p> The list of evidence identifiers. </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.evidence_ids = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p> A list of errors that the <code>BatchAssociateAssessmentReportEvidence</code> API
        /// returned. </p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::AssessmentReportEvidenceError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p> A list of errors that the <code>BatchAssociateAssessmentReportEvidence</code> API
        /// returned. </p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentReportEvidenceError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateAssessmentReportEvidenceOutput`](crate::output::BatchAssociateAssessmentReportEvidenceOutput)
        pub fn build(self) -> crate::output::BatchAssociateAssessmentReportEvidenceOutput {
            crate::output::BatchAssociateAssessmentReportEvidenceOutput {
                evidence_ids: self.evidence_ids,
                errors: self.errors,
            }
        }
    }
}
impl BatchAssociateAssessmentReportEvidenceOutput {
    /// Creates a new builder-style object to manufacture [`BatchAssociateAssessmentReportEvidenceOutput`](crate::output::BatchAssociateAssessmentReportEvidenceOutput)
    pub fn builder() -> crate::output::batch_associate_assessment_report_evidence_output::Builder {
        crate::output::batch_associate_assessment_report_evidence_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAssessmentReportEvidenceFolderOutput {}
impl std::fmt::Debug for AssociateAssessmentReportEvidenceFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAssessmentReportEvidenceFolderOutput");
        formatter.finish()
    }
}
/// See [`AssociateAssessmentReportEvidenceFolderOutput`](crate::output::AssociateAssessmentReportEvidenceFolderOutput)
pub mod associate_assessment_report_evidence_folder_output {
    /// A builder for [`AssociateAssessmentReportEvidenceFolderOutput`](crate::output::AssociateAssessmentReportEvidenceFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateAssessmentReportEvidenceFolderOutput`](crate::output::AssociateAssessmentReportEvidenceFolderOutput)
        pub fn build(self) -> crate::output::AssociateAssessmentReportEvidenceFolderOutput {
            crate::output::AssociateAssessmentReportEvidenceFolderOutput {}
        }
    }
}
impl AssociateAssessmentReportEvidenceFolderOutput {
    /// Creates a new builder-style object to manufacture [`AssociateAssessmentReportEvidenceFolderOutput`](crate::output::AssociateAssessmentReportEvidenceFolderOutput)
    pub fn builder() -> crate::output::associate_assessment_report_evidence_folder_output::Builder {
        crate::output::associate_assessment_report_evidence_folder_output::Builder::default()
    }
}
