// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p> Indicates that the request has invalid or missing parameters for the field. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p> The name of the validation error. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The body of the error message. </p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the validation error. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the validation error. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The body of the error message. </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> The body of the error message. </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "cannotParse" => ValidationExceptionReason::CannotParse,
            "fieldValidationFailed" => ValidationExceptionReason::FieldValidationFailed,
            "other" => ValidationExceptionReason::Other,
            "unknownOperation" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "cannotParse",
            ValidationExceptionReason::FieldValidationFailed => "fieldValidationFailed",
            ValidationExceptionReason::Other => "other",
            ValidationExceptionReason::UnknownOperation => "unknownOperation",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cannotParse",
            "fieldValidationFailed",
            "other",
            "unknownOperation",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The settings object that holds all supported Audit Manager settings. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Settings {
    /// <p> Specifies whether Organizations is enabled. </p>
    pub is_aws_org_enabled: std::option::Option<bool>,
    /// <p> The designated Amazon Simple Notification Service (Amazon SNS) topic. </p>
    pub sns_topic: std::option::Option<std::string::String>,
    /// <p> The default storage destination for assessment reports. </p>
    pub default_assessment_reports_destination:
        std::option::Option<crate::model::AssessmentReportsDestination>,
    /// <p> The designated default audit owners. </p>
    pub default_process_owners: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p> The KMS key details. </p>
    pub kms_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Settings");
        formatter.field("is_aws_org_enabled", &self.is_aws_org_enabled);
        formatter.field("sns_topic", &self.sns_topic);
        formatter.field(
            "default_assessment_reports_destination",
            &self.default_assessment_reports_destination,
        );
        formatter.field("default_process_owners", &self.default_process_owners);
        formatter.field("kms_key", &self.kms_key);
        formatter.finish()
    }
}
/// See [`Settings`](crate::model::Settings)
pub mod settings {
    /// A builder for [`Settings`](crate::model::Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_aws_org_enabled: std::option::Option<bool>,
        pub(crate) sns_topic: std::option::Option<std::string::String>,
        pub(crate) default_assessment_reports_destination:
            std::option::Option<crate::model::AssessmentReportsDestination>,
        pub(crate) default_process_owners: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Specifies whether Organizations is enabled. </p>
        pub fn is_aws_org_enabled(mut self, input: bool) -> Self {
            self.is_aws_org_enabled = Some(input);
            self
        }
        /// <p> Specifies whether Organizations is enabled. </p>
        pub fn set_is_aws_org_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_aws_org_enabled = input;
            self
        }
        /// <p> The designated Amazon Simple Notification Service (Amazon SNS) topic. </p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic = Some(input.into());
            self
        }
        /// <p> The designated Amazon Simple Notification Service (Amazon SNS) topic. </p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_topic = input;
            self
        }
        /// <p> The default storage destination for assessment reports. </p>
        pub fn default_assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.default_assessment_reports_destination = Some(input);
            self
        }
        /// <p> The default storage destination for assessment reports. </p>
        pub fn set_default_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.default_assessment_reports_destination = input;
            self
        }
        /// Appends an item to `default_process_owners`.
        ///
        /// To override the contents of this collection use [`set_default_process_owners`](Self::set_default_process_owners).
        ///
        /// <p> The designated default audit owners. </p>
        pub fn default_process_owners(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.default_process_owners.unwrap_or_default();
            v.push(input.into());
            self.default_process_owners = Some(v);
            self
        }
        /// <p> The designated default audit owners. </p>
        pub fn set_default_process_owners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.default_process_owners = input;
            self
        }
        /// <p> The KMS key details. </p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p> The KMS key details. </p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Consumes the builder and constructs a [`Settings`](crate::model::Settings)
        pub fn build(self) -> crate::model::Settings {
            crate::model::Settings {
                is_aws_org_enabled: self.is_aws_org_enabled,
                sns_topic: self.sns_topic,
                default_assessment_reports_destination: self.default_assessment_reports_destination,
                default_process_owners: self.default_process_owners,
                kms_key: self.kms_key,
            }
        }
    }
}
impl Settings {
    /// Creates a new builder-style object to manufacture [`Settings`](crate::model::Settings)
    pub fn builder() -> crate::model::settings::Builder {
        crate::model::settings::Builder::default()
    }
}

/// <p> The wrapper that contains the Audit Manager role information of the current
/// user. This includes the role type and IAM Amazon Resource Name (ARN).
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Role {
    /// <p> The type of customer persona. </p>
    /// <note>
    /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
    /// <code>PROCESS_OWNER</code>. </p>
    /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
    /// <code>PROCESS_OWNER</code>.</p>
    /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
    /// <code>RESOURCE_OWNER</code>.</p>
    /// </note>
    pub role_type: std::option::Option<crate::model::RoleType>,
    /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Role {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Role");
        formatter.field("role_type", &self.role_type);
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`Role`](crate::model::Role)
pub mod role {
    /// A builder for [`Role`](crate::model::Role)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_type: std::option::Option<crate::model::RoleType>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The type of customer persona. </p>
        /// <note>
        /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>. </p>
        /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>.</p>
        /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
        /// <code>RESOURCE_OWNER</code>.</p>
        /// </note>
        pub fn role_type(mut self, input: crate::model::RoleType) -> Self {
            self.role_type = Some(input);
            self
        }
        /// <p> The type of customer persona. </p>
        /// <note>
        /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>. </p>
        /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>.</p>
        /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
        /// <code>RESOURCE_OWNER</code>.</p>
        /// </note>
        pub fn set_role_type(mut self, input: std::option::Option<crate::model::RoleType>) -> Self {
            self.role_type = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Role`](crate::model::Role)
        pub fn build(self) -> crate::model::Role {
            crate::model::Role {
                role_type: self.role_type,
                role_arn: self.role_arn,
            }
        }
    }
}
impl Role {
    /// Creates a new builder-style object to manufacture [`Role`](crate::model::Role)
    pub fn builder() -> crate::model::role::Builder {
        crate::model::role::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RoleType {
    #[allow(missing_docs)] // documentation missing in model
    ProcessOwner,
    #[allow(missing_docs)] // documentation missing in model
    ResourceOwner,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RoleType {
    fn from(s: &str) -> Self {
        match s {
            "PROCESS_OWNER" => RoleType::ProcessOwner,
            "RESOURCE_OWNER" => RoleType::ResourceOwner,
            other => RoleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RoleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RoleType::from(s))
    }
}
impl RoleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RoleType::ProcessOwner => "PROCESS_OWNER",
            RoleType::ResourceOwner => "RESOURCE_OWNER",
            RoleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROCESS_OWNER", "RESOURCE_OWNER"]
    }
}
impl AsRef<str> for RoleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The location where Audit Manager saves assessment reports for the given
/// assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentReportsDestination {
    /// <p> The destination type, such as Amazon S3. </p>
    pub destination_type: std::option::Option<crate::model::AssessmentReportDestinationType>,
    /// <p> The destination of the assessment report. </p>
    pub destination: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssessmentReportsDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentReportsDestination");
        formatter.field("destination_type", &self.destination_type);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`AssessmentReportsDestination`](crate::model::AssessmentReportsDestination)
pub mod assessment_reports_destination {
    /// A builder for [`AssessmentReportsDestination`](crate::model::AssessmentReportsDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_type:
            std::option::Option<crate::model::AssessmentReportDestinationType>,
        pub(crate) destination: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The destination type, such as Amazon S3. </p>
        pub fn destination_type(
            mut self,
            input: crate::model::AssessmentReportDestinationType,
        ) -> Self {
            self.destination_type = Some(input);
            self
        }
        /// <p> The destination type, such as Amazon S3. </p>
        pub fn set_destination_type(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportDestinationType>,
        ) -> Self {
            self.destination_type = input;
            self
        }
        /// <p> The destination of the assessment report. </p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p> The destination of the assessment report. </p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentReportsDestination`](crate::model::AssessmentReportsDestination)
        pub fn build(self) -> crate::model::AssessmentReportsDestination {
            crate::model::AssessmentReportsDestination {
                destination_type: self.destination_type,
                destination: self.destination,
            }
        }
    }
}
impl AssessmentReportsDestination {
    /// Creates a new builder-style object to manufacture [`AssessmentReportsDestination`](crate::model::AssessmentReportsDestination)
    pub fn builder() -> crate::model::assessment_reports_destination::Builder {
        crate::model::assessment_reports_destination::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentReportDestinationType {
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentReportDestinationType {
    fn from(s: &str) -> Self {
        match s {
            "S3" => AssessmentReportDestinationType::S3,
            other => AssessmentReportDestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentReportDestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentReportDestinationType::from(s))
    }
}
impl AssessmentReportDestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentReportDestinationType::S3 => "S3",
            AssessmentReportDestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3"]
    }
}
impl AsRef<str> for AssessmentReportDestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A control in Audit Manager. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Control {
    /// <p> The Amazon Resource Name (ARN) of the control. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the control. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The type of control, such as a custom control or a standard control. </p>
    pub r#type: std::option::Option<crate::model::ControlType>,
    /// <p> The name of the control. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the control. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The steps that you should follow to determine if the control has been satisfied.
    /// </p>
    pub testing_information: std::option::Option<std::string::String>,
    /// <p> The title of the action plan for remediating the control. </p>
    pub action_plan_title: std::option::Option<std::string::String>,
    /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
    pub action_plan_instructions: std::option::Option<std::string::String>,
    /// <p> The data source that determines where Audit Manager collects evidence from for
    /// the control. </p>
    pub control_sources: std::option::Option<std::string::String>,
    /// <p> The data mapping sources for the control. </p>
    pub control_mapping_sources:
        std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
    /// <p> Specifies when the control was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies when the control was most recently updated. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The IAM user or role that created the control. </p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p> The IAM user or role that most recently updated the control. </p>
    pub last_updated_by: std::option::Option<std::string::String>,
    /// <p> The tags associated with the control. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Control {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Control");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("testing_information", &self.testing_information);
        formatter.field("action_plan_title", &self.action_plan_title);
        formatter.field("action_plan_instructions", &self.action_plan_instructions);
        formatter.field("control_sources", &self.control_sources);
        formatter.field("control_mapping_sources", &self.control_mapping_sources);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_updated_by", &self.last_updated_by);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Control`](crate::model::Control)
pub mod control {
    /// A builder for [`Control`](crate::model::Control)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ControlType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) testing_information: std::option::Option<std::string::String>,
        pub(crate) action_plan_title: std::option::Option<std::string::String>,
        pub(crate) action_plan_instructions: std::option::Option<std::string::String>,
        pub(crate) control_sources: std::option::Option<std::string::String>,
        pub(crate) control_mapping_sources:
            std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) last_updated_by: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the control. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the control. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The type of control, such as a custom control or a standard control. </p>
        pub fn r#type(mut self, input: crate::model::ControlType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of control, such as a custom control or a standard control. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ControlType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The name of the control. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the control. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the control. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the control. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The steps that you should follow to determine if the control has been satisfied.
        /// </p>
        pub fn testing_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.testing_information = Some(input.into());
            self
        }
        /// <p> The steps that you should follow to determine if the control has been satisfied.
        /// </p>
        pub fn set_testing_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.testing_information = input;
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn action_plan_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_plan_title = Some(input.into());
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn set_action_plan_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_plan_title = input;
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn action_plan_instructions(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_plan_instructions = Some(input.into());
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn set_action_plan_instructions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_plan_instructions = input;
            self
        }
        /// <p> The data source that determines where Audit Manager collects evidence from for
        /// the control. </p>
        pub fn control_sources(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_sources = Some(input.into());
            self
        }
        /// <p> The data source that determines where Audit Manager collects evidence from for
        /// the control. </p>
        pub fn set_control_sources(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_sources = input;
            self
        }
        /// Appends an item to `control_mapping_sources`.
        ///
        /// To override the contents of this collection use [`set_control_mapping_sources`](Self::set_control_mapping_sources).
        ///
        /// <p> The data mapping sources for the control. </p>
        pub fn control_mapping_sources(
            mut self,
            input: impl Into<crate::model::ControlMappingSource>,
        ) -> Self {
            let mut v = self.control_mapping_sources.unwrap_or_default();
            v.push(input.into());
            self.control_mapping_sources = Some(v);
            self
        }
        /// <p> The data mapping sources for the control. </p>
        pub fn set_control_mapping_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
        ) -> Self {
            self.control_mapping_sources = input;
            self
        }
        /// <p> Specifies when the control was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> Specifies when the control was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> Specifies when the control was most recently updated. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies when the control was most recently updated. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p> The IAM user or role that created the control. </p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p> The IAM user or role that created the control. </p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p> The IAM user or role that most recently updated the control. </p>
        pub fn last_updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_by = Some(input.into());
            self
        }
        /// <p> The IAM user or role that most recently updated the control. </p>
        pub fn set_last_updated_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_by = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags associated with the control. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags associated with the control. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Control`](crate::model::Control)
        pub fn build(self) -> crate::model::Control {
            crate::model::Control {
                arn: self.arn,
                id: self.id,
                r#type: self.r#type,
                name: self.name,
                description: self.description,
                testing_information: self.testing_information,
                action_plan_title: self.action_plan_title,
                action_plan_instructions: self.action_plan_instructions,
                control_sources: self.control_sources,
                control_mapping_sources: self.control_mapping_sources,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                created_by: self.created_by,
                last_updated_by: self.last_updated_by,
                tags: self.tags,
            }
        }
    }
}
impl Control {
    /// Creates a new builder-style object to manufacture [`Control`](crate::model::Control)
    pub fn builder() -> crate::model::control::Builder {
        crate::model::control::Builder::default()
    }
}

/// <p> The data source that determines where Audit Manager collects evidence from for
/// the control. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ControlMappingSource {
    /// <p> The unique identifier for the source. </p>
    pub source_id: std::option::Option<std::string::String>,
    /// <p> The name of the source. </p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p> The description of the source. </p>
    pub source_description: std::option::Option<std::string::String>,
    /// <p> The setup option for the data source. This option reflects if the evidence collection
    /// is automated or manual. </p>
    pub source_set_up_option: std::option::Option<crate::model::SourceSetUpOption>,
    /// <p> Specifies one of the five types of data sources for evidence collection. </p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p> The keyword to search for in CloudTrail logs, Config rules,
    /// Security Hub checks, and Amazon Web Services API names. </p>
    pub source_keyword: std::option::Option<crate::model::SourceKeyword>,
    /// <p> The frequency of evidence collection for the control mapping source. </p>
    pub source_frequency: std::option::Option<crate::model::SourceFrequency>,
    /// <p> The instructions for troubleshooting the control. </p>
    pub troubleshooting_text: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ControlMappingSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ControlMappingSource");
        formatter.field("source_id", &self.source_id);
        formatter.field("source_name", &self.source_name);
        formatter.field("source_description", &self.source_description);
        formatter.field("source_set_up_option", &self.source_set_up_option);
        formatter.field("source_type", &self.source_type);
        formatter.field("source_keyword", &self.source_keyword);
        formatter.field("source_frequency", &self.source_frequency);
        formatter.field("troubleshooting_text", &self.troubleshooting_text);
        formatter.finish()
    }
}
/// See [`ControlMappingSource`](crate::model::ControlMappingSource)
pub mod control_mapping_source {
    /// A builder for [`ControlMappingSource`](crate::model::ControlMappingSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_id: std::option::Option<std::string::String>,
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_description: std::option::Option<std::string::String>,
        pub(crate) source_set_up_option: std::option::Option<crate::model::SourceSetUpOption>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) source_keyword: std::option::Option<crate::model::SourceKeyword>,
        pub(crate) source_frequency: std::option::Option<crate::model::SourceFrequency>,
        pub(crate) troubleshooting_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for the source. </p>
        pub fn source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the source. </p>
        pub fn set_source_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_id = input;
            self
        }
        /// <p> The name of the source. </p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p> The name of the source. </p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p> The description of the source. </p>
        pub fn source_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_description = Some(input.into());
            self
        }
        /// <p> The description of the source. </p>
        pub fn set_source_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_description = input;
            self
        }
        /// <p> The setup option for the data source. This option reflects if the evidence collection
        /// is automated or manual. </p>
        pub fn source_set_up_option(mut self, input: crate::model::SourceSetUpOption) -> Self {
            self.source_set_up_option = Some(input);
            self
        }
        /// <p> The setup option for the data source. This option reflects if the evidence collection
        /// is automated or manual. </p>
        pub fn set_source_set_up_option(
            mut self,
            input: std::option::Option<crate::model::SourceSetUpOption>,
        ) -> Self {
            self.source_set_up_option = input;
            self
        }
        /// <p> Specifies one of the five types of data sources for evidence collection. </p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p> Specifies one of the five types of data sources for evidence collection. </p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p> The keyword to search for in CloudTrail logs, Config rules,
        /// Security Hub checks, and Amazon Web Services API names. </p>
        pub fn source_keyword(mut self, input: crate::model::SourceKeyword) -> Self {
            self.source_keyword = Some(input);
            self
        }
        /// <p> The keyword to search for in CloudTrail logs, Config rules,
        /// Security Hub checks, and Amazon Web Services API names. </p>
        pub fn set_source_keyword(
            mut self,
            input: std::option::Option<crate::model::SourceKeyword>,
        ) -> Self {
            self.source_keyword = input;
            self
        }
        /// <p> The frequency of evidence collection for the control mapping source. </p>
        pub fn source_frequency(mut self, input: crate::model::SourceFrequency) -> Self {
            self.source_frequency = Some(input);
            self
        }
        /// <p> The frequency of evidence collection for the control mapping source. </p>
        pub fn set_source_frequency(
            mut self,
            input: std::option::Option<crate::model::SourceFrequency>,
        ) -> Self {
            self.source_frequency = input;
            self
        }
        /// <p> The instructions for troubleshooting the control. </p>
        pub fn troubleshooting_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.troubleshooting_text = Some(input.into());
            self
        }
        /// <p> The instructions for troubleshooting the control. </p>
        pub fn set_troubleshooting_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.troubleshooting_text = input;
            self
        }
        /// Consumes the builder and constructs a [`ControlMappingSource`](crate::model::ControlMappingSource)
        pub fn build(self) -> crate::model::ControlMappingSource {
            crate::model::ControlMappingSource {
                source_id: self.source_id,
                source_name: self.source_name,
                source_description: self.source_description,
                source_set_up_option: self.source_set_up_option,
                source_type: self.source_type,
                source_keyword: self.source_keyword,
                source_frequency: self.source_frequency,
                troubleshooting_text: self.troubleshooting_text,
            }
        }
    }
}
impl ControlMappingSource {
    /// Creates a new builder-style object to manufacture [`ControlMappingSource`](crate::model::ControlMappingSource)
    pub fn builder() -> crate::model::control_mapping_source::Builder {
        crate::model::control_mapping_source::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceFrequency {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceFrequency {
    fn from(s: &str) -> Self {
        match s {
            "DAILY" => SourceFrequency::Daily,
            "MONTHLY" => SourceFrequency::Monthly,
            "WEEKLY" => SourceFrequency::Weekly,
            other => SourceFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceFrequency::from(s))
    }
}
impl SourceFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceFrequency::Daily => "DAILY",
            SourceFrequency::Monthly => "MONTHLY",
            SourceFrequency::Weekly => "WEEKLY",
            SourceFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAILY", "MONTHLY", "WEEKLY"]
    }
}
impl AsRef<str> for SourceFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The keyword to search for in CloudTrail logs, Config rules,
/// Security Hub checks, and Amazon Web Services API names. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceKeyword {
    /// <p> The method of input for the keyword. </p>
    pub keyword_input_type: std::option::Option<crate::model::KeywordInputType>,
    /// <p> The value of the keyword that's used to search CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names
    /// when mapping a control data source. </p>
    pub keyword_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceKeyword {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceKeyword");
        formatter.field("keyword_input_type", &self.keyword_input_type);
        formatter.field("keyword_value", &self.keyword_value);
        formatter.finish()
    }
}
/// See [`SourceKeyword`](crate::model::SourceKeyword)
pub mod source_keyword {
    /// A builder for [`SourceKeyword`](crate::model::SourceKeyword)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keyword_input_type: std::option::Option<crate::model::KeywordInputType>,
        pub(crate) keyword_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The method of input for the keyword. </p>
        pub fn keyword_input_type(mut self, input: crate::model::KeywordInputType) -> Self {
            self.keyword_input_type = Some(input);
            self
        }
        /// <p> The method of input for the keyword. </p>
        pub fn set_keyword_input_type(
            mut self,
            input: std::option::Option<crate::model::KeywordInputType>,
        ) -> Self {
            self.keyword_input_type = input;
            self
        }
        /// <p> The value of the keyword that's used to search CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names
        /// when mapping a control data source. </p>
        pub fn keyword_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword_value = Some(input.into());
            self
        }
        /// <p> The value of the keyword that's used to search CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names
        /// when mapping a control data source. </p>
        pub fn set_keyword_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.keyword_value = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceKeyword`](crate::model::SourceKeyword)
        pub fn build(self) -> crate::model::SourceKeyword {
            crate::model::SourceKeyword {
                keyword_input_type: self.keyword_input_type,
                keyword_value: self.keyword_value,
            }
        }
    }
}
impl SourceKeyword {
    /// Creates a new builder-style object to manufacture [`SourceKeyword`](crate::model::SourceKeyword)
    pub fn builder() -> crate::model::source_keyword::Builder {
        crate::model::source_keyword::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeywordInputType {
    #[allow(missing_docs)] // documentation missing in model
    SelectFromList,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeywordInputType {
    fn from(s: &str) -> Self {
        match s {
            "SELECT_FROM_LIST" => KeywordInputType::SelectFromList,
            other => KeywordInputType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeywordInputType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeywordInputType::from(s))
    }
}
impl KeywordInputType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeywordInputType::SelectFromList => "SELECT_FROM_LIST",
            KeywordInputType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SELECT_FROM_LIST"]
    }
}
impl AsRef<str> for KeywordInputType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    AwsApiCall,
    #[allow(missing_docs)] // documentation missing in model
    AwsCloudtrail,
    #[allow(missing_docs)] // documentation missing in model
    AwsConfig,
    #[allow(missing_docs)] // documentation missing in model
    AwsSecurityHub,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_API_Call" => SourceType::AwsApiCall,
            "AWS_Cloudtrail" => SourceType::AwsCloudtrail,
            "AWS_Config" => SourceType::AwsConfig,
            "AWS_Security_Hub" => SourceType::AwsSecurityHub,
            "MANUAL" => SourceType::Manual,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::AwsApiCall => "AWS_API_Call",
            SourceType::AwsCloudtrail => "AWS_Cloudtrail",
            SourceType::AwsConfig => "AWS_Config",
            SourceType::AwsSecurityHub => "AWS_Security_Hub",
            SourceType::Manual => "MANUAL",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_API_Call",
            "AWS_Cloudtrail",
            "AWS_Config",
            "AWS_Security_Hub",
            "MANUAL",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceSetUpOption {
    #[allow(missing_docs)] // documentation missing in model
    ProceduralControlsMapping,
    #[allow(missing_docs)] // documentation missing in model
    SystemControlsMapping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceSetUpOption {
    fn from(s: &str) -> Self {
        match s {
            "Procedural_Controls_Mapping" => SourceSetUpOption::ProceduralControlsMapping,
            "System_Controls_Mapping" => SourceSetUpOption::SystemControlsMapping,
            other => SourceSetUpOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceSetUpOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceSetUpOption::from(s))
    }
}
impl SourceSetUpOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceSetUpOption::ProceduralControlsMapping => "Procedural_Controls_Mapping",
            SourceSetUpOption::SystemControlsMapping => "System_Controls_Mapping",
            SourceSetUpOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Procedural_Controls_Mapping", "System_Controls_Mapping"]
    }
}
impl AsRef<str> for SourceSetUpOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ControlType {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ControlType {
    fn from(s: &str) -> Self {
        match s {
            "Custom" => ControlType::Custom,
            "Standard" => ControlType::Standard,
            other => ControlType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ControlType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ControlType::from(s))
    }
}
impl ControlType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ControlType::Custom => "Custom",
            ControlType::Standard => "Standard",
            ControlType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Custom", "Standard"]
    }
}
impl AsRef<str> for ControlType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> An entity that defines the scope of audit evidence collected by Audit Manager.
/// An Audit Manager assessment is an implementation of an Audit Manager
/// framework. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Assessment {
    /// <p> The Amazon Resource Name (ARN) of the assessment. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services account that's associated with the assessment. </p>
    pub aws_account: std::option::Option<crate::model::AwsAccount>,
    /// <p> The metadata for the assessment. </p>
    pub metadata: std::option::Option<crate::model::AssessmentMetadata>,
    /// <p> The framework that the assessment was created from. </p>
    pub framework: std::option::Option<crate::model::AssessmentFramework>,
    /// <p> The tags that are associated with the assessment. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Assessment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Assessment");
        formatter.field("arn", &self.arn);
        formatter.field("aws_account", &self.aws_account);
        formatter.field("metadata", &self.metadata);
        formatter.field("framework", &self.framework);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Assessment`](crate::model::Assessment)
pub mod assessment {
    /// A builder for [`Assessment`](crate::model::Assessment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) aws_account: std::option::Option<crate::model::AwsAccount>,
        pub(crate) metadata: std::option::Option<crate::model::AssessmentMetadata>,
        pub(crate) framework: std::option::Option<crate::model::AssessmentFramework>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the assessment. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the assessment. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The Amazon Web Services account that's associated with the assessment. </p>
        pub fn aws_account(mut self, input: crate::model::AwsAccount) -> Self {
            self.aws_account = Some(input);
            self
        }
        /// <p> The Amazon Web Services account that's associated with the assessment. </p>
        pub fn set_aws_account(
            mut self,
            input: std::option::Option<crate::model::AwsAccount>,
        ) -> Self {
            self.aws_account = input;
            self
        }
        /// <p> The metadata for the assessment. </p>
        pub fn metadata(mut self, input: crate::model::AssessmentMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p> The metadata for the assessment. </p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::AssessmentMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p> The framework that the assessment was created from. </p>
        pub fn framework(mut self, input: crate::model::AssessmentFramework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p> The framework that the assessment was created from. </p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::AssessmentFramework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the assessment. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags that are associated with the assessment. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Assessment`](crate::model::Assessment)
        pub fn build(self) -> crate::model::Assessment {
            crate::model::Assessment {
                arn: self.arn,
                aws_account: self.aws_account,
                metadata: self.metadata,
                framework: self.framework,
                tags: self.tags,
            }
        }
    }
}
impl Assessment {
    /// Creates a new builder-style object to manufacture [`Assessment`](crate::model::Assessment)
    pub fn builder() -> crate::model::assessment::Builder {
        crate::model::assessment::Builder::default()
    }
}

/// <p> The file used to structure and automate Audit Manager assessments for a given
/// compliance standard. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentFramework {
    /// <p> The unique identifier for the framework. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the framework. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The metadata of a framework, such as the name, ID, or description. </p>
    pub metadata: std::option::Option<crate::model::FrameworkMetadata>,
    /// <p> The control sets that are associated with the framework. </p>
    pub control_sets: std::option::Option<std::vec::Vec<crate::model::AssessmentControlSet>>,
}
impl std::fmt::Debug for AssessmentFramework {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentFramework");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("metadata", &self.metadata);
        formatter.field("control_sets", &self.control_sets);
        formatter.finish()
    }
}
/// See [`AssessmentFramework`](crate::model::AssessmentFramework)
pub mod assessment_framework {
    /// A builder for [`AssessmentFramework`](crate::model::AssessmentFramework)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) metadata: std::option::Option<crate::model::FrameworkMetadata>,
        pub(crate) control_sets:
            std::option::Option<std::vec::Vec<crate::model::AssessmentControlSet>>,
    }
    impl Builder {
        /// <p> The unique identifier for the framework. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the framework. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the framework. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the framework. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The metadata of a framework, such as the name, ID, or description. </p>
        pub fn metadata(mut self, input: crate::model::FrameworkMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p> The metadata of a framework, such as the name, ID, or description. </p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::FrameworkMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Appends an item to `control_sets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p> The control sets that are associated with the framework. </p>
        pub fn control_sets(
            mut self,
            input: impl Into<crate::model::AssessmentControlSet>,
        ) -> Self {
            let mut v = self.control_sets.unwrap_or_default();
            v.push(input.into());
            self.control_sets = Some(v);
            self
        }
        /// <p> The control sets that are associated with the framework. </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentControlSet>>,
        ) -> Self {
            self.control_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentFramework`](crate::model::AssessmentFramework)
        pub fn build(self) -> crate::model::AssessmentFramework {
            crate::model::AssessmentFramework {
                id: self.id,
                arn: self.arn,
                metadata: self.metadata,
                control_sets: self.control_sets,
            }
        }
    }
}
impl AssessmentFramework {
    /// Creates a new builder-style object to manufacture [`AssessmentFramework`](crate::model::AssessmentFramework)
    pub fn builder() -> crate::model::assessment_framework::Builder {
        crate::model::assessment_framework::Builder::default()
    }
}

/// <p> Represents a set of controls in an Audit Manager assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentControlSet {
    /// <p> The identifier of the control set in the assessment. This is the control set name in a
    /// plain string format. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The description for the control set. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> Specifies the current status of the control set. </p>
    pub status: std::option::Option<crate::model::ControlSetStatus>,
    /// <p> The roles that are associated with the control set. </p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p> The list of controls that's contained with the control set. </p>
    pub controls: std::option::Option<std::vec::Vec<crate::model::AssessmentControl>>,
    /// <p> The delegations that are associated with the control set. </p>
    pub delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
    /// <p> The total number of evidence objects that are retrieved automatically for the control
    /// set. </p>
    pub system_evidence_count: i32,
    /// <p> The total number of evidence objects that are uploaded manually to the control set.
    /// </p>
    pub manual_evidence_count: i32,
}
impl std::fmt::Debug for AssessmentControlSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentControlSet");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("roles", &self.roles);
        formatter.field("controls", &self.controls);
        formatter.field("delegations", &self.delegations);
        formatter.field("system_evidence_count", &self.system_evidence_count);
        formatter.field("manual_evidence_count", &self.manual_evidence_count);
        formatter.finish()
    }
}
/// See [`AssessmentControlSet`](crate::model::AssessmentControlSet)
pub mod assessment_control_set {
    /// A builder for [`AssessmentControlSet`](crate::model::AssessmentControlSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ControlSetStatus>,
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) controls: std::option::Option<std::vec::Vec<crate::model::AssessmentControl>>,
        pub(crate) delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        pub(crate) system_evidence_count: std::option::Option<i32>,
        pub(crate) manual_evidence_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The identifier of the control set in the assessment. This is the control set name in a
        /// plain string format. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The identifier of the control set in the assessment. This is the control set name in a
        /// plain string format. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The description for the control set. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description for the control set. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> Specifies the current status of the control set. </p>
        pub fn status(mut self, input: crate::model::ControlSetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> Specifies the current status of the control set. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ControlSetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p> The roles that are associated with the control set. </p>
        pub fn roles(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p> The roles that are associated with the control set. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Appends an item to `controls`.
        ///
        /// To override the contents of this collection use [`set_controls`](Self::set_controls).
        ///
        /// <p> The list of controls that's contained with the control set. </p>
        pub fn controls(mut self, input: impl Into<crate::model::AssessmentControl>) -> Self {
            let mut v = self.controls.unwrap_or_default();
            v.push(input.into());
            self.controls = Some(v);
            self
        }
        /// <p> The list of controls that's contained with the control set. </p>
        pub fn set_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssessmentControl>>,
        ) -> Self {
            self.controls = input;
            self
        }
        /// Appends an item to `delegations`.
        ///
        /// To override the contents of this collection use [`set_delegations`](Self::set_delegations).
        ///
        /// <p> The delegations that are associated with the control set. </p>
        pub fn delegations(mut self, input: impl Into<crate::model::Delegation>) -> Self {
            let mut v = self.delegations.unwrap_or_default();
            v.push(input.into());
            self.delegations = Some(v);
            self
        }
        /// <p> The delegations that are associated with the control set. </p>
        pub fn set_delegations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        ) -> Self {
            self.delegations = input;
            self
        }
        /// <p> The total number of evidence objects that are retrieved automatically for the control
        /// set. </p>
        pub fn system_evidence_count(mut self, input: i32) -> Self {
            self.system_evidence_count = Some(input);
            self
        }
        /// <p> The total number of evidence objects that are retrieved automatically for the control
        /// set. </p>
        pub fn set_system_evidence_count(mut self, input: std::option::Option<i32>) -> Self {
            self.system_evidence_count = input;
            self
        }
        /// <p> The total number of evidence objects that are uploaded manually to the control set.
        /// </p>
        pub fn manual_evidence_count(mut self, input: i32) -> Self {
            self.manual_evidence_count = Some(input);
            self
        }
        /// <p> The total number of evidence objects that are uploaded manually to the control set.
        /// </p>
        pub fn set_manual_evidence_count(mut self, input: std::option::Option<i32>) -> Self {
            self.manual_evidence_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentControlSet`](crate::model::AssessmentControlSet)
        pub fn build(self) -> crate::model::AssessmentControlSet {
            crate::model::AssessmentControlSet {
                id: self.id,
                description: self.description,
                status: self.status,
                roles: self.roles,
                controls: self.controls,
                delegations: self.delegations,
                system_evidence_count: self.system_evidence_count.unwrap_or_default(),
                manual_evidence_count: self.manual_evidence_count.unwrap_or_default(),
            }
        }
    }
}
impl AssessmentControlSet {
    /// Creates a new builder-style object to manufacture [`AssessmentControlSet`](crate::model::AssessmentControlSet)
    pub fn builder() -> crate::model::assessment_control_set::Builder {
        crate::model::assessment_control_set::Builder::default()
    }
}

/// <p> The assignment of a control set to a delegate for review. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Delegation {
    /// <p> The unique identifier for the delegation. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the assessment that's associated with the delegation. </p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p> The identifier for the assessment that's associated with the delegation. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The status of the delegation. </p>
    pub status: std::option::Option<crate::model::DelegationStatus>,
    /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p> The type of customer persona. </p>
    /// <note>
    /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
    /// <code>PROCESS_OWNER</code>. </p>
    /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
    /// <code>PROCESS_OWNER</code>.</p>
    /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
    /// <code>RESOURCE_OWNER</code>.</p>
    /// </note>
    pub role_type: std::option::Option<crate::model::RoleType>,
    /// <p> Specifies when the delegation was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies when the delegation was last updated. </p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The identifier for the control set that's associated with the delegation. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The comment that's related to the delegation. </p>
    pub comment: std::option::Option<std::string::String>,
    /// <p> The IAM user or role that created the delegation. </p>
    pub created_by: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Delegation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Delegation");
        formatter.field("id", &self.id);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("status", &self.status);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("role_type", &self.role_type);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("comment", &self.comment);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`Delegation`](crate::model::Delegation)
pub mod delegation {
    /// A builder for [`Delegation`](crate::model::Delegation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DelegationStatus>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) role_type: std::option::Option<crate::model::RoleType>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for the delegation. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the delegation. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the assessment that's associated with the delegation. </p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p> The name of the assessment that's associated with the delegation. </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p> The identifier for the assessment that's associated with the delegation. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment that's associated with the delegation. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The status of the delegation. </p>
        pub fn status(mut self, input: crate::model::DelegationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the delegation. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DelegationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p> The type of customer persona. </p>
        /// <note>
        /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>. </p>
        /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>.</p>
        /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
        /// <code>RESOURCE_OWNER</code>.</p>
        /// </note>
        pub fn role_type(mut self, input: crate::model::RoleType) -> Self {
            self.role_type = Some(input);
            self
        }
        /// <p> The type of customer persona. </p>
        /// <note>
        /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>. </p>
        /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>.</p>
        /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
        /// <code>RESOURCE_OWNER</code>.</p>
        /// </note>
        pub fn set_role_type(mut self, input: std::option::Option<crate::model::RoleType>) -> Self {
            self.role_type = input;
            self
        }
        /// <p> Specifies when the delegation was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> Specifies when the delegation was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> Specifies when the delegation was last updated. </p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p> Specifies when the delegation was last updated. </p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p> The identifier for the control set that's associated with the delegation. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set that's associated with the delegation. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The comment that's related to the delegation. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p> The comment that's related to the delegation. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p> The IAM user or role that created the delegation. </p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p> The IAM user or role that created the delegation. </p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`Delegation`](crate::model::Delegation)
        pub fn build(self) -> crate::model::Delegation {
            crate::model::Delegation {
                id: self.id,
                assessment_name: self.assessment_name,
                assessment_id: self.assessment_id,
                status: self.status,
                role_arn: self.role_arn,
                role_type: self.role_type,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
                control_set_id: self.control_set_id,
                comment: self.comment,
                created_by: self.created_by,
            }
        }
    }
}
impl Delegation {
    /// Creates a new builder-style object to manufacture [`Delegation`](crate::model::Delegation)
    pub fn builder() -> crate::model::delegation::Builder {
        crate::model::delegation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DelegationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    UnderReview,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DelegationStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => DelegationStatus::Complete,
            "IN_PROGRESS" => DelegationStatus::InProgress,
            "UNDER_REVIEW" => DelegationStatus::UnderReview,
            other => DelegationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DelegationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DelegationStatus::from(s))
    }
}
impl DelegationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DelegationStatus::Complete => "COMPLETE",
            DelegationStatus::InProgress => "IN_PROGRESS",
            DelegationStatus::UnderReview => "UNDER_REVIEW",
            DelegationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "IN_PROGRESS", "UNDER_REVIEW"]
    }
}
impl AsRef<str> for DelegationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The control entity that represents a standard control or a custom control in an Audit Manager assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentControl {
    /// <p> The identifier for the control. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the control. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the control. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The status of the control. </p>
    pub status: std::option::Option<crate::model::ControlStatus>,
    /// <p> The response of the control. </p>
    pub response: std::option::Option<crate::model::ControlResponse>,
    /// <p> The list of comments that's attached to the control. </p>
    pub comments: std::option::Option<std::vec::Vec<crate::model::ControlComment>>,
    /// <p> The list of data sources for the evidence. </p>
    pub evidence_sources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The amount of evidence that's generated for the control. </p>
    pub evidence_count: i32,
    /// <p> The amount of evidence in the assessment report. </p>
    pub assessment_report_evidence_count: i32,
}
impl std::fmt::Debug for AssessmentControl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentControl");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("response", &self.response);
        formatter.field("comments", &self.comments);
        formatter.field("evidence_sources", &self.evidence_sources);
        formatter.field("evidence_count", &self.evidence_count);
        formatter.field(
            "assessment_report_evidence_count",
            &self.assessment_report_evidence_count,
        );
        formatter.finish()
    }
}
/// See [`AssessmentControl`](crate::model::AssessmentControl)
pub mod assessment_control {
    /// A builder for [`AssessmentControl`](crate::model::AssessmentControl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ControlStatus>,
        pub(crate) response: std::option::Option<crate::model::ControlResponse>,
        pub(crate) comments: std::option::Option<std::vec::Vec<crate::model::ControlComment>>,
        pub(crate) evidence_sources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) evidence_count: std::option::Option<i32>,
        pub(crate) assessment_report_evidence_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The identifier for the control. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the control. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the control. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the control. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the control. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The status of the control. </p>
        pub fn status(mut self, input: crate::model::ControlStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the control. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ControlStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The response of the control. </p>
        pub fn response(mut self, input: crate::model::ControlResponse) -> Self {
            self.response = Some(input);
            self
        }
        /// <p> The response of the control. </p>
        pub fn set_response(
            mut self,
            input: std::option::Option<crate::model::ControlResponse>,
        ) -> Self {
            self.response = input;
            self
        }
        /// Appends an item to `comments`.
        ///
        /// To override the contents of this collection use [`set_comments`](Self::set_comments).
        ///
        /// <p> The list of comments that's attached to the control. </p>
        pub fn comments(mut self, input: impl Into<crate::model::ControlComment>) -> Self {
            let mut v = self.comments.unwrap_or_default();
            v.push(input.into());
            self.comments = Some(v);
            self
        }
        /// <p> The list of comments that's attached to the control. </p>
        pub fn set_comments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlComment>>,
        ) -> Self {
            self.comments = input;
            self
        }
        /// Appends an item to `evidence_sources`.
        ///
        /// To override the contents of this collection use [`set_evidence_sources`](Self::set_evidence_sources).
        ///
        /// <p> The list of data sources for the evidence. </p>
        pub fn evidence_sources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.evidence_sources.unwrap_or_default();
            v.push(input.into());
            self.evidence_sources = Some(v);
            self
        }
        /// <p> The list of data sources for the evidence. </p>
        pub fn set_evidence_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.evidence_sources = input;
            self
        }
        /// <p> The amount of evidence that's generated for the control. </p>
        pub fn evidence_count(mut self, input: i32) -> Self {
            self.evidence_count = Some(input);
            self
        }
        /// <p> The amount of evidence that's generated for the control. </p>
        pub fn set_evidence_count(mut self, input: std::option::Option<i32>) -> Self {
            self.evidence_count = input;
            self
        }
        /// <p> The amount of evidence in the assessment report. </p>
        pub fn assessment_report_evidence_count(mut self, input: i32) -> Self {
            self.assessment_report_evidence_count = Some(input);
            self
        }
        /// <p> The amount of evidence in the assessment report. </p>
        pub fn set_assessment_report_evidence_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.assessment_report_evidence_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentControl`](crate::model::AssessmentControl)
        pub fn build(self) -> crate::model::AssessmentControl {
            crate::model::AssessmentControl {
                id: self.id,
                name: self.name,
                description: self.description,
                status: self.status,
                response: self.response,
                comments: self.comments,
                evidence_sources: self.evidence_sources,
                evidence_count: self.evidence_count.unwrap_or_default(),
                assessment_report_evidence_count: self
                    .assessment_report_evidence_count
                    .unwrap_or_default(),
            }
        }
    }
}
impl AssessmentControl {
    /// Creates a new builder-style object to manufacture [`AssessmentControl`](crate::model::AssessmentControl)
    pub fn builder() -> crate::model::assessment_control::Builder {
        crate::model::assessment_control::Builder::default()
    }
}

/// <p> A comment that's posted by a user on a control. This includes the author's name, the
/// comment text, and a timestamp. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ControlComment {
    /// <p> The name of the user who authored the comment. </p>
    pub author_name: std::option::Option<std::string::String>,
    /// <p> The body text of a control comment. </p>
    pub comment_body: std::option::Option<std::string::String>,
    /// <p> The time when the comment was posted. </p>
    pub posted_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ControlComment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ControlComment");
        formatter.field("author_name", &self.author_name);
        formatter.field("comment_body", &self.comment_body);
        formatter.field("posted_date", &self.posted_date);
        formatter.finish()
    }
}
/// See [`ControlComment`](crate::model::ControlComment)
pub mod control_comment {
    /// A builder for [`ControlComment`](crate::model::ControlComment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) author_name: std::option::Option<std::string::String>,
        pub(crate) comment_body: std::option::Option<std::string::String>,
        pub(crate) posted_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The name of the user who authored the comment. </p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_name = Some(input.into());
            self
        }
        /// <p> The name of the user who authored the comment. </p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_name = input;
            self
        }
        /// <p> The body text of a control comment. </p>
        pub fn comment_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_body = Some(input.into());
            self
        }
        /// <p> The body text of a control comment. </p>
        pub fn set_comment_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_body = input;
            self
        }
        /// <p> The time when the comment was posted. </p>
        pub fn posted_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.posted_date = Some(input);
            self
        }
        /// <p> The time when the comment was posted. </p>
        pub fn set_posted_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.posted_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ControlComment`](crate::model::ControlComment)
        pub fn build(self) -> crate::model::ControlComment {
            crate::model::ControlComment {
                author_name: self.author_name,
                comment_body: self.comment_body,
                posted_date: self.posted_date,
            }
        }
    }
}
impl ControlComment {
    /// Creates a new builder-style object to manufacture [`ControlComment`](crate::model::ControlComment)
    pub fn builder() -> crate::model::control_comment::Builder {
        crate::model::control_comment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ControlResponse {
    #[allow(missing_docs)] // documentation missing in model
    Automate,
    #[allow(missing_docs)] // documentation missing in model
    Defer,
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Manual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ControlResponse {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMATE" => ControlResponse::Automate,
            "DEFER" => ControlResponse::Defer,
            "IGNORE" => ControlResponse::Ignore,
            "MANUAL" => ControlResponse::Manual,
            other => ControlResponse::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ControlResponse {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ControlResponse::from(s))
    }
}
impl ControlResponse {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ControlResponse::Automate => "AUTOMATE",
            ControlResponse::Defer => "DEFER",
            ControlResponse::Ignore => "IGNORE",
            ControlResponse::Manual => "MANUAL",
            ControlResponse::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMATE", "DEFER", "IGNORE", "MANUAL"]
    }
}
impl AsRef<str> for ControlResponse {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ControlStatus {
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Reviewed,
    #[allow(missing_docs)] // documentation missing in model
    UnderReview,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ControlStatus {
    fn from(s: &str) -> Self {
        match s {
            "INACTIVE" => ControlStatus::Inactive,
            "REVIEWED" => ControlStatus::Reviewed,
            "UNDER_REVIEW" => ControlStatus::UnderReview,
            other => ControlStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ControlStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ControlStatus::from(s))
    }
}
impl ControlStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ControlStatus::Inactive => "INACTIVE",
            ControlStatus::Reviewed => "REVIEWED",
            ControlStatus::UnderReview => "UNDER_REVIEW",
            ControlStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INACTIVE", "REVIEWED", "UNDER_REVIEW"]
    }
}
impl AsRef<str> for ControlStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ControlSetStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Reviewed,
    #[allow(missing_docs)] // documentation missing in model
    UnderReview,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ControlSetStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ControlSetStatus::Active,
            "REVIEWED" => ControlSetStatus::Reviewed,
            "UNDER_REVIEW" => ControlSetStatus::UnderReview,
            other => ControlSetStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ControlSetStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ControlSetStatus::from(s))
    }
}
impl ControlSetStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ControlSetStatus::Active => "ACTIVE",
            ControlSetStatus::Reviewed => "REVIEWED",
            ControlSetStatus::UnderReview => "UNDER_REVIEW",
            ControlSetStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "REVIEWED", "UNDER_REVIEW"]
    }
}
impl AsRef<str> for ControlSetStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The metadata of a framework, such as the name, ID, or description. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrameworkMetadata {
    /// <p> The name of the framework. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the framework. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The logo that's associated with the framework. </p>
    pub logo: std::option::Option<std::string::String>,
    /// <p> The compliance standard that's associated with the framework. For example, this could
    /// be PCI DSS or HIPAA. </p>
    pub compliance_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FrameworkMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrameworkMetadata");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("logo", &self.logo);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.finish()
    }
}
/// See [`FrameworkMetadata`](crate::model::FrameworkMetadata)
pub mod framework_metadata {
    /// A builder for [`FrameworkMetadata`](crate::model::FrameworkMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) logo: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the framework. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the framework. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the framework. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the framework. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The logo that's associated with the framework. </p>
        pub fn logo(mut self, input: impl Into<std::string::String>) -> Self {
            self.logo = Some(input.into());
            self
        }
        /// <p> The logo that's associated with the framework. </p>
        pub fn set_logo(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logo = input;
            self
        }
        /// <p> The compliance standard that's associated with the framework. For example, this could
        /// be PCI DSS or HIPAA. </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p> The compliance standard that's associated with the framework. For example, this could
        /// be PCI DSS or HIPAA. </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`FrameworkMetadata`](crate::model::FrameworkMetadata)
        pub fn build(self) -> crate::model::FrameworkMetadata {
            crate::model::FrameworkMetadata {
                name: self.name,
                description: self.description,
                logo: self.logo,
                compliance_type: self.compliance_type,
            }
        }
    }
}
impl FrameworkMetadata {
    /// Creates a new builder-style object to manufacture [`FrameworkMetadata`](crate::model::FrameworkMetadata)
    pub fn builder() -> crate::model::framework_metadata::Builder {
        crate::model::framework_metadata::Builder::default()
    }
}

/// <p> The metadata that's associated with the specified assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentMetadata {
    /// <p> The name of the assessment. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the assessment. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The description of the assessment. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The name of the compliance standard that's related to the assessment, such as PCI-DSS.
    /// </p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p> The overall status of the assessment. </p>
    pub status: std::option::Option<crate::model::AssessmentStatus>,
    /// <p> The destination that evidence reports are stored in for the assessment. </p>
    pub assessment_reports_destination:
        std::option::Option<crate::model::AssessmentReportsDestination>,
    /// <p> The wrapper of Amazon Web Services accounts and services that are in scope for the
    /// assessment. </p>
    pub scope: std::option::Option<crate::model::Scope>,
    /// <p> The roles that are associated with the assessment. </p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p> The delegations that are associated with the assessment. </p>
    pub delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
    /// <p> Specifies when the assessment was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The time of the most recent update. </p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AssessmentMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentMetadata");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("status", &self.status);
        formatter.field(
            "assessment_reports_destination",
            &self.assessment_reports_destination,
        );
        formatter.field("scope", &self.scope);
        formatter.field("roles", &self.roles);
        formatter.field("delegations", &self.delegations);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.finish()
    }
}
/// See [`AssessmentMetadata`](crate::model::AssessmentMetadata)
pub mod assessment_metadata {
    /// A builder for [`AssessmentMetadata`](crate::model::AssessmentMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AssessmentStatus>,
        pub(crate) assessment_reports_destination:
            std::option::Option<crate::model::AssessmentReportsDestination>,
        pub(crate) scope: std::option::Option<crate::model::Scope>,
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The name of the assessment. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the assessment. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The description of the assessment. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the assessment. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The name of the compliance standard that's related to the assessment, such as PCI-DSS.
        /// </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p> The name of the compliance standard that's related to the assessment, such as PCI-DSS.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p> The overall status of the assessment. </p>
        pub fn status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The overall status of the assessment. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The destination that evidence reports are stored in for the assessment. </p>
        pub fn assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.assessment_reports_destination = Some(input);
            self
        }
        /// <p> The destination that evidence reports are stored in for the assessment. </p>
        pub fn set_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.assessment_reports_destination = input;
            self
        }
        /// <p> The wrapper of Amazon Web Services accounts and services that are in scope for the
        /// assessment. </p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p> The wrapper of Amazon Web Services accounts and services that are in scope for the
        /// assessment. </p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.scope = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p> The roles that are associated with the assessment. </p>
        pub fn roles(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p> The roles that are associated with the assessment. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Appends an item to `delegations`.
        ///
        /// To override the contents of this collection use [`set_delegations`](Self::set_delegations).
        ///
        /// <p> The delegations that are associated with the assessment. </p>
        pub fn delegations(mut self, input: impl Into<crate::model::Delegation>) -> Self {
            let mut v = self.delegations.unwrap_or_default();
            v.push(input.into());
            self.delegations = Some(v);
            self
        }
        /// <p> The delegations that are associated with the assessment. </p>
        pub fn set_delegations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        ) -> Self {
            self.delegations = input;
            self
        }
        /// <p> Specifies when the assessment was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> Specifies when the assessment was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The time of the most recent update. </p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p> The time of the most recent update. </p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentMetadata`](crate::model::AssessmentMetadata)
        pub fn build(self) -> crate::model::AssessmentMetadata {
            crate::model::AssessmentMetadata {
                name: self.name,
                id: self.id,
                description: self.description,
                compliance_type: self.compliance_type,
                status: self.status,
                assessment_reports_destination: self.assessment_reports_destination,
                scope: self.scope,
                roles: self.roles,
                delegations: self.delegations,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
            }
        }
    }
}
impl AssessmentMetadata {
    /// Creates a new builder-style object to manufacture [`AssessmentMetadata`](crate::model::AssessmentMetadata)
    pub fn builder() -> crate::model::assessment_metadata::Builder {
        crate::model::assessment_metadata::Builder::default()
    }
}

/// <p> The wrapper that contains the Amazon Web Services accounts and services that are in
/// scope for the assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Scope {
    /// <p> The Amazon Web Services accounts that are included in the scope of the assessment.
    /// </p>
    pub aws_accounts: std::option::Option<std::vec::Vec<crate::model::AwsAccount>>,
    /// <p> The Amazon Web Services services that are included in the scope of the assessment.
    /// </p>
    pub aws_services: std::option::Option<std::vec::Vec<crate::model::AwsService>>,
}
impl std::fmt::Debug for Scope {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Scope");
        formatter.field("aws_accounts", &self.aws_accounts);
        formatter.field("aws_services", &self.aws_services);
        formatter.finish()
    }
}
/// See [`Scope`](crate::model::Scope)
pub mod scope {
    /// A builder for [`Scope`](crate::model::Scope)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_accounts: std::option::Option<std::vec::Vec<crate::model::AwsAccount>>,
        pub(crate) aws_services: std::option::Option<std::vec::Vec<crate::model::AwsService>>,
    }
    impl Builder {
        /// Appends an item to `aws_accounts`.
        ///
        /// To override the contents of this collection use [`set_aws_accounts`](Self::set_aws_accounts).
        ///
        /// <p> The Amazon Web Services accounts that are included in the scope of the assessment.
        /// </p>
        pub fn aws_accounts(mut self, input: impl Into<crate::model::AwsAccount>) -> Self {
            let mut v = self.aws_accounts.unwrap_or_default();
            v.push(input.into());
            self.aws_accounts = Some(v);
            self
        }
        /// <p> The Amazon Web Services accounts that are included in the scope of the assessment.
        /// </p>
        pub fn set_aws_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsAccount>>,
        ) -> Self {
            self.aws_accounts = input;
            self
        }
        /// Appends an item to `aws_services`.
        ///
        /// To override the contents of this collection use [`set_aws_services`](Self::set_aws_services).
        ///
        /// <p> The Amazon Web Services services that are included in the scope of the assessment.
        /// </p>
        pub fn aws_services(mut self, input: impl Into<crate::model::AwsService>) -> Self {
            let mut v = self.aws_services.unwrap_or_default();
            v.push(input.into());
            self.aws_services = Some(v);
            self
        }
        /// <p> The Amazon Web Services services that are included in the scope of the assessment.
        /// </p>
        pub fn set_aws_services(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AwsService>>,
        ) -> Self {
            self.aws_services = input;
            self
        }
        /// Consumes the builder and constructs a [`Scope`](crate::model::Scope)
        pub fn build(self) -> crate::model::Scope {
            crate::model::Scope {
                aws_accounts: self.aws_accounts,
                aws_services: self.aws_services,
            }
        }
    }
}
impl Scope {
    /// Creates a new builder-style object to manufacture [`Scope`](crate::model::Scope)
    pub fn builder() -> crate::model::scope::Builder {
        crate::model::scope::Builder::default()
    }
}

/// <p> An Amazon Web Service such as Amazon S3 or CloudTrail.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsService {
    /// <p> The name of the Amazon Web Service. </p>
    pub service_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsService");
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}
/// See [`AwsService`](crate::model::AwsService)
pub mod aws_service {
    /// A builder for [`AwsService`](crate::model::AwsService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the Amazon Web Service. </p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p> The name of the Amazon Web Service. </p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsService`](crate::model::AwsService)
        pub fn build(self) -> crate::model::AwsService {
            crate::model::AwsService {
                service_name: self.service_name,
            }
        }
    }
}
impl AwsService {
    /// Creates a new builder-style object to manufacture [`AwsService`](crate::model::AwsService)
    pub fn builder() -> crate::model::aws_service::Builder {
        crate::model::aws_service::Builder::default()
    }
}

/// <p> The wrapper of Amazon Web Services account details, such as account ID or email address.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsAccount {
    /// <p> The identifier for the Amazon Web Services account. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The email address that's associated with the Amazon Web Services account. </p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p> The name of the Amazon Web Services account. </p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AwsAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsAccount");
        formatter.field("id", &self.id);
        formatter.field("email_address", &self.email_address);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AwsAccount`](crate::model::AwsAccount)
pub mod aws_account {
    /// A builder for [`AwsAccount`](crate::model::AwsAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the Amazon Web Services account. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The identifier for the Amazon Web Services account. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The email address that's associated with the Amazon Web Services account. </p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p> The email address that's associated with the Amazon Web Services account. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p> The name of the Amazon Web Services account. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the Amazon Web Services account. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsAccount`](crate::model::AwsAccount)
        pub fn build(self) -> crate::model::AwsAccount {
            crate::model::AwsAccount {
                id: self.id,
                email_address: self.email_address,
                name: self.name,
            }
        }
    }
}
impl AwsAccount {
    /// Creates a new builder-style object to manufacture [`AwsAccount`](crate::model::AwsAccount)
    pub fn builder() -> crate::model::aws_account::Builder {
        crate::model::aws_account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AssessmentStatus::Active,
            "INACTIVE" => AssessmentStatus::Inactive,
            other => AssessmentStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentStatus::from(s))
    }
}
impl AssessmentStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentStatus::Active => "ACTIVE",
            AssessmentStatus::Inactive => "INACTIVE",
            AssessmentStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for AssessmentStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Represents a share request for a custom framework in Audit Manager. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentFrameworkShareRequest {
    /// <p> The unique identifier for the share request. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the shared custom framework. </p>
    pub framework_id: std::option::Option<std::string::String>,
    /// <p> The name of the custom framework that the share request is for. </p>
    pub framework_name: std::option::Option<std::string::String>,
    /// <p>The description of the shared custom framework.</p>
    pub framework_description: std::option::Option<std::string::String>,
    /// <p> The status of the share request. </p>
    pub status: std::option::Option<crate::model::ShareRequestStatus>,
    /// <p> The Amazon Web Services account of the sender. </p>
    pub source_account: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services account of the recipient. </p>
    pub destination_account: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services Region of the recipient. </p>
    pub destination_region: std::option::Option<std::string::String>,
    /// <p> The time when the share request expires. </p>
    pub expiration_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The time when the share request was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies when the share request was last updated. </p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// <p> An optional comment from the sender about the share request. </p>
    pub comment: std::option::Option<std::string::String>,
    /// <p>The number of standard controls that are part of the shared custom framework. </p>
    pub standard_controls_count: std::option::Option<i32>,
    /// <p>The number of custom controls that are part of the shared custom framework.</p>
    pub custom_controls_count: std::option::Option<i32>,
    /// <p>The compliance type that the shared custom framework supports, such as CIS or HIPAA.</p>
    pub compliance_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssessmentFrameworkShareRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentFrameworkShareRequest");
        formatter.field("id", &self.id);
        formatter.field("framework_id", &self.framework_id);
        formatter.field("framework_name", &self.framework_name);
        formatter.field("framework_description", &self.framework_description);
        formatter.field("status", &self.status);
        formatter.field("source_account", &self.source_account);
        formatter.field("destination_account", &self.destination_account);
        formatter.field("destination_region", &self.destination_region);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("comment", &self.comment);
        formatter.field("standard_controls_count", &self.standard_controls_count);
        formatter.field("custom_controls_count", &self.custom_controls_count);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.finish()
    }
}
/// See [`AssessmentFrameworkShareRequest`](crate::model::AssessmentFrameworkShareRequest)
pub mod assessment_framework_share_request {
    /// A builder for [`AssessmentFrameworkShareRequest`](crate::model::AssessmentFrameworkShareRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) framework_id: std::option::Option<std::string::String>,
        pub(crate) framework_name: std::option::Option<std::string::String>,
        pub(crate) framework_description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ShareRequestStatus>,
        pub(crate) source_account: std::option::Option<std::string::String>,
        pub(crate) destination_account: std::option::Option<std::string::String>,
        pub(crate) destination_region: std::option::Option<std::string::String>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) standard_controls_count: std::option::Option<i32>,
        pub(crate) custom_controls_count: std::option::Option<i32>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for the share request. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the share request. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The unique identifier for the shared custom framework. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the shared custom framework. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework_id = input;
            self
        }
        /// <p> The name of the custom framework that the share request is for. </p>
        pub fn framework_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_name = Some(input.into());
            self
        }
        /// <p> The name of the custom framework that the share request is for. </p>
        pub fn set_framework_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_name = input;
            self
        }
        /// <p>The description of the shared custom framework.</p>
        pub fn framework_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_description = Some(input.into());
            self
        }
        /// <p>The description of the shared custom framework.</p>
        pub fn set_framework_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_description = input;
            self
        }
        /// <p> The status of the share request. </p>
        pub fn status(mut self, input: crate::model::ShareRequestStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the share request. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ShareRequestStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The Amazon Web Services account of the sender. </p>
        pub fn source_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_account = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account of the sender. </p>
        pub fn set_source_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_account = input;
            self
        }
        /// <p> The Amazon Web Services account of the recipient. </p>
        pub fn destination_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_account = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account of the recipient. </p>
        pub fn set_destination_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_account = input;
            self
        }
        /// <p> The Amazon Web Services Region of the recipient. </p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_region = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services Region of the recipient. </p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_region = input;
            self
        }
        /// <p> The time when the share request expires. </p>
        pub fn expiration_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p> The time when the share request expires. </p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p> The time when the share request was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> The time when the share request was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> Specifies when the share request was last updated. </p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p> Specifies when the share request was last updated. </p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p> An optional comment from the sender about the share request. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p> An optional comment from the sender about the share request. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p>The number of standard controls that are part of the shared custom framework. </p>
        pub fn standard_controls_count(mut self, input: i32) -> Self {
            self.standard_controls_count = Some(input);
            self
        }
        /// <p>The number of standard controls that are part of the shared custom framework. </p>
        pub fn set_standard_controls_count(mut self, input: std::option::Option<i32>) -> Self {
            self.standard_controls_count = input;
            self
        }
        /// <p>The number of custom controls that are part of the shared custom framework.</p>
        pub fn custom_controls_count(mut self, input: i32) -> Self {
            self.custom_controls_count = Some(input);
            self
        }
        /// <p>The number of custom controls that are part of the shared custom framework.</p>
        pub fn set_custom_controls_count(mut self, input: std::option::Option<i32>) -> Self {
            self.custom_controls_count = input;
            self
        }
        /// <p>The compliance type that the shared custom framework supports, such as CIS or HIPAA.</p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p>The compliance type that the shared custom framework supports, such as CIS or HIPAA.</p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentFrameworkShareRequest`](crate::model::AssessmentFrameworkShareRequest)
        pub fn build(self) -> crate::model::AssessmentFrameworkShareRequest {
            crate::model::AssessmentFrameworkShareRequest {
                id: self.id,
                framework_id: self.framework_id,
                framework_name: self.framework_name,
                framework_description: self.framework_description,
                status: self.status,
                source_account: self.source_account,
                destination_account: self.destination_account,
                destination_region: self.destination_region,
                expiration_time: self.expiration_time,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
                comment: self.comment,
                standard_controls_count: self.standard_controls_count,
                custom_controls_count: self.custom_controls_count,
                compliance_type: self.compliance_type,
            }
        }
    }
}
impl AssessmentFrameworkShareRequest {
    /// Creates a new builder-style object to manufacture [`AssessmentFrameworkShareRequest`](crate::model::AssessmentFrameworkShareRequest)
    pub fn builder() -> crate::model::assessment_framework_share_request::Builder {
        crate::model::assessment_framework_share_request::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareRequestStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Declined,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Expiring,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Replicating,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareRequestStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ShareRequestStatus::Active,
            "DECLINED" => ShareRequestStatus::Declined,
            "EXPIRED" => ShareRequestStatus::Expired,
            "EXPIRING" => ShareRequestStatus::Expiring,
            "FAILED" => ShareRequestStatus::Failed,
            "REPLICATING" => ShareRequestStatus::Replicating,
            "REVOKED" => ShareRequestStatus::Revoked,
            "SHARED" => ShareRequestStatus::Shared,
            other => ShareRequestStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareRequestStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareRequestStatus::from(s))
    }
}
impl ShareRequestStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareRequestStatus::Active => "ACTIVE",
            ShareRequestStatus::Declined => "DECLINED",
            ShareRequestStatus::Expired => "EXPIRED",
            ShareRequestStatus::Expiring => "EXPIRING",
            ShareRequestStatus::Failed => "FAILED",
            ShareRequestStatus::Replicating => "REPLICATING",
            ShareRequestStatus::Revoked => "REVOKED",
            ShareRequestStatus::Shared => "SHARED",
            ShareRequestStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DECLINED",
            "EXPIRED",
            "EXPIRING",
            "FAILED",
            "REPLICATING",
            "REVOKED",
            "SHARED",
        ]
    }
}
impl AsRef<str> for ShareRequestStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareRequestAction {
    #[allow(missing_docs)] // documentation missing in model
    Accept,
    #[allow(missing_docs)] // documentation missing in model
    Decline,
    #[allow(missing_docs)] // documentation missing in model
    Revoke,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareRequestAction {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPT" => ShareRequestAction::Accept,
            "DECLINE" => ShareRequestAction::Decline,
            "REVOKE" => ShareRequestAction::Revoke,
            other => ShareRequestAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareRequestAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareRequestAction::from(s))
    }
}
impl ShareRequestAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareRequestAction::Accept => "ACCEPT",
            ShareRequestAction::Decline => "DECLINE",
            ShareRequestAction::Revoke => "REVOKE",
            ShareRequestAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPT", "DECLINE", "REVOKE"]
    }
}
impl AsRef<str> for ShareRequestAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ShareRequestType {
    #[allow(missing_docs)] // documentation missing in model
    Received,
    #[allow(missing_docs)] // documentation missing in model
    Sent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ShareRequestType {
    fn from(s: &str) -> Self {
        match s {
            "RECEIVED" => ShareRequestType::Received,
            "SENT" => ShareRequestType::Sent,
            other => ShareRequestType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ShareRequestType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ShareRequestType::from(s))
    }
}
impl ShareRequestType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ShareRequestType::Received => "RECEIVED",
            ShareRequestType::Sent => "SENT",
            ShareRequestType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RECEIVED", "SENT"]
    }
}
impl AsRef<str> for ShareRequestType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The file that's used to structure and automate Audit Manager assessments for a
/// given compliance standard. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Framework {
    /// <p> The Amazon Resource Name (ARN) of the framework. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the framework. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the framework. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The framework type, such as a custom framework or a standard framework. </p>
    pub r#type: std::option::Option<crate::model::FrameworkType>,
    /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
    /// </p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p> The description of the framework. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The logo that's associated with the framework. </p>
    pub logo: std::option::Option<std::string::String>,
    /// <p> The sources that Audit Manager collects evidence from for the control. </p>
    pub control_sources: std::option::Option<std::string::String>,
    /// <p> The control sets that are associated with the framework. </p>
    pub control_sets: std::option::Option<std::vec::Vec<crate::model::ControlSet>>,
    /// <p> Specifies when the framework was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies when the framework was most recently updated. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The IAM user or role that created the framework. </p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p> The IAM user or role that most recently updated the framework. </p>
    pub last_updated_by: std::option::Option<std::string::String>,
    /// <p> The tags that are associated with the framework. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Framework {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Framework");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("description", &self.description);
        formatter.field("logo", &self.logo);
        formatter.field("control_sources", &self.control_sources);
        formatter.field("control_sets", &self.control_sets);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("created_by", &self.created_by);
        formatter.field("last_updated_by", &self.last_updated_by);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Framework`](crate::model::Framework)
pub mod framework {
    /// A builder for [`Framework`](crate::model::Framework)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FrameworkType>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) logo: std::option::Option<std::string::String>,
        pub(crate) control_sources: std::option::Option<std::string::String>,
        pub(crate) control_sets: std::option::Option<std::vec::Vec<crate::model::ControlSet>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) last_updated_by: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the framework. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the framework. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The unique identifier for the framework. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the framework. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the framework. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the framework. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The framework type, such as a custom framework or a standard framework. </p>
        pub fn r#type(mut self, input: crate::model::FrameworkType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The framework type, such as a custom framework or a standard framework. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FrameworkType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p> The description of the framework. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the framework. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The logo that's associated with the framework. </p>
        pub fn logo(mut self, input: impl Into<std::string::String>) -> Self {
            self.logo = Some(input.into());
            self
        }
        /// <p> The logo that's associated with the framework. </p>
        pub fn set_logo(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logo = input;
            self
        }
        /// <p> The sources that Audit Manager collects evidence from for the control. </p>
        pub fn control_sources(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_sources = Some(input.into());
            self
        }
        /// <p> The sources that Audit Manager collects evidence from for the control. </p>
        pub fn set_control_sources(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_sources = input;
            self
        }
        /// Appends an item to `control_sets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p> The control sets that are associated with the framework. </p>
        pub fn control_sets(mut self, input: impl Into<crate::model::ControlSet>) -> Self {
            let mut v = self.control_sets.unwrap_or_default();
            v.push(input.into());
            self.control_sets = Some(v);
            self
        }
        /// <p> The control sets that are associated with the framework. </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlSet>>,
        ) -> Self {
            self.control_sets = input;
            self
        }
        /// <p> Specifies when the framework was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> Specifies when the framework was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> Specifies when the framework was most recently updated. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies when the framework was most recently updated. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p> The IAM user or role that created the framework. </p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p> The IAM user or role that created the framework. </p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p> The IAM user or role that most recently updated the framework. </p>
        pub fn last_updated_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_by = Some(input.into());
            self
        }
        /// <p> The IAM user or role that most recently updated the framework. </p>
        pub fn set_last_updated_by(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_by = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the framework. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags that are associated with the framework. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Framework`](crate::model::Framework)
        pub fn build(self) -> crate::model::Framework {
            crate::model::Framework {
                arn: self.arn,
                id: self.id,
                name: self.name,
                r#type: self.r#type,
                compliance_type: self.compliance_type,
                description: self.description,
                logo: self.logo,
                control_sources: self.control_sources,
                control_sets: self.control_sets,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                created_by: self.created_by,
                last_updated_by: self.last_updated_by,
                tags: self.tags,
            }
        }
    }
}
impl Framework {
    /// Creates a new builder-style object to manufacture [`Framework`](crate::model::Framework)
    pub fn builder() -> crate::model::framework::Builder {
        crate::model::framework::Builder::default()
    }
}

/// <p> A set of controls in Audit Manager. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ControlSet {
    /// <p> The identifier of the control set in the assessment. This is the control set name in a
    /// plain string format. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the control set. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The list of controls within the control set. </p>
    pub controls: std::option::Option<std::vec::Vec<crate::model::Control>>,
}
impl std::fmt::Debug for ControlSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ControlSet");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("controls", &self.controls);
        formatter.finish()
    }
}
/// See [`ControlSet`](crate::model::ControlSet)
pub mod control_set {
    /// A builder for [`ControlSet`](crate::model::ControlSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) controls: std::option::Option<std::vec::Vec<crate::model::Control>>,
    }
    impl Builder {
        /// <p> The identifier of the control set in the assessment. This is the control set name in a
        /// plain string format. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The identifier of the control set in the assessment. This is the control set name in a
        /// plain string format. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the control set. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the control set. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `controls`.
        ///
        /// To override the contents of this collection use [`set_controls`](Self::set_controls).
        ///
        /// <p> The list of controls within the control set. </p>
        pub fn controls(mut self, input: impl Into<crate::model::Control>) -> Self {
            let mut v = self.controls.unwrap_or_default();
            v.push(input.into());
            self.controls = Some(v);
            self
        }
        /// <p> The list of controls within the control set. </p>
        pub fn set_controls(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Control>>,
        ) -> Self {
            self.controls = input;
            self
        }
        /// Consumes the builder and constructs a [`ControlSet`](crate::model::ControlSet)
        pub fn build(self) -> crate::model::ControlSet {
            crate::model::ControlSet {
                id: self.id,
                name: self.name,
                controls: self.controls,
            }
        }
    }
}
impl ControlSet {
    /// Creates a new builder-style object to manufacture [`ControlSet`](crate::model::ControlSet)
    pub fn builder() -> crate::model::control_set::Builder {
        crate::model::control_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FrameworkType {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FrameworkType {
    fn from(s: &str) -> Self {
        match s {
            "Custom" => FrameworkType::Custom,
            "Standard" => FrameworkType::Standard,
            other => FrameworkType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FrameworkType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FrameworkType::from(s))
    }
}
impl FrameworkType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FrameworkType::Custom => "Custom",
            FrameworkType::Standard => "Standard",
            FrameworkType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Custom", "Standard"]
    }
}
impl AsRef<str> for FrameworkType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A <code>controlSet</code> entity that represents a collection of controls in Audit Manager. This doesn't contain the control set ID. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentFrameworkControlSet {
    /// <p> The unique identifier for the control set. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the control set. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The list of controls that are contained within the control set. </p>
    pub controls:
        std::option::Option<std::vec::Vec<crate::model::CreateAssessmentFrameworkControl>>,
}
impl std::fmt::Debug for UpdateAssessmentFrameworkControlSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentFrameworkControlSet");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("controls", &self.controls);
        formatter.finish()
    }
}
/// See [`UpdateAssessmentFrameworkControlSet`](crate::model::UpdateAssessmentFrameworkControlSet)
pub mod update_assessment_framework_control_set {
    /// A builder for [`UpdateAssessmentFrameworkControlSet`](crate::model::UpdateAssessmentFrameworkControlSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) controls:
            std::option::Option<std::vec::Vec<crate::model::CreateAssessmentFrameworkControl>>,
    }
    impl Builder {
        /// <p> The unique identifier for the control set. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the control set. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the control set. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `controls`.
        ///
        /// To override the contents of this collection use [`set_controls`](Self::set_controls).
        ///
        /// <p> The list of controls that are contained within the control set. </p>
        pub fn controls(
            mut self,
            input: impl Into<crate::model::CreateAssessmentFrameworkControl>,
        ) -> Self {
            let mut v = self.controls.unwrap_or_default();
            v.push(input.into());
            self.controls = Some(v);
            self
        }
        /// <p> The list of controls that are contained within the control set. </p>
        pub fn set_controls(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssessmentFrameworkControl>,
            >,
        ) -> Self {
            self.controls = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentFrameworkControlSet`](crate::model::UpdateAssessmentFrameworkControlSet)
        pub fn build(self) -> crate::model::UpdateAssessmentFrameworkControlSet {
            crate::model::UpdateAssessmentFrameworkControlSet {
                id: self.id,
                name: self.name,
                controls: self.controls,
            }
        }
    }
}
impl UpdateAssessmentFrameworkControlSet {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentFrameworkControlSet`](crate::model::UpdateAssessmentFrameworkControlSet)
    pub fn builder() -> crate::model::update_assessment_framework_control_set::Builder {
        crate::model::update_assessment_framework_control_set::Builder::default()
    }
}

/// <p> The control entity attributes that uniquely identify an existing control to be added to
/// a framework in Audit Manager. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentFrameworkControl {
    /// <p> The unique identifier of the control. </p>
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAssessmentFrameworkControl {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentFrameworkControl");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`CreateAssessmentFrameworkControl`](crate::model::CreateAssessmentFrameworkControl)
pub mod create_assessment_framework_control {
    /// A builder for [`CreateAssessmentFrameworkControl`](crate::model::CreateAssessmentFrameworkControl)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier of the control. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the control. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentFrameworkControl`](crate::model::CreateAssessmentFrameworkControl)
        pub fn build(self) -> crate::model::CreateAssessmentFrameworkControl {
            crate::model::CreateAssessmentFrameworkControl { id: self.id }
        }
    }
}
impl CreateAssessmentFrameworkControl {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentFrameworkControl`](crate::model::CreateAssessmentFrameworkControl)
    pub fn builder() -> crate::model::create_assessment_framework_control::Builder {
        crate::model::create_assessment_framework_control::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    PendingActivation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AccountStatus::Active,
            "INACTIVE" => AccountStatus::Inactive,
            "PENDING_ACTIVATION" => AccountStatus::PendingActivation,
            other => AccountStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountStatus::from(s))
    }
}
impl AccountStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountStatus::Active => "ACTIVE",
            AccountStatus::Inactive => "INACTIVE",
            AccountStatus::PendingActivation => "PENDING_ACTIVATION",
            AccountStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE", "PENDING_ACTIVATION"]
    }
}
impl AsRef<str> for AccountStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The notification that informs a user of an update in Audit Manager. For
/// example, this includes the notification that's sent when a control set is delegated for
/// review. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Notification {
    /// <p> The unique identifier for the notification. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The name of the related assessment. </p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> Specifies the name of the control set that the notification is about. </p>
    pub control_set_name: std::option::Option<std::string::String>,
    /// <p> The description of the notification. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The time when the notification was sent. </p>
    pub event_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The sender of the notification. </p>
    pub source: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Notification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Notification");
        formatter.field("id", &self.id);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("control_set_name", &self.control_set_name);
        formatter.field("description", &self.description);
        formatter.field("event_time", &self.event_time);
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`Notification`](crate::model::Notification)
pub mod notification {
    /// A builder for [`Notification`](crate::model::Notification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) control_set_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) event_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) source: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for the notification. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the notification. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The name of the related assessment. </p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p> The name of the related assessment. </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> Specifies the name of the control set that the notification is about. </p>
        pub fn control_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_name = Some(input.into());
            self
        }
        /// <p> Specifies the name of the control set that the notification is about. </p>
        pub fn set_control_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_name = input;
            self
        }
        /// <p> The description of the notification. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the notification. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The time when the notification was sent. </p>
        pub fn event_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_time = Some(input);
            self
        }
        /// <p> The time when the notification was sent. </p>
        pub fn set_event_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_time = input;
            self
        }
        /// <p> The sender of the notification. </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p> The sender of the notification. </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`Notification`](crate::model::Notification)
        pub fn build(self) -> crate::model::Notification {
            crate::model::Notification {
                id: self.id,
                assessment_id: self.assessment_id,
                assessment_name: self.assessment_name,
                control_set_id: self.control_set_id,
                control_set_name: self.control_set_name,
                description: self.description,
                event_time: self.event_time,
                source: self.source,
            }
        }
    }
}
impl Notification {
    /// Creates a new builder-style object to manufacture [`Notification`](crate::model::Notification)
    pub fn builder() -> crate::model::notification::Builder {
        crate::model::notification::Builder::default()
    }
}

/// <p> The metadata that's associated with the standard control or custom control. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ControlMetadata {
    /// <p> The Amazon Resource Name (ARN) of the control. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the control. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the control. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The data source that determines where Audit Manager collects evidence from for
    /// the control. </p>
    pub control_sources: std::option::Option<std::string::String>,
    /// <p> Specifies when the control was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies when the control was most recently updated. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ControlMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ControlMetadata");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("control_sources", &self.control_sources);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`ControlMetadata`](crate::model::ControlMetadata)
pub mod control_metadata {
    /// A builder for [`ControlMetadata`](crate::model::ControlMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) control_sources: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the control. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the control. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the control. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the control. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The data source that determines where Audit Manager collects evidence from for
        /// the control. </p>
        pub fn control_sources(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_sources = Some(input.into());
            self
        }
        /// <p> The data source that determines where Audit Manager collects evidence from for
        /// the control. </p>
        pub fn set_control_sources(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_sources = input;
            self
        }
        /// <p> Specifies when the control was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> Specifies when the control was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> Specifies when the control was most recently updated. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies when the control was most recently updated. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ControlMetadata`](crate::model::ControlMetadata)
        pub fn build(self) -> crate::model::ControlMetadata {
            crate::model::ControlMetadata {
                arn: self.arn,
                id: self.id,
                name: self.name,
                control_sources: self.control_sources,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl ControlMetadata {
    /// Creates a new builder-style object to manufacture [`ControlMetadata`](crate::model::ControlMetadata)
    pub fn builder() -> crate::model::control_metadata::Builder {
        crate::model::control_metadata::Builder::default()
    }
}

/// <p> A metadata object that's associated with an assessment in Audit Manager.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentMetadataItem {
    /// <p> The name of the assessment. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the assessment. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the compliance standard that's related to the assessment, such as PCI-DSS.
    /// </p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p> The current status of the assessment. </p>
    pub status: std::option::Option<crate::model::AssessmentStatus>,
    /// <p> The roles that are associated with the assessment. </p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p> The delegations that are associated with the assessment. </p>
    pub delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
    /// <p> Specifies when the assessment was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The time of the most recent update. </p>
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AssessmentMetadataItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentMetadataItem");
        formatter.field("name", &self.name);
        formatter.field("id", &self.id);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("status", &self.status);
        formatter.field("roles", &self.roles);
        formatter.field("delegations", &self.delegations);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_updated", &self.last_updated);
        formatter.finish()
    }
}
/// See [`AssessmentMetadataItem`](crate::model::AssessmentMetadataItem)
pub mod assessment_metadata_item {
    /// A builder for [`AssessmentMetadataItem`](crate::model::AssessmentMetadataItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AssessmentStatus>,
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) delegations: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The name of the assessment. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the assessment. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the compliance standard that's related to the assessment, such as PCI-DSS.
        /// </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p> The name of the compliance standard that's related to the assessment, such as PCI-DSS.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p> The current status of the assessment. </p>
        pub fn status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current status of the assessment. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p> The roles that are associated with the assessment. </p>
        pub fn roles(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p> The roles that are associated with the assessment. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Appends an item to `delegations`.
        ///
        /// To override the contents of this collection use [`set_delegations`](Self::set_delegations).
        ///
        /// <p> The delegations that are associated with the assessment. </p>
        pub fn delegations(mut self, input: impl Into<crate::model::Delegation>) -> Self {
            let mut v = self.delegations.unwrap_or_default();
            v.push(input.into());
            self.delegations = Some(v);
            self
        }
        /// <p> The delegations that are associated with the assessment. </p>
        pub fn set_delegations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Delegation>>,
        ) -> Self {
            self.delegations = input;
            self
        }
        /// <p> Specifies when the assessment was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> Specifies when the assessment was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> The time of the most recent update. </p>
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p> The time of the most recent update. </p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentMetadataItem`](crate::model::AssessmentMetadataItem)
        pub fn build(self) -> crate::model::AssessmentMetadataItem {
            crate::model::AssessmentMetadataItem {
                name: self.name,
                id: self.id,
                compliance_type: self.compliance_type,
                status: self.status,
                roles: self.roles,
                delegations: self.delegations,
                creation_time: self.creation_time,
                last_updated: self.last_updated,
            }
        }
    }
}
impl AssessmentMetadataItem {
    /// Creates a new builder-style object to manufacture [`AssessmentMetadataItem`](crate::model::AssessmentMetadataItem)
    pub fn builder() -> crate::model::assessment_metadata_item::Builder {
        crate::model::assessment_metadata_item::Builder::default()
    }
}

/// <p> The metadata objects that are associated with the specified assessment report. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentReportMetadata {
    /// <p> The unique identifier for the assessment report. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the assessment report. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the assessment report. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the associated assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p>The name of the associated assessment. </p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p> The name of the user who created the assessment report. </p>
    pub author: std::option::Option<std::string::String>,
    /// <p> The current status of the assessment report. </p>
    pub status: std::option::Option<crate::model::AssessmentReportStatus>,
    /// <p> Specifies when the assessment report was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AssessmentReportMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentReportMetadata");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("author", &self.author);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`AssessmentReportMetadata`](crate::model::AssessmentReportMetadata)
pub mod assessment_report_metadata {
    /// A builder for [`AssessmentReportMetadata`](crate::model::AssessmentReportMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AssessmentReportStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The unique identifier for the assessment report. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the assessment report. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the assessment report. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the assessment report. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the assessment report. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The unique identifier for the associated assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the associated assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p>The name of the associated assessment. </p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p>The name of the associated assessment. </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p> The name of the user who created the assessment report. </p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p> The name of the user who created the assessment report. </p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p> The current status of the assessment report. </p>
        pub fn status(mut self, input: crate::model::AssessmentReportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current status of the assessment report. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> Specifies when the assessment report was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> Specifies when the assessment report was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentReportMetadata`](crate::model::AssessmentReportMetadata)
        pub fn build(self) -> crate::model::AssessmentReportMetadata {
            crate::model::AssessmentReportMetadata {
                id: self.id,
                name: self.name,
                description: self.description,
                assessment_id: self.assessment_id,
                assessment_name: self.assessment_name,
                author: self.author,
                status: self.status,
                creation_time: self.creation_time,
            }
        }
    }
}
impl AssessmentReportMetadata {
    /// Creates a new builder-style object to manufacture [`AssessmentReportMetadata`](crate::model::AssessmentReportMetadata)
    pub fn builder() -> crate::model::assessment_report_metadata::Builder {
        crate::model::assessment_report_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssessmentReportStatus {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssessmentReportStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETE" => AssessmentReportStatus::Complete,
            "FAILED" => AssessmentReportStatus::Failed,
            "IN_PROGRESS" => AssessmentReportStatus::InProgress,
            other => AssessmentReportStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssessmentReportStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssessmentReportStatus::from(s))
    }
}
impl AssessmentReportStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssessmentReportStatus::Complete => "COMPLETE",
            AssessmentReportStatus::Failed => "FAILED",
            AssessmentReportStatus::InProgress => "IN_PROGRESS",
            AssessmentReportStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPLETE", "FAILED", "IN_PROGRESS"]
    }
}
impl AsRef<str> for AssessmentReportStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The metadata that's associated with a standard framework or a custom framework. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentFrameworkMetadata {
    /// <p> The Amazon Resource Name (ARN) of the framework. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the framework. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The framework type, such as a standard framework or a custom framework. </p>
    pub r#type: std::option::Option<crate::model::FrameworkType>,
    /// <p> The name of the framework. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the framework. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The logo that's associated with the framework. </p>
    pub logo: std::option::Option<std::string::String>,
    /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
    /// </p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p> The number of controls that are associated with the framework. </p>
    pub controls_count: i32,
    /// <p> The number of control sets that are associated with the framework. </p>
    pub control_sets_count: i32,
    /// <p> Specifies when the framework was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies when the framework was most recently updated. </p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AssessmentFrameworkMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentFrameworkMetadata");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("logo", &self.logo);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("controls_count", &self.controls_count);
        formatter.field("control_sets_count", &self.control_sets_count);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.finish()
    }
}
/// See [`AssessmentFrameworkMetadata`](crate::model::AssessmentFrameworkMetadata)
pub mod assessment_framework_metadata {
    /// A builder for [`AssessmentFrameworkMetadata`](crate::model::AssessmentFrameworkMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FrameworkType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) logo: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) controls_count: std::option::Option<i32>,
        pub(crate) control_sets_count: std::option::Option<i32>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the framework. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the framework. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The unique identifier for the framework. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the framework. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The framework type, such as a standard framework or a custom framework. </p>
        pub fn r#type(mut self, input: crate::model::FrameworkType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The framework type, such as a standard framework or a custom framework. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FrameworkType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The name of the framework. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the framework. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the framework. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the framework. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The logo that's associated with the framework. </p>
        pub fn logo(mut self, input: impl Into<std::string::String>) -> Self {
            self.logo = Some(input.into());
            self
        }
        /// <p> The logo that's associated with the framework. </p>
        pub fn set_logo(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.logo = input;
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// <p> The number of controls that are associated with the framework. </p>
        pub fn controls_count(mut self, input: i32) -> Self {
            self.controls_count = Some(input);
            self
        }
        /// <p> The number of controls that are associated with the framework. </p>
        pub fn set_controls_count(mut self, input: std::option::Option<i32>) -> Self {
            self.controls_count = input;
            self
        }
        /// <p> The number of control sets that are associated with the framework. </p>
        pub fn control_sets_count(mut self, input: i32) -> Self {
            self.control_sets_count = Some(input);
            self
        }
        /// <p> The number of control sets that are associated with the framework. </p>
        pub fn set_control_sets_count(mut self, input: std::option::Option<i32>) -> Self {
            self.control_sets_count = input;
            self
        }
        /// <p> Specifies when the framework was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> Specifies when the framework was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> Specifies when the framework was most recently updated. </p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p> Specifies when the framework was most recently updated. </p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentFrameworkMetadata`](crate::model::AssessmentFrameworkMetadata)
        pub fn build(self) -> crate::model::AssessmentFrameworkMetadata {
            crate::model::AssessmentFrameworkMetadata {
                arn: self.arn,
                id: self.id,
                r#type: self.r#type,
                name: self.name,
                description: self.description,
                logo: self.logo,
                compliance_type: self.compliance_type,
                controls_count: self.controls_count.unwrap_or_default(),
                control_sets_count: self.control_sets_count.unwrap_or_default(),
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
            }
        }
    }
}
impl AssessmentFrameworkMetadata {
    /// Creates a new builder-style object to manufacture [`AssessmentFrameworkMetadata`](crate::model::AssessmentFrameworkMetadata)
    pub fn builder() -> crate::model::assessment_framework_metadata::Builder {
        crate::model::assessment_framework_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SettingAttribute {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    DefaultAssessmentReportsDestination,
    #[allow(missing_docs)] // documentation missing in model
    DefaultProcessOwners,
    #[allow(missing_docs)] // documentation missing in model
    IsAwsOrgEnabled,
    #[allow(missing_docs)] // documentation missing in model
    SnsTopic,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SettingAttribute {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => SettingAttribute::All,
            "DEFAULT_ASSESSMENT_REPORTS_DESTINATION" => {
                SettingAttribute::DefaultAssessmentReportsDestination
            }
            "DEFAULT_PROCESS_OWNERS" => SettingAttribute::DefaultProcessOwners,
            "IS_AWS_ORG_ENABLED" => SettingAttribute::IsAwsOrgEnabled,
            "SNS_TOPIC" => SettingAttribute::SnsTopic,
            other => SettingAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SettingAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SettingAttribute::from(s))
    }
}
impl SettingAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SettingAttribute::All => "ALL",
            SettingAttribute::DefaultAssessmentReportsDestination => {
                "DEFAULT_ASSESSMENT_REPORTS_DESTINATION"
            }
            SettingAttribute::DefaultProcessOwners => "DEFAULT_PROCESS_OWNERS",
            SettingAttribute::IsAwsOrgEnabled => "IS_AWS_ORG_ENABLED",
            SettingAttribute::SnsTopic => "SNS_TOPIC",
            SettingAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL",
            "DEFAULT_ASSESSMENT_REPORTS_DESTINATION",
            "DEFAULT_PROCESS_OWNERS",
            "IS_AWS_ORG_ENABLED",
            "SNS_TOPIC",
        ]
    }
}
impl AsRef<str> for SettingAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The metadata that's associated with the Amazon Web Service. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceMetadata {
    /// <p> The name of the Amazon Web Service. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The display name of the Amazon Web Service. </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p> The description of the Amazon Web Service. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The category that the Amazon Web Service belongs to, such as compute, storage,
    /// or database. </p>
    pub category: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceMetadata");
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("category", &self.category);
        formatter.finish()
    }
}
/// See [`ServiceMetadata`](crate::model::ServiceMetadata)
pub mod service_metadata {
    /// A builder for [`ServiceMetadata`](crate::model::ServiceMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the Amazon Web Service. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the Amazon Web Service. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The display name of the Amazon Web Service. </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p> The display name of the Amazon Web Service. </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p> The description of the Amazon Web Service. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the Amazon Web Service. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The category that the Amazon Web Service belongs to, such as compute, storage,
        /// or database. </p>
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// <p> The category that the Amazon Web Service belongs to, such as compute, storage,
        /// or database. </p>
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceMetadata`](crate::model::ServiceMetadata)
        pub fn build(self) -> crate::model::ServiceMetadata {
            crate::model::ServiceMetadata {
                name: self.name,
                display_name: self.display_name,
                description: self.description,
                category: self.category,
            }
        }
    }
}
impl ServiceMetadata {
    /// Creates a new builder-style object to manufacture [`ServiceMetadata`](crate::model::ServiceMetadata)
    pub fn builder() -> crate::model::service_metadata::Builder {
        crate::model::service_metadata::Builder::default()
    }
}

/// <p> The folder where Audit Manager stores evidence for an assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentEvidenceFolder {
    /// <p> The name of the evidence folder. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The date when the first evidence was added to the evidence folder. </p>
    pub date: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder that the evidence is stored in. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Service that the evidence was collected from. </p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p> The name of the user who created the evidence folder. </p>
    pub author: std::option::Option<std::string::String>,
    /// <p> The total amount of evidence in the evidence folder. </p>
    pub total_evidence: i32,
    /// <p> The total count of evidence that's included in the assessment report. </p>
    pub assessment_report_selection_count: i32,
    /// <p> The name of the control. </p>
    pub control_name: std::option::Option<std::string::String>,
    /// <p> The amount of evidence that's included in the evidence folder. </p>
    pub evidence_resources_included_count: i32,
    /// <p> The number of evidence that falls under the configuration data category. This
    /// evidence is collected from configuration snapshots of other Amazon Web Services services such as Amazon EC2, Amazon S3, or IAM. </p>
    pub evidence_by_type_configuration_data_count: i32,
    /// <p> The number of evidence that falls under the manual category. This evidence is imported
    /// manually. </p>
    pub evidence_by_type_manual_count: i32,
    /// <p> The number of evidence that falls under the compliance check category. This evidence is
    /// collected from Config or Security Hub. </p>
    pub evidence_by_type_compliance_check_count: i32,
    /// <p> The total number of issues that were reported directly from Security Hub,
    /// Config, or both. </p>
    pub evidence_by_type_compliance_check_issues_count: i32,
    /// <p> The number of evidence that falls under the user activity category. This evidence is
    /// collected from CloudTrail logs. </p>
    pub evidence_by_type_user_activity_count: i32,
    /// <p> The total number of Amazon Web Services resources that were assessed to generate the
    /// evidence. </p>
    pub evidence_aws_service_source_count: i32,
}
impl std::fmt::Debug for AssessmentEvidenceFolder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentEvidenceFolder");
        formatter.field("name", &self.name);
        formatter.field("date", &self.date);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("control_id", &self.control_id);
        formatter.field("id", &self.id);
        formatter.field("data_source", &self.data_source);
        formatter.field("author", &self.author);
        formatter.field("total_evidence", &self.total_evidence);
        formatter.field(
            "assessment_report_selection_count",
            &self.assessment_report_selection_count,
        );
        formatter.field("control_name", &self.control_name);
        formatter.field(
            "evidence_resources_included_count",
            &self.evidence_resources_included_count,
        );
        formatter.field(
            "evidence_by_type_configuration_data_count",
            &self.evidence_by_type_configuration_data_count,
        );
        formatter.field(
            "evidence_by_type_manual_count",
            &self.evidence_by_type_manual_count,
        );
        formatter.field(
            "evidence_by_type_compliance_check_count",
            &self.evidence_by_type_compliance_check_count,
        );
        formatter.field(
            "evidence_by_type_compliance_check_issues_count",
            &self.evidence_by_type_compliance_check_issues_count,
        );
        formatter.field(
            "evidence_by_type_user_activity_count",
            &self.evidence_by_type_user_activity_count,
        );
        formatter.field(
            "evidence_aws_service_source_count",
            &self.evidence_aws_service_source_count,
        );
        formatter.finish()
    }
}
/// See [`AssessmentEvidenceFolder`](crate::model::AssessmentEvidenceFolder)
pub mod assessment_evidence_folder {
    /// A builder for [`AssessmentEvidenceFolder`](crate::model::AssessmentEvidenceFolder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) control_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) total_evidence: std::option::Option<i32>,
        pub(crate) assessment_report_selection_count: std::option::Option<i32>,
        pub(crate) control_name: std::option::Option<std::string::String>,
        pub(crate) evidence_resources_included_count: std::option::Option<i32>,
        pub(crate) evidence_by_type_configuration_data_count: std::option::Option<i32>,
        pub(crate) evidence_by_type_manual_count: std::option::Option<i32>,
        pub(crate) evidence_by_type_compliance_check_count: std::option::Option<i32>,
        pub(crate) evidence_by_type_compliance_check_issues_count: std::option::Option<i32>,
        pub(crate) evidence_by_type_user_activity_count: std::option::Option<i32>,
        pub(crate) evidence_aws_service_source_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The name of the evidence folder. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the evidence folder. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The date when the first evidence was added to the evidence folder. </p>
        pub fn date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.date = Some(input);
            self
        }
        /// <p> The date when the first evidence was added to the evidence folder. </p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.date = input;
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The Amazon Web Service that the evidence was collected from. </p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p> The Amazon Web Service that the evidence was collected from. </p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p> The name of the user who created the evidence folder. </p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p> The name of the user who created the evidence folder. </p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p> The total amount of evidence in the evidence folder. </p>
        pub fn total_evidence(mut self, input: i32) -> Self {
            self.total_evidence = Some(input);
            self
        }
        /// <p> The total amount of evidence in the evidence folder. </p>
        pub fn set_total_evidence(mut self, input: std::option::Option<i32>) -> Self {
            self.total_evidence = input;
            self
        }
        /// <p> The total count of evidence that's included in the assessment report. </p>
        pub fn assessment_report_selection_count(mut self, input: i32) -> Self {
            self.assessment_report_selection_count = Some(input);
            self
        }
        /// <p> The total count of evidence that's included in the assessment report. </p>
        pub fn set_assessment_report_selection_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.assessment_report_selection_count = input;
            self
        }
        /// <p> The name of the control. </p>
        pub fn control_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_name = Some(input.into());
            self
        }
        /// <p> The name of the control. </p>
        pub fn set_control_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_name = input;
            self
        }
        /// <p> The amount of evidence that's included in the evidence folder. </p>
        pub fn evidence_resources_included_count(mut self, input: i32) -> Self {
            self.evidence_resources_included_count = Some(input);
            self
        }
        /// <p> The amount of evidence that's included in the evidence folder. </p>
        pub fn set_evidence_resources_included_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.evidence_resources_included_count = input;
            self
        }
        /// <p> The number of evidence that falls under the configuration data category. This
        /// evidence is collected from configuration snapshots of other Amazon Web Services services such as Amazon EC2, Amazon S3, or IAM. </p>
        pub fn evidence_by_type_configuration_data_count(mut self, input: i32) -> Self {
            self.evidence_by_type_configuration_data_count = Some(input);
            self
        }
        /// <p> The number of evidence that falls under the configuration data category. This
        /// evidence is collected from configuration snapshots of other Amazon Web Services services such as Amazon EC2, Amazon S3, or IAM. </p>
        pub fn set_evidence_by_type_configuration_data_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.evidence_by_type_configuration_data_count = input;
            self
        }
        /// <p> The number of evidence that falls under the manual category. This evidence is imported
        /// manually. </p>
        pub fn evidence_by_type_manual_count(mut self, input: i32) -> Self {
            self.evidence_by_type_manual_count = Some(input);
            self
        }
        /// <p> The number of evidence that falls under the manual category. This evidence is imported
        /// manually. </p>
        pub fn set_evidence_by_type_manual_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.evidence_by_type_manual_count = input;
            self
        }
        /// <p> The number of evidence that falls under the compliance check category. This evidence is
        /// collected from Config or Security Hub. </p>
        pub fn evidence_by_type_compliance_check_count(mut self, input: i32) -> Self {
            self.evidence_by_type_compliance_check_count = Some(input);
            self
        }
        /// <p> The number of evidence that falls under the compliance check category. This evidence is
        /// collected from Config or Security Hub. </p>
        pub fn set_evidence_by_type_compliance_check_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.evidence_by_type_compliance_check_count = input;
            self
        }
        /// <p> The total number of issues that were reported directly from Security Hub,
        /// Config, or both. </p>
        pub fn evidence_by_type_compliance_check_issues_count(mut self, input: i32) -> Self {
            self.evidence_by_type_compliance_check_issues_count = Some(input);
            self
        }
        /// <p> The total number of issues that were reported directly from Security Hub,
        /// Config, or both. </p>
        pub fn set_evidence_by_type_compliance_check_issues_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.evidence_by_type_compliance_check_issues_count = input;
            self
        }
        /// <p> The number of evidence that falls under the user activity category. This evidence is
        /// collected from CloudTrail logs. </p>
        pub fn evidence_by_type_user_activity_count(mut self, input: i32) -> Self {
            self.evidence_by_type_user_activity_count = Some(input);
            self
        }
        /// <p> The number of evidence that falls under the user activity category. This evidence is
        /// collected from CloudTrail logs. </p>
        pub fn set_evidence_by_type_user_activity_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.evidence_by_type_user_activity_count = input;
            self
        }
        /// <p> The total number of Amazon Web Services resources that were assessed to generate the
        /// evidence. </p>
        pub fn evidence_aws_service_source_count(mut self, input: i32) -> Self {
            self.evidence_aws_service_source_count = Some(input);
            self
        }
        /// <p> The total number of Amazon Web Services resources that were assessed to generate the
        /// evidence. </p>
        pub fn set_evidence_aws_service_source_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.evidence_aws_service_source_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentEvidenceFolder`](crate::model::AssessmentEvidenceFolder)
        pub fn build(self) -> crate::model::AssessmentEvidenceFolder {
            crate::model::AssessmentEvidenceFolder {
                name: self.name,
                date: self.date,
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                control_id: self.control_id,
                id: self.id,
                data_source: self.data_source,
                author: self.author,
                total_evidence: self.total_evidence.unwrap_or_default(),
                assessment_report_selection_count: self
                    .assessment_report_selection_count
                    .unwrap_or_default(),
                control_name: self.control_name,
                evidence_resources_included_count: self
                    .evidence_resources_included_count
                    .unwrap_or_default(),
                evidence_by_type_configuration_data_count: self
                    .evidence_by_type_configuration_data_count
                    .unwrap_or_default(),
                evidence_by_type_manual_count: self
                    .evidence_by_type_manual_count
                    .unwrap_or_default(),
                evidence_by_type_compliance_check_count: self
                    .evidence_by_type_compliance_check_count
                    .unwrap_or_default(),
                evidence_by_type_compliance_check_issues_count: self
                    .evidence_by_type_compliance_check_issues_count
                    .unwrap_or_default(),
                evidence_by_type_user_activity_count: self
                    .evidence_by_type_user_activity_count
                    .unwrap_or_default(),
                evidence_aws_service_source_count: self
                    .evidence_aws_service_source_count
                    .unwrap_or_default(),
            }
        }
    }
}
impl AssessmentEvidenceFolder {
    /// Creates a new builder-style object to manufacture [`AssessmentEvidenceFolder`](crate::model::AssessmentEvidenceFolder)
    pub fn builder() -> crate::model::assessment_evidence_folder::Builder {
        crate::model::assessment_evidence_folder::Builder::default()
    }
}

/// <p> A record that contains the information needed to demonstrate compliance with the
/// requirements specified by a control. Examples of evidence include change activity triggered
/// by a user, or a system configuration snapshot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Evidence {
    /// <p> The data source where the evidence was collected from. </p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p> The identifier for the Amazon Web Services account. </p>
    pub evidence_aws_account_id: std::option::Option<std::string::String>,
    /// <p> The timestamp that represents when the evidence was collected. </p>
    pub time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The Amazon Web Service that the evidence is collected from. </p>
    pub event_source: std::option::Option<std::string::String>,
    /// <p> The name of the evidence event. </p>
    pub event_name: std::option::Option<std::string::String>,
    /// <p> The type of automated evidence. </p>
    pub evidence_by_type: std::option::Option<std::string::String>,
    /// <p> The list of resources that are assessed to generate the evidence. </p>
    pub resources_included: std::option::Option<std::vec::Vec<crate::model::Resource>>,
    /// <p> The names and values that are used by the evidence event. This includes an attribute
    /// name (such as <code>allowUsersToChangePassword</code>) and value (such as <code>true</code>
    /// or <code>false</code>). </p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The unique identifier for the IAM user or role that's associated with
    /// the evidence. </p>
    pub iam_id: std::option::Option<std::string::String>,
    /// <p> The evaluation status for evidence that falls under the compliance check category. For
    /// evidence collected from Security Hub, a <i>Pass</i> or
    /// <i>Fail</i> result is shown. For evidence collected from Config, a <i>Compliant</i> or <i>Noncompliant</i>
    /// result is shown. </p>
    pub compliance_check: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services account that the evidence is collected from, and its
    /// organization path. </p>
    pub aws_organization: std::option::Option<std::string::String>,
    /// <p> The identifier for the Amazon Web Services account. </p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder that the evidence is stored in. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the evidence. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> Specifies whether the evidence is included in the assessment report. </p>
    pub assessment_report_selection: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Evidence {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Evidence");
        formatter.field("data_source", &self.data_source);
        formatter.field("evidence_aws_account_id", &self.evidence_aws_account_id);
        formatter.field("time", &self.time);
        formatter.field("event_source", &self.event_source);
        formatter.field("event_name", &self.event_name);
        formatter.field("evidence_by_type", &self.evidence_by_type);
        formatter.field("resources_included", &self.resources_included);
        formatter.field("attributes", &self.attributes);
        formatter.field("iam_id", &self.iam_id);
        formatter.field("compliance_check", &self.compliance_check);
        formatter.field("aws_organization", &self.aws_organization);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.field("id", &self.id);
        formatter.field(
            "assessment_report_selection",
            &self.assessment_report_selection,
        );
        formatter.finish()
    }
}
/// See [`Evidence`](crate::model::Evidence)
pub mod evidence {
    /// A builder for [`Evidence`](crate::model::Evidence)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) evidence_aws_account_id: std::option::Option<std::string::String>,
        pub(crate) time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_source: std::option::Option<std::string::String>,
        pub(crate) event_name: std::option::Option<std::string::String>,
        pub(crate) evidence_by_type: std::option::Option<std::string::String>,
        pub(crate) resources_included: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) iam_id: std::option::Option<std::string::String>,
        pub(crate) compliance_check: std::option::Option<std::string::String>,
        pub(crate) aws_organization: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) assessment_report_selection: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The data source where the evidence was collected from. </p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p> The data source where the evidence was collected from. </p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p> The identifier for the Amazon Web Services account. </p>
        pub fn evidence_aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_aws_account_id = Some(input.into());
            self
        }
        /// <p> The identifier for the Amazon Web Services account. </p>
        pub fn set_evidence_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_aws_account_id = input;
            self
        }
        /// <p> The timestamp that represents when the evidence was collected. </p>
        pub fn time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.time = Some(input);
            self
        }
        /// <p> The timestamp that represents when the evidence was collected. </p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.time = input;
            self
        }
        /// <p> The Amazon Web Service that the evidence is collected from. </p>
        pub fn event_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source = Some(input.into());
            self
        }
        /// <p> The Amazon Web Service that the evidence is collected from. </p>
        pub fn set_event_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_source = input;
            self
        }
        /// <p> The name of the evidence event. </p>
        pub fn event_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_name = Some(input.into());
            self
        }
        /// <p> The name of the evidence event. </p>
        pub fn set_event_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_name = input;
            self
        }
        /// <p> The type of automated evidence. </p>
        pub fn evidence_by_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_by_type = Some(input.into());
            self
        }
        /// <p> The type of automated evidence. </p>
        pub fn set_evidence_by_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_by_type = input;
            self
        }
        /// Appends an item to `resources_included`.
        ///
        /// To override the contents of this collection use [`set_resources_included`](Self::set_resources_included).
        ///
        /// <p> The list of resources that are assessed to generate the evidence. </p>
        pub fn resources_included(mut self, input: impl Into<crate::model::Resource>) -> Self {
            let mut v = self.resources_included.unwrap_or_default();
            v.push(input.into());
            self.resources_included = Some(v);
            self
        }
        /// <p> The list of resources that are assessed to generate the evidence. </p>
        pub fn set_resources_included(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Resource>>,
        ) -> Self {
            self.resources_included = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p> The names and values that are used by the evidence event. This includes an attribute
        /// name (such as <code>allowUsersToChangePassword</code>) and value (such as <code>true</code>
        /// or <code>false</code>). </p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p> The names and values that are used by the evidence event. This includes an attribute
        /// name (such as <code>allowUsersToChangePassword</code>) and value (such as <code>true</code>
        /// or <code>false</code>). </p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p> The unique identifier for the IAM user or role that's associated with
        /// the evidence. </p>
        pub fn iam_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the IAM user or role that's associated with
        /// the evidence. </p>
        pub fn set_iam_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_id = input;
            self
        }
        /// <p> The evaluation status for evidence that falls under the compliance check category. For
        /// evidence collected from Security Hub, a <i>Pass</i> or
        /// <i>Fail</i> result is shown. For evidence collected from Config, a <i>Compliant</i> or <i>Noncompliant</i>
        /// result is shown. </p>
        pub fn compliance_check(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_check = Some(input.into());
            self
        }
        /// <p> The evaluation status for evidence that falls under the compliance check category. For
        /// evidence collected from Security Hub, a <i>Pass</i> or
        /// <i>Fail</i> result is shown. For evidence collected from Config, a <i>Compliant</i> or <i>Noncompliant</i>
        /// result is shown. </p>
        pub fn set_compliance_check(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_check = input;
            self
        }
        /// <p> The Amazon Web Services account that the evidence is collected from, and its
        /// organization path. </p>
        pub fn aws_organization(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_organization = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account that the evidence is collected from, and its
        /// organization path. </p>
        pub fn set_aws_organization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_organization = input;
            self
        }
        /// <p> The identifier for the Amazon Web Services account. </p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p> The identifier for the Amazon Web Services account. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// <p> The identifier for the evidence. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The identifier for the evidence. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> Specifies whether the evidence is included in the assessment report. </p>
        pub fn assessment_report_selection(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.assessment_report_selection = Some(input.into());
            self
        }
        /// <p> Specifies whether the evidence is included in the assessment report. </p>
        pub fn set_assessment_report_selection(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_report_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`Evidence`](crate::model::Evidence)
        pub fn build(self) -> crate::model::Evidence {
            crate::model::Evidence {
                data_source: self.data_source,
                evidence_aws_account_id: self.evidence_aws_account_id,
                time: self.time,
                event_source: self.event_source,
                event_name: self.event_name,
                evidence_by_type: self.evidence_by_type,
                resources_included: self.resources_included,
                attributes: self.attributes,
                iam_id: self.iam_id,
                compliance_check: self.compliance_check,
                aws_organization: self.aws_organization,
                aws_account_id: self.aws_account_id,
                evidence_folder_id: self.evidence_folder_id,
                id: self.id,
                assessment_report_selection: self.assessment_report_selection,
            }
        }
    }
}
impl Evidence {
    /// Creates a new builder-style object to manufacture [`Evidence`](crate::model::Evidence)
    pub fn builder() -> crate::model::evidence::Builder {
        crate::model::evidence::Builder::default()
    }
}

/// <p> A system asset that's evaluated in an Audit Manager assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resource {
    /// <p> The Amazon Resource Name (ARN) for the resource. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The value of the resource. </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resource");
        formatter.field("arn", &self.arn);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Resource`](crate::model::Resource)
pub mod resource {
    /// A builder for [`Resource`](crate::model::Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) for the resource. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the resource. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The value of the resource. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p> The value of the resource. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Resource`](crate::model::Resource)
        pub fn build(self) -> crate::model::Resource {
            crate::model::Resource {
                arn: self.arn,
                value: self.value,
            }
        }
    }
}
impl Resource {
    /// Creates a new builder-style object to manufacture [`Resource`](crate::model::Resource)
    pub fn builder() -> crate::model::resource::Builder {
        crate::model::resource::Builder::default()
    }
}

/// <p> The metadata that's associated with the delegation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DelegationMetadata {
    /// <p> The unique identifier for the delegation. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name of the associated assessment. </p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The current status of the delegation. </p>
    pub status: std::option::Option<crate::model::DelegationStatus>,
    /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p> Specifies when the delegation was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> Specifies the name of the control set that was delegated for review. </p>
    pub control_set_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DelegationMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DelegationMetadata");
        formatter.field("id", &self.id);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("status", &self.status);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("control_set_name", &self.control_set_name);
        formatter.finish()
    }
}
/// See [`DelegationMetadata`](crate::model::DelegationMetadata)
pub mod delegation_metadata {
    /// A builder for [`DelegationMetadata`](crate::model::DelegationMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DelegationStatus>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) control_set_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for the delegation. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the delegation. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name of the associated assessment. </p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p> The name of the associated assessment. </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The current status of the delegation. </p>
        pub fn status(mut self, input: crate::model::DelegationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current status of the delegation. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DelegationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p> Specifies when the delegation was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> Specifies when the delegation was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p> Specifies the name of the control set that was delegated for review. </p>
        pub fn control_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_name = Some(input.into());
            self
        }
        /// <p> Specifies the name of the control set that was delegated for review. </p>
        pub fn set_control_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DelegationMetadata`](crate::model::DelegationMetadata)
        pub fn build(self) -> crate::model::DelegationMetadata {
            crate::model::DelegationMetadata {
                id: self.id,
                assessment_name: self.assessment_name,
                assessment_id: self.assessment_id,
                status: self.status,
                role_arn: self.role_arn,
                creation_time: self.creation_time,
                control_set_name: self.control_set_name,
            }
        }
    }
}
impl DelegationMetadata {
    /// Creates a new builder-style object to manufacture [`DelegationMetadata`](crate::model::DelegationMetadata)
    pub fn builder() -> crate::model::delegation_metadata::Builder {
        crate::model::delegation_metadata::Builder::default()
    }
}

/// <p> The record of a change within Audit Manager. For example, this could be the
/// status change of an assessment or the delegation of a control set. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeLog {
    /// <p> The object that was changed, such as an assessment, control, or control set. </p>
    pub object_type: std::option::Option<crate::model::ObjectTypeEnum>,
    /// <p> The name of the object that changed. This could be the name of an assessment, control,
    /// or control set.</p>
    pub object_name: std::option::Option<std::string::String>,
    /// <p> The action that was performed. </p>
    pub action: std::option::Option<crate::model::ActionEnum>,
    /// <p> The time when the action was performed and the changelog record was created. </p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The IAM user or role that performed the action. </p>
    pub created_by: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ChangeLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeLog");
        formatter.field("object_type", &self.object_type);
        formatter.field("object_name", &self.object_name);
        formatter.field("action", &self.action);
        formatter.field("created_at", &self.created_at);
        formatter.field("created_by", &self.created_by);
        formatter.finish()
    }
}
/// See [`ChangeLog`](crate::model::ChangeLog)
pub mod change_log {
    /// A builder for [`ChangeLog`](crate::model::ChangeLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_type: std::option::Option<crate::model::ObjectTypeEnum>,
        pub(crate) object_name: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::ActionEnum>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) created_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The object that was changed, such as an assessment, control, or control set. </p>
        pub fn object_type(mut self, input: crate::model::ObjectTypeEnum) -> Self {
            self.object_type = Some(input);
            self
        }
        /// <p> The object that was changed, such as an assessment, control, or control set. </p>
        pub fn set_object_type(
            mut self,
            input: std::option::Option<crate::model::ObjectTypeEnum>,
        ) -> Self {
            self.object_type = input;
            self
        }
        /// <p> The name of the object that changed. This could be the name of an assessment, control,
        /// or control set.</p>
        pub fn object_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_name = Some(input.into());
            self
        }
        /// <p> The name of the object that changed. This could be the name of an assessment, control,
        /// or control set.</p>
        pub fn set_object_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object_name = input;
            self
        }
        /// <p> The action that was performed. </p>
        pub fn action(mut self, input: crate::model::ActionEnum) -> Self {
            self.action = Some(input);
            self
        }
        /// <p> The action that was performed. </p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::ActionEnum>) -> Self {
            self.action = input;
            self
        }
        /// <p> The time when the action was performed and the changelog record was created. </p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p> The time when the action was performed and the changelog record was created. </p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p> The IAM user or role that performed the action. </p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p> The IAM user or role that performed the action. </p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeLog`](crate::model::ChangeLog)
        pub fn build(self) -> crate::model::ChangeLog {
            crate::model::ChangeLog {
                object_type: self.object_type,
                object_name: self.object_name,
                action: self.action,
                created_at: self.created_at,
                created_by: self.created_by,
            }
        }
    }
}
impl ChangeLog {
    /// Creates a new builder-style object to manufacture [`ChangeLog`](crate::model::ChangeLog)
    pub fn builder() -> crate::model::change_log::Builder {
        crate::model::change_log::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionEnum {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Create,
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    ImportEvidence,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Reviewed,
    #[allow(missing_docs)] // documentation missing in model
    UnderReview,
    #[allow(missing_docs)] // documentation missing in model
    UpdateMetadata,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionEnum {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ActionEnum::Active,
            "CREATE" => ActionEnum::Create,
            "DELETE" => ActionEnum::Delete,
            "IMPORT_EVIDENCE" => ActionEnum::ImportEvidence,
            "INACTIVE" => ActionEnum::Inactive,
            "REVIEWED" => ActionEnum::Reviewed,
            "UNDER_REVIEW" => ActionEnum::UnderReview,
            "UPDATE_METADATA" => ActionEnum::UpdateMetadata,
            other => ActionEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionEnum::from(s))
    }
}
impl ActionEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionEnum::Active => "ACTIVE",
            ActionEnum::Create => "CREATE",
            ActionEnum::Delete => "DELETE",
            ActionEnum::ImportEvidence => "IMPORT_EVIDENCE",
            ActionEnum::Inactive => "INACTIVE",
            ActionEnum::Reviewed => "REVIEWED",
            ActionEnum::UnderReview => "UNDER_REVIEW",
            ActionEnum::UpdateMetadata => "UPDATE_METADATA",
            ActionEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "CREATE",
            "DELETE",
            "IMPORT_EVIDENCE",
            "INACTIVE",
            "REVIEWED",
            "UNDER_REVIEW",
            "UPDATE_METADATA",
        ]
    }
}
impl AsRef<str> for ActionEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    Assessment,
    #[allow(missing_docs)] // documentation missing in model
    AssessmentReport,
    #[allow(missing_docs)] // documentation missing in model
    Control,
    #[allow(missing_docs)] // documentation missing in model
    ControlSet,
    #[allow(missing_docs)] // documentation missing in model
    Delegation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "ASSESSMENT" => ObjectTypeEnum::Assessment,
            "ASSESSMENT_REPORT" => ObjectTypeEnum::AssessmentReport,
            "CONTROL" => ObjectTypeEnum::Control,
            "CONTROL_SET" => ObjectTypeEnum::ControlSet,
            "DELEGATION" => ObjectTypeEnum::Delegation,
            other => ObjectTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectTypeEnum::from(s))
    }
}
impl ObjectTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectTypeEnum::Assessment => "ASSESSMENT",
            ObjectTypeEnum::AssessmentReport => "ASSESSMENT_REPORT",
            ObjectTypeEnum::Control => "CONTROL",
            ObjectTypeEnum::ControlSet => "CONTROL_SET",
            ObjectTypeEnum::Delegation => "DELEGATION",
            ObjectTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSESSMENT",
            "ASSESSMENT_REPORT",
            "CONTROL",
            "CONTROL_SET",
            "DELEGATION",
        ]
    }
}
impl AsRef<str> for ObjectTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Short for uniform resource locator. A URL is used as a unique identifier to locate a
/// resource on the internet. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Url {
    /// <p> The name or word that's used as a hyperlink to the URL. </p>
    pub hyperlink_name: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the internet resource. </p>
    pub link: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Url {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Url");
        formatter.field("hyperlink_name", &self.hyperlink_name);
        formatter.field("link", &self.link);
        formatter.finish()
    }
}
/// See [`Url`](crate::model::Url)
pub mod url {
    /// A builder for [`Url`](crate::model::Url)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hyperlink_name: std::option::Option<std::string::String>,
        pub(crate) link: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name or word that's used as a hyperlink to the URL. </p>
        pub fn hyperlink_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.hyperlink_name = Some(input.into());
            self
        }
        /// <p> The name or word that's used as a hyperlink to the URL. </p>
        pub fn set_hyperlink_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hyperlink_name = input;
            self
        }
        /// <p> The unique identifier for the internet resource. </p>
        pub fn link(mut self, input: impl Into<std::string::String>) -> Self {
            self.link = Some(input.into());
            self
        }
        /// <p> The unique identifier for the internet resource. </p>
        pub fn set_link(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.link = input;
            self
        }
        /// Consumes the builder and constructs a [`Url`](crate::model::Url)
        pub fn build(self) -> crate::model::Url {
            crate::model::Url {
                hyperlink_name: self.hyperlink_name,
                link: self.link,
            }
        }
    }
}
impl Url {
    /// Creates a new builder-style object to manufacture [`Url`](crate::model::Url)
    pub fn builder() -> crate::model::url::Builder {
        crate::model::url::Builder::default()
    }
}

/// <p> The control mapping fields that represent the source for evidence collection, along
/// with related parameters and metadata. This doesn't contain <code>mappingID</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateControlMappingSource {
    /// <p> The name of the control mapping data source. </p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p> The description of the data source that determines where Audit Manager collects
    /// evidence from for the control. </p>
    pub source_description: std::option::Option<std::string::String>,
    /// <p> The setup option for the data source, which reflects if the evidence collection is
    /// automated or manual. </p>
    pub source_set_up_option: std::option::Option<crate::model::SourceSetUpOption>,
    /// <p> Specifies one of the five types of data sources for evidence collection. </p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p> The keyword to search for in CloudTrail logs, Config rules,
    /// Security Hub checks, and Amazon Web Services API names. </p>
    pub source_keyword: std::option::Option<crate::model::SourceKeyword>,
    /// <p> The frequency of evidence collection for the control mapping source. </p>
    pub source_frequency: std::option::Option<crate::model::SourceFrequency>,
    /// <p> The instructions for troubleshooting the control. </p>
    pub troubleshooting_text: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateControlMappingSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateControlMappingSource");
        formatter.field("source_name", &self.source_name);
        formatter.field("source_description", &self.source_description);
        formatter.field("source_set_up_option", &self.source_set_up_option);
        formatter.field("source_type", &self.source_type);
        formatter.field("source_keyword", &self.source_keyword);
        formatter.field("source_frequency", &self.source_frequency);
        formatter.field("troubleshooting_text", &self.troubleshooting_text);
        formatter.finish()
    }
}
/// See [`CreateControlMappingSource`](crate::model::CreateControlMappingSource)
pub mod create_control_mapping_source {
    /// A builder for [`CreateControlMappingSource`](crate::model::CreateControlMappingSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_description: std::option::Option<std::string::String>,
        pub(crate) source_set_up_option: std::option::Option<crate::model::SourceSetUpOption>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) source_keyword: std::option::Option<crate::model::SourceKeyword>,
        pub(crate) source_frequency: std::option::Option<crate::model::SourceFrequency>,
        pub(crate) troubleshooting_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the control mapping data source. </p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p> The name of the control mapping data source. </p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p> The description of the data source that determines where Audit Manager collects
        /// evidence from for the control. </p>
        pub fn source_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_description = Some(input.into());
            self
        }
        /// <p> The description of the data source that determines where Audit Manager collects
        /// evidence from for the control. </p>
        pub fn set_source_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_description = input;
            self
        }
        /// <p> The setup option for the data source, which reflects if the evidence collection is
        /// automated or manual. </p>
        pub fn source_set_up_option(mut self, input: crate::model::SourceSetUpOption) -> Self {
            self.source_set_up_option = Some(input);
            self
        }
        /// <p> The setup option for the data source, which reflects if the evidence collection is
        /// automated or manual. </p>
        pub fn set_source_set_up_option(
            mut self,
            input: std::option::Option<crate::model::SourceSetUpOption>,
        ) -> Self {
            self.source_set_up_option = input;
            self
        }
        /// <p> Specifies one of the five types of data sources for evidence collection. </p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p> Specifies one of the five types of data sources for evidence collection. </p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p> The keyword to search for in CloudTrail logs, Config rules,
        /// Security Hub checks, and Amazon Web Services API names. </p>
        pub fn source_keyword(mut self, input: crate::model::SourceKeyword) -> Self {
            self.source_keyword = Some(input);
            self
        }
        /// <p> The keyword to search for in CloudTrail logs, Config rules,
        /// Security Hub checks, and Amazon Web Services API names. </p>
        pub fn set_source_keyword(
            mut self,
            input: std::option::Option<crate::model::SourceKeyword>,
        ) -> Self {
            self.source_keyword = input;
            self
        }
        /// <p> The frequency of evidence collection for the control mapping source. </p>
        pub fn source_frequency(mut self, input: crate::model::SourceFrequency) -> Self {
            self.source_frequency = Some(input);
            self
        }
        /// <p> The frequency of evidence collection for the control mapping source. </p>
        pub fn set_source_frequency(
            mut self,
            input: std::option::Option<crate::model::SourceFrequency>,
        ) -> Self {
            self.source_frequency = input;
            self
        }
        /// <p> The instructions for troubleshooting the control. </p>
        pub fn troubleshooting_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.troubleshooting_text = Some(input.into());
            self
        }
        /// <p> The instructions for troubleshooting the control. </p>
        pub fn set_troubleshooting_text(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.troubleshooting_text = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateControlMappingSource`](crate::model::CreateControlMappingSource)
        pub fn build(self) -> crate::model::CreateControlMappingSource {
            crate::model::CreateControlMappingSource {
                source_name: self.source_name,
                source_description: self.source_description,
                source_set_up_option: self.source_set_up_option,
                source_type: self.source_type,
                source_keyword: self.source_keyword,
                source_frequency: self.source_frequency,
                troubleshooting_text: self.troubleshooting_text,
            }
        }
    }
}
impl CreateControlMappingSource {
    /// Creates a new builder-style object to manufacture [`CreateControlMappingSource`](crate::model::CreateControlMappingSource)
    pub fn builder() -> crate::model::create_control_mapping_source::Builder {
        crate::model::create_control_mapping_source::Builder::default()
    }
}

/// <p> A finalized document that's generated from an Audit Manager assessment. These
/// reports summarize the relevant evidence that was collected for your audit, and link to the
/// relevant evidence folders. These evidence folders are named and organized according to the
/// controls that are specified in your assessment. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentReport {
    /// <p> The unique identifier for the assessment report. </p>
    pub id: std::option::Option<std::string::String>,
    /// <p> The name that's given to the assessment report. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the specified assessment report. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The identifier for the specified Amazon Web Services account. </p>
    pub aws_account_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the specified assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The name of the associated assessment. </p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p> The name of the user who created the assessment report. </p>
    pub author: std::option::Option<std::string::String>,
    /// <p> The current status of the specified assessment report. </p>
    pub status: std::option::Option<crate::model::AssessmentReportStatus>,
    /// <p> Specifies when the assessment report was created. </p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for AssessmentReport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentReport");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("aws_account_id", &self.aws_account_id);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("author", &self.author);
        formatter.field("status", &self.status);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`AssessmentReport`](crate::model::AssessmentReport)
pub mod assessment_report {
    /// A builder for [`AssessmentReport`](crate::model::AssessmentReport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) aws_account_id: std::option::Option<std::string::String>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AssessmentReportStatus>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p> The unique identifier for the assessment report. </p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p> The name that's given to the assessment report. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name that's given to the assessment report. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the specified assessment report. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the specified assessment report. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The identifier for the specified Amazon Web Services account. </p>
        pub fn aws_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_account_id = Some(input.into());
            self
        }
        /// <p> The identifier for the specified Amazon Web Services account. </p>
        pub fn set_aws_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_account_id = input;
            self
        }
        /// <p> The identifier for the specified assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the specified assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The name of the associated assessment. </p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p> The name of the associated assessment. </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p> The name of the user who created the assessment report. </p>
        pub fn author(mut self, input: impl Into<std::string::String>) -> Self {
            self.author = Some(input.into());
            self
        }
        /// <p> The name of the user who created the assessment report. </p>
        pub fn set_author(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author = input;
            self
        }
        /// <p> The current status of the specified assessment report. </p>
        pub fn status(mut self, input: crate::model::AssessmentReportStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current status of the specified assessment report. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> Specifies when the assessment report was created. </p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p> Specifies when the assessment report was created. </p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentReport`](crate::model::AssessmentReport)
        pub fn build(self) -> crate::model::AssessmentReport {
            crate::model::AssessmentReport {
                id: self.id,
                name: self.name,
                description: self.description,
                aws_account_id: self.aws_account_id,
                assessment_id: self.assessment_id,
                assessment_name: self.assessment_name,
                author: self.author,
                status: self.status,
                creation_time: self.creation_time,
            }
        }
    }
}
impl AssessmentReport {
    /// Creates a new builder-style object to manufacture [`AssessmentReport`](crate::model::AssessmentReport)
    pub fn builder() -> crate::model::assessment_report::Builder {
        crate::model::assessment_report::Builder::default()
    }
}

/// <p> A <code>controlSet</code> entity that represents a collection of controls in Audit Manager. This doesn't contain the control set ID. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentFrameworkControlSet {
    /// <p> The name of the control set. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The list of controls within the control set. This doesn't contain the control set ID.
    /// </p>
    pub controls:
        std::option::Option<std::vec::Vec<crate::model::CreateAssessmentFrameworkControl>>,
}
impl std::fmt::Debug for CreateAssessmentFrameworkControlSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentFrameworkControlSet");
        formatter.field("name", &self.name);
        formatter.field("controls", &self.controls);
        formatter.finish()
    }
}
/// See [`CreateAssessmentFrameworkControlSet`](crate::model::CreateAssessmentFrameworkControlSet)
pub mod create_assessment_framework_control_set {
    /// A builder for [`CreateAssessmentFrameworkControlSet`](crate::model::CreateAssessmentFrameworkControlSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) controls:
            std::option::Option<std::vec::Vec<crate::model::CreateAssessmentFrameworkControl>>,
    }
    impl Builder {
        /// <p> The name of the control set. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the control set. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `controls`.
        ///
        /// To override the contents of this collection use [`set_controls`](Self::set_controls).
        ///
        /// <p> The list of controls within the control set. This doesn't contain the control set ID.
        /// </p>
        pub fn controls(
            mut self,
            input: impl Into<crate::model::CreateAssessmentFrameworkControl>,
        ) -> Self {
            let mut v = self.controls.unwrap_or_default();
            v.push(input.into());
            self.controls = Some(v);
            self
        }
        /// <p> The list of controls within the control set. This doesn't contain the control set ID.
        /// </p>
        pub fn set_controls(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssessmentFrameworkControl>,
            >,
        ) -> Self {
            self.controls = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentFrameworkControlSet`](crate::model::CreateAssessmentFrameworkControlSet)
        pub fn build(self) -> crate::model::CreateAssessmentFrameworkControlSet {
            crate::model::CreateAssessmentFrameworkControlSet {
                name: self.name,
                controls: self.controls,
            }
        }
    }
}
impl CreateAssessmentFrameworkControlSet {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentFrameworkControlSet`](crate::model::CreateAssessmentFrameworkControlSet)
    pub fn builder() -> crate::model::create_assessment_framework_control_set::Builder {
        crate::model::create_assessment_framework_control_set::Builder::default()
    }
}

/// <p> An error entity for the <code>BatchImportEvidenceToAssessmentControl</code> API. This
/// is used to provide more meaningful errors than a simple string message. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchImportEvidenceToAssessmentControlError {
    /// <p> Manual evidence that can't be collected automatically by Audit Manager. </p>
    pub manual_evidence: std::option::Option<crate::model::ManualEvidence>,
    /// <p> The error code that the <code>BatchImportEvidenceToAssessmentControl</code> API
    /// returned. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p> The error message that the <code>BatchImportEvidenceToAssessmentControl</code> API
    /// returned. </p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchImportEvidenceToAssessmentControlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchImportEvidenceToAssessmentControlError");
        formatter.field("manual_evidence", &self.manual_evidence);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchImportEvidenceToAssessmentControlError`](crate::model::BatchImportEvidenceToAssessmentControlError)
pub mod batch_import_evidence_to_assessment_control_error {
    /// A builder for [`BatchImportEvidenceToAssessmentControlError`](crate::model::BatchImportEvidenceToAssessmentControlError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) manual_evidence: std::option::Option<crate::model::ManualEvidence>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> Manual evidence that can't be collected automatically by Audit Manager. </p>
        pub fn manual_evidence(mut self, input: crate::model::ManualEvidence) -> Self {
            self.manual_evidence = Some(input);
            self
        }
        /// <p> Manual evidence that can't be collected automatically by Audit Manager. </p>
        pub fn set_manual_evidence(
            mut self,
            input: std::option::Option<crate::model::ManualEvidence>,
        ) -> Self {
            self.manual_evidence = input;
            self
        }
        /// <p> The error code that the <code>BatchImportEvidenceToAssessmentControl</code> API
        /// returned. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p> The error code that the <code>BatchImportEvidenceToAssessmentControl</code> API
        /// returned. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p> The error message that the <code>BatchImportEvidenceToAssessmentControl</code> API
        /// returned. </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p> The error message that the <code>BatchImportEvidenceToAssessmentControl</code> API
        /// returned. </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchImportEvidenceToAssessmentControlError`](crate::model::BatchImportEvidenceToAssessmentControlError)
        pub fn build(self) -> crate::model::BatchImportEvidenceToAssessmentControlError {
            crate::model::BatchImportEvidenceToAssessmentControlError {
                manual_evidence: self.manual_evidence,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchImportEvidenceToAssessmentControlError {
    /// Creates a new builder-style object to manufacture [`BatchImportEvidenceToAssessmentControlError`](crate::model::BatchImportEvidenceToAssessmentControlError)
    pub fn builder() -> crate::model::batch_import_evidence_to_assessment_control_error::Builder {
        crate::model::batch_import_evidence_to_assessment_control_error::Builder::default()
    }
}

/// <p> Evidence that's uploaded to Audit Manager manually. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManualEvidence {
    /// <p> The Amazon S3 URL that points to a manual evidence object. </p>
    pub s3_resource_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ManualEvidence {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManualEvidence");
        formatter.field("s3_resource_path", &self.s3_resource_path);
        formatter.finish()
    }
}
/// See [`ManualEvidence`](crate::model::ManualEvidence)
pub mod manual_evidence {
    /// A builder for [`ManualEvidence`](crate::model::ManualEvidence)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_resource_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon S3 URL that points to a manual evidence object. </p>
        pub fn s3_resource_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_resource_path = Some(input.into());
            self
        }
        /// <p> The Amazon S3 URL that points to a manual evidence object. </p>
        pub fn set_s3_resource_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_resource_path = input;
            self
        }
        /// Consumes the builder and constructs a [`ManualEvidence`](crate::model::ManualEvidence)
        pub fn build(self) -> crate::model::ManualEvidence {
            crate::model::ManualEvidence {
                s3_resource_path: self.s3_resource_path,
            }
        }
    }
}
impl ManualEvidence {
    /// Creates a new builder-style object to manufacture [`ManualEvidence`](crate::model::ManualEvidence)
    pub fn builder() -> crate::model::manual_evidence::Builder {
        crate::model::manual_evidence::Builder::default()
    }
}

/// <p> An error entity for the <code>AssessmentReportEvidence</code> API. This is used to
/// provide more meaningful errors than a simple string message. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssessmentReportEvidenceError {
    /// <p> The identifier for the evidence. </p>
    pub evidence_id: std::option::Option<std::string::String>,
    /// <p> The error code that the <code>AssessmentReportEvidence</code> API returned. </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p> The error message that the <code>AssessmentReportEvidence</code> API returned. </p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssessmentReportEvidenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssessmentReportEvidenceError");
        formatter.field("evidence_id", &self.evidence_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`AssessmentReportEvidenceError`](crate::model::AssessmentReportEvidenceError)
pub mod assessment_report_evidence_error {
    /// A builder for [`AssessmentReportEvidenceError`](crate::model::AssessmentReportEvidenceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evidence_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the evidence. </p>
        pub fn evidence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_id = Some(input.into());
            self
        }
        /// <p> The identifier for the evidence. </p>
        pub fn set_evidence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.evidence_id = input;
            self
        }
        /// <p> The error code that the <code>AssessmentReportEvidence</code> API returned. </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p> The error code that the <code>AssessmentReportEvidence</code> API returned. </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p> The error message that the <code>AssessmentReportEvidence</code> API returned. </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p> The error message that the <code>AssessmentReportEvidence</code> API returned. </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`AssessmentReportEvidenceError`](crate::model::AssessmentReportEvidenceError)
        pub fn build(self) -> crate::model::AssessmentReportEvidenceError {
            crate::model::AssessmentReportEvidenceError {
                evidence_id: self.evidence_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl AssessmentReportEvidenceError {
    /// Creates a new builder-style object to manufacture [`AssessmentReportEvidenceError`](crate::model::AssessmentReportEvidenceError)
    pub fn builder() -> crate::model::assessment_report_evidence_error::Builder {
        crate::model::assessment_report_evidence_error::Builder::default()
    }
}

/// <p> An error entity for the <code>BatchDeleteDelegationByAssessment</code> API. This is
/// used to provide more meaningful errors than a simple string message. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDelegationByAssessmentError {
    /// <p> The identifier for the delegation. </p>
    pub delegation_id: std::option::Option<std::string::String>,
    /// <p> The error code that the <code>BatchDeleteDelegationByAssessment</code> API returned.
    /// </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p> The error message that the <code>BatchDeleteDelegationByAssessment</code> API returned.
    /// </p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchDeleteDelegationByAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDelegationByAssessmentError");
        formatter.field("delegation_id", &self.delegation_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchDeleteDelegationByAssessmentError`](crate::model::BatchDeleteDelegationByAssessmentError)
pub mod batch_delete_delegation_by_assessment_error {
    /// A builder for [`BatchDeleteDelegationByAssessmentError`](crate::model::BatchDeleteDelegationByAssessmentError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegation_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the delegation. </p>
        pub fn delegation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegation_id = Some(input.into());
            self
        }
        /// <p> The identifier for the delegation. </p>
        pub fn set_delegation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegation_id = input;
            self
        }
        /// <p> The error code that the <code>BatchDeleteDelegationByAssessment</code> API returned.
        /// </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p> The error code that the <code>BatchDeleteDelegationByAssessment</code> API returned.
        /// </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p> The error message that the <code>BatchDeleteDelegationByAssessment</code> API returned.
        /// </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p> The error message that the <code>BatchDeleteDelegationByAssessment</code> API returned.
        /// </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDelegationByAssessmentError`](crate::model::BatchDeleteDelegationByAssessmentError)
        pub fn build(self) -> crate::model::BatchDeleteDelegationByAssessmentError {
            crate::model::BatchDeleteDelegationByAssessmentError {
                delegation_id: self.delegation_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchDeleteDelegationByAssessmentError {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDelegationByAssessmentError`](crate::model::BatchDeleteDelegationByAssessmentError)
    pub fn builder() -> crate::model::batch_delete_delegation_by_assessment_error::Builder {
        crate::model::batch_delete_delegation_by_assessment_error::Builder::default()
    }
}

/// <p> An error entity for the <code>BatchCreateDelegationByAssessment</code> API. This is
/// used to provide more meaningful errors than a simple string message. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateDelegationByAssessmentError {
    /// <p> The API request to batch create delegations in Audit Manager. </p>
    pub create_delegation_request: std::option::Option<crate::model::CreateDelegationRequest>,
    /// <p> The error code that the <code>BatchCreateDelegationByAssessment</code> API returned.
    /// </p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p> The error message that the <code>BatchCreateDelegationByAssessment</code> API returned.
    /// </p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchCreateDelegationByAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateDelegationByAssessmentError");
        formatter.field("create_delegation_request", &self.create_delegation_request);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchCreateDelegationByAssessmentError`](crate::model::BatchCreateDelegationByAssessmentError)
pub mod batch_create_delegation_by_assessment_error {
    /// A builder for [`BatchCreateDelegationByAssessmentError`](crate::model::BatchCreateDelegationByAssessmentError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_delegation_request:
            std::option::Option<crate::model::CreateDelegationRequest>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The API request to batch create delegations in Audit Manager. </p>
        pub fn create_delegation_request(
            mut self,
            input: crate::model::CreateDelegationRequest,
        ) -> Self {
            self.create_delegation_request = Some(input);
            self
        }
        /// <p> The API request to batch create delegations in Audit Manager. </p>
        pub fn set_create_delegation_request(
            mut self,
            input: std::option::Option<crate::model::CreateDelegationRequest>,
        ) -> Self {
            self.create_delegation_request = input;
            self
        }
        /// <p> The error code that the <code>BatchCreateDelegationByAssessment</code> API returned.
        /// </p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p> The error code that the <code>BatchCreateDelegationByAssessment</code> API returned.
        /// </p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p> The error message that the <code>BatchCreateDelegationByAssessment</code> API returned.
        /// </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p> The error message that the <code>BatchCreateDelegationByAssessment</code> API returned.
        /// </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateDelegationByAssessmentError`](crate::model::BatchCreateDelegationByAssessmentError)
        pub fn build(self) -> crate::model::BatchCreateDelegationByAssessmentError {
            crate::model::BatchCreateDelegationByAssessmentError {
                create_delegation_request: self.create_delegation_request,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchCreateDelegationByAssessmentError {
    /// Creates a new builder-style object to manufacture [`BatchCreateDelegationByAssessmentError`](crate::model::BatchCreateDelegationByAssessmentError)
    pub fn builder() -> crate::model::batch_create_delegation_by_assessment_error::Builder {
        crate::model::batch_create_delegation_by_assessment_error::Builder::default()
    }
}

/// <p> A collection of attributes that's used to create a delegation for an assessment in
/// Audit Manager. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDelegationRequest {
    /// <p> A comment that's related to the delegation request. </p>
    pub comment: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p> The type of customer persona. </p>
    /// <note>
    /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
    /// <code>PROCESS_OWNER</code>. </p>
    /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
    /// <code>PROCESS_OWNER</code>.</p>
    /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
    /// <code>RESOURCE_OWNER</code>.</p>
    /// </note>
    pub role_type: std::option::Option<crate::model::RoleType>,
}
impl std::fmt::Debug for CreateDelegationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDelegationRequest");
        formatter.field("comment", &self.comment);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("role_type", &self.role_type);
        formatter.finish()
    }
}
/// See [`CreateDelegationRequest`](crate::model::CreateDelegationRequest)
pub mod create_delegation_request {
    /// A builder for [`CreateDelegationRequest`](crate::model::CreateDelegationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) role_type: std::option::Option<crate::model::RoleType>,
    }
    impl Builder {
        /// <p> A comment that's related to the delegation request. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p> A comment that's related to the delegation request. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the IAM role. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p> The type of customer persona. </p>
        /// <note>
        /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>. </p>
        /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>.</p>
        /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
        /// <code>RESOURCE_OWNER</code>.</p>
        /// </note>
        pub fn role_type(mut self, input: crate::model::RoleType) -> Self {
            self.role_type = Some(input);
            self
        }
        /// <p> The type of customer persona. </p>
        /// <note>
        /// <p>In <code>CreateAssessment</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>. </p>
        /// <p>In <code>UpdateSettings</code>, <code>roleType</code> can only be
        /// <code>PROCESS_OWNER</code>.</p>
        /// <p>In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
        /// <code>RESOURCE_OWNER</code>.</p>
        /// </note>
        pub fn set_role_type(mut self, input: std::option::Option<crate::model::RoleType>) -> Self {
            self.role_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDelegationRequest`](crate::model::CreateDelegationRequest)
        pub fn build(self) -> crate::model::CreateDelegationRequest {
            crate::model::CreateDelegationRequest {
                comment: self.comment,
                control_set_id: self.control_set_id,
                role_arn: self.role_arn,
                role_type: self.role_type,
            }
        }
    }
}
impl CreateDelegationRequest {
    /// Creates a new builder-style object to manufacture [`CreateDelegationRequest`](crate::model::CreateDelegationRequest)
    pub fn builder() -> crate::model::create_delegation_request::Builder {
        crate::model::create_delegation_request::Builder::default()
    }
}
