// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateAssessmentReportEvidenceFolderInput`](crate::input::AssociateAssessmentReportEvidenceFolderInput)
pub mod associate_assessment_report_evidence_folder_input {
    /// A builder for [`AssociateAssessmentReportEvidenceFolderInput`](crate::input::AssociateAssessmentReportEvidenceFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateAssessmentReportEvidenceFolderInput`](crate::input::AssociateAssessmentReportEvidenceFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateAssessmentReportEvidenceFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateAssessmentReportEvidenceFolderInput {
                assessment_id: self.assessment_id,
                evidence_folder_id: self.evidence_folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateAssessmentReportEvidenceFolderInputOperationOutputAlias =
    crate::operation::AssociateAssessmentReportEvidenceFolder;
#[doc(hidden)]
pub type AssociateAssessmentReportEvidenceFolderInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl AssociateAssessmentReportEvidenceFolderInput {
    /// Consumes the builder and constructs an Operation<[`AssociateAssessmentReportEvidenceFolder`](crate::operation::AssociateAssessmentReportEvidenceFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateAssessmentReportEvidenceFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateAssessmentReportEvidenceFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.assessment_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_1, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/associateToAssessmentReport",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateAssessmentReportEvidenceFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateAssessmentReportEvidenceFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_assessment_report_evidence_folder(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateAssessmentReportEvidenceFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateAssessmentReportEvidenceFolder",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateAssessmentReportEvidenceFolderInput`](crate::input::AssociateAssessmentReportEvidenceFolderInput)
    pub fn builder() -> crate::input::associate_assessment_report_evidence_folder_input::Builder {
        crate::input::associate_assessment_report_evidence_folder_input::Builder::default()
    }
}

/// See [`BatchAssociateAssessmentReportEvidenceInput`](crate::input::BatchAssociateAssessmentReportEvidenceInput)
pub mod batch_associate_assessment_report_evidence_input {
    /// A builder for [`BatchAssociateAssessmentReportEvidenceInput`](crate::input::BatchAssociateAssessmentReportEvidenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
        pub(crate) evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// Appends an item to `evidence_ids`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p> The list of evidence identifiers. </p>
        pub fn evidence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.evidence_ids.unwrap_or_default();
            v.push(input.into());
            self.evidence_ids = Some(v);
            self
        }
        /// <p> The list of evidence identifiers. </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.evidence_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateAssessmentReportEvidenceInput`](crate::input::BatchAssociateAssessmentReportEvidenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAssociateAssessmentReportEvidenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchAssociateAssessmentReportEvidenceInput {
                assessment_id: self.assessment_id,
                evidence_folder_id: self.evidence_folder_id,
                evidence_ids: self.evidence_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchAssociateAssessmentReportEvidenceInputOperationOutputAlias =
    crate::operation::BatchAssociateAssessmentReportEvidence;
#[doc(hidden)]
pub type BatchAssociateAssessmentReportEvidenceInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl BatchAssociateAssessmentReportEvidenceInput {
    /// Consumes the builder and constructs an Operation<[`BatchAssociateAssessmentReportEvidence`](crate::operation::BatchAssociateAssessmentReportEvidence)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAssociateAssessmentReportEvidence,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchAssociateAssessmentReportEvidenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.assessment_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_2, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/batchAssociateToAssessmentReport",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchAssociateAssessmentReportEvidenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchAssociateAssessmentReportEvidenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_associate_assessment_report_evidence(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAssociateAssessmentReportEvidence::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAssociateAssessmentReportEvidence",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchAssociateAssessmentReportEvidenceInput`](crate::input::BatchAssociateAssessmentReportEvidenceInput)
    pub fn builder() -> crate::input::batch_associate_assessment_report_evidence_input::Builder {
        crate::input::batch_associate_assessment_report_evidence_input::Builder::default()
    }
}

/// See [`BatchCreateDelegationByAssessmentInput`](crate::input::BatchCreateDelegationByAssessmentInput)
pub mod batch_create_delegation_by_assessment_input {
    /// A builder for [`BatchCreateDelegationByAssessmentInput`](crate::input::BatchCreateDelegationByAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) create_delegation_requests:
            std::option::Option<std::vec::Vec<crate::model::CreateDelegationRequest>>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `create_delegation_requests`.
        ///
        /// To override the contents of this collection use [`set_create_delegation_requests`](Self::set_create_delegation_requests).
        ///
        /// <p> The API request to batch create delegations in Audit Manager. </p>
        pub fn create_delegation_requests(
            mut self,
            input: impl Into<crate::model::CreateDelegationRequest>,
        ) -> Self {
            let mut v = self.create_delegation_requests.unwrap_or_default();
            v.push(input.into());
            self.create_delegation_requests = Some(v);
            self
        }
        /// <p> The API request to batch create delegations in Audit Manager. </p>
        pub fn set_create_delegation_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateDelegationRequest>>,
        ) -> Self {
            self.create_delegation_requests = input;
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchCreateDelegationByAssessmentInput`](crate::input::BatchCreateDelegationByAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchCreateDelegationByAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchCreateDelegationByAssessmentInput {
                create_delegation_requests: self.create_delegation_requests,
                assessment_id: self.assessment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchCreateDelegationByAssessmentInputOperationOutputAlias =
    crate::operation::BatchCreateDelegationByAssessment;
#[doc(hidden)]
pub type BatchCreateDelegationByAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchCreateDelegationByAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`BatchCreateDelegationByAssessment`](crate::operation::BatchCreateDelegationByAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchCreateDelegationByAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchCreateDelegationByAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.assessment_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_3, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/delegations",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchCreateDelegationByAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchCreateDelegationByAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_create_delegation_by_assessment(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchCreateDelegationByAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchCreateDelegationByAssessment",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchCreateDelegationByAssessmentInput`](crate::input::BatchCreateDelegationByAssessmentInput)
    pub fn builder() -> crate::input::batch_create_delegation_by_assessment_input::Builder {
        crate::input::batch_create_delegation_by_assessment_input::Builder::default()
    }
}

/// See [`BatchDeleteDelegationByAssessmentInput`](crate::input::BatchDeleteDelegationByAssessmentInput)
pub mod batch_delete_delegation_by_assessment_input {
    /// A builder for [`BatchDeleteDelegationByAssessmentInput`](crate::input::BatchDeleteDelegationByAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) delegation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `delegation_ids`.
        ///
        /// To override the contents of this collection use [`set_delegation_ids`](Self::set_delegation_ids).
        ///
        /// <p> The identifiers for the delegations. </p>
        pub fn delegation_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.delegation_ids.unwrap_or_default();
            v.push(input.into());
            self.delegation_ids = Some(v);
            self
        }
        /// <p> The identifiers for the delegations. </p>
        pub fn set_delegation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.delegation_ids = input;
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDelegationByAssessmentInput`](crate::input::BatchDeleteDelegationByAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteDelegationByAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteDelegationByAssessmentInput {
                delegation_ids: self.delegation_ids,
                assessment_id: self.assessment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteDelegationByAssessmentInputOperationOutputAlias =
    crate::operation::BatchDeleteDelegationByAssessment;
#[doc(hidden)]
pub type BatchDeleteDelegationByAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchDeleteDelegationByAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteDelegationByAssessment`](crate::operation::BatchDeleteDelegationByAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteDelegationByAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDeleteDelegationByAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.assessment_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_4, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/delegations",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDeleteDelegationByAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDeleteDelegationByAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_delegation_by_assessment(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteDelegationByAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteDelegationByAssessment",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteDelegationByAssessmentInput`](crate::input::BatchDeleteDelegationByAssessmentInput)
    pub fn builder() -> crate::input::batch_delete_delegation_by_assessment_input::Builder {
        crate::input::batch_delete_delegation_by_assessment_input::Builder::default()
    }
}

/// See [`BatchDisassociateAssessmentReportEvidenceInput`](crate::input::BatchDisassociateAssessmentReportEvidenceInput)
pub mod batch_disassociate_assessment_report_evidence_input {
    /// A builder for [`BatchDisassociateAssessmentReportEvidenceInput`](crate::input::BatchDisassociateAssessmentReportEvidenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
        pub(crate) evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// Appends an item to `evidence_ids`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p> The list of evidence identifiers. </p>
        pub fn evidence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.evidence_ids.unwrap_or_default();
            v.push(input.into());
            self.evidence_ids = Some(v);
            self
        }
        /// <p> The list of evidence identifiers. </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.evidence_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateAssessmentReportEvidenceInput`](crate::input::BatchDisassociateAssessmentReportEvidenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisassociateAssessmentReportEvidenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchDisassociateAssessmentReportEvidenceInput {
                    assessment_id: self.assessment_id,
                    evidence_folder_id: self.evidence_folder_id,
                    evidence_ids: self.evidence_ids,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchDisassociateAssessmentReportEvidenceInputOperationOutputAlias =
    crate::operation::BatchDisassociateAssessmentReportEvidence;
#[doc(hidden)]
pub type BatchDisassociateAssessmentReportEvidenceInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl BatchDisassociateAssessmentReportEvidenceInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisassociateAssessmentReportEvidence`](crate::operation::BatchDisassociateAssessmentReportEvidence)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisassociateAssessmentReportEvidence,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDisassociateAssessmentReportEvidenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.assessment_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_5, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/batchDisassociateFromAssessmentReport",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDisassociateAssessmentReportEvidenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDisassociateAssessmentReportEvidenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_disassociate_assessment_report_evidence(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisassociateAssessmentReportEvidence::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisassociateAssessmentReportEvidence",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDisassociateAssessmentReportEvidenceInput`](crate::input::BatchDisassociateAssessmentReportEvidenceInput)
    pub fn builder() -> crate::input::batch_disassociate_assessment_report_evidence_input::Builder {
        crate::input::batch_disassociate_assessment_report_evidence_input::Builder::default()
    }
}

/// See [`BatchImportEvidenceToAssessmentControlInput`](crate::input::BatchImportEvidenceToAssessmentControlInput)
pub mod batch_import_evidence_to_assessment_control_input {
    /// A builder for [`BatchImportEvidenceToAssessmentControlInput`](crate::input::BatchImportEvidenceToAssessmentControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) control_id: std::option::Option<std::string::String>,
        pub(crate) manual_evidence:
            std::option::Option<std::vec::Vec<crate::model::ManualEvidence>>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// Appends an item to `manual_evidence`.
        ///
        /// To override the contents of this collection use [`set_manual_evidence`](Self::set_manual_evidence).
        ///
        /// <p> The list of manual evidence objects. </p>
        pub fn manual_evidence(mut self, input: impl Into<crate::model::ManualEvidence>) -> Self {
            let mut v = self.manual_evidence.unwrap_or_default();
            v.push(input.into());
            self.manual_evidence = Some(v);
            self
        }
        /// <p> The list of manual evidence objects. </p>
        pub fn set_manual_evidence(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManualEvidence>>,
        ) -> Self {
            self.manual_evidence = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchImportEvidenceToAssessmentControlInput`](crate::input::BatchImportEvidenceToAssessmentControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchImportEvidenceToAssessmentControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchImportEvidenceToAssessmentControlInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                control_id: self.control_id,
                manual_evidence: self.manual_evidence,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchImportEvidenceToAssessmentControlInputOperationOutputAlias =
    crate::operation::BatchImportEvidenceToAssessmentControl;
#[doc(hidden)]
pub type BatchImportEvidenceToAssessmentControlInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl BatchImportEvidenceToAssessmentControlInput {
    /// Consumes the builder and constructs an Operation<[`BatchImportEvidenceToAssessmentControl`](crate::operation::BatchImportEvidenceToAssessmentControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchImportEvidenceToAssessmentControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchImportEvidenceToAssessmentControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.assessment_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_6, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_7 = &_input.control_set_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_set_id = aws_smithy_http::label::fmt_string(input_7, false);
            if control_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_8 = &_input.control_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_id = aws_smithy_http::label::fmt_string(input_8, false);
            if control_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}/evidence", assessmentId = assessment_id, controlSetId = control_set_id, controlId = control_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchImportEvidenceToAssessmentControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchImportEvidenceToAssessmentControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_import_evidence_to_assessment_control(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchImportEvidenceToAssessmentControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchImportEvidenceToAssessmentControl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchImportEvidenceToAssessmentControlInput`](crate::input::BatchImportEvidenceToAssessmentControlInput)
    pub fn builder() -> crate::input::batch_import_evidence_to_assessment_control_input::Builder {
        crate::input::batch_import_evidence_to_assessment_control_input::Builder::default()
    }
}

/// See [`CreateAssessmentInput`](crate::input::CreateAssessmentInput)
pub mod create_assessment_input {
    /// A builder for [`CreateAssessmentInput`](crate::input::CreateAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) assessment_reports_destination:
            std::option::Option<crate::model::AssessmentReportsDestination>,
        pub(crate) scope: std::option::Option<crate::model::Scope>,
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) framework_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The name of the assessment to be created. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the assessment to be created. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The optional description of the assessment to be created. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The optional description of the assessment to be created. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being created. </p>
        pub fn assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.assessment_reports_destination = Some(input);
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being created. </p>
        pub fn set_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.assessment_reports_destination = input;
            self
        }
        /// <p> The wrapper that contains the Amazon Web Services accounts and services that are in
        /// scope for the assessment. </p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p> The wrapper that contains the Amazon Web Services accounts and services that are in
        /// scope for the assessment. </p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.scope = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p> The list of roles for the assessment. </p>
        pub fn roles(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p> The list of roles for the assessment. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// <p> The identifier for the framework that the assessment will be created from. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_id = Some(input.into());
            self
        }
        /// <p> The identifier for the framework that the assessment will be created from. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the assessment. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags that are associated with the assessment. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentInput`](crate::input::CreateAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssessmentInput {
                name: self.name,
                description: self.description,
                assessment_reports_destination: self.assessment_reports_destination,
                scope: self.scope,
                roles: self.roles,
                framework_id: self.framework_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssessmentInputOperationOutputAlias = crate::operation::CreateAssessment;
#[doc(hidden)]
pub type CreateAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssessment`](crate::operation::CreateAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assessments").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_assessment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssessment",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssessmentInput`](crate::input::CreateAssessmentInput)
    pub fn builder() -> crate::input::create_assessment_input::Builder {
        crate::input::create_assessment_input::Builder::default()
    }
}

/// See [`CreateAssessmentFrameworkInput`](crate::input::CreateAssessmentFrameworkInput)
pub mod create_assessment_framework_input {
    /// A builder for [`CreateAssessmentFrameworkInput`](crate::input::CreateAssessmentFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) control_sets:
            std::option::Option<std::vec::Vec<crate::model::CreateAssessmentFrameworkControlSet>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The name of the new custom framework. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the new custom framework. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> An optional description for the new custom framework. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> An optional description for the new custom framework. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// Appends an item to `control_sets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p> The control sets that are associated with the framework. </p>
        pub fn control_sets(
            mut self,
            input: impl Into<crate::model::CreateAssessmentFrameworkControlSet>,
        ) -> Self {
            let mut v = self.control_sets.unwrap_or_default();
            v.push(input.into());
            self.control_sets = Some(v);
            self
        }
        /// <p> The control sets that are associated with the framework. </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssessmentFrameworkControlSet>,
            >,
        ) -> Self {
            self.control_sets = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the framework. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags that are associated with the framework. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentFrameworkInput`](crate::input::CreateAssessmentFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssessmentFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssessmentFrameworkInput {
                name: self.name,
                description: self.description,
                compliance_type: self.compliance_type,
                control_sets: self.control_sets,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssessmentFrameworkInputOperationOutputAlias =
    crate::operation::CreateAssessmentFramework;
#[doc(hidden)]
pub type CreateAssessmentFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssessmentFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssessmentFramework`](crate::operation::CreateAssessmentFramework)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssessmentFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssessmentFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assessmentFrameworks").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssessmentFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssessmentFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_assessment_framework(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssessmentFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssessmentFramework",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssessmentFrameworkInput`](crate::input::CreateAssessmentFrameworkInput)
    pub fn builder() -> crate::input::create_assessment_framework_input::Builder {
        crate::input::create_assessment_framework_input::Builder::default()
    }
}

/// See [`CreateAssessmentReportInput`](crate::input::CreateAssessmentReportInput)
pub mod create_assessment_report_input {
    /// A builder for [`CreateAssessmentReportInput`](crate::input::CreateAssessmentReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the new assessment report. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the new assessment report. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the assessment report. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the assessment report. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAssessmentReportInput`](crate::input::CreateAssessmentReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAssessmentReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAssessmentReportInput {
                name: self.name,
                description: self.description,
                assessment_id: self.assessment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAssessmentReportInputOperationOutputAlias = crate::operation::CreateAssessmentReport;
#[doc(hidden)]
pub type CreateAssessmentReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateAssessmentReportInput {
    /// Consumes the builder and constructs an Operation<[`CreateAssessmentReport`](crate::operation::CreateAssessmentReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAssessmentReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAssessmentReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.assessment_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_9, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/reports",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAssessmentReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAssessmentReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_assessment_report(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAssessmentReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAssessmentReport",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAssessmentReportInput`](crate::input::CreateAssessmentReportInput)
    pub fn builder() -> crate::input::create_assessment_report_input::Builder {
        crate::input::create_assessment_report_input::Builder::default()
    }
}

/// See [`CreateControlInput`](crate::input::CreateControlInput)
pub mod create_control_input {
    /// A builder for [`CreateControlInput`](crate::input::CreateControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) testing_information: std::option::Option<std::string::String>,
        pub(crate) action_plan_title: std::option::Option<std::string::String>,
        pub(crate) action_plan_instructions: std::option::Option<std::string::String>,
        pub(crate) control_mapping_sources:
            std::option::Option<std::vec::Vec<crate::model::CreateControlMappingSource>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The name of the control. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the control. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the control. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the control. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The steps to follow to determine if the control is satisfied. </p>
        pub fn testing_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.testing_information = Some(input.into());
            self
        }
        /// <p> The steps to follow to determine if the control is satisfied. </p>
        pub fn set_testing_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.testing_information = input;
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn action_plan_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_plan_title = Some(input.into());
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn set_action_plan_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_plan_title = input;
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn action_plan_instructions(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_plan_instructions = Some(input.into());
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn set_action_plan_instructions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_plan_instructions = input;
            self
        }
        /// Appends an item to `control_mapping_sources`.
        ///
        /// To override the contents of this collection use [`set_control_mapping_sources`](Self::set_control_mapping_sources).
        ///
        /// <p> The data mapping sources for the control. </p>
        pub fn control_mapping_sources(
            mut self,
            input: impl Into<crate::model::CreateControlMappingSource>,
        ) -> Self {
            let mut v = self.control_mapping_sources.unwrap_or_default();
            v.push(input.into());
            self.control_mapping_sources = Some(v);
            self
        }
        /// <p> The data mapping sources for the control. </p>
        pub fn set_control_mapping_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateControlMappingSource>>,
        ) -> Self {
            self.control_mapping_sources = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the control. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags that are associated with the control. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateControlInput`](crate::input::CreateControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateControlInput {
                name: self.name,
                description: self.description,
                testing_information: self.testing_information,
                action_plan_title: self.action_plan_title,
                action_plan_instructions: self.action_plan_instructions,
                control_mapping_sources: self.control_mapping_sources,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateControlInputOperationOutputAlias = crate::operation::CreateControl;
#[doc(hidden)]
pub type CreateControlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateControlInput {
    /// Consumes the builder and constructs an Operation<[`CreateControl`](crate::operation::CreateControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/controls").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_control(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateControl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateControlInput`](crate::input::CreateControlInput)
    pub fn builder() -> crate::input::create_control_input::Builder {
        crate::input::create_control_input::Builder::default()
    }
}

/// See [`DeleteAssessmentInput`](crate::input::DeleteAssessmentInput)
pub mod delete_assessment_input {
    /// A builder for [`DeleteAssessmentInput`](crate::input::DeleteAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssessmentInput`](crate::input::DeleteAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssessmentInput {
                assessment_id: self.assessment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssessmentInputOperationOutputAlias = crate::operation::DeleteAssessment;
#[doc(hidden)]
pub type DeleteAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssessment`](crate::operation::DeleteAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.assessment_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_10, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssessment",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentInput`](crate::input::DeleteAssessmentInput)
    pub fn builder() -> crate::input::delete_assessment_input::Builder {
        crate::input::delete_assessment_input::Builder::default()
    }
}

/// See [`DeleteAssessmentFrameworkInput`](crate::input::DeleteAssessmentFrameworkInput)
pub mod delete_assessment_framework_input {
    /// A builder for [`DeleteAssessmentFrameworkInput`](crate::input::DeleteAssessmentFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the framework. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_id = Some(input.into());
            self
        }
        /// <p> The identifier for the framework. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssessmentFrameworkInput`](crate::input::DeleteAssessmentFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssessmentFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssessmentFrameworkInput {
                framework_id: self.framework_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssessmentFrameworkInputOperationOutputAlias =
    crate::operation::DeleteAssessmentFramework;
#[doc(hidden)]
pub type DeleteAssessmentFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssessmentFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssessmentFramework`](crate::operation::DeleteAssessmentFramework)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssessmentFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssessmentFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_11 = &_input.framework_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "framework_id",
                        details: "cannot be empty or unset",
                    })?;
            let framework_id = aws_smithy_http::label::fmt_string(input_11, false);
            if framework_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "framework_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessmentFrameworks/{frameworkId}",
                frameworkId = framework_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssessmentFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssessmentFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssessmentFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssessmentFramework",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentFrameworkInput`](crate::input::DeleteAssessmentFrameworkInput)
    pub fn builder() -> crate::input::delete_assessment_framework_input::Builder {
        crate::input::delete_assessment_framework_input::Builder::default()
    }
}

/// See [`DeleteAssessmentFrameworkShareInput`](crate::input::DeleteAssessmentFrameworkShareInput)
pub mod delete_assessment_framework_share_input {
    /// A builder for [`DeleteAssessmentFrameworkShareInput`](crate::input::DeleteAssessmentFrameworkShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) request_type: std::option::Option<crate::model::ShareRequestType>,
    }
    impl Builder {
        /// <p>The unique identifier for the share request to be deleted.</p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the share request to be deleted.</p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn request_type(mut self, input: crate::model::ShareRequestType) -> Self {
            self.request_type = Some(input);
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn set_request_type(
            mut self,
            input: std::option::Option<crate::model::ShareRequestType>,
        ) -> Self {
            self.request_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssessmentFrameworkShareInput`](crate::input::DeleteAssessmentFrameworkShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssessmentFrameworkShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssessmentFrameworkShareInput {
                request_id: self.request_id,
                request_type: self.request_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssessmentFrameworkShareInputOperationOutputAlias =
    crate::operation::DeleteAssessmentFrameworkShare;
#[doc(hidden)]
pub type DeleteAssessmentFrameworkShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssessmentFrameworkShareInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssessmentFrameworkShare`](crate::operation::DeleteAssessmentFrameworkShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssessmentFrameworkShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssessmentFrameworkShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.request_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "request_id",
                        details: "cannot be empty or unset",
                    })?;
            let request_id = aws_smithy_http::label::fmt_string(input_12, false);
            if request_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "request_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessmentFrameworkShareRequests/{requestId}",
                requestId = request_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteAssessmentFrameworkShareInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.request_type {
                query.push_kv(
                    "requestType",
                    &aws_smithy_http::query::fmt_string(&inner_13),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssessmentFrameworkShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssessmentFrameworkShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssessmentFrameworkShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssessmentFrameworkShare",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentFrameworkShareInput`](crate::input::DeleteAssessmentFrameworkShareInput)
    pub fn builder() -> crate::input::delete_assessment_framework_share_input::Builder {
        crate::input::delete_assessment_framework_share_input::Builder::default()
    }
}

/// See [`DeleteAssessmentReportInput`](crate::input::DeleteAssessmentReportInput)
pub mod delete_assessment_report_input {
    /// A builder for [`DeleteAssessmentReportInput`](crate::input::DeleteAssessmentReportInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) assessment_report_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn assessment_report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_report_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the assessment report. </p>
        pub fn set_assessment_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_report_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAssessmentReportInput`](crate::input::DeleteAssessmentReportInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAssessmentReportInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAssessmentReportInput {
                assessment_id: self.assessment_id,
                assessment_report_id: self.assessment_report_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAssessmentReportInputOperationOutputAlias = crate::operation::DeleteAssessmentReport;
#[doc(hidden)]
pub type DeleteAssessmentReportInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteAssessmentReportInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAssessmentReport`](crate::operation::DeleteAssessmentReport)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAssessmentReport,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAssessmentReportInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.assessment_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_14, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_15 = &_input.assessment_report_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_report_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_report_id = aws_smithy_http::label::fmt_string(input_15, false);
            if assessment_report_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_report_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/reports/{assessmentReportId}",
                assessmentId = assessment_id,
                assessmentReportId = assessment_report_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAssessmentReportInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAssessmentReportInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAssessmentReport::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAssessmentReport",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentReportInput`](crate::input::DeleteAssessmentReportInput)
    pub fn builder() -> crate::input::delete_assessment_report_input::Builder {
        crate::input::delete_assessment_report_input::Builder::default()
    }
}

/// See [`DeleteControlInput`](crate::input::DeleteControlInput)
pub mod delete_control_input {
    /// A builder for [`DeleteControlInput`](crate::input::DeleteControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteControlInput`](crate::input::DeleteControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteControlInput {
                control_id: self.control_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteControlInputOperationOutputAlias = crate::operation::DeleteControl;
#[doc(hidden)]
pub type DeleteControlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteControlInput {
    /// Consumes the builder and constructs an Operation<[`DeleteControl`](crate::operation::DeleteControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.control_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_id = aws_smithy_http::label::fmt_string(input_16, false);
            if control_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/controls/{controlId}", controlId = control_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteControl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteControlInput`](crate::input::DeleteControlInput)
    pub fn builder() -> crate::input::delete_control_input::Builder {
        crate::input::delete_control_input::Builder::default()
    }
}

/// See [`DeregisterAccountInput`](crate::input::DeregisterAccountInput)
pub mod deregister_account_input {
    /// A builder for [`DeregisterAccountInput`](crate::input::DeregisterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterAccountInput`](crate::input::DeregisterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type DeregisterAccountInputOperationOutputAlias = crate::operation::DeregisterAccount;
#[doc(hidden)]
pub type DeregisterAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterAccountInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterAccount`](crate::operation::DeregisterAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account/deregisterAccount").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterAccount",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterAccountInput`](crate::input::DeregisterAccountInput)
    pub fn builder() -> crate::input::deregister_account_input::Builder {
        crate::input::deregister_account_input::Builder::default()
    }
}

/// See [`DeregisterOrganizationAdminAccountInput`](crate::input::DeregisterOrganizationAdminAccountInput)
pub mod deregister_organization_admin_account_input {
    /// A builder for [`DeregisterOrganizationAdminAccountInput`](crate::input::DeregisterOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the administrator account. </p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p> The identifier for the administrator account. </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterOrganizationAdminAccountInput`](crate::input::DeregisterOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::DeregisterOrganizationAdminAccount;
#[doc(hidden)]
pub type DeregisterOrganizationAdminAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeregisterOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterOrganizationAdminAccount`](crate::operation::DeregisterOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterOrganizationAdminAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeregisterOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account/deregisterOrganizationAdminAccount")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeregisterOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeregisterOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_deregister_organization_admin_account(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterOrganizationAdminAccount",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeregisterOrganizationAdminAccountInput`](crate::input::DeregisterOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::deregister_organization_admin_account_input::Builder {
        crate::input::deregister_organization_admin_account_input::Builder::default()
    }
}

/// See [`DisassociateAssessmentReportEvidenceFolderInput`](crate::input::DisassociateAssessmentReportEvidenceFolderInput)
pub mod disassociate_assessment_report_evidence_folder_input {
    /// A builder for [`DisassociateAssessmentReportEvidenceFolderInput`](crate::input::DisassociateAssessmentReportEvidenceFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the folder in which evidence is stored. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder in which evidence is stored. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateAssessmentReportEvidenceFolderInput`](crate::input::DisassociateAssessmentReportEvidenceFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateAssessmentReportEvidenceFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociateAssessmentReportEvidenceFolderInput {
                    assessment_id: self.assessment_id,
                    evidence_folder_id: self.evidence_folder_id,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociateAssessmentReportEvidenceFolderInputOperationOutputAlias =
    crate::operation::DisassociateAssessmentReportEvidenceFolder;
#[doc(hidden)]
pub type DisassociateAssessmentReportEvidenceFolderInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateAssessmentReportEvidenceFolderInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateAssessmentReportEvidenceFolder`](crate::operation::DisassociateAssessmentReportEvidenceFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateAssessmentReportEvidenceFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateAssessmentReportEvidenceFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.assessment_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_17, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/disassociateFromAssessmentReport",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateAssessmentReportEvidenceFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateAssessmentReportEvidenceFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_assessment_report_evidence_folder(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateAssessmentReportEvidenceFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateAssessmentReportEvidenceFolder",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateAssessmentReportEvidenceFolderInput`](crate::input::DisassociateAssessmentReportEvidenceFolderInput)
    pub fn builder() -> crate::input::disassociate_assessment_report_evidence_folder_input::Builder
    {
        crate::input::disassociate_assessment_report_evidence_folder_input::Builder::default()
    }
}

/// See [`GetAccountStatusInput`](crate::input::GetAccountStatusInput)
pub mod get_account_status_input {
    /// A builder for [`GetAccountStatusInput`](crate::input::GetAccountStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAccountStatusInput`](crate::input::GetAccountStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccountStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccountStatusInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAccountStatusInputOperationOutputAlias = crate::operation::GetAccountStatus;
#[doc(hidden)]
pub type GetAccountStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAccountStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetAccountStatus`](crate::operation::GetAccountStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccountStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAccountStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account/status").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAccountStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAccountStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccountStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccountStatus",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAccountStatusInput`](crate::input::GetAccountStatusInput)
    pub fn builder() -> crate::input::get_account_status_input::Builder {
        crate::input::get_account_status_input::Builder::default()
    }
}

/// See [`GetAssessmentInput`](crate::input::GetAssessmentInput)
pub mod get_assessment_input {
    /// A builder for [`GetAssessmentInput`](crate::input::GetAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssessmentInput`](crate::input::GetAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssessmentInput {
                assessment_id: self.assessment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssessmentInputOperationOutputAlias = crate::operation::GetAssessment;
#[doc(hidden)]
pub type GetAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`GetAssessment`](crate::operation::GetAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.assessment_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_18, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssessment",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssessmentInput`](crate::input::GetAssessmentInput)
    pub fn builder() -> crate::input::get_assessment_input::Builder {
        crate::input::get_assessment_input::Builder::default()
    }
}

/// See [`GetAssessmentFrameworkInput`](crate::input::GetAssessmentFrameworkInput)
pub mod get_assessment_framework_input {
    /// A builder for [`GetAssessmentFrameworkInput`](crate::input::GetAssessmentFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the framework. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_id = Some(input.into());
            self
        }
        /// <p> The identifier for the framework. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssessmentFrameworkInput`](crate::input::GetAssessmentFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssessmentFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssessmentFrameworkInput {
                framework_id: self.framework_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssessmentFrameworkInputOperationOutputAlias = crate::operation::GetAssessmentFramework;
#[doc(hidden)]
pub type GetAssessmentFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssessmentFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`GetAssessmentFramework`](crate::operation::GetAssessmentFramework)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssessmentFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssessmentFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.framework_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "framework_id",
                        details: "cannot be empty or unset",
                    })?;
            let framework_id = aws_smithy_http::label::fmt_string(input_19, false);
            if framework_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "framework_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessmentFrameworks/{frameworkId}",
                frameworkId = framework_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssessmentFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssessmentFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssessmentFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssessmentFramework",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssessmentFrameworkInput`](crate::input::GetAssessmentFrameworkInput)
    pub fn builder() -> crate::input::get_assessment_framework_input::Builder {
        crate::input::get_assessment_framework_input::Builder::default()
    }
}

/// See [`GetAssessmentReportUrlInput`](crate::input::GetAssessmentReportUrlInput)
pub mod get_assessment_report_url_input {
    /// A builder for [`GetAssessmentReportUrlInput`](crate::input::GetAssessmentReportUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_report_id: std::option::Option<std::string::String>,
        pub(crate) assessment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment report. </p>
        pub fn assessment_report_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_report_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment report. </p>
        pub fn set_assessment_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_report_id = input;
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAssessmentReportUrlInput`](crate::input::GetAssessmentReportUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAssessmentReportUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAssessmentReportUrlInput {
                assessment_report_id: self.assessment_report_id,
                assessment_id: self.assessment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAssessmentReportUrlInputOperationOutputAlias = crate::operation::GetAssessmentReportUrl;
#[doc(hidden)]
pub type GetAssessmentReportUrlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAssessmentReportUrlInput {
    /// Consumes the builder and constructs an Operation<[`GetAssessmentReportUrl`](crate::operation::GetAssessmentReportUrl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAssessmentReportUrl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAssessmentReportUrlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.assessment_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_20, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.assessment_report_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_report_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_report_id = aws_smithy_http::label::fmt_string(input_21, false);
            if assessment_report_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_report_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/reports/{assessmentReportId}/url",
                assessmentId = assessment_id,
                assessmentReportId = assessment_report_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAssessmentReportUrlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAssessmentReportUrlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAssessmentReportUrl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAssessmentReportUrl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAssessmentReportUrlInput`](crate::input::GetAssessmentReportUrlInput)
    pub fn builder() -> crate::input::get_assessment_report_url_input::Builder {
        crate::input::get_assessment_report_url_input::Builder::default()
    }
}

/// See [`GetChangeLogsInput`](crate::input::GetChangeLogsInput)
pub mod get_change_logs_input {
    /// A builder for [`GetChangeLogsInput`](crate::input::GetChangeLogsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) control_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetChangeLogsInput`](crate::input::GetChangeLogsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetChangeLogsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetChangeLogsInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                control_id: self.control_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetChangeLogsInputOperationOutputAlias = crate::operation::GetChangeLogs;
#[doc(hidden)]
pub type GetChangeLogsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetChangeLogsInput {
    /// Consumes the builder and constructs an Operation<[`GetChangeLogs`](crate::operation::GetChangeLogs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetChangeLogs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetChangeLogsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.assessment_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_22, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/changelogs",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetChangeLogsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_23) = &_input.control_set_id {
                query.push_kv(
                    "controlSetId",
                    &aws_smithy_http::query::fmt_string(&inner_23),
                );
            }
            if let Some(inner_24) = &_input.control_id {
                query.push_kv("controlId", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if let Some(inner_25) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            if let Some(inner_26) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_26).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetChangeLogsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetChangeLogsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetChangeLogs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetChangeLogs",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetChangeLogsInput`](crate::input::GetChangeLogsInput)
    pub fn builder() -> crate::input::get_change_logs_input::Builder {
        crate::input::get_change_logs_input::Builder::default()
    }
}

/// See [`GetControlInput`](crate::input::GetControlInput)
pub mod get_control_input {
    /// A builder for [`GetControlInput`](crate::input::GetControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetControlInput`](crate::input::GetControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetControlInput {
                control_id: self.control_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetControlInputOperationOutputAlias = crate::operation::GetControl;
#[doc(hidden)]
pub type GetControlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetControlInput {
    /// Consumes the builder and constructs an Operation<[`GetControl`](crate::operation::GetControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.control_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_id = aws_smithy_http::label::fmt_string(input_27, false);
            if control_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/controls/{controlId}", controlId = control_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetControl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetControlInput`](crate::input::GetControlInput)
    pub fn builder() -> crate::input::get_control_input::Builder {
        crate::input::get_control_input::Builder::default()
    }
}

/// See [`GetDelegationsInput`](crate::input::GetDelegationsInput)
pub mod get_delegations_input {
    /// A builder for [`GetDelegationsInput`](crate::input::GetDelegationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDelegationsInput`](crate::input::GetDelegationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDelegationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDelegationsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDelegationsInputOperationOutputAlias = crate::operation::GetDelegations;
#[doc(hidden)]
pub type GetDelegationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDelegationsInput {
    /// Consumes the builder and constructs an Operation<[`GetDelegations`](crate::operation::GetDelegations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDelegations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDelegationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/delegations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetDelegationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_28) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_28));
            }
            if let Some(inner_29) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_29).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDelegationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDelegationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDelegations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDelegations",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDelegationsInput`](crate::input::GetDelegationsInput)
    pub fn builder() -> crate::input::get_delegations_input::Builder {
        crate::input::get_delegations_input::Builder::default()
    }
}

/// See [`GetEvidenceInput`](crate::input::GetEvidenceInput)
pub mod get_evidence_input {
    /// A builder for [`GetEvidenceInput`](crate::input::GetEvidenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
        pub(crate) evidence_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// <p> The identifier for the evidence. </p>
        pub fn evidence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_id = Some(input.into());
            self
        }
        /// <p> The identifier for the evidence. </p>
        pub fn set_evidence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.evidence_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceInput`](crate::input::GetEvidenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEvidenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEvidenceInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                evidence_folder_id: self.evidence_folder_id,
                evidence_id: self.evidence_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEvidenceInputOperationOutputAlias = crate::operation::GetEvidence;
#[doc(hidden)]
pub type GetEvidenceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEvidenceInput {
    /// Consumes the builder and constructs an Operation<[`GetEvidence`](crate::operation::GetEvidence)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEvidence,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEvidenceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_30 = &_input.assessment_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_30, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_31 = &_input.control_set_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_set_id = aws_smithy_http::label::fmt_string(input_31, false);
            if control_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_32 = &_input.evidence_folder_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "evidence_folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let evidence_folder_id = aws_smithy_http::label::fmt_string(input_32, false);
            if evidence_folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "evidence_folder_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_33 = &_input.evidence_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "evidence_id",
                        details: "cannot be empty or unset",
                    })?;
            let evidence_id = aws_smithy_http::label::fmt_string(input_33, false);
            if evidence_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "evidence_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence/{evidenceId}", assessmentId = assessment_id, controlSetId = control_set_id, evidenceFolderId = evidence_folder_id, evidenceId = evidence_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEvidenceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEvidenceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEvidence::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEvidence",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEvidenceInput`](crate::input::GetEvidenceInput)
    pub fn builder() -> crate::input::get_evidence_input::Builder {
        crate::input::get_evidence_input::Builder::default()
    }
}

/// See [`GetEvidenceByEvidenceFolderInput`](crate::input::GetEvidenceByEvidenceFolderInput)
pub mod get_evidence_by_evidence_folder_input {
    /// A builder for [`GetEvidenceByEvidenceFolderInput`](crate::input::GetEvidenceByEvidenceFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceByEvidenceFolderInput`](crate::input::GetEvidenceByEvidenceFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEvidenceByEvidenceFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEvidenceByEvidenceFolderInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                evidence_folder_id: self.evidence_folder_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEvidenceByEvidenceFolderInputOperationOutputAlias =
    crate::operation::GetEvidenceByEvidenceFolder;
#[doc(hidden)]
pub type GetEvidenceByEvidenceFolderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEvidenceByEvidenceFolderInput {
    /// Consumes the builder and constructs an Operation<[`GetEvidenceByEvidenceFolder`](crate::operation::GetEvidenceByEvidenceFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEvidenceByEvidenceFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEvidenceByEvidenceFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.assessment_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_34, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.control_set_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_set_id = aws_smithy_http::label::fmt_string(input_35, false);
            if control_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_36 = &_input.evidence_folder_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "evidence_folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let evidence_folder_id = aws_smithy_http::label::fmt_string(input_36, false);
            if evidence_folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "evidence_folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence", assessmentId = assessment_id, controlSetId = control_set_id, evidenceFolderId = evidence_folder_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetEvidenceByEvidenceFolderInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_37) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_37));
            }
            if let Some(inner_38) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_38).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEvidenceByEvidenceFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEvidenceByEvidenceFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEvidenceByEvidenceFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEvidenceByEvidenceFolder",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEvidenceByEvidenceFolderInput`](crate::input::GetEvidenceByEvidenceFolderInput)
    pub fn builder() -> crate::input::get_evidence_by_evidence_folder_input::Builder {
        crate::input::get_evidence_by_evidence_folder_input::Builder::default()
    }
}

/// See [`GetEvidenceFolderInput`](crate::input::GetEvidenceFolderInput)
pub mod get_evidence_folder_input {
    /// A builder for [`GetEvidenceFolderInput`](crate::input::GetEvidenceFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) evidence_folder_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn evidence_folder_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evidence_folder_id = Some(input.into());
            self
        }
        /// <p> The identifier for the folder that the evidence is stored in. </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evidence_folder_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceFolderInput`](crate::input::GetEvidenceFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEvidenceFolderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEvidenceFolderInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                evidence_folder_id: self.evidence_folder_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEvidenceFolderInputOperationOutputAlias = crate::operation::GetEvidenceFolder;
#[doc(hidden)]
pub type GetEvidenceFolderInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEvidenceFolderInput {
    /// Consumes the builder and constructs an Operation<[`GetEvidenceFolder`](crate::operation::GetEvidenceFolder)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEvidenceFolder,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEvidenceFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.assessment_id;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_39, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_40 = &_input.control_set_id;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_set_id = aws_smithy_http::label::fmt_string(input_40, false);
            if control_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_41 = &_input.evidence_folder_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "evidence_folder_id",
                        details: "cannot be empty or unset",
                    })?;
            let evidence_folder_id = aws_smithy_http::label::fmt_string(input_41, false);
            if evidence_folder_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "evidence_folder_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}", assessmentId = assessment_id, controlSetId = control_set_id, evidenceFolderId = evidence_folder_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEvidenceFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEvidenceFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEvidenceFolder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEvidenceFolder",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEvidenceFolderInput`](crate::input::GetEvidenceFolderInput)
    pub fn builder() -> crate::input::get_evidence_folder_input::Builder {
        crate::input::get_evidence_folder_input::Builder::default()
    }
}

/// See [`GetEvidenceFoldersByAssessmentInput`](crate::input::GetEvidenceFoldersByAssessmentInput)
pub mod get_evidence_folders_by_assessment_input {
    /// A builder for [`GetEvidenceFoldersByAssessmentInput`](crate::input::GetEvidenceFoldersByAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceFoldersByAssessmentInput`](crate::input::GetEvidenceFoldersByAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEvidenceFoldersByAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEvidenceFoldersByAssessmentInput {
                assessment_id: self.assessment_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEvidenceFoldersByAssessmentInputOperationOutputAlias =
    crate::operation::GetEvidenceFoldersByAssessment;
#[doc(hidden)]
pub type GetEvidenceFoldersByAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEvidenceFoldersByAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`GetEvidenceFoldersByAssessment`](crate::operation::GetEvidenceFoldersByAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEvidenceFoldersByAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEvidenceFoldersByAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_42 = &_input.assessment_id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_42, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/evidenceFolders",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetEvidenceFoldersByAssessmentInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_43) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_43));
            }
            if let Some(inner_44) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_44).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEvidenceFoldersByAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEvidenceFoldersByAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEvidenceFoldersByAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEvidenceFoldersByAssessment",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEvidenceFoldersByAssessmentInput`](crate::input::GetEvidenceFoldersByAssessmentInput)
    pub fn builder() -> crate::input::get_evidence_folders_by_assessment_input::Builder {
        crate::input::get_evidence_folders_by_assessment_input::Builder::default()
    }
}

/// See [`GetEvidenceFoldersByAssessmentControlInput`](crate::input::GetEvidenceFoldersByAssessmentControlInput)
pub mod get_evidence_folders_by_assessment_control_input {
    /// A builder for [`GetEvidenceFoldersByAssessmentControlInput`](crate::input::GetEvidenceFoldersByAssessmentControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) control_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvidenceFoldersByAssessmentControlInput`](crate::input::GetEvidenceFoldersByAssessmentControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEvidenceFoldersByAssessmentControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEvidenceFoldersByAssessmentControlInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                control_id: self.control_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEvidenceFoldersByAssessmentControlInputOperationOutputAlias =
    crate::operation::GetEvidenceFoldersByAssessmentControl;
#[doc(hidden)]
pub type GetEvidenceFoldersByAssessmentControlInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetEvidenceFoldersByAssessmentControlInput {
    /// Consumes the builder and constructs an Operation<[`GetEvidenceFoldersByAssessmentControl`](crate::operation::GetEvidenceFoldersByAssessmentControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEvidenceFoldersByAssessmentControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEvidenceFoldersByAssessmentControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.assessment_id;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_45, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_46 = &_input.control_set_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_set_id = aws_smithy_http::label::fmt_string(input_46, false);
            if control_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_47 = &_input.control_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_id = aws_smithy_http::label::fmt_string(input_47, false);
            if control_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/assessments/{assessmentId}/evidenceFolders-by-assessment-control/{controlSetId}/{controlId}", assessmentId = assessment_id, controlSetId = control_set_id, controlId = control_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetEvidenceFoldersByAssessmentControlInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_48) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_48));
            }
            if let Some(inner_49) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_49).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEvidenceFoldersByAssessmentControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEvidenceFoldersByAssessmentControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEvidenceFoldersByAssessmentControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEvidenceFoldersByAssessmentControl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEvidenceFoldersByAssessmentControlInput`](crate::input::GetEvidenceFoldersByAssessmentControlInput)
    pub fn builder() -> crate::input::get_evidence_folders_by_assessment_control_input::Builder {
        crate::input::get_evidence_folders_by_assessment_control_input::Builder::default()
    }
}

/// See [`GetOrganizationAdminAccountInput`](crate::input::GetOrganizationAdminAccountInput)
pub mod get_organization_admin_account_input {
    /// A builder for [`GetOrganizationAdminAccountInput`](crate::input::GetOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetOrganizationAdminAccountInput`](crate::input::GetOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOrganizationAdminAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::GetOrganizationAdminAccount;
#[doc(hidden)]
pub type GetOrganizationAdminAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetOrganizationAdminAccount`](crate::operation::GetOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOrganizationAdminAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account/organizationAdminAccount").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOrganizationAdminAccount",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetOrganizationAdminAccountInput`](crate::input::GetOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::get_organization_admin_account_input::Builder {
        crate::input::get_organization_admin_account_input::Builder::default()
    }
}

/// See [`GetServicesInScopeInput`](crate::input::GetServicesInScopeInput)
pub mod get_services_in_scope_input {
    /// A builder for [`GetServicesInScopeInput`](crate::input::GetServicesInScopeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetServicesInScopeInput`](crate::input::GetServicesInScopeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServicesInScopeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServicesInScopeInput {})
        }
    }
}
#[doc(hidden)]
pub type GetServicesInScopeInputOperationOutputAlias = crate::operation::GetServicesInScope;
#[doc(hidden)]
pub type GetServicesInScopeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetServicesInScopeInput {
    /// Consumes the builder and constructs an Operation<[`GetServicesInScope`](crate::operation::GetServicesInScope)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServicesInScope,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetServicesInScopeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/services").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetServicesInScopeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetServicesInScopeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServicesInScope::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServicesInScope",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetServicesInScopeInput`](crate::input::GetServicesInScopeInput)
    pub fn builder() -> crate::input::get_services_in_scope_input::Builder {
        crate::input::get_services_in_scope_input::Builder::default()
    }
}

/// See [`GetSettingsInput`](crate::input::GetSettingsInput)
pub mod get_settings_input {
    /// A builder for [`GetSettingsInput`](crate::input::GetSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::SettingAttribute>,
    }
    impl Builder {
        /// <p> The list of <code>SettingAttribute</code> enum values. </p>
        pub fn attribute(mut self, input: crate::model::SettingAttribute) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p> The list of <code>SettingAttribute</code> enum values. </p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::SettingAttribute>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSettingsInput`](crate::input::GetSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSettingsInput {
                attribute: self.attribute,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSettingsInputOperationOutputAlias = crate::operation::GetSettings;
#[doc(hidden)]
pub type GetSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetSettings`](crate::operation::GetSettings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_50 = &_input.attribute;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attribute",
                        details: "cannot be empty or unset",
                    })?;
            let attribute = aws_smithy_http::label::fmt_string(input_50, false);
            if attribute.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "attribute",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/settings/{attribute}", attribute = attribute)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSettings",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSettingsInput`](crate::input::GetSettingsInput)
    pub fn builder() -> crate::input::get_settings_input::Builder {
        crate::input::get_settings_input::Builder::default()
    }
}

/// See [`ListAssessmentFrameworksInput`](crate::input::ListAssessmentFrameworksInput)
pub mod list_assessment_frameworks_input {
    /// A builder for [`ListAssessmentFrameworksInput`](crate::input::ListAssessmentFrameworksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_type: std::option::Option<crate::model::FrameworkType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The type of framework, such as a standard framework or a custom framework. </p>
        pub fn framework_type(mut self, input: crate::model::FrameworkType) -> Self {
            self.framework_type = Some(input);
            self
        }
        /// <p> The type of framework, such as a standard framework or a custom framework. </p>
        pub fn set_framework_type(
            mut self,
            input: std::option::Option<crate::model::FrameworkType>,
        ) -> Self {
            self.framework_type = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentFrameworksInput`](crate::input::ListAssessmentFrameworksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentFrameworksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentFrameworksInput {
                framework_type: self.framework_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentFrameworksInputOperationOutputAlias =
    crate::operation::ListAssessmentFrameworks;
#[doc(hidden)]
pub type ListAssessmentFrameworksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssessmentFrameworksInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessmentFrameworks`](crate::operation::ListAssessmentFrameworks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessmentFrameworks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentFrameworksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assessmentFrameworks").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssessmentFrameworksInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_51) = &_input.framework_type {
                query.push_kv(
                    "frameworkType",
                    &aws_smithy_http::query::fmt_string(&inner_51),
                );
            }
            if let Some(inner_52) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_52));
            }
            if let Some(inner_53) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_53).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentFrameworksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentFrameworksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessmentFrameworks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessmentFrameworks",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentFrameworksInput`](crate::input::ListAssessmentFrameworksInput)
    pub fn builder() -> crate::input::list_assessment_frameworks_input::Builder {
        crate::input::list_assessment_frameworks_input::Builder::default()
    }
}

/// See [`ListAssessmentFrameworkShareRequestsInput`](crate::input::ListAssessmentFrameworkShareRequestsInput)
pub mod list_assessment_framework_share_requests_input {
    /// A builder for [`ListAssessmentFrameworkShareRequestsInput`](crate::input::ListAssessmentFrameworkShareRequestsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_type: std::option::Option<crate::model::ShareRequestType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> Specifies whether the share request is a sent request or a received request.</p>
        pub fn request_type(mut self, input: crate::model::ShareRequestType) -> Self {
            self.request_type = Some(input);
            self
        }
        /// <p> Specifies whether the share request is a sent request or a received request.</p>
        pub fn set_request_type(
            mut self,
            input: std::option::Option<crate::model::ShareRequestType>,
        ) -> Self {
            self.request_type = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentFrameworkShareRequestsInput`](crate::input::ListAssessmentFrameworkShareRequestsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentFrameworkShareRequestsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentFrameworkShareRequestsInput {
                request_type: self.request_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentFrameworkShareRequestsInputOperationOutputAlias =
    crate::operation::ListAssessmentFrameworkShareRequests;
#[doc(hidden)]
pub type ListAssessmentFrameworkShareRequestsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl ListAssessmentFrameworkShareRequestsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessmentFrameworkShareRequests`](crate::operation::ListAssessmentFrameworkShareRequests)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessmentFrameworkShareRequests,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentFrameworkShareRequestsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assessmentFrameworkShareRequests").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAssessmentFrameworkShareRequestsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_54) = &_input.request_type {
                query.push_kv(
                    "requestType",
                    &aws_smithy_http::query::fmt_string(&inner_54),
                );
            }
            if let Some(inner_55) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_55));
            }
            if let Some(inner_56) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_56).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentFrameworkShareRequestsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentFrameworkShareRequestsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessmentFrameworkShareRequests::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessmentFrameworkShareRequests",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentFrameworkShareRequestsInput`](crate::input::ListAssessmentFrameworkShareRequestsInput)
    pub fn builder() -> crate::input::list_assessment_framework_share_requests_input::Builder {
        crate::input::list_assessment_framework_share_requests_input::Builder::default()
    }
}

/// See [`ListAssessmentReportsInput`](crate::input::ListAssessmentReportsInput)
pub mod list_assessment_reports_input {
    /// A builder for [`ListAssessmentReportsInput`](crate::input::ListAssessmentReportsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentReportsInput`](crate::input::ListAssessmentReportsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentReportsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentReportsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentReportsInputOperationOutputAlias = crate::operation::ListAssessmentReports;
#[doc(hidden)]
pub type ListAssessmentReportsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssessmentReportsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessmentReports`](crate::operation::ListAssessmentReports)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessmentReports,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentReportsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assessmentReports").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListAssessmentReportsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_57) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_57));
            }
            if let Some(inner_58) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_58).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentReportsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentReportsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessmentReports::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessmentReports",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentReportsInput`](crate::input::ListAssessmentReportsInput)
    pub fn builder() -> crate::input::list_assessment_reports_input::Builder {
        crate::input::list_assessment_reports_input::Builder::default()
    }
}

/// See [`ListAssessmentsInput`](crate::input::ListAssessmentsInput)
pub mod list_assessments_input {
    /// A builder for [`ListAssessmentsInput`](crate::input::ListAssessmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssessmentsInput`](crate::input::ListAssessmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssessmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssessmentsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssessmentsInputOperationOutputAlias = crate::operation::ListAssessments;
#[doc(hidden)]
pub type ListAssessmentsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListAssessmentsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssessments`](crate::operation::ListAssessments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssessments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssessmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assessments").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListAssessmentsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_59) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_59));
            }
            if let Some(inner_60) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_60).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssessmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssessmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssessments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssessments",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssessmentsInput`](crate::input::ListAssessmentsInput)
    pub fn builder() -> crate::input::list_assessments_input::Builder {
        crate::input::list_assessments_input::Builder::default()
    }
}

/// See [`ListControlsInput`](crate::input::ListControlsInput)
pub mod list_controls_input {
    /// A builder for [`ListControlsInput`](crate::input::ListControlsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_type: std::option::Option<crate::model::ControlType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The type of control, such as a standard control or a custom control. </p>
        pub fn control_type(mut self, input: crate::model::ControlType) -> Self {
            self.control_type = Some(input);
            self
        }
        /// <p> The type of control, such as a standard control or a custom control. </p>
        pub fn set_control_type(
            mut self,
            input: std::option::Option<crate::model::ControlType>,
        ) -> Self {
            self.control_type = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListControlsInput`](crate::input::ListControlsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListControlsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListControlsInput {
                control_type: self.control_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListControlsInputOperationOutputAlias = crate::operation::ListControls;
#[doc(hidden)]
pub type ListControlsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListControlsInput {
    /// Consumes the builder and constructs an Operation<[`ListControls`](crate::operation::ListControls)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListControls,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListControlsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/controls").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListControlsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_61) = &_input.control_type {
                query.push_kv(
                    "controlType",
                    &aws_smithy_http::query::fmt_string(&inner_61),
                );
            }
            if let Some(inner_62) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_62));
            }
            if let Some(inner_63) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_63).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListControlsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListControlsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListControls::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListControls",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListControlsInput`](crate::input::ListControlsInput)
    pub fn builder() -> crate::input::list_controls_input::Builder {
        crate::input::list_controls_input::Builder::default()
    }
}

/// See [`ListKeywordsForDataSourceInput`](crate::input::ListKeywordsForDataSourceInput)
pub mod list_keywords_for_data_source_input {
    /// A builder for [`ListKeywordsForDataSourceInput`](crate::input::ListKeywordsForDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::SourceType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The control mapping data source that the keywords apply to. </p>
        pub fn source(mut self, input: crate::model::SourceType) -> Self {
            self.source = Some(input);
            self
        }
        /// <p> The control mapping data source that the keywords apply to. </p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::SourceType>) -> Self {
            self.source = input;
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListKeywordsForDataSourceInput`](crate::input::ListKeywordsForDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListKeywordsForDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListKeywordsForDataSourceInput {
                source: self.source,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListKeywordsForDataSourceInputOperationOutputAlias =
    crate::operation::ListKeywordsForDataSource;
#[doc(hidden)]
pub type ListKeywordsForDataSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListKeywordsForDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`ListKeywordsForDataSource`](crate::operation::ListKeywordsForDataSource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListKeywordsForDataSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListKeywordsForDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/dataSourceKeywords").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListKeywordsForDataSourceInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_64) = &_input.source {
                query.push_kv("source", &aws_smithy_http::query::fmt_string(&inner_64));
            }
            if let Some(inner_65) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_65));
            }
            if let Some(inner_66) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_66).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListKeywordsForDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListKeywordsForDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListKeywordsForDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListKeywordsForDataSource",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListKeywordsForDataSourceInput`](crate::input::ListKeywordsForDataSourceInput)
    pub fn builder() -> crate::input::list_keywords_for_data_source_input::Builder {
        crate::input::list_keywords_for_data_source_input::Builder::default()
    }
}

/// See [`ListNotificationsInput`](crate::input::ListNotificationsInput)
pub mod list_notifications_input {
    /// A builder for [`ListNotificationsInput`](crate::input::ListNotificationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that's used to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> Represents the maximum number of results on a page or for an API request call. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNotificationsInput`](crate::input::ListNotificationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNotificationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNotificationsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNotificationsInputOperationOutputAlias = crate::operation::ListNotifications;
#[doc(hidden)]
pub type ListNotificationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListNotificationsInput {
    /// Consumes the builder and constructs an Operation<[`ListNotifications`](crate::operation::ListNotifications)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNotifications,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNotificationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/notifications").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListNotificationsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_67) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_67));
            }
            if let Some(inner_68) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    &aws_smithy_types::primitive::Encoder::from(*inner_68).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNotificationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNotificationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNotifications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNotifications",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNotificationsInput`](crate::input::ListNotificationsInput)
    pub fn builder() -> crate::input::list_notifications_input::Builder {
        crate::input::list_notifications_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_69 = &_input.resource_arn;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_69, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RegisterAccountInput`](crate::input::RegisterAccountInput)
pub mod register_account_input {
    /// A builder for [`RegisterAccountInput`](crate::input::RegisterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key: std::option::Option<std::string::String>,
        pub(crate) delegated_admin_account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The KMS key details. </p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p> The KMS key details. </p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// <p> The delegated administrator account for Audit Manager. </p>
        pub fn delegated_admin_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.delegated_admin_account = Some(input.into());
            self
        }
        /// <p> The delegated administrator account for Audit Manager. </p>
        pub fn set_delegated_admin_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delegated_admin_account = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterAccountInput`](crate::input::RegisterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterAccountInput {
                kms_key: self.kms_key,
                delegated_admin_account: self.delegated_admin_account,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterAccountInputOperationOutputAlias = crate::operation::RegisterAccount;
#[doc(hidden)]
pub type RegisterAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterAccountInput {
    /// Consumes the builder and constructs an Operation<[`RegisterAccount`](crate::operation::RegisterAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account/registerAccount").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_account(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterAccount",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterAccountInput`](crate::input::RegisterAccountInput)
    pub fn builder() -> crate::input::register_account_input::Builder {
        crate::input::register_account_input::Builder::default()
    }
}

/// See [`RegisterOrganizationAdminAccountInput`](crate::input::RegisterOrganizationAdminAccountInput)
pub mod register_organization_admin_account_input {
    /// A builder for [`RegisterOrganizationAdminAccountInput`](crate::input::RegisterOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the delegated administrator account. </p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p> The identifier for the delegated administrator account. </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterOrganizationAdminAccountInput`](crate::input::RegisterOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::RegisterOrganizationAdminAccount;
#[doc(hidden)]
pub type RegisterOrganizationAdminAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`RegisterOrganizationAdminAccount`](crate::operation::RegisterOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterOrganizationAdminAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/account/registerOrganizationAdminAccount")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_register_organization_admin_account(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterOrganizationAdminAccount",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterOrganizationAdminAccountInput`](crate::input::RegisterOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::register_organization_admin_account_input::Builder {
        crate::input::register_organization_admin_account_input::Builder::default()
    }
}

/// See [`StartAssessmentFrameworkShareInput`](crate::input::StartAssessmentFrameworkShareInput)
pub mod start_assessment_framework_share_input {
    /// A builder for [`StartAssessmentFrameworkShareInput`](crate::input::StartAssessmentFrameworkShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_id: std::option::Option<std::string::String>,
        pub(crate) destination_account: std::option::Option<std::string::String>,
        pub(crate) destination_region: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for the custom framework to be shared. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the custom framework to be shared. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework_id = input;
            self
        }
        /// <p> The Amazon Web Services account of the recipient. </p>
        pub fn destination_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_account = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services account of the recipient. </p>
        pub fn set_destination_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_account = input;
            self
        }
        /// <p> The Amazon Web Services Region of the recipient. </p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_region = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services Region of the recipient. </p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_region = input;
            self
        }
        /// <p> An optional comment from the sender about the share request. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p> An optional comment from the sender about the share request. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAssessmentFrameworkShareInput`](crate::input::StartAssessmentFrameworkShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartAssessmentFrameworkShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartAssessmentFrameworkShareInput {
                framework_id: self.framework_id,
                destination_account: self.destination_account,
                destination_region: self.destination_region,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type StartAssessmentFrameworkShareInputOperationOutputAlias =
    crate::operation::StartAssessmentFrameworkShare;
#[doc(hidden)]
pub type StartAssessmentFrameworkShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartAssessmentFrameworkShareInput {
    /// Consumes the builder and constructs an Operation<[`StartAssessmentFrameworkShare`](crate::operation::StartAssessmentFrameworkShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartAssessmentFrameworkShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartAssessmentFrameworkShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_70 = &_input.framework_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "framework_id",
                        details: "cannot be empty or unset",
                    })?;
            let framework_id = aws_smithy_http::label::fmt_string(input_70, false);
            if framework_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "framework_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessmentFrameworks/{frameworkId}/shareRequests",
                frameworkId = framework_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartAssessmentFrameworkShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartAssessmentFrameworkShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_assessment_framework_share(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartAssessmentFrameworkShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartAssessmentFrameworkShare",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartAssessmentFrameworkShareInput`](crate::input::StartAssessmentFrameworkShareInput)
    pub fn builder() -> crate::input::start_assessment_framework_share_input::Builder {
        crate::input::start_assessment_framework_share_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> The tags that are associated with the resource. </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p> The tags that are associated with the resource. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.resource_arn;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_71, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the specified resource. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the specified resource. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p> The name or key of the tag. </p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p> The name or key of the tag. </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_72 = &_input.resource_arn;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_72, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_73) = &_input.tag_keys {
                for inner_74 in inner_73 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_74));
                }
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAssessmentInput`](crate::input::UpdateAssessmentInput)
pub mod update_assessment_input {
    /// A builder for [`UpdateAssessmentInput`](crate::input::UpdateAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) assessment_name: std::option::Option<std::string::String>,
        pub(crate) assessment_description: std::option::Option<std::string::String>,
        pub(crate) scope: std::option::Option<crate::model::Scope>,
        pub(crate) assessment_reports_destination:
            std::option::Option<crate::model::AssessmentReportsDestination>,
        pub(crate) roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The name of the assessment to be updated. </p>
        pub fn assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_name = Some(input.into());
            self
        }
        /// <p> The name of the assessment to be updated. </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_name = input;
            self
        }
        /// <p> The description of the assessment. </p>
        pub fn assessment_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_description = Some(input.into());
            self
        }
        /// <p> The description of the assessment. </p>
        pub fn set_assessment_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_description = input;
            self
        }
        /// <p> The scope of the assessment. </p>
        pub fn scope(mut self, input: crate::model::Scope) -> Self {
            self.scope = Some(input);
            self
        }
        /// <p> The scope of the assessment. </p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.scope = input;
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being updated.
        /// </p>
        pub fn assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.assessment_reports_destination = Some(input);
            self
        }
        /// <p> The assessment report storage destination for the assessment that's being updated.
        /// </p>
        pub fn set_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.assessment_reports_destination = input;
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p> The list of roles for the assessment. </p>
        pub fn roles(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.roles.unwrap_or_default();
            v.push(input.into());
            self.roles = Some(v);
            self
        }
        /// <p> The list of roles for the assessment. </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.roles = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentInput`](crate::input::UpdateAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssessmentInput {
                assessment_id: self.assessment_id,
                assessment_name: self.assessment_name,
                assessment_description: self.assessment_description,
                scope: self.scope,
                assessment_reports_destination: self.assessment_reports_destination,
                roles: self.roles,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssessmentInputOperationOutputAlias = crate::operation::UpdateAssessment;
#[doc(hidden)]
pub type UpdateAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssessment`](crate::operation::UpdateAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.assessment_id;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_75, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_assessment(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssessment",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentInput`](crate::input::UpdateAssessmentInput)
    pub fn builder() -> crate::input::update_assessment_input::Builder {
        crate::input::update_assessment_input::Builder::default()
    }
}

/// See [`UpdateAssessmentControlInput`](crate::input::UpdateAssessmentControlInput)
pub mod update_assessment_control_input {
    /// A builder for [`UpdateAssessmentControlInput`](crate::input::UpdateAssessmentControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) control_id: std::option::Option<std::string::String>,
        pub(crate) control_status: std::option::Option<crate::model::ControlStatus>,
        pub(crate) comment_body: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// <p> The status of the control. </p>
        pub fn control_status(mut self, input: crate::model::ControlStatus) -> Self {
            self.control_status = Some(input);
            self
        }
        /// <p> The status of the control. </p>
        pub fn set_control_status(
            mut self,
            input: std::option::Option<crate::model::ControlStatus>,
        ) -> Self {
            self.control_status = input;
            self
        }
        /// <p> The comment body text for the control. </p>
        pub fn comment_body(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_body = Some(input.into());
            self
        }
        /// <p> The comment body text for the control. </p>
        pub fn set_comment_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_body = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentControlInput`](crate::input::UpdateAssessmentControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssessmentControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssessmentControlInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                control_id: self.control_id,
                control_status: self.control_status,
                comment_body: self.comment_body,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssessmentControlInputOperationOutputAlias =
    crate::operation::UpdateAssessmentControl;
#[doc(hidden)]
pub type UpdateAssessmentControlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssessmentControlInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssessmentControl`](crate::operation::UpdateAssessmentControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssessmentControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssessmentControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_76 = &_input.assessment_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_76, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_77 = &_input.control_set_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_set_id = aws_smithy_http::label::fmt_string(input_77, false);
            if control_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_set_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_78 = &_input.control_id;
            let input_78 =
                input_78
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_id = aws_smithy_http::label::fmt_string(input_78, false);
            if control_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}",
                assessmentId = assessment_id,
                controlSetId = control_set_id,
                controlId = control_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssessmentControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssessmentControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_assessment_control(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssessmentControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssessmentControl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentControlInput`](crate::input::UpdateAssessmentControlInput)
    pub fn builder() -> crate::input::update_assessment_control_input::Builder {
        crate::input::update_assessment_control_input::Builder::default()
    }
}

/// See [`UpdateAssessmentControlSetStatusInput`](crate::input::UpdateAssessmentControlSetStatusInput)
pub mod update_assessment_control_set_status_input {
    /// A builder for [`UpdateAssessmentControlSetStatusInput`](crate::input::UpdateAssessmentControlSetStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) control_set_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ControlSetStatus>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn control_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_set_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control set. </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_set_id = input;
            self
        }
        /// <p> The status of the control set that's being updated. </p>
        pub fn status(mut self, input: crate::model::ControlSetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of the control set that's being updated. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ControlSetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The comment that's related to the status update. </p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p> The comment that's related to the status update. </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentControlSetStatusInput`](crate::input::UpdateAssessmentControlSetStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssessmentControlSetStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssessmentControlSetStatusInput {
                assessment_id: self.assessment_id,
                control_set_id: self.control_set_id,
                status: self.status,
                comment: self.comment,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssessmentControlSetStatusInputOperationOutputAlias =
    crate::operation::UpdateAssessmentControlSetStatus;
#[doc(hidden)]
pub type UpdateAssessmentControlSetStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssessmentControlSetStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssessmentControlSetStatus`](crate::operation::UpdateAssessmentControlSetStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssessmentControlSetStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssessmentControlSetStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_79 = &_input.assessment_id;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_79, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_80 = &_input.control_set_id;
            let input_80 =
                input_80
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_set_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_set_id = aws_smithy_http::label::fmt_string(input_80, false);
            if control_set_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_set_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/controlSets/{controlSetId}/status",
                assessmentId = assessment_id,
                controlSetId = control_set_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssessmentControlSetStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssessmentControlSetStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_assessment_control_set_status(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssessmentControlSetStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssessmentControlSetStatus",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentControlSetStatusInput`](crate::input::UpdateAssessmentControlSetStatusInput)
    pub fn builder() -> crate::input::update_assessment_control_set_status_input::Builder {
        crate::input::update_assessment_control_set_status_input::Builder::default()
    }
}

/// See [`UpdateAssessmentFrameworkInput`](crate::input::UpdateAssessmentFrameworkInput)
pub mod update_assessment_framework_input {
    /// A builder for [`UpdateAssessmentFrameworkInput`](crate::input::UpdateAssessmentFrameworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framework_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) compliance_type: std::option::Option<std::string::String>,
        pub(crate) control_sets:
            std::option::Option<std::vec::Vec<crate::model::UpdateAssessmentFrameworkControlSet>>,
    }
    impl Builder {
        /// <p> The identifier for the framework. </p>
        pub fn framework_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_id = Some(input.into());
            self
        }
        /// <p> The identifier for the framework. </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.framework_id = input;
            self
        }
        /// <p> The name of the framework to be updated. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the framework to be updated. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The description of the updated framework. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The description of the updated framework. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn compliance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.compliance_type = Some(input.into());
            self
        }
        /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.compliance_type = input;
            self
        }
        /// Appends an item to `control_sets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p> The control sets that are associated with the framework. </p>
        pub fn control_sets(
            mut self,
            input: impl Into<crate::model::UpdateAssessmentFrameworkControlSet>,
        ) -> Self {
            let mut v = self.control_sets.unwrap_or_default();
            v.push(input.into());
            self.control_sets = Some(v);
            self
        }
        /// <p> The control sets that are associated with the framework. </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::UpdateAssessmentFrameworkControlSet>,
            >,
        ) -> Self {
            self.control_sets = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentFrameworkInput`](crate::input::UpdateAssessmentFrameworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssessmentFrameworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssessmentFrameworkInput {
                framework_id: self.framework_id,
                name: self.name,
                description: self.description,
                compliance_type: self.compliance_type,
                control_sets: self.control_sets,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssessmentFrameworkInputOperationOutputAlias =
    crate::operation::UpdateAssessmentFramework;
#[doc(hidden)]
pub type UpdateAssessmentFrameworkInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssessmentFrameworkInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssessmentFramework`](crate::operation::UpdateAssessmentFramework)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssessmentFramework,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssessmentFrameworkInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_81 = &_input.framework_id;
            let input_81 =
                input_81
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "framework_id",
                        details: "cannot be empty or unset",
                    })?;
            let framework_id = aws_smithy_http::label::fmt_string(input_81, false);
            if framework_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "framework_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessmentFrameworks/{frameworkId}",
                frameworkId = framework_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssessmentFrameworkInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssessmentFrameworkInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_assessment_framework(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssessmentFramework::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssessmentFramework",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentFrameworkInput`](crate::input::UpdateAssessmentFrameworkInput)
    pub fn builder() -> crate::input::update_assessment_framework_input::Builder {
        crate::input::update_assessment_framework_input::Builder::default()
    }
}

/// See [`UpdateAssessmentFrameworkShareInput`](crate::input::UpdateAssessmentFrameworkShareInput)
pub mod update_assessment_framework_share_input {
    /// A builder for [`UpdateAssessmentFrameworkShareInput`](crate::input::UpdateAssessmentFrameworkShareInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) request_id: std::option::Option<std::string::String>,
        pub(crate) request_type: std::option::Option<crate::model::ShareRequestType>,
        pub(crate) action: std::option::Option<crate::model::ShareRequestAction>,
    }
    impl Builder {
        /// <p> The unique identifier for the share request. </p>
        pub fn request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_id = Some(input.into());
            self
        }
        /// <p> The unique identifier for the share request. </p>
        pub fn set_request_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.request_id = input;
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn request_type(mut self, input: crate::model::ShareRequestType) -> Self {
            self.request_type = Some(input);
            self
        }
        /// <p>Specifies whether the share request is a sent request or a received request.</p>
        pub fn set_request_type(
            mut self,
            input: std::option::Option<crate::model::ShareRequestType>,
        ) -> Self {
            self.request_type = input;
            self
        }
        /// <p>Specifies the update action for the share request.</p>
        pub fn action(mut self, input: crate::model::ShareRequestAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Specifies the update action for the share request.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::ShareRequestAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentFrameworkShareInput`](crate::input::UpdateAssessmentFrameworkShareInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssessmentFrameworkShareInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssessmentFrameworkShareInput {
                request_id: self.request_id,
                request_type: self.request_type,
                action: self.action,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssessmentFrameworkShareInputOperationOutputAlias =
    crate::operation::UpdateAssessmentFrameworkShare;
#[doc(hidden)]
pub type UpdateAssessmentFrameworkShareInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssessmentFrameworkShareInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssessmentFrameworkShare`](crate::operation::UpdateAssessmentFrameworkShare)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssessmentFrameworkShare,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssessmentFrameworkShareInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_82 = &_input.request_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "request_id",
                        details: "cannot be empty or unset",
                    })?;
            let request_id = aws_smithy_http::label::fmt_string(input_82, false);
            if request_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "request_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessmentFrameworkShareRequests/{requestId}",
                requestId = request_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssessmentFrameworkShareInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssessmentFrameworkShareInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_assessment_framework_share(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssessmentFrameworkShare::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssessmentFrameworkShare",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentFrameworkShareInput`](crate::input::UpdateAssessmentFrameworkShareInput)
    pub fn builder() -> crate::input::update_assessment_framework_share_input::Builder {
        crate::input::update_assessment_framework_share_input::Builder::default()
    }
}

/// See [`UpdateAssessmentStatusInput`](crate::input::UpdateAssessmentStatusInput)
pub mod update_assessment_status_input {
    /// A builder for [`UpdateAssessmentStatusInput`](crate::input::UpdateAssessmentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assessment_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AssessmentStatus>,
    }
    impl Builder {
        /// <p> The identifier for the assessment. </p>
        pub fn assessment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_id = Some(input.into());
            self
        }
        /// <p> The identifier for the assessment. </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_id = input;
            self
        }
        /// <p> The current status of the assessment. </p>
        pub fn status(mut self, input: crate::model::AssessmentStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current status of the assessment. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAssessmentStatusInput`](crate::input::UpdateAssessmentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAssessmentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAssessmentStatusInput {
                assessment_id: self.assessment_id,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAssessmentStatusInputOperationOutputAlias = crate::operation::UpdateAssessmentStatus;
#[doc(hidden)]
pub type UpdateAssessmentStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateAssessmentStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAssessmentStatus`](crate::operation::UpdateAssessmentStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAssessmentStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAssessmentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.assessment_id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "assessment_id",
                        details: "cannot be empty or unset",
                    })?;
            let assessment_id = aws_smithy_http::label::fmt_string(input_83, false);
            if assessment_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "assessment_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/assessments/{assessmentId}/status",
                assessmentId = assessment_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAssessmentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAssessmentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_assessment_status(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAssessmentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAssessmentStatus",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentStatusInput`](crate::input::UpdateAssessmentStatusInput)
    pub fn builder() -> crate::input::update_assessment_status_input::Builder {
        crate::input::update_assessment_status_input::Builder::default()
    }
}

/// See [`UpdateControlInput`](crate::input::UpdateControlInput)
pub mod update_control_input {
    /// A builder for [`UpdateControlInput`](crate::input::UpdateControlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) control_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) testing_information: std::option::Option<std::string::String>,
        pub(crate) action_plan_title: std::option::Option<std::string::String>,
        pub(crate) action_plan_instructions: std::option::Option<std::string::String>,
        pub(crate) control_mapping_sources:
            std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
    }
    impl Builder {
        /// <p> The identifier for the control. </p>
        pub fn control_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_id = Some(input.into());
            self
        }
        /// <p> The identifier for the control. </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.control_id = input;
            self
        }
        /// <p> The name of the updated control. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the updated control. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The optional description of the control. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p> The optional description of the control. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p> The steps that you should follow to determine if the control is met. </p>
        pub fn testing_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.testing_information = Some(input.into());
            self
        }
        /// <p> The steps that you should follow to determine if the control is met. </p>
        pub fn set_testing_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.testing_information = input;
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn action_plan_title(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_plan_title = Some(input.into());
            self
        }
        /// <p> The title of the action plan for remediating the control. </p>
        pub fn set_action_plan_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_plan_title = input;
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn action_plan_instructions(mut self, input: impl Into<std::string::String>) -> Self {
            self.action_plan_instructions = Some(input.into());
            self
        }
        /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
        pub fn set_action_plan_instructions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.action_plan_instructions = input;
            self
        }
        /// Appends an item to `control_mapping_sources`.
        ///
        /// To override the contents of this collection use [`set_control_mapping_sources`](Self::set_control_mapping_sources).
        ///
        /// <p> The data mapping sources for the control. </p>
        pub fn control_mapping_sources(
            mut self,
            input: impl Into<crate::model::ControlMappingSource>,
        ) -> Self {
            let mut v = self.control_mapping_sources.unwrap_or_default();
            v.push(input.into());
            self.control_mapping_sources = Some(v);
            self
        }
        /// <p> The data mapping sources for the control. </p>
        pub fn set_control_mapping_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
        ) -> Self {
            self.control_mapping_sources = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateControlInput`](crate::input::UpdateControlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateControlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateControlInput {
                control_id: self.control_id,
                name: self.name,
                description: self.description,
                testing_information: self.testing_information,
                action_plan_title: self.action_plan_title,
                action_plan_instructions: self.action_plan_instructions,
                control_mapping_sources: self.control_mapping_sources,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateControlInputOperationOutputAlias = crate::operation::UpdateControl;
#[doc(hidden)]
pub type UpdateControlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateControlInput {
    /// Consumes the builder and constructs an Operation<[`UpdateControl`](crate::operation::UpdateControl)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateControl,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateControlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_84 = &_input.control_id;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "control_id",
                        details: "cannot be empty or unset",
                    })?;
            let control_id = aws_smithy_http::label::fmt_string(input_84, false);
            if control_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "control_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/controls/{controlId}", controlId = control_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateControlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateControlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_control(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateControl::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateControl",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateControlInput`](crate::input::UpdateControlInput)
    pub fn builder() -> crate::input::update_control_input::Builder {
        crate::input::update_control_input::Builder::default()
    }
}

/// See [`UpdateSettingsInput`](crate::input::UpdateSettingsInput)
pub mod update_settings_input {
    /// A builder for [`UpdateSettingsInput`](crate::input::UpdateSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_topic: std::option::Option<std::string::String>,
        pub(crate) default_assessment_reports_destination:
            std::option::Option<crate::model::AssessmentReportsDestination>,
        pub(crate) default_process_owners: std::option::Option<std::vec::Vec<crate::model::Role>>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends
        /// notifications to. </p>
        pub fn sns_topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic = Some(input.into());
            self
        }
        /// <p> The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends
        /// notifications to. </p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sns_topic = input;
            self
        }
        /// <p> The default storage destination for assessment reports. </p>
        pub fn default_assessment_reports_destination(
            mut self,
            input: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.default_assessment_reports_destination = Some(input);
            self
        }
        /// <p> The default storage destination for assessment reports. </p>
        pub fn set_default_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.default_assessment_reports_destination = input;
            self
        }
        /// Appends an item to `default_process_owners`.
        ///
        /// To override the contents of this collection use [`set_default_process_owners`](Self::set_default_process_owners).
        ///
        /// <p> A list of the default audit owners. </p>
        pub fn default_process_owners(mut self, input: impl Into<crate::model::Role>) -> Self {
            let mut v = self.default_process_owners.unwrap_or_default();
            v.push(input.into());
            self.default_process_owners = Some(v);
            self
        }
        /// <p> A list of the default audit owners. </p>
        pub fn set_default_process_owners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.default_process_owners = input;
            self
        }
        /// <p> The KMS key details. </p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p> The KMS key details. </p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateSettingsInput`](crate::input::UpdateSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateSettingsInput {
                sns_topic: self.sns_topic,
                default_assessment_reports_destination: self.default_assessment_reports_destination,
                default_process_owners: self.default_process_owners,
                kms_key: self.kms_key,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateSettingsInputOperationOutputAlias = crate::operation::UpdateSettings;
#[doc(hidden)]
pub type UpdateSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateSettings`](crate::operation::UpdateSettings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/settings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_settings(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateSettings",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateSettingsInput`](crate::input::UpdateSettingsInput)
    pub fn builder() -> crate::input::update_settings_input::Builder {
        crate::input::update_settings_input::Builder::default()
    }
}

/// See [`ValidateAssessmentReportIntegrityInput`](crate::input::ValidateAssessmentReportIntegrityInput)
pub mod validate_assessment_report_integrity_input {
    /// A builder for [`ValidateAssessmentReportIntegrityInput`](crate::input::ValidateAssessmentReportIntegrityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_relative_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The relative path of the Amazon S3 bucket that the assessment report is stored
        /// in. </p>
        pub fn s3_relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_relative_path = Some(input.into());
            self
        }
        /// <p> The relative path of the Amazon S3 bucket that the assessment report is stored
        /// in. </p>
        pub fn set_s3_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_relative_path = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidateAssessmentReportIntegrityInput`](crate::input::ValidateAssessmentReportIntegrityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ValidateAssessmentReportIntegrityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ValidateAssessmentReportIntegrityInput {
                s3_relative_path: self.s3_relative_path,
            })
        }
    }
}
#[doc(hidden)]
pub type ValidateAssessmentReportIntegrityInputOperationOutputAlias =
    crate::operation::ValidateAssessmentReportIntegrity;
#[doc(hidden)]
pub type ValidateAssessmentReportIntegrityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ValidateAssessmentReportIntegrityInput {
    /// Consumes the builder and constructs an Operation<[`ValidateAssessmentReportIntegrity`](crate::operation::ValidateAssessmentReportIntegrity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ValidateAssessmentReportIntegrity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ValidateAssessmentReportIntegrityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/assessmentReports/integrity").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ValidateAssessmentReportIntegrityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ValidateAssessmentReportIntegrityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_validate_assessment_report_integrity(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ValidateAssessmentReportIntegrity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ValidateAssessmentReportIntegrity",
            "auditmanager",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ValidateAssessmentReportIntegrityInput`](crate::input::ValidateAssessmentReportIntegrityInput)
    pub fn builder() -> crate::input::validate_assessment_report_integrity_input::Builder {
        crate::input::validate_assessment_report_integrity_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidateAssessmentReportIntegrityInput {
    /// <p> The relative path of the Amazon S3 bucket that the assessment report is stored
    /// in. </p>
    pub s3_relative_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidateAssessmentReportIntegrityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidateAssessmentReportIntegrityInput");
        formatter.field("s3_relative_path", &self.s3_relative_path);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateSettingsInput {
    /// <p> The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends
    /// notifications to. </p>
    pub sns_topic: std::option::Option<std::string::String>,
    /// <p> The default storage destination for assessment reports. </p>
    pub default_assessment_reports_destination:
        std::option::Option<crate::model::AssessmentReportsDestination>,
    /// <p> A list of the default audit owners. </p>
    pub default_process_owners: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p> The KMS key details. </p>
    pub kms_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateSettingsInput");
        formatter.field("sns_topic", &self.sns_topic);
        formatter.field(
            "default_assessment_reports_destination",
            &self.default_assessment_reports_destination,
        );
        formatter.field("default_process_owners", &self.default_process_owners);
        formatter.field("kms_key", &self.kms_key);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateControlInput {
    /// <p> The identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
    /// <p> The name of the updated control. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The optional description of the control. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The steps that you should follow to determine if the control is met. </p>
    pub testing_information: std::option::Option<std::string::String>,
    /// <p> The title of the action plan for remediating the control. </p>
    pub action_plan_title: std::option::Option<std::string::String>,
    /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
    pub action_plan_instructions: std::option::Option<std::string::String>,
    /// <p> The data mapping sources for the control. </p>
    pub control_mapping_sources:
        std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
}
impl std::fmt::Debug for UpdateControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateControlInput");
        formatter.field("control_id", &self.control_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("testing_information", &self.testing_information);
        formatter.field("action_plan_title", &self.action_plan_title);
        formatter.field("action_plan_instructions", &self.action_plan_instructions);
        formatter.field("control_mapping_sources", &self.control_mapping_sources);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentStatusInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The current status of the assessment. </p>
    pub status: std::option::Option<crate::model::AssessmentStatus>,
}
impl std::fmt::Debug for UpdateAssessmentStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentStatusInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentFrameworkShareInput {
    /// <p> The unique identifier for the share request. </p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the share request is a sent request or a received request.</p>
    pub request_type: std::option::Option<crate::model::ShareRequestType>,
    /// <p>Specifies the update action for the share request.</p>
    pub action: std::option::Option<crate::model::ShareRequestAction>,
}
impl std::fmt::Debug for UpdateAssessmentFrameworkShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentFrameworkShareInput");
        formatter.field("request_id", &self.request_id);
        formatter.field("request_type", &self.request_type);
        formatter.field("action", &self.action);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentFrameworkInput {
    /// <p> The identifier for the framework. </p>
    pub framework_id: std::option::Option<std::string::String>,
    /// <p> The name of the framework to be updated. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the updated framework. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
    /// </p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p> The control sets that are associated with the framework. </p>
    pub control_sets:
        std::option::Option<std::vec::Vec<crate::model::UpdateAssessmentFrameworkControlSet>>,
}
impl std::fmt::Debug for UpdateAssessmentFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentFrameworkInput");
        formatter.field("framework_id", &self.framework_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("control_sets", &self.control_sets);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentControlSetStatusInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The status of the control set that's being updated. </p>
    pub status: std::option::Option<crate::model::ControlSetStatus>,
    /// <p> The comment that's related to the status update. </p>
    pub comment: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateAssessmentControlSetStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentControlSetStatusInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("status", &self.status);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentControlInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
    /// <p> The status of the control. </p>
    pub control_status: std::option::Option<crate::model::ControlStatus>,
    /// <p> The comment body text for the control. </p>
    pub comment_body: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateAssessmentControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentControlInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("control_id", &self.control_id);
        formatter.field("control_status", &self.control_status);
        formatter.field("comment_body", &self.comment_body);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAssessmentInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The name of the assessment to be updated. </p>
    pub assessment_name: std::option::Option<std::string::String>,
    /// <p> The description of the assessment. </p>
    pub assessment_description: std::option::Option<std::string::String>,
    /// <p> The scope of the assessment. </p>
    pub scope: std::option::Option<crate::model::Scope>,
    /// <p> The assessment report storage destination for the assessment that's being updated.
    /// </p>
    pub assessment_reports_destination:
        std::option::Option<crate::model::AssessmentReportsDestination>,
    /// <p> The list of roles for the assessment. </p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
}
impl std::fmt::Debug for UpdateAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAssessmentInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("assessment_name", &self.assessment_name);
        formatter.field("assessment_description", &self.assessment_description);
        formatter.field("scope", &self.scope);
        formatter.field(
            "assessment_reports_destination",
            &self.assessment_reports_destination,
        );
        formatter.field("roles", &self.roles);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the specified resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The name or key of the tag. </p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p> The tags that are associated with the resource. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAssessmentFrameworkShareInput {
    /// <p> The unique identifier for the custom framework to be shared. </p>
    pub framework_id: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services account of the recipient. </p>
    pub destination_account: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services Region of the recipient. </p>
    pub destination_region: std::option::Option<std::string::String>,
    /// <p> An optional comment from the sender about the share request. </p>
    pub comment: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartAssessmentFrameworkShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAssessmentFrameworkShareInput");
        formatter.field("framework_id", &self.framework_id);
        formatter.field("destination_account", &self.destination_account);
        formatter.field("destination_region", &self.destination_region);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterOrganizationAdminAccountInput {
    /// <p> The identifier for the delegated administrator account. </p>
    pub admin_account_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegisterOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterAccountInput {
    /// <p> The KMS key details. </p>
    pub kms_key: std::option::Option<std::string::String>,
    /// <p> The delegated administrator account for Audit Manager. </p>
    pub delegated_admin_account: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegisterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterAccountInput");
        formatter.field("kms_key", &self.kms_key);
        formatter.field("delegated_admin_account", &self.delegated_admin_account);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p> The Amazon Resource Name (ARN) of the resource. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNotificationsInput {
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListNotificationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNotificationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListKeywordsForDataSourceInput {
    /// <p> The control mapping data source that the keywords apply to. </p>
    pub source: std::option::Option<crate::model::SourceType>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListKeywordsForDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListKeywordsForDataSourceInput");
        formatter.field("source", &self.source);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListControlsInput {
    /// <p> The type of control, such as a standard control or a custom control. </p>
    pub control_type: std::option::Option<crate::model::ControlType>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListControlsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListControlsInput");
        formatter.field("control_type", &self.control_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentsInput {
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListAssessmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentReportsInput {
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListAssessmentReportsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentReportsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentFrameworkShareRequestsInput {
    /// <p> Specifies whether the share request is a sent request or a received request.</p>
    pub request_type: std::option::Option<crate::model::ShareRequestType>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListAssessmentFrameworkShareRequestsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentFrameworkShareRequestsInput");
        formatter.field("request_type", &self.request_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssessmentFrameworksInput {
    /// <p> The type of framework, such as a standard framework or a custom framework. </p>
    pub framework_type: std::option::Option<crate::model::FrameworkType>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for ListAssessmentFrameworksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssessmentFrameworksInput");
        formatter.field("framework_type", &self.framework_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSettingsInput {
    /// <p> The list of <code>SettingAttribute</code> enum values. </p>
    pub attribute: std::option::Option<crate::model::SettingAttribute>,
}
impl std::fmt::Debug for GetSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSettingsInput");
        formatter.field("attribute", &self.attribute);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServicesInScopeInput {}
impl std::fmt::Debug for GetServicesInScopeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServicesInScopeInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetOrganizationAdminAccountInput {}
impl std::fmt::Debug for GetOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetOrganizationAdminAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceFoldersByAssessmentControlInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetEvidenceFoldersByAssessmentControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceFoldersByAssessmentControlInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("control_id", &self.control_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceFoldersByAssessmentInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetEvidenceFoldersByAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceFoldersByAssessmentInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceFolderInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder that the evidence is stored in. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEvidenceFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceFolderInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceByEvidenceFolderInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the folder that the evidence is stored in. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetEvidenceByEvidenceFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceByEvidenceFolderInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvidenceInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder that the evidence is stored in. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the evidence. </p>
    pub evidence_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetEvidenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvidenceInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.field("evidence_id", &self.evidence_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDelegationsInput {
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetDelegationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDelegationsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetControlInput {
    /// <p> The identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetControlInput");
        formatter.field("control_id", &self.control_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetChangeLogsInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
    /// <p> The pagination token that's used to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> Represents the maximum number of results on a page or for an API request call. </p>
    pub max_results: std::option::Option<i32>,
}
impl std::fmt::Debug for GetChangeLogsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetChangeLogsInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("control_id", &self.control_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssessmentReportUrlInput {
    /// <p> The identifier for the assessment report. </p>
    pub assessment_report_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAssessmentReportUrlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssessmentReportUrlInput");
        formatter.field("assessment_report_id", &self.assessment_report_id);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssessmentFrameworkInput {
    /// <p> The identifier for the framework. </p>
    pub framework_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAssessmentFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssessmentFrameworkInput");
        formatter.field("framework_id", &self.framework_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAssessmentInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAssessmentInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccountStatusInput {}
impl std::fmt::Debug for GetAccountStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccountStatusInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateAssessmentReportEvidenceFolderInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder in which evidence is stored. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DisassociateAssessmentReportEvidenceFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateAssessmentReportEvidenceFolderInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterOrganizationAdminAccountInput {
    /// <p> The identifier for the administrator account. </p>
    pub admin_account_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeregisterOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterAccountInput {}
impl std::fmt::Debug for DeregisterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteControlInput {
    /// <p> The identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteControlInput");
        formatter.field("control_id", &self.control_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentReportInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The unique identifier for the assessment report. </p>
    pub assessment_report_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteAssessmentReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentReportInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("assessment_report_id", &self.assessment_report_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentFrameworkShareInput {
    /// <p>The unique identifier for the share request to be deleted.</p>
    pub request_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the share request is a sent request or a received request.</p>
    pub request_type: std::option::Option<crate::model::ShareRequestType>,
}
impl std::fmt::Debug for DeleteAssessmentFrameworkShareInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentFrameworkShareInput");
        formatter.field("request_id", &self.request_id);
        formatter.field("request_type", &self.request_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentFrameworkInput {
    /// <p> The identifier for the framework. </p>
    pub framework_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteAssessmentFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentFrameworkInput");
        formatter.field("framework_id", &self.framework_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAssessmentInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAssessmentInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateControlInput {
    /// <p> The name of the control. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the control. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The steps to follow to determine if the control is satisfied. </p>
    pub testing_information: std::option::Option<std::string::String>,
    /// <p> The title of the action plan for remediating the control. </p>
    pub action_plan_title: std::option::Option<std::string::String>,
    /// <p> The recommended actions to carry out if the control isn't fulfilled. </p>
    pub action_plan_instructions: std::option::Option<std::string::String>,
    /// <p> The data mapping sources for the control. </p>
    pub control_mapping_sources:
        std::option::Option<std::vec::Vec<crate::model::CreateControlMappingSource>>,
    /// <p> The tags that are associated with the control. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateControlInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("testing_information", &self.testing_information);
        formatter.field("action_plan_title", &self.action_plan_title);
        formatter.field("action_plan_instructions", &self.action_plan_instructions);
        formatter.field("control_mapping_sources", &self.control_mapping_sources);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentReportInput {
    /// <p> The name of the new assessment report. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The description of the assessment report. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAssessmentReportInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentReportInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentFrameworkInput {
    /// <p> The name of the new custom framework. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> An optional description for the new custom framework. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The compliance type that the new custom framework supports, such as CIS or HIPAA.
    /// </p>
    pub compliance_type: std::option::Option<std::string::String>,
    /// <p> The control sets that are associated with the framework. </p>
    pub control_sets:
        std::option::Option<std::vec::Vec<crate::model::CreateAssessmentFrameworkControlSet>>,
    /// <p> The tags that are associated with the framework. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateAssessmentFrameworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentFrameworkInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("compliance_type", &self.compliance_type);
        formatter.field("control_sets", &self.control_sets);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAssessmentInput {
    /// <p> The name of the assessment to be created. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The optional description of the assessment to be created. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> The assessment report storage destination for the assessment that's being created. </p>
    pub assessment_reports_destination:
        std::option::Option<crate::model::AssessmentReportsDestination>,
    /// <p> The wrapper that contains the Amazon Web Services accounts and services that are in
    /// scope for the assessment. </p>
    pub scope: std::option::Option<crate::model::Scope>,
    /// <p> The list of roles for the assessment. </p>
    pub roles: std::option::Option<std::vec::Vec<crate::model::Role>>,
    /// <p> The identifier for the framework that the assessment will be created from. </p>
    pub framework_id: std::option::Option<std::string::String>,
    /// <p> The tags that are associated with the assessment. </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for CreateAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAssessmentInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field(
            "assessment_reports_destination",
            &self.assessment_reports_destination,
        );
        formatter.field("scope", &self.scope);
        formatter.field("roles", &self.roles);
        formatter.field("framework_id", &self.framework_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchImportEvidenceToAssessmentControlInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control set. </p>
    pub control_set_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the control. </p>
    pub control_id: std::option::Option<std::string::String>,
    /// <p> The list of manual evidence objects. </p>
    pub manual_evidence: std::option::Option<std::vec::Vec<crate::model::ManualEvidence>>,
}
impl std::fmt::Debug for BatchImportEvidenceToAssessmentControlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchImportEvidenceToAssessmentControlInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("control_set_id", &self.control_set_id);
        formatter.field("control_id", &self.control_id);
        formatter.field("manual_evidence", &self.manual_evidence);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateAssessmentReportEvidenceInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder that the evidence is stored in. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
    /// <p> The list of evidence identifiers. </p>
    pub evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchDisassociateAssessmentReportEvidenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateAssessmentReportEvidenceInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.field("evidence_ids", &self.evidence_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDelegationByAssessmentInput {
    /// <p> The identifiers for the delegations. </p>
    pub delegation_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchDeleteDelegationByAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDelegationByAssessmentInput");
        formatter.field("delegation_ids", &self.delegation_ids);
        formatter.field("assessment_id", &self.assessment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchCreateDelegationByAssessmentInput {
    /// <p> The API request to batch create delegations in Audit Manager. </p>
    pub create_delegation_requests:
        std::option::Option<std::vec::Vec<crate::model::CreateDelegationRequest>>,
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchCreateDelegationByAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchCreateDelegationByAssessmentInput");
        formatter.field(
            "create_delegation_requests",
            &self.create_delegation_requests,
        );
        formatter.field("assessment_id", &self.assessment_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateAssessmentReportEvidenceInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder that the evidence is stored in. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
    /// <p> The list of evidence identifiers. </p>
    pub evidence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchAssociateAssessmentReportEvidenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateAssessmentReportEvidenceInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.field("evidence_ids", &self.evidence_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateAssessmentReportEvidenceFolderInput {
    /// <p> The identifier for the assessment. </p>
    pub assessment_id: std::option::Option<std::string::String>,
    /// <p> The identifier for the folder that the evidence is stored in. </p>
    pub evidence_folder_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AssociateAssessmentReportEvidenceFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateAssessmentReportEvidenceFolderInput");
        formatter.field("assessment_id", &self.assessment_id);
        formatter.field("evidence_folder_id", &self.evidence_folder_id);
        formatter.finish()
    }
}
