// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateAssessmentReportEvidenceFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_assessment_report_evidence_folder`](crate::client::Client::associate_assessment_report_evidence_folder).
///
/// See [`crate::client::fluent_builders::AssociateAssessmentReportEvidenceFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateAssessmentReportEvidenceFolder {
    _private: (),
}
impl AssociateAssessmentReportEvidenceFolder {
    /// Creates a new builder-style object to manufacture [`AssociateAssessmentReportEvidenceFolderInput`](crate::input::AssociateAssessmentReportEvidenceFolderInput)
    pub fn builder() -> crate::input::associate_assessment_report_evidence_folder_input::Builder {
        crate::input::associate_assessment_report_evidence_folder_input::Builder::default()
    }
    /// Creates a new `AssociateAssessmentReportEvidenceFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateAssessmentReportEvidenceFolder {
    type Output = std::result::Result<
        crate::output::AssociateAssessmentReportEvidenceFolderOutput,
        crate::error::AssociateAssessmentReportEvidenceFolderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_assessment_report_evidence_folder_error(
                response,
            )
        } else {
            crate::operation_deser::parse_associate_assessment_report_evidence_folder_response(
                response,
            )
        }
    }
}

/// Operation shape for `BatchAssociateAssessmentReportEvidence`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_associate_assessment_report_evidence`](crate::client::Client::batch_associate_assessment_report_evidence).
///
/// See [`crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchAssociateAssessmentReportEvidence {
    _private: (),
}
impl BatchAssociateAssessmentReportEvidence {
    /// Creates a new builder-style object to manufacture [`BatchAssociateAssessmentReportEvidenceInput`](crate::input::BatchAssociateAssessmentReportEvidenceInput)
    pub fn builder() -> crate::input::batch_associate_assessment_report_evidence_input::Builder {
        crate::input::batch_associate_assessment_report_evidence_input::Builder::default()
    }
    /// Creates a new `BatchAssociateAssessmentReportEvidence` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchAssociateAssessmentReportEvidence {
    type Output = std::result::Result<
        crate::output::BatchAssociateAssessmentReportEvidenceOutput,
        crate::error::BatchAssociateAssessmentReportEvidenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_associate_assessment_report_evidence_error(response)
        } else {
            crate::operation_deser::parse_batch_associate_assessment_report_evidence_response(
                response,
            )
        }
    }
}

/// Operation shape for `BatchCreateDelegationByAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_create_delegation_by_assessment`](crate::client::Client::batch_create_delegation_by_assessment).
///
/// See [`crate::client::fluent_builders::BatchCreateDelegationByAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchCreateDelegationByAssessment {
    _private: (),
}
impl BatchCreateDelegationByAssessment {
    /// Creates a new builder-style object to manufacture [`BatchCreateDelegationByAssessmentInput`](crate::input::BatchCreateDelegationByAssessmentInput)
    pub fn builder() -> crate::input::batch_create_delegation_by_assessment_input::Builder {
        crate::input::batch_create_delegation_by_assessment_input::Builder::default()
    }
    /// Creates a new `BatchCreateDelegationByAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchCreateDelegationByAssessment {
    type Output = std::result::Result<
        crate::output::BatchCreateDelegationByAssessmentOutput,
        crate::error::BatchCreateDelegationByAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_create_delegation_by_assessment_error(response)
        } else {
            crate::operation_deser::parse_batch_create_delegation_by_assessment_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteDelegationByAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_delegation_by_assessment`](crate::client::Client::batch_delete_delegation_by_assessment).
///
/// See [`crate::client::fluent_builders::BatchDeleteDelegationByAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteDelegationByAssessment {
    _private: (),
}
impl BatchDeleteDelegationByAssessment {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDelegationByAssessmentInput`](crate::input::BatchDeleteDelegationByAssessmentInput)
    pub fn builder() -> crate::input::batch_delete_delegation_by_assessment_input::Builder {
        crate::input::batch_delete_delegation_by_assessment_input::Builder::default()
    }
    /// Creates a new `BatchDeleteDelegationByAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteDelegationByAssessment {
    type Output = std::result::Result<
        crate::output::BatchDeleteDelegationByAssessmentOutput,
        crate::error::BatchDeleteDelegationByAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_delegation_by_assessment_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_delegation_by_assessment_response(response)
        }
    }
}

/// Operation shape for `BatchDisassociateAssessmentReportEvidence`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_disassociate_assessment_report_evidence`](crate::client::Client::batch_disassociate_assessment_report_evidence).
///
/// See [`crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDisassociateAssessmentReportEvidence {
    _private: (),
}
impl BatchDisassociateAssessmentReportEvidence {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateAssessmentReportEvidenceInput`](crate::input::BatchDisassociateAssessmentReportEvidenceInput)
    pub fn builder() -> crate::input::batch_disassociate_assessment_report_evidence_input::Builder {
        crate::input::batch_disassociate_assessment_report_evidence_input::Builder::default()
    }
    /// Creates a new `BatchDisassociateAssessmentReportEvidence` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDisassociateAssessmentReportEvidence {
    type Output = std::result::Result<
        crate::output::BatchDisassociateAssessmentReportEvidenceOutput,
        crate::error::BatchDisassociateAssessmentReportEvidenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_disassociate_assessment_report_evidence_error(
                response,
            )
        } else {
            crate::operation_deser::parse_batch_disassociate_assessment_report_evidence_response(
                response,
            )
        }
    }
}

/// Operation shape for `BatchImportEvidenceToAssessmentControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_import_evidence_to_assessment_control`](crate::client::Client::batch_import_evidence_to_assessment_control).
///
/// See [`crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchImportEvidenceToAssessmentControl {
    _private: (),
}
impl BatchImportEvidenceToAssessmentControl {
    /// Creates a new builder-style object to manufacture [`BatchImportEvidenceToAssessmentControlInput`](crate::input::BatchImportEvidenceToAssessmentControlInput)
    pub fn builder() -> crate::input::batch_import_evidence_to_assessment_control_input::Builder {
        crate::input::batch_import_evidence_to_assessment_control_input::Builder::default()
    }
    /// Creates a new `BatchImportEvidenceToAssessmentControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchImportEvidenceToAssessmentControl {
    type Output = std::result::Result<
        crate::output::BatchImportEvidenceToAssessmentControlOutput,
        crate::error::BatchImportEvidenceToAssessmentControlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_import_evidence_to_assessment_control_error(
                response,
            )
        } else {
            crate::operation_deser::parse_batch_import_evidence_to_assessment_control_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_assessment`](crate::client::Client::create_assessment).
///
/// See [`crate::client::fluent_builders::CreateAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssessment {
    _private: (),
}
impl CreateAssessment {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentInput`](crate::input::CreateAssessmentInput)
    pub fn builder() -> crate::input::create_assessment_input::Builder {
        crate::input::create_assessment_input::Builder::default()
    }
    /// Creates a new `CreateAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssessment {
    type Output = std::result::Result<
        crate::output::CreateAssessmentOutput,
        crate::error::CreateAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_assessment_error(response)
        } else {
            crate::operation_deser::parse_create_assessment_response(response)
        }
    }
}

/// Operation shape for `CreateAssessmentFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_assessment_framework`](crate::client::Client::create_assessment_framework).
///
/// See [`crate::client::fluent_builders::CreateAssessmentFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssessmentFramework {
    _private: (),
}
impl CreateAssessmentFramework {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentFrameworkInput`](crate::input::CreateAssessmentFrameworkInput)
    pub fn builder() -> crate::input::create_assessment_framework_input::Builder {
        crate::input::create_assessment_framework_input::Builder::default()
    }
    /// Creates a new `CreateAssessmentFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssessmentFramework {
    type Output = std::result::Result<
        crate::output::CreateAssessmentFrameworkOutput,
        crate::error::CreateAssessmentFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_assessment_framework_error(response)
        } else {
            crate::operation_deser::parse_create_assessment_framework_response(response)
        }
    }
}

/// Operation shape for `CreateAssessmentReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_assessment_report`](crate::client::Client::create_assessment_report).
///
/// See [`crate::client::fluent_builders::CreateAssessmentReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAssessmentReport {
    _private: (),
}
impl CreateAssessmentReport {
    /// Creates a new builder-style object to manufacture [`CreateAssessmentReportInput`](crate::input::CreateAssessmentReportInput)
    pub fn builder() -> crate::input::create_assessment_report_input::Builder {
        crate::input::create_assessment_report_input::Builder::default()
    }
    /// Creates a new `CreateAssessmentReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAssessmentReport {
    type Output = std::result::Result<
        crate::output::CreateAssessmentReportOutput,
        crate::error::CreateAssessmentReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_assessment_report_error(response)
        } else {
            crate::operation_deser::parse_create_assessment_report_response(response)
        }
    }
}

/// Operation shape for `CreateControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_control`](crate::client::Client::create_control).
///
/// See [`crate::client::fluent_builders::CreateControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateControl {
    _private: (),
}
impl CreateControl {
    /// Creates a new builder-style object to manufacture [`CreateControlInput`](crate::input::CreateControlInput)
    pub fn builder() -> crate::input::create_control_input::Builder {
        crate::input::create_control_input::Builder::default()
    }
    /// Creates a new `CreateControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateControl {
    type Output =
        std::result::Result<crate::output::CreateControlOutput, crate::error::CreateControlError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_control_error(response)
        } else {
            crate::operation_deser::parse_create_control_response(response)
        }
    }
}

/// Operation shape for `DeleteAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assessment`](crate::client::Client::delete_assessment).
///
/// See [`crate::client::fluent_builders::DeleteAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssessment {
    _private: (),
}
impl DeleteAssessment {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentInput`](crate::input::DeleteAssessmentInput)
    pub fn builder() -> crate::input::delete_assessment_input::Builder {
        crate::input::delete_assessment_input::Builder::default()
    }
    /// Creates a new `DeleteAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssessment {
    type Output = std::result::Result<
        crate::output::DeleteAssessmentOutput,
        crate::error::DeleteAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_assessment_error(response)
        } else {
            crate::operation_deser::parse_delete_assessment_response(response)
        }
    }
}

/// Operation shape for `DeleteAssessmentFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assessment_framework`](crate::client::Client::delete_assessment_framework).
///
/// See [`crate::client::fluent_builders::DeleteAssessmentFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssessmentFramework {
    _private: (),
}
impl DeleteAssessmentFramework {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentFrameworkInput`](crate::input::DeleteAssessmentFrameworkInput)
    pub fn builder() -> crate::input::delete_assessment_framework_input::Builder {
        crate::input::delete_assessment_framework_input::Builder::default()
    }
    /// Creates a new `DeleteAssessmentFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssessmentFramework {
    type Output = std::result::Result<
        crate::output::DeleteAssessmentFrameworkOutput,
        crate::error::DeleteAssessmentFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_assessment_framework_error(response)
        } else {
            crate::operation_deser::parse_delete_assessment_framework_response(response)
        }
    }
}

/// Operation shape for `DeleteAssessmentReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_assessment_report`](crate::client::Client::delete_assessment_report).
///
/// See [`crate::client::fluent_builders::DeleteAssessmentReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAssessmentReport {
    _private: (),
}
impl DeleteAssessmentReport {
    /// Creates a new builder-style object to manufacture [`DeleteAssessmentReportInput`](crate::input::DeleteAssessmentReportInput)
    pub fn builder() -> crate::input::delete_assessment_report_input::Builder {
        crate::input::delete_assessment_report_input::Builder::default()
    }
    /// Creates a new `DeleteAssessmentReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAssessmentReport {
    type Output = std::result::Result<
        crate::output::DeleteAssessmentReportOutput,
        crate::error::DeleteAssessmentReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_assessment_report_error(response)
        } else {
            crate::operation_deser::parse_delete_assessment_report_response(response)
        }
    }
}

/// Operation shape for `DeleteControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_control`](crate::client::Client::delete_control).
///
/// See [`crate::client::fluent_builders::DeleteControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteControl {
    _private: (),
}
impl DeleteControl {
    /// Creates a new builder-style object to manufacture [`DeleteControlInput`](crate::input::DeleteControlInput)
    pub fn builder() -> crate::input::delete_control_input::Builder {
        crate::input::delete_control_input::Builder::default()
    }
    /// Creates a new `DeleteControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteControl {
    type Output =
        std::result::Result<crate::output::DeleteControlOutput, crate::error::DeleteControlError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_control_error(response)
        } else {
            crate::operation_deser::parse_delete_control_response(response)
        }
    }
}

/// Operation shape for `DeregisterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_account`](crate::client::Client::deregister_account).
///
/// See [`crate::client::fluent_builders::DeregisterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterAccount {
    _private: (),
}
impl DeregisterAccount {
    /// Creates a new builder-style object to manufacture [`DeregisterAccountInput`](crate::input::DeregisterAccountInput)
    pub fn builder() -> crate::input::deregister_account_input::Builder {
        crate::input::deregister_account_input::Builder::default()
    }
    /// Creates a new `DeregisterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterAccount {
    type Output = std::result::Result<
        crate::output::DeregisterAccountOutput,
        crate::error::DeregisterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_account_error(response)
        } else {
            crate::operation_deser::parse_deregister_account_response(response)
        }
    }
}

/// Operation shape for `DeregisterOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`deregister_organization_admin_account`](crate::client::Client::deregister_organization_admin_account).
///
/// See [`crate::client::fluent_builders::DeregisterOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeregisterOrganizationAdminAccount {
    _private: (),
}
impl DeregisterOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`DeregisterOrganizationAdminAccountInput`](crate::input::DeregisterOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::deregister_organization_admin_account_input::Builder {
        crate::input::deregister_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `DeregisterOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeregisterOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::DeregisterOrganizationAdminAccountOutput,
        crate::error::DeregisterOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_deregister_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_deregister_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateAssessmentReportEvidenceFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_assessment_report_evidence_folder`](crate::client::Client::disassociate_assessment_report_evidence_folder).
///
/// See [`crate::client::fluent_builders::DisassociateAssessmentReportEvidenceFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateAssessmentReportEvidenceFolder {
    _private: (),
}
impl DisassociateAssessmentReportEvidenceFolder {
    /// Creates a new builder-style object to manufacture [`DisassociateAssessmentReportEvidenceFolderInput`](crate::input::DisassociateAssessmentReportEvidenceFolderInput)
    pub fn builder() -> crate::input::disassociate_assessment_report_evidence_folder_input::Builder
    {
        crate::input::disassociate_assessment_report_evidence_folder_input::Builder::default()
    }
    /// Creates a new `DisassociateAssessmentReportEvidenceFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateAssessmentReportEvidenceFolder {
    type Output = std::result::Result<
        crate::output::DisassociateAssessmentReportEvidenceFolderOutput,
        crate::error::DisassociateAssessmentReportEvidenceFolderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_assessment_report_evidence_folder_error(
                response,
            )
        } else {
            crate::operation_deser::parse_disassociate_assessment_report_evidence_folder_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetAccountStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_account_status`](crate::client::Client::get_account_status).
///
/// See [`crate::client::fluent_builders::GetAccountStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccountStatus {
    _private: (),
}
impl GetAccountStatus {
    /// Creates a new builder-style object to manufacture [`GetAccountStatusInput`](crate::input::GetAccountStatusInput)
    pub fn builder() -> crate::input::get_account_status_input::Builder {
        crate::input::get_account_status_input::Builder::default()
    }
    /// Creates a new `GetAccountStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccountStatus {
    type Output = std::result::Result<
        crate::output::GetAccountStatusOutput,
        crate::error::GetAccountStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_account_status_error(response)
        } else {
            crate::operation_deser::parse_get_account_status_response(response)
        }
    }
}

/// Operation shape for `GetAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_assessment`](crate::client::Client::get_assessment).
///
/// See [`crate::client::fluent_builders::GetAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssessment {
    _private: (),
}
impl GetAssessment {
    /// Creates a new builder-style object to manufacture [`GetAssessmentInput`](crate::input::GetAssessmentInput)
    pub fn builder() -> crate::input::get_assessment_input::Builder {
        crate::input::get_assessment_input::Builder::default()
    }
    /// Creates a new `GetAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssessment {
    type Output =
        std::result::Result<crate::output::GetAssessmentOutput, crate::error::GetAssessmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_assessment_error(response)
        } else {
            crate::operation_deser::parse_get_assessment_response(response)
        }
    }
}

/// Operation shape for `GetAssessmentFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_assessment_framework`](crate::client::Client::get_assessment_framework).
///
/// See [`crate::client::fluent_builders::GetAssessmentFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssessmentFramework {
    _private: (),
}
impl GetAssessmentFramework {
    /// Creates a new builder-style object to manufacture [`GetAssessmentFrameworkInput`](crate::input::GetAssessmentFrameworkInput)
    pub fn builder() -> crate::input::get_assessment_framework_input::Builder {
        crate::input::get_assessment_framework_input::Builder::default()
    }
    /// Creates a new `GetAssessmentFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssessmentFramework {
    type Output = std::result::Result<
        crate::output::GetAssessmentFrameworkOutput,
        crate::error::GetAssessmentFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_assessment_framework_error(response)
        } else {
            crate::operation_deser::parse_get_assessment_framework_response(response)
        }
    }
}

/// Operation shape for `GetAssessmentReportUrl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_assessment_report_url`](crate::client::Client::get_assessment_report_url).
///
/// See [`crate::client::fluent_builders::GetAssessmentReportUrl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAssessmentReportUrl {
    _private: (),
}
impl GetAssessmentReportUrl {
    /// Creates a new builder-style object to manufacture [`GetAssessmentReportUrlInput`](crate::input::GetAssessmentReportUrlInput)
    pub fn builder() -> crate::input::get_assessment_report_url_input::Builder {
        crate::input::get_assessment_report_url_input::Builder::default()
    }
    /// Creates a new `GetAssessmentReportUrl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAssessmentReportUrl {
    type Output = std::result::Result<
        crate::output::GetAssessmentReportUrlOutput,
        crate::error::GetAssessmentReportUrlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_assessment_report_url_error(response)
        } else {
            crate::operation_deser::parse_get_assessment_report_url_response(response)
        }
    }
}

/// Operation shape for `GetChangeLogs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_change_logs`](crate::client::Client::get_change_logs).
///
/// See [`crate::client::fluent_builders::GetChangeLogs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetChangeLogs {
    _private: (),
}
impl GetChangeLogs {
    /// Creates a new builder-style object to manufacture [`GetChangeLogsInput`](crate::input::GetChangeLogsInput)
    pub fn builder() -> crate::input::get_change_logs_input::Builder {
        crate::input::get_change_logs_input::Builder::default()
    }
    /// Creates a new `GetChangeLogs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetChangeLogs {
    type Output =
        std::result::Result<crate::output::GetChangeLogsOutput, crate::error::GetChangeLogsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_change_logs_error(response)
        } else {
            crate::operation_deser::parse_get_change_logs_response(response)
        }
    }
}

/// Operation shape for `GetControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_control`](crate::client::Client::get_control).
///
/// See [`crate::client::fluent_builders::GetControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetControl {
    _private: (),
}
impl GetControl {
    /// Creates a new builder-style object to manufacture [`GetControlInput`](crate::input::GetControlInput)
    pub fn builder() -> crate::input::get_control_input::Builder {
        crate::input::get_control_input::Builder::default()
    }
    /// Creates a new `GetControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetControl {
    type Output =
        std::result::Result<crate::output::GetControlOutput, crate::error::GetControlError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_control_error(response)
        } else {
            crate::operation_deser::parse_get_control_response(response)
        }
    }
}

/// Operation shape for `GetDelegations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_delegations`](crate::client::Client::get_delegations).
///
/// See [`crate::client::fluent_builders::GetDelegations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDelegations {
    _private: (),
}
impl GetDelegations {
    /// Creates a new builder-style object to manufacture [`GetDelegationsInput`](crate::input::GetDelegationsInput)
    pub fn builder() -> crate::input::get_delegations_input::Builder {
        crate::input::get_delegations_input::Builder::default()
    }
    /// Creates a new `GetDelegations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDelegations {
    type Output =
        std::result::Result<crate::output::GetDelegationsOutput, crate::error::GetDelegationsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_delegations_error(response)
        } else {
            crate::operation_deser::parse_get_delegations_response(response)
        }
    }
}

/// Operation shape for `GetEvidence`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_evidence`](crate::client::Client::get_evidence).
///
/// See [`crate::client::fluent_builders::GetEvidence`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEvidence {
    _private: (),
}
impl GetEvidence {
    /// Creates a new builder-style object to manufacture [`GetEvidenceInput`](crate::input::GetEvidenceInput)
    pub fn builder() -> crate::input::get_evidence_input::Builder {
        crate::input::get_evidence_input::Builder::default()
    }
    /// Creates a new `GetEvidence` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEvidence {
    type Output =
        std::result::Result<crate::output::GetEvidenceOutput, crate::error::GetEvidenceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_evidence_error(response)
        } else {
            crate::operation_deser::parse_get_evidence_response(response)
        }
    }
}

/// Operation shape for `GetEvidenceByEvidenceFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_evidence_by_evidence_folder`](crate::client::Client::get_evidence_by_evidence_folder).
///
/// See [`crate::client::fluent_builders::GetEvidenceByEvidenceFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEvidenceByEvidenceFolder {
    _private: (),
}
impl GetEvidenceByEvidenceFolder {
    /// Creates a new builder-style object to manufacture [`GetEvidenceByEvidenceFolderInput`](crate::input::GetEvidenceByEvidenceFolderInput)
    pub fn builder() -> crate::input::get_evidence_by_evidence_folder_input::Builder {
        crate::input::get_evidence_by_evidence_folder_input::Builder::default()
    }
    /// Creates a new `GetEvidenceByEvidenceFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEvidenceByEvidenceFolder {
    type Output = std::result::Result<
        crate::output::GetEvidenceByEvidenceFolderOutput,
        crate::error::GetEvidenceByEvidenceFolderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_evidence_by_evidence_folder_error(response)
        } else {
            crate::operation_deser::parse_get_evidence_by_evidence_folder_response(response)
        }
    }
}

/// Operation shape for `GetEvidenceFolder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_evidence_folder`](crate::client::Client::get_evidence_folder).
///
/// See [`crate::client::fluent_builders::GetEvidenceFolder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEvidenceFolder {
    _private: (),
}
impl GetEvidenceFolder {
    /// Creates a new builder-style object to manufacture [`GetEvidenceFolderInput`](crate::input::GetEvidenceFolderInput)
    pub fn builder() -> crate::input::get_evidence_folder_input::Builder {
        crate::input::get_evidence_folder_input::Builder::default()
    }
    /// Creates a new `GetEvidenceFolder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEvidenceFolder {
    type Output = std::result::Result<
        crate::output::GetEvidenceFolderOutput,
        crate::error::GetEvidenceFolderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_evidence_folder_error(response)
        } else {
            crate::operation_deser::parse_get_evidence_folder_response(response)
        }
    }
}

/// Operation shape for `GetEvidenceFoldersByAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_evidence_folders_by_assessment`](crate::client::Client::get_evidence_folders_by_assessment).
///
/// See [`crate::client::fluent_builders::GetEvidenceFoldersByAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEvidenceFoldersByAssessment {
    _private: (),
}
impl GetEvidenceFoldersByAssessment {
    /// Creates a new builder-style object to manufacture [`GetEvidenceFoldersByAssessmentInput`](crate::input::GetEvidenceFoldersByAssessmentInput)
    pub fn builder() -> crate::input::get_evidence_folders_by_assessment_input::Builder {
        crate::input::get_evidence_folders_by_assessment_input::Builder::default()
    }
    /// Creates a new `GetEvidenceFoldersByAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEvidenceFoldersByAssessment {
    type Output = std::result::Result<
        crate::output::GetEvidenceFoldersByAssessmentOutput,
        crate::error::GetEvidenceFoldersByAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_evidence_folders_by_assessment_error(response)
        } else {
            crate::operation_deser::parse_get_evidence_folders_by_assessment_response(response)
        }
    }
}

/// Operation shape for `GetEvidenceFoldersByAssessmentControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_evidence_folders_by_assessment_control`](crate::client::Client::get_evidence_folders_by_assessment_control).
///
/// See [`crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetEvidenceFoldersByAssessmentControl {
    _private: (),
}
impl GetEvidenceFoldersByAssessmentControl {
    /// Creates a new builder-style object to manufacture [`GetEvidenceFoldersByAssessmentControlInput`](crate::input::GetEvidenceFoldersByAssessmentControlInput)
    pub fn builder() -> crate::input::get_evidence_folders_by_assessment_control_input::Builder {
        crate::input::get_evidence_folders_by_assessment_control_input::Builder::default()
    }
    /// Creates a new `GetEvidenceFoldersByAssessmentControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetEvidenceFoldersByAssessmentControl {
    type Output = std::result::Result<
        crate::output::GetEvidenceFoldersByAssessmentControlOutput,
        crate::error::GetEvidenceFoldersByAssessmentControlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_evidence_folders_by_assessment_control_error(response)
        } else {
            crate::operation_deser::parse_get_evidence_folders_by_assessment_control_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_organization_admin_account`](crate::client::Client::get_organization_admin_account).
///
/// See [`crate::client::fluent_builders::GetOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOrganizationAdminAccount {
    _private: (),
}
impl GetOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`GetOrganizationAdminAccountInput`](crate::input::GetOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::get_organization_admin_account_input::Builder {
        crate::input::get_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `GetOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::GetOrganizationAdminAccountOutput,
        crate::error::GetOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_get_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `GetServicesInScope`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_services_in_scope`](crate::client::Client::get_services_in_scope).
///
/// See [`crate::client::fluent_builders::GetServicesInScope`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServicesInScope {
    _private: (),
}
impl GetServicesInScope {
    /// Creates a new builder-style object to manufacture [`GetServicesInScopeInput`](crate::input::GetServicesInScopeInput)
    pub fn builder() -> crate::input::get_services_in_scope_input::Builder {
        crate::input::get_services_in_scope_input::Builder::default()
    }
    /// Creates a new `GetServicesInScope` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServicesInScope {
    type Output = std::result::Result<
        crate::output::GetServicesInScopeOutput,
        crate::error::GetServicesInScopeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_services_in_scope_error(response)
        } else {
            crate::operation_deser::parse_get_services_in_scope_response(response)
        }
    }
}

/// Operation shape for `GetSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_settings`](crate::client::Client::get_settings).
///
/// See [`crate::client::fluent_builders::GetSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSettings {
    _private: (),
}
impl GetSettings {
    /// Creates a new builder-style object to manufacture [`GetSettingsInput`](crate::input::GetSettingsInput)
    pub fn builder() -> crate::input::get_settings_input::Builder {
        crate::input::get_settings_input::Builder::default()
    }
    /// Creates a new `GetSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSettings {
    type Output =
        std::result::Result<crate::output::GetSettingsOutput, crate::error::GetSettingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_settings_error(response)
        } else {
            crate::operation_deser::parse_get_settings_response(response)
        }
    }
}

/// Operation shape for `ListAssessmentFrameworks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assessment_frameworks`](crate::client::Client::list_assessment_frameworks).
///
/// See [`crate::client::fluent_builders::ListAssessmentFrameworks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssessmentFrameworks {
    _private: (),
}
impl ListAssessmentFrameworks {
    /// Creates a new builder-style object to manufacture [`ListAssessmentFrameworksInput`](crate::input::ListAssessmentFrameworksInput)
    pub fn builder() -> crate::input::list_assessment_frameworks_input::Builder {
        crate::input::list_assessment_frameworks_input::Builder::default()
    }
    /// Creates a new `ListAssessmentFrameworks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssessmentFrameworks {
    type Output = std::result::Result<
        crate::output::ListAssessmentFrameworksOutput,
        crate::error::ListAssessmentFrameworksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assessment_frameworks_error(response)
        } else {
            crate::operation_deser::parse_list_assessment_frameworks_response(response)
        }
    }
}

/// Operation shape for `ListAssessmentReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assessment_reports`](crate::client::Client::list_assessment_reports).
///
/// See [`crate::client::fluent_builders::ListAssessmentReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssessmentReports {
    _private: (),
}
impl ListAssessmentReports {
    /// Creates a new builder-style object to manufacture [`ListAssessmentReportsInput`](crate::input::ListAssessmentReportsInput)
    pub fn builder() -> crate::input::list_assessment_reports_input::Builder {
        crate::input::list_assessment_reports_input::Builder::default()
    }
    /// Creates a new `ListAssessmentReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssessmentReports {
    type Output = std::result::Result<
        crate::output::ListAssessmentReportsOutput,
        crate::error::ListAssessmentReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assessment_reports_error(response)
        } else {
            crate::operation_deser::parse_list_assessment_reports_response(response)
        }
    }
}

/// Operation shape for `ListAssessments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_assessments`](crate::client::Client::list_assessments).
///
/// See [`crate::client::fluent_builders::ListAssessments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssessments {
    _private: (),
}
impl ListAssessments {
    /// Creates a new builder-style object to manufacture [`ListAssessmentsInput`](crate::input::ListAssessmentsInput)
    pub fn builder() -> crate::input::list_assessments_input::Builder {
        crate::input::list_assessments_input::Builder::default()
    }
    /// Creates a new `ListAssessments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssessments {
    type Output = std::result::Result<
        crate::output::ListAssessmentsOutput,
        crate::error::ListAssessmentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_assessments_error(response)
        } else {
            crate::operation_deser::parse_list_assessments_response(response)
        }
    }
}

/// Operation shape for `ListControls`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_controls`](crate::client::Client::list_controls).
///
/// See [`crate::client::fluent_builders::ListControls`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListControls {
    _private: (),
}
impl ListControls {
    /// Creates a new builder-style object to manufacture [`ListControlsInput`](crate::input::ListControlsInput)
    pub fn builder() -> crate::input::list_controls_input::Builder {
        crate::input::list_controls_input::Builder::default()
    }
    /// Creates a new `ListControls` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListControls {
    type Output =
        std::result::Result<crate::output::ListControlsOutput, crate::error::ListControlsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_controls_error(response)
        } else {
            crate::operation_deser::parse_list_controls_response(response)
        }
    }
}

/// Operation shape for `ListKeywordsForDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_keywords_for_data_source`](crate::client::Client::list_keywords_for_data_source).
///
/// See [`crate::client::fluent_builders::ListKeywordsForDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListKeywordsForDataSource {
    _private: (),
}
impl ListKeywordsForDataSource {
    /// Creates a new builder-style object to manufacture [`ListKeywordsForDataSourceInput`](crate::input::ListKeywordsForDataSourceInput)
    pub fn builder() -> crate::input::list_keywords_for_data_source_input::Builder {
        crate::input::list_keywords_for_data_source_input::Builder::default()
    }
    /// Creates a new `ListKeywordsForDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListKeywordsForDataSource {
    type Output = std::result::Result<
        crate::output::ListKeywordsForDataSourceOutput,
        crate::error::ListKeywordsForDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_keywords_for_data_source_error(response)
        } else {
            crate::operation_deser::parse_list_keywords_for_data_source_response(response)
        }
    }
}

/// Operation shape for `ListNotifications`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_notifications`](crate::client::Client::list_notifications).
///
/// See [`crate::client::fluent_builders::ListNotifications`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNotifications {
    _private: (),
}
impl ListNotifications {
    /// Creates a new builder-style object to manufacture [`ListNotificationsInput`](crate::input::ListNotificationsInput)
    pub fn builder() -> crate::input::list_notifications_input::Builder {
        crate::input::list_notifications_input::Builder::default()
    }
    /// Creates a new `ListNotifications` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNotifications {
    type Output = std::result::Result<
        crate::output::ListNotificationsOutput,
        crate::error::ListNotificationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_notifications_error(response)
        } else {
            crate::operation_deser::parse_list_notifications_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RegisterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_account`](crate::client::Client::register_account).
///
/// See [`crate::client::fluent_builders::RegisterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterAccount {
    _private: (),
}
impl RegisterAccount {
    /// Creates a new builder-style object to manufacture [`RegisterAccountInput`](crate::input::RegisterAccountInput)
    pub fn builder() -> crate::input::register_account_input::Builder {
        crate::input::register_account_input::Builder::default()
    }
    /// Creates a new `RegisterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterAccount {
    type Output = std::result::Result<
        crate::output::RegisterAccountOutput,
        crate::error::RegisterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_account_error(response)
        } else {
            crate::operation_deser::parse_register_account_response(response)
        }
    }
}

/// Operation shape for `RegisterOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_organization_admin_account`](crate::client::Client::register_organization_admin_account).
///
/// See [`crate::client::fluent_builders::RegisterOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterOrganizationAdminAccount {
    _private: (),
}
impl RegisterOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`RegisterOrganizationAdminAccountInput`](crate::input::RegisterOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::register_organization_admin_account_input::Builder {
        crate::input::register_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `RegisterOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::RegisterOrganizationAdminAccountOutput,
        crate::error::RegisterOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_register_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAssessment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_assessment`](crate::client::Client::update_assessment).
///
/// See [`crate::client::fluent_builders::UpdateAssessment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssessment {
    _private: (),
}
impl UpdateAssessment {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentInput`](crate::input::UpdateAssessmentInput)
    pub fn builder() -> crate::input::update_assessment_input::Builder {
        crate::input::update_assessment_input::Builder::default()
    }
    /// Creates a new `UpdateAssessment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssessment {
    type Output = std::result::Result<
        crate::output::UpdateAssessmentOutput,
        crate::error::UpdateAssessmentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_assessment_error(response)
        } else {
            crate::operation_deser::parse_update_assessment_response(response)
        }
    }
}

/// Operation shape for `UpdateAssessmentControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_assessment_control`](crate::client::Client::update_assessment_control).
///
/// See [`crate::client::fluent_builders::UpdateAssessmentControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssessmentControl {
    _private: (),
}
impl UpdateAssessmentControl {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentControlInput`](crate::input::UpdateAssessmentControlInput)
    pub fn builder() -> crate::input::update_assessment_control_input::Builder {
        crate::input::update_assessment_control_input::Builder::default()
    }
    /// Creates a new `UpdateAssessmentControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssessmentControl {
    type Output = std::result::Result<
        crate::output::UpdateAssessmentControlOutput,
        crate::error::UpdateAssessmentControlError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_assessment_control_error(response)
        } else {
            crate::operation_deser::parse_update_assessment_control_response(response)
        }
    }
}

/// Operation shape for `UpdateAssessmentControlSetStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_assessment_control_set_status`](crate::client::Client::update_assessment_control_set_status).
///
/// See [`crate::client::fluent_builders::UpdateAssessmentControlSetStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssessmentControlSetStatus {
    _private: (),
}
impl UpdateAssessmentControlSetStatus {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentControlSetStatusInput`](crate::input::UpdateAssessmentControlSetStatusInput)
    pub fn builder() -> crate::input::update_assessment_control_set_status_input::Builder {
        crate::input::update_assessment_control_set_status_input::Builder::default()
    }
    /// Creates a new `UpdateAssessmentControlSetStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssessmentControlSetStatus {
    type Output = std::result::Result<
        crate::output::UpdateAssessmentControlSetStatusOutput,
        crate::error::UpdateAssessmentControlSetStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_assessment_control_set_status_error(response)
        } else {
            crate::operation_deser::parse_update_assessment_control_set_status_response(response)
        }
    }
}

/// Operation shape for `UpdateAssessmentFramework`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_assessment_framework`](crate::client::Client::update_assessment_framework).
///
/// See [`crate::client::fluent_builders::UpdateAssessmentFramework`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssessmentFramework {
    _private: (),
}
impl UpdateAssessmentFramework {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentFrameworkInput`](crate::input::UpdateAssessmentFrameworkInput)
    pub fn builder() -> crate::input::update_assessment_framework_input::Builder {
        crate::input::update_assessment_framework_input::Builder::default()
    }
    /// Creates a new `UpdateAssessmentFramework` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssessmentFramework {
    type Output = std::result::Result<
        crate::output::UpdateAssessmentFrameworkOutput,
        crate::error::UpdateAssessmentFrameworkError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_assessment_framework_error(response)
        } else {
            crate::operation_deser::parse_update_assessment_framework_response(response)
        }
    }
}

/// Operation shape for `UpdateAssessmentStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_assessment_status`](crate::client::Client::update_assessment_status).
///
/// See [`crate::client::fluent_builders::UpdateAssessmentStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAssessmentStatus {
    _private: (),
}
impl UpdateAssessmentStatus {
    /// Creates a new builder-style object to manufacture [`UpdateAssessmentStatusInput`](crate::input::UpdateAssessmentStatusInput)
    pub fn builder() -> crate::input::update_assessment_status_input::Builder {
        crate::input::update_assessment_status_input::Builder::default()
    }
    /// Creates a new `UpdateAssessmentStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAssessmentStatus {
    type Output = std::result::Result<
        crate::output::UpdateAssessmentStatusOutput,
        crate::error::UpdateAssessmentStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_assessment_status_error(response)
        } else {
            crate::operation_deser::parse_update_assessment_status_response(response)
        }
    }
}

/// Operation shape for `UpdateControl`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_control`](crate::client::Client::update_control).
///
/// See [`crate::client::fluent_builders::UpdateControl`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateControl {
    _private: (),
}
impl UpdateControl {
    /// Creates a new builder-style object to manufacture [`UpdateControlInput`](crate::input::UpdateControlInput)
    pub fn builder() -> crate::input::update_control_input::Builder {
        crate::input::update_control_input::Builder::default()
    }
    /// Creates a new `UpdateControl` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateControl {
    type Output =
        std::result::Result<crate::output::UpdateControlOutput, crate::error::UpdateControlError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_control_error(response)
        } else {
            crate::operation_deser::parse_update_control_response(response)
        }
    }
}

/// Operation shape for `UpdateSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_settings`](crate::client::Client::update_settings).
///
/// See [`crate::client::fluent_builders::UpdateSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateSettings {
    _private: (),
}
impl UpdateSettings {
    /// Creates a new builder-style object to manufacture [`UpdateSettingsInput`](crate::input::UpdateSettingsInput)
    pub fn builder() -> crate::input::update_settings_input::Builder {
        crate::input::update_settings_input::Builder::default()
    }
    /// Creates a new `UpdateSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateSettings {
    type Output =
        std::result::Result<crate::output::UpdateSettingsOutput, crate::error::UpdateSettingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_settings_error(response)
        } else {
            crate::operation_deser::parse_update_settings_response(response)
        }
    }
}

/// Operation shape for `ValidateAssessmentReportIntegrity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`validate_assessment_report_integrity`](crate::client::Client::validate_assessment_report_integrity).
///
/// See [`crate::client::fluent_builders::ValidateAssessmentReportIntegrity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ValidateAssessmentReportIntegrity {
    _private: (),
}
impl ValidateAssessmentReportIntegrity {
    /// Creates a new builder-style object to manufacture [`ValidateAssessmentReportIntegrityInput`](crate::input::ValidateAssessmentReportIntegrityInput)
    pub fn builder() -> crate::input::validate_assessment_report_integrity_input::Builder {
        crate::input::validate_assessment_report_integrity_input::Builder::default()
    }
    /// Creates a new `ValidateAssessmentReportIntegrity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ValidateAssessmentReportIntegrity {
    type Output = std::result::Result<
        crate::output::ValidateAssessmentReportIntegrityOutput,
        crate::error::ValidateAssessmentReportIntegrityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_validate_assessment_report_integrity_error(response)
        } else {
            crate::operation_deser::parse_validate_assessment_report_integrity_response(response)
        }
    }
}
