// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `BedrockAssessmentManagerLambda`.
///
/// This client allows ergonomic access to a `BedrockAssessmentManagerLambda`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateAssessmentReportEvidenceFolder` operation.
    ///
    /// See [`AssociateAssessmentReportEvidenceFolder`](crate::client::fluent_builders::AssociateAssessmentReportEvidenceFolder) for more information about the
    /// operation and its arguments.
    pub fn associate_assessment_report_evidence_folder(
        &self,
    ) -> fluent_builders::AssociateAssessmentReportEvidenceFolder<C, M, R> {
        fluent_builders::AssociateAssessmentReportEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchAssociateAssessmentReportEvidence` operation.
    ///
    /// See [`BatchAssociateAssessmentReportEvidence`](crate::client::fluent_builders::BatchAssociateAssessmentReportEvidence) for more information about the
    /// operation and its arguments.
    pub fn batch_associate_assessment_report_evidence(
        &self,
    ) -> fluent_builders::BatchAssociateAssessmentReportEvidence<C, M, R> {
        fluent_builders::BatchAssociateAssessmentReportEvidence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchCreateDelegationByAssessment` operation.
    ///
    /// See [`BatchCreateDelegationByAssessment`](crate::client::fluent_builders::BatchCreateDelegationByAssessment) for more information about the
    /// operation and its arguments.
    pub fn batch_create_delegation_by_assessment(
        &self,
    ) -> fluent_builders::BatchCreateDelegationByAssessment<C, M, R> {
        fluent_builders::BatchCreateDelegationByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteDelegationByAssessment` operation.
    ///
    /// See [`BatchDeleteDelegationByAssessment`](crate::client::fluent_builders::BatchDeleteDelegationByAssessment) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_delegation_by_assessment(
        &self,
    ) -> fluent_builders::BatchDeleteDelegationByAssessment<C, M, R> {
        fluent_builders::BatchDeleteDelegationByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDisassociateAssessmentReportEvidence` operation.
    ///
    /// See [`BatchDisassociateAssessmentReportEvidence`](crate::client::fluent_builders::BatchDisassociateAssessmentReportEvidence) for more information about the
    /// operation and its arguments.
    pub fn batch_disassociate_assessment_report_evidence(
        &self,
    ) -> fluent_builders::BatchDisassociateAssessmentReportEvidence<C, M, R> {
        fluent_builders::BatchDisassociateAssessmentReportEvidence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchImportEvidenceToAssessmentControl` operation.
    ///
    /// See [`BatchImportEvidenceToAssessmentControl`](crate::client::fluent_builders::BatchImportEvidenceToAssessmentControl) for more information about the
    /// operation and its arguments.
    pub fn batch_import_evidence_to_assessment_control(
        &self,
    ) -> fluent_builders::BatchImportEvidenceToAssessmentControl<C, M, R> {
        fluent_builders::BatchImportEvidenceToAssessmentControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssessment` operation.
    ///
    /// See [`CreateAssessment`](crate::client::fluent_builders::CreateAssessment) for more information about the
    /// operation and its arguments.
    pub fn create_assessment(&self) -> fluent_builders::CreateAssessment<C, M, R> {
        fluent_builders::CreateAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssessmentFramework` operation.
    ///
    /// See [`CreateAssessmentFramework`](crate::client::fluent_builders::CreateAssessmentFramework) for more information about the
    /// operation and its arguments.
    pub fn create_assessment_framework(
        &self,
    ) -> fluent_builders::CreateAssessmentFramework<C, M, R> {
        fluent_builders::CreateAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAssessmentReport` operation.
    ///
    /// See [`CreateAssessmentReport`](crate::client::fluent_builders::CreateAssessmentReport) for more information about the
    /// operation and its arguments.
    pub fn create_assessment_report(&self) -> fluent_builders::CreateAssessmentReport<C, M, R> {
        fluent_builders::CreateAssessmentReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateControl` operation.
    ///
    /// See [`CreateControl`](crate::client::fluent_builders::CreateControl) for more information about the
    /// operation and its arguments.
    pub fn create_control(&self) -> fluent_builders::CreateControl<C, M, R> {
        fluent_builders::CreateControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssessment` operation.
    ///
    /// See [`DeleteAssessment`](crate::client::fluent_builders::DeleteAssessment) for more information about the
    /// operation and its arguments.
    pub fn delete_assessment(&self) -> fluent_builders::DeleteAssessment<C, M, R> {
        fluent_builders::DeleteAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssessmentFramework` operation.
    ///
    /// See [`DeleteAssessmentFramework`](crate::client::fluent_builders::DeleteAssessmentFramework) for more information about the
    /// operation and its arguments.
    pub fn delete_assessment_framework(
        &self,
    ) -> fluent_builders::DeleteAssessmentFramework<C, M, R> {
        fluent_builders::DeleteAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAssessmentReport` operation.
    ///
    /// See [`DeleteAssessmentReport`](crate::client::fluent_builders::DeleteAssessmentReport) for more information about the
    /// operation and its arguments.
    pub fn delete_assessment_report(&self) -> fluent_builders::DeleteAssessmentReport<C, M, R> {
        fluent_builders::DeleteAssessmentReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteControl` operation.
    ///
    /// See [`DeleteControl`](crate::client::fluent_builders::DeleteControl) for more information about the
    /// operation and its arguments.
    pub fn delete_control(&self) -> fluent_builders::DeleteControl<C, M, R> {
        fluent_builders::DeleteControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterAccount` operation.
    ///
    /// See [`DeregisterAccount`](crate::client::fluent_builders::DeregisterAccount) for more information about the
    /// operation and its arguments.
    pub fn deregister_account(&self) -> fluent_builders::DeregisterAccount<C, M, R> {
        fluent_builders::DeregisterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeregisterOrganizationAdminAccount` operation.
    ///
    /// See [`DeregisterOrganizationAdminAccount`](crate::client::fluent_builders::DeregisterOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn deregister_organization_admin_account(
        &self,
    ) -> fluent_builders::DeregisterOrganizationAdminAccount<C, M, R> {
        fluent_builders::DeregisterOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateAssessmentReportEvidenceFolder` operation.
    ///
    /// See [`DisassociateAssessmentReportEvidenceFolder`](crate::client::fluent_builders::DisassociateAssessmentReportEvidenceFolder) for more information about the
    /// operation and its arguments.
    pub fn disassociate_assessment_report_evidence_folder(
        &self,
    ) -> fluent_builders::DisassociateAssessmentReportEvidenceFolder<C, M, R> {
        fluent_builders::DisassociateAssessmentReportEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccountStatus` operation.
    ///
    /// See [`GetAccountStatus`](crate::client::fluent_builders::GetAccountStatus) for more information about the
    /// operation and its arguments.
    pub fn get_account_status(&self) -> fluent_builders::GetAccountStatus<C, M, R> {
        fluent_builders::GetAccountStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssessment` operation.
    ///
    /// See [`GetAssessment`](crate::client::fluent_builders::GetAssessment) for more information about the
    /// operation and its arguments.
    pub fn get_assessment(&self) -> fluent_builders::GetAssessment<C, M, R> {
        fluent_builders::GetAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssessmentFramework` operation.
    ///
    /// See [`GetAssessmentFramework`](crate::client::fluent_builders::GetAssessmentFramework) for more information about the
    /// operation and its arguments.
    pub fn get_assessment_framework(&self) -> fluent_builders::GetAssessmentFramework<C, M, R> {
        fluent_builders::GetAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAssessmentReportUrl` operation.
    ///
    /// See [`GetAssessmentReportUrl`](crate::client::fluent_builders::GetAssessmentReportUrl) for more information about the
    /// operation and its arguments.
    pub fn get_assessment_report_url(&self) -> fluent_builders::GetAssessmentReportUrl<C, M, R> {
        fluent_builders::GetAssessmentReportUrl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetChangeLogs` operation.
    ///
    /// See [`GetChangeLogs`](crate::client::fluent_builders::GetChangeLogs) for more information about the
    /// operation and its arguments.
    pub fn get_change_logs(&self) -> fluent_builders::GetChangeLogs<C, M, R> {
        fluent_builders::GetChangeLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetControl` operation.
    ///
    /// See [`GetControl`](crate::client::fluent_builders::GetControl) for more information about the
    /// operation and its arguments.
    pub fn get_control(&self) -> fluent_builders::GetControl<C, M, R> {
        fluent_builders::GetControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDelegations` operation.
    ///
    /// See [`GetDelegations`](crate::client::fluent_builders::GetDelegations) for more information about the
    /// operation and its arguments.
    pub fn get_delegations(&self) -> fluent_builders::GetDelegations<C, M, R> {
        fluent_builders::GetDelegations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEvidence` operation.
    ///
    /// See [`GetEvidence`](crate::client::fluent_builders::GetEvidence) for more information about the
    /// operation and its arguments.
    pub fn get_evidence(&self) -> fluent_builders::GetEvidence<C, M, R> {
        fluent_builders::GetEvidence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEvidenceByEvidenceFolder` operation.
    ///
    /// See [`GetEvidenceByEvidenceFolder`](crate::client::fluent_builders::GetEvidenceByEvidenceFolder) for more information about the
    /// operation and its arguments.
    pub fn get_evidence_by_evidence_folder(
        &self,
    ) -> fluent_builders::GetEvidenceByEvidenceFolder<C, M, R> {
        fluent_builders::GetEvidenceByEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEvidenceFolder` operation.
    ///
    /// See [`GetEvidenceFolder`](crate::client::fluent_builders::GetEvidenceFolder) for more information about the
    /// operation and its arguments.
    pub fn get_evidence_folder(&self) -> fluent_builders::GetEvidenceFolder<C, M, R> {
        fluent_builders::GetEvidenceFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEvidenceFoldersByAssessment` operation.
    ///
    /// See [`GetEvidenceFoldersByAssessment`](crate::client::fluent_builders::GetEvidenceFoldersByAssessment) for more information about the
    /// operation and its arguments.
    pub fn get_evidence_folders_by_assessment(
        &self,
    ) -> fluent_builders::GetEvidenceFoldersByAssessment<C, M, R> {
        fluent_builders::GetEvidenceFoldersByAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEvidenceFoldersByAssessmentControl` operation.
    ///
    /// See [`GetEvidenceFoldersByAssessmentControl`](crate::client::fluent_builders::GetEvidenceFoldersByAssessmentControl) for more information about the
    /// operation and its arguments.
    pub fn get_evidence_folders_by_assessment_control(
        &self,
    ) -> fluent_builders::GetEvidenceFoldersByAssessmentControl<C, M, R> {
        fluent_builders::GetEvidenceFoldersByAssessmentControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOrganizationAdminAccount` operation.
    ///
    /// See [`GetOrganizationAdminAccount`](crate::client::fluent_builders::GetOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn get_organization_admin_account(
        &self,
    ) -> fluent_builders::GetOrganizationAdminAccount<C, M, R> {
        fluent_builders::GetOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServicesInScope` operation.
    ///
    /// See [`GetServicesInScope`](crate::client::fluent_builders::GetServicesInScope) for more information about the
    /// operation and its arguments.
    pub fn get_services_in_scope(&self) -> fluent_builders::GetServicesInScope<C, M, R> {
        fluent_builders::GetServicesInScope::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSettings` operation.
    ///
    /// See [`GetSettings`](crate::client::fluent_builders::GetSettings) for more information about the
    /// operation and its arguments.
    pub fn get_settings(&self) -> fluent_builders::GetSettings<C, M, R> {
        fluent_builders::GetSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssessmentFrameworks` operation.
    ///
    /// See [`ListAssessmentFrameworks`](crate::client::fluent_builders::ListAssessmentFrameworks) for more information about the
    /// operation and its arguments.
    pub fn list_assessment_frameworks(&self) -> fluent_builders::ListAssessmentFrameworks<C, M, R> {
        fluent_builders::ListAssessmentFrameworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssessmentReports` operation.
    ///
    /// See [`ListAssessmentReports`](crate::client::fluent_builders::ListAssessmentReports) for more information about the
    /// operation and its arguments.
    pub fn list_assessment_reports(&self) -> fluent_builders::ListAssessmentReports<C, M, R> {
        fluent_builders::ListAssessmentReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssessments` operation.
    ///
    /// See [`ListAssessments`](crate::client::fluent_builders::ListAssessments) for more information about the
    /// operation and its arguments.
    pub fn list_assessments(&self) -> fluent_builders::ListAssessments<C, M, R> {
        fluent_builders::ListAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListControls` operation.
    ///
    /// See [`ListControls`](crate::client::fluent_builders::ListControls) for more information about the
    /// operation and its arguments.
    pub fn list_controls(&self) -> fluent_builders::ListControls<C, M, R> {
        fluent_builders::ListControls::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListKeywordsForDataSource` operation.
    ///
    /// See [`ListKeywordsForDataSource`](crate::client::fluent_builders::ListKeywordsForDataSource) for more information about the
    /// operation and its arguments.
    pub fn list_keywords_for_data_source(
        &self,
    ) -> fluent_builders::ListKeywordsForDataSource<C, M, R> {
        fluent_builders::ListKeywordsForDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNotifications` operation.
    ///
    /// See [`ListNotifications`](crate::client::fluent_builders::ListNotifications) for more information about the
    /// operation and its arguments.
    pub fn list_notifications(&self) -> fluent_builders::ListNotifications<C, M, R> {
        fluent_builders::ListNotifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterAccount` operation.
    ///
    /// See [`RegisterAccount`](crate::client::fluent_builders::RegisterAccount) for more information about the
    /// operation and its arguments.
    pub fn register_account(&self) -> fluent_builders::RegisterAccount<C, M, R> {
        fluent_builders::RegisterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterOrganizationAdminAccount` operation.
    ///
    /// See [`RegisterOrganizationAdminAccount`](crate::client::fluent_builders::RegisterOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn register_organization_admin_account(
        &self,
    ) -> fluent_builders::RegisterOrganizationAdminAccount<C, M, R> {
        fluent_builders::RegisterOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssessment` operation.
    ///
    /// See [`UpdateAssessment`](crate::client::fluent_builders::UpdateAssessment) for more information about the
    /// operation and its arguments.
    pub fn update_assessment(&self) -> fluent_builders::UpdateAssessment<C, M, R> {
        fluent_builders::UpdateAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssessmentControl` operation.
    ///
    /// See [`UpdateAssessmentControl`](crate::client::fluent_builders::UpdateAssessmentControl) for more information about the
    /// operation and its arguments.
    pub fn update_assessment_control(&self) -> fluent_builders::UpdateAssessmentControl<C, M, R> {
        fluent_builders::UpdateAssessmentControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssessmentControlSetStatus` operation.
    ///
    /// See [`UpdateAssessmentControlSetStatus`](crate::client::fluent_builders::UpdateAssessmentControlSetStatus) for more information about the
    /// operation and its arguments.
    pub fn update_assessment_control_set_status(
        &self,
    ) -> fluent_builders::UpdateAssessmentControlSetStatus<C, M, R> {
        fluent_builders::UpdateAssessmentControlSetStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssessmentFramework` operation.
    ///
    /// See [`UpdateAssessmentFramework`](crate::client::fluent_builders::UpdateAssessmentFramework) for more information about the
    /// operation and its arguments.
    pub fn update_assessment_framework(
        &self,
    ) -> fluent_builders::UpdateAssessmentFramework<C, M, R> {
        fluent_builders::UpdateAssessmentFramework::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAssessmentStatus` operation.
    ///
    /// See [`UpdateAssessmentStatus`](crate::client::fluent_builders::UpdateAssessmentStatus) for more information about the
    /// operation and its arguments.
    pub fn update_assessment_status(&self) -> fluent_builders::UpdateAssessmentStatus<C, M, R> {
        fluent_builders::UpdateAssessmentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateControl` operation.
    ///
    /// See [`UpdateControl`](crate::client::fluent_builders::UpdateControl) for more information about the
    /// operation and its arguments.
    pub fn update_control(&self) -> fluent_builders::UpdateControl<C, M, R> {
        fluent_builders::UpdateControl::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSettings` operation.
    ///
    /// See [`UpdateSettings`](crate::client::fluent_builders::UpdateSettings) for more information about the
    /// operation and its arguments.
    pub fn update_settings(&self) -> fluent_builders::UpdateSettings<C, M, R> {
        fluent_builders::UpdateSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ValidateAssessmentReportIntegrity` operation.
    ///
    /// See [`ValidateAssessmentReportIntegrity`](crate::client::fluent_builders::ValidateAssessmentReportIntegrity) for more information about the
    /// operation and its arguments.
    pub fn validate_assessment_report_integrity(
        &self,
    ) -> fluent_builders::ValidateAssessmentReportIntegrity<C, M, R> {
        fluent_builders::ValidateAssessmentReportIntegrity::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateAssessmentReportEvidenceFolder`.
    ///
    /// <p>
    /// Associates an evidence folder to the specified assessment report in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateAssessmentReportEvidenceFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_assessment_report_evidence_folder_input::Builder,
    }
    impl<C, M, R> AssociateAssessmentReportEvidenceFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateAssessmentReportEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateAssessmentReportEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateAssessmentReportEvidenceFolderError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateAssessmentReportEvidenceFolderInputOperationOutputAlias,
                crate::output::AssociateAssessmentReportEvidenceFolderOutput,
                crate::error::AssociateAssessmentReportEvidenceFolderError,
                crate::input::AssociateAssessmentReportEvidenceFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the folder in which evidence is stored.
        /// </p>
        pub fn evidence_folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(inp);
            self
        }
        /// <p>
        /// The identifier for the folder in which evidence is stored.
        /// </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateAssessmentReportEvidence`.
    ///
    /// <p>
    /// Associates a list of evidence to an assessment report in an Audit Manager assessment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchAssociateAssessmentReportEvidence<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_associate_assessment_report_evidence_input::Builder,
    }
    impl<C, M, R> BatchAssociateAssessmentReportEvidence<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchAssociateAssessmentReportEvidence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateAssessmentReportEvidenceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchAssociateAssessmentReportEvidenceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchAssociateAssessmentReportEvidenceInputOperationOutputAlias,
                crate::output::BatchAssociateAssessmentReportEvidenceOutput,
                crate::error::BatchAssociateAssessmentReportEvidenceError,
                crate::input::BatchAssociateAssessmentReportEvidenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The unique identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The unique identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn evidence_folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(inp);
            self
        }
        /// <p>
        /// The identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// Appends an item to `evidenceIds`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p>
        /// The list of evidence identifiers.
        /// </p>
        pub fn evidence_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_ids(inp);
            self
        }
        /// <p>
        /// The list of evidence identifiers.
        /// </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_evidence_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchCreateDelegationByAssessment`.
    ///
    /// <p>
    /// Create a batch of delegations for a specified assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchCreateDelegationByAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_create_delegation_by_assessment_input::Builder,
    }
    impl<C, M, R> BatchCreateDelegationByAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchCreateDelegationByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchCreateDelegationByAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchCreateDelegationByAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchCreateDelegationByAssessmentInputOperationOutputAlias,
                crate::output::BatchCreateDelegationByAssessmentOutput,
                crate::error::BatchCreateDelegationByAssessmentError,
                crate::input::BatchCreateDelegationByAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `createDelegationRequests`.
        ///
        /// To override the contents of this collection use [`set_create_delegation_requests`](Self::set_create_delegation_requests).
        ///
        /// <p>
        /// The API request to batch create delegations in Audit Manager.
        /// </p>
        pub fn create_delegation_requests(
            mut self,
            inp: impl Into<crate::model::CreateDelegationRequest>,
        ) -> Self {
            self.inner = self.inner.create_delegation_requests(inp);
            self
        }
        /// <p>
        /// The API request to batch create delegations in Audit Manager.
        /// </p>
        pub fn set_create_delegation_requests(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateDelegationRequest>>,
        ) -> Self {
            self.inner = self.inner.set_create_delegation_requests(input);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteDelegationByAssessment`.
    ///
    /// <p>
    /// Deletes the delegations in the specified Audit Manager assessment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteDelegationByAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_delegation_by_assessment_input::Builder,
    }
    impl<C, M, R> BatchDeleteDelegationByAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteDelegationByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteDelegationByAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteDelegationByAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteDelegationByAssessmentInputOperationOutputAlias,
                crate::output::BatchDeleteDelegationByAssessmentOutput,
                crate::error::BatchDeleteDelegationByAssessmentError,
                crate::input::BatchDeleteDelegationByAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `delegationIds`.
        ///
        /// To override the contents of this collection use [`set_delegation_ids`](Self::set_delegation_ids).
        ///
        /// <p>
        /// The identifiers for the specified delegations.
        /// </p>
        pub fn delegation_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegation_ids(inp);
            self
        }
        /// <p>
        /// The identifiers for the specified delegations.
        /// </p>
        pub fn set_delegation_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_delegation_ids(input);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateAssessmentReportEvidence`.
    ///
    /// <p>
    /// Disassociates a list of evidence from the specified assessment report in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDisassociateAssessmentReportEvidence<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_disassociate_assessment_report_evidence_input::Builder,
    }
    impl<C, M, R> BatchDisassociateAssessmentReportEvidence<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDisassociateAssessmentReportEvidence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateAssessmentReportEvidenceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchDisassociateAssessmentReportEvidenceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDisassociateAssessmentReportEvidenceInputOperationOutputAlias,
                crate::output::BatchDisassociateAssessmentReportEvidenceOutput,
                crate::error::BatchDisassociateAssessmentReportEvidenceError,
                crate::input::BatchDisassociateAssessmentReportEvidenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the folder in which evidence is stored.
        /// </p>
        pub fn evidence_folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(inp);
            self
        }
        /// <p>
        /// The identifier for the folder in which evidence is stored.
        /// </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// Appends an item to `evidenceIds`.
        ///
        /// To override the contents of this collection use [`set_evidence_ids`](Self::set_evidence_ids).
        ///
        /// <p>
        /// The list of evidence identifiers.
        /// </p>
        pub fn evidence_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_ids(inp);
            self
        }
        /// <p>
        /// The list of evidence identifiers.
        /// </p>
        pub fn set_evidence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_evidence_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchImportEvidenceToAssessmentControl`.
    ///
    /// <p>
    /// Uploads one or more pieces of evidence to the specified control in the assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchImportEvidenceToAssessmentControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_import_evidence_to_assessment_control_input::Builder,
    }
    impl<C, M, R> BatchImportEvidenceToAssessmentControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchImportEvidenceToAssessmentControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchImportEvidenceToAssessmentControlOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchImportEvidenceToAssessmentControlError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchImportEvidenceToAssessmentControlInputOperationOutputAlias,
                crate::output::BatchImportEvidenceToAssessmentControlOutput,
                crate::error::BatchImportEvidenceToAssessmentControlError,
                crate::input::BatchImportEvidenceToAssessmentControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// Appends an item to `manualEvidence`.
        ///
        /// To override the contents of this collection use [`set_manual_evidence`](Self::set_manual_evidence).
        ///
        /// <p>
        /// The list of manual evidence objects.
        /// </p>
        pub fn manual_evidence(mut self, inp: impl Into<crate::model::ManualEvidence>) -> Self {
            self.inner = self.inner.manual_evidence(inp);
            self
        }
        /// <p>
        /// The list of manual evidence objects.
        /// </p>
        pub fn set_manual_evidence(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ManualEvidence>>,
        ) -> Self {
            self.inner = self.inner.set_manual_evidence(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessment`.
    ///
    /// <p>
    /// Creates an assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_assessment_input::Builder,
    }
    impl<C, M, R> CreateAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssessmentInputOperationOutputAlias,
                crate::output::CreateAssessmentOutput,
                crate::error::CreateAssessmentError,
                crate::input::CreateAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the assessment to be created.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the assessment to be created.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The optional description of the assessment to be created.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// The optional description of the assessment to be created.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>
        /// The assessment report storage destination for the specified assessment that is being created.
        /// </p>
        pub fn assessment_reports_destination(
            mut self,
            inp: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.inner = self.inner.assessment_reports_destination(inp);
            self
        }
        /// <p>
        /// The assessment report storage destination for the specified assessment that is being created.
        /// </p>
        pub fn set_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.inner = self.inner.set_assessment_reports_destination(input);
            self
        }
        /// <p>
        /// The wrapper that contains the accounts and services in scope for the assessment.
        /// </p>
        pub fn scope(mut self, inp: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(inp);
            self
        }
        /// <p>
        /// The wrapper that contains the accounts and services in scope for the assessment.
        /// </p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>
        /// The list of roles for the specified assessment.
        /// </p>
        pub fn roles(mut self, inp: impl Into<crate::model::Role>) -> Self {
            self.inner = self.inner.roles(inp);
            self
        }
        /// <p>
        /// The list of roles for the specified assessment.
        /// </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.inner = self.inner.set_roles(input);
            self
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn framework_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The tags associated with the assessment.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// The tags associated with the assessment.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentFramework`.
    ///
    /// <p>
    /// Creates a custom framework in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssessmentFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_assessment_framework_input::Builder,
    }
    impl<C, M, R> CreateAssessmentFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssessmentFrameworkInputOperationOutputAlias,
                crate::output::CreateAssessmentFrameworkOutput,
                crate::error::CreateAssessmentFrameworkError,
                crate::input::CreateAssessmentFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the new custom framework.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the new custom framework.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// An optional description for the new custom framework.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// An optional description for the new custom framework.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>
        /// The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn compliance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compliance_type(inp);
            self
        }
        /// <p>
        /// The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compliance_type(input);
            self
        }
        /// Appends an item to `controlSets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p>
        /// The control sets to be associated with the framework.
        /// </p>
        pub fn control_sets(
            mut self,
            inp: impl Into<crate::model::CreateAssessmentFrameworkControlSet>,
        ) -> Self {
            self.inner = self.inner.control_sets(inp);
            self
        }
        /// <p>
        /// The control sets to be associated with the framework.
        /// </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CreateAssessmentFrameworkControlSet>,
            >,
        ) -> Self {
            self.inner = self.inner.set_control_sets(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The tags associated with the framework.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// The tags associated with the framework.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAssessmentReport`.
    ///
    /// <p>
    /// Creates an assessment report for the specified assessment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAssessmentReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_assessment_report_input::Builder,
    }
    impl<C, M, R> CreateAssessmentReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAssessmentReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAssessmentReportOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAssessmentReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAssessmentReportInputOperationOutputAlias,
                crate::output::CreateAssessmentReportOutput,
                crate::error::CreateAssessmentReportError,
                crate::input::CreateAssessmentReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the new assessment report.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the new assessment report.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The description of the assessment report.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// The description of the assessment report.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateControl`.
    ///
    /// <p>
    /// Creates a new custom control in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_control_input::Builder,
    }
    impl<C, M, R> CreateControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateControlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateControlInputOperationOutputAlias,
                crate::output::CreateControlOutput,
                crate::error::CreateControlError,
                crate::input::CreateControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the control.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the control.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The description of the control.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// The description of the control.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>
        /// The steps to follow to determine if the control has been satisfied.
        /// </p>
        pub fn testing_information(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.testing_information(inp);
            self
        }
        /// <p>
        /// The steps to follow to determine if the control has been satisfied.
        /// </p>
        pub fn set_testing_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_testing_information(input);
            self
        }
        /// <p>
        /// The title of the action plan for remediating the control.
        /// </p>
        pub fn action_plan_title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_title(inp);
            self
        }
        /// <p>
        /// The title of the action plan for remediating the control.
        /// </p>
        pub fn set_action_plan_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_title(input);
            self
        }
        /// <p>
        /// The recommended actions to carry out if the control is not fulfilled.
        /// </p>
        pub fn action_plan_instructions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_instructions(inp);
            self
        }
        /// <p>
        /// The recommended actions to carry out if the control is not fulfilled.
        /// </p>
        pub fn set_action_plan_instructions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_instructions(input);
            self
        }
        /// Appends an item to `controlMappingSources`.
        ///
        /// To override the contents of this collection use [`set_control_mapping_sources`](Self::set_control_mapping_sources).
        ///
        /// <p>
        /// The data mapping sources for the specified control.
        /// </p>
        pub fn control_mapping_sources(
            mut self,
            inp: impl Into<crate::model::CreateControlMappingSource>,
        ) -> Self {
            self.inner = self.inner.control_mapping_sources(inp);
            self
        }
        /// <p>
        /// The data mapping sources for the specified control.
        /// </p>
        pub fn set_control_mapping_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CreateControlMappingSource>>,
        ) -> Self {
            self.inner = self.inner.set_control_mapping_sources(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The tags associated with the control.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// The tags associated with the control.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessment`.
    ///
    /// <p>
    /// Deletes an assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_assessment_input::Builder,
    }
    impl<C, M, R> DeleteAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssessmentInputOperationOutputAlias,
                crate::output::DeleteAssessmentOutput,
                crate::error::DeleteAssessmentError,
                crate::input::DeleteAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentFramework`.
    ///
    /// <p>
    /// Deletes a custom framework in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssessmentFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_assessment_framework_input::Builder,
    }
    impl<C, M, R> DeleteAssessmentFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssessmentFrameworkInputOperationOutputAlias,
                crate::output::DeleteAssessmentFrameworkOutput,
                crate::error::DeleteAssessmentFrameworkError,
                crate::input::DeleteAssessmentFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn framework_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAssessmentReport`.
    ///
    /// <p>
    /// Deletes an assessment report from an assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAssessmentReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_assessment_report_input::Builder,
    }
    impl<C, M, R> DeleteAssessmentReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAssessmentReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAssessmentReportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAssessmentReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAssessmentReportInputOperationOutputAlias,
                crate::output::DeleteAssessmentReportOutput,
                crate::error::DeleteAssessmentReportError,
                crate::input::DeleteAssessmentReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The unique identifier for the assessment report.
        /// </p>
        pub fn assessment_report_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_report_id(inp);
            self
        }
        /// <p>
        /// The unique identifier for the assessment report.
        /// </p>
        pub fn set_assessment_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_report_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteControl`.
    ///
    /// <p>
    /// Deletes a custom control in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_control_input::Builder,
    }
    impl<C, M, R> DeleteControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteControlOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteControlInputOperationOutputAlias,
                crate::output::DeleteControlOutput,
                crate::error::DeleteControlError,
                crate::input::DeleteControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified control.
        /// </p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control.
        /// </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeregisterAccount`.
    ///
    /// <p>
    /// Deregisters an account in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_account_input::Builder,
    }
    impl<C, M, R> DeregisterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DeregisterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterAccountInputOperationOutputAlias,
                crate::output::DeregisterAccountOutput,
                crate::error::DeregisterAccountError,
                crate::input::DeregisterAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeregisterOrganizationAdminAccount`.
    ///
    /// <p>Removes the specified member account as a delegated administrator for Audit Manager. </p>
    /// <important>
    /// <p>When you remove a delegated administrator from your Audit Manager settings, or when you
    /// deregister a delegated administrator from Organizations, you continue to have access
    /// to the evidence that you previously collected under that account. However, Audit Manager
    /// will stop collecting and attaching evidence to that delegated administrator account
    /// moving forward.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeregisterOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deregister_organization_admin_account_input::Builder,
    }
    impl<C, M, R> DeregisterOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeregisterOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeregisterOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeregisterOrganizationAdminAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeregisterOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::DeregisterOrganizationAdminAccountOutput,
                crate::error::DeregisterOrganizationAdminAccountError,
                crate::input::DeregisterOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified administrator account.
        /// </p>
        pub fn admin_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified administrator account.
        /// </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateAssessmentReportEvidenceFolder`.
    ///
    /// <p>
    /// Disassociates an evidence folder from the specified assessment report in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateAssessmentReportEvidenceFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_assessment_report_evidence_folder_input::Builder,
    }
    impl<C, M, R> DisassociateAssessmentReportEvidenceFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateAssessmentReportEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateAssessmentReportEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateAssessmentReportEvidenceFolderError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateAssessmentReportEvidenceFolderInputOperationOutputAlias,
                crate::output::DisassociateAssessmentReportEvidenceFolderOutput,
                crate::error::DisassociateAssessmentReportEvidenceFolderError,
                crate::input::DisassociateAssessmentReportEvidenceFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the folder in which evidence is stored.
        /// </p>
        pub fn evidence_folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(inp);
            self
        }
        /// <p>
        /// The identifier for the folder in which evidence is stored.
        /// </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccountStatus`.
    ///
    /// <p>
    /// Returns the registration status of an account in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccountStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_account_status_input::Builder,
    }
    impl<C, M, R> GetAccountStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccountStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccountStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccountStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccountStatusInputOperationOutputAlias,
                crate::output::GetAccountStatusOutput,
                crate::error::GetAccountStatusError,
                crate::input::GetAccountStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetAssessment`.
    ///
    /// <p>
    /// Returns an assessment from Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_assessment_input::Builder,
    }
    impl<C, M, R> GetAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssessmentInputOperationOutputAlias,
                crate::output::GetAssessmentOutput,
                crate::error::GetAssessmentError,
                crate::input::GetAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessmentFramework`.
    ///
    /// <p>
    /// Returns a framework from Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAssessmentFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_assessment_framework_input::Builder,
    }
    impl<C, M, R> GetAssessmentFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssessmentFrameworkInputOperationOutputAlias,
                crate::output::GetAssessmentFrameworkOutput,
                crate::error::GetAssessmentFrameworkError,
                crate::input::GetAssessmentFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn framework_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAssessmentReportUrl`.
    ///
    /// <p>
    /// Returns the URL of a specified assessment report in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetAssessmentReportUrl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_assessment_report_url_input::Builder,
    }
    impl<C, M, R> GetAssessmentReportUrl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAssessmentReportUrl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAssessmentReportUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAssessmentReportUrlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAssessmentReportUrlInputOperationOutputAlias,
                crate::output::GetAssessmentReportUrlOutput,
                crate::error::GetAssessmentReportUrlError,
                crate::input::GetAssessmentReportUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the assessment report.
        /// </p>
        pub fn assessment_report_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_report_id(inp);
            self
        }
        /// <p>
        /// The identifier for the assessment report.
        /// </p>
        pub fn set_assessment_report_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_report_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetChangeLogs`.
    ///
    /// <p>
    /// Returns a list of changelogs from Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetChangeLogs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_change_logs_input::Builder,
    }
    impl<C, M, R> GetChangeLogs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetChangeLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetChangeLogsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetChangeLogsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetChangeLogsInputOperationOutputAlias,
                crate::output::GetChangeLogsOutput,
                crate::error::GetChangeLogsError,
                crate::input::GetChangeLogsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetControl`.
    ///
    /// <p>
    /// Returns a control from Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_control_input::Builder,
    }
    impl<C, M, R> GetControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetControlOutput,
            aws_smithy_http::result::SdkError<crate::error::GetControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetControlInputOperationOutputAlias,
                crate::output::GetControlOutput,
                crate::error::GetControlError,
                crate::input::GetControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDelegations`.
    ///
    /// <p>
    /// Returns a list of delegations from an audit owner to a delegate.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetDelegations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_delegations_input::Builder,
    }
    impl<C, M, R> GetDelegations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDelegations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDelegationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDelegationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDelegationsInputOperationOutputAlias,
                crate::output::GetDelegationsOutput,
                crate::error::GetDelegationsError,
                crate::input::GetDelegationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidence`.
    ///
    /// <p>
    /// Returns evidence from Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetEvidence<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_evidence_input::Builder,
    }
    impl<C, M, R> GetEvidence<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEvidence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEvidenceInputOperationOutputAlias,
                crate::output::GetEvidenceOutput,
                crate::error::GetEvidenceError,
                crate::input::GetEvidenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        /// The identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn evidence_folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(inp);
            self
        }
        /// <p>
        /// The identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// <p>
        /// The identifier for the evidence.
        /// </p>
        pub fn evidence_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_id(inp);
            self
        }
        /// <p>
        /// The identifier for the evidence.
        /// </p>
        pub fn set_evidence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_evidence_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceByEvidenceFolder`.
    ///
    /// <p>
    /// Returns all evidence from a specified evidence folder in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetEvidenceByEvidenceFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_evidence_by_evidence_folder_input::Builder,
    }
    impl<C, M, R> GetEvidenceByEvidenceFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEvidenceByEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceByEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceByEvidenceFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEvidenceByEvidenceFolderInputOperationOutputAlias,
                crate::output::GetEvidenceByEvidenceFolderOutput,
                crate::error::GetEvidenceByEvidenceFolderError,
                crate::input::GetEvidenceByEvidenceFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        /// The unique identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn evidence_folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(inp);
            self
        }
        /// <p>
        /// The unique identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceFolder`.
    ///
    /// <p>
    /// Returns an evidence folder from the specified assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetEvidenceFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_evidence_folder_input::Builder,
    }
    impl<C, M, R> GetEvidenceFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEvidenceFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEvidenceFolderInputOperationOutputAlias,
                crate::output::GetEvidenceFolderOutput,
                crate::error::GetEvidenceFolderError,
                crate::input::GetEvidenceFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        /// The identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn evidence_folder_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evidence_folder_id(inp);
            self
        }
        /// <p>
        /// The identifier for the folder in which the evidence is stored.
        /// </p>
        pub fn set_evidence_folder_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evidence_folder_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceFoldersByAssessment`.
    ///
    /// <p>
    /// Returns the evidence folders from a specified assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetEvidenceFoldersByAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_evidence_folders_by_assessment_input::Builder,
    }
    impl<C, M, R> GetEvidenceFoldersByAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEvidenceFoldersByAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceFoldersByAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvidenceFoldersByAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEvidenceFoldersByAssessmentInputOperationOutputAlias,
                crate::output::GetEvidenceFoldersByAssessmentOutput,
                crate::error::GetEvidenceFoldersByAssessmentError,
                crate::input::GetEvidenceFoldersByAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvidenceFoldersByAssessmentControl`.
    ///
    /// <p>
    /// Returns a list of evidence folders associated with a specified control of an assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetEvidenceFoldersByAssessmentControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_evidence_folders_by_assessment_control_input::Builder,
    }
    impl<C, M, R> GetEvidenceFoldersByAssessmentControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEvidenceFoldersByAssessmentControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvidenceFoldersByAssessmentControlOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetEvidenceFoldersByAssessmentControlError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEvidenceFoldersByAssessmentControlInputOperationOutputAlias,
                crate::output::GetEvidenceFoldersByAssessmentControlOutput,
                crate::error::GetEvidenceFoldersByAssessmentControlError,
                crate::input::GetEvidenceFoldersByAssessmentControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control.
        /// </p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control.
        /// </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOrganizationAdminAccount`.
    ///
    /// <p>
    /// Returns the name of the delegated Amazon Web Services administrator account for the organization.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_organization_admin_account_input::Builder,
    }
    impl<C, M, R> GetOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::GetOrganizationAdminAccountOutput,
                crate::error::GetOrganizationAdminAccountError,
                crate::input::GetOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetServicesInScope`.
    ///
    /// <p>
    /// Returns a list of the in-scope Amazon Web Services services for the specified assessment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetServicesInScope<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_services_in_scope_input::Builder,
    }
    impl<C, M, R> GetServicesInScope<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServicesInScope`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServicesInScopeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServicesInScopeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServicesInScopeInputOperationOutputAlias,
                crate::output::GetServicesInScopeOutput,
                crate::error::GetServicesInScopeError,
                crate::input::GetServicesInScopeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetSettings`.
    ///
    /// <p>
    /// Returns the settings for the specified account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_settings_input::Builder,
    }
    impl<C, M, R> GetSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSettingsInputOperationOutputAlias,
                crate::output::GetSettingsOutput,
                crate::error::GetSettingsError,
                crate::input::GetSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The list of <code>SettingAttribute</code> enum values.
        /// </p>
        pub fn attribute(mut self, inp: crate::model::SettingAttribute) -> Self {
            self.inner = self.inner.attribute(inp);
            self
        }
        /// <p>
        /// The list of <code>SettingAttribute</code> enum values.
        /// </p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::SettingAttribute>,
        ) -> Self {
            self.inner = self.inner.set_attribute(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentFrameworks`.
    ///
    /// <p>
    /// Returns a list of the frameworks available in the Audit Manager framework library.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssessmentFrameworks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assessment_frameworks_input::Builder,
    }
    impl<C, M, R> ListAssessmentFrameworks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssessmentFrameworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentFrameworksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentFrameworksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssessmentFrameworksInputOperationOutputAlias,
                crate::output::ListAssessmentFrameworksOutput,
                crate::error::ListAssessmentFrameworksError,
                crate::input::ListAssessmentFrameworksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The type of framework, such as standard or custom.
        /// </p>
        pub fn framework_type(mut self, inp: crate::model::FrameworkType) -> Self {
            self.inner = self.inner.framework_type(inp);
            self
        }
        /// <p>
        /// The type of framework, such as standard or custom.
        /// </p>
        pub fn set_framework_type(
            mut self,
            input: std::option::Option<crate::model::FrameworkType>,
        ) -> Self {
            self.inner = self.inner.set_framework_type(input);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessmentReports`.
    ///
    /// <p>
    /// Returns a list of assessment reports created in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssessmentReports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assessment_reports_input::Builder,
    }
    impl<C, M, R> ListAssessmentReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssessmentReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssessmentReportsInputOperationOutputAlias,
                crate::output::ListAssessmentReportsOutput,
                crate::error::ListAssessmentReportsError,
                crate::input::ListAssessmentReportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssessments`.
    ///
    /// <p>
    /// Returns a list of current and past assessments from Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssessments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_assessments_input::Builder,
    }
    impl<C, M, R> ListAssessments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssessmentsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssessmentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssessmentsInputOperationOutputAlias,
                crate::output::ListAssessmentsOutput,
                crate::error::ListAssessmentsError,
                crate::input::ListAssessmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListControls`.
    ///
    /// <p>
    /// Returns a list of controls from Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListControls<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_controls_input::Builder,
    }
    impl<C, M, R> ListControls<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListControls`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListControlsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListControlsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListControlsInputOperationOutputAlias,
                crate::output::ListControlsOutput,
                crate::error::ListControlsError,
                crate::input::ListControlsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The type of control, such as standard or custom.
        /// </p>
        pub fn control_type(mut self, inp: crate::model::ControlType) -> Self {
            self.inner = self.inner.control_type(inp);
            self
        }
        /// <p>
        /// The type of control, such as standard or custom.
        /// </p>
        pub fn set_control_type(
            mut self,
            input: std::option::Option<crate::model::ControlType>,
        ) -> Self {
            self.inner = self.inner.set_control_type(input);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListKeywordsForDataSource`.
    ///
    /// <p>
    /// Returns a list of keywords that pre-mapped to the specified control data source.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListKeywordsForDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_keywords_for_data_source_input::Builder,
    }
    impl<C, M, R> ListKeywordsForDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListKeywordsForDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListKeywordsForDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListKeywordsForDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListKeywordsForDataSourceInputOperationOutputAlias,
                crate::output::ListKeywordsForDataSourceOutput,
                crate::error::ListKeywordsForDataSourceError,
                crate::input::ListKeywordsForDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The control mapping data source to which the keywords apply.
        /// </p>
        pub fn source(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>
        /// The control mapping data source to which the keywords apply.
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<crate::model::SourceType>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNotifications`.
    ///
    /// <p>
    /// Returns a list of all Audit Manager notifications.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListNotifications<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_notifications_input::Builder,
    }
    impl<C, M, R> ListNotifications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNotifications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNotificationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNotificationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNotificationsInputOperationOutputAlias,
                crate::output::ListNotificationsOutput,
                crate::error::ListNotificationsError,
                crate::input::ListNotificationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token used to fetch the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// Represents the maximum number of results per page, or per API request call.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>
    /// Returns a list of tags for the specified resource in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the specified resource.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the specified resource.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterAccount`.
    ///
    /// <p>
    /// Enables Audit Manager for the specified account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_account_input::Builder,
    }
    impl<C, M, R> RegisterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterAccountInputOperationOutputAlias,
                crate::output::RegisterAccountOutput,
                crate::error::RegisterAccountError,
                crate::input::RegisterAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The KMS key details.
        /// </p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>
        /// The KMS key details.
        /// </p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
        /// <p>
        /// The delegated administrator account for Audit Manager.
        /// </p>
        pub fn delegated_admin_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.delegated_admin_account(inp);
            self
        }
        /// <p>
        /// The delegated administrator account for Audit Manager.
        /// </p>
        pub fn set_delegated_admin_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_delegated_admin_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterOrganizationAdminAccount`.
    ///
    /// <p>
    /// Enables an account within the organization as the delegated administrator for Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct RegisterOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_organization_admin_account_input::Builder,
    }
    impl<C, M, R> RegisterOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::RegisterOrganizationAdminAccountOutput,
                crate::error::RegisterOrganizationAdminAccountError,
                crate::input::RegisterOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified delegated administrator account.
        /// </p>
        pub fn admin_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified delegated administrator account.
        /// </p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>
    /// Tags the specified resource in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the specified resource.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the specified resource.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// The tags to be associated with the resource.
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>
        /// The tags to be associated with the resource.
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>
    /// Removes a tag from a resource in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the specified resource.
        /// </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>
        /// The Amazon Resource Name (ARN) of the specified resource.
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>
        /// The name or key of the tag.
        /// </p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>
        /// The name or key of the tag.
        /// </p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessment`.
    ///
    /// <p>
    /// Edits an Audit Manager assessment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_assessment_input::Builder,
    }
    impl<C, M, R> UpdateAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssessmentInputOperationOutputAlias,
                crate::output::UpdateAssessmentOutput,
                crate::error::UpdateAssessmentError,
                crate::input::UpdateAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The name of the specified assessment to be updated.
        /// </p>
        pub fn assessment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_name(inp);
            self
        }
        /// <p>
        /// The name of the specified assessment to be updated.
        /// </p>
        pub fn set_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_name(input);
            self
        }
        /// <p>
        /// The description of the specified assessment.
        /// </p>
        pub fn assessment_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_description(inp);
            self
        }
        /// <p>
        /// The description of the specified assessment.
        /// </p>
        pub fn set_assessment_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_description(input);
            self
        }
        /// <p>
        /// The scope of the specified assessment.
        /// </p>
        pub fn scope(mut self, inp: crate::model::Scope) -> Self {
            self.inner = self.inner.scope(inp);
            self
        }
        /// <p>
        /// The scope of the specified assessment.
        /// </p>
        pub fn set_scope(mut self, input: std::option::Option<crate::model::Scope>) -> Self {
            self.inner = self.inner.set_scope(input);
            self
        }
        /// <p>
        /// The assessment report storage destination for the specified assessment that is being updated.
        /// </p>
        pub fn assessment_reports_destination(
            mut self,
            inp: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.inner = self.inner.assessment_reports_destination(inp);
            self
        }
        /// <p>
        /// The assessment report storage destination for the specified assessment that is being updated.
        /// </p>
        pub fn set_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.inner = self.inner.set_assessment_reports_destination(input);
            self
        }
        /// Appends an item to `roles`.
        ///
        /// To override the contents of this collection use [`set_roles`](Self::set_roles).
        ///
        /// <p>
        /// The list of roles for the specified assessment.
        /// </p>
        pub fn roles(mut self, inp: impl Into<crate::model::Role>) -> Self {
            self.inner = self.inner.roles(inp);
            self
        }
        /// <p>
        /// The list of roles for the specified assessment.
        /// </p>
        pub fn set_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.inner = self.inner.set_roles(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentControl`.
    ///
    /// <p>
    /// Updates a control within an assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssessmentControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_assessment_control_input::Builder,
    }
    impl<C, M, R> UpdateAssessmentControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssessmentControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentControlOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssessmentControlInputOperationOutputAlias,
                crate::output::UpdateAssessmentControlOutput,
                crate::error::UpdateAssessmentControlError,
                crate::input::UpdateAssessmentControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>
        ///
        /// The identifier for the specified control.
        /// </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p>
        /// The status of the specified control.
        /// </p>
        pub fn control_status(mut self, inp: crate::model::ControlStatus) -> Self {
            self.inner = self.inner.control_status(inp);
            self
        }
        /// <p>
        /// The status of the specified control.
        /// </p>
        pub fn set_control_status(
            mut self,
            input: std::option::Option<crate::model::ControlStatus>,
        ) -> Self {
            self.inner = self.inner.set_control_status(input);
            self
        }
        /// <p>
        /// The comment body text for the specified control.
        /// </p>
        pub fn comment_body(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_body(inp);
            self
        }
        /// <p>
        /// The comment body text for the specified control.
        /// </p>
        pub fn set_comment_body(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_body(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentControlSetStatus`.
    ///
    /// <p>
    /// Updates the status of a control set in an Audit Manager assessment.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssessmentControlSetStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_assessment_control_set_status_input::Builder,
    }
    impl<C, M, R> UpdateAssessmentControlSetStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssessmentControlSetStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentControlSetStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentControlSetStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssessmentControlSetStatusInputOperationOutputAlias,
                crate::output::UpdateAssessmentControlSetStatusOutput,
                crate::error::UpdateAssessmentControlSetStatusError,
                crate::input::UpdateAssessmentControlSetStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn control_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_set_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control set.
        /// </p>
        pub fn set_control_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_control_set_id(input);
            self
        }
        /// <p>
        /// The status of the control set that is being updated.
        /// </p>
        pub fn status(mut self, inp: crate::model::ControlSetStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>
        /// The status of the control set that is being updated.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ControlSetStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>
        /// The comment related to the status update.
        /// </p>
        pub fn comment(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment(inp);
            self
        }
        /// <p>
        /// The comment related to the status update.
        /// </p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentFramework`.
    ///
    /// <p>
    /// Updates a custom framework in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssessmentFramework<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_assessment_framework_input::Builder,
    }
    impl<C, M, R> UpdateAssessmentFramework<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssessmentFramework`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentFrameworkOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentFrameworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssessmentFrameworkInputOperationOutputAlias,
                crate::output::UpdateAssessmentFrameworkOutput,
                crate::error::UpdateAssessmentFrameworkError,
                crate::input::UpdateAssessmentFrameworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn framework_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified framework.
        /// </p>
        pub fn set_framework_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_framework_id(input);
            self
        }
        /// <p>
        /// The name of the framework to be updated.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the framework to be updated.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The description of the framework that is to be updated.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// The description of the framework that is to be updated.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>
        /// The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn compliance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.compliance_type(inp);
            self
        }
        /// <p>
        /// The compliance type that the new custom framework supports, such as CIS or HIPAA.
        /// </p>
        pub fn set_compliance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_compliance_type(input);
            self
        }
        /// Appends an item to `controlSets`.
        ///
        /// To override the contents of this collection use [`set_control_sets`](Self::set_control_sets).
        ///
        /// <p>
        /// The control sets associated with the framework.
        /// </p>
        pub fn control_sets(
            mut self,
            inp: impl Into<crate::model::UpdateAssessmentFrameworkControlSet>,
        ) -> Self {
            self.inner = self.inner.control_sets(inp);
            self
        }
        /// <p>
        /// The control sets associated with the framework.
        /// </p>
        pub fn set_control_sets(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::UpdateAssessmentFrameworkControlSet>,
            >,
        ) -> Self {
            self.inner = self.inner.set_control_sets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAssessmentStatus`.
    ///
    /// <p>
    /// Updates the status of an assessment in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAssessmentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_assessment_status_input::Builder,
    }
    impl<C, M, R> UpdateAssessmentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAssessmentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAssessmentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAssessmentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAssessmentStatusInputOperationOutputAlias,
                crate::output::UpdateAssessmentStatusOutput,
                crate::error::UpdateAssessmentStatusError,
                crate::input::UpdateAssessmentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn assessment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified assessment.
        /// </p>
        pub fn set_assessment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_id(input);
            self
        }
        /// <p>
        /// The current status of the specified assessment.
        /// </p>
        pub fn status(mut self, inp: crate::model::AssessmentStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>
        /// The current status of the specified assessment.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AssessmentStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateControl`.
    ///
    /// <p>
    /// Updates a custom control in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateControl<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_control_input::Builder,
    }
    impl<C, M, R> UpdateControl<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateControl`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateControlOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateControlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateControlInputOperationOutputAlias,
                crate::output::UpdateControlOutput,
                crate::error::UpdateControlError,
                crate::input::UpdateControlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The identifier for the specified control.
        /// </p>
        pub fn control_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.control_id(inp);
            self
        }
        /// <p>
        /// The identifier for the specified control.
        /// </p>
        pub fn set_control_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_control_id(input);
            self
        }
        /// <p>
        /// The name of the control to be updated.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the control to be updated.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The optional description of the control.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// The optional description of the control.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>
        /// The steps that to follow to determine if the control has been satisfied.
        /// </p>
        pub fn testing_information(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.testing_information(inp);
            self
        }
        /// <p>
        /// The steps that to follow to determine if the control has been satisfied.
        /// </p>
        pub fn set_testing_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_testing_information(input);
            self
        }
        /// <p>
        /// The title of the action plan for remediating the control.
        /// </p>
        pub fn action_plan_title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_title(inp);
            self
        }
        /// <p>
        /// The title of the action plan for remediating the control.
        /// </p>
        pub fn set_action_plan_title(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_title(input);
            self
        }
        /// <p>
        ///
        /// The recommended actions to carry out if the control is not fulfilled.
        /// </p>
        pub fn action_plan_instructions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action_plan_instructions(inp);
            self
        }
        /// <p>
        ///
        /// The recommended actions to carry out if the control is not fulfilled.
        /// </p>
        pub fn set_action_plan_instructions(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_action_plan_instructions(input);
            self
        }
        /// Appends an item to `controlMappingSources`.
        ///
        /// To override the contents of this collection use [`set_control_mapping_sources`](Self::set_control_mapping_sources).
        ///
        /// <p>
        /// The data mapping sources for the specified control.
        /// </p>
        pub fn control_mapping_sources(
            mut self,
            inp: impl Into<crate::model::ControlMappingSource>,
        ) -> Self {
            self.inner = self.inner.control_mapping_sources(inp);
            self
        }
        /// <p>
        /// The data mapping sources for the specified control.
        /// </p>
        pub fn set_control_mapping_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ControlMappingSource>>,
        ) -> Self {
            self.inner = self.inner.set_control_mapping_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSettings`.
    ///
    /// <p>
    /// Updates Audit Manager settings for the current user account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_settings_input::Builder,
    }
    impl<C, M, R> UpdateSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSettingsInputOperationOutputAlias,
                crate::output::UpdateSettingsOutput,
                crate::error::UpdateSettingsError,
                crate::input::UpdateSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The Amazon Simple Notification Service (Amazon SNS) topic to which Audit Manager sends notifications.
        /// </p>
        pub fn sns_topic(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic(inp);
            self
        }
        /// <p>
        /// The Amazon Simple Notification Service (Amazon SNS) topic to which Audit Manager sends notifications.
        /// </p>
        pub fn set_sns_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sns_topic(input);
            self
        }
        /// <p>
        /// The default storage destination for assessment reports.
        /// </p>
        pub fn default_assessment_reports_destination(
            mut self,
            inp: crate::model::AssessmentReportsDestination,
        ) -> Self {
            self.inner = self.inner.default_assessment_reports_destination(inp);
            self
        }
        /// <p>
        /// The default storage destination for assessment reports.
        /// </p>
        pub fn set_default_assessment_reports_destination(
            mut self,
            input: std::option::Option<crate::model::AssessmentReportsDestination>,
        ) -> Self {
            self.inner = self.inner.set_default_assessment_reports_destination(input);
            self
        }
        /// Appends an item to `defaultProcessOwners`.
        ///
        /// To override the contents of this collection use [`set_default_process_owners`](Self::set_default_process_owners).
        ///
        /// <p>
        /// A list of the default audit owners.
        /// </p>
        pub fn default_process_owners(mut self, inp: impl Into<crate::model::Role>) -> Self {
            self.inner = self.inner.default_process_owners(inp);
            self
        }
        /// <p>
        /// A list of the default audit owners.
        /// </p>
        pub fn set_default_process_owners(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Role>>,
        ) -> Self {
            self.inner = self.inner.set_default_process_owners(input);
            self
        }
        /// <p>
        /// The KMS key details.
        /// </p>
        pub fn kms_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key(inp);
            self
        }
        /// <p>
        /// The KMS key details.
        /// </p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ValidateAssessmentReportIntegrity`.
    ///
    /// <p>
    /// Validates the integrity of an assessment report in Audit Manager.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ValidateAssessmentReportIntegrity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::validate_assessment_report_integrity_input::Builder,
    }
    impl<C, M, R> ValidateAssessmentReportIntegrity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ValidateAssessmentReportIntegrity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ValidateAssessmentReportIntegrityOutput,
            aws_smithy_http::result::SdkError<crate::error::ValidateAssessmentReportIntegrityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ValidateAssessmentReportIntegrityInputOperationOutputAlias,
                crate::output::ValidateAssessmentReportIntegrityOutput,
                crate::error::ValidateAssessmentReportIntegrityError,
                crate::input::ValidateAssessmentReportIntegrityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The relative path of the specified Amazon S3 bucket in which the assessment report is stored.
        /// </p>
        pub fn s3_relative_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_relative_path(inp);
            self
        }
        /// <p>
        /// The relative path of the specified Amazon S3 bucket in which the assessment report is stored.
        /// </p>
        pub fn set_s3_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_relative_path(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
