// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchGetNamedQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_named_query`](crate::client::Client::batch_get_named_query).
///
/// See [`crate::client::fluent_builders::BatchGetNamedQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetNamedQuery {
    _private: (),
}
impl BatchGetNamedQuery {
    /// Creates a new builder-style object to manufacture [`BatchGetNamedQueryInput`](crate::input::BatchGetNamedQueryInput)
    pub fn builder() -> crate::input::batch_get_named_query_input::Builder {
        crate::input::batch_get_named_query_input::Builder::default()
    }
    /// Creates a new `BatchGetNamedQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetNamedQuery {
    type Output = std::result::Result<
        crate::output::BatchGetNamedQueryOutput,
        crate::error::BatchGetNamedQueryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_named_query_error(response)
        } else {
            crate::operation_deser::parse_batch_get_named_query_response(response)
        }
    }
}

/// Operation shape for `BatchGetQueryExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_query_execution`](crate::client::Client::batch_get_query_execution).
///
/// See [`crate::client::fluent_builders::BatchGetQueryExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetQueryExecution {
    _private: (),
}
impl BatchGetQueryExecution {
    /// Creates a new builder-style object to manufacture [`BatchGetQueryExecutionInput`](crate::input::BatchGetQueryExecutionInput)
    pub fn builder() -> crate::input::batch_get_query_execution_input::Builder {
        crate::input::batch_get_query_execution_input::Builder::default()
    }
    /// Creates a new `BatchGetQueryExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetQueryExecution {
    type Output = std::result::Result<
        crate::output::BatchGetQueryExecutionOutput,
        crate::error::BatchGetQueryExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_query_execution_error(response)
        } else {
            crate::operation_deser::parse_batch_get_query_execution_response(response)
        }
    }
}

/// Operation shape for `CreateDataCatalog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_catalog`](crate::client::Client::create_data_catalog).
///
/// See [`crate::client::fluent_builders::CreateDataCatalog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataCatalog {
    _private: (),
}
impl CreateDataCatalog {
    /// Creates a new builder-style object to manufacture [`CreateDataCatalogInput`](crate::input::CreateDataCatalogInput)
    pub fn builder() -> crate::input::create_data_catalog_input::Builder {
        crate::input::create_data_catalog_input::Builder::default()
    }
    /// Creates a new `CreateDataCatalog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataCatalog {
    type Output = std::result::Result<
        crate::output::CreateDataCatalogOutput,
        crate::error::CreateDataCatalogError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_catalog_error(response)
        } else {
            crate::operation_deser::parse_create_data_catalog_response(response)
        }
    }
}

/// Operation shape for `CreateNamedQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_named_query`](crate::client::Client::create_named_query).
///
/// See [`crate::client::fluent_builders::CreateNamedQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNamedQuery {
    _private: (),
}
impl CreateNamedQuery {
    /// Creates a new builder-style object to manufacture [`CreateNamedQueryInput`](crate::input::CreateNamedQueryInput)
    pub fn builder() -> crate::input::create_named_query_input::Builder {
        crate::input::create_named_query_input::Builder::default()
    }
    /// Creates a new `CreateNamedQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNamedQuery {
    type Output = std::result::Result<
        crate::output::CreateNamedQueryOutput,
        crate::error::CreateNamedQueryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_named_query_error(response)
        } else {
            crate::operation_deser::parse_create_named_query_response(response)
        }
    }
}

/// Operation shape for `CreatePreparedStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_prepared_statement`](crate::client::Client::create_prepared_statement).
///
/// See [`crate::client::fluent_builders::CreatePreparedStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePreparedStatement {
    _private: (),
}
impl CreatePreparedStatement {
    /// Creates a new builder-style object to manufacture [`CreatePreparedStatementInput`](crate::input::CreatePreparedStatementInput)
    pub fn builder() -> crate::input::create_prepared_statement_input::Builder {
        crate::input::create_prepared_statement_input::Builder::default()
    }
    /// Creates a new `CreatePreparedStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePreparedStatement {
    type Output = std::result::Result<
        crate::output::CreatePreparedStatementOutput,
        crate::error::CreatePreparedStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_prepared_statement_error(response)
        } else {
            crate::operation_deser::parse_create_prepared_statement_response(response)
        }
    }
}

/// Operation shape for `CreateWorkGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_work_group`](crate::client::Client::create_work_group).
///
/// See [`crate::client::fluent_builders::CreateWorkGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWorkGroup {
    _private: (),
}
impl CreateWorkGroup {
    /// Creates a new builder-style object to manufacture [`CreateWorkGroupInput`](crate::input::CreateWorkGroupInput)
    pub fn builder() -> crate::input::create_work_group_input::Builder {
        crate::input::create_work_group_input::Builder::default()
    }
    /// Creates a new `CreateWorkGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWorkGroup {
    type Output = std::result::Result<
        crate::output::CreateWorkGroupOutput,
        crate::error::CreateWorkGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_work_group_error(response)
        } else {
            crate::operation_deser::parse_create_work_group_response(response)
        }
    }
}

/// Operation shape for `DeleteDataCatalog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_data_catalog`](crate::client::Client::delete_data_catalog).
///
/// See [`crate::client::fluent_builders::DeleteDataCatalog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataCatalog {
    _private: (),
}
impl DeleteDataCatalog {
    /// Creates a new builder-style object to manufacture [`DeleteDataCatalogInput`](crate::input::DeleteDataCatalogInput)
    pub fn builder() -> crate::input::delete_data_catalog_input::Builder {
        crate::input::delete_data_catalog_input::Builder::default()
    }
    /// Creates a new `DeleteDataCatalog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataCatalog {
    type Output = std::result::Result<
        crate::output::DeleteDataCatalogOutput,
        crate::error::DeleteDataCatalogError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_data_catalog_error(response)
        } else {
            crate::operation_deser::parse_delete_data_catalog_response(response)
        }
    }
}

/// Operation shape for `DeleteNamedQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_named_query`](crate::client::Client::delete_named_query).
///
/// See [`crate::client::fluent_builders::DeleteNamedQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNamedQuery {
    _private: (),
}
impl DeleteNamedQuery {
    /// Creates a new builder-style object to manufacture [`DeleteNamedQueryInput`](crate::input::DeleteNamedQueryInput)
    pub fn builder() -> crate::input::delete_named_query_input::Builder {
        crate::input::delete_named_query_input::Builder::default()
    }
    /// Creates a new `DeleteNamedQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNamedQuery {
    type Output = std::result::Result<
        crate::output::DeleteNamedQueryOutput,
        crate::error::DeleteNamedQueryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_named_query_error(response)
        } else {
            crate::operation_deser::parse_delete_named_query_response(response)
        }
    }
}

/// Operation shape for `DeletePreparedStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_prepared_statement`](crate::client::Client::delete_prepared_statement).
///
/// See [`crate::client::fluent_builders::DeletePreparedStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePreparedStatement {
    _private: (),
}
impl DeletePreparedStatement {
    /// Creates a new builder-style object to manufacture [`DeletePreparedStatementInput`](crate::input::DeletePreparedStatementInput)
    pub fn builder() -> crate::input::delete_prepared_statement_input::Builder {
        crate::input::delete_prepared_statement_input::Builder::default()
    }
    /// Creates a new `DeletePreparedStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePreparedStatement {
    type Output = std::result::Result<
        crate::output::DeletePreparedStatementOutput,
        crate::error::DeletePreparedStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_prepared_statement_error(response)
        } else {
            crate::operation_deser::parse_delete_prepared_statement_response(response)
        }
    }
}

/// Operation shape for `DeleteWorkGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_work_group`](crate::client::Client::delete_work_group).
///
/// See [`crate::client::fluent_builders::DeleteWorkGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWorkGroup {
    _private: (),
}
impl DeleteWorkGroup {
    /// Creates a new builder-style object to manufacture [`DeleteWorkGroupInput`](crate::input::DeleteWorkGroupInput)
    pub fn builder() -> crate::input::delete_work_group_input::Builder {
        crate::input::delete_work_group_input::Builder::default()
    }
    /// Creates a new `DeleteWorkGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWorkGroup {
    type Output = std::result::Result<
        crate::output::DeleteWorkGroupOutput,
        crate::error::DeleteWorkGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_work_group_error(response)
        } else {
            crate::operation_deser::parse_delete_work_group_response(response)
        }
    }
}

/// Operation shape for `GetDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_database`](crate::client::Client::get_database).
///
/// See [`crate::client::fluent_builders::GetDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDatabase {
    _private: (),
}
impl GetDatabase {
    /// Creates a new builder-style object to manufacture [`GetDatabaseInput`](crate::input::GetDatabaseInput)
    pub fn builder() -> crate::input::get_database_input::Builder {
        crate::input::get_database_input::Builder::default()
    }
    /// Creates a new `GetDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDatabase {
    type Output =
        std::result::Result<crate::output::GetDatabaseOutput, crate::error::GetDatabaseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_database_error(response)
        } else {
            crate::operation_deser::parse_get_database_response(response)
        }
    }
}

/// Operation shape for `GetDataCatalog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_data_catalog`](crate::client::Client::get_data_catalog).
///
/// See [`crate::client::fluent_builders::GetDataCatalog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataCatalog {
    _private: (),
}
impl GetDataCatalog {
    /// Creates a new builder-style object to manufacture [`GetDataCatalogInput`](crate::input::GetDataCatalogInput)
    pub fn builder() -> crate::input::get_data_catalog_input::Builder {
        crate::input::get_data_catalog_input::Builder::default()
    }
    /// Creates a new `GetDataCatalog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataCatalog {
    type Output =
        std::result::Result<crate::output::GetDataCatalogOutput, crate::error::GetDataCatalogError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_data_catalog_error(response)
        } else {
            crate::operation_deser::parse_get_data_catalog_response(response)
        }
    }
}

/// Operation shape for `GetNamedQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_named_query`](crate::client::Client::get_named_query).
///
/// See [`crate::client::fluent_builders::GetNamedQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNamedQuery {
    _private: (),
}
impl GetNamedQuery {
    /// Creates a new builder-style object to manufacture [`GetNamedQueryInput`](crate::input::GetNamedQueryInput)
    pub fn builder() -> crate::input::get_named_query_input::Builder {
        crate::input::get_named_query_input::Builder::default()
    }
    /// Creates a new `GetNamedQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNamedQuery {
    type Output =
        std::result::Result<crate::output::GetNamedQueryOutput, crate::error::GetNamedQueryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_named_query_error(response)
        } else {
            crate::operation_deser::parse_get_named_query_response(response)
        }
    }
}

/// Operation shape for `GetPreparedStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_prepared_statement`](crate::client::Client::get_prepared_statement).
///
/// See [`crate::client::fluent_builders::GetPreparedStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPreparedStatement {
    _private: (),
}
impl GetPreparedStatement {
    /// Creates a new builder-style object to manufacture [`GetPreparedStatementInput`](crate::input::GetPreparedStatementInput)
    pub fn builder() -> crate::input::get_prepared_statement_input::Builder {
        crate::input::get_prepared_statement_input::Builder::default()
    }
    /// Creates a new `GetPreparedStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPreparedStatement {
    type Output = std::result::Result<
        crate::output::GetPreparedStatementOutput,
        crate::error::GetPreparedStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_prepared_statement_error(response)
        } else {
            crate::operation_deser::parse_get_prepared_statement_response(response)
        }
    }
}

/// Operation shape for `GetQueryExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_query_execution`](crate::client::Client::get_query_execution).
///
/// See [`crate::client::fluent_builders::GetQueryExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQueryExecution {
    _private: (),
}
impl GetQueryExecution {
    /// Creates a new builder-style object to manufacture [`GetQueryExecutionInput`](crate::input::GetQueryExecutionInput)
    pub fn builder() -> crate::input::get_query_execution_input::Builder {
        crate::input::get_query_execution_input::Builder::default()
    }
    /// Creates a new `GetQueryExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQueryExecution {
    type Output = std::result::Result<
        crate::output::GetQueryExecutionOutput,
        crate::error::GetQueryExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_query_execution_error(response)
        } else {
            crate::operation_deser::parse_get_query_execution_response(response)
        }
    }
}

/// Operation shape for `GetQueryResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_query_results`](crate::client::Client::get_query_results).
///
/// See [`crate::client::fluent_builders::GetQueryResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQueryResults {
    _private: (),
}
impl GetQueryResults {
    /// Creates a new builder-style object to manufacture [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
    pub fn builder() -> crate::input::get_query_results_input::Builder {
        crate::input::get_query_results_input::Builder::default()
    }
    /// Creates a new `GetQueryResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQueryResults {
    type Output = std::result::Result<
        crate::output::GetQueryResultsOutput,
        crate::error::GetQueryResultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_query_results_error(response)
        } else {
            crate::operation_deser::parse_get_query_results_response(response)
        }
    }
}

/// Operation shape for `GetTableMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_table_metadata`](crate::client::Client::get_table_metadata).
///
/// See [`crate::client::fluent_builders::GetTableMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTableMetadata {
    _private: (),
}
impl GetTableMetadata {
    /// Creates a new builder-style object to manufacture [`GetTableMetadataInput`](crate::input::GetTableMetadataInput)
    pub fn builder() -> crate::input::get_table_metadata_input::Builder {
        crate::input::get_table_metadata_input::Builder::default()
    }
    /// Creates a new `GetTableMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTableMetadata {
    type Output = std::result::Result<
        crate::output::GetTableMetadataOutput,
        crate::error::GetTableMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_table_metadata_error(response)
        } else {
            crate::operation_deser::parse_get_table_metadata_response(response)
        }
    }
}

/// Operation shape for `GetWorkGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_work_group`](crate::client::Client::get_work_group).
///
/// See [`crate::client::fluent_builders::GetWorkGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetWorkGroup {
    _private: (),
}
impl GetWorkGroup {
    /// Creates a new builder-style object to manufacture [`GetWorkGroupInput`](crate::input::GetWorkGroupInput)
    pub fn builder() -> crate::input::get_work_group_input::Builder {
        crate::input::get_work_group_input::Builder::default()
    }
    /// Creates a new `GetWorkGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetWorkGroup {
    type Output =
        std::result::Result<crate::output::GetWorkGroupOutput, crate::error::GetWorkGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_work_group_error(response)
        } else {
            crate::operation_deser::parse_get_work_group_response(response)
        }
    }
}

/// Operation shape for `ListDatabases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_databases`](crate::client::Client::list_databases).
///
/// See [`crate::client::fluent_builders::ListDatabases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatabases {
    _private: (),
}
impl ListDatabases {
    /// Creates a new builder-style object to manufacture [`ListDatabasesInput`](crate::input::ListDatabasesInput)
    pub fn builder() -> crate::input::list_databases_input::Builder {
        crate::input::list_databases_input::Builder::default()
    }
    /// Creates a new `ListDatabases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatabases {
    type Output =
        std::result::Result<crate::output::ListDatabasesOutput, crate::error::ListDatabasesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_databases_error(response)
        } else {
            crate::operation_deser::parse_list_databases_response(response)
        }
    }
}

/// Operation shape for `ListDataCatalogs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_catalogs`](crate::client::Client::list_data_catalogs).
///
/// See [`crate::client::fluent_builders::ListDataCatalogs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataCatalogs {
    _private: (),
}
impl ListDataCatalogs {
    /// Creates a new builder-style object to manufacture [`ListDataCatalogsInput`](crate::input::ListDataCatalogsInput)
    pub fn builder() -> crate::input::list_data_catalogs_input::Builder {
        crate::input::list_data_catalogs_input::Builder::default()
    }
    /// Creates a new `ListDataCatalogs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataCatalogs {
    type Output = std::result::Result<
        crate::output::ListDataCatalogsOutput,
        crate::error::ListDataCatalogsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_catalogs_error(response)
        } else {
            crate::operation_deser::parse_list_data_catalogs_response(response)
        }
    }
}

/// Operation shape for `ListEngineVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_engine_versions`](crate::client::Client::list_engine_versions).
///
/// See [`crate::client::fluent_builders::ListEngineVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEngineVersions {
    _private: (),
}
impl ListEngineVersions {
    /// Creates a new builder-style object to manufacture [`ListEngineVersionsInput`](crate::input::ListEngineVersionsInput)
    pub fn builder() -> crate::input::list_engine_versions_input::Builder {
        crate::input::list_engine_versions_input::Builder::default()
    }
    /// Creates a new `ListEngineVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEngineVersions {
    type Output = std::result::Result<
        crate::output::ListEngineVersionsOutput,
        crate::error::ListEngineVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_engine_versions_error(response)
        } else {
            crate::operation_deser::parse_list_engine_versions_response(response)
        }
    }
}

/// Operation shape for `ListNamedQueries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_named_queries`](crate::client::Client::list_named_queries).
///
/// See [`crate::client::fluent_builders::ListNamedQueries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNamedQueries {
    _private: (),
}
impl ListNamedQueries {
    /// Creates a new builder-style object to manufacture [`ListNamedQueriesInput`](crate::input::ListNamedQueriesInput)
    pub fn builder() -> crate::input::list_named_queries_input::Builder {
        crate::input::list_named_queries_input::Builder::default()
    }
    /// Creates a new `ListNamedQueries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNamedQueries {
    type Output = std::result::Result<
        crate::output::ListNamedQueriesOutput,
        crate::error::ListNamedQueriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_named_queries_error(response)
        } else {
            crate::operation_deser::parse_list_named_queries_response(response)
        }
    }
}

/// Operation shape for `ListPreparedStatements`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_prepared_statements`](crate::client::Client::list_prepared_statements).
///
/// See [`crate::client::fluent_builders::ListPreparedStatements`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPreparedStatements {
    _private: (),
}
impl ListPreparedStatements {
    /// Creates a new builder-style object to manufacture [`ListPreparedStatementsInput`](crate::input::ListPreparedStatementsInput)
    pub fn builder() -> crate::input::list_prepared_statements_input::Builder {
        crate::input::list_prepared_statements_input::Builder::default()
    }
    /// Creates a new `ListPreparedStatements` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPreparedStatements {
    type Output = std::result::Result<
        crate::output::ListPreparedStatementsOutput,
        crate::error::ListPreparedStatementsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_prepared_statements_error(response)
        } else {
            crate::operation_deser::parse_list_prepared_statements_response(response)
        }
    }
}

/// Operation shape for `ListQueryExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_query_executions`](crate::client::Client::list_query_executions).
///
/// See [`crate::client::fluent_builders::ListQueryExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQueryExecutions {
    _private: (),
}
impl ListQueryExecutions {
    /// Creates a new builder-style object to manufacture [`ListQueryExecutionsInput`](crate::input::ListQueryExecutionsInput)
    pub fn builder() -> crate::input::list_query_executions_input::Builder {
        crate::input::list_query_executions_input::Builder::default()
    }
    /// Creates a new `ListQueryExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQueryExecutions {
    type Output = std::result::Result<
        crate::output::ListQueryExecutionsOutput,
        crate::error::ListQueryExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_query_executions_error(response)
        } else {
            crate::operation_deser::parse_list_query_executions_response(response)
        }
    }
}

/// Operation shape for `ListTableMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_table_metadata`](crate::client::Client::list_table_metadata).
///
/// See [`crate::client::fluent_builders::ListTableMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTableMetadata {
    _private: (),
}
impl ListTableMetadata {
    /// Creates a new builder-style object to manufacture [`ListTableMetadataInput`](crate::input::ListTableMetadataInput)
    pub fn builder() -> crate::input::list_table_metadata_input::Builder {
        crate::input::list_table_metadata_input::Builder::default()
    }
    /// Creates a new `ListTableMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTableMetadata {
    type Output = std::result::Result<
        crate::output::ListTableMetadataOutput,
        crate::error::ListTableMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_table_metadata_error(response)
        } else {
            crate::operation_deser::parse_list_table_metadata_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListWorkGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_work_groups`](crate::client::Client::list_work_groups).
///
/// See [`crate::client::fluent_builders::ListWorkGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListWorkGroups {
    _private: (),
}
impl ListWorkGroups {
    /// Creates a new builder-style object to manufacture [`ListWorkGroupsInput`](crate::input::ListWorkGroupsInput)
    pub fn builder() -> crate::input::list_work_groups_input::Builder {
        crate::input::list_work_groups_input::Builder::default()
    }
    /// Creates a new `ListWorkGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListWorkGroups {
    type Output =
        std::result::Result<crate::output::ListWorkGroupsOutput, crate::error::ListWorkGroupsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_work_groups_error(response)
        } else {
            crate::operation_deser::parse_list_work_groups_response(response)
        }
    }
}

/// Operation shape for `StartQueryExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_query_execution`](crate::client::Client::start_query_execution).
///
/// See [`crate::client::fluent_builders::StartQueryExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartQueryExecution {
    _private: (),
}
impl StartQueryExecution {
    /// Creates a new builder-style object to manufacture [`StartQueryExecutionInput`](crate::input::StartQueryExecutionInput)
    pub fn builder() -> crate::input::start_query_execution_input::Builder {
        crate::input::start_query_execution_input::Builder::default()
    }
    /// Creates a new `StartQueryExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartQueryExecution {
    type Output = std::result::Result<
        crate::output::StartQueryExecutionOutput,
        crate::error::StartQueryExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_query_execution_error(response)
        } else {
            crate::operation_deser::parse_start_query_execution_response(response)
        }
    }
}

/// Operation shape for `StopQueryExecution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_query_execution`](crate::client::Client::stop_query_execution).
///
/// See [`crate::client::fluent_builders::StopQueryExecution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopQueryExecution {
    _private: (),
}
impl StopQueryExecution {
    /// Creates a new builder-style object to manufacture [`StopQueryExecutionInput`](crate::input::StopQueryExecutionInput)
    pub fn builder() -> crate::input::stop_query_execution_input::Builder {
        crate::input::stop_query_execution_input::Builder::default()
    }
    /// Creates a new `StopQueryExecution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopQueryExecution {
    type Output = std::result::Result<
        crate::output::StopQueryExecutionOutput,
        crate::error::StopQueryExecutionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_query_execution_error(response)
        } else {
            crate::operation_deser::parse_stop_query_execution_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDataCatalog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_catalog`](crate::client::Client::update_data_catalog).
///
/// See [`crate::client::fluent_builders::UpdateDataCatalog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataCatalog {
    _private: (),
}
impl UpdateDataCatalog {
    /// Creates a new builder-style object to manufacture [`UpdateDataCatalogInput`](crate::input::UpdateDataCatalogInput)
    pub fn builder() -> crate::input::update_data_catalog_input::Builder {
        crate::input::update_data_catalog_input::Builder::default()
    }
    /// Creates a new `UpdateDataCatalog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataCatalog {
    type Output = std::result::Result<
        crate::output::UpdateDataCatalogOutput,
        crate::error::UpdateDataCatalogError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_catalog_error(response)
        } else {
            crate::operation_deser::parse_update_data_catalog_response(response)
        }
    }
}

/// Operation shape for `UpdateNamedQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_named_query`](crate::client::Client::update_named_query).
///
/// See [`crate::client::fluent_builders::UpdateNamedQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNamedQuery {
    _private: (),
}
impl UpdateNamedQuery {
    /// Creates a new builder-style object to manufacture [`UpdateNamedQueryInput`](crate::input::UpdateNamedQueryInput)
    pub fn builder() -> crate::input::update_named_query_input::Builder {
        crate::input::update_named_query_input::Builder::default()
    }
    /// Creates a new `UpdateNamedQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNamedQuery {
    type Output = std::result::Result<
        crate::output::UpdateNamedQueryOutput,
        crate::error::UpdateNamedQueryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_named_query_error(response)
        } else {
            crate::operation_deser::parse_update_named_query_response(response)
        }
    }
}

/// Operation shape for `UpdatePreparedStatement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_prepared_statement`](crate::client::Client::update_prepared_statement).
///
/// See [`crate::client::fluent_builders::UpdatePreparedStatement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePreparedStatement {
    _private: (),
}
impl UpdatePreparedStatement {
    /// Creates a new builder-style object to manufacture [`UpdatePreparedStatementInput`](crate::input::UpdatePreparedStatementInput)
    pub fn builder() -> crate::input::update_prepared_statement_input::Builder {
        crate::input::update_prepared_statement_input::Builder::default()
    }
    /// Creates a new `UpdatePreparedStatement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePreparedStatement {
    type Output = std::result::Result<
        crate::output::UpdatePreparedStatementOutput,
        crate::error::UpdatePreparedStatementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_prepared_statement_error(response)
        } else {
            crate::operation_deser::parse_update_prepared_statement_response(response)
        }
    }
}

/// Operation shape for `UpdateWorkGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_work_group`](crate::client::Client::update_work_group).
///
/// See [`crate::client::fluent_builders::UpdateWorkGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWorkGroup {
    _private: (),
}
impl UpdateWorkGroup {
    /// Creates a new builder-style object to manufacture [`UpdateWorkGroupInput`](crate::input::UpdateWorkGroupInput)
    pub fn builder() -> crate::input::update_work_group_input::Builder {
        crate::input::update_work_group_input::Builder::default()
    }
    /// Creates a new `UpdateWorkGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWorkGroup {
    type Output = std::result::Result<
        crate::output::UpdateWorkGroupOutput,
        crate::error::UpdateWorkGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_work_group_error(response)
        } else {
            crate::operation_deser::parse_update_work_group_response(response)
        }
    }
}
