// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchGetNamedQueryInput`](crate::input::BatchGetNamedQueryInput)
pub mod batch_get_named_query_input {
    /// A builder for [`BatchGetNamedQueryInput`](crate::input::BatchGetNamedQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) named_query_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `named_query_ids`.
        ///
        /// To override the contents of this collection use [`set_named_query_ids`](Self::set_named_query_ids).
        ///
        /// <p>An array of query IDs.</p>
        pub fn named_query_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.named_query_ids.unwrap_or_default();
            v.push(input.into());
            self.named_query_ids = Some(v);
            self
        }
        /// <p>An array of query IDs.</p>
        pub fn set_named_query_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.named_query_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetNamedQueryInput`](crate::input::BatchGetNamedQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetNamedQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetNamedQueryInput {
                named_query_ids: self.named_query_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetNamedQueryInputOperationOutputAlias = crate::operation::BatchGetNamedQuery;
#[doc(hidden)]
pub type BatchGetNamedQueryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetNamedQueryInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetNamedQuery`](crate::operation::BatchGetNamedQuery)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetNamedQuery,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetNamedQueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetNamedQueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetNamedQueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.BatchGetNamedQuery",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_named_query(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetNamedQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetNamedQuery",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetNamedQueryInput`](crate::input::BatchGetNamedQueryInput)
    pub fn builder() -> crate::input::batch_get_named_query_input::Builder {
        crate::input::batch_get_named_query_input::Builder::default()
    }
}

/// See [`BatchGetQueryExecutionInput`](crate::input::BatchGetQueryExecutionInput)
pub mod batch_get_query_execution_input {
    /// A builder for [`BatchGetQueryExecutionInput`](crate::input::BatchGetQueryExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_execution_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `query_execution_ids`.
        ///
        /// To override the contents of this collection use [`set_query_execution_ids`](Self::set_query_execution_ids).
        ///
        /// <p>An array of query execution IDs.</p>
        pub fn query_execution_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.query_execution_ids.unwrap_or_default();
            v.push(input.into());
            self.query_execution_ids = Some(v);
            self
        }
        /// <p>An array of query execution IDs.</p>
        pub fn set_query_execution_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.query_execution_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetQueryExecutionInput`](crate::input::BatchGetQueryExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetQueryExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetQueryExecutionInput {
                query_execution_ids: self.query_execution_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetQueryExecutionInputOperationOutputAlias = crate::operation::BatchGetQueryExecution;
#[doc(hidden)]
pub type BatchGetQueryExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetQueryExecutionInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetQueryExecution`](crate::operation::BatchGetQueryExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetQueryExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetQueryExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetQueryExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetQueryExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.BatchGetQueryExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_query_execution(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetQueryExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetQueryExecution",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetQueryExecutionInput`](crate::input::BatchGetQueryExecutionInput)
    pub fn builder() -> crate::input::batch_get_query_execution_input::Builder {
        crate::input::batch_get_query_execution_input::Builder::default()
    }
}

/// See [`CreateDataCatalogInput`](crate::input::CreateDataCatalogInput)
pub mod create_data_catalog_input {
    /// A builder for [`CreateDataCatalogInput`](crate::input::CreateDataCatalogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataCatalogType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the data catalog to create. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog to create. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
        /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
        /// Glue Data Catalog.</p>
        pub fn r#type(mut self, input: crate::model::DataCatalogType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
        /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
        /// Glue Data Catalog.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataCatalogType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A description of the data catalog to be created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the data catalog to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Specifies the Lambda function or functions to use for creating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
        /// <code>
        /// <i>catalog_id</i>
        /// </code> is the account ID of the
        /// Amazon Web Services account to which the Glue Data Catalog
        /// belongs.</p>
        /// <p>
        /// <code>catalog-id=<i>catalog_id</i>
        /// </code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The <code>GLUE</code> data catalog type also applies to the default
        /// <code>AwsDataCatalog</code> that already exists in your account, of
        /// which you can have only one and cannot modify.</p>
        /// </li>
        /// <li>
        /// <p>Queries that specify a Glue Data Catalog other than the default
        /// <code>AwsDataCatalog</code> must be run on Athena engine
        /// version 2.</p>
        /// </li>
        /// <li>
        /// <p>In Regions where Athena engine version 2 is not available,
        /// creating new Glue data catalogs results in an
        /// <code>INVALID_INPUT</code> error.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>Specifies the Lambda function or functions to use for creating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
        /// <code>
        /// <i>catalog_id</i>
        /// </code> is the account ID of the
        /// Amazon Web Services account to which the Glue Data Catalog
        /// belongs.</p>
        /// <p>
        /// <code>catalog-id=<i>catalog_id</i>
        /// </code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The <code>GLUE</code> data catalog type also applies to the default
        /// <code>AwsDataCatalog</code> that already exists in your account, of
        /// which you can have only one and cannot modify.</p>
        /// </li>
        /// <li>
        /// <p>Queries that specify a Glue Data Catalog other than the default
        /// <code>AwsDataCatalog</code> must be run on Athena engine
        /// version 2.</p>
        /// </li>
        /// <li>
        /// <p>In Regions where Athena engine version 2 is not available,
        /// creating new Glue data catalogs results in an
        /// <code>INVALID_INPUT</code> error.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of comma separated tags to add to the data catalog that is created.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of comma separated tags to add to the data catalog that is created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataCatalogInput`](crate::input::CreateDataCatalogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataCatalogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataCatalogInput {
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                parameters: self.parameters,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataCatalogInputOperationOutputAlias = crate::operation::CreateDataCatalog;
#[doc(hidden)]
pub type CreateDataCatalogInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDataCatalogInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataCatalog`](crate::operation::CreateDataCatalog)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataCatalog,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataCatalogInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataCatalogInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataCatalogInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.CreateDataCatalog",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_catalog(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataCatalog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataCatalog",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataCatalogInput`](crate::input::CreateDataCatalogInput)
    pub fn builder() -> crate::input::create_data_catalog_input::Builder {
        crate::input::create_data_catalog_input::Builder::default()
    }
}

/// See [`CreateNamedQueryInput`](crate::input::CreateNamedQueryInput)
pub mod create_named_query_input {
    /// A builder for [`CreateNamedQueryInput`](crate::input::CreateNamedQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The query name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The query name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The query description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The query description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The database to which the query belongs.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The database to which the query belongs.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The contents of the query with all query statements.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The contents of the query with all query statements.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>CreateNamedQuery</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>CreateNamedQuery</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The name of the workgroup in which the named query is being created.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup in which the named query is being created.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNamedQueryInput`](crate::input::CreateNamedQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNamedQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNamedQueryInput {
                name: self.name,
                description: self.description,
                database: self.database,
                query_string: self.query_string,
                client_request_token: self.client_request_token,
                work_group: self.work_group,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNamedQueryInputOperationOutputAlias = crate::operation::CreateNamedQuery;
#[doc(hidden)]
pub type CreateNamedQueryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateNamedQueryInput {
    /// Consumes the builder and constructs an Operation<[`CreateNamedQuery`](crate::operation::CreateNamedQuery)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNamedQuery,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateNamedQueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateNamedQueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateNamedQueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.CreateNamedQuery",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_named_query(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNamedQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNamedQuery",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateNamedQueryInput`](crate::input::CreateNamedQueryInput)
    pub fn builder() -> crate::input::create_named_query_input::Builder {
        crate::input::create_named_query_input::Builder::default()
    }
}

/// See [`CreatePreparedStatementInput`](crate::input::CreatePreparedStatementInput)
pub mod create_prepared_statement_input {
    /// A builder for [`CreatePreparedStatementInput`](crate::input::CreatePreparedStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) work_group: std::option::Option<std::string::String>,
        pub(crate) query_statement: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the prepared statement.</p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the prepared statement.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The name of the workgroup to which the prepared statement belongs.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup to which the prepared statement belongs.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn query_statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_statement = Some(input.into());
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn set_query_statement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_statement = input;
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePreparedStatementInput`](crate::input::CreatePreparedStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePreparedStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePreparedStatementInput {
                statement_name: self.statement_name,
                work_group: self.work_group,
                query_statement: self.query_statement,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePreparedStatementInputOperationOutputAlias =
    crate::operation::CreatePreparedStatement;
#[doc(hidden)]
pub type CreatePreparedStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreatePreparedStatementInput {
    /// Consumes the builder and constructs an Operation<[`CreatePreparedStatement`](crate::operation::CreatePreparedStatement)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePreparedStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePreparedStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePreparedStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePreparedStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.CreatePreparedStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_prepared_statement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePreparedStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePreparedStatement",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePreparedStatementInput`](crate::input::CreatePreparedStatementInput)
    pub fn builder() -> crate::input::create_prepared_statement_input::Builder {
        crate::input::create_prepared_statement_input::Builder::default()
    }
}

/// See [`CreateWorkGroupInput`](crate::input::CreateWorkGroupInput)
pub mod create_work_group_input {
    /// A builder for [`CreateWorkGroupInput`](crate::input::CreateWorkGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::WorkGroupConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The workgroup name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The workgroup name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The configuration for the workgroup, which includes the location in Amazon S3
        /// where query results are stored, the encryption configuration, if any, used for
        /// encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the
        /// workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is
        /// specified, and whether workgroup's settings (specified with
        /// <code>EnforceWorkGroupConfiguration</code>) in the
        /// <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn configuration(mut self, input: crate::model::WorkGroupConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration for the workgroup, which includes the location in Amazon S3
        /// where query results are stored, the encryption configuration, if any, used for
        /// encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the
        /// workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is
        /// specified, and whether workgroup's settings (specified with
        /// <code>EnforceWorkGroupConfiguration</code>) in the
        /// <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkGroupConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The workgroup description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The workgroup description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of comma separated tags to add to the workgroup that is created.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of comma separated tags to add to the workgroup that is created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWorkGroupInput`](crate::input::CreateWorkGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateWorkGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateWorkGroupInput {
                name: self.name,
                configuration: self.configuration,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateWorkGroupInputOperationOutputAlias = crate::operation::CreateWorkGroup;
#[doc(hidden)]
pub type CreateWorkGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateWorkGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateWorkGroup`](crate::operation::CreateWorkGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateWorkGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateWorkGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateWorkGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateWorkGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.CreateWorkGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_work_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateWorkGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateWorkGroup",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateWorkGroupInput`](crate::input::CreateWorkGroupInput)
    pub fn builder() -> crate::input::create_work_group_input::Builder {
        crate::input::create_work_group_input::Builder::default()
    }
}

/// See [`DeleteDataCatalogInput`](crate::input::DeleteDataCatalogInput)
pub mod delete_data_catalog_input {
    /// A builder for [`DeleteDataCatalogInput`](crate::input::DeleteDataCatalogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data catalog to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataCatalogInput`](crate::input::DeleteDataCatalogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataCatalogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataCatalogInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataCatalogInputOperationOutputAlias = crate::operation::DeleteDataCatalog;
#[doc(hidden)]
pub type DeleteDataCatalogInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDataCatalogInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataCatalog`](crate::operation::DeleteDataCatalog)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataCatalog,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataCatalogInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataCatalogInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataCatalogInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.DeleteDataCatalog",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_data_catalog(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataCatalog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataCatalog",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataCatalogInput`](crate::input::DeleteDataCatalogInput)
    pub fn builder() -> crate::input::delete_data_catalog_input::Builder {
        crate::input::delete_data_catalog_input::Builder::default()
    }
}

/// See [`DeleteNamedQueryInput`](crate::input::DeleteNamedQueryInput)
pub mod delete_named_query_input {
    /// A builder for [`DeleteNamedQueryInput`](crate::input::DeleteNamedQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) named_query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the query to delete.</p>
        pub fn named_query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.named_query_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the query to delete.</p>
        pub fn set_named_query_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.named_query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNamedQueryInput`](crate::input::DeleteNamedQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNamedQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNamedQueryInput {
                named_query_id: self.named_query_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNamedQueryInputOperationOutputAlias = crate::operation::DeleteNamedQuery;
#[doc(hidden)]
pub type DeleteNamedQueryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteNamedQueryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNamedQuery`](crate::operation::DeleteNamedQuery)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNamedQuery,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteNamedQueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteNamedQueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteNamedQueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.DeleteNamedQuery",
            );
            Ok(builder)
        }
        if self.named_query_id.is_none() {
            self.named_query_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_named_query(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNamedQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNamedQuery",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteNamedQueryInput`](crate::input::DeleteNamedQueryInput)
    pub fn builder() -> crate::input::delete_named_query_input::Builder {
        crate::input::delete_named_query_input::Builder::default()
    }
}

/// See [`DeletePreparedStatementInput`](crate::input::DeletePreparedStatementInput)
pub mod delete_prepared_statement_input {
    /// A builder for [`DeletePreparedStatementInput`](crate::input::DeletePreparedStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the prepared statement to delete.</p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the prepared statement to delete.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The workgroup to which the statement to be deleted belongs.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The workgroup to which the statement to be deleted belongs.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePreparedStatementInput`](crate::input::DeletePreparedStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePreparedStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePreparedStatementInput {
                statement_name: self.statement_name,
                work_group: self.work_group,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePreparedStatementInputOperationOutputAlias =
    crate::operation::DeletePreparedStatement;
#[doc(hidden)]
pub type DeletePreparedStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePreparedStatementInput {
    /// Consumes the builder and constructs an Operation<[`DeletePreparedStatement`](crate::operation::DeletePreparedStatement)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePreparedStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePreparedStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePreparedStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePreparedStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.DeletePreparedStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_prepared_statement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePreparedStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePreparedStatement",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePreparedStatementInput`](crate::input::DeletePreparedStatementInput)
    pub fn builder() -> crate::input::delete_prepared_statement_input::Builder {
        crate::input::delete_prepared_statement_input::Builder::default()
    }
}

/// See [`DeleteWorkGroupInput`](crate::input::DeleteWorkGroupInput)
pub mod delete_work_group_input {
    /// A builder for [`DeleteWorkGroupInput`](crate::input::DeleteWorkGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) work_group: std::option::Option<std::string::String>,
        pub(crate) recursive_delete_option: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique name of the workgroup to delete.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The unique name of the workgroup to delete.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// <p>The option to delete the workgroup and its contents even if the workgroup contains any
        /// named queries or query executions.</p>
        pub fn recursive_delete_option(mut self, input: bool) -> Self {
            self.recursive_delete_option = Some(input);
            self
        }
        /// <p>The option to delete the workgroup and its contents even if the workgroup contains any
        /// named queries or query executions.</p>
        pub fn set_recursive_delete_option(mut self, input: std::option::Option<bool>) -> Self {
            self.recursive_delete_option = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkGroupInput`](crate::input::DeleteWorkGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkGroupInput {
                work_group: self.work_group,
                recursive_delete_option: self.recursive_delete_option,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkGroupInputOperationOutputAlias = crate::operation::DeleteWorkGroup;
#[doc(hidden)]
pub type DeleteWorkGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteWorkGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkGroup`](crate::operation::DeleteWorkGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteWorkGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteWorkGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteWorkGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.DeleteWorkGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_work_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkGroup",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkGroupInput`](crate::input::DeleteWorkGroupInput)
    pub fn builder() -> crate::input::delete_work_group_input::Builder {
        crate::input::delete_work_group_input::Builder::default()
    }
}

/// See [`GetDatabaseInput`](crate::input::GetDatabaseInput)
pub mod get_database_input {
    /// A builder for [`GetDatabaseInput`](crate::input::GetDatabaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data catalog that contains the database to return.</p>
        pub fn catalog_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog that contains the database to return.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_name = input;
            self
        }
        /// <p>The name of the database to return.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database to return.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDatabaseInput`](crate::input::GetDatabaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDatabaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDatabaseInput {
                catalog_name: self.catalog_name,
                database_name: self.database_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDatabaseInputOperationOutputAlias = crate::operation::GetDatabase;
#[doc(hidden)]
pub type GetDatabaseInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDatabaseInput {
    /// Consumes the builder and constructs an Operation<[`GetDatabase`](crate::operation::GetDatabase)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDatabase,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDatabaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDatabaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDatabaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetDatabase",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_database(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDatabase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDatabase",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDatabaseInput`](crate::input::GetDatabaseInput)
    pub fn builder() -> crate::input::get_database_input::Builder {
        crate::input::get_database_input::Builder::default()
    }
}

/// See [`GetDataCatalogInput`](crate::input::GetDataCatalogInput)
pub mod get_data_catalog_input {
    /// A builder for [`GetDataCatalogInput`](crate::input::GetDataCatalogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data catalog to return.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog to return.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataCatalogInput`](crate::input::GetDataCatalogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataCatalogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataCatalogInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type GetDataCatalogInputOperationOutputAlias = crate::operation::GetDataCatalog;
#[doc(hidden)]
pub type GetDataCatalogInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDataCatalogInput {
    /// Consumes the builder and constructs an Operation<[`GetDataCatalog`](crate::operation::GetDataCatalog)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataCatalog,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDataCatalogInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDataCatalogInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDataCatalogInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetDataCatalog",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_data_catalog(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataCatalog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataCatalog",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDataCatalogInput`](crate::input::GetDataCatalogInput)
    pub fn builder() -> crate::input::get_data_catalog_input::Builder {
        crate::input::get_data_catalog_input::Builder::default()
    }
}

/// See [`GetNamedQueryInput`](crate::input::GetNamedQueryInput)
pub mod get_named_query_input {
    /// A builder for [`GetNamedQueryInput`](crate::input::GetNamedQueryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) named_query_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query
        /// IDs.</p>
        pub fn named_query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.named_query_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query
        /// IDs.</p>
        pub fn set_named_query_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.named_query_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNamedQueryInput`](crate::input::GetNamedQueryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNamedQueryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNamedQueryInput {
                named_query_id: self.named_query_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetNamedQueryInputOperationOutputAlias = crate::operation::GetNamedQuery;
#[doc(hidden)]
pub type GetNamedQueryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetNamedQueryInput {
    /// Consumes the builder and constructs an Operation<[`GetNamedQuery`](crate::operation::GetNamedQuery)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNamedQuery,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetNamedQueryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetNamedQueryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetNamedQueryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetNamedQuery",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_named_query(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNamedQuery::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNamedQuery",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetNamedQueryInput`](crate::input::GetNamedQueryInput)
    pub fn builder() -> crate::input::get_named_query_input::Builder {
        crate::input::get_named_query_input::Builder::default()
    }
}

/// See [`GetPreparedStatementInput`](crate::input::GetPreparedStatementInput)
pub mod get_prepared_statement_input {
    /// A builder for [`GetPreparedStatementInput`](crate::input::GetPreparedStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the prepared statement to retrieve.</p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the prepared statement to retrieve.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The workgroup to which the statement to be retrieved belongs.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The workgroup to which the statement to be retrieved belongs.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPreparedStatementInput`](crate::input::GetPreparedStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPreparedStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPreparedStatementInput {
                statement_name: self.statement_name,
                work_group: self.work_group,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPreparedStatementInputOperationOutputAlias = crate::operation::GetPreparedStatement;
#[doc(hidden)]
pub type GetPreparedStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPreparedStatementInput {
    /// Consumes the builder and constructs an Operation<[`GetPreparedStatement`](crate::operation::GetPreparedStatement)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPreparedStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPreparedStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPreparedStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPreparedStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetPreparedStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_prepared_statement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPreparedStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPreparedStatement",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPreparedStatementInput`](crate::input::GetPreparedStatementInput)
    pub fn builder() -> crate::input::get_prepared_statement_input::Builder {
        crate::input::get_prepared_statement_input::Builder::default()
    }
}

/// See [`GetQueryExecutionInput`](crate::input::GetQueryExecutionInput)
pub mod get_query_execution_input {
    /// A builder for [`GetQueryExecutionInput`](crate::input::GetQueryExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the query execution.</p>
        pub fn query_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_execution_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the query execution.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryExecutionInput`](crate::input::GetQueryExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQueryExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQueryExecutionInput {
                query_execution_id: self.query_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQueryExecutionInputOperationOutputAlias = crate::operation::GetQueryExecution;
#[doc(hidden)]
pub type GetQueryExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetQueryExecutionInput {
    /// Consumes the builder and constructs an Operation<[`GetQueryExecution`](crate::operation::GetQueryExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQueryExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQueryExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQueryExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQueryExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetQueryExecution",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_query_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQueryExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQueryExecution",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQueryExecutionInput`](crate::input::GetQueryExecutionInput)
    pub fn builder() -> crate::input::get_query_execution_input::Builder {
        crate::input::get_query_execution_input::Builder::default()
    }
}

/// See [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
pub mod get_query_results_input {
    /// A builder for [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_execution_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique ID of the query execution.</p>
        pub fn query_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_execution_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the query execution.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_execution_id = input;
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results (rows) to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results (rows) to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetQueryResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetQueryResultsInput {
                query_execution_id: self.query_execution_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetQueryResultsInputOperationOutputAlias = crate::operation::GetQueryResults;
#[doc(hidden)]
pub type GetQueryResultsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetQueryResultsInput {
    /// Consumes the builder and constructs an Operation<[`GetQueryResults`](crate::operation::GetQueryResults)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetQueryResults,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetQueryResultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetQueryResultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetQueryResultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetQueryResults",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_query_results(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetQueryResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetQueryResults",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
    pub fn builder() -> crate::input::get_query_results_input::Builder {
        crate::input::get_query_results_input::Builder::default()
    }
}

/// See [`GetTableMetadataInput`](crate::input::GetTableMetadataInput)
pub mod get_table_metadata_input {
    /// A builder for [`GetTableMetadataInput`](crate::input::GetTableMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the data catalog that contains the database and table metadata to
        /// return.</p>
        pub fn catalog_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog that contains the database and table metadata to
        /// return.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_name = input;
            self
        }
        /// <p>The name of the database that contains the table metadata to return.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that contains the table metadata to return.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the table for which metadata is returned.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table for which metadata is returned.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTableMetadataInput`](crate::input::GetTableMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetTableMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetTableMetadataInput {
                catalog_name: self.catalog_name,
                database_name: self.database_name,
                table_name: self.table_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTableMetadataInputOperationOutputAlias = crate::operation::GetTableMetadata;
#[doc(hidden)]
pub type GetTableMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetTableMetadataInput {
    /// Consumes the builder and constructs an Operation<[`GetTableMetadata`](crate::operation::GetTableMetadata)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTableMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTableMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTableMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTableMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetTableMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_table_metadata(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetTableMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetTableMetadata",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTableMetadataInput`](crate::input::GetTableMetadataInput)
    pub fn builder() -> crate::input::get_table_metadata_input::Builder {
        crate::input::get_table_metadata_input::Builder::default()
    }
}

/// See [`GetWorkGroupInput`](crate::input::GetWorkGroupInput)
pub mod get_work_group_input {
    /// A builder for [`GetWorkGroupInput`](crate::input::GetWorkGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the workgroup.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkGroupInput`](crate::input::GetWorkGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkGroupInput {
                work_group: self.work_group,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkGroupInputOperationOutputAlias = crate::operation::GetWorkGroup;
#[doc(hidden)]
pub type GetWorkGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetWorkGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkGroup`](crate::operation::GetWorkGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetWorkGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetWorkGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetWorkGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.GetWorkGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_work_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkGroup",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetWorkGroupInput`](crate::input::GetWorkGroupInput)
    pub fn builder() -> crate::input::get_work_group_input::Builder {
        crate::input::get_work_group_input::Builder::default()
    }
}

/// See [`ListDatabasesInput`](crate::input::ListDatabasesInput)
pub mod list_databases_input {
    /// A builder for [`ListDatabasesInput`](crate::input::ListDatabasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the data catalog that contains the databases to return.</p>
        pub fn catalog_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog that contains the databases to return.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_name = input;
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatabasesInput`](crate::input::ListDatabasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatabasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatabasesInput {
                catalog_name: self.catalog_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatabasesInputOperationOutputAlias = crate::operation::ListDatabases;
#[doc(hidden)]
pub type ListDatabasesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDatabasesInput {
    /// Consumes the builder and constructs an Operation<[`ListDatabases`](crate::operation::ListDatabases)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatabases,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDatabasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDatabasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDatabasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListDatabases",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_databases(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatabases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatabases",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDatabasesInput`](crate::input::ListDatabasesInput)
    pub fn builder() -> crate::input::list_databases_input::Builder {
        crate::input::list_databases_input::Builder::default()
    }
}

/// See [`ListDataCatalogsInput`](crate::input::ListDataCatalogsInput)
pub mod list_data_catalogs_input {
    /// A builder for [`ListDataCatalogsInput`](crate::input::ListDataCatalogsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the maximum number of data catalogs to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of data catalogs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataCatalogsInput`](crate::input::ListDataCatalogsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataCatalogsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataCatalogsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataCatalogsInputOperationOutputAlias = crate::operation::ListDataCatalogs;
#[doc(hidden)]
pub type ListDataCatalogsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDataCatalogsInput {
    /// Consumes the builder and constructs an Operation<[`ListDataCatalogs`](crate::operation::ListDataCatalogs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataCatalogs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDataCatalogsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDataCatalogsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDataCatalogsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListDataCatalogs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_data_catalogs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataCatalogs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataCatalogs",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDataCatalogsInput`](crate::input::ListDataCatalogsInput)
    pub fn builder() -> crate::input::list_data_catalogs_input::Builder {
        crate::input::list_data_catalogs_input::Builder::default()
    }
}

/// See [`ListEngineVersionsInput`](crate::input::ListEngineVersionsInput)
pub mod list_engine_versions_input {
    /// A builder for [`ListEngineVersionsInput`](crate::input::ListEngineVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of engine versions to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of engine versions to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEngineVersionsInput`](crate::input::ListEngineVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEngineVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEngineVersionsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEngineVersionsInputOperationOutputAlias = crate::operation::ListEngineVersions;
#[doc(hidden)]
pub type ListEngineVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEngineVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListEngineVersions`](crate::operation::ListEngineVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEngineVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEngineVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEngineVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEngineVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListEngineVersions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_engine_versions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEngineVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEngineVersions",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEngineVersionsInput`](crate::input::ListEngineVersionsInput)
    pub fn builder() -> crate::input::list_engine_versions_input::Builder {
        crate::input::list_engine_versions_input::Builder::default()
    }
}

/// See [`ListNamedQueriesInput`](crate::input::ListNamedQueriesInput)
pub mod list_named_queries_input {
    /// A builder for [`ListNamedQueriesInput`](crate::input::ListNamedQueriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of queries to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of queries to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The name of the workgroup from which the named queries are being returned. If a
        /// workgroup is not specified, the saved queries for the primary workgroup are
        /// returned.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup from which the named queries are being returned. If a
        /// workgroup is not specified, the saved queries for the primary workgroup are
        /// returned.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNamedQueriesInput`](crate::input::ListNamedQueriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNamedQueriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNamedQueriesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                work_group: self.work_group,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNamedQueriesInputOperationOutputAlias = crate::operation::ListNamedQueries;
#[doc(hidden)]
pub type ListNamedQueriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListNamedQueriesInput {
    /// Consumes the builder and constructs an Operation<[`ListNamedQueries`](crate::operation::ListNamedQueries)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNamedQueries,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListNamedQueriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListNamedQueriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListNamedQueriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListNamedQueries",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_named_queries(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNamedQueries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNamedQueries",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListNamedQueriesInput`](crate::input::ListNamedQueriesInput)
    pub fn builder() -> crate::input::list_named_queries_input::Builder {
        crate::input::list_named_queries_input::Builder::default()
    }
}

/// See [`ListPreparedStatementsInput`](crate::input::ListPreparedStatementsInput)
pub mod list_prepared_statements_input {
    /// A builder for [`ListPreparedStatementsInput`](crate::input::ListPreparedStatementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) work_group: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The workgroup to list the prepared statements for.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The workgroup to list the prepared statements for.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPreparedStatementsInput`](crate::input::ListPreparedStatementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPreparedStatementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPreparedStatementsInput {
                work_group: self.work_group,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPreparedStatementsInputOperationOutputAlias = crate::operation::ListPreparedStatements;
#[doc(hidden)]
pub type ListPreparedStatementsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPreparedStatementsInput {
    /// Consumes the builder and constructs an Operation<[`ListPreparedStatements`](crate::operation::ListPreparedStatements)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPreparedStatements,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPreparedStatementsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPreparedStatementsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPreparedStatementsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListPreparedStatements",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_prepared_statements(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPreparedStatements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPreparedStatements",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPreparedStatementsInput`](crate::input::ListPreparedStatementsInput)
    pub fn builder() -> crate::input::list_prepared_statements_input::Builder {
        crate::input::list_prepared_statements_input::Builder::default()
    }
}

/// See [`ListQueryExecutionsInput`](crate::input::ListQueryExecutionsInput)
pub mod list_query_executions_input {
    /// A builder for [`ListQueryExecutionsInput`](crate::input::ListQueryExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of query executions to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of query executions to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The name of the workgroup from which queries are being returned. If a workgroup is not
        /// specified, a list of available query execution IDs for the queries in the primary
        /// workgroup is returned.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup from which queries are being returned. If a workgroup is not
        /// specified, a list of available query execution IDs for the queries in the primary
        /// workgroup is returned.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueryExecutionsInput`](crate::input::ListQueryExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQueryExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQueryExecutionsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                work_group: self.work_group,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQueryExecutionsInputOperationOutputAlias = crate::operation::ListQueryExecutions;
#[doc(hidden)]
pub type ListQueryExecutionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListQueryExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`ListQueryExecutions`](crate::operation::ListQueryExecutions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQueryExecutions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQueryExecutionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQueryExecutionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQueryExecutionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListQueryExecutions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_query_executions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQueryExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQueryExecutions",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQueryExecutionsInput`](crate::input::ListQueryExecutionsInput)
    pub fn builder() -> crate::input::list_query_executions_input::Builder {
        crate::input::list_query_executions_input::Builder::default()
    }
}

/// See [`ListTableMetadataInput`](crate::input::ListTableMetadataInput)
pub mod list_table_metadata_input {
    /// A builder for [`ListTableMetadataInput`](crate::input::ListTableMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the data catalog for which table metadata should be returned.</p>
        pub fn catalog_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog for which table metadata should be returned.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_name = input;
            self
        }
        /// <p>The name of the database for which table metadata should be returned.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database for which table metadata should be returned.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>A regex filter that pattern-matches table names. If no expression is supplied,
        /// metadata for all tables are listed.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A regex filter that pattern-matches table names. If no expression is supplied,
        /// metadata for all tables are listed.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTableMetadataInput`](crate::input::ListTableMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTableMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTableMetadataInput {
                catalog_name: self.catalog_name,
                database_name: self.database_name,
                expression: self.expression,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTableMetadataInputOperationOutputAlias = crate::operation::ListTableMetadata;
#[doc(hidden)]
pub type ListTableMetadataInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTableMetadataInput {
    /// Consumes the builder and constructs an Operation<[`ListTableMetadata`](crate::operation::ListTableMetadata)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTableMetadata,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTableMetadataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTableMetadataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTableMetadataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListTableMetadata",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_table_metadata(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTableMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTableMetadata",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTableMetadataInput`](crate::input::ListTableMetadataInput)
    pub fn builder() -> crate::input::list_table_metadata_input::Builder {
        crate::input::list_table_metadata_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Lists the tags for the resource with the specified ARN.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Lists the tags for the resource with the specified ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results for
        /// this request, where the request lists the tags for the resource with the specified
        /// ARN.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results for
        /// this request, where the request lists the tags for the resource with the specified
        /// ARN.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to be returned per request that lists the tags for the
        /// resource.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to be returned per request that lists the tags for the
        /// resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWorkGroupsInput`](crate::input::ListWorkGroupsInput)
pub mod list_work_groups_input {
    /// A builder for [`ListWorkGroupsInput`](crate::input::ListWorkGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of workgroups to return in this request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of workgroups to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkGroupsInput`](crate::input::ListWorkGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkGroupsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkGroupsInputOperationOutputAlias = crate::operation::ListWorkGroups;
#[doc(hidden)]
pub type ListWorkGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListWorkGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkGroups`](crate::operation::ListWorkGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListWorkGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListWorkGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListWorkGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.ListWorkGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_work_groups(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkGroups",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListWorkGroupsInput`](crate::input::ListWorkGroupsInput)
    pub fn builder() -> crate::input::list_work_groups_input::Builder {
        crate::input::list_work_groups_input::Builder::default()
    }
}

/// See [`StartQueryExecutionInput`](crate::input::StartQueryExecutionInput)
pub mod start_query_execution_input {
    /// A builder for [`StartQueryExecutionInput`](crate::input::StartQueryExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) query_execution_context:
            std::option::Option<crate::model::QueryExecutionContext>,
        pub(crate) result_configuration: std::option::Option<crate::model::ResultConfiguration>,
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The SQL query statements to be executed.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The SQL query statements to be executed.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>StartQueryExecution</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>StartQueryExecution</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The database within which the query executes.</p>
        pub fn query_execution_context(
            mut self,
            input: crate::model::QueryExecutionContext,
        ) -> Self {
            self.query_execution_context = Some(input);
            self
        }
        /// <p>The database within which the query executes.</p>
        pub fn set_query_execution_context(
            mut self,
            input: std::option::Option<crate::model::QueryExecutionContext>,
        ) -> Self {
            self.query_execution_context = input;
            self
        }
        /// <p>Specifies information about where and how to save the results of the query execution.
        /// If the query runs in a workgroup, then workgroup's settings may override query settings.
        /// This affects the query results location. The workgroup settings override is specified in
        /// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn result_configuration(mut self, input: crate::model::ResultConfiguration) -> Self {
            self.result_configuration = Some(input);
            self
        }
        /// <p>Specifies information about where and how to save the results of the query execution.
        /// If the query runs in a workgroup, then workgroup's settings may override query settings.
        /// This affects the query results location. The workgroup settings override is specified in
        /// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn set_result_configuration(
            mut self,
            input: std::option::Option<crate::model::ResultConfiguration>,
        ) -> Self {
            self.result_configuration = input;
            self
        }
        /// <p>The name of the workgroup in which the query is being started.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup in which the query is being started.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`StartQueryExecutionInput`](crate::input::StartQueryExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartQueryExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartQueryExecutionInput {
                query_string: self.query_string,
                client_request_token: self.client_request_token,
                query_execution_context: self.query_execution_context,
                result_configuration: self.result_configuration,
                work_group: self.work_group,
            })
        }
    }
}
#[doc(hidden)]
pub type StartQueryExecutionInputOperationOutputAlias = crate::operation::StartQueryExecution;
#[doc(hidden)]
pub type StartQueryExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartQueryExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StartQueryExecution`](crate::operation::StartQueryExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartQueryExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartQueryExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartQueryExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartQueryExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.StartQueryExecution",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_query_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartQueryExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartQueryExecution",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartQueryExecutionInput`](crate::input::StartQueryExecutionInput)
    pub fn builder() -> crate::input::start_query_execution_input::Builder {
        crate::input::start_query_execution_input::Builder::default()
    }
}

/// See [`StopQueryExecutionInput`](crate::input::StopQueryExecutionInput)
pub mod stop_query_execution_input {
    /// A builder for [`StopQueryExecutionInput`](crate::input::StopQueryExecutionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_execution_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the query execution to stop.</p>
        pub fn query_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_execution_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the query execution to stop.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_execution_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopQueryExecutionInput`](crate::input::StopQueryExecutionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopQueryExecutionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopQueryExecutionInput {
                query_execution_id: self.query_execution_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopQueryExecutionInputOperationOutputAlias = crate::operation::StopQueryExecution;
#[doc(hidden)]
pub type StopQueryExecutionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopQueryExecutionInput {
    /// Consumes the builder and constructs an Operation<[`StopQueryExecution`](crate::operation::StopQueryExecution)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopQueryExecution,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopQueryExecutionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopQueryExecutionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopQueryExecutionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.StopQueryExecution",
            );
            Ok(builder)
        }
        if self.query_execution_id.is_none() {
            self.query_execution_id = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_query_execution(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopQueryExecution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopQueryExecution",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopQueryExecutionInput`](crate::input::StopQueryExecutionInput)
    pub fn builder() -> crate::input::stop_query_execution_input::Builder {
        crate::input::stop_query_execution_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the Athena resource (workgroup or data catalog) to
        /// which tags are to be added.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the Athena resource (workgroup or data catalog) to
        /// which tags are to be added.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of one or more tags, separated by commas, to be added to an Athena workgroup or data catalog resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A collection of one or more tags, separated by commas, to be added to an Athena workgroup or data catalog resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies the ARN of the resource from which tags are to be removed.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Specifies the ARN of the resource from which tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A comma-separated list of one or more tag keys whose tags are to be removed from the
        /// specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A comma-separated list of one or more tag keys whose tags are to be removed from the
        /// specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDataCatalogInput`](crate::input::UpdateDataCatalogInput)
pub mod update_data_catalog_input {
    /// A builder for [`UpdateDataCatalogInput`](crate::input::UpdateDataCatalogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataCatalogType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the data catalog to update. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog to update. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a
        /// federated catalog, <code>HIVE</code> for an external hive metastore, or
        /// <code>GLUE</code> for an Glue Data Catalog.</p>
        pub fn r#type(mut self, input: crate::model::DataCatalogType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a
        /// federated catalog, <code>HIVE</code> for an external hive metastore, or
        /// <code>GLUE</code> for an Glue Data Catalog.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataCatalogType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>New or modified text that describes the data catalog.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>New or modified text that describes the data catalog.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Specifies the Lambda function or functions to use for updating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>Specifies the Lambda function or functions to use for updating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataCatalogInput`](crate::input::UpdateDataCatalogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDataCatalogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDataCatalogInput {
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                parameters: self.parameters,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDataCatalogInputOperationOutputAlias = crate::operation::UpdateDataCatalog;
#[doc(hidden)]
pub type UpdateDataCatalogInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDataCatalogInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataCatalog`](crate::operation::UpdateDataCatalog)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataCatalog,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDataCatalogInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDataCatalogInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDataCatalogInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.UpdateDataCatalog",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_data_catalog(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataCatalog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataCatalog",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDataCatalogInput`](crate::input::UpdateDataCatalogInput)
    pub fn builder() -> crate::input::update_data_catalog_input::Builder {
        crate::input::update_data_catalog_input::Builder::default()
    }
}

/// See [`UpdatePreparedStatementInput`](crate::input::UpdatePreparedStatementInput)
pub mod update_prepared_statement_input {
    /// A builder for [`UpdatePreparedStatementInput`](crate::input::UpdatePreparedStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) work_group: std::option::Option<std::string::String>,
        pub(crate) query_statement: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the prepared statement.</p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the prepared statement.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The workgroup for the prepared statement.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The workgroup for the prepared statement.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn query_statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_statement = Some(input.into());
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn set_query_statement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_statement = input;
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePreparedStatementInput`](crate::input::UpdatePreparedStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePreparedStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePreparedStatementInput {
                statement_name: self.statement_name,
                work_group: self.work_group,
                query_statement: self.query_statement,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePreparedStatementInputOperationOutputAlias =
    crate::operation::UpdatePreparedStatement;
#[doc(hidden)]
pub type UpdatePreparedStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdatePreparedStatementInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePreparedStatement`](crate::operation::UpdatePreparedStatement)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePreparedStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePreparedStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePreparedStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePreparedStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.UpdatePreparedStatement",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_prepared_statement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePreparedStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePreparedStatement",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePreparedStatementInput`](crate::input::UpdatePreparedStatementInput)
    pub fn builder() -> crate::input::update_prepared_statement_input::Builder {
        crate::input::update_prepared_statement_input::Builder::default()
    }
}

/// See [`UpdateWorkGroupInput`](crate::input::UpdateWorkGroupInput)
pub mod update_work_group_input {
    /// A builder for [`UpdateWorkGroupInput`](crate::input::UpdateWorkGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) work_group: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) configuration_updates:
            std::option::Option<crate::model::WorkGroupConfigurationUpdates>,
        pub(crate) state: std::option::Option<crate::model::WorkGroupState>,
    }
    impl Builder {
        /// <p>The specified workgroup that will be updated.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The specified workgroup that will be updated.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// <p>The workgroup description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The workgroup description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The workgroup configuration that will be updated for the given workgroup.</p>
        pub fn configuration_updates(
            mut self,
            input: crate::model::WorkGroupConfigurationUpdates,
        ) -> Self {
            self.configuration_updates = Some(input);
            self
        }
        /// <p>The workgroup configuration that will be updated for the given workgroup.</p>
        pub fn set_configuration_updates(
            mut self,
            input: std::option::Option<crate::model::WorkGroupConfigurationUpdates>,
        ) -> Self {
            self.configuration_updates = input;
            self
        }
        /// <p>The workgroup state that will be updated for the given workgroup.</p>
        pub fn state(mut self, input: crate::model::WorkGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The workgroup state that will be updated for the given workgroup.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::WorkGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWorkGroupInput`](crate::input::UpdateWorkGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateWorkGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateWorkGroupInput {
                work_group: self.work_group,
                description: self.description,
                configuration_updates: self.configuration_updates,
                state: self.state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateWorkGroupInputOperationOutputAlias = crate::operation::UpdateWorkGroup;
#[doc(hidden)]
pub type UpdateWorkGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateWorkGroupInput {
    /// Consumes the builder and constructs an Operation<[`UpdateWorkGroup`](crate::operation::UpdateWorkGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateWorkGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateWorkGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateWorkGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateWorkGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonAthena.UpdateWorkGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_work_group(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateWorkGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateWorkGroup",
            "athena",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateWorkGroupInput`](crate::input::UpdateWorkGroupInput)
    pub fn builder() -> crate::input::update_work_group_input::Builder {
        crate::input::update_work_group_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWorkGroupInput {
    /// <p>The specified workgroup that will be updated.</p>
    pub work_group: std::option::Option<std::string::String>,
    /// <p>The workgroup description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The workgroup configuration that will be updated for the given workgroup.</p>
    pub configuration_updates: std::option::Option<crate::model::WorkGroupConfigurationUpdates>,
    /// <p>The workgroup state that will be updated for the given workgroup.</p>
    pub state: std::option::Option<crate::model::WorkGroupState>,
}
impl UpdateWorkGroupInput {
    /// <p>The specified workgroup that will be updated.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
    /// <p>The workgroup description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The workgroup configuration that will be updated for the given workgroup.</p>
    pub fn configuration_updates(
        &self,
    ) -> std::option::Option<&crate::model::WorkGroupConfigurationUpdates> {
        self.configuration_updates.as_ref()
    }
    /// <p>The workgroup state that will be updated for the given workgroup.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::WorkGroupState> {
        self.state.as_ref()
    }
}
impl std::fmt::Debug for UpdateWorkGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWorkGroupInput");
        formatter.field("work_group", &self.work_group);
        formatter.field("description", &self.description);
        formatter.field("configuration_updates", &self.configuration_updates);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePreparedStatementInput {
    /// <p>The name of the prepared statement.</p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The workgroup for the prepared statement.</p>
    pub work_group: std::option::Option<std::string::String>,
    /// <p>The query string for the prepared statement.</p>
    pub query_statement: std::option::Option<std::string::String>,
    /// <p>The description of the prepared statement.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdatePreparedStatementInput {
    /// <p>The name of the prepared statement.</p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
    /// <p>The workgroup for the prepared statement.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
    /// <p>The query string for the prepared statement.</p>
    pub fn query_statement(&self) -> std::option::Option<&str> {
        self.query_statement.as_deref()
    }
    /// <p>The description of the prepared statement.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdatePreparedStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePreparedStatementInput");
        formatter.field("statement_name", &self.statement_name);
        formatter.field("work_group", &self.work_group);
        formatter.field("query_statement", &self.query_statement);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataCatalogInput {
    /// <p>The name of the data catalog to update. The catalog name must be unique for the
    /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
    /// sign, or hyphen characters.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a
    /// federated catalog, <code>HIVE</code> for an external hive metastore, or
    /// <code>GLUE</code> for an Glue Data Catalog.</p>
    pub r#type: std::option::Option<crate::model::DataCatalogType>,
    /// <p>New or modified text that describes the data catalog.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the Lambda function or functions to use for updating the data
    /// catalog. This is a mapping whose values depend on the catalog type. </p>
    /// <ul>
    /// <li>
    /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
    /// <code>metadata-function</code> parameter is required. <code>The
    /// sdk-version</code> parameter is optional and defaults to the currently
    /// supported version.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// sdk-version=<i>version_number</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
    /// of required parameters, but not both.</p>
    /// <ul>
    /// <li>
    /// <p>If you have one Lambda function that processes metadata
    /// and another for reading the actual data, use the following syntax. Both
    /// parameters are required.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// record-function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> If you have a composite Lambda function that processes
    /// both metadata and data, use the following syntax to specify your Lambda function.</p>
    /// <p>
    /// <code>function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateDataCatalogInput {
    /// <p>The name of the data catalog to update. The catalog name must be unique for the
    /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
    /// sign, or hyphen characters.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a
    /// federated catalog, <code>HIVE</code> for an external hive metastore, or
    /// <code>GLUE</code> for an Glue Data Catalog.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataCatalogType> {
        self.r#type.as_ref()
    }
    /// <p>New or modified text that describes the data catalog.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the Lambda function or functions to use for updating the data
    /// catalog. This is a mapping whose values depend on the catalog type. </p>
    /// <ul>
    /// <li>
    /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
    /// <code>metadata-function</code> parameter is required. <code>The
    /// sdk-version</code> parameter is optional and defaults to the currently
    /// supported version.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// sdk-version=<i>version_number</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
    /// of required parameters, but not both.</p>
    /// <ul>
    /// <li>
    /// <p>If you have one Lambda function that processes metadata
    /// and another for reading the actual data, use the following syntax. Both
    /// parameters are required.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// record-function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> If you have a composite Lambda function that processes
    /// both metadata and data, use the following syntax to specify your Lambda function.</p>
    /// <p>
    /// <code>function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
}
impl std::fmt::Debug for UpdateDataCatalogInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataCatalogInput");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>Specifies the ARN of the resource from which tags are to be removed.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of one or more tag keys whose tags are to be removed from the
    /// specified resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>Specifies the ARN of the resource from which tags are to be removed.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A comma-separated list of one or more tag keys whose tags are to be removed from the
    /// specified resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>Specifies the ARN of the Athena resource (workgroup or data catalog) to
    /// which tags are to be added.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A collection of one or more tags, separated by commas, to be added to an Athena workgroup or data catalog resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>Specifies the ARN of the Athena resource (workgroup or data catalog) to
    /// which tags are to be added.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A collection of one or more tags, separated by commas, to be added to an Athena workgroup or data catalog resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopQueryExecutionInput {
    /// <p>The unique ID of the query execution to stop.</p>
    pub query_execution_id: std::option::Option<std::string::String>,
}
impl StopQueryExecutionInput {
    /// <p>The unique ID of the query execution to stop.</p>
    pub fn query_execution_id(&self) -> std::option::Option<&str> {
        self.query_execution_id.as_deref()
    }
}
impl std::fmt::Debug for StopQueryExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopQueryExecutionInput");
        formatter.field("query_execution_id", &self.query_execution_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartQueryExecutionInput {
    /// <p>The SQL query statements to be executed.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive string used to ensure the request to create the query is
    /// idempotent (executes only once). If another <code>StartQueryExecution</code> request is
    /// received, the same response is returned and another query is not created. If a parameter
    /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
    /// <important>
    /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
    /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
    /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
    /// this token or the action will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The database within which the query executes.</p>
    pub query_execution_context: std::option::Option<crate::model::QueryExecutionContext>,
    /// <p>Specifies information about where and how to save the results of the query execution.
    /// If the query runs in a workgroup, then workgroup's settings may override query settings.
    /// This affects the query results location. The workgroup settings override is specified in
    /// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
    pub result_configuration: std::option::Option<crate::model::ResultConfiguration>,
    /// <p>The name of the workgroup in which the query is being started.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl StartQueryExecutionInput {
    /// <p>The SQL query statements to be executed.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>A unique case-sensitive string used to ensure the request to create the query is
    /// idempotent (executes only once). If another <code>StartQueryExecution</code> request is
    /// received, the same response is returned and another query is not created. If a parameter
    /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
    /// <important>
    /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
    /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
    /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
    /// this token or the action will fail.</p>
    /// </important>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The database within which the query executes.</p>
    pub fn query_execution_context(
        &self,
    ) -> std::option::Option<&crate::model::QueryExecutionContext> {
        self.query_execution_context.as_ref()
    }
    /// <p>Specifies information about where and how to save the results of the query execution.
    /// If the query runs in a workgroup, then workgroup's settings may override query settings.
    /// This affects the query results location. The workgroup settings override is specified in
    /// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
    pub fn result_configuration(&self) -> std::option::Option<&crate::model::ResultConfiguration> {
        self.result_configuration.as_ref()
    }
    /// <p>The name of the workgroup in which the query is being started.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for StartQueryExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartQueryExecutionInput");
        formatter.field("query_string", &self.query_string);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("query_execution_context", &self.query_execution_context);
        formatter.field("result_configuration", &self.result_configuration);
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkGroupsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of workgroups to return in this request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListWorkGroupsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of workgroups to return in this request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListWorkGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkGroupsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>Lists the tags for the resource with the specified ARN.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results, or null if there are no additional results for
    /// this request, where the request lists the tags for the resource with the specified
    /// ARN.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to be returned per request that lists the tags for the
    /// resource.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTagsForResourceInput {
    /// <p>Lists the tags for the resource with the specified ARN.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The token for the next set of results, or null if there are no additional results for
    /// this request, where the request lists the tags for the resource with the specified
    /// ARN.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to be returned per request that lists the tags for the
    /// resource.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTableMetadataInput {
    /// <p>The name of the data catalog for which table metadata should be returned.</p>
    pub catalog_name: std::option::Option<std::string::String>,
    /// <p>The name of the database for which table metadata should be returned.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>A regex filter that pattern-matches table names. If no expression is supplied,
    /// metadata for all tables are listed.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the NextToken from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTableMetadataInput {
    /// <p>The name of the data catalog for which table metadata should be returned.</p>
    pub fn catalog_name(&self) -> std::option::Option<&str> {
        self.catalog_name.as_deref()
    }
    /// <p>The name of the database for which table metadata should be returned.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>A regex filter that pattern-matches table names. If no expression is supplied,
    /// metadata for all tables are listed.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the NextToken from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTableMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTableMetadataInput");
        formatter.field("catalog_name", &self.catalog_name);
        formatter.field("database_name", &self.database_name);
        formatter.field("expression", &self.expression);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueryExecutionsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of query executions to return in this request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The name of the workgroup from which queries are being returned. If a workgroup is not
    /// specified, a list of available query execution IDs for the queries in the primary
    /// workgroup is returned.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl ListQueryExecutionsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of query executions to return in this request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The name of the workgroup from which queries are being returned. If a workgroup is not
    /// specified, a list of available query execution IDs for the queries in the primary
    /// workgroup is returned.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for ListQueryExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueryExecutionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPreparedStatementsInput {
    /// <p>The workgroup to list the prepared statements for.</p>
    pub work_group: std::option::Option<std::string::String>,
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return in this request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPreparedStatementsInput {
    /// <p>The workgroup to list the prepared statements for.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return in this request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPreparedStatementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPreparedStatementsInput");
        formatter.field("work_group", &self.work_group);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNamedQueriesInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of queries to return in this request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The name of the workgroup from which the named queries are being returned. If a
    /// workgroup is not specified, the saved queries for the primary workgroup are
    /// returned.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl ListNamedQueriesInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of queries to return in this request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The name of the workgroup from which the named queries are being returned. If a
    /// workgroup is not specified, the saved queries for the primary workgroup are
    /// returned.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for ListNamedQueriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNamedQueriesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEngineVersionsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of engine versions to return in this request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEngineVersionsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of engine versions to return in this request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEngineVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEngineVersionsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataCatalogsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the NextToken from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of data catalogs to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDataCatalogsInput {
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the NextToken from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the maximum number of data catalogs to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDataCatalogsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataCatalogsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatabasesInput {
    /// <p>The name of the data catalog that contains the databases to return.</p>
    pub catalog_name: std::option::Option<std::string::String>,
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDatabasesInput {
    /// <p>The name of the data catalog that contains the databases to return.</p>
    pub fn catalog_name(&self) -> std::option::Option<&str> {
        self.catalog_name.as_deref()
    }
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDatabasesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatabasesInput");
        formatter.field("catalog_name", &self.catalog_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkGroupInput {
    /// <p>The name of the workgroup.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl GetWorkGroupInput {
    /// <p>The name of the workgroup.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for GetWorkGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkGroupInput");
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTableMetadataInput {
    /// <p>The name of the data catalog that contains the database and table metadata to
    /// return.</p>
    pub catalog_name: std::option::Option<std::string::String>,
    /// <p>The name of the database that contains the table metadata to return.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the table for which metadata is returned.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl GetTableMetadataInput {
    /// <p>The name of the data catalog that contains the database and table metadata to
    /// return.</p>
    pub fn catalog_name(&self) -> std::option::Option<&str> {
        self.catalog_name.as_deref()
    }
    /// <p>The name of the database that contains the table metadata to return.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the table for which metadata is returned.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for GetTableMetadataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTableMetadataInput");
        formatter.field("catalog_name", &self.catalog_name);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryResultsInput {
    /// <p>The unique ID of the query execution.</p>
    pub query_execution_id: std::option::Option<std::string::String>,
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results (rows) to return in this request.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetQueryResultsInput {
    /// <p>The unique ID of the query execution.</p>
    pub fn query_execution_id(&self) -> std::option::Option<&str> {
        self.query_execution_id.as_deref()
    }
    /// <p>A token generated by the Athena service that specifies where to continue
    /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
    /// the <code>NextToken</code> from the response object of the previous page call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results (rows) to return in this request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetQueryResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryResultsInput");
        formatter.field("query_execution_id", &self.query_execution_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueryExecutionInput {
    /// <p>The unique ID of the query execution.</p>
    pub query_execution_id: std::option::Option<std::string::String>,
}
impl GetQueryExecutionInput {
    /// <p>The unique ID of the query execution.</p>
    pub fn query_execution_id(&self) -> std::option::Option<&str> {
        self.query_execution_id.as_deref()
    }
}
impl std::fmt::Debug for GetQueryExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueryExecutionInput");
        formatter.field("query_execution_id", &self.query_execution_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPreparedStatementInput {
    /// <p>The name of the prepared statement to retrieve.</p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The workgroup to which the statement to be retrieved belongs.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl GetPreparedStatementInput {
    /// <p>The name of the prepared statement to retrieve.</p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
    /// <p>The workgroup to which the statement to be retrieved belongs.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for GetPreparedStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPreparedStatementInput");
        formatter.field("statement_name", &self.statement_name);
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNamedQueryInput {
    /// <p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query
    /// IDs.</p>
    pub named_query_id: std::option::Option<std::string::String>,
}
impl GetNamedQueryInput {
    /// <p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query
    /// IDs.</p>
    pub fn named_query_id(&self) -> std::option::Option<&str> {
        self.named_query_id.as_deref()
    }
}
impl std::fmt::Debug for GetNamedQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNamedQueryInput");
        formatter.field("named_query_id", &self.named_query_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataCatalogInput {
    /// <p>The name of the data catalog to return.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetDataCatalogInput {
    /// <p>The name of the data catalog to return.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetDataCatalogInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataCatalogInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDatabaseInput {
    /// <p>The name of the data catalog that contains the database to return.</p>
    pub catalog_name: std::option::Option<std::string::String>,
    /// <p>The name of the database to return.</p>
    pub database_name: std::option::Option<std::string::String>,
}
impl GetDatabaseInput {
    /// <p>The name of the data catalog that contains the database to return.</p>
    pub fn catalog_name(&self) -> std::option::Option<&str> {
        self.catalog_name.as_deref()
    }
    /// <p>The name of the database to return.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
}
impl std::fmt::Debug for GetDatabaseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDatabaseInput");
        formatter.field("catalog_name", &self.catalog_name);
        formatter.field("database_name", &self.database_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkGroupInput {
    /// <p>The unique name of the workgroup to delete.</p>
    pub work_group: std::option::Option<std::string::String>,
    /// <p>The option to delete the workgroup and its contents even if the workgroup contains any
    /// named queries or query executions.</p>
    pub recursive_delete_option: std::option::Option<bool>,
}
impl DeleteWorkGroupInput {
    /// <p>The unique name of the workgroup to delete.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
    /// <p>The option to delete the workgroup and its contents even if the workgroup contains any
    /// named queries or query executions.</p>
    pub fn recursive_delete_option(&self) -> std::option::Option<bool> {
        self.recursive_delete_option
    }
}
impl std::fmt::Debug for DeleteWorkGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkGroupInput");
        formatter.field("work_group", &self.work_group);
        formatter.field("recursive_delete_option", &self.recursive_delete_option);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePreparedStatementInput {
    /// <p>The name of the prepared statement to delete.</p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The workgroup to which the statement to be deleted belongs.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl DeletePreparedStatementInput {
    /// <p>The name of the prepared statement to delete.</p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
    /// <p>The workgroup to which the statement to be deleted belongs.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for DeletePreparedStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePreparedStatementInput");
        formatter.field("statement_name", &self.statement_name);
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNamedQueryInput {
    /// <p>The unique ID of the query to delete.</p>
    pub named_query_id: std::option::Option<std::string::String>,
}
impl DeleteNamedQueryInput {
    /// <p>The unique ID of the query to delete.</p>
    pub fn named_query_id(&self) -> std::option::Option<&str> {
        self.named_query_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteNamedQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNamedQueryInput");
        formatter.field("named_query_id", &self.named_query_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataCatalogInput {
    /// <p>The name of the data catalog to delete.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteDataCatalogInput {
    /// <p>The name of the data catalog to delete.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDataCatalogInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataCatalogInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWorkGroupInput {
    /// <p>The workgroup name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The configuration for the workgroup, which includes the location in Amazon S3
    /// where query results are stored, the encryption configuration, if any, used for
    /// encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the
    /// workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is
    /// specified, and whether workgroup's settings (specified with
    /// <code>EnforceWorkGroupConfiguration</code>) in the
    /// <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
    pub configuration: std::option::Option<crate::model::WorkGroupConfiguration>,
    /// <p>The workgroup description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of comma separated tags to add to the workgroup that is created.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateWorkGroupInput {
    /// <p>The workgroup name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The configuration for the workgroup, which includes the location in Amazon S3
    /// where query results are stored, the encryption configuration, if any, used for
    /// encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the
    /// workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is
    /// specified, and whether workgroup's settings (specified with
    /// <code>EnforceWorkGroupConfiguration</code>) in the
    /// <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::WorkGroupConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The workgroup description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of comma separated tags to add to the workgroup that is created.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateWorkGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWorkGroupInput");
        formatter.field("name", &self.name);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePreparedStatementInput {
    /// <p>The name of the prepared statement.</p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The name of the workgroup to which the prepared statement belongs.</p>
    pub work_group: std::option::Option<std::string::String>,
    /// <p>The query string for the prepared statement.</p>
    pub query_statement: std::option::Option<std::string::String>,
    /// <p>The description of the prepared statement.</p>
    pub description: std::option::Option<std::string::String>,
}
impl CreatePreparedStatementInput {
    /// <p>The name of the prepared statement.</p>
    pub fn statement_name(&self) -> std::option::Option<&str> {
        self.statement_name.as_deref()
    }
    /// <p>The name of the workgroup to which the prepared statement belongs.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
    /// <p>The query string for the prepared statement.</p>
    pub fn query_statement(&self) -> std::option::Option<&str> {
        self.query_statement.as_deref()
    }
    /// <p>The description of the prepared statement.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CreatePreparedStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePreparedStatementInput");
        formatter.field("statement_name", &self.statement_name);
        formatter.field("work_group", &self.work_group);
        formatter.field("query_statement", &self.query_statement);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNamedQueryInput {
    /// <p>The query name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The query description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The database to which the query belongs.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The contents of the query with all query statements.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>A unique case-sensitive string used to ensure the request to create the query is
    /// idempotent (executes only once). If another <code>CreateNamedQuery</code> request is
    /// received, the same response is returned and another query is not created. If a parameter
    /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
    /// <important>
    /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
    /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
    /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
    /// this token or the action will fail.</p>
    /// </important>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The name of the workgroup in which the named query is being created.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl CreateNamedQueryInput {
    /// <p>The query name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The query description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The database to which the query belongs.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>The contents of the query with all query statements.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>A unique case-sensitive string used to ensure the request to create the query is
    /// idempotent (executes only once). If another <code>CreateNamedQuery</code> request is
    /// received, the same response is returned and another query is not created. If a parameter
    /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
    /// <important>
    /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
    /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
    /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
    /// this token or the action will fail.</p>
    /// </important>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The name of the workgroup in which the named query is being created.</p>
    pub fn work_group(&self) -> std::option::Option<&str> {
        self.work_group.as_deref()
    }
}
impl std::fmt::Debug for CreateNamedQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNamedQueryInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("database", &self.database);
        formatter.field("query_string", &self.query_string);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataCatalogInput {
    /// <p>The name of the data catalog to create. The catalog name must be unique for the
    /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
    /// sign, or hyphen characters.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
    /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
    /// Glue Data Catalog.</p>
    pub r#type: std::option::Option<crate::model::DataCatalogType>,
    /// <p>A description of the data catalog to be created.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the Lambda function or functions to use for creating the data
    /// catalog. This is a mapping whose values depend on the catalog type. </p>
    /// <ul>
    /// <li>
    /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
    /// <code>metadata-function</code> parameter is required. <code>The
    /// sdk-version</code> parameter is optional and defaults to the currently
    /// supported version.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// sdk-version=<i>version_number</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
    /// of required parameters, but not both.</p>
    /// <ul>
    /// <li>
    /// <p>If you have one Lambda function that processes metadata
    /// and another for reading the actual data, use the following syntax. Both
    /// parameters are required.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// record-function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> If you have a composite Lambda function that processes
    /// both metadata and data, use the following syntax to specify your Lambda function.</p>
    /// <p>
    /// <code>function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
    /// <code>
    /// <i>catalog_id</i>
    /// </code> is the account ID of the
    /// Amazon Web Services account to which the Glue Data Catalog
    /// belongs.</p>
    /// <p>
    /// <code>catalog-id=<i>catalog_id</i>
    /// </code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The <code>GLUE</code> data catalog type also applies to the default
    /// <code>AwsDataCatalog</code> that already exists in your account, of
    /// which you can have only one and cannot modify.</p>
    /// </li>
    /// <li>
    /// <p>Queries that specify a Glue Data Catalog other than the default
    /// <code>AwsDataCatalog</code> must be run on Athena engine
    /// version 2.</p>
    /// </li>
    /// <li>
    /// <p>In Regions where Athena engine version 2 is not available,
    /// creating new Glue data catalogs results in an
    /// <code>INVALID_INPUT</code> error.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of comma separated tags to add to the data catalog that is created.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDataCatalogInput {
    /// <p>The name of the data catalog to create. The catalog name must be unique for the
    /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
    /// sign, or hyphen characters.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
    /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
    /// Glue Data Catalog.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataCatalogType> {
        self.r#type.as_ref()
    }
    /// <p>A description of the data catalog to be created.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the Lambda function or functions to use for creating the data
    /// catalog. This is a mapping whose values depend on the catalog type. </p>
    /// <ul>
    /// <li>
    /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
    /// <code>metadata-function</code> parameter is required. <code>The
    /// sdk-version</code> parameter is optional and defaults to the currently
    /// supported version.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// sdk-version=<i>version_number</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
    /// of required parameters, but not both.</p>
    /// <ul>
    /// <li>
    /// <p>If you have one Lambda function that processes metadata
    /// and another for reading the actual data, use the following syntax. Both
    /// parameters are required.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// record-function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> If you have a composite Lambda function that processes
    /// both metadata and data, use the following syntax to specify your Lambda function.</p>
    /// <p>
    /// <code>function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
    /// <code>
    /// <i>catalog_id</i>
    /// </code> is the account ID of the
    /// Amazon Web Services account to which the Glue Data Catalog
    /// belongs.</p>
    /// <p>
    /// <code>catalog-id=<i>catalog_id</i>
    /// </code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The <code>GLUE</code> data catalog type also applies to the default
    /// <code>AwsDataCatalog</code> that already exists in your account, of
    /// which you can have only one and cannot modify.</p>
    /// </li>
    /// <li>
    /// <p>Queries that specify a Glue Data Catalog other than the default
    /// <code>AwsDataCatalog</code> must be run on Athena engine
    /// version 2.</p>
    /// </li>
    /// <li>
    /// <p>In Regions where Athena engine version 2 is not available,
    /// creating new Glue data catalogs results in an
    /// <code>INVALID_INPUT</code> error.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
    /// <p>A list of comma separated tags to add to the data catalog that is created.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDataCatalogInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataCatalogInput");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetQueryExecutionInput {
    /// <p>An array of query execution IDs.</p>
    pub query_execution_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetQueryExecutionInput {
    /// <p>An array of query execution IDs.</p>
    pub fn query_execution_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.query_execution_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchGetQueryExecutionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetQueryExecutionInput");
        formatter.field("query_execution_ids", &self.query_execution_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetNamedQueryInput {
    /// <p>An array of query IDs.</p>
    pub named_query_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetNamedQueryInput {
    /// <p>An array of query IDs.</p>
    pub fn named_query_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.named_query_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchGetNamedQueryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetNamedQueryInput");
        formatter.field("named_query_ids", &self.named_query_ids);
        formatter.finish()
    }
}
