// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WorkGroupState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WorkGroupState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => WorkGroupState::Disabled,
            "ENABLED" => WorkGroupState::Enabled,
            other => WorkGroupState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WorkGroupState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WorkGroupState::from(s))
    }
}
impl WorkGroupState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WorkGroupState::Disabled => "DISABLED",
            WorkGroupState::Enabled => "ENABLED",
            WorkGroupState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for WorkGroupState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configuration information that will be updated for this workgroup, which includes
/// the location in Amazon S3 where query results are stored, the encryption option,
/// if any, used for query results, whether the Amazon CloudWatch Metrics are enabled
/// for the workgroup, whether the workgroup settings override the client-side settings, and
/// the data usage limit for the amount of bytes scanned per query, if it is
/// specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkGroupConfigurationUpdates {
    /// <p>If set to "true", the settings for the workgroup override client-side settings. If set
    /// to "false" client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
    pub enforce_work_group_configuration: std::option::Option<bool>,
    /// <p>The result configuration information about the queries in this workgroup that will be
    /// updated. Includes the updated results location and an updated option for encrypting
    /// query results.</p>
    pub result_configuration_updates: std::option::Option<crate::model::ResultConfigurationUpdates>,
    /// <p>Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.</p>
    pub publish_cloud_watch_metrics_enabled: std::option::Option<bool>,
    /// <p>The upper limit (cutoff) for the amount of bytes a single query in a workgroup is
    /// allowed to scan.</p>
    pub bytes_scanned_cutoff_per_query: std::option::Option<i64>,
    /// <p>Indicates that the data usage control limit per query is removed. <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
    /// </p>
    pub remove_bytes_scanned_cutoff_per_query: std::option::Option<bool>,
    /// <p>If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>, workgroup
    /// members cannot query data from Requester Pays buckets, and queries that retrieve data
    /// from Requester Pays buckets cause an error. The default is <code>false</code>. For more
    /// information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>
    /// in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
    pub requester_pays_enabled: std::option::Option<bool>,
    /// <p>The engine version requested when a workgroup is updated. After the update, all
    /// queries on the workgroup run on the requested engine version. If no value was previously
    /// set, the default is Auto. Queries on the <code>AmazonAthenaPreviewFunctionality</code>
    /// workgroup run on the preview engine regardless of this setting.</p>
    pub engine_version: std::option::Option<crate::model::EngineVersion>,
}
impl std::fmt::Debug for WorkGroupConfigurationUpdates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkGroupConfigurationUpdates");
        formatter.field(
            "enforce_work_group_configuration",
            &self.enforce_work_group_configuration,
        );
        formatter.field(
            "result_configuration_updates",
            &self.result_configuration_updates,
        );
        formatter.field(
            "publish_cloud_watch_metrics_enabled",
            &self.publish_cloud_watch_metrics_enabled,
        );
        formatter.field(
            "bytes_scanned_cutoff_per_query",
            &self.bytes_scanned_cutoff_per_query,
        );
        formatter.field(
            "remove_bytes_scanned_cutoff_per_query",
            &self.remove_bytes_scanned_cutoff_per_query,
        );
        formatter.field("requester_pays_enabled", &self.requester_pays_enabled);
        formatter.field("engine_version", &self.engine_version);
        formatter.finish()
    }
}
/// See [`WorkGroupConfigurationUpdates`](crate::model::WorkGroupConfigurationUpdates)
pub mod work_group_configuration_updates {
    /// A builder for [`WorkGroupConfigurationUpdates`](crate::model::WorkGroupConfigurationUpdates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enforce_work_group_configuration: std::option::Option<bool>,
        pub(crate) result_configuration_updates:
            std::option::Option<crate::model::ResultConfigurationUpdates>,
        pub(crate) publish_cloud_watch_metrics_enabled: std::option::Option<bool>,
        pub(crate) bytes_scanned_cutoff_per_query: std::option::Option<i64>,
        pub(crate) remove_bytes_scanned_cutoff_per_query: std::option::Option<bool>,
        pub(crate) requester_pays_enabled: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<crate::model::EngineVersion>,
    }
    impl Builder {
        /// <p>If set to "true", the settings for the workgroup override client-side settings. If set
        /// to "false" client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
        pub fn enforce_work_group_configuration(mut self, input: bool) -> Self {
            self.enforce_work_group_configuration = Some(input);
            self
        }
        /// <p>If set to "true", the settings for the workgroup override client-side settings. If set
        /// to "false" client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
        pub fn set_enforce_work_group_configuration(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enforce_work_group_configuration = input;
            self
        }
        /// <p>The result configuration information about the queries in this workgroup that will be
        /// updated. Includes the updated results location and an updated option for encrypting
        /// query results.</p>
        pub fn result_configuration_updates(
            mut self,
            input: crate::model::ResultConfigurationUpdates,
        ) -> Self {
            self.result_configuration_updates = Some(input);
            self
        }
        /// <p>The result configuration information about the queries in this workgroup that will be
        /// updated. Includes the updated results location and an updated option for encrypting
        /// query results.</p>
        pub fn set_result_configuration_updates(
            mut self,
            input: std::option::Option<crate::model::ResultConfigurationUpdates>,
        ) -> Self {
            self.result_configuration_updates = input;
            self
        }
        /// <p>Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.</p>
        pub fn publish_cloud_watch_metrics_enabled(mut self, input: bool) -> Self {
            self.publish_cloud_watch_metrics_enabled = Some(input);
            self
        }
        /// <p>Indicates whether this workgroup enables publishing metrics to Amazon CloudWatch.</p>
        pub fn set_publish_cloud_watch_metrics_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.publish_cloud_watch_metrics_enabled = input;
            self
        }
        /// <p>The upper limit (cutoff) for the amount of bytes a single query in a workgroup is
        /// allowed to scan.</p>
        pub fn bytes_scanned_cutoff_per_query(mut self, input: i64) -> Self {
            self.bytes_scanned_cutoff_per_query = Some(input);
            self
        }
        /// <p>The upper limit (cutoff) for the amount of bytes a single query in a workgroup is
        /// allowed to scan.</p>
        pub fn set_bytes_scanned_cutoff_per_query(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.bytes_scanned_cutoff_per_query = input;
            self
        }
        /// <p>Indicates that the data usage control limit per query is removed. <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
        /// </p>
        pub fn remove_bytes_scanned_cutoff_per_query(mut self, input: bool) -> Self {
            self.remove_bytes_scanned_cutoff_per_query = Some(input);
            self
        }
        /// <p>Indicates that the data usage control limit per query is removed. <a>WorkGroupConfiguration$BytesScannedCutoffPerQuery</a>
        /// </p>
        pub fn set_remove_bytes_scanned_cutoff_per_query(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.remove_bytes_scanned_cutoff_per_query = input;
            self
        }
        /// <p>If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>, workgroup
        /// members cannot query data from Requester Pays buckets, and queries that retrieve data
        /// from Requester Pays buckets cause an error. The default is <code>false</code>. For more
        /// information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>
        /// in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
        pub fn requester_pays_enabled(mut self, input: bool) -> Self {
            self.requester_pays_enabled = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, allows members assigned to a workgroup to specify Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>, workgroup
        /// members cannot query data from Requester Pays buckets, and queries that retrieve data
        /// from Requester Pays buckets cause an error. The default is <code>false</code>. For more
        /// information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester Pays Buckets</a>
        /// in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
        pub fn set_requester_pays_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays_enabled = input;
            self
        }
        /// <p>The engine version requested when a workgroup is updated. After the update, all
        /// queries on the workgroup run on the requested engine version. If no value was previously
        /// set, the default is Auto. Queries on the <code>AmazonAthenaPreviewFunctionality</code>
        /// workgroup run on the preview engine regardless of this setting.</p>
        pub fn engine_version(mut self, input: crate::model::EngineVersion) -> Self {
            self.engine_version = Some(input);
            self
        }
        /// <p>The engine version requested when a workgroup is updated. After the update, all
        /// queries on the workgroup run on the requested engine version. If no value was previously
        /// set, the default is Auto. Queries on the <code>AmazonAthenaPreviewFunctionality</code>
        /// workgroup run on the preview engine regardless of this setting.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<crate::model::EngineVersion>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkGroupConfigurationUpdates`](crate::model::WorkGroupConfigurationUpdates)
        pub fn build(self) -> crate::model::WorkGroupConfigurationUpdates {
            crate::model::WorkGroupConfigurationUpdates {
                enforce_work_group_configuration: self.enforce_work_group_configuration,
                result_configuration_updates: self.result_configuration_updates,
                publish_cloud_watch_metrics_enabled: self.publish_cloud_watch_metrics_enabled,
                bytes_scanned_cutoff_per_query: self.bytes_scanned_cutoff_per_query,
                remove_bytes_scanned_cutoff_per_query: self.remove_bytes_scanned_cutoff_per_query,
                requester_pays_enabled: self.requester_pays_enabled,
                engine_version: self.engine_version,
            }
        }
    }
}
impl WorkGroupConfigurationUpdates {
    /// Creates a new builder-style object to manufacture [`WorkGroupConfigurationUpdates`](crate::model::WorkGroupConfigurationUpdates)
    pub fn builder() -> crate::model::work_group_configuration_updates::Builder {
        crate::model::work_group_configuration_updates::Builder::default()
    }
}

/// <p>The Athena engine version for running queries.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineVersion {
    /// <p>The engine version requested by the user. Possible values are determined by the output
    /// of <code>ListEngineVersions</code>, including Auto. The default is Auto.</p>
    pub selected_engine_version: std::option::Option<std::string::String>,
    /// <p>Read only. The engine version on which the query runs. If the user requests a valid
    /// engine version other than Auto, the effective engine version is the same as the engine
    /// version that the user requested. If the user requests Auto, the effective engine version
    /// is chosen by Athena. When a request to update the engine version is made by
    /// a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the
    /// <code>EffectiveEngineVersion</code> field is ignored.</p>
    pub effective_engine_version: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EngineVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineVersion");
        formatter.field("selected_engine_version", &self.selected_engine_version);
        formatter.field("effective_engine_version", &self.effective_engine_version);
        formatter.finish()
    }
}
/// See [`EngineVersion`](crate::model::EngineVersion)
pub mod engine_version {
    /// A builder for [`EngineVersion`](crate::model::EngineVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) selected_engine_version: std::option::Option<std::string::String>,
        pub(crate) effective_engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The engine version requested by the user. Possible values are determined by the output
        /// of <code>ListEngineVersions</code>, including Auto. The default is Auto.</p>
        pub fn selected_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.selected_engine_version = Some(input.into());
            self
        }
        /// <p>The engine version requested by the user. Possible values are determined by the output
        /// of <code>ListEngineVersions</code>, including Auto. The default is Auto.</p>
        pub fn set_selected_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.selected_engine_version = input;
            self
        }
        /// <p>Read only. The engine version on which the query runs. If the user requests a valid
        /// engine version other than Auto, the effective engine version is the same as the engine
        /// version that the user requested. If the user requests Auto, the effective engine version
        /// is chosen by Athena. When a request to update the engine version is made by
        /// a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the
        /// <code>EffectiveEngineVersion</code> field is ignored.</p>
        pub fn effective_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_engine_version = Some(input.into());
            self
        }
        /// <p>Read only. The engine version on which the query runs. If the user requests a valid
        /// engine version other than Auto, the effective engine version is the same as the engine
        /// version that the user requested. If the user requests Auto, the effective engine version
        /// is chosen by Athena. When a request to update the engine version is made by
        /// a <code>CreateWorkGroup</code> or <code>UpdateWorkGroup</code> operation, the
        /// <code>EffectiveEngineVersion</code> field is ignored.</p>
        pub fn set_effective_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineVersion`](crate::model::EngineVersion)
        pub fn build(self) -> crate::model::EngineVersion {
            crate::model::EngineVersion {
                selected_engine_version: self.selected_engine_version,
                effective_engine_version: self.effective_engine_version,
            }
        }
    }
}
impl EngineVersion {
    /// Creates a new builder-style object to manufacture [`EngineVersion`](crate::model::EngineVersion)
    pub fn builder() -> crate::model::engine_version::Builder {
        crate::model::engine_version::Builder::default()
    }
}

/// <p>The information about the updates in the query results, such as output location and
/// encryption configuration for the query results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultConfigurationUpdates {
    /// <p>The location in Amazon S3 where your query results are stored, such as
    /// <code>s3://path/to/query/bucket/</code>. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If
    /// workgroup settings override client-side settings, then the query uses the location for
    /// the query results and the encryption configuration that are specified for the workgroup.
    /// The "workgroup settings override" is specified in
    /// <code>EnforceWorkGroupConfiguration</code> (true/false) in the
    /// <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
    pub output_location: std::option::Option<std::string::String>,
    /// <p>If set to "true", indicates that the previously-specified query results location (also
    /// known as a client-side setting) for queries in this workgroup should be ignored and set
    /// to null. If set to "false" or not set, and a value is present in the
    /// <code>OutputLocation</code> in <code>ResultConfigurationUpdates</code> (the
    /// client-side setting), the <code>OutputLocation</code> in the workgroup's
    /// <code>ResultConfiguration</code> will be updated with the new value. For more
    /// information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
    /// Client-Side Settings</a>.</p>
    pub remove_output_location: std::option::Option<bool>,
    /// <p>The encryption configuration for the query results.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>If set to "true", indicates that the previously-specified encryption configuration
    /// (also known as the client-side setting) for queries in this workgroup should be ignored
    /// and set to null. If set to "false" or not set, and a value is present in the
    /// <code>EncryptionConfiguration</code> in <code>ResultConfigurationUpdates</code> (the
    /// client-side setting), the <code>EncryptionConfiguration</code> in the workgroup's
    /// <code>ResultConfiguration</code> will be updated with the new value. For more
    /// information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
    /// Client-Side Settings</a>.</p>
    pub remove_encryption_configuration: std::option::Option<bool>,
}
impl std::fmt::Debug for ResultConfigurationUpdates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultConfigurationUpdates");
        formatter.field("output_location", &self.output_location);
        formatter.field("remove_output_location", &self.remove_output_location);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "remove_encryption_configuration",
            &self.remove_encryption_configuration,
        );
        formatter.finish()
    }
}
/// See [`ResultConfigurationUpdates`](crate::model::ResultConfigurationUpdates)
pub mod result_configuration_updates {
    /// A builder for [`ResultConfigurationUpdates`](crate::model::ResultConfigurationUpdates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_location: std::option::Option<std::string::String>,
        pub(crate) remove_output_location: std::option::Option<bool>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) remove_encryption_configuration: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The location in Amazon S3 where your query results are stored, such as
        /// <code>s3://path/to/query/bucket/</code>. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If
        /// workgroup settings override client-side settings, then the query uses the location for
        /// the query results and the encryption configuration that are specified for the workgroup.
        /// The "workgroup settings override" is specified in
        /// <code>EnforceWorkGroupConfiguration</code> (true/false) in the
        /// <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn output_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_location = Some(input.into());
            self
        }
        /// <p>The location in Amazon S3 where your query results are stored, such as
        /// <code>s3://path/to/query/bucket/</code>. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> If
        /// workgroup settings override client-side settings, then the query uses the location for
        /// the query results and the encryption configuration that are specified for the workgroup.
        /// The "workgroup settings override" is specified in
        /// <code>EnforceWorkGroupConfiguration</code> (true/false) in the
        /// <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>If set to "true", indicates that the previously-specified query results location (also
        /// known as a client-side setting) for queries in this workgroup should be ignored and set
        /// to null. If set to "false" or not set, and a value is present in the
        /// <code>OutputLocation</code> in <code>ResultConfigurationUpdates</code> (the
        /// client-side setting), the <code>OutputLocation</code> in the workgroup's
        /// <code>ResultConfiguration</code> will be updated with the new value. For more
        /// information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
        /// Client-Side Settings</a>.</p>
        pub fn remove_output_location(mut self, input: bool) -> Self {
            self.remove_output_location = Some(input);
            self
        }
        /// <p>If set to "true", indicates that the previously-specified query results location (also
        /// known as a client-side setting) for queries in this workgroup should be ignored and set
        /// to null. If set to "false" or not set, and a value is present in the
        /// <code>OutputLocation</code> in <code>ResultConfigurationUpdates</code> (the
        /// client-side setting), the <code>OutputLocation</code> in the workgroup's
        /// <code>ResultConfiguration</code> will be updated with the new value. For more
        /// information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
        /// Client-Side Settings</a>.</p>
        pub fn set_remove_output_location(mut self, input: std::option::Option<bool>) -> Self {
            self.remove_output_location = input;
            self
        }
        /// <p>The encryption configuration for the query results.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption configuration for the query results.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>If set to "true", indicates that the previously-specified encryption configuration
        /// (also known as the client-side setting) for queries in this workgroup should be ignored
        /// and set to null. If set to "false" or not set, and a value is present in the
        /// <code>EncryptionConfiguration</code> in <code>ResultConfigurationUpdates</code> (the
        /// client-side setting), the <code>EncryptionConfiguration</code> in the workgroup's
        /// <code>ResultConfiguration</code> will be updated with the new value. For more
        /// information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
        /// Client-Side Settings</a>.</p>
        pub fn remove_encryption_configuration(mut self, input: bool) -> Self {
            self.remove_encryption_configuration = Some(input);
            self
        }
        /// <p>If set to "true", indicates that the previously-specified encryption configuration
        /// (also known as the client-side setting) for queries in this workgroup should be ignored
        /// and set to null. If set to "false" or not set, and a value is present in the
        /// <code>EncryptionConfiguration</code> in <code>ResultConfigurationUpdates</code> (the
        /// client-side setting), the <code>EncryptionConfiguration</code> in the workgroup's
        /// <code>ResultConfiguration</code> will be updated with the new value. For more
        /// information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override
        /// Client-Side Settings</a>.</p>
        pub fn set_remove_encryption_configuration(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.remove_encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultConfigurationUpdates`](crate::model::ResultConfigurationUpdates)
        pub fn build(self) -> crate::model::ResultConfigurationUpdates {
            crate::model::ResultConfigurationUpdates {
                output_location: self.output_location,
                remove_output_location: self.remove_output_location,
                encryption_configuration: self.encryption_configuration,
                remove_encryption_configuration: self.remove_encryption_configuration,
            }
        }
    }
}
impl ResultConfigurationUpdates {
    /// Creates a new builder-style object to manufacture [`ResultConfigurationUpdates`](crate::model::ResultConfigurationUpdates)
    pub fn builder() -> crate::model::result_configuration_updates::Builder {
        crate::model::result_configuration_updates::Builder::default()
    }
}

/// <p>If query results are encrypted in Amazon S3, indicates the encryption option
/// used (for example, <code>SSE-KMS</code> or <code>CSE-KMS</code>) and key
/// information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfiguration {
    /// <p>Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (<code>SSE-S3</code>), server-side encryption with KMS-managed keys
    /// (<code>SSE-KMS</code>), or client-side encryption with KMS-managed keys (CSE-KMS) is
    /// used.</p>
    /// <p>If a query runs in a workgroup and the workgroup overrides client-side settings, then
    /// the workgroup's setting for encryption is used. It specifies whether query results must
    /// be encrypted, for all queries that run in this workgroup. </p>
    pub encryption_option: std::option::Option<crate::model::EncryptionOption>,
    /// <p>For <code>SSE-KMS</code> and <code>CSE-KMS</code>, this is the KMS key ARN or
    /// ID.</p>
    pub kms_key: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfiguration");
        formatter.field("encryption_option", &self.encryption_option);
        formatter.field("kms_key", &self.kms_key);
        formatter.finish()
    }
}
/// See [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
pub mod encryption_configuration {
    /// A builder for [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_option: std::option::Option<crate::model::EncryptionOption>,
        pub(crate) kms_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (<code>SSE-S3</code>), server-side encryption with KMS-managed keys
        /// (<code>SSE-KMS</code>), or client-side encryption with KMS-managed keys (CSE-KMS) is
        /// used.</p>
        /// <p>If a query runs in a workgroup and the workgroup overrides client-side settings, then
        /// the workgroup's setting for encryption is used. It specifies whether query results must
        /// be encrypted, for all queries that run in this workgroup. </p>
        pub fn encryption_option(mut self, input: crate::model::EncryptionOption) -> Self {
            self.encryption_option = Some(input);
            self
        }
        /// <p>Indicates whether Amazon S3 server-side encryption with Amazon S3-managed keys (<code>SSE-S3</code>), server-side encryption with KMS-managed keys
        /// (<code>SSE-KMS</code>), or client-side encryption with KMS-managed keys (CSE-KMS) is
        /// used.</p>
        /// <p>If a query runs in a workgroup and the workgroup overrides client-side settings, then
        /// the workgroup's setting for encryption is used. It specifies whether query results must
        /// be encrypted, for all queries that run in this workgroup. </p>
        pub fn set_encryption_option(
            mut self,
            input: std::option::Option<crate::model::EncryptionOption>,
        ) -> Self {
            self.encryption_option = input;
            self
        }
        /// <p>For <code>SSE-KMS</code> and <code>CSE-KMS</code>, this is the KMS key ARN or
        /// ID.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>For <code>SSE-KMS</code> and <code>CSE-KMS</code>, this is the KMS key ARN or
        /// ID.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
        pub fn build(self) -> crate::model::EncryptionConfiguration {
            crate::model::EncryptionConfiguration {
                encryption_option: self.encryption_option,
                kms_key: self.kms_key,
            }
        }
    }
}
impl EncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    pub fn builder() -> crate::model::encryption_configuration::Builder {
        crate::model::encryption_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionOption {
    #[allow(missing_docs)] // documentation missing in model
    CseKms,
    #[allow(missing_docs)] // documentation missing in model
    SseKms,
    #[allow(missing_docs)] // documentation missing in model
    SseS3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionOption {
    fn from(s: &str) -> Self {
        match s {
            "CSE_KMS" => EncryptionOption::CseKms,
            "SSE_KMS" => EncryptionOption::SseKms,
            "SSE_S3" => EncryptionOption::SseS3,
            other => EncryptionOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionOption::from(s))
    }
}
impl EncryptionOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionOption::CseKms => "CSE_KMS",
            EncryptionOption::SseKms => "SSE_KMS",
            EncryptionOption::SseS3 => "SSE_S3",
            EncryptionOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CSE_KMS", "SSE_KMS", "SSE_S3"]
    }
}
impl AsRef<str> for EncryptionOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataCatalogType {
    #[allow(missing_docs)] // documentation missing in model
    Glue,
    #[allow(missing_docs)] // documentation missing in model
    Hive,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataCatalogType {
    fn from(s: &str) -> Self {
        match s {
            "GLUE" => DataCatalogType::Glue,
            "HIVE" => DataCatalogType::Hive,
            "LAMBDA" => DataCatalogType::Lambda,
            other => DataCatalogType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataCatalogType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataCatalogType::from(s))
    }
}
impl DataCatalogType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataCatalogType::Glue => "GLUE",
            DataCatalogType::Hive => "HIVE",
            DataCatalogType::Lambda => "LAMBDA",
            DataCatalogType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GLUE", "HIVE", "LAMBDA"]
    }
}
impl AsRef<str> for DataCatalogType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A label that you assign to a resource. In Athena, a resource can be a
/// workgroup or data catalog. Each tag consists of a key and an optional value, both of
/// which you define. For example, you can use tags to categorize Athena
/// workgroups or data catalogs by purpose, owner, or environment. Use a consistent set of
/// tag keys to make it easier to search and filter workgroups or data catalogs in your
/// account. For best practices, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Tagging Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode
/// characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use
/// letters and numbers representable in UTF-8, and the following characters: + - = . _ : /
/// @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you
/// specify more than one tag, separate them by commas. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8. You can
    /// use letters and numbers representable in UTF-8, and the following characters: + - = . _
    /// : / @. Tag keys are case-sensitive and must be unique per resource. </p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A tag value. The tag value length is from 0 to 256 Unicode characters in UTF-8. You
    /// can use letters and numbers representable in UTF-8, and the following characters: + - =
    /// . _ : / @. Tag values are case-sensitive. </p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8. You can
        /// use letters and numbers representable in UTF-8, and the following characters: + - = . _
        /// : / @. Tag keys are case-sensitive and must be unique per resource. </p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A tag key. The tag key length is from 1 to 128 Unicode characters in UTF-8. You can
        /// use letters and numbers representable in UTF-8, and the following characters: + - = . _
        /// : / @. Tag keys are case-sensitive and must be unique per resource. </p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A tag value. The tag value length is from 0 to 256 Unicode characters in UTF-8. You
        /// can use letters and numbers representable in UTF-8, and the following characters: + - =
        /// . _ : / @. Tag values are case-sensitive. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A tag value. The tag value length is from 0 to 256 Unicode characters in UTF-8. You
        /// can use letters and numbers representable in UTF-8, and the following characters: + - =
        /// . _ : / @. Tag values are case-sensitive. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The reason for the query throttling, for example, when it exceeds the concurrent query
/// limit.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThrottleReason {
    #[allow(missing_docs)] // documentation missing in model
    ConcurrentQueryLimitExceeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThrottleReason {
    fn from(s: &str) -> Self {
        match s {
            "CONCURRENT_QUERY_LIMIT_EXCEEDED" => ThrottleReason::ConcurrentQueryLimitExceeded,
            other => ThrottleReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThrottleReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThrottleReason::from(s))
    }
}
impl ThrottleReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThrottleReason::ConcurrentQueryLimitExceeded => "CONCURRENT_QUERY_LIMIT_EXCEEDED",
            ThrottleReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONCURRENT_QUERY_LIMIT_EXCEEDED"]
    }
}
impl AsRef<str> for ThrottleReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The location in Amazon S3 where query results are stored and the encryption
/// option, if any, used for query results. These are known as "client-side settings". If
/// workgroup settings override client-side settings, then the query uses the workgroup
/// settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultConfiguration {
    /// <p>The location in Amazon S3 where your query results are stored, such as
    /// <code>s3://path/to/query/bucket/</code>. To run the query, you must specify the
    /// query results location using one of the ways: either for individual queries using either
    /// this setting (client-side), or in the workgroup, using <a>WorkGroupConfiguration</a>. If none of them is set, Athena
    /// issues an error that no output location is provided. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>. If
    /// workgroup settings override client-side settings, then the query uses the settings
    /// specified for the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
    pub output_location: std::option::Option<std::string::String>,
    /// <p>If query results are encrypted in Amazon S3, indicates the encryption option
    /// used (for example, <code>SSE-KMS</code> or <code>CSE-KMS</code>) and key information.
    /// This is a client-side setting. If workgroup settings override client-side settings, then
    /// the query uses the encryption configuration that is specified for the workgroup, and
    /// also uses the location for storing query results specified in the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
}
impl std::fmt::Debug for ResultConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultConfiguration");
        formatter.field("output_location", &self.output_location);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.finish()
    }
}
/// See [`ResultConfiguration`](crate::model::ResultConfiguration)
pub mod result_configuration {
    /// A builder for [`ResultConfiguration`](crate::model::ResultConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_location: std::option::Option<std::string::String>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
    }
    impl Builder {
        /// <p>The location in Amazon S3 where your query results are stored, such as
        /// <code>s3://path/to/query/bucket/</code>. To run the query, you must specify the
        /// query results location using one of the ways: either for individual queries using either
        /// this setting (client-side), or in the workgroup, using <a>WorkGroupConfiguration</a>. If none of them is set, Athena
        /// issues an error that no output location is provided. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>. If
        /// workgroup settings override client-side settings, then the query uses the settings
        /// specified for the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn output_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_location = Some(input.into());
            self
        }
        /// <p>The location in Amazon S3 where your query results are stored, such as
        /// <code>s3://path/to/query/bucket/</code>. To run the query, you must specify the
        /// query results location using one of the ways: either for individual queries using either
        /// this setting (client-side), or in the workgroup, using <a>WorkGroupConfiguration</a>. If none of them is set, Athena
        /// issues an error that no output location is provided. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>. If
        /// workgroup settings override client-side settings, then the query uses the settings
        /// specified for the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn set_output_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.output_location = input;
            self
        }
        /// <p>If query results are encrypted in Amazon S3, indicates the encryption option
        /// used (for example, <code>SSE-KMS</code> or <code>CSE-KMS</code>) and key information.
        /// This is a client-side setting. If workgroup settings override client-side settings, then
        /// the query uses the encryption configuration that is specified for the workgroup, and
        /// also uses the location for storing query results specified in the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>If query results are encrypted in Amazon S3, indicates the encryption option
        /// used (for example, <code>SSE-KMS</code> or <code>CSE-KMS</code>) and key information.
        /// This is a client-side setting. If workgroup settings override client-side settings, then
        /// the query uses the encryption configuration that is specified for the workgroup, and
        /// also uses the location for storing query results specified in the workgroup. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a> and <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultConfiguration`](crate::model::ResultConfiguration)
        pub fn build(self) -> crate::model::ResultConfiguration {
            crate::model::ResultConfiguration {
                output_location: self.output_location,
                encryption_configuration: self.encryption_configuration,
            }
        }
    }
}
impl ResultConfiguration {
    /// Creates a new builder-style object to manufacture [`ResultConfiguration`](crate::model::ResultConfiguration)
    pub fn builder() -> crate::model::result_configuration::Builder {
        crate::model::result_configuration::Builder::default()
    }
}

/// <p>The database and data catalog context in which the query execution occurs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryExecutionContext {
    /// <p>The name of the database used in the query execution. The database must exist in the catalog.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name of the data catalog used in the query execution.</p>
    pub catalog: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for QueryExecutionContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryExecutionContext");
        formatter.field("database", &self.database);
        formatter.field("catalog", &self.catalog);
        formatter.finish()
    }
}
/// See [`QueryExecutionContext`](crate::model::QueryExecutionContext)
pub mod query_execution_context {
    /// A builder for [`QueryExecutionContext`](crate::model::QueryExecutionContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) catalog: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database used in the query execution. The database must exist in the catalog.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database used in the query execution. The database must exist in the catalog.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name of the data catalog used in the query execution.</p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>The name of the data catalog used in the query execution.</p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryExecutionContext`](crate::model::QueryExecutionContext)
        pub fn build(self) -> crate::model::QueryExecutionContext {
            crate::model::QueryExecutionContext {
                database: self.database,
                catalog: self.catalog,
            }
        }
    }
}
impl QueryExecutionContext {
    /// Creates a new builder-style object to manufacture [`QueryExecutionContext`](crate::model::QueryExecutionContext)
    pub fn builder() -> crate::model::query_execution_context::Builder {
        crate::model::query_execution_context::Builder::default()
    }
}

/// <p>The summary information for the workgroup, which includes its name, state,
/// description, and the date and time it was created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkGroupSummary {
    /// <p>The name of the workgroup.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the workgroup.</p>
    pub state: std::option::Option<crate::model::WorkGroupState>,
    /// <p>The workgroup description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The workgroup creation date and time.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The engine version setting for all queries on the workgroup. Queries on the
    /// <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
    /// regardless of this setting.</p>
    pub engine_version: std::option::Option<crate::model::EngineVersion>,
}
impl std::fmt::Debug for WorkGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkGroupSummary");
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("engine_version", &self.engine_version);
        formatter.finish()
    }
}
/// See [`WorkGroupSummary`](crate::model::WorkGroupSummary)
pub mod work_group_summary {
    /// A builder for [`WorkGroupSummary`](crate::model::WorkGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::WorkGroupState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) engine_version: std::option::Option<crate::model::EngineVersion>,
    }
    impl Builder {
        /// <p>The name of the workgroup.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the workgroup.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the workgroup.</p>
        pub fn state(mut self, input: crate::model::WorkGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the workgroup.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::WorkGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The workgroup description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The workgroup description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The workgroup creation date and time.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The workgroup creation date and time.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The engine version setting for all queries on the workgroup. Queries on the
        /// <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
        /// regardless of this setting.</p>
        pub fn engine_version(mut self, input: crate::model::EngineVersion) -> Self {
            self.engine_version = Some(input);
            self
        }
        /// <p>The engine version setting for all queries on the workgroup. Queries on the
        /// <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
        /// regardless of this setting.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<crate::model::EngineVersion>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkGroupSummary`](crate::model::WorkGroupSummary)
        pub fn build(self) -> crate::model::WorkGroupSummary {
            crate::model::WorkGroupSummary {
                name: self.name,
                state: self.state,
                description: self.description,
                creation_time: self.creation_time,
                engine_version: self.engine_version,
            }
        }
    }
}
impl WorkGroupSummary {
    /// Creates a new builder-style object to manufacture [`WorkGroupSummary`](crate::model::WorkGroupSummary)
    pub fn builder() -> crate::model::work_group_summary::Builder {
        crate::model::work_group_summary::Builder::default()
    }
}

/// <p>Contains metadata for a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableMetadata {
    /// <p>The name of the table.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that the table was created.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The last time the table was accessed.</p>
    pub last_access_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is
    /// supported.</p>
    pub table_type: std::option::Option<std::string::String>,
    /// <p>A list of the columns in the table.</p>
    pub columns: std::option::Option<std::vec::Vec<crate::model::Column>>,
    /// <p>A list of the partition keys in the table.</p>
    pub partition_keys: std::option::Option<std::vec::Vec<crate::model::Column>>,
    /// <p>A set of custom key/value pairs for table properties.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for TableMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableMetadata");
        formatter.field("name", &self.name);
        formatter.field("create_time", &self.create_time);
        formatter.field("last_access_time", &self.last_access_time);
        formatter.field("table_type", &self.table_type);
        formatter.field("columns", &self.columns);
        formatter.field("partition_keys", &self.partition_keys);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`TableMetadata`](crate::model::TableMetadata)
pub mod table_metadata {
    /// A builder for [`TableMetadata`](crate::model::TableMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_access_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) table_type: std::option::Option<std::string::String>,
        pub(crate) columns: std::option::Option<std::vec::Vec<crate::model::Column>>,
        pub(crate) partition_keys: std::option::Option<std::vec::Vec<crate::model::Column>>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the table.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that the table was created.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The time that the table was created.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The last time the table was accessed.</p>
        pub fn last_access_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_access_time = Some(input);
            self
        }
        /// <p>The last time the table was accessed.</p>
        pub fn set_last_access_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_access_time = input;
            self
        }
        /// <p>The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is
        /// supported.</p>
        pub fn table_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_type = Some(input.into());
            self
        }
        /// <p>The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is
        /// supported.</p>
        pub fn set_table_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_type = input;
            self
        }
        /// Appends an item to `columns`.
        ///
        /// To override the contents of this collection use [`set_columns`](Self::set_columns).
        ///
        /// <p>A list of the columns in the table.</p>
        pub fn columns(mut self, input: impl Into<crate::model::Column>) -> Self {
            let mut v = self.columns.unwrap_or_default();
            v.push(input.into());
            self.columns = Some(v);
            self
        }
        /// <p>A list of the columns in the table.</p>
        pub fn set_columns(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Column>>,
        ) -> Self {
            self.columns = input;
            self
        }
        /// Appends an item to `partition_keys`.
        ///
        /// To override the contents of this collection use [`set_partition_keys`](Self::set_partition_keys).
        ///
        /// <p>A list of the partition keys in the table.</p>
        pub fn partition_keys(mut self, input: impl Into<crate::model::Column>) -> Self {
            let mut v = self.partition_keys.unwrap_or_default();
            v.push(input.into());
            self.partition_keys = Some(v);
            self
        }
        /// <p>A list of the partition keys in the table.</p>
        pub fn set_partition_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Column>>,
        ) -> Self {
            self.partition_keys = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A set of custom key/value pairs for table properties.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A set of custom key/value pairs for table properties.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`TableMetadata`](crate::model::TableMetadata)
        pub fn build(self) -> crate::model::TableMetadata {
            crate::model::TableMetadata {
                name: self.name,
                create_time: self.create_time,
                last_access_time: self.last_access_time,
                table_type: self.table_type,
                columns: self.columns,
                partition_keys: self.partition_keys,
                parameters: self.parameters,
            }
        }
    }
}
impl TableMetadata {
    /// Creates a new builder-style object to manufacture [`TableMetadata`](crate::model::TableMetadata)
    pub fn builder() -> crate::model::table_metadata::Builder {
        crate::model::table_metadata::Builder::default()
    }
}

/// <p>Contains metadata for a column in a table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Column {
    /// <p>The name of the column.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The data type of the column.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>Optional information about the column.</p>
    pub comment: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Column {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Column");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`Column`](crate::model::Column)
pub mod column {
    /// A builder for [`Column`](crate::model::Column)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) comment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The data type of the column.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The data type of the column.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Optional information about the column.</p>
        pub fn comment(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment = Some(input.into());
            self
        }
        /// <p>Optional information about the column.</p>
        pub fn set_comment(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`Column`](crate::model::Column)
        pub fn build(self) -> crate::model::Column {
            crate::model::Column {
                name: self.name,
                r#type: self.r#type,
                comment: self.comment,
            }
        }
    }
}
impl Column {
    /// Creates a new builder-style object to manufacture [`Column`](crate::model::Column)
    pub fn builder() -> crate::model::column::Builder {
        crate::model::column::Builder::default()
    }
}

/// <p>The name and last modified time of the prepared statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreparedStatementSummary {
    /// <p>The name of the prepared statement.</p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The last modified time of the prepared statement.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for PreparedStatementSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreparedStatementSummary");
        formatter.field("statement_name", &self.statement_name);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`PreparedStatementSummary`](crate::model::PreparedStatementSummary)
pub mod prepared_statement_summary {
    /// A builder for [`PreparedStatementSummary`](crate::model::PreparedStatementSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the prepared statement.</p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the prepared statement.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The last modified time of the prepared statement.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last modified time of the prepared statement.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PreparedStatementSummary`](crate::model::PreparedStatementSummary)
        pub fn build(self) -> crate::model::PreparedStatementSummary {
            crate::model::PreparedStatementSummary {
                statement_name: self.statement_name,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl PreparedStatementSummary {
    /// Creates a new builder-style object to manufacture [`PreparedStatementSummary`](crate::model::PreparedStatementSummary)
    pub fn builder() -> crate::model::prepared_statement_summary::Builder {
        crate::model::prepared_statement_summary::Builder::default()
    }
}

/// <p>The summary information for the data catalog, which includes its name and type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCatalogSummary {
    /// <p>The name of the data catalog.</p>
    pub catalog_name: std::option::Option<std::string::String>,
    /// <p>The data catalog type.</p>
    pub r#type: std::option::Option<crate::model::DataCatalogType>,
}
impl std::fmt::Debug for DataCatalogSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCatalogSummary");
        formatter.field("catalog_name", &self.catalog_name);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`DataCatalogSummary`](crate::model::DataCatalogSummary)
pub mod data_catalog_summary {
    /// A builder for [`DataCatalogSummary`](crate::model::DataCatalogSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataCatalogType>,
    }
    impl Builder {
        /// <p>The name of the data catalog.</p>
        pub fn catalog_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_name = input;
            self
        }
        /// <p>The data catalog type.</p>
        pub fn r#type(mut self, input: crate::model::DataCatalogType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The data catalog type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataCatalogType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCatalogSummary`](crate::model::DataCatalogSummary)
        pub fn build(self) -> crate::model::DataCatalogSummary {
            crate::model::DataCatalogSummary {
                catalog_name: self.catalog_name,
                r#type: self.r#type,
            }
        }
    }
}
impl DataCatalogSummary {
    /// Creates a new builder-style object to manufacture [`DataCatalogSummary`](crate::model::DataCatalogSummary)
    pub fn builder() -> crate::model::data_catalog_summary::Builder {
        crate::model::data_catalog_summary::Builder::default()
    }
}

/// <p>Contains metadata information for a database in a data catalog.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Database {
    /// <p>The name of the database.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the database.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A set of custom key/value pairs.</p>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Database {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Database");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`Database`](crate::model::Database)
pub mod database {
    /// A builder for [`Database`](crate::model::Database)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the database.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the database.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the database.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A set of custom key/value pairs.</p>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A set of custom key/value pairs.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`Database`](crate::model::Database)
        pub fn build(self) -> crate::model::Database {
            crate::model::Database {
                name: self.name,
                description: self.description,
                parameters: self.parameters,
            }
        }
    }
}
impl Database {
    /// Creates a new builder-style object to manufacture [`Database`](crate::model::Database)
    pub fn builder() -> crate::model::database::Builder {
        crate::model::database::Builder::default()
    }
}

/// <p>A workgroup, which contains a name, description, creation time, state, and other
/// configuration, listed under <a>WorkGroup$Configuration</a>. Each workgroup
/// enables you to isolate queries for you or your group of users from other queries in the
/// same account, to configure the query results location and the encryption configuration
/// (known as workgroup settings), to enable sending query metrics to Amazon CloudWatch,
/// and to establish per-query data usage control limits for all queries in a workgroup. The
/// workgroup settings override is specified in <code>EnforceWorkGroupConfiguration</code>
/// (true/false) in the <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkGroup {
    /// <p>The workgroup name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the workgroup: ENABLED or DISABLED.</p>
    pub state: std::option::Option<crate::model::WorkGroupState>,
    /// <p>The configuration of the workgroup, which includes the location in Amazon S3
    /// where query results are stored, the encryption configuration, if any, used for query
    /// results; whether the Amazon CloudWatch Metrics are enabled for the workgroup;
    /// whether workgroup settings override client-side settings; and the data usage limits for
    /// the amount of data scanned per query or per workgroup. The workgroup settings override
    /// is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the
    /// <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
    pub configuration: std::option::Option<crate::model::WorkGroupConfiguration>,
    /// <p>The workgroup description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date and time the workgroup was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for WorkGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkGroup");
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`WorkGroup`](crate::model::WorkGroup)
pub mod work_group {
    /// A builder for [`WorkGroup`](crate::model::WorkGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::WorkGroupState>,
        pub(crate) configuration: std::option::Option<crate::model::WorkGroupConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The workgroup name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The workgroup name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the workgroup: ENABLED or DISABLED.</p>
        pub fn state(mut self, input: crate::model::WorkGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the workgroup: ENABLED or DISABLED.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::WorkGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The configuration of the workgroup, which includes the location in Amazon S3
        /// where query results are stored, the encryption configuration, if any, used for query
        /// results; whether the Amazon CloudWatch Metrics are enabled for the workgroup;
        /// whether workgroup settings override client-side settings; and the data usage limits for
        /// the amount of data scanned per query or per workgroup. The workgroup settings override
        /// is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the
        /// <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn configuration(mut self, input: crate::model::WorkGroupConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration of the workgroup, which includes the location in Amazon S3
        /// where query results are stored, the encryption configuration, if any, used for query
        /// results; whether the Amazon CloudWatch Metrics are enabled for the workgroup;
        /// whether workgroup settings override client-side settings; and the data usage limits for
        /// the amount of data scanned per query or per workgroup. The workgroup settings override
        /// is specified in <code>EnforceWorkGroupConfiguration</code> (true/false) in the
        /// <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkGroupConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The workgroup description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The workgroup description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date and time the workgroup was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time the workgroup was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkGroup`](crate::model::WorkGroup)
        pub fn build(self) -> crate::model::WorkGroup {
            crate::model::WorkGroup {
                name: self.name,
                state: self.state,
                configuration: self.configuration,
                description: self.description,
                creation_time: self.creation_time,
            }
        }
    }
}
impl WorkGroup {
    /// Creates a new builder-style object to manufacture [`WorkGroup`](crate::model::WorkGroup)
    pub fn builder() -> crate::model::work_group::Builder {
        crate::model::work_group::Builder::default()
    }
}

/// <p>The configuration of the workgroup, which includes the location in Amazon S3
/// where query results are stored, the encryption option, if any, used for query results,
/// whether the Amazon CloudWatch Metrics are enabled for the workgroup and whether
/// workgroup settings override query settings, and the data usage limits for the amount of
/// data scanned per query or per workgroup. The workgroup settings override is specified in
/// <code>EnforceWorkGroupConfiguration</code> (true/false) in the
/// <code>WorkGroupConfiguration</code>. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WorkGroupConfiguration {
    /// <p>The configuration for the workgroup, which includes the location in Amazon S3
    /// where query results are stored and the encryption option, if any, used for query
    /// results. To run the query, you must specify the query results location using one of the
    /// ways: either in the workgroup using this setting, or for individual queries
    /// (client-side), using <a>ResultConfiguration$OutputLocation</a>. If none of
    /// them is set, Athena issues an error that no output location is provided. For
    /// more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>.</p>
    pub result_configuration: std::option::Option<crate::model::ResultConfiguration>,
    /// <p>If set to "true", the settings for the workgroup override client-side settings. If set
    /// to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
    pub enforce_work_group_configuration: std::option::Option<bool>,
    /// <p>Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.</p>
    pub publish_cloud_watch_metrics_enabled: std::option::Option<bool>,
    /// <p>The upper data usage limit (cutoff) for the amount of bytes a single query in a
    /// workgroup is allowed to scan.</p>
    pub bytes_scanned_cutoff_per_query: std::option::Option<i64>,
    /// <p>If set to <code>true</code>, allows members assigned to a workgroup to reference
    /// Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>,
    /// workgroup members cannot query data from Requester Pays buckets, and queries that
    /// retrieve data from Requester Pays buckets cause an error. The default is
    /// <code>false</code>. For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester
    /// Pays Buckets</a> in the <i>Amazon Simple Storage Service Developer
    /// Guide</i>.</p>
    pub requester_pays_enabled: std::option::Option<bool>,
    /// <p>The engine version that all queries running on the workgroup use. Queries on the
    /// <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
    /// regardless of this setting.</p>
    pub engine_version: std::option::Option<crate::model::EngineVersion>,
}
impl std::fmt::Debug for WorkGroupConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WorkGroupConfiguration");
        formatter.field("result_configuration", &self.result_configuration);
        formatter.field(
            "enforce_work_group_configuration",
            &self.enforce_work_group_configuration,
        );
        formatter.field(
            "publish_cloud_watch_metrics_enabled",
            &self.publish_cloud_watch_metrics_enabled,
        );
        formatter.field(
            "bytes_scanned_cutoff_per_query",
            &self.bytes_scanned_cutoff_per_query,
        );
        formatter.field("requester_pays_enabled", &self.requester_pays_enabled);
        formatter.field("engine_version", &self.engine_version);
        formatter.finish()
    }
}
/// See [`WorkGroupConfiguration`](crate::model::WorkGroupConfiguration)
pub mod work_group_configuration {
    /// A builder for [`WorkGroupConfiguration`](crate::model::WorkGroupConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_configuration: std::option::Option<crate::model::ResultConfiguration>,
        pub(crate) enforce_work_group_configuration: std::option::Option<bool>,
        pub(crate) publish_cloud_watch_metrics_enabled: std::option::Option<bool>,
        pub(crate) bytes_scanned_cutoff_per_query: std::option::Option<i64>,
        pub(crate) requester_pays_enabled: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<crate::model::EngineVersion>,
    }
    impl Builder {
        /// <p>The configuration for the workgroup, which includes the location in Amazon S3
        /// where query results are stored and the encryption option, if any, used for query
        /// results. To run the query, you must specify the query results location using one of the
        /// ways: either in the workgroup using this setting, or for individual queries
        /// (client-side), using <a>ResultConfiguration$OutputLocation</a>. If none of
        /// them is set, Athena issues an error that no output location is provided. For
        /// more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>.</p>
        pub fn result_configuration(mut self, input: crate::model::ResultConfiguration) -> Self {
            self.result_configuration = Some(input);
            self
        }
        /// <p>The configuration for the workgroup, which includes the location in Amazon S3
        /// where query results are stored and the encryption option, if any, used for query
        /// results. To run the query, you must specify the query results location using one of the
        /// ways: either in the workgroup using this setting, or for individual queries
        /// (client-side), using <a>ResultConfiguration$OutputLocation</a>. If none of
        /// them is set, Athena issues an error that no output location is provided. For
        /// more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a>.</p>
        pub fn set_result_configuration(
            mut self,
            input: std::option::Option<crate::model::ResultConfiguration>,
        ) -> Self {
            self.result_configuration = input;
            self
        }
        /// <p>If set to "true", the settings for the workgroup override client-side settings. If set
        /// to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
        pub fn enforce_work_group_configuration(mut self, input: bool) -> Self {
            self.enforce_work_group_configuration = Some(input);
            self
        }
        /// <p>If set to "true", the settings for the workgroup override client-side settings. If set
        /// to "false", client-side settings are used. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html">Workgroup Settings Override Client-Side Settings</a>.</p>
        pub fn set_enforce_work_group_configuration(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enforce_work_group_configuration = input;
            self
        }
        /// <p>Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.</p>
        pub fn publish_cloud_watch_metrics_enabled(mut self, input: bool) -> Self {
            self.publish_cloud_watch_metrics_enabled = Some(input);
            self
        }
        /// <p>Indicates that the Amazon CloudWatch metrics are enabled for the workgroup.</p>
        pub fn set_publish_cloud_watch_metrics_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.publish_cloud_watch_metrics_enabled = input;
            self
        }
        /// <p>The upper data usage limit (cutoff) for the amount of bytes a single query in a
        /// workgroup is allowed to scan.</p>
        pub fn bytes_scanned_cutoff_per_query(mut self, input: i64) -> Self {
            self.bytes_scanned_cutoff_per_query = Some(input);
            self
        }
        /// <p>The upper data usage limit (cutoff) for the amount of bytes a single query in a
        /// workgroup is allowed to scan.</p>
        pub fn set_bytes_scanned_cutoff_per_query(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.bytes_scanned_cutoff_per_query = input;
            self
        }
        /// <p>If set to <code>true</code>, allows members assigned to a workgroup to reference
        /// Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>,
        /// workgroup members cannot query data from Requester Pays buckets, and queries that
        /// retrieve data from Requester Pays buckets cause an error. The default is
        /// <code>false</code>. For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester
        /// Pays Buckets</a> in the <i>Amazon Simple Storage Service Developer
        /// Guide</i>.</p>
        pub fn requester_pays_enabled(mut self, input: bool) -> Self {
            self.requester_pays_enabled = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, allows members assigned to a workgroup to reference
        /// Amazon S3 Requester Pays buckets in queries. If set to <code>false</code>,
        /// workgroup members cannot query data from Requester Pays buckets, and queries that
        /// retrieve data from Requester Pays buckets cause an error. The default is
        /// <code>false</code>. For more information about Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html">Requester
        /// Pays Buckets</a> in the <i>Amazon Simple Storage Service Developer
        /// Guide</i>.</p>
        pub fn set_requester_pays_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.requester_pays_enabled = input;
            self
        }
        /// <p>The engine version that all queries running on the workgroup use. Queries on the
        /// <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
        /// regardless of this setting.</p>
        pub fn engine_version(mut self, input: crate::model::EngineVersion) -> Self {
            self.engine_version = Some(input);
            self
        }
        /// <p>The engine version that all queries running on the workgroup use. Queries on the
        /// <code>AmazonAthenaPreviewFunctionality</code> workgroup run on the preview engine
        /// regardless of this setting.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<crate::model::EngineVersion>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`WorkGroupConfiguration`](crate::model::WorkGroupConfiguration)
        pub fn build(self) -> crate::model::WorkGroupConfiguration {
            crate::model::WorkGroupConfiguration {
                result_configuration: self.result_configuration,
                enforce_work_group_configuration: self.enforce_work_group_configuration,
                publish_cloud_watch_metrics_enabled: self.publish_cloud_watch_metrics_enabled,
                bytes_scanned_cutoff_per_query: self.bytes_scanned_cutoff_per_query,
                requester_pays_enabled: self.requester_pays_enabled,
                engine_version: self.engine_version,
            }
        }
    }
}
impl WorkGroupConfiguration {
    /// Creates a new builder-style object to manufacture [`WorkGroupConfiguration`](crate::model::WorkGroupConfiguration)
    pub fn builder() -> crate::model::work_group_configuration::Builder {
        crate::model::work_group_configuration::Builder::default()
    }
}

/// <p>The metadata and rows that comprise a query result set. The metadata describes the
/// column structure and data types. To return a <code>ResultSet</code> object, use <a>GetQueryResults</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultSet {
    /// <p>The rows in the table.</p>
    pub rows: std::option::Option<std::vec::Vec<crate::model::Row>>,
    /// <p>The metadata that describes the column structure and data types of a table of query
    /// results.</p>
    pub result_set_metadata: std::option::Option<crate::model::ResultSetMetadata>,
}
impl std::fmt::Debug for ResultSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultSet");
        formatter.field("rows", &self.rows);
        formatter.field("result_set_metadata", &self.result_set_metadata);
        formatter.finish()
    }
}
/// See [`ResultSet`](crate::model::ResultSet)
pub mod result_set {
    /// A builder for [`ResultSet`](crate::model::ResultSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rows: std::option::Option<std::vec::Vec<crate::model::Row>>,
        pub(crate) result_set_metadata: std::option::Option<crate::model::ResultSetMetadata>,
    }
    impl Builder {
        /// Appends an item to `rows`.
        ///
        /// To override the contents of this collection use [`set_rows`](Self::set_rows).
        ///
        /// <p>The rows in the table.</p>
        pub fn rows(mut self, input: impl Into<crate::model::Row>) -> Self {
            let mut v = self.rows.unwrap_or_default();
            v.push(input.into());
            self.rows = Some(v);
            self
        }
        /// <p>The rows in the table.</p>
        pub fn set_rows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Row>>,
        ) -> Self {
            self.rows = input;
            self
        }
        /// <p>The metadata that describes the column structure and data types of a table of query
        /// results.</p>
        pub fn result_set_metadata(mut self, input: crate::model::ResultSetMetadata) -> Self {
            self.result_set_metadata = Some(input);
            self
        }
        /// <p>The metadata that describes the column structure and data types of a table of query
        /// results.</p>
        pub fn set_result_set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResultSetMetadata>,
        ) -> Self {
            self.result_set_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultSet`](crate::model::ResultSet)
        pub fn build(self) -> crate::model::ResultSet {
            crate::model::ResultSet {
                rows: self.rows,
                result_set_metadata: self.result_set_metadata,
            }
        }
    }
}
impl ResultSet {
    /// Creates a new builder-style object to manufacture [`ResultSet`](crate::model::ResultSet)
    pub fn builder() -> crate::model::result_set::Builder {
        crate::model::result_set::Builder::default()
    }
}

/// <p>The metadata that describes the column structure and data types of a table of query
/// results. To return a <code>ResultSetMetadata</code> object, use <a>GetQueryResults</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultSetMetadata {
    /// <p>Information about the columns returned in a query result metadata.</p>
    pub column_info: std::option::Option<std::vec::Vec<crate::model::ColumnInfo>>,
}
impl std::fmt::Debug for ResultSetMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultSetMetadata");
        formatter.field("column_info", &self.column_info);
        formatter.finish()
    }
}
/// See [`ResultSetMetadata`](crate::model::ResultSetMetadata)
pub mod result_set_metadata {
    /// A builder for [`ResultSetMetadata`](crate::model::ResultSetMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_info: std::option::Option<std::vec::Vec<crate::model::ColumnInfo>>,
    }
    impl Builder {
        /// Appends an item to `column_info`.
        ///
        /// To override the contents of this collection use [`set_column_info`](Self::set_column_info).
        ///
        /// <p>Information about the columns returned in a query result metadata.</p>
        pub fn column_info(mut self, input: impl Into<crate::model::ColumnInfo>) -> Self {
            let mut v = self.column_info.unwrap_or_default();
            v.push(input.into());
            self.column_info = Some(v);
            self
        }
        /// <p>Information about the columns returned in a query result metadata.</p>
        pub fn set_column_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnInfo>>,
        ) -> Self {
            self.column_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultSetMetadata`](crate::model::ResultSetMetadata)
        pub fn build(self) -> crate::model::ResultSetMetadata {
            crate::model::ResultSetMetadata {
                column_info: self.column_info,
            }
        }
    }
}
impl ResultSetMetadata {
    /// Creates a new builder-style object to manufacture [`ResultSetMetadata`](crate::model::ResultSetMetadata)
    pub fn builder() -> crate::model::result_set_metadata::Builder {
        crate::model::result_set_metadata::Builder::default()
    }
}

/// <p>Information about the columns in a query execution result.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnInfo {
    /// <p>The catalog to which the query results belong.</p>
    pub catalog_name: std::option::Option<std::string::String>,
    /// <p>The schema name (database name) to which the query results belong.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The table name for the query results.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The name of the column.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A column label.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The data type of the column.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38.
    /// For performance reasons, we recommend up to 18 digits.</p>
    pub precision: i32,
    /// <p>For <code>DECIMAL</code> data types, specifies the total number of digits in the
    /// fractional part of the value. Defaults to 0.</p>
    pub scale: i32,
    /// <p>Indicates the column's nullable status.</p>
    pub nullable: std::option::Option<crate::model::ColumnNullable>,
    /// <p>Indicates whether values in the column are case-sensitive.</p>
    pub case_sensitive: bool,
}
impl std::fmt::Debug for ColumnInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnInfo");
        formatter.field("catalog_name", &self.catalog_name);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("name", &self.name);
        formatter.field("label", &self.label);
        formatter.field("r#type", &self.r#type);
        formatter.field("precision", &self.precision);
        formatter.field("scale", &self.scale);
        formatter.field("nullable", &self.nullable);
        formatter.field("case_sensitive", &self.case_sensitive);
        formatter.finish()
    }
}
/// See [`ColumnInfo`](crate::model::ColumnInfo)
pub mod column_info {
    /// A builder for [`ColumnInfo`](crate::model::ColumnInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog_name: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) precision: std::option::Option<i32>,
        pub(crate) scale: std::option::Option<i32>,
        pub(crate) nullable: std::option::Option<crate::model::ColumnNullable>,
        pub(crate) case_sensitive: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The catalog to which the query results belong.</p>
        pub fn catalog_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog_name = Some(input.into());
            self
        }
        /// <p>The catalog to which the query results belong.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog_name = input;
            self
        }
        /// <p>The schema name (database name) to which the query results belong.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The schema name (database name) to which the query results belong.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The table name for the query results.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The table name for the query results.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The name of the column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A column label.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>A column label.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>The data type of the column.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The data type of the column.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38.
        /// For performance reasons, we recommend up to 18 digits.</p>
        pub fn precision(mut self, input: i32) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38.
        /// For performance reasons, we recommend up to 18 digits.</p>
        pub fn set_precision(mut self, input: std::option::Option<i32>) -> Self {
            self.precision = input;
            self
        }
        /// <p>For <code>DECIMAL</code> data types, specifies the total number of digits in the
        /// fractional part of the value. Defaults to 0.</p>
        pub fn scale(mut self, input: i32) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>For <code>DECIMAL</code> data types, specifies the total number of digits in the
        /// fractional part of the value. Defaults to 0.</p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.scale = input;
            self
        }
        /// <p>Indicates the column's nullable status.</p>
        pub fn nullable(mut self, input: crate::model::ColumnNullable) -> Self {
            self.nullable = Some(input);
            self
        }
        /// <p>Indicates the column's nullable status.</p>
        pub fn set_nullable(
            mut self,
            input: std::option::Option<crate::model::ColumnNullable>,
        ) -> Self {
            self.nullable = input;
            self
        }
        /// <p>Indicates whether values in the column are case-sensitive.</p>
        pub fn case_sensitive(mut self, input: bool) -> Self {
            self.case_sensitive = Some(input);
            self
        }
        /// <p>Indicates whether values in the column are case-sensitive.</p>
        pub fn set_case_sensitive(mut self, input: std::option::Option<bool>) -> Self {
            self.case_sensitive = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnInfo`](crate::model::ColumnInfo)
        pub fn build(self) -> crate::model::ColumnInfo {
            crate::model::ColumnInfo {
                catalog_name: self.catalog_name,
                schema_name: self.schema_name,
                table_name: self.table_name,
                name: self.name,
                label: self.label,
                r#type: self.r#type,
                precision: self.precision.unwrap_or_default(),
                scale: self.scale.unwrap_or_default(),
                nullable: self.nullable,
                case_sensitive: self.case_sensitive.unwrap_or_default(),
            }
        }
    }
}
impl ColumnInfo {
    /// Creates a new builder-style object to manufacture [`ColumnInfo`](crate::model::ColumnInfo)
    pub fn builder() -> crate::model::column_info::Builder {
        crate::model::column_info::Builder::default()
    }
}

/// _Note: `ColumnNullable::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ColumnNullable {
    #[allow(missing_docs)] // documentation missing in model
    NotNull,
    #[allow(missing_docs)] // documentation missing in model
    Nullable,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ColumnNullable {
    fn from(s: &str) -> Self {
        match s {
            "NOT_NULL" => ColumnNullable::NotNull,
            "NULLABLE" => ColumnNullable::Nullable,
            "UNKNOWN" => ColumnNullable::UnknownValue,
            other => ColumnNullable::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ColumnNullable {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ColumnNullable::from(s))
    }
}
impl ColumnNullable {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ColumnNullable::NotNull => "NOT_NULL",
            ColumnNullable::Nullable => "NULLABLE",
            ColumnNullable::UnknownValue => "UNKNOWN",
            ColumnNullable::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_NULL", "NULLABLE", "UNKNOWN"]
    }
}
impl AsRef<str> for ColumnNullable {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The rows that comprise a query result table.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Row {
    /// <p>The data that populates a row in a query result table.</p>
    pub data: std::option::Option<std::vec::Vec<crate::model::Datum>>,
}
impl std::fmt::Debug for Row {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Row");
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`Row`](crate::model::Row)
pub mod row {
    /// A builder for [`Row`](crate::model::Row)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data: std::option::Option<std::vec::Vec<crate::model::Datum>>,
    }
    impl Builder {
        /// Appends an item to `data`.
        ///
        /// To override the contents of this collection use [`set_data`](Self::set_data).
        ///
        /// <p>The data that populates a row in a query result table.</p>
        pub fn data(mut self, input: impl Into<crate::model::Datum>) -> Self {
            let mut v = self.data.unwrap_or_default();
            v.push(input.into());
            self.data = Some(v);
            self
        }
        /// <p>The data that populates a row in a query result table.</p>
        pub fn set_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Datum>>,
        ) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`Row`](crate::model::Row)
        pub fn build(self) -> crate::model::Row {
            crate::model::Row { data: self.data }
        }
    }
}
impl Row {
    /// Creates a new builder-style object to manufacture [`Row`](crate::model::Row)
    pub fn builder() -> crate::model::row::Builder {
        crate::model::row::Builder::default()
    }
}

/// <p>A piece of data (a field in the table).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Datum {
    /// <p>The value of the datum.</p>
    pub var_char_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Datum {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Datum");
        formatter.field("var_char_value", &self.var_char_value);
        formatter.finish()
    }
}
/// See [`Datum`](crate::model::Datum)
pub mod datum {
    /// A builder for [`Datum`](crate::model::Datum)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) var_char_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of the datum.</p>
        pub fn var_char_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.var_char_value = Some(input.into());
            self
        }
        /// <p>The value of the datum.</p>
        pub fn set_var_char_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.var_char_value = input;
            self
        }
        /// Consumes the builder and constructs a [`Datum`](crate::model::Datum)
        pub fn build(self) -> crate::model::Datum {
            crate::model::Datum {
                var_char_value: self.var_char_value,
            }
        }
    }
}
impl Datum {
    /// Creates a new builder-style object to manufacture [`Datum`](crate::model::Datum)
    pub fn builder() -> crate::model::datum::Builder {
        crate::model::datum::Builder::default()
    }
}

/// <p>Information about a single instance of a query execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryExecution {
    /// <p>The unique identifier for each query execution.</p>
    pub query_execution_id: std::option::Option<std::string::String>,
    /// <p>The SQL query statements which the query execution ran.</p>
    pub query: std::option::Option<std::string::String>,
    /// <p>The type of query statement that was run. <code>DDL</code> indicates DDL query
    /// statements. <code>DML</code> indicates DML (Data Manipulation Language) query
    /// statements, such as <code>CREATE TABLE AS SELECT</code>. <code>UTILITY</code> indicates
    /// query statements other than DDL and DML, such as <code>SHOW CREATE TABLE</code>, or
    /// <code>DESCRIBE TABLE</code>.</p>
    pub statement_type: std::option::Option<crate::model::StatementType>,
    /// <p>The location in Amazon S3 where query results were stored and the encryption
    /// option, if any, used for query results. These are known as "client-side settings". If
    /// workgroup settings override client-side settings, then the query uses the location for
    /// the query results and the encryption configuration that are specified for the
    /// workgroup.</p>
    pub result_configuration: std::option::Option<crate::model::ResultConfiguration>,
    /// <p>The database in which the query execution occurred.</p>
    pub query_execution_context: std::option::Option<crate::model::QueryExecutionContext>,
    /// <p>The completion date, current state, submission time, and state change reason (if
    /// applicable) for the query execution.</p>
    pub status: std::option::Option<crate::model::QueryExecutionStatus>,
    /// <p>Query execution statistics, such as the amount of data scanned, the amount of time
    /// that the query took to process, and the type of statement that was run.</p>
    pub statistics: std::option::Option<crate::model::QueryExecutionStatistics>,
    /// <p>The name of the workgroup in which the query ran.</p>
    pub work_group: std::option::Option<std::string::String>,
    /// <p>The engine version that executed the query.</p>
    pub engine_version: std::option::Option<crate::model::EngineVersion>,
}
impl std::fmt::Debug for QueryExecution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryExecution");
        formatter.field("query_execution_id", &self.query_execution_id);
        formatter.field("query", &self.query);
        formatter.field("statement_type", &self.statement_type);
        formatter.field("result_configuration", &self.result_configuration);
        formatter.field("query_execution_context", &self.query_execution_context);
        formatter.field("status", &self.status);
        formatter.field("statistics", &self.statistics);
        formatter.field("work_group", &self.work_group);
        formatter.field("engine_version", &self.engine_version);
        formatter.finish()
    }
}
/// See [`QueryExecution`](crate::model::QueryExecution)
pub mod query_execution {
    /// A builder for [`QueryExecution`](crate::model::QueryExecution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_execution_id: std::option::Option<std::string::String>,
        pub(crate) query: std::option::Option<std::string::String>,
        pub(crate) statement_type: std::option::Option<crate::model::StatementType>,
        pub(crate) result_configuration: std::option::Option<crate::model::ResultConfiguration>,
        pub(crate) query_execution_context:
            std::option::Option<crate::model::QueryExecutionContext>,
        pub(crate) status: std::option::Option<crate::model::QueryExecutionStatus>,
        pub(crate) statistics: std::option::Option<crate::model::QueryExecutionStatistics>,
        pub(crate) work_group: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<crate::model::EngineVersion>,
    }
    impl Builder {
        /// <p>The unique identifier for each query execution.</p>
        pub fn query_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_execution_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for each query execution.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_execution_id = input;
            self
        }
        /// <p>The SQL query statements which the query execution ran.</p>
        pub fn query(mut self, input: impl Into<std::string::String>) -> Self {
            self.query = Some(input.into());
            self
        }
        /// <p>The SQL query statements which the query execution ran.</p>
        pub fn set_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query = input;
            self
        }
        /// <p>The type of query statement that was run. <code>DDL</code> indicates DDL query
        /// statements. <code>DML</code> indicates DML (Data Manipulation Language) query
        /// statements, such as <code>CREATE TABLE AS SELECT</code>. <code>UTILITY</code> indicates
        /// query statements other than DDL and DML, such as <code>SHOW CREATE TABLE</code>, or
        /// <code>DESCRIBE TABLE</code>.</p>
        pub fn statement_type(mut self, input: crate::model::StatementType) -> Self {
            self.statement_type = Some(input);
            self
        }
        /// <p>The type of query statement that was run. <code>DDL</code> indicates DDL query
        /// statements. <code>DML</code> indicates DML (Data Manipulation Language) query
        /// statements, such as <code>CREATE TABLE AS SELECT</code>. <code>UTILITY</code> indicates
        /// query statements other than DDL and DML, such as <code>SHOW CREATE TABLE</code>, or
        /// <code>DESCRIBE TABLE</code>.</p>
        pub fn set_statement_type(
            mut self,
            input: std::option::Option<crate::model::StatementType>,
        ) -> Self {
            self.statement_type = input;
            self
        }
        /// <p>The location in Amazon S3 where query results were stored and the encryption
        /// option, if any, used for query results. These are known as "client-side settings". If
        /// workgroup settings override client-side settings, then the query uses the location for
        /// the query results and the encryption configuration that are specified for the
        /// workgroup.</p>
        pub fn result_configuration(mut self, input: crate::model::ResultConfiguration) -> Self {
            self.result_configuration = Some(input);
            self
        }
        /// <p>The location in Amazon S3 where query results were stored and the encryption
        /// option, if any, used for query results. These are known as "client-side settings". If
        /// workgroup settings override client-side settings, then the query uses the location for
        /// the query results and the encryption configuration that are specified for the
        /// workgroup.</p>
        pub fn set_result_configuration(
            mut self,
            input: std::option::Option<crate::model::ResultConfiguration>,
        ) -> Self {
            self.result_configuration = input;
            self
        }
        /// <p>The database in which the query execution occurred.</p>
        pub fn query_execution_context(
            mut self,
            input: crate::model::QueryExecutionContext,
        ) -> Self {
            self.query_execution_context = Some(input);
            self
        }
        /// <p>The database in which the query execution occurred.</p>
        pub fn set_query_execution_context(
            mut self,
            input: std::option::Option<crate::model::QueryExecutionContext>,
        ) -> Self {
            self.query_execution_context = input;
            self
        }
        /// <p>The completion date, current state, submission time, and state change reason (if
        /// applicable) for the query execution.</p>
        pub fn status(mut self, input: crate::model::QueryExecutionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The completion date, current state, submission time, and state change reason (if
        /// applicable) for the query execution.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::QueryExecutionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Query execution statistics, such as the amount of data scanned, the amount of time
        /// that the query took to process, and the type of statement that was run.</p>
        pub fn statistics(mut self, input: crate::model::QueryExecutionStatistics) -> Self {
            self.statistics = Some(input);
            self
        }
        /// <p>Query execution statistics, such as the amount of data scanned, the amount of time
        /// that the query took to process, and the type of statement that was run.</p>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<crate::model::QueryExecutionStatistics>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// <p>The name of the workgroup in which the query ran.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup in which the query ran.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// <p>The engine version that executed the query.</p>
        pub fn engine_version(mut self, input: crate::model::EngineVersion) -> Self {
            self.engine_version = Some(input);
            self
        }
        /// <p>The engine version that executed the query.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<crate::model::EngineVersion>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryExecution`](crate::model::QueryExecution)
        pub fn build(self) -> crate::model::QueryExecution {
            crate::model::QueryExecution {
                query_execution_id: self.query_execution_id,
                query: self.query,
                statement_type: self.statement_type,
                result_configuration: self.result_configuration,
                query_execution_context: self.query_execution_context,
                status: self.status,
                statistics: self.statistics,
                work_group: self.work_group,
                engine_version: self.engine_version,
            }
        }
    }
}
impl QueryExecution {
    /// Creates a new builder-style object to manufacture [`QueryExecution`](crate::model::QueryExecution)
    pub fn builder() -> crate::model::query_execution::Builder {
        crate::model::query_execution::Builder::default()
    }
}

/// <p>The amount of data scanned during the query execution and the amount of time that it
/// took to execute, and the type of statement that was run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryExecutionStatistics {
    /// <p>The number of milliseconds that the query took to execute.</p>
    pub engine_execution_time_in_millis: std::option::Option<i64>,
    /// <p>The number of bytes in the data that was queried.</p>
    pub data_scanned_in_bytes: std::option::Option<i64>,
    /// <p>The location and file name of a data manifest file. The manifest file is saved to the
    /// Athena query results location in Amazon S3. The manifest file
    /// tracks files that the query wrote to Amazon S3. If the query fails, the manifest
    /// file also tracks files that the query intended to write. The manifest is useful for
    /// identifying orphaned files resulting from a failed query. For more information, see
    /// <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query
    /// Results, Output Files, and Query History</a> in the <i>Amazon Athena User Guide</i>.</p>
    pub data_manifest_location: std::option::Option<std::string::String>,
    /// <p>The number of milliseconds that Athena took to run the query.</p>
    pub total_execution_time_in_millis: std::option::Option<i64>,
    /// <p>The number of milliseconds that the query was in your query queue waiting for
    /// resources. Note that if transient errors occur, Athena might automatically
    /// add the query back to the queue.</p>
    pub query_queue_time_in_millis: std::option::Option<i64>,
    /// <p>The number of milliseconds that Athena took to plan the query processing
    /// flow. This includes the time spent retrieving table partitions from the data source.
    /// Note that because the query engine performs the query planning, query planning time is a
    /// subset of engine processing time.</p>
    pub query_planning_time_in_millis: std::option::Option<i64>,
    /// <p>The number of milliseconds that Athena took to finalize and publish the
    /// query results after the query engine finished running the query.</p>
    pub service_processing_time_in_millis: std::option::Option<i64>,
}
impl std::fmt::Debug for QueryExecutionStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryExecutionStatistics");
        formatter.field(
            "engine_execution_time_in_millis",
            &self.engine_execution_time_in_millis,
        );
        formatter.field("data_scanned_in_bytes", &self.data_scanned_in_bytes);
        formatter.field("data_manifest_location", &self.data_manifest_location);
        formatter.field(
            "total_execution_time_in_millis",
            &self.total_execution_time_in_millis,
        );
        formatter.field(
            "query_queue_time_in_millis",
            &self.query_queue_time_in_millis,
        );
        formatter.field(
            "query_planning_time_in_millis",
            &self.query_planning_time_in_millis,
        );
        formatter.field(
            "service_processing_time_in_millis",
            &self.service_processing_time_in_millis,
        );
        formatter.finish()
    }
}
/// See [`QueryExecutionStatistics`](crate::model::QueryExecutionStatistics)
pub mod query_execution_statistics {
    /// A builder for [`QueryExecutionStatistics`](crate::model::QueryExecutionStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_execution_time_in_millis: std::option::Option<i64>,
        pub(crate) data_scanned_in_bytes: std::option::Option<i64>,
        pub(crate) data_manifest_location: std::option::Option<std::string::String>,
        pub(crate) total_execution_time_in_millis: std::option::Option<i64>,
        pub(crate) query_queue_time_in_millis: std::option::Option<i64>,
        pub(crate) query_planning_time_in_millis: std::option::Option<i64>,
        pub(crate) service_processing_time_in_millis: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of milliseconds that the query took to execute.</p>
        pub fn engine_execution_time_in_millis(mut self, input: i64) -> Self {
            self.engine_execution_time_in_millis = Some(input);
            self
        }
        /// <p>The number of milliseconds that the query took to execute.</p>
        pub fn set_engine_execution_time_in_millis(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.engine_execution_time_in_millis = input;
            self
        }
        /// <p>The number of bytes in the data that was queried.</p>
        pub fn data_scanned_in_bytes(mut self, input: i64) -> Self {
            self.data_scanned_in_bytes = Some(input);
            self
        }
        /// <p>The number of bytes in the data that was queried.</p>
        pub fn set_data_scanned_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.data_scanned_in_bytes = input;
            self
        }
        /// <p>The location and file name of a data manifest file. The manifest file is saved to the
        /// Athena query results location in Amazon S3. The manifest file
        /// tracks files that the query wrote to Amazon S3. If the query fails, the manifest
        /// file also tracks files that the query intended to write. The manifest is useful for
        /// identifying orphaned files resulting from a failed query. For more information, see
        /// <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query
        /// Results, Output Files, and Query History</a> in the <i>Amazon Athena User Guide</i>.</p>
        pub fn data_manifest_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_manifest_location = Some(input.into());
            self
        }
        /// <p>The location and file name of a data manifest file. The manifest file is saved to the
        /// Athena query results location in Amazon S3. The manifest file
        /// tracks files that the query wrote to Amazon S3. If the query fails, the manifest
        /// file also tracks files that the query intended to write. The manifest is useful for
        /// identifying orphaned files resulting from a failed query. For more information, see
        /// <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Working with Query
        /// Results, Output Files, and Query History</a> in the <i>Amazon Athena User Guide</i>.</p>
        pub fn set_data_manifest_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_manifest_location = input;
            self
        }
        /// <p>The number of milliseconds that Athena took to run the query.</p>
        pub fn total_execution_time_in_millis(mut self, input: i64) -> Self {
            self.total_execution_time_in_millis = Some(input);
            self
        }
        /// <p>The number of milliseconds that Athena took to run the query.</p>
        pub fn set_total_execution_time_in_millis(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.total_execution_time_in_millis = input;
            self
        }
        /// <p>The number of milliseconds that the query was in your query queue waiting for
        /// resources. Note that if transient errors occur, Athena might automatically
        /// add the query back to the queue.</p>
        pub fn query_queue_time_in_millis(mut self, input: i64) -> Self {
            self.query_queue_time_in_millis = Some(input);
            self
        }
        /// <p>The number of milliseconds that the query was in your query queue waiting for
        /// resources. Note that if transient errors occur, Athena might automatically
        /// add the query back to the queue.</p>
        pub fn set_query_queue_time_in_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.query_queue_time_in_millis = input;
            self
        }
        /// <p>The number of milliseconds that Athena took to plan the query processing
        /// flow. This includes the time spent retrieving table partitions from the data source.
        /// Note that because the query engine performs the query planning, query planning time is a
        /// subset of engine processing time.</p>
        pub fn query_planning_time_in_millis(mut self, input: i64) -> Self {
            self.query_planning_time_in_millis = Some(input);
            self
        }
        /// <p>The number of milliseconds that Athena took to plan the query processing
        /// flow. This includes the time spent retrieving table partitions from the data source.
        /// Note that because the query engine performs the query planning, query planning time is a
        /// subset of engine processing time.</p>
        pub fn set_query_planning_time_in_millis(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.query_planning_time_in_millis = input;
            self
        }
        /// <p>The number of milliseconds that Athena took to finalize and publish the
        /// query results after the query engine finished running the query.</p>
        pub fn service_processing_time_in_millis(mut self, input: i64) -> Self {
            self.service_processing_time_in_millis = Some(input);
            self
        }
        /// <p>The number of milliseconds that Athena took to finalize and publish the
        /// query results after the query engine finished running the query.</p>
        pub fn set_service_processing_time_in_millis(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.service_processing_time_in_millis = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryExecutionStatistics`](crate::model::QueryExecutionStatistics)
        pub fn build(self) -> crate::model::QueryExecutionStatistics {
            crate::model::QueryExecutionStatistics {
                engine_execution_time_in_millis: self.engine_execution_time_in_millis,
                data_scanned_in_bytes: self.data_scanned_in_bytes,
                data_manifest_location: self.data_manifest_location,
                total_execution_time_in_millis: self.total_execution_time_in_millis,
                query_queue_time_in_millis: self.query_queue_time_in_millis,
                query_planning_time_in_millis: self.query_planning_time_in_millis,
                service_processing_time_in_millis: self.service_processing_time_in_millis,
            }
        }
    }
}
impl QueryExecutionStatistics {
    /// Creates a new builder-style object to manufacture [`QueryExecutionStatistics`](crate::model::QueryExecutionStatistics)
    pub fn builder() -> crate::model::query_execution_statistics::Builder {
        crate::model::query_execution_statistics::Builder::default()
    }
}

/// <p>The completion date, current state, submission time, and state change reason (if
/// applicable) for the query execution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryExecutionStatus {
    /// <p>The state of query execution. <code>QUEUED</code> indicates that the query has been
    /// submitted to the service, and Athena will execute the query as soon as
    /// resources are available. <code>RUNNING</code> indicates that the query is in execution
    /// phase. <code>SUCCEEDED</code> indicates that the query completed without errors.
    /// <code>FAILED</code> indicates that the query experienced an error and did not
    /// complete processing. <code>CANCELLED</code> indicates that a user input interrupted
    /// query execution.</p>
    /// <note>
    /// <p>Athena automatically retries your queries in cases of certain
    /// transient errors. As a result, you may see the query state transition from
    /// <code>RUNNING</code> or <code>FAILED</code> to <code>QUEUED</code>. </p>
    /// </note>
    pub state: std::option::Option<crate::model::QueryExecutionState>,
    /// <p>Further detail about the status of the query.</p>
    pub state_change_reason: std::option::Option<std::string::String>,
    /// <p>The date and time that the query was submitted.</p>
    pub submission_date_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the query completed.</p>
    pub completion_date_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for QueryExecutionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryExecutionStatus");
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("submission_date_time", &self.submission_date_time);
        formatter.field("completion_date_time", &self.completion_date_time);
        formatter.finish()
    }
}
/// See [`QueryExecutionStatus`](crate::model::QueryExecutionStatus)
pub mod query_execution_status {
    /// A builder for [`QueryExecutionStatus`](crate::model::QueryExecutionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::QueryExecutionState>,
        pub(crate) state_change_reason: std::option::Option<std::string::String>,
        pub(crate) submission_date_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) completion_date_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The state of query execution. <code>QUEUED</code> indicates that the query has been
        /// submitted to the service, and Athena will execute the query as soon as
        /// resources are available. <code>RUNNING</code> indicates that the query is in execution
        /// phase. <code>SUCCEEDED</code> indicates that the query completed without errors.
        /// <code>FAILED</code> indicates that the query experienced an error and did not
        /// complete processing. <code>CANCELLED</code> indicates that a user input interrupted
        /// query execution.</p>
        /// <note>
        /// <p>Athena automatically retries your queries in cases of certain
        /// transient errors. As a result, you may see the query state transition from
        /// <code>RUNNING</code> or <code>FAILED</code> to <code>QUEUED</code>. </p>
        /// </note>
        pub fn state(mut self, input: crate::model::QueryExecutionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of query execution. <code>QUEUED</code> indicates that the query has been
        /// submitted to the service, and Athena will execute the query as soon as
        /// resources are available. <code>RUNNING</code> indicates that the query is in execution
        /// phase. <code>SUCCEEDED</code> indicates that the query completed without errors.
        /// <code>FAILED</code> indicates that the query experienced an error and did not
        /// complete processing. <code>CANCELLED</code> indicates that a user input interrupted
        /// query execution.</p>
        /// <note>
        /// <p>Athena automatically retries your queries in cases of certain
        /// transient errors. As a result, you may see the query state transition from
        /// <code>RUNNING</code> or <code>FAILED</code> to <code>QUEUED</code>. </p>
        /// </note>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::QueryExecutionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>Further detail about the status of the query.</p>
        pub fn state_change_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_change_reason = Some(input.into());
            self
        }
        /// <p>Further detail about the status of the query.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// <p>The date and time that the query was submitted.</p>
        pub fn submission_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.submission_date_time = Some(input);
            self
        }
        /// <p>The date and time that the query was submitted.</p>
        pub fn set_submission_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.submission_date_time = input;
            self
        }
        /// <p>The date and time that the query completed.</p>
        pub fn completion_date_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.completion_date_time = Some(input);
            self
        }
        /// <p>The date and time that the query completed.</p>
        pub fn set_completion_date_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.completion_date_time = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryExecutionStatus`](crate::model::QueryExecutionStatus)
        pub fn build(self) -> crate::model::QueryExecutionStatus {
            crate::model::QueryExecutionStatus {
                state: self.state,
                state_change_reason: self.state_change_reason,
                submission_date_time: self.submission_date_time,
                completion_date_time: self.completion_date_time,
            }
        }
    }
}
impl QueryExecutionStatus {
    /// Creates a new builder-style object to manufacture [`QueryExecutionStatus`](crate::model::QueryExecutionStatus)
    pub fn builder() -> crate::model::query_execution_status::Builder {
        crate::model::query_execution_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueryExecutionState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueryExecutionState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => QueryExecutionState::Cancelled,
            "FAILED" => QueryExecutionState::Failed,
            "QUEUED" => QueryExecutionState::Queued,
            "RUNNING" => QueryExecutionState::Running,
            "SUCCEEDED" => QueryExecutionState::Succeeded,
            other => QueryExecutionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueryExecutionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueryExecutionState::from(s))
    }
}
impl QueryExecutionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueryExecutionState::Cancelled => "CANCELLED",
            QueryExecutionState::Failed => "FAILED",
            QueryExecutionState::Queued => "QUEUED",
            QueryExecutionState::Running => "RUNNING",
            QueryExecutionState::Succeeded => "SUCCEEDED",
            QueryExecutionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELLED", "FAILED", "QUEUED", "RUNNING", "SUCCEEDED"]
    }
}
impl AsRef<str> for QueryExecutionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatementType {
    #[allow(missing_docs)] // documentation missing in model
    Ddl,
    #[allow(missing_docs)] // documentation missing in model
    Dml,
    #[allow(missing_docs)] // documentation missing in model
    Utility,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatementType {
    fn from(s: &str) -> Self {
        match s {
            "DDL" => StatementType::Ddl,
            "DML" => StatementType::Dml,
            "UTILITY" => StatementType::Utility,
            other => StatementType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatementType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatementType::from(s))
    }
}
impl StatementType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatementType::Ddl => "DDL",
            StatementType::Dml => "DML",
            StatementType::Utility => "UTILITY",
            StatementType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DDL", "DML", "UTILITY"]
    }
}
impl AsRef<str> for StatementType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A prepared SQL statement for use with Athena.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PreparedStatement {
    /// <p>The name of the prepared statement.</p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>The query string for the prepared statement.</p>
    pub query_statement: std::option::Option<std::string::String>,
    /// <p>The name of the workgroup to which the prepared statement belongs.</p>
    pub work_group_name: std::option::Option<std::string::String>,
    /// <p>The description of the prepared statement.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The last modified time of the prepared statement.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for PreparedStatement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PreparedStatement");
        formatter.field("statement_name", &self.statement_name);
        formatter.field("query_statement", &self.query_statement);
        formatter.field("work_group_name", &self.work_group_name);
        formatter.field("description", &self.description);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`PreparedStatement`](crate::model::PreparedStatement)
pub mod prepared_statement {
    /// A builder for [`PreparedStatement`](crate::model::PreparedStatement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) query_statement: std::option::Option<std::string::String>,
        pub(crate) work_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the prepared statement.</p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the prepared statement.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn query_statement(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_statement = Some(input.into());
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn set_query_statement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_statement = input;
            self
        }
        /// <p>The name of the workgroup to which the prepared statement belongs.</p>
        pub fn work_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group_name = Some(input.into());
            self
        }
        /// <p>The name of the workgroup to which the prepared statement belongs.</p>
        pub fn set_work_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.work_group_name = input;
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The last modified time of the prepared statement.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>The last modified time of the prepared statement.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PreparedStatement`](crate::model::PreparedStatement)
        pub fn build(self) -> crate::model::PreparedStatement {
            crate::model::PreparedStatement {
                statement_name: self.statement_name,
                query_statement: self.query_statement,
                work_group_name: self.work_group_name,
                description: self.description,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl PreparedStatement {
    /// Creates a new builder-style object to manufacture [`PreparedStatement`](crate::model::PreparedStatement)
    pub fn builder() -> crate::model::prepared_statement::Builder {
        crate::model::prepared_statement::Builder::default()
    }
}

/// <p>A query, where <code>QueryString</code> is the list of SQL query statements that
/// comprise the query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NamedQuery {
    /// <p>The query name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The query description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The database to which the query belongs.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The SQL query statements that comprise the query.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the query.</p>
    pub named_query_id: std::option::Option<std::string::String>,
    /// <p>The name of the workgroup that contains the named query.</p>
    pub work_group: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NamedQuery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NamedQuery");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("database", &self.database);
        formatter.field("query_string", &self.query_string);
        formatter.field("named_query_id", &self.named_query_id);
        formatter.field("work_group", &self.work_group);
        formatter.finish()
    }
}
/// See [`NamedQuery`](crate::model::NamedQuery)
pub mod named_query {
    /// A builder for [`NamedQuery`](crate::model::NamedQuery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) named_query_id: std::option::Option<std::string::String>,
        pub(crate) work_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The query name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The query name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The query description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The query description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The database to which the query belongs.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The database to which the query belongs.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The SQL query statements that comprise the query.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The SQL query statements that comprise the query.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The unique identifier of the query.</p>
        pub fn named_query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.named_query_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the query.</p>
        pub fn set_named_query_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.named_query_id = input;
            self
        }
        /// <p>The name of the workgroup that contains the named query.</p>
        pub fn work_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.work_group = Some(input.into());
            self
        }
        /// <p>The name of the workgroup that contains the named query.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.work_group = input;
            self
        }
        /// Consumes the builder and constructs a [`NamedQuery`](crate::model::NamedQuery)
        pub fn build(self) -> crate::model::NamedQuery {
            crate::model::NamedQuery {
                name: self.name,
                description: self.description,
                database: self.database,
                query_string: self.query_string,
                named_query_id: self.named_query_id,
                work_group: self.work_group,
            }
        }
    }
}
impl NamedQuery {
    /// Creates a new builder-style object to manufacture [`NamedQuery`](crate::model::NamedQuery)
    pub fn builder() -> crate::model::named_query::Builder {
        crate::model::named_query::Builder::default()
    }
}

/// <p>Contains information about a data catalog in an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataCatalog {
    /// <p>The name of the data catalog. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at sign,
    /// or hyphen characters.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the data catalog.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
    /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
    /// Glue Data Catalog.</p>
    pub r#type: std::option::Option<crate::model::DataCatalogType>,
    /// <p>Specifies the Lambda function or functions to use for the data catalog.
    /// This is a mapping whose values depend on the catalog type. </p>
    /// <ul>
    /// <li>
    /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
    /// <code>metadata-function</code> parameter is required. <code>The
    /// sdk-version</code> parameter is optional and defaults to the currently
    /// supported version.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// sdk-version=<i>version_number</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
    /// of required parameters, but not both.</p>
    /// <ul>
    /// <li>
    /// <p>If you have one Lambda function that processes metadata
    /// and another for reading the actual data, use the following syntax. Both
    /// parameters are required.</p>
    /// <p>
    /// <code>metadata-function=<i>lambda_arn</i>,
    /// record-function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// <li>
    /// <p> If you have a composite Lambda function that processes
    /// both metadata and data, use the following syntax to specify your Lambda function.</p>
    /// <p>
    /// <code>function=<i>lambda_arn</i>
    /// </code>
    /// </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
    /// <code>
    /// <i>catalog_id</i>
    /// </code> is the account ID of the
    /// Amazon Web Services account to which the Glue catalog
    /// belongs.</p>
    /// <p>
    /// <code>catalog-id=<i>catalog_id</i>
    /// </code>
    /// </p>
    /// <ul>
    /// <li>
    /// <p>The <code>GLUE</code> data catalog type also applies to the default
    /// <code>AwsDataCatalog</code> that already exists in your account, of
    /// which you can have only one and cannot modify.</p>
    /// </li>
    /// <li>
    /// <p>Queries that specify a Glue Data Catalog other than the default
    /// <code>AwsDataCatalog</code> must be run on Athena engine
    /// version 2.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DataCatalog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataCatalog");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`DataCatalog`](crate::model::DataCatalog)
pub mod data_catalog {
    /// A builder for [`DataCatalog`](crate::model::DataCatalog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataCatalogType>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the data catalog. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at sign,
        /// or hyphen characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data catalog. The catalog name must be unique for the Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at sign,
        /// or hyphen characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the data catalog.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the data catalog.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
        /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
        /// Glue Data Catalog.</p>
        pub fn r#type(mut self, input: crate::model::DataCatalogType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
        /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
        /// Glue Data Catalog.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataCatalogType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Specifies the Lambda function or functions to use for the data catalog.
        /// This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
        /// <code>
        /// <i>catalog_id</i>
        /// </code> is the account ID of the
        /// Amazon Web Services account to which the Glue catalog
        /// belongs.</p>
        /// <p>
        /// <code>catalog-id=<i>catalog_id</i>
        /// </code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The <code>GLUE</code> data catalog type also applies to the default
        /// <code>AwsDataCatalog</code> that already exists in your account, of
        /// which you can have only one and cannot modify.</p>
        /// </li>
        /// <li>
        /// <p>Queries that specify a Glue Data Catalog other than the default
        /// <code>AwsDataCatalog</code> must be run on Athena engine
        /// version 2.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>Specifies the Lambda function or functions to use for the data catalog.
        /// This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
        /// <code>
        /// <i>catalog_id</i>
        /// </code> is the account ID of the
        /// Amazon Web Services account to which the Glue catalog
        /// belongs.</p>
        /// <p>
        /// <code>catalog-id=<i>catalog_id</i>
        /// </code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The <code>GLUE</code> data catalog type also applies to the default
        /// <code>AwsDataCatalog</code> that already exists in your account, of
        /// which you can have only one and cannot modify.</p>
        /// </li>
        /// <li>
        /// <p>Queries that specify a Glue Data Catalog other than the default
        /// <code>AwsDataCatalog</code> must be run on Athena engine
        /// version 2.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DataCatalog`](crate::model::DataCatalog)
        pub fn build(self) -> crate::model::DataCatalog {
            crate::model::DataCatalog {
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                parameters: self.parameters,
            }
        }
    }
}
impl DataCatalog {
    /// Creates a new builder-style object to manufacture [`DataCatalog`](crate::model::DataCatalog)
    pub fn builder() -> crate::model::data_catalog::Builder {
        crate::model::data_catalog::Builder::default()
    }
}

/// <p>Describes a query execution that failed to process.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedQueryExecutionId {
    /// <p>The unique identifier of the query execution.</p>
    pub query_execution_id: std::option::Option<std::string::String>,
    /// <p>The error code returned when the query execution failed to process, if
    /// applicable.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message returned when the query execution failed to process, if
    /// applicable.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnprocessedQueryExecutionId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedQueryExecutionId");
        formatter.field("query_execution_id", &self.query_execution_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UnprocessedQueryExecutionId`](crate::model::UnprocessedQueryExecutionId)
pub mod unprocessed_query_execution_id {
    /// A builder for [`UnprocessedQueryExecutionId`](crate::model::UnprocessedQueryExecutionId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_execution_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the query execution.</p>
        pub fn query_execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_execution_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the query execution.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_execution_id = input;
            self
        }
        /// <p>The error code returned when the query execution failed to process, if
        /// applicable.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code returned when the query execution failed to process, if
        /// applicable.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message returned when the query execution failed to process, if
        /// applicable.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message returned when the query execution failed to process, if
        /// applicable.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedQueryExecutionId`](crate::model::UnprocessedQueryExecutionId)
        pub fn build(self) -> crate::model::UnprocessedQueryExecutionId {
            crate::model::UnprocessedQueryExecutionId {
                query_execution_id: self.query_execution_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl UnprocessedQueryExecutionId {
    /// Creates a new builder-style object to manufacture [`UnprocessedQueryExecutionId`](crate::model::UnprocessedQueryExecutionId)
    pub fn builder() -> crate::model::unprocessed_query_execution_id::Builder {
        crate::model::unprocessed_query_execution_id::Builder::default()
    }
}

/// <p>Information about a named query ID that could not be processed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedNamedQueryId {
    /// <p>The unique identifier of the named query.</p>
    pub named_query_id: std::option::Option<std::string::String>,
    /// <p>The error code returned when the processing request for the named query failed, if
    /// applicable.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message returned when the processing request for the named query failed, if
    /// applicable.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnprocessedNamedQueryId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedNamedQueryId");
        formatter.field("named_query_id", &self.named_query_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UnprocessedNamedQueryId`](crate::model::UnprocessedNamedQueryId)
pub mod unprocessed_named_query_id {
    /// A builder for [`UnprocessedNamedQueryId`](crate::model::UnprocessedNamedQueryId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) named_query_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the named query.</p>
        pub fn named_query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.named_query_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the named query.</p>
        pub fn set_named_query_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.named_query_id = input;
            self
        }
        /// <p>The error code returned when the processing request for the named query failed, if
        /// applicable.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code returned when the processing request for the named query failed, if
        /// applicable.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message returned when the processing request for the named query failed, if
        /// applicable.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message returned when the processing request for the named query failed, if
        /// applicable.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedNamedQueryId`](crate::model::UnprocessedNamedQueryId)
        pub fn build(self) -> crate::model::UnprocessedNamedQueryId {
            crate::model::UnprocessedNamedQueryId {
                named_query_id: self.named_query_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl UnprocessedNamedQueryId {
    /// Creates a new builder-style object to manufacture [`UnprocessedNamedQueryId`](crate::model::UnprocessedNamedQueryId)
    pub fn builder() -> crate::model::unprocessed_named_query_id::Builder {
        crate::model::unprocessed_named_query_id::Builder::default()
    }
}
