// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchGetNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetNamedQueryError {
    /// Kind of error that occurred.
    pub kind: BatchGetNamedQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetNamedQueryErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetNamedQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetNamedQueryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchGetNamedQueryErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchGetNamedQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetNamedQueryError {
    fn code(&self) -> Option<&str> {
        BatchGetNamedQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetNamedQueryError {
    /// Creates a new `BatchGetNamedQueryError`.
    pub fn new(kind: BatchGetNamedQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetNamedQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetNamedQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetNamedQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetNamedQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchGetNamedQueryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetNamedQueryErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `BatchGetNamedQueryErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetNamedQueryErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for BatchGetNamedQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetNamedQueryErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetNamedQueryErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchGetNamedQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetQueryExecutionError {
    /// Kind of error that occurred.
    pub kind: BatchGetQueryExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetQueryExecutionErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetQueryExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetQueryExecutionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BatchGetQueryExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            BatchGetQueryExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetQueryExecutionError {
    fn code(&self) -> Option<&str> {
        BatchGetQueryExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetQueryExecutionError {
    /// Creates a new `BatchGetQueryExecutionError`.
    pub fn new(kind: BatchGetQueryExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetQueryExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetQueryExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetQueryExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetQueryExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `BatchGetQueryExecutionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetQueryExecutionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `BatchGetQueryExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetQueryExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for BatchGetQueryExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetQueryExecutionErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetQueryExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            BatchGetQueryExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataCatalogError {
    /// Kind of error that occurred.
    pub kind: CreateDataCatalogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataCatalogErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataCatalogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataCatalogErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDataCatalogErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateDataCatalogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataCatalogError {
    fn code(&self) -> Option<&str> {
        CreateDataCatalogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataCatalogError {
    /// Creates a new `CreateDataCatalogError`.
    pub fn new(kind: CreateDataCatalogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataCatalogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataCatalogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataCatalogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataCatalogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDataCatalogErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataCatalogErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateDataCatalogErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataCatalogErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateDataCatalogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataCatalogErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDataCatalogErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateDataCatalogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNamedQueryError {
    /// Kind of error that occurred.
    pub kind: CreateNamedQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNamedQueryErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNamedQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNamedQueryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateNamedQueryErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateNamedQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNamedQueryError {
    fn code(&self) -> Option<&str> {
        CreateNamedQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNamedQueryError {
    /// Creates a new `CreateNamedQueryError`.
    pub fn new(kind: CreateNamedQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNamedQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNamedQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNamedQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNamedQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateNamedQueryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamedQueryErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateNamedQueryErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNamedQueryErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateNamedQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNamedQueryErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateNamedQueryErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateNamedQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePreparedStatementError {
    /// Kind of error that occurred.
    pub kind: CreatePreparedStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePreparedStatementErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePreparedStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePreparedStatementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreatePreparedStatementErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreatePreparedStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePreparedStatementError {
    fn code(&self) -> Option<&str> {
        CreatePreparedStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePreparedStatementError {
    /// Creates a new `CreatePreparedStatementError`.
    pub fn new(kind: CreatePreparedStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePreparedStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePreparedStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePreparedStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePreparedStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreatePreparedStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePreparedStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreatePreparedStatementErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePreparedStatementErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreatePreparedStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePreparedStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            CreatePreparedStatementErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreatePreparedStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWorkGroupError {
    /// Kind of error that occurred.
    pub kind: CreateWorkGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWorkGroupErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWorkGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWorkGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateWorkGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateWorkGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWorkGroupError {
    fn code(&self) -> Option<&str> {
        CreateWorkGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWorkGroupError {
    /// Creates a new `CreateWorkGroupError`.
    pub fn new(kind: CreateWorkGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWorkGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWorkGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWorkGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWorkGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateWorkGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateWorkGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWorkGroupErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for CreateWorkGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWorkGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateWorkGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateWorkGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataCatalogError {
    /// Kind of error that occurred.
    pub kind: DeleteDataCatalogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataCatalogErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataCatalogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataCatalogErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDataCatalogErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteDataCatalogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataCatalogError {
    fn code(&self) -> Option<&str> {
        DeleteDataCatalogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataCatalogError {
    /// Creates a new `DeleteDataCatalogError`.
    pub fn new(kind: DeleteDataCatalogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataCatalogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataCatalogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataCatalogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataCatalogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDataCatalogErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataCatalogErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDataCatalogErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataCatalogErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteDataCatalogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataCatalogErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDataCatalogErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteDataCatalogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNamedQueryError {
    /// Kind of error that occurred.
    pub kind: DeleteNamedQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNamedQueryErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNamedQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNamedQueryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteNamedQueryErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteNamedQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNamedQueryError {
    fn code(&self) -> Option<&str> {
        DeleteNamedQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNamedQueryError {
    /// Creates a new `DeleteNamedQueryError`.
    pub fn new(kind: DeleteNamedQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNamedQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNamedQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNamedQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNamedQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteNamedQueryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamedQueryErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteNamedQueryErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNamedQueryErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteNamedQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNamedQueryErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteNamedQueryErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteNamedQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePreparedStatementError {
    /// Kind of error that occurred.
    pub kind: DeletePreparedStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePreparedStatementErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource, such as a workgroup, was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePreparedStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePreparedStatementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePreparedStatementErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeletePreparedStatementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePreparedStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePreparedStatementError {
    fn code(&self) -> Option<&str> {
        DeletePreparedStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePreparedStatementError {
    /// Creates a new `DeletePreparedStatementError`.
    pub fn new(kind: DeletePreparedStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePreparedStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePreparedStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePreparedStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePreparedStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeletePreparedStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePreparedStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeletePreparedStatementErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePreparedStatementErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeletePreparedStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePreparedStatementErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeletePreparedStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePreparedStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePreparedStatementErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeletePreparedStatementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePreparedStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWorkGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteWorkGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWorkGroupErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWorkGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWorkGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteWorkGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteWorkGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWorkGroupError {
    fn code(&self) -> Option<&str> {
        DeleteWorkGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWorkGroupError {
    /// Creates a new `DeleteWorkGroupError`.
    pub fn new(kind: DeleteWorkGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWorkGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWorkGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWorkGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWorkGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteWorkGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteWorkGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWorkGroupErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for DeleteWorkGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWorkGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteWorkGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteWorkGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDatabaseError {
    /// Kind of error that occurred.
    pub kind: GetDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDatabaseErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An exception that Athena received when it called a custom metastore.
    /// Occurs if the error is not caused by user input (<code>InvalidRequestException</code>)
    /// or from the Athena platform (<code>InternalServerException</code>). For
    /// example, if a user-created Lambda function is missing permissions, the
    /// Lambda
    /// <code>4XX</code> exception is returned in a <code>MetadataException</code>.</p>
    MetadataException(crate::error::MetadataException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDatabaseErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::MetadataException(_inner) => _inner.fmt(f),
            GetDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDatabaseError {
    fn code(&self) -> Option<&str> {
        GetDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDatabaseError {
    /// Creates a new `GetDatabaseError`.
    pub fn new(kind: GetDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDatabaseErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetDatabaseErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetDatabaseErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetDatabaseErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `GetDatabaseErrorKind::MetadataException`.
    pub fn is_metadata_exception(&self) -> bool {
        matches!(&self.kind, GetDatabaseErrorKind::MetadataException(_))
    }
}
impl std::error::Error for GetDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDatabaseErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDatabaseErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetDatabaseErrorKind::MetadataException(_inner) => Some(_inner),
            GetDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataCatalogError {
    /// Kind of error that occurred.
    pub kind: GetDataCatalogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataCatalogErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataCatalogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataCatalogErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDataCatalogErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetDataCatalogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataCatalogError {
    fn code(&self) -> Option<&str> {
        GetDataCatalogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataCatalogError {
    /// Creates a new `GetDataCatalogError`.
    pub fn new(kind: GetDataCatalogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataCatalogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataCatalogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataCatalogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataCatalogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDataCatalogErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataCatalogErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetDataCatalogErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataCatalogErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for GetDataCatalogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataCatalogErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDataCatalogErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetDataCatalogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNamedQueryError {
    /// Kind of error that occurred.
    pub kind: GetNamedQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNamedQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNamedQueryErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNamedQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNamedQueryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetNamedQueryErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetNamedQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNamedQueryError {
    fn code(&self) -> Option<&str> {
        GetNamedQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNamedQueryError {
    /// Creates a new `GetNamedQueryError`.
    pub fn new(kind: GetNamedQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNamedQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNamedQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNamedQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNamedQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetNamedQueryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNamedQueryErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetNamedQueryErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNamedQueryErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for GetNamedQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNamedQueryErrorKind::InternalServerException(_inner) => Some(_inner),
            GetNamedQueryErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetNamedQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPreparedStatementError {
    /// Kind of error that occurred.
    pub kind: GetPreparedStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPreparedStatementErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource, such as a workgroup, was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPreparedStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPreparedStatementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPreparedStatementErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetPreparedStatementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPreparedStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPreparedStatementError {
    fn code(&self) -> Option<&str> {
        GetPreparedStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPreparedStatementError {
    /// Creates a new `GetPreparedStatementError`.
    pub fn new(kind: GetPreparedStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPreparedStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPreparedStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPreparedStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPreparedStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetPreparedStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPreparedStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetPreparedStatementErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPreparedStatementErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetPreparedStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPreparedStatementErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetPreparedStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPreparedStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPreparedStatementErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetPreparedStatementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPreparedStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueryExecutionError {
    /// Kind of error that occurred.
    pub kind: GetQueryExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueryExecutionErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueryExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueryExecutionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetQueryExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetQueryExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueryExecutionError {
    fn code(&self) -> Option<&str> {
        GetQueryExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueryExecutionError {
    /// Creates a new `GetQueryExecutionError`.
    pub fn new(kind: GetQueryExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueryExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueryExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueryExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueryExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetQueryExecutionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryExecutionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetQueryExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for GetQueryExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueryExecutionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetQueryExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetQueryExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueryResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueryResultsError {
    /// Kind of error that occurred.
    pub kind: GetQueryResultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueryResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueryResultsErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueryResultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueryResultsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueryResultsError {
    fn code(&self) -> Option<&str> {
        GetQueryResultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueryResultsError {
    /// Creates a new `GetQueryResultsError`.
    pub fn new(kind: GetQueryResultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueryResultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueryResultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueryResultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueryResultsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetQueryResultsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetQueryResultsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for GetQueryResultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueryResultsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTableMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTableMetadataError {
    /// Kind of error that occurred.
    pub kind: GetTableMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTableMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTableMetadataErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An exception that Athena received when it called a custom metastore.
    /// Occurs if the error is not caused by user input (<code>InvalidRequestException</code>)
    /// or from the Athena platform (<code>InternalServerException</code>). For
    /// example, if a user-created Lambda function is missing permissions, the
    /// Lambda
    /// <code>4XX</code> exception is returned in a <code>MetadataException</code>.</p>
    MetadataException(crate::error::MetadataException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTableMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTableMetadataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetTableMetadataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetTableMetadataErrorKind::MetadataException(_inner) => _inner.fmt(f),
            GetTableMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTableMetadataError {
    fn code(&self) -> Option<&str> {
        GetTableMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTableMetadataError {
    /// Creates a new `GetTableMetadataError`.
    pub fn new(kind: GetTableMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTableMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTableMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTableMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTableMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTableMetadataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableMetadataErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetTableMetadataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTableMetadataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetTableMetadataErrorKind::MetadataException`.
    pub fn is_metadata_exception(&self) -> bool {
        matches!(&self.kind, GetTableMetadataErrorKind::MetadataException(_))
    }
}
impl std::error::Error for GetTableMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTableMetadataErrorKind::InternalServerException(_inner) => Some(_inner),
            GetTableMetadataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetTableMetadataErrorKind::MetadataException(_inner) => Some(_inner),
            GetTableMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetWorkGroupError {
    /// Kind of error that occurred.
    pub kind: GetWorkGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetWorkGroupErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetWorkGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetWorkGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetWorkGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetWorkGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetWorkGroupError {
    fn code(&self) -> Option<&str> {
        GetWorkGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetWorkGroupError {
    /// Creates a new `GetWorkGroupError`.
    pub fn new(kind: GetWorkGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetWorkGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetWorkGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetWorkGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetWorkGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetWorkGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetWorkGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetWorkGroupErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for GetWorkGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetWorkGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            GetWorkGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetWorkGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatabasesError {
    /// Kind of error that occurred.
    pub kind: ListDatabasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatabasesErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An exception that Athena received when it called a custom metastore.
    /// Occurs if the error is not caused by user input (<code>InvalidRequestException</code>)
    /// or from the Athena platform (<code>InternalServerException</code>). For
    /// example, if a user-created Lambda function is missing permissions, the
    /// Lambda
    /// <code>4XX</code> exception is returned in a <code>MetadataException</code>.</p>
    MetadataException(crate::error::MetadataException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatabasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatabasesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDatabasesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDatabasesErrorKind::MetadataException(_inner) => _inner.fmt(f),
            ListDatabasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatabasesError {
    fn code(&self) -> Option<&str> {
        ListDatabasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatabasesError {
    /// Creates a new `ListDatabasesError`.
    pub fn new(kind: ListDatabasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatabasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatabasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatabasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatabasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDatabasesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatabasesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListDatabasesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatabasesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListDatabasesErrorKind::MetadataException`.
    pub fn is_metadata_exception(&self) -> bool {
        matches!(&self.kind, ListDatabasesErrorKind::MetadataException(_))
    }
}
impl std::error::Error for ListDatabasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatabasesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDatabasesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDatabasesErrorKind::MetadataException(_inner) => Some(_inner),
            ListDatabasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataCatalogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataCatalogsError {
    /// Kind of error that occurred.
    pub kind: ListDataCatalogsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataCatalogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataCatalogsErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataCatalogsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataCatalogsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDataCatalogsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListDataCatalogsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataCatalogsError {
    fn code(&self) -> Option<&str> {
        ListDataCatalogsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataCatalogsError {
    /// Creates a new `ListDataCatalogsError`.
    pub fn new(kind: ListDataCatalogsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataCatalogsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataCatalogsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataCatalogsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataCatalogsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDataCatalogsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataCatalogsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListDataCatalogsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataCatalogsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListDataCatalogsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataCatalogsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDataCatalogsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListDataCatalogsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEngineVersionsError {
    /// Kind of error that occurred.
    pub kind: ListEngineVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEngineVersionsErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEngineVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEngineVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListEngineVersionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListEngineVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEngineVersionsError {
    fn code(&self) -> Option<&str> {
        ListEngineVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEngineVersionsError {
    /// Creates a new `ListEngineVersionsError`.
    pub fn new(kind: ListEngineVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEngineVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEngineVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEngineVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEngineVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListEngineVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEngineVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListEngineVersionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEngineVersionsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListEngineVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEngineVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListEngineVersionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListEngineVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNamedQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNamedQueriesError {
    /// Kind of error that occurred.
    pub kind: ListNamedQueriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNamedQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNamedQueriesErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNamedQueriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNamedQueriesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListNamedQueriesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListNamedQueriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNamedQueriesError {
    fn code(&self) -> Option<&str> {
        ListNamedQueriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNamedQueriesError {
    /// Creates a new `ListNamedQueriesError`.
    pub fn new(kind: ListNamedQueriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNamedQueriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNamedQueriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNamedQueriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNamedQueriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListNamedQueriesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedQueriesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListNamedQueriesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNamedQueriesErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListNamedQueriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNamedQueriesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListNamedQueriesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListNamedQueriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPreparedStatements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPreparedStatementsError {
    /// Kind of error that occurred.
    pub kind: ListPreparedStatementsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPreparedStatements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPreparedStatementsErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPreparedStatementsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPreparedStatementsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPreparedStatementsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPreparedStatementsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPreparedStatementsError {
    fn code(&self) -> Option<&str> {
        ListPreparedStatementsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPreparedStatementsError {
    /// Creates a new `ListPreparedStatementsError`.
    pub fn new(kind: ListPreparedStatementsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPreparedStatementsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPreparedStatementsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPreparedStatementsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPreparedStatementsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListPreparedStatementsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPreparedStatementsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListPreparedStatementsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPreparedStatementsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListPreparedStatementsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPreparedStatementsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPreparedStatementsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPreparedStatementsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueryExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueryExecutionsError {
    /// Kind of error that occurred.
    pub kind: ListQueryExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueryExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueryExecutionsErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueryExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueryExecutionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListQueryExecutionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListQueryExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueryExecutionsError {
    fn code(&self) -> Option<&str> {
        ListQueryExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueryExecutionsError {
    /// Creates a new `ListQueryExecutionsError`.
    pub fn new(kind: ListQueryExecutionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueryExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueryExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueryExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueryExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListQueryExecutionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueryExecutionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListQueryExecutionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueryExecutionsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListQueryExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueryExecutionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListQueryExecutionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListQueryExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTableMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTableMetadataError {
    /// Kind of error that occurred.
    pub kind: ListTableMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTableMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTableMetadataErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>An exception that Athena received when it called a custom metastore.
    /// Occurs if the error is not caused by user input (<code>InvalidRequestException</code>)
    /// or from the Athena platform (<code>InternalServerException</code>). For
    /// example, if a user-created Lambda function is missing permissions, the
    /// Lambda
    /// <code>4XX</code> exception is returned in a <code>MetadataException</code>.</p>
    MetadataException(crate::error::MetadataException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTableMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTableMetadataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTableMetadataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTableMetadataErrorKind::MetadataException(_inner) => _inner.fmt(f),
            ListTableMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTableMetadataError {
    fn code(&self) -> Option<&str> {
        ListTableMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTableMetadataError {
    /// Creates a new `ListTableMetadataError`.
    pub fn new(kind: ListTableMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTableMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTableMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTableMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTableMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTableMetadataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTableMetadataErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListTableMetadataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTableMetadataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTableMetadataErrorKind::MetadataException`.
    pub fn is_metadata_exception(&self) -> bool {
        matches!(&self.kind, ListTableMetadataErrorKind::MetadataException(_))
    }
}
impl std::error::Error for ListTableMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTableMetadataErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTableMetadataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTableMetadataErrorKind::MetadataException(_inner) => Some(_inner),
            ListTableMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource, such as a workgroup, was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListWorkGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListWorkGroupsError {
    /// Kind of error that occurred.
    pub kind: ListWorkGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListWorkGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListWorkGroupsErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListWorkGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListWorkGroupsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListWorkGroupsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListWorkGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListWorkGroupsError {
    fn code(&self) -> Option<&str> {
        ListWorkGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListWorkGroupsError {
    /// Creates a new `ListWorkGroupsError`.
    pub fn new(kind: ListWorkGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListWorkGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListWorkGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListWorkGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListWorkGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListWorkGroupsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkGroupsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListWorkGroupsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListWorkGroupsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListWorkGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListWorkGroupsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListWorkGroupsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListWorkGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartQueryExecutionError {
    /// Kind of error that occurred.
    pub kind: StartQueryExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartQueryExecutionErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>Indicates that the request was throttled.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartQueryExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartQueryExecutionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartQueryExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartQueryExecutionErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartQueryExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartQueryExecutionError {
    fn code(&self) -> Option<&str> {
        StartQueryExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartQueryExecutionError {
    /// Creates a new `StartQueryExecutionError`.
    pub fn new(kind: StartQueryExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartQueryExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartQueryExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartQueryExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartQueryExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartQueryExecutionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryExecutionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `StartQueryExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryExecutionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `StartQueryExecutionErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryExecutionErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for StartQueryExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartQueryExecutionErrorKind::InternalServerException(_inner) => Some(_inner),
            StartQueryExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartQueryExecutionErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartQueryExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopQueryExecutionError {
    /// Kind of error that occurred.
    pub kind: StopQueryExecutionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopQueryExecution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopQueryExecutionErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopQueryExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopQueryExecutionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopQueryExecutionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopQueryExecutionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopQueryExecutionError {
    fn code(&self) -> Option<&str> {
        StopQueryExecutionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopQueryExecutionError {
    /// Creates a new `StopQueryExecutionError`.
    pub fn new(kind: StopQueryExecutionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopQueryExecutionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopQueryExecutionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopQueryExecutionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopQueryExecutionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopQueryExecutionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopQueryExecutionErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `StopQueryExecutionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopQueryExecutionErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for StopQueryExecutionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopQueryExecutionErrorKind::InternalServerException(_inner) => Some(_inner),
            StopQueryExecutionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopQueryExecutionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource, such as a workgroup, was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource, such as a workgroup, was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataCatalogError {
    /// Kind of error that occurred.
    pub kind: UpdateDataCatalogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataCatalog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataCatalogErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataCatalogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataCatalogErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDataCatalogErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateDataCatalogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataCatalogError {
    fn code(&self) -> Option<&str> {
        UpdateDataCatalogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataCatalogError {
    /// Creates a new `UpdateDataCatalogError`.
    pub fn new(kind: UpdateDataCatalogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataCatalogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataCatalogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataCatalogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataCatalogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDataCatalogErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataCatalogErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDataCatalogErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataCatalogErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateDataCatalogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataCatalogErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDataCatalogErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateDataCatalogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePreparedStatementError {
    /// Kind of error that occurred.
    pub kind: UpdatePreparedStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePreparedStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePreparedStatementErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource, such as a workgroup, was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePreparedStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePreparedStatementErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePreparedStatementErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdatePreparedStatementErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdatePreparedStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePreparedStatementError {
    fn code(&self) -> Option<&str> {
        UpdatePreparedStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePreparedStatementError {
    /// Creates a new `UpdatePreparedStatementError`.
    pub fn new(kind: UpdatePreparedStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePreparedStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePreparedStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePreparedStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePreparedStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdatePreparedStatementErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePreparedStatementErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePreparedStatementErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePreparedStatementErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdatePreparedStatementErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePreparedStatementErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdatePreparedStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePreparedStatementErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePreparedStatementErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdatePreparedStatementErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePreparedStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWorkGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateWorkGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWorkGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWorkGroupErrorKind {
    /// <p>Indicates a platform issue, which may be due to a transient condition or
    /// outage.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a
    /// required parameter may be missing or out of range.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWorkGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWorkGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateWorkGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateWorkGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWorkGroupError {
    fn code(&self) -> Option<&str> {
        UpdateWorkGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWorkGroupError {
    /// Creates a new `UpdateWorkGroupError`.
    pub fn new(kind: UpdateWorkGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWorkGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWorkGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWorkGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWorkGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateWorkGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateWorkGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWorkGroupErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for UpdateWorkGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWorkGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateWorkGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateWorkGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Indicates that something is wrong with the input to the request. For example, a
/// required parameter may be missing or out of range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The error code returned when the query execution failed to process, or when the
    /// processing request for the named query failed.</p>
    pub athena_error_code: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("athena_error_code", &self.athena_error_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) athena_error_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code returned when the query execution failed to process, or when the
        /// processing request for the named query failed.</p>
        pub fn athena_error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.athena_error_code = Some(input.into());
            self
        }
        /// <p>The error code returned when the query execution failed to process, or when the
        /// processing request for the named query failed.</p>
        pub fn set_athena_error_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.athena_error_code = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                athena_error_code: self.athena_error_code,
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>Indicates a platform issue, which may be due to a transient condition or
/// outage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>A resource, such as a workgroup, was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Indicates that the request was throttled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason for the query throttling, for example, when it exceeds the concurrent query
    /// limit.</p>
    pub reason: std::option::Option<crate::model::ThrottleReason>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ThrottleReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason for the query throttling, for example, when it exceeds the concurrent query
        /// limit.</p>
        pub fn reason(mut self, input: crate::model::ThrottleReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the query throttling, for example, when it exceeds the concurrent query
        /// limit.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ThrottleReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>An exception that Athena received when it called a custom metastore.
/// Occurs if the error is not caused by user input (<code>InvalidRequestException</code>)
/// or from the Athena platform (<code>InternalServerException</code>). For
/// example, if a user-created Lambda function is missing permissions, the
/// Lambda
/// <code>4XX</code> exception is returned in a <code>MetadataException</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetadataException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MetadataException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetadataException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MetadataException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MetadataException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MetadataException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for MetadataException {}
/// See [`MetadataException`](crate::error::MetadataException)
pub mod metadata_exception {
    /// A builder for [`MetadataException`](crate::error::MetadataException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MetadataException`](crate::error::MetadataException)
        pub fn build(self) -> crate::error::MetadataException {
            crate::error::MetadataException {
                message: self.message,
            }
        }
    }
}
impl MetadataException {
    /// Creates a new builder-style object to manufacture [`MetadataException`](crate::error::MetadataException)
    pub fn builder() -> crate::error::metadata_exception::Builder {
        crate::error::metadata_exception::Builder::default()
    }
}
