// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonAthena`.
///
/// This client allows ergonomic access to a `AmazonAthena`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchGetNamedQuery` operation.
    ///
    /// See [`BatchGetNamedQuery`](crate::client::fluent_builders::BatchGetNamedQuery) for more information about the
    /// operation and its arguments.
    pub fn batch_get_named_query(&self) -> fluent_builders::BatchGetNamedQuery<C, M, R> {
        fluent_builders::BatchGetNamedQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetQueryExecution` operation.
    ///
    /// See [`BatchGetQueryExecution`](crate::client::fluent_builders::BatchGetQueryExecution) for more information about the
    /// operation and its arguments.
    pub fn batch_get_query_execution(&self) -> fluent_builders::BatchGetQueryExecution<C, M, R> {
        fluent_builders::BatchGetQueryExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataCatalog` operation.
    ///
    /// See [`CreateDataCatalog`](crate::client::fluent_builders::CreateDataCatalog) for more information about the
    /// operation and its arguments.
    pub fn create_data_catalog(&self) -> fluent_builders::CreateDataCatalog<C, M, R> {
        fluent_builders::CreateDataCatalog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNamedQuery` operation.
    ///
    /// See [`CreateNamedQuery`](crate::client::fluent_builders::CreateNamedQuery) for more information about the
    /// operation and its arguments.
    pub fn create_named_query(&self) -> fluent_builders::CreateNamedQuery<C, M, R> {
        fluent_builders::CreateNamedQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePreparedStatement` operation.
    ///
    /// See [`CreatePreparedStatement`](crate::client::fluent_builders::CreatePreparedStatement) for more information about the
    /// operation and its arguments.
    pub fn create_prepared_statement(&self) -> fluent_builders::CreatePreparedStatement<C, M, R> {
        fluent_builders::CreatePreparedStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWorkGroup` operation.
    ///
    /// See [`CreateWorkGroup`](crate::client::fluent_builders::CreateWorkGroup) for more information about the
    /// operation and its arguments.
    pub fn create_work_group(&self) -> fluent_builders::CreateWorkGroup<C, M, R> {
        fluent_builders::CreateWorkGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataCatalog` operation.
    ///
    /// See [`DeleteDataCatalog`](crate::client::fluent_builders::DeleteDataCatalog) for more information about the
    /// operation and its arguments.
    pub fn delete_data_catalog(&self) -> fluent_builders::DeleteDataCatalog<C, M, R> {
        fluent_builders::DeleteDataCatalog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNamedQuery` operation.
    ///
    /// See [`DeleteNamedQuery`](crate::client::fluent_builders::DeleteNamedQuery) for more information about the
    /// operation and its arguments.
    pub fn delete_named_query(&self) -> fluent_builders::DeleteNamedQuery<C, M, R> {
        fluent_builders::DeleteNamedQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePreparedStatement` operation.
    ///
    /// See [`DeletePreparedStatement`](crate::client::fluent_builders::DeletePreparedStatement) for more information about the
    /// operation and its arguments.
    pub fn delete_prepared_statement(&self) -> fluent_builders::DeletePreparedStatement<C, M, R> {
        fluent_builders::DeletePreparedStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWorkGroup` operation.
    ///
    /// See [`DeleteWorkGroup`](crate::client::fluent_builders::DeleteWorkGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_work_group(&self) -> fluent_builders::DeleteWorkGroup<C, M, R> {
        fluent_builders::DeleteWorkGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDatabase` operation.
    ///
    /// See [`GetDatabase`](crate::client::fluent_builders::GetDatabase) for more information about the
    /// operation and its arguments.
    pub fn get_database(&self) -> fluent_builders::GetDatabase<C, M, R> {
        fluent_builders::GetDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataCatalog` operation.
    ///
    /// See [`GetDataCatalog`](crate::client::fluent_builders::GetDataCatalog) for more information about the
    /// operation and its arguments.
    pub fn get_data_catalog(&self) -> fluent_builders::GetDataCatalog<C, M, R> {
        fluent_builders::GetDataCatalog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNamedQuery` operation.
    ///
    /// See [`GetNamedQuery`](crate::client::fluent_builders::GetNamedQuery) for more information about the
    /// operation and its arguments.
    pub fn get_named_query(&self) -> fluent_builders::GetNamedQuery<C, M, R> {
        fluent_builders::GetNamedQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPreparedStatement` operation.
    ///
    /// See [`GetPreparedStatement`](crate::client::fluent_builders::GetPreparedStatement) for more information about the
    /// operation and its arguments.
    pub fn get_prepared_statement(&self) -> fluent_builders::GetPreparedStatement<C, M, R> {
        fluent_builders::GetPreparedStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQueryExecution` operation.
    ///
    /// See [`GetQueryExecution`](crate::client::fluent_builders::GetQueryExecution) for more information about the
    /// operation and its arguments.
    pub fn get_query_execution(&self) -> fluent_builders::GetQueryExecution<C, M, R> {
        fluent_builders::GetQueryExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQueryResults` operation.
    ///
    /// See [`GetQueryResults`](crate::client::fluent_builders::GetQueryResults) for more information about the
    /// operation and its arguments.
    pub fn get_query_results(&self) -> fluent_builders::GetQueryResults<C, M, R> {
        fluent_builders::GetQueryResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTableMetadata` operation.
    ///
    /// See [`GetTableMetadata`](crate::client::fluent_builders::GetTableMetadata) for more information about the
    /// operation and its arguments.
    pub fn get_table_metadata(&self) -> fluent_builders::GetTableMetadata<C, M, R> {
        fluent_builders::GetTableMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetWorkGroup` operation.
    ///
    /// See [`GetWorkGroup`](crate::client::fluent_builders::GetWorkGroup) for more information about the
    /// operation and its arguments.
    pub fn get_work_group(&self) -> fluent_builders::GetWorkGroup<C, M, R> {
        fluent_builders::GetWorkGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatabases` operation.
    ///
    /// See [`ListDatabases`](crate::client::fluent_builders::ListDatabases) for more information about the
    /// operation and its arguments.
    pub fn list_databases(&self) -> fluent_builders::ListDatabases<C, M, R> {
        fluent_builders::ListDatabases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataCatalogs` operation.
    ///
    /// See [`ListDataCatalogs`](crate::client::fluent_builders::ListDataCatalogs) for more information about the
    /// operation and its arguments.
    pub fn list_data_catalogs(&self) -> fluent_builders::ListDataCatalogs<C, M, R> {
        fluent_builders::ListDataCatalogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEngineVersions` operation.
    ///
    /// See [`ListEngineVersions`](crate::client::fluent_builders::ListEngineVersions) for more information about the
    /// operation and its arguments.
    pub fn list_engine_versions(&self) -> fluent_builders::ListEngineVersions<C, M, R> {
        fluent_builders::ListEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNamedQueries` operation.
    ///
    /// See [`ListNamedQueries`](crate::client::fluent_builders::ListNamedQueries) for more information about the
    /// operation and its arguments.
    pub fn list_named_queries(&self) -> fluent_builders::ListNamedQueries<C, M, R> {
        fluent_builders::ListNamedQueries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPreparedStatements` operation.
    ///
    /// See [`ListPreparedStatements`](crate::client::fluent_builders::ListPreparedStatements) for more information about the
    /// operation and its arguments.
    pub fn list_prepared_statements(&self) -> fluent_builders::ListPreparedStatements<C, M, R> {
        fluent_builders::ListPreparedStatements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQueryExecutions` operation.
    ///
    /// See [`ListQueryExecutions`](crate::client::fluent_builders::ListQueryExecutions) for more information about the
    /// operation and its arguments.
    pub fn list_query_executions(&self) -> fluent_builders::ListQueryExecutions<C, M, R> {
        fluent_builders::ListQueryExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTableMetadata` operation.
    ///
    /// See [`ListTableMetadata`](crate::client::fluent_builders::ListTableMetadata) for more information about the
    /// operation and its arguments.
    pub fn list_table_metadata(&self) -> fluent_builders::ListTableMetadata<C, M, R> {
        fluent_builders::ListTableMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListWorkGroups` operation.
    ///
    /// See [`ListWorkGroups`](crate::client::fluent_builders::ListWorkGroups) for more information about the
    /// operation and its arguments.
    pub fn list_work_groups(&self) -> fluent_builders::ListWorkGroups<C, M, R> {
        fluent_builders::ListWorkGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartQueryExecution` operation.
    ///
    /// See [`StartQueryExecution`](crate::client::fluent_builders::StartQueryExecution) for more information about the
    /// operation and its arguments.
    pub fn start_query_execution(&self) -> fluent_builders::StartQueryExecution<C, M, R> {
        fluent_builders::StartQueryExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopQueryExecution` operation.
    ///
    /// See [`StopQueryExecution`](crate::client::fluent_builders::StopQueryExecution) for more information about the
    /// operation and its arguments.
    pub fn stop_query_execution(&self) -> fluent_builders::StopQueryExecution<C, M, R> {
        fluent_builders::StopQueryExecution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataCatalog` operation.
    ///
    /// See [`UpdateDataCatalog`](crate::client::fluent_builders::UpdateDataCatalog) for more information about the
    /// operation and its arguments.
    pub fn update_data_catalog(&self) -> fluent_builders::UpdateDataCatalog<C, M, R> {
        fluent_builders::UpdateDataCatalog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePreparedStatement` operation.
    ///
    /// See [`UpdatePreparedStatement`](crate::client::fluent_builders::UpdatePreparedStatement) for more information about the
    /// operation and its arguments.
    pub fn update_prepared_statement(&self) -> fluent_builders::UpdatePreparedStatement<C, M, R> {
        fluent_builders::UpdatePreparedStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWorkGroup` operation.
    ///
    /// See [`UpdateWorkGroup`](crate::client::fluent_builders::UpdateWorkGroup) for more information about the
    /// operation and its arguments.
    pub fn update_work_group(&self) -> fluent_builders::UpdateWorkGroup<C, M, R> {
        fluent_builders::UpdateWorkGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchGetNamedQuery`.
    ///
    /// <p>Returns the details of a single named query or a list of up to 50 queries, which you
    /// provide as an array of query ID strings. Requires you to have access to the workgroup in
    /// which the queries were saved. Use <a>ListNamedQueriesInput</a> to get the
    /// list of named query IDs in the specified workgroup. If information could not be
    /// retrieved for a submitted query ID, information about the query ID submitted is listed
    /// under <a>UnprocessedNamedQueryId</a>. Named queries differ from executed
    /// queries. Use <a>BatchGetQueryExecutionInput</a> to get details about each
    /// unique query execution, and <a>ListQueryExecutionsInput</a> to get a list of
    /// query execution IDs.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetNamedQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_named_query_input::Builder,
    }
    impl<C, M, R> BatchGetNamedQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetNamedQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetNamedQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetNamedQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetNamedQueryInputOperationOutputAlias,
                crate::output::BatchGetNamedQueryOutput,
                crate::error::BatchGetNamedQueryError,
                crate::input::BatchGetNamedQueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `NamedQueryIds`.
        ///
        /// To override the contents of this collection use [`set_named_query_ids`](Self::set_named_query_ids).
        ///
        /// <p>An array of query IDs.</p>
        pub fn named_query_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.named_query_ids(inp);
            self
        }
        /// <p>An array of query IDs.</p>
        pub fn set_named_query_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_named_query_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetQueryExecution`.
    ///
    /// <p>Returns the details of a single query execution or a list of up to 50 query
    /// executions, which you provide as an array of query execution ID strings. Requires you to
    /// have access to the workgroup in which the queries ran. To get a list of query execution
    /// IDs, use <a>ListQueryExecutionsInput$WorkGroup</a>. Query executions differ
    /// from named (saved) queries. Use <a>BatchGetNamedQueryInput</a> to get details
    /// about named queries.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetQueryExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_query_execution_input::Builder,
    }
    impl<C, M, R> BatchGetQueryExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetQueryExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetQueryExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetQueryExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetQueryExecutionInputOperationOutputAlias,
                crate::output::BatchGetQueryExecutionOutput,
                crate::error::BatchGetQueryExecutionError,
                crate::input::BatchGetQueryExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `QueryExecutionIds`.
        ///
        /// To override the contents of this collection use [`set_query_execution_ids`](Self::set_query_execution_ids).
        ///
        /// <p>An array of query execution IDs.</p>
        pub fn query_execution_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_execution_ids(inp);
            self
        }
        /// <p>An array of query execution IDs.</p>
        pub fn set_query_execution_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_query_execution_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataCatalog`.
    ///
    /// <p>Creates (registers) a data catalog with the specified name and properties. Catalogs
    /// created are visible to all users of the same Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataCatalog<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_catalog_input::Builder,
    }
    impl<C, M, R> CreateDataCatalog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataCatalog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataCatalogOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataCatalogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataCatalogInputOperationOutputAlias,
                crate::output::CreateDataCatalogOutput,
                crate::error::CreateDataCatalogError,
                crate::input::CreateDataCatalogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog to create. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the data catalog to create. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
        /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
        /// Glue Data Catalog.</p>
        pub fn r#type(mut self, inp: crate::model::DataCatalogType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of data catalog to create: <code>LAMBDA</code> for a federated catalog,
        /// <code>HIVE</code> for an external hive metastore, or <code>GLUE</code> for an
        /// Glue Data Catalog.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataCatalogType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>A description of the data catalog to be created.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the data catalog to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Specifies the Lambda function or functions to use for creating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
        /// <code>
        /// <i>catalog_id</i>
        /// </code> is the account ID of the
        /// Amazon Web Services account to which the Glue Data Catalog
        /// belongs.</p>
        /// <p>
        /// <code>catalog-id=<i>catalog_id</i>
        /// </code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The <code>GLUE</code> data catalog type also applies to the default
        /// <code>AwsDataCatalog</code> that already exists in your account, of
        /// which you can have only one and cannot modify.</p>
        /// </li>
        /// <li>
        /// <p>Queries that specify a Glue Data Catalog other than the default
        /// <code>AwsDataCatalog</code> must be run on Athena engine
        /// version 2.</p>
        /// </li>
        /// <li>
        /// <p>In Regions where Athena engine version 2 is not available,
        /// creating new Glue data catalogs results in an
        /// <code>INVALID_INPUT</code> error.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>Specifies the Lambda function or functions to use for creating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The <code>GLUE</code> type takes a catalog ID parameter and is required. The
        /// <code>
        /// <i>catalog_id</i>
        /// </code> is the account ID of the
        /// Amazon Web Services account to which the Glue Data Catalog
        /// belongs.</p>
        /// <p>
        /// <code>catalog-id=<i>catalog_id</i>
        /// </code>
        /// </p>
        /// <ul>
        /// <li>
        /// <p>The <code>GLUE</code> data catalog type also applies to the default
        /// <code>AwsDataCatalog</code> that already exists in your account, of
        /// which you can have only one and cannot modify.</p>
        /// </li>
        /// <li>
        /// <p>Queries that specify a Glue Data Catalog other than the default
        /// <code>AwsDataCatalog</code> must be run on Athena engine
        /// version 2.</p>
        /// </li>
        /// <li>
        /// <p>In Regions where Athena engine version 2 is not available,
        /// creating new Glue data catalogs results in an
        /// <code>INVALID_INPUT</code> error.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of comma separated tags to add to the data catalog that is created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of comma separated tags to add to the data catalog that is created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNamedQuery`.
    ///
    /// <p>Creates a named query in the specified workgroup. Requires that you have access to the
    /// workgroup.</p>
    /// <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and
    /// Code Samples</a> in the <i>Amazon Athena User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNamedQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_named_query_input::Builder,
    }
    impl<C, M, R> CreateNamedQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNamedQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNamedQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNamedQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNamedQueryInputOperationOutputAlias,
                crate::output::CreateNamedQueryOutput,
                crate::error::CreateNamedQueryError,
                crate::input::CreateNamedQueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The query name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The query name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The query description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The query description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The database to which the query belongs.</p>
        pub fn database(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(inp);
            self
        }
        /// <p>The database to which the query belongs.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The contents of the query with all query statements.</p>
        pub fn query_string(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(inp);
            self
        }
        /// <p>The contents of the query with all query statements.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>CreateNamedQuery</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>CreateNamedQuery</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The name of the workgroup in which the named query is being created.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The name of the workgroup in which the named query is being created.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePreparedStatement`.
    ///
    /// <p>Creates a prepared statement for use with SQL queries in Athena.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePreparedStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_prepared_statement_input::Builder,
    }
    impl<C, M, R> CreatePreparedStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePreparedStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePreparedStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePreparedStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePreparedStatementInputOperationOutputAlias,
                crate::output::CreatePreparedStatementOutput,
                crate::error::CreatePreparedStatementError,
                crate::input::CreatePreparedStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the prepared statement.</p>
        pub fn statement_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_name(inp);
            self
        }
        /// <p>The name of the prepared statement.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_statement_name(input);
            self
        }
        /// <p>The name of the workgroup to which the prepared statement belongs.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The name of the workgroup to which the prepared statement belongs.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn query_statement(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_statement(inp);
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn set_query_statement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_statement(input);
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWorkGroup`.
    ///
    /// <p>Creates a workgroup with the specified name.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateWorkGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_work_group_input::Builder,
    }
    impl<C, M, R> CreateWorkGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWorkGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWorkGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWorkGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWorkGroupInputOperationOutputAlias,
                crate::output::CreateWorkGroupOutput,
                crate::error::CreateWorkGroupError,
                crate::input::CreateWorkGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The workgroup name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The workgroup name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The configuration for the workgroup, which includes the location in Amazon S3
        /// where query results are stored, the encryption configuration, if any, used for
        /// encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the
        /// workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is
        /// specified, and whether workgroup's settings (specified with
        /// <code>EnforceWorkGroupConfiguration</code>) in the
        /// <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn configuration(mut self, inp: crate::model::WorkGroupConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The configuration for the workgroup, which includes the location in Amazon S3
        /// where query results are stored, the encryption configuration, if any, used for
        /// encrypting query results, whether the Amazon CloudWatch Metrics are enabled for the
        /// workgroup, the limit for the amount of bytes scanned (cutoff) per query, if it is
        /// specified, and whether workgroup's settings (specified with
        /// <code>EnforceWorkGroupConfiguration</code>) in the
        /// <code>WorkGroupConfiguration</code> override client-side settings. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::WorkGroupConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The workgroup description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The workgroup description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of comma separated tags to add to the workgroup that is created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of comma separated tags to add to the workgroup that is created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataCatalog`.
    ///
    /// <p>Deletes a data catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataCatalog<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_catalog_input::Builder,
    }
    impl<C, M, R> DeleteDataCatalog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataCatalog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataCatalogOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataCatalogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataCatalogInputOperationOutputAlias,
                crate::output::DeleteDataCatalogOutput,
                crate::error::DeleteDataCatalogError,
                crate::input::DeleteDataCatalogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog to delete.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the data catalog to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNamedQuery`.
    ///
    /// <p>Deletes the named query if you have access to the workgroup in which the query was
    /// saved.</p>
    /// <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and
    /// Code Samples</a> in the <i>Amazon Athena User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNamedQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_named_query_input::Builder,
    }
    impl<C, M, R> DeleteNamedQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNamedQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNamedQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNamedQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNamedQueryInputOperationOutputAlias,
                crate::output::DeleteNamedQueryOutput,
                crate::error::DeleteNamedQueryError,
                crate::input::DeleteNamedQueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the query to delete.</p>
        pub fn named_query_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.named_query_id(inp);
            self
        }
        /// <p>The unique ID of the query to delete.</p>
        pub fn set_named_query_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_named_query_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePreparedStatement`.
    ///
    /// <p>Deletes the prepared statement with the specified name from the specified
    /// workgroup.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePreparedStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_prepared_statement_input::Builder,
    }
    impl<C, M, R> DeletePreparedStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePreparedStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePreparedStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePreparedStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePreparedStatementInputOperationOutputAlias,
                crate::output::DeletePreparedStatementOutput,
                crate::error::DeletePreparedStatementError,
                crate::input::DeletePreparedStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the prepared statement to delete.</p>
        pub fn statement_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_name(inp);
            self
        }
        /// <p>The name of the prepared statement to delete.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_statement_name(input);
            self
        }
        /// <p>The workgroup to which the statement to be deleted belongs.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The workgroup to which the statement to be deleted belongs.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkGroup`.
    ///
    /// <p>Deletes the workgroup with the specified name. The primary workgroup cannot be
    /// deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWorkGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_work_group_input::Builder,
    }
    impl<C, M, R> DeleteWorkGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWorkGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWorkGroupInputOperationOutputAlias,
                crate::output::DeleteWorkGroupOutput,
                crate::error::DeleteWorkGroupError,
                crate::input::DeleteWorkGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the workgroup to delete.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The unique name of the workgroup to delete.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
        /// <p>The option to delete the workgroup and its contents even if the workgroup contains any
        /// named queries or query executions.</p>
        pub fn recursive_delete_option(mut self, inp: bool) -> Self {
            self.inner = self.inner.recursive_delete_option(inp);
            self
        }
        /// <p>The option to delete the workgroup and its contents even if the workgroup contains any
        /// named queries or query executions.</p>
        pub fn set_recursive_delete_option(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_recursive_delete_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDatabase`.
    ///
    /// <p>Returns a database object for the specified database and data catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_database_input::Builder,
    }
    impl<C, M, R> GetDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDatabaseInputOperationOutputAlias,
                crate::output::GetDatabaseOutput,
                crate::error::GetDatabaseError,
                crate::input::GetDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog that contains the database to return.</p>
        pub fn catalog_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_name(inp);
            self
        }
        /// <p>The name of the data catalog that contains the database to return.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_name(input);
            self
        }
        /// <p>The name of the database to return.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database to return.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataCatalog`.
    ///
    /// <p>Returns the specified data catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDataCatalog<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_data_catalog_input::Builder,
    }
    impl<C, M, R> GetDataCatalog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataCatalog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataCatalogOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataCatalogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataCatalogInputOperationOutputAlias,
                crate::output::GetDataCatalogOutput,
                crate::error::GetDataCatalogError,
                crate::input::GetDataCatalogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog to return.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the data catalog to return.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNamedQuery`.
    ///
    /// <p>Returns information about a single query. Requires that you have access to the
    /// workgroup in which the query was saved.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetNamedQuery<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_named_query_input::Builder,
    }
    impl<C, M, R> GetNamedQuery<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNamedQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNamedQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNamedQueryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNamedQueryInputOperationOutputAlias,
                crate::output::GetNamedQueryOutput,
                crate::error::GetNamedQueryError,
                crate::input::GetNamedQueryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query
        /// IDs.</p>
        pub fn named_query_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.named_query_id(inp);
            self
        }
        /// <p>The unique ID of the query. Use <a>ListNamedQueries</a> to get query
        /// IDs.</p>
        pub fn set_named_query_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_named_query_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPreparedStatement`.
    ///
    /// <p>Retrieves the prepared statement with the specified name from the specified
    /// workgroup.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPreparedStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_prepared_statement_input::Builder,
    }
    impl<C, M, R> GetPreparedStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPreparedStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPreparedStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPreparedStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPreparedStatementInputOperationOutputAlias,
                crate::output::GetPreparedStatementOutput,
                crate::error::GetPreparedStatementError,
                crate::input::GetPreparedStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the prepared statement to retrieve.</p>
        pub fn statement_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_name(inp);
            self
        }
        /// <p>The name of the prepared statement to retrieve.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_statement_name(input);
            self
        }
        /// <p>The workgroup to which the statement to be retrieved belongs.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The workgroup to which the statement to be retrieved belongs.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueryExecution`.
    ///
    /// <p>Returns information about a single execution of a query if you have access to the
    /// workgroup in which the query ran. Each time a query executes, information about the
    /// query execution is saved with a unique ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetQueryExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_query_execution_input::Builder,
    }
    impl<C, M, R> GetQueryExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueryExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueryExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueryExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueryExecutionInputOperationOutputAlias,
                crate::output::GetQueryExecutionOutput,
                crate::error::GetQueryExecutionError,
                crate::input::GetQueryExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the query execution.</p>
        pub fn query_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_execution_id(inp);
            self
        }
        /// <p>The unique ID of the query execution.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueryResults`.
    ///
    /// <p>Streams the results of a single query execution specified by
    /// <code>QueryExecutionId</code> from the Athena query results location in
    /// Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/athena/latest/ug/querying.html">Query Results</a> in the <i>Amazon Athena User Guide</i>. This request does not execute the query
    /// but returns results. Use <a>StartQueryExecution</a> to run a query.</p>
    /// <p>To stream query results successfully, the IAM principal with permission to call
    /// <code>GetQueryResults</code> also must have permissions to the Amazon S3
    /// <code>GetObject</code> action for the Athena query results location.</p>
    /// <important>
    /// <p>IAM principals with permission to the Amazon S3
    /// <code>GetObject</code> action for the query results location are able to retrieve
    /// query results from Amazon S3 even if permission to the
    /// <code>GetQueryResults</code> action is denied. To restrict user or role access,
    /// ensure that Amazon S3 permissions to the Athena query location
    /// are denied.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct GetQueryResults<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_query_results_input::Builder,
    }
    impl<C, M, R> GetQueryResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueryResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueryResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueryResultsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueryResultsInputOperationOutputAlias,
                crate::output::GetQueryResultsOutput,
                crate::error::GetQueryResultsError,
                crate::input::GetQueryResultsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the query execution.</p>
        pub fn query_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_execution_id(inp);
            self
        }
        /// <p>The unique ID of the query execution.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_execution_id(input);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results (rows) to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results (rows) to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTableMetadata`.
    ///
    /// <p>Returns table metadata for the specified catalog, database, and table.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTableMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_table_metadata_input::Builder,
    }
    impl<C, M, R> GetTableMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTableMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTableMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTableMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTableMetadataInputOperationOutputAlias,
                crate::output::GetTableMetadataOutput,
                crate::error::GetTableMetadataError,
                crate::input::GetTableMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog that contains the database and table metadata to
        /// return.</p>
        pub fn catalog_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_name(inp);
            self
        }
        /// <p>The name of the data catalog that contains the database and table metadata to
        /// return.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_name(input);
            self
        }
        /// <p>The name of the database that contains the table metadata to return.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database that contains the table metadata to return.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the table for which metadata is returned.</p>
        pub fn table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_name(inp);
            self
        }
        /// <p>The name of the table for which metadata is returned.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_table_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkGroup`.
    ///
    /// <p>Returns information about the workgroup with the specified name.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetWorkGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_work_group_input::Builder,
    }
    impl<C, M, R> GetWorkGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetWorkGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetWorkGroupInputOperationOutputAlias,
                crate::output::GetWorkGroupOutput,
                crate::error::GetWorkGroupError,
                crate::input::GetWorkGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the workgroup.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The name of the workgroup.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatabases`.
    ///
    /// <p>Lists the databases in the specified data catalog.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatabases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_databases_input::Builder,
    }
    impl<C, M, R> ListDatabases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatabases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatabasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatabasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatabasesInputOperationOutputAlias,
                crate::output::ListDatabasesOutput,
                crate::error::ListDatabasesError,
                crate::input::ListDatabasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog that contains the databases to return.</p>
        pub fn catalog_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_name(inp);
            self
        }
        /// <p>The name of the data catalog that contains the databases to return.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_name(input);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataCatalogs`.
    ///
    /// <p>Lists the data catalogs in the current Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDataCatalogs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_catalogs_input::Builder,
    }
    impl<C, M, R> ListDataCatalogs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataCatalogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataCatalogsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataCatalogsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataCatalogsInputOperationOutputAlias,
                crate::output::ListDataCatalogsOutput,
                crate::error::ListDataCatalogsError,
                crate::input::ListDataCatalogsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the maximum number of data catalogs to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specifies the maximum number of data catalogs to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEngineVersions`.
    ///
    /// <p>Returns a list of engine versions that are available to choose from, including the
    /// Auto option.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEngineVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_engine_versions_input::Builder,
    }
    impl<C, M, R> ListEngineVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEngineVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEngineVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEngineVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEngineVersionsInputOperationOutputAlias,
                crate::output::ListEngineVersionsOutput,
                crate::error::ListEngineVersionsError,
                crate::input::ListEngineVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of engine versions to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of engine versions to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNamedQueries`.
    ///
    /// <p>Provides a list of available query IDs only for queries saved in the specified
    /// workgroup. Requires that you have access to the specified workgroup. If a workgroup is
    /// not specified, lists the saved queries for the primary workgroup.</p>
    /// <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and
    /// Code Samples</a> in the <i>Amazon Athena User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNamedQueries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_named_queries_input::Builder,
    }
    impl<C, M, R> ListNamedQueries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNamedQueries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNamedQueriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNamedQueriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNamedQueriesInputOperationOutputAlias,
                crate::output::ListNamedQueriesOutput,
                crate::error::ListNamedQueriesError,
                crate::input::ListNamedQueriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of queries to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of queries to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the workgroup from which the named queries are being returned. If a
        /// workgroup is not specified, the saved queries for the primary workgroup are
        /// returned.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The name of the workgroup from which the named queries are being returned. If a
        /// workgroup is not specified, the saved queries for the primary workgroup are
        /// returned.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPreparedStatements`.
    ///
    /// <p>Lists the prepared statements in the specfied workgroup.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPreparedStatements<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_prepared_statements_input::Builder,
    }
    impl<C, M, R> ListPreparedStatements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPreparedStatements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPreparedStatementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPreparedStatementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPreparedStatementsInputOperationOutputAlias,
                crate::output::ListPreparedStatementsOutput,
                crate::error::ListPreparedStatementsError,
                crate::input::ListPreparedStatementsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The workgroup to list the prepared statements for.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The workgroup to list the prepared statements for.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueryExecutions`.
    ///
    /// <p>Provides a list of available query execution IDs for the queries in the specified
    /// workgroup. If a workgroup is not specified, returns a list of query execution IDs for
    /// the primary workgroup. Requires you to have access to the workgroup in which the queries
    /// ran.</p>
    /// <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and
    /// Code Samples</a> in the <i>Amazon Athena User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListQueryExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_query_executions_input::Builder,
    }
    impl<C, M, R> ListQueryExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueryExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueryExecutionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueryExecutionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueryExecutionsInputOperationOutputAlias,
                crate::output::ListQueryExecutionsOutput,
                crate::error::ListQueryExecutionsError,
                crate::input::ListQueryExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of query executions to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of query executions to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The name of the workgroup from which queries are being returned. If a workgroup is not
        /// specified, a list of available query execution IDs for the queries in the primary
        /// workgroup is returned.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The name of the workgroup from which queries are being returned. If a workgroup is not
        /// specified, a list of available query execution IDs for the queries in the primary
        /// workgroup is returned.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTableMetadata`.
    ///
    /// <p>Lists the metadata for the tables in the specified data catalog database.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTableMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_table_metadata_input::Builder,
    }
    impl<C, M, R> ListTableMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTableMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTableMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTableMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTableMetadataInputOperationOutputAlias,
                crate::output::ListTableMetadataOutput,
                crate::error::ListTableMetadataError,
                crate::input::ListTableMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog for which table metadata should be returned.</p>
        pub fn catalog_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog_name(inp);
            self
        }
        /// <p>The name of the data catalog for which table metadata should be returned.</p>
        pub fn set_catalog_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog_name(input);
            self
        }
        /// <p>The name of the database for which table metadata should be returned.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database for which table metadata should be returned.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>A regex filter that pattern-matches table names. If no expression is supplied,
        /// metadata for all tables are listed.</p>
        pub fn expression(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.expression(inp);
            self
        }
        /// <p>A regex filter that pattern-matches table names. If no expression is supplied,
        /// metadata for all tables are listed.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_expression(input);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the NextToken from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specifies the maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags associated with an Athena workgroup or data catalog
    /// resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Lists the tags for the resource with the specified ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Lists the tags for the resource with the specified ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results for
        /// this request, where the request lists the tags for the resource with the specified
        /// ARN.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results, or null if there are no additional results for
        /// this request, where the request lists the tags for the resource with the specified
        /// ARN.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to be returned per request that lists the tags for the
        /// resource.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to be returned per request that lists the tags for the
        /// resource.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkGroups`.
    ///
    /// <p>Lists available workgroups for the account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListWorkGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_work_groups_input::Builder,
    }
    impl<C, M, R> ListWorkGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListWorkGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListWorkGroupsInputOperationOutputAlias,
                crate::output::ListWorkGroupsOutput,
                crate::error::ListWorkGroupsError,
                crate::input::ListWorkGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token generated by the Athena service that specifies where to continue
        /// pagination if a previous request was truncated. To obtain the next set of pages, pass in
        /// the <code>NextToken</code> from the response object of the previous page call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of workgroups to return in this request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of workgroups to return in this request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartQueryExecution`.
    ///
    /// <p>Runs the SQL query statements contained in the <code>Query</code>. Requires you to
    /// have access to the workgroup in which the query ran. Running queries against an external
    /// catalog requires <a>GetDataCatalog</a> permission to the catalog. For code
    /// samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and
    /// Code Samples</a> in the <i>Amazon Athena User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartQueryExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_query_execution_input::Builder,
    }
    impl<C, M, R> StartQueryExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartQueryExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartQueryExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StartQueryExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartQueryExecutionInputOperationOutputAlias,
                crate::output::StartQueryExecutionOutput,
                crate::error::StartQueryExecutionError,
                crate::input::StartQueryExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The SQL query statements to be executed.</p>
        pub fn query_string(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(inp);
            self
        }
        /// <p>The SQL query statements to be executed.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>StartQueryExecution</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique case-sensitive string used to ensure the request to create the query is
        /// idempotent (executes only once). If another <code>StartQueryExecution</code> request is
        /// received, the same response is returned and another query is not created. If a parameter
        /// has changed, for example, the <code>QueryString</code>, an error is returned.</p>
        /// <important>
        /// <p>This token is listed as not required because Amazon Web Services SDKs (for example
        /// the Amazon Web Services SDK for Java) auto-generate the token for users. If you are
        /// not using the Amazon Web Services SDK or the Amazon Web Services CLI, you must provide
        /// this token or the action will fail.</p>
        /// </important>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The database within which the query executes.</p>
        pub fn query_execution_context(mut self, inp: crate::model::QueryExecutionContext) -> Self {
            self.inner = self.inner.query_execution_context(inp);
            self
        }
        /// <p>The database within which the query executes.</p>
        pub fn set_query_execution_context(
            mut self,
            input: std::option::Option<crate::model::QueryExecutionContext>,
        ) -> Self {
            self.inner = self.inner.set_query_execution_context(input);
            self
        }
        /// <p>Specifies information about where and how to save the results of the query execution.
        /// If the query runs in a workgroup, then workgroup's settings may override query settings.
        /// This affects the query results location. The workgroup settings override is specified in
        /// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn result_configuration(mut self, inp: crate::model::ResultConfiguration) -> Self {
            self.inner = self.inner.result_configuration(inp);
            self
        }
        /// <p>Specifies information about where and how to save the results of the query execution.
        /// If the query runs in a workgroup, then workgroup's settings may override query settings.
        /// This affects the query results location. The workgroup settings override is specified in
        /// EnforceWorkGroupConfiguration (true/false) in the WorkGroupConfiguration. See <a>WorkGroupConfiguration$EnforceWorkGroupConfiguration</a>.</p>
        pub fn set_result_configuration(
            mut self,
            input: std::option::Option<crate::model::ResultConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_result_configuration(input);
            self
        }
        /// <p>The name of the workgroup in which the query is being started.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The name of the workgroup in which the query is being started.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopQueryExecution`.
    ///
    /// <p>Stops a query execution. Requires you to have access to the workgroup in which the
    /// query ran.</p>
    /// <p>For code samples using the Amazon Web Services SDK for Java, see <a href="http://docs.aws.amazon.com/athena/latest/ug/code-samples.html">Examples and
    /// Code Samples</a> in the <i>Amazon Athena User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopQueryExecution<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_query_execution_input::Builder,
    }
    impl<C, M, R> StopQueryExecution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopQueryExecution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopQueryExecutionOutput,
            aws_smithy_http::result::SdkError<crate::error::StopQueryExecutionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopQueryExecutionInputOperationOutputAlias,
                crate::output::StopQueryExecutionOutput,
                crate::error::StopQueryExecutionError,
                crate::input::StopQueryExecutionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique ID of the query execution to stop.</p>
        pub fn query_execution_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_execution_id(inp);
            self
        }
        /// <p>The unique ID of the query execution to stop.</p>
        pub fn set_query_execution_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_execution_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to an Athena resource. A tag is a label that you
    /// assign to a resource. In Athena, a resource can be a workgroup or data
    /// catalog. Each tag consists of a key and an optional value, both of which you define. For
    /// example, you can use tags to categorize Athena workgroups or data catalogs
    /// by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to
    /// search and filter workgroups or data catalogs in your account. For best practices, see
    /// <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Tagging Best Practices</a>. Tag keys can be from 1 to 128 UTF-8 Unicode
    /// characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use
    /// letters and numbers representable in UTF-8, and the following characters: + - = . _ : /
    /// @. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you
    /// specify more than one tag, separate them by commas.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ARN of the Athena resource (workgroup or data catalog) to
        /// which tags are to be added.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Specifies the ARN of the Athena resource (workgroup or data catalog) to
        /// which tags are to be added.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A collection of one or more tags, separated by commas, to be added to an Athena workgroup or data catalog resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A collection of one or more tags, separated by commas, to be added to an Athena workgroup or data catalog resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from a data catalog or workgroup resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the ARN of the resource from which tags are to be removed.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Specifies the ARN of the resource from which tags are to be removed.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A comma-separated list of one or more tag keys whose tags are to be removed from the
        /// specified resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A comma-separated list of one or more tag keys whose tags are to be removed from the
        /// specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataCatalog`.
    ///
    /// <p>Updates the data catalog that has the specified name.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataCatalog<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_catalog_input::Builder,
    }
    impl<C, M, R> UpdateDataCatalog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataCatalog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataCatalogOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataCatalogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataCatalogInputOperationOutputAlias,
                crate::output::UpdateDataCatalogOutput,
                crate::error::UpdateDataCatalogError,
                crate::input::UpdateDataCatalogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the data catalog to update. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the data catalog to update. The catalog name must be unique for the
        /// Amazon Web Services account and can use a maximum of 128 alphanumeric, underscore, at
        /// sign, or hyphen characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a
        /// federated catalog, <code>HIVE</code> for an external hive metastore, or
        /// <code>GLUE</code> for an Glue Data Catalog.</p>
        pub fn r#type(mut self, inp: crate::model::DataCatalogType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Specifies the type of data catalog to update. Specify <code>LAMBDA</code> for a
        /// federated catalog, <code>HIVE</code> for an external hive metastore, or
        /// <code>GLUE</code> for an Glue Data Catalog.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataCatalogType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>New or modified text that describes the data catalog.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>New or modified text that describes the data catalog.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Specifies the Lambda function or functions to use for updating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>Specifies the Lambda function or functions to use for updating the data
        /// catalog. This is a mapping whose values depend on the catalog type. </p>
        /// <ul>
        /// <li>
        /// <p>For the <code>HIVE</code> data catalog type, use the following syntax. The
        /// <code>metadata-function</code> parameter is required. <code>The
        /// sdk-version</code> parameter is optional and defaults to the currently
        /// supported version.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// sdk-version=<i>version_number</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>For the <code>LAMBDA</code> data catalog type, use one of the following sets
        /// of required parameters, but not both.</p>
        /// <ul>
        /// <li>
        /// <p>If you have one Lambda function that processes metadata
        /// and another for reading the actual data, use the following syntax. Both
        /// parameters are required.</p>
        /// <p>
        /// <code>metadata-function=<i>lambda_arn</i>,
        /// record-function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// <li>
        /// <p> If you have a composite Lambda function that processes
        /// both metadata and data, use the following syntax to specify your Lambda function.</p>
        /// <p>
        /// <code>function=<i>lambda_arn</i>
        /// </code>
        /// </p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePreparedStatement`.
    ///
    /// <p>Updates a prepared statement.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePreparedStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_prepared_statement_input::Builder,
    }
    impl<C, M, R> UpdatePreparedStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePreparedStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePreparedStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePreparedStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePreparedStatementInputOperationOutputAlias,
                crate::output::UpdatePreparedStatementOutput,
                crate::error::UpdatePreparedStatementError,
                crate::input::UpdatePreparedStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the prepared statement.</p>
        pub fn statement_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_name(inp);
            self
        }
        /// <p>The name of the prepared statement.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_statement_name(input);
            self
        }
        /// <p>The workgroup for the prepared statement.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The workgroup for the prepared statement.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn query_statement(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_statement(inp);
            self
        }
        /// <p>The query string for the prepared statement.</p>
        pub fn set_query_statement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_statement(input);
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the prepared statement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWorkGroup`.
    ///
    /// <p>Updates the workgroup with the specified name. The workgroup's name cannot be
    /// changed.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWorkGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_work_group_input::Builder,
    }
    impl<C, M, R> UpdateWorkGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWorkGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWorkGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWorkGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWorkGroupInputOperationOutputAlias,
                crate::output::UpdateWorkGroupOutput,
                crate::error::UpdateWorkGroupError,
                crate::input::UpdateWorkGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The specified workgroup that will be updated.</p>
        pub fn work_group(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.work_group(inp);
            self
        }
        /// <p>The specified workgroup that will be updated.</p>
        pub fn set_work_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_work_group(input);
            self
        }
        /// <p>The workgroup description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The workgroup description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The workgroup configuration that will be updated for the given workgroup.</p>
        pub fn configuration_updates(
            mut self,
            inp: crate::model::WorkGroupConfigurationUpdates,
        ) -> Self {
            self.inner = self.inner.configuration_updates(inp);
            self
        }
        /// <p>The workgroup configuration that will be updated for the given workgroup.</p>
        pub fn set_configuration_updates(
            mut self,
            input: std::option::Option<crate::model::WorkGroupConfigurationUpdates>,
        ) -> Self {
            self.inner = self.inner.set_configuration_updates(input);
            self
        }
        /// <p>The workgroup state that will be updated for the given workgroup.</p>
        pub fn state(mut self, inp: crate::model::WorkGroupState) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The workgroup state that will be updated for the given workgroup.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::WorkGroupState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
