// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateApiInput`](crate::input::AssociateApiInput)
pub mod associate_api_input {
    /// A builder for [`AssociateApiInput`](crate::input::AssociateApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateApiInput`](crate::input::AssociateApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateApiInput {
                domain_name: self.domain_name,
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateApiInputOperationOutputAlias = crate::operation::AssociateApi;
#[doc(hidden)]
pub type AssociateApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateApiInput {
    /// Consumes the builder and constructs an Operation<[`AssociateApi`](crate::operation::AssociateApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.domain_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_1, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainnames/{domainName}/apiassociation",
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateApi",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateApiInput`](crate::input::AssociateApiInput)
    pub fn builder() -> crate::input::associate_api_input::Builder {
        crate::input::associate_api_input::Builder::default()
    }
}

/// See [`CreateApiCacheInput`](crate::input::CreateApiCacheInput)
pub mod create_api_cache_input {
    /// A builder for [`CreateApiCacheInput`](crate::input::CreateApiCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<i64>,
        pub(crate) transit_encryption_enabled: std::option::Option<bool>,
        pub(crate) at_rest_encryption_enabled: std::option::Option<bool>,
        pub(crate) api_caching_behavior: std::option::Option<crate::model::ApiCachingBehavior>,
        pub(crate) r#type: std::option::Option<crate::model::ApiCacheType>,
    }
    impl Builder {
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.transit_encryption_enabled = Some(input);
            self
        }
        /// <p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.transit_encryption_enabled = input;
            self
        }
        /// <p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.at_rest_encryption_enabled = Some(input);
            self
        }
        /// <p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.at_rest_encryption_enabled = input;
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn api_caching_behavior(mut self, input: crate::model::ApiCachingBehavior) -> Self {
            self.api_caching_behavior = Some(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn set_api_caching_behavior(
            mut self,
            input: std::option::Option<crate::model::ApiCachingBehavior>,
        ) -> Self {
            self.api_caching_behavior = input;
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ApiCacheType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ApiCacheType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiCacheInput`](crate::input::CreateApiCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApiCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApiCacheInput {
                api_id: self.api_id,
                ttl: self.ttl.unwrap_or_default(),
                transit_encryption_enabled: self.transit_encryption_enabled.unwrap_or_default(),
                at_rest_encryption_enabled: self.at_rest_encryption_enabled.unwrap_or_default(),
                api_caching_behavior: self.api_caching_behavior,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApiCacheInputOperationOutputAlias = crate::operation::CreateApiCache;
#[doc(hidden)]
pub type CreateApiCacheInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApiCacheInput {
    /// Consumes the builder and constructs an Operation<[`CreateApiCache`](crate::operation::CreateApiCache)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApiCache,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateApiCacheInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.api_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_2, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/ApiCaches", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateApiCacheInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_api_cache(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApiCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApiCache",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateApiCacheInput`](crate::input::CreateApiCacheInput)
    pub fn builder() -> crate::input::create_api_cache_input::Builder {
        crate::input::create_api_cache_input::Builder::default()
    }
}

/// See [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
pub mod create_api_key_input {
    /// A builder for [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID for your GraphQL API.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The ID for your GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>
        pub fn expires(mut self, input: i64) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>
        pub fn set_expires(mut self, input: std::option::Option<i64>) -> Self {
            self.expires = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApiKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApiKeyInput {
                api_id: self.api_id,
                description: self.description,
                expires: self.expires.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApiKeyInputOperationOutputAlias = crate::operation::CreateApiKey;
#[doc(hidden)]
pub type CreateApiKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApiKeyInput {
    /// Consumes the builder and constructs an Operation<[`CreateApiKey`](crate::operation::CreateApiKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApiKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateApiKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.api_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_3, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/apikeys", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateApiKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_api_key(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApiKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApiKey",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
    pub fn builder() -> crate::input::create_api_key_input::Builder {
        crate::input::create_api_key_input::Builder::default()
    }
}

/// See [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
pub mod create_data_source_input {
    /// A builder for [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) dynamodb_config: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        pub(crate) lambda_config: std::option::Option<crate::model::LambdaDataSourceConfig>,
        pub(crate) elasticsearch_config:
            std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        pub(crate) open_search_service_config:
            std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        pub(crate) http_config: std::option::Option<crate::model::HttpDataSourceConfig>,
        pub(crate) relational_database_config:
            std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
    }
    impl Builder {
        /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>A user-supplied name for the <code>DataSource</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-supplied name for the <code>DataSource</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A description of the <code>DataSource</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the <code>DataSource</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the <code>DataSource</code>.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the <code>DataSource</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn dynamodb_config(mut self, input: crate::model::DynamodbDataSourceConfig) -> Self {
            self.dynamodb_config = Some(input);
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn set_dynamodb_config(
            mut self,
            input: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        ) -> Self {
            self.dynamodb_config = input;
            self
        }
        /// <p>Lambda settings.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaDataSourceConfig) -> Self {
            self.lambda_config = Some(input);
            self
        }
        /// <p>Lambda settings.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaDataSourceConfig>,
        ) -> Self {
            self.lambda_config = input;
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <code>CreateDataSourceRequest$openSearchServiceConfig</code> to create an OpenSearch data source.</p>
        pub fn elasticsearch_config(
            mut self,
            input: crate::model::ElasticsearchDataSourceConfig,
        ) -> Self {
            self.elasticsearch_config = Some(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <code>CreateDataSourceRequest$openSearchServiceConfig</code> to create an OpenSearch data source.</p>
        pub fn set_elasticsearch_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        ) -> Self {
            self.elasticsearch_config = input;
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn open_search_service_config(
            mut self,
            input: crate::model::OpenSearchServiceDataSourceConfig,
        ) -> Self {
            self.open_search_service_config = Some(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn set_open_search_service_config(
            mut self,
            input: std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        ) -> Self {
            self.open_search_service_config = input;
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn http_config(mut self, input: crate::model::HttpDataSourceConfig) -> Self {
            self.http_config = Some(input);
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn set_http_config(
            mut self,
            input: std::option::Option<crate::model::HttpDataSourceConfig>,
        ) -> Self {
            self.http_config = input;
            self
        }
        /// <p>Relational database settings.</p>
        pub fn relational_database_config(
            mut self,
            input: crate::model::RelationalDatabaseDataSourceConfig,
        ) -> Self {
            self.relational_database_config = Some(input);
            self
        }
        /// <p>Relational database settings.</p>
        pub fn set_relational_database_config(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
        ) -> Self {
            self.relational_database_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSourceInput {
                api_id: self.api_id,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                service_role_arn: self.service_role_arn,
                dynamodb_config: self.dynamodb_config,
                lambda_config: self.lambda_config,
                elasticsearch_config: self.elasticsearch_config,
                open_search_service_config: self.open_search_service_config,
                http_config: self.http_config,
                relational_database_config: self.relational_database_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSourceInputOperationOutputAlias = crate::operation::CreateDataSource;
#[doc(hidden)]
pub type CreateDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataSource`](crate::operation::CreateDataSource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDataSourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.api_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_4, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/datasources", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDataSourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_data_source(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSource",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    pub fn builder() -> crate::input::create_data_source_input::Builder {
        crate::input::create_data_source_input::Builder::default()
    }
}

/// See [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
pub mod create_domain_name_input {
    /// A builder for [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainNameInput {
                domain_name: self.domain_name,
                certificate_arn: self.certificate_arn,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainNameInputOperationOutputAlias = crate::operation::CreateDomainName;
#[doc(hidden)]
pub type CreateDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomainName`](crate::operation::CreateDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/domainnames").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain_name(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomainName",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainNameInput`](crate::input::CreateDomainNameInput)
    pub fn builder() -> crate::input::create_domain_name_input::Builder {
        crate::input::create_domain_name_input::Builder::default()
    }
}

/// See [`CreateFunctionInput`](crate::input::CreateFunctionInput)
pub mod create_function_input {
    /// A builder for [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) request_mapping_template: std::option::Option<std::string::String>,
        pub(crate) response_mapping_template: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) sync_config: std::option::Option<crate::model::SyncConfig>,
        pub(crate) max_batch_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_mapping_template = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_mapping_template = input;
            self
        }
        /// <p>The <code>Function</code> response mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_mapping_template = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> response mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_mapping_template = input;
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.sync_config = Some(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.sync_config = input;
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.max_batch_size = Some(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_batch_size = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFunctionInput`](crate::input::CreateFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFunctionInput {
                api_id: self.api_id,
                name: self.name,
                description: self.description,
                data_source_name: self.data_source_name,
                request_mapping_template: self.request_mapping_template,
                response_mapping_template: self.response_mapping_template,
                function_version: self.function_version,
                sync_config: self.sync_config,
                max_batch_size: self.max_batch_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFunctionInputOperationOutputAlias = crate::operation::CreateFunction;
#[doc(hidden)]
pub type CreateFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFunctionInput {
    /// Consumes the builder and constructs an Operation<[`CreateFunction`](crate::operation::CreateFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.api_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_5, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/functions", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_function(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFunction",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    pub fn builder() -> crate::input::create_function_input::Builder {
        crate::input::create_function_input::Builder::default()
    }
}

/// See [`CreateGraphqlApiInput`](crate::input::CreateGraphqlApiInput)
pub mod create_graphql_api_input {
    /// A builder for [`CreateGraphqlApiInput`](crate::input::CreateGraphqlApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_config: std::option::Option<crate::model::LogConfig>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) user_pool_config: std::option::Option<crate::model::UserPoolConfig>,
        pub(crate) open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) additional_authentication_providers:
            std::option::Option<std::vec::Vec<crate::model::AdditionalAuthenticationProvider>>,
        pub(crate) xray_enabled: std::option::Option<bool>,
        pub(crate) lambda_authorizer_config:
            std::option::Option<crate::model::LambdaAuthorizerConfig>,
    }
    impl Builder {
        /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn log_config(mut self, input: crate::model::LogConfig) -> Self {
            self.log_config = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogConfig>,
        ) -> Self {
            self.log_config = input;
            self
        }
        /// <p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn user_pool_config(mut self, input: crate::model::UserPoolConfig) -> Self {
            self.user_pool_config = Some(input);
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::UserPoolConfig>,
        ) -> Self {
            self.user_pool_config = input;
            self
        }
        /// <p>The OIDC configuration.</p>
        pub fn open_id_connect_config(mut self, input: crate::model::OpenIdConnectConfig) -> Self {
            self.open_id_connect_config = Some(input);
            self
        }
        /// <p>The OIDC configuration.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.open_id_connect_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A <code>TagMap</code> object.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A <code>TagMap</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `additional_authentication_providers`.
        ///
        /// To override the contents of this collection use [`set_additional_authentication_providers`](Self::set_additional_authentication_providers).
        ///
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn additional_authentication_providers(
            mut self,
            input: crate::model::AdditionalAuthenticationProvider,
        ) -> Self {
            let mut v = self.additional_authentication_providers.unwrap_or_default();
            v.push(input);
            self.additional_authentication_providers = Some(v);
            self
        }
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn set_additional_authentication_providers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalAuthenticationProvider>,
            >,
        ) -> Self {
            self.additional_authentication_providers = input;
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn xray_enabled(mut self, input: bool) -> Self {
            self.xray_enabled = Some(input);
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn set_xray_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.xray_enabled = input;
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            input: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.lambda_authorizer_config = Some(input);
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.lambda_authorizer_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGraphqlApiInput`](crate::input::CreateGraphqlApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGraphqlApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGraphqlApiInput {
                name: self.name,
                log_config: self.log_config,
                authentication_type: self.authentication_type,
                user_pool_config: self.user_pool_config,
                open_id_connect_config: self.open_id_connect_config,
                tags: self.tags,
                additional_authentication_providers: self.additional_authentication_providers,
                xray_enabled: self.xray_enabled.unwrap_or_default(),
                lambda_authorizer_config: self.lambda_authorizer_config,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGraphqlApiInputOperationOutputAlias = crate::operation::CreateGraphqlApi;
#[doc(hidden)]
pub type CreateGraphqlApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGraphqlApiInput {
    /// Consumes the builder and constructs an Operation<[`CreateGraphqlApi`](crate::operation::CreateGraphqlApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGraphqlApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGraphqlApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/apis").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGraphqlApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_graphql_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGraphqlApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGraphqlApi",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGraphqlApiInput`](crate::input::CreateGraphqlApiInput)
    pub fn builder() -> crate::input::create_graphql_api_input::Builder {
        crate::input::create_graphql_api_input::Builder::default()
    }
}

/// See [`CreateResolverInput`](crate::input::CreateResolverInput)
pub mod create_resolver_input {
    /// A builder for [`CreateResolverInput`](crate::input::CreateResolverInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) field_name: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) request_mapping_template: std::option::Option<std::string::String>,
        pub(crate) response_mapping_template: std::option::Option<std::string::String>,
        pub(crate) kind: std::option::Option<crate::model::ResolverKind>,
        pub(crate) pipeline_config: std::option::Option<crate::model::PipelineConfig>,
        pub(crate) sync_config: std::option::Option<crate::model::SyncConfig>,
        pub(crate) caching_config: std::option::Option<crate::model::CachingConfig>,
        pub(crate) max_batch_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The name of the <code>Type</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The name of the field to attach the resolver to.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The name of the field to attach the resolver to.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// <p>The name of the data source for which the resolver is being created.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>The name of the data source for which the resolver is being created.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The mapping template to use for requests.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_mapping_template = Some(input.into());
            self
        }
        /// <p>The mapping template to use for requests.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_mapping_template = input;
            self
        }
        /// <p>The mapping template to use for responses from the data source.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_mapping_template = Some(input.into());
            self
        }
        /// <p>The mapping template to use for responses from the data source.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_mapping_template = input;
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::ResolverKind) -> Self {
            self.kind = Some(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::ResolverKind>) -> Self {
            self.kind = input;
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn pipeline_config(mut self, input: crate::model::PipelineConfig) -> Self {
            self.pipeline_config = Some(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn set_pipeline_config(
            mut self,
            input: std::option::Option<crate::model::PipelineConfig>,
        ) -> Self {
            self.pipeline_config = input;
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.sync_config = Some(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.sync_config = input;
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn caching_config(mut self, input: crate::model::CachingConfig) -> Self {
            self.caching_config = Some(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn set_caching_config(
            mut self,
            input: std::option::Option<crate::model::CachingConfig>,
        ) -> Self {
            self.caching_config = input;
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.max_batch_size = Some(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_batch_size = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateResolverInput`](crate::input::CreateResolverInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateResolverInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateResolverInput {
                api_id: self.api_id,
                type_name: self.type_name,
                field_name: self.field_name,
                data_source_name: self.data_source_name,
                request_mapping_template: self.request_mapping_template,
                response_mapping_template: self.response_mapping_template,
                kind: self.kind,
                pipeline_config: self.pipeline_config,
                sync_config: self.sync_config,
                caching_config: self.caching_config,
                max_batch_size: self.max_batch_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateResolverInputOperationOutputAlias = crate::operation::CreateResolver;
#[doc(hidden)]
pub type CreateResolverInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateResolverInput {
    /// Consumes the builder and constructs an Operation<[`CreateResolver`](crate::operation::CreateResolver)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateResolver,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateResolverInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.api_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_6, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_7 = &_input.type_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_7, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}/resolvers",
                    apiId = api_id,
                    typeName = type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateResolverInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_resolver(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateResolver::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateResolver",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateResolverInput`](crate::input::CreateResolverInput)
    pub fn builder() -> crate::input::create_resolver_input::Builder {
        crate::input::create_resolver_input::Builder::default()
    }
}

/// See [`CreateTypeInput`](crate::input::CreateTypeInput)
pub mod create_type_input {
    /// A builder for [`CreateTypeInput`](crate::input::CreateTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::TypeDefinitionFormat>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
        /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
        /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTypeInput`](crate::input::CreateTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTypeInput {
                api_id: self.api_id,
                definition: self.definition,
                format: self.format,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTypeInputOperationOutputAlias = crate::operation::CreateType;
#[doc(hidden)]
pub type CreateTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTypeInput {
    /// Consumes the builder and constructs an Operation<[`CreateType`](crate::operation::CreateType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.api_id;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_8, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/types", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_type(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateType",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTypeInput`](crate::input::CreateTypeInput)
    pub fn builder() -> crate::input::create_type_input::Builder {
        crate::input::create_type_input::Builder::default()
    }
}

/// See [`DeleteApiCacheInput`](crate::input::DeleteApiCacheInput)
pub mod delete_api_cache_input {
    /// A builder for [`DeleteApiCacheInput`](crate::input::DeleteApiCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApiCacheInput`](crate::input::DeleteApiCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApiCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApiCacheInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApiCacheInputOperationOutputAlias = crate::operation::DeleteApiCache;
#[doc(hidden)]
pub type DeleteApiCacheInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApiCacheInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApiCache`](crate::operation::DeleteApiCache)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApiCache,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApiCacheInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.api_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_9, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/ApiCaches", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApiCacheInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApiCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApiCache",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApiCacheInput`](crate::input::DeleteApiCacheInput)
    pub fn builder() -> crate::input::delete_api_cache_input::Builder {
        crate::input::delete_api_cache_input::Builder::default()
    }
}

/// See [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
pub mod delete_api_key_input {
    /// A builder for [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The ID for the API key.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID for the API key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApiKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApiKeyInput {
                api_id: self.api_id,
                id: self.id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApiKeyInputOperationOutputAlias = crate::operation::DeleteApiKey;
#[doc(hidden)]
pub type DeleteApiKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApiKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApiKey`](crate::operation::DeleteApiKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApiKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApiKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.api_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_10, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_11, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/apikeys/{id}",
                    apiId = api_id,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApiKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApiKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApiKey",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
    pub fn builder() -> crate::input::delete_api_key_input::Builder {
        crate::input::delete_api_key_input::Builder::default()
    }
}

/// See [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
pub mod delete_data_source_input {
    /// A builder for [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataSourceInput {
                api_id: self.api_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataSourceInputOperationOutputAlias = crate::operation::DeleteDataSource;
#[doc(hidden)]
pub type DeleteDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataSource`](crate::operation::DeleteDataSource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDataSourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.api_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_12, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_13, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/datasources/{name}",
                    apiId = api_id,
                    name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDataSourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataSource",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    pub fn builder() -> crate::input::delete_data_source_input::Builder {
        crate::input::delete_data_source_input::Builder::default()
    }
}

/// See [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
pub mod delete_domain_name_input {
    /// A builder for [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainNameInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainNameInputOperationOutputAlias = crate::operation::DeleteDomainName;
#[doc(hidden)]
pub type DeleteDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomainName`](crate::operation::DeleteDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.domain_name;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_14, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainnames/{domainName}",
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomainName",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainNameInput`](crate::input::DeleteDomainNameInput)
    pub fn builder() -> crate::input::delete_domain_name_input::Builder {
        crate::input::delete_domain_name_input::Builder::default()
    }
}

/// See [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
pub mod delete_function_input {
    /// A builder for [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) function_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_id = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFunctionInput {
                api_id: self.api_id,
                function_id: self.function_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFunctionInputOperationOutputAlias = crate::operation::DeleteFunction;
#[doc(hidden)]
pub type DeleteFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFunctionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFunction`](crate::operation::DeleteFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.api_id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_15, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_16 = &_input.function_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_id = aws_smithy_http::label::fmt_string(input_16, false);
                if function_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/functions/{functionId}",
                    apiId = api_id,
                    functionId = function_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFunction",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    pub fn builder() -> crate::input::delete_function_input::Builder {
        crate::input::delete_function_input::Builder::default()
    }
}

/// See [`DeleteGraphqlApiInput`](crate::input::DeleteGraphqlApiInput)
pub mod delete_graphql_api_input {
    /// A builder for [`DeleteGraphqlApiInput`](crate::input::DeleteGraphqlApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGraphqlApiInput`](crate::input::DeleteGraphqlApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGraphqlApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGraphqlApiInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGraphqlApiInputOperationOutputAlias = crate::operation::DeleteGraphqlApi;
#[doc(hidden)]
pub type DeleteGraphqlApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGraphqlApiInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGraphqlApi`](crate::operation::DeleteGraphqlApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGraphqlApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGraphqlApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.api_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_17, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGraphqlApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGraphqlApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGraphqlApi",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGraphqlApiInput`](crate::input::DeleteGraphqlApiInput)
    pub fn builder() -> crate::input::delete_graphql_api_input::Builder {
        crate::input::delete_graphql_api_input::Builder::default()
    }
}

/// See [`DeleteResolverInput`](crate::input::DeleteResolverInput)
pub mod delete_resolver_input {
    /// A builder for [`DeleteResolverInput`](crate::input::DeleteResolverInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The name of the resolver type.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The name of the resolver type.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The resolver field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The resolver field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteResolverInput`](crate::input::DeleteResolverInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteResolverInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteResolverInput {
                api_id: self.api_id,
                type_name: self.type_name,
                field_name: self.field_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteResolverInputOperationOutputAlias = crate::operation::DeleteResolver;
#[doc(hidden)]
pub type DeleteResolverInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteResolverInput {
    /// Consumes the builder and constructs an Operation<[`DeleteResolver`](crate::operation::DeleteResolver)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteResolver,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteResolverInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.api_id;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_18, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_19 = &_input.type_name;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_19, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_20 = &_input.field_name;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "field_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let field_name = aws_smithy_http::label::fmt_string(input_20, false);
                if field_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "field_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}",
                    apiId = api_id,
                    typeName = type_name,
                    fieldName = field_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteResolverInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteResolver::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteResolver",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteResolverInput`](crate::input::DeleteResolverInput)
    pub fn builder() -> crate::input::delete_resolver_input::Builder {
        crate::input::delete_resolver_input::Builder::default()
    }
}

/// See [`DeleteTypeInput`](crate::input::DeleteTypeInput)
pub mod delete_type_input {
    /// A builder for [`DeleteTypeInput`](crate::input::DeleteTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTypeInput`](crate::input::DeleteTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTypeInput {
                api_id: self.api_id,
                type_name: self.type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTypeInputOperationOutputAlias = crate::operation::DeleteType;
#[doc(hidden)]
pub type DeleteTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteType`](crate::operation::DeleteType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_21 = &_input.api_id;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_21, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_22 = &_input.type_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_22, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}",
                    apiId = api_id,
                    typeName = type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteType",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTypeInput`](crate::input::DeleteTypeInput)
    pub fn builder() -> crate::input::delete_type_input::Builder {
        crate::input::delete_type_input::Builder::default()
    }
}

/// See [`DisassociateApiInput`](crate::input::DisassociateApiInput)
pub mod disassociate_api_input {
    /// A builder for [`DisassociateApiInput`](crate::input::DisassociateApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateApiInput`](crate::input::DisassociateApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateApiInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateApiInputOperationOutputAlias = crate::operation::DisassociateApi;
#[doc(hidden)]
pub type DisassociateApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateApiInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateApi`](crate::operation::DisassociateApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_23 = &_input.domain_name;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_23, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainnames/{domainName}/apiassociation",
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateApi",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateApiInput`](crate::input::DisassociateApiInput)
    pub fn builder() -> crate::input::disassociate_api_input::Builder {
        crate::input::disassociate_api_input::Builder::default()
    }
}

/// See [`FlushApiCacheInput`](crate::input::FlushApiCacheInput)
pub mod flush_api_cache_input {
    /// A builder for [`FlushApiCacheInput`](crate::input::FlushApiCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FlushApiCacheInput`](crate::input::FlushApiCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::FlushApiCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::FlushApiCacheInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type FlushApiCacheInputOperationOutputAlias = crate::operation::FlushApiCache;
#[doc(hidden)]
pub type FlushApiCacheInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl FlushApiCacheInput {
    /// Consumes the builder and constructs an Operation<[`FlushApiCache`](crate::operation::FlushApiCache)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::FlushApiCache,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::FlushApiCacheInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.api_id;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_24, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/FlushCache", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::FlushApiCacheInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::FlushApiCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "FlushApiCache",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`FlushApiCacheInput`](crate::input::FlushApiCacheInput)
    pub fn builder() -> crate::input::flush_api_cache_input::Builder {
        crate::input::flush_api_cache_input::Builder::default()
    }
}

/// See [`GetApiAssociationInput`](crate::input::GetApiAssociationInput)
pub mod get_api_association_input {
    /// A builder for [`GetApiAssociationInput`](crate::input::GetApiAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiAssociationInput`](crate::input::GetApiAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApiAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApiAssociationInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApiAssociationInputOperationOutputAlias = crate::operation::GetApiAssociation;
#[doc(hidden)]
pub type GetApiAssociationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApiAssociationInput {
    /// Consumes the builder and constructs an Operation<[`GetApiAssociation`](crate::operation::GetApiAssociation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApiAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApiAssociationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.domain_name;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_25, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainnames/{domainName}/apiassociation",
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApiAssociationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApiAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApiAssociation",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApiAssociationInput`](crate::input::GetApiAssociationInput)
    pub fn builder() -> crate::input::get_api_association_input::Builder {
        crate::input::get_api_association_input::Builder::default()
    }
}

/// See [`GetApiCacheInput`](crate::input::GetApiCacheInput)
pub mod get_api_cache_input {
    /// A builder for [`GetApiCacheInput`](crate::input::GetApiCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApiCacheInput`](crate::input::GetApiCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApiCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApiCacheInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApiCacheInputOperationOutputAlias = crate::operation::GetApiCache;
#[doc(hidden)]
pub type GetApiCacheInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApiCacheInput {
    /// Consumes the builder and constructs an Operation<[`GetApiCache`](crate::operation::GetApiCache)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApiCache,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetApiCacheInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.api_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_26, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/ApiCaches", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetApiCacheInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApiCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApiCache",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetApiCacheInput`](crate::input::GetApiCacheInput)
    pub fn builder() -> crate::input::get_api_cache_input::Builder {
        crate::input::get_api_cache_input::Builder::default()
    }
}

/// See [`GetDataSourceInput`](crate::input::GetDataSourceInput)
pub mod get_data_source_input {
    /// A builder for [`GetDataSourceInput`](crate::input::GetDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataSourceInput`](crate::input::GetDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataSourceInput {
                api_id: self.api_id,
                name: self.name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataSourceInputOperationOutputAlias = crate::operation::GetDataSource;
#[doc(hidden)]
pub type GetDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`GetDataSource`](crate::operation::GetDataSource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDataSourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.api_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_27, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_28 = &_input.name;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_28, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/datasources/{name}",
                    apiId = api_id,
                    name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDataSourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataSource",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDataSourceInput`](crate::input::GetDataSourceInput)
    pub fn builder() -> crate::input::get_data_source_input::Builder {
        crate::input::get_data_source_input::Builder::default()
    }
}

/// See [`GetDomainNameInput`](crate::input::GetDomainNameInput)
pub mod get_domain_name_input {
    /// A builder for [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainNameInput`](crate::input::GetDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainNameInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainNameInputOperationOutputAlias = crate::operation::GetDomainName;
#[doc(hidden)]
pub type GetDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainName`](crate::operation::GetDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.domain_name;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_29, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainnames/{domainName}",
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainName",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainNameInput`](crate::input::GetDomainNameInput)
    pub fn builder() -> crate::input::get_domain_name_input::Builder {
        crate::input::get_domain_name_input::Builder::default()
    }
}

/// See [`GetFunctionInput`](crate::input::GetFunctionInput)
pub mod get_function_input {
    /// A builder for [`GetFunctionInput`](crate::input::GetFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) function_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_id = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFunctionInput`](crate::input::GetFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFunctionInput {
                api_id: self.api_id,
                function_id: self.function_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFunctionInputOperationOutputAlias = crate::operation::GetFunction;
#[doc(hidden)]
pub type GetFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFunctionInput {
    /// Consumes the builder and constructs an Operation<[`GetFunction`](crate::operation::GetFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.api_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_30, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_31 = &_input.function_id;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_id = aws_smithy_http::label::fmt_string(input_31, false);
                if function_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/functions/{functionId}",
                    apiId = api_id,
                    functionId = function_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFunction",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFunctionInput`](crate::input::GetFunctionInput)
    pub fn builder() -> crate::input::get_function_input::Builder {
        crate::input::get_function_input::Builder::default()
    }
}

/// See [`GetGraphqlApiInput`](crate::input::GetGraphqlApiInput)
pub mod get_graphql_api_input {
    /// A builder for [`GetGraphqlApiInput`](crate::input::GetGraphqlApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID for the GraphQL API.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID for the GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGraphqlApiInput`](crate::input::GetGraphqlApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGraphqlApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGraphqlApiInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGraphqlApiInputOperationOutputAlias = crate::operation::GetGraphqlApi;
#[doc(hidden)]
pub type GetGraphqlApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGraphqlApiInput {
    /// Consumes the builder and constructs an Operation<[`GetGraphqlApi`](crate::operation::GetGraphqlApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGraphqlApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetGraphqlApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_32 = &_input.api_id;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_32, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetGraphqlApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGraphqlApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGraphqlApi",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetGraphqlApiInput`](crate::input::GetGraphqlApiInput)
    pub fn builder() -> crate::input::get_graphql_api_input::Builder {
        crate::input::get_graphql_api_input::Builder::default()
    }
}

/// See [`GetIntrospectionSchemaInput`](crate::input::GetIntrospectionSchemaInput)
pub mod get_introspection_schema_input {
    /// A builder for [`GetIntrospectionSchemaInput`](crate::input::GetIntrospectionSchemaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::OutputType>,
        pub(crate) include_directives: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The schema format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::OutputType) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The schema format: SDL or JSON.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::OutputType>) -> Self {
            self.format = input;
            self
        }
        /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
        pub fn include_directives(mut self, input: bool) -> Self {
            self.include_directives = Some(input);
            self
        }
        /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
        pub fn set_include_directives(mut self, input: std::option::Option<bool>) -> Self {
            self.include_directives = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntrospectionSchemaInput`](crate::input::GetIntrospectionSchemaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntrospectionSchemaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntrospectionSchemaInput {
                api_id: self.api_id,
                format: self.format,
                include_directives: self.include_directives,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntrospectionSchemaInputOperationOutputAlias = crate::operation::GetIntrospectionSchema;
#[doc(hidden)]
pub type GetIntrospectionSchemaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIntrospectionSchemaInput {
    /// Consumes the builder and constructs an Operation<[`GetIntrospectionSchema`](crate::operation::GetIntrospectionSchema)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntrospectionSchema,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIntrospectionSchemaInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.api_id;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_33, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/schema", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetIntrospectionSchemaInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_34) = &_input.format {
                    query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_34));
                }
                if let Some(inner_35) = &_input.include_directives {
                    query.push_kv(
                        "includeDirectives",
                        aws_smithy_types::primitive::Encoder::from(*inner_35).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIntrospectionSchemaInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntrospectionSchema::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntrospectionSchema",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIntrospectionSchemaInput`](crate::input::GetIntrospectionSchemaInput)
    pub fn builder() -> crate::input::get_introspection_schema_input::Builder {
        crate::input::get_introspection_schema_input::Builder::default()
    }
}

/// See [`GetResolverInput`](crate::input::GetResolverInput)
pub mod get_resolver_input {
    /// A builder for [`GetResolverInput`](crate::input::GetResolverInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The resolver type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The resolver type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The resolver field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The resolver field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResolverInput`](crate::input::GetResolverInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetResolverInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetResolverInput {
                api_id: self.api_id,
                type_name: self.type_name,
                field_name: self.field_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetResolverInputOperationOutputAlias = crate::operation::GetResolver;
#[doc(hidden)]
pub type GetResolverInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetResolverInput {
    /// Consumes the builder and constructs an Operation<[`GetResolver`](crate::operation::GetResolver)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetResolver,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetResolverInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.api_id;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_36, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.type_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_37, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_38 = &_input.field_name;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "field_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let field_name = aws_smithy_http::label::fmt_string(input_38, false);
                if field_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "field_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}",
                    apiId = api_id,
                    typeName = type_name,
                    fieldName = field_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetResolverInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetResolver::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetResolver",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetResolverInput`](crate::input::GetResolverInput)
    pub fn builder() -> crate::input::get_resolver_input::Builder {
        crate::input::get_resolver_input::Builder::default()
    }
}

/// See [`GetSchemaCreationStatusInput`](crate::input::GetSchemaCreationStatusInput)
pub mod get_schema_creation_status_input {
    /// A builder for [`GetSchemaCreationStatusInput`](crate::input::GetSchemaCreationStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSchemaCreationStatusInput`](crate::input::GetSchemaCreationStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSchemaCreationStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSchemaCreationStatusInput {
                api_id: self.api_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSchemaCreationStatusInputOperationOutputAlias =
    crate::operation::GetSchemaCreationStatus;
#[doc(hidden)]
pub type GetSchemaCreationStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSchemaCreationStatusInput {
    /// Consumes the builder and constructs an Operation<[`GetSchemaCreationStatus`](crate::operation::GetSchemaCreationStatus)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSchemaCreationStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSchemaCreationStatusInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.api_id;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_39, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/schemacreation", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSchemaCreationStatusInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSchemaCreationStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSchemaCreationStatus",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSchemaCreationStatusInput`](crate::input::GetSchemaCreationStatusInput)
    pub fn builder() -> crate::input::get_schema_creation_status_input::Builder {
        crate::input::get_schema_creation_status_input::Builder::default()
    }
}

/// See [`GetTypeInput`](crate::input::GetTypeInput)
pub mod get_type_input {
    /// A builder for [`GetTypeInput`](crate::input::GetTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::TypeDefinitionFormat>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTypeInput`](crate::input::GetTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTypeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTypeInput {
                api_id: self.api_id,
                type_name: self.type_name,
                format: self.format,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTypeInputOperationOutputAlias = crate::operation::GetType;
#[doc(hidden)]
pub type GetTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetType`](crate::operation::GetType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.api_id;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_40, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_41 = &_input.type_name;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_41, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}",
                    apiId = api_id,
                    typeName = type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetTypeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_42) = &_input.format {
                    query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_42));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetType::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetType", "appsync",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetTypeInput`](crate::input::GetTypeInput)
    pub fn builder() -> crate::input::get_type_input::Builder {
        crate::input::get_type_input::Builder::default()
    }
}

/// See [`ListApiKeysInput`](crate::input::ListApiKeysInput)
pub mod list_api_keys_input {
    /// A builder for [`ListApiKeysInput`](crate::input::ListApiKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApiKeysInput`](crate::input::ListApiKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApiKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApiKeysInput {
                api_id: self.api_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListApiKeysInputOperationOutputAlias = crate::operation::ListApiKeys;
#[doc(hidden)]
pub type ListApiKeysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListApiKeysInput {
    /// Consumes the builder and constructs an Operation<[`ListApiKeys`](crate::operation::ListApiKeys)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApiKeys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListApiKeysInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.api_id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_43, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/apikeys", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListApiKeysInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_44) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_44));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListApiKeysInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApiKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApiKeys",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListApiKeysInput`](crate::input::ListApiKeysInput)
    pub fn builder() -> crate::input::list_api_keys_input::Builder {
        crate::input::list_api_keys_input::Builder::default()
    }
}

/// See [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
pub mod list_data_sources_input {
    /// A builder for [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDataSourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDataSourcesInput {
                api_id: self.api_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDataSourcesInputOperationOutputAlias = crate::operation::ListDataSources;
#[doc(hidden)]
pub type ListDataSourcesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDataSourcesInput {
    /// Consumes the builder and constructs an Operation<[`ListDataSources`](crate::operation::ListDataSources)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDataSources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDataSourcesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.api_id;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_45, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/datasources", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDataSourcesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_46) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_46));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDataSourcesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDataSources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDataSources",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    pub fn builder() -> crate::input::list_data_sources_input::Builder {
        crate::input::list_data_sources_input::Builder::default()
    }
}

/// See [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
pub mod list_domain_names_input {
    /// A builder for [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The API token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The API token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainNamesInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainNamesInputOperationOutputAlias = crate::operation::ListDomainNames;
#[doc(hidden)]
pub type ListDomainNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainNamesInput {
    /// Consumes the builder and constructs an Operation<[`ListDomainNames`](crate::operation::ListDomainNames)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomainNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainNamesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/domainnames").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainNamesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_47) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainNamesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomainNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomainNames",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainNamesInput`](crate::input::ListDomainNamesInput)
    pub fn builder() -> crate::input::list_domain_names_input::Builder {
        crate::input::list_domain_names_input::Builder::default()
    }
}

/// See [`ListFunctionsInput`](crate::input::ListFunctionsInput)
pub mod list_functions_input {
    /// A builder for [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFunctionsInput`](crate::input::ListFunctionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFunctionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFunctionsInput {
                api_id: self.api_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListFunctionsInputOperationOutputAlias = crate::operation::ListFunctions;
#[doc(hidden)]
pub type ListFunctionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListFunctionsInput {
    /// Consumes the builder and constructs an Operation<[`ListFunctions`](crate::operation::ListFunctions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFunctions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFunctionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.api_id;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_48, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/functions", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListFunctionsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_49));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFunctionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFunctions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFunctions",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    pub fn builder() -> crate::input::list_functions_input::Builder {
        crate::input::list_functions_input::Builder::default()
    }
}

/// See [`ListGraphqlApisInput`](crate::input::ListGraphqlApisInput)
pub mod list_graphql_apis_input {
    /// A builder for [`ListGraphqlApisInput`](crate::input::ListGraphqlApisInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGraphqlApisInput`](crate::input::ListGraphqlApisInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGraphqlApisInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGraphqlApisInput {
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListGraphqlApisInputOperationOutputAlias = crate::operation::ListGraphqlApis;
#[doc(hidden)]
pub type ListGraphqlApisInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGraphqlApisInput {
    /// Consumes the builder and constructs an Operation<[`ListGraphqlApis`](crate::operation::ListGraphqlApis)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGraphqlApis,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGraphqlApisInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v1/apis").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListGraphqlApisInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_50) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_50));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGraphqlApisInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGraphqlApis::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGraphqlApis",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGraphqlApisInput`](crate::input::ListGraphqlApisInput)
    pub fn builder() -> crate::input::list_graphql_apis_input::Builder {
        crate::input::list_graphql_apis_input::Builder::default()
    }
}

/// See [`ListResolversInput`](crate::input::ListResolversInput)
pub mod list_resolvers_input {
    /// A builder for [`ListResolversInput`](crate::input::ListResolversInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolversInput`](crate::input::ListResolversInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolversInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolversInput {
                api_id: self.api_id,
                type_name: self.type_name,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolversInputOperationOutputAlias = crate::operation::ListResolvers;
#[doc(hidden)]
pub type ListResolversInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResolversInput {
    /// Consumes the builder and constructs an Operation<[`ListResolvers`](crate::operation::ListResolvers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolvers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListResolversInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.api_id;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_51, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_52 = &_input.type_name;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_52, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}/resolvers",
                    apiId = api_id,
                    typeName = type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListResolversInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_53) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_53));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListResolversInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolvers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolvers",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListResolversInput`](crate::input::ListResolversInput)
    pub fn builder() -> crate::input::list_resolvers_input::Builder {
        crate::input::list_resolvers_input::Builder::default()
    }
}

/// See [`ListResolversByFunctionInput`](crate::input::ListResolversByFunctionInput)
pub mod list_resolvers_by_function_input {
    /// A builder for [`ListResolversByFunctionInput`](crate::input::ListResolversByFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) function_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The function ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_id = Some(input.into());
            self
        }
        /// <p>The function ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_id = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResolversByFunctionInput`](crate::input::ListResolversByFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResolversByFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResolversByFunctionInput {
                api_id: self.api_id,
                function_id: self.function_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListResolversByFunctionInputOperationOutputAlias =
    crate::operation::ListResolversByFunction;
#[doc(hidden)]
pub type ListResolversByFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResolversByFunctionInput {
    /// Consumes the builder and constructs an Operation<[`ListResolversByFunction`](crate::operation::ListResolversByFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResolversByFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListResolversByFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_54 = &_input.api_id;
                let input_54 = input_54.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_54, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_55 = &_input.function_id;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_id = aws_smithy_http::label::fmt_string(input_55, false);
                if function_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/functions/{functionId}/resolvers",
                    apiId = api_id,
                    functionId = function_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListResolversByFunctionInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_56) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_56));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListResolversByFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResolversByFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResolversByFunction",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListResolversByFunctionInput`](crate::input::ListResolversByFunctionInput)
    pub fn builder() -> crate::input::list_resolvers_by_function_input::Builder {
        crate::input::list_resolvers_by_function_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_57 = &_input.resource_arn;
                let input_57 = input_57.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_57, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTypesInput`](crate::input::ListTypesInput)
pub mod list_types_input {
    /// A builder for [`ListTypesInput`](crate::input::ListTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::TypeDefinitionFormat>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTypesInput`](crate::input::ListTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListTypesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListTypesInput {
                api_id: self.api_id,
                format: self.format,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListTypesInputOperationOutputAlias = crate::operation::ListTypes;
#[doc(hidden)]
pub type ListTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListTypes`](crate::operation::ListTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.api_id;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_58, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/types", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTypesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_59) = &_input.format {
                    query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_59));
                }
                if let Some(inner_60) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_60));
                }
                if _input.max_results != 0 {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListTypes::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListTypes",
                    "appsync",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTypesInput`](crate::input::ListTypesInput)
    pub fn builder() -> crate::input::list_types_input::Builder {
        crate::input::list_types_input::Builder::default()
    }
}

/// See [`StartSchemaCreationInput`](crate::input::StartSchemaCreationInput)
pub mod start_schema_creation_input {
    /// A builder for [`StartSchemaCreationInput`](crate::input::StartSchemaCreationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The schema definition, in GraphQL schema language format.</p>
        pub fn definition(mut self, input: aws_smithy_types::Blob) -> Self {
            self.definition = Some(input);
            self
        }
        /// <p>The schema definition, in GraphQL schema language format.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.definition = input;
            self
        }
        /// Consumes the builder and constructs a [`StartSchemaCreationInput`](crate::input::StartSchemaCreationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartSchemaCreationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartSchemaCreationInput {
                api_id: self.api_id,
                definition: self.definition,
            })
        }
    }
}
#[doc(hidden)]
pub type StartSchemaCreationInputOperationOutputAlias = crate::operation::StartSchemaCreation;
#[doc(hidden)]
pub type StartSchemaCreationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartSchemaCreationInput {
    /// Consumes the builder and constructs an Operation<[`StartSchemaCreation`](crate::operation::StartSchemaCreation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartSchemaCreation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartSchemaCreationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_61 = &_input.api_id;
                let input_61 = input_61.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_61, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/schemacreation", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartSchemaCreationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_schema_creation(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartSchemaCreation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartSchemaCreation",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartSchemaCreationInput`](crate::input::StartSchemaCreationInput)
    pub fn builder() -> crate::input::start_schema_creation_input::Builder {
        crate::input::start_schema_creation_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A <code>TagMap</code> object.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A <code>TagMap</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_62 = &_input.resource_arn;
                let input_62 = input_62.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_62, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of <code>TagKey</code> objects.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of <code>TagKey</code> objects.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_63 = &_input.resource_arn;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_63, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_64) = &_input.tag_keys {
                    for inner_65 in inner_64 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_65));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApiCacheInput`](crate::input::UpdateApiCacheInput)
pub mod update_api_cache_input {
    /// A builder for [`UpdateApiCacheInput`](crate::input::UpdateApiCacheInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) ttl: std::option::Option<i64>,
        pub(crate) api_caching_behavior: std::option::Option<crate::model::ApiCachingBehavior>,
        pub(crate) r#type: std::option::Option<crate::model::ApiCacheType>,
    }
    impl Builder {
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn api_caching_behavior(mut self, input: crate::model::ApiCachingBehavior) -> Self {
            self.api_caching_behavior = Some(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn set_api_caching_behavior(
            mut self,
            input: std::option::Option<crate::model::ApiCachingBehavior>,
        ) -> Self {
            self.api_caching_behavior = input;
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ApiCacheType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ApiCacheType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiCacheInput`](crate::input::UpdateApiCacheInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApiCacheInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApiCacheInput {
                api_id: self.api_id,
                ttl: self.ttl.unwrap_or_default(),
                api_caching_behavior: self.api_caching_behavior,
                r#type: self.r#type,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApiCacheInputOperationOutputAlias = crate::operation::UpdateApiCache;
#[doc(hidden)]
pub type UpdateApiCacheInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApiCacheInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApiCache`](crate::operation::UpdateApiCache)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApiCache,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApiCacheInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_66 = &_input.api_id;
                let input_66 = input_66.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_66, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}/ApiCaches/update", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApiCacheInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_api_cache(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApiCache::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApiCache",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApiCacheInput`](crate::input::UpdateApiCacheInput)
    pub fn builder() -> crate::input::update_api_cache_input::Builder {
        crate::input::update_api_cache_input::Builder::default()
    }
}

/// See [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
pub mod update_api_key_input {
    /// A builder for [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The ID for the GraphQL API.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The ID for the GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The API key ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The API key ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>
        pub fn expires(mut self, input: i64) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>
        pub fn set_expires(mut self, input: std::option::Option<i64>) -> Self {
            self.expires = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApiKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApiKeyInput {
                api_id: self.api_id,
                id: self.id,
                description: self.description,
                expires: self.expires.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApiKeyInputOperationOutputAlias = crate::operation::UpdateApiKey;
#[doc(hidden)]
pub type UpdateApiKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApiKeyInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApiKey`](crate::operation::UpdateApiKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApiKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApiKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_67 = &_input.api_id;
                let input_67 = input_67.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_67, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_68 = &_input.id;
                let input_68 = input_68.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let id = aws_smithy_http::label::fmt_string(input_68, false);
                if id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/apikeys/{id}",
                    apiId = api_id,
                    id = id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApiKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_api_key(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApiKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApiKey",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
    pub fn builder() -> crate::input::update_api_key_input::Builder {
        crate::input::update_api_key_input::Builder::default()
    }
}

/// See [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
pub mod update_data_source_input {
    /// A builder for [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) dynamodb_config: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        pub(crate) lambda_config: std::option::Option<crate::model::LambdaDataSourceConfig>,
        pub(crate) elasticsearch_config:
            std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        pub(crate) open_search_service_config:
            std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        pub(crate) http_config: std::option::Option<crate::model::HttpDataSourceConfig>,
        pub(crate) relational_database_config:
            std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The new name for the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The new data source type.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The new data source type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The new service role Amazon Resource Name (ARN) for the data source.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The new service role Amazon Resource Name (ARN) for the data source.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>The new Amazon DynamoDB configuration.</p>
        pub fn dynamodb_config(mut self, input: crate::model::DynamodbDataSourceConfig) -> Self {
            self.dynamodb_config = Some(input);
            self
        }
        /// <p>The new Amazon DynamoDB configuration.</p>
        pub fn set_dynamodb_config(
            mut self,
            input: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        ) -> Self {
            self.dynamodb_config = input;
            self
        }
        /// <p>The new Lambda configuration.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaDataSourceConfig) -> Self {
            self.lambda_config = Some(input);
            self
        }
        /// <p>The new Lambda configuration.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaDataSourceConfig>,
        ) -> Self {
            self.lambda_config = input;
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <code>UpdateDataSourceRequest$openSearchServiceConfig</code> to update an OpenSearch data source.</p>
        pub fn elasticsearch_config(
            mut self,
            input: crate::model::ElasticsearchDataSourceConfig,
        ) -> Self {
            self.elasticsearch_config = Some(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <code>UpdateDataSourceRequest$openSearchServiceConfig</code> to update an OpenSearch data source.</p>
        pub fn set_elasticsearch_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        ) -> Self {
            self.elasticsearch_config = input;
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        pub fn open_search_service_config(
            mut self,
            input: crate::model::OpenSearchServiceDataSourceConfig,
        ) -> Self {
            self.open_search_service_config = Some(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        pub fn set_open_search_service_config(
            mut self,
            input: std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        ) -> Self {
            self.open_search_service_config = input;
            self
        }
        /// <p>The new HTTP endpoint configuration.</p>
        pub fn http_config(mut self, input: crate::model::HttpDataSourceConfig) -> Self {
            self.http_config = Some(input);
            self
        }
        /// <p>The new HTTP endpoint configuration.</p>
        pub fn set_http_config(
            mut self,
            input: std::option::Option<crate::model::HttpDataSourceConfig>,
        ) -> Self {
            self.http_config = input;
            self
        }
        /// <p>The new relational database configuration.</p>
        pub fn relational_database_config(
            mut self,
            input: crate::model::RelationalDatabaseDataSourceConfig,
        ) -> Self {
            self.relational_database_config = Some(input);
            self
        }
        /// <p>The new relational database configuration.</p>
        pub fn set_relational_database_config(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
        ) -> Self {
            self.relational_database_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDataSourceInput {
                api_id: self.api_id,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                service_role_arn: self.service_role_arn,
                dynamodb_config: self.dynamodb_config,
                lambda_config: self.lambda_config,
                elasticsearch_config: self.elasticsearch_config,
                open_search_service_config: self.open_search_service_config,
                http_config: self.http_config,
                relational_database_config: self.relational_database_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDataSourceInputOperationOutputAlias = crate::operation::UpdateDataSource;
#[doc(hidden)]
pub type UpdateDataSourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataSource`](crate::operation::UpdateDataSource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataSource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDataSourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_69 = &_input.api_id;
                let input_69 = input_69.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_69, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_70 = &_input.name;
                let input_70 = input_70.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let name = aws_smithy_http::label::fmt_string(input_70, false);
                if name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/datasources/{name}",
                    apiId = api_id,
                    name = name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDataSourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_data_source(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataSource",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    pub fn builder() -> crate::input::update_data_source_input::Builder {
        crate::input::update_data_source_input::Builder::default()
    }
}

/// See [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
pub mod update_domain_name_input {
    /// A builder for [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainNameInput {
                domain_name: self.domain_name,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainNameInputOperationOutputAlias = crate::operation::UpdateDomainName;
#[doc(hidden)]
pub type UpdateDomainNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainNameInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomainName`](crate::operation::UpdateDomainName)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomainName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDomainNameInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_71 = &_input.domain_name;
                let input_71 = input_71.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_71, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domainnames/{domainName}",
                    domainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDomainNameInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_domain_name(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomainName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomainName",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainNameInput`](crate::input::UpdateDomainNameInput)
    pub fn builder() -> crate::input::update_domain_name_input::Builder {
        crate::input::update_domain_name_input::Builder::default()
    }
}

/// See [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
pub mod update_function_input {
    /// A builder for [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) function_id: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) request_mapping_template: std::option::Option<std::string::String>,
        pub(crate) response_mapping_template: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) sync_config: std::option::Option<crate::model::SyncConfig>,
        pub(crate) max_batch_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The <code>Function</code> name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The function ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_id = Some(input.into());
            self
        }
        /// <p>The function ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_id = input;
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_mapping_template = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_mapping_template = input;
            self
        }
        /// <p>The <code>Function</code> request mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_mapping_template = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> request mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_mapping_template = input;
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.sync_config = Some(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.sync_config = input;
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.max_batch_size = Some(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_batch_size = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFunctionInput {
                api_id: self.api_id,
                name: self.name,
                description: self.description,
                function_id: self.function_id,
                data_source_name: self.data_source_name,
                request_mapping_template: self.request_mapping_template,
                response_mapping_template: self.response_mapping_template,
                function_version: self.function_version,
                sync_config: self.sync_config,
                max_batch_size: self.max_batch_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFunctionInputOperationOutputAlias = crate::operation::UpdateFunction;
#[doc(hidden)]
pub type UpdateFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFunctionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFunction`](crate::operation::UpdateFunction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFunctionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_72 = &_input.api_id;
                let input_72 = input_72.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_72, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_73 = &_input.function_id;
                let input_73 = input_73.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let function_id = aws_smithy_http::label::fmt_string(input_73, false);
                if function_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "function_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/functions/{functionId}",
                    apiId = api_id,
                    functionId = function_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFunctionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_function(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFunction",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
    pub fn builder() -> crate::input::update_function_input::Builder {
        crate::input::update_function_input::Builder::default()
    }
}

/// See [`UpdateGraphqlApiInput`](crate::input::UpdateGraphqlApiInput)
pub mod update_graphql_api_input {
    /// A builder for [`UpdateGraphqlApiInput`](crate::input::UpdateGraphqlApiInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) log_config: std::option::Option<crate::model::LogConfig>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) user_pool_config: std::option::Option<crate::model::UserPoolConfig>,
        pub(crate) open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
        pub(crate) additional_authentication_providers:
            std::option::Option<std::vec::Vec<crate::model::AdditionalAuthenticationProvider>>,
        pub(crate) xray_enabled: std::option::Option<bool>,
        pub(crate) lambda_authorizer_config:
            std::option::Option<crate::model::LambdaAuthorizerConfig>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The new name for the <code>GraphqlApi</code> object.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The new name for the <code>GraphqlApi</code> object.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
        pub fn log_config(mut self, input: crate::model::LogConfig) -> Self {
            self.log_config = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogConfig>,
        ) -> Self {
            self.log_config = input;
            self
        }
        /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>
        pub fn user_pool_config(mut self, input: crate::model::UserPoolConfig) -> Self {
            self.user_pool_config = Some(input);
            self
        }
        /// <p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::UserPoolConfig>,
        ) -> Self {
            self.user_pool_config = input;
            self
        }
        /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
        pub fn open_id_connect_config(mut self, input: crate::model::OpenIdConnectConfig) -> Self {
            self.open_id_connect_config = Some(input);
            self
        }
        /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.open_id_connect_config = input;
            self
        }
        /// Appends an item to `additional_authentication_providers`.
        ///
        /// To override the contents of this collection use [`set_additional_authentication_providers`](Self::set_additional_authentication_providers).
        ///
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn additional_authentication_providers(
            mut self,
            input: crate::model::AdditionalAuthenticationProvider,
        ) -> Self {
            let mut v = self.additional_authentication_providers.unwrap_or_default();
            v.push(input);
            self.additional_authentication_providers = Some(v);
            self
        }
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn set_additional_authentication_providers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalAuthenticationProvider>,
            >,
        ) -> Self {
            self.additional_authentication_providers = input;
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn xray_enabled(mut self, input: bool) -> Self {
            self.xray_enabled = Some(input);
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn set_xray_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.xray_enabled = input;
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            input: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.lambda_authorizer_config = Some(input);
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.lambda_authorizer_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGraphqlApiInput`](crate::input::UpdateGraphqlApiInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGraphqlApiInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGraphqlApiInput {
                api_id: self.api_id,
                name: self.name,
                log_config: self.log_config,
                authentication_type: self.authentication_type,
                user_pool_config: self.user_pool_config,
                open_id_connect_config: self.open_id_connect_config,
                additional_authentication_providers: self.additional_authentication_providers,
                xray_enabled: self.xray_enabled.unwrap_or_default(),
                lambda_authorizer_config: self.lambda_authorizer_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGraphqlApiInputOperationOutputAlias = crate::operation::UpdateGraphqlApi;
#[doc(hidden)]
pub type UpdateGraphqlApiInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGraphqlApiInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGraphqlApi`](crate::operation::UpdateGraphqlApi)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGraphqlApi,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateGraphqlApiInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_74 = &_input.api_id;
                let input_74 = input_74.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_74, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v1/apis/{apiId}", apiId = api_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateGraphqlApiInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_graphql_api(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGraphqlApi::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGraphqlApi",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateGraphqlApiInput`](crate::input::UpdateGraphqlApiInput)
    pub fn builder() -> crate::input::update_graphql_api_input::Builder {
        crate::input::update_graphql_api_input::Builder::default()
    }
}

/// See [`UpdateResolverInput`](crate::input::UpdateResolverInput)
pub mod update_resolver_input {
    /// A builder for [`UpdateResolverInput`](crate::input::UpdateResolverInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) field_name: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) request_mapping_template: std::option::Option<std::string::String>,
        pub(crate) response_mapping_template: std::option::Option<std::string::String>,
        pub(crate) kind: std::option::Option<crate::model::ResolverKind>,
        pub(crate) pipeline_config: std::option::Option<crate::model::PipelineConfig>,
        pub(crate) sync_config: std::option::Option<crate::model::SyncConfig>,
        pub(crate) caching_config: std::option::Option<crate::model::CachingConfig>,
        pub(crate) max_batch_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The new type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The new type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The new field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The new field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// <p>The new data source name.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>The new data source name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The new request mapping template.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_mapping_template = Some(input.into());
            self
        }
        /// <p>The new request mapping template.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_mapping_template = input;
            self
        }
        /// <p>The new response mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_mapping_template = Some(input.into());
            self
        }
        /// <p>The new response mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_mapping_template = input;
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::ResolverKind) -> Self {
            self.kind = Some(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::ResolverKind>) -> Self {
            self.kind = input;
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn pipeline_config(mut self, input: crate::model::PipelineConfig) -> Self {
            self.pipeline_config = Some(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn set_pipeline_config(
            mut self,
            input: std::option::Option<crate::model::PipelineConfig>,
        ) -> Self {
            self.pipeline_config = input;
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.sync_config = Some(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.sync_config = input;
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn caching_config(mut self, input: crate::model::CachingConfig) -> Self {
            self.caching_config = Some(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn set_caching_config(
            mut self,
            input: std::option::Option<crate::model::CachingConfig>,
        ) -> Self {
            self.caching_config = input;
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.max_batch_size = Some(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_batch_size = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResolverInput`](crate::input::UpdateResolverInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateResolverInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateResolverInput {
                api_id: self.api_id,
                type_name: self.type_name,
                field_name: self.field_name,
                data_source_name: self.data_source_name,
                request_mapping_template: self.request_mapping_template,
                response_mapping_template: self.response_mapping_template,
                kind: self.kind,
                pipeline_config: self.pipeline_config,
                sync_config: self.sync_config,
                caching_config: self.caching_config,
                max_batch_size: self.max_batch_size.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateResolverInputOperationOutputAlias = crate::operation::UpdateResolver;
#[doc(hidden)]
pub type UpdateResolverInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateResolverInput {
    /// Consumes the builder and constructs an Operation<[`UpdateResolver`](crate::operation::UpdateResolver)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateResolver,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateResolverInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_75 = &_input.api_id;
                let input_75 = input_75.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_75, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_76 = &_input.type_name;
                let input_76 = input_76.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_76, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_77 = &_input.field_name;
                let input_77 = input_77.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "field_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let field_name = aws_smithy_http::label::fmt_string(input_77, false);
                if field_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "field_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}",
                    apiId = api_id,
                    typeName = type_name,
                    fieldName = field_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateResolverInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_resolver(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateResolver::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateResolver",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateResolverInput`](crate::input::UpdateResolverInput)
    pub fn builder() -> crate::input::update_resolver_input::Builder {
        crate::input::update_resolver_input::Builder::default()
    }
}

/// See [`UpdateTypeInput`](crate::input::UpdateTypeInput)
pub mod update_type_input {
    /// A builder for [`UpdateTypeInput`](crate::input::UpdateTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::TypeDefinitionFormat>,
    }
    impl Builder {
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The new type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The new type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The new definition.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The new definition.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The new type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The new type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTypeInput`](crate::input::UpdateTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTypeInput {
                api_id: self.api_id,
                type_name: self.type_name,
                definition: self.definition,
                format: self.format,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTypeInputOperationOutputAlias = crate::operation::UpdateType;
#[doc(hidden)]
pub type UpdateTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTypeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateType`](crate::operation::UpdateType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_78 = &_input.api_id;
                let input_78 = input_78.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let api_id = aws_smithy_http::label::fmt_string(input_78, false);
                if api_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "api_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_79 = &_input.type_name;
                let input_79 = input_79.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let type_name = aws_smithy_http::label::fmt_string(input_79, false);
                if type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v1/apis/{apiId}/types/{typeName}",
                    apiId = api_id,
                    typeName = type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_type(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateType",
            "appsync",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateTypeInput`](crate::input::UpdateTypeInput)
    pub fn builder() -> crate::input::update_type_input::Builder {
        crate::input::update_type_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTypeInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The new type name.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The new definition.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The new type format: SDL or JSON.</p>
    pub format: std::option::Option<crate::model::TypeDefinitionFormat>,
}
impl UpdateTypeInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The new type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The new definition.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The new type format: SDL or JSON.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::TypeDefinitionFormat> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for UpdateTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTypeInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("definition", &self.definition);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResolverInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The new type name.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The new field name.</p>
    pub field_name: std::option::Option<std::string::String>,
    /// <p>The new data source name.</p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The new request mapping template.</p>
    /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
    /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
    pub request_mapping_template: std::option::Option<std::string::String>,
    /// <p>The new response mapping template.</p>
    pub response_mapping_template: std::option::Option<std::string::String>,
    /// <p>The resolver type.</p>
    /// <ul>
    /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
    /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
    /// </ul>
    pub kind: std::option::Option<crate::model::ResolverKind>,
    /// <p>The <code>PipelineConfig</code>.</p>
    pub pipeline_config: std::option::Option<crate::model::PipelineConfig>,
    /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
    pub sync_config: std::option::Option<crate::model::SyncConfig>,
    /// <p>The caching configuration for the resolver.</p>
    pub caching_config: std::option::Option<crate::model::CachingConfig>,
    /// <p>The maximum batching size for a resolver.</p>
    pub max_batch_size: i32,
}
impl UpdateResolverInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The new type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The new field name.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
    /// <p>The new data source name.</p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The new request mapping template.</p>
    /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
    /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
    pub fn request_mapping_template(&self) -> std::option::Option<&str> {
        self.request_mapping_template.as_deref()
    }
    /// <p>The new response mapping template.</p>
    pub fn response_mapping_template(&self) -> std::option::Option<&str> {
        self.response_mapping_template.as_deref()
    }
    /// <p>The resolver type.</p>
    /// <ul>
    /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
    /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
    /// </ul>
    pub fn kind(&self) -> std::option::Option<&crate::model::ResolverKind> {
        self.kind.as_ref()
    }
    /// <p>The <code>PipelineConfig</code>.</p>
    pub fn pipeline_config(&self) -> std::option::Option<&crate::model::PipelineConfig> {
        self.pipeline_config.as_ref()
    }
    /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
    pub fn sync_config(&self) -> std::option::Option<&crate::model::SyncConfig> {
        self.sync_config.as_ref()
    }
    /// <p>The caching configuration for the resolver.</p>
    pub fn caching_config(&self) -> std::option::Option<&crate::model::CachingConfig> {
        self.caching_config.as_ref()
    }
    /// <p>The maximum batching size for a resolver.</p>
    pub fn max_batch_size(&self) -> i32 {
        self.max_batch_size
    }
}
impl std::fmt::Debug for UpdateResolverInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResolverInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("field_name", &self.field_name);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("request_mapping_template", &self.request_mapping_template);
        formatter.field("response_mapping_template", &self.response_mapping_template);
        formatter.field("kind", &self.kind);
        formatter.field("pipeline_config", &self.pipeline_config);
        formatter.field("sync_config", &self.sync_config);
        formatter.field("caching_config", &self.caching_config);
        formatter.field("max_batch_size", &self.max_batch_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGraphqlApiInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The new name for the <code>GraphqlApi</code> object.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
    pub log_config: std::option::Option<crate::model::LogConfig>,
    /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>
    pub user_pool_config: std::option::Option<crate::model::UserPoolConfig>,
    /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
    pub open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
    /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
    pub additional_authentication_providers:
        std::option::Option<std::vec::Vec<crate::model::AdditionalAuthenticationProvider>>,
    /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
    pub xray_enabled: bool,
    /// <p>Configuration for Lambda function authorization.</p>
    pub lambda_authorizer_config: std::option::Option<crate::model::LambdaAuthorizerConfig>,
}
impl UpdateGraphqlApiInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The new name for the <code>GraphqlApi</code> object.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
    pub fn log_config(&self) -> std::option::Option<&crate::model::LogConfig> {
        self.log_config.as_ref()
    }
    /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>
    pub fn user_pool_config(&self) -> std::option::Option<&crate::model::UserPoolConfig> {
        self.user_pool_config.as_ref()
    }
    /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
    pub fn open_id_connect_config(
        &self,
    ) -> std::option::Option<&crate::model::OpenIdConnectConfig> {
        self.open_id_connect_config.as_ref()
    }
    /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
    pub fn additional_authentication_providers(
        &self,
    ) -> std::option::Option<&[crate::model::AdditionalAuthenticationProvider]> {
        self.additional_authentication_providers.as_deref()
    }
    /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
    pub fn xray_enabled(&self) -> bool {
        self.xray_enabled
    }
    /// <p>Configuration for Lambda function authorization.</p>
    pub fn lambda_authorizer_config(
        &self,
    ) -> std::option::Option<&crate::model::LambdaAuthorizerConfig> {
        self.lambda_authorizer_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateGraphqlApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGraphqlApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("name", &self.name);
        formatter.field("log_config", &self.log_config);
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("user_pool_config", &self.user_pool_config);
        formatter.field("open_id_connect_config", &self.open_id_connect_config);
        formatter.field(
            "additional_authentication_providers",
            &self.additional_authentication_providers,
        );
        formatter.field("xray_enabled", &self.xray_enabled);
        formatter.field("lambda_authorizer_config", &self.lambda_authorizer_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The function ID.</p>
    pub function_id: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
    pub request_mapping_template: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> request mapping template.</p>
    pub response_mapping_template: std::option::Option<std::string::String>,
    /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>Describes a Sync configuration for a resolver.</p>
    /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
    pub sync_config: std::option::Option<crate::model::SyncConfig>,
    /// <p>The maximum batching size for a resolver.</p>
    pub max_batch_size: i32,
}
impl UpdateFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The <code>Function</code> name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The <code>Function</code> description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The function ID.</p>
    pub fn function_id(&self) -> std::option::Option<&str> {
        self.function_id.as_deref()
    }
    /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
    pub fn request_mapping_template(&self) -> std::option::Option<&str> {
        self.request_mapping_template.as_deref()
    }
    /// <p>The <code>Function</code> request mapping template.</p>
    pub fn response_mapping_template(&self) -> std::option::Option<&str> {
        self.response_mapping_template.as_deref()
    }
    /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>Describes a Sync configuration for a resolver.</p>
    /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
    pub fn sync_config(&self) -> std::option::Option<&crate::model::SyncConfig> {
        self.sync_config.as_ref()
    }
    /// <p>The maximum batching size for a resolver.</p>
    pub fn max_batch_size(&self) -> i32 {
        self.max_batch_size
    }
}
impl std::fmt::Debug for UpdateFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFunctionInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("function_id", &self.function_id);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("request_mapping_template", &self.request_mapping_template);
        formatter.field("response_mapping_template", &self.response_mapping_template);
        formatter.field("function_version", &self.function_version);
        formatter.field("sync_config", &self.sync_config);
        formatter.field("max_batch_size", &self.max_batch_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A description of the <code>DomainName</code>.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A description of the <code>DomainName</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSourceInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The new name for the data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The new description for the data source.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The new data source type.</p>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The new service role Amazon Resource Name (ARN) for the data source.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>The new Amazon DynamoDB configuration.</p>
    pub dynamodb_config: std::option::Option<crate::model::DynamodbDataSourceConfig>,
    /// <p>The new Lambda configuration.</p>
    pub lambda_config: std::option::Option<crate::model::LambdaDataSourceConfig>,
    /// <p>The new OpenSearch configuration.</p>
    /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <code>UpdateDataSourceRequest$openSearchServiceConfig</code> to update an OpenSearch data source.</p>
    pub elasticsearch_config: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
    /// <p>The new OpenSearch configuration.</p>
    pub open_search_service_config:
        std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
    /// <p>The new HTTP endpoint configuration.</p>
    pub http_config: std::option::Option<crate::model::HttpDataSourceConfig>,
    /// <p>The new relational database configuration.</p>
    pub relational_database_config:
        std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
}
impl UpdateDataSourceInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The new name for the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The new description for the data source.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The new data source type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The new service role Amazon Resource Name (ARN) for the data source.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>The new Amazon DynamoDB configuration.</p>
    pub fn dynamodb_config(&self) -> std::option::Option<&crate::model::DynamodbDataSourceConfig> {
        self.dynamodb_config.as_ref()
    }
    /// <p>The new Lambda configuration.</p>
    pub fn lambda_config(&self) -> std::option::Option<&crate::model::LambdaDataSourceConfig> {
        self.lambda_config.as_ref()
    }
    /// <p>The new OpenSearch configuration.</p>
    /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <code>UpdateDataSourceRequest$openSearchServiceConfig</code> to update an OpenSearch data source.</p>
    pub fn elasticsearch_config(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchDataSourceConfig> {
        self.elasticsearch_config.as_ref()
    }
    /// <p>The new OpenSearch configuration.</p>
    pub fn open_search_service_config(
        &self,
    ) -> std::option::Option<&crate::model::OpenSearchServiceDataSourceConfig> {
        self.open_search_service_config.as_ref()
    }
    /// <p>The new HTTP endpoint configuration.</p>
    pub fn http_config(&self) -> std::option::Option<&crate::model::HttpDataSourceConfig> {
        self.http_config.as_ref()
    }
    /// <p>The new relational database configuration.</p>
    pub fn relational_database_config(
        &self,
    ) -> std::option::Option<&crate::model::RelationalDatabaseDataSourceConfig> {
        self.relational_database_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSourceInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("dynamodb_config", &self.dynamodb_config);
        formatter.field("lambda_config", &self.lambda_config);
        formatter.field("elasticsearch_config", &self.elasticsearch_config);
        formatter.field(
            "open_search_service_config",
            &self.open_search_service_config,
        );
        formatter.field("http_config", &self.http_config);
        formatter.field(
            "relational_database_config",
            &self.relational_database_config,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiKeyInput {
    /// <p>The ID for the GraphQL API.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The API key ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A description of the purpose of the API key.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>
    pub expires: i64,
}
impl UpdateApiKeyInput {
    /// <p>The ID for the GraphQL API.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The API key ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A description of the purpose of the API key.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>
    pub fn expires(&self) -> i64 {
        self.expires
    }
}
impl std::fmt::Debug for UpdateApiKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiKeyInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("expires", &self.expires);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>UpdateApiCache</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApiCacheInput {
    /// <p>The GraphQL API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>TTL in seconds for cache entries.</p>
    /// <p>Valid values are 1–3,600 seconds.</p>
    pub ttl: i64,
    /// <p>Caching behavior.</p>
    /// <ul>
    /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
    /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
    /// </ul>
    pub api_caching_behavior: std::option::Option<crate::model::ApiCachingBehavior>,
    /// <p>The cache instance type. Valid values are </p>
    /// <ul>
    /// <li> <p> <code>SMALL</code> </p> </li>
    /// <li> <p> <code>MEDIUM</code> </p> </li>
    /// <li> <p> <code>LARGE</code> </p> </li>
    /// <li> <p> <code>XLARGE</code> </p> </li>
    /// <li> <p> <code>LARGE_2X</code> </p> </li>
    /// <li> <p> <code>LARGE_4X</code> </p> </li>
    /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
    /// <li> <p> <code>LARGE_12X</code> </p> </li>
    /// </ul>
    /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
    /// <p>The following legacy instance types are available, but their use is discouraged:</p>
    /// <ul>
    /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
    /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
    /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
    /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ApiCacheType>,
}
impl UpdateApiCacheInput {
    /// <p>The GraphQL API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>TTL in seconds for cache entries.</p>
    /// <p>Valid values are 1–3,600 seconds.</p>
    pub fn ttl(&self) -> i64 {
        self.ttl
    }
    /// <p>Caching behavior.</p>
    /// <ul>
    /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
    /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
    /// </ul>
    pub fn api_caching_behavior(&self) -> std::option::Option<&crate::model::ApiCachingBehavior> {
        self.api_caching_behavior.as_ref()
    }
    /// <p>The cache instance type. Valid values are </p>
    /// <ul>
    /// <li> <p> <code>SMALL</code> </p> </li>
    /// <li> <p> <code>MEDIUM</code> </p> </li>
    /// <li> <p> <code>LARGE</code> </p> </li>
    /// <li> <p> <code>XLARGE</code> </p> </li>
    /// <li> <p> <code>LARGE_2X</code> </p> </li>
    /// <li> <p> <code>LARGE_4X</code> </p> </li>
    /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
    /// <li> <p> <code>LARGE_12X</code> </p> </li>
    /// </ul>
    /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
    /// <p>The following legacy instance types are available, but their use is discouraged:</p>
    /// <ul>
    /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
    /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
    /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
    /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ApiCacheType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UpdateApiCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApiCacheInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("ttl", &self.ttl);
        formatter.field("api_caching_behavior", &self.api_caching_behavior);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of <code>TagKey</code> objects.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of <code>TagKey</code> objects.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A <code>TagMap</code> object.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A <code>TagMap</code> object.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartSchemaCreationInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The schema definition, in GraphQL schema language format.</p>
    pub definition: std::option::Option<aws_smithy_types::Blob>,
}
impl StartSchemaCreationInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The schema definition, in GraphQL schema language format.</p>
    pub fn definition(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.definition.as_ref()
    }
}
impl std::fmt::Debug for StartSchemaCreationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartSchemaCreationInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("definition", &self.definition);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTypesInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The type format: SDL or JSON.</p>
    pub format: std::option::Option<crate::model::TypeDefinitionFormat>,
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListTypesInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The type format: SDL or JSON.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::TypeDefinitionFormat> {
        self.format.as_ref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTypesInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("format", &self.format);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolversByFunctionInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The function ID.</p>
    pub function_id: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListResolversByFunctionInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The function ID.</p>
    pub fn function_id(&self) -> std::option::Option<&str> {
        self.function_id.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListResolversByFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolversByFunctionInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("function_id", &self.function_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResolversInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The type name.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListResolversInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListResolversInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResolversInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGraphqlApisInput {
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListGraphqlApisInput {
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListGraphqlApisInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGraphqlApisInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFunctionsInput {
    /// <p>The GraphQL API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListFunctionsInput {
    /// <p>The GraphQL API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListFunctionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFunctionsInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainNamesInput {
    /// <p>The API token.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListDomainNamesInput {
    /// <p>The API token.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListDomainNamesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainNamesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDataSourcesInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListDataSourcesInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListDataSourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDataSourcesInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApiKeysInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that you want the request to return.</p>
    pub max_results: i32,
}
impl ListApiKeysInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that you want the request to return.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
}
impl std::fmt::Debug for ListApiKeysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApiKeysInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTypeInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The type name.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The type format: SDL or JSON.</p>
    pub format: std::option::Option<crate::model::TypeDefinitionFormat>,
}
impl GetTypeInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The type format: SDL or JSON.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::TypeDefinitionFormat> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for GetTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTypeInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSchemaCreationStatusInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl GetSchemaCreationStatusInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for GetSchemaCreationStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSchemaCreationStatusInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResolverInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The resolver type name.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The resolver field name.</p>
    pub field_name: std::option::Option<std::string::String>,
}
impl GetResolverInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The resolver type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The resolver field name.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
}
impl std::fmt::Debug for GetResolverInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResolverInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("field_name", &self.field_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntrospectionSchemaInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The schema format: SDL or JSON.</p>
    pub format: std::option::Option<crate::model::OutputType>,
    /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
    pub include_directives: std::option::Option<bool>,
}
impl GetIntrospectionSchemaInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The schema format: SDL or JSON.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::OutputType> {
        self.format.as_ref()
    }
    /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
    pub fn include_directives(&self) -> std::option::Option<bool> {
        self.include_directives
    }
}
impl std::fmt::Debug for GetIntrospectionSchemaInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntrospectionSchemaInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("format", &self.format);
        formatter.field("include_directives", &self.include_directives);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGraphqlApiInput {
    /// <p>The API ID for the GraphQL API.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl GetGraphqlApiInput {
    /// <p>The API ID for the GraphQL API.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for GetGraphqlApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGraphqlApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> ID.</p>
    pub function_id: std::option::Option<std::string::String>,
}
impl GetFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The <code>Function</code> ID.</p>
    pub fn function_id(&self) -> std::option::Option<&str> {
        self.function_id.as_deref()
    }
}
impl std::fmt::Debug for GetFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFunctionInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("function_id", &self.function_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataSourceInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The name of the data source.</p>
    pub name: std::option::Option<std::string::String>,
}
impl GetDataSourceInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The name of the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for GetDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataSourceInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>GetApiCache</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiCacheInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl GetApiCacheInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for GetApiCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiCacheInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApiAssociationInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetApiAssociationInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetApiAssociationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApiAssociationInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>FlushApiCache</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlushApiCacheInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl FlushApiCacheInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for FlushApiCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlushApiCacheInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateApiInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DisassociateApiInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DisassociateApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateApiInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTypeInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The type name.</p>
    pub type_name: std::option::Option<std::string::String>,
}
impl DeleteTypeInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTypeInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResolverInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The name of the resolver type.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The resolver field name.</p>
    pub field_name: std::option::Option<std::string::String>,
}
impl DeleteResolverInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The name of the resolver type.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The resolver field name.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteResolverInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResolverInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("field_name", &self.field_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGraphqlApiInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl DeleteGraphqlApiInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteGraphqlApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGraphqlApiInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> ID.</p>
    pub function_id: std::option::Option<std::string::String>,
}
impl DeleteFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The <code>Function</code> ID.</p>
    pub fn function_id(&self) -> std::option::Option<&str> {
        self.function_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFunctionInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("function_id", &self.function_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSourceInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The name of the data source.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteDataSourceInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The name of the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSourceInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiKeyInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The ID for the API key.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteApiKeyInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The ID for the API key.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApiKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiKeyInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>DeleteApiCache</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApiCacheInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl DeleteApiCacheInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApiCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApiCacheInput");
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTypeInput {
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
    /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The type format: SDL or JSON.</p>
    pub format: std::option::Option<crate::model::TypeDefinitionFormat>,
}
impl CreateTypeInput {
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
    /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The type format: SDL or JSON.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::TypeDefinitionFormat> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for CreateTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTypeInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("definition", &self.definition);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateResolverInput {
    /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The name of the <code>Type</code>.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The name of the field to attach the resolver to.</p>
    pub field_name: std::option::Option<std::string::String>,
    /// <p>The name of the data source for which the resolver is being created.</p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The mapping template to use for requests.</p>
    /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
    /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
    pub request_mapping_template: std::option::Option<std::string::String>,
    /// <p>The mapping template to use for responses from the data source.</p>
    pub response_mapping_template: std::option::Option<std::string::String>,
    /// <p>The resolver type.</p>
    /// <ul>
    /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
    /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
    /// </ul>
    pub kind: std::option::Option<crate::model::ResolverKind>,
    /// <p>The <code>PipelineConfig</code>.</p>
    pub pipeline_config: std::option::Option<crate::model::PipelineConfig>,
    /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
    pub sync_config: std::option::Option<crate::model::SyncConfig>,
    /// <p>The caching configuration for the resolver.</p>
    pub caching_config: std::option::Option<crate::model::CachingConfig>,
    /// <p>The maximum batching size for a resolver.</p>
    pub max_batch_size: i32,
}
impl CreateResolverInput {
    /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The name of the <code>Type</code>.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The name of the field to attach the resolver to.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
    /// <p>The name of the data source for which the resolver is being created.</p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The mapping template to use for requests.</p>
    /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
    /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
    pub fn request_mapping_template(&self) -> std::option::Option<&str> {
        self.request_mapping_template.as_deref()
    }
    /// <p>The mapping template to use for responses from the data source.</p>
    pub fn response_mapping_template(&self) -> std::option::Option<&str> {
        self.response_mapping_template.as_deref()
    }
    /// <p>The resolver type.</p>
    /// <ul>
    /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
    /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
    /// </ul>
    pub fn kind(&self) -> std::option::Option<&crate::model::ResolverKind> {
        self.kind.as_ref()
    }
    /// <p>The <code>PipelineConfig</code>.</p>
    pub fn pipeline_config(&self) -> std::option::Option<&crate::model::PipelineConfig> {
        self.pipeline_config.as_ref()
    }
    /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
    pub fn sync_config(&self) -> std::option::Option<&crate::model::SyncConfig> {
        self.sync_config.as_ref()
    }
    /// <p>The caching configuration for the resolver.</p>
    pub fn caching_config(&self) -> std::option::Option<&crate::model::CachingConfig> {
        self.caching_config.as_ref()
    }
    /// <p>The maximum batching size for a resolver.</p>
    pub fn max_batch_size(&self) -> i32 {
        self.max_batch_size
    }
}
impl std::fmt::Debug for CreateResolverInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateResolverInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("type_name", &self.type_name);
        formatter.field("field_name", &self.field_name);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("request_mapping_template", &self.request_mapping_template);
        formatter.field("response_mapping_template", &self.response_mapping_template);
        formatter.field("kind", &self.kind);
        formatter.field("pipeline_config", &self.pipeline_config);
        formatter.field("sync_config", &self.sync_config);
        formatter.field("caching_config", &self.caching_config);
        formatter.field("max_batch_size", &self.max_batch_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGraphqlApiInput {
    /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon CloudWatch Logs configuration.</p>
    pub log_config: std::option::Option<crate::model::LogConfig>,
    /// <p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The Amazon Cognito user pool configuration.</p>
    pub user_pool_config: std::option::Option<crate::model::UserPoolConfig>,
    /// <p>The OIDC configuration.</p>
    pub open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
    /// <p>A <code>TagMap</code> object.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
    pub additional_authentication_providers:
        std::option::Option<std::vec::Vec<crate::model::AdditionalAuthenticationProvider>>,
    /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
    pub xray_enabled: bool,
    /// <p>Configuration for Lambda function authorization.</p>
    pub lambda_authorizer_config: std::option::Option<crate::model::LambdaAuthorizerConfig>,
}
impl CreateGraphqlApiInput {
    /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon CloudWatch Logs configuration.</p>
    pub fn log_config(&self) -> std::option::Option<&crate::model::LogConfig> {
        self.log_config.as_ref()
    }
    /// <p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The Amazon Cognito user pool configuration.</p>
    pub fn user_pool_config(&self) -> std::option::Option<&crate::model::UserPoolConfig> {
        self.user_pool_config.as_ref()
    }
    /// <p>The OIDC configuration.</p>
    pub fn open_id_connect_config(
        &self,
    ) -> std::option::Option<&crate::model::OpenIdConnectConfig> {
        self.open_id_connect_config.as_ref()
    }
    /// <p>A <code>TagMap</code> object.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
    pub fn additional_authentication_providers(
        &self,
    ) -> std::option::Option<&[crate::model::AdditionalAuthenticationProvider]> {
        self.additional_authentication_providers.as_deref()
    }
    /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
    pub fn xray_enabled(&self) -> bool {
        self.xray_enabled
    }
    /// <p>Configuration for Lambda function authorization.</p>
    pub fn lambda_authorizer_config(
        &self,
    ) -> std::option::Option<&crate::model::LambdaAuthorizerConfig> {
        self.lambda_authorizer_config.as_ref()
    }
}
impl std::fmt::Debug for CreateGraphqlApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGraphqlApiInput");
        formatter.field("name", &self.name);
        formatter.field("log_config", &self.log_config);
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("user_pool_config", &self.user_pool_config);
        formatter.field("open_id_connect_config", &self.open_id_connect_config);
        formatter.field("tags", &self.tags);
        formatter.field(
            "additional_authentication_providers",
            &self.additional_authentication_providers,
        );
        formatter.field("xray_enabled", &self.xray_enabled);
        formatter.field("lambda_authorizer_config", &self.lambda_authorizer_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
    pub request_mapping_template: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> response mapping template.</p>
    pub response_mapping_template: std::option::Option<std::string::String>,
    /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>Describes a Sync configuration for a resolver.</p>
    /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
    pub sync_config: std::option::Option<crate::model::SyncConfig>,
    /// <p>The maximum batching size for a resolver.</p>
    pub max_batch_size: i32,
}
impl CreateFunctionInput {
    /// <p>The GraphQL API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The <code>Function</code> description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
    pub fn request_mapping_template(&self) -> std::option::Option<&str> {
        self.request_mapping_template.as_deref()
    }
    /// <p>The <code>Function</code> response mapping template.</p>
    pub fn response_mapping_template(&self) -> std::option::Option<&str> {
        self.response_mapping_template.as_deref()
    }
    /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>Describes a Sync configuration for a resolver.</p>
    /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
    pub fn sync_config(&self) -> std::option::Option<&crate::model::SyncConfig> {
        self.sync_config.as_ref()
    }
    /// <p>The maximum batching size for a resolver.</p>
    pub fn max_batch_size(&self) -> i32 {
        self.max_batch_size
    }
}
impl std::fmt::Debug for CreateFunctionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFunctionInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("request_mapping_template", &self.request_mapping_template);
        formatter.field("response_mapping_template", &self.response_mapping_template);
        formatter.field("function_version", &self.function_version);
        formatter.field("sync_config", &self.sync_config);
        formatter.field("max_batch_size", &self.max_batch_size);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainNameInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>A description of the <code>DomainName</code>.</p>
    pub description: std::option::Option<std::string::String>,
}
impl CreateDomainNameInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>A description of the <code>DomainName</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for CreateDomainNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainNameInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceInput {
    /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name for the <code>DataSource</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A description of the <code>DataSource</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the <code>DataSource</code>.</p>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>Amazon DynamoDB settings.</p>
    pub dynamodb_config: std::option::Option<crate::model::DynamodbDataSourceConfig>,
    /// <p>Lambda settings.</p>
    pub lambda_config: std::option::Option<crate::model::LambdaDataSourceConfig>,
    /// <p>Amazon OpenSearch Service settings.</p>
    /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <code>CreateDataSourceRequest$openSearchServiceConfig</code> to create an OpenSearch data source.</p>
    pub elasticsearch_config: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
    /// <p>Amazon OpenSearch Service settings.</p>
    pub open_search_service_config:
        std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
    /// <p>HTTP endpoint settings.</p>
    pub http_config: std::option::Option<crate::model::HttpDataSourceConfig>,
    /// <p>Relational database settings.</p>
    pub relational_database_config:
        std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
}
impl CreateDataSourceInput {
    /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>A user-supplied name for the <code>DataSource</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A description of the <code>DataSource</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the <code>DataSource</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>Amazon DynamoDB settings.</p>
    pub fn dynamodb_config(&self) -> std::option::Option<&crate::model::DynamodbDataSourceConfig> {
        self.dynamodb_config.as_ref()
    }
    /// <p>Lambda settings.</p>
    pub fn lambda_config(&self) -> std::option::Option<&crate::model::LambdaDataSourceConfig> {
        self.lambda_config.as_ref()
    }
    /// <p>Amazon OpenSearch Service settings.</p>
    /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <code>CreateDataSourceRequest$openSearchServiceConfig</code> to create an OpenSearch data source.</p>
    pub fn elasticsearch_config(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchDataSourceConfig> {
        self.elasticsearch_config.as_ref()
    }
    /// <p>Amazon OpenSearch Service settings.</p>
    pub fn open_search_service_config(
        &self,
    ) -> std::option::Option<&crate::model::OpenSearchServiceDataSourceConfig> {
        self.open_search_service_config.as_ref()
    }
    /// <p>HTTP endpoint settings.</p>
    pub fn http_config(&self) -> std::option::Option<&crate::model::HttpDataSourceConfig> {
        self.http_config.as_ref()
    }
    /// <p>Relational database settings.</p>
    pub fn relational_database_config(
        &self,
    ) -> std::option::Option<&crate::model::RelationalDatabaseDataSourceConfig> {
        self.relational_database_config.as_ref()
    }
}
impl std::fmt::Debug for CreateDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("dynamodb_config", &self.dynamodb_config);
        formatter.field("lambda_config", &self.lambda_config);
        formatter.field("elasticsearch_config", &self.elasticsearch_config);
        formatter.field(
            "open_search_service_config",
            &self.open_search_service_config,
        );
        formatter.field("http_config", &self.http_config);
        formatter.field(
            "relational_database_config",
            &self.relational_database_config,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiKeyInput {
    /// <p>The ID for your GraphQL API.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>A description of the purpose of the API key.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>
    pub expires: i64,
}
impl CreateApiKeyInput {
    /// <p>The ID for your GraphQL API.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>A description of the purpose of the API key.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>
    pub fn expires(&self) -> i64 {
        self.expires
    }
}
impl std::fmt::Debug for CreateApiKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiKeyInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("description", &self.description);
        formatter.field("expires", &self.expires);
        formatter.finish()
    }
}

/// <p>Represents the input of a <code>CreateApiCache</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApiCacheInput {
    /// <p>The GraphQL API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>TTL in seconds for cache entries.</p>
    /// <p>Valid values are 1–3,600 seconds.</p>
    pub ttl: i64,
    /// <p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>
    pub transit_encryption_enabled: bool,
    /// <p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>
    pub at_rest_encryption_enabled: bool,
    /// <p>Caching behavior.</p>
    /// <ul>
    /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
    /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
    /// </ul>
    pub api_caching_behavior: std::option::Option<crate::model::ApiCachingBehavior>,
    /// <p>The cache instance type. Valid values are </p>
    /// <ul>
    /// <li> <p> <code>SMALL</code> </p> </li>
    /// <li> <p> <code>MEDIUM</code> </p> </li>
    /// <li> <p> <code>LARGE</code> </p> </li>
    /// <li> <p> <code>XLARGE</code> </p> </li>
    /// <li> <p> <code>LARGE_2X</code> </p> </li>
    /// <li> <p> <code>LARGE_4X</code> </p> </li>
    /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
    /// <li> <p> <code>LARGE_12X</code> </p> </li>
    /// </ul>
    /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
    /// <p>The following legacy instance types are available, but their use is discouraged:</p>
    /// <ul>
    /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
    /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
    /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
    /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ApiCacheType>,
}
impl CreateApiCacheInput {
    /// <p>The GraphQL API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>TTL in seconds for cache entries.</p>
    /// <p>Valid values are 1–3,600 seconds.</p>
    pub fn ttl(&self) -> i64 {
        self.ttl
    }
    /// <p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>
    pub fn transit_encryption_enabled(&self) -> bool {
        self.transit_encryption_enabled
    }
    /// <p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>
    pub fn at_rest_encryption_enabled(&self) -> bool {
        self.at_rest_encryption_enabled
    }
    /// <p>Caching behavior.</p>
    /// <ul>
    /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
    /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
    /// </ul>
    pub fn api_caching_behavior(&self) -> std::option::Option<&crate::model::ApiCachingBehavior> {
        self.api_caching_behavior.as_ref()
    }
    /// <p>The cache instance type. Valid values are </p>
    /// <ul>
    /// <li> <p> <code>SMALL</code> </p> </li>
    /// <li> <p> <code>MEDIUM</code> </p> </li>
    /// <li> <p> <code>LARGE</code> </p> </li>
    /// <li> <p> <code>XLARGE</code> </p> </li>
    /// <li> <p> <code>LARGE_2X</code> </p> </li>
    /// <li> <p> <code>LARGE_4X</code> </p> </li>
    /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
    /// <li> <p> <code>LARGE_12X</code> </p> </li>
    /// </ul>
    /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
    /// <p>The following legacy instance types are available, but their use is discouraged:</p>
    /// <ul>
    /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
    /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
    /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
    /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
    /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ApiCacheType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CreateApiCacheInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApiCacheInput");
        formatter.field("api_id", &self.api_id);
        formatter.field("ttl", &self.ttl);
        formatter.field(
            "transit_encryption_enabled",
            &self.transit_encryption_enabled,
        );
        formatter.field(
            "at_rest_encryption_enabled",
            &self.at_rest_encryption_enabled,
        );
        formatter.field("api_caching_behavior", &self.api_caching_behavior);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateApiInput {
    /// <p>The domain name.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
}
impl AssociateApiInput {
    /// <p>The domain name.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
}
impl std::fmt::Debug for AssociateApiInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateApiInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("api_id", &self.api_id);
        formatter.finish()
    }
}
