// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS AppSync
///
/// Client for invoking operations on AWS AppSync. Each operation on AWS AppSync is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appsync::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appsync::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appsync::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateApi`](crate::client::fluent_builders::AssociateApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::AssociateApi::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::AssociateApi::set_domain_name): <p>The domain name.</p>
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::AssociateApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::AssociateApi::set_api_id): <p>The API ID.</p>
    /// - On success, responds with [`AssociateApiOutput`](crate::output::AssociateApiOutput) with field(s):
    ///   - [`api_association(Option<ApiAssociation>)`](crate::output::AssociateApiOutput::api_association): <p>The <code>ApiAssociation</code> object.</p>
    /// - On failure, responds with [`SdkError<AssociateApiError>`](crate::error::AssociateApiError)
    pub fn associate_api(&self) -> fluent_builders::AssociateApi {
        fluent_builders::AssociateApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApiCache`](crate::client::fluent_builders::CreateApiCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateApiCache::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateApiCache::set_api_id): <p>The GraphQL API ID.</p>
    ///   - [`ttl(i64)`](crate::client::fluent_builders::CreateApiCache::ttl) / [`set_ttl(i64)`](crate::client::fluent_builders::CreateApiCache::set_ttl): <p>TTL in seconds for cache entries.</p>  <p>Valid values are 1–3,600 seconds.</p>
    ///   - [`transit_encryption_enabled(bool)`](crate::client::fluent_builders::CreateApiCache::transit_encryption_enabled) / [`set_transit_encryption_enabled(bool)`](crate::client::fluent_builders::CreateApiCache::set_transit_encryption_enabled): <p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>
    ///   - [`at_rest_encryption_enabled(bool)`](crate::client::fluent_builders::CreateApiCache::at_rest_encryption_enabled) / [`set_at_rest_encryption_enabled(bool)`](crate::client::fluent_builders::CreateApiCache::set_at_rest_encryption_enabled): <p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>
    ///   - [`api_caching_behavior(ApiCachingBehavior)`](crate::client::fluent_builders::CreateApiCache::api_caching_behavior) / [`set_api_caching_behavior(Option<ApiCachingBehavior>)`](crate::client::fluent_builders::CreateApiCache::set_api_caching_behavior): <p>Caching behavior.</p>  <ul>   <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>   <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>  </ul>
    ///   - [`r#type(ApiCacheType)`](crate::client::fluent_builders::CreateApiCache::type) / [`set_type(Option<ApiCacheType>)`](crate::client::fluent_builders::CreateApiCache::set_type): <p>The cache instance type. Valid values are </p>  <ul>   <li> <p> <code>SMALL</code> </p> </li>   <li> <p> <code>MEDIUM</code> </p> </li>   <li> <p> <code>LARGE</code> </p> </li>   <li> <p> <code>XLARGE</code> </p> </li>   <li> <p> <code>LARGE_2X</code> </p> </li>   <li> <p> <code>LARGE_4X</code> </p> </li>   <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>   <li> <p> <code>LARGE_12X</code> </p> </li>  </ul>  <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>  <p>The following legacy instance types are available, but their use is discouraged:</p>  <ul>   <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>   <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>   <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>   <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>   <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>   <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>   <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>  </ul>
    /// - On success, responds with [`CreateApiCacheOutput`](crate::output::CreateApiCacheOutput) with field(s):
    ///   - [`api_cache(Option<ApiCache>)`](crate::output::CreateApiCacheOutput::api_cache): <p>The <code>ApiCache</code> object.</p>
    /// - On failure, responds with [`SdkError<CreateApiCacheError>`](crate::error::CreateApiCacheError)
    pub fn create_api_cache(&self) -> fluent_builders::CreateApiCache {
        fluent_builders::CreateApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApiKey`](crate::client::fluent_builders::CreateApiKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateApiKey::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateApiKey::set_api_id): <p>The ID for your GraphQL API.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApiKey::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApiKey::set_description): <p>A description of the purpose of the API key.</p>
    ///   - [`expires(i64)`](crate::client::fluent_builders::CreateApiKey::expires) / [`set_expires(i64)`](crate::client::fluent_builders::CreateApiKey::set_expires): <p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>
    /// - On success, responds with [`CreateApiKeyOutput`](crate::output::CreateApiKeyOutput) with field(s):
    ///   - [`api_key(Option<ApiKey>)`](crate::output::CreateApiKeyOutput::api_key): <p>The API key.</p>
    /// - On failure, responds with [`SdkError<CreateApiKeyError>`](crate::error::CreateApiKeyError)
    pub fn create_api_key(&self) -> fluent_builders::CreateApiKey {
        fluent_builders::CreateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataSource`](crate::client::fluent_builders::CreateDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSource::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateDataSource::set_api_id): <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateDataSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateDataSource::set_name): <p>A user-supplied name for the <code>DataSource</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDataSource::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDataSource::set_description): <p>A description of the <code>DataSource</code>.</p>
    ///   - [`r#type(DataSourceType)`](crate::client::fluent_builders::CreateDataSource::type) / [`set_type(Option<DataSourceType>)`](crate::client::fluent_builders::CreateDataSource::set_type): <p>The type of the <code>DataSource</code>.</p>
    ///   - [`service_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDataSource::service_role_arn) / [`set_service_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDataSource::set_service_role_arn): <p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>
    ///   - [`dynamodb_config(DynamodbDataSourceConfig)`](crate::client::fluent_builders::CreateDataSource::dynamodb_config) / [`set_dynamodb_config(Option<DynamodbDataSourceConfig>)`](crate::client::fluent_builders::CreateDataSource::set_dynamodb_config): <p>Amazon DynamoDB settings.</p>
    ///   - [`lambda_config(LambdaDataSourceConfig)`](crate::client::fluent_builders::CreateDataSource::lambda_config) / [`set_lambda_config(Option<LambdaDataSourceConfig>)`](crate::client::fluent_builders::CreateDataSource::set_lambda_config): <p>Lambda settings.</p>
    ///   - [`elasticsearch_config(ElasticsearchDataSourceConfig)`](crate::client::fluent_builders::CreateDataSource::elasticsearch_config) / [`set_elasticsearch_config(Option<ElasticsearchDataSourceConfig>)`](crate::client::fluent_builders::CreateDataSource::set_elasticsearch_config): <p>Amazon OpenSearch Service settings.</p>  <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <code>CreateDataSourceRequest$openSearchServiceConfig</code> to create an OpenSearch data source.</p>
    ///   - [`open_search_service_config(OpenSearchServiceDataSourceConfig)`](crate::client::fluent_builders::CreateDataSource::open_search_service_config) / [`set_open_search_service_config(Option<OpenSearchServiceDataSourceConfig>)`](crate::client::fluent_builders::CreateDataSource::set_open_search_service_config): <p>Amazon OpenSearch Service settings.</p>
    ///   - [`http_config(HttpDataSourceConfig)`](crate::client::fluent_builders::CreateDataSource::http_config) / [`set_http_config(Option<HttpDataSourceConfig>)`](crate::client::fluent_builders::CreateDataSource::set_http_config): <p>HTTP endpoint settings.</p>
    ///   - [`relational_database_config(RelationalDatabaseDataSourceConfig)`](crate::client::fluent_builders::CreateDataSource::relational_database_config) / [`set_relational_database_config(Option<RelationalDatabaseDataSourceConfig>)`](crate::client::fluent_builders::CreateDataSource::set_relational_database_config): <p>Relational database settings.</p>
    /// - On success, responds with [`CreateDataSourceOutput`](crate::output::CreateDataSourceOutput) with field(s):
    ///   - [`data_source(Option<DataSource>)`](crate::output::CreateDataSourceOutput::data_source): <p>The <code>DataSource</code> object.</p>
    /// - On failure, responds with [`SdkError<CreateDataSourceError>`](crate::error::CreateDataSourceError)
    pub fn create_data_source(&self) -> fluent_builders::CreateDataSource {
        fluent_builders::CreateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomainName`](crate::client::fluent_builders::CreateDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_domain_name): <p>The domain name.</p>
    ///   - [`certificate_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::certificate_arn) / [`set_certificate_arn(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_certificate_arn): <p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDomainName::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDomainName::set_description): <p>A description of the <code>DomainName</code>.</p>
    /// - On success, responds with [`CreateDomainNameOutput`](crate::output::CreateDomainNameOutput) with field(s):
    ///   - [`domain_name_config(Option<DomainNameConfig>)`](crate::output::CreateDomainNameOutput::domain_name_config): <p>The configuration for the <code>DomainName</code>.</p>
    /// - On failure, responds with [`SdkError<CreateDomainNameError>`](crate::error::CreateDomainNameError)
    pub fn create_domain_name(&self) -> fluent_builders::CreateDomainName {
        fluent_builders::CreateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFunction`](crate::client::fluent_builders::CreateFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_api_id): <p>The GraphQL API ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_name): <p>The <code>Function</code> name. The function name does not have to be unique.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_description): <p>The <code>Function</code> description.</p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_data_source_name): <p>The <code>Function</code> <code>DataSource</code> name.</p>
    ///   - [`request_mapping_template(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::request_mapping_template) / [`set_request_mapping_template(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_request_mapping_template): <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
    ///   - [`response_mapping_template(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::response_mapping_template) / [`set_response_mapping_template(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_response_mapping_template): <p>The <code>Function</code> response mapping template.</p>
    ///   - [`function_version(impl Into<String>)`](crate::client::fluent_builders::CreateFunction::function_version) / [`set_function_version(Option<String>)`](crate::client::fluent_builders::CreateFunction::set_function_version): <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
    ///   - [`sync_config(SyncConfig)`](crate::client::fluent_builders::CreateFunction::sync_config) / [`set_sync_config(Option<SyncConfig>)`](crate::client::fluent_builders::CreateFunction::set_sync_config): <p>Describes a Sync configuration for a resolver.</p>  <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
    ///   - [`max_batch_size(i32)`](crate::client::fluent_builders::CreateFunction::max_batch_size) / [`set_max_batch_size(i32)`](crate::client::fluent_builders::CreateFunction::set_max_batch_size): <p>The maximum batching size for a resolver.</p>
    /// - On success, responds with [`CreateFunctionOutput`](crate::output::CreateFunctionOutput) with field(s):
    ///   - [`function_configuration(Option<FunctionConfiguration>)`](crate::output::CreateFunctionOutput::function_configuration): <p>The <code>Function</code> object.</p>
    /// - On failure, responds with [`SdkError<CreateFunctionError>`](crate::error::CreateFunctionError)
    pub fn create_function(&self) -> fluent_builders::CreateFunction {
        fluent_builders::CreateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGraphqlApi`](crate::client::fluent_builders::CreateGraphqlApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateGraphqlApi::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateGraphqlApi::set_name): <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
    ///   - [`log_config(LogConfig)`](crate::client::fluent_builders::CreateGraphqlApi::log_config) / [`set_log_config(Option<LogConfig>)`](crate::client::fluent_builders::CreateGraphqlApi::set_log_config): <p>The Amazon CloudWatch Logs configuration.</p>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::CreateGraphqlApi::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::CreateGraphqlApi::set_authentication_type): <p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>
    ///   - [`user_pool_config(UserPoolConfig)`](crate::client::fluent_builders::CreateGraphqlApi::user_pool_config) / [`set_user_pool_config(Option<UserPoolConfig>)`](crate::client::fluent_builders::CreateGraphqlApi::set_user_pool_config): <p>The Amazon Cognito user pool configuration.</p>
    ///   - [`open_id_connect_config(OpenIdConnectConfig)`](crate::client::fluent_builders::CreateGraphqlApi::open_id_connect_config) / [`set_open_id_connect_config(Option<OpenIdConnectConfig>)`](crate::client::fluent_builders::CreateGraphqlApi::set_open_id_connect_config): <p>The OIDC configuration.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateGraphqlApi::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateGraphqlApi::set_tags): <p>A <code>TagMap</code> object.</p>
    ///   - [`additional_authentication_providers(Vec<AdditionalAuthenticationProvider>)`](crate::client::fluent_builders::CreateGraphqlApi::additional_authentication_providers) / [`set_additional_authentication_providers(Option<Vec<AdditionalAuthenticationProvider>>)`](crate::client::fluent_builders::CreateGraphqlApi::set_additional_authentication_providers): <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
    ///   - [`xray_enabled(bool)`](crate::client::fluent_builders::CreateGraphqlApi::xray_enabled) / [`set_xray_enabled(bool)`](crate::client::fluent_builders::CreateGraphqlApi::set_xray_enabled): <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
    ///   - [`lambda_authorizer_config(LambdaAuthorizerConfig)`](crate::client::fluent_builders::CreateGraphqlApi::lambda_authorizer_config) / [`set_lambda_authorizer_config(Option<LambdaAuthorizerConfig>)`](crate::client::fluent_builders::CreateGraphqlApi::set_lambda_authorizer_config): <p>Configuration for Lambda function authorization.</p>
    /// - On success, responds with [`CreateGraphqlApiOutput`](crate::output::CreateGraphqlApiOutput) with field(s):
    ///   - [`graphql_api(Option<GraphqlApi>)`](crate::output::CreateGraphqlApiOutput::graphql_api): <p>The <code>GraphqlApi</code>.</p>
    /// - On failure, responds with [`SdkError<CreateGraphqlApiError>`](crate::error::CreateGraphqlApiError)
    pub fn create_graphql_api(&self) -> fluent_builders::CreateGraphqlApi {
        fluent_builders::CreateGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateResolver`](crate::client::fluent_builders::CreateResolver) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateResolver::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateResolver::set_api_id): <p>The ID for the GraphQL API for which the resolver is being created.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::CreateResolver::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::CreateResolver::set_type_name): <p>The name of the <code>Type</code>.</p>
    ///   - [`field_name(impl Into<String>)`](crate::client::fluent_builders::CreateResolver::field_name) / [`set_field_name(Option<String>)`](crate::client::fluent_builders::CreateResolver::set_field_name): <p>The name of the field to attach the resolver to.</p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::CreateResolver::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::CreateResolver::set_data_source_name): <p>The name of the data source for which the resolver is being created.</p>
    ///   - [`request_mapping_template(impl Into<String>)`](crate::client::fluent_builders::CreateResolver::request_mapping_template) / [`set_request_mapping_template(Option<String>)`](crate::client::fluent_builders::CreateResolver::set_request_mapping_template): <p>The mapping template to use for requests.</p>  <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>  <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
    ///   - [`response_mapping_template(impl Into<String>)`](crate::client::fluent_builders::CreateResolver::response_mapping_template) / [`set_response_mapping_template(Option<String>)`](crate::client::fluent_builders::CreateResolver::set_response_mapping_template): <p>The mapping template to use for responses from the data source.</p>
    ///   - [`kind(ResolverKind)`](crate::client::fluent_builders::CreateResolver::kind) / [`set_kind(Option<ResolverKind>)`](crate::client::fluent_builders::CreateResolver::set_kind): <p>The resolver type.</p>  <ul>   <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>   <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>  </ul>
    ///   - [`pipeline_config(PipelineConfig)`](crate::client::fluent_builders::CreateResolver::pipeline_config) / [`set_pipeline_config(Option<PipelineConfig>)`](crate::client::fluent_builders::CreateResolver::set_pipeline_config): <p>The <code>PipelineConfig</code>.</p>
    ///   - [`sync_config(SyncConfig)`](crate::client::fluent_builders::CreateResolver::sync_config) / [`set_sync_config(Option<SyncConfig>)`](crate::client::fluent_builders::CreateResolver::set_sync_config): <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
    ///   - [`caching_config(CachingConfig)`](crate::client::fluent_builders::CreateResolver::caching_config) / [`set_caching_config(Option<CachingConfig>)`](crate::client::fluent_builders::CreateResolver::set_caching_config): <p>The caching configuration for the resolver.</p>
    ///   - [`max_batch_size(i32)`](crate::client::fluent_builders::CreateResolver::max_batch_size) / [`set_max_batch_size(i32)`](crate::client::fluent_builders::CreateResolver::set_max_batch_size): <p>The maximum batching size for a resolver.</p>
    /// - On success, responds with [`CreateResolverOutput`](crate::output::CreateResolverOutput) with field(s):
    ///   - [`resolver(Option<Resolver>)`](crate::output::CreateResolverOutput::resolver): <p>The <code>Resolver</code> object.</p>
    /// - On failure, responds with [`SdkError<CreateResolverError>`](crate::error::CreateResolverError)
    pub fn create_resolver(&self) -> fluent_builders::CreateResolver {
        fluent_builders::CreateResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateType`](crate::client::fluent_builders::CreateType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::CreateType::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::CreateType::set_api_id): <p>The API ID.</p>
    ///   - [`definition(impl Into<String>)`](crate::client::fluent_builders::CreateType::definition) / [`set_definition(Option<String>)`](crate::client::fluent_builders::CreateType::set_definition): <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>  <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
    ///   - [`format(TypeDefinitionFormat)`](crate::client::fluent_builders::CreateType::format) / [`set_format(Option<TypeDefinitionFormat>)`](crate::client::fluent_builders::CreateType::set_format): <p>The type format: SDL or JSON.</p>
    /// - On success, responds with [`CreateTypeOutput`](crate::output::CreateTypeOutput) with field(s):
    ///   - [`r#type(Option<Type>)`](crate::output::CreateTypeOutput::type): <p>The <code>Type</code> object.</p>
    /// - On failure, responds with [`SdkError<CreateTypeError>`](crate::error::CreateTypeError)
    pub fn create_type(&self) -> fluent_builders::CreateType {
        fluent_builders::CreateType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApiCache`](crate::client::fluent_builders::DeleteApiCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApiCache::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteApiCache::set_api_id): <p>The API ID.</p>
    /// - On success, responds with [`DeleteApiCacheOutput`](crate::output::DeleteApiCacheOutput)

    /// - On failure, responds with [`SdkError<DeleteApiCacheError>`](crate::error::DeleteApiCacheError)
    pub fn delete_api_cache(&self) -> fluent_builders::DeleteApiCache {
        fluent_builders::DeleteApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApiKey`](crate::client::fluent_builders::DeleteApiKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteApiKey::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteApiKey::set_api_id): <p>The API ID.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteApiKey::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteApiKey::set_id): <p>The ID for the API key.</p>
    /// - On success, responds with [`DeleteApiKeyOutput`](crate::output::DeleteApiKeyOutput)

    /// - On failure, responds with [`SdkError<DeleteApiKeyError>`](crate::error::DeleteApiKeyError)
    pub fn delete_api_key(&self) -> fluent_builders::DeleteApiKey {
        fluent_builders::DeleteApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataSource`](crate::client::fluent_builders::DeleteDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSource::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteDataSource::set_api_id): <p>The API ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteDataSource::set_name): <p>The name of the data source.</p>
    /// - On success, responds with [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)

    /// - On failure, responds with [`SdkError<DeleteDataSourceError>`](crate::error::DeleteDataSourceError)
    pub fn delete_data_source(&self) -> fluent_builders::DeleteDataSource {
        fluent_builders::DeleteDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomainName`](crate::client::fluent_builders::DeleteDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteDomainName::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`DeleteDomainNameOutput`](crate::output::DeleteDomainNameOutput)

    /// - On failure, responds with [`SdkError<DeleteDomainNameError>`](crate::error::DeleteDomainNameError)
    pub fn delete_domain_name(&self) -> fluent_builders::DeleteDomainName {
        fluent_builders::DeleteDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFunction`](crate::client::fluent_builders::DeleteFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFunction::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteFunction::set_api_id): <p>The GraphQL API ID.</p>
    ///   - [`function_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFunction::function_id) / [`set_function_id(Option<String>)`](crate::client::fluent_builders::DeleteFunction::set_function_id): <p>The <code>Function</code> ID.</p>
    /// - On success, responds with [`DeleteFunctionOutput`](crate::output::DeleteFunctionOutput)

    /// - On failure, responds with [`SdkError<DeleteFunctionError>`](crate::error::DeleteFunctionError)
    pub fn delete_function(&self) -> fluent_builders::DeleteFunction {
        fluent_builders::DeleteFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGraphqlApi`](crate::client::fluent_builders::DeleteGraphqlApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteGraphqlApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteGraphqlApi::set_api_id): <p>The API ID.</p>
    /// - On success, responds with [`DeleteGraphqlApiOutput`](crate::output::DeleteGraphqlApiOutput)

    /// - On failure, responds with [`SdkError<DeleteGraphqlApiError>`](crate::error::DeleteGraphqlApiError)
    pub fn delete_graphql_api(&self) -> fluent_builders::DeleteGraphqlApi {
        fluent_builders::DeleteGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResolver`](crate::client::fluent_builders::DeleteResolver) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteResolver::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteResolver::set_api_id): <p>The API ID.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteResolver::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::DeleteResolver::set_type_name): <p>The name of the resolver type.</p>
    ///   - [`field_name(impl Into<String>)`](crate::client::fluent_builders::DeleteResolver::field_name) / [`set_field_name(Option<String>)`](crate::client::fluent_builders::DeleteResolver::set_field_name): <p>The resolver field name.</p>
    /// - On success, responds with [`DeleteResolverOutput`](crate::output::DeleteResolverOutput)

    /// - On failure, responds with [`SdkError<DeleteResolverError>`](crate::error::DeleteResolverError)
    pub fn delete_resolver(&self) -> fluent_builders::DeleteResolver {
        fluent_builders::DeleteResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteType`](crate::client::fluent_builders::DeleteType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::DeleteType::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::DeleteType::set_api_id): <p>The API ID.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteType::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::DeleteType::set_type_name): <p>The type name.</p>
    /// - On success, responds with [`DeleteTypeOutput`](crate::output::DeleteTypeOutput)

    /// - On failure, responds with [`SdkError<DeleteTypeError>`](crate::error::DeleteTypeError)
    pub fn delete_type(&self) -> fluent_builders::DeleteType {
        fluent_builders::DeleteType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateApi`](crate::client::fluent_builders::DisassociateApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateApi::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DisassociateApi::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`DisassociateApiOutput`](crate::output::DisassociateApiOutput)

    /// - On failure, responds with [`SdkError<DisassociateApiError>`](crate::error::DisassociateApiError)
    pub fn disassociate_api(&self) -> fluent_builders::DisassociateApi {
        fluent_builders::DisassociateApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FlushApiCache`](crate::client::fluent_builders::FlushApiCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::FlushApiCache::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::FlushApiCache::set_api_id): <p>The API ID.</p>
    /// - On success, responds with [`FlushApiCacheOutput`](crate::output::FlushApiCacheOutput)

    /// - On failure, responds with [`SdkError<FlushApiCacheError>`](crate::error::FlushApiCacheError)
    pub fn flush_api_cache(&self) -> fluent_builders::FlushApiCache {
        fluent_builders::FlushApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApiAssociation`](crate::client::fluent_builders::GetApiAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetApiAssociation::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetApiAssociation::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`GetApiAssociationOutput`](crate::output::GetApiAssociationOutput) with field(s):
    ///   - [`api_association(Option<ApiAssociation>)`](crate::output::GetApiAssociationOutput::api_association): <p>The <code>ApiAssociation</code> object.</p>
    /// - On failure, responds with [`SdkError<GetApiAssociationError>`](crate::error::GetApiAssociationError)
    pub fn get_api_association(&self) -> fluent_builders::GetApiAssociation {
        fluent_builders::GetApiAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApiCache`](crate::client::fluent_builders::GetApiCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetApiCache::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetApiCache::set_api_id): <p>The API ID.</p>
    /// - On success, responds with [`GetApiCacheOutput`](crate::output::GetApiCacheOutput) with field(s):
    ///   - [`api_cache(Option<ApiCache>)`](crate::output::GetApiCacheOutput::api_cache): <p>The <code>ApiCache</code> object.</p>
    /// - On failure, responds with [`SdkError<GetApiCacheError>`](crate::error::GetApiCacheError)
    pub fn get_api_cache(&self) -> fluent_builders::GetApiCache {
        fluent_builders::GetApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDataSource`](crate::client::fluent_builders::GetDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetDataSource::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetDataSource::set_api_id): <p>The API ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::GetDataSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::GetDataSource::set_name): <p>The name of the data source.</p>
    /// - On success, responds with [`GetDataSourceOutput`](crate::output::GetDataSourceOutput) with field(s):
    ///   - [`data_source(Option<DataSource>)`](crate::output::GetDataSourceOutput::data_source): <p>The <code>DataSource</code> object.</p>
    /// - On failure, responds with [`SdkError<GetDataSourceError>`](crate::error::GetDataSourceError)
    pub fn get_data_source(&self) -> fluent_builders::GetDataSource {
        fluent_builders::GetDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainName`](crate::client::fluent_builders::GetDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetDomainName::set_domain_name): <p>The domain name.</p>
    /// - On success, responds with [`GetDomainNameOutput`](crate::output::GetDomainNameOutput) with field(s):
    ///   - [`domain_name_config(Option<DomainNameConfig>)`](crate::output::GetDomainNameOutput::domain_name_config): <p>The configuration for the <code>DomainName</code>.</p>
    /// - On failure, responds with [`SdkError<GetDomainNameError>`](crate::error::GetDomainNameError)
    pub fn get_domain_name(&self) -> fluent_builders::GetDomainName {
        fluent_builders::GetDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFunction`](crate::client::fluent_builders::GetFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetFunction::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetFunction::set_api_id): <p>The GraphQL API ID.</p>
    ///   - [`function_id(impl Into<String>)`](crate::client::fluent_builders::GetFunction::function_id) / [`set_function_id(Option<String>)`](crate::client::fluent_builders::GetFunction::set_function_id): <p>The <code>Function</code> ID.</p>
    /// - On success, responds with [`GetFunctionOutput`](crate::output::GetFunctionOutput) with field(s):
    ///   - [`function_configuration(Option<FunctionConfiguration>)`](crate::output::GetFunctionOutput::function_configuration): <p>The <code>Function</code> object.</p>
    /// - On failure, responds with [`SdkError<GetFunctionError>`](crate::error::GetFunctionError)
    pub fn get_function(&self) -> fluent_builders::GetFunction {
        fluent_builders::GetFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGraphqlApi`](crate::client::fluent_builders::GetGraphqlApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetGraphqlApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetGraphqlApi::set_api_id): <p>The API ID for the GraphQL API.</p>
    /// - On success, responds with [`GetGraphqlApiOutput`](crate::output::GetGraphqlApiOutput) with field(s):
    ///   - [`graphql_api(Option<GraphqlApi>)`](crate::output::GetGraphqlApiOutput::graphql_api): <p>The <code>GraphqlApi</code> object.</p>
    /// - On failure, responds with [`SdkError<GetGraphqlApiError>`](crate::error::GetGraphqlApiError)
    pub fn get_graphql_api(&self) -> fluent_builders::GetGraphqlApi {
        fluent_builders::GetGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntrospectionSchema`](crate::client::fluent_builders::GetIntrospectionSchema) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetIntrospectionSchema::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetIntrospectionSchema::set_api_id): <p>The API ID.</p>
    ///   - [`format(OutputType)`](crate::client::fluent_builders::GetIntrospectionSchema::format) / [`set_format(Option<OutputType>)`](crate::client::fluent_builders::GetIntrospectionSchema::set_format): <p>The schema format: SDL or JSON.</p>
    ///   - [`include_directives(bool)`](crate::client::fluent_builders::GetIntrospectionSchema::include_directives) / [`set_include_directives(Option<bool>)`](crate::client::fluent_builders::GetIntrospectionSchema::set_include_directives): <p>A flag that specifies whether the schema introspection should contain directives.</p>
    /// - On success, responds with [`GetIntrospectionSchemaOutput`](crate::output::GetIntrospectionSchemaOutput) with field(s):
    ///   - [`schema(Option<Blob>)`](crate::output::GetIntrospectionSchemaOutput::schema): <p>The schema, in GraphQL Schema Definition Language (SDL) format.</p>  <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
    /// - On failure, responds with [`SdkError<GetIntrospectionSchemaError>`](crate::error::GetIntrospectionSchemaError)
    pub fn get_introspection_schema(&self) -> fluent_builders::GetIntrospectionSchema {
        fluent_builders::GetIntrospectionSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResolver`](crate::client::fluent_builders::GetResolver) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetResolver::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetResolver::set_api_id): <p>The API ID.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::GetResolver::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::GetResolver::set_type_name): <p>The resolver type name.</p>
    ///   - [`field_name(impl Into<String>)`](crate::client::fluent_builders::GetResolver::field_name) / [`set_field_name(Option<String>)`](crate::client::fluent_builders::GetResolver::set_field_name): <p>The resolver field name.</p>
    /// - On success, responds with [`GetResolverOutput`](crate::output::GetResolverOutput) with field(s):
    ///   - [`resolver(Option<Resolver>)`](crate::output::GetResolverOutput::resolver): <p>The <code>Resolver</code> object.</p>
    /// - On failure, responds with [`SdkError<GetResolverError>`](crate::error::GetResolverError)
    pub fn get_resolver(&self) -> fluent_builders::GetResolver {
        fluent_builders::GetResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSchemaCreationStatus`](crate::client::fluent_builders::GetSchemaCreationStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetSchemaCreationStatus::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetSchemaCreationStatus::set_api_id): <p>The API ID.</p>
    /// - On success, responds with [`GetSchemaCreationStatusOutput`](crate::output::GetSchemaCreationStatusOutput) with field(s):
    ///   - [`status(Option<SchemaStatus>)`](crate::output::GetSchemaCreationStatusOutput::status): <p>The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the ACTIVE state, you can add data.</p>
    ///   - [`details(Option<String>)`](crate::output::GetSchemaCreationStatusOutput::details): <p>Detailed information about the status of the schema creation operation.</p>
    /// - On failure, responds with [`SdkError<GetSchemaCreationStatusError>`](crate::error::GetSchemaCreationStatusError)
    pub fn get_schema_creation_status(&self) -> fluent_builders::GetSchemaCreationStatus {
        fluent_builders::GetSchemaCreationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetType`](crate::client::fluent_builders::GetType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::GetType::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::GetType::set_api_id): <p>The API ID.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::GetType::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::GetType::set_type_name): <p>The type name.</p>
    ///   - [`format(TypeDefinitionFormat)`](crate::client::fluent_builders::GetType::format) / [`set_format(Option<TypeDefinitionFormat>)`](crate::client::fluent_builders::GetType::set_format): <p>The type format: SDL or JSON.</p>
    /// - On success, responds with [`GetTypeOutput`](crate::output::GetTypeOutput) with field(s):
    ///   - [`r#type(Option<Type>)`](crate::output::GetTypeOutput::type): <p>The <code>Type</code> object.</p>
    /// - On failure, responds with [`SdkError<GetTypeError>`](crate::error::GetTypeError)
    pub fn get_type(&self) -> fluent_builders::GetType {
        fluent_builders::GetType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApiKeys`](crate::client::fluent_builders::ListApiKeys) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ListApiKeys::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ListApiKeys::set_api_id): <p>The API ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApiKeys::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApiKeys::set_next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApiKeys::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListApiKeys::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListApiKeysOutput`](crate::output::ListApiKeysOutput) with field(s):
    ///   - [`api_keys(Option<Vec<ApiKey>>)`](crate::output::ListApiKeysOutput::api_keys): <p>The <code>ApiKey</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApiKeysOutput::next_token): <p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListApiKeysError>`](crate::error::ListApiKeysError)
    pub fn list_api_keys(&self) -> fluent_builders::ListApiKeys {
        fluent_builders::ListApiKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDataSources`](crate::client::fluent_builders::ListDataSources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ListDataSources::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ListDataSources::set_api_id): <p>The API ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDataSources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDataSources::set_next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDataSources::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDataSources::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListDataSourcesOutput`](crate::output::ListDataSourcesOutput) with field(s):
    ///   - [`data_sources(Option<Vec<DataSource>>)`](crate::output::ListDataSourcesOutput::data_sources): <p>The <code>DataSource</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDataSourcesOutput::next_token): <p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListDataSourcesError>`](crate::error::ListDataSourcesError)
    pub fn list_data_sources(&self) -> fluent_builders::ListDataSources {
        fluent_builders::ListDataSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomainNames`](crate::client::fluent_builders::ListDomainNames) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomainNames::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomainNames::set_next_token): <p>The API token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomainNames::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDomainNames::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListDomainNamesOutput`](crate::output::ListDomainNamesOutput) with field(s):
    ///   - [`domain_name_configs(Option<Vec<DomainNameConfig>>)`](crate::output::ListDomainNamesOutput::domain_name_configs): <p>Lists configurations for multiple domain names.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainNamesOutput::next_token): <p>The API token.</p>
    /// - On failure, responds with [`SdkError<ListDomainNamesError>`](crate::error::ListDomainNamesError)
    pub fn list_domain_names(&self) -> fluent_builders::ListDomainNames {
        fluent_builders::ListDomainNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFunctions`](crate::client::fluent_builders::ListFunctions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ListFunctions::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ListFunctions::set_api_id): <p>The GraphQL API ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFunctions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFunctions::set_next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFunctions::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListFunctions::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListFunctionsOutput`](crate::output::ListFunctionsOutput) with field(s):
    ///   - [`functions(Option<Vec<FunctionConfiguration>>)`](crate::output::ListFunctionsOutput::functions): <p>A list of <code>Function</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFunctionsOutput::next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListFunctionsError>`](crate::error::ListFunctionsError)
    pub fn list_functions(&self) -> fluent_builders::ListFunctions {
        fluent_builders::ListFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGraphqlApis`](crate::client::fluent_builders::ListGraphqlApis) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGraphqlApis::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGraphqlApis::set_next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGraphqlApis::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListGraphqlApis::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListGraphqlApisOutput`](crate::output::ListGraphqlApisOutput) with field(s):
    ///   - [`graphql_apis(Option<Vec<GraphqlApi>>)`](crate::output::ListGraphqlApisOutput::graphql_apis): <p>The <code>GraphqlApi</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGraphqlApisOutput::next_token): <p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListGraphqlApisError>`](crate::error::ListGraphqlApisError)
    pub fn list_graphql_apis(&self) -> fluent_builders::ListGraphqlApis {
        fluent_builders::ListGraphqlApis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolvers`](crate::client::fluent_builders::ListResolvers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ListResolvers::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ListResolvers::set_api_id): <p>The API ID.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::ListResolvers::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::ListResolvers::set_type_name): <p>The type name.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolvers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolvers::set_next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolvers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListResolvers::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListResolversOutput`](crate::output::ListResolversOutput) with field(s):
    ///   - [`resolvers(Option<Vec<Resolver>>)`](crate::output::ListResolversOutput::resolvers): <p>The <code>Resolver</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResolversOutput::next_token): <p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListResolversError>`](crate::error::ListResolversError)
    pub fn list_resolvers(&self) -> fluent_builders::ListResolvers {
        fluent_builders::ListResolvers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResolversByFunction`](crate::client::fluent_builders::ListResolversByFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ListResolversByFunction::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ListResolversByFunction::set_api_id): <p>The API ID.</p>
    ///   - [`function_id(impl Into<String>)`](crate::client::fluent_builders::ListResolversByFunction::function_id) / [`set_function_id(Option<String>)`](crate::client::fluent_builders::ListResolversByFunction::set_function_id): <p>The function ID.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResolversByFunction::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResolversByFunction::set_next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResolversByFunction::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListResolversByFunction::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListResolversByFunctionOutput`](crate::output::ListResolversByFunctionOutput) with field(s):
    ///   - [`resolvers(Option<Vec<Resolver>>)`](crate::output::ListResolversByFunctionOutput::resolvers): <p>The list of resolvers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResolversByFunctionOutput::next_token): <p>An identifier that you can use to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListResolversByFunctionError>`](crate::error::ListResolversByFunctionError)
    pub fn list_resolvers_by_function(&self) -> fluent_builders::ListResolversByFunction {
        fluent_builders::ListResolversByFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A <code>TagMap</code> object.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTypes`](crate::client::fluent_builders::ListTypes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::ListTypes::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::ListTypes::set_api_id): <p>The API ID.</p>
    ///   - [`format(TypeDefinitionFormat)`](crate::client::fluent_builders::ListTypes::format) / [`set_format(Option<TypeDefinitionFormat>)`](crate::client::fluent_builders::ListTypes::set_format): <p>The type format: SDL or JSON.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTypes::set_next_token): <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTypes::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListTypes::set_max_results): <p>The maximum number of results that you want the request to return.</p>
    /// - On success, responds with [`ListTypesOutput`](crate::output::ListTypesOutput) with field(s):
    ///   - [`types(Option<Vec<Type>>)`](crate::output::ListTypesOutput::types): <p>The <code>Type</code> objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTypesOutput::next_token): <p>An identifier to pass in the next request to this operation to return the next set of items in the list.</p>
    /// - On failure, responds with [`SdkError<ListTypesError>`](crate::error::ListTypesError)
    pub fn list_types(&self) -> fluent_builders::ListTypes {
        fluent_builders::ListTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartSchemaCreation`](crate::client::fluent_builders::StartSchemaCreation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::StartSchemaCreation::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::StartSchemaCreation::set_api_id): <p>The API ID.</p>
    ///   - [`definition(Blob)`](crate::client::fluent_builders::StartSchemaCreation::definition) / [`set_definition(Option<Blob>)`](crate::client::fluent_builders::StartSchemaCreation::set_definition): <p>The schema definition, in GraphQL schema language format.</p>
    /// - On success, responds with [`StartSchemaCreationOutput`](crate::output::StartSchemaCreationOutput) with field(s):
    ///   - [`status(Option<SchemaStatus>)`](crate::output::StartSchemaCreationOutput::status): <p>The current state of the schema (PROCESSING, FAILED, SUCCESS, or NOT_APPLICABLE). When the schema is in the ACTIVE state, you can add data.</p>
    /// - On failure, responds with [`SdkError<StartSchemaCreationError>`](crate::error::StartSchemaCreationError)
    pub fn start_schema_creation(&self) -> fluent_builders::StartSchemaCreation {
        fluent_builders::StartSchemaCreation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A <code>TagMap</code> object.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of <code>TagKey</code> objects.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApiCache`](crate::client::fluent_builders::UpdateApiCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApiCache::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateApiCache::set_api_id): <p>The GraphQL API ID.</p>
    ///   - [`ttl(i64)`](crate::client::fluent_builders::UpdateApiCache::ttl) / [`set_ttl(i64)`](crate::client::fluent_builders::UpdateApiCache::set_ttl): <p>TTL in seconds for cache entries.</p>  <p>Valid values are 1–3,600 seconds.</p>
    ///   - [`api_caching_behavior(ApiCachingBehavior)`](crate::client::fluent_builders::UpdateApiCache::api_caching_behavior) / [`set_api_caching_behavior(Option<ApiCachingBehavior>)`](crate::client::fluent_builders::UpdateApiCache::set_api_caching_behavior): <p>Caching behavior.</p>  <ul>   <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>   <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>  </ul>
    ///   - [`r#type(ApiCacheType)`](crate::client::fluent_builders::UpdateApiCache::type) / [`set_type(Option<ApiCacheType>)`](crate::client::fluent_builders::UpdateApiCache::set_type): <p>The cache instance type. Valid values are </p>  <ul>   <li> <p> <code>SMALL</code> </p> </li>   <li> <p> <code>MEDIUM</code> </p> </li>   <li> <p> <code>LARGE</code> </p> </li>   <li> <p> <code>XLARGE</code> </p> </li>   <li> <p> <code>LARGE_2X</code> </p> </li>   <li> <p> <code>LARGE_4X</code> </p> </li>   <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>   <li> <p> <code>LARGE_12X</code> </p> </li>  </ul>  <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>  <p>The following legacy instance types are available, but their use is discouraged:</p>  <ul>   <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>   <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>   <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>   <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>   <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>   <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>   <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>  </ul>
    /// - On success, responds with [`UpdateApiCacheOutput`](crate::output::UpdateApiCacheOutput) with field(s):
    ///   - [`api_cache(Option<ApiCache>)`](crate::output::UpdateApiCacheOutput::api_cache): <p>The <code>ApiCache</code> object.</p>
    /// - On failure, responds with [`SdkError<UpdateApiCacheError>`](crate::error::UpdateApiCacheError)
    pub fn update_api_cache(&self) -> fluent_builders::UpdateApiCache {
        fluent_builders::UpdateApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApiKey`](crate::client::fluent_builders::UpdateApiKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateApiKey::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateApiKey::set_api_id): <p>The ID for the GraphQL API.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateApiKey::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateApiKey::set_id): <p>The API key ID.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApiKey::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApiKey::set_description): <p>A description of the purpose of the API key.</p>
    ///   - [`expires(i64)`](crate::client::fluent_builders::UpdateApiKey::expires) / [`set_expires(i64)`](crate::client::fluent_builders::UpdateApiKey::set_expires): <p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>
    /// - On success, responds with [`UpdateApiKeyOutput`](crate::output::UpdateApiKeyOutput) with field(s):
    ///   - [`api_key(Option<ApiKey>)`](crate::output::UpdateApiKeyOutput::api_key): <p>The API key.</p>
    /// - On failure, responds with [`SdkError<UpdateApiKeyError>`](crate::error::UpdateApiKeyError)
    pub fn update_api_key(&self) -> fluent_builders::UpdateApiKey {
        fluent_builders::UpdateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataSource`](crate::client::fluent_builders::UpdateDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_api_id): <p>The API ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_name): <p>The new name for the data source.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_description): <p>The new description for the data source.</p>
    ///   - [`r#type(DataSourceType)`](crate::client::fluent_builders::UpdateDataSource::type) / [`set_type(Option<DataSourceType>)`](crate::client::fluent_builders::UpdateDataSource::set_type): <p>The new data source type.</p>
    ///   - [`service_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::service_role_arn) / [`set_service_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_service_role_arn): <p>The new service role Amazon Resource Name (ARN) for the data source.</p>
    ///   - [`dynamodb_config(DynamodbDataSourceConfig)`](crate::client::fluent_builders::UpdateDataSource::dynamodb_config) / [`set_dynamodb_config(Option<DynamodbDataSourceConfig>)`](crate::client::fluent_builders::UpdateDataSource::set_dynamodb_config): <p>The new Amazon DynamoDB configuration.</p>
    ///   - [`lambda_config(LambdaDataSourceConfig)`](crate::client::fluent_builders::UpdateDataSource::lambda_config) / [`set_lambda_config(Option<LambdaDataSourceConfig>)`](crate::client::fluent_builders::UpdateDataSource::set_lambda_config): <p>The new Lambda configuration.</p>
    ///   - [`elasticsearch_config(ElasticsearchDataSourceConfig)`](crate::client::fluent_builders::UpdateDataSource::elasticsearch_config) / [`set_elasticsearch_config(Option<ElasticsearchDataSourceConfig>)`](crate::client::fluent_builders::UpdateDataSource::set_elasticsearch_config): <p>The new OpenSearch configuration.</p>  <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <code>UpdateDataSourceRequest$openSearchServiceConfig</code> to update an OpenSearch data source.</p>
    ///   - [`open_search_service_config(OpenSearchServiceDataSourceConfig)`](crate::client::fluent_builders::UpdateDataSource::open_search_service_config) / [`set_open_search_service_config(Option<OpenSearchServiceDataSourceConfig>)`](crate::client::fluent_builders::UpdateDataSource::set_open_search_service_config): <p>The new OpenSearch configuration.</p>
    ///   - [`http_config(HttpDataSourceConfig)`](crate::client::fluent_builders::UpdateDataSource::http_config) / [`set_http_config(Option<HttpDataSourceConfig>)`](crate::client::fluent_builders::UpdateDataSource::set_http_config): <p>The new HTTP endpoint configuration.</p>
    ///   - [`relational_database_config(RelationalDatabaseDataSourceConfig)`](crate::client::fluent_builders::UpdateDataSource::relational_database_config) / [`set_relational_database_config(Option<RelationalDatabaseDataSourceConfig>)`](crate::client::fluent_builders::UpdateDataSource::set_relational_database_config): <p>The new relational database configuration.</p>
    /// - On success, responds with [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput) with field(s):
    ///   - [`data_source(Option<DataSource>)`](crate::output::UpdateDataSourceOutput::data_source): <p>The updated <code>DataSource</code> object.</p>
    /// - On failure, responds with [`SdkError<UpdateDataSourceError>`](crate::error::UpdateDataSourceError)
    pub fn update_data_source(&self) -> fluent_builders::UpdateDataSource {
        fluent_builders::UpdateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomainName`](crate::client::fluent_builders::UpdateDomainName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainName::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomainName::set_domain_name): <p>The domain name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateDomainName::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateDomainName::set_description): <p>A description of the <code>DomainName</code>.</p>
    /// - On success, responds with [`UpdateDomainNameOutput`](crate::output::UpdateDomainNameOutput) with field(s):
    ///   - [`domain_name_config(Option<DomainNameConfig>)`](crate::output::UpdateDomainNameOutput::domain_name_config): <p>The configuration for the <code>DomainName</code>.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainNameError>`](crate::error::UpdateDomainNameError)
    pub fn update_domain_name(&self) -> fluent_builders::UpdateDomainName {
        fluent_builders::UpdateDomainName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFunction`](crate::client::fluent_builders::UpdateFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_api_id): <p>The GraphQL API ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_name): <p>The <code>Function</code> name.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_description): <p>The <code>Function</code> description.</p>
    ///   - [`function_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::function_id) / [`set_function_id(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_function_id): <p>The function ID.</p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_data_source_name): <p>The <code>Function</code> <code>DataSource</code> name.</p>
    ///   - [`request_mapping_template(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::request_mapping_template) / [`set_request_mapping_template(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_request_mapping_template): <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
    ///   - [`response_mapping_template(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::response_mapping_template) / [`set_response_mapping_template(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_response_mapping_template): <p>The <code>Function</code> request mapping template.</p>
    ///   - [`function_version(impl Into<String>)`](crate::client::fluent_builders::UpdateFunction::function_version) / [`set_function_version(Option<String>)`](crate::client::fluent_builders::UpdateFunction::set_function_version): <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
    ///   - [`sync_config(SyncConfig)`](crate::client::fluent_builders::UpdateFunction::sync_config) / [`set_sync_config(Option<SyncConfig>)`](crate::client::fluent_builders::UpdateFunction::set_sync_config): <p>Describes a Sync configuration for a resolver.</p>  <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
    ///   - [`max_batch_size(i32)`](crate::client::fluent_builders::UpdateFunction::max_batch_size) / [`set_max_batch_size(i32)`](crate::client::fluent_builders::UpdateFunction::set_max_batch_size): <p>The maximum batching size for a resolver.</p>
    /// - On success, responds with [`UpdateFunctionOutput`](crate::output::UpdateFunctionOutput) with field(s):
    ///   - [`function_configuration(Option<FunctionConfiguration>)`](crate::output::UpdateFunctionOutput::function_configuration): <p>The <code>Function</code> object.</p>
    /// - On failure, responds with [`SdkError<UpdateFunctionError>`](crate::error::UpdateFunctionError)
    pub fn update_function(&self) -> fluent_builders::UpdateFunction {
        fluent_builders::UpdateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGraphqlApi`](crate::client::fluent_builders::UpdateGraphqlApi) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateGraphqlApi::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_api_id): <p>The API ID.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateGraphqlApi::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_name): <p>The new name for the <code>GraphqlApi</code> object.</p>
    ///   - [`log_config(LogConfig)`](crate::client::fluent_builders::UpdateGraphqlApi::log_config) / [`set_log_config(Option<LogConfig>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_log_config): <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::UpdateGraphqlApi::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_authentication_type): <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
    ///   - [`user_pool_config(UserPoolConfig)`](crate::client::fluent_builders::UpdateGraphqlApi::user_pool_config) / [`set_user_pool_config(Option<UserPoolConfig>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_user_pool_config): <p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>
    ///   - [`open_id_connect_config(OpenIdConnectConfig)`](crate::client::fluent_builders::UpdateGraphqlApi::open_id_connect_config) / [`set_open_id_connect_config(Option<OpenIdConnectConfig>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_open_id_connect_config): <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
    ///   - [`additional_authentication_providers(Vec<AdditionalAuthenticationProvider>)`](crate::client::fluent_builders::UpdateGraphqlApi::additional_authentication_providers) / [`set_additional_authentication_providers(Option<Vec<AdditionalAuthenticationProvider>>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_additional_authentication_providers): <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
    ///   - [`xray_enabled(bool)`](crate::client::fluent_builders::UpdateGraphqlApi::xray_enabled) / [`set_xray_enabled(bool)`](crate::client::fluent_builders::UpdateGraphqlApi::set_xray_enabled): <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
    ///   - [`lambda_authorizer_config(LambdaAuthorizerConfig)`](crate::client::fluent_builders::UpdateGraphqlApi::lambda_authorizer_config) / [`set_lambda_authorizer_config(Option<LambdaAuthorizerConfig>)`](crate::client::fluent_builders::UpdateGraphqlApi::set_lambda_authorizer_config): <p>Configuration for Lambda function authorization.</p>
    /// - On success, responds with [`UpdateGraphqlApiOutput`](crate::output::UpdateGraphqlApiOutput) with field(s):
    ///   - [`graphql_api(Option<GraphqlApi>)`](crate::output::UpdateGraphqlApiOutput::graphql_api): <p>The updated <code>GraphqlApi</code> object.</p>
    /// - On failure, responds with [`SdkError<UpdateGraphqlApiError>`](crate::error::UpdateGraphqlApiError)
    pub fn update_graphql_api(&self) -> fluent_builders::UpdateGraphqlApi {
        fluent_builders::UpdateGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateResolver`](crate::client::fluent_builders::UpdateResolver) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateResolver::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateResolver::set_api_id): <p>The API ID.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::UpdateResolver::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::UpdateResolver::set_type_name): <p>The new type name.</p>
    ///   - [`field_name(impl Into<String>)`](crate::client::fluent_builders::UpdateResolver::field_name) / [`set_field_name(Option<String>)`](crate::client::fluent_builders::UpdateResolver::set_field_name): <p>The new field name.</p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::UpdateResolver::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::UpdateResolver::set_data_source_name): <p>The new data source name.</p>
    ///   - [`request_mapping_template(impl Into<String>)`](crate::client::fluent_builders::UpdateResolver::request_mapping_template) / [`set_request_mapping_template(Option<String>)`](crate::client::fluent_builders::UpdateResolver::set_request_mapping_template): <p>The new request mapping template.</p>  <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>  <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
    ///   - [`response_mapping_template(impl Into<String>)`](crate::client::fluent_builders::UpdateResolver::response_mapping_template) / [`set_response_mapping_template(Option<String>)`](crate::client::fluent_builders::UpdateResolver::set_response_mapping_template): <p>The new response mapping template.</p>
    ///   - [`kind(ResolverKind)`](crate::client::fluent_builders::UpdateResolver::kind) / [`set_kind(Option<ResolverKind>)`](crate::client::fluent_builders::UpdateResolver::set_kind): <p>The resolver type.</p>  <ul>   <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>   <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>  </ul>
    ///   - [`pipeline_config(PipelineConfig)`](crate::client::fluent_builders::UpdateResolver::pipeline_config) / [`set_pipeline_config(Option<PipelineConfig>)`](crate::client::fluent_builders::UpdateResolver::set_pipeline_config): <p>The <code>PipelineConfig</code>.</p>
    ///   - [`sync_config(SyncConfig)`](crate::client::fluent_builders::UpdateResolver::sync_config) / [`set_sync_config(Option<SyncConfig>)`](crate::client::fluent_builders::UpdateResolver::set_sync_config): <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
    ///   - [`caching_config(CachingConfig)`](crate::client::fluent_builders::UpdateResolver::caching_config) / [`set_caching_config(Option<CachingConfig>)`](crate::client::fluent_builders::UpdateResolver::set_caching_config): <p>The caching configuration for the resolver.</p>
    ///   - [`max_batch_size(i32)`](crate::client::fluent_builders::UpdateResolver::max_batch_size) / [`set_max_batch_size(i32)`](crate::client::fluent_builders::UpdateResolver::set_max_batch_size): <p>The maximum batching size for a resolver.</p>
    /// - On success, responds with [`UpdateResolverOutput`](crate::output::UpdateResolverOutput) with field(s):
    ///   - [`resolver(Option<Resolver>)`](crate::output::UpdateResolverOutput::resolver): <p>The updated <code>Resolver</code> object.</p>
    /// - On failure, responds with [`SdkError<UpdateResolverError>`](crate::error::UpdateResolverError)
    pub fn update_resolver(&self) -> fluent_builders::UpdateResolver {
        fluent_builders::UpdateResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateType`](crate::client::fluent_builders::UpdateType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`api_id(impl Into<String>)`](crate::client::fluent_builders::UpdateType::api_id) / [`set_api_id(Option<String>)`](crate::client::fluent_builders::UpdateType::set_api_id): <p>The API ID.</p>
    ///   - [`type_name(impl Into<String>)`](crate::client::fluent_builders::UpdateType::type_name) / [`set_type_name(Option<String>)`](crate::client::fluent_builders::UpdateType::set_type_name): <p>The new type name.</p>
    ///   - [`definition(impl Into<String>)`](crate::client::fluent_builders::UpdateType::definition) / [`set_definition(Option<String>)`](crate::client::fluent_builders::UpdateType::set_definition): <p>The new definition.</p>
    ///   - [`format(TypeDefinitionFormat)`](crate::client::fluent_builders::UpdateType::format) / [`set_format(Option<TypeDefinitionFormat>)`](crate::client::fluent_builders::UpdateType::set_format): <p>The new type format: SDL or JSON.</p>
    /// - On success, responds with [`UpdateTypeOutput`](crate::output::UpdateTypeOutput) with field(s):
    ///   - [`r#type(Option<Type>)`](crate::output::UpdateTypeOutput::type): <p>The updated <code>Type</code> object.</p>
    /// - On failure, responds with [`SdkError<UpdateTypeError>`](crate::error::UpdateTypeError)
    pub fn update_type(&self) -> fluent_builders::UpdateType {
        fluent_builders::UpdateType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateApi`.
    ///
    /// <p>Maps an endpoint to your custom domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_api_input::Builder,
    }
    impl AssociateApi {
        /// Creates a new `AssociateApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateApiOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApiCache`.
    ///
    /// <p>Creates a cache for the GraphQL API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApiCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_api_cache_input::Builder,
    }
    impl CreateApiCache {
        /// Creates a new `CreateApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.transit_encryption_enabled(input);
            self
        }
        /// <p>Transit encryption flag when connecting to cache. You cannot update this setting after creation.</p>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_transit_encryption_enabled(input);
            self
        }
        /// <p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.at_rest_encryption_enabled(input);
            self
        }
        /// <p>At-rest encryption flag for cache. You cannot update this setting after creation.</p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_at_rest_encryption_enabled(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn api_caching_behavior(mut self, input: crate::model::ApiCachingBehavior) -> Self {
            self.inner = self.inner.api_caching_behavior(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn set_api_caching_behavior(
            mut self,
            input: std::option::Option<crate::model::ApiCachingBehavior>,
        ) -> Self {
            self.inner = self.inner.set_api_caching_behavior(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ApiCacheType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ApiCacheType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApiKey`.
    ///
    /// <p>Creates a unique key that you can distribute to clients who invoke your API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApiKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_api_key_input::Builder,
    }
    impl CreateApiKey {
        /// Creates a new `CreateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for your GraphQL API.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The ID for your GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>
        pub fn expires(mut self, input: i64) -> Self {
            self.inner = self.inner.expires(input);
            self
        }
        /// <p>From the creation time, the time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour. The default value for this parameter is 7 days from creation time. For more information, see .</p>
        pub fn set_expires(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expires(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSource`.
    ///
    /// <p>Creates a <code>DataSource</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_source_input::Builder,
    }
    impl CreateDataSource {
        /// Creates a new `CreateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>A user-supplied name for the <code>DataSource</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A user-supplied name for the <code>DataSource</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the <code>DataSource</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the <code>DataSource</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the <code>DataSource</code>.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the <code>DataSource</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(input.into());
            self
        }
        /// <p>The Identity and Access Management (IAM) service role Amazon Resource Name (ARN) for the data source. The system assumes this role when accessing the data source.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn dynamodb_config(mut self, input: crate::model::DynamodbDataSourceConfig) -> Self {
            self.inner = self.inner.dynamodb_config(input);
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn set_dynamodb_config(
            mut self,
            input: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_dynamodb_config(input);
            self
        }
        /// <p>Lambda settings.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaDataSourceConfig) -> Self {
            self.inner = self.inner.lambda_config(input);
            self
        }
        /// <p>Lambda settings.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_config(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <code>CreateDataSourceRequest$openSearchServiceConfig</code> to create an OpenSearch data source.</p>
        pub fn elasticsearch_config(
            mut self,
            input: crate::model::ElasticsearchDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_config(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For new data sources, use <code>CreateDataSourceRequest$openSearchServiceConfig</code> to create an OpenSearch data source.</p>
        pub fn set_elasticsearch_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_config(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn open_search_service_config(
            mut self,
            input: crate::model::OpenSearchServiceDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.open_search_service_config(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn set_open_search_service_config(
            mut self,
            input: std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_search_service_config(input);
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn http_config(mut self, input: crate::model::HttpDataSourceConfig) -> Self {
            self.inner = self.inner.http_config(input);
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn set_http_config(
            mut self,
            input: std::option::Option<crate::model::HttpDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_http_config(input);
            self
        }
        /// <p>Relational database settings.</p>
        pub fn relational_database_config(
            mut self,
            input: crate::model::RelationalDatabaseDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.relational_database_config(input);
            self
        }
        /// <p>Relational database settings.</p>
        pub fn set_relational_database_config(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainName`.
    ///
    /// <p>Creates a custom <code>DomainName</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_domain_name_input::Builder,
    }
    impl CreateDomainName {
        /// Creates a new `CreateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunction`.
    ///
    /// <p>Creates a <code>Function</code> object.</p>
    /// <p>A function is a reusable entity. You can use multiple functions to compose the resolver logic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_function_input::Builder,
    }
    impl CreateFunction {
        /// Creates a new `CreateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(input.into());
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The <code>Function</code> response mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(input.into());
            self
        }
        /// <p>The <code>Function</code> response mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(input.into());
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.inner = self.inner.max_batch_size(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_batch_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGraphqlApi`.
    ///
    /// <p>Creates a <code>GraphqlApi</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGraphqlApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_graphql_api_input::Builder,
    }
    impl CreateGraphqlApi {
        /// Creates a new `CreateGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGraphqlApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn log_config(mut self, input: crate::model::LogConfig) -> Self {
            self.inner = self.inner.log_config(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogConfig>,
        ) -> Self {
            self.inner = self.inner.set_log_config(input);
            self
        }
        /// <p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn user_pool_config(mut self, input: crate::model::UserPoolConfig) -> Self {
            self.inner = self.inner.user_pool_config(input);
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::UserPoolConfig>,
        ) -> Self {
            self.inner = self.inner.set_user_pool_config(input);
            self
        }
        /// <p>The OIDC configuration.</p>
        pub fn open_id_connect_config(mut self, input: crate::model::OpenIdConnectConfig) -> Self {
            self.inner = self.inner.open_id_connect_config(input);
            self
        }
        /// <p>The OIDC configuration.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_config(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A <code>TagMap</code> object.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A <code>TagMap</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `additionalAuthenticationProviders`.
        ///
        /// To override the contents of this collection use [`set_additional_authentication_providers`](Self::set_additional_authentication_providers).
        ///
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn additional_authentication_providers(
            mut self,
            input: crate::model::AdditionalAuthenticationProvider,
        ) -> Self {
            self.inner = self.inner.additional_authentication_providers(input);
            self
        }
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn set_additional_authentication_providers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalAuthenticationProvider>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_authentication_providers(input);
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn xray_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.xray_enabled(input);
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn set_xray_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_xray_enabled(input);
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            input: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.inner = self.inner.lambda_authorizer_config(input);
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_authorizer_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolver`.
    ///
    /// <p>Creates a <code>Resolver</code> object.</p>
    /// <p>A resolver converts incoming requests into a format that a data source can understand, and converts the data source's responses into GraphQL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateResolver {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_resolver_input::Builder,
    }
    impl CreateResolver {
        /// Creates a new `CreateResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the <code>Type</code>.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The name of the <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The name of the field to attach the resolver to.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(input.into());
            self
        }
        /// <p>The name of the field to attach the resolver to.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
        /// <p>The name of the data source for which the resolver is being created.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>The name of the data source for which the resolver is being created.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The mapping template to use for requests.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(input.into());
            self
        }
        /// <p>The mapping template to use for requests.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The mapping template to use for responses from the data source.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(input.into());
            self
        }
        /// <p>The mapping template to use for responses from the data source.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::ResolverKind) -> Self {
            self.inner = self.inner.kind(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::ResolverKind>) -> Self {
            self.inner = self.inner.set_kind(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn pipeline_config(mut self, input: crate::model::PipelineConfig) -> Self {
            self.inner = self.inner.pipeline_config(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn set_pipeline_config(
            mut self,
            input: std::option::Option<crate::model::PipelineConfig>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_config(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn caching_config(mut self, input: crate::model::CachingConfig) -> Self {
            self.inner = self.inner.caching_config(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn set_caching_config(
            mut self,
            input: std::option::Option<crate::model::CachingConfig>,
        ) -> Self {
            self.inner = self.inner.set_caching_config(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.inner = self.inner.max_batch_size(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_batch_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateType`.
    ///
    /// <p>Creates a <code>Type</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_type_input::Builder,
    }
    impl CreateType {
        /// Creates a new `CreateType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
        /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(input.into());
            self
        }
        /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
        /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL documentation</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiCache`.
    ///
    /// <p>Deletes an <code>ApiCache</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApiCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_api_cache_input::Builder,
    }
    impl DeleteApiCache {
        /// Creates a new `DeleteApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiKey`.
    ///
    /// <p>Deletes an API key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApiKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_api_key_input::Builder,
    }
    impl DeleteApiKey {
        /// Creates a new `DeleteApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The ID for the API key.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID for the API key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSource`.
    ///
    /// <p>Deletes a <code>DataSource</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_data_source_input::Builder,
    }
    impl DeleteDataSource {
        /// Creates a new `DeleteDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainName`.
    ///
    /// <p>Deletes a custom <code>DomainName</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_domain_name_input::Builder,
    }
    impl DeleteDomainName {
        /// Creates a new `DeleteDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunction`.
    ///
    /// <p>Deletes a <code>Function</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_function_input::Builder,
    }
    impl DeleteFunction {
        /// Creates a new `DeleteFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(input.into());
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGraphqlApi`.
    ///
    /// <p>Deletes a <code>GraphqlApi</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGraphqlApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_graphql_api_input::Builder,
    }
    impl DeleteGraphqlApi {
        /// Creates a new `DeleteGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGraphqlApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolver`.
    ///
    /// <p>Deletes a <code>Resolver</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResolver {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resolver_input::Builder,
    }
    impl DeleteResolver {
        /// Creates a new `DeleteResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the resolver type.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The name of the resolver type.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The resolver field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(input.into());
            self
        }
        /// <p>The resolver field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteType`.
    ///
    /// <p>Deletes a <code>Type</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_type_input::Builder,
    }
    impl DeleteType {
        /// Creates a new `DeleteType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateApi`.
    ///
    /// <p>Removes an <code>ApiAssociation</code> object from a custom domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_api_input::Builder,
    }
    impl DisassociateApi {
        /// Creates a new `DisassociateApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FlushApiCache`.
    ///
    /// <p>Flushes an <code>ApiCache</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FlushApiCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::flush_api_cache_input::Builder,
    }
    impl FlushApiCache {
        /// Creates a new `FlushApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FlushApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::FlushApiCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiAssociation`.
    ///
    /// <p>Retrieves an <code>ApiAssociation</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiAssociation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_api_association_input::Builder,
    }
    impl GetApiAssociation {
        /// Creates a new `GetApiAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiAssociationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiCache`.
    ///
    /// <p>Retrieves an <code>ApiCache</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApiCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_api_cache_input::Builder,
    }
    impl GetApiCache {
        /// Creates a new `GetApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataSource`.
    ///
    /// <p>Retrieves a <code>DataSource</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_data_source_input::Builder,
    }
    impl GetDataSource {
        /// Creates a new `GetDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainName`.
    ///
    /// <p>Retrieves a custom <code>DomainName</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_name_input::Builder,
    }
    impl GetDomainName {
        /// Creates a new `GetDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunction`.
    ///
    /// <p>Get a <code>Function</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_function_input::Builder,
    }
    impl GetFunction {
        /// Creates a new `GetFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(input.into());
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGraphqlApi`.
    ///
    /// <p>Retrieves a <code>GraphqlApi</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGraphqlApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_graphql_api_input::Builder,
    }
    impl GetGraphqlApi {
        /// Creates a new `GetGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGraphqlApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID for the GraphQL API.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID for the GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntrospectionSchema`.
    ///
    /// <p>Retrieves the introspection schema for a GraphQL API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntrospectionSchema {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_introspection_schema_input::Builder,
    }
    impl GetIntrospectionSchema {
        /// Creates a new `GetIntrospectionSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntrospectionSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntrospectionSchemaError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The schema format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::OutputType) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The schema format: SDL or JSON.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::OutputType>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
        pub fn include_directives(mut self, input: bool) -> Self {
            self.inner = self.inner.include_directives(input);
            self
        }
        /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
        pub fn set_include_directives(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_directives(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolver`.
    ///
    /// <p>Retrieves a <code>Resolver</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResolver {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resolver_input::Builder,
    }
    impl GetResolver {
        /// Creates a new `GetResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The resolver type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The resolver type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The resolver field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(input.into());
            self
        }
        /// <p>The resolver field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchemaCreationStatus`.
    ///
    /// <p>Retrieves the current status of a schema creation operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSchemaCreationStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_schema_creation_status_input::Builder,
    }
    impl GetSchemaCreationStatus {
        /// Creates a new `GetSchemaCreationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaCreationStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaCreationStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetType`.
    ///
    /// <p>Retrieves a <code>Type</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_type_input::Builder,
    }
    impl GetType {
        /// Creates a new `GetType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApiKeys`.
    ///
    /// <p>Lists the API keys for a given API.</p> <note>
    /// <p>API keys are deleted automatically 60 days after they expire. However, they may still be included in the response until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete a key before it's automatically deleted.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApiKeys {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_api_keys_input::Builder,
    }
    impl ListApiKeys {
        /// Creates a new `ListApiKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApiKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApiKeysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSources`.
    ///
    /// <p>Lists the data sources for a given API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDataSources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_data_sources_input::Builder,
    }
    impl ListDataSources {
        /// Creates a new `ListDataSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomainNames`.
    ///
    /// <p>Lists multiple custom domain names.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomainNames {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domain_names_input::Builder,
    }
    impl ListDomainNames {
        /// Creates a new `ListDomainNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainNamesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The API token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctions`.
    ///
    /// <p>List multiple functions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFunctions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_functions_input::Builder,
    }
    impl ListFunctions {
        /// Creates a new `ListFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGraphqlApis`.
    ///
    /// <p>Lists your GraphQL APIs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGraphqlApis {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_graphql_apis_input::Builder,
    }
    impl ListGraphqlApis {
        /// Creates a new `ListGraphqlApis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGraphqlApisOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGraphqlApisError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolvers`.
    ///
    /// <p>Lists the resolvers for a given API and type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolvers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolvers_input::Builder,
    }
    impl ListResolvers {
        /// Creates a new `ListResolvers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolversOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolversError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolversByFunction`.
    ///
    /// <p>List the resolvers that are associated with a specific function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResolversByFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_resolvers_by_function_input::Builder,
    }
    impl ListResolversByFunction {
        /// Creates a new `ListResolversByFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolversByFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolversByFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The function ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(input.into());
            self
        }
        /// <p>The function ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypes`.
    ///
    /// <p>Lists the types for a given API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_types_input::Builder,
    }
    impl ListTypes {
        /// Creates a new `ListTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results that you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSchemaCreation`.
    ///
    /// <p>Adds a new schema to your GraphQL API.</p>
    /// <p>This operation is asynchronous. Use to determine when it has completed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartSchemaCreation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_schema_creation_input::Builder,
    }
    impl StartSchemaCreation {
        /// Creates a new `StartSchemaCreation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSchemaCreationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSchemaCreationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The schema definition, in GraphQL schema language format.</p>
        pub fn definition(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.definition(input);
            self
        }
        /// <p>The schema definition, in GraphQL schema language format.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags a resource with user-supplied tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A <code>TagMap</code> object.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A <code>TagMap</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Untags a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The <code>GraphqlApi</code> Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of <code>TagKey</code> objects.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of <code>TagKey</code> objects.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiCache`.
    ///
    /// <p>Updates the cache for the GraphQL API.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApiCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_api_cache_input::Builder,
    }
    impl UpdateApiCache {
        /// Creates a new `UpdateApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.inner = self.inner.ttl(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are 1–3,600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn api_caching_behavior(mut self, input: crate::model::ApiCachingBehavior) -> Self {
            self.inner = self.inner.api_caching_behavior(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li> <p> <b>FULL_REQUEST_CACHING</b>: All requests are fully cached.</p> </li>
        /// <li> <p> <b>PER_RESOLVER_CACHING</b>: Individual resolvers that you specify are cached.</p> </li>
        /// </ul>
        pub fn set_api_caching_behavior(
            mut self,
            input: std::option::Option<crate::model::ApiCachingBehavior>,
        ) -> Self {
            self.inner = self.inner.set_api_caching_behavior(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ApiCacheType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li> <p> <code>SMALL</code> </p> </li>
        /// <li> <p> <code>MEDIUM</code> </p> </li>
        /// <li> <p> <code>LARGE</code> </p> </li>
        /// <li> <p> <code>XLARGE</code> </p> </li>
        /// <li> <p> <code>LARGE_2X</code> </p> </li>
        /// <li> <p> <code>LARGE_4X</code> </p> </li>
        /// <li> <p> <code>LARGE_8X</code> (not available in all regions)</p> </li>
        /// <li> <p> <code>LARGE_12X</code> </p> </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li> <p> <b>T2_SMALL</b>: A t2.small instance type.</p> </li>
        /// <li> <p> <b>T2_MEDIUM</b>: A t2.medium instance type.</p> </li>
        /// <li> <p> <b>R4_LARGE</b>: A r4.large instance type.</p> </li>
        /// <li> <p> <b>R4_XLARGE</b>: A r4.xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p> </li>
        /// <li> <p> <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p> </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ApiCacheType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiKey`.
    ///
    /// <p>Updates an API key. You can update the key as long as it's not deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApiKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_api_key_input::Builder,
    }
    impl UpdateApiKey {
        /// Creates a new `UpdateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the GraphQL API.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The ID for the GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The API key ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The API key ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>
        pub fn expires(mut self, input: i64) -> Self {
            self.inner = self.inner.expires(input);
            self
        }
        /// <p>From the update time, the time after which the API key expires. The date is represented as seconds since the epoch. For more information, see .</p>
        pub fn set_expires(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expires(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSource`.
    ///
    /// <p>Updates a <code>DataSource</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_data_source_input::Builder,
    }
    impl UpdateDataSource {
        /// Creates a new `UpdateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new name for the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new data source type.</p>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The new data source type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The new service role Amazon Resource Name (ARN) for the data source.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(input.into());
            self
        }
        /// <p>The new service role Amazon Resource Name (ARN) for the data source.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// <p>The new Amazon DynamoDB configuration.</p>
        pub fn dynamodb_config(mut self, input: crate::model::DynamodbDataSourceConfig) -> Self {
            self.inner = self.inner.dynamodb_config(input);
            self
        }
        /// <p>The new Amazon DynamoDB configuration.</p>
        pub fn set_dynamodb_config(
            mut self,
            input: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_dynamodb_config(input);
            self
        }
        /// <p>The new Lambda configuration.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaDataSourceConfig) -> Self {
            self.inner = self.inner.lambda_config(input);
            self
        }
        /// <p>The new Lambda configuration.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_config(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <code>UpdateDataSourceRequest$openSearchServiceConfig</code> to update an OpenSearch data source.</p>
        pub fn elasticsearch_config(
            mut self,
            input: crate::model::ElasticsearchDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_config(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. Instead, use <code>UpdateDataSourceRequest$openSearchServiceConfig</code> to update an OpenSearch data source.</p>
        pub fn set_elasticsearch_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_config(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        pub fn open_search_service_config(
            mut self,
            input: crate::model::OpenSearchServiceDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.open_search_service_config(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        pub fn set_open_search_service_config(
            mut self,
            input: std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_search_service_config(input);
            self
        }
        /// <p>The new HTTP endpoint configuration.</p>
        pub fn http_config(mut self, input: crate::model::HttpDataSourceConfig) -> Self {
            self.inner = self.inner.http_config(input);
            self
        }
        /// <p>The new HTTP endpoint configuration.</p>
        pub fn set_http_config(
            mut self,
            input: std::option::Option<crate::model::HttpDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_http_config(input);
            self
        }
        /// <p>The new relational database configuration.</p>
        pub fn relational_database_config(
            mut self,
            input: crate::model::RelationalDatabaseDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.relational_database_config(input);
            self
        }
        /// <p>The new relational database configuration.</p>
        pub fn set_relational_database_config(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainName`.
    ///
    /// <p>Updates a custom <code>DomainName</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomainName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_name_input::Builder,
    }
    impl UpdateDomainName {
        /// Creates a new `UpdateDomainName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The domain name.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the <code>DomainName</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunction`.
    ///
    /// <p>Updates a <code>Function</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFunction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_function_input::Builder,
    }
    impl UpdateFunction {
        /// Creates a new `UpdateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The <code>Function</code> name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The function ID.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(input.into());
            self
        }
        /// <p>The function ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>The <code>Function</code> <code>DataSource</code> name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(input.into());
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The <code>Function</code> request mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(input.into());
            self
        }
        /// <p>The <code>Function</code> request mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(input.into());
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.inner = self.inner.max_batch_size(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_batch_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGraphqlApi`.
    ///
    /// <p>Updates a <code>GraphqlApi</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGraphqlApi {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_graphql_api_input::Builder,
    }
    impl UpdateGraphqlApi {
        /// Creates a new `UpdateGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGraphqlApiError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new name for the <code>GraphqlApi</code> object.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The new name for the <code>GraphqlApi</code> object.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
        pub fn log_config(mut self, input: crate::model::LogConfig) -> Self {
            self.inner = self.inner.log_config(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogConfig>,
        ) -> Self {
            self.inner = self.inner.set_log_config(input);
            self
        }
        /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>
        pub fn user_pool_config(mut self, input: crate::model::UserPoolConfig) -> Self {
            self.inner = self.inner.user_pool_config(input);
            self
        }
        /// <p>The new Amazon Cognito user pool configuration for the <code>~GraphqlApi</code> object.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::UserPoolConfig>,
        ) -> Self {
            self.inner = self.inner.set_user_pool_config(input);
            self
        }
        /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
        pub fn open_id_connect_config(mut self, input: crate::model::OpenIdConnectConfig) -> Self {
            self.inner = self.inner.open_id_connect_config(input);
            self
        }
        /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_config(input);
            self
        }
        /// Appends an item to `additionalAuthenticationProviders`.
        ///
        /// To override the contents of this collection use [`set_additional_authentication_providers`](Self::set_additional_authentication_providers).
        ///
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn additional_authentication_providers(
            mut self,
            input: crate::model::AdditionalAuthenticationProvider,
        ) -> Self {
            self.inner = self.inner.additional_authentication_providers(input);
            self
        }
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code> API.</p>
        pub fn set_additional_authentication_providers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalAuthenticationProvider>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_authentication_providers(input);
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn xray_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.xray_enabled(input);
            self
        }
        /// <p>A flag indicating whether to use X-Ray tracing for the <code>GraphqlApi</code>.</p>
        pub fn set_xray_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_xray_enabled(input);
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            input: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.inner = self.inner.lambda_authorizer_config(input);
            self
        }
        /// <p>Configuration for Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_authorizer_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolver`.
    ///
    /// <p>Updates a <code>Resolver</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateResolver {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_resolver_input::Builder,
    }
    impl UpdateResolver {
        /// Creates a new `UpdateResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The new type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The new field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(input.into());
            self
        }
        /// <p>The new field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
        /// <p>The new data source name.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>The new data source name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The new request mapping template.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(input.into());
            self
        }
        /// <p>The new request mapping template.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL request and response mapping templates are required.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The new response mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(input.into());
            self
        }
        /// <p>The new response mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::ResolverKind) -> Self {
            self.inner = self.inner.kind(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li> <p> <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to run a GraphQL query against a single data source.</p> </li>
        /// <li> <p> <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against multiple data sources.</p> </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::ResolverKind>) -> Self {
            self.inner = self.inner.set_kind(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn pipeline_config(mut self, input: crate::model::PipelineConfig) -> Self {
            self.inner = self.inner.pipeline_config(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn set_pipeline_config(
            mut self,
            input: std::option::Option<crate::model::PipelineConfig>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_config(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned data source.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn caching_config(mut self, input: crate::model::CachingConfig) -> Self {
            self.inner = self.inner.caching_config(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn set_caching_config(
            mut self,
            input: std::option::Option<crate::model::CachingConfig>,
        ) -> Self {
            self.inner = self.inner.set_caching_config(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn max_batch_size(mut self, input: i32) -> Self {
            self.inner = self.inner.max_batch_size(input);
            self
        }
        /// <p>The maximum batching size for a resolver.</p>
        pub fn set_max_batch_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_batch_size(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateType`.
    ///
    /// <p>Updates a <code>Type</code> object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_type_input::Builder,
    }
    impl UpdateType {
        /// Creates a new `UpdateType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(input.into());
            self
        }
        /// <p>The new type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The new definition.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(input.into());
            self
        }
        /// <p>The new definition.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The new type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p>The new type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
