// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateApiCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_api_cache`](crate::client::Client::create_api_cache).
///
/// See [`crate::client::fluent_builders::CreateApiCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApiCache {
    _private: (),
}
impl CreateApiCache {
    /// Creates a new builder-style object to manufacture [`CreateApiCacheInput`](crate::input::CreateApiCacheInput)
    pub fn builder() -> crate::input::create_api_cache_input::Builder {
        crate::input::create_api_cache_input::Builder::default()
    }
    /// Creates a new `CreateApiCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApiCache {
    type Output =
        std::result::Result<crate::output::CreateApiCacheOutput, crate::error::CreateApiCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_api_cache_error(response)
        } else {
            crate::operation_deser::parse_create_api_cache_response(response)
        }
    }
}

/// Operation shape for `CreateApiKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_api_key`](crate::client::Client::create_api_key).
///
/// See [`crate::client::fluent_builders::CreateApiKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateApiKey {
    _private: (),
}
impl CreateApiKey {
    /// Creates a new builder-style object to manufacture [`CreateApiKeyInput`](crate::input::CreateApiKeyInput)
    pub fn builder() -> crate::input::create_api_key_input::Builder {
        crate::input::create_api_key_input::Builder::default()
    }
    /// Creates a new `CreateApiKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateApiKey {
    type Output =
        std::result::Result<crate::output::CreateApiKeyOutput, crate::error::CreateApiKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_api_key_error(response)
        } else {
            crate::operation_deser::parse_create_api_key_response(response)
        }
    }
}

/// Operation shape for `CreateDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_data_source`](crate::client::Client::create_data_source).
///
/// See [`crate::client::fluent_builders::CreateDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataSource {
    _private: (),
}
impl CreateDataSource {
    /// Creates a new builder-style object to manufacture [`CreateDataSourceInput`](crate::input::CreateDataSourceInput)
    pub fn builder() -> crate::input::create_data_source_input::Builder {
        crate::input::create_data_source_input::Builder::default()
    }
    /// Creates a new `CreateDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataSource {
    type Output = std::result::Result<
        crate::output::CreateDataSourceOutput,
        crate::error::CreateDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_data_source_error(response)
        } else {
            crate::operation_deser::parse_create_data_source_response(response)
        }
    }
}

/// Operation shape for `CreateFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_function`](crate::client::Client::create_function).
///
/// See [`crate::client::fluent_builders::CreateFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFunction {
    _private: (),
}
impl CreateFunction {
    /// Creates a new builder-style object to manufacture [`CreateFunctionInput`](crate::input::CreateFunctionInput)
    pub fn builder() -> crate::input::create_function_input::Builder {
        crate::input::create_function_input::Builder::default()
    }
    /// Creates a new `CreateFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFunction {
    type Output =
        std::result::Result<crate::output::CreateFunctionOutput, crate::error::CreateFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_function_error(response)
        } else {
            crate::operation_deser::parse_create_function_response(response)
        }
    }
}

/// Operation shape for `CreateGraphqlApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_graphql_api`](crate::client::Client::create_graphql_api).
///
/// See [`crate::client::fluent_builders::CreateGraphqlApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGraphqlApi {
    _private: (),
}
impl CreateGraphqlApi {
    /// Creates a new builder-style object to manufacture [`CreateGraphqlApiInput`](crate::input::CreateGraphqlApiInput)
    pub fn builder() -> crate::input::create_graphql_api_input::Builder {
        crate::input::create_graphql_api_input::Builder::default()
    }
    /// Creates a new `CreateGraphqlApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGraphqlApi {
    type Output = std::result::Result<
        crate::output::CreateGraphqlApiOutput,
        crate::error::CreateGraphqlApiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_graphql_api_error(response)
        } else {
            crate::operation_deser::parse_create_graphql_api_response(response)
        }
    }
}

/// Operation shape for `CreateResolver`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_resolver`](crate::client::Client::create_resolver).
///
/// See [`crate::client::fluent_builders::CreateResolver`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateResolver {
    _private: (),
}
impl CreateResolver {
    /// Creates a new builder-style object to manufacture [`CreateResolverInput`](crate::input::CreateResolverInput)
    pub fn builder() -> crate::input::create_resolver_input::Builder {
        crate::input::create_resolver_input::Builder::default()
    }
    /// Creates a new `CreateResolver` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateResolver {
    type Output =
        std::result::Result<crate::output::CreateResolverOutput, crate::error::CreateResolverError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_resolver_error(response)
        } else {
            crate::operation_deser::parse_create_resolver_response(response)
        }
    }
}

/// Operation shape for `CreateType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_type`](crate::client::Client::create_type).
///
/// See [`crate::client::fluent_builders::CreateType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateType {
    _private: (),
}
impl CreateType {
    /// Creates a new builder-style object to manufacture [`CreateTypeInput`](crate::input::CreateTypeInput)
    pub fn builder() -> crate::input::create_type_input::Builder {
        crate::input::create_type_input::Builder::default()
    }
    /// Creates a new `CreateType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateType {
    type Output =
        std::result::Result<crate::output::CreateTypeOutput, crate::error::CreateTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_type_error(response)
        } else {
            crate::operation_deser::parse_create_type_response(response)
        }
    }
}

/// Operation shape for `DeleteApiCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_api_cache`](crate::client::Client::delete_api_cache).
///
/// See [`crate::client::fluent_builders::DeleteApiCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApiCache {
    _private: (),
}
impl DeleteApiCache {
    /// Creates a new builder-style object to manufacture [`DeleteApiCacheInput`](crate::input::DeleteApiCacheInput)
    pub fn builder() -> crate::input::delete_api_cache_input::Builder {
        crate::input::delete_api_cache_input::Builder::default()
    }
    /// Creates a new `DeleteApiCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApiCache {
    type Output =
        std::result::Result<crate::output::DeleteApiCacheOutput, crate::error::DeleteApiCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_api_cache_error(response)
        } else {
            crate::operation_deser::parse_delete_api_cache_response(response)
        }
    }
}

/// Operation shape for `DeleteApiKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_api_key`](crate::client::Client::delete_api_key).
///
/// See [`crate::client::fluent_builders::DeleteApiKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteApiKey {
    _private: (),
}
impl DeleteApiKey {
    /// Creates a new builder-style object to manufacture [`DeleteApiKeyInput`](crate::input::DeleteApiKeyInput)
    pub fn builder() -> crate::input::delete_api_key_input::Builder {
        crate::input::delete_api_key_input::Builder::default()
    }
    /// Creates a new `DeleteApiKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteApiKey {
    type Output =
        std::result::Result<crate::output::DeleteApiKeyOutput, crate::error::DeleteApiKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_api_key_error(response)
        } else {
            crate::operation_deser::parse_delete_api_key_response(response)
        }
    }
}

/// Operation shape for `DeleteDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_data_source`](crate::client::Client::delete_data_source).
///
/// See [`crate::client::fluent_builders::DeleteDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataSource {
    _private: (),
}
impl DeleteDataSource {
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    pub fn builder() -> crate::input::delete_data_source_input::Builder {
        crate::input::delete_data_source_input::Builder::default()
    }
    /// Creates a new `DeleteDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataSource {
    type Output = std::result::Result<
        crate::output::DeleteDataSourceOutput,
        crate::error::DeleteDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_data_source_error(response)
        } else {
            crate::operation_deser::parse_delete_data_source_response(response)
        }
    }
}

/// Operation shape for `DeleteFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_function`](crate::client::Client::delete_function).
///
/// See [`crate::client::fluent_builders::DeleteFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFunction {
    _private: (),
}
impl DeleteFunction {
    /// Creates a new builder-style object to manufacture [`DeleteFunctionInput`](crate::input::DeleteFunctionInput)
    pub fn builder() -> crate::input::delete_function_input::Builder {
        crate::input::delete_function_input::Builder::default()
    }
    /// Creates a new `DeleteFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFunction {
    type Output =
        std::result::Result<crate::output::DeleteFunctionOutput, crate::error::DeleteFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_function_error(response)
        } else {
            crate::operation_deser::parse_delete_function_response(response)
        }
    }
}

/// Operation shape for `DeleteGraphqlApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_graphql_api`](crate::client::Client::delete_graphql_api).
///
/// See [`crate::client::fluent_builders::DeleteGraphqlApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGraphqlApi {
    _private: (),
}
impl DeleteGraphqlApi {
    /// Creates a new builder-style object to manufacture [`DeleteGraphqlApiInput`](crate::input::DeleteGraphqlApiInput)
    pub fn builder() -> crate::input::delete_graphql_api_input::Builder {
        crate::input::delete_graphql_api_input::Builder::default()
    }
    /// Creates a new `DeleteGraphqlApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGraphqlApi {
    type Output = std::result::Result<
        crate::output::DeleteGraphqlApiOutput,
        crate::error::DeleteGraphqlApiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_graphql_api_error(response)
        } else {
            crate::operation_deser::parse_delete_graphql_api_response(response)
        }
    }
}

/// Operation shape for `DeleteResolver`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resolver`](crate::client::Client::delete_resolver).
///
/// See [`crate::client::fluent_builders::DeleteResolver`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResolver {
    _private: (),
}
impl DeleteResolver {
    /// Creates a new builder-style object to manufacture [`DeleteResolverInput`](crate::input::DeleteResolverInput)
    pub fn builder() -> crate::input::delete_resolver_input::Builder {
        crate::input::delete_resolver_input::Builder::default()
    }
    /// Creates a new `DeleteResolver` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResolver {
    type Output =
        std::result::Result<crate::output::DeleteResolverOutput, crate::error::DeleteResolverError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resolver_error(response)
        } else {
            crate::operation_deser::parse_delete_resolver_response(response)
        }
    }
}

/// Operation shape for `DeleteType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_type`](crate::client::Client::delete_type).
///
/// See [`crate::client::fluent_builders::DeleteType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteType {
    _private: (),
}
impl DeleteType {
    /// Creates a new builder-style object to manufacture [`DeleteTypeInput`](crate::input::DeleteTypeInput)
    pub fn builder() -> crate::input::delete_type_input::Builder {
        crate::input::delete_type_input::Builder::default()
    }
    /// Creates a new `DeleteType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteType {
    type Output =
        std::result::Result<crate::output::DeleteTypeOutput, crate::error::DeleteTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_type_error(response)
        } else {
            crate::operation_deser::parse_delete_type_response(response)
        }
    }
}

/// Operation shape for `FlushApiCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`flush_api_cache`](crate::client::Client::flush_api_cache).
///
/// See [`crate::client::fluent_builders::FlushApiCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FlushApiCache {
    _private: (),
}
impl FlushApiCache {
    /// Creates a new builder-style object to manufacture [`FlushApiCacheInput`](crate::input::FlushApiCacheInput)
    pub fn builder() -> crate::input::flush_api_cache_input::Builder {
        crate::input::flush_api_cache_input::Builder::default()
    }
    /// Creates a new `FlushApiCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FlushApiCache {
    type Output =
        std::result::Result<crate::output::FlushApiCacheOutput, crate::error::FlushApiCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_flush_api_cache_error(response)
        } else {
            crate::operation_deser::parse_flush_api_cache_response(response)
        }
    }
}

/// Operation shape for `GetApiCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_api_cache`](crate::client::Client::get_api_cache).
///
/// See [`crate::client::fluent_builders::GetApiCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetApiCache {
    _private: (),
}
impl GetApiCache {
    /// Creates a new builder-style object to manufacture [`GetApiCacheInput`](crate::input::GetApiCacheInput)
    pub fn builder() -> crate::input::get_api_cache_input::Builder {
        crate::input::get_api_cache_input::Builder::default()
    }
    /// Creates a new `GetApiCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetApiCache {
    type Output =
        std::result::Result<crate::output::GetApiCacheOutput, crate::error::GetApiCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_api_cache_error(response)
        } else {
            crate::operation_deser::parse_get_api_cache_response(response)
        }
    }
}

/// Operation shape for `GetDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_data_source`](crate::client::Client::get_data_source).
///
/// See [`crate::client::fluent_builders::GetDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDataSource {
    _private: (),
}
impl GetDataSource {
    /// Creates a new builder-style object to manufacture [`GetDataSourceInput`](crate::input::GetDataSourceInput)
    pub fn builder() -> crate::input::get_data_source_input::Builder {
        crate::input::get_data_source_input::Builder::default()
    }
    /// Creates a new `GetDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDataSource {
    type Output =
        std::result::Result<crate::output::GetDataSourceOutput, crate::error::GetDataSourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_data_source_error(response)
        } else {
            crate::operation_deser::parse_get_data_source_response(response)
        }
    }
}

/// Operation shape for `GetFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_function`](crate::client::Client::get_function).
///
/// See [`crate::client::fluent_builders::GetFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFunction {
    _private: (),
}
impl GetFunction {
    /// Creates a new builder-style object to manufacture [`GetFunctionInput`](crate::input::GetFunctionInput)
    pub fn builder() -> crate::input::get_function_input::Builder {
        crate::input::get_function_input::Builder::default()
    }
    /// Creates a new `GetFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFunction {
    type Output =
        std::result::Result<crate::output::GetFunctionOutput, crate::error::GetFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_function_error(response)
        } else {
            crate::operation_deser::parse_get_function_response(response)
        }
    }
}

/// Operation shape for `GetGraphqlApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_graphql_api`](crate::client::Client::get_graphql_api).
///
/// See [`crate::client::fluent_builders::GetGraphqlApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGraphqlApi {
    _private: (),
}
impl GetGraphqlApi {
    /// Creates a new builder-style object to manufacture [`GetGraphqlApiInput`](crate::input::GetGraphqlApiInput)
    pub fn builder() -> crate::input::get_graphql_api_input::Builder {
        crate::input::get_graphql_api_input::Builder::default()
    }
    /// Creates a new `GetGraphqlApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGraphqlApi {
    type Output =
        std::result::Result<crate::output::GetGraphqlApiOutput, crate::error::GetGraphqlApiError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_graphql_api_error(response)
        } else {
            crate::operation_deser::parse_get_graphql_api_response(response)
        }
    }
}

/// Operation shape for `GetIntrospectionSchema`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_introspection_schema`](crate::client::Client::get_introspection_schema).
///
/// See [`crate::client::fluent_builders::GetIntrospectionSchema`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntrospectionSchema {
    _private: (),
}
impl GetIntrospectionSchema {
    /// Creates a new builder-style object to manufacture [`GetIntrospectionSchemaInput`](crate::input::GetIntrospectionSchemaInput)
    pub fn builder() -> crate::input::get_introspection_schema_input::Builder {
        crate::input::get_introspection_schema_input::Builder::default()
    }
    /// Creates a new `GetIntrospectionSchema` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntrospectionSchema {
    type Output = std::result::Result<
        crate::output::GetIntrospectionSchemaOutput,
        crate::error::GetIntrospectionSchemaError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_introspection_schema_error(response)
        } else {
            crate::operation_deser::parse_get_introspection_schema_response(response)
        }
    }
}

/// Operation shape for `GetResolver`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resolver`](crate::client::Client::get_resolver).
///
/// See [`crate::client::fluent_builders::GetResolver`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResolver {
    _private: (),
}
impl GetResolver {
    /// Creates a new builder-style object to manufacture [`GetResolverInput`](crate::input::GetResolverInput)
    pub fn builder() -> crate::input::get_resolver_input::Builder {
        crate::input::get_resolver_input::Builder::default()
    }
    /// Creates a new `GetResolver` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResolver {
    type Output =
        std::result::Result<crate::output::GetResolverOutput, crate::error::GetResolverError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resolver_error(response)
        } else {
            crate::operation_deser::parse_get_resolver_response(response)
        }
    }
}

/// Operation shape for `GetSchemaCreationStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_schema_creation_status`](crate::client::Client::get_schema_creation_status).
///
/// See [`crate::client::fluent_builders::GetSchemaCreationStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSchemaCreationStatus {
    _private: (),
}
impl GetSchemaCreationStatus {
    /// Creates a new builder-style object to manufacture [`GetSchemaCreationStatusInput`](crate::input::GetSchemaCreationStatusInput)
    pub fn builder() -> crate::input::get_schema_creation_status_input::Builder {
        crate::input::get_schema_creation_status_input::Builder::default()
    }
    /// Creates a new `GetSchemaCreationStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSchemaCreationStatus {
    type Output = std::result::Result<
        crate::output::GetSchemaCreationStatusOutput,
        crate::error::GetSchemaCreationStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_schema_creation_status_error(response)
        } else {
            crate::operation_deser::parse_get_schema_creation_status_response(response)
        }
    }
}

/// Operation shape for `GetType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_type`](crate::client::Client::get_type).
///
/// See [`crate::client::fluent_builders::GetType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetType {
    _private: (),
}
impl GetType {
    /// Creates a new builder-style object to manufacture [`GetTypeInput`](crate::input::GetTypeInput)
    pub fn builder() -> crate::input::get_type_input::Builder {
        crate::input::get_type_input::Builder::default()
    }
    /// Creates a new `GetType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetType {
    type Output = std::result::Result<crate::output::GetTypeOutput, crate::error::GetTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_type_error(response)
        } else {
            crate::operation_deser::parse_get_type_response(response)
        }
    }
}

/// Operation shape for `ListApiKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_api_keys`](crate::client::Client::list_api_keys).
///
/// See [`crate::client::fluent_builders::ListApiKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListApiKeys {
    _private: (),
}
impl ListApiKeys {
    /// Creates a new builder-style object to manufacture [`ListApiKeysInput`](crate::input::ListApiKeysInput)
    pub fn builder() -> crate::input::list_api_keys_input::Builder {
        crate::input::list_api_keys_input::Builder::default()
    }
    /// Creates a new `ListApiKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListApiKeys {
    type Output =
        std::result::Result<crate::output::ListApiKeysOutput, crate::error::ListApiKeysError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_api_keys_error(response)
        } else {
            crate::operation_deser::parse_list_api_keys_response(response)
        }
    }
}

/// Operation shape for `ListDataSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_data_sources`](crate::client::Client::list_data_sources).
///
/// See [`crate::client::fluent_builders::ListDataSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDataSources {
    _private: (),
}
impl ListDataSources {
    /// Creates a new builder-style object to manufacture [`ListDataSourcesInput`](crate::input::ListDataSourcesInput)
    pub fn builder() -> crate::input::list_data_sources_input::Builder {
        crate::input::list_data_sources_input::Builder::default()
    }
    /// Creates a new `ListDataSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDataSources {
    type Output = std::result::Result<
        crate::output::ListDataSourcesOutput,
        crate::error::ListDataSourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_data_sources_error(response)
        } else {
            crate::operation_deser::parse_list_data_sources_response(response)
        }
    }
}

/// Operation shape for `ListFunctions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_functions`](crate::client::Client::list_functions).
///
/// See [`crate::client::fluent_builders::ListFunctions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFunctions {
    _private: (),
}
impl ListFunctions {
    /// Creates a new builder-style object to manufacture [`ListFunctionsInput`](crate::input::ListFunctionsInput)
    pub fn builder() -> crate::input::list_functions_input::Builder {
        crate::input::list_functions_input::Builder::default()
    }
    /// Creates a new `ListFunctions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFunctions {
    type Output =
        std::result::Result<crate::output::ListFunctionsOutput, crate::error::ListFunctionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_functions_error(response)
        } else {
            crate::operation_deser::parse_list_functions_response(response)
        }
    }
}

/// Operation shape for `ListGraphqlApis`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_graphql_apis`](crate::client::Client::list_graphql_apis).
///
/// See [`crate::client::fluent_builders::ListGraphqlApis`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGraphqlApis {
    _private: (),
}
impl ListGraphqlApis {
    /// Creates a new builder-style object to manufacture [`ListGraphqlApisInput`](crate::input::ListGraphqlApisInput)
    pub fn builder() -> crate::input::list_graphql_apis_input::Builder {
        crate::input::list_graphql_apis_input::Builder::default()
    }
    /// Creates a new `ListGraphqlApis` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGraphqlApis {
    type Output = std::result::Result<
        crate::output::ListGraphqlApisOutput,
        crate::error::ListGraphqlApisError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_graphql_apis_error(response)
        } else {
            crate::operation_deser::parse_list_graphql_apis_response(response)
        }
    }
}

/// Operation shape for `ListResolvers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolvers`](crate::client::Client::list_resolvers).
///
/// See [`crate::client::fluent_builders::ListResolvers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolvers {
    _private: (),
}
impl ListResolvers {
    /// Creates a new builder-style object to manufacture [`ListResolversInput`](crate::input::ListResolversInput)
    pub fn builder() -> crate::input::list_resolvers_input::Builder {
        crate::input::list_resolvers_input::Builder::default()
    }
    /// Creates a new `ListResolvers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolvers {
    type Output =
        std::result::Result<crate::output::ListResolversOutput, crate::error::ListResolversError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolvers_error(response)
        } else {
            crate::operation_deser::parse_list_resolvers_response(response)
        }
    }
}

/// Operation shape for `ListResolversByFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resolvers_by_function`](crate::client::Client::list_resolvers_by_function).
///
/// See [`crate::client::fluent_builders::ListResolversByFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResolversByFunction {
    _private: (),
}
impl ListResolversByFunction {
    /// Creates a new builder-style object to manufacture [`ListResolversByFunctionInput`](crate::input::ListResolversByFunctionInput)
    pub fn builder() -> crate::input::list_resolvers_by_function_input::Builder {
        crate::input::list_resolvers_by_function_input::Builder::default()
    }
    /// Creates a new `ListResolversByFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResolversByFunction {
    type Output = std::result::Result<
        crate::output::ListResolversByFunctionOutput,
        crate::error::ListResolversByFunctionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resolvers_by_function_error(response)
        } else {
            crate::operation_deser::parse_list_resolvers_by_function_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_types`](crate::client::Client::list_types).
///
/// See [`crate::client::fluent_builders::ListTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTypes {
    _private: (),
}
impl ListTypes {
    /// Creates a new builder-style object to manufacture [`ListTypesInput`](crate::input::ListTypesInput)
    pub fn builder() -> crate::input::list_types_input::Builder {
        crate::input::list_types_input::Builder::default()
    }
    /// Creates a new `ListTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTypes {
    type Output = std::result::Result<crate::output::ListTypesOutput, crate::error::ListTypesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_types_error(response)
        } else {
            crate::operation_deser::parse_list_types_response(response)
        }
    }
}

/// Operation shape for `StartSchemaCreation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_schema_creation`](crate::client::Client::start_schema_creation).
///
/// See [`crate::client::fluent_builders::StartSchemaCreation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartSchemaCreation {
    _private: (),
}
impl StartSchemaCreation {
    /// Creates a new builder-style object to manufacture [`StartSchemaCreationInput`](crate::input::StartSchemaCreationInput)
    pub fn builder() -> crate::input::start_schema_creation_input::Builder {
        crate::input::start_schema_creation_input::Builder::default()
    }
    /// Creates a new `StartSchemaCreation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartSchemaCreation {
    type Output = std::result::Result<
        crate::output::StartSchemaCreationOutput,
        crate::error::StartSchemaCreationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_schema_creation_error(response)
        } else {
            crate::operation_deser::parse_start_schema_creation_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateApiCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_api_cache`](crate::client::Client::update_api_cache).
///
/// See [`crate::client::fluent_builders::UpdateApiCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApiCache {
    _private: (),
}
impl UpdateApiCache {
    /// Creates a new builder-style object to manufacture [`UpdateApiCacheInput`](crate::input::UpdateApiCacheInput)
    pub fn builder() -> crate::input::update_api_cache_input::Builder {
        crate::input::update_api_cache_input::Builder::default()
    }
    /// Creates a new `UpdateApiCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApiCache {
    type Output =
        std::result::Result<crate::output::UpdateApiCacheOutput, crate::error::UpdateApiCacheError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_api_cache_error(response)
        } else {
            crate::operation_deser::parse_update_api_cache_response(response)
        }
    }
}

/// Operation shape for `UpdateApiKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_api_key`](crate::client::Client::update_api_key).
///
/// See [`crate::client::fluent_builders::UpdateApiKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateApiKey {
    _private: (),
}
impl UpdateApiKey {
    /// Creates a new builder-style object to manufacture [`UpdateApiKeyInput`](crate::input::UpdateApiKeyInput)
    pub fn builder() -> crate::input::update_api_key_input::Builder {
        crate::input::update_api_key_input::Builder::default()
    }
    /// Creates a new `UpdateApiKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateApiKey {
    type Output =
        std::result::Result<crate::output::UpdateApiKeyOutput, crate::error::UpdateApiKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_api_key_error(response)
        } else {
            crate::operation_deser::parse_update_api_key_response(response)
        }
    }
}

/// Operation shape for `UpdateDataSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_data_source`](crate::client::Client::update_data_source).
///
/// See [`crate::client::fluent_builders::UpdateDataSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDataSource {
    _private: (),
}
impl UpdateDataSource {
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    pub fn builder() -> crate::input::update_data_source_input::Builder {
        crate::input::update_data_source_input::Builder::default()
    }
    /// Creates a new `UpdateDataSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDataSource {
    type Output = std::result::Result<
        crate::output::UpdateDataSourceOutput,
        crate::error::UpdateDataSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_data_source_error(response)
        } else {
            crate::operation_deser::parse_update_data_source_response(response)
        }
    }
}

/// Operation shape for `UpdateFunction`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_function`](crate::client::Client::update_function).
///
/// See [`crate::client::fluent_builders::UpdateFunction`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFunction {
    _private: (),
}
impl UpdateFunction {
    /// Creates a new builder-style object to manufacture [`UpdateFunctionInput`](crate::input::UpdateFunctionInput)
    pub fn builder() -> crate::input::update_function_input::Builder {
        crate::input::update_function_input::Builder::default()
    }
    /// Creates a new `UpdateFunction` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFunction {
    type Output =
        std::result::Result<crate::output::UpdateFunctionOutput, crate::error::UpdateFunctionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_function_error(response)
        } else {
            crate::operation_deser::parse_update_function_response(response)
        }
    }
}

/// Operation shape for `UpdateGraphqlApi`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_graphql_api`](crate::client::Client::update_graphql_api).
///
/// See [`crate::client::fluent_builders::UpdateGraphqlApi`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGraphqlApi {
    _private: (),
}
impl UpdateGraphqlApi {
    /// Creates a new builder-style object to manufacture [`UpdateGraphqlApiInput`](crate::input::UpdateGraphqlApiInput)
    pub fn builder() -> crate::input::update_graphql_api_input::Builder {
        crate::input::update_graphql_api_input::Builder::default()
    }
    /// Creates a new `UpdateGraphqlApi` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGraphqlApi {
    type Output = std::result::Result<
        crate::output::UpdateGraphqlApiOutput,
        crate::error::UpdateGraphqlApiError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_graphql_api_error(response)
        } else {
            crate::operation_deser::parse_update_graphql_api_response(response)
        }
    }
}

/// Operation shape for `UpdateResolver`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_resolver`](crate::client::Client::update_resolver).
///
/// See [`crate::client::fluent_builders::UpdateResolver`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateResolver {
    _private: (),
}
impl UpdateResolver {
    /// Creates a new builder-style object to manufacture [`UpdateResolverInput`](crate::input::UpdateResolverInput)
    pub fn builder() -> crate::input::update_resolver_input::Builder {
        crate::input::update_resolver_input::Builder::default()
    }
    /// Creates a new `UpdateResolver` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateResolver {
    type Output =
        std::result::Result<crate::output::UpdateResolverOutput, crate::error::UpdateResolverError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_resolver_error(response)
        } else {
            crate::operation_deser::parse_update_resolver_response(response)
        }
    }
}

/// Operation shape for `UpdateType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_type`](crate::client::Client::update_type).
///
/// See [`crate::client::fluent_builders::UpdateType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateType {
    _private: (),
}
impl UpdateType {
    /// Creates a new builder-style object to manufacture [`UpdateTypeInput`](crate::input::UpdateTypeInput)
    pub fn builder() -> crate::input::update_type_input::Builder {
        crate::input::update_type_input::Builder::default()
    }
    /// Creates a new `UpdateType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateType {
    type Output =
        std::result::Result<crate::output::UpdateTypeOutput, crate::error::UpdateTypeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_type_error(response)
        } else {
            crate::operation_deser::parse_update_type_response(response)
        }
    }
}
