// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Type {
    /// <p>The type name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type definition.</p>
    pub definition: std::option::Option<std::string::String>,
    /// <p>The type format: SDL or JSON.</p>
    pub format: std::option::Option<crate::model::TypeDefinitionFormat>,
}
impl Type {
    /// <p>The type name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type definition.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
    /// <p>The type format: SDL or JSON.</p>
    pub fn format(&self) -> std::option::Option<&crate::model::TypeDefinitionFormat> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for Type {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Type");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("arn", &self.arn);
        formatter.field("definition", &self.definition);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}
/// See [`Type`](crate::model::Type)
pub mod r#type {
    /// A builder for [`Type`](crate::model::Type)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::TypeDefinitionFormat>,
    }
    impl Builder {
        /// <p>The type name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The type name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The type description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The type ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type definition.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The type definition.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, input: crate::model::TypeDefinitionFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`Type`](crate::model::Type)
        pub fn build(self) -> crate::model::Type {
            crate::model::Type {
                name: self.name,
                description: self.description,
                arn: self.arn,
                definition: self.definition,
                format: self.format,
            }
        }
    }
}
impl Type {
    /// Creates a new builder-style object to manufacture [`Type`](crate::model::Type)
    pub fn builder() -> crate::model::r#type::Builder {
        crate::model::r#type::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TypeDefinitionFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Sdl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TypeDefinitionFormat {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => TypeDefinitionFormat::Json,
            "SDL" => TypeDefinitionFormat::Sdl,
            other => TypeDefinitionFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TypeDefinitionFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TypeDefinitionFormat::from(s))
    }
}
impl TypeDefinitionFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TypeDefinitionFormat::Json => "JSON",
            TypeDefinitionFormat::Sdl => "SDL",
            TypeDefinitionFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "SDL"]
    }
}
impl AsRef<str> for TypeDefinitionFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a resolver.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Resolver {
    /// <p>The resolver type name.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The resolver field name.</p>
    pub field_name: std::option::Option<std::string::String>,
    /// <p>The resolver data source name.</p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The resolver ARN.</p>
    pub resolver_arn: std::option::Option<std::string::String>,
    /// <p>The request mapping template.</p>
    pub request_mapping_template: std::option::Option<std::string::String>,
    /// <p>The response mapping template.</p>
    pub response_mapping_template: std::option::Option<std::string::String>,
    /// <p>The resolver type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
    /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
    /// against a single data source.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
    /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
    /// You can use a pipeline resolver to execute a GraphQL query against multiple data
    /// sources.</p>
    /// </li>
    /// </ul>
    pub kind: std::option::Option<crate::model::ResolverKind>,
    /// <p>The <code>PipelineConfig</code>.</p>
    pub pipeline_config: std::option::Option<crate::model::PipelineConfig>,
    /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
    pub sync_config: std::option::Option<crate::model::SyncConfig>,
    /// <p>The caching configuration for the resolver.</p>
    pub caching_config: std::option::Option<crate::model::CachingConfig>,
}
impl Resolver {
    /// <p>The resolver type name.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The resolver field name.</p>
    pub fn field_name(&self) -> std::option::Option<&str> {
        self.field_name.as_deref()
    }
    /// <p>The resolver data source name.</p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The resolver ARN.</p>
    pub fn resolver_arn(&self) -> std::option::Option<&str> {
        self.resolver_arn.as_deref()
    }
    /// <p>The request mapping template.</p>
    pub fn request_mapping_template(&self) -> std::option::Option<&str> {
        self.request_mapping_template.as_deref()
    }
    /// <p>The response mapping template.</p>
    pub fn response_mapping_template(&self) -> std::option::Option<&str> {
        self.response_mapping_template.as_deref()
    }
    /// <p>The resolver type.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
    /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
    /// against a single data source.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
    /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
    /// You can use a pipeline resolver to execute a GraphQL query against multiple data
    /// sources.</p>
    /// </li>
    /// </ul>
    pub fn kind(&self) -> std::option::Option<&crate::model::ResolverKind> {
        self.kind.as_ref()
    }
    /// <p>The <code>PipelineConfig</code>.</p>
    pub fn pipeline_config(&self) -> std::option::Option<&crate::model::PipelineConfig> {
        self.pipeline_config.as_ref()
    }
    /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
    pub fn sync_config(&self) -> std::option::Option<&crate::model::SyncConfig> {
        self.sync_config.as_ref()
    }
    /// <p>The caching configuration for the resolver.</p>
    pub fn caching_config(&self) -> std::option::Option<&crate::model::CachingConfig> {
        self.caching_config.as_ref()
    }
}
impl std::fmt::Debug for Resolver {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Resolver");
        formatter.field("type_name", &self.type_name);
        formatter.field("field_name", &self.field_name);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("resolver_arn", &self.resolver_arn);
        formatter.field("request_mapping_template", &self.request_mapping_template);
        formatter.field("response_mapping_template", &self.response_mapping_template);
        formatter.field("kind", &self.kind);
        formatter.field("pipeline_config", &self.pipeline_config);
        formatter.field("sync_config", &self.sync_config);
        formatter.field("caching_config", &self.caching_config);
        formatter.finish()
    }
}
/// See [`Resolver`](crate::model::Resolver)
pub mod resolver {
    /// A builder for [`Resolver`](crate::model::Resolver)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) field_name: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) resolver_arn: std::option::Option<std::string::String>,
        pub(crate) request_mapping_template: std::option::Option<std::string::String>,
        pub(crate) response_mapping_template: std::option::Option<std::string::String>,
        pub(crate) kind: std::option::Option<crate::model::ResolverKind>,
        pub(crate) pipeline_config: std::option::Option<crate::model::PipelineConfig>,
        pub(crate) sync_config: std::option::Option<crate::model::SyncConfig>,
        pub(crate) caching_config: std::option::Option<crate::model::CachingConfig>,
    }
    impl Builder {
        /// <p>The resolver type name.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The resolver type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The resolver field name.</p>
        pub fn field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.field_name = Some(input.into());
            self
        }
        /// <p>The resolver field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field_name = input;
            self
        }
        /// <p>The resolver data source name.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>The resolver data source name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The resolver ARN.</p>
        pub fn resolver_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolver_arn = Some(input.into());
            self
        }
        /// <p>The resolver ARN.</p>
        pub fn set_resolver_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resolver_arn = input;
            self
        }
        /// <p>The request mapping template.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_mapping_template = Some(input.into());
            self
        }
        /// <p>The request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_mapping_template = input;
            self
        }
        /// <p>The response mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_mapping_template = Some(input.into());
            self
        }
        /// <p>The response mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_mapping_template = input;
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
        /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
        /// against a single data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
        /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
        /// You can use a pipeline resolver to execute a GraphQL query against multiple data
        /// sources.</p>
        /// </li>
        /// </ul>
        pub fn kind(mut self, input: crate::model::ResolverKind) -> Self {
            self.kind = Some(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
        /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
        /// against a single data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
        /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
        /// You can use a pipeline resolver to execute a GraphQL query against multiple data
        /// sources.</p>
        /// </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::ResolverKind>) -> Self {
            self.kind = input;
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn pipeline_config(mut self, input: crate::model::PipelineConfig) -> Self {
            self.pipeline_config = Some(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn set_pipeline_config(
            mut self,
            input: std::option::Option<crate::model::PipelineConfig>,
        ) -> Self {
            self.pipeline_config = input;
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.sync_config = Some(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.sync_config = input;
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn caching_config(mut self, input: crate::model::CachingConfig) -> Self {
            self.caching_config = Some(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn set_caching_config(
            mut self,
            input: std::option::Option<crate::model::CachingConfig>,
        ) -> Self {
            self.caching_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Resolver`](crate::model::Resolver)
        pub fn build(self) -> crate::model::Resolver {
            crate::model::Resolver {
                type_name: self.type_name,
                field_name: self.field_name,
                data_source_name: self.data_source_name,
                resolver_arn: self.resolver_arn,
                request_mapping_template: self.request_mapping_template,
                response_mapping_template: self.response_mapping_template,
                kind: self.kind,
                pipeline_config: self.pipeline_config,
                sync_config: self.sync_config,
                caching_config: self.caching_config,
            }
        }
    }
}
impl Resolver {
    /// Creates a new builder-style object to manufacture [`Resolver`](crate::model::Resolver)
    pub fn builder() -> crate::model::resolver::Builder {
        crate::model::resolver::Builder::default()
    }
}

/// <p>The caching configuration for a resolver that has caching enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CachingConfig {
    /// <p>The TTL in seconds for a resolver that has caching enabled.</p>
    /// <p>Valid values are between 1 and 3600 seconds.</p>
    pub ttl: i64,
    /// <p>The caching keys for a resolver that has caching enabled.</p>
    /// <p>Valid values are entries from the <code>$context.arguments</code>,
    /// <code>$context.source</code>, and <code>$context.identity</code> maps.</p>
    pub caching_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CachingConfig {
    /// <p>The TTL in seconds for a resolver that has caching enabled.</p>
    /// <p>Valid values are between 1 and 3600 seconds.</p>
    pub fn ttl(&self) -> i64 {
        self.ttl
    }
    /// <p>The caching keys for a resolver that has caching enabled.</p>
    /// <p>Valid values are entries from the <code>$context.arguments</code>,
    /// <code>$context.source</code>, and <code>$context.identity</code> maps.</p>
    pub fn caching_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.caching_keys.as_deref()
    }
}
impl std::fmt::Debug for CachingConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CachingConfig");
        formatter.field("ttl", &self.ttl);
        formatter.field("caching_keys", &self.caching_keys);
        formatter.finish()
    }
}
/// See [`CachingConfig`](crate::model::CachingConfig)
pub mod caching_config {
    /// A builder for [`CachingConfig`](crate::model::CachingConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ttl: std::option::Option<i64>,
        pub(crate) caching_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The TTL in seconds for a resolver that has caching enabled.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>The TTL in seconds for a resolver that has caching enabled.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// Appends an item to `caching_keys`.
        ///
        /// To override the contents of this collection use [`set_caching_keys`](Self::set_caching_keys).
        ///
        /// <p>The caching keys for a resolver that has caching enabled.</p>
        /// <p>Valid values are entries from the <code>$context.arguments</code>,
        /// <code>$context.source</code>, and <code>$context.identity</code> maps.</p>
        pub fn caching_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.caching_keys.unwrap_or_default();
            v.push(input.into());
            self.caching_keys = Some(v);
            self
        }
        /// <p>The caching keys for a resolver that has caching enabled.</p>
        /// <p>Valid values are entries from the <code>$context.arguments</code>,
        /// <code>$context.source</code>, and <code>$context.identity</code> maps.</p>
        pub fn set_caching_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.caching_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`CachingConfig`](crate::model::CachingConfig)
        pub fn build(self) -> crate::model::CachingConfig {
            crate::model::CachingConfig {
                ttl: self.ttl.unwrap_or_default(),
                caching_keys: self.caching_keys,
            }
        }
    }
}
impl CachingConfig {
    /// Creates a new builder-style object to manufacture [`CachingConfig`](crate::model::CachingConfig)
    pub fn builder() -> crate::model::caching_config::Builder {
        crate::model::caching_config::Builder::default()
    }
}

/// <p>Describes a Sync configuration for a resolver.</p>
/// <p>Contains information on which Conflict Detection as well as Resolution strategy should
/// be performed when the resolver is invoked.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SyncConfig {
    /// <p>The Conflict Resolution strategy to perform in the event of a conflict.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by
    /// rejecting mutations when versions do not match the latest version at the
    /// server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AUTOMERGE</b>: Resolve conflicts with the
    /// Automerge conflict resolution strategy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>LAMBDA</b>: Resolve conflicts with a Lambda
    /// function supplied in the LambdaConflictHandlerConfig.</p>
    /// </li>
    /// </ul>
    pub conflict_handler: std::option::Option<crate::model::ConflictHandlerType>,
    /// <p>The Conflict Detection strategy to use.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>VERSION</b>: Detect conflicts based on object
    /// versions for this resolver.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>NONE</b>: Do not detect conflicts when executing
    /// this resolver.</p>
    /// </li>
    /// </ul>
    pub conflict_detection: std::option::Option<crate::model::ConflictDetectionType>,
    /// <p>The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict
    /// Handler.</p>
    pub lambda_conflict_handler_config:
        std::option::Option<crate::model::LambdaConflictHandlerConfig>,
}
impl SyncConfig {
    /// <p>The Conflict Resolution strategy to perform in the event of a conflict.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by
    /// rejecting mutations when versions do not match the latest version at the
    /// server.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AUTOMERGE</b>: Resolve conflicts with the
    /// Automerge conflict resolution strategy.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>LAMBDA</b>: Resolve conflicts with a Lambda
    /// function supplied in the LambdaConflictHandlerConfig.</p>
    /// </li>
    /// </ul>
    pub fn conflict_handler(&self) -> std::option::Option<&crate::model::ConflictHandlerType> {
        self.conflict_handler.as_ref()
    }
    /// <p>The Conflict Detection strategy to use.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>VERSION</b>: Detect conflicts based on object
    /// versions for this resolver.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>NONE</b>: Do not detect conflicts when executing
    /// this resolver.</p>
    /// </li>
    /// </ul>
    pub fn conflict_detection(&self) -> std::option::Option<&crate::model::ConflictDetectionType> {
        self.conflict_detection.as_ref()
    }
    /// <p>The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict
    /// Handler.</p>
    pub fn lambda_conflict_handler_config(
        &self,
    ) -> std::option::Option<&crate::model::LambdaConflictHandlerConfig> {
        self.lambda_conflict_handler_config.as_ref()
    }
}
impl std::fmt::Debug for SyncConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SyncConfig");
        formatter.field("conflict_handler", &self.conflict_handler);
        formatter.field("conflict_detection", &self.conflict_detection);
        formatter.field(
            "lambda_conflict_handler_config",
            &self.lambda_conflict_handler_config,
        );
        formatter.finish()
    }
}
/// See [`SyncConfig`](crate::model::SyncConfig)
pub mod sync_config {
    /// A builder for [`SyncConfig`](crate::model::SyncConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conflict_handler: std::option::Option<crate::model::ConflictHandlerType>,
        pub(crate) conflict_detection: std::option::Option<crate::model::ConflictDetectionType>,
        pub(crate) lambda_conflict_handler_config:
            std::option::Option<crate::model::LambdaConflictHandlerConfig>,
    }
    impl Builder {
        /// <p>The Conflict Resolution strategy to perform in the event of a conflict.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by
        /// rejecting mutations when versions do not match the latest version at the
        /// server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AUTOMERGE</b>: Resolve conflicts with the
        /// Automerge conflict resolution strategy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>LAMBDA</b>: Resolve conflicts with a Lambda
        /// function supplied in the LambdaConflictHandlerConfig.</p>
        /// </li>
        /// </ul>
        pub fn conflict_handler(mut self, input: crate::model::ConflictHandlerType) -> Self {
            self.conflict_handler = Some(input);
            self
        }
        /// <p>The Conflict Resolution strategy to perform in the event of a conflict.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>OPTIMISTIC_CONCURRENCY</b>: Resolve conflicts by
        /// rejecting mutations when versions do not match the latest version at the
        /// server.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AUTOMERGE</b>: Resolve conflicts with the
        /// Automerge conflict resolution strategy.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>LAMBDA</b>: Resolve conflicts with a Lambda
        /// function supplied in the LambdaConflictHandlerConfig.</p>
        /// </li>
        /// </ul>
        pub fn set_conflict_handler(
            mut self,
            input: std::option::Option<crate::model::ConflictHandlerType>,
        ) -> Self {
            self.conflict_handler = input;
            self
        }
        /// <p>The Conflict Detection strategy to use.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>VERSION</b>: Detect conflicts based on object
        /// versions for this resolver.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NONE</b>: Do not detect conflicts when executing
        /// this resolver.</p>
        /// </li>
        /// </ul>
        pub fn conflict_detection(mut self, input: crate::model::ConflictDetectionType) -> Self {
            self.conflict_detection = Some(input);
            self
        }
        /// <p>The Conflict Detection strategy to use.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>VERSION</b>: Detect conflicts based on object
        /// versions for this resolver.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NONE</b>: Do not detect conflicts when executing
        /// this resolver.</p>
        /// </li>
        /// </ul>
        pub fn set_conflict_detection(
            mut self,
            input: std::option::Option<crate::model::ConflictDetectionType>,
        ) -> Self {
            self.conflict_detection = input;
            self
        }
        /// <p>The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict
        /// Handler.</p>
        pub fn lambda_conflict_handler_config(
            mut self,
            input: crate::model::LambdaConflictHandlerConfig,
        ) -> Self {
            self.lambda_conflict_handler_config = Some(input);
            self
        }
        /// <p>The <code>LambdaConflictHandlerConfig</code> when configuring LAMBDA as the Conflict
        /// Handler.</p>
        pub fn set_lambda_conflict_handler_config(
            mut self,
            input: std::option::Option<crate::model::LambdaConflictHandlerConfig>,
        ) -> Self {
            self.lambda_conflict_handler_config = input;
            self
        }
        /// Consumes the builder and constructs a [`SyncConfig`](crate::model::SyncConfig)
        pub fn build(self) -> crate::model::SyncConfig {
            crate::model::SyncConfig {
                conflict_handler: self.conflict_handler,
                conflict_detection: self.conflict_detection,
                lambda_conflict_handler_config: self.lambda_conflict_handler_config,
            }
        }
    }
}
impl SyncConfig {
    /// Creates a new builder-style object to manufacture [`SyncConfig`](crate::model::SyncConfig)
    pub fn builder() -> crate::model::sync_config::Builder {
        crate::model::sync_config::Builder::default()
    }
}

/// <p>The <code>LambdaConflictHandlerConfig</code> object when configuring LAMBDA as the
/// Conflict Handler.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaConflictHandlerConfig {
    /// <p>The Arn for the Lambda function to use as the Conflict Handler.</p>
    pub lambda_conflict_handler_arn: std::option::Option<std::string::String>,
}
impl LambdaConflictHandlerConfig {
    /// <p>The Arn for the Lambda function to use as the Conflict Handler.</p>
    pub fn lambda_conflict_handler_arn(&self) -> std::option::Option<&str> {
        self.lambda_conflict_handler_arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaConflictHandlerConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaConflictHandlerConfig");
        formatter.field(
            "lambda_conflict_handler_arn",
            &self.lambda_conflict_handler_arn,
        );
        formatter.finish()
    }
}
/// See [`LambdaConflictHandlerConfig`](crate::model::LambdaConflictHandlerConfig)
pub mod lambda_conflict_handler_config {
    /// A builder for [`LambdaConflictHandlerConfig`](crate::model::LambdaConflictHandlerConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_conflict_handler_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Arn for the Lambda function to use as the Conflict Handler.</p>
        pub fn lambda_conflict_handler_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.lambda_conflict_handler_arn = Some(input.into());
            self
        }
        /// <p>The Arn for the Lambda function to use as the Conflict Handler.</p>
        pub fn set_lambda_conflict_handler_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_conflict_handler_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaConflictHandlerConfig`](crate::model::LambdaConflictHandlerConfig)
        pub fn build(self) -> crate::model::LambdaConflictHandlerConfig {
            crate::model::LambdaConflictHandlerConfig {
                lambda_conflict_handler_arn: self.lambda_conflict_handler_arn,
            }
        }
    }
}
impl LambdaConflictHandlerConfig {
    /// Creates a new builder-style object to manufacture [`LambdaConflictHandlerConfig`](crate::model::LambdaConflictHandlerConfig)
    pub fn builder() -> crate::model::lambda_conflict_handler_config::Builder {
        crate::model::lambda_conflict_handler_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConflictDetectionType {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Version,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConflictDetectionType {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ConflictDetectionType::None,
            "VERSION" => ConflictDetectionType::Version,
            other => ConflictDetectionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConflictDetectionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConflictDetectionType::from(s))
    }
}
impl ConflictDetectionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConflictDetectionType::None => "NONE",
            ConflictDetectionType::Version => "VERSION",
            ConflictDetectionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "VERSION"]
    }
}
impl AsRef<str> for ConflictDetectionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConflictHandlerType {
    #[allow(missing_docs)] // documentation missing in model
    Automerge,
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    OptimisticConcurrency,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConflictHandlerType {
    fn from(s: &str) -> Self {
        match s {
            "AUTOMERGE" => ConflictHandlerType::Automerge,
            "LAMBDA" => ConflictHandlerType::Lambda,
            "NONE" => ConflictHandlerType::None,
            "OPTIMISTIC_CONCURRENCY" => ConflictHandlerType::OptimisticConcurrency,
            other => ConflictHandlerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConflictHandlerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConflictHandlerType::from(s))
    }
}
impl ConflictHandlerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConflictHandlerType::Automerge => "AUTOMERGE",
            ConflictHandlerType::Lambda => "LAMBDA",
            ConflictHandlerType::None => "NONE",
            ConflictHandlerType::OptimisticConcurrency => "OPTIMISTIC_CONCURRENCY",
            ConflictHandlerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTOMERGE", "LAMBDA", "NONE", "OPTIMISTIC_CONCURRENCY"]
    }
}
impl AsRef<str> for ConflictHandlerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The pipeline configuration for a resolver of kind <code>PIPELINE</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineConfig {
    /// <p>A list of <code>Function</code> objects.</p>
    pub functions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PipelineConfig {
    /// <p>A list of <code>Function</code> objects.</p>
    pub fn functions(&self) -> std::option::Option<&[std::string::String]> {
        self.functions.as_deref()
    }
}
impl std::fmt::Debug for PipelineConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineConfig");
        formatter.field("functions", &self.functions);
        formatter.finish()
    }
}
/// See [`PipelineConfig`](crate::model::PipelineConfig)
pub mod pipeline_config {
    /// A builder for [`PipelineConfig`](crate::model::PipelineConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) functions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `functions`.
        ///
        /// To override the contents of this collection use [`set_functions`](Self::set_functions).
        ///
        /// <p>A list of <code>Function</code> objects.</p>
        pub fn functions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.functions.unwrap_or_default();
            v.push(input.into());
            self.functions = Some(v);
            self
        }
        /// <p>A list of <code>Function</code> objects.</p>
        pub fn set_functions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.functions = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineConfig`](crate::model::PipelineConfig)
        pub fn build(self) -> crate::model::PipelineConfig {
            crate::model::PipelineConfig {
                functions: self.functions,
            }
        }
    }
}
impl PipelineConfig {
    /// Creates a new builder-style object to manufacture [`PipelineConfig`](crate::model::PipelineConfig)
    pub fn builder() -> crate::model::pipeline_config::Builder {
        crate::model::pipeline_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResolverKind {
    #[allow(missing_docs)] // documentation missing in model
    Pipeline,
    #[allow(missing_docs)] // documentation missing in model
    Unit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResolverKind {
    fn from(s: &str) -> Self {
        match s {
            "PIPELINE" => ResolverKind::Pipeline,
            "UNIT" => ResolverKind::Unit,
            other => ResolverKind::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResolverKind {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResolverKind::from(s))
    }
}
impl ResolverKind {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResolverKind::Pipeline => "PIPELINE",
            ResolverKind::Unit => "UNIT",
            ResolverKind::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PIPELINE", "UNIT"]
    }
}
impl AsRef<str> for ResolverKind {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a GraphQL API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GraphqlApi {
    /// <p>The API name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The API ID.</p>
    pub api_id: std::option::Option<std::string::String>,
    /// <p>The authentication type.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The Amazon CloudWatch Logs configuration.</p>
    pub log_config: std::option::Option<crate::model::LogConfig>,
    /// <p>The Amazon Cognito user pool configuration.</p>
    pub user_pool_config: std::option::Option<crate::model::UserPoolConfig>,
    /// <p>The OpenID Connect configuration.</p>
    pub open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
    /// <p>The ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The URIs.</p>
    pub uris:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
    /// API.</p>
    pub additional_authentication_providers:
        std::option::Option<std::vec::Vec<crate::model::AdditionalAuthenticationProvider>>,
    /// <p>A flag representing whether X-Ray tracing is enabled for this
    /// <code>GraphqlApi</code>.</p>
    pub xray_enabled: bool,
    /// <p>The ARN of the WAF ACL associated with this <code>GraphqlApi</code>,
    /// if one exists.</p>
    pub waf_web_acl_arn: std::option::Option<std::string::String>,
    /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
    pub lambda_authorizer_config: std::option::Option<crate::model::LambdaAuthorizerConfig>,
}
impl GraphqlApi {
    /// <p>The API name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The API ID.</p>
    pub fn api_id(&self) -> std::option::Option<&str> {
        self.api_id.as_deref()
    }
    /// <p>The authentication type.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The Amazon CloudWatch Logs configuration.</p>
    pub fn log_config(&self) -> std::option::Option<&crate::model::LogConfig> {
        self.log_config.as_ref()
    }
    /// <p>The Amazon Cognito user pool configuration.</p>
    pub fn user_pool_config(&self) -> std::option::Option<&crate::model::UserPoolConfig> {
        self.user_pool_config.as_ref()
    }
    /// <p>The OpenID Connect configuration.</p>
    pub fn open_id_connect_config(
        &self,
    ) -> std::option::Option<&crate::model::OpenIdConnectConfig> {
        self.open_id_connect_config.as_ref()
    }
    /// <p>The ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The URIs.</p>
    pub fn uris(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.uris.as_ref()
    }
    /// <p>The tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
    /// API.</p>
    pub fn additional_authentication_providers(
        &self,
    ) -> std::option::Option<&[crate::model::AdditionalAuthenticationProvider]> {
        self.additional_authentication_providers.as_deref()
    }
    /// <p>A flag representing whether X-Ray tracing is enabled for this
    /// <code>GraphqlApi</code>.</p>
    pub fn xray_enabled(&self) -> bool {
        self.xray_enabled
    }
    /// <p>The ARN of the WAF ACL associated with this <code>GraphqlApi</code>,
    /// if one exists.</p>
    pub fn waf_web_acl_arn(&self) -> std::option::Option<&str> {
        self.waf_web_acl_arn.as_deref()
    }
    /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
    pub fn lambda_authorizer_config(
        &self,
    ) -> std::option::Option<&crate::model::LambdaAuthorizerConfig> {
        self.lambda_authorizer_config.as_ref()
    }
}
impl std::fmt::Debug for GraphqlApi {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GraphqlApi");
        formatter.field("name", &self.name);
        formatter.field("api_id", &self.api_id);
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("log_config", &self.log_config);
        formatter.field("user_pool_config", &self.user_pool_config);
        formatter.field("open_id_connect_config", &self.open_id_connect_config);
        formatter.field("arn", &self.arn);
        formatter.field("uris", &self.uris);
        formatter.field("tags", &self.tags);
        formatter.field(
            "additional_authentication_providers",
            &self.additional_authentication_providers,
        );
        formatter.field("xray_enabled", &self.xray_enabled);
        formatter.field("waf_web_acl_arn", &self.waf_web_acl_arn);
        formatter.field("lambda_authorizer_config", &self.lambda_authorizer_config);
        formatter.finish()
    }
}
/// See [`GraphqlApi`](crate::model::GraphqlApi)
pub mod graphql_api {
    /// A builder for [`GraphqlApi`](crate::model::GraphqlApi)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) api_id: std::option::Option<std::string::String>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) log_config: std::option::Option<crate::model::LogConfig>,
        pub(crate) user_pool_config: std::option::Option<crate::model::UserPoolConfig>,
        pub(crate) open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) uris: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) additional_authentication_providers:
            std::option::Option<std::vec::Vec<crate::model::AdditionalAuthenticationProvider>>,
        pub(crate) xray_enabled: std::option::Option<bool>,
        pub(crate) waf_web_acl_arn: std::option::Option<std::string::String>,
        pub(crate) lambda_authorizer_config:
            std::option::Option<crate::model::LambdaAuthorizerConfig>,
    }
    impl Builder {
        /// <p>The API name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The API name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_id = Some(input.into());
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_id = input;
            self
        }
        /// <p>The authentication type.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn log_config(mut self, input: crate::model::LogConfig) -> Self {
            self.log_config = Some(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogConfig>,
        ) -> Self {
            self.log_config = input;
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn user_pool_config(mut self, input: crate::model::UserPoolConfig) -> Self {
            self.user_pool_config = Some(input);
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::UserPoolConfig>,
        ) -> Self {
            self.user_pool_config = input;
            self
        }
        /// <p>The OpenID Connect configuration.</p>
        pub fn open_id_connect_config(mut self, input: crate::model::OpenIdConnectConfig) -> Self {
            self.open_id_connect_config = Some(input);
            self
        }
        /// <p>The OpenID Connect configuration.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.open_id_connect_config = input;
            self
        }
        /// <p>The ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Adds a key-value pair to `uris`.
        ///
        /// To override the contents of this collection use [`set_uris`](Self::set_uris).
        ///
        /// <p>The URIs.</p>
        pub fn uris(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.uris.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.uris = Some(hash_map);
            self
        }
        /// <p>The URIs.</p>
        pub fn set_uris(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.uris = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `additional_authentication_providers`.
        ///
        /// To override the contents of this collection use [`set_additional_authentication_providers`](Self::set_additional_authentication_providers).
        ///
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
        /// API.</p>
        pub fn additional_authentication_providers(
            mut self,
            input: impl Into<crate::model::AdditionalAuthenticationProvider>,
        ) -> Self {
            let mut v = self.additional_authentication_providers.unwrap_or_default();
            v.push(input.into());
            self.additional_authentication_providers = Some(v);
            self
        }
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
        /// API.</p>
        pub fn set_additional_authentication_providers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalAuthenticationProvider>,
            >,
        ) -> Self {
            self.additional_authentication_providers = input;
            self
        }
        /// <p>A flag representing whether X-Ray tracing is enabled for this
        /// <code>GraphqlApi</code>.</p>
        pub fn xray_enabled(mut self, input: bool) -> Self {
            self.xray_enabled = Some(input);
            self
        }
        /// <p>A flag representing whether X-Ray tracing is enabled for this
        /// <code>GraphqlApi</code>.</p>
        pub fn set_xray_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.xray_enabled = input;
            self
        }
        /// <p>The ARN of the WAF ACL associated with this <code>GraphqlApi</code>,
        /// if one exists.</p>
        pub fn waf_web_acl_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.waf_web_acl_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the WAF ACL associated with this <code>GraphqlApi</code>,
        /// if one exists.</p>
        pub fn set_waf_web_acl_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.waf_web_acl_arn = input;
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            input: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.lambda_authorizer_config = Some(input);
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.lambda_authorizer_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GraphqlApi`](crate::model::GraphqlApi)
        pub fn build(self) -> crate::model::GraphqlApi {
            crate::model::GraphqlApi {
                name: self.name,
                api_id: self.api_id,
                authentication_type: self.authentication_type,
                log_config: self.log_config,
                user_pool_config: self.user_pool_config,
                open_id_connect_config: self.open_id_connect_config,
                arn: self.arn,
                uris: self.uris,
                tags: self.tags,
                additional_authentication_providers: self.additional_authentication_providers,
                xray_enabled: self.xray_enabled.unwrap_or_default(),
                waf_web_acl_arn: self.waf_web_acl_arn,
                lambda_authorizer_config: self.lambda_authorizer_config,
            }
        }
    }
}
impl GraphqlApi {
    /// Creates a new builder-style object to manufacture [`GraphqlApi`](crate::model::GraphqlApi)
    pub fn builder() -> crate::model::graphql_api::Builder {
        crate::model::graphql_api::Builder::default()
    }
}

/// <p>A <code>LambdaAuthorizerConfig</code> holds configuration on how to authorize AppSync
/// API access when using the <code>AWS_LAMBDA</code> authorizer mode. Be aware that an AppSync
/// API may have only one Lambda authorizer configured at a time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaAuthorizerConfig {
    /// <p>The number of seconds a response should be cached for. The default is 5 minutes (300
    /// seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key
    /// in its response. A value of 0 disables caching of responses.</p>
    pub authorizer_result_ttl_in_seconds: i32,
    /// <p>The ARN of the Lambda function to be called for authorization. This may be a standard
    /// Lambda ARN, a version ARN (<code>.../v3</code>) or alias ARN. </p>
    /// <p>
    /// <i>Note</i>: This Lambda function must have the following resource-based
    /// policy assigned to it. When configuring Lambda authorizers in the Console, this is done for
    /// you. To do so with the Amazon Web Services CLI, run the following:</p>
    /// <p>
    /// <code>aws lambda add-permission --function-name
    /// "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync"
    /// --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
    /// </p>
    pub authorizer_uri: std::option::Option<std::string::String>,
    /// <p>A regular expression for validation of tokens before the Lambda function is
    /// called.</p>
    pub identity_validation_expression: std::option::Option<std::string::String>,
}
impl LambdaAuthorizerConfig {
    /// <p>The number of seconds a response should be cached for. The default is 5 minutes (300
    /// seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key
    /// in its response. A value of 0 disables caching of responses.</p>
    pub fn authorizer_result_ttl_in_seconds(&self) -> i32 {
        self.authorizer_result_ttl_in_seconds
    }
    /// <p>The ARN of the Lambda function to be called for authorization. This may be a standard
    /// Lambda ARN, a version ARN (<code>.../v3</code>) or alias ARN. </p>
    /// <p>
    /// <i>Note</i>: This Lambda function must have the following resource-based
    /// policy assigned to it. When configuring Lambda authorizers in the Console, this is done for
    /// you. To do so with the Amazon Web Services CLI, run the following:</p>
    /// <p>
    /// <code>aws lambda add-permission --function-name
    /// "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync"
    /// --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
    /// </p>
    pub fn authorizer_uri(&self) -> std::option::Option<&str> {
        self.authorizer_uri.as_deref()
    }
    /// <p>A regular expression for validation of tokens before the Lambda function is
    /// called.</p>
    pub fn identity_validation_expression(&self) -> std::option::Option<&str> {
        self.identity_validation_expression.as_deref()
    }
}
impl std::fmt::Debug for LambdaAuthorizerConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaAuthorizerConfig");
        formatter.field(
            "authorizer_result_ttl_in_seconds",
            &self.authorizer_result_ttl_in_seconds,
        );
        formatter.field("authorizer_uri", &self.authorizer_uri);
        formatter.field(
            "identity_validation_expression",
            &self.identity_validation_expression,
        );
        formatter.finish()
    }
}
/// See [`LambdaAuthorizerConfig`](crate::model::LambdaAuthorizerConfig)
pub mod lambda_authorizer_config {
    /// A builder for [`LambdaAuthorizerConfig`](crate::model::LambdaAuthorizerConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorizer_result_ttl_in_seconds: std::option::Option<i32>,
        pub(crate) authorizer_uri: std::option::Option<std::string::String>,
        pub(crate) identity_validation_expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of seconds a response should be cached for. The default is 5 minutes (300
        /// seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key
        /// in its response. A value of 0 disables caching of responses.</p>
        pub fn authorizer_result_ttl_in_seconds(mut self, input: i32) -> Self {
            self.authorizer_result_ttl_in_seconds = Some(input);
            self
        }
        /// <p>The number of seconds a response should be cached for. The default is 5 minutes (300
        /// seconds). The Lambda function can override this by returning a <code>ttlOverride</code> key
        /// in its response. A value of 0 disables caching of responses.</p>
        pub fn set_authorizer_result_ttl_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.authorizer_result_ttl_in_seconds = input;
            self
        }
        /// <p>The ARN of the Lambda function to be called for authorization. This may be a standard
        /// Lambda ARN, a version ARN (<code>.../v3</code>) or alias ARN. </p>
        /// <p>
        /// <i>Note</i>: This Lambda function must have the following resource-based
        /// policy assigned to it. When configuring Lambda authorizers in the Console, this is done for
        /// you. To do so with the Amazon Web Services CLI, run the following:</p>
        /// <p>
        /// <code>aws lambda add-permission --function-name
        /// "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync"
        /// --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
        /// </p>
        pub fn authorizer_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorizer_uri = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function to be called for authorization. This may be a standard
        /// Lambda ARN, a version ARN (<code>.../v3</code>) or alias ARN. </p>
        /// <p>
        /// <i>Note</i>: This Lambda function must have the following resource-based
        /// policy assigned to it. When configuring Lambda authorizers in the Console, this is done for
        /// you. To do so with the Amazon Web Services CLI, run the following:</p>
        /// <p>
        /// <code>aws lambda add-permission --function-name
        /// "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync"
        /// --principal appsync.amazonaws.com --action lambda:InvokeFunction</code>
        /// </p>
        pub fn set_authorizer_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorizer_uri = input;
            self
        }
        /// <p>A regular expression for validation of tokens before the Lambda function is
        /// called.</p>
        pub fn identity_validation_expression(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = Some(input.into());
            self
        }
        /// <p>A regular expression for validation of tokens before the Lambda function is
        /// called.</p>
        pub fn set_identity_validation_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.identity_validation_expression = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaAuthorizerConfig`](crate::model::LambdaAuthorizerConfig)
        pub fn build(self) -> crate::model::LambdaAuthorizerConfig {
            crate::model::LambdaAuthorizerConfig {
                authorizer_result_ttl_in_seconds: self
                    .authorizer_result_ttl_in_seconds
                    .unwrap_or_default(),
                authorizer_uri: self.authorizer_uri,
                identity_validation_expression: self.identity_validation_expression,
            }
        }
    }
}
impl LambdaAuthorizerConfig {
    /// Creates a new builder-style object to manufacture [`LambdaAuthorizerConfig`](crate::model::LambdaAuthorizerConfig)
    pub fn builder() -> crate::model::lambda_authorizer_config::Builder {
        crate::model::lambda_authorizer_config::Builder::default()
    }
}

/// <p>Describes an additional authentication provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdditionalAuthenticationProvider {
    /// <p>The authentication type: API key, Identity and Access Management, OIDC, Amazon Cognito user
    /// pools, or Amazon Web Services Lambda.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The OpenID Connect configuration.</p>
    pub open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
    /// <p>The Amazon Cognito user pool configuration.</p>
    pub user_pool_config: std::option::Option<crate::model::CognitoUserPoolConfig>,
    /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
    pub lambda_authorizer_config: std::option::Option<crate::model::LambdaAuthorizerConfig>,
}
impl AdditionalAuthenticationProvider {
    /// <p>The authentication type: API key, Identity and Access Management, OIDC, Amazon Cognito user
    /// pools, or Amazon Web Services Lambda.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The OpenID Connect configuration.</p>
    pub fn open_id_connect_config(
        &self,
    ) -> std::option::Option<&crate::model::OpenIdConnectConfig> {
        self.open_id_connect_config.as_ref()
    }
    /// <p>The Amazon Cognito user pool configuration.</p>
    pub fn user_pool_config(&self) -> std::option::Option<&crate::model::CognitoUserPoolConfig> {
        self.user_pool_config.as_ref()
    }
    /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
    pub fn lambda_authorizer_config(
        &self,
    ) -> std::option::Option<&crate::model::LambdaAuthorizerConfig> {
        self.lambda_authorizer_config.as_ref()
    }
}
impl std::fmt::Debug for AdditionalAuthenticationProvider {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdditionalAuthenticationProvider");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("open_id_connect_config", &self.open_id_connect_config);
        formatter.field("user_pool_config", &self.user_pool_config);
        formatter.field("lambda_authorizer_config", &self.lambda_authorizer_config);
        formatter.finish()
    }
}
/// See [`AdditionalAuthenticationProvider`](crate::model::AdditionalAuthenticationProvider)
pub mod additional_authentication_provider {
    /// A builder for [`AdditionalAuthenticationProvider`](crate::model::AdditionalAuthenticationProvider)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) open_id_connect_config: std::option::Option<crate::model::OpenIdConnectConfig>,
        pub(crate) user_pool_config: std::option::Option<crate::model::CognitoUserPoolConfig>,
        pub(crate) lambda_authorizer_config:
            std::option::Option<crate::model::LambdaAuthorizerConfig>,
    }
    impl Builder {
        /// <p>The authentication type: API key, Identity and Access Management, OIDC, Amazon Cognito user
        /// pools, or Amazon Web Services Lambda.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type: API key, Identity and Access Management, OIDC, Amazon Cognito user
        /// pools, or Amazon Web Services Lambda.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The OpenID Connect configuration.</p>
        pub fn open_id_connect_config(mut self, input: crate::model::OpenIdConnectConfig) -> Self {
            self.open_id_connect_config = Some(input);
            self
        }
        /// <p>The OpenID Connect configuration.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.open_id_connect_config = input;
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn user_pool_config(mut self, input: crate::model::CognitoUserPoolConfig) -> Self {
            self.user_pool_config = Some(input);
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::CognitoUserPoolConfig>,
        ) -> Self {
            self.user_pool_config = input;
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            input: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.lambda_authorizer_config = Some(input);
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.lambda_authorizer_config = input;
            self
        }
        /// Consumes the builder and constructs a [`AdditionalAuthenticationProvider`](crate::model::AdditionalAuthenticationProvider)
        pub fn build(self) -> crate::model::AdditionalAuthenticationProvider {
            crate::model::AdditionalAuthenticationProvider {
                authentication_type: self.authentication_type,
                open_id_connect_config: self.open_id_connect_config,
                user_pool_config: self.user_pool_config,
                lambda_authorizer_config: self.lambda_authorizer_config,
            }
        }
    }
}
impl AdditionalAuthenticationProvider {
    /// Creates a new builder-style object to manufacture [`AdditionalAuthenticationProvider`](crate::model::AdditionalAuthenticationProvider)
    pub fn builder() -> crate::model::additional_authentication_provider::Builder {
        crate::model::additional_authentication_provider::Builder::default()
    }
}

/// <p>Describes an Amazon Cognito user pool configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CognitoUserPoolConfig {
    /// <p>The user pool ID.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region in which the user pool was created.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
    /// ID.</p>
    pub app_id_client_regex: std::option::Option<std::string::String>,
}
impl CognitoUserPoolConfig {
    /// <p>The user pool ID.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The Amazon Web Services Region in which the user pool was created.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
    /// ID.</p>
    pub fn app_id_client_regex(&self) -> std::option::Option<&str> {
        self.app_id_client_regex.as_deref()
    }
}
impl std::fmt::Debug for CognitoUserPoolConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CognitoUserPoolConfig");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("app_id_client_regex", &self.app_id_client_regex);
        formatter.finish()
    }
}
/// See [`CognitoUserPoolConfig`](crate::model::CognitoUserPoolConfig)
pub mod cognito_user_pool_config {
    /// A builder for [`CognitoUserPoolConfig`](crate::model::CognitoUserPoolConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) app_id_client_regex: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The Amazon Web Services Region in which the user pool was created.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region in which the user pool was created.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
        /// ID.</p>
        pub fn app_id_client_regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id_client_regex = Some(input.into());
            self
        }
        /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
        /// ID.</p>
        pub fn set_app_id_client_regex(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_id_client_regex = input;
            self
        }
        /// Consumes the builder and constructs a [`CognitoUserPoolConfig`](crate::model::CognitoUserPoolConfig)
        pub fn build(self) -> crate::model::CognitoUserPoolConfig {
            crate::model::CognitoUserPoolConfig {
                user_pool_id: self.user_pool_id,
                aws_region: self.aws_region,
                app_id_client_regex: self.app_id_client_regex,
            }
        }
    }
}
impl CognitoUserPoolConfig {
    /// Creates a new builder-style object to manufacture [`CognitoUserPoolConfig`](crate::model::CognitoUserPoolConfig)
    pub fn builder() -> crate::model::cognito_user_pool_config::Builder {
        crate::model::cognito_user_pool_config::Builder::default()
    }
}

/// <p>Describes an OpenID Connect configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpenIdConnectConfig {
    /// <p>The issuer for the OpenID Connect configuration. The issuer returned by discovery must
    /// exactly match the value of <code>iss</code> in the ID token.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The client identifier of the Relying party at the OpenID identity provider. This
    /// identifier is typically obtained when the Relying party is registered with the OpenID
    /// identity provider. You can specify a regular expression so the AppSync can
    /// validate against multiple client identifiers at a time.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The number of milliseconds a token is valid after being issued to a user.</p>
    pub iat_ttl: i64,
    /// <p>The number of milliseconds a token is valid after being authenticated.</p>
    pub auth_ttl: i64,
}
impl OpenIdConnectConfig {
    /// <p>The issuer for the OpenID Connect configuration. The issuer returned by discovery must
    /// exactly match the value of <code>iss</code> in the ID token.</p>
    pub fn issuer(&self) -> std::option::Option<&str> {
        self.issuer.as_deref()
    }
    /// <p>The client identifier of the Relying party at the OpenID identity provider. This
    /// identifier is typically obtained when the Relying party is registered with the OpenID
    /// identity provider. You can specify a regular expression so the AppSync can
    /// validate against multiple client identifiers at a time.</p>
    pub fn client_id(&self) -> std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>The number of milliseconds a token is valid after being issued to a user.</p>
    pub fn iat_ttl(&self) -> i64 {
        self.iat_ttl
    }
    /// <p>The number of milliseconds a token is valid after being authenticated.</p>
    pub fn auth_ttl(&self) -> i64 {
        self.auth_ttl
    }
}
impl std::fmt::Debug for OpenIdConnectConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpenIdConnectConfig");
        formatter.field("issuer", &self.issuer);
        formatter.field("client_id", &self.client_id);
        formatter.field("iat_ttl", &self.iat_ttl);
        formatter.field("auth_ttl", &self.auth_ttl);
        formatter.finish()
    }
}
/// See [`OpenIdConnectConfig`](crate::model::OpenIdConnectConfig)
pub mod open_id_connect_config {
    /// A builder for [`OpenIdConnectConfig`](crate::model::OpenIdConnectConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) iat_ttl: std::option::Option<i64>,
        pub(crate) auth_ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The issuer for the OpenID Connect configuration. The issuer returned by discovery must
        /// exactly match the value of <code>iss</code> in the ID token.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The issuer for the OpenID Connect configuration. The issuer returned by discovery must
        /// exactly match the value of <code>iss</code> in the ID token.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The client identifier of the Relying party at the OpenID identity provider. This
        /// identifier is typically obtained when the Relying party is registered with the OpenID
        /// identity provider. You can specify a regular expression so the AppSync can
        /// validate against multiple client identifiers at a time.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client identifier of the Relying party at the OpenID identity provider. This
        /// identifier is typically obtained when the Relying party is registered with the OpenID
        /// identity provider. You can specify a regular expression so the AppSync can
        /// validate against multiple client identifiers at a time.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The number of milliseconds a token is valid after being issued to a user.</p>
        pub fn iat_ttl(mut self, input: i64) -> Self {
            self.iat_ttl = Some(input);
            self
        }
        /// <p>The number of milliseconds a token is valid after being issued to a user.</p>
        pub fn set_iat_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.iat_ttl = input;
            self
        }
        /// <p>The number of milliseconds a token is valid after being authenticated.</p>
        pub fn auth_ttl(mut self, input: i64) -> Self {
            self.auth_ttl = Some(input);
            self
        }
        /// <p>The number of milliseconds a token is valid after being authenticated.</p>
        pub fn set_auth_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.auth_ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`OpenIdConnectConfig`](crate::model::OpenIdConnectConfig)
        pub fn build(self) -> crate::model::OpenIdConnectConfig {
            crate::model::OpenIdConnectConfig {
                issuer: self.issuer,
                client_id: self.client_id,
                iat_ttl: self.iat_ttl.unwrap_or_default(),
                auth_ttl: self.auth_ttl.unwrap_or_default(),
            }
        }
    }
}
impl OpenIdConnectConfig {
    /// Creates a new builder-style object to manufacture [`OpenIdConnectConfig`](crate::model::OpenIdConnectConfig)
    pub fn builder() -> crate::model::open_id_connect_config::Builder {
        crate::model::open_id_connect_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    AmazonCognitoUserPools,
    #[allow(missing_docs)] // documentation missing in model
    ApiKey,
    #[allow(missing_docs)] // documentation missing in model
    AwsIam,
    #[allow(missing_docs)] // documentation missing in model
    AwsLambda,
    #[allow(missing_docs)] // documentation missing in model
    OpenidConnect,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_COGNITO_USER_POOLS" => AuthenticationType::AmazonCognitoUserPools,
            "API_KEY" => AuthenticationType::ApiKey,
            "AWS_IAM" => AuthenticationType::AwsIam,
            "AWS_LAMBDA" => AuthenticationType::AwsLambda,
            "OPENID_CONNECT" => AuthenticationType::OpenidConnect,
            other => AuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationType::from(s))
    }
}
impl AuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationType::AmazonCognitoUserPools => "AMAZON_COGNITO_USER_POOLS",
            AuthenticationType::ApiKey => "API_KEY",
            AuthenticationType::AwsIam => "AWS_IAM",
            AuthenticationType::AwsLambda => "AWS_LAMBDA",
            AuthenticationType::OpenidConnect => "OPENID_CONNECT",
            AuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMAZON_COGNITO_USER_POOLS",
            "API_KEY",
            "AWS_IAM",
            "AWS_LAMBDA",
            "OPENID_CONNECT",
        ]
    }
}
impl AsRef<str> for AuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Amazon Cognito user pool configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPoolConfig {
    /// <p>The user pool ID.</p>
    pub user_pool_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region in which the user pool was created.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>The action that you want your GraphQL API to take when a request that uses Amazon
    /// Cognito user pool authentication doesn't match the Amazon Cognito user pool
    /// configuration.</p>
    pub default_action: std::option::Option<crate::model::DefaultAction>,
    /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
    /// ID.</p>
    pub app_id_client_regex: std::option::Option<std::string::String>,
}
impl UserPoolConfig {
    /// <p>The user pool ID.</p>
    pub fn user_pool_id(&self) -> std::option::Option<&str> {
        self.user_pool_id.as_deref()
    }
    /// <p>The Amazon Web Services Region in which the user pool was created.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>The action that you want your GraphQL API to take when a request that uses Amazon
    /// Cognito user pool authentication doesn't match the Amazon Cognito user pool
    /// configuration.</p>
    pub fn default_action(&self) -> std::option::Option<&crate::model::DefaultAction> {
        self.default_action.as_ref()
    }
    /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
    /// ID.</p>
    pub fn app_id_client_regex(&self) -> std::option::Option<&str> {
        self.app_id_client_regex.as_deref()
    }
}
impl std::fmt::Debug for UserPoolConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPoolConfig");
        formatter.field("user_pool_id", &self.user_pool_id);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("default_action", &self.default_action);
        formatter.field("app_id_client_regex", &self.app_id_client_regex);
        formatter.finish()
    }
}
/// See [`UserPoolConfig`](crate::model::UserPoolConfig)
pub mod user_pool_config {
    /// A builder for [`UserPoolConfig`](crate::model::UserPoolConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_pool_id: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) default_action: std::option::Option<crate::model::DefaultAction>,
        pub(crate) app_id_client_regex: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user pool ID.</p>
        pub fn user_pool_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_pool_id = Some(input.into());
            self
        }
        /// <p>The user pool ID.</p>
        pub fn set_user_pool_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_pool_id = input;
            self
        }
        /// <p>The Amazon Web Services Region in which the user pool was created.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region in which the user pool was created.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>The action that you want your GraphQL API to take when a request that uses Amazon
        /// Cognito user pool authentication doesn't match the Amazon Cognito user pool
        /// configuration.</p>
        pub fn default_action(mut self, input: crate::model::DefaultAction) -> Self {
            self.default_action = Some(input);
            self
        }
        /// <p>The action that you want your GraphQL API to take when a request that uses Amazon
        /// Cognito user pool authentication doesn't match the Amazon Cognito user pool
        /// configuration.</p>
        pub fn set_default_action(
            mut self,
            input: std::option::Option<crate::model::DefaultAction>,
        ) -> Self {
            self.default_action = input;
            self
        }
        /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
        /// ID.</p>
        pub fn app_id_client_regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_id_client_regex = Some(input.into());
            self
        }
        /// <p>A regular expression for validating the incoming Amazon Cognito user pool app client
        /// ID.</p>
        pub fn set_app_id_client_regex(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_id_client_regex = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPoolConfig`](crate::model::UserPoolConfig)
        pub fn build(self) -> crate::model::UserPoolConfig {
            crate::model::UserPoolConfig {
                user_pool_id: self.user_pool_id,
                aws_region: self.aws_region,
                default_action: self.default_action,
                app_id_client_regex: self.app_id_client_regex,
            }
        }
    }
}
impl UserPoolConfig {
    /// Creates a new builder-style object to manufacture [`UserPoolConfig`](crate::model::UserPoolConfig)
    pub fn builder() -> crate::model::user_pool_config::Builder {
        crate::model::user_pool_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DefaultAction {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DefaultAction {
    fn from(s: &str) -> Self {
        match s {
            "ALLOW" => DefaultAction::Allow,
            "DENY" => DefaultAction::Deny,
            other => DefaultAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DefaultAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DefaultAction::from(s))
    }
}
impl DefaultAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DefaultAction::Allow => "ALLOW",
            DefaultAction::Deny => "DENY",
            DefaultAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOW", "DENY"]
    }
}
impl AsRef<str> for DefaultAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The CloudWatch Logs configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogConfig {
    /// <p>The field logging level. Values can be NONE, ERROR, or ALL. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NONE</b>: No field-level logs are
    /// captured.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ERROR</b>: Logs the following information only for
    /// the fields that are in error:</p>
    /// <ul>
    /// <li>
    /// <p>The error section in the server response.</p>
    /// </li>
    /// <li>
    /// <p>Field-level errors.</p>
    /// </li>
    /// <li>
    /// <p>The generated request/response functions that got resolved for error
    /// fields.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ALL</b>: The following information is logged for
    /// all fields in the query:</p>
    /// <ul>
    /// <li>
    /// <p>Field-level tracing information.</p>
    /// </li>
    /// <li>
    /// <p>The generated request/response functions that got resolved for each
    /// field.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub field_log_level: std::option::Option<crate::model::FieldLogLevel>,
    /// <p>The service role that AppSync will assume to publish to Amazon
    /// CloudWatch logs in your account. </p>
    pub cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
    /// <p>Set to TRUE to exclude sections that contain information such as headers, context, and
    /// evaluated mapping templates, regardless of logging level.</p>
    pub exclude_verbose_content: bool,
}
impl LogConfig {
    /// <p>The field logging level. Values can be NONE, ERROR, or ALL. </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>NONE</b>: No field-level logs are
    /// captured.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ERROR</b>: Logs the following information only for
    /// the fields that are in error:</p>
    /// <ul>
    /// <li>
    /// <p>The error section in the server response.</p>
    /// </li>
    /// <li>
    /// <p>Field-level errors.</p>
    /// </li>
    /// <li>
    /// <p>The generated request/response functions that got resolved for error
    /// fields.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>
    /// <b>ALL</b>: The following information is logged for
    /// all fields in the query:</p>
    /// <ul>
    /// <li>
    /// <p>Field-level tracing information.</p>
    /// </li>
    /// <li>
    /// <p>The generated request/response functions that got resolved for each
    /// field.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn field_log_level(&self) -> std::option::Option<&crate::model::FieldLogLevel> {
        self.field_log_level.as_ref()
    }
    /// <p>The service role that AppSync will assume to publish to Amazon
    /// CloudWatch logs in your account. </p>
    pub fn cloud_watch_logs_role_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_role_arn.as_deref()
    }
    /// <p>Set to TRUE to exclude sections that contain information such as headers, context, and
    /// evaluated mapping templates, regardless of logging level.</p>
    pub fn exclude_verbose_content(&self) -> bool {
        self.exclude_verbose_content
    }
}
impl std::fmt::Debug for LogConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogConfig");
        formatter.field("field_log_level", &self.field_log_level);
        formatter.field("cloud_watch_logs_role_arn", &self.cloud_watch_logs_role_arn);
        formatter.field("exclude_verbose_content", &self.exclude_verbose_content);
        formatter.finish()
    }
}
/// See [`LogConfig`](crate::model::LogConfig)
pub mod log_config {
    /// A builder for [`LogConfig`](crate::model::LogConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field_log_level: std::option::Option<crate::model::FieldLogLevel>,
        pub(crate) cloud_watch_logs_role_arn: std::option::Option<std::string::String>,
        pub(crate) exclude_verbose_content: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The field logging level. Values can be NONE, ERROR, or ALL. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NONE</b>: No field-level logs are
        /// captured.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ERROR</b>: Logs the following information only for
        /// the fields that are in error:</p>
        /// <ul>
        /// <li>
        /// <p>The error section in the server response.</p>
        /// </li>
        /// <li>
        /// <p>Field-level errors.</p>
        /// </li>
        /// <li>
        /// <p>The generated request/response functions that got resolved for error
        /// fields.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ALL</b>: The following information is logged for
        /// all fields in the query:</p>
        /// <ul>
        /// <li>
        /// <p>Field-level tracing information.</p>
        /// </li>
        /// <li>
        /// <p>The generated request/response functions that got resolved for each
        /// field.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn field_log_level(mut self, input: crate::model::FieldLogLevel) -> Self {
            self.field_log_level = Some(input);
            self
        }
        /// <p>The field logging level. Values can be NONE, ERROR, or ALL. </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>NONE</b>: No field-level logs are
        /// captured.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ERROR</b>: Logs the following information only for
        /// the fields that are in error:</p>
        /// <ul>
        /// <li>
        /// <p>The error section in the server response.</p>
        /// </li>
        /// <li>
        /// <p>Field-level errors.</p>
        /// </li>
        /// <li>
        /// <p>The generated request/response functions that got resolved for error
        /// fields.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>
        /// <b>ALL</b>: The following information is logged for
        /// all fields in the query:</p>
        /// <ul>
        /// <li>
        /// <p>Field-level tracing information.</p>
        /// </li>
        /// <li>
        /// <p>The generated request/response functions that got resolved for each
        /// field.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_field_log_level(
            mut self,
            input: std::option::Option<crate::model::FieldLogLevel>,
        ) -> Self {
            self.field_log_level = input;
            self
        }
        /// <p>The service role that AppSync will assume to publish to Amazon
        /// CloudWatch logs in your account. </p>
        pub fn cloud_watch_logs_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_role_arn = Some(input.into());
            self
        }
        /// <p>The service role that AppSync will assume to publish to Amazon
        /// CloudWatch logs in your account. </p>
        pub fn set_cloud_watch_logs_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_role_arn = input;
            self
        }
        /// <p>Set to TRUE to exclude sections that contain information such as headers, context, and
        /// evaluated mapping templates, regardless of logging level.</p>
        pub fn exclude_verbose_content(mut self, input: bool) -> Self {
            self.exclude_verbose_content = Some(input);
            self
        }
        /// <p>Set to TRUE to exclude sections that contain information such as headers, context, and
        /// evaluated mapping templates, regardless of logging level.</p>
        pub fn set_exclude_verbose_content(mut self, input: std::option::Option<bool>) -> Self {
            self.exclude_verbose_content = input;
            self
        }
        /// Consumes the builder and constructs a [`LogConfig`](crate::model::LogConfig)
        pub fn build(self) -> crate::model::LogConfig {
            crate::model::LogConfig {
                field_log_level: self.field_log_level,
                cloud_watch_logs_role_arn: self.cloud_watch_logs_role_arn,
                exclude_verbose_content: self.exclude_verbose_content.unwrap_or_default(),
            }
        }
    }
}
impl LogConfig {
    /// Creates a new builder-style object to manufacture [`LogConfig`](crate::model::LogConfig)
    pub fn builder() -> crate::model::log_config::Builder {
        crate::model::log_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FieldLogLevel {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FieldLogLevel {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => FieldLogLevel::All,
            "ERROR" => FieldLogLevel::Error,
            "NONE" => FieldLogLevel::None,
            other => FieldLogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FieldLogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FieldLogLevel::from(s))
    }
}
impl FieldLogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FieldLogLevel::All => "ALL",
            FieldLogLevel::Error => "ERROR",
            FieldLogLevel::None => "NONE",
            FieldLogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "ERROR", "NONE"]
    }
}
impl AsRef<str> for FieldLogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A function is a reusable entity. Multiple functions can be used to compose the resolver
/// logic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FunctionConfiguration {
    /// <p>A unique ID representing the <code>Function</code> object.</p>
    pub function_id: std::option::Option<std::string::String>,
    /// <p>The ARN of the <code>Function</code> object.</p>
    pub function_arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>Function</code> object.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> description.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the <code>DataSource</code>.</p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> request mapping template. Functions support only the
    /// 2018-05-29 version of the request mapping template.</p>
    pub request_mapping_template: std::option::Option<std::string::String>,
    /// <p>The <code>Function</code> response mapping template.</p>
    pub response_mapping_template: std::option::Option<std::string::String>,
    /// <p>The version of the request mapping template. Currently only the 2018-05-29 version of
    /// the template is supported.</p>
    pub function_version: std::option::Option<std::string::String>,
    /// <p>Describes a Sync configuration for a resolver.</p>
    /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
    /// be performed when the resolver is invoked.</p>
    pub sync_config: std::option::Option<crate::model::SyncConfig>,
}
impl FunctionConfiguration {
    /// <p>A unique ID representing the <code>Function</code> object.</p>
    pub fn function_id(&self) -> std::option::Option<&str> {
        self.function_id.as_deref()
    }
    /// <p>The ARN of the <code>Function</code> object.</p>
    pub fn function_arn(&self) -> std::option::Option<&str> {
        self.function_arn.as_deref()
    }
    /// <p>The name of the <code>Function</code> object.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The <code>Function</code> description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the <code>DataSource</code>.</p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The <code>Function</code> request mapping template. Functions support only the
    /// 2018-05-29 version of the request mapping template.</p>
    pub fn request_mapping_template(&self) -> std::option::Option<&str> {
        self.request_mapping_template.as_deref()
    }
    /// <p>The <code>Function</code> response mapping template.</p>
    pub fn response_mapping_template(&self) -> std::option::Option<&str> {
        self.response_mapping_template.as_deref()
    }
    /// <p>The version of the request mapping template. Currently only the 2018-05-29 version of
    /// the template is supported.</p>
    pub fn function_version(&self) -> std::option::Option<&str> {
        self.function_version.as_deref()
    }
    /// <p>Describes a Sync configuration for a resolver.</p>
    /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
    /// be performed when the resolver is invoked.</p>
    pub fn sync_config(&self) -> std::option::Option<&crate::model::SyncConfig> {
        self.sync_config.as_ref()
    }
}
impl std::fmt::Debug for FunctionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FunctionConfiguration");
        formatter.field("function_id", &self.function_id);
        formatter.field("function_arn", &self.function_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("request_mapping_template", &self.request_mapping_template);
        formatter.field("response_mapping_template", &self.response_mapping_template);
        formatter.field("function_version", &self.function_version);
        formatter.field("sync_config", &self.sync_config);
        formatter.finish()
    }
}
/// See [`FunctionConfiguration`](crate::model::FunctionConfiguration)
pub mod function_configuration {
    /// A builder for [`FunctionConfiguration`](crate::model::FunctionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) function_id: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) request_mapping_template: std::option::Option<std::string::String>,
        pub(crate) response_mapping_template: std::option::Option<std::string::String>,
        pub(crate) function_version: std::option::Option<std::string::String>,
        pub(crate) sync_config: std::option::Option<crate::model::SyncConfig>,
    }
    impl Builder {
        /// <p>A unique ID representing the <code>Function</code> object.</p>
        pub fn function_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_id = Some(input.into());
            self
        }
        /// <p>A unique ID representing the <code>Function</code> object.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_id = input;
            self
        }
        /// <p>The ARN of the <code>Function</code> object.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>Function</code> object.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// <p>The name of the <code>Function</code> object.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>Function</code> object.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the <code>DataSource</code>.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>The name of the <code>DataSource</code>.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the
        /// 2018-05-29 version of the request mapping template.</p>
        pub fn request_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_mapping_template = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the
        /// 2018-05-29 version of the request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_mapping_template = input;
            self
        }
        /// <p>The <code>Function</code> response mapping template.</p>
        pub fn response_mapping_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.response_mapping_template = Some(input.into());
            self
        }
        /// <p>The <code>Function</code> response mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.response_mapping_template = input;
            self
        }
        /// <p>The version of the request mapping template. Currently only the 2018-05-29 version of
        /// the template is supported.</p>
        pub fn function_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_version = Some(input.into());
            self
        }
        /// <p>The version of the request mapping template. Currently only the 2018-05-29 version of
        /// the template is supported.</p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.function_version = input;
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
        /// be performed when the resolver is invoked.</p>
        pub fn sync_config(mut self, input: crate::model::SyncConfig) -> Self {
            self.sync_config = Some(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
        /// be performed when the resolver is invoked.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.sync_config = input;
            self
        }
        /// Consumes the builder and constructs a [`FunctionConfiguration`](crate::model::FunctionConfiguration)
        pub fn build(self) -> crate::model::FunctionConfiguration {
            crate::model::FunctionConfiguration {
                function_id: self.function_id,
                function_arn: self.function_arn,
                name: self.name,
                description: self.description,
                data_source_name: self.data_source_name,
                request_mapping_template: self.request_mapping_template,
                response_mapping_template: self.response_mapping_template,
                function_version: self.function_version,
                sync_config: self.sync_config,
            }
        }
    }
}
impl FunctionConfiguration {
    /// Creates a new builder-style object to manufacture [`FunctionConfiguration`](crate::model::FunctionConfiguration)
    pub fn builder() -> crate::model::function_configuration::Builder {
        crate::model::function_configuration::Builder::default()
    }
}

/// <p>Describes a data source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSource {
    /// <p>The data source ARN.</p>
    pub data_source_arn: std::option::Option<std::string::String>,
    /// <p>The name of the data source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the data source.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The type of the data source.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AWS_LAMBDA</b>: The data source is an Amazon Web Services Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AMAZON_DYNAMODB</b>: The data source is an Amazon
    /// DynamoDB table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AMAZON_ELASTICSEARCH</b>: The data source is an
    /// Amazon OpenSearch Service domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AMAZON_OPENSEARCH_SERVICE</b>: The data source is
    /// an Amazon OpenSearch Service domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>NONE</b>: There is no data source. This type is
    /// used when you wish to invoke a GraphQL operation without connecting to a data source,
    /// such as performing data transformation with resolvers or triggering a subscription to
    /// be invoked from a mutation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>HTTP</b>: The data source is an HTTP
    /// endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>RELATIONAL_DATABASE</b>: The data source is a
    /// relational database.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::DataSourceType>,
    /// <p>The Identity and Access Management service role ARN for the data source. The system assumes this
    /// role when accessing the data source.</p>
    pub service_role_arn: std::option::Option<std::string::String>,
    /// <p>Amazon DynamoDB settings.</p>
    pub dynamodb_config: std::option::Option<crate::model::DynamodbDataSourceConfig>,
    /// <p>Amazon Web Services Lambda settings.</p>
    pub lambda_config: std::option::Option<crate::model::LambdaDataSourceConfig>,
    /// <p>Amazon OpenSearch Service settings.</p>
    pub elasticsearch_config: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
    /// <p>Amazon OpenSearch Service settings.</p>
    pub open_search_service_config:
        std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
    /// <p>HTTP endpoint settings.</p>
    pub http_config: std::option::Option<crate::model::HttpDataSourceConfig>,
    /// <p>Relational database settings.</p>
    pub relational_database_config:
        std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
}
impl DataSource {
    /// <p>The data source ARN.</p>
    pub fn data_source_arn(&self) -> std::option::Option<&str> {
        self.data_source_arn.as_deref()
    }
    /// <p>The name of the data source.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the data source.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The type of the data source.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AWS_LAMBDA</b>: The data source is an Amazon Web Services Lambda function.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AMAZON_DYNAMODB</b>: The data source is an Amazon
    /// DynamoDB table.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AMAZON_ELASTICSEARCH</b>: The data source is an
    /// Amazon OpenSearch Service domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>AMAZON_OPENSEARCH_SERVICE</b>: The data source is
    /// an Amazon OpenSearch Service domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>NONE</b>: There is no data source. This type is
    /// used when you wish to invoke a GraphQL operation without connecting to a data source,
    /// such as performing data transformation with resolvers or triggering a subscription to
    /// be invoked from a mutation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>HTTP</b>: The data source is an HTTP
    /// endpoint.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>RELATIONAL_DATABASE</b>: The data source is a
    /// relational database.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::DataSourceType> {
        self.r#type.as_ref()
    }
    /// <p>The Identity and Access Management service role ARN for the data source. The system assumes this
    /// role when accessing the data source.</p>
    pub fn service_role_arn(&self) -> std::option::Option<&str> {
        self.service_role_arn.as_deref()
    }
    /// <p>Amazon DynamoDB settings.</p>
    pub fn dynamodb_config(&self) -> std::option::Option<&crate::model::DynamodbDataSourceConfig> {
        self.dynamodb_config.as_ref()
    }
    /// <p>Amazon Web Services Lambda settings.</p>
    pub fn lambda_config(&self) -> std::option::Option<&crate::model::LambdaDataSourceConfig> {
        self.lambda_config.as_ref()
    }
    /// <p>Amazon OpenSearch Service settings.</p>
    pub fn elasticsearch_config(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchDataSourceConfig> {
        self.elasticsearch_config.as_ref()
    }
    /// <p>Amazon OpenSearch Service settings.</p>
    pub fn open_search_service_config(
        &self,
    ) -> std::option::Option<&crate::model::OpenSearchServiceDataSourceConfig> {
        self.open_search_service_config.as_ref()
    }
    /// <p>HTTP endpoint settings.</p>
    pub fn http_config(&self) -> std::option::Option<&crate::model::HttpDataSourceConfig> {
        self.http_config.as_ref()
    }
    /// <p>Relational database settings.</p>
    pub fn relational_database_config(
        &self,
    ) -> std::option::Option<&crate::model::RelationalDatabaseDataSourceConfig> {
        self.relational_database_config.as_ref()
    }
}
impl std::fmt::Debug for DataSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSource");
        formatter.field("data_source_arn", &self.data_source_arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("r#type", &self.r#type);
        formatter.field("service_role_arn", &self.service_role_arn);
        formatter.field("dynamodb_config", &self.dynamodb_config);
        formatter.field("lambda_config", &self.lambda_config);
        formatter.field("elasticsearch_config", &self.elasticsearch_config);
        formatter.field(
            "open_search_service_config",
            &self.open_search_service_config,
        );
        formatter.field("http_config", &self.http_config);
        formatter.field(
            "relational_database_config",
            &self.relational_database_config,
        );
        formatter.finish()
    }
}
/// See [`DataSource`](crate::model::DataSource)
pub mod data_source {
    /// A builder for [`DataSource`](crate::model::DataSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::DataSourceType>,
        pub(crate) service_role_arn: std::option::Option<std::string::String>,
        pub(crate) dynamodb_config: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        pub(crate) lambda_config: std::option::Option<crate::model::LambdaDataSourceConfig>,
        pub(crate) elasticsearch_config:
            std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        pub(crate) open_search_service_config:
            std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        pub(crate) http_config: std::option::Option<crate::model::HttpDataSourceConfig>,
        pub(crate) relational_database_config:
            std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
    }
    impl Builder {
        /// <p>The data source ARN.</p>
        pub fn data_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_arn = Some(input.into());
            self
        }
        /// <p>The data source ARN.</p>
        pub fn set_data_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_arn = input;
            self
        }
        /// <p>The name of the data source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the data source.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The type of the data source.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AWS_LAMBDA</b>: The data source is an Amazon Web Services Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AMAZON_DYNAMODB</b>: The data source is an Amazon
        /// DynamoDB table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AMAZON_ELASTICSEARCH</b>: The data source is an
        /// Amazon OpenSearch Service domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AMAZON_OPENSEARCH_SERVICE</b>: The data source is
        /// an Amazon OpenSearch Service domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NONE</b>: There is no data source. This type is
        /// used when you wish to invoke a GraphQL operation without connecting to a data source,
        /// such as performing data transformation with resolvers or triggering a subscription to
        /// be invoked from a mutation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>HTTP</b>: The data source is an HTTP
        /// endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>RELATIONAL_DATABASE</b>: The data source is a
        /// relational database.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::DataSourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the data source.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AWS_LAMBDA</b>: The data source is an Amazon Web Services Lambda function.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AMAZON_DYNAMODB</b>: The data source is an Amazon
        /// DynamoDB table.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AMAZON_ELASTICSEARCH</b>: The data source is an
        /// Amazon OpenSearch Service domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>AMAZON_OPENSEARCH_SERVICE</b>: The data source is
        /// an Amazon OpenSearch Service domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>NONE</b>: There is no data source. This type is
        /// used when you wish to invoke a GraphQL operation without connecting to a data source,
        /// such as performing data transformation with resolvers or triggering a subscription to
        /// be invoked from a mutation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>HTTP</b>: The data source is an HTTP
        /// endpoint.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>RELATIONAL_DATABASE</b>: The data source is a
        /// relational database.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The Identity and Access Management service role ARN for the data source. The system assumes this
        /// role when accessing the data source.</p>
        pub fn service_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role_arn = Some(input.into());
            self
        }
        /// <p>The Identity and Access Management service role ARN for the data source. The system assumes this
        /// role when accessing the data source.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_role_arn = input;
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn dynamodb_config(mut self, input: crate::model::DynamodbDataSourceConfig) -> Self {
            self.dynamodb_config = Some(input);
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn set_dynamodb_config(
            mut self,
            input: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        ) -> Self {
            self.dynamodb_config = input;
            self
        }
        /// <p>Amazon Web Services Lambda settings.</p>
        pub fn lambda_config(mut self, input: crate::model::LambdaDataSourceConfig) -> Self {
            self.lambda_config = Some(input);
            self
        }
        /// <p>Amazon Web Services Lambda settings.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaDataSourceConfig>,
        ) -> Self {
            self.lambda_config = input;
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn elasticsearch_config(
            mut self,
            input: crate::model::ElasticsearchDataSourceConfig,
        ) -> Self {
            self.elasticsearch_config = Some(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn set_elasticsearch_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        ) -> Self {
            self.elasticsearch_config = input;
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn open_search_service_config(
            mut self,
            input: crate::model::OpenSearchServiceDataSourceConfig,
        ) -> Self {
            self.open_search_service_config = Some(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn set_open_search_service_config(
            mut self,
            input: std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        ) -> Self {
            self.open_search_service_config = input;
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn http_config(mut self, input: crate::model::HttpDataSourceConfig) -> Self {
            self.http_config = Some(input);
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn set_http_config(
            mut self,
            input: std::option::Option<crate::model::HttpDataSourceConfig>,
        ) -> Self {
            self.http_config = input;
            self
        }
        /// <p>Relational database settings.</p>
        pub fn relational_database_config(
            mut self,
            input: crate::model::RelationalDatabaseDataSourceConfig,
        ) -> Self {
            self.relational_database_config = Some(input);
            self
        }
        /// <p>Relational database settings.</p>
        pub fn set_relational_database_config(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
        ) -> Self {
            self.relational_database_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSource`](crate::model::DataSource)
        pub fn build(self) -> crate::model::DataSource {
            crate::model::DataSource {
                data_source_arn: self.data_source_arn,
                name: self.name,
                description: self.description,
                r#type: self.r#type,
                service_role_arn: self.service_role_arn,
                dynamodb_config: self.dynamodb_config,
                lambda_config: self.lambda_config,
                elasticsearch_config: self.elasticsearch_config,
                open_search_service_config: self.open_search_service_config,
                http_config: self.http_config,
                relational_database_config: self.relational_database_config,
            }
        }
    }
}
impl DataSource {
    /// Creates a new builder-style object to manufacture [`DataSource`](crate::model::DataSource)
    pub fn builder() -> crate::model::data_source::Builder {
        crate::model::data_source::Builder::default()
    }
}

/// <p>Describes a relational database data source configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseDataSourceConfig {
    /// <p>Source type for the relational database.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>RDS_HTTP_ENDPOINT</b>: The relational database
    /// source type is an Amazon RDS HTTP endpoint.</p>
    /// </li>
    /// </ul>
    pub relational_database_source_type:
        std::option::Option<crate::model::RelationalDatabaseSourceType>,
    /// <p>Amazon RDS HTTP endpoint settings.</p>
    pub rds_http_endpoint_config: std::option::Option<crate::model::RdsHttpEndpointConfig>,
}
impl RelationalDatabaseDataSourceConfig {
    /// <p>Source type for the relational database.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>RDS_HTTP_ENDPOINT</b>: The relational database
    /// source type is an Amazon RDS HTTP endpoint.</p>
    /// </li>
    /// </ul>
    pub fn relational_database_source_type(
        &self,
    ) -> std::option::Option<&crate::model::RelationalDatabaseSourceType> {
        self.relational_database_source_type.as_ref()
    }
    /// <p>Amazon RDS HTTP endpoint settings.</p>
    pub fn rds_http_endpoint_config(
        &self,
    ) -> std::option::Option<&crate::model::RdsHttpEndpointConfig> {
        self.rds_http_endpoint_config.as_ref()
    }
}
impl std::fmt::Debug for RelationalDatabaseDataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseDataSourceConfig");
        formatter.field(
            "relational_database_source_type",
            &self.relational_database_source_type,
        );
        formatter.field("rds_http_endpoint_config", &self.rds_http_endpoint_config);
        formatter.finish()
    }
}
/// See [`RelationalDatabaseDataSourceConfig`](crate::model::RelationalDatabaseDataSourceConfig)
pub mod relational_database_data_source_config {
    /// A builder for [`RelationalDatabaseDataSourceConfig`](crate::model::RelationalDatabaseDataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_source_type:
            std::option::Option<crate::model::RelationalDatabaseSourceType>,
        pub(crate) rds_http_endpoint_config:
            std::option::Option<crate::model::RdsHttpEndpointConfig>,
    }
    impl Builder {
        /// <p>Source type for the relational database.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>RDS_HTTP_ENDPOINT</b>: The relational database
        /// source type is an Amazon RDS HTTP endpoint.</p>
        /// </li>
        /// </ul>
        pub fn relational_database_source_type(
            mut self,
            input: crate::model::RelationalDatabaseSourceType,
        ) -> Self {
            self.relational_database_source_type = Some(input);
            self
        }
        /// <p>Source type for the relational database.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>RDS_HTTP_ENDPOINT</b>: The relational database
        /// source type is an Amazon RDS HTTP endpoint.</p>
        /// </li>
        /// </ul>
        pub fn set_relational_database_source_type(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseSourceType>,
        ) -> Self {
            self.relational_database_source_type = input;
            self
        }
        /// <p>Amazon RDS HTTP endpoint settings.</p>
        pub fn rds_http_endpoint_config(
            mut self,
            input: crate::model::RdsHttpEndpointConfig,
        ) -> Self {
            self.rds_http_endpoint_config = Some(input);
            self
        }
        /// <p>Amazon RDS HTTP endpoint settings.</p>
        pub fn set_rds_http_endpoint_config(
            mut self,
            input: std::option::Option<crate::model::RdsHttpEndpointConfig>,
        ) -> Self {
            self.rds_http_endpoint_config = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseDataSourceConfig`](crate::model::RelationalDatabaseDataSourceConfig)
        pub fn build(self) -> crate::model::RelationalDatabaseDataSourceConfig {
            crate::model::RelationalDatabaseDataSourceConfig {
                relational_database_source_type: self.relational_database_source_type,
                rds_http_endpoint_config: self.rds_http_endpoint_config,
            }
        }
    }
}
impl RelationalDatabaseDataSourceConfig {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseDataSourceConfig`](crate::model::RelationalDatabaseDataSourceConfig)
    pub fn builder() -> crate::model::relational_database_data_source_config::Builder {
        crate::model::relational_database_data_source_config::Builder::default()
    }
}

/// <p>The Amazon RDS HTTP endpoint configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RdsHttpEndpointConfig {
    /// <p>Amazon Web Services Region for RDS HTTP endpoint.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>Amazon RDS cluster ARN.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Logical database name.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Logical schema name.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>Amazon Web Services secret store ARN for database credentials.</p>
    pub aws_secret_store_arn: std::option::Option<std::string::String>,
}
impl RdsHttpEndpointConfig {
    /// <p>Amazon Web Services Region for RDS HTTP endpoint.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>Amazon RDS cluster ARN.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>Logical database name.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Logical schema name.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>Amazon Web Services secret store ARN for database credentials.</p>
    pub fn aws_secret_store_arn(&self) -> std::option::Option<&str> {
        self.aws_secret_store_arn.as_deref()
    }
}
impl std::fmt::Debug for RdsHttpEndpointConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RdsHttpEndpointConfig");
        formatter.field("aws_region", &self.aws_region);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("database_name", &self.database_name);
        formatter.field("schema", &self.schema);
        formatter.field("aws_secret_store_arn", &self.aws_secret_store_arn);
        formatter.finish()
    }
}
/// See [`RdsHttpEndpointConfig`](crate::model::RdsHttpEndpointConfig)
pub mod rds_http_endpoint_config {
    /// A builder for [`RdsHttpEndpointConfig`](crate::model::RdsHttpEndpointConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) aws_secret_store_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Web Services Region for RDS HTTP endpoint.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>Amazon Web Services Region for RDS HTTP endpoint.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>Amazon RDS cluster ARN.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Amazon RDS cluster ARN.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Logical database name.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Logical database name.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Logical schema name.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>Logical schema name.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>Amazon Web Services secret store ARN for database credentials.</p>
        pub fn aws_secret_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_secret_store_arn = Some(input.into());
            self
        }
        /// <p>Amazon Web Services secret store ARN for database credentials.</p>
        pub fn set_aws_secret_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_secret_store_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RdsHttpEndpointConfig`](crate::model::RdsHttpEndpointConfig)
        pub fn build(self) -> crate::model::RdsHttpEndpointConfig {
            crate::model::RdsHttpEndpointConfig {
                aws_region: self.aws_region,
                db_cluster_identifier: self.db_cluster_identifier,
                database_name: self.database_name,
                schema: self.schema,
                aws_secret_store_arn: self.aws_secret_store_arn,
            }
        }
    }
}
impl RdsHttpEndpointConfig {
    /// Creates a new builder-style object to manufacture [`RdsHttpEndpointConfig`](crate::model::RdsHttpEndpointConfig)
    pub fn builder() -> crate::model::rds_http_endpoint_config::Builder {
        crate::model::rds_http_endpoint_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationalDatabaseSourceType {
    #[allow(missing_docs)] // documentation missing in model
    RdsHttpEndpoint,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationalDatabaseSourceType {
    fn from(s: &str) -> Self {
        match s {
            "RDS_HTTP_ENDPOINT" => RelationalDatabaseSourceType::RdsHttpEndpoint,
            other => RelationalDatabaseSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationalDatabaseSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationalDatabaseSourceType::from(s))
    }
}
impl RelationalDatabaseSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationalDatabaseSourceType::RdsHttpEndpoint => "RDS_HTTP_ENDPOINT",
            RelationalDatabaseSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RDS_HTTP_ENDPOINT"]
    }
}
impl AsRef<str> for RelationalDatabaseSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an HTTP data source configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpDataSourceConfig {
    /// <p>The HTTP URL endpoint. You can either specify the domain name or IP, and port
    /// combination, and the URL scheme must be HTTP or HTTPS. If the port is not specified,
    /// AppSync uses the default port 80 for the HTTP endpoint and port 443 for
    /// HTTPS endpoints.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The authorization config in case the HTTP endpoint requires authorization.</p>
    pub authorization_config: std::option::Option<crate::model::AuthorizationConfig>,
}
impl HttpDataSourceConfig {
    /// <p>The HTTP URL endpoint. You can either specify the domain name or IP, and port
    /// combination, and the URL scheme must be HTTP or HTTPS. If the port is not specified,
    /// AppSync uses the default port 80 for the HTTP endpoint and port 443 for
    /// HTTPS endpoints.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The authorization config in case the HTTP endpoint requires authorization.</p>
    pub fn authorization_config(&self) -> std::option::Option<&crate::model::AuthorizationConfig> {
        self.authorization_config.as_ref()
    }
}
impl std::fmt::Debug for HttpDataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpDataSourceConfig");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("authorization_config", &self.authorization_config);
        formatter.finish()
    }
}
/// See [`HttpDataSourceConfig`](crate::model::HttpDataSourceConfig)
pub mod http_data_source_config {
    /// A builder for [`HttpDataSourceConfig`](crate::model::HttpDataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) authorization_config: std::option::Option<crate::model::AuthorizationConfig>,
    }
    impl Builder {
        /// <p>The HTTP URL endpoint. You can either specify the domain name or IP, and port
        /// combination, and the URL scheme must be HTTP or HTTPS. If the port is not specified,
        /// AppSync uses the default port 80 for the HTTP endpoint and port 443 for
        /// HTTPS endpoints.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The HTTP URL endpoint. You can either specify the domain name or IP, and port
        /// combination, and the URL scheme must be HTTP or HTTPS. If the port is not specified,
        /// AppSync uses the default port 80 for the HTTP endpoint and port 443 for
        /// HTTPS endpoints.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The authorization config in case the HTTP endpoint requires authorization.</p>
        pub fn authorization_config(mut self, input: crate::model::AuthorizationConfig) -> Self {
            self.authorization_config = Some(input);
            self
        }
        /// <p>The authorization config in case the HTTP endpoint requires authorization.</p>
        pub fn set_authorization_config(
            mut self,
            input: std::option::Option<crate::model::AuthorizationConfig>,
        ) -> Self {
            self.authorization_config = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpDataSourceConfig`](crate::model::HttpDataSourceConfig)
        pub fn build(self) -> crate::model::HttpDataSourceConfig {
            crate::model::HttpDataSourceConfig {
                endpoint: self.endpoint,
                authorization_config: self.authorization_config,
            }
        }
    }
}
impl HttpDataSourceConfig {
    /// Creates a new builder-style object to manufacture [`HttpDataSourceConfig`](crate::model::HttpDataSourceConfig)
    pub fn builder() -> crate::model::http_data_source_config::Builder {
        crate::model::http_data_source_config::Builder::default()
    }
}

/// <p>The authorization config in case the HTTP endpoint requires authorization.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationConfig {
    /// <p>The authorization type required by the HTTP endpoint.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AWS_IAM</b>: The authorization type is
    /// Sigv4.</p>
    /// </li>
    /// </ul>
    pub authorization_type: std::option::Option<crate::model::AuthorizationType>,
    /// <p>The Identity and Access Management settings.</p>
    pub aws_iam_config: std::option::Option<crate::model::AwsIamConfig>,
}
impl AuthorizationConfig {
    /// <p>The authorization type required by the HTTP endpoint.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AWS_IAM</b>: The authorization type is
    /// Sigv4.</p>
    /// </li>
    /// </ul>
    pub fn authorization_type(&self) -> std::option::Option<&crate::model::AuthorizationType> {
        self.authorization_type.as_ref()
    }
    /// <p>The Identity and Access Management settings.</p>
    pub fn aws_iam_config(&self) -> std::option::Option<&crate::model::AwsIamConfig> {
        self.aws_iam_config.as_ref()
    }
}
impl std::fmt::Debug for AuthorizationConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationConfig");
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("aws_iam_config", &self.aws_iam_config);
        formatter.finish()
    }
}
/// See [`AuthorizationConfig`](crate::model::AuthorizationConfig)
pub mod authorization_config {
    /// A builder for [`AuthorizationConfig`](crate::model::AuthorizationConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_type: std::option::Option<crate::model::AuthorizationType>,
        pub(crate) aws_iam_config: std::option::Option<crate::model::AwsIamConfig>,
    }
    impl Builder {
        /// <p>The authorization type required by the HTTP endpoint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AWS_IAM</b>: The authorization type is
        /// Sigv4.</p>
        /// </li>
        /// </ul>
        pub fn authorization_type(mut self, input: crate::model::AuthorizationType) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type required by the HTTP endpoint.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AWS_IAM</b>: The authorization type is
        /// Sigv4.</p>
        /// </li>
        /// </ul>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::AuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>The Identity and Access Management settings.</p>
        pub fn aws_iam_config(mut self, input: crate::model::AwsIamConfig) -> Self {
            self.aws_iam_config = Some(input);
            self
        }
        /// <p>The Identity and Access Management settings.</p>
        pub fn set_aws_iam_config(
            mut self,
            input: std::option::Option<crate::model::AwsIamConfig>,
        ) -> Self {
            self.aws_iam_config = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationConfig`](crate::model::AuthorizationConfig)
        pub fn build(self) -> crate::model::AuthorizationConfig {
            crate::model::AuthorizationConfig {
                authorization_type: self.authorization_type,
                aws_iam_config: self.aws_iam_config,
            }
        }
    }
}
impl AuthorizationConfig {
    /// Creates a new builder-style object to manufacture [`AuthorizationConfig`](crate::model::AuthorizationConfig)
    pub fn builder() -> crate::model::authorization_config::Builder {
        crate::model::authorization_config::Builder::default()
    }
}

/// <p>The Identity and Access Management configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsIamConfig {
    /// <p>The signing region for Identity and Access Management authorization.</p>
    pub signing_region: std::option::Option<std::string::String>,
    /// <p>The signing service name for Identity and Access Management authorization.</p>
    pub signing_service_name: std::option::Option<std::string::String>,
}
impl AwsIamConfig {
    /// <p>The signing region for Identity and Access Management authorization.</p>
    pub fn signing_region(&self) -> std::option::Option<&str> {
        self.signing_region.as_deref()
    }
    /// <p>The signing service name for Identity and Access Management authorization.</p>
    pub fn signing_service_name(&self) -> std::option::Option<&str> {
        self.signing_service_name.as_deref()
    }
}
impl std::fmt::Debug for AwsIamConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsIamConfig");
        formatter.field("signing_region", &self.signing_region);
        formatter.field("signing_service_name", &self.signing_service_name);
        formatter.finish()
    }
}
/// See [`AwsIamConfig`](crate::model::AwsIamConfig)
pub mod aws_iam_config {
    /// A builder for [`AwsIamConfig`](crate::model::AwsIamConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) signing_region: std::option::Option<std::string::String>,
        pub(crate) signing_service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The signing region for Identity and Access Management authorization.</p>
        pub fn signing_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_region = Some(input.into());
            self
        }
        /// <p>The signing region for Identity and Access Management authorization.</p>
        pub fn set_signing_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_region = input;
            self
        }
        /// <p>The signing service name for Identity and Access Management authorization.</p>
        pub fn signing_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_service_name = Some(input.into());
            self
        }
        /// <p>The signing service name for Identity and Access Management authorization.</p>
        pub fn set_signing_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsIamConfig`](crate::model::AwsIamConfig)
        pub fn build(self) -> crate::model::AwsIamConfig {
            crate::model::AwsIamConfig {
                signing_region: self.signing_region,
                signing_service_name: self.signing_service_name,
            }
        }
    }
}
impl AwsIamConfig {
    /// Creates a new builder-style object to manufacture [`AwsIamConfig`](crate::model::AwsIamConfig)
    pub fn builder() -> crate::model::aws_iam_config::Builder {
        crate::model::aws_iam_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthorizationType {
    #[allow(missing_docs)] // documentation missing in model
    AwsIam,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthorizationType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_IAM" => AuthorizationType::AwsIam,
            other => AuthorizationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthorizationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthorizationType::from(s))
    }
}
impl AuthorizationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthorizationType::AwsIam => "AWS_IAM",
            AuthorizationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_IAM"]
    }
}
impl AsRef<str> for AuthorizationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an OpenSearch data source configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OpenSearchServiceDataSourceConfig {
    /// <p>The endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl OpenSearchServiceDataSourceConfig {
    /// <p>The endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The Amazon Web Services Region.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for OpenSearchServiceDataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OpenSearchServiceDataSourceConfig");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`OpenSearchServiceDataSourceConfig`](crate::model::OpenSearchServiceDataSourceConfig)
pub mod open_search_service_data_source_config {
    /// A builder for [`OpenSearchServiceDataSourceConfig`](crate::model::OpenSearchServiceDataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`OpenSearchServiceDataSourceConfig`](crate::model::OpenSearchServiceDataSourceConfig)
        pub fn build(self) -> crate::model::OpenSearchServiceDataSourceConfig {
            crate::model::OpenSearchServiceDataSourceConfig {
                endpoint: self.endpoint,
                aws_region: self.aws_region,
            }
        }
    }
}
impl OpenSearchServiceDataSourceConfig {
    /// Creates a new builder-style object to manufacture [`OpenSearchServiceDataSourceConfig`](crate::model::OpenSearchServiceDataSourceConfig)
    pub fn builder() -> crate::model::open_search_service_data_source_config::Builder {
        crate::model::open_search_service_data_source_config::Builder::default()
    }
}

/// <p>Describes an OpenSearch data source configuration.</p>
/// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This
/// configuration is deprecated. For new data sources, use <a>OpenSearchServiceDataSourceConfig</a> to specify an OpenSearch data
/// source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchDataSourceConfig {
    /// <p>The endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region.</p>
    pub aws_region: std::option::Option<std::string::String>,
}
impl ElasticsearchDataSourceConfig {
    /// <p>The endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The Amazon Web Services Region.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
}
impl std::fmt::Debug for ElasticsearchDataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchDataSourceConfig");
        formatter.field("endpoint", &self.endpoint);
        formatter.field("aws_region", &self.aws_region);
        formatter.finish()
    }
}
/// See [`ElasticsearchDataSourceConfig`](crate::model::ElasticsearchDataSourceConfig)
pub mod elasticsearch_data_source_config {
    /// A builder for [`ElasticsearchDataSourceConfig`](crate::model::ElasticsearchDataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchDataSourceConfig`](crate::model::ElasticsearchDataSourceConfig)
        pub fn build(self) -> crate::model::ElasticsearchDataSourceConfig {
            crate::model::ElasticsearchDataSourceConfig {
                endpoint: self.endpoint,
                aws_region: self.aws_region,
            }
        }
    }
}
impl ElasticsearchDataSourceConfig {
    /// Creates a new builder-style object to manufacture [`ElasticsearchDataSourceConfig`](crate::model::ElasticsearchDataSourceConfig)
    pub fn builder() -> crate::model::elasticsearch_data_source_config::Builder {
        crate::model::elasticsearch_data_source_config::Builder::default()
    }
}

/// <p>Describes an Amazon Web Services Lambda data source configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaDataSourceConfig {
    /// <p>The ARN for the Lambda function.</p>
    pub lambda_function_arn: std::option::Option<std::string::String>,
}
impl LambdaDataSourceConfig {
    /// <p>The ARN for the Lambda function.</p>
    pub fn lambda_function_arn(&self) -> std::option::Option<&str> {
        self.lambda_function_arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaDataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaDataSourceConfig");
        formatter.field("lambda_function_arn", &self.lambda_function_arn);
        formatter.finish()
    }
}
/// See [`LambdaDataSourceConfig`](crate::model::LambdaDataSourceConfig)
pub mod lambda_data_source_config {
    /// A builder for [`LambdaDataSourceConfig`](crate::model::LambdaDataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lambda_function_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN for the Lambda function.</p>
        pub fn lambda_function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_function_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the Lambda function.</p>
        pub fn set_lambda_function_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.lambda_function_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaDataSourceConfig`](crate::model::LambdaDataSourceConfig)
        pub fn build(self) -> crate::model::LambdaDataSourceConfig {
            crate::model::LambdaDataSourceConfig {
                lambda_function_arn: self.lambda_function_arn,
            }
        }
    }
}
impl LambdaDataSourceConfig {
    /// Creates a new builder-style object to manufacture [`LambdaDataSourceConfig`](crate::model::LambdaDataSourceConfig)
    pub fn builder() -> crate::model::lambda_data_source_config::Builder {
        crate::model::lambda_data_source_config::Builder::default()
    }
}

/// <p>Describes an Amazon DynamoDB data source configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamodbDataSourceConfig {
    /// <p>The table name.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region.</p>
    pub aws_region: std::option::Option<std::string::String>,
    /// <p>Set to TRUE to use Amazon Cognito credentials with this data source.</p>
    pub use_caller_credentials: bool,
    /// <p>The <code>DeltaSyncConfig</code> for a versioned datasource.</p>
    pub delta_sync_config: std::option::Option<crate::model::DeltaSyncConfig>,
    /// <p>Set to TRUE to use Conflict Detection and Resolution with this data source.</p>
    pub versioned: bool,
}
impl DynamodbDataSourceConfig {
    /// <p>The table name.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The Amazon Web Services Region.</p>
    pub fn aws_region(&self) -> std::option::Option<&str> {
        self.aws_region.as_deref()
    }
    /// <p>Set to TRUE to use Amazon Cognito credentials with this data source.</p>
    pub fn use_caller_credentials(&self) -> bool {
        self.use_caller_credentials
    }
    /// <p>The <code>DeltaSyncConfig</code> for a versioned datasource.</p>
    pub fn delta_sync_config(&self) -> std::option::Option<&crate::model::DeltaSyncConfig> {
        self.delta_sync_config.as_ref()
    }
    /// <p>Set to TRUE to use Conflict Detection and Resolution with this data source.</p>
    pub fn versioned(&self) -> bool {
        self.versioned
    }
}
impl std::fmt::Debug for DynamodbDataSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamodbDataSourceConfig");
        formatter.field("table_name", &self.table_name);
        formatter.field("aws_region", &self.aws_region);
        formatter.field("use_caller_credentials", &self.use_caller_credentials);
        formatter.field("delta_sync_config", &self.delta_sync_config);
        formatter.field("versioned", &self.versioned);
        formatter.finish()
    }
}
/// See [`DynamodbDataSourceConfig`](crate::model::DynamodbDataSourceConfig)
pub mod dynamodb_data_source_config {
    /// A builder for [`DynamodbDataSourceConfig`](crate::model::DynamodbDataSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) aws_region: std::option::Option<std::string::String>,
        pub(crate) use_caller_credentials: std::option::Option<bool>,
        pub(crate) delta_sync_config: std::option::Option<crate::model::DeltaSyncConfig>,
        pub(crate) versioned: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The table name.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The table name.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn aws_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region.</p>
        pub fn set_aws_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.aws_region = input;
            self
        }
        /// <p>Set to TRUE to use Amazon Cognito credentials with this data source.</p>
        pub fn use_caller_credentials(mut self, input: bool) -> Self {
            self.use_caller_credentials = Some(input);
            self
        }
        /// <p>Set to TRUE to use Amazon Cognito credentials with this data source.</p>
        pub fn set_use_caller_credentials(mut self, input: std::option::Option<bool>) -> Self {
            self.use_caller_credentials = input;
            self
        }
        /// <p>The <code>DeltaSyncConfig</code> for a versioned datasource.</p>
        pub fn delta_sync_config(mut self, input: crate::model::DeltaSyncConfig) -> Self {
            self.delta_sync_config = Some(input);
            self
        }
        /// <p>The <code>DeltaSyncConfig</code> for a versioned datasource.</p>
        pub fn set_delta_sync_config(
            mut self,
            input: std::option::Option<crate::model::DeltaSyncConfig>,
        ) -> Self {
            self.delta_sync_config = input;
            self
        }
        /// <p>Set to TRUE to use Conflict Detection and Resolution with this data source.</p>
        pub fn versioned(mut self, input: bool) -> Self {
            self.versioned = Some(input);
            self
        }
        /// <p>Set to TRUE to use Conflict Detection and Resolution with this data source.</p>
        pub fn set_versioned(mut self, input: std::option::Option<bool>) -> Self {
            self.versioned = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamodbDataSourceConfig`](crate::model::DynamodbDataSourceConfig)
        pub fn build(self) -> crate::model::DynamodbDataSourceConfig {
            crate::model::DynamodbDataSourceConfig {
                table_name: self.table_name,
                aws_region: self.aws_region,
                use_caller_credentials: self.use_caller_credentials.unwrap_or_default(),
                delta_sync_config: self.delta_sync_config,
                versioned: self.versioned.unwrap_or_default(),
            }
        }
    }
}
impl DynamodbDataSourceConfig {
    /// Creates a new builder-style object to manufacture [`DynamodbDataSourceConfig`](crate::model::DynamodbDataSourceConfig)
    pub fn builder() -> crate::model::dynamodb_data_source_config::Builder {
        crate::model::dynamodb_data_source_config::Builder::default()
    }
}

/// <p>Describes a Delta Sync configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeltaSyncConfig {
    /// <p>The number of minutes an Item is stored in the datasource.</p>
    pub base_table_ttl: i64,
    /// <p>The Delta Sync table name.</p>
    pub delta_sync_table_name: std::option::Option<std::string::String>,
    /// <p>The number of minutes a Delta Sync log entry is stored in the Delta Sync table.</p>
    pub delta_sync_table_ttl: i64,
}
impl DeltaSyncConfig {
    /// <p>The number of minutes an Item is stored in the datasource.</p>
    pub fn base_table_ttl(&self) -> i64 {
        self.base_table_ttl
    }
    /// <p>The Delta Sync table name.</p>
    pub fn delta_sync_table_name(&self) -> std::option::Option<&str> {
        self.delta_sync_table_name.as_deref()
    }
    /// <p>The number of minutes a Delta Sync log entry is stored in the Delta Sync table.</p>
    pub fn delta_sync_table_ttl(&self) -> i64 {
        self.delta_sync_table_ttl
    }
}
impl std::fmt::Debug for DeltaSyncConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeltaSyncConfig");
        formatter.field("base_table_ttl", &self.base_table_ttl);
        formatter.field("delta_sync_table_name", &self.delta_sync_table_name);
        formatter.field("delta_sync_table_ttl", &self.delta_sync_table_ttl);
        formatter.finish()
    }
}
/// See [`DeltaSyncConfig`](crate::model::DeltaSyncConfig)
pub mod delta_sync_config {
    /// A builder for [`DeltaSyncConfig`](crate::model::DeltaSyncConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) base_table_ttl: std::option::Option<i64>,
        pub(crate) delta_sync_table_name: std::option::Option<std::string::String>,
        pub(crate) delta_sync_table_ttl: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of minutes an Item is stored in the datasource.</p>
        pub fn base_table_ttl(mut self, input: i64) -> Self {
            self.base_table_ttl = Some(input);
            self
        }
        /// <p>The number of minutes an Item is stored in the datasource.</p>
        pub fn set_base_table_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.base_table_ttl = input;
            self
        }
        /// <p>The Delta Sync table name.</p>
        pub fn delta_sync_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.delta_sync_table_name = Some(input.into());
            self
        }
        /// <p>The Delta Sync table name.</p>
        pub fn set_delta_sync_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.delta_sync_table_name = input;
            self
        }
        /// <p>The number of minutes a Delta Sync log entry is stored in the Delta Sync table.</p>
        pub fn delta_sync_table_ttl(mut self, input: i64) -> Self {
            self.delta_sync_table_ttl = Some(input);
            self
        }
        /// <p>The number of minutes a Delta Sync log entry is stored in the Delta Sync table.</p>
        pub fn set_delta_sync_table_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.delta_sync_table_ttl = input;
            self
        }
        /// Consumes the builder and constructs a [`DeltaSyncConfig`](crate::model::DeltaSyncConfig)
        pub fn build(self) -> crate::model::DeltaSyncConfig {
            crate::model::DeltaSyncConfig {
                base_table_ttl: self.base_table_ttl.unwrap_or_default(),
                delta_sync_table_name: self.delta_sync_table_name,
                delta_sync_table_ttl: self.delta_sync_table_ttl.unwrap_or_default(),
            }
        }
    }
}
impl DeltaSyncConfig {
    /// Creates a new builder-style object to manufacture [`DeltaSyncConfig`](crate::model::DeltaSyncConfig)
    pub fn builder() -> crate::model::delta_sync_config::Builder {
        crate::model::delta_sync_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataSourceType {
    #[allow(missing_docs)] // documentation missing in model
    AmazonDynamodb,
    #[allow(missing_docs)] // documentation missing in model
    AmazonElasticsearch,
    #[allow(missing_docs)] // documentation missing in model
    AmazonOpensearchService,
    #[allow(missing_docs)] // documentation missing in model
    AwsLambda,
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    RelationalDatabase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataSourceType {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_DYNAMODB" => DataSourceType::AmazonDynamodb,
            "AMAZON_ELASTICSEARCH" => DataSourceType::AmazonElasticsearch,
            "AMAZON_OPENSEARCH_SERVICE" => DataSourceType::AmazonOpensearchService,
            "AWS_LAMBDA" => DataSourceType::AwsLambda,
            "HTTP" => DataSourceType::Http,
            "NONE" => DataSourceType::None,
            "RELATIONAL_DATABASE" => DataSourceType::RelationalDatabase,
            other => DataSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataSourceType::from(s))
    }
}
impl DataSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataSourceType::AmazonDynamodb => "AMAZON_DYNAMODB",
            DataSourceType::AmazonElasticsearch => "AMAZON_ELASTICSEARCH",
            DataSourceType::AmazonOpensearchService => "AMAZON_OPENSEARCH_SERVICE",
            DataSourceType::AwsLambda => "AWS_LAMBDA",
            DataSourceType::Http => "HTTP",
            DataSourceType::None => "NONE",
            DataSourceType::RelationalDatabase => "RELATIONAL_DATABASE",
            DataSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMAZON_DYNAMODB",
            "AMAZON_ELASTICSEARCH",
            "AMAZON_OPENSEARCH_SERVICE",
            "AWS_LAMBDA",
            "HTTP",
            "NONE",
            "RELATIONAL_DATABASE",
        ]
    }
}
impl AsRef<str> for DataSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an API key.</p>
/// <p>Customers invoke AppSync GraphQL API operations with API keys as an
/// identity mechanism. There are two key versions:</p>
/// <p>
/// <b>da1</b>: This version was introduced at launch in November
/// 2017. These keys always expire after 7 days. Key expiration is managed by Amazon DynamoDB
/// TTL. The keys ceased to be valid after February 21, 2018 and should not be used after that
/// date.</p>
/// <ul>
/// <li>
/// <p>
/// <code>ListApiKeys</code> returns the expiration time in milliseconds.</p>
/// </li>
/// <li>
/// <p>
/// <code>CreateApiKey</code> returns the expiration time in
/// milliseconds.</p>
/// </li>
/// <li>
/// <p>
/// <code>UpdateApiKey</code> is not available for this key version.</p>
/// </li>
/// <li>
/// <p>
/// <code>DeleteApiKey</code> deletes the item from the table.</p>
/// </li>
/// <li>
/// <p>Expiration is stored in Amazon DynamoDB as milliseconds. This results in a bug
/// where keys are not automatically deleted because DynamoDB expects the TTL to be
/// stored in seconds. As a one-time action, we will delete these keys from the table
/// after February 21, 2018.</p>
/// </li>
/// </ul>
/// <p>
/// <b>da2</b>: This version was introduced in February 2018 when
/// AppSync added support to extend key expiration.</p>
/// <ul>
/// <li>
/// <p>
/// <code>ListApiKeys</code> returns the expiration time and deletion time in
/// seconds.</p>
/// </li>
/// <li>
/// <p>
/// <code>CreateApiKey</code> returns the expiration time and deletion time in
/// seconds and accepts a user-provided expiration time in seconds.</p>
/// </li>
/// <li>
/// <p>
/// <code>UpdateApiKey</code> returns the expiration time and and deletion time in
/// seconds and accepts a user-provided expiration time in seconds. Expired API keys are
/// kept for 60 days after the expiration time. Key expiration time can be updated while
/// the key is not deleted. </p>
/// </li>
/// <li>
/// <p>
/// <code>DeleteApiKey</code> deletes the item from the table.</p>
/// </li>
/// <li>
/// <p>Expiration is stored in Amazon DynamoDB as seconds. After the expiration time,
/// using the key to authenticate will fail. But the key can be reinstated before
/// deletion.</p>
/// </li>
/// <li>
/// <p>Deletion is stored in Amazon DynamoDB as seconds. The key will be deleted after
/// deletion time. </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiKey {
    /// <p>The API key ID.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A description of the purpose of the API key.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The time after which the API key expires. The date is represented as seconds since the
    /// epoch, rounded down to the nearest hour.</p>
    pub expires: i64,
    /// <p>The time after which the API key is deleted. The date is represented as seconds since
    /// the epoch, rounded down to the nearest hour.</p>
    pub deletes: i64,
}
impl ApiKey {
    /// <p>The API key ID.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A description of the purpose of the API key.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The time after which the API key expires. The date is represented as seconds since the
    /// epoch, rounded down to the nearest hour.</p>
    pub fn expires(&self) -> i64 {
        self.expires
    }
    /// <p>The time after which the API key is deleted. The date is represented as seconds since
    /// the epoch, rounded down to the nearest hour.</p>
    pub fn deletes(&self) -> i64 {
        self.deletes
    }
}
impl std::fmt::Debug for ApiKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiKey");
        formatter.field("id", &self.id);
        formatter.field("description", &self.description);
        formatter.field("expires", &self.expires);
        formatter.field("deletes", &self.deletes);
        formatter.finish()
    }
}
/// See [`ApiKey`](crate::model::ApiKey)
pub mod api_key {
    /// A builder for [`ApiKey`](crate::model::ApiKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<i64>,
        pub(crate) deletes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The API key ID.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The API key ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The time after which the API key expires. The date is represented as seconds since the
        /// epoch, rounded down to the nearest hour.</p>
        pub fn expires(mut self, input: i64) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The time after which the API key expires. The date is represented as seconds since the
        /// epoch, rounded down to the nearest hour.</p>
        pub fn set_expires(mut self, input: std::option::Option<i64>) -> Self {
            self.expires = input;
            self
        }
        /// <p>The time after which the API key is deleted. The date is represented as seconds since
        /// the epoch, rounded down to the nearest hour.</p>
        pub fn deletes(mut self, input: i64) -> Self {
            self.deletes = Some(input);
            self
        }
        /// <p>The time after which the API key is deleted. The date is represented as seconds since
        /// the epoch, rounded down to the nearest hour.</p>
        pub fn set_deletes(mut self, input: std::option::Option<i64>) -> Self {
            self.deletes = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiKey`](crate::model::ApiKey)
        pub fn build(self) -> crate::model::ApiKey {
            crate::model::ApiKey {
                id: self.id,
                description: self.description,
                expires: self.expires.unwrap_or_default(),
                deletes: self.deletes.unwrap_or_default(),
            }
        }
    }
}
impl ApiKey {
    /// Creates a new builder-style object to manufacture [`ApiKey`](crate::model::ApiKey)
    pub fn builder() -> crate::model::api_key::Builder {
        crate::model::api_key::Builder::default()
    }
}

/// <p>The <code>ApiCache</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiCache {
    /// <p>TTL in seconds for cache entries.</p>
    /// <p>Valid values are between 1 and 3600 seconds.</p>
    pub ttl: i64,
    /// <p>Caching behavior.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
    /// cached.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
    /// that you specify are cached.</p>
    /// </li>
    /// </ul>
    pub api_caching_behavior: std::option::Option<crate::model::ApiCachingBehavior>,
    /// <p>Transit encryption flag when connecting to cache. This setting cannot be updated after
    /// creation.</p>
    pub transit_encryption_enabled: bool,
    /// <p>At rest encryption flag for cache. This setting cannot be updated after creation.</p>
    pub at_rest_encryption_enabled: bool,
    /// <p>The cache instance type. Valid values are </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SMALL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MEDIUM</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>XLARGE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_2X</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_4X</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_8X</code> (not available in all regions)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_12X</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
    /// <p>The following legacy instance types are available, but their use is discouraged:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>T2_SMALL</b>: A t2.small instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_LARGE</b>: A r4.large instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ApiCacheType>,
    /// <p>The cache instance status.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AVAILABLE</b>: The instance is available for
    /// use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CREATING</b>: The instance is currently
    /// creating.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>DELETING</b>: The instance is currently
    /// deleting.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MODIFYING</b>: The instance is currently
    /// modifying.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>FAILED</b>: The instance has failed
    /// creation.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ApiCacheStatus>,
}
impl ApiCache {
    /// <p>TTL in seconds for cache entries.</p>
    /// <p>Valid values are between 1 and 3600 seconds.</p>
    pub fn ttl(&self) -> i64 {
        self.ttl
    }
    /// <p>Caching behavior.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
    /// cached.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
    /// that you specify are cached.</p>
    /// </li>
    /// </ul>
    pub fn api_caching_behavior(&self) -> std::option::Option<&crate::model::ApiCachingBehavior> {
        self.api_caching_behavior.as_ref()
    }
    /// <p>Transit encryption flag when connecting to cache. This setting cannot be updated after
    /// creation.</p>
    pub fn transit_encryption_enabled(&self) -> bool {
        self.transit_encryption_enabled
    }
    /// <p>At rest encryption flag for cache. This setting cannot be updated after creation.</p>
    pub fn at_rest_encryption_enabled(&self) -> bool {
        self.at_rest_encryption_enabled
    }
    /// <p>The cache instance type. Valid values are </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SMALL</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MEDIUM</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>XLARGE</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_2X</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_4X</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_8X</code> (not available in all regions)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LARGE_12X</code>
    /// </p>
    /// </li>
    /// </ul>
    /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
    /// <p>The following legacy instance types are available, but their use is discouraged:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>T2_SMALL</b>: A t2.small instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_LARGE</b>: A r4.large instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ApiCacheType> {
        self.r#type.as_ref()
    }
    /// <p>The cache instance status.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>AVAILABLE</b>: The instance is available for
    /// use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>CREATING</b>: The instance is currently
    /// creating.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>DELETING</b>: The instance is currently
    /// deleting.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>MODIFYING</b>: The instance is currently
    /// modifying.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>FAILED</b>: The instance has failed
    /// creation.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ApiCacheStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ApiCache {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiCache");
        formatter.field("ttl", &self.ttl);
        formatter.field("api_caching_behavior", &self.api_caching_behavior);
        formatter.field(
            "transit_encryption_enabled",
            &self.transit_encryption_enabled,
        );
        formatter.field(
            "at_rest_encryption_enabled",
            &self.at_rest_encryption_enabled,
        );
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ApiCache`](crate::model::ApiCache)
pub mod api_cache {
    /// A builder for [`ApiCache`](crate::model::ApiCache)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ttl: std::option::Option<i64>,
        pub(crate) api_caching_behavior: std::option::Option<crate::model::ApiCachingBehavior>,
        pub(crate) transit_encryption_enabled: std::option::Option<bool>,
        pub(crate) at_rest_encryption_enabled: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<crate::model::ApiCacheType>,
        pub(crate) status: std::option::Option<crate::model::ApiCacheStatus>,
    }
    impl Builder {
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn ttl(mut self, input: i64) -> Self {
            self.ttl = Some(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.ttl = input;
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
        /// cached.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
        /// that you specify are cached.</p>
        /// </li>
        /// </ul>
        pub fn api_caching_behavior(mut self, input: crate::model::ApiCachingBehavior) -> Self {
            self.api_caching_behavior = Some(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
        /// cached.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
        /// that you specify are cached.</p>
        /// </li>
        /// </ul>
        pub fn set_api_caching_behavior(
            mut self,
            input: std::option::Option<crate::model::ApiCachingBehavior>,
        ) -> Self {
            self.api_caching_behavior = input;
            self
        }
        /// <p>Transit encryption flag when connecting to cache. This setting cannot be updated after
        /// creation.</p>
        pub fn transit_encryption_enabled(mut self, input: bool) -> Self {
            self.transit_encryption_enabled = Some(input);
            self
        }
        /// <p>Transit encryption flag when connecting to cache. This setting cannot be updated after
        /// creation.</p>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.transit_encryption_enabled = input;
            self
        }
        /// <p>At rest encryption flag for cache. This setting cannot be updated after creation.</p>
        pub fn at_rest_encryption_enabled(mut self, input: bool) -> Self {
            self.at_rest_encryption_enabled = Some(input);
            self
        }
        /// <p>At rest encryption flag for cache. This setting cannot be updated after creation.</p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.at_rest_encryption_enabled = input;
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MEDIUM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>XLARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_2X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_4X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_8X</code> (not available in all regions)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_12X</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>T2_SMALL</b>: A t2.small instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_LARGE</b>: A r4.large instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ApiCacheType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MEDIUM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>XLARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_2X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_4X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_8X</code> (not available in all regions)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_12X</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>T2_SMALL</b>: A t2.small instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_LARGE</b>: A r4.large instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ApiCacheType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The cache instance status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AVAILABLE</b>: The instance is available for
        /// use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CREATING</b>: The instance is currently
        /// creating.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DELETING</b>: The instance is currently
        /// deleting.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MODIFYING</b>: The instance is currently
        /// modifying.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>FAILED</b>: The instance has failed
        /// creation.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ApiCacheStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The cache instance status.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>AVAILABLE</b>: The instance is available for
        /// use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>CREATING</b>: The instance is currently
        /// creating.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>DELETING</b>: The instance is currently
        /// deleting.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>MODIFYING</b>: The instance is currently
        /// modifying.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>FAILED</b>: The instance has failed
        /// creation.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ApiCacheStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiCache`](crate::model::ApiCache)
        pub fn build(self) -> crate::model::ApiCache {
            crate::model::ApiCache {
                ttl: self.ttl.unwrap_or_default(),
                api_caching_behavior: self.api_caching_behavior,
                transit_encryption_enabled: self.transit_encryption_enabled.unwrap_or_default(),
                at_rest_encryption_enabled: self.at_rest_encryption_enabled.unwrap_or_default(),
                r#type: self.r#type,
                status: self.status,
            }
        }
    }
}
impl ApiCache {
    /// Creates a new builder-style object to manufacture [`ApiCache`](crate::model::ApiCache)
    pub fn builder() -> crate::model::api_cache::Builder {
        crate::model::api_cache::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiCacheStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Modifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiCacheStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ApiCacheStatus::Available,
            "CREATING" => ApiCacheStatus::Creating,
            "DELETING" => ApiCacheStatus::Deleting,
            "FAILED" => ApiCacheStatus::Failed,
            "MODIFYING" => ApiCacheStatus::Modifying,
            other => ApiCacheStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiCacheStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiCacheStatus::from(s))
    }
}
impl ApiCacheStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiCacheStatus::Available => "AVAILABLE",
            ApiCacheStatus::Creating => "CREATING",
            ApiCacheStatus::Deleting => "DELETING",
            ApiCacheStatus::Failed => "FAILED",
            ApiCacheStatus::Modifying => "MODIFYING",
            ApiCacheStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "CREATING", "DELETING", "FAILED", "MODIFYING"]
    }
}
impl AsRef<str> for ApiCacheStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiCacheType {
    #[allow(missing_docs)] // documentation missing in model
    Large,
    #[allow(missing_docs)] // documentation missing in model
    Large12X,
    #[allow(missing_docs)] // documentation missing in model
    Large2X,
    #[allow(missing_docs)] // documentation missing in model
    Large4X,
    #[allow(missing_docs)] // documentation missing in model
    Large8X,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    R42Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R44Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R48Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    R4Large,
    #[allow(missing_docs)] // documentation missing in model
    R4Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    Small,
    #[allow(missing_docs)] // documentation missing in model
    T2Medium,
    #[allow(missing_docs)] // documentation missing in model
    T2Small,
    #[allow(missing_docs)] // documentation missing in model
    Xlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiCacheType {
    fn from(s: &str) -> Self {
        match s {
            "LARGE" => ApiCacheType::Large,
            "LARGE_12X" => ApiCacheType::Large12X,
            "LARGE_2X" => ApiCacheType::Large2X,
            "LARGE_4X" => ApiCacheType::Large4X,
            "LARGE_8X" => ApiCacheType::Large8X,
            "MEDIUM" => ApiCacheType::Medium,
            "R4_2XLARGE" => ApiCacheType::R42Xlarge,
            "R4_4XLARGE" => ApiCacheType::R44Xlarge,
            "R4_8XLARGE" => ApiCacheType::R48Xlarge,
            "R4_LARGE" => ApiCacheType::R4Large,
            "R4_XLARGE" => ApiCacheType::R4Xlarge,
            "SMALL" => ApiCacheType::Small,
            "T2_MEDIUM" => ApiCacheType::T2Medium,
            "T2_SMALL" => ApiCacheType::T2Small,
            "XLARGE" => ApiCacheType::Xlarge,
            other => ApiCacheType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiCacheType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiCacheType::from(s))
    }
}
impl ApiCacheType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiCacheType::Large => "LARGE",
            ApiCacheType::Large12X => "LARGE_12X",
            ApiCacheType::Large2X => "LARGE_2X",
            ApiCacheType::Large4X => "LARGE_4X",
            ApiCacheType::Large8X => "LARGE_8X",
            ApiCacheType::Medium => "MEDIUM",
            ApiCacheType::R42Xlarge => "R4_2XLARGE",
            ApiCacheType::R44Xlarge => "R4_4XLARGE",
            ApiCacheType::R48Xlarge => "R4_8XLARGE",
            ApiCacheType::R4Large => "R4_LARGE",
            ApiCacheType::R4Xlarge => "R4_XLARGE",
            ApiCacheType::Small => "SMALL",
            ApiCacheType::T2Medium => "T2_MEDIUM",
            ApiCacheType::T2Small => "T2_SMALL",
            ApiCacheType::Xlarge => "XLARGE",
            ApiCacheType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "LARGE",
            "LARGE_12X",
            "LARGE_2X",
            "LARGE_4X",
            "LARGE_8X",
            "MEDIUM",
            "R4_2XLARGE",
            "R4_4XLARGE",
            "R4_8XLARGE",
            "R4_LARGE",
            "R4_XLARGE",
            "SMALL",
            "T2_MEDIUM",
            "T2_SMALL",
            "XLARGE",
        ]
    }
}
impl AsRef<str> for ApiCacheType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiCachingBehavior {
    #[allow(missing_docs)] // documentation missing in model
    FullRequestCaching,
    #[allow(missing_docs)] // documentation missing in model
    PerResolverCaching,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiCachingBehavior {
    fn from(s: &str) -> Self {
        match s {
            "FULL_REQUEST_CACHING" => ApiCachingBehavior::FullRequestCaching,
            "PER_RESOLVER_CACHING" => ApiCachingBehavior::PerResolverCaching,
            other => ApiCachingBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiCachingBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiCachingBehavior::from(s))
    }
}
impl ApiCachingBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiCachingBehavior::FullRequestCaching => "FULL_REQUEST_CACHING",
            ApiCachingBehavior::PerResolverCaching => "PER_RESOLVER_CACHING",
            ApiCachingBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL_REQUEST_CACHING", "PER_RESOLVER_CACHING"]
    }
}
impl AsRef<str> for ApiCachingBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SchemaStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotApplicable,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SchemaStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => SchemaStatus::Active,
            "DELETING" => SchemaStatus::Deleting,
            "FAILED" => SchemaStatus::Failed,
            "NOT_APPLICABLE" => SchemaStatus::NotApplicable,
            "PROCESSING" => SchemaStatus::Processing,
            "SUCCESS" => SchemaStatus::Success,
            other => SchemaStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SchemaStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SchemaStatus::from(s))
    }
}
impl SchemaStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SchemaStatus::Active => "ACTIVE",
            SchemaStatus::Deleting => "DELETING",
            SchemaStatus::Failed => "FAILED",
            SchemaStatus::NotApplicable => "NOT_APPLICABLE",
            SchemaStatus::Processing => "PROCESSING",
            SchemaStatus::Success => "SUCCESS",
            SchemaStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "DELETING",
            "FAILED",
            "NOT_APPLICABLE",
            "PROCESSING",
            "SUCCESS",
        ]
    }
}
impl AsRef<str> for SchemaStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OutputType {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Sdl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OutputType {
    fn from(s: &str) -> Self {
        match s {
            "JSON" => OutputType::Json,
            "SDL" => OutputType::Sdl,
            other => OutputType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OutputType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OutputType::from(s))
    }
}
impl OutputType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OutputType::Json => "JSON",
            OutputType::Sdl => "SDL",
            OutputType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["JSON", "SDL"]
    }
}
impl AsRef<str> for OutputType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
