// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS AppSync
///
/// Client for invoking operations on AWS AppSync. Each operation on AWS AppSync is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appsync::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appsync::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appsync::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateApiCache` operation.
    ///
    /// See [`CreateApiCache`](crate::client::fluent_builders::CreateApiCache) for more information about the
    /// operation and its arguments.
    pub fn create_api_cache(&self) -> fluent_builders::CreateApiCache<C, M, R> {
        fluent_builders::CreateApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApiKey` operation.
    ///
    /// See [`CreateApiKey`](crate::client::fluent_builders::CreateApiKey) for more information about the
    /// operation and its arguments.
    pub fn create_api_key(&self) -> fluent_builders::CreateApiKey<C, M, R> {
        fluent_builders::CreateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSource` operation.
    ///
    /// See [`CreateDataSource`](crate::client::fluent_builders::CreateDataSource) for more information about the
    /// operation and its arguments.
    pub fn create_data_source(&self) -> fluent_builders::CreateDataSource<C, M, R> {
        fluent_builders::CreateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFunction` operation.
    ///
    /// See [`CreateFunction`](crate::client::fluent_builders::CreateFunction) for more information about the
    /// operation and its arguments.
    pub fn create_function(&self) -> fluent_builders::CreateFunction<C, M, R> {
        fluent_builders::CreateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGraphqlApi` operation.
    ///
    /// See [`CreateGraphqlApi`](crate::client::fluent_builders::CreateGraphqlApi) for more information about the
    /// operation and its arguments.
    pub fn create_graphql_api(&self) -> fluent_builders::CreateGraphqlApi<C, M, R> {
        fluent_builders::CreateGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateResolver` operation.
    ///
    /// See [`CreateResolver`](crate::client::fluent_builders::CreateResolver) for more information about the
    /// operation and its arguments.
    pub fn create_resolver(&self) -> fluent_builders::CreateResolver<C, M, R> {
        fluent_builders::CreateResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateType` operation.
    ///
    /// See [`CreateType`](crate::client::fluent_builders::CreateType) for more information about the
    /// operation and its arguments.
    pub fn create_type(&self) -> fluent_builders::CreateType<C, M, R> {
        fluent_builders::CreateType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApiCache` operation.
    ///
    /// See [`DeleteApiCache`](crate::client::fluent_builders::DeleteApiCache) for more information about the
    /// operation and its arguments.
    pub fn delete_api_cache(&self) -> fluent_builders::DeleteApiCache<C, M, R> {
        fluent_builders::DeleteApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApiKey` operation.
    ///
    /// See [`DeleteApiKey`](crate::client::fluent_builders::DeleteApiKey) for more information about the
    /// operation and its arguments.
    pub fn delete_api_key(&self) -> fluent_builders::DeleteApiKey<C, M, R> {
        fluent_builders::DeleteApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataSource` operation.
    ///
    /// See [`DeleteDataSource`](crate::client::fluent_builders::DeleteDataSource) for more information about the
    /// operation and its arguments.
    pub fn delete_data_source(&self) -> fluent_builders::DeleteDataSource<C, M, R> {
        fluent_builders::DeleteDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFunction` operation.
    ///
    /// See [`DeleteFunction`](crate::client::fluent_builders::DeleteFunction) for more information about the
    /// operation and its arguments.
    pub fn delete_function(&self) -> fluent_builders::DeleteFunction<C, M, R> {
        fluent_builders::DeleteFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGraphqlApi` operation.
    ///
    /// See [`DeleteGraphqlApi`](crate::client::fluent_builders::DeleteGraphqlApi) for more information about the
    /// operation and its arguments.
    pub fn delete_graphql_api(&self) -> fluent_builders::DeleteGraphqlApi<C, M, R> {
        fluent_builders::DeleteGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResolver` operation.
    ///
    /// See [`DeleteResolver`](crate::client::fluent_builders::DeleteResolver) for more information about the
    /// operation and its arguments.
    pub fn delete_resolver(&self) -> fluent_builders::DeleteResolver<C, M, R> {
        fluent_builders::DeleteResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteType` operation.
    ///
    /// See [`DeleteType`](crate::client::fluent_builders::DeleteType) for more information about the
    /// operation and its arguments.
    pub fn delete_type(&self) -> fluent_builders::DeleteType<C, M, R> {
        fluent_builders::DeleteType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `FlushApiCache` operation.
    ///
    /// See [`FlushApiCache`](crate::client::fluent_builders::FlushApiCache) for more information about the
    /// operation and its arguments.
    pub fn flush_api_cache(&self) -> fluent_builders::FlushApiCache<C, M, R> {
        fluent_builders::FlushApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApiCache` operation.
    ///
    /// See [`GetApiCache`](crate::client::fluent_builders::GetApiCache) for more information about the
    /// operation and its arguments.
    pub fn get_api_cache(&self) -> fluent_builders::GetApiCache<C, M, R> {
        fluent_builders::GetApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataSource` operation.
    ///
    /// See [`GetDataSource`](crate::client::fluent_builders::GetDataSource) for more information about the
    /// operation and its arguments.
    pub fn get_data_source(&self) -> fluent_builders::GetDataSource<C, M, R> {
        fluent_builders::GetDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFunction` operation.
    ///
    /// See [`GetFunction`](crate::client::fluent_builders::GetFunction) for more information about the
    /// operation and its arguments.
    pub fn get_function(&self) -> fluent_builders::GetFunction<C, M, R> {
        fluent_builders::GetFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGraphqlApi` operation.
    ///
    /// See [`GetGraphqlApi`](crate::client::fluent_builders::GetGraphqlApi) for more information about the
    /// operation and its arguments.
    pub fn get_graphql_api(&self) -> fluent_builders::GetGraphqlApi<C, M, R> {
        fluent_builders::GetGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntrospectionSchema` operation.
    ///
    /// See [`GetIntrospectionSchema`](crate::client::fluent_builders::GetIntrospectionSchema) for more information about the
    /// operation and its arguments.
    pub fn get_introspection_schema(&self) -> fluent_builders::GetIntrospectionSchema<C, M, R> {
        fluent_builders::GetIntrospectionSchema::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResolver` operation.
    ///
    /// See [`GetResolver`](crate::client::fluent_builders::GetResolver) for more information about the
    /// operation and its arguments.
    pub fn get_resolver(&self) -> fluent_builders::GetResolver<C, M, R> {
        fluent_builders::GetResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSchemaCreationStatus` operation.
    ///
    /// See [`GetSchemaCreationStatus`](crate::client::fluent_builders::GetSchemaCreationStatus) for more information about the
    /// operation and its arguments.
    pub fn get_schema_creation_status(&self) -> fluent_builders::GetSchemaCreationStatus<C, M, R> {
        fluent_builders::GetSchemaCreationStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetType` operation.
    ///
    /// See [`GetType`](crate::client::fluent_builders::GetType) for more information about the
    /// operation and its arguments.
    pub fn get_type(&self) -> fluent_builders::GetType<C, M, R> {
        fluent_builders::GetType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApiKeys` operation.
    ///
    /// See [`ListApiKeys`](crate::client::fluent_builders::ListApiKeys) for more information about the
    /// operation and its arguments.
    pub fn list_api_keys(&self) -> fluent_builders::ListApiKeys<C, M, R> {
        fluent_builders::ListApiKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDataSources` operation.
    ///
    /// See [`ListDataSources`](crate::client::fluent_builders::ListDataSources) for more information about the
    /// operation and its arguments.
    pub fn list_data_sources(&self) -> fluent_builders::ListDataSources<C, M, R> {
        fluent_builders::ListDataSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFunctions` operation.
    ///
    /// See [`ListFunctions`](crate::client::fluent_builders::ListFunctions) for more information about the
    /// operation and its arguments.
    pub fn list_functions(&self) -> fluent_builders::ListFunctions<C, M, R> {
        fluent_builders::ListFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGraphqlApis` operation.
    ///
    /// See [`ListGraphqlApis`](crate::client::fluent_builders::ListGraphqlApis) for more information about the
    /// operation and its arguments.
    pub fn list_graphql_apis(&self) -> fluent_builders::ListGraphqlApis<C, M, R> {
        fluent_builders::ListGraphqlApis::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolvers` operation.
    ///
    /// See [`ListResolvers`](crate::client::fluent_builders::ListResolvers) for more information about the
    /// operation and its arguments.
    pub fn list_resolvers(&self) -> fluent_builders::ListResolvers<C, M, R> {
        fluent_builders::ListResolvers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResolversByFunction` operation.
    ///
    /// See [`ListResolversByFunction`](crate::client::fluent_builders::ListResolversByFunction) for more information about the
    /// operation and its arguments.
    pub fn list_resolvers_by_function(&self) -> fluent_builders::ListResolversByFunction<C, M, R> {
        fluent_builders::ListResolversByFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTypes` operation.
    ///
    /// See [`ListTypes`](crate::client::fluent_builders::ListTypes) for more information about the
    /// operation and its arguments.
    pub fn list_types(&self) -> fluent_builders::ListTypes<C, M, R> {
        fluent_builders::ListTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartSchemaCreation` operation.
    ///
    /// See [`StartSchemaCreation`](crate::client::fluent_builders::StartSchemaCreation) for more information about the
    /// operation and its arguments.
    pub fn start_schema_creation(&self) -> fluent_builders::StartSchemaCreation<C, M, R> {
        fluent_builders::StartSchemaCreation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApiCache` operation.
    ///
    /// See [`UpdateApiCache`](crate::client::fluent_builders::UpdateApiCache) for more information about the
    /// operation and its arguments.
    pub fn update_api_cache(&self) -> fluent_builders::UpdateApiCache<C, M, R> {
        fluent_builders::UpdateApiCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApiKey` operation.
    ///
    /// See [`UpdateApiKey`](crate::client::fluent_builders::UpdateApiKey) for more information about the
    /// operation and its arguments.
    pub fn update_api_key(&self) -> fluent_builders::UpdateApiKey<C, M, R> {
        fluent_builders::UpdateApiKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSource` operation.
    ///
    /// See [`UpdateDataSource`](crate::client::fluent_builders::UpdateDataSource) for more information about the
    /// operation and its arguments.
    pub fn update_data_source(&self) -> fluent_builders::UpdateDataSource<C, M, R> {
        fluent_builders::UpdateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFunction` operation.
    ///
    /// See [`UpdateFunction`](crate::client::fluent_builders::UpdateFunction) for more information about the
    /// operation and its arguments.
    pub fn update_function(&self) -> fluent_builders::UpdateFunction<C, M, R> {
        fluent_builders::UpdateFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGraphqlApi` operation.
    ///
    /// See [`UpdateGraphqlApi`](crate::client::fluent_builders::UpdateGraphqlApi) for more information about the
    /// operation and its arguments.
    pub fn update_graphql_api(&self) -> fluent_builders::UpdateGraphqlApi<C, M, R> {
        fluent_builders::UpdateGraphqlApi::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateResolver` operation.
    ///
    /// See [`UpdateResolver`](crate::client::fluent_builders::UpdateResolver) for more information about the
    /// operation and its arguments.
    pub fn update_resolver(&self) -> fluent_builders::UpdateResolver<C, M, R> {
        fluent_builders::UpdateResolver::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateType` operation.
    ///
    /// See [`UpdateType`](crate::client::fluent_builders::UpdateType) for more information about the
    /// operation and its arguments.
    pub fn update_type(&self) -> fluent_builders::UpdateType<C, M, R> {
        fluent_builders::UpdateType::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateApiCache`.
    ///
    /// <p>Creates a cache for the GraphQL API.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApiCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_api_cache_input::Builder,
    }
    impl<C, M, R> CreateApiCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApiCacheInputOperationOutputAlias,
                crate::output::CreateApiCacheOutput,
                crate::error::CreateApiCacheError,
                crate::input::CreateApiCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API Id.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The GraphQL API Id.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn ttl(mut self, inp: i64) -> Self {
            self.inner = self.inner.ttl(inp);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>Transit encryption flag when connecting to cache. This setting cannot be updated after
        /// creation.</p>
        pub fn transit_encryption_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.transit_encryption_enabled(inp);
            self
        }
        /// <p>Transit encryption flag when connecting to cache. This setting cannot be updated after
        /// creation.</p>
        pub fn set_transit_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_transit_encryption_enabled(input);
            self
        }
        /// <p>At rest encryption flag for cache. This setting cannot be updated after creation.</p>
        pub fn at_rest_encryption_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.at_rest_encryption_enabled(inp);
            self
        }
        /// <p>At rest encryption flag for cache. This setting cannot be updated after creation.</p>
        pub fn set_at_rest_encryption_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_at_rest_encryption_enabled(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
        /// cached.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
        /// that you specify are cached.</p>
        /// </li>
        /// </ul>
        pub fn api_caching_behavior(mut self, inp: crate::model::ApiCachingBehavior) -> Self {
            self.inner = self.inner.api_caching_behavior(inp);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
        /// cached.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
        /// that you specify are cached.</p>
        /// </li>
        /// </ul>
        pub fn set_api_caching_behavior(
            mut self,
            input: std::option::Option<crate::model::ApiCachingBehavior>,
        ) -> Self {
            self.inner = self.inner.set_api_caching_behavior(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MEDIUM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>XLARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_2X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_4X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_8X</code> (not available in all regions)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_12X</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>T2_SMALL</b>: A t2.small instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_LARGE</b>: A r4.large instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ApiCacheType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MEDIUM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>XLARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_2X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_4X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_8X</code> (not available in all regions)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_12X</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>T2_SMALL</b>: A t2.small instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_LARGE</b>: A r4.large instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ApiCacheType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApiKey`.
    ///
    /// <p>Creates a unique key that you can distribute to clients who are executing your
    /// API.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_api_key_input::Builder,
    }
    impl<C, M, R> CreateApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApiKeyInputOperationOutputAlias,
                crate::output::CreateApiKeyOutput,
                crate::error::CreateApiKeyError,
                crate::input::CreateApiKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for your GraphQL API.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The ID for your GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The time from creation time after which the API key expires. The date is represented as
        /// seconds since the epoch, rounded down to the nearest hour. The default value for this
        /// parameter is 7 days from creation time. For more information, see .</p>
        pub fn expires(mut self, inp: i64) -> Self {
            self.inner = self.inner.expires(inp);
            self
        }
        /// <p>The time from creation time after which the API key expires. The date is represented as
        /// seconds since the epoch, rounded down to the nearest hour. The default value for this
        /// parameter is 7 days from creation time. For more information, see .</p>
        pub fn set_expires(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expires(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSource`.
    ///
    /// <p>Creates a <code>DataSource</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_source_input::Builder,
    }
    impl<C, M, R> CreateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSourceInputOperationOutputAlias,
                crate::output::CreateDataSourceOutput,
                crate::error::CreateDataSourceError,
                crate::input::CreateDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID for the GraphQL API for the <code>DataSource</code>.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>A user-supplied name for the <code>DataSource</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A user-supplied name for the <code>DataSource</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description of the <code>DataSource</code>.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the <code>DataSource</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of the <code>DataSource</code>.</p>
        pub fn r#type(mut self, inp: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the <code>DataSource</code>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The Identity and Access Management service role ARN for the data source. The system assumes this
        /// role when accessing the data source.</p>
        pub fn service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(inp);
            self
        }
        /// <p>The Identity and Access Management service role ARN for the data source. The system assumes this
        /// role when accessing the data source.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn dynamodb_config(mut self, inp: crate::model::DynamodbDataSourceConfig) -> Self {
            self.inner = self.inner.dynamodb_config(inp);
            self
        }
        /// <p>Amazon DynamoDB settings.</p>
        pub fn set_dynamodb_config(
            mut self,
            input: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_dynamodb_config(input);
            self
        }
        /// <p>Amazon Web Services Lambda settings.</p>
        pub fn lambda_config(mut self, inp: crate::model::LambdaDataSourceConfig) -> Self {
            self.inner = self.inner.lambda_config(inp);
            self
        }
        /// <p>Amazon Web Services Lambda settings.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_config(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This
        /// configuration is deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create an OpenSearch data source.</p>
        pub fn elasticsearch_config(
            mut self,
            inp: crate::model::ElasticsearchDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_config(inp);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This
        /// configuration is deprecated. For new data sources, use <a>CreateDataSourceRequest$openSearchServiceConfig</a> to create an OpenSearch data source.</p>
        pub fn set_elasticsearch_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_config(input);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn open_search_service_config(
            mut self,
            inp: crate::model::OpenSearchServiceDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.open_search_service_config(inp);
            self
        }
        /// <p>Amazon OpenSearch Service settings.</p>
        pub fn set_open_search_service_config(
            mut self,
            input: std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_search_service_config(input);
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn http_config(mut self, inp: crate::model::HttpDataSourceConfig) -> Self {
            self.inner = self.inner.http_config(inp);
            self
        }
        /// <p>HTTP endpoint settings.</p>
        pub fn set_http_config(
            mut self,
            input: std::option::Option<crate::model::HttpDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_http_config(input);
            self
        }
        /// <p>Relational database settings.</p>
        pub fn relational_database_config(
            mut self,
            inp: crate::model::RelationalDatabaseDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.relational_database_config(inp);
            self
        }
        /// <p>Relational database settings.</p>
        pub fn set_relational_database_config(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFunction`.
    ///
    /// <p>Creates a <code>Function</code> object.</p>
    /// <p>A function is a reusable entity. Multiple functions can be used to compose the resolver
    /// logic.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_function_input::Builder,
    }
    impl<C, M, R> CreateFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFunctionInputOperationOutputAlias,
                crate::output::CreateFunctionOutput,
                crate::error::CreateFunctionError,
                crate::input::CreateFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The <code>Function</code> name. The function name does not have to be unique.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The <code>Function</code>
        /// <code>DataSource</code> name.</p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>The <code>Function</code>
        /// <code>DataSource</code> name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the
        /// 2018-05-29 version of the request mapping template.</p>
        pub fn request_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(inp);
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the
        /// 2018-05-29 version of the request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The <code>Function</code> response mapping template. </p>
        pub fn response_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(inp);
            self
        }
        /// <p>The <code>Function</code> response mapping template. </p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently the supported value
        /// is 2018-05-29. </p>
        pub fn function_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(inp);
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently the supported value
        /// is 2018-05-29. </p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
        /// be performed when the resolver is invoked.</p>
        pub fn sync_config(mut self, inp: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(inp);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
        /// be performed when the resolver is invoked.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGraphqlApi`.
    ///
    /// <p>Creates a <code>GraphqlApi</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGraphqlApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_graphql_api_input::Builder,
    }
    impl<C, M, R> CreateGraphqlApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGraphqlApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGraphqlApiInputOperationOutputAlias,
                crate::output::CreateGraphqlApiOutput,
                crate::error::CreateGraphqlApiError,
                crate::input::CreateGraphqlApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A user-supplied name for the <code>GraphqlApi</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn log_config(mut self, inp: crate::model::LogConfig) -> Self {
            self.inner = self.inner.log_config(inp);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration.</p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogConfig>,
        ) -> Self {
            self.inner = self.inner.set_log_config(input);
            self
        }
        /// <p>The authentication type: API key, Identity and Access Management, OIDC, Amazon Cognito user
        /// pools, or Amazon Web Services Lambda.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication type: API key, Identity and Access Management, OIDC, Amazon Cognito user
        /// pools, or Amazon Web Services Lambda.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn user_pool_config(mut self, inp: crate::model::UserPoolConfig) -> Self {
            self.inner = self.inner.user_pool_config(inp);
            self
        }
        /// <p>The Amazon Cognito user pool configuration.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::UserPoolConfig>,
        ) -> Self {
            self.inner = self.inner.set_user_pool_config(input);
            self
        }
        /// <p>The OpenID Connect configuration.</p>
        pub fn open_id_connect_config(mut self, inp: crate::model::OpenIdConnectConfig) -> Self {
            self.inner = self.inner.open_id_connect_config(inp);
            self
        }
        /// <p>The OpenID Connect configuration.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_config(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A <code>TagMap</code> object.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A <code>TagMap</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `additionalAuthenticationProviders`.
        ///
        /// To override the contents of this collection use [`set_additional_authentication_providers`](Self::set_additional_authentication_providers).
        ///
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
        /// API.</p>
        pub fn additional_authentication_providers(
            mut self,
            inp: impl Into<crate::model::AdditionalAuthenticationProvider>,
        ) -> Self {
            self.inner = self.inner.additional_authentication_providers(inp);
            self
        }
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
        /// API.</p>
        pub fn set_additional_authentication_providers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalAuthenticationProvider>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_authentication_providers(input);
            self
        }
        /// <p>A flag indicating whether to enable X-Ray tracing for the
        /// <code>GraphqlApi</code>.</p>
        pub fn xray_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.xray_enabled(inp);
            self
        }
        /// <p>A flag indicating whether to enable X-Ray tracing for the
        /// <code>GraphqlApi</code>.</p>
        pub fn set_xray_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_xray_enabled(input);
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            inp: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.inner = self.inner.lambda_authorizer_config(inp);
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_authorizer_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateResolver`.
    ///
    /// <p>Creates a <code>Resolver</code> object.</p>
    /// <p>A resolver converts incoming requests into a format that a data source can understand
    /// and converts the data source's responses into GraphQL.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateResolver<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_resolver_input::Builder,
    }
    impl<C, M, R> CreateResolver<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateResolverError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateResolverInputOperationOutputAlias,
                crate::output::CreateResolverOutput,
                crate::error::CreateResolverError,
                crate::input::CreateResolverInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The ID for the GraphQL API for which the resolver is being created.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the <code>Type</code>.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the <code>Type</code>.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The name of the field to attach the resolver to.</p>
        pub fn field_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(inp);
            self
        }
        /// <p>The name of the field to attach the resolver to.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
        /// <p>The name of the data source for which the resolver is being created.</p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>The name of the data source for which the resolver is being created.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The mapping template to be used for requests.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format
        /// that a data source can understand. Mapping templates are written in Apache Velocity
        /// Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using a Lambda data source. For all
        /// other data sources, VTL request and response mapping templates are required.</p>
        pub fn request_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(inp);
            self
        }
        /// <p>The mapping template to be used for requests.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format
        /// that a data source can understand. Mapping templates are written in Apache Velocity
        /// Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using a Lambda data source. For all
        /// other data sources, VTL request and response mapping templates are required.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The mapping template to be used for responses from the data source.</p>
        pub fn response_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(inp);
            self
        }
        /// <p>The mapping template to be used for responses from the data source.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
        /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
        /// against a single data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
        /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
        /// You can use a pipeline resolver to execute a GraphQL query against multiple data
        /// sources.</p>
        /// </li>
        /// </ul>
        pub fn kind(mut self, inp: crate::model::ResolverKind) -> Self {
            self.inner = self.inner.kind(inp);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
        /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
        /// against a single data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
        /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
        /// You can use a pipeline resolver to execute a GraphQL query against multiple data
        /// sources.</p>
        /// </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::ResolverKind>) -> Self {
            self.inner = self.inner.set_kind(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn pipeline_config(mut self, inp: crate::model::PipelineConfig) -> Self {
            self.inner = self.inner.pipeline_config(inp);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn set_pipeline_config(
            mut self,
            input: std::option::Option<crate::model::PipelineConfig>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_config(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
        pub fn sync_config(mut self, inp: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(inp);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn caching_config(mut self, inp: crate::model::CachingConfig) -> Self {
            self.inner = self.inner.caching_config(inp);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn set_caching_config(
            mut self,
            input: std::option::Option<crate::model::CachingConfig>,
        ) -> Self {
            self.inner = self.inner.set_caching_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateType`.
    ///
    /// <p>Creates a <code>Type</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_type_input::Builder,
    }
    impl<C, M, R> CreateType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTypeInputOperationOutputAlias,
                crate::output::CreateTypeOutput,
                crate::error::CreateTypeError,
                crate::input::CreateTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
        /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL
        /// documentation</a>.</p>
        pub fn definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(inp);
            self
        }
        /// <p>The type definition, in GraphQL Schema Definition Language (SDL) format.</p>
        /// <p>For more information, see the <a href="http://graphql.org/learn/schema/">GraphQL SDL
        /// documentation</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, inp: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiCache`.
    ///
    /// <p>Deletes an <code>ApiCache</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApiCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_api_cache_input::Builder,
    }
    impl<C, M, R> DeleteApiCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApiCacheInputOperationOutputAlias,
                crate::output::DeleteApiCacheOutput,
                crate::error::DeleteApiCacheError,
                crate::input::DeleteApiCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiKey`.
    ///
    /// <p>Deletes an API key.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_api_key_input::Builder,
    }
    impl<C, M, R> DeleteApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApiKeyInputOperationOutputAlias,
                crate::output::DeleteApiKeyOutput,
                crate::error::DeleteApiKeyError,
                crate::input::DeleteApiKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The ID for the API key.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID for the API key.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSource`.
    ///
    /// <p>Deletes a <code>DataSource</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_source_input::Builder,
    }
    impl<C, M, R> DeleteDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSourceInputOperationOutputAlias,
                crate::output::DeleteDataSourceOutput,
                crate::error::DeleteDataSourceError,
                crate::input::DeleteDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the data source.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFunction`.
    ///
    /// <p>Deletes a <code>Function</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_function_input::Builder,
    }
    impl<C, M, R> DeleteFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFunctionInputOperationOutputAlias,
                crate::output::DeleteFunctionOutput,
                crate::error::DeleteFunctionError,
                crate::input::DeleteFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn function_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(inp);
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGraphqlApi`.
    ///
    /// <p>Deletes a <code>GraphqlApi</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGraphqlApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_graphql_api_input::Builder,
    }
    impl<C, M, R> DeleteGraphqlApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGraphqlApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGraphqlApiInputOperationOutputAlias,
                crate::output::DeleteGraphqlApiOutput,
                crate::error::DeleteGraphqlApiError,
                crate::input::DeleteGraphqlApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResolver`.
    ///
    /// <p>Deletes a <code>Resolver</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResolver<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resolver_input::Builder,
    }
    impl<C, M, R> DeleteResolver<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResolverError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResolverInputOperationOutputAlias,
                crate::output::DeleteResolverOutput,
                crate::error::DeleteResolverError,
                crate::input::DeleteResolverInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the resolver type.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The name of the resolver type.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The resolver field name.</p>
        pub fn field_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(inp);
            self
        }
        /// <p>The resolver field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteType`.
    ///
    /// <p>Deletes a <code>Type</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_type_input::Builder,
    }
    impl<C, M, R> DeleteType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTypeInputOperationOutputAlias,
                crate::output::DeleteTypeOutput,
                crate::error::DeleteTypeError,
                crate::input::DeleteTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FlushApiCache`.
    ///
    /// <p>Flushes an <code>ApiCache</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct FlushApiCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::flush_api_cache_input::Builder,
    }
    impl<C, M, R> FlushApiCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `FlushApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FlushApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::FlushApiCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::FlushApiCacheInputOperationOutputAlias,
                crate::output::FlushApiCacheOutput,
                crate::error::FlushApiCacheError,
                crate::input::FlushApiCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApiCache`.
    ///
    /// <p>Retrieves an <code>ApiCache</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApiCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_api_cache_input::Builder,
    }
    impl<C, M, R> GetApiCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApiCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApiCacheInputOperationOutputAlias,
                crate::output::GetApiCacheOutput,
                crate::error::GetApiCacheError,
                crate::input::GetApiCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataSource`.
    ///
    /// <p>Retrieves a <code>DataSource</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_data_source_input::Builder,
    }
    impl<C, M, R> GetDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataSourceInputOperationOutputAlias,
                crate::output::GetDataSourceOutput,
                crate::error::GetDataSourceError,
                crate::input::GetDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The name of the data source.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFunction`.
    ///
    /// <p>Get a <code>Function</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_function_input::Builder,
    }
    impl<C, M, R> GetFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFunctionInputOperationOutputAlias,
                crate::output::GetFunctionOutput,
                crate::error::GetFunctionError,
                crate::input::GetFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn function_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(inp);
            self
        }
        /// <p>The <code>Function</code> ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGraphqlApi`.
    ///
    /// <p>Retrieves a <code>GraphqlApi</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGraphqlApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_graphql_api_input::Builder,
    }
    impl<C, M, R> GetGraphqlApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGraphqlApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGraphqlApiInputOperationOutputAlias,
                crate::output::GetGraphqlApiOutput,
                crate::error::GetGraphqlApiError,
                crate::input::GetGraphqlApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID for the GraphQL API.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID for the GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntrospectionSchema`.
    ///
    /// <p>Retrieves the introspection schema for a GraphQL API.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIntrospectionSchema<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_introspection_schema_input::Builder,
    }
    impl<C, M, R> GetIntrospectionSchema<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntrospectionSchema`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntrospectionSchemaOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntrospectionSchemaError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntrospectionSchemaInputOperationOutputAlias,
                crate::output::GetIntrospectionSchemaOutput,
                crate::error::GetIntrospectionSchemaError,
                crate::input::GetIntrospectionSchemaInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The schema format: SDL or JSON.</p>
        pub fn format(mut self, inp: crate::model::OutputType) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The schema format: SDL or JSON.</p>
        pub fn set_format(mut self, input: std::option::Option<crate::model::OutputType>) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
        pub fn include_directives(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_directives(inp);
            self
        }
        /// <p>A flag that specifies whether the schema introspection should contain directives.</p>
        pub fn set_include_directives(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_directives(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResolver`.
    ///
    /// <p>Retrieves a <code>Resolver</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetResolver<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resolver_input::Builder,
    }
    impl<C, M, R> GetResolver<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResolverError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResolverInputOperationOutputAlias,
                crate::output::GetResolverOutput,
                crate::error::GetResolverError,
                crate::input::GetResolverInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The resolver type name.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The resolver type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The resolver field name.</p>
        pub fn field_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(inp);
            self
        }
        /// <p>The resolver field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSchemaCreationStatus`.
    ///
    /// <p>Retrieves the current status of a schema creation operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSchemaCreationStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_schema_creation_status_input::Builder,
    }
    impl<C, M, R> GetSchemaCreationStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSchemaCreationStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSchemaCreationStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSchemaCreationStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSchemaCreationStatusInputOperationOutputAlias,
                crate::output::GetSchemaCreationStatusOutput,
                crate::error::GetSchemaCreationStatusError,
                crate::input::GetSchemaCreationStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetType`.
    ///
    /// <p>Retrieves a <code>Type</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_type_input::Builder,
    }
    impl<C, M, R> GetType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTypeInputOperationOutputAlias,
                crate::output::GetTypeOutput,
                crate::error::GetTypeError,
                crate::input::GetTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, inp: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApiKeys`.
    ///
    /// <p>Lists the API keys for a given API.</p>
    /// <note>
    /// <p>API keys are deleted automatically 60 days after they expire. However, they may still
    /// be included in the response until they have actually been deleted. You can safely call
    /// <code>DeleteApiKey</code> to manually delete a key before it's automatically
    /// deleted.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ListApiKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_api_keys_input::Builder,
    }
    impl<C, M, R> ListApiKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApiKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApiKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApiKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApiKeysInputOperationOutputAlias,
                crate::output::ListApiKeysOutput,
                crate::error::ListApiKeysError,
                crate::input::ListApiKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDataSources`.
    ///
    /// <p>Lists the data sources for a given API.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDataSources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_data_sources_input::Builder,
    }
    impl<C, M, R> ListDataSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDataSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDataSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDataSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDataSourcesInputOperationOutputAlias,
                crate::output::ListDataSourcesOutput,
                crate::error::ListDataSourcesError,
                crate::input::ListDataSourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFunctions`.
    ///
    /// <p>List multiple functions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFunctions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_functions_input::Builder,
    }
    impl<C, M, R> ListFunctions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFunctionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFunctionsInputOperationOutputAlias,
                crate::output::ListFunctionsOutput,
                crate::error::ListFunctionsError,
                crate::input::ListFunctionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGraphqlApis`.
    ///
    /// <p>Lists your GraphQL APIs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGraphqlApis<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_graphql_apis_input::Builder,
    }
    impl<C, M, R> ListGraphqlApis<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGraphqlApis`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGraphqlApisOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGraphqlApisError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGraphqlApisInputOperationOutputAlias,
                crate::output::ListGraphqlApisOutput,
                crate::error::ListGraphqlApisError,
                crate::input::ListGraphqlApisInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolvers`.
    ///
    /// <p>Lists the resolvers for a given API and type.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolvers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolvers_input::Builder,
    }
    impl<C, M, R> ListResolvers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolvers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolversOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolversError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolversInputOperationOutputAlias,
                crate::output::ListResolversOutput,
                crate::error::ListResolversError,
                crate::input::ListResolversInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type name.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResolversByFunction`.
    ///
    /// <p>List the resolvers that are associated with a specific function.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResolversByFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resolvers_by_function_input::Builder,
    }
    impl<C, M, R> ListResolversByFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResolversByFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResolversByFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResolversByFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResolversByFunctionInputOperationOutputAlias,
                crate::output::ListResolversByFunctionOutput,
                crate::error::ListResolversByFunctionError,
                crate::input::ListResolversByFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The Function ID.</p>
        pub fn function_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(inp);
            self
        }
        /// <p>The Function ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can
        /// use to return the next set of items in the list.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which you can
        /// use to return the next set of items in the list.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GraphqlApi</code> ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The <code>GraphqlApi</code> ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTypes`.
    ///
    /// <p>Lists the types for a given API.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_types_input::Builder,
    }
    impl<C, M, R> ListTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTypesInputOperationOutputAlias,
                crate::output::ListTypesOutput,
                crate::error::ListTypesError,
                crate::input::ListTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn format(mut self, inp: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An identifier that was returned from the previous call to this operation, which can be
        /// used to return the next set of items in the list. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results you want the request to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartSchemaCreation`.
    ///
    /// <p>Adds a new schema to your GraphQL API.</p>
    /// <p>This operation is asynchronous. Use  to
    /// determine when it has completed.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartSchemaCreation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_schema_creation_input::Builder,
    }
    impl<C, M, R> StartSchemaCreation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartSchemaCreation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartSchemaCreationOutput,
            aws_smithy_http::result::SdkError<crate::error::StartSchemaCreationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartSchemaCreationInputOperationOutputAlias,
                crate::output::StartSchemaCreationOutput,
                crate::error::StartSchemaCreationError,
                crate::input::StartSchemaCreationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The schema definition, in GraphQL schema language format.</p>
        pub fn definition(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.definition(inp);
            self
        }
        /// <p>The schema definition, in GraphQL schema language format.</p>
        pub fn set_definition(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Tags a resource with user-supplied tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GraphqlApi</code> ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The <code>GraphqlApi</code> ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A <code>TagMap</code> object.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A <code>TagMap</code> object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Untags a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The <code>GraphqlApi</code> ARN.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The <code>GraphqlApi</code> ARN.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of <code>TagKey</code> objects.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of <code>TagKey</code> objects.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiCache`.
    ///
    /// <p>Updates the cache for the GraphQL API.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApiCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_api_cache_input::Builder,
    }
    impl<C, M, R> UpdateApiCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApiCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApiCacheInputOperationOutputAlias,
                crate::output::UpdateApiCacheOutput,
                crate::error::UpdateApiCacheError,
                crate::input::UpdateApiCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API Id.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The GraphQL API Id.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn ttl(mut self, inp: i64) -> Self {
            self.inner = self.inner.ttl(inp);
            self
        }
        /// <p>TTL in seconds for cache entries.</p>
        /// <p>Valid values are between 1 and 3600 seconds.</p>
        pub fn set_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_ttl(input);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
        /// cached.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
        /// that you specify are cached.</p>
        /// </li>
        /// </ul>
        pub fn api_caching_behavior(mut self, inp: crate::model::ApiCachingBehavior) -> Self {
            self.inner = self.inner.api_caching_behavior(inp);
            self
        }
        /// <p>Caching behavior.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>FULL_REQUEST_CACHING</b>: All requests are fully
        /// cached.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PER_RESOLVER_CACHING</b>: Individual resolvers
        /// that you specify are cached.</p>
        /// </li>
        /// </ul>
        pub fn set_api_caching_behavior(
            mut self,
            input: std::option::Option<crate::model::ApiCachingBehavior>,
        ) -> Self {
            self.inner = self.inner.set_api_caching_behavior(input);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MEDIUM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>XLARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_2X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_4X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_8X</code> (not available in all regions)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_12X</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>T2_SMALL</b>: A t2.small instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_LARGE</b>: A r4.large instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: crate::model::ApiCacheType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The cache instance type. Valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SMALL</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MEDIUM</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>XLARGE</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_2X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_4X</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_8X</code> (not available in all regions)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LARGE_12X</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.</p>
        /// <p>The following legacy instance types are available, but their use is discouraged:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>T2_SMALL</b>: A t2.small instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>T2_MEDIUM</b>: A t2.medium instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_LARGE</b>: A r4.large instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_XLARGE</b>: A r4.xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_2XLARGE</b>: A r4.2xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_4XLARGE</b>: A r4.4xlarge instance type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>R4_8XLARGE</b>: A r4.8xlarge instance type.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ApiCacheType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiKey`.
    ///
    /// <p>Updates an API key. The key can be updated while it is not deleted.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApiKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_api_key_input::Builder,
    }
    impl<C, M, R> UpdateApiKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApiKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApiKeyInputOperationOutputAlias,
                crate::output::UpdateApiKeyOutput,
                crate::error::UpdateApiKeyError,
                crate::input::UpdateApiKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID for the GraphQL API.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The ID for the GraphQL API.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The API key ID.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The API key ID.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the purpose of the API key.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The time from update time after which the API key expires. The date is represented as
        /// seconds since the epoch. For more information, see .</p>
        pub fn expires(mut self, inp: i64) -> Self {
            self.inner = self.inner.expires(inp);
            self
        }
        /// <p>The time from update time after which the API key expires. The date is represented as
        /// seconds since the epoch. For more information, see .</p>
        pub fn set_expires(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_expires(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSource`.
    ///
    /// <p>Updates a <code>DataSource</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_source_input::Builder,
    }
    impl<C, M, R> UpdateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSourceInputOperationOutputAlias,
                crate::output::UpdateDataSourceOutput,
                crate::error::UpdateDataSourceError,
                crate::input::UpdateDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new name for the data source.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name for the data source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The new description for the data source.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The new data source type.</p>
        pub fn r#type(mut self, inp: crate::model::DataSourceType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The new data source type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::DataSourceType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The new service role ARN for the data source.</p>
        pub fn service_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_arn(inp);
            self
        }
        /// <p>The new service role ARN for the data source.</p>
        pub fn set_service_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_arn(input);
            self
        }
        /// <p>The new Amazon DynamoDB configuration.</p>
        pub fn dynamodb_config(mut self, inp: crate::model::DynamodbDataSourceConfig) -> Self {
            self.inner = self.inner.dynamodb_config(inp);
            self
        }
        /// <p>The new Amazon DynamoDB configuration.</p>
        pub fn set_dynamodb_config(
            mut self,
            input: std::option::Option<crate::model::DynamodbDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_dynamodb_config(input);
            self
        }
        /// <p>The new Amazon Web Services Lambda configuration.</p>
        pub fn lambda_config(mut self, inp: crate::model::LambdaDataSourceConfig) -> Self {
            self.inner = self.inner.lambda_config(inp);
            self
        }
        /// <p>The new Amazon Web Services Lambda configuration.</p>
        pub fn set_lambda_config(
            mut self,
            input: std::option::Option<crate::model::LambdaDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_config(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This
        /// configuration is deprecated. Instead, use <a>UpdateDataSourceRequest$openSearchServiceConfig</a> to update an OpenSearch data source.</p>
        pub fn elasticsearch_config(
            mut self,
            inp: crate::model::ElasticsearchDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.elasticsearch_config(inp);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        /// <p>As of September 2021, Amazon Elasticsearch service is Amazon OpenSearch Service. This
        /// configuration is deprecated. Instead, use <a>UpdateDataSourceRequest$openSearchServiceConfig</a> to update an OpenSearch data source.</p>
        pub fn set_elasticsearch_config(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_config(input);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        pub fn open_search_service_config(
            mut self,
            inp: crate::model::OpenSearchServiceDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.open_search_service_config(inp);
            self
        }
        /// <p>The new OpenSearch configuration.</p>
        pub fn set_open_search_service_config(
            mut self,
            input: std::option::Option<crate::model::OpenSearchServiceDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_search_service_config(input);
            self
        }
        /// <p>The new HTTP endpoint configuration.</p>
        pub fn http_config(mut self, inp: crate::model::HttpDataSourceConfig) -> Self {
            self.inner = self.inner.http_config(inp);
            self
        }
        /// <p>The new HTTP endpoint configuration.</p>
        pub fn set_http_config(
            mut self,
            input: std::option::Option<crate::model::HttpDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_http_config(input);
            self
        }
        /// <p>The new relational database configuration.</p>
        pub fn relational_database_config(
            mut self,
            inp: crate::model::RelationalDatabaseDataSourceConfig,
        ) -> Self {
            self.inner = self.inner.relational_database_config(inp);
            self
        }
        /// <p>The new relational database configuration.</p>
        pub fn set_relational_database_config(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseDataSourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFunction`.
    ///
    /// <p>Updates a <code>Function</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_function_input::Builder,
    }
    impl<C, M, R> UpdateFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFunctionInputOperationOutputAlias,
                crate::output::UpdateFunctionOutput,
                crate::error::UpdateFunctionError,
                crate::input::UpdateFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The GraphQL API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The GraphQL API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The <code>Function</code> name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The <code>Function</code> name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The <code>Function</code> description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The function ID.</p>
        pub fn function_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_id(inp);
            self
        }
        /// <p>The function ID.</p>
        pub fn set_function_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_id(input);
            self
        }
        /// <p>The <code>Function</code>
        /// <code>DataSource</code> name.</p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>The <code>Function</code>
        /// <code>DataSource</code> name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the
        /// 2018-05-29 version of the request mapping template.</p>
        pub fn request_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(inp);
            self
        }
        /// <p>The <code>Function</code> request mapping template. Functions support only the
        /// 2018-05-29 version of the request mapping template.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The <code>Function</code> request mapping template. </p>
        pub fn response_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(inp);
            self
        }
        /// <p>The <code>Function</code> request mapping template. </p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently the supported value
        /// is 2018-05-29. </p>
        pub fn function_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_version(inp);
            self
        }
        /// <p>The <code>version</code> of the request mapping template. Currently the supported value
        /// is 2018-05-29. </p>
        pub fn set_function_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_function_version(input);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
        /// be performed when the resolver is invoked.</p>
        pub fn sync_config(mut self, inp: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(inp);
            self
        }
        /// <p>Describes a Sync configuration for a resolver.</p>
        /// <p>Contains information on which Conflict Detection as well as Resolution strategy should
        /// be performed when the resolver is invoked.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGraphqlApi`.
    ///
    /// <p>Updates a <code>GraphqlApi</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGraphqlApi<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_graphql_api_input::Builder,
    }
    impl<C, M, R> UpdateGraphqlApi<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGraphqlApi`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGraphqlApiOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGraphqlApiError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGraphqlApiInputOperationOutputAlias,
                crate::output::UpdateGraphqlApiOutput,
                crate::error::UpdateGraphqlApiError,
                crate::input::UpdateGraphqlApiInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new name for the <code>GraphqlApi</code> object.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The new name for the <code>GraphqlApi</code> object.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
        pub fn log_config(mut self, inp: crate::model::LogConfig) -> Self {
            self.inner = self.inner.log_config(inp);
            self
        }
        /// <p>The Amazon CloudWatch Logs configuration for the <code>GraphqlApi</code> object.</p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogConfig>,
        ) -> Self {
            self.inner = self.inner.set_log_config(input);
            self
        }
        /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The new authentication type for the <code>GraphqlApi</code> object.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The new Amazon Cognito user pool configuration for the <code>GraphqlApi</code>
        /// object.</p>
        pub fn user_pool_config(mut self, inp: crate::model::UserPoolConfig) -> Self {
            self.inner = self.inner.user_pool_config(inp);
            self
        }
        /// <p>The new Amazon Cognito user pool configuration for the <code>GraphqlApi</code>
        /// object.</p>
        pub fn set_user_pool_config(
            mut self,
            input: std::option::Option<crate::model::UserPoolConfig>,
        ) -> Self {
            self.inner = self.inner.set_user_pool_config(input);
            self
        }
        /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
        pub fn open_id_connect_config(mut self, inp: crate::model::OpenIdConnectConfig) -> Self {
            self.inner = self.inner.open_id_connect_config(inp);
            self
        }
        /// <p>The OpenID Connect configuration for the <code>GraphqlApi</code> object.</p>
        pub fn set_open_id_connect_config(
            mut self,
            input: std::option::Option<crate::model::OpenIdConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_open_id_connect_config(input);
            self
        }
        /// Appends an item to `additionalAuthenticationProviders`.
        ///
        /// To override the contents of this collection use [`set_additional_authentication_providers`](Self::set_additional_authentication_providers).
        ///
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
        /// API.</p>
        pub fn additional_authentication_providers(
            mut self,
            inp: impl Into<crate::model::AdditionalAuthenticationProvider>,
        ) -> Self {
            self.inner = self.inner.additional_authentication_providers(inp);
            self
        }
        /// <p>A list of additional authentication providers for the <code>GraphqlApi</code>
        /// API.</p>
        pub fn set_additional_authentication_providers(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AdditionalAuthenticationProvider>,
            >,
        ) -> Self {
            self.inner = self.inner.set_additional_authentication_providers(input);
            self
        }
        /// <p>A flag indicating whether to enable X-Ray tracing for the
        /// <code>GraphqlApi</code>.</p>
        pub fn xray_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.xray_enabled(inp);
            self
        }
        /// <p>A flag indicating whether to enable X-Ray tracing for the
        /// <code>GraphqlApi</code>.</p>
        pub fn set_xray_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_xray_enabled(input);
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn lambda_authorizer_config(
            mut self,
            inp: crate::model::LambdaAuthorizerConfig,
        ) -> Self {
            self.inner = self.inner.lambda_authorizer_config(inp);
            self
        }
        /// <p>Configuration for Amazon Web Services Lambda function authorization.</p>
        pub fn set_lambda_authorizer_config(
            mut self,
            input: std::option::Option<crate::model::LambdaAuthorizerConfig>,
        ) -> Self {
            self.inner = self.inner.set_lambda_authorizer_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateResolver`.
    ///
    /// <p>Updates a <code>Resolver</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateResolver<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_resolver_input::Builder,
    }
    impl<C, M, R> UpdateResolver<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateResolver`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateResolverOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateResolverError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateResolverInputOperationOutputAlias,
                crate::output::UpdateResolverOutput,
                crate::error::UpdateResolverError,
                crate::input::UpdateResolverInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new type name.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The new type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The new field name.</p>
        pub fn field_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.field_name(inp);
            self
        }
        /// <p>The new field name.</p>
        pub fn set_field_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_field_name(input);
            self
        }
        /// <p>The new data source name.</p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>The new data source name.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The new request mapping template.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format
        /// that a data source can understand. Mapping templates are written in Apache Velocity
        /// Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using a Lambda data source. For all
        /// other data sources, VTL request and response mapping templates are required.</p>
        pub fn request_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.request_mapping_template(inp);
            self
        }
        /// <p>The new request mapping template.</p>
        /// <p>A resolver uses a request mapping template to convert a GraphQL expression into a format
        /// that a data source can understand. Mapping templates are written in Apache Velocity
        /// Template Language (VTL).</p>
        /// <p>VTL request mapping templates are optional when using a Lambda data source. For all
        /// other data sources, VTL request and response mapping templates are required.</p>
        pub fn set_request_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_request_mapping_template(input);
            self
        }
        /// <p>The new response mapping template.</p>
        pub fn response_mapping_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.response_mapping_template(inp);
            self
        }
        /// <p>The new response mapping template.</p>
        pub fn set_response_mapping_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_response_mapping_template(input);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
        /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
        /// against a single data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
        /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
        /// You can use a pipeline resolver to execute a GraphQL query against multiple data
        /// sources.</p>
        /// </li>
        /// </ul>
        pub fn kind(mut self, inp: crate::model::ResolverKind) -> Self {
            self.inner = self.inner.kind(inp);
            self
        }
        /// <p>The resolver type.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is
        /// the default resolver type. A UNIT resolver enables you to execute a GraphQL query
        /// against a single data source.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>PIPELINE</b>: A PIPELINE resolver type. A PIPELINE
        /// resolver enables you to execute a series of <code>Function</code> in a serial manner.
        /// You can use a pipeline resolver to execute a GraphQL query against multiple data
        /// sources.</p>
        /// </li>
        /// </ul>
        pub fn set_kind(mut self, input: std::option::Option<crate::model::ResolverKind>) -> Self {
            self.inner = self.inner.set_kind(input);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn pipeline_config(mut self, inp: crate::model::PipelineConfig) -> Self {
            self.inner = self.inner.pipeline_config(inp);
            self
        }
        /// <p>The <code>PipelineConfig</code>.</p>
        pub fn set_pipeline_config(
            mut self,
            input: std::option::Option<crate::model::PipelineConfig>,
        ) -> Self {
            self.inner = self.inner.set_pipeline_config(input);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
        pub fn sync_config(mut self, inp: crate::model::SyncConfig) -> Self {
            self.inner = self.inner.sync_config(inp);
            self
        }
        /// <p>The <code>SyncConfig</code> for a resolver attached to a versioned datasource.</p>
        pub fn set_sync_config(
            mut self,
            input: std::option::Option<crate::model::SyncConfig>,
        ) -> Self {
            self.inner = self.inner.set_sync_config(input);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn caching_config(mut self, inp: crate::model::CachingConfig) -> Self {
            self.inner = self.inner.caching_config(inp);
            self
        }
        /// <p>The caching configuration for the resolver.</p>
        pub fn set_caching_config(
            mut self,
            input: std::option::Option<crate::model::CachingConfig>,
        ) -> Self {
            self.inner = self.inner.set_caching_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateType`.
    ///
    /// <p>Updates a <code>Type</code> object.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_type_input::Builder,
    }
    impl<C, M, R> UpdateType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTypeInputOperationOutputAlias,
                crate::output::UpdateTypeOutput,
                crate::error::UpdateTypeError,
                crate::input::UpdateTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The API ID.</p>
        pub fn api_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.api_id(inp);
            self
        }
        /// <p>The API ID.</p>
        pub fn set_api_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_api_id(input);
            self
        }
        /// <p>The new type name.</p>
        pub fn type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.type_name(inp);
            self
        }
        /// <p>The new type name.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_type_name(input);
            self
        }
        /// <p>The new definition.</p>
        pub fn definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.definition(inp);
            self
        }
        /// <p>The new definition.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_definition(input);
            self
        }
        /// <p>The new type format: SDL or JSON.</p>
        pub fn format(mut self, inp: crate::model::TypeDefinitionFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>The new type format: SDL or JSON.</p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::TypeDefinitionFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
