// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApiCacheError {
    /// Kind of error that occurred.
    pub kind: CreateApiCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApiCacheErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApiCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApiCacheErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApiCacheErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateApiCacheErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateApiCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateApiCacheErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateApiCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApiCacheError {
    fn code(&self) -> Option<&str> {
        CreateApiCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApiCacheError {
    /// Creates a new `CreateApiCacheError`.
    pub fn new(kind: CreateApiCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApiCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApiCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApiCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApiCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateApiCacheErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateApiCacheErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateApiCacheErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiCacheErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateApiCacheErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiCacheErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateApiCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateApiCacheErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateApiCacheErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiCacheErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateApiCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApiCacheErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApiCacheErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateApiCacheErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateApiCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateApiCacheErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateApiCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApiKeyError {
    /// Kind of error that occurred.
    pub kind: CreateApiKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApiKeyErrorKind {
    /// <p>The API key exceeded a limit. Try your request again.</p>
    ApiKeyLimitExceededException(crate::error::ApiKeyLimitExceededException),
    /// <p>The API key expiration must be set to a value between 1 and 365 days from creation (for
    /// <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</p>
    ApiKeyValidityOutOfBoundsException(crate::error::ApiKeyValidityOutOfBoundsException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApiKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApiKeyErrorKind::ApiKeyLimitExceededException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateApiKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApiKeyError {
    fn code(&self) -> Option<&str> {
        CreateApiKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApiKeyError {
    /// Creates a new `CreateApiKeyError`.
    pub fn new(kind: CreateApiKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApiKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApiKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApiKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApiKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::ApiKeyLimitExceededException`.
    pub fn is_api_key_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiKeyErrorKind::ApiKeyLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException`.
    pub fn is_api_key_validity_out_of_bounds_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException(_)
        )
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiKeyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateApiKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateApiKeyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateApiKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApiKeyErrorKind::ApiKeyLimitExceededException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateApiKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSourceError {
    /// Kind of error that occurred.
    pub kind: CreateDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSourceErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSourceError {
    fn code(&self) -> Option<&str> {
        CreateDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSourceError {
    /// Creates a new `CreateDataSourceError`.
    pub fn new(kind: CreateDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDataSourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateDataSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateDataSourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDataSourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateDataSourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSourceErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFunctionError {
    /// Kind of error that occurred.
    pub kind: CreateFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFunctionErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFunctionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFunctionError {
    fn code(&self) -> Option<&str> {
        CreateFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFunctionError {
    /// Creates a new `CreateFunctionError`.
    pub fn new(kind: CreateFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFunctionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateFunctionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateFunctionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateFunctionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateFunctionErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateFunctionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFunctionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFunctionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateFunctionErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateFunctionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateFunctionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGraphqlApiError {
    /// Kind of error that occurred.
    pub kind: CreateGraphqlApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGraphqlApiErrorKind {
    /// <p>The GraphQL API exceeded a limit. Try your request again.</p>
    ApiLimitExceededException(crate::error::ApiLimitExceededException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGraphqlApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGraphqlApiErrorKind::ApiLimitExceededException(_inner) => _inner.fmt(f),
            CreateGraphqlApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateGraphqlApiErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateGraphqlApiErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateGraphqlApiErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGraphqlApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateGraphqlApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGraphqlApiError {
    fn code(&self) -> Option<&str> {
        CreateGraphqlApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGraphqlApiError {
    /// Creates a new `CreateGraphqlApiError`.
    pub fn new(kind: CreateGraphqlApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGraphqlApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGraphqlApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGraphqlApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGraphqlApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateGraphqlApiErrorKind::ApiLimitExceededException`.
    pub fn is_api_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGraphqlApiErrorKind::ApiLimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateGraphqlApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGraphqlApiErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateGraphqlApiErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGraphqlApiErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateGraphqlApiErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGraphqlApiErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateGraphqlApiErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGraphqlApiErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateGraphqlApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGraphqlApiErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateGraphqlApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGraphqlApiErrorKind::ApiLimitExceededException(_inner) => Some(_inner),
            CreateGraphqlApiErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateGraphqlApiErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateGraphqlApiErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateGraphqlApiErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGraphqlApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateGraphqlApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateResolverError {
    /// Kind of error that occurred.
    pub kind: CreateResolverErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateResolverErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateResolverError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateResolverErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateResolverErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateResolverErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateResolverErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateResolverErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateResolverError {
    fn code(&self) -> Option<&str> {
        CreateResolverError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateResolverError {
    /// Creates a new `CreateResolverError`.
    pub fn new(kind: CreateResolverErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateResolverError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateResolverErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateResolverError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateResolverErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateResolverErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResolverErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateResolverErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResolverErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `CreateResolverErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateResolverErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateResolverErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateResolverErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for CreateResolverError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateResolverErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateResolverErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateResolverErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateResolverErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateResolverErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTypeError {
    /// Kind of error that occurred.
    pub kind: CreateTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTypeErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateTypeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            CreateTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            CreateTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTypeError {
    fn code(&self) -> Option<&str> {
        CreateTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTypeError {
    /// Creates a new `CreateTypeError`.
    pub fn new(kind: CreateTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateTypeErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `CreateTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, CreateTypeErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `CreateTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateTypeErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `CreateTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, CreateTypeErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for CreateTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateTypeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            CreateTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            CreateTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApiCacheError {
    /// Kind of error that occurred.
    pub kind: DeleteApiCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApiCacheErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApiCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApiCacheErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApiCacheErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteApiCacheErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteApiCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApiCacheErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteApiCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApiCacheError {
    fn code(&self) -> Option<&str> {
        DeleteApiCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApiCacheError {
    /// Creates a new `DeleteApiCacheError`.
    pub fn new(kind: DeleteApiCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApiCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApiCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApiCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApiCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteApiCacheErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiCacheErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteApiCacheErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiCacheErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApiCacheErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiCacheErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApiCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiCacheErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteApiCacheErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiCacheErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteApiCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApiCacheErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApiCacheErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteApiCacheErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteApiCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApiCacheErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteApiCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApiKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteApiKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApiKeyErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApiKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApiKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteApiKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApiKeyError {
    fn code(&self) -> Option<&str> {
        DeleteApiKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApiKeyError {
    /// Creates a new `DeleteApiKeyError`.
    pub fn new(kind: DeleteApiKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApiKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApiKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApiKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApiKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiKeyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteApiKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteApiKeyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteApiKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApiKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteApiKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataSourceError {
    /// Kind of error that occurred.
    pub kind: DeleteDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataSourceErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataSourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataSourceError {
    fn code(&self) -> Option<&str> {
        DeleteDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataSourceError {
    /// Creates a new `DeleteDataSourceError`.
    pub fn new(kind: DeleteDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDataSourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDataSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDataSourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDataSourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteDataSourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataSourceErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFunctionError {
    /// Kind of error that occurred.
    pub kind: DeleteFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFunctionErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFunctionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFunctionError {
    fn code(&self) -> Option<&str> {
        DeleteFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFunctionError {
    /// Creates a new `DeleteFunctionError`.
    pub fn new(kind: DeleteFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFunctionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteFunctionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFunctionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteFunctionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteFunctionErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteFunctionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFunctionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFunctionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGraphqlApiError {
    /// Kind of error that occurred.
    pub kind: DeleteGraphqlApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGraphqlApiErrorKind {
    /// <p>You do not have access to perform this operation on this resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGraphqlApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGraphqlApiErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteGraphqlApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteGraphqlApiErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteGraphqlApiErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteGraphqlApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteGraphqlApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteGraphqlApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGraphqlApiError {
    fn code(&self) -> Option<&str> {
        DeleteGraphqlApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGraphqlApiError {
    /// Creates a new `DeleteGraphqlApiError`.
    pub fn new(kind: DeleteGraphqlApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGraphqlApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGraphqlApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGraphqlApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGraphqlApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteGraphqlApiErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGraphqlApiErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGraphqlApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGraphqlApiErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGraphqlApiErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGraphqlApiErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGraphqlApiErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGraphqlApiErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteGraphqlApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteGraphqlApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteGraphqlApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGraphqlApiErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteGraphqlApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGraphqlApiErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteGraphqlApiErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteGraphqlApiErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteGraphqlApiErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteGraphqlApiErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteGraphqlApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteGraphqlApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResolverError {
    /// Kind of error that occurred.
    pub kind: DeleteResolverErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResolverErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResolverError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResolverErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteResolverErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteResolverErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteResolverErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteResolverErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResolverError {
    fn code(&self) -> Option<&str> {
        DeleteResolverError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResolverError {
    /// Creates a new `DeleteResolverError`.
    pub fn new(kind: DeleteResolverErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResolverError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResolverErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResolverError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResolverErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteResolverErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResolverErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResolverErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResolverErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `DeleteResolverErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteResolverErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteResolverErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResolverErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for DeleteResolverError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResolverErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteResolverErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteResolverErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteResolverErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteResolverErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTypeErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteTypeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            DeleteTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            DeleteTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTypeError {
    fn code(&self) -> Option<&str> {
        DeleteTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTypeError {
    /// Creates a new `DeleteTypeError`.
    pub fn new(kind: DeleteTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteTypeErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `DeleteTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, DeleteTypeErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `DeleteTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteTypeErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `DeleteTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, DeleteTypeErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for DeleteTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteTypeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            DeleteTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            DeleteTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FlushApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FlushApiCacheError {
    /// Kind of error that occurred.
    pub kind: FlushApiCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FlushApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FlushApiCacheErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FlushApiCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FlushApiCacheErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            FlushApiCacheErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            FlushApiCacheErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            FlushApiCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            FlushApiCacheErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            FlushApiCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FlushApiCacheError {
    fn code(&self) -> Option<&str> {
        FlushApiCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FlushApiCacheError {
    /// Creates a new `FlushApiCacheError`.
    pub fn new(kind: FlushApiCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FlushApiCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FlushApiCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FlushApiCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FlushApiCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `FlushApiCacheErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, FlushApiCacheErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `FlushApiCacheErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushApiCacheErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `FlushApiCacheErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            FlushApiCacheErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `FlushApiCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, FlushApiCacheErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `FlushApiCacheErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, FlushApiCacheErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for FlushApiCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FlushApiCacheErrorKind::BadRequestException(_inner) => Some(_inner),
            FlushApiCacheErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            FlushApiCacheErrorKind::InternalFailureException(_inner) => Some(_inner),
            FlushApiCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            FlushApiCacheErrorKind::UnauthorizedException(_inner) => Some(_inner),
            FlushApiCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApiCacheError {
    /// Kind of error that occurred.
    pub kind: GetApiCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApiCacheErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApiCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApiCacheErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetApiCacheErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            GetApiCacheErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetApiCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetApiCacheErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetApiCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApiCacheError {
    fn code(&self) -> Option<&str> {
        GetApiCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApiCacheError {
    /// Creates a new `GetApiCacheError`.
    pub fn new(kind: GetApiCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApiCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApiCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApiCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApiCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetApiCacheErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetApiCacheErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetApiCacheErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApiCacheErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `GetApiCacheErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApiCacheErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetApiCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetApiCacheErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetApiCacheErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetApiCacheErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetApiCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApiCacheErrorKind::BadRequestException(_inner) => Some(_inner),
            GetApiCacheErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            GetApiCacheErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetApiCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            GetApiCacheErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetApiCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataSourceError {
    /// Kind of error that occurred.
    pub kind: GetDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataSourceErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataSourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataSourceError {
    fn code(&self) -> Option<&str> {
        GetDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataSourceError {
    /// Creates a new `GetDataSourceError`.
    pub fn new(kind: GetDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDataSourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDataSourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDataSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `GetDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetDataSourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDataSourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetDataSourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetDataSourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataSourceErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDataSourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            GetDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetDataSourceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDataSourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFunctionError {
    /// Kind of error that occurred.
    pub kind: GetFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFunctionErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFunctionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFunctionError {
    fn code(&self) -> Option<&str> {
        GetFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFunctionError {
    /// Creates a new `GetFunctionError`.
    pub fn new(kind: GetFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFunctionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetFunctionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFunctionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `GetFunctionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetFunctionErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetFunctionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetFunctionErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFunctionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            GetFunctionErrorKind::NotFoundException(_inner) => Some(_inner),
            GetFunctionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGraphqlApiError {
    /// Kind of error that occurred.
    pub kind: GetGraphqlApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGraphqlApiErrorKind {
    /// <p>You do not have access to perform this operation on this resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGraphqlApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGraphqlApiErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetGraphqlApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetGraphqlApiErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetGraphqlApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetGraphqlApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetGraphqlApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGraphqlApiError {
    fn code(&self) -> Option<&str> {
        GetGraphqlApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGraphqlApiError {
    /// Creates a new `GetGraphqlApiError`.
    pub fn new(kind: GetGraphqlApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGraphqlApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGraphqlApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGraphqlApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGraphqlApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetGraphqlApiErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetGraphqlApiErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetGraphqlApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetGraphqlApiErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetGraphqlApiErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGraphqlApiErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetGraphqlApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetGraphqlApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetGraphqlApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetGraphqlApiErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetGraphqlApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGraphqlApiErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetGraphqlApiErrorKind::BadRequestException(_inner) => Some(_inner),
            GetGraphqlApiErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetGraphqlApiErrorKind::NotFoundException(_inner) => Some(_inner),
            GetGraphqlApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetGraphqlApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntrospectionSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntrospectionSchemaError {
    /// Kind of error that occurred.
    pub kind: GetIntrospectionSchemaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntrospectionSchema` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntrospectionSchemaErrorKind {
    /// <p>The GraphQL schema is not valid.</p>
    GraphQlSchemaException(crate::error::GraphQlSchemaException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntrospectionSchemaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntrospectionSchemaErrorKind::GraphQlSchemaException(_inner) => _inner.fmt(f),
            GetIntrospectionSchemaErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetIntrospectionSchemaErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetIntrospectionSchemaErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetIntrospectionSchemaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntrospectionSchemaError {
    fn code(&self) -> Option<&str> {
        GetIntrospectionSchemaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntrospectionSchemaError {
    /// Creates a new `GetIntrospectionSchemaError`.
    pub fn new(kind: GetIntrospectionSchemaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntrospectionSchemaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntrospectionSchemaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntrospectionSchemaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntrospectionSchemaErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntrospectionSchemaErrorKind::GraphQlSchemaException`.
    pub fn is_graph_ql_schema_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntrospectionSchemaErrorKind::GraphQlSchemaException(_)
        )
    }
    /// Returns true if the error kind is `GetIntrospectionSchemaErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntrospectionSchemaErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetIntrospectionSchemaErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntrospectionSchemaErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetIntrospectionSchemaErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntrospectionSchemaErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetIntrospectionSchemaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntrospectionSchemaErrorKind::GraphQlSchemaException(_inner) => Some(_inner),
            GetIntrospectionSchemaErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetIntrospectionSchemaErrorKind::NotFoundException(_inner) => Some(_inner),
            GetIntrospectionSchemaErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetIntrospectionSchemaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResolverError {
    /// Kind of error that occurred.
    pub kind: GetResolverErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResolverErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResolverError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResolverErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            GetResolverErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetResolverErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetResolverErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResolverError {
    fn code(&self) -> Option<&str> {
        GetResolverError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResolverError {
    /// Creates a new `GetResolverError`.
    pub fn new(kind: GetResolverErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResolverError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResolverErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResolverError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResolverErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetResolverErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResolverErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `GetResolverErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetResolverErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetResolverErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetResolverErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetResolverError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResolverErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            GetResolverErrorKind::NotFoundException(_inner) => Some(_inner),
            GetResolverErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetResolverErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSchemaCreationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSchemaCreationStatusError {
    /// Kind of error that occurred.
    pub kind: GetSchemaCreationStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSchemaCreationStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSchemaCreationStatusErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSchemaCreationStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSchemaCreationStatusErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetSchemaCreationStatusErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetSchemaCreationStatusErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetSchemaCreationStatusErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetSchemaCreationStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSchemaCreationStatusError {
    fn code(&self) -> Option<&str> {
        GetSchemaCreationStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSchemaCreationStatusError {
    /// Creates a new `GetSchemaCreationStatusError`.
    pub fn new(kind: GetSchemaCreationStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSchemaCreationStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSchemaCreationStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSchemaCreationStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSchemaCreationStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetSchemaCreationStatusErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaCreationStatusErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaCreationStatusErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaCreationStatusErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaCreationStatusErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaCreationStatusErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetSchemaCreationStatusErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSchemaCreationStatusErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for GetSchemaCreationStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSchemaCreationStatusErrorKind::BadRequestException(_inner) => Some(_inner),
            GetSchemaCreationStatusErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetSchemaCreationStatusErrorKind::NotFoundException(_inner) => Some(_inner),
            GetSchemaCreationStatusErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetSchemaCreationStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTypeError {
    /// Kind of error that occurred.
    pub kind: GetTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTypeErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetTypeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            GetTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            GetTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            GetTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTypeError {
    fn code(&self) -> Option<&str> {
        GetTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTypeError {
    /// Creates a new `GetTypeError`.
    pub fn new(kind: GetTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetTypeErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `GetTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, GetTypeErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `GetTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetTypeErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `GetTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, GetTypeErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for GetTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            GetTypeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            GetTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            GetTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            GetTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            GetTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApiKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApiKeysError {
    /// Kind of error that occurred.
    pub kind: ListApiKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApiKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApiKeysErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApiKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApiKeysErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListApiKeysErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListApiKeysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListApiKeysErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListApiKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApiKeysError {
    fn code(&self) -> Option<&str> {
        ListApiKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApiKeysError {
    /// Creates a new `ListApiKeysError`.
    pub fn new(kind: ListApiKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApiKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApiKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApiKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApiKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListApiKeysErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListApiKeysErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListApiKeysErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApiKeysErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListApiKeysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListApiKeysErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListApiKeysErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListApiKeysErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListApiKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApiKeysErrorKind::BadRequestException(_inner) => Some(_inner),
            ListApiKeysErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListApiKeysErrorKind::NotFoundException(_inner) => Some(_inner),
            ListApiKeysErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListApiKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDataSourcesError {
    /// Kind of error that occurred.
    pub kind: ListDataSourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDataSourcesErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDataSourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDataSourcesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListDataSourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDataSourcesError {
    fn code(&self) -> Option<&str> {
        ListDataSourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDataSourcesError {
    /// Creates a new `ListDataSourcesError`.
    pub fn new(kind: ListDataSourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDataSourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDataSourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDataSourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDataSourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDataSourcesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListDataSourcesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListDataSourcesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListDataSourcesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListDataSourcesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListDataSourcesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDataSourcesErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListDataSourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDataSourcesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListDataSourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFunctionsError {
    /// Kind of error that occurred.
    pub kind: ListFunctionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFunctionsErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFunctionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFunctionsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListFunctionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFunctionsError {
    fn code(&self) -> Option<&str> {
        ListFunctionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFunctionsError {
    /// Creates a new `ListFunctionsError`.
    pub fn new(kind: ListFunctionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFunctionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFunctionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFunctionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFunctionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListFunctionsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListFunctionsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListFunctionsErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFunctionsErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListFunctionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListFunctionsErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListFunctionsErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListFunctionsErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListFunctionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFunctionsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListFunctionsErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListFunctionsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListFunctionsErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListFunctionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGraphqlApis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGraphqlApisError {
    /// Kind of error that occurred.
    pub kind: ListGraphqlApisErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGraphqlApis` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGraphqlApisErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGraphqlApisError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGraphqlApisErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListGraphqlApisErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListGraphqlApisErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListGraphqlApisErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGraphqlApisError {
    fn code(&self) -> Option<&str> {
        ListGraphqlApisError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListGraphqlApisError {
    /// Creates a new `ListGraphqlApisError`.
    pub fn new(kind: ListGraphqlApisErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGraphqlApisError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGraphqlApisErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGraphqlApisError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGraphqlApisErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListGraphqlApisErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListGraphqlApisErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListGraphqlApisErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGraphqlApisErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListGraphqlApisErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGraphqlApisErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListGraphqlApisError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGraphqlApisErrorKind::BadRequestException(_inner) => Some(_inner),
            ListGraphqlApisErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListGraphqlApisErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListGraphqlApisErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResolvers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResolversError {
    /// Kind of error that occurred.
    pub kind: ListResolversErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResolvers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResolversErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResolversError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResolversErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListResolversErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListResolversErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListResolversErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListResolversErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResolversError {
    fn code(&self) -> Option<&str> {
        ListResolversError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResolversError {
    /// Creates a new `ListResolversError`.
    pub fn new(kind: ListResolversErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResolversError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResolversErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResolversError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResolversErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListResolversErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListResolversErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListResolversErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResolversErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListResolversErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListResolversErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListResolversErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListResolversErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListResolversError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResolversErrorKind::BadRequestException(_inner) => Some(_inner),
            ListResolversErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListResolversErrorKind::NotFoundException(_inner) => Some(_inner),
            ListResolversErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListResolversErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResolversByFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResolversByFunctionError {
    /// Kind of error that occurred.
    pub kind: ListResolversByFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResolversByFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResolversByFunctionErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResolversByFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResolversByFunctionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListResolversByFunctionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListResolversByFunctionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListResolversByFunctionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListResolversByFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResolversByFunctionError {
    fn code(&self) -> Option<&str> {
        ListResolversByFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResolversByFunctionError {
    /// Creates a new `ListResolversByFunctionError`.
    pub fn new(kind: ListResolversByFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResolversByFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResolversByFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResolversByFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResolversByFunctionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListResolversByFunctionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResolversByFunctionErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListResolversByFunctionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResolversByFunctionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListResolversByFunctionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResolversByFunctionErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListResolversByFunctionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResolversByFunctionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListResolversByFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResolversByFunctionErrorKind::BadRequestException(_inner) => Some(_inner),
            ListResolversByFunctionErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListResolversByFunctionErrorKind::NotFoundException(_inner) => Some(_inner),
            ListResolversByFunctionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListResolversByFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You do not have access to perform this operation on this resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTypesError {
    /// Kind of error that occurred.
    pub kind: ListTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTypesErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTypesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTypesErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            ListTypesErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            ListTypesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTypesErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            ListTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTypesError {
    fn code(&self) -> Option<&str> {
        ListTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTypesError {
    /// Creates a new `ListTypesError`.
    pub fn new(kind: ListTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTypesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListTypesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListTypesErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTypesErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `ListTypesErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, ListTypesErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `ListTypesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListTypesErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `ListTypesErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, ListTypesErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for ListTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTypesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTypesErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            ListTypesErrorKind::InternalFailureException(_inner) => Some(_inner),
            ListTypesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTypesErrorKind::UnauthorizedException(_inner) => Some(_inner),
            ListTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartSchemaCreation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartSchemaCreationError {
    /// Kind of error that occurred.
    pub kind: StartSchemaCreationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartSchemaCreation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartSchemaCreationErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartSchemaCreationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartSchemaCreationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartSchemaCreationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            StartSchemaCreationErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            StartSchemaCreationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartSchemaCreationErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            StartSchemaCreationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartSchemaCreationError {
    fn code(&self) -> Option<&str> {
        StartSchemaCreationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartSchemaCreationError {
    /// Creates a new `StartSchemaCreationError`.
    pub fn new(kind: StartSchemaCreationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartSchemaCreationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartSchemaCreationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartSchemaCreationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartSchemaCreationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartSchemaCreationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaCreationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `StartSchemaCreationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaCreationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `StartSchemaCreationErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaCreationErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `StartSchemaCreationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaCreationErrorKind::NotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StartSchemaCreationErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartSchemaCreationErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for StartSchemaCreationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartSchemaCreationErrorKind::BadRequestException(_inner) => Some(_inner),
            StartSchemaCreationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            StartSchemaCreationErrorKind::InternalFailureException(_inner) => Some(_inner),
            StartSchemaCreationErrorKind::NotFoundException(_inner) => Some(_inner),
            StartSchemaCreationErrorKind::UnauthorizedException(_inner) => Some(_inner),
            StartSchemaCreationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You do not have access to perform this operation on this resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You do not have access to perform this operation on this resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UntagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApiCacheError {
    /// Kind of error that occurred.
    pub kind: UpdateApiCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApiCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApiCacheErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApiCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApiCacheErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApiCacheErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateApiCacheErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateApiCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApiCacheErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateApiCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApiCacheError {
    fn code(&self) -> Option<&str> {
        UpdateApiCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApiCacheError {
    /// Creates a new `UpdateApiCacheError`.
    pub fn new(kind: UpdateApiCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApiCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApiCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApiCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApiCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateApiCacheErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiCacheErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateApiCacheErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiCacheErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateApiCacheErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiCacheErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateApiCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiCacheErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateApiCacheErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiCacheErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateApiCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApiCacheErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApiCacheErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateApiCacheErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateApiCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApiCacheErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateApiCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApiKeyError {
    /// Kind of error that occurred.
    pub kind: UpdateApiKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApiKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApiKeyErrorKind {
    /// <p>The API key expiration must be set to a value between 1 and 365 days from creation (for
    /// <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</p>
    ApiKeyValidityOutOfBoundsException(crate::error::ApiKeyValidityOutOfBoundsException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The request exceeded a limit. Try your request again.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApiKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateApiKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApiKeyError {
    fn code(&self) -> Option<&str> {
        UpdateApiKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApiKeyError {
    /// Creates a new `UpdateApiKeyError`.
    pub fn new(kind: UpdateApiKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApiKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApiKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApiKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApiKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException`.
    pub fn is_api_key_validity_out_of_bounds_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException(_)
        )
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiKeyErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::LimitExceededException(_))
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateApiKeyErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateApiKeyErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateApiKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApiKeyErrorKind::ApiKeyValidityOutOfBoundsException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateApiKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSourceError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSourceErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSourceError {
    fn code(&self) -> Option<&str> {
        UpdateDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSourceError {
    /// Creates a new `UpdateDataSourceError`.
    pub fn new(kind: UpdateDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDataSourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDataSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDataSourceErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDataSourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateDataSourceErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateDataSourceErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFunctionError {
    /// Kind of error that occurred.
    pub kind: UpdateFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFunctionErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFunctionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFunctionError {
    fn code(&self) -> Option<&str> {
        UpdateFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFunctionError {
    /// Creates a new `UpdateFunctionError`.
    pub fn new(kind: UpdateFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFunctionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateFunctionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFunctionErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateFunctionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateFunctionErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateFunctionErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFunctionErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFunctionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateFunctionErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateFunctionErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFunctionErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGraphqlApiError {
    /// Kind of error that occurred.
    pub kind: UpdateGraphqlApiErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGraphqlApi` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGraphqlApiErrorKind {
    /// <p>You do not have access to perform this operation on this resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGraphqlApiError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGraphqlApiErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateGraphqlApiErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateGraphqlApiErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateGraphqlApiErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateGraphqlApiErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGraphqlApiErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateGraphqlApiErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGraphqlApiError {
    fn code(&self) -> Option<&str> {
        UpdateGraphqlApiError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateGraphqlApiError {
    /// Creates a new `UpdateGraphqlApiError`.
    pub fn new(kind: UpdateGraphqlApiErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGraphqlApiError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGraphqlApiErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGraphqlApiError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGraphqlApiErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateGraphqlApiErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGraphqlApiErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGraphqlApiErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGraphqlApiErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGraphqlApiErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGraphqlApiErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGraphqlApiErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGraphqlApiErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateGraphqlApiErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateGraphqlApiErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateGraphqlApiErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGraphqlApiErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateGraphqlApiError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGraphqlApiErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateGraphqlApiErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateGraphqlApiErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateGraphqlApiErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateGraphqlApiErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGraphqlApiErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateGraphqlApiErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateResolverError {
    /// Kind of error that occurred.
    pub kind: UpdateResolverErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateResolver` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateResolverErrorKind {
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateResolverError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateResolverErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateResolverErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateResolverErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateResolverErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateResolverErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateResolverError {
    fn code(&self) -> Option<&str> {
        UpdateResolverError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateResolverError {
    /// Creates a new `UpdateResolverError`.
    pub fn new(kind: UpdateResolverErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateResolverError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateResolverErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateResolverError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateResolverErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateResolverErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResolverErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateResolverErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResolverErrorKind::InternalFailureException(_)
        )
    }
    /// Returns true if the error kind is `UpdateResolverErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateResolverErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateResolverErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateResolverErrorKind::UnauthorizedException(_)
        )
    }
}
impl std::error::Error for UpdateResolverError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateResolverErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateResolverErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateResolverErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateResolverErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateResolverErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateTypeError {
    /// Kind of error that occurred.
    pub kind: UpdateTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateTypeErrorKind {
    /// <p>The request is not well formed. For example, a value is invalid or a required field is
    /// missing. Check the field values, and then try again. </p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>Another modification is in progress at this time and it must complete before you can
    /// make your change. </p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An internal AppSync error occurred. Try your request again.</p>
    InternalFailureException(crate::error::InternalFailureException),
    /// <p>The resource specified in the request was not found. Check the resource, and then try
    /// again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You are not authorized to perform this operation.</p>
    UnauthorizedException(crate::error::UnauthorizedException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateTypeErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateTypeErrorKind::InternalFailureException(_inner) => _inner.fmt(f),
            UpdateTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateTypeErrorKind::UnauthorizedException(_inner) => _inner.fmt(f),
            UpdateTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateTypeError {
    fn code(&self) -> Option<&str> {
        UpdateTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateTypeError {
    /// Creates a new `UpdateTypeError`.
    pub fn new(kind: UpdateTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateTypeErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateTypeErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateTypeErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns true if the error kind is `UpdateTypeErrorKind::InternalFailureException`.
    pub fn is_internal_failure_exception(&self) -> bool {
        matches!(&self.kind, UpdateTypeErrorKind::InternalFailureException(_))
    }
    /// Returns true if the error kind is `UpdateTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateTypeErrorKind::NotFoundException(_))
    }
    /// Returns true if the error kind is `UpdateTypeErrorKind::UnauthorizedException`.
    pub fn is_unauthorized_exception(&self) -> bool {
        matches!(&self.kind, UpdateTypeErrorKind::UnauthorizedException(_))
    }
}
impl std::error::Error for UpdateTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateTypeErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateTypeErrorKind::InternalFailureException(_inner) => Some(_inner),
            UpdateTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateTypeErrorKind::UnauthorizedException(_inner) => Some(_inner),
            UpdateTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>You are not authorized to perform this operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedException {}
/// See [`UnauthorizedException`](crate::error::UnauthorizedException)
pub mod unauthorized_exception {
    /// A builder for [`UnauthorizedException`](crate::error::UnauthorizedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedException`](crate::error::UnauthorizedException)
        pub fn build(self) -> crate::error::UnauthorizedException {
            crate::error::UnauthorizedException {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedException {
    /// Creates a new builder-style object to manufacture [`UnauthorizedException`](crate::error::UnauthorizedException)
    pub fn builder() -> crate::error::unauthorized_exception::Builder {
        crate::error::unauthorized_exception::Builder::default()
    }
}

/// <p>The resource specified in the request was not found. Check the resource, and then try
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>An internal AppSync error occurred. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalFailureException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalFailureException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalFailureException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalFailureException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalFailureException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalFailureException {}
/// See [`InternalFailureException`](crate::error::InternalFailureException)
pub mod internal_failure_exception {
    /// A builder for [`InternalFailureException`](crate::error::InternalFailureException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalFailureException`](crate::error::InternalFailureException)
        pub fn build(self) -> crate::error::InternalFailureException {
            crate::error::InternalFailureException {
                message: self.message,
            }
        }
    }
}
impl InternalFailureException {
    /// Creates a new builder-style object to manufacture [`InternalFailureException`](crate::error::InternalFailureException)
    pub fn builder() -> crate::error::internal_failure_exception::Builder {
        crate::error::internal_failure_exception::Builder::default()
    }
}

/// <p>Another modification is in progress at this time and it must complete before you can
/// make your change. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The request is not well formed. For example, a value is invalid or a required field is
/// missing. Check the field values, and then try again. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>You do not have access to perform this operation on this resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The request exceeded a limit. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The API key expiration must be set to a value between 1 and 365 days from creation (for
/// <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiKeyValidityOutOfBoundsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApiKeyValidityOutOfBoundsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiKeyValidityOutOfBoundsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ApiKeyValidityOutOfBoundsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ApiKeyValidityOutOfBoundsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ApiKeyValidityOutOfBoundsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ApiKeyValidityOutOfBoundsException {}
/// See [`ApiKeyValidityOutOfBoundsException`](crate::error::ApiKeyValidityOutOfBoundsException)
pub mod api_key_validity_out_of_bounds_exception {
    /// A builder for [`ApiKeyValidityOutOfBoundsException`](crate::error::ApiKeyValidityOutOfBoundsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiKeyValidityOutOfBoundsException`](crate::error::ApiKeyValidityOutOfBoundsException)
        pub fn build(self) -> crate::error::ApiKeyValidityOutOfBoundsException {
            crate::error::ApiKeyValidityOutOfBoundsException {
                message: self.message,
            }
        }
    }
}
impl ApiKeyValidityOutOfBoundsException {
    /// Creates a new builder-style object to manufacture [`ApiKeyValidityOutOfBoundsException`](crate::error::ApiKeyValidityOutOfBoundsException)
    pub fn builder() -> crate::error::api_key_validity_out_of_bounds_exception::Builder {
        crate::error::api_key_validity_out_of_bounds_exception::Builder::default()
    }
}

/// <p>The GraphQL schema is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GraphQlSchemaException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GraphQlSchemaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GraphQlSchemaException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GraphQlSchemaException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GraphQlSchemaException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GraphQlSchemaException [GraphQLSchemaException]")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for GraphQlSchemaException {}
/// See [`GraphQlSchemaException`](crate::error::GraphQlSchemaException)
pub mod graph_ql_schema_exception {
    /// A builder for [`GraphQlSchemaException`](crate::error::GraphQlSchemaException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GraphQlSchemaException`](crate::error::GraphQlSchemaException)
        pub fn build(self) -> crate::error::GraphQlSchemaException {
            crate::error::GraphQlSchemaException {
                message: self.message,
            }
        }
    }
}
impl GraphQlSchemaException {
    /// Creates a new builder-style object to manufacture [`GraphQlSchemaException`](crate::error::GraphQlSchemaException)
    pub fn builder() -> crate::error::graph_ql_schema_exception::Builder {
        crate::error::graph_ql_schema_exception::Builder::default()
    }
}

/// <p>The GraphQL API exceeded a limit. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApiLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ApiLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ApiLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ApiLimitExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ApiLimitExceededException {}
/// See [`ApiLimitExceededException`](crate::error::ApiLimitExceededException)
pub mod api_limit_exceeded_exception {
    /// A builder for [`ApiLimitExceededException`](crate::error::ApiLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiLimitExceededException`](crate::error::ApiLimitExceededException)
        pub fn build(self) -> crate::error::ApiLimitExceededException {
            crate::error::ApiLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ApiLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ApiLimitExceededException`](crate::error::ApiLimitExceededException)
    pub fn builder() -> crate::error::api_limit_exceeded_exception::Builder {
        crate::error::api_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The API key exceeded a limit. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiKeyLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApiKeyLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiKeyLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ApiKeyLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ApiKeyLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ApiKeyLimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ApiKeyLimitExceededException {}
/// See [`ApiKeyLimitExceededException`](crate::error::ApiKeyLimitExceededException)
pub mod api_key_limit_exceeded_exception {
    /// A builder for [`ApiKeyLimitExceededException`](crate::error::ApiKeyLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiKeyLimitExceededException`](crate::error::ApiKeyLimitExceededException)
        pub fn build(self) -> crate::error::ApiKeyLimitExceededException {
            crate::error::ApiKeyLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ApiKeyLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ApiKeyLimitExceededException`](crate::error::ApiKeyLimitExceededException)
    pub fn builder() -> crate::error::api_key_limit_exceeded_exception::Builder {
        crate::error::api_key_limit_exceeded_exception::Builder::default()
    }
}
