// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateApplicationFleetInput`](crate::input::AssociateApplicationFleetInput)
pub mod associate_application_fleet_input {
    /// A builder for [`AssociateApplicationFleetInput`](crate::input::AssociateApplicationFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) application_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateApplicationFleetInput`](crate::input::AssociateApplicationFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateApplicationFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateApplicationFleetInput {
                fleet_name: self.fleet_name,
                application_arn: self.application_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateApplicationFleetInputOperationOutputAlias =
    crate::operation::AssociateApplicationFleet;
#[doc(hidden)]
pub type AssociateApplicationFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateApplicationFleetInput {
    /// Consumes the builder and constructs an Operation<[`AssociateApplicationFleet`](crate::operation::AssociateApplicationFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateApplicationFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateApplicationFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateApplicationFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.AssociateApplicationFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_application_fleet(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateApplicationFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateApplicationFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateApplicationFleetInput`](crate::input::AssociateApplicationFleetInput)
    pub fn builder() -> crate::input::associate_application_fleet_input::Builder {
        crate::input::associate_application_fleet_input::Builder::default()
    }
}

/// See [`AssociateApplicationToEntitlementInput`](crate::input::AssociateApplicationToEntitlementInput)
pub mod associate_application_to_entitlement_input {
    /// A builder for [`AssociateApplicationToEntitlementInput`](crate::input::AssociateApplicationToEntitlementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) entitlement_name: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn entitlement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_name = Some(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_entitlement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_name = input;
            self
        }
        /// <p>The identifier of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateApplicationToEntitlementInput`](crate::input::AssociateApplicationToEntitlementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateApplicationToEntitlementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateApplicationToEntitlementInput {
                stack_name: self.stack_name,
                entitlement_name: self.entitlement_name,
                application_identifier: self.application_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateApplicationToEntitlementInputOperationOutputAlias =
    crate::operation::AssociateApplicationToEntitlement;
#[doc(hidden)]
pub type AssociateApplicationToEntitlementInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateApplicationToEntitlementInput {
    /// Consumes the builder and constructs an Operation<[`AssociateApplicationToEntitlement`](crate::operation::AssociateApplicationToEntitlement)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateApplicationToEntitlement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateApplicationToEntitlementInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateApplicationToEntitlementInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.AssociateApplicationToEntitlement",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_application_to_entitlement(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateApplicationToEntitlement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateApplicationToEntitlement",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateApplicationToEntitlementInput`](crate::input::AssociateApplicationToEntitlementInput)
    pub fn builder() -> crate::input::associate_application_to_entitlement_input::Builder {
        crate::input::associate_application_to_entitlement_input::Builder::default()
    }
}

/// See [`AssociateFleetInput`](crate::input::AssociateFleetInput)
pub mod associate_fleet_input {
    /// A builder for [`AssociateFleetInput`](crate::input::AssociateFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet. </p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet. </p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateFleetInput`](crate::input::AssociateFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateFleetInput {
                fleet_name: self.fleet_name,
                stack_name: self.stack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateFleetInputOperationOutputAlias = crate::operation::AssociateFleet;
#[doc(hidden)]
pub type AssociateFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateFleetInput {
    /// Consumes the builder and constructs an Operation<[`AssociateFleet`](crate::operation::AssociateFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.AssociateFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateFleetInput`](crate::input::AssociateFleetInput)
    pub fn builder() -> crate::input::associate_fleet_input::Builder {
        crate::input::associate_fleet_input::Builder::default()
    }
}

/// See [`BatchAssociateUserStackInput`](crate::input::BatchAssociateUserStackInput)
pub mod batch_associate_user_stack_input {
    /// A builder for [`BatchAssociateUserStackInput`](crate::input::BatchAssociateUserStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_stack_associations:
            std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
    }
    impl Builder {
        /// Appends an item to `user_stack_associations`.
        ///
        /// To override the contents of this collection use [`set_user_stack_associations`](Self::set_user_stack_associations).
        ///
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn user_stack_associations(
            mut self,
            input: crate::model::UserStackAssociation,
        ) -> Self {
            let mut v = self.user_stack_associations.unwrap_or_default();
            v.push(input);
            self.user_stack_associations = Some(v);
            self
        }
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn set_user_stack_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        ) -> Self {
            self.user_stack_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateUserStackInput`](crate::input::BatchAssociateUserStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAssociateUserStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchAssociateUserStackInput {
                user_stack_associations: self.user_stack_associations,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchAssociateUserStackInputOperationOutputAlias =
    crate::operation::BatchAssociateUserStack;
#[doc(hidden)]
pub type BatchAssociateUserStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchAssociateUserStackInput {
    /// Consumes the builder and constructs an Operation<[`BatchAssociateUserStack`](crate::operation::BatchAssociateUserStack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAssociateUserStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchAssociateUserStackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchAssociateUserStackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.BatchAssociateUserStack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_associate_user_stack(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAssociateUserStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAssociateUserStack",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchAssociateUserStackInput`](crate::input::BatchAssociateUserStackInput)
    pub fn builder() -> crate::input::batch_associate_user_stack_input::Builder {
        crate::input::batch_associate_user_stack_input::Builder::default()
    }
}

/// See [`BatchDisassociateUserStackInput`](crate::input::BatchDisassociateUserStackInput)
pub mod batch_disassociate_user_stack_input {
    /// A builder for [`BatchDisassociateUserStackInput`](crate::input::BatchDisassociateUserStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_stack_associations:
            std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
    }
    impl Builder {
        /// Appends an item to `user_stack_associations`.
        ///
        /// To override the contents of this collection use [`set_user_stack_associations`](Self::set_user_stack_associations).
        ///
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn user_stack_associations(
            mut self,
            input: crate::model::UserStackAssociation,
        ) -> Self {
            let mut v = self.user_stack_associations.unwrap_or_default();
            v.push(input);
            self.user_stack_associations = Some(v);
            self
        }
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn set_user_stack_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        ) -> Self {
            self.user_stack_associations = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateUserStackInput`](crate::input::BatchDisassociateUserStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisassociateUserStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDisassociateUserStackInput {
                user_stack_associations: self.user_stack_associations,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDisassociateUserStackInputOperationOutputAlias =
    crate::operation::BatchDisassociateUserStack;
#[doc(hidden)]
pub type BatchDisassociateUserStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDisassociateUserStackInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisassociateUserStack`](crate::operation::BatchDisassociateUserStack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisassociateUserStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchDisassociateUserStackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchDisassociateUserStackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.BatchDisassociateUserStack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_disassociate_user_stack(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisassociateUserStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisassociateUserStack",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchDisassociateUserStackInput`](crate::input::BatchDisassociateUserStackInput)
    pub fn builder() -> crate::input::batch_disassociate_user_stack_input::Builder {
        crate::input::batch_disassociate_user_stack_input::Builder::default()
    }
}

/// See [`CopyImageInput`](crate::input::CopyImageInput)
pub mod copy_image_input {
    /// A builder for [`CopyImageInput`](crate::input::CopyImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_image_name: std::option::Option<std::string::String>,
        pub(crate) destination_image_name: std::option::Option<std::string::String>,
        pub(crate) destination_region: std::option::Option<std::string::String>,
        pub(crate) destination_image_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the image to copy.</p>
        pub fn source_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_image_name = Some(input.into());
            self
        }
        /// <p>The name of the image to copy.</p>
        pub fn set_source_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_image_name = input;
            self
        }
        /// <p>The name that the image will have when it is copied to the destination.</p>
        pub fn destination_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_image_name = Some(input.into());
            self
        }
        /// <p>The name that the image will have when it is copied to the destination.</p>
        pub fn set_destination_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_image_name = input;
            self
        }
        /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_region = Some(input.into());
            self
        }
        /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_region = input;
            self
        }
        /// <p>The description that the image will have when it is copied to the destination.</p>
        pub fn destination_image_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_image_description = Some(input.into());
            self
        }
        /// <p>The description that the image will have when it is copied to the destination.</p>
        pub fn set_destination_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_image_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyImageInput`](crate::input::CopyImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CopyImageInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CopyImageInput {
                source_image_name: self.source_image_name,
                destination_image_name: self.destination_image_name,
                destination_region: self.destination_region,
                destination_image_description: self.destination_image_description,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyImageInputOperationOutputAlias = crate::operation::CopyImage;
#[doc(hidden)]
pub type CopyImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyImageInput {
    /// Consumes the builder and constructs an Operation<[`CopyImage`](crate::operation::CopyImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CopyImage",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CopyImage::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CopyImage",
                    "appstream",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyImageInput`](crate::input::CopyImageInput)
    pub fn builder() -> crate::input::copy_image_input::Builder {
        crate::input::copy_image_input::Builder::default()
    }
}

/// See [`CreateAppBlockInput`](crate::input::CreateAppBlockInput)
pub mod create_app_block_input {
    /// A builder for [`CreateAppBlockInput`](crate::input::CreateAppBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) source_s3_location: std::option::Option<crate::model::S3Location>,
        pub(crate) setup_script_details: std::option::Option<crate::model::ScriptDetails>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the app block.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the app block.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the app block.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the app block.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The display name of the app block. This is not displayed to the user.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the app block. This is not displayed to the user.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The source S3 location of the app block.</p>
        pub fn source_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.source_s3_location = Some(input);
            self
        }
        /// <p>The source S3 location of the app block.</p>
        pub fn set_source_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.source_s3_location = input;
            self
        }
        /// <p>The setup script details of the app block.</p>
        pub fn setup_script_details(mut self, input: crate::model::ScriptDetails) -> Self {
            self.setup_script_details = Some(input);
            self
        }
        /// <p>The setup script details of the app block.</p>
        pub fn set_setup_script_details(
            mut self,
            input: std::option::Option<crate::model::ScriptDetails>,
        ) -> Self {
            self.setup_script_details = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the app block.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the app block.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAppBlockInput`](crate::input::CreateAppBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAppBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAppBlockInput {
                name: self.name,
                description: self.description,
                display_name: self.display_name,
                source_s3_location: self.source_s3_location,
                setup_script_details: self.setup_script_details,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAppBlockInputOperationOutputAlias = crate::operation::CreateAppBlock;
#[doc(hidden)]
pub type CreateAppBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAppBlockInput {
    /// Consumes the builder and constructs an Operation<[`CreateAppBlock`](crate::operation::CreateAppBlock)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAppBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAppBlockInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAppBlockInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateAppBlock",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_app_block(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAppBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAppBlock",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAppBlockInput`](crate::input::CreateAppBlockInput)
    pub fn builder() -> crate::input::create_app_block_input::Builder {
        crate::input::create_app_block_input::Builder::default()
    }
}

/// See [`CreateApplicationInput`](crate::input::CreateApplicationInput)
pub mod create_application_input {
    /// A builder for [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) icon_s3_location: std::option::Option<crate::model::S3Location>,
        pub(crate) launch_path: std::option::Option<std::string::String>,
        pub(crate) working_directory: std::option::Option<std::string::String>,
        pub(crate) launch_parameters: std::option::Option<std::string::String>,
        pub(crate) platforms: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
        pub(crate) instance_families: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) app_block_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The location in S3 of the application icon.</p>
        pub fn icon_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.icon_s3_location = Some(input);
            self
        }
        /// <p>The location in S3 of the application icon.</p>
        pub fn set_icon_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.icon_s3_location = input;
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_path = Some(input.into());
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn set_launch_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_path = input;
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn launch_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_parameters = Some(input.into());
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn set_launch_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_parameters = input;
            self
        }
        /// Appends an item to `platforms`.
        ///
        /// To override the contents of this collection use [`set_platforms`](Self::set_platforms).
        ///
        /// <p>The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.</p>
        pub fn platforms(mut self, input: crate::model::PlatformType) -> Self {
            let mut v = self.platforms.unwrap_or_default();
            v.push(input);
            self.platforms = Some(v);
            self
        }
        /// <p>The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.</p>
        pub fn set_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
        ) -> Self {
            self.platforms = input;
            self
        }
        /// Appends an item to `instance_families`.
        ///
        /// To override the contents of this collection use [`set_instance_families`](Self::set_instance_families).
        ///
        /// <p>The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.</p>
        pub fn instance_families(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_families.unwrap_or_default();
            v.push(input.into());
            self.instance_families = Some(v);
            self
        }
        /// <p>The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.</p>
        pub fn set_instance_families(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_families = input;
            self
        }
        /// <p>The app block ARN to which the application should be associated</p>
        pub fn app_block_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_block_arn = Some(input.into());
            self
        }
        /// <p>The app block ARN to which the application should be associated</p>
        pub fn set_app_block_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_block_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags assigned to the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApplicationInput`](crate::input::CreateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApplicationInput {
                name: self.name,
                display_name: self.display_name,
                description: self.description,
                icon_s3_location: self.icon_s3_location,
                launch_path: self.launch_path,
                working_directory: self.working_directory,
                launch_parameters: self.launch_parameters,
                platforms: self.platforms,
                instance_families: self.instance_families,
                app_block_arn: self.app_block_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApplicationInputOperationOutputAlias = crate::operation::CreateApplication;
#[doc(hidden)]
pub type CreateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`CreateApplication`](crate::operation::CreateApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateApplication",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_application(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApplication",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateApplicationInput`](crate::input::CreateApplicationInput)
    pub fn builder() -> crate::input::create_application_input::Builder {
        crate::input::create_application_input::Builder::default()
    }
}

/// See [`CreateDirectoryConfigInput`](crate::input::CreateDirectoryConfigInput)
pub mod create_directory_config_input {
    /// A builder for [`CreateDirectoryConfigInput`](crate::input::CreateDirectoryConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_name: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_account_credentials:
            std::option::Option<crate::model::ServiceAccountCredentials>,
    }
    impl Builder {
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_name = Some(input.into());
            self
        }
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// Appends an item to `organizational_unit_distinguished_names`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_distinguished_names`](Self::set_organizational_unit_distinguished_names).
        ///
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn organizational_unit_distinguished_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .organizational_unit_distinguished_names
                .unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_distinguished_names = Some(v);
            self
        }
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_distinguished_names = input;
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn service_account_credentials(
            mut self,
            input: crate::model::ServiceAccountCredentials,
        ) -> Self {
            self.service_account_credentials = Some(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn set_service_account_credentials(
            mut self,
            input: std::option::Option<crate::model::ServiceAccountCredentials>,
        ) -> Self {
            self.service_account_credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectoryConfigInput`](crate::input::CreateDirectoryConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDirectoryConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDirectoryConfigInput {
                directory_name: self.directory_name,
                organizational_unit_distinguished_names: self
                    .organizational_unit_distinguished_names,
                service_account_credentials: self.service_account_credentials,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDirectoryConfigInputOperationOutputAlias = crate::operation::CreateDirectoryConfig;
#[doc(hidden)]
pub type CreateDirectoryConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDirectoryConfigInput {
    /// Consumes the builder and constructs an Operation<[`CreateDirectoryConfig`](crate::operation::CreateDirectoryConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDirectoryConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDirectoryConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDirectoryConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateDirectoryConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_directory_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDirectoryConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDirectoryConfig",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDirectoryConfigInput`](crate::input::CreateDirectoryConfigInput)
    pub fn builder() -> crate::input::create_directory_config_input::Builder {
        crate::input::create_directory_config_input::Builder::default()
    }
}

/// See [`CreateEntitlementInput`](crate::input::CreateEntitlementInput)
pub mod create_entitlement_input {
    /// A builder for [`CreateEntitlementInput`](crate::input::CreateEntitlementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) app_visibility: std::option::Option<crate::model::AppVisibility>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
    }
    impl Builder {
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether all or selected apps are entitled.</p>
        pub fn app_visibility(mut self, input: crate::model::AppVisibility) -> Self {
            self.app_visibility = Some(input);
            self
        }
        /// <p>Specifies whether all or selected apps are entitled.</p>
        pub fn set_app_visibility(
            mut self,
            input: std::option::Option<crate::model::AppVisibility>,
        ) -> Self {
            self.app_visibility = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes of the entitlement.</p>
        pub fn attributes(mut self, input: crate::model::EntitlementAttribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes of the entitlement.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEntitlementInput`](crate::input::CreateEntitlementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEntitlementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEntitlementInput {
                name: self.name,
                stack_name: self.stack_name,
                description: self.description,
                app_visibility: self.app_visibility,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEntitlementInputOperationOutputAlias = crate::operation::CreateEntitlement;
#[doc(hidden)]
pub type CreateEntitlementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEntitlementInput {
    /// Consumes the builder and constructs an Operation<[`CreateEntitlement`](crate::operation::CreateEntitlement)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEntitlement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEntitlementInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEntitlementInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateEntitlement",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_entitlement(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEntitlement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEntitlement",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEntitlementInput`](crate::input::CreateEntitlementInput)
    pub fn builder() -> crate::input::create_entitlement_input::Builder {
        crate::input::create_entitlement_input::Builder::default()
    }
}

/// See [`CreateFleetInput`](crate::input::CreateFleetInput)
pub mod create_fleet_input {
    /// A builder for [`CreateFleetInput`](crate::input::CreateFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) fleet_type: std::option::Option<crate::model::FleetType>,
        pub(crate) compute_capacity: std::option::Option<crate::model::ComputeCapacity>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) max_user_duration_in_seconds: std::option::Option<i32>,
        pub(crate) disconnect_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) enable_default_internet_access: std::option::Option<bool>,
        pub(crate) domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) idle_disconnect_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) stream_view: std::option::Option<crate::model::StreamView>,
        pub(crate) platform: std::option::Option<crate::model::PlatformType>,
        pub(crate) max_concurrent_sessions: std::option::Option<i32>,
        pub(crate) usb_device_filter_strings:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A unique name for the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>
        /// ALWAYS_ON
        /// </dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>
        /// ON_DEMAND
        /// </dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn fleet_type(mut self, input: crate::model::FleetType) -> Self {
            self.fleet_type = Some(input);
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>
        /// ALWAYS_ON
        /// </dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>
        /// ON_DEMAND
        /// </dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn set_fleet_type(
            mut self,
            input: std::option::Option<crate::model::FleetType>,
        ) -> Self {
            self.fleet_type = input;
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify MaxConcurrentSessions instead.</p>
        pub fn compute_capacity(mut self, input: crate::model::ComputeCapacity) -> Self {
            self.compute_capacity = Some(input);
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify MaxConcurrentSessions instead.</p>
        pub fn set_compute_capacity(
            mut self,
            input: std::option::Option<crate::model::ComputeCapacity>,
        ) -> Self {
            self.compute_capacity = input;
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn max_user_duration_in_seconds(mut self, input: i32) -> Self {
            self.max_user_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn set_max_user_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_user_duration_in_seconds = input;
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.disconnect_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn set_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.disconnect_timeout_in_seconds = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.enable_default_internet_access = Some(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_default_internet_access = input;
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.domain_join_info = Some(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.domain_join_info = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn idle_disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.idle_disconnect_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn set_idle_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.idle_disconnect_timeout_in_seconds = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn stream_view(mut self, input: crate::model::StreamView) -> Self {
            self.stream_view = Some(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn set_stream_view(
            mut self,
            input: std::option::Option<crate::model::StreamView>,
        ) -> Self {
            self.stream_view = input;
            self
        }
        /// <p>The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn platform(mut self, input: crate::model::PlatformType) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformType>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for other fleet types.</p>
        pub fn max_concurrent_sessions(mut self, input: i32) -> Self {
            self.max_concurrent_sessions = Some(input);
            self
        }
        /// <p>The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for other fleet types.</p>
        pub fn set_max_concurrent_sessions(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_sessions = input;
            self
        }
        /// Appends an item to `usb_device_filter_strings`.
        ///
        /// To override the contents of this collection use [`set_usb_device_filter_strings`](Self::set_usb_device_filter_strings).
        ///
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn usb_device_filter_strings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.usb_device_filter_strings.unwrap_or_default();
            v.push(input.into());
            self.usb_device_filter_strings = Some(v);
            self
        }
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn set_usb_device_filter_strings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.usb_device_filter_strings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetInput`](crate::input::CreateFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFleetInput {
                name: self.name,
                image_name: self.image_name,
                image_arn: self.image_arn,
                instance_type: self.instance_type,
                fleet_type: self.fleet_type,
                compute_capacity: self.compute_capacity,
                vpc_config: self.vpc_config,
                max_user_duration_in_seconds: self.max_user_duration_in_seconds,
                disconnect_timeout_in_seconds: self.disconnect_timeout_in_seconds,
                description: self.description,
                display_name: self.display_name,
                enable_default_internet_access: self.enable_default_internet_access,
                domain_join_info: self.domain_join_info,
                tags: self.tags,
                idle_disconnect_timeout_in_seconds: self.idle_disconnect_timeout_in_seconds,
                iam_role_arn: self.iam_role_arn,
                stream_view: self.stream_view,
                platform: self.platform,
                max_concurrent_sessions: self.max_concurrent_sessions,
                usb_device_filter_strings: self.usb_device_filter_strings,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFleetInputOperationOutputAlias = crate::operation::CreateFleet;
#[doc(hidden)]
pub type CreateFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateFleetInput {
    /// Consumes the builder and constructs an Operation<[`CreateFleet`](crate::operation::CreateFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
}

/// See [`CreateImageBuilderInput`](crate::input::CreateImageBuilderInput)
pub mod create_image_builder_input {
    /// A builder for [`CreateImageBuilderInput`](crate::input::CreateImageBuilderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) enable_default_internet_access: std::option::Option<bool>,
        pub(crate) domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
        pub(crate) appstream_agent_version: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) access_endpoints:
            std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
    }
    impl Builder {
        /// <p>A unique name for the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the image used to create the image builder.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image used to create the image builder.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.enable_default_internet_access = Some(input);
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_default_internet_access = input;
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.domain_join_info = Some(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.domain_join_info = input;
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn appstream_agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.appstream_agent_version = Some(input.into());
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.appstream_agent_version = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `access_endpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, input: crate::model::AccessEndpoint) -> Self {
            let mut v = self.access_endpoints.unwrap_or_default();
            v.push(input);
            self.access_endpoints = Some(v);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.access_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageBuilderInput`](crate::input::CreateImageBuilderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImageBuilderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImageBuilderInput {
                name: self.name,
                image_name: self.image_name,
                image_arn: self.image_arn,
                instance_type: self.instance_type,
                description: self.description,
                display_name: self.display_name,
                vpc_config: self.vpc_config,
                iam_role_arn: self.iam_role_arn,
                enable_default_internet_access: self.enable_default_internet_access,
                domain_join_info: self.domain_join_info,
                appstream_agent_version: self.appstream_agent_version,
                tags: self.tags,
                access_endpoints: self.access_endpoints,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImageBuilderInputOperationOutputAlias = crate::operation::CreateImageBuilder;
#[doc(hidden)]
pub type CreateImageBuilderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateImageBuilderInput {
    /// Consumes the builder and constructs an Operation<[`CreateImageBuilder`](crate::operation::CreateImageBuilder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImageBuilder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImageBuilderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImageBuilderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateImageBuilder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_image_builder(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImageBuilder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImageBuilder",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImageBuilderInput`](crate::input::CreateImageBuilderInput)
    pub fn builder() -> crate::input::create_image_builder_input::Builder {
        crate::input::create_image_builder_input::Builder::default()
    }
}

/// See [`CreateImageBuilderStreamingUrlInput`](crate::input::CreateImageBuilderStreamingUrlInput)
pub mod create_image_builder_streaming_url_input {
    /// A builder for [`CreateImageBuilderStreamingUrlInput`](crate::input::CreateImageBuilderStreamingUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) validity: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
        pub fn validity(mut self, input: i64) -> Self {
            self.validity = Some(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
        pub fn set_validity(mut self, input: std::option::Option<i64>) -> Self {
            self.validity = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageBuilderStreamingUrlInput`](crate::input::CreateImageBuilderStreamingUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateImageBuilderStreamingUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateImageBuilderStreamingUrlInput {
                name: self.name,
                validity: self.validity,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateImageBuilderStreamingUrlInputOperationOutputAlias =
    crate::operation::CreateImageBuilderStreamingURL;
#[doc(hidden)]
pub type CreateImageBuilderStreamingUrlInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateImageBuilderStreamingUrlInput {
    /// Consumes the builder and constructs an Operation<[`CreateImageBuilderStreamingURL`](crate::operation::CreateImageBuilderStreamingURL)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateImageBuilderStreamingURL,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateImageBuilderStreamingUrlInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateImageBuilderStreamingUrlInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateImageBuilderStreamingURL",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_image_builder_streaming_url(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateImageBuilderStreamingURL::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateImageBuilderStreamingURL",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateImageBuilderStreamingUrlInput`](crate::input::CreateImageBuilderStreamingUrlInput)
    pub fn builder() -> crate::input::create_image_builder_streaming_url_input::Builder {
        crate::input::create_image_builder_streaming_url_input::Builder::default()
    }
}

/// See [`CreateStackInput`](crate::input::CreateStackInput)
pub mod create_stack_input {
    /// A builder for [`CreateStackInput`](crate::input::CreateStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) storage_connectors:
            std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        pub(crate) redirect_url: std::option::Option<std::string::String>,
        pub(crate) feedback_url: std::option::Option<std::string::String>,
        pub(crate) user_settings: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        pub(crate) application_settings: std::option::Option<crate::model::ApplicationSettings>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) access_endpoints:
            std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        pub(crate) embed_host_domains: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the stack.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The stack name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The stack name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// Appends an item to `storage_connectors`.
        ///
        /// To override the contents of this collection use [`set_storage_connectors`](Self::set_storage_connectors).
        ///
        /// <p>The storage connectors to enable.</p>
        pub fn storage_connectors(mut self, input: crate::model::StorageConnector) -> Self {
            let mut v = self.storage_connectors.unwrap_or_default();
            v.push(input);
            self.storage_connectors = Some(v);
            self
        }
        /// <p>The storage connectors to enable.</p>
        pub fn set_storage_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        ) -> Self {
            self.storage_connectors = input;
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn redirect_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.redirect_url = Some(input.into());
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn set_redirect_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.redirect_url = input;
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn feedback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.feedback_url = Some(input.into());
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn set_feedback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feedback_url = input;
            self
        }
        /// Appends an item to `user_settings`.
        ///
        /// To override the contents of this collection use [`set_user_settings`](Self::set_user_settings).
        ///
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
        pub fn user_settings(mut self, input: crate::model::UserSetting) -> Self {
            let mut v = self.user_settings.unwrap_or_default();
            v.push(input);
            self.user_settings = Some(v);
            self
        }
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        ) -> Self {
            self.user_settings = input;
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn application_settings(mut self, input: crate::model::ApplicationSettings) -> Self {
            self.application_settings = Some(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn set_application_settings(
            mut self,
            input: std::option::Option<crate::model::ApplicationSettings>,
        ) -> Self {
            self.application_settings = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `access_endpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, input: crate::model::AccessEndpoint) -> Self {
            let mut v = self.access_endpoints.unwrap_or_default();
            v.push(input);
            self.access_endpoints = Some(v);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.access_endpoints = input;
            self
        }
        /// Appends an item to `embed_host_domains`.
        ///
        /// To override the contents of this collection use [`set_embed_host_domains`](Self::set_embed_host_domains).
        ///
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn embed_host_domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.embed_host_domains.unwrap_or_default();
            v.push(input.into());
            self.embed_host_domains = Some(v);
            self
        }
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn set_embed_host_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.embed_host_domains = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStackInput`](crate::input::CreateStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStackInput {
                name: self.name,
                description: self.description,
                display_name: self.display_name,
                storage_connectors: self.storage_connectors,
                redirect_url: self.redirect_url,
                feedback_url: self.feedback_url,
                user_settings: self.user_settings,
                application_settings: self.application_settings,
                tags: self.tags,
                access_endpoints: self.access_endpoints,
                embed_host_domains: self.embed_host_domains,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStackInputOperationOutputAlias = crate::operation::CreateStack;
#[doc(hidden)]
pub type CreateStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStackInput {
    /// Consumes the builder and constructs an Operation<[`CreateStack`](crate::operation::CreateStack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateStack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_stack(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStack",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStackInput`](crate::input::CreateStackInput)
    pub fn builder() -> crate::input::create_stack_input::Builder {
        crate::input::create_stack_input::Builder::default()
    }
}

/// See [`CreateStreamingUrlInput`](crate::input::CreateStreamingUrlInput)
pub mod create_streaming_url_input {
    /// A builder for [`CreateStreamingUrlInput`](crate::input::CreateStreamingUrlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) application_id: std::option::Option<std::string::String>,
        pub(crate) validity: std::option::Option<i64>,
        pub(crate) session_context: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_id = Some(input.into());
            self
        }
        /// <p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_id = input;
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
        pub fn validity(mut self, input: i64) -> Self {
            self.validity = Some(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
        pub fn set_validity(mut self, input: std::option::Option<i64>) -> Self {
            self.validity = input;
            self
        }
        /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn session_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_context = Some(input.into());
            self
        }
        /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_session_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_context = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingUrlInput`](crate::input::CreateStreamingUrlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateStreamingUrlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateStreamingUrlInput {
                stack_name: self.stack_name,
                fleet_name: self.fleet_name,
                user_id: self.user_id,
                application_id: self.application_id,
                validity: self.validity,
                session_context: self.session_context,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateStreamingUrlInputOperationOutputAlias = crate::operation::CreateStreamingURL;
#[doc(hidden)]
pub type CreateStreamingUrlInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateStreamingUrlInput {
    /// Consumes the builder and constructs an Operation<[`CreateStreamingURL`](crate::operation::CreateStreamingURL)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateStreamingURL,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateStreamingUrlInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateStreamingUrlInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateStreamingURL",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_streaming_url(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateStreamingURL::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateStreamingURL",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateStreamingUrlInput`](crate::input::CreateStreamingUrlInput)
    pub fn builder() -> crate::input::create_streaming_url_input::Builder {
        crate::input::create_streaming_url_input::Builder::default()
    }
}

/// See [`CreateUpdatedImageInput`](crate::input::CreateUpdatedImageInput)
pub mod create_updated_image_input {
    /// A builder for [`CreateUpdatedImageInput`](crate::input::CreateUpdatedImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) existing_image_name: std::option::Option<std::string::String>,
        pub(crate) new_image_name: std::option::Option<std::string::String>,
        pub(crate) new_image_description: std::option::Option<std::string::String>,
        pub(crate) new_image_display_name: std::option::Option<std::string::String>,
        pub(crate) new_image_tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the image to update.</p>
        pub fn existing_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.existing_image_name = Some(input.into());
            self
        }
        /// <p>The name of the image to update.</p>
        pub fn set_existing_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.existing_image_name = input;
            self
        }
        /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
        pub fn new_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_image_name = Some(input.into());
            self
        }
        /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
        pub fn set_new_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_image_name = input;
            self
        }
        /// <p>The description to display for the new image.</p>
        pub fn new_image_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_image_description = Some(input.into());
            self
        }
        /// <p>The description to display for the new image.</p>
        pub fn set_new_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_image_description = input;
            self
        }
        /// <p>The name to display for the new image.</p>
        pub fn new_image_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_image_display_name = Some(input.into());
            self
        }
        /// <p>The name to display for the new image.</p>
        pub fn set_new_image_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_image_display_name = input;
            self
        }
        /// Adds a key-value pair to `new_image_tags`.
        ///
        /// To override the contents of this collection use [`set_new_image_tags`](Self::set_new_image_tags).
        ///
        /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn new_image_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.new_image_tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.new_image_tags = Some(hash_map);
            self
        }
        /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_new_image_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.new_image_tags = input;
            self
        }
        /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUpdatedImageInput`](crate::input::CreateUpdatedImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUpdatedImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUpdatedImageInput {
                existing_image_name: self.existing_image_name,
                new_image_name: self.new_image_name,
                new_image_description: self.new_image_description,
                new_image_display_name: self.new_image_display_name,
                new_image_tags: self.new_image_tags,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUpdatedImageInputOperationOutputAlias = crate::operation::CreateUpdatedImage;
#[doc(hidden)]
pub type CreateUpdatedImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUpdatedImageInput {
    /// Consumes the builder and constructs an Operation<[`CreateUpdatedImage`](crate::operation::CreateUpdatedImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUpdatedImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateUpdatedImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateUpdatedImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateUpdatedImage",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_updated_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUpdatedImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUpdatedImage",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateUpdatedImageInput`](crate::input::CreateUpdatedImageInput)
    pub fn builder() -> crate::input::create_updated_image_input::Builder {
        crate::input::create_updated_image_input::Builder::default()
    }
}

/// See [`CreateUsageReportSubscriptionInput`](crate::input::CreateUsageReportSubscriptionInput)
pub mod create_usage_report_subscription_input {
    /// A builder for [`CreateUsageReportSubscriptionInput`](crate::input::CreateUsageReportSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateUsageReportSubscriptionInput`](crate::input::CreateUsageReportSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUsageReportSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUsageReportSubscriptionInput {})
        }
    }
}
#[doc(hidden)]
pub type CreateUsageReportSubscriptionInputOperationOutputAlias =
    crate::operation::CreateUsageReportSubscription;
#[doc(hidden)]
pub type CreateUsageReportSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateUsageReportSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateUsageReportSubscription`](crate::operation::CreateUsageReportSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUsageReportSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateUsageReportSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateUsageReportSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateUsageReportSubscription",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_usage_report_subscription(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUsageReportSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUsageReportSubscription",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateUsageReportSubscriptionInput`](crate::input::CreateUsageReportSubscriptionInput)
    pub fn builder() -> crate::input::create_usage_report_subscription_input::Builder {
        crate::input::create_usage_report_subscription_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) message_action: std::option::Option<crate::model::MessageAction>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
    }
    impl Builder {
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note>
        /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
        /// </note>
        pub fn message_action(mut self, input: crate::model::MessageAction) -> Self {
            self.message_action = Some(input);
            self
        }
        /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note>
        /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
        /// </note>
        pub fn set_message_action(
            mut self,
            input: std::option::Option<crate::model::MessageAction>,
        ) -> Self {
            self.message_action = input;
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL. </p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                user_name: self.user_name,
                message_action: self.message_action,
                first_name: self.first_name,
                last_name: self.last_name,
                authentication_type: self.authentication_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.CreateUser",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`DeleteAppBlockInput`](crate::input::DeleteAppBlockInput)
pub mod delete_app_block_input {
    /// A builder for [`DeleteAppBlockInput`](crate::input::DeleteAppBlockInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the app block.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the app block.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAppBlockInput`](crate::input::DeleteAppBlockInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAppBlockInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAppBlockInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteAppBlockInputOperationOutputAlias = crate::operation::DeleteAppBlock;
#[doc(hidden)]
pub type DeleteAppBlockInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAppBlockInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAppBlock`](crate::operation::DeleteAppBlock)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAppBlock,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAppBlockInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAppBlockInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteAppBlock",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_app_block(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAppBlock::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAppBlock",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAppBlockInput`](crate::input::DeleteAppBlockInput)
    pub fn builder() -> crate::input::delete_app_block_input::Builder {
        crate::input::delete_app_block_input::Builder::default()
    }
}

/// See [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
pub mod delete_application_input {
    /// A builder for [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApplicationInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteApplicationInputOperationOutputAlias = crate::operation::DeleteApplication;
#[doc(hidden)]
pub type DeleteApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApplicationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApplication`](crate::operation::DeleteApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteApplication",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_application(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApplication",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteApplicationInput`](crate::input::DeleteApplicationInput)
    pub fn builder() -> crate::input::delete_application_input::Builder {
        crate::input::delete_application_input::Builder::default()
    }
}

/// See [`DeleteDirectoryConfigInput`](crate::input::DeleteDirectoryConfigInput)
pub mod delete_directory_config_input {
    /// A builder for [`DeleteDirectoryConfigInput`](crate::input::DeleteDirectoryConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the directory configuration.</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_name = Some(input.into());
            self
        }
        /// <p>The name of the directory configuration.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDirectoryConfigInput`](crate::input::DeleteDirectoryConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDirectoryConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDirectoryConfigInput {
                directory_name: self.directory_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDirectoryConfigInputOperationOutputAlias = crate::operation::DeleteDirectoryConfig;
#[doc(hidden)]
pub type DeleteDirectoryConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDirectoryConfigInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDirectoryConfig`](crate::operation::DeleteDirectoryConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDirectoryConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDirectoryConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDirectoryConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteDirectoryConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_directory_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDirectoryConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDirectoryConfig",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryConfigInput`](crate::input::DeleteDirectoryConfigInput)
    pub fn builder() -> crate::input::delete_directory_config_input::Builder {
        crate::input::delete_directory_config_input::Builder::default()
    }
}

/// See [`DeleteEntitlementInput`](crate::input::DeleteEntitlementInput)
pub mod delete_entitlement_input {
    /// A builder for [`DeleteEntitlementInput`](crate::input::DeleteEntitlementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEntitlementInput`](crate::input::DeleteEntitlementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEntitlementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEntitlementInput {
                name: self.name,
                stack_name: self.stack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEntitlementInputOperationOutputAlias = crate::operation::DeleteEntitlement;
#[doc(hidden)]
pub type DeleteEntitlementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEntitlementInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEntitlement`](crate::operation::DeleteEntitlement)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEntitlement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEntitlementInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEntitlementInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteEntitlement",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_entitlement(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEntitlement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEntitlement",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEntitlementInput`](crate::input::DeleteEntitlementInput)
    pub fn builder() -> crate::input::delete_entitlement_input::Builder {
        crate::input::delete_entitlement_input::Builder::default()
    }
}

/// See [`DeleteFleetInput`](crate::input::DeleteFleetInput)
pub mod delete_fleet_input {
    /// A builder for [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFleetInput`](crate::input::DeleteFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFleetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteFleetInputOperationOutputAlias = crate::operation::DeleteFleet;
#[doc(hidden)]
pub type DeleteFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFleetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFleet`](crate::operation::DeleteFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    pub fn builder() -> crate::input::delete_fleet_input::Builder {
        crate::input::delete_fleet_input::Builder::default()
    }
}

/// See [`DeleteImageInput`](crate::input::DeleteImageInput)
pub mod delete_image_input {
    /// A builder for [`DeleteImageInput`](crate::input::DeleteImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageInput`](crate::input::DeleteImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImageInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteImageInputOperationOutputAlias = crate::operation::DeleteImage;
#[doc(hidden)]
pub type DeleteImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteImageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImage`](crate::operation::DeleteImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteImage",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_image(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImage",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteImageInput`](crate::input::DeleteImageInput)
    pub fn builder() -> crate::input::delete_image_input::Builder {
        crate::input::delete_image_input::Builder::default()
    }
}

/// See [`DeleteImageBuilderInput`](crate::input::DeleteImageBuilderInput)
pub mod delete_image_builder_input {
    /// A builder for [`DeleteImageBuilderInput`](crate::input::DeleteImageBuilderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageBuilderInput`](crate::input::DeleteImageBuilderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImageBuilderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImageBuilderInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteImageBuilderInputOperationOutputAlias = crate::operation::DeleteImageBuilder;
#[doc(hidden)]
pub type DeleteImageBuilderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteImageBuilderInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImageBuilder`](crate::operation::DeleteImageBuilder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImageBuilder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteImageBuilderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteImageBuilderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteImageBuilder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_image_builder(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImageBuilder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImageBuilder",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteImageBuilderInput`](crate::input::DeleteImageBuilderInput)
    pub fn builder() -> crate::input::delete_image_builder_input::Builder {
        crate::input::delete_image_builder_input::Builder::default()
    }
}

/// See [`DeleteImagePermissionsInput`](crate::input::DeleteImagePermissionsInput)
pub mod delete_image_permissions_input {
    /// A builder for [`DeleteImagePermissionsInput`](crate::input::DeleteImagePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) shared_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the private image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the private image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImagePermissionsInput`](crate::input::DeleteImagePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteImagePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteImagePermissionsInput {
                name: self.name,
                shared_account_id: self.shared_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteImagePermissionsInputOperationOutputAlias = crate::operation::DeleteImagePermissions;
#[doc(hidden)]
pub type DeleteImagePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteImagePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteImagePermissions`](crate::operation::DeleteImagePermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteImagePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteImagePermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteImagePermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteImagePermissions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_image_permissions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteImagePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteImagePermissions",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteImagePermissionsInput`](crate::input::DeleteImagePermissionsInput)
    pub fn builder() -> crate::input::delete_image_permissions_input::Builder {
        crate::input::delete_image_permissions_input::Builder::default()
    }
}

/// See [`DeleteStackInput`](crate::input::DeleteStackInput)
pub mod delete_stack_input {
    /// A builder for [`DeleteStackInput`](crate::input::DeleteStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stack.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteStackInput`](crate::input::DeleteStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteStackInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type DeleteStackInputOperationOutputAlias = crate::operation::DeleteStack;
#[doc(hidden)]
pub type DeleteStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteStackInput {
    /// Consumes the builder and constructs an Operation<[`DeleteStack`](crate::operation::DeleteStack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteStackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteStackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteStack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_stack(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteStack",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteStackInput`](crate::input::DeleteStackInput)
    pub fn builder() -> crate::input::delete_stack_input::Builder {
        crate::input::delete_stack_input::Builder::default()
    }
}

/// See [`DeleteUsageReportSubscriptionInput`](crate::input::DeleteUsageReportSubscriptionInput)
pub mod delete_usage_report_subscription_input {
    /// A builder for [`DeleteUsageReportSubscriptionInput`](crate::input::DeleteUsageReportSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUsageReportSubscriptionInput`](crate::input::DeleteUsageReportSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUsageReportSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUsageReportSubscriptionInput {})
        }
    }
}
#[doc(hidden)]
pub type DeleteUsageReportSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteUsageReportSubscription;
#[doc(hidden)]
pub type DeleteUsageReportSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUsageReportSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUsageReportSubscription`](crate::operation::DeleteUsageReportSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUsageReportSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteUsageReportSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteUsageReportSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteUsageReportSubscription",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_usage_report_subscription(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUsageReportSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUsageReportSubscription",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteUsageReportSubscriptionInput`](crate::input::DeleteUsageReportSubscriptionInput)
    pub fn builder() -> crate::input::delete_usage_report_subscription_input::Builder {
        crate::input::delete_usage_report_subscription_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
    }
    impl Builder {
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                user_name: self.user_name,
                authentication_type: self.authentication_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DeleteUser",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DescribeAppBlocksInput`](crate::input::DescribeAppBlocksInput)
pub mod describe_app_blocks_input {
    /// A builder for [`DescribeAppBlocksInput`](crate::input::DescribeAppBlocksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The ARNs of the app blocks.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.arns.unwrap_or_default();
            v.push(input.into());
            self.arns = Some(v);
            self
        }
        /// <p>The ARNs of the app blocks.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.arns = input;
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAppBlocksInput`](crate::input::DescribeAppBlocksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAppBlocksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAppBlocksInput {
                arns: self.arns,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAppBlocksInputOperationOutputAlias = crate::operation::DescribeAppBlocks;
#[doc(hidden)]
pub type DescribeAppBlocksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAppBlocksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAppBlocks`](crate::operation::DescribeAppBlocks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAppBlocks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAppBlocksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAppBlocksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeAppBlocks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_app_blocks(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAppBlocks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAppBlocks",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAppBlocksInput`](crate::input::DescribeAppBlocksInput)
    pub fn builder() -> crate::input::describe_app_blocks_input::Builder {
        crate::input::describe_app_blocks_input::Builder::default()
    }
}

/// See [`DescribeApplicationFleetAssociationsInput`](crate::input::DescribeApplicationFleetAssociationsInput)
pub mod describe_application_fleet_associations_input {
    /// A builder for [`DescribeApplicationFleetAssociationsInput`](crate::input::DescribeApplicationFleetAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) application_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationFleetAssociationsInput`](crate::input::DescribeApplicationFleetAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationFleetAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationFleetAssociationsInput {
                fleet_name: self.fleet_name,
                application_arn: self.application_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationFleetAssociationsInputOperationOutputAlias =
    crate::operation::DescribeApplicationFleetAssociations;
#[doc(hidden)]
pub type DescribeApplicationFleetAssociationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeApplicationFleetAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplicationFleetAssociations`](crate::operation::DescribeApplicationFleetAssociations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplicationFleetAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeApplicationFleetAssociationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeApplicationFleetAssociationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeApplicationFleetAssociations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_application_fleet_associations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplicationFleetAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplicationFleetAssociations",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationFleetAssociationsInput`](crate::input::DescribeApplicationFleetAssociationsInput)
    pub fn builder() -> crate::input::describe_application_fleet_associations_input::Builder {
        crate::input::describe_application_fleet_associations_input::Builder::default()
    }
}

/// See [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
pub mod describe_applications_input {
    /// A builder for [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The ARNs for the applications.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.arns.unwrap_or_default();
            v.push(input.into());
            self.arns = Some(v);
            self
        }
        /// <p>The ARNs for the applications.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.arns = input;
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicationsInput {
                arns: self.arns,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicationsInputOperationOutputAlias = crate::operation::DescribeApplications;
#[doc(hidden)]
pub type DescribeApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplications`](crate::operation::DescribeApplications)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeApplicationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeApplicationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeApplications",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_applications(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplications",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicationsInput`](crate::input::DescribeApplicationsInput)
    pub fn builder() -> crate::input::describe_applications_input::Builder {
        crate::input::describe_applications_input::Builder::default()
    }
}

/// See [`DescribeDirectoryConfigsInput`](crate::input::DescribeDirectoryConfigsInput)
pub mod describe_directory_configs_input {
    /// A builder for [`DescribeDirectoryConfigsInput`](crate::input::DescribeDirectoryConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `directory_names`.
        ///
        /// To override the contents of this collection use [`set_directory_names`](Self::set_directory_names).
        ///
        /// <p>The directory names.</p>
        pub fn directory_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.directory_names.unwrap_or_default();
            v.push(input.into());
            self.directory_names = Some(v);
            self
        }
        /// <p>The directory names.</p>
        pub fn set_directory_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.directory_names = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectoryConfigsInput`](crate::input::DescribeDirectoryConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDirectoryConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDirectoryConfigsInput {
                directory_names: self.directory_names,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDirectoryConfigsInputOperationOutputAlias =
    crate::operation::DescribeDirectoryConfigs;
#[doc(hidden)]
pub type DescribeDirectoryConfigsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDirectoryConfigsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDirectoryConfigs`](crate::operation::DescribeDirectoryConfigs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDirectoryConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDirectoryConfigsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDirectoryConfigsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeDirectoryConfigs",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_directory_configs(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDirectoryConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDirectoryConfigs",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDirectoryConfigsInput`](crate::input::DescribeDirectoryConfigsInput)
    pub fn builder() -> crate::input::describe_directory_configs_input::Builder {
        crate::input::describe_directory_configs_input::Builder::default()
    }
}

/// See [`DescribeEntitlementsInput`](crate::input::DescribeEntitlementsInput)
pub mod describe_entitlements_input {
    /// A builder for [`DescribeEntitlementsInput`](crate::input::DescribeEntitlementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEntitlementsInput`](crate::input::DescribeEntitlementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEntitlementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEntitlementsInput {
                name: self.name,
                stack_name: self.stack_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEntitlementsInputOperationOutputAlias = crate::operation::DescribeEntitlements;
#[doc(hidden)]
pub type DescribeEntitlementsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEntitlementsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEntitlements`](crate::operation::DescribeEntitlements)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEntitlements,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEntitlementsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEntitlementsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeEntitlements",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_entitlements(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEntitlements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEntitlements",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEntitlementsInput`](crate::input::DescribeEntitlementsInput)
    pub fn builder() -> crate::input::describe_entitlements_input::Builder {
        crate::input::describe_entitlements_input::Builder::default()
    }
}

/// See [`DescribeFleetsInput`](crate::input::DescribeFleetsInput)
pub mod describe_fleets_input {
    /// A builder for [`DescribeFleetsInput`](crate::input::DescribeFleetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the fleets to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the fleets to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetsInput`](crate::input::DescribeFleetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFleetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFleetsInput {
                names: self.names,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFleetsInputOperationOutputAlias = crate::operation::DescribeFleets;
#[doc(hidden)]
pub type DescribeFleetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeFleetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFleets`](crate::operation::DescribeFleets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFleets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeFleetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeFleetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeFleets",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_fleets(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFleets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFleets",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeFleetsInput`](crate::input::DescribeFleetsInput)
    pub fn builder() -> crate::input::describe_fleets_input::Builder {
        crate::input::describe_fleets_input::Builder::default()
    }
}

/// See [`DescribeImageBuildersInput`](crate::input::DescribeImageBuildersInput)
pub mod describe_image_builders_input {
    /// A builder for [`DescribeImageBuildersInput`](crate::input::DescribeImageBuildersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the image builders to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the image builders to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageBuildersInput`](crate::input::DescribeImageBuildersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImageBuildersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImageBuildersInput {
                names: self.names,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImageBuildersInputOperationOutputAlias = crate::operation::DescribeImageBuilders;
#[doc(hidden)]
pub type DescribeImageBuildersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeImageBuildersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImageBuilders`](crate::operation::DescribeImageBuilders)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImageBuilders,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeImageBuildersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeImageBuildersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeImageBuilders",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_image_builders(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImageBuilders::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImageBuilders",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeImageBuildersInput`](crate::input::DescribeImageBuildersInput)
    pub fn builder() -> crate::input::describe_image_builders_input::Builder {
        crate::input::describe_image_builders_input::Builder::default()
    }
}

/// See [`DescribeImagePermissionsInput`](crate::input::DescribeImagePermissionsInput)
pub mod describe_image_permissions_input {
    /// A builder for [`DescribeImagePermissionsInput`](crate::input::DescribeImagePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) shared_aws_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `shared_aws_account_ids`.
        ///
        /// To override the contents of this collection use [`set_shared_aws_account_ids`](Self::set_shared_aws_account_ids).
        ///
        /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
        pub fn shared_aws_account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.shared_aws_account_ids.unwrap_or_default();
            v.push(input.into());
            self.shared_aws_account_ids = Some(v);
            self
        }
        /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
        pub fn set_shared_aws_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.shared_aws_account_ids = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagePermissionsInput`](crate::input::DescribeImagePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImagePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImagePermissionsInput {
                name: self.name,
                max_results: self.max_results,
                shared_aws_account_ids: self.shared_aws_account_ids,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImagePermissionsInputOperationOutputAlias =
    crate::operation::DescribeImagePermissions;
#[doc(hidden)]
pub type DescribeImagePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeImagePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImagePermissions`](crate::operation::DescribeImagePermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImagePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeImagePermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeImagePermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeImagePermissions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_image_permissions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImagePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImagePermissions",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeImagePermissionsInput`](crate::input::DescribeImagePermissionsInput)
    pub fn builder() -> crate::input::describe_image_permissions_input::Builder {
        crate::input::describe_image_permissions_input::Builder::default()
    }
}

/// See [`DescribeImagesInput`](crate::input::DescribeImagesInput)
pub mod describe_images_input {
    /// A builder for [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) r#type: std::option::Option<crate::model::VisibilityType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the public or private images to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the public or private images to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// Appends an item to `arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The ARNs of the public, private, and shared images to describe.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.arns.unwrap_or_default();
            v.push(input.into());
            self.arns = Some(v);
            self
        }
        /// <p>The ARNs of the public, private, and shared images to describe.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.arns = input;
            self
        }
        /// <p>The type of image (public, private, or shared) to describe. </p>
        pub fn r#type(mut self, input: crate::model::VisibilityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of image (public, private, or shared) to describe. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::VisibilityType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagesInput`](crate::input::DescribeImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeImagesInput {
                names: self.names,
                arns: self.arns,
                r#type: self.r#type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeImagesInputOperationOutputAlias = crate::operation::DescribeImages;
#[doc(hidden)]
pub type DescribeImagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeImagesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeImages`](crate::operation::DescribeImages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeImages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeImagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeImagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeImages",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_images(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeImages",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    pub fn builder() -> crate::input::describe_images_input::Builder {
        crate::input::describe_images_input::Builder::default()
    }
}

/// See [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
pub mod describe_sessions_input {
    /// A builder for [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
    }
    impl Builder {
        /// <p>The name of the stack. This value is case-sensitive.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack. This value is case-sensitive.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name of the fleet. This value is case-sensitive.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet. This value is case-sensitive.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSessionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSessionsInput {
                stack_name: self.stack_name,
                fleet_name: self.fleet_name,
                user_id: self.user_id,
                next_token: self.next_token,
                limit: self.limit,
                authentication_type: self.authentication_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSessionsInputOperationOutputAlias = crate::operation::DescribeSessions;
#[doc(hidden)]
pub type DescribeSessionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSessionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSessions`](crate::operation::DescribeSessions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSessions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeSessionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeSessionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeSessions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_sessions(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSessions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSessions",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
    pub fn builder() -> crate::input::describe_sessions_input::Builder {
        crate::input::describe_sessions_input::Builder::default()
    }
}

/// See [`DescribeStacksInput`](crate::input::DescribeStacksInput)
pub mod describe_stacks_input {
    /// A builder for [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the stacks to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The names of the stacks to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStacksInput`](crate::input::DescribeStacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeStacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeStacksInput {
                names: self.names,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeStacksInputOperationOutputAlias = crate::operation::DescribeStacks;
#[doc(hidden)]
pub type DescribeStacksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeStacksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeStacks`](crate::operation::DescribeStacks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeStacks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeStacksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeStacksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeStacks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_stacks(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeStacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeStacks",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    pub fn builder() -> crate::input::describe_stacks_input::Builder {
        crate::input::describe_stacks_input::Builder::default()
    }
}

/// See [`DescribeUsageReportSubscriptionsInput`](crate::input::DescribeUsageReportSubscriptionsInput)
pub mod describe_usage_report_subscriptions_input {
    /// A builder for [`DescribeUsageReportSubscriptionsInput`](crate::input::DescribeUsageReportSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsageReportSubscriptionsInput`](crate::input::DescribeUsageReportSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUsageReportSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUsageReportSubscriptionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUsageReportSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeUsageReportSubscriptions;
#[doc(hidden)]
pub type DescribeUsageReportSubscriptionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUsageReportSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUsageReportSubscriptions`](crate::operation::DescribeUsageReportSubscriptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUsageReportSubscriptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeUsageReportSubscriptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeUsageReportSubscriptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeUsageReportSubscriptions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_usage_report_subscriptions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUsageReportSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUsageReportSubscriptions",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeUsageReportSubscriptionsInput`](crate::input::DescribeUsageReportSubscriptionsInput)
    pub fn builder() -> crate::input::describe_usage_report_subscriptions_input::Builder {
        crate::input::describe_usage_report_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeUsersInput`](crate::input::DescribeUsersInput)
pub mod describe_users_input {
    /// A builder for [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersInput`](crate::input::DescribeUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUsersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUsersInput {
                authentication_type: self.authentication_type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUsersInputOperationOutputAlias = crate::operation::DescribeUsers;
#[doc(hidden)]
pub type DescribeUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUsersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUsers`](crate::operation::DescribeUsers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeUsersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeUsersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeUsers",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_users(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUsers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUsers",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
}

/// See [`DescribeUserStackAssociationsInput`](crate::input::DescribeUserStackAssociationsInput)
pub mod describe_user_stack_associations_input {
    /// A builder for [`DescribeUserStackAssociationsInput`](crate::input::DescribeUserStackAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserStackAssociationsInput`](crate::input::DescribeUserStackAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserStackAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserStackAssociationsInput {
                stack_name: self.stack_name,
                user_name: self.user_name,
                authentication_type: self.authentication_type,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserStackAssociationsInputOperationOutputAlias =
    crate::operation::DescribeUserStackAssociations;
#[doc(hidden)]
pub type DescribeUserStackAssociationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserStackAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserStackAssociations`](crate::operation::DescribeUserStackAssociations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserStackAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeUserStackAssociationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeUserStackAssociationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DescribeUserStackAssociations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_user_stack_associations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserStackAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserStackAssociations",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserStackAssociationsInput`](crate::input::DescribeUserStackAssociationsInput)
    pub fn builder() -> crate::input::describe_user_stack_associations_input::Builder {
        crate::input::describe_user_stack_associations_input::Builder::default()
    }
}

/// See [`DisableUserInput`](crate::input::DisableUserInput)
pub mod disable_user_input {
    /// A builder for [`DisableUserInput`](crate::input::DisableUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
    }
    impl Builder {
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableUserInput`](crate::input::DisableUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableUserInput {
                user_name: self.user_name,
                authentication_type: self.authentication_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableUserInputOperationOutputAlias = crate::operation::DisableUser;
#[doc(hidden)]
pub type DisableUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableUserInput {
    /// Consumes the builder and constructs an Operation<[`DisableUser`](crate::operation::DisableUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisableUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisableUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DisableUser",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disable_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableUser",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisableUserInput`](crate::input::DisableUserInput)
    pub fn builder() -> crate::input::disable_user_input::Builder {
        crate::input::disable_user_input::Builder::default()
    }
}

/// See [`DisassociateApplicationFleetInput`](crate::input::DisassociateApplicationFleetInput)
pub mod disassociate_application_fleet_input {
    /// A builder for [`DisassociateApplicationFleetInput`](crate::input::DisassociateApplicationFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) application_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateApplicationFleetInput`](crate::input::DisassociateApplicationFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateApplicationFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateApplicationFleetInput {
                fleet_name: self.fleet_name,
                application_arn: self.application_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateApplicationFleetInputOperationOutputAlias =
    crate::operation::DisassociateApplicationFleet;
#[doc(hidden)]
pub type DisassociateApplicationFleetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateApplicationFleetInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateApplicationFleet`](crate::operation::DisassociateApplicationFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateApplicationFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateApplicationFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateApplicationFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DisassociateApplicationFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_application_fleet(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateApplicationFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateApplicationFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateApplicationFleetInput`](crate::input::DisassociateApplicationFleetInput)
    pub fn builder() -> crate::input::disassociate_application_fleet_input::Builder {
        crate::input::disassociate_application_fleet_input::Builder::default()
    }
}

/// See [`DisassociateApplicationFromEntitlementInput`](crate::input::DisassociateApplicationFromEntitlementInput)
pub mod disassociate_application_from_entitlement_input {
    /// A builder for [`DisassociateApplicationFromEntitlementInput`](crate::input::DisassociateApplicationFromEntitlementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) entitlement_name: std::option::Option<std::string::String>,
        pub(crate) application_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn entitlement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_name = Some(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_entitlement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_name = input;
            self
        }
        /// <p>The identifier of the application to remove from the entitlement.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.application_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the application to remove from the entitlement.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.application_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateApplicationFromEntitlementInput`](crate::input::DisassociateApplicationFromEntitlementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateApplicationFromEntitlementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateApplicationFromEntitlementInput {
                stack_name: self.stack_name,
                entitlement_name: self.entitlement_name,
                application_identifier: self.application_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateApplicationFromEntitlementInputOperationOutputAlias =
    crate::operation::DisassociateApplicationFromEntitlement;
#[doc(hidden)]
pub type DisassociateApplicationFromEntitlementInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateApplicationFromEntitlementInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateApplicationFromEntitlement`](crate::operation::DisassociateApplicationFromEntitlement)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateApplicationFromEntitlement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateApplicationFromEntitlementInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateApplicationFromEntitlementInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DisassociateApplicationFromEntitlement",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_application_from_entitlement(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateApplicationFromEntitlement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateApplicationFromEntitlement",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateApplicationFromEntitlementInput`](crate::input::DisassociateApplicationFromEntitlementInput)
    pub fn builder() -> crate::input::disassociate_application_from_entitlement_input::Builder {
        crate::input::disassociate_application_from_entitlement_input::Builder::default()
    }
}

/// See [`DisassociateFleetInput`](crate::input::DisassociateFleetInput)
pub mod disassociate_fleet_input {
    /// A builder for [`DisassociateFleetInput`](crate::input::DisassociateFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateFleetInput`](crate::input::DisassociateFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFleetInput {
                fleet_name: self.fleet_name,
                stack_name: self.stack_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateFleetInputOperationOutputAlias = crate::operation::DisassociateFleet;
#[doc(hidden)]
pub type DisassociateFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateFleetInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFleet`](crate::operation::DisassociateFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.DisassociateFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFleetInput`](crate::input::DisassociateFleetInput)
    pub fn builder() -> crate::input::disassociate_fleet_input::Builder {
        crate::input::disassociate_fleet_input::Builder::default()
    }
}

/// See [`EnableUserInput`](crate::input::EnableUserInput)
pub mod enable_user_input {
    /// A builder for [`EnableUserInput`](crate::input::EnableUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
    }
    impl Builder {
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableUserInput`](crate::input::EnableUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableUserInput {
                user_name: self.user_name,
                authentication_type: self.authentication_type,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableUserInputOperationOutputAlias = crate::operation::EnableUser;
#[doc(hidden)]
pub type EnableUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableUserInput {
    /// Consumes the builder and constructs an Operation<[`EnableUser`](crate::operation::EnableUser)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::EnableUserInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EnableUserInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.EnableUser",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_enable_user(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableUser",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EnableUserInput`](crate::input::EnableUserInput)
    pub fn builder() -> crate::input::enable_user_input::Builder {
        crate::input::enable_user_input::Builder::default()
    }
}

/// See [`ExpireSessionInput`](crate::input::ExpireSessionInput)
pub mod expire_session_input {
    /// A builder for [`ExpireSessionInput`](crate::input::ExpireSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the streaming session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_id = Some(input.into());
            self
        }
        /// <p>The identifier of the streaming session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.session_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ExpireSessionInput`](crate::input::ExpireSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExpireSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExpireSessionInput {
                session_id: self.session_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ExpireSessionInputOperationOutputAlias = crate::operation::ExpireSession;
#[doc(hidden)]
pub type ExpireSessionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExpireSessionInput {
    /// Consumes the builder and constructs an Operation<[`ExpireSession`](crate::operation::ExpireSession)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExpireSession,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExpireSessionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExpireSessionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.ExpireSession",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_expire_session(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExpireSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExpireSession",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExpireSessionInput`](crate::input::ExpireSessionInput)
    pub fn builder() -> crate::input::expire_session_input::Builder {
        crate::input::expire_session_input::Builder::default()
    }
}

/// See [`ListAssociatedFleetsInput`](crate::input::ListAssociatedFleetsInput)
pub mod list_associated_fleets_input {
    /// A builder for [`ListAssociatedFleetsInput`](crate::input::ListAssociatedFleetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedFleetsInput`](crate::input::ListAssociatedFleetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociatedFleetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssociatedFleetsInput {
                stack_name: self.stack_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssociatedFleetsInputOperationOutputAlias = crate::operation::ListAssociatedFleets;
#[doc(hidden)]
pub type ListAssociatedFleetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAssociatedFleetsInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociatedFleets`](crate::operation::ListAssociatedFleets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociatedFleets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAssociatedFleetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAssociatedFleetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.ListAssociatedFleets",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_associated_fleets(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociatedFleets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociatedFleets",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAssociatedFleetsInput`](crate::input::ListAssociatedFleetsInput)
    pub fn builder() -> crate::input::list_associated_fleets_input::Builder {
        crate::input::list_associated_fleets_input::Builder::default()
    }
}

/// See [`ListAssociatedStacksInput`](crate::input::ListAssociatedStacksInput)
pub mod list_associated_stacks_input {
    /// A builder for [`ListAssociatedStacksInput`](crate::input::ListAssociatedStacksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedStacksInput`](crate::input::ListAssociatedStacksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociatedStacksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssociatedStacksInput {
                fleet_name: self.fleet_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssociatedStacksInputOperationOutputAlias = crate::operation::ListAssociatedStacks;
#[doc(hidden)]
pub type ListAssociatedStacksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAssociatedStacksInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociatedStacks`](crate::operation::ListAssociatedStacks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociatedStacks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAssociatedStacksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAssociatedStacksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.ListAssociatedStacks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_associated_stacks(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociatedStacks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociatedStacks",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAssociatedStacksInput`](crate::input::ListAssociatedStacksInput)
    pub fn builder() -> crate::input::list_associated_stacks_input::Builder {
        crate::input::list_associated_stacks_input::Builder::default()
    }
}

/// See [`ListEntitledApplicationsInput`](crate::input::ListEntitledApplicationsInput)
pub mod list_entitled_applications_input {
    /// A builder for [`ListEntitledApplicationsInput`](crate::input::ListEntitledApplicationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) entitlement_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn entitlement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_name = Some(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_entitlement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_name = input;
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitledApplicationsInput`](crate::input::ListEntitledApplicationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntitledApplicationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntitledApplicationsInput {
                stack_name: self.stack_name,
                entitlement_name: self.entitlement_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntitledApplicationsInputOperationOutputAlias =
    crate::operation::ListEntitledApplications;
#[doc(hidden)]
pub type ListEntitledApplicationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListEntitledApplicationsInput {
    /// Consumes the builder and constructs an Operation<[`ListEntitledApplications`](crate::operation::ListEntitledApplications)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntitledApplications,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListEntitledApplicationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListEntitledApplicationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.ListEntitledApplications",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_entitled_applications(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntitledApplications::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntitledApplications",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListEntitledApplicationsInput`](crate::input::ListEntitledApplicationsInput)
    pub fn builder() -> crate::input::list_entitled_applications_input::Builder {
        crate::input::list_entitled_applications_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartFleetInput`](crate::input::StartFleetInput)
pub mod start_fleet_input {
    /// A builder for [`StartFleetInput`](crate::input::StartFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFleetInput`](crate::input::StartFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartFleetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StartFleetInputOperationOutputAlias = crate::operation::StartFleet;
#[doc(hidden)]
pub type StartFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartFleetInput {
    /// Consumes the builder and constructs an Operation<[`StartFleet`](crate::operation::StartFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.StartFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartFleetInput`](crate::input::StartFleetInput)
    pub fn builder() -> crate::input::start_fleet_input::Builder {
        crate::input::start_fleet_input::Builder::default()
    }
}

/// See [`StartImageBuilderInput`](crate::input::StartImageBuilderInput)
pub mod start_image_builder_input {
    /// A builder for [`StartImageBuilderInput`](crate::input::StartImageBuilderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) appstream_agent_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn appstream_agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.appstream_agent_version = Some(input.into());
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.appstream_agent_version = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImageBuilderInput`](crate::input::StartImageBuilderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartImageBuilderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartImageBuilderInput {
                name: self.name,
                appstream_agent_version: self.appstream_agent_version,
            })
        }
    }
}
#[doc(hidden)]
pub type StartImageBuilderInputOperationOutputAlias = crate::operation::StartImageBuilder;
#[doc(hidden)]
pub type StartImageBuilderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartImageBuilderInput {
    /// Consumes the builder and constructs an Operation<[`StartImageBuilder`](crate::operation::StartImageBuilder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartImageBuilder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartImageBuilderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartImageBuilderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.StartImageBuilder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_image_builder(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartImageBuilder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartImageBuilder",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartImageBuilderInput`](crate::input::StartImageBuilderInput)
    pub fn builder() -> crate::input::start_image_builder_input::Builder {
        crate::input::start_image_builder_input::Builder::default()
    }
}

/// See [`StopFleetInput`](crate::input::StopFleetInput)
pub mod stop_fleet_input {
    /// A builder for [`StopFleetInput`](crate::input::StopFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFleetInput`](crate::input::StopFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopFleetInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopFleetInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StopFleetInputOperationOutputAlias = crate::operation::StopFleet;
#[doc(hidden)]
pub type StopFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopFleetInput {
    /// Consumes the builder and constructs an Operation<[`StopFleet`](crate::operation::StopFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.StopFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopFleet::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopFleet",
                    "appstream",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopFleetInput`](crate::input::StopFleetInput)
    pub fn builder() -> crate::input::stop_fleet_input::Builder {
        crate::input::stop_fleet_input::Builder::default()
    }
}

/// See [`StopImageBuilderInput`](crate::input::StopImageBuilderInput)
pub mod stop_image_builder_input {
    /// A builder for [`StopImageBuilderInput`](crate::input::StopImageBuilderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`StopImageBuilderInput`](crate::input::StopImageBuilderInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopImageBuilderInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopImageBuilderInput { name: self.name })
        }
    }
}
#[doc(hidden)]
pub type StopImageBuilderInputOperationOutputAlias = crate::operation::StopImageBuilder;
#[doc(hidden)]
pub type StopImageBuilderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopImageBuilderInput {
    /// Consumes the builder and constructs an Operation<[`StopImageBuilder`](crate::operation::StopImageBuilder)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopImageBuilder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopImageBuilderInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopImageBuilderInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.StopImageBuilder",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_stop_image_builder(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopImageBuilder::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopImageBuilder",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopImageBuilderInput`](crate::input::StopImageBuilderInput)
    pub fn builder() -> crate::input::stop_image_builder_input::Builder {
        crate::input::stop_image_builder_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys for the tags to disassociate.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys for the tags to disassociate.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
pub mod update_application_input {
    /// A builder for [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) icon_s3_location: std::option::Option<crate::model::S3Location>,
        pub(crate) launch_path: std::option::Option<std::string::String>,
        pub(crate) working_directory: std::option::Option<std::string::String>,
        pub(crate) launch_parameters: std::option::Option<std::string::String>,
        pub(crate) app_block_arn: std::option::Option<std::string::String>,
        pub(crate) attributes_to_delete:
            std::option::Option<std::vec::Vec<crate::model::ApplicationAttribute>>,
    }
    impl Builder {
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The icon S3 location of the application.</p>
        pub fn icon_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.icon_s3_location = Some(input);
            self
        }
        /// <p>The icon S3 location of the application.</p>
        pub fn set_icon_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.icon_s3_location = input;
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_path = Some(input.into());
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn set_launch_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_path = input;
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.working_directory = Some(input.into());
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.working_directory = input;
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn launch_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_parameters = Some(input.into());
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn set_launch_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_parameters = input;
            self
        }
        /// <p>The ARN of the app block.</p>
        pub fn app_block_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.app_block_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the app block.</p>
        pub fn set_app_block_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.app_block_arn = input;
            self
        }
        /// Appends an item to `attributes_to_delete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The attributes to delete for an application.</p>
        pub fn attributes_to_delete(mut self, input: crate::model::ApplicationAttribute) -> Self {
            let mut v = self.attributes_to_delete.unwrap_or_default();
            v.push(input);
            self.attributes_to_delete = Some(v);
            self
        }
        /// <p>The attributes to delete for an application.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationAttribute>>,
        ) -> Self {
            self.attributes_to_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApplicationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApplicationInput {
                name: self.name,
                display_name: self.display_name,
                description: self.description,
                icon_s3_location: self.icon_s3_location,
                launch_path: self.launch_path,
                working_directory: self.working_directory,
                launch_parameters: self.launch_parameters,
                app_block_arn: self.app_block_arn,
                attributes_to_delete: self.attributes_to_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApplicationInputOperationOutputAlias = crate::operation::UpdateApplication;
#[doc(hidden)]
pub type UpdateApplicationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApplicationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApplication`](crate::operation::UpdateApplication)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApplication,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateApplicationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateApplicationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.UpdateApplication",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_application(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApplication::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApplication",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateApplicationInput`](crate::input::UpdateApplicationInput)
    pub fn builder() -> crate::input::update_application_input::Builder {
        crate::input::update_application_input::Builder::default()
    }
}

/// See [`UpdateDirectoryConfigInput`](crate::input::UpdateDirectoryConfigInput)
pub mod update_directory_config_input {
    /// A builder for [`UpdateDirectoryConfigInput`](crate::input::UpdateDirectoryConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_name: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_account_credentials:
            std::option::Option<crate::model::ServiceAccountCredentials>,
    }
    impl Builder {
        /// <p>The name of the Directory Config object.</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_name = Some(input.into());
            self
        }
        /// <p>The name of the Directory Config object.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// Appends an item to `organizational_unit_distinguished_names`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_distinguished_names`](Self::set_organizational_unit_distinguished_names).
        ///
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn organizational_unit_distinguished_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .organizational_unit_distinguished_names
                .unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_distinguished_names = Some(v);
            self
        }
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_distinguished_names = input;
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn service_account_credentials(
            mut self,
            input: crate::model::ServiceAccountCredentials,
        ) -> Self {
            self.service_account_credentials = Some(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn set_service_account_credentials(
            mut self,
            input: std::option::Option<crate::model::ServiceAccountCredentials>,
        ) -> Self {
            self.service_account_credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDirectoryConfigInput`](crate::input::UpdateDirectoryConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDirectoryConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDirectoryConfigInput {
                directory_name: self.directory_name,
                organizational_unit_distinguished_names: self
                    .organizational_unit_distinguished_names,
                service_account_credentials: self.service_account_credentials,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDirectoryConfigInputOperationOutputAlias = crate::operation::UpdateDirectoryConfig;
#[doc(hidden)]
pub type UpdateDirectoryConfigInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDirectoryConfigInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDirectoryConfig`](crate::operation::UpdateDirectoryConfig)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDirectoryConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDirectoryConfigInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDirectoryConfigInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.UpdateDirectoryConfig",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_directory_config(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDirectoryConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDirectoryConfig",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDirectoryConfigInput`](crate::input::UpdateDirectoryConfigInput)
    pub fn builder() -> crate::input::update_directory_config_input::Builder {
        crate::input::update_directory_config_input::Builder::default()
    }
}

/// See [`UpdateEntitlementInput`](crate::input::UpdateEntitlementInput)
pub mod update_entitlement_input {
    /// A builder for [`UpdateEntitlementInput`](crate::input::UpdateEntitlementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) app_visibility: std::option::Option<crate::model::AppVisibility>,
        pub(crate) attributes:
            std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
    }
    impl Builder {
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies whether all or only selected apps are entitled.</p>
        pub fn app_visibility(mut self, input: crate::model::AppVisibility) -> Self {
            self.app_visibility = Some(input);
            self
        }
        /// <p>Specifies whether all or only selected apps are entitled.</p>
        pub fn set_app_visibility(
            mut self,
            input: std::option::Option<crate::model::AppVisibility>,
        ) -> Self {
            self.app_visibility = input;
            self
        }
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes of the entitlement.</p>
        pub fn attributes(mut self, input: crate::model::EntitlementAttribute) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input);
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes of the entitlement.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEntitlementInput`](crate::input::UpdateEntitlementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEntitlementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEntitlementInput {
                name: self.name,
                stack_name: self.stack_name,
                description: self.description,
                app_visibility: self.app_visibility,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEntitlementInputOperationOutputAlias = crate::operation::UpdateEntitlement;
#[doc(hidden)]
pub type UpdateEntitlementInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateEntitlementInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEntitlement`](crate::operation::UpdateEntitlement)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEntitlement,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateEntitlementInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateEntitlementInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.UpdateEntitlement",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_entitlement(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEntitlement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEntitlement",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateEntitlementInput`](crate::input::UpdateEntitlementInput)
    pub fn builder() -> crate::input::update_entitlement_input::Builder {
        crate::input::update_entitlement_input::Builder::default()
    }
}

/// See [`UpdateFleetInput`](crate::input::UpdateFleetInput)
pub mod update_fleet_input {
    /// A builder for [`UpdateFleetInput`](crate::input::UpdateFleetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) compute_capacity: std::option::Option<crate::model::ComputeCapacity>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) max_user_duration_in_seconds: std::option::Option<i32>,
        pub(crate) disconnect_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) delete_vpc_config: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) enable_default_internet_access: std::option::Option<bool>,
        pub(crate) domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
        pub(crate) idle_disconnect_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) attributes_to_delete:
            std::option::Option<std::vec::Vec<crate::model::FleetAttribute>>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) stream_view: std::option::Option<crate::model::StreamView>,
        pub(crate) platform: std::option::Option<crate::model::PlatformType>,
        pub(crate) max_concurrent_sessions: std::option::Option<i32>,
        pub(crate) usb_device_filter_strings:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the image used to create the fleet.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets.</p>
        pub fn compute_capacity(mut self, input: crate::model::ComputeCapacity) -> Self {
            self.compute_capacity = Some(input);
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets.</p>
        pub fn set_compute_capacity(
            mut self,
            input: std::option::Option<crate::model::ComputeCapacity>,
        ) -> Self {
            self.compute_capacity = input;
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn max_user_duration_in_seconds(mut self, input: i32) -> Self {
            self.max_user_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn set_max_user_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_user_duration_in_seconds = input;
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.disconnect_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn set_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.disconnect_timeout_in_seconds = input;
            self
        }
        /// <p>Deletes the VPC association for the specified fleet.</p>
        pub fn delete_vpc_config(mut self, input: bool) -> Self {
            self.delete_vpc_config = Some(input);
            self
        }
        /// <p>Deletes the VPC association for the specified fleet.</p>
        pub fn set_delete_vpc_config(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_vpc_config = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.enable_default_internet_access = Some(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_default_internet_access = input;
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.domain_join_info = Some(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.domain_join_info = input;
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn idle_disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.idle_disconnect_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn set_idle_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.idle_disconnect_timeout_in_seconds = input;
            self
        }
        /// Appends an item to `attributes_to_delete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The fleet attributes to delete.</p>
        pub fn attributes_to_delete(mut self, input: crate::model::FleetAttribute) -> Self {
            let mut v = self.attributes_to_delete.unwrap_or_default();
            v.push(input);
            self.attributes_to_delete = Some(v);
            self
        }
        /// <p>The fleet attributes to delete.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAttribute>>,
        ) -> Self {
            self.attributes_to_delete = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn stream_view(mut self, input: crate::model::StreamView) -> Self {
            self.stream_view = Some(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn set_stream_view(
            mut self,
            input: std::option::Option<crate::model::StreamView>,
        ) -> Self {
            self.stream_view = input;
            self
        }
        /// <p>The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn platform(mut self, input: crate::model::PlatformType) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformType>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>The maximum number of concurrent sessions for a fleet.</p>
        pub fn max_concurrent_sessions(mut self, input: i32) -> Self {
            self.max_concurrent_sessions = Some(input);
            self
        }
        /// <p>The maximum number of concurrent sessions for a fleet.</p>
        pub fn set_max_concurrent_sessions(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrent_sessions = input;
            self
        }
        /// Appends an item to `usb_device_filter_strings`.
        ///
        /// To override the contents of this collection use [`set_usb_device_filter_strings`](Self::set_usb_device_filter_strings).
        ///
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn usb_device_filter_strings(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.usb_device_filter_strings.unwrap_or_default();
            v.push(input.into());
            self.usb_device_filter_strings = Some(v);
            self
        }
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn set_usb_device_filter_strings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.usb_device_filter_strings = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetInput`](crate::input::UpdateFleetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFleetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFleetInput {
                image_name: self.image_name,
                image_arn: self.image_arn,
                name: self.name,
                instance_type: self.instance_type,
                compute_capacity: self.compute_capacity,
                vpc_config: self.vpc_config,
                max_user_duration_in_seconds: self.max_user_duration_in_seconds,
                disconnect_timeout_in_seconds: self.disconnect_timeout_in_seconds,
                delete_vpc_config: self.delete_vpc_config.unwrap_or_default(),
                description: self.description,
                display_name: self.display_name,
                enable_default_internet_access: self.enable_default_internet_access,
                domain_join_info: self.domain_join_info,
                idle_disconnect_timeout_in_seconds: self.idle_disconnect_timeout_in_seconds,
                attributes_to_delete: self.attributes_to_delete,
                iam_role_arn: self.iam_role_arn,
                stream_view: self.stream_view,
                platform: self.platform,
                max_concurrent_sessions: self.max_concurrent_sessions,
                usb_device_filter_strings: self.usb_device_filter_strings,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFleetInputOperationOutputAlias = crate::operation::UpdateFleet;
#[doc(hidden)]
pub type UpdateFleetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateFleetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFleet`](crate::operation::UpdateFleet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFleet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateFleetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateFleetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.UpdateFleet",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_fleet(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFleet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFleet",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateFleetInput`](crate::input::UpdateFleetInput)
    pub fn builder() -> crate::input::update_fleet_input::Builder {
        crate::input::update_fleet_input::Builder::default()
    }
}

/// See [`UpdateImagePermissionsInput`](crate::input::UpdateImagePermissionsInput)
pub mod update_image_permissions_input {
    /// A builder for [`UpdateImagePermissionsInput`](crate::input::UpdateImagePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) shared_account_id: std::option::Option<std::string::String>,
        pub(crate) image_permissions: std::option::Option<crate::model::ImagePermissions>,
    }
    impl Builder {
        /// <p>The name of the private image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the private image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_account_id = input;
            self
        }
        /// <p>The permissions for the image.</p>
        pub fn image_permissions(mut self, input: crate::model::ImagePermissions) -> Self {
            self.image_permissions = Some(input);
            self
        }
        /// <p>The permissions for the image.</p>
        pub fn set_image_permissions(
            mut self,
            input: std::option::Option<crate::model::ImagePermissions>,
        ) -> Self {
            self.image_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateImagePermissionsInput`](crate::input::UpdateImagePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateImagePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateImagePermissionsInput {
                name: self.name,
                shared_account_id: self.shared_account_id,
                image_permissions: self.image_permissions,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateImagePermissionsInputOperationOutputAlias = crate::operation::UpdateImagePermissions;
#[doc(hidden)]
pub type UpdateImagePermissionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateImagePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateImagePermissions`](crate::operation::UpdateImagePermissions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateImagePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateImagePermissionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateImagePermissionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.UpdateImagePermissions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_image_permissions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateImagePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateImagePermissions",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateImagePermissionsInput`](crate::input::UpdateImagePermissionsInput)
    pub fn builder() -> crate::input::update_image_permissions_input::Builder {
        crate::input::update_image_permissions_input::Builder::default()
    }
}

/// See [`UpdateStackInput`](crate::input::UpdateStackInput)
pub mod update_stack_input {
    /// A builder for [`UpdateStackInput`](crate::input::UpdateStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) storage_connectors:
            std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        pub(crate) delete_storage_connectors: std::option::Option<bool>,
        pub(crate) redirect_url: std::option::Option<std::string::String>,
        pub(crate) feedback_url: std::option::Option<std::string::String>,
        pub(crate) attributes_to_delete:
            std::option::Option<std::vec::Vec<crate::model::StackAttribute>>,
        pub(crate) user_settings: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        pub(crate) application_settings: std::option::Option<crate::model::ApplicationSettings>,
        pub(crate) access_endpoints:
            std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        pub(crate) embed_host_domains: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The stack name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The stack name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `storage_connectors`.
        ///
        /// To override the contents of this collection use [`set_storage_connectors`](Self::set_storage_connectors).
        ///
        /// <p>The storage connectors to enable.</p>
        pub fn storage_connectors(mut self, input: crate::model::StorageConnector) -> Self {
            let mut v = self.storage_connectors.unwrap_or_default();
            v.push(input);
            self.storage_connectors = Some(v);
            self
        }
        /// <p>The storage connectors to enable.</p>
        pub fn set_storage_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        ) -> Self {
            self.storage_connectors = input;
            self
        }
        /// <p>Deletes the storage connectors currently enabled for the stack.</p>
        pub fn delete_storage_connectors(mut self, input: bool) -> Self {
            self.delete_storage_connectors = Some(input);
            self
        }
        /// <p>Deletes the storage connectors currently enabled for the stack.</p>
        pub fn set_delete_storage_connectors(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_storage_connectors = input;
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn redirect_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.redirect_url = Some(input.into());
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn set_redirect_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.redirect_url = input;
            self
        }
        /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn feedback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.feedback_url = Some(input.into());
            self
        }
        /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn set_feedback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feedback_url = input;
            self
        }
        /// Appends an item to `attributes_to_delete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The stack attributes to delete.</p>
        pub fn attributes_to_delete(mut self, input: crate::model::StackAttribute) -> Self {
            let mut v = self.attributes_to_delete.unwrap_or_default();
            v.push(input);
            self.attributes_to_delete = Some(v);
            self
        }
        /// <p>The stack attributes to delete.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackAttribute>>,
        ) -> Self {
            self.attributes_to_delete = input;
            self
        }
        /// Appends an item to `user_settings`.
        ///
        /// To override the contents of this collection use [`set_user_settings`](Self::set_user_settings).
        ///
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
        pub fn user_settings(mut self, input: crate::model::UserSetting) -> Self {
            let mut v = self.user_settings.unwrap_or_default();
            v.push(input);
            self.user_settings = Some(v);
            self
        }
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        ) -> Self {
            self.user_settings = input;
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn application_settings(mut self, input: crate::model::ApplicationSettings) -> Self {
            self.application_settings = Some(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn set_application_settings(
            mut self,
            input: std::option::Option<crate::model::ApplicationSettings>,
        ) -> Self {
            self.application_settings = input;
            self
        }
        /// Appends an item to `access_endpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, input: crate::model::AccessEndpoint) -> Self {
            let mut v = self.access_endpoints.unwrap_or_default();
            v.push(input);
            self.access_endpoints = Some(v);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.access_endpoints = input;
            self
        }
        /// Appends an item to `embed_host_domains`.
        ///
        /// To override the contents of this collection use [`set_embed_host_domains`](Self::set_embed_host_domains).
        ///
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn embed_host_domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.embed_host_domains.unwrap_or_default();
            v.push(input.into());
            self.embed_host_domains = Some(v);
            self
        }
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn set_embed_host_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.embed_host_domains = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStackInput`](crate::input::UpdateStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateStackInput {
                display_name: self.display_name,
                description: self.description,
                name: self.name,
                storage_connectors: self.storage_connectors,
                delete_storage_connectors: self.delete_storage_connectors.unwrap_or_default(),
                redirect_url: self.redirect_url,
                feedback_url: self.feedback_url,
                attributes_to_delete: self.attributes_to_delete,
                user_settings: self.user_settings,
                application_settings: self.application_settings,
                access_endpoints: self.access_endpoints,
                embed_host_domains: self.embed_host_domains,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateStackInputOperationOutputAlias = crate::operation::UpdateStack;
#[doc(hidden)]
pub type UpdateStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateStackInput {
    /// Consumes the builder and constructs an Operation<[`UpdateStack`](crate::operation::UpdateStack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateStackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateStackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "PhotonAdminProxyService.UpdateStack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_stack(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateStack",
            "appstream",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateStackInput`](crate::input::UpdateStackInput)
    pub fn builder() -> crate::input::update_stack_input::Builder {
        crate::input::update_stack_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStackInput {
    /// <p>The stack name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the stack.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The storage connectors to enable.</p>
    pub storage_connectors: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
    /// <p>Deletes the storage connectors currently enabled for the stack.</p>
    pub delete_storage_connectors: bool,
    /// <p>The URL that users are redirected to after their streaming session ends.</p>
    pub redirect_url: std::option::Option<std::string::String>,
    /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    pub feedback_url: std::option::Option<std::string::String>,
    /// <p>The stack attributes to delete.</p>
    pub attributes_to_delete: std::option::Option<std::vec::Vec<crate::model::StackAttribute>>,
    /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
    pub user_settings: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
    /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
    pub application_settings: std::option::Option<crate::model::ApplicationSettings>,
    /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
    pub access_endpoints: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
    /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
    pub embed_host_domains: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateStackInput {
    /// <p>The stack name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the stack.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The storage connectors to enable.</p>
    pub fn storage_connectors(&self) -> std::option::Option<&[crate::model::StorageConnector]> {
        self.storage_connectors.as_deref()
    }
    /// <p>Deletes the storage connectors currently enabled for the stack.</p>
    pub fn delete_storage_connectors(&self) -> bool {
        self.delete_storage_connectors
    }
    /// <p>The URL that users are redirected to after their streaming session ends.</p>
    pub fn redirect_url(&self) -> std::option::Option<&str> {
        self.redirect_url.as_deref()
    }
    /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    pub fn feedback_url(&self) -> std::option::Option<&str> {
        self.feedback_url.as_deref()
    }
    /// <p>The stack attributes to delete.</p>
    pub fn attributes_to_delete(&self) -> std::option::Option<&[crate::model::StackAttribute]> {
        self.attributes_to_delete.as_deref()
    }
    /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
    pub fn user_settings(&self) -> std::option::Option<&[crate::model::UserSetting]> {
        self.user_settings.as_deref()
    }
    /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
    pub fn application_settings(&self) -> std::option::Option<&crate::model::ApplicationSettings> {
        self.application_settings.as_ref()
    }
    /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
    pub fn access_endpoints(&self) -> std::option::Option<&[crate::model::AccessEndpoint]> {
        self.access_endpoints.as_deref()
    }
    /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
    pub fn embed_host_domains(&self) -> std::option::Option<&[std::string::String]> {
        self.embed_host_domains.as_deref()
    }
}
impl std::fmt::Debug for UpdateStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStackInput");
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("name", &self.name);
        formatter.field("storage_connectors", &self.storage_connectors);
        formatter.field("delete_storage_connectors", &self.delete_storage_connectors);
        formatter.field("redirect_url", &self.redirect_url);
        formatter.field("feedback_url", &self.feedback_url);
        formatter.field("attributes_to_delete", &self.attributes_to_delete);
        formatter.field("user_settings", &self.user_settings);
        formatter.field("application_settings", &self.application_settings);
        formatter.field("access_endpoints", &self.access_endpoints);
        formatter.field("embed_host_domains", &self.embed_host_domains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateImagePermissionsInput {
    /// <p>The name of the private image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
    pub shared_account_id: std::option::Option<std::string::String>,
    /// <p>The permissions for the image.</p>
    pub image_permissions: std::option::Option<crate::model::ImagePermissions>,
}
impl UpdateImagePermissionsInput {
    /// <p>The name of the private image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
    pub fn shared_account_id(&self) -> std::option::Option<&str> {
        self.shared_account_id.as_deref()
    }
    /// <p>The permissions for the image.</p>
    pub fn image_permissions(&self) -> std::option::Option<&crate::model::ImagePermissions> {
        self.image_permissions.as_ref()
    }
}
impl std::fmt::Debug for UpdateImagePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateImagePermissionsInput");
        formatter.field("name", &self.name);
        formatter.field("shared_account_id", &self.shared_account_id);
        formatter.field("image_permissions", &self.image_permissions);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetInput {
    /// <p>The name of the image used to create the fleet.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the public, private, or shared image to use.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>A unique name for the fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// <li> <p>stream.standard.large</p> </li>
    /// <li> <p>stream.compute.large</p> </li>
    /// <li> <p>stream.compute.xlarge</p> </li>
    /// <li> <p>stream.compute.2xlarge</p> </li>
    /// <li> <p>stream.compute.4xlarge</p> </li>
    /// <li> <p>stream.compute.8xlarge</p> </li>
    /// <li> <p>stream.memory.large</p> </li>
    /// <li> <p>stream.memory.xlarge</p> </li>
    /// <li> <p>stream.memory.2xlarge</p> </li>
    /// <li> <p>stream.memory.4xlarge</p> </li>
    /// <li> <p>stream.memory.8xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.large</p> </li>
    /// <li> <p>stream.memory.z1d.xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
    /// <li> <p>stream.graphics-design.large</p> </li>
    /// <li> <p>stream.graphics-design.xlarge</p> </li>
    /// <li> <p>stream.graphics-design.2xlarge</p> </li>
    /// <li> <p>stream.graphics-design.4xlarge</p> </li>
    /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
    /// </ul>
    /// <p>The following instance types are available for Elastic fleets:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// </ul>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets.</p>
    pub compute_capacity: std::option::Option<crate::model::ComputeCapacity>,
    /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones. </p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
    /// <p>Specify a value between 600 and 360000.</p>
    pub max_user_duration_in_seconds: std::option::Option<i32>,
    /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
    /// <p>Specify a value between 60 and 360000.</p>
    pub disconnect_timeout_in_seconds: std::option::Option<i32>,
    /// <p>Deletes the VPC association for the specified fleet.</p>
    pub delete_vpc_config: bool,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The fleet name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>Enables or disables default internet access for the fleet.</p>
    pub enable_default_internet_access: std::option::Option<bool>,
    /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
    pub domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
    /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p>
    /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
    /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
    /// </note>
    pub idle_disconnect_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The fleet attributes to delete.</p>
    pub attributes_to_delete: std::option::Option<std::vec::Vec<crate::model::FleetAttribute>>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
    /// <p>The default value is <code>APP</code>.</p>
    pub stream_view: std::option::Option<crate::model::StreamView>,
    /// <p>The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
    pub platform: std::option::Option<crate::model::PlatformType>,
    /// <p>The maximum number of concurrent sessions for a fleet.</p>
    pub max_concurrent_sessions: std::option::Option<i32>,
    /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
    pub usb_device_filter_strings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateFleetInput {
    /// <p>The name of the image used to create the fleet.</p>
    pub fn image_name(&self) -> std::option::Option<&str> {
        self.image_name.as_deref()
    }
    /// <p>The ARN of the public, private, or shared image to use.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>A unique name for the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// <li> <p>stream.standard.large</p> </li>
    /// <li> <p>stream.compute.large</p> </li>
    /// <li> <p>stream.compute.xlarge</p> </li>
    /// <li> <p>stream.compute.2xlarge</p> </li>
    /// <li> <p>stream.compute.4xlarge</p> </li>
    /// <li> <p>stream.compute.8xlarge</p> </li>
    /// <li> <p>stream.memory.large</p> </li>
    /// <li> <p>stream.memory.xlarge</p> </li>
    /// <li> <p>stream.memory.2xlarge</p> </li>
    /// <li> <p>stream.memory.4xlarge</p> </li>
    /// <li> <p>stream.memory.8xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.large</p> </li>
    /// <li> <p>stream.memory.z1d.xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
    /// <li> <p>stream.graphics-design.large</p> </li>
    /// <li> <p>stream.graphics-design.xlarge</p> </li>
    /// <li> <p>stream.graphics-design.2xlarge</p> </li>
    /// <li> <p>stream.graphics-design.4xlarge</p> </li>
    /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
    /// </ul>
    /// <p>The following instance types are available for Elastic fleets:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// </ul>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets.</p>
    pub fn compute_capacity(&self) -> std::option::Option<&crate::model::ComputeCapacity> {
        self.compute_capacity.as_ref()
    }
    /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones. </p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
    /// <p>Specify a value between 600 and 360000.</p>
    pub fn max_user_duration_in_seconds(&self) -> std::option::Option<i32> {
        self.max_user_duration_in_seconds
    }
    /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
    /// <p>Specify a value between 60 and 360000.</p>
    pub fn disconnect_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.disconnect_timeout_in_seconds
    }
    /// <p>Deletes the VPC association for the specified fleet.</p>
    pub fn delete_vpc_config(&self) -> bool {
        self.delete_vpc_config
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The fleet name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>Enables or disables default internet access for the fleet.</p>
    pub fn enable_default_internet_access(&self) -> std::option::Option<bool> {
        self.enable_default_internet_access
    }
    /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
    pub fn domain_join_info(&self) -> std::option::Option<&crate::model::DomainJoinInfo> {
        self.domain_join_info.as_ref()
    }
    /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p>
    /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
    /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
    /// </note>
    pub fn idle_disconnect_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_disconnect_timeout_in_seconds
    }
    /// <p>The fleet attributes to delete.</p>
    pub fn attributes_to_delete(&self) -> std::option::Option<&[crate::model::FleetAttribute]> {
        self.attributes_to_delete.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
    /// <p>The default value is <code>APP</code>.</p>
    pub fn stream_view(&self) -> std::option::Option<&crate::model::StreamView> {
        self.stream_view.as_ref()
    }
    /// <p>The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
    pub fn platform(&self) -> std::option::Option<&crate::model::PlatformType> {
        self.platform.as_ref()
    }
    /// <p>The maximum number of concurrent sessions for a fleet.</p>
    pub fn max_concurrent_sessions(&self) -> std::option::Option<i32> {
        self.max_concurrent_sessions
    }
    /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
    pub fn usb_device_filter_strings(&self) -> std::option::Option<&[std::string::String]> {
        self.usb_device_filter_strings.as_deref()
    }
}
impl std::fmt::Debug for UpdateFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetInput");
        formatter.field("image_name", &self.image_name);
        formatter.field("image_arn", &self.image_arn);
        formatter.field("name", &self.name);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("compute_capacity", &self.compute_capacity);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field(
            "max_user_duration_in_seconds",
            &self.max_user_duration_in_seconds,
        );
        formatter.field(
            "disconnect_timeout_in_seconds",
            &self.disconnect_timeout_in_seconds,
        );
        formatter.field("delete_vpc_config", &self.delete_vpc_config);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field(
            "enable_default_internet_access",
            &self.enable_default_internet_access,
        );
        formatter.field("domain_join_info", &self.domain_join_info);
        formatter.field(
            "idle_disconnect_timeout_in_seconds",
            &self.idle_disconnect_timeout_in_seconds,
        );
        formatter.field("attributes_to_delete", &self.attributes_to_delete);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("stream_view", &self.stream_view);
        formatter.field("platform", &self.platform);
        formatter.field("max_concurrent_sessions", &self.max_concurrent_sessions);
        formatter.field("usb_device_filter_strings", &self.usb_device_filter_strings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEntitlementInput {
    /// <p>The name of the entitlement.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The description of the entitlement.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether all or only selected apps are entitled.</p>
    pub app_visibility: std::option::Option<crate::model::AppVisibility>,
    /// <p>The attributes of the entitlement.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
}
impl UpdateEntitlementInput {
    /// <p>The name of the entitlement.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The description of the entitlement.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether all or only selected apps are entitled.</p>
    pub fn app_visibility(&self) -> std::option::Option<&crate::model::AppVisibility> {
        self.app_visibility.as_ref()
    }
    /// <p>The attributes of the entitlement.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::EntitlementAttribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for UpdateEntitlementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEntitlementInput");
        formatter.field("name", &self.name);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("description", &self.description);
        formatter.field("app_visibility", &self.app_visibility);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDirectoryConfigInput {
    /// <p>The name of the Directory Config object.</p>
    pub directory_name: std::option::Option<std::string::String>,
    /// <p>The distinguished names of the organizational units for computer accounts.</p>
    pub organizational_unit_distinguished_names:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    pub service_account_credentials: std::option::Option<crate::model::ServiceAccountCredentials>,
}
impl UpdateDirectoryConfigInput {
    /// <p>The name of the Directory Config object.</p>
    pub fn directory_name(&self) -> std::option::Option<&str> {
        self.directory_name.as_deref()
    }
    /// <p>The distinguished names of the organizational units for computer accounts.</p>
    pub fn organizational_unit_distinguished_names(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_distinguished_names.as_deref()
    }
    /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    pub fn service_account_credentials(
        &self,
    ) -> std::option::Option<&crate::model::ServiceAccountCredentials> {
        self.service_account_credentials.as_ref()
    }
}
impl std::fmt::Debug for UpdateDirectoryConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDirectoryConfigInput");
        formatter.field("directory_name", &self.directory_name);
        formatter.field(
            "organizational_unit_distinguished_names",
            &self.organizational_unit_distinguished_names,
        );
        formatter.field(
            "service_account_credentials",
            &self.service_account_credentials,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApplicationInput {
    /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The icon S3 location of the application.</p>
    pub icon_s3_location: std::option::Option<crate::model::S3Location>,
    /// <p>The launch path of the application.</p>
    pub launch_path: std::option::Option<std::string::String>,
    /// <p>The working directory of the application.</p>
    pub working_directory: std::option::Option<std::string::String>,
    /// <p>The launch parameters of the application.</p>
    pub launch_parameters: std::option::Option<std::string::String>,
    /// <p>The ARN of the app block.</p>
    pub app_block_arn: std::option::Option<std::string::String>,
    /// <p>The attributes to delete for an application.</p>
    pub attributes_to_delete:
        std::option::Option<std::vec::Vec<crate::model::ApplicationAttribute>>,
}
impl UpdateApplicationInput {
    /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The icon S3 location of the application.</p>
    pub fn icon_s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.icon_s3_location.as_ref()
    }
    /// <p>The launch path of the application.</p>
    pub fn launch_path(&self) -> std::option::Option<&str> {
        self.launch_path.as_deref()
    }
    /// <p>The working directory of the application.</p>
    pub fn working_directory(&self) -> std::option::Option<&str> {
        self.working_directory.as_deref()
    }
    /// <p>The launch parameters of the application.</p>
    pub fn launch_parameters(&self) -> std::option::Option<&str> {
        self.launch_parameters.as_deref()
    }
    /// <p>The ARN of the app block.</p>
    pub fn app_block_arn(&self) -> std::option::Option<&str> {
        self.app_block_arn.as_deref()
    }
    /// <p>The attributes to delete for an application.</p>
    pub fn attributes_to_delete(
        &self,
    ) -> std::option::Option<&[crate::model::ApplicationAttribute]> {
        self.attributes_to_delete.as_deref()
    }
}
impl std::fmt::Debug for UpdateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApplicationInput");
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("icon_s3_location", &self.icon_s3_location);
        formatter.field("launch_path", &self.launch_path);
        formatter.field("working_directory", &self.working_directory);
        formatter.field("launch_parameters", &self.launch_parameters);
        formatter.field("app_block_arn", &self.app_block_arn);
        formatter.field("attributes_to_delete", &self.attributes_to_delete);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys for the tags to disassociate.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys for the tags to disassociate.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopImageBuilderInput {
    /// <p>The name of the image builder.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StopImageBuilderInput {
    /// <p>The name of the image builder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StopImageBuilderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopImageBuilderInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFleetInput {
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StopFleetInput {
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StopFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFleetInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImageBuilderInput {
    /// <p>The name of the image builder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
    pub appstream_agent_version: std::option::Option<std::string::String>,
}
impl StartImageBuilderInput {
    /// <p>The name of the image builder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
    pub fn appstream_agent_version(&self) -> std::option::Option<&str> {
        self.appstream_agent_version.as_deref()
    }
}
impl std::fmt::Debug for StartImageBuilderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImageBuilderInput");
        formatter.field("name", &self.name);
        formatter.field("appstream_agent_version", &self.appstream_agent_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFleetInput {
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
}
impl StartFleetInput {
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for StartFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFleetInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitledApplicationsInput {
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the entitlement.</p>
    pub entitlement_name: std::option::Option<std::string::String>,
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEntitledApplicationsInput {
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The name of the entitlement.</p>
    pub fn entitlement_name(&self) -> std::option::Option<&str> {
        self.entitlement_name.as_deref()
    }
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEntitledApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitledApplicationsInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("entitlement_name", &self.entitlement_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedStacksInput {
    /// <p>The name of the fleet.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedStacksInput {
    /// <p>The name of the fleet.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedStacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedStacksInput");
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedFleetsInput {
    /// <p>The name of the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedFleetsInput {
    /// <p>The name of the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedFleetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedFleetsInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpireSessionInput {
    /// <p>The identifier of the streaming session.</p>
    pub session_id: std::option::Option<std::string::String>,
}
impl ExpireSessionInput {
    /// <p>The identifier of the streaming session.</p>
    pub fn session_id(&self) -> std::option::Option<&str> {
        self.session_id.as_deref()
    }
}
impl std::fmt::Debug for ExpireSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpireSessionInput");
        formatter.field("session_id", &self.session_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
    /// </note>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The authentication type for the user. You must specify USERPOOL.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
}
impl EnableUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
    /// </note>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The authentication type for the user. You must specify USERPOOL.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for EnableUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableUserInput");
        formatter.field("user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFleetInput {
    /// <p>The name of the fleet.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The name of the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
}
impl DisassociateFleetInput {
    /// <p>The name of the fleet.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The name of the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
}
impl std::fmt::Debug for DisassociateFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFleetInput");
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("stack_name", &self.stack_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateApplicationFromEntitlementInput {
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the entitlement.</p>
    pub entitlement_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the application to remove from the entitlement.</p>
    pub application_identifier: std::option::Option<std::string::String>,
}
impl DisassociateApplicationFromEntitlementInput {
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The name of the entitlement.</p>
    pub fn entitlement_name(&self) -> std::option::Option<&str> {
        self.entitlement_name.as_deref()
    }
    /// <p>The identifier of the application to remove from the entitlement.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
}
impl std::fmt::Debug for DisassociateApplicationFromEntitlementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateApplicationFromEntitlementInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("entitlement_name", &self.entitlement_name);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateApplicationFleetInput {
    /// <p>The name of the fleet.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
}
impl DisassociateApplicationFleetInput {
    /// <p>The name of the fleet.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The ARN of the application.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateApplicationFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateApplicationFleetInput");
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("application_arn", &self.application_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The authentication type for the user. You must specify USERPOOL.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
}
impl DisableUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The authentication type for the user. You must specify USERPOOL.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for DisableUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableUserInput");
        formatter.field("user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserStackAssociationsInput {
    /// <p>The name of the stack that is associated with the user.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The email address of the user who is associated with the stack.</p> <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeUserStackAssociationsInput {
    /// <p>The name of the stack that is associated with the user.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The email address of the user who is associated with the stack.</p> <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserStackAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserStackAssociationsInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersInput {
    /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeUsersInput {
    /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersInput");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsageReportSubscriptionsInput {
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeUsageReportSubscriptionsInput {
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsageReportSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsageReportSubscriptionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStacksInput {
    /// <p>The names of the stacks to describe.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeStacksInput {
    /// <p>The names of the stacks to describe.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeStacksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStacksInput");
        formatter.field("names", &self.names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSessionsInput {
    /// <p>The name of the stack. This value is case-sensitive.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the fleet. This value is case-sensitive.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
}
impl DescribeSessionsInput {
    /// <p>The name of the stack. This value is case-sensitive.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The name of the fleet. This value is case-sensitive.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for DescribeSessionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSessionsInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("user_id", &self.user_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagesInput {
    /// <p>The names of the public or private images to describe.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ARNs of the public, private, and shared images to describe.</p>
    pub arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The type of image (public, private, or shared) to describe. </p>
    pub r#type: std::option::Option<crate::model::VisibilityType>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeImagesInput {
    /// <p>The names of the public or private images to describe.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The ARNs of the public, private, and shared images to describe.</p>
    pub fn arns(&self) -> std::option::Option<&[std::string::String]> {
        self.arns.as_deref()
    }
    /// <p>The type of image (public, private, or shared) to describe. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::VisibilityType> {
        self.r#type.as_ref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeImagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagesInput");
        formatter.field("names", &self.names);
        formatter.field("arns", &self.arns);
        formatter.field("r#type", &self.r#type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagePermissionsInput {
    /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
    pub shared_aws_account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImagePermissionsInput {
    /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
    pub fn shared_aws_account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.shared_aws_account_ids.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImagePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagePermissionsInput");
        formatter.field("name", &self.name);
        formatter.field("max_results", &self.max_results);
        formatter.field("shared_aws_account_ids", &self.shared_aws_account_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageBuildersInput {
    /// <p>The names of the image builders to describe.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImageBuildersInput {
    /// <p>The names of the image builders to describe.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImageBuildersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageBuildersInput");
        formatter.field("names", &self.names);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetsInput {
    /// <p>The names of the fleets to describe.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFleetsInput {
    /// <p>The names of the fleets to describe.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetsInput");
        formatter.field("names", &self.names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEntitlementsInput {
    /// <p>The name of the entitlement.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeEntitlementsInput {
    /// <p>The name of the entitlement.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeEntitlementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEntitlementsInput");
        formatter.field("name", &self.name);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectoryConfigsInput {
    /// <p>The directory names.</p>
    pub directory_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDirectoryConfigsInput {
    /// <p>The directory names.</p>
    pub fn directory_names(&self) -> std::option::Option<&[std::string::String]> {
        self.directory_names.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDirectoryConfigsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectoryConfigsInput");
        formatter.field("directory_names", &self.directory_names);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationsInput {
    /// <p>The ARNs for the applications.</p>
    pub arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeApplicationsInput {
    /// <p>The ARNs for the applications.</p>
    pub fn arns(&self) -> std::option::Option<&[std::string::String]> {
        self.arns.as_deref()
    }
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeApplicationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationsInput");
        formatter.field("arns", &self.arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicationFleetAssociationsInput {
    /// <p>The name of the fleet.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeApplicationFleetAssociationsInput {
    /// <p>The name of the fleet.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The ARN of the application.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeApplicationFleetAssociationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicationFleetAssociationsInput");
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("application_arn", &self.application_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAppBlocksInput {
    /// <p>The ARNs of the app blocks.</p>
    pub arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum size of each page of results.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribeAppBlocksInput {
    /// <p>The ARNs of the app blocks.</p>
    pub fn arns(&self) -> std::option::Option<&[std::string::String]> {
        self.arns.as_deref()
    }
    /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum size of each page of results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribeAppBlocksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAppBlocksInput");
        formatter.field("arns", &self.arns);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The authentication type for the user. You must specify USERPOOL.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
}
impl DeleteUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The authentication type for the user. You must specify USERPOOL.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for DeleteUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserInput");
        formatter.field("user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUsageReportSubscriptionInput {}
impl std::fmt::Debug for DeleteUsageReportSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUsageReportSubscriptionInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStackInput {
    /// <p>The name of the stack.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteStackInput {
    /// <p>The name of the stack.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStackInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImagePermissionsInput {
    /// <p>The name of the private image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
    pub shared_account_id: std::option::Option<std::string::String>,
}
impl DeleteImagePermissionsInput {
    /// <p>The name of the private image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
    pub fn shared_account_id(&self) -> std::option::Option<&str> {
        self.shared_account_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteImagePermissionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImagePermissionsInput");
        formatter.field("name", &self.name);
        formatter.field("shared_account_id", &self.shared_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageBuilderInput {
    /// <p>The name of the image builder.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteImageBuilderInput {
    /// <p>The name of the image builder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteImageBuilderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageBuilderInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageInput {
    /// <p>The name of the image.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteImageInput {
    /// <p>The name of the image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFleetInput {
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteFleetInput {
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFleetInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEntitlementInput {
    /// <p>The name of the entitlement.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub stack_name: std::option::Option<std::string::String>,
}
impl DeleteEntitlementInput {
    /// <p>The name of the entitlement.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteEntitlementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEntitlementInput");
        formatter.field("name", &self.name);
        formatter.field("stack_name", &self.stack_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectoryConfigInput {
    /// <p>The name of the directory configuration.</p>
    pub directory_name: std::option::Option<std::string::String>,
}
impl DeleteDirectoryConfigInput {
    /// <p>The name of the directory configuration.</p>
    pub fn directory_name(&self) -> std::option::Option<&str> {
        self.directory_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDirectoryConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectoryConfigInput");
        formatter.field("directory_name", &self.directory_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApplicationInput {
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteApplicationInput {
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApplicationInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAppBlockInput {
    /// <p>The name of the app block.</p>
    pub name: std::option::Option<std::string::String>,
}
impl DeleteAppBlockInput {
    /// <p>The name of the app block.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAppBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAppBlockInput");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
    /// </note>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note>
    /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
    /// </note>
    pub message_action: std::option::Option<crate::model::MessageAction>,
    /// <p>The first name, or given name, of the user.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name, or surname, of the user.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The authentication type for the user. You must specify USERPOOL. </p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
}
impl CreateUserInput {
    /// <p>The email address of the user.</p> <note>
    /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
    /// </note>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note>
    /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
    /// </note>
    pub fn message_action(&self) -> std::option::Option<&crate::model::MessageAction> {
        self.message_action.as_ref()
    }
    /// <p>The first name, or given name, of the user.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>The last name, or surname, of the user.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>The authentication type for the user. You must specify USERPOOL. </p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for CreateUserInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserInput");
        formatter.field("user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("message_action", &self.message_action);
        formatter.field("first_name", &"*** Sensitive Data Redacted ***");
        formatter.field("last_name", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUsageReportSubscriptionInput {}
impl std::fmt::Debug for CreateUsageReportSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUsageReportSubscriptionInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUpdatedImageInput {
    /// <p>The name of the image to update.</p>
    pub existing_image_name: std::option::Option<std::string::String>,
    /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
    pub new_image_name: std::option::Option<std::string::String>,
    /// <p>The description to display for the new image.</p>
    pub new_image_description: std::option::Option<std::string::String>,
    /// <p>The name to display for the new image.</p>
    pub new_image_display_name: std::option::Option<std::string::String>,
    /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub new_image_tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
    pub dry_run: bool,
}
impl CreateUpdatedImageInput {
    /// <p>The name of the image to update.</p>
    pub fn existing_image_name(&self) -> std::option::Option<&str> {
        self.existing_image_name.as_deref()
    }
    /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
    pub fn new_image_name(&self) -> std::option::Option<&str> {
        self.new_image_name.as_deref()
    }
    /// <p>The description to display for the new image.</p>
    pub fn new_image_description(&self) -> std::option::Option<&str> {
        self.new_image_description.as_deref()
    }
    /// <p>The name to display for the new image.</p>
    pub fn new_image_display_name(&self) -> std::option::Option<&str> {
        self.new_image_display_name.as_deref()
    }
    /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn new_image_tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.new_image_tags.as_ref()
    }
    /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for CreateUpdatedImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUpdatedImageInput");
        formatter.field("existing_image_name", &self.existing_image_name);
        formatter.field("new_image_name", &self.new_image_name);
        formatter.field("new_image_description", &self.new_image_description);
        formatter.field("new_image_display_name", &self.new_image_display_name);
        formatter.field("new_image_tags", &self.new_image_tags);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingUrlInput {
    /// <p>The name of the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the fleet.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the user.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
    pub application_id: std::option::Option<std::string::String>,
    /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
    pub validity: std::option::Option<i64>,
    /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub session_context: std::option::Option<std::string::String>,
}
impl CreateStreamingUrlInput {
    /// <p>The name of the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The name of the fleet.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The identifier of the user.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
    pub fn application_id(&self) -> std::option::Option<&str> {
        self.application_id.as_deref()
    }
    /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
    pub fn validity(&self) -> std::option::Option<i64> {
        self.validity
    }
    /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn session_context(&self) -> std::option::Option<&str> {
        self.session_context.as_deref()
    }
}
impl std::fmt::Debug for CreateStreamingUrlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingUrlInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("user_id", &self.user_id);
        formatter.field("application_id", &self.application_id);
        formatter.field("validity", &self.validity);
        formatter.field("session_context", &self.session_context);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStackInput {
    /// <p>The name of the stack.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The stack name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The storage connectors to enable.</p>
    pub storage_connectors: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
    /// <p>The URL that users are redirected to after their streaming session ends.</p>
    pub redirect_url: std::option::Option<std::string::String>,
    /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    pub feedback_url: std::option::Option<std::string::String>,
    /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
    pub user_settings: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
    /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
    pub application_settings: std::option::Option<crate::model::ApplicationSettings>,
    /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
    pub access_endpoints: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
    /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
    pub embed_host_domains: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateStackInput {
    /// <p>The name of the stack.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The stack name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The storage connectors to enable.</p>
    pub fn storage_connectors(&self) -> std::option::Option<&[crate::model::StorageConnector]> {
        self.storage_connectors.as_deref()
    }
    /// <p>The URL that users are redirected to after their streaming session ends.</p>
    pub fn redirect_url(&self) -> std::option::Option<&str> {
        self.redirect_url.as_deref()
    }
    /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    pub fn feedback_url(&self) -> std::option::Option<&str> {
        self.feedback_url.as_deref()
    }
    /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
    pub fn user_settings(&self) -> std::option::Option<&[crate::model::UserSetting]> {
        self.user_settings.as_deref()
    }
    /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
    pub fn application_settings(&self) -> std::option::Option<&crate::model::ApplicationSettings> {
        self.application_settings.as_ref()
    }
    /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
    pub fn access_endpoints(&self) -> std::option::Option<&[crate::model::AccessEndpoint]> {
        self.access_endpoints.as_deref()
    }
    /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
    pub fn embed_host_domains(&self) -> std::option::Option<&[std::string::String]> {
        self.embed_host_domains.as_deref()
    }
}
impl std::fmt::Debug for CreateStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStackInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field("storage_connectors", &self.storage_connectors);
        formatter.field("redirect_url", &self.redirect_url);
        formatter.field("feedback_url", &self.feedback_url);
        formatter.field("user_settings", &self.user_settings);
        formatter.field("application_settings", &self.application_settings);
        formatter.field("tags", &self.tags);
        formatter.field("access_endpoints", &self.access_endpoints);
        formatter.field("embed_host_domains", &self.embed_host_domains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageBuilderStreamingUrlInput {
    /// <p>The name of the image builder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
    pub validity: std::option::Option<i64>,
}
impl CreateImageBuilderStreamingUrlInput {
    /// <p>The name of the image builder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
    pub fn validity(&self) -> std::option::Option<i64> {
        self.validity
    }
}
impl std::fmt::Debug for CreateImageBuilderStreamingUrlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageBuilderStreamingUrlInput");
        formatter.field("name", &self.name);
        formatter.field("validity", &self.validity);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageBuilderInput {
    /// <p>A unique name for the image builder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the image used to create the image builder.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the public, private, or shared image to use.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// <li> <p>stream.standard.large</p> </li>
    /// <li> <p>stream.compute.large</p> </li>
    /// <li> <p>stream.compute.xlarge</p> </li>
    /// <li> <p>stream.compute.2xlarge</p> </li>
    /// <li> <p>stream.compute.4xlarge</p> </li>
    /// <li> <p>stream.compute.8xlarge</p> </li>
    /// <li> <p>stream.memory.large</p> </li>
    /// <li> <p>stream.memory.xlarge</p> </li>
    /// <li> <p>stream.memory.2xlarge</p> </li>
    /// <li> <p>stream.memory.4xlarge</p> </li>
    /// <li> <p>stream.memory.8xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.large</p> </li>
    /// <li> <p>stream.memory.z1d.xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
    /// <li> <p>stream.graphics-design.large</p> </li>
    /// <li> <p>stream.graphics-design.xlarge</p> </li>
    /// <li> <p>stream.graphics-design.2xlarge</p> </li>
    /// <li> <p>stream.graphics-design.4xlarge</p> </li>
    /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
    /// </ul>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The image builder name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>Enables or disables default internet access for the image builder.</p>
    pub enable_default_internet_access: std::option::Option<bool>,
    /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
    pub domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
    /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
    pub appstream_agent_version: std::option::Option<std::string::String>,
    /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
    pub access_endpoints: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
}
impl CreateImageBuilderInput {
    /// <p>A unique name for the image builder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the image used to create the image builder.</p>
    pub fn image_name(&self) -> std::option::Option<&str> {
        self.image_name.as_deref()
    }
    /// <p>The ARN of the public, private, or shared image to use.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// <li> <p>stream.standard.large</p> </li>
    /// <li> <p>stream.compute.large</p> </li>
    /// <li> <p>stream.compute.xlarge</p> </li>
    /// <li> <p>stream.compute.2xlarge</p> </li>
    /// <li> <p>stream.compute.4xlarge</p> </li>
    /// <li> <p>stream.compute.8xlarge</p> </li>
    /// <li> <p>stream.memory.large</p> </li>
    /// <li> <p>stream.memory.xlarge</p> </li>
    /// <li> <p>stream.memory.2xlarge</p> </li>
    /// <li> <p>stream.memory.4xlarge</p> </li>
    /// <li> <p>stream.memory.8xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.large</p> </li>
    /// <li> <p>stream.memory.z1d.xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
    /// <li> <p>stream.graphics-design.large</p> </li>
    /// <li> <p>stream.graphics-design.xlarge</p> </li>
    /// <li> <p>stream.graphics-design.2xlarge</p> </li>
    /// <li> <p>stream.graphics-design.4xlarge</p> </li>
    /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
    /// </ul>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The image builder name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>Enables or disables default internet access for the image builder.</p>
    pub fn enable_default_internet_access(&self) -> std::option::Option<bool> {
        self.enable_default_internet_access
    }
    /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
    pub fn domain_join_info(&self) -> std::option::Option<&crate::model::DomainJoinInfo> {
        self.domain_join_info.as_ref()
    }
    /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
    pub fn appstream_agent_version(&self) -> std::option::Option<&str> {
        self.appstream_agent_version.as_deref()
    }
    /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
    pub fn access_endpoints(&self) -> std::option::Option<&[crate::model::AccessEndpoint]> {
        self.access_endpoints.as_deref()
    }
}
impl std::fmt::Debug for CreateImageBuilderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageBuilderInput");
        formatter.field("name", &self.name);
        formatter.field("image_name", &self.image_name);
        formatter.field("image_arn", &self.image_arn);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field(
            "enable_default_internet_access",
            &self.enable_default_internet_access,
        );
        formatter.field("domain_join_info", &self.domain_join_info);
        formatter.field("appstream_agent_version", &self.appstream_agent_version);
        formatter.field("tags", &self.tags);
        formatter.field("access_endpoints", &self.access_endpoints);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFleetInput {
    /// <p>A unique name for the fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the image used to create the fleet.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the public, private, or shared image to use.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// <li> <p>stream.standard.large</p> </li>
    /// <li> <p>stream.compute.large</p> </li>
    /// <li> <p>stream.compute.xlarge</p> </li>
    /// <li> <p>stream.compute.2xlarge</p> </li>
    /// <li> <p>stream.compute.4xlarge</p> </li>
    /// <li> <p>stream.compute.8xlarge</p> </li>
    /// <li> <p>stream.memory.large</p> </li>
    /// <li> <p>stream.memory.xlarge</p> </li>
    /// <li> <p>stream.memory.2xlarge</p> </li>
    /// <li> <p>stream.memory.4xlarge</p> </li>
    /// <li> <p>stream.memory.8xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.large</p> </li>
    /// <li> <p>stream.memory.z1d.xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
    /// <li> <p>stream.graphics-design.large</p> </li>
    /// <li> <p>stream.graphics-design.xlarge</p> </li>
    /// <li> <p>stream.graphics-design.2xlarge</p> </li>
    /// <li> <p>stream.graphics-design.4xlarge</p> </li>
    /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
    /// </ul>
    /// <p>The following instance types are available for Elastic fleets:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// </ul>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The fleet type.</p>
    /// <dl>
    /// <dt>
    /// ALWAYS_ON
    /// </dt>
    /// <dd>
    /// <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
    /// </dd>
    /// <dt>
    /// ON_DEMAND
    /// </dt>
    /// <dd>
    /// <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p>
    /// </dd>
    /// </dl>
    pub fleet_type: std::option::Option<crate::model::FleetType>,
    /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify MaxConcurrentSessions instead.</p>
    pub compute_capacity: std::option::Option<crate::model::ComputeCapacity>,
    /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
    /// <p>Specify a value between 600 and 360000.</p>
    pub max_user_duration_in_seconds: std::option::Option<i32>,
    /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
    /// <p>Specify a value between 60 and 360000.</p>
    pub disconnect_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The fleet name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>Enables or disables default internet access for the fleet.</p>
    pub enable_default_internet_access: std::option::Option<bool>,
    /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets. </p>
    pub domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
    /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
    /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
    /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
    /// </note>
    pub idle_disconnect_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
    /// <p>The default value is <code>APP</code>.</p>
    pub stream_view: std::option::Option<crate::model::StreamView>,
    /// <p>The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
    pub platform: std::option::Option<crate::model::PlatformType>,
    /// <p>The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for other fleet types.</p>
    pub max_concurrent_sessions: std::option::Option<i32>,
    /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
    pub usb_device_filter_strings: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CreateFleetInput {
    /// <p>A unique name for the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the image used to create the fleet.</p>
    pub fn image_name(&self) -> std::option::Option<&str> {
        self.image_name.as_deref()
    }
    /// <p>The ARN of the public, private, or shared image to use.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// <li> <p>stream.standard.large</p> </li>
    /// <li> <p>stream.compute.large</p> </li>
    /// <li> <p>stream.compute.xlarge</p> </li>
    /// <li> <p>stream.compute.2xlarge</p> </li>
    /// <li> <p>stream.compute.4xlarge</p> </li>
    /// <li> <p>stream.compute.8xlarge</p> </li>
    /// <li> <p>stream.memory.large</p> </li>
    /// <li> <p>stream.memory.xlarge</p> </li>
    /// <li> <p>stream.memory.2xlarge</p> </li>
    /// <li> <p>stream.memory.4xlarge</p> </li>
    /// <li> <p>stream.memory.8xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.large</p> </li>
    /// <li> <p>stream.memory.z1d.xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
    /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
    /// <li> <p>stream.graphics-design.large</p> </li>
    /// <li> <p>stream.graphics-design.xlarge</p> </li>
    /// <li> <p>stream.graphics-design.2xlarge</p> </li>
    /// <li> <p>stream.graphics-design.4xlarge</p> </li>
    /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
    /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
    /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
    /// </ul>
    /// <p>The following instance types are available for Elastic fleets:</p>
    /// <ul>
    /// <li> <p>stream.standard.small</p> </li>
    /// <li> <p>stream.standard.medium</p> </li>
    /// </ul>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The fleet type.</p>
    /// <dl>
    /// <dt>
    /// ALWAYS_ON
    /// </dt>
    /// <dd>
    /// <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
    /// </dd>
    /// <dt>
    /// ON_DEMAND
    /// </dt>
    /// <dd>
    /// <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p>
    /// </dd>
    /// </dl>
    pub fn fleet_type(&self) -> std::option::Option<&crate::model::FleetType> {
        self.fleet_type.as_ref()
    }
    /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify MaxConcurrentSessions instead.</p>
    pub fn compute_capacity(&self) -> std::option::Option<&crate::model::ComputeCapacity> {
        self.compute_capacity.as_ref()
    }
    /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
    /// <p>Specify a value between 600 and 360000.</p>
    pub fn max_user_duration_in_seconds(&self) -> std::option::Option<i32> {
        self.max_user_duration_in_seconds
    }
    /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
    /// <p>Specify a value between 60 and 360000.</p>
    pub fn disconnect_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.disconnect_timeout_in_seconds
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The fleet name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>Enables or disables default internet access for the fleet.</p>
    pub fn enable_default_internet_access(&self) -> std::option::Option<bool> {
        self.enable_default_internet_access
    }
    /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets. </p>
    pub fn domain_join_info(&self) -> std::option::Option<&crate::model::DomainJoinInfo> {
        self.domain_join_info.as_ref()
    }
    /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
    /// <p>If you do not specify a value, the value is set to an empty string.</p>
    /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
    /// <p>_ . : / = + \ - @</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
    /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
    /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
    /// </note>
    pub fn idle_disconnect_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_disconnect_timeout_in_seconds
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
    /// <p>The default value is <code>APP</code>.</p>
    pub fn stream_view(&self) -> std::option::Option<&crate::model::StreamView> {
        self.stream_view.as_ref()
    }
    /// <p>The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
    pub fn platform(&self) -> std::option::Option<&crate::model::PlatformType> {
        self.platform.as_ref()
    }
    /// <p>The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for other fleet types.</p>
    pub fn max_concurrent_sessions(&self) -> std::option::Option<i32> {
        self.max_concurrent_sessions
    }
    /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
    pub fn usb_device_filter_strings(&self) -> std::option::Option<&[std::string::String]> {
        self.usb_device_filter_strings.as_deref()
    }
}
impl std::fmt::Debug for CreateFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFleetInput");
        formatter.field("name", &self.name);
        formatter.field("image_name", &self.image_name);
        formatter.field("image_arn", &self.image_arn);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("fleet_type", &self.fleet_type);
        formatter.field("compute_capacity", &self.compute_capacity);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field(
            "max_user_duration_in_seconds",
            &self.max_user_duration_in_seconds,
        );
        formatter.field(
            "disconnect_timeout_in_seconds",
            &self.disconnect_timeout_in_seconds,
        );
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field(
            "enable_default_internet_access",
            &self.enable_default_internet_access,
        );
        formatter.field("domain_join_info", &self.domain_join_info);
        formatter.field("tags", &self.tags);
        formatter.field(
            "idle_disconnect_timeout_in_seconds",
            &self.idle_disconnect_timeout_in_seconds,
        );
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("stream_view", &self.stream_view);
        formatter.field("platform", &self.platform);
        formatter.field("max_concurrent_sessions", &self.max_concurrent_sessions);
        formatter.field("usb_device_filter_strings", &self.usb_device_filter_strings);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEntitlementInput {
    /// <p>The name of the entitlement.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The description of the entitlement.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies whether all or selected apps are entitled.</p>
    pub app_visibility: std::option::Option<crate::model::AppVisibility>,
    /// <p>The attributes of the entitlement.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
}
impl CreateEntitlementInput {
    /// <p>The name of the entitlement.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The name of the stack with which the entitlement is associated.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The description of the entitlement.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies whether all or selected apps are entitled.</p>
    pub fn app_visibility(&self) -> std::option::Option<&crate::model::AppVisibility> {
        self.app_visibility.as_ref()
    }
    /// <p>The attributes of the entitlement.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::EntitlementAttribute]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for CreateEntitlementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEntitlementInput");
        formatter.field("name", &self.name);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("description", &self.description);
        formatter.field("app_visibility", &self.app_visibility);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectoryConfigInput {
    /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
    pub directory_name: std::option::Option<std::string::String>,
    /// <p>The distinguished names of the organizational units for computer accounts.</p>
    pub organizational_unit_distinguished_names:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    pub service_account_credentials: std::option::Option<crate::model::ServiceAccountCredentials>,
}
impl CreateDirectoryConfigInput {
    /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
    pub fn directory_name(&self) -> std::option::Option<&str> {
        self.directory_name.as_deref()
    }
    /// <p>The distinguished names of the organizational units for computer accounts.</p>
    pub fn organizational_unit_distinguished_names(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_distinguished_names.as_deref()
    }
    /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    pub fn service_account_credentials(
        &self,
    ) -> std::option::Option<&crate::model::ServiceAccountCredentials> {
        self.service_account_credentials.as_ref()
    }
}
impl std::fmt::Debug for CreateDirectoryConfigInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectoryConfigInput");
        formatter.field("directory_name", &self.directory_name);
        formatter.field(
            "organizational_unit_distinguished_names",
            &self.organizational_unit_distinguished_names,
        );
        formatter.field(
            "service_account_credentials",
            &self.service_account_credentials,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApplicationInput {
    /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The description of the application.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The location in S3 of the application icon.</p>
    pub icon_s3_location: std::option::Option<crate::model::S3Location>,
    /// <p>The launch path of the application.</p>
    pub launch_path: std::option::Option<std::string::String>,
    /// <p>The working directory of the application.</p>
    pub working_directory: std::option::Option<std::string::String>,
    /// <p>The launch parameters of the application.</p>
    pub launch_parameters: std::option::Option<std::string::String>,
    /// <p>The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.</p>
    pub platforms: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
    /// <p>The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.</p>
    pub instance_families: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The app block ARN to which the application should be associated</p>
    pub app_block_arn: std::option::Option<std::string::String>,
    /// <p>The tags assigned to the application.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateApplicationInput {
    /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The description of the application.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The location in S3 of the application icon.</p>
    pub fn icon_s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.icon_s3_location.as_ref()
    }
    /// <p>The launch path of the application.</p>
    pub fn launch_path(&self) -> std::option::Option<&str> {
        self.launch_path.as_deref()
    }
    /// <p>The working directory of the application.</p>
    pub fn working_directory(&self) -> std::option::Option<&str> {
        self.working_directory.as_deref()
    }
    /// <p>The launch parameters of the application.</p>
    pub fn launch_parameters(&self) -> std::option::Option<&str> {
        self.launch_parameters.as_deref()
    }
    /// <p>The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.</p>
    pub fn platforms(&self) -> std::option::Option<&[crate::model::PlatformType]> {
        self.platforms.as_deref()
    }
    /// <p>The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.</p>
    pub fn instance_families(&self) -> std::option::Option<&[std::string::String]> {
        self.instance_families.as_deref()
    }
    /// <p>The app block ARN to which the application should be associated</p>
    pub fn app_block_arn(&self) -> std::option::Option<&str> {
        self.app_block_arn.as_deref()
    }
    /// <p>The tags assigned to the application.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateApplicationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApplicationInput");
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("icon_s3_location", &self.icon_s3_location);
        formatter.field("launch_path", &self.launch_path);
        formatter.field("working_directory", &self.working_directory);
        formatter.field("launch_parameters", &self.launch_parameters);
        formatter.field("platforms", &self.platforms);
        formatter.field("instance_families", &self.instance_families);
        formatter.field("app_block_arn", &self.app_block_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAppBlockInput {
    /// <p>The name of the app block.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the app block.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The display name of the app block. This is not displayed to the user.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The source S3 location of the app block.</p>
    pub source_s3_location: std::option::Option<crate::model::S3Location>,
    /// <p>The setup script details of the app block.</p>
    pub setup_script_details: std::option::Option<crate::model::ScriptDetails>,
    /// <p>The tags assigned to the app block.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAppBlockInput {
    /// <p>The name of the app block.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the app block.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The display name of the app block. This is not displayed to the user.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The source S3 location of the app block.</p>
    pub fn source_s3_location(&self) -> std::option::Option<&crate::model::S3Location> {
        self.source_s3_location.as_ref()
    }
    /// <p>The setup script details of the app block.</p>
    pub fn setup_script_details(&self) -> std::option::Option<&crate::model::ScriptDetails> {
        self.setup_script_details.as_ref()
    }
    /// <p>The tags assigned to the app block.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAppBlockInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAppBlockInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field("source_s3_location", &self.source_s3_location);
        formatter.field("setup_script_details", &self.setup_script_details);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyImageInput {
    /// <p>The name of the image to copy.</p>
    pub source_image_name: std::option::Option<std::string::String>,
    /// <p>The name that the image will have when it is copied to the destination.</p>
    pub destination_image_name: std::option::Option<std::string::String>,
    /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
    pub destination_region: std::option::Option<std::string::String>,
    /// <p>The description that the image will have when it is copied to the destination.</p>
    pub destination_image_description: std::option::Option<std::string::String>,
}
impl CopyImageInput {
    /// <p>The name of the image to copy.</p>
    pub fn source_image_name(&self) -> std::option::Option<&str> {
        self.source_image_name.as_deref()
    }
    /// <p>The name that the image will have when it is copied to the destination.</p>
    pub fn destination_image_name(&self) -> std::option::Option<&str> {
        self.destination_image_name.as_deref()
    }
    /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
    pub fn destination_region(&self) -> std::option::Option<&str> {
        self.destination_region.as_deref()
    }
    /// <p>The description that the image will have when it is copied to the destination.</p>
    pub fn destination_image_description(&self) -> std::option::Option<&str> {
        self.destination_image_description.as_deref()
    }
}
impl std::fmt::Debug for CopyImageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyImageInput");
        formatter.field("source_image_name", &self.source_image_name);
        formatter.field("destination_image_name", &self.destination_image_name);
        formatter.field("destination_region", &self.destination_region);
        formatter.field(
            "destination_image_description",
            &self.destination_image_description,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateUserStackInput {
    /// <p>The list of UserStackAssociation objects.</p>
    pub user_stack_associations:
        std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
}
impl BatchDisassociateUserStackInput {
    /// <p>The list of UserStackAssociation objects.</p>
    pub fn user_stack_associations(
        &self,
    ) -> std::option::Option<&[crate::model::UserStackAssociation]> {
        self.user_stack_associations.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateUserStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateUserStackInput");
        formatter.field("user_stack_associations", &self.user_stack_associations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateUserStackInput {
    /// <p>The list of UserStackAssociation objects.</p>
    pub user_stack_associations:
        std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
}
impl BatchAssociateUserStackInput {
    /// <p>The list of UserStackAssociation objects.</p>
    pub fn user_stack_associations(
        &self,
    ) -> std::option::Option<&[crate::model::UserStackAssociation]> {
        self.user_stack_associations.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateUserStackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateUserStackInput");
        formatter.field("user_stack_associations", &self.user_stack_associations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFleetInput {
    /// <p>The name of the fleet. </p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The name of the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
}
impl AssociateFleetInput {
    /// <p>The name of the fleet. </p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The name of the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
}
impl std::fmt::Debug for AssociateFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFleetInput");
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("stack_name", &self.stack_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateApplicationToEntitlementInput {
    /// <p>The name of the stack.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the entitlement.</p>
    pub entitlement_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the application.</p>
    pub application_identifier: std::option::Option<std::string::String>,
}
impl AssociateApplicationToEntitlementInput {
    /// <p>The name of the stack.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The name of the entitlement.</p>
    pub fn entitlement_name(&self) -> std::option::Option<&str> {
        self.entitlement_name.as_deref()
    }
    /// <p>The identifier of the application.</p>
    pub fn application_identifier(&self) -> std::option::Option<&str> {
        self.application_identifier.as_deref()
    }
}
impl std::fmt::Debug for AssociateApplicationToEntitlementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateApplicationToEntitlementInput");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("entitlement_name", &self.entitlement_name);
        formatter.field("application_identifier", &self.application_identifier);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateApplicationFleetInput {
    /// <p>The name of the fleet.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the application.</p>
    pub application_arn: std::option::Option<std::string::String>,
}
impl AssociateApplicationFleetInput {
    /// <p>The name of the fleet.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The ARN of the application.</p>
    pub fn application_arn(&self) -> std::option::Option<&str> {
        self.application_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateApplicationFleetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateApplicationFleetInput");
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("application_arn", &self.application_arn);
        formatter.finish()
    }
}
