// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon AppStream
///
/// Client for invoking operations on Amazon AppStream. Each operation on Amazon AppStream is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appstream::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appstream::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appstream::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateApplicationFleet`](crate::client::fluent_builders::AssociateApplicationFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::AssociateApplicationFleet::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::AssociateApplicationFleet::set_fleet_name): <p>The name of the fleet.</p>
    ///   - [`application_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateApplicationFleet::application_arn) / [`set_application_arn(Option<String>)`](crate::client::fluent_builders::AssociateApplicationFleet::set_application_arn): <p>The ARN of the application.</p>
    /// - On success, responds with [`AssociateApplicationFleetOutput`](crate::output::AssociateApplicationFleetOutput) with field(s):
    ///   - [`application_fleet_association(Option<ApplicationFleetAssociation>)`](crate::output::AssociateApplicationFleetOutput::application_fleet_association): <p>If fleet name is specified, this returns the list of applications that are associated to it. If application ARN is specified, this returns the list of fleets to which it is associated.</p>
    /// - On failure, responds with [`SdkError<AssociateApplicationFleetError>`](crate::error::AssociateApplicationFleetError)
    pub fn associate_application_fleet(
        &self,
    ) -> fluent_builders::AssociateApplicationFleet<C, M, R> {
        fluent_builders::AssociateApplicationFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateApplicationToEntitlement`](crate::client::fluent_builders::AssociateApplicationToEntitlement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::AssociateApplicationToEntitlement::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::AssociateApplicationToEntitlement::set_stack_name): <p>The name of the stack.</p>
    ///   - [`entitlement_name(impl Into<String>)`](crate::client::fluent_builders::AssociateApplicationToEntitlement::entitlement_name) / [`set_entitlement_name(Option<String>)`](crate::client::fluent_builders::AssociateApplicationToEntitlement::set_entitlement_name): <p>The name of the entitlement.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::AssociateApplicationToEntitlement::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::AssociateApplicationToEntitlement::set_application_identifier): <p>The identifier of the application.</p>
    /// - On success, responds with [`AssociateApplicationToEntitlementOutput`](crate::output::AssociateApplicationToEntitlementOutput)

    /// - On failure, responds with [`SdkError<AssociateApplicationToEntitlementError>`](crate::error::AssociateApplicationToEntitlementError)
    pub fn associate_application_to_entitlement(
        &self,
    ) -> fluent_builders::AssociateApplicationToEntitlement<C, M, R> {
        fluent_builders::AssociateApplicationToEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateFleet`](crate::client::fluent_builders::AssociateFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::AssociateFleet::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::AssociateFleet::set_fleet_name): <p>The name of the fleet. </p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::AssociateFleet::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::AssociateFleet::set_stack_name): <p>The name of the stack.</p>
    /// - On success, responds with [`AssociateFleetOutput`](crate::output::AssociateFleetOutput)

    /// - On failure, responds with [`SdkError<AssociateFleetError>`](crate::error::AssociateFleetError)
    pub fn associate_fleet(&self) -> fluent_builders::AssociateFleet<C, M, R> {
        fluent_builders::AssociateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchAssociateUserStack`](crate::client::fluent_builders::BatchAssociateUserStack) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_stack_associations(Vec<UserStackAssociation>)`](crate::client::fluent_builders::BatchAssociateUserStack::user_stack_associations) / [`set_user_stack_associations(Option<Vec<UserStackAssociation>>)`](crate::client::fluent_builders::BatchAssociateUserStack::set_user_stack_associations): <p>The list of UserStackAssociation objects.</p>
    /// - On success, responds with [`BatchAssociateUserStackOutput`](crate::output::BatchAssociateUserStackOutput) with field(s):
    ///   - [`errors(Option<Vec<UserStackAssociationError>>)`](crate::output::BatchAssociateUserStackOutput::errors): <p>The list of UserStackAssociationError objects.</p>
    /// - On failure, responds with [`SdkError<BatchAssociateUserStackError>`](crate::error::BatchAssociateUserStackError)
    pub fn batch_associate_user_stack(&self) -> fluent_builders::BatchAssociateUserStack<C, M, R> {
        fluent_builders::BatchAssociateUserStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDisassociateUserStack`](crate::client::fluent_builders::BatchDisassociateUserStack) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_stack_associations(Vec<UserStackAssociation>)`](crate::client::fluent_builders::BatchDisassociateUserStack::user_stack_associations) / [`set_user_stack_associations(Option<Vec<UserStackAssociation>>)`](crate::client::fluent_builders::BatchDisassociateUserStack::set_user_stack_associations): <p>The list of UserStackAssociation objects.</p>
    /// - On success, responds with [`BatchDisassociateUserStackOutput`](crate::output::BatchDisassociateUserStackOutput) with field(s):
    ///   - [`errors(Option<Vec<UserStackAssociationError>>)`](crate::output::BatchDisassociateUserStackOutput::errors): <p>The list of UserStackAssociationError objects.</p>
    /// - On failure, responds with [`SdkError<BatchDisassociateUserStackError>`](crate::error::BatchDisassociateUserStackError)
    pub fn batch_disassociate_user_stack(
        &self,
    ) -> fluent_builders::BatchDisassociateUserStack<C, M, R> {
        fluent_builders::BatchDisassociateUserStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyImage`](crate::client::fluent_builders::CopyImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_image_name(impl Into<String>)`](crate::client::fluent_builders::CopyImage::source_image_name) / [`set_source_image_name(Option<String>)`](crate::client::fluent_builders::CopyImage::set_source_image_name): <p>The name of the image to copy.</p>
    ///   - [`destination_image_name(impl Into<String>)`](crate::client::fluent_builders::CopyImage::destination_image_name) / [`set_destination_image_name(Option<String>)`](crate::client::fluent_builders::CopyImage::set_destination_image_name): <p>The name that the image will have when it is copied to the destination.</p>
    ///   - [`destination_region(impl Into<String>)`](crate::client::fluent_builders::CopyImage::destination_region) / [`set_destination_region(Option<String>)`](crate::client::fluent_builders::CopyImage::set_destination_region): <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
    ///   - [`destination_image_description(impl Into<String>)`](crate::client::fluent_builders::CopyImage::destination_image_description) / [`set_destination_image_description(Option<String>)`](crate::client::fluent_builders::CopyImage::set_destination_image_description): <p>The description that the image will have when it is copied to the destination.</p>
    /// - On success, responds with [`CopyImageOutput`](crate::output::CopyImageOutput) with field(s):
    ///   - [`destination_image_name(Option<String>)`](crate::output::CopyImageOutput::destination_image_name): <p>The name of the destination image.</p>
    /// - On failure, responds with [`SdkError<CopyImageError>`](crate::error::CopyImageError)
    pub fn copy_image(&self) -> fluent_builders::CopyImage<C, M, R> {
        fluent_builders::CopyImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAppBlock`](crate::client::fluent_builders::CreateAppBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAppBlock::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAppBlock::set_name): <p>The name of the app block.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAppBlock::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAppBlock::set_description): <p>The description of the app block.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateAppBlock::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateAppBlock::set_display_name): <p>The display name of the app block. This is not displayed to the user.</p>
    ///   - [`source_s3_location(S3Location)`](crate::client::fluent_builders::CreateAppBlock::source_s3_location) / [`set_source_s3_location(Option<S3Location>)`](crate::client::fluent_builders::CreateAppBlock::set_source_s3_location): <p>The source S3 location of the app block.</p>
    ///   - [`setup_script_details(ScriptDetails)`](crate::client::fluent_builders::CreateAppBlock::setup_script_details) / [`set_setup_script_details(Option<ScriptDetails>)`](crate::client::fluent_builders::CreateAppBlock::set_setup_script_details): <p>The setup script details of the app block.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAppBlock::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAppBlock::set_tags): <p>The tags assigned to the app block.</p>
    /// - On success, responds with [`CreateAppBlockOutput`](crate::output::CreateAppBlockOutput) with field(s):
    ///   - [`app_block(Option<AppBlock>)`](crate::output::CreateAppBlockOutput::app_block): <p>The app block.</p>
    /// - On failure, responds with [`SdkError<CreateAppBlockError>`](crate::error::CreateAppBlockError)
    pub fn create_app_block(&self) -> fluent_builders::CreateAppBlock<C, M, R> {
        fluent_builders::CreateAppBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApplication`](crate::client::fluent_builders::CreateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_name): <p>The name of the application. This name is visible to users when display name is not specified.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_display_name): <p>The display name of the application. This name is visible to users in the application catalog.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_description): <p>The description of the application.</p>
    ///   - [`icon_s3_location(S3Location)`](crate::client::fluent_builders::CreateApplication::icon_s3_location) / [`set_icon_s3_location(Option<S3Location>)`](crate::client::fluent_builders::CreateApplication::set_icon_s3_location): <p>The location in S3 of the application icon.</p>
    ///   - [`launch_path(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::launch_path) / [`set_launch_path(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_launch_path): <p>The launch path of the application.</p>
    ///   - [`working_directory(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::working_directory) / [`set_working_directory(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_working_directory): <p>The working directory of the application.</p>
    ///   - [`launch_parameters(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::launch_parameters) / [`set_launch_parameters(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_launch_parameters): <p>The launch parameters of the application.</p>
    ///   - [`platforms(Vec<PlatformType>)`](crate::client::fluent_builders::CreateApplication::platforms) / [`set_platforms(Option<Vec<PlatformType>>)`](crate::client::fluent_builders::CreateApplication::set_platforms): <p>The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.</p>
    ///   - [`instance_families(Vec<String>)`](crate::client::fluent_builders::CreateApplication::instance_families) / [`set_instance_families(Option<Vec<String>>)`](crate::client::fluent_builders::CreateApplication::set_instance_families): <p>The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.</p>
    ///   - [`app_block_arn(impl Into<String>)`](crate::client::fluent_builders::CreateApplication::app_block_arn) / [`set_app_block_arn(Option<String>)`](crate::client::fluent_builders::CreateApplication::set_app_block_arn): <p>The app block ARN to which the application should be associated</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateApplication::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateApplication::set_tags): <p>The tags assigned to the application.</p>
    /// - On success, responds with [`CreateApplicationOutput`](crate::output::CreateApplicationOutput) with field(s):
    ///   - [`application(Option<Application>)`](crate::output::CreateApplicationOutput::application): <p>Describes an application in the application catalog.</p>
    /// - On failure, responds with [`SdkError<CreateApplicationError>`](crate::error::CreateApplicationError)
    pub fn create_application(&self) -> fluent_builders::CreateApplication<C, M, R> {
        fluent_builders::CreateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDirectoryConfig`](crate::client::fluent_builders::CreateDirectoryConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_name(impl Into<String>)`](crate::client::fluent_builders::CreateDirectoryConfig::directory_name) / [`set_directory_name(Option<String>)`](crate::client::fluent_builders::CreateDirectoryConfig::set_directory_name): <p>The fully qualified name of the directory (for example, corp.example.com).</p>
    ///   - [`organizational_unit_distinguished_names(Vec<String>)`](crate::client::fluent_builders::CreateDirectoryConfig::organizational_unit_distinguished_names) / [`set_organizational_unit_distinguished_names(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDirectoryConfig::set_organizational_unit_distinguished_names): <p>The distinguished names of the organizational units for computer accounts.</p>
    ///   - [`service_account_credentials(ServiceAccountCredentials)`](crate::client::fluent_builders::CreateDirectoryConfig::service_account_credentials) / [`set_service_account_credentials(Option<ServiceAccountCredentials>)`](crate::client::fluent_builders::CreateDirectoryConfig::set_service_account_credentials): <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    /// - On success, responds with [`CreateDirectoryConfigOutput`](crate::output::CreateDirectoryConfigOutput) with field(s):
    ///   - [`directory_config(Option<DirectoryConfig>)`](crate::output::CreateDirectoryConfigOutput::directory_config): <p>Information about the directory configuration.</p>
    /// - On failure, responds with [`SdkError<CreateDirectoryConfigError>`](crate::error::CreateDirectoryConfigError)
    pub fn create_directory_config(&self) -> fluent_builders::CreateDirectoryConfig<C, M, R> {
        fluent_builders::CreateDirectoryConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEntitlement`](crate::client::fluent_builders::CreateEntitlement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateEntitlement::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateEntitlement::set_name): <p>The name of the entitlement.</p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::CreateEntitlement::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::CreateEntitlement::set_stack_name): <p>The name of the stack with which the entitlement is associated.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateEntitlement::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateEntitlement::set_description): <p>The description of the entitlement.</p>
    ///   - [`app_visibility(AppVisibility)`](crate::client::fluent_builders::CreateEntitlement::app_visibility) / [`set_app_visibility(Option<AppVisibility>)`](crate::client::fluent_builders::CreateEntitlement::set_app_visibility): <p>Specifies whether all or selected apps are entitled.</p>
    ///   - [`attributes(Vec<EntitlementAttribute>)`](crate::client::fluent_builders::CreateEntitlement::attributes) / [`set_attributes(Option<Vec<EntitlementAttribute>>)`](crate::client::fluent_builders::CreateEntitlement::set_attributes): <p>The attributes of the entitlement.</p>
    /// - On success, responds with [`CreateEntitlementOutput`](crate::output::CreateEntitlementOutput) with field(s):
    ///   - [`entitlement(Option<Entitlement>)`](crate::output::CreateEntitlementOutput::entitlement): <p>The entitlement.</p>
    /// - On failure, responds with [`SdkError<CreateEntitlementError>`](crate::error::CreateEntitlementError)
    pub fn create_entitlement(&self) -> fluent_builders::CreateEntitlement<C, M, R> {
        fluent_builders::CreateEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFleet`](crate::client::fluent_builders::CreateFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_name): <p>A unique name for the fleet.</p>
    ///   - [`image_name(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::image_name) / [`set_image_name(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_image_name): <p>The name of the image used to create the fleet.</p>
    ///   - [`image_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::image_arn) / [`set_image_arn(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_image_arn): <p>The ARN of the public, private, or shared image to use.</p>
    ///   - [`instance_type(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::instance_type) / [`set_instance_type(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_instance_type): <p>The instance type to use when launching fleet instances. The following instance types are available:</p>  <ul>   <li> <p>stream.standard.small</p> </li>   <li> <p>stream.standard.medium</p> </li>   <li> <p>stream.standard.large</p> </li>   <li> <p>stream.compute.large</p> </li>   <li> <p>stream.compute.xlarge</p> </li>   <li> <p>stream.compute.2xlarge</p> </li>   <li> <p>stream.compute.4xlarge</p> </li>   <li> <p>stream.compute.8xlarge</p> </li>   <li> <p>stream.memory.large</p> </li>   <li> <p>stream.memory.xlarge</p> </li>   <li> <p>stream.memory.2xlarge</p> </li>   <li> <p>stream.memory.4xlarge</p> </li>   <li> <p>stream.memory.8xlarge</p> </li>   <li> <p>stream.memory.z1d.large</p> </li>   <li> <p>stream.memory.z1d.xlarge</p> </li>   <li> <p>stream.memory.z1d.2xlarge</p> </li>   <li> <p>stream.memory.z1d.3xlarge</p> </li>   <li> <p>stream.memory.z1d.6xlarge</p> </li>   <li> <p>stream.memory.z1d.12xlarge</p> </li>   <li> <p>stream.graphics-design.large</p> </li>   <li> <p>stream.graphics-design.xlarge</p> </li>   <li> <p>stream.graphics-design.2xlarge</p> </li>   <li> <p>stream.graphics-design.4xlarge</p> </li>   <li> <p>stream.graphics-desktop.2xlarge</p> </li>   <li> <p>stream.graphics.g4dn.xlarge</p> </li>   <li> <p>stream.graphics.g4dn.2xlarge</p> </li>   <li> <p>stream.graphics.g4dn.4xlarge</p> </li>   <li> <p>stream.graphics.g4dn.8xlarge</p> </li>   <li> <p>stream.graphics.g4dn.12xlarge</p> </li>   <li> <p>stream.graphics.g4dn.16xlarge</p> </li>   <li> <p>stream.graphics-pro.4xlarge</p> </li>   <li> <p>stream.graphics-pro.8xlarge</p> </li>   <li> <p>stream.graphics-pro.16xlarge</p> </li>  </ul>  <p>The following instance types are available for Elastic fleets:</p>  <ul>   <li> <p>stream.standard.small</p> </li>   <li> <p>stream.standard.medium</p> </li>  </ul>
    ///   - [`fleet_type(FleetType)`](crate::client::fluent_builders::CreateFleet::fleet_type) / [`set_fleet_type(Option<FleetType>)`](crate::client::fluent_builders::CreateFleet::set_fleet_type): <p>The fleet type.</p>  <dl>   <dt>   ALWAYS_ON  </dt>   <dd>    <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p>   </dd>   <dt>   ON_DEMAND  </dt>   <dd>    <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p>   </dd>  </dl>
    ///   - [`compute_capacity(ComputeCapacity)`](crate::client::fluent_builders::CreateFleet::compute_capacity) / [`set_compute_capacity(Option<ComputeCapacity>)`](crate::client::fluent_builders::CreateFleet::set_compute_capacity): <p>The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify MaxConcurrentSessions instead.</p>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::CreateFleet::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::CreateFleet::set_vpc_config): <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.</p>
    ///   - [`max_user_duration_in_seconds(i32)`](crate::client::fluent_builders::CreateFleet::max_user_duration_in_seconds) / [`set_max_user_duration_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateFleet::set_max_user_duration_in_seconds): <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>  <p>Specify a value between 600 and 360000.</p>
    ///   - [`disconnect_timeout_in_seconds(i32)`](crate::client::fluent_builders::CreateFleet::disconnect_timeout_in_seconds) / [`set_disconnect_timeout_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateFleet::set_disconnect_timeout_in_seconds): <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>  <p>Specify a value between 60 and 360000.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_description): <p>The description to display.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_display_name): <p>The fleet name to display.</p>
    ///   - [`enable_default_internet_access(bool)`](crate::client::fluent_builders::CreateFleet::enable_default_internet_access) / [`set_enable_default_internet_access(Option<bool>)`](crate::client::fluent_builders::CreateFleet::set_enable_default_internet_access): <p>Enables or disables default internet access for the fleet.</p>
    ///   - [`domain_join_info(DomainJoinInfo)`](crate::client::fluent_builders::CreateFleet::domain_join_info) / [`set_domain_join_info(Option<DomainJoinInfo>)`](crate::client::fluent_builders::CreateFleet::set_domain_join_info): <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFleet::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFleet::set_tags): <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>  <p>If you do not specify a value, the value is set to an empty string.</p>  <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>  <p>_ . : / = + \ - @</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    ///   - [`idle_disconnect_timeout_in_seconds(i32)`](crate::client::fluent_builders::CreateFleet::idle_disconnect_timeout_in_seconds) / [`set_idle_disconnect_timeout_in_seconds(Option<i32>)`](crate::client::fluent_builders::CreateFleet::set_idle_disconnect_timeout_in_seconds): <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>  <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>   <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>  </note>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateFleet::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::CreateFleet::set_iam_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    ///   - [`stream_view(StreamView)`](crate::client::fluent_builders::CreateFleet::stream_view) / [`set_stream_view(Option<StreamView>)`](crate::client::fluent_builders::CreateFleet::set_stream_view): <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>  <p>The default value is <code>APP</code>.</p>
    ///   - [`platform(PlatformType)`](crate::client::fluent_builders::CreateFleet::platform) / [`set_platform(Option<PlatformType>)`](crate::client::fluent_builders::CreateFleet::set_platform): <p>The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
    ///   - [`max_concurrent_sessions(i32)`](crate::client::fluent_builders::CreateFleet::max_concurrent_sessions) / [`set_max_concurrent_sessions(Option<i32>)`](crate::client::fluent_builders::CreateFleet::set_max_concurrent_sessions): <p>The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for other fleet types.</p>
    ///   - [`usb_device_filter_strings(Vec<String>)`](crate::client::fluent_builders::CreateFleet::usb_device_filter_strings) / [`set_usb_device_filter_strings(Option<Vec<String>>)`](crate::client::fluent_builders::CreateFleet::set_usb_device_filter_strings): <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
    /// - On success, responds with [`CreateFleetOutput`](crate::output::CreateFleetOutput) with field(s):
    ///   - [`fleet(Option<Fleet>)`](crate::output::CreateFleetOutput::fleet): <p>Information about the fleet.</p>
    /// - On failure, responds with [`SdkError<CreateFleetError>`](crate::error::CreateFleetError)
    pub fn create_fleet(&self) -> fluent_builders::CreateFleet<C, M, R> {
        fluent_builders::CreateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImageBuilder`](crate::client::fluent_builders::CreateImageBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_name): <p>A unique name for the image builder.</p>
    ///   - [`image_name(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::image_name) / [`set_image_name(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_image_name): <p>The name of the image used to create the image builder.</p>
    ///   - [`image_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::image_arn) / [`set_image_arn(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_image_arn): <p>The ARN of the public, private, or shared image to use.</p>
    ///   - [`instance_type(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::instance_type) / [`set_instance_type(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_instance_type): <p>The instance type to use when launching the image builder. The following instance types are available:</p>  <ul>   <li> <p>stream.standard.small</p> </li>   <li> <p>stream.standard.medium</p> </li>   <li> <p>stream.standard.large</p> </li>   <li> <p>stream.compute.large</p> </li>   <li> <p>stream.compute.xlarge</p> </li>   <li> <p>stream.compute.2xlarge</p> </li>   <li> <p>stream.compute.4xlarge</p> </li>   <li> <p>stream.compute.8xlarge</p> </li>   <li> <p>stream.memory.large</p> </li>   <li> <p>stream.memory.xlarge</p> </li>   <li> <p>stream.memory.2xlarge</p> </li>   <li> <p>stream.memory.4xlarge</p> </li>   <li> <p>stream.memory.8xlarge</p> </li>   <li> <p>stream.memory.z1d.large</p> </li>   <li> <p>stream.memory.z1d.xlarge</p> </li>   <li> <p>stream.memory.z1d.2xlarge</p> </li>   <li> <p>stream.memory.z1d.3xlarge</p> </li>   <li> <p>stream.memory.z1d.6xlarge</p> </li>   <li> <p>stream.memory.z1d.12xlarge</p> </li>   <li> <p>stream.graphics-design.large</p> </li>   <li> <p>stream.graphics-design.xlarge</p> </li>   <li> <p>stream.graphics-design.2xlarge</p> </li>   <li> <p>stream.graphics-design.4xlarge</p> </li>   <li> <p>stream.graphics-desktop.2xlarge</p> </li>   <li> <p>stream.graphics.g4dn.xlarge</p> </li>   <li> <p>stream.graphics.g4dn.2xlarge</p> </li>   <li> <p>stream.graphics.g4dn.4xlarge</p> </li>   <li> <p>stream.graphics.g4dn.8xlarge</p> </li>   <li> <p>stream.graphics.g4dn.12xlarge</p> </li>   <li> <p>stream.graphics.g4dn.16xlarge</p> </li>   <li> <p>stream.graphics-pro.4xlarge</p> </li>   <li> <p>stream.graphics-pro.8xlarge</p> </li>   <li> <p>stream.graphics-pro.16xlarge</p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_description): <p>The description to display.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_display_name): <p>The image builder name to display.</p>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::CreateImageBuilder::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::CreateImageBuilder::set_vpc_config): <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_iam_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    ///   - [`enable_default_internet_access(bool)`](crate::client::fluent_builders::CreateImageBuilder::enable_default_internet_access) / [`set_enable_default_internet_access(Option<bool>)`](crate::client::fluent_builders::CreateImageBuilder::set_enable_default_internet_access): <p>Enables or disables default internet access for the image builder.</p>
    ///   - [`domain_join_info(DomainJoinInfo)`](crate::client::fluent_builders::CreateImageBuilder::domain_join_info) / [`set_domain_join_info(Option<DomainJoinInfo>)`](crate::client::fluent_builders::CreateImageBuilder::set_domain_join_info): <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
    ///   - [`appstream_agent_version(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilder::appstream_agent_version) / [`set_appstream_agent_version(Option<String>)`](crate::client::fluent_builders::CreateImageBuilder::set_appstream_agent_version): <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateImageBuilder::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateImageBuilder::set_tags): <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>  <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>  <p>_ . : / = + \ - @</p>  <p>If you do not specify a value, the value is set to an empty string.</p>  <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    ///   - [`access_endpoints(Vec<AccessEndpoint>)`](crate::client::fluent_builders::CreateImageBuilder::access_endpoints) / [`set_access_endpoints(Option<Vec<AccessEndpoint>>)`](crate::client::fluent_builders::CreateImageBuilder::set_access_endpoints): <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
    /// - On success, responds with [`CreateImageBuilderOutput`](crate::output::CreateImageBuilderOutput) with field(s):
    ///   - [`image_builder(Option<ImageBuilder>)`](crate::output::CreateImageBuilderOutput::image_builder): <p>Information about the image builder.</p>
    /// - On failure, responds with [`SdkError<CreateImageBuilderError>`](crate::error::CreateImageBuilderError)
    pub fn create_image_builder(&self) -> fluent_builders::CreateImageBuilder<C, M, R> {
        fluent_builders::CreateImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateImageBuilderStreamingURL`](crate::client::fluent_builders::CreateImageBuilderStreamingURL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateImageBuilderStreamingURL::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateImageBuilderStreamingURL::set_name): <p>The name of the image builder.</p>
    ///   - [`validity(i64)`](crate::client::fluent_builders::CreateImageBuilderStreamingURL::validity) / [`set_validity(Option<i64>)`](crate::client::fluent_builders::CreateImageBuilderStreamingURL::set_validity): <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
    /// - On success, responds with [`CreateImageBuilderStreamingUrlOutput`](crate::output::CreateImageBuilderStreamingUrlOutput) with field(s):
    ///   - [`streaming_url(Option<String>)`](crate::output::CreateImageBuilderStreamingUrlOutput::streaming_url): <p>The URL to start the AppStream 2.0 streaming session.</p>
    ///   - [`expires(Option<DateTime>)`](crate::output::CreateImageBuilderStreamingUrlOutput::expires): <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
    /// - On failure, responds with [`SdkError<CreateImageBuilderStreamingURLError>`](crate::error::CreateImageBuilderStreamingURLError)
    pub fn create_image_builder_streaming_url(
        &self,
    ) -> fluent_builders::CreateImageBuilderStreamingURL<C, M, R> {
        fluent_builders::CreateImageBuilderStreamingURL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStack`](crate::client::fluent_builders::CreateStack) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateStack::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateStack::set_name): <p>The name of the stack.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateStack::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateStack::set_description): <p>The description to display.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::CreateStack::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::CreateStack::set_display_name): <p>The stack name to display.</p>
    ///   - [`storage_connectors(Vec<StorageConnector>)`](crate::client::fluent_builders::CreateStack::storage_connectors) / [`set_storage_connectors(Option<Vec<StorageConnector>>)`](crate::client::fluent_builders::CreateStack::set_storage_connectors): <p>The storage connectors to enable.</p>
    ///   - [`redirect_url(impl Into<String>)`](crate::client::fluent_builders::CreateStack::redirect_url) / [`set_redirect_url(Option<String>)`](crate::client::fluent_builders::CreateStack::set_redirect_url): <p>The URL that users are redirected to after their streaming session ends.</p>
    ///   - [`feedback_url(impl Into<String>)`](crate::client::fluent_builders::CreateStack::feedback_url) / [`set_feedback_url(Option<String>)`](crate::client::fluent_builders::CreateStack::set_feedback_url): <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    ///   - [`user_settings(Vec<UserSetting>)`](crate::client::fluent_builders::CreateStack::user_settings) / [`set_user_settings(Option<Vec<UserSetting>>)`](crate::client::fluent_builders::CreateStack::set_user_settings): <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
    ///   - [`application_settings(ApplicationSettings)`](crate::client::fluent_builders::CreateStack::application_settings) / [`set_application_settings(Option<ApplicationSettings>)`](crate::client::fluent_builders::CreateStack::set_application_settings): <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateStack::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateStack::set_tags): <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>  <p>If you do not specify a value, the value is set to an empty string.</p>  <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>  <p>_ . : / = + \ - @</p>  <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    ///   - [`access_endpoints(Vec<AccessEndpoint>)`](crate::client::fluent_builders::CreateStack::access_endpoints) / [`set_access_endpoints(Option<Vec<AccessEndpoint>>)`](crate::client::fluent_builders::CreateStack::set_access_endpoints): <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
    ///   - [`embed_host_domains(Vec<String>)`](crate::client::fluent_builders::CreateStack::embed_host_domains) / [`set_embed_host_domains(Option<Vec<String>>)`](crate::client::fluent_builders::CreateStack::set_embed_host_domains): <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
    /// - On success, responds with [`CreateStackOutput`](crate::output::CreateStackOutput) with field(s):
    ///   - [`stack(Option<Stack>)`](crate::output::CreateStackOutput::stack): <p>Information about the stack.</p>
    /// - On failure, responds with [`SdkError<CreateStackError>`](crate::error::CreateStackError)
    pub fn create_stack(&self) -> fluent_builders::CreateStack<C, M, R> {
        fluent_builders::CreateStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateStreamingURL`](crate::client::fluent_builders::CreateStreamingURL) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingURL::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::CreateStreamingURL::set_stack_name): <p>The name of the stack.</p>
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingURL::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::CreateStreamingURL::set_fleet_name): <p>The name of the fleet.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingURL::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingURL::set_user_id): <p>The identifier of the user.</p>
    ///   - [`application_id(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingURL::application_id) / [`set_application_id(Option<String>)`](crate::client::fluent_builders::CreateStreamingURL::set_application_id): <p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
    ///   - [`validity(i64)`](crate::client::fluent_builders::CreateStreamingURL::validity) / [`set_validity(Option<i64>)`](crate::client::fluent_builders::CreateStreamingURL::set_validity): <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
    ///   - [`session_context(impl Into<String>)`](crate::client::fluent_builders::CreateStreamingURL::session_context) / [`set_session_context(Option<String>)`](crate::client::fluent_builders::CreateStreamingURL::set_session_context): <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    /// - On success, responds with [`CreateStreamingUrlOutput`](crate::output::CreateStreamingUrlOutput) with field(s):
    ///   - [`streaming_url(Option<String>)`](crate::output::CreateStreamingUrlOutput::streaming_url): <p>The URL to start the AppStream 2.0 streaming session.</p>
    ///   - [`expires(Option<DateTime>)`](crate::output::CreateStreamingUrlOutput::expires): <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
    /// - On failure, responds with [`SdkError<CreateStreamingURLError>`](crate::error::CreateStreamingURLError)
    pub fn create_streaming_url(&self) -> fluent_builders::CreateStreamingURL<C, M, R> {
        fluent_builders::CreateStreamingURL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUpdatedImage`](crate::client::fluent_builders::CreateUpdatedImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`existing_image_name(impl Into<String>)`](crate::client::fluent_builders::CreateUpdatedImage::existing_image_name) / [`set_existing_image_name(Option<String>)`](crate::client::fluent_builders::CreateUpdatedImage::set_existing_image_name): <p>The name of the image to update.</p>
    ///   - [`new_image_name(impl Into<String>)`](crate::client::fluent_builders::CreateUpdatedImage::new_image_name) / [`set_new_image_name(Option<String>)`](crate::client::fluent_builders::CreateUpdatedImage::set_new_image_name): <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
    ///   - [`new_image_description(impl Into<String>)`](crate::client::fluent_builders::CreateUpdatedImage::new_image_description) / [`set_new_image_description(Option<String>)`](crate::client::fluent_builders::CreateUpdatedImage::set_new_image_description): <p>The description to display for the new image.</p>
    ///   - [`new_image_display_name(impl Into<String>)`](crate::client::fluent_builders::CreateUpdatedImage::new_image_display_name) / [`set_new_image_display_name(Option<String>)`](crate::client::fluent_builders::CreateUpdatedImage::set_new_image_display_name): <p>The name to display for the new image.</p>
    ///   - [`new_image_tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateUpdatedImage::new_image_tags) / [`set_new_image_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateUpdatedImage::set_new_image_tags): <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>  <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>  <p>_ . : / = + \ - @</p>  <p>If you do not specify a value, the value is set to an empty string.</p>  <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateUpdatedImage::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::CreateUpdatedImage::set_dry_run): <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
    /// - On success, responds with [`CreateUpdatedImageOutput`](crate::output::CreateUpdatedImageOutput) with field(s):
    ///   - [`image(Option<Image>)`](crate::output::CreateUpdatedImageOutput::image): <p>Describes an image.</p>
    ///   - [`can_update_image(bool)`](crate::output::CreateUpdatedImageOutput::can_update_image): <p>Indicates whether a new image can be created.</p>
    /// - On failure, responds with [`SdkError<CreateUpdatedImageError>`](crate::error::CreateUpdatedImageError)
    pub fn create_updated_image(&self) -> fluent_builders::CreateUpdatedImage<C, M, R> {
        fluent_builders::CreateUpdatedImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUsageReportSubscription`](crate::client::fluent_builders::CreateUsageReportSubscription) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::CreateUsageReportSubscription::send) it.

    /// - On success, responds with [`CreateUsageReportSubscriptionOutput`](crate::output::CreateUsageReportSubscriptionOutput) with field(s):
    ///   - [`s3_bucket_name(Option<String>)`](crate::output::CreateUsageReportSubscriptionOutput::s3_bucket_name): <p>The Amazon S3 bucket where generated reports are stored.</p>  <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts, when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
    ///   - [`schedule(Option<UsageReportSchedule>)`](crate::output::CreateUsageReportSubscriptionOutput::schedule): <p>The schedule for generating usage reports.</p>
    /// - On failure, responds with [`SdkError<CreateUsageReportSubscriptionError>`](crate::error::CreateUsageReportSubscriptionError)
    pub fn create_usage_report_subscription(
        &self,
    ) -> fluent_builders::CreateUsageReportSubscription<C, M, R> {
        fluent_builders::CreateUsageReportSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_user_name): <p>The email address of the user.</p> <note>   <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>  </note>
    ///   - [`message_action(MessageAction)`](crate::client::fluent_builders::CreateUser::message_action) / [`set_message_action(Option<MessageAction>)`](crate::client::fluent_builders::CreateUser::set_message_action): <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note>   <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>  </note>
    ///   - [`first_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::first_name) / [`set_first_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_first_name): <p>The first name, or given name, of the user.</p>
    ///   - [`last_name(impl Into<String>)`](crate::client::fluent_builders::CreateUser::last_name) / [`set_last_name(Option<String>)`](crate::client::fluent_builders::CreateUser::set_last_name): <p>The last name, or surname, of the user.</p>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::CreateUser::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::CreateUser::set_authentication_type): <p>The authentication type for the user. You must specify USERPOOL. </p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput)

    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAppBlock`](crate::client::fluent_builders::DeleteAppBlock) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteAppBlock::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteAppBlock::set_name): <p>The name of the app block.</p>
    /// - On success, responds with [`DeleteAppBlockOutput`](crate::output::DeleteAppBlockOutput)

    /// - On failure, responds with [`SdkError<DeleteAppBlockError>`](crate::error::DeleteAppBlockError)
    pub fn delete_app_block(&self) -> fluent_builders::DeleteAppBlock<C, M, R> {
        fluent_builders::DeleteAppBlock::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApplication`](crate::client::fluent_builders::DeleteApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteApplication::set_name): <p>The name of the application.</p>
    /// - On success, responds with [`DeleteApplicationOutput`](crate::output::DeleteApplicationOutput)

    /// - On failure, responds with [`SdkError<DeleteApplicationError>`](crate::error::DeleteApplicationError)
    pub fn delete_application(&self) -> fluent_builders::DeleteApplication<C, M, R> {
        fluent_builders::DeleteApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDirectoryConfig`](crate::client::fluent_builders::DeleteDirectoryConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDirectoryConfig::directory_name) / [`set_directory_name(Option<String>)`](crate::client::fluent_builders::DeleteDirectoryConfig::set_directory_name): <p>The name of the directory configuration.</p>
    /// - On success, responds with [`DeleteDirectoryConfigOutput`](crate::output::DeleteDirectoryConfigOutput)

    /// - On failure, responds with [`SdkError<DeleteDirectoryConfigError>`](crate::error::DeleteDirectoryConfigError)
    pub fn delete_directory_config(&self) -> fluent_builders::DeleteDirectoryConfig<C, M, R> {
        fluent_builders::DeleteDirectoryConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEntitlement`](crate::client::fluent_builders::DeleteEntitlement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteEntitlement::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteEntitlement::set_name): <p>The name of the entitlement.</p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEntitlement::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::DeleteEntitlement::set_stack_name): <p>The name of the stack with which the entitlement is associated.</p>
    /// - On success, responds with [`DeleteEntitlementOutput`](crate::output::DeleteEntitlementOutput)

    /// - On failure, responds with [`SdkError<DeleteEntitlementError>`](crate::error::DeleteEntitlementError)
    pub fn delete_entitlement(&self) -> fluent_builders::DeleteEntitlement<C, M, R> {
        fluent_builders::DeleteEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFleet`](crate::client::fluent_builders::DeleteFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteFleet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteFleet::set_name): <p>The name of the fleet.</p>
    /// - On success, responds with [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)

    /// - On failure, responds with [`SdkError<DeleteFleetError>`](crate::error::DeleteFleetError)
    pub fn delete_fleet(&self) -> fluent_builders::DeleteFleet<C, M, R> {
        fluent_builders::DeleteFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImage`](crate::client::fluent_builders::DeleteImage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteImage::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteImage::set_name): <p>The name of the image.</p>
    /// - On success, responds with [`DeleteImageOutput`](crate::output::DeleteImageOutput) with field(s):
    ///   - [`image(Option<Image>)`](crate::output::DeleteImageOutput::image): <p>Information about the image.</p>
    /// - On failure, responds with [`SdkError<DeleteImageError>`](crate::error::DeleteImageError)
    pub fn delete_image(&self) -> fluent_builders::DeleteImage<C, M, R> {
        fluent_builders::DeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImageBuilder`](crate::client::fluent_builders::DeleteImageBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteImageBuilder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteImageBuilder::set_name): <p>The name of the image builder.</p>
    /// - On success, responds with [`DeleteImageBuilderOutput`](crate::output::DeleteImageBuilderOutput) with field(s):
    ///   - [`image_builder(Option<ImageBuilder>)`](crate::output::DeleteImageBuilderOutput::image_builder): <p>Information about the image builder.</p>
    /// - On failure, responds with [`SdkError<DeleteImageBuilderError>`](crate::error::DeleteImageBuilderError)
    pub fn delete_image_builder(&self) -> fluent_builders::DeleteImageBuilder<C, M, R> {
        fluent_builders::DeleteImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteImagePermissions`](crate::client::fluent_builders::DeleteImagePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteImagePermissions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteImagePermissions::set_name): <p>The name of the private image.</p>
    ///   - [`shared_account_id(impl Into<String>)`](crate::client::fluent_builders::DeleteImagePermissions::shared_account_id) / [`set_shared_account_id(Option<String>)`](crate::client::fluent_builders::DeleteImagePermissions::set_shared_account_id): <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
    /// - On success, responds with [`DeleteImagePermissionsOutput`](crate::output::DeleteImagePermissionsOutput)

    /// - On failure, responds with [`SdkError<DeleteImagePermissionsError>`](crate::error::DeleteImagePermissionsError)
    pub fn delete_image_permissions(&self) -> fluent_builders::DeleteImagePermissions<C, M, R> {
        fluent_builders::DeleteImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteStack`](crate::client::fluent_builders::DeleteStack) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteStack::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteStack::set_name): <p>The name of the stack.</p>
    /// - On success, responds with [`DeleteStackOutput`](crate::output::DeleteStackOutput)

    /// - On failure, responds with [`SdkError<DeleteStackError>`](crate::error::DeleteStackError)
    pub fn delete_stack(&self) -> fluent_builders::DeleteStack<C, M, R> {
        fluent_builders::DeleteStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUsageReportSubscription`](crate::client::fluent_builders::DeleteUsageReportSubscription) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DeleteUsageReportSubscription::send) it.

    /// - On success, responds with [`DeleteUsageReportSubscriptionOutput`](crate::output::DeleteUsageReportSubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteUsageReportSubscriptionError>`](crate::error::DeleteUsageReportSubscriptionError)
    pub fn delete_usage_report_subscription(
        &self,
    ) -> fluent_builders::DeleteUsageReportSubscription<C, M, R> {
        fluent_builders::DeleteUsageReportSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_name): <p>The email address of the user.</p> <note>   <p>Users' email addresses are case-sensitive.</p>  </note>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::DeleteUser::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::DeleteUser::set_authentication_type): <p>The authentication type for the user. You must specify USERPOOL.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput)

    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAppBlocks`](crate::client::fluent_builders::DescribeAppBlocks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arns(Vec<String>)`](crate::client::fluent_builders::DescribeAppBlocks::arns) / [`set_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAppBlocks::set_arns): <p>The ARNs of the app blocks.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeAppBlocks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeAppBlocks::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeAppBlocks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeAppBlocks::set_max_results): <p>The maximum size of each page of results.</p>
    /// - On success, responds with [`DescribeAppBlocksOutput`](crate::output::DescribeAppBlocksOutput) with field(s):
    ///   - [`app_blocks(Option<Vec<AppBlock>>)`](crate::output::DescribeAppBlocksOutput::app_blocks): <p>The app blocks in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeAppBlocksOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeAppBlocksError>`](crate::error::DescribeAppBlocksError)
    pub fn describe_app_blocks(&self) -> fluent_builders::DescribeAppBlocks<C, M, R> {
        fluent_builders::DescribeAppBlocks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApplicationFleetAssociations`](crate::client::fluent_builders::DescribeApplicationFleetAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::set_fleet_name): <p>The name of the fleet.</p>
    ///   - [`application_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::application_arn) / [`set_application_arn(Option<String>)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::set_application_arn): <p>The ARN of the application.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::set_max_results): <p>The maximum size of each page of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeApplicationFleetAssociations::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On success, responds with [`DescribeApplicationFleetAssociationsOutput`](crate::output::DescribeApplicationFleetAssociationsOutput) with field(s):
    ///   - [`application_fleet_associations(Option<Vec<ApplicationFleetAssociation>>)`](crate::output::DescribeApplicationFleetAssociationsOutput::application_fleet_associations): <p>The application fleet associations in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeApplicationFleetAssociationsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeApplicationFleetAssociationsError>`](crate::error::DescribeApplicationFleetAssociationsError)
    pub fn describe_application_fleet_associations(
        &self,
    ) -> fluent_builders::DescribeApplicationFleetAssociations<C, M, R> {
        fluent_builders::DescribeApplicationFleetAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeApplications`](crate::client::fluent_builders::DescribeApplications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arns(Vec<String>)`](crate::client::fluent_builders::DescribeApplications::arns) / [`set_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeApplications::set_arns): <p>The ARNs for the applications.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeApplications::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeApplications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeApplications::set_max_results): <p>The maximum size of each page of results.</p>
    /// - On success, responds with [`DescribeApplicationsOutput`](crate::output::DescribeApplicationsOutput) with field(s):
    ///   - [`applications(Option<Vec<Application>>)`](crate::output::DescribeApplicationsOutput::applications): <p>The applications in the list.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeApplicationsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeApplicationsError>`](crate::error::DescribeApplicationsError)
    pub fn describe_applications(&self) -> fluent_builders::DescribeApplications<C, M, R> {
        fluent_builders::DescribeApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDirectoryConfigs`](crate::client::fluent_builders::DescribeDirectoryConfigs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_names(Vec<String>)`](crate::client::fluent_builders::DescribeDirectoryConfigs::directory_names) / [`set_directory_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeDirectoryConfigs::set_directory_names): <p>The directory names.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeDirectoryConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeDirectoryConfigs::set_max_results): <p>The maximum size of each page of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDirectoryConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDirectoryConfigs::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeDirectoryConfigsOutput`](crate::output::DescribeDirectoryConfigsOutput) with field(s):
    ///   - [`directory_configs(Option<Vec<DirectoryConfig>>)`](crate::output::DescribeDirectoryConfigsOutput::directory_configs): <p>Information about the directory configurations. Note that although the response syntax in this topic includes the account password, this password is not returned in the actual response. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDirectoryConfigsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeDirectoryConfigsError>`](crate::error::DescribeDirectoryConfigsError)
    pub fn describe_directory_configs(&self) -> fluent_builders::DescribeDirectoryConfigs<C, M, R> {
        fluent_builders::DescribeDirectoryConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEntitlements`](crate::client::fluent_builders::DescribeEntitlements) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeEntitlements::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeEntitlements::set_name): <p>The name of the entitlement.</p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEntitlements::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::DescribeEntitlements::set_stack_name): <p>The name of the stack with which the entitlement is associated.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEntitlements::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEntitlements::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeEntitlements::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeEntitlements::set_max_results): <p>The maximum size of each page of results.</p>
    /// - On success, responds with [`DescribeEntitlementsOutput`](crate::output::DescribeEntitlementsOutput) with field(s):
    ///   - [`entitlements(Option<Vec<Entitlement>>)`](crate::output::DescribeEntitlementsOutput::entitlements): <p>The entitlements.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEntitlementsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<DescribeEntitlementsError>`](crate::error::DescribeEntitlementsError)
    pub fn describe_entitlements(&self) -> fluent_builders::DescribeEntitlements<C, M, R> {
        fluent_builders::DescribeEntitlements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFleets`](crate::client::fluent_builders::DescribeFleets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DescribeFleets::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeFleets::set_names): <p>The names of the fleets to describe.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeFleets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeFleets::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeFleetsOutput`](crate::output::DescribeFleetsOutput) with field(s):
    ///   - [`fleets(Option<Vec<Fleet>>)`](crate::output::DescribeFleetsOutput::fleets): <p>Information about the fleets.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeFleetsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeFleetsError>`](crate::error::DescribeFleetsError)
    pub fn describe_fleets(&self) -> fluent_builders::DescribeFleets<C, M, R> {
        fluent_builders::DescribeFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImageBuilders`](crate::client::fluent_builders::DescribeImageBuilders) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DescribeImageBuilders::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImageBuilders::set_names): <p>The names of the image builders to describe.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImageBuilders::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImageBuilders::set_max_results): <p>The maximum size of each page of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImageBuilders::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImageBuilders::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeImageBuildersOutput`](crate::output::DescribeImageBuildersOutput) with field(s):
    ///   - [`image_builders(Option<Vec<ImageBuilder>>)`](crate::output::DescribeImageBuildersOutput::image_builders): <p>Information about the image builders.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImageBuildersOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeImageBuildersError>`](crate::error::DescribeImageBuildersError)
    pub fn describe_image_builders(&self) -> fluent_builders::DescribeImageBuilders<C, M, R> {
        fluent_builders::DescribeImageBuilders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImagePermissions`](crate::client::fluent_builders::DescribeImagePermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeImagePermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DescribeImagePermissions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DescribeImagePermissions::set_name): <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImagePermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImagePermissions::set_max_results): <p>The maximum size of each page of results.</p>
    ///   - [`shared_aws_account_ids(Vec<String>)`](crate::client::fluent_builders::DescribeImagePermissions::shared_aws_account_ids) / [`set_shared_aws_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImagePermissions::set_shared_aws_account_ids): <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImagePermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImagePermissions::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeImagePermissionsOutput`](crate::output::DescribeImagePermissionsOutput) with field(s):
    ///   - [`name(Option<String>)`](crate::output::DescribeImagePermissionsOutput::name): <p>The name of the private image.</p>
    ///   - [`shared_image_permissions_list(Option<Vec<SharedImagePermissions>>)`](crate::output::DescribeImagePermissionsOutput::shared_image_permissions_list): <p>The permissions for a private image that you own. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImagePermissionsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeImagePermissionsError>`](crate::error::DescribeImagePermissionsError)
    pub fn describe_image_permissions(&self) -> fluent_builders::DescribeImagePermissions<C, M, R> {
        fluent_builders::DescribeImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeImages`](crate::client::fluent_builders::DescribeImages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeImages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DescribeImages::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImages::set_names): <p>The names of the public or private images to describe.</p>
    ///   - [`arns(Vec<String>)`](crate::client::fluent_builders::DescribeImages::arns) / [`set_arns(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeImages::set_arns): <p>The ARNs of the public, private, and shared images to describe.</p>
    ///   - [`r#type(VisibilityType)`](crate::client::fluent_builders::DescribeImages::r#type) / [`set_type(Option<VisibilityType>)`](crate::client::fluent_builders::DescribeImages::set_type): <p>The type of image (public, private, or shared) to describe. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeImages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeImages::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeImages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeImages::set_max_results): <p>The maximum size of each page of results.</p>
    /// - On success, responds with [`DescribeImagesOutput`](crate::output::DescribeImagesOutput) with field(s):
    ///   - [`images(Option<Vec<Image>>)`](crate::output::DescribeImagesOutput::images): <p>Information about the images.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeImagesOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeImagesError>`](crate::error::DescribeImagesError)
    pub fn describe_images(&self) -> fluent_builders::DescribeImages<C, M, R> {
        fluent_builders::DescribeImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSessions`](crate::client::fluent_builders::DescribeSessions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSessions::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::DescribeSessions::set_stack_name): <p>The name of the stack. This value is case-sensitive.</p>
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSessions::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::DescribeSessions::set_fleet_name): <p>The name of the fleet. This value is case-sensitive.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSessions::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DescribeSessions::set_user_id): <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSessions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSessions::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeSessions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeSessions::set_limit): <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::DescribeSessions::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::DescribeSessions::set_authentication_type): <p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>
    /// - On success, responds with [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput) with field(s):
    ///   - [`sessions(Option<Vec<Session>>)`](crate::output::DescribeSessionsOutput::sessions): <p>Information about the streaming sessions.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSessionsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeSessionsError>`](crate::error::DescribeSessionsError)
    pub fn describe_sessions(&self) -> fluent_builders::DescribeSessions<C, M, R> {
        fluent_builders::DescribeSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStacks`](crate::client::fluent_builders::DescribeStacks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::DescribeStacks::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeStacks::set_names): <p>The names of the stacks to describe.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeStacks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeStacks::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeStacksOutput`](crate::output::DescribeStacksOutput) with field(s):
    ///   - [`stacks(Option<Vec<Stack>>)`](crate::output::DescribeStacksOutput::stacks): <p>Information about the stacks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeStacksOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeStacksError>`](crate::error::DescribeStacksError)
    pub fn describe_stacks(&self) -> fluent_builders::DescribeStacks<C, M, R> {
        fluent_builders::DescribeStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUsageReportSubscriptions`](crate::client::fluent_builders::DescribeUsageReportSubscriptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeUsageReportSubscriptions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeUsageReportSubscriptions::set_max_results): <p>The maximum size of each page of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeUsageReportSubscriptions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeUsageReportSubscriptions::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeUsageReportSubscriptionsOutput`](crate::output::DescribeUsageReportSubscriptionsOutput) with field(s):
    ///   - [`usage_report_subscriptions(Option<Vec<UsageReportSubscription>>)`](crate::output::DescribeUsageReportSubscriptionsOutput::usage_report_subscriptions): <p>Information about the usage report subscription.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeUsageReportSubscriptionsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeUsageReportSubscriptionsError>`](crate::error::DescribeUsageReportSubscriptionsError)
    pub fn describe_usage_report_subscriptions(
        &self,
    ) -> fluent_builders::DescribeUsageReportSubscriptions<C, M, R> {
        fluent_builders::DescribeUsageReportSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUsers`](crate::client::fluent_builders::DescribeUsers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::DescribeUsers::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::DescribeUsers::set_authentication_type): <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeUsers::set_max_results): <p>The maximum size of each page of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeUsers::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeUsersOutput`](crate::output::DescribeUsersOutput) with field(s):
    ///   - [`users(Option<Vec<User>>)`](crate::output::DescribeUsersOutput::users): <p>Information about users in the user pool.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeUsersOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeUsersError>`](crate::error::DescribeUsersError)
    pub fn describe_users(&self) -> fluent_builders::DescribeUsers<C, M, R> {
        fluent_builders::DescribeUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserStackAssociations`](crate::client::fluent_builders::DescribeUserStackAssociations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUserStackAssociations::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::DescribeUserStackAssociations::set_stack_name): <p>The name of the stack that is associated with the user.</p>
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DescribeUserStackAssociations::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DescribeUserStackAssociations::set_user_name): <p>The email address of the user who is associated with the stack.</p> <note>   <p>Users' email addresses are case-sensitive.</p>  </note>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::DescribeUserStackAssociations::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::DescribeUserStackAssociations::set_authentication_type): <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeUserStackAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeUserStackAssociations::set_max_results): <p>The maximum size of each page of results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeUserStackAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeUserStackAssociations::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`DescribeUserStackAssociationsOutput`](crate::output::DescribeUserStackAssociationsOutput) with field(s):
    ///   - [`user_stack_associations(Option<Vec<UserStackAssociation>>)`](crate::output::DescribeUserStackAssociationsOutput::user_stack_associations): <p>The UserStackAssociation objects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeUserStackAssociationsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<DescribeUserStackAssociationsError>`](crate::error::DescribeUserStackAssociationsError)
    pub fn describe_user_stack_associations(
        &self,
    ) -> fluent_builders::DescribeUserStackAssociations<C, M, R> {
        fluent_builders::DescribeUserStackAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableUser`](crate::client::fluent_builders::DisableUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::DisableUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::DisableUser::set_user_name): <p>The email address of the user.</p> <note>   <p>Users' email addresses are case-sensitive.</p>  </note>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::DisableUser::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::DisableUser::set_authentication_type): <p>The authentication type for the user. You must specify USERPOOL.</p>
    /// - On success, responds with [`DisableUserOutput`](crate::output::DisableUserOutput)

    /// - On failure, responds with [`SdkError<DisableUserError>`](crate::error::DisableUserError)
    pub fn disable_user(&self) -> fluent_builders::DisableUser<C, M, R> {
        fluent_builders::DisableUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateApplicationFleet`](crate::client::fluent_builders::DisassociateApplicationFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateApplicationFleet::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::DisassociateApplicationFleet::set_fleet_name): <p>The name of the fleet.</p>
    ///   - [`application_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateApplicationFleet::application_arn) / [`set_application_arn(Option<String>)`](crate::client::fluent_builders::DisassociateApplicationFleet::set_application_arn): <p>The ARN of the application.</p>
    /// - On success, responds with [`DisassociateApplicationFleetOutput`](crate::output::DisassociateApplicationFleetOutput)

    /// - On failure, responds with [`SdkError<DisassociateApplicationFleetError>`](crate::error::DisassociateApplicationFleetError)
    pub fn disassociate_application_fleet(
        &self,
    ) -> fluent_builders::DisassociateApplicationFleet<C, M, R> {
        fluent_builders::DisassociateApplicationFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateApplicationFromEntitlement`](crate::client::fluent_builders::DisassociateApplicationFromEntitlement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateApplicationFromEntitlement::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::DisassociateApplicationFromEntitlement::set_stack_name): <p>The name of the stack with which the entitlement is associated.</p>
    ///   - [`entitlement_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateApplicationFromEntitlement::entitlement_name) / [`set_entitlement_name(Option<String>)`](crate::client::fluent_builders::DisassociateApplicationFromEntitlement::set_entitlement_name): <p>The name of the entitlement.</p>
    ///   - [`application_identifier(impl Into<String>)`](crate::client::fluent_builders::DisassociateApplicationFromEntitlement::application_identifier) / [`set_application_identifier(Option<String>)`](crate::client::fluent_builders::DisassociateApplicationFromEntitlement::set_application_identifier): <p>The identifier of the application to remove from the entitlement.</p>
    /// - On success, responds with [`DisassociateApplicationFromEntitlementOutput`](crate::output::DisassociateApplicationFromEntitlementOutput)

    /// - On failure, responds with [`SdkError<DisassociateApplicationFromEntitlementError>`](crate::error::DisassociateApplicationFromEntitlementError)
    pub fn disassociate_application_from_entitlement(
        &self,
    ) -> fluent_builders::DisassociateApplicationFromEntitlement<C, M, R> {
        fluent_builders::DisassociateApplicationFromEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFleet`](crate::client::fluent_builders::DisassociateFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateFleet::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::DisassociateFleet::set_fleet_name): <p>The name of the fleet.</p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateFleet::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::DisassociateFleet::set_stack_name): <p>The name of the stack.</p>
    /// - On success, responds with [`DisassociateFleetOutput`](crate::output::DisassociateFleetOutput)

    /// - On failure, responds with [`SdkError<DisassociateFleetError>`](crate::error::DisassociateFleetError)
    pub fn disassociate_fleet(&self) -> fluent_builders::DisassociateFleet<C, M, R> {
        fluent_builders::DisassociateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableUser`](crate::client::fluent_builders::EnableUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_name(impl Into<String>)`](crate::client::fluent_builders::EnableUser::user_name) / [`set_user_name(Option<String>)`](crate::client::fluent_builders::EnableUser::set_user_name): <p>The email address of the user.</p> <note>   <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>  </note>
    ///   - [`authentication_type(AuthenticationType)`](crate::client::fluent_builders::EnableUser::authentication_type) / [`set_authentication_type(Option<AuthenticationType>)`](crate::client::fluent_builders::EnableUser::set_authentication_type): <p>The authentication type for the user. You must specify USERPOOL.</p>
    /// - On success, responds with [`EnableUserOutput`](crate::output::EnableUserOutput)

    /// - On failure, responds with [`SdkError<EnableUserError>`](crate::error::EnableUserError)
    pub fn enable_user(&self) -> fluent_builders::EnableUser<C, M, R> {
        fluent_builders::EnableUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExpireSession`](crate::client::fluent_builders::ExpireSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`session_id(impl Into<String>)`](crate::client::fluent_builders::ExpireSession::session_id) / [`set_session_id(Option<String>)`](crate::client::fluent_builders::ExpireSession::set_session_id): <p>The identifier of the streaming session.</p>
    /// - On success, responds with [`ExpireSessionOutput`](crate::output::ExpireSessionOutput)

    /// - On failure, responds with [`SdkError<ExpireSessionError>`](crate::error::ExpireSessionError)
    pub fn expire_session(&self) -> fluent_builders::ExpireSession<C, M, R> {
        fluent_builders::ExpireSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociatedFleets`](crate::client::fluent_builders::ListAssociatedFleets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedFleets::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::ListAssociatedFleets::set_stack_name): <p>The name of the stack.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedFleets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociatedFleets::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`ListAssociatedFleetsOutput`](crate::output::ListAssociatedFleetsOutput) with field(s):
    ///   - [`names(Option<Vec<String>>)`](crate::output::ListAssociatedFleetsOutput::names): <p>The name of the fleet.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociatedFleetsOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListAssociatedFleetsError>`](crate::error::ListAssociatedFleetsError)
    pub fn list_associated_fleets(&self) -> fluent_builders::ListAssociatedFleets<C, M, R> {
        fluent_builders::ListAssociatedFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociatedStacks`](crate::client::fluent_builders::ListAssociatedStacks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`fleet_name(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedStacks::fleet_name) / [`set_fleet_name(Option<String>)`](crate::client::fluent_builders::ListAssociatedStacks::set_fleet_name): <p>The name of the fleet.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedStacks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociatedStacks::set_next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
    /// - On success, responds with [`ListAssociatedStacksOutput`](crate::output::ListAssociatedStacksOutput) with field(s):
    ///   - [`names(Option<Vec<String>>)`](crate::output::ListAssociatedStacksOutput::names): <p>The name of the stack.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociatedStacksOutput::next_token): <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    /// - On failure, responds with [`SdkError<ListAssociatedStacksError>`](crate::error::ListAssociatedStacksError)
    pub fn list_associated_stacks(&self) -> fluent_builders::ListAssociatedStacks<C, M, R> {
        fluent_builders::ListAssociatedStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEntitledApplications`](crate::client::fluent_builders::ListEntitledApplications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::ListEntitledApplications::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::ListEntitledApplications::set_stack_name): <p>The name of the stack with which the entitlement is associated.</p>
    ///   - [`entitlement_name(impl Into<String>)`](crate::client::fluent_builders::ListEntitledApplications::entitlement_name) / [`set_entitlement_name(Option<String>)`](crate::client::fluent_builders::ListEntitledApplications::set_entitlement_name): <p>The name of the entitlement.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEntitledApplications::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEntitledApplications::set_next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEntitledApplications::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListEntitledApplications::set_max_results): <p>The maximum size of each page of results.</p>
    /// - On success, responds with [`ListEntitledApplicationsOutput`](crate::output::ListEntitledApplicationsOutput) with field(s):
    ///   - [`entitled_applications(Option<Vec<EntitledApplication>>)`](crate::output::ListEntitledApplicationsOutput::entitled_applications): <p>The entitled applications.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListEntitledApplicationsOutput::next_token): <p>The pagination token used to retrieve the next page of results for this operation.</p>
    /// - On failure, responds with [`SdkError<ListEntitledApplicationsError>`](crate::error::ListEntitledApplicationsError)
    pub fn list_entitled_applications(&self) -> fluent_builders::ListEntitledApplications<C, M, R> {
        fluent_builders::ListEntitledApplications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The information about the tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFleet`](crate::client::fluent_builders::StartFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartFleet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartFleet::set_name): <p>The name of the fleet.</p>
    /// - On success, responds with [`StartFleetOutput`](crate::output::StartFleetOutput)

    /// - On failure, responds with [`SdkError<StartFleetError>`](crate::error::StartFleetError)
    pub fn start_fleet(&self) -> fluent_builders::StartFleet<C, M, R> {
        fluent_builders::StartFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartImageBuilder`](crate::client::fluent_builders::StartImageBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartImageBuilder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartImageBuilder::set_name): <p>The name of the image builder.</p>
    ///   - [`appstream_agent_version(impl Into<String>)`](crate::client::fluent_builders::StartImageBuilder::appstream_agent_version) / [`set_appstream_agent_version(Option<String>)`](crate::client::fluent_builders::StartImageBuilder::set_appstream_agent_version): <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
    /// - On success, responds with [`StartImageBuilderOutput`](crate::output::StartImageBuilderOutput) with field(s):
    ///   - [`image_builder(Option<ImageBuilder>)`](crate::output::StartImageBuilderOutput::image_builder): <p>Information about the image builder.</p>
    /// - On failure, responds with [`SdkError<StartImageBuilderError>`](crate::error::StartImageBuilderError)
    pub fn start_image_builder(&self) -> fluent_builders::StartImageBuilder<C, M, R> {
        fluent_builders::StartImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopFleet`](crate::client::fluent_builders::StopFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StopFleet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StopFleet::set_name): <p>The name of the fleet.</p>
    /// - On success, responds with [`StopFleetOutput`](crate::output::StopFleetOutput)

    /// - On failure, responds with [`SdkError<StopFleetError>`](crate::error::StopFleetError)
    pub fn stop_fleet(&self) -> fluent_builders::StopFleet<C, M, R> {
        fluent_builders::StopFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopImageBuilder`](crate::client::fluent_builders::StopImageBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StopImageBuilder::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StopImageBuilder::set_name): <p>The name of the image builder.</p>
    /// - On success, responds with [`StopImageBuilderOutput`](crate::output::StopImageBuilderOutput) with field(s):
    ///   - [`image_builder(Option<ImageBuilder>)`](crate::output::StopImageBuilderOutput::image_builder): <p>Information about the image builder.</p>
    /// - On failure, responds with [`SdkError<StopImageBuilderError>`](crate::error::StopImageBuilderError)
    pub fn stop_image_builder(&self) -> fluent_builders::StopImageBuilder<C, M, R> {
        fluent_builders::StopImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>  <p>If you do not specify a value, the value is set to an empty string.</p>  <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>  <p>_ . : / = + \ - @</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys for the tags to disassociate.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApplication`](crate::client::fluent_builders::UpdateApplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_name): <p>The name of the application. This name is visible to users when display name is not specified.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_display_name): <p>The display name of the application. This name is visible to users in the application catalog.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_description): <p>The description of the application.</p>
    ///   - [`icon_s3_location(S3Location)`](crate::client::fluent_builders::UpdateApplication::icon_s3_location) / [`set_icon_s3_location(Option<S3Location>)`](crate::client::fluent_builders::UpdateApplication::set_icon_s3_location): <p>The icon S3 location of the application.</p>
    ///   - [`launch_path(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::launch_path) / [`set_launch_path(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_launch_path): <p>The launch path of the application.</p>
    ///   - [`working_directory(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::working_directory) / [`set_working_directory(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_working_directory): <p>The working directory of the application.</p>
    ///   - [`launch_parameters(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::launch_parameters) / [`set_launch_parameters(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_launch_parameters): <p>The launch parameters of the application.</p>
    ///   - [`app_block_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateApplication::app_block_arn) / [`set_app_block_arn(Option<String>)`](crate::client::fluent_builders::UpdateApplication::set_app_block_arn): <p>The ARN of the app block.</p>
    ///   - [`attributes_to_delete(Vec<ApplicationAttribute>)`](crate::client::fluent_builders::UpdateApplication::attributes_to_delete) / [`set_attributes_to_delete(Option<Vec<ApplicationAttribute>>)`](crate::client::fluent_builders::UpdateApplication::set_attributes_to_delete): <p>The attributes to delete for an application.</p>
    /// - On success, responds with [`UpdateApplicationOutput`](crate::output::UpdateApplicationOutput) with field(s):
    ///   - [`application(Option<Application>)`](crate::output::UpdateApplicationOutput::application): <p>Describes an application in the application catalog.</p>
    /// - On failure, responds with [`SdkError<UpdateApplicationError>`](crate::error::UpdateApplicationError)
    pub fn update_application(&self) -> fluent_builders::UpdateApplication<C, M, R> {
        fluent_builders::UpdateApplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDirectoryConfig`](crate::client::fluent_builders::UpdateDirectoryConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`directory_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDirectoryConfig::directory_name) / [`set_directory_name(Option<String>)`](crate::client::fluent_builders::UpdateDirectoryConfig::set_directory_name): <p>The name of the Directory Config object.</p>
    ///   - [`organizational_unit_distinguished_names(Vec<String>)`](crate::client::fluent_builders::UpdateDirectoryConfig::organizational_unit_distinguished_names) / [`set_organizational_unit_distinguished_names(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateDirectoryConfig::set_organizational_unit_distinguished_names): <p>The distinguished names of the organizational units for computer accounts.</p>
    ///   - [`service_account_credentials(ServiceAccountCredentials)`](crate::client::fluent_builders::UpdateDirectoryConfig::service_account_credentials) / [`set_service_account_credentials(Option<ServiceAccountCredentials>)`](crate::client::fluent_builders::UpdateDirectoryConfig::set_service_account_credentials): <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    /// - On success, responds with [`UpdateDirectoryConfigOutput`](crate::output::UpdateDirectoryConfigOutput) with field(s):
    ///   - [`directory_config(Option<DirectoryConfig>)`](crate::output::UpdateDirectoryConfigOutput::directory_config): <p>Information about the Directory Config object.</p>
    /// - On failure, responds with [`SdkError<UpdateDirectoryConfigError>`](crate::error::UpdateDirectoryConfigError)
    pub fn update_directory_config(&self) -> fluent_builders::UpdateDirectoryConfig<C, M, R> {
        fluent_builders::UpdateDirectoryConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEntitlement`](crate::client::fluent_builders::UpdateEntitlement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateEntitlement::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateEntitlement::set_name): <p>The name of the entitlement.</p>
    ///   - [`stack_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEntitlement::stack_name) / [`set_stack_name(Option<String>)`](crate::client::fluent_builders::UpdateEntitlement::set_stack_name): <p>The name of the stack with which the entitlement is associated.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateEntitlement::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateEntitlement::set_description): <p>The description of the entitlement.</p>
    ///   - [`app_visibility(AppVisibility)`](crate::client::fluent_builders::UpdateEntitlement::app_visibility) / [`set_app_visibility(Option<AppVisibility>)`](crate::client::fluent_builders::UpdateEntitlement::set_app_visibility): <p>Specifies whether all or only selected apps are entitled.</p>
    ///   - [`attributes(Vec<EntitlementAttribute>)`](crate::client::fluent_builders::UpdateEntitlement::attributes) / [`set_attributes(Option<Vec<EntitlementAttribute>>)`](crate::client::fluent_builders::UpdateEntitlement::set_attributes): <p>The attributes of the entitlement.</p>
    /// - On success, responds with [`UpdateEntitlementOutput`](crate::output::UpdateEntitlementOutput) with field(s):
    ///   - [`entitlement(Option<Entitlement>)`](crate::output::UpdateEntitlementOutput::entitlement): <p>The entitlement.</p>
    /// - On failure, responds with [`SdkError<UpdateEntitlementError>`](crate::error::UpdateEntitlementError)
    pub fn update_entitlement(&self) -> fluent_builders::UpdateEntitlement<C, M, R> {
        fluent_builders::UpdateEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFleet`](crate::client::fluent_builders::UpdateFleet) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`image_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFleet::image_name) / [`set_image_name(Option<String>)`](crate::client::fluent_builders::UpdateFleet::set_image_name): <p>The name of the image used to create the fleet.</p>
    ///   - [`image_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFleet::image_arn) / [`set_image_arn(Option<String>)`](crate::client::fluent_builders::UpdateFleet::set_image_arn): <p>The ARN of the public, private, or shared image to use.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFleet::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFleet::set_name): <p>A unique name for the fleet.</p>
    ///   - [`instance_type(impl Into<String>)`](crate::client::fluent_builders::UpdateFleet::instance_type) / [`set_instance_type(Option<String>)`](crate::client::fluent_builders::UpdateFleet::set_instance_type): <p>The instance type to use when launching fleet instances. The following instance types are available:</p>  <ul>   <li> <p>stream.standard.small</p> </li>   <li> <p>stream.standard.medium</p> </li>   <li> <p>stream.standard.large</p> </li>   <li> <p>stream.compute.large</p> </li>   <li> <p>stream.compute.xlarge</p> </li>   <li> <p>stream.compute.2xlarge</p> </li>   <li> <p>stream.compute.4xlarge</p> </li>   <li> <p>stream.compute.8xlarge</p> </li>   <li> <p>stream.memory.large</p> </li>   <li> <p>stream.memory.xlarge</p> </li>   <li> <p>stream.memory.2xlarge</p> </li>   <li> <p>stream.memory.4xlarge</p> </li>   <li> <p>stream.memory.8xlarge</p> </li>   <li> <p>stream.memory.z1d.large</p> </li>   <li> <p>stream.memory.z1d.xlarge</p> </li>   <li> <p>stream.memory.z1d.2xlarge</p> </li>   <li> <p>stream.memory.z1d.3xlarge</p> </li>   <li> <p>stream.memory.z1d.6xlarge</p> </li>   <li> <p>stream.memory.z1d.12xlarge</p> </li>   <li> <p>stream.graphics-design.large</p> </li>   <li> <p>stream.graphics-design.xlarge</p> </li>   <li> <p>stream.graphics-design.2xlarge</p> </li>   <li> <p>stream.graphics-design.4xlarge</p> </li>   <li> <p>stream.graphics-desktop.2xlarge</p> </li>   <li> <p>stream.graphics.g4dn.xlarge</p> </li>   <li> <p>stream.graphics.g4dn.2xlarge</p> </li>   <li> <p>stream.graphics.g4dn.4xlarge</p> </li>   <li> <p>stream.graphics.g4dn.8xlarge</p> </li>   <li> <p>stream.graphics.g4dn.12xlarge</p> </li>   <li> <p>stream.graphics.g4dn.16xlarge</p> </li>   <li> <p>stream.graphics-pro.4xlarge</p> </li>   <li> <p>stream.graphics-pro.8xlarge</p> </li>   <li> <p>stream.graphics-pro.16xlarge</p> </li>  </ul>  <p>The following instance types are available for Elastic fleets:</p>  <ul>   <li> <p>stream.standard.small</p> </li>   <li> <p>stream.standard.medium</p> </li>  </ul>
    ///   - [`compute_capacity(ComputeCapacity)`](crate::client::fluent_builders::UpdateFleet::compute_capacity) / [`set_compute_capacity(Option<ComputeCapacity>)`](crate::client::fluent_builders::UpdateFleet::set_compute_capacity): <p>The desired capacity for the fleet. This is not allowed for Elastic fleets.</p>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::UpdateFleet::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::UpdateFleet::set_vpc_config): <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones. </p>
    ///   - [`max_user_duration_in_seconds(i32)`](crate::client::fluent_builders::UpdateFleet::max_user_duration_in_seconds) / [`set_max_user_duration_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateFleet::set_max_user_duration_in_seconds): <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>  <p>Specify a value between 600 and 360000.</p>
    ///   - [`disconnect_timeout_in_seconds(i32)`](crate::client::fluent_builders::UpdateFleet::disconnect_timeout_in_seconds) / [`set_disconnect_timeout_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateFleet::set_disconnect_timeout_in_seconds): <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>  <p>Specify a value between 60 and 360000.</p>
    ///   - [`delete_vpc_config(bool)`](crate::client::fluent_builders::UpdateFleet::delete_vpc_config) / [`set_delete_vpc_config(bool)`](crate::client::fluent_builders::UpdateFleet::set_delete_vpc_config): <p>Deletes the VPC association for the specified fleet.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFleet::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFleet::set_description): <p>The description to display.</p>
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFleet::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateFleet::set_display_name): <p>The fleet name to display.</p>
    ///   - [`enable_default_internet_access(bool)`](crate::client::fluent_builders::UpdateFleet::enable_default_internet_access) / [`set_enable_default_internet_access(Option<bool>)`](crate::client::fluent_builders::UpdateFleet::set_enable_default_internet_access): <p>Enables or disables default internet access for the fleet.</p>
    ///   - [`domain_join_info(DomainJoinInfo)`](crate::client::fluent_builders::UpdateFleet::domain_join_info) / [`set_domain_join_info(Option<DomainJoinInfo>)`](crate::client::fluent_builders::UpdateFleet::set_domain_join_info): <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
    ///   - [`idle_disconnect_timeout_in_seconds(i32)`](crate::client::fluent_builders::UpdateFleet::idle_disconnect_timeout_in_seconds) / [`set_idle_disconnect_timeout_in_seconds(Option<i32>)`](crate::client::fluent_builders::UpdateFleet::set_idle_disconnect_timeout_in_seconds): <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p>  <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>   <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>  </note>
    ///   - [`attributes_to_delete(Vec<FleetAttribute>)`](crate::client::fluent_builders::UpdateFleet::attributes_to_delete) / [`set_attributes_to_delete(Option<Vec<FleetAttribute>>)`](crate::client::fluent_builders::UpdateFleet::set_attributes_to_delete): <p>The fleet attributes to delete.</p>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFleet::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::UpdateFleet::set_iam_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    ///   - [`stream_view(StreamView)`](crate::client::fluent_builders::UpdateFleet::stream_view) / [`set_stream_view(Option<StreamView>)`](crate::client::fluent_builders::UpdateFleet::set_stream_view): <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>  <p>The default value is <code>APP</code>.</p>
    ///   - [`platform(PlatformType)`](crate::client::fluent_builders::UpdateFleet::platform) / [`set_platform(Option<PlatformType>)`](crate::client::fluent_builders::UpdateFleet::set_platform): <p>The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
    ///   - [`max_concurrent_sessions(i32)`](crate::client::fluent_builders::UpdateFleet::max_concurrent_sessions) / [`set_max_concurrent_sessions(Option<i32>)`](crate::client::fluent_builders::UpdateFleet::set_max_concurrent_sessions): <p>The maximum number of concurrent sessions for a fleet.</p>
    ///   - [`usb_device_filter_strings(Vec<String>)`](crate::client::fluent_builders::UpdateFleet::usb_device_filter_strings) / [`set_usb_device_filter_strings(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFleet::set_usb_device_filter_strings): <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
    /// - On success, responds with [`UpdateFleetOutput`](crate::output::UpdateFleetOutput) with field(s):
    ///   - [`fleet(Option<Fleet>)`](crate::output::UpdateFleetOutput::fleet): <p>Information about the fleet.</p>
    /// - On failure, responds with [`SdkError<UpdateFleetError>`](crate::error::UpdateFleetError)
    pub fn update_fleet(&self) -> fluent_builders::UpdateFleet<C, M, R> {
        fluent_builders::UpdateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateImagePermissions`](crate::client::fluent_builders::UpdateImagePermissions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePermissions::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateImagePermissions::set_name): <p>The name of the private image.</p>
    ///   - [`shared_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateImagePermissions::shared_account_id) / [`set_shared_account_id(Option<String>)`](crate::client::fluent_builders::UpdateImagePermissions::set_shared_account_id): <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
    ///   - [`image_permissions(ImagePermissions)`](crate::client::fluent_builders::UpdateImagePermissions::image_permissions) / [`set_image_permissions(Option<ImagePermissions>)`](crate::client::fluent_builders::UpdateImagePermissions::set_image_permissions): <p>The permissions for the image.</p>
    /// - On success, responds with [`UpdateImagePermissionsOutput`](crate::output::UpdateImagePermissionsOutput)

    /// - On failure, responds with [`SdkError<UpdateImagePermissionsError>`](crate::error::UpdateImagePermissionsError)
    pub fn update_image_permissions(&self) -> fluent_builders::UpdateImagePermissions<C, M, R> {
        fluent_builders::UpdateImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateStack`](crate::client::fluent_builders::UpdateStack) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`display_name(impl Into<String>)`](crate::client::fluent_builders::UpdateStack::display_name) / [`set_display_name(Option<String>)`](crate::client::fluent_builders::UpdateStack::set_display_name): <p>The stack name to display.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateStack::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateStack::set_description): <p>The description to display.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateStack::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateStack::set_name): <p>The name of the stack.</p>
    ///   - [`storage_connectors(Vec<StorageConnector>)`](crate::client::fluent_builders::UpdateStack::storage_connectors) / [`set_storage_connectors(Option<Vec<StorageConnector>>)`](crate::client::fluent_builders::UpdateStack::set_storage_connectors): <p>The storage connectors to enable.</p>
    ///   - [`delete_storage_connectors(bool)`](crate::client::fluent_builders::UpdateStack::delete_storage_connectors) / [`set_delete_storage_connectors(bool)`](crate::client::fluent_builders::UpdateStack::set_delete_storage_connectors): <p>Deletes the storage connectors currently enabled for the stack.</p>
    ///   - [`redirect_url(impl Into<String>)`](crate::client::fluent_builders::UpdateStack::redirect_url) / [`set_redirect_url(Option<String>)`](crate::client::fluent_builders::UpdateStack::set_redirect_url): <p>The URL that users are redirected to after their streaming session ends.</p>
    ///   - [`feedback_url(impl Into<String>)`](crate::client::fluent_builders::UpdateStack::feedback_url) / [`set_feedback_url(Option<String>)`](crate::client::fluent_builders::UpdateStack::set_feedback_url): <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    ///   - [`attributes_to_delete(Vec<StackAttribute>)`](crate::client::fluent_builders::UpdateStack::attributes_to_delete) / [`set_attributes_to_delete(Option<Vec<StackAttribute>>)`](crate::client::fluent_builders::UpdateStack::set_attributes_to_delete): <p>The stack attributes to delete.</p>
    ///   - [`user_settings(Vec<UserSetting>)`](crate::client::fluent_builders::UpdateStack::user_settings) / [`set_user_settings(Option<Vec<UserSetting>>)`](crate::client::fluent_builders::UpdateStack::set_user_settings): <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
    ///   - [`application_settings(ApplicationSettings)`](crate::client::fluent_builders::UpdateStack::application_settings) / [`set_application_settings(Option<ApplicationSettings>)`](crate::client::fluent_builders::UpdateStack::set_application_settings): <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
    ///   - [`access_endpoints(Vec<AccessEndpoint>)`](crate::client::fluent_builders::UpdateStack::access_endpoints) / [`set_access_endpoints(Option<Vec<AccessEndpoint>>)`](crate::client::fluent_builders::UpdateStack::set_access_endpoints): <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
    ///   - [`embed_host_domains(Vec<String>)`](crate::client::fluent_builders::UpdateStack::embed_host_domains) / [`set_embed_host_domains(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateStack::set_embed_host_domains): <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
    /// - On success, responds with [`UpdateStackOutput`](crate::output::UpdateStackOutput) with field(s):
    ///   - [`stack(Option<Stack>)`](crate::output::UpdateStackOutput::stack): <p>Information about the stack.</p>
    /// - On failure, responds with [`SdkError<UpdateStackError>`](crate::error::UpdateStackError)
    pub fn update_stack(&self) -> fluent_builders::UpdateStack<C, M, R> {
        fluent_builders::UpdateStack::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateApplicationFleet`.
    ///
    /// <p>Associates the specified application with the specified fleet. This is only supported for Elastic fleets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateApplicationFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_application_fleet_input::Builder,
    }
    impl<C, M, R> AssociateApplicationFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateApplicationFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateApplicationFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateApplicationFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateApplicationFleetInputOperationOutputAlias,
                crate::output::AssociateApplicationFleetOutput,
                crate::error::AssociateApplicationFleetError,
                crate::input::AssociateApplicationFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_arn(input.into());
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateApplicationToEntitlement`.
    ///
    /// <p>Associates an application to entitle.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateApplicationToEntitlement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_application_to_entitlement_input::Builder,
    }
    impl<C, M, R> AssociateApplicationToEntitlement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateApplicationToEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateApplicationToEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateApplicationToEntitlementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateApplicationToEntitlementInputOperationOutputAlias,
                crate::output::AssociateApplicationToEntitlementOutput,
                crate::error::AssociateApplicationToEntitlementError,
                crate::input::AssociateApplicationToEntitlementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn entitlement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_name(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_entitlement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_name(input);
            self
        }
        /// <p>The identifier of the application.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The identifier of the application.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateFleet`.
    ///
    /// <p>Associates the specified fleet with the specified stack.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_fleet_input::Builder,
    }
    impl<C, M, R> AssociateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateFleetInputOperationOutputAlias,
                crate::output::AssociateFleetOutput,
                crate::error::AssociateFleetError,
                crate::input::AssociateFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet. </p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet. </p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateUserStack`.
    ///
    /// <p>Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchAssociateUserStack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_associate_user_stack_input::Builder,
    }
    impl<C, M, R> BatchAssociateUserStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchAssociateUserStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateUserStackOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchAssociateUserStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchAssociateUserStackInputOperationOutputAlias,
                crate::output::BatchAssociateUserStackOutput,
                crate::error::BatchAssociateUserStackError,
                crate::input::BatchAssociateUserStackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UserStackAssociations`.
        ///
        /// To override the contents of this collection use [`set_user_stack_associations`](Self::set_user_stack_associations).
        ///
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn user_stack_associations(
            mut self,
            input: crate::model::UserStackAssociation,
        ) -> Self {
            self.inner = self.inner.user_stack_associations(input);
            self
        }
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn set_user_stack_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_user_stack_associations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateUserStack`.
    ///
    /// <p>Disassociates the specified users from the specified stacks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisassociateUserStack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_disassociate_user_stack_input::Builder,
    }
    impl<C, M, R> BatchDisassociateUserStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDisassociateUserStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateUserStackOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDisassociateUserStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDisassociateUserStackInputOperationOutputAlias,
                crate::output::BatchDisassociateUserStackOutput,
                crate::error::BatchDisassociateUserStackError,
                crate::input::BatchDisassociateUserStackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UserStackAssociations`.
        ///
        /// To override the contents of this collection use [`set_user_stack_associations`](Self::set_user_stack_associations).
        ///
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn user_stack_associations(
            mut self,
            input: crate::model::UserStackAssociation,
        ) -> Self {
            self.inner = self.inner.user_stack_associations(input);
            self
        }
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn set_user_stack_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_user_stack_associations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyImage`.
    ///
    /// <p>Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_image_input::Builder,
    }
    impl<C, M, R> CopyImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyImageInputOperationOutputAlias,
                crate::output::CopyImageOutput,
                crate::error::CopyImageError,
                crate::input::CopyImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image to copy.</p>
        pub fn source_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_image_name(input.into());
            self
        }
        /// <p>The name of the image to copy.</p>
        pub fn set_source_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_image_name(input);
            self
        }
        /// <p>The name that the image will have when it is copied to the destination.</p>
        pub fn destination_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_image_name(input.into());
            self
        }
        /// <p>The name that the image will have when it is copied to the destination.</p>
        pub fn set_destination_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_image_name(input);
            self
        }
        /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(input.into());
            self
        }
        /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p>The description that the image will have when it is copied to the destination.</p>
        pub fn destination_image_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_image_description(input.into());
            self
        }
        /// <p>The description that the image will have when it is copied to the destination.</p>
        pub fn set_destination_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_image_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAppBlock`.
    ///
    /// <p>Creates an app block.</p>
    /// <p>App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3 bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard disk includes the application binaries and other files necessary to launch your applications. Multiple applications can be assigned to a single app block.</p>
    /// <p>This is only supported for Elastic fleets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAppBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_app_block_input::Builder,
    }
    impl<C, M, R> CreateAppBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAppBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAppBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAppBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAppBlockInputOperationOutputAlias,
                crate::output::CreateAppBlockOutput,
                crate::error::CreateAppBlockError,
                crate::input::CreateAppBlockInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the app block.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the app block.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the app block.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the app block.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The display name of the app block. This is not displayed to the user.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The display name of the app block. This is not displayed to the user.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The source S3 location of the app block.</p>
        pub fn source_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.source_s3_location(input);
            self
        }
        /// <p>The source S3 location of the app block.</p>
        pub fn set_source_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_source_s3_location(input);
            self
        }
        /// <p>The setup script details of the app block.</p>
        pub fn setup_script_details(mut self, input: crate::model::ScriptDetails) -> Self {
            self.inner = self.inner.setup_script_details(input);
            self
        }
        /// <p>The setup script details of the app block.</p>
        pub fn set_setup_script_details(
            mut self,
            input: std::option::Option<crate::model::ScriptDetails>,
        ) -> Self {
            self.inner = self.inner.set_setup_script_details(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the app block.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the app block.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApplication`.
    ///
    /// <p>Creates an application.</p>
    /// <p>Applications are an Amazon AppStream 2.0 resource that stores the details about how to launch applications on Elastic fleet streaming instances. An application consists of the launch details, icon, and display name. Applications are associated with an app block that contains the application binaries and other files. The applications assigned to an Elastic fleet are the applications users can launch. </p>
    /// <p>This is only supported for Elastic fleets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_application_input::Builder,
    }
    impl<C, M, R> CreateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApplicationInputOperationOutputAlias,
                crate::output::CreateApplicationOutput,
                crate::error::CreateApplicationError,
                crate::input::CreateApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The location in S3 of the application icon.</p>
        pub fn icon_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.icon_s3_location(input);
            self
        }
        /// <p>The location in S3 of the application icon.</p>
        pub fn set_icon_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_icon_s3_location(input);
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_path(input.into());
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn set_launch_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch_path(input);
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.working_directory(input.into());
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_working_directory(input);
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn launch_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_parameters(input.into());
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn set_launch_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_parameters(input);
            self
        }
        /// Appends an item to `Platforms`.
        ///
        /// To override the contents of this collection use [`set_platforms`](Self::set_platforms).
        ///
        /// <p>The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.</p>
        pub fn platforms(mut self, input: crate::model::PlatformType) -> Self {
            self.inner = self.inner.platforms(input);
            self
        }
        /// <p>The platforms the application supports. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets.</p>
        pub fn set_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformType>>,
        ) -> Self {
            self.inner = self.inner.set_platforms(input);
            self
        }
        /// Appends an item to `InstanceFamilies`.
        ///
        /// To override the contents of this collection use [`set_instance_families`](Self::set_instance_families).
        ///
        /// <p>The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.</p>
        pub fn instance_families(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_families(input.into());
            self
        }
        /// <p>The instance families the application supports. Valid values are GENERAL_PURPOSE and GRAPHICS_G4.</p>
        pub fn set_instance_families(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_families(input);
            self
        }
        /// <p>The app block ARN to which the application should be associated</p>
        pub fn app_block_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_block_arn(input.into());
            self
        }
        /// <p>The app block ARN to which the application should be associated</p>
        pub fn set_app_block_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_block_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags assigned to the application.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags assigned to the application.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectoryConfig`.
    ///
    /// <p>Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDirectoryConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_directory_config_input::Builder,
    }
    impl<C, M, R> CreateDirectoryConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectoryConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectoryConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectoryConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDirectoryConfigInputOperationOutputAlias,
                crate::output::CreateDirectoryConfigOutput,
                crate::error::CreateDirectoryConfigError,
                crate::input::CreateDirectoryConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_name(input.into());
            self
        }
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_name(input);
            self
        }
        /// Appends an item to `OrganizationalUnitDistinguishedNames`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_distinguished_names`](Self::set_organizational_unit_distinguished_names).
        ///
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn organizational_unit_distinguished_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .organizational_unit_distinguished_names(input.into());
            self
        }
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_organizational_unit_distinguished_names(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn service_account_credentials(
            mut self,
            input: crate::model::ServiceAccountCredentials,
        ) -> Self {
            self.inner = self.inner.service_account_credentials(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn set_service_account_credentials(
            mut self,
            input: std::option::Option<crate::model::ServiceAccountCredentials>,
        ) -> Self {
            self.inner = self.inner.set_service_account_credentials(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEntitlement`.
    ///
    /// <p>Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEntitlement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_entitlement_input::Builder,
    }
    impl<C, M, R> CreateEntitlement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEntitlementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEntitlementInputOperationOutputAlias,
                crate::output::CreateEntitlementOutput,
                crate::error::CreateEntitlementError,
                crate::input::CreateEntitlementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies whether all or selected apps are entitled.</p>
        pub fn app_visibility(mut self, input: crate::model::AppVisibility) -> Self {
            self.inner = self.inner.app_visibility(input);
            self
        }
        /// <p>Specifies whether all or selected apps are entitled.</p>
        pub fn set_app_visibility(
            mut self,
            input: std::option::Option<crate::model::AppVisibility>,
        ) -> Self {
            self.inner = self.inner.set_app_visibility(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes of the entitlement.</p>
        pub fn attributes(mut self, input: crate::model::EntitlementAttribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The attributes of the entitlement.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleet`.
    ///
    /// <p>Creates a fleet. A fleet consists of streaming instances that run a specified image when using Always-On or On-Demand.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fleet_input::Builder,
    }
    impl<C, M, R> CreateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFleetInputOperationOutputAlias,
                crate::output::CreateFleetOutput,
                crate::error::CreateFleetError,
                crate::input::CreateFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(input.into());
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(input.into());
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>
        /// ALWAYS_ON
        /// </dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>
        /// ON_DEMAND
        /// </dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn fleet_type(mut self, input: crate::model::FleetType) -> Self {
            self.inner = self.inner.fleet_type(input);
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>
        /// ALWAYS_ON
        /// </dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps. You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>
        /// ON_DEMAND
        /// </dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes. You are charged for instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn set_fleet_type(
            mut self,
            input: std::option::Option<crate::model::FleetType>,
        ) -> Self {
            self.inner = self.inner.set_fleet_type(input);
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify MaxConcurrentSessions instead.</p>
        pub fn compute_capacity(mut self, input: crate::model::ComputeCapacity) -> Self {
            self.inner = self.inner.compute_capacity(input);
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets. For Elastic fleets, specify MaxConcurrentSessions instead.</p>
        pub fn set_compute_capacity(
            mut self,
            input: std::option::Option<crate::model::ComputeCapacity>,
        ) -> Self {
            self.inner = self.inner.set_compute_capacity(input);
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn max_user_duration_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.max_user_duration_in_seconds(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn set_max_user_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_user_duration_in_seconds(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn set_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_default_internet_access(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_default_internet_access(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.inner = self.inner.domain_join_info(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. This is not allowed for Elastic fleets. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.inner = self.inner.set_domain_join_info(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn idle_disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.idle_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If they try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn set_idle_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_idle_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn stream_view(mut self, input: crate::model::StreamView) -> Self {
            self.inner = self.inner.stream_view(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn set_stream_view(
            mut self,
            input: std::option::Option<crate::model::StreamView>,
        ) -> Self {
            self.inner = self.inner.set_stream_view(input);
            self
        }
        /// <p>The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn platform(mut self, input: crate::model::PlatformType) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformType>,
        ) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for other fleet types.</p>
        pub fn max_concurrent_sessions(mut self, input: i32) -> Self {
            self.inner = self.inner.max_concurrent_sessions(input);
            self
        }
        /// <p>The maximum concurrent sessions of the Elastic fleet. This is required for Elastic fleets, and not allowed for other fleet types.</p>
        pub fn set_max_concurrent_sessions(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_concurrent_sessions(input);
            self
        }
        /// Appends an item to `UsbDeviceFilterStrings`.
        ///
        /// To override the contents of this collection use [`set_usb_device_filter_strings`](Self::set_usb_device_filter_strings).
        ///
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn usb_device_filter_strings(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usb_device_filter_strings(input.into());
            self
        }
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn set_usb_device_filter_strings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usb_device_filter_strings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImageBuilder`.
    ///
    /// <p>Creates an image builder. An image builder is a virtual machine that is used to create an image.</p>
    /// <p>The initial state of the builder is <code>PENDING</code>. When it is ready, the state is <code>RUNNING</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_builder_input::Builder,
    }
    impl<C, M, R> CreateImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageBuilderInputOperationOutputAlias,
                crate::output::CreateImageBuilderOutput,
                crate::error::CreateImageBuilderError,
                crate::input::CreateImageBuilderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name for the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the image used to create the image builder.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image used to create the image builder.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(input.into());
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(input.into());
            self
        }
        /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_default_internet_access(input);
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_default_internet_access(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.inner = self.inner.domain_join_info(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.inner = self.inner.set_domain_join_info(input);
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn appstream_agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.appstream_agent_version(input.into());
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_appstream_agent_version(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `AccessEndpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, input: crate::model::AccessEndpoint) -> Self {
            self.inner = self.inner.access_endpoints(input);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_access_endpoints(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImageBuilderStreamingURL`.
    ///
    /// <p>Creates a URL to start an image builder streaming session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateImageBuilderStreamingURL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_builder_streaming_url_input::Builder,
    }
    impl<C, M, R> CreateImageBuilderStreamingURL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImageBuilderStreamingURL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageBuilderStreamingUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageBuilderStreamingURLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageBuilderStreamingUrlInputOperationOutputAlias,
                crate::output::CreateImageBuilderStreamingUrlOutput,
                crate::error::CreateImageBuilderStreamingURLError,
                crate::input::CreateImageBuilderStreamingUrlInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
        pub fn validity(mut self, input: i64) -> Self {
            self.inner = self.inner.validity(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
        pub fn set_validity(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStack`.
    ///
    /// <p>Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stack_input::Builder,
    }
    impl<C, M, R> CreateStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStackOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStackInputOperationOutputAlias,
                crate::output::CreateStackOutput,
                crate::error::CreateStackError,
                crate::input::CreateStackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The stack name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The stack name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// Appends an item to `StorageConnectors`.
        ///
        /// To override the contents of this collection use [`set_storage_connectors`](Self::set_storage_connectors).
        ///
        /// <p>The storage connectors to enable.</p>
        pub fn storage_connectors(mut self, input: crate::model::StorageConnector) -> Self {
            self.inner = self.inner.storage_connectors(input);
            self
        }
        /// <p>The storage connectors to enable.</p>
        pub fn set_storage_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        ) -> Self {
            self.inner = self.inner.set_storage_connectors(input);
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn redirect_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.redirect_url(input.into());
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn set_redirect_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_redirect_url(input);
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn feedback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feedback_url(input.into());
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn set_feedback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feedback_url(input);
            self
        }
        /// Appends an item to `UserSettings`.
        ///
        /// To override the contents of this collection use [`set_user_settings`](Self::set_user_settings).
        ///
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
        pub fn user_settings(mut self, input: crate::model::UserSetting) -> Self {
            self.inner = self.inner.user_settings(input);
            self
        }
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        ) -> Self {
            self.inner = self.inner.set_user_settings(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn application_settings(mut self, input: crate::model::ApplicationSettings) -> Self {
            self.inner = self.inner.application_settings(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn set_application_settings(
            mut self,
            input: std::option::Option<crate::model::ApplicationSettings>,
        ) -> Self {
            self.inner = self.inner.set_application_settings(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `AccessEndpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, input: crate::model::AccessEndpoint) -> Self {
            self.inner = self.inner.access_endpoints(input);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_access_endpoints(input);
            self
        }
        /// Appends an item to `EmbedHostDomains`.
        ///
        /// To override the contents of this collection use [`set_embed_host_domains`](Self::set_embed_host_domains).
        ///
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn embed_host_domains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed_host_domains(input.into());
            self
        }
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn set_embed_host_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed_host_domains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingURL`.
    ///
    /// <p>Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateStreamingURL<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_streaming_url_input::Builder,
    }
    impl<C, M, R> CreateStreamingURL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamingURL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingURLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamingUrlInputOperationOutputAlias,
                crate::output::CreateStreamingUrlOutput,
                crate::error::CreateStreamingURLError,
                crate::input::CreateStreamingUrlInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
        pub fn application_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(input.into());
            self
        }
        /// <p>The name of the application to launch after the session starts. This is the name that you specified as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
        pub fn validity(mut self, input: i64) -> Self {
            self.inner = self.inner.validity(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
        pub fn set_validity(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
        /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn session_context(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_context(input.into());
            self
        }
        /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_session_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUpdatedImage`.
    ///
    /// <p>Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.</p>
    /// <p>For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html">Administer Your AppStream 2.0 Images</a>, in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUpdatedImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_updated_image_input::Builder,
    }
    impl<C, M, R> CreateUpdatedImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUpdatedImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUpdatedImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUpdatedImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUpdatedImageInputOperationOutputAlias,
                crate::output::CreateUpdatedImageOutput,
                crate::error::CreateUpdatedImageError,
                crate::input::CreateUpdatedImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image to update.</p>
        pub fn existing_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.existing_image_name(input.into());
            self
        }
        /// <p>The name of the image to update.</p>
        pub fn set_existing_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_existing_image_name(input);
            self
        }
        /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
        pub fn new_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_image_name(input.into());
            self
        }
        /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
        pub fn set_new_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_image_name(input);
            self
        }
        /// <p>The description to display for the new image.</p>
        pub fn new_image_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_image_description(input.into());
            self
        }
        /// <p>The description to display for the new image.</p>
        pub fn set_new_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_image_description(input);
            self
        }
        /// <p>The name to display for the new image.</p>
        pub fn new_image_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_image_display_name(input.into());
            self
        }
        /// <p>The name to display for the new image.</p>
        pub fn set_new_image_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_image_display_name(input);
            self
        }
        /// Adds a key-value pair to `newImageTags`.
        ///
        /// To override the contents of this collection use [`set_new_image_tags`](Self::set_new_image_tags).
        ///
        /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn new_image_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.new_image_tags(k.into(), v.into());
            self
        }
        /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_new_image_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_new_image_tags(input);
            self
        }
        /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsageReportSubscription`.
    ///
    /// <p>Creates a usage report subscription. Usage reports are generated daily.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUsageReportSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_usage_report_subscription_input::Builder,
    }
    impl<C, M, R> CreateUsageReportSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUsageReportSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsageReportSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsageReportSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUsageReportSubscriptionInputOperationOutputAlias,
                crate::output::CreateUsageReportSubscriptionOutput,
                crate::error::CreateUsageReportSubscriptionError,
                crate::input::CreateUsageReportSubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a new user in the user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note>
        /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
        /// </note>
        pub fn message_action(mut self, input: crate::model::MessageAction) -> Self {
            self.inner = self.inner.message_action(input);
            self
        }
        /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p> <note>
        /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
        /// </note>
        pub fn set_message_action(
            mut self,
            input: std::option::Option<crate::model::MessageAction>,
        ) -> Self {
            self.inner = self.inner.set_message_action(input);
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(input.into());
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(input.into());
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL. </p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAppBlock`.
    ///
    /// <p>Deletes an app block.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAppBlock<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_app_block_input::Builder,
    }
    impl<C, M, R> DeleteAppBlock<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAppBlock`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAppBlockOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAppBlockError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAppBlockInputOperationOutputAlias,
                crate::output::DeleteAppBlockOutput,
                crate::error::DeleteAppBlockError,
                crate::input::DeleteAppBlockInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the app block.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the app block.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApplication`.
    ///
    /// <p>Deletes an application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_application_input::Builder,
    }
    impl<C, M, R> DeleteApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApplicationInputOperationOutputAlias,
                crate::output::DeleteApplicationOutput,
                crate::error::DeleteApplicationError,
                crate::input::DeleteApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectoryConfig`.
    ///
    /// <p>Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDirectoryConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_directory_config_input::Builder,
    }
    impl<C, M, R> DeleteDirectoryConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectoryConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectoryConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDirectoryConfigInputOperationOutputAlias,
                crate::output::DeleteDirectoryConfigOutput,
                crate::error::DeleteDirectoryConfigError,
                crate::input::DeleteDirectoryConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the directory configuration.</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_name(input.into());
            self
        }
        /// <p>The name of the directory configuration.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEntitlement`.
    ///
    /// <p>Deletes the specified entitlement.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEntitlement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_entitlement_input::Builder,
    }
    impl<C, M, R> DeleteEntitlement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEntitlementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEntitlementInputOperationOutputAlias,
                crate::output::DeleteEntitlementOutput,
                crate::error::DeleteEntitlementError,
                crate::input::DeleteEntitlementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFleet`.
    ///
    /// <p>Deletes the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fleet_input::Builder,
    }
    impl<C, M, R> DeleteFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFleetInputOperationOutputAlias,
                crate::output::DeleteFleetOutput,
                crate::error::DeleteFleetError,
                crate::input::DeleteFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImage`.
    ///
    /// <p>Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot provision new capacity using the image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_input::Builder,
    }
    impl<C, M, R> DeleteImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageInputOperationOutputAlias,
                crate::output::DeleteImageOutput,
                crate::error::DeleteImageError,
                crate::input::DeleteImageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImageBuilder`.
    ///
    /// <p>Deletes the specified image builder and releases the capacity.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_builder_input::Builder,
    }
    impl<C, M, R> DeleteImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageBuilderInputOperationOutputAlias,
                crate::output::DeleteImageBuilderOutput,
                crate::error::DeleteImageBuilderError,
                crate::input::DeleteImageBuilderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImagePermissions`.
    ///
    /// <p>Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteImagePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_permissions_input::Builder,
    }
    impl<C, M, R> DeleteImagePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImagePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImagePermissionsInputOperationOutputAlias,
                crate::output::DeleteImagePermissionsOutput,
                crate::error::DeleteImagePermissionsError,
                crate::input::DeleteImagePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the private image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the private image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_account_id(input.into());
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStack`.
    ///
    /// <p>Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteStack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stack_input::Builder,
    }
    impl<C, M, R> DeleteStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStackOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStackInputOperationOutputAlias,
                crate::output::DeleteStackOutput,
                crate::error::DeleteStackError,
                crate::input::DeleteStackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsageReportSubscription`.
    ///
    /// <p>Disables usage report generation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUsageReportSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_usage_report_subscription_input::Builder,
    }
    impl<C, M, R> DeleteUsageReportSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUsageReportSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsageReportSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsageReportSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUsageReportSubscriptionInputOperationOutputAlias,
                crate::output::DeleteUsageReportSubscriptionOutput,
                crate::error::DeleteUsageReportSubscriptionError,
                crate::input::DeleteUsageReportSubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user from the user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAppBlocks`.
    ///
    /// <p>Retrieves a list that describes one or more app blocks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAppBlocks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_app_blocks_input::Builder,
    }
    impl<C, M, R> DescribeAppBlocks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAppBlocks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAppBlocksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAppBlocksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAppBlocksInputOperationOutputAlias,
                crate::output::DescribeAppBlocksOutput,
                crate::error::DescribeAppBlocksError,
                crate::input::DescribeAppBlocksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The ARNs of the app blocks.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(input.into());
            self
        }
        /// <p>The ARNs of the app blocks.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicationFleetAssociations`.
    ///
    /// <p>Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName must be specified.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplicationFleetAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_application_fleet_associations_input::Builder,
    }
    impl<C, M, R> DescribeApplicationFleetAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplicationFleetAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationFleetAssociationsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeApplicationFleetAssociationsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationFleetAssociationsInputOperationOutputAlias,
                crate::output::DescribeApplicationFleetAssociationsOutput,
                crate::error::DescribeApplicationFleetAssociationsError,
                crate::input::DescribeApplicationFleetAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_arn(input.into());
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_arn(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApplications`.
    ///
    /// <p>Retrieves a list that describes one or more applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_applications_input::Builder,
    }
    impl<C, M, R> DescribeApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicationsInputOperationOutputAlias,
                crate::output::DescribeApplicationsOutput,
                crate::error::DescribeApplicationsError,
                crate::input::DescribeApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The ARNs for the applications.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(input.into());
            self
        }
        /// <p>The ARNs for the applications.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectoryConfigs`.
    ///
    /// <p>Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains. </p>
    /// <p>Although the response syntax in this topic includes the account password, this password is not returned in the actual response.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDirectoryConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_directory_configs_input::Builder,
    }
    impl<C, M, R> DescribeDirectoryConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectoryConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectoryConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDirectoryConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDirectoryConfigsInputOperationOutputAlias,
                crate::output::DescribeDirectoryConfigsOutput,
                crate::error::DescribeDirectoryConfigsError,
                crate::input::DescribeDirectoryConfigsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DirectoryNames`.
        ///
        /// To override the contents of this collection use [`set_directory_names`](Self::set_directory_names).
        ///
        /// <p>The directory names.</p>
        pub fn directory_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_names(input.into());
            self
        }
        /// <p>The directory names.</p>
        pub fn set_directory_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_directory_names(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEntitlements`.
    ///
    /// <p>Retrieves a list that describes one of more entitlements.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEntitlements<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_entitlements_input::Builder,
    }
    impl<C, M, R> DescribeEntitlements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEntitlements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEntitlementsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEntitlementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEntitlementsInputOperationOutputAlias,
                crate::output::DescribeEntitlementsOutput,
                crate::error::DescribeEntitlementsError,
                crate::input::DescribeEntitlementsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFleets`.
    ///
    /// <p>Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFleets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fleets_input::Builder,
    }
    impl<C, M, R> DescribeFleets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFleetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFleetsInputOperationOutputAlias,
                crate::output::DescribeFleetsOutput,
                crate::error::DescribeFleetsError,
                crate::input::DescribeFleetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the fleets to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the fleets to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageBuilders`.
    ///
    /// <p>Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImageBuilders<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_builders_input::Builder,
    }
    impl<C, M, R> DescribeImageBuilders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImageBuilders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageBuildersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageBuildersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImageBuildersInputOperationOutputAlias,
                crate::output::DescribeImageBuildersOutput,
                crate::error::DescribeImageBuildersError,
                crate::input::DescribeImageBuildersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the image builders to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the image builders to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImagePermissions`.
    ///
    /// <p>Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImagePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_permissions_input::Builder,
    }
    impl<C, M, R> DescribeImagePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImagePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImagePermissionsInputOperationOutputAlias,
                crate::output::DescribeImagePermissionsOutput,
                crate::error::DescribeImagePermissionsError,
                crate::input::DescribeImagePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeImagePermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeImagePermissionsPaginator<C, M, R> {
            crate::paginator::DescribeImagePermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `SharedAwsAccountIds`.
        ///
        /// To override the contents of this collection use [`set_shared_aws_account_ids`](Self::set_shared_aws_account_ids).
        ///
        /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
        pub fn shared_aws_account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_aws_account_ids(input.into());
            self
        }
        /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
        pub fn set_shared_aws_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_shared_aws_account_ids(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImages`.
    ///
    /// <p>Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeImages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_images_input::Builder,
    }
    impl<C, M, R> DescribeImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImagesInputOperationOutputAlias,
                crate::output::DescribeImagesOutput,
                crate::error::DescribeImagesError,
                crate::input::DescribeImagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeImagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeImagesPaginator<C, M, R> {
            crate::paginator::DescribeImagesPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the public or private images to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the public or private images to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// Appends an item to `Arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The ARNs of the public, private, and shared images to describe.</p>
        pub fn arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(input.into());
            self
        }
        /// <p>The ARNs of the public, private, and shared images to describe.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
        /// <p>The type of image (public, private, or shared) to describe. </p>
        pub fn r#type(mut self, input: crate::model::VisibilityType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of image (public, private, or shared) to describe. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::VisibilityType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSessions`.
    ///
    /// <p>Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_sessions_input::Builder,
    }
    impl<C, M, R> DescribeSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSessionsInputOperationOutputAlias,
                crate::output::DescribeSessionsOutput,
                crate::error::DescribeSessionsError,
                crate::input::DescribeSessionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack. This value is case-sensitive.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack. This value is case-sensitive.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name of the fleet. This value is case-sensitive.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet. This value is case-sensitive.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication method. Specify <code>API</code> for a user authenticated using a streaming URL or <code>SAML</code> for a SAML federated user. The default is to authenticate users using a streaming URL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStacks`.
    ///
    /// <p>Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStacks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stacks_input::Builder,
    }
    impl<C, M, R> DescribeStacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStacksInputOperationOutputAlias,
                crate::output::DescribeStacksOutput,
                crate::error::DescribeStacksError,
                crate::input::DescribeStacksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the stacks to describe.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names of the stacks to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsageReportSubscriptions`.
    ///
    /// <p>Retrieves a list that describes one or more usage report subscriptions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUsageReportSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_usage_report_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeUsageReportSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUsageReportSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsageReportSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsageReportSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUsageReportSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeUsageReportSubscriptionsOutput,
                crate::error::DescribeUsageReportSubscriptionsError,
                crate::input::DescribeUsageReportSubscriptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsers`.
    ///
    /// <p>Retrieves a list that describes one or more specified users in the user pool.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_users_input::Builder,
    }
    impl<C, M, R> DescribeUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUsersInputOperationOutputAlias,
                crate::output::DescribeUsersOutput,
                crate::error::DescribeUsersError,
                crate::input::DescribeUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserStackAssociations`.
    ///
    /// <p>Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:</p>
    /// <ul>
    /// <li> <p>The stack name</p> </li>
    /// <li> <p>The user name (email address of the user associated with the stack) and the authentication type for the user</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserStackAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_stack_associations_input::Builder,
    }
    impl<C, M, R> DescribeUserStackAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserStackAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserStackAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserStackAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserStackAssociationsInputOperationOutputAlias,
                crate::output::DescribeUserStackAssociationsOutput,
                crate::error::DescribeUserStackAssociationsError,
                crate::input::DescribeUserStackAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableUser`.
    ///
    /// <p>Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_user_input::Builder,
    }
    impl<C, M, R> DisableUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableUserInputOperationOutputAlias,
                crate::output::DisableUserOutput,
                crate::error::DisableUserError,
                crate::input::DisableUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateApplicationFleet`.
    ///
    /// <p>Disassociates the specified application from the fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateApplicationFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_application_fleet_input::Builder,
    }
    impl<C, M, R> DisassociateApplicationFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateApplicationFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateApplicationFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateApplicationFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateApplicationFleetInputOperationOutputAlias,
                crate::output::DisassociateApplicationFleetOutput,
                crate::error::DisassociateApplicationFleetError,
                crate::input::DisassociateApplicationFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn application_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_arn(input.into());
            self
        }
        /// <p>The ARN of the application.</p>
        pub fn set_application_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateApplicationFromEntitlement`.
    ///
    /// <p>Deletes the specified application from the specified entitlement.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateApplicationFromEntitlement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_application_from_entitlement_input::Builder,
    }
    impl<C, M, R> DisassociateApplicationFromEntitlement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateApplicationFromEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateApplicationFromEntitlementOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateApplicationFromEntitlementError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateApplicationFromEntitlementInputOperationOutputAlias,
                crate::output::DisassociateApplicationFromEntitlementOutput,
                crate::error::DisassociateApplicationFromEntitlementError,
                crate::input::DisassociateApplicationFromEntitlementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn entitlement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_name(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_entitlement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_name(input);
            self
        }
        /// <p>The identifier of the application to remove from the entitlement.</p>
        pub fn application_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_identifier(input.into());
            self
        }
        /// <p>The identifier of the application to remove from the entitlement.</p>
        pub fn set_application_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFleet`.
    ///
    /// <p>Disassociates the specified fleet from the specified stack.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_fleet_input::Builder,
    }
    impl<C, M, R> DisassociateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFleetInputOperationOutputAlias,
                crate::output::DisassociateFleetOutput,
                crate::error::DisassociateFleetError,
                crate::input::DisassociateFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableUser`.
    ///
    /// <p>Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_user_input::Builder,
    }
    impl<C, M, R> EnableUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableUserOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableUserInputOperationOutputAlias,
                crate::output::EnableUserOutput,
                crate::error::EnableUserError,
                crate::input::EnableUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(input.into());
            self
        }
        /// <p>The email address of the user.</p> <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExpireSession`.
    ///
    /// <p>Immediately stops the specified streaming session.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExpireSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::expire_session_input::Builder,
    }
    impl<C, M, R> ExpireSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExpireSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExpireSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExpireSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExpireSessionInputOperationOutputAlias,
                crate::output::ExpireSessionOutput,
                crate::error::ExpireSessionError,
                crate::input::ExpireSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the streaming session.</p>
        pub fn session_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(input.into());
            self
        }
        /// <p>The identifier of the streaming session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedFleets`.
    ///
    /// <p>Retrieves the name of the fleet that is associated with the specified stack.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociatedFleets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_fleets_input::Builder,
    }
    impl<C, M, R> ListAssociatedFleets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedFleetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedFleetsInputOperationOutputAlias,
                crate::output::ListAssociatedFleetsOutput,
                crate::error::ListAssociatedFleetsError,
                crate::input::ListAssociatedFleetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedStacks`.
    ///
    /// <p>Retrieves the name of the stack with which the specified fleet is associated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociatedStacks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_stacks_input::Builder,
    }
    impl<C, M, R> ListAssociatedStacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedStacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedStacksInputOperationOutputAlias,
                crate::output::ListAssociatedStacksOutput,
                crate::error::ListAssociatedStacksError,
                crate::input::ListAssociatedStacksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntitledApplications`.
    ///
    /// <p>Retrieves a list of entitled applications.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEntitledApplications<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entitled_applications_input::Builder,
    }
    impl<C, M, R> ListEntitledApplications<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntitledApplications`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitledApplicationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitledApplicationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntitledApplicationsInputOperationOutputAlias,
                crate::output::ListEntitledApplicationsOutput,
                crate::error::ListEntitledApplicationsError,
                crate::input::ListEntitledApplicationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn entitlement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_name(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_entitlement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_name(input);
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token used to retrieve the next page of results for this operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFleet`.
    ///
    /// <p>Starts the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fleet_input::Builder,
    }
    impl<C, M, R> StartFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFleetInputOperationOutputAlias,
                crate::output::StartFleetOutput,
                crate::error::StartFleetError,
                crate::input::StartFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImageBuilder`.
    ///
    /// <p>Starts the specified image builder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_image_builder_input::Builder,
    }
    impl<C, M, R> StartImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImageBuilderInputOperationOutputAlias,
                crate::output::StartImageBuilderOutput,
                crate::error::StartImageBuilderError,
                crate::input::StartImageBuilderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn appstream_agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.appstream_agent_version(input.into());
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_appstream_agent_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFleet`.
    ///
    /// <p>Stops the specified fleet.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_fleet_input::Builder,
    }
    impl<C, M, R> StopFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopFleetInputOperationOutputAlias,
                crate::output::StopFleetOutput,
                crate::error::StopFleetError,
                crate::input::StopFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopImageBuilder`.
    ///
    /// <p>Stops the specified image builder.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_image_builder_input::Builder,
    }
    impl<C, M, R> StopImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::StopImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopImageBuilderInputOperationOutputAlias,
                crate::output::StopImageBuilderOutput,
                crate::error::StopImageBuilderError,
                crate::input::StopImageBuilderInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.</p>
    /// <p>Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this operation updates its value.</p>
    /// <p>To list the current tags for your resources, use <code>ListTagsForResource</code>. To disassociate tags from your resources, use <code>UntagResource</code>.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Disassociates one or more specified tags from the specified AppStream 2.0 resource.</p>
    /// <p>To list the current tags for your resources, use <code>ListTagsForResource</code>.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys for the tags to disassociate.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys for the tags to disassociate.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApplication`.
    ///
    /// <p>Updates the specified application.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApplication<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_application_input::Builder,
    }
    impl<C, M, R> UpdateApplication<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApplication`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApplicationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApplicationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApplicationInputOperationOutputAlias,
                crate::output::UpdateApplicationOutput,
                crate::error::UpdateApplicationError,
                crate::input::UpdateApplicationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the application. This name is visible to users when display name is not specified.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The display name of the application. This name is visible to users in the application catalog.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The description of the application.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the application.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The icon S3 location of the application.</p>
        pub fn icon_s3_location(mut self, input: crate::model::S3Location) -> Self {
            self.inner = self.inner.icon_s3_location(input);
            self
        }
        /// <p>The icon S3 location of the application.</p>
        pub fn set_icon_s3_location(
            mut self,
            input: std::option::Option<crate::model::S3Location>,
        ) -> Self {
            self.inner = self.inner.set_icon_s3_location(input);
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_path(input.into());
            self
        }
        /// <p>The launch path of the application.</p>
        pub fn set_launch_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_launch_path(input);
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn working_directory(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.working_directory(input.into());
            self
        }
        /// <p>The working directory of the application.</p>
        pub fn set_working_directory(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_working_directory(input);
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn launch_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.launch_parameters(input.into());
            self
        }
        /// <p>The launch parameters of the application.</p>
        pub fn set_launch_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_launch_parameters(input);
            self
        }
        /// <p>The ARN of the app block.</p>
        pub fn app_block_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.app_block_arn(input.into());
            self
        }
        /// <p>The ARN of the app block.</p>
        pub fn set_app_block_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_app_block_arn(input);
            self
        }
        /// Appends an item to `AttributesToDelete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The attributes to delete for an application.</p>
        pub fn attributes_to_delete(mut self, input: crate::model::ApplicationAttribute) -> Self {
            self.inner = self.inner.attributes_to_delete(input);
            self
        }
        /// <p>The attributes to delete for an application.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApplicationAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDirectoryConfig`.
    ///
    /// <p>Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDirectoryConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_directory_config_input::Builder,
    }
    impl<C, M, R> UpdateDirectoryConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDirectoryConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDirectoryConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDirectoryConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDirectoryConfigInputOperationOutputAlias,
                crate::output::UpdateDirectoryConfigOutput,
                crate::error::UpdateDirectoryConfigError,
                crate::input::UpdateDirectoryConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Directory Config object.</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_name(input.into());
            self
        }
        /// <p>The name of the Directory Config object.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_name(input);
            self
        }
        /// Appends an item to `OrganizationalUnitDistinguishedNames`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_distinguished_names`](Self::set_organizational_unit_distinguished_names).
        ///
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn organizational_unit_distinguished_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .organizational_unit_distinguished_names(input.into());
            self
        }
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_organizational_unit_distinguished_names(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn service_account_credentials(
            mut self,
            input: crate::model::ServiceAccountCredentials,
        ) -> Self {
            self.inner = self.inner.service_account_credentials(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn set_service_account_credentials(
            mut self,
            input: std::option::Option<crate::model::ServiceAccountCredentials>,
        ) -> Self {
            self.inner = self.inner.set_service_account_credentials(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEntitlement`.
    ///
    /// <p>Updates the specified entitlement.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEntitlement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_entitlement_input::Builder,
    }
    impl<C, M, R> UpdateEntitlement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEntitlementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEntitlementInputOperationOutputAlias,
                crate::output::UpdateEntitlementOutput,
                crate::error::UpdateEntitlementError,
                crate::input::UpdateEntitlementInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the entitlement.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the entitlement.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(input.into());
            self
        }
        /// <p>The name of the stack with which the entitlement is associated.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the entitlement.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies whether all or only selected apps are entitled.</p>
        pub fn app_visibility(mut self, input: crate::model::AppVisibility) -> Self {
            self.inner = self.inner.app_visibility(input);
            self
        }
        /// <p>Specifies whether all or only selected apps are entitled.</p>
        pub fn set_app_visibility(
            mut self,
            input: std::option::Option<crate::model::AppVisibility>,
        ) -> Self {
            self.inner = self.inner.set_app_visibility(input);
            self
        }
        /// Appends an item to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes of the entitlement.</p>
        pub fn attributes(mut self, input: crate::model::EntitlementAttribute) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// <p>The attributes of the entitlement.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFleet`.
    ///
    /// <p>Updates the specified fleet.</p>
    /// <p>If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name.</p>
    /// <p>If the fleet is in the <code>RUNNING</code> state, you can update the following based on the fleet type:</p>
    /// <ul>
    /// <li> <p>Always-On and On-Demand fleet types</p> <p>You can update the <code>DisplayName</code>, <code>ComputeCapacity</code>, <code>ImageARN</code>, <code>ImageName</code>, <code>IdleDisconnectTimeoutInSeconds</code>, and <code>DisconnectTimeoutInSeconds</code> attributes.</p> </li>
    /// <li> <p>Elastic fleet type</p> <p>You can update the <code>DisplayName</code>, <code>IdleDisconnectTimeoutInSeconds</code>, <code>DisconnectTimeoutInSeconds</code>, <code>MaxConcurrentSessions</code>, and <code>UsbDeviceFilterStrings</code> attributes.</p> </li>
    /// </ul>
    /// <p>If the fleet is in the <code>STARTING</code> or <code>STOPPED</code> state, you can't update it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_fleet_input::Builder,
    }
    impl<C, M, R> UpdateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFleetInputOperationOutputAlias,
                crate::output::UpdateFleetOutput,
                crate::error::UpdateFleetError,
                crate::input::UpdateFleetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(input.into());
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(input.into());
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(input.into());
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// <li> <p>stream.standard.large</p> </li>
        /// <li> <p>stream.compute.large</p> </li>
        /// <li> <p>stream.compute.xlarge</p> </li>
        /// <li> <p>stream.compute.2xlarge</p> </li>
        /// <li> <p>stream.compute.4xlarge</p> </li>
        /// <li> <p>stream.compute.8xlarge</p> </li>
        /// <li> <p>stream.memory.large</p> </li>
        /// <li> <p>stream.memory.xlarge</p> </li>
        /// <li> <p>stream.memory.2xlarge</p> </li>
        /// <li> <p>stream.memory.4xlarge</p> </li>
        /// <li> <p>stream.memory.8xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.large</p> </li>
        /// <li> <p>stream.memory.z1d.xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.2xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.3xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.6xlarge</p> </li>
        /// <li> <p>stream.memory.z1d.12xlarge</p> </li>
        /// <li> <p>stream.graphics-design.large</p> </li>
        /// <li> <p>stream.graphics-design.xlarge</p> </li>
        /// <li> <p>stream.graphics-design.2xlarge</p> </li>
        /// <li> <p>stream.graphics-design.4xlarge</p> </li>
        /// <li> <p>stream.graphics-desktop.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.2xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.4xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.8xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.12xlarge</p> </li>
        /// <li> <p>stream.graphics.g4dn.16xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.4xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.8xlarge</p> </li>
        /// <li> <p>stream.graphics-pro.16xlarge</p> </li>
        /// </ul>
        /// <p>The following instance types are available for Elastic fleets:</p>
        /// <ul>
        /// <li> <p>stream.standard.small</p> </li>
        /// <li> <p>stream.standard.medium</p> </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets.</p>
        pub fn compute_capacity(mut self, input: crate::model::ComputeCapacity) -> Self {
            self.inner = self.inner.compute_capacity(input);
            self
        }
        /// <p>The desired capacity for the fleet. This is not allowed for Elastic fleets.</p>
        pub fn set_compute_capacity(
            mut self,
            input: std::option::Option<crate::model::ComputeCapacity>,
        ) -> Self {
            self.inner = self.inner.set_compute_capacity(input);
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones. </p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>The VPC configuration for the fleet. This is required for Elastic fleets, but not required for other fleet types. Elastic fleets require that you specify at least two subnets in different availability zones. </p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn max_user_duration_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.max_user_duration_in_seconds(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn set_max_user_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_user_duration_in_seconds(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn set_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>Deletes the VPC association for the specified fleet.</p>
        pub fn delete_vpc_config(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_vpc_config(input);
            self
        }
        /// <p>Deletes the VPC association for the specified fleet.</p>
        pub fn set_delete_vpc_config(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_vpc_config(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_default_internet_access(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_default_internet_access(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.inner = self.inner.domain_join_info(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.inner = self.inner.set_domain_join_info(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn idle_disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.idle_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected. </p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p> <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn set_idle_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_idle_disconnect_timeout_in_seconds(input);
            self
        }
        /// Appends an item to `AttributesToDelete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The fleet attributes to delete.</p>
        pub fn attributes_to_delete(mut self, input: crate::model::FleetAttribute) -> Self {
            self.inner = self.inner.attributes_to_delete(input);
            self
        }
        /// <p>The fleet attributes to delete.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_delete(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn stream_view(mut self, input: crate::model::StreamView) -> Self {
            self.inner = self.inner.stream_view(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        /// <p>The default value is <code>APP</code>.</p>
        pub fn set_stream_view(
            mut self,
            input: std::option::Option<crate::model::StreamView>,
        ) -> Self {
            self.inner = self.inner.set_stream_view(input);
            self
        }
        /// <p>The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn platform(mut self, input: crate::model::PlatformType) -> Self {
            self.inner = self.inner.platform(input);
            self
        }
        /// <p>The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported for Elastic fleets. </p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformType>,
        ) -> Self {
            self.inner = self.inner.set_platform(input);
            self
        }
        /// <p>The maximum number of concurrent sessions for a fleet.</p>
        pub fn max_concurrent_sessions(mut self, input: i32) -> Self {
            self.inner = self.inner.max_concurrent_sessions(input);
            self
        }
        /// <p>The maximum number of concurrent sessions for a fleet.</p>
        pub fn set_max_concurrent_sessions(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_concurrent_sessions(input);
            self
        }
        /// Appends an item to `UsbDeviceFilterStrings`.
        ///
        /// To override the contents of this collection use [`set_usb_device_filter_strings`](Self::set_usb_device_filter_strings).
        ///
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn usb_device_filter_strings(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usb_device_filter_strings(input.into());
            self
        }
        /// <p>The USB device filter strings that specify which USB devices a user can redirect to the fleet streaming session, when using the Windows native client. This is allowed but not required for Elastic fleets.</p>
        pub fn set_usb_device_filter_strings(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_usb_device_filter_strings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateImagePermissions`.
    ///
    /// <p>Adds or updates permissions for the specified private image. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateImagePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_image_permissions_input::Builder,
    }
    impl<C, M, R> UpdateImagePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateImagePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateImagePermissionsInputOperationOutputAlias,
                crate::output::UpdateImagePermissionsOutput,
                crate::error::UpdateImagePermissionsError,
                crate::input::UpdateImagePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the private image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the private image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_account_id(input.into());
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_account_id(input);
            self
        }
        /// <p>The permissions for the image.</p>
        pub fn image_permissions(mut self, input: crate::model::ImagePermissions) -> Self {
            self.inner = self.inner.image_permissions(input);
            self
        }
        /// <p>The permissions for the image.</p>
        pub fn set_image_permissions(
            mut self,
            input: std::option::Option<crate::model::ImagePermissions>,
        ) -> Self {
            self.inner = self.inner.set_image_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStack`.
    ///
    /// <p>Updates the specified fields for the specified stack.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateStack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_stack_input::Builder,
    }
    impl<C, M, R> UpdateStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStackOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStackInputOperationOutputAlias,
                crate::output::UpdateStackOutput,
                crate::error::UpdateStackError,
                crate::input::UpdateStackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stack name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(input.into());
            self
        }
        /// <p>The stack name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `StorageConnectors`.
        ///
        /// To override the contents of this collection use [`set_storage_connectors`](Self::set_storage_connectors).
        ///
        /// <p>The storage connectors to enable.</p>
        pub fn storage_connectors(mut self, input: crate::model::StorageConnector) -> Self {
            self.inner = self.inner.storage_connectors(input);
            self
        }
        /// <p>The storage connectors to enable.</p>
        pub fn set_storage_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        ) -> Self {
            self.inner = self.inner.set_storage_connectors(input);
            self
        }
        /// <p>Deletes the storage connectors currently enabled for the stack.</p>
        pub fn delete_storage_connectors(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_storage_connectors(input);
            self
        }
        /// <p>Deletes the storage connectors currently enabled for the stack.</p>
        pub fn set_delete_storage_connectors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_storage_connectors(input);
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn redirect_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.redirect_url(input.into());
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn set_redirect_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_redirect_url(input);
            self
        }
        /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn feedback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feedback_url(input.into());
            self
        }
        /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn set_feedback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feedback_url(input);
            self
        }
        /// Appends an item to `AttributesToDelete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The stack attributes to delete.</p>
        pub fn attributes_to_delete(mut self, input: crate::model::StackAttribute) -> Self {
            self.inner = self.inner.attributes_to_delete(input);
            self
        }
        /// <p>The stack attributes to delete.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_delete(input);
            self
        }
        /// Appends an item to `UserSettings`.
        ///
        /// To override the contents of this collection use [`set_user_settings`](Self::set_user_settings).
        ///
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
        pub fn user_settings(mut self, input: crate::model::UserSetting) -> Self {
            self.inner = self.inner.user_settings(input);
            self
        }
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        ) -> Self {
            self.inner = self.inner.set_user_settings(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn application_settings(mut self, input: crate::model::ApplicationSettings) -> Self {
            self.inner = self.inner.application_settings(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn set_application_settings(
            mut self,
            input: std::option::Option<crate::model::ApplicationSettings>,
        ) -> Self {
            self.inner = self.inner.set_application_settings(input);
            self
        }
        /// Appends an item to `AccessEndpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, input: crate::model::AccessEndpoint) -> Self {
            self.inner = self.inner.access_endpoints(input);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_access_endpoints(input);
            self
        }
        /// Appends an item to `EmbedHostDomains`.
        ///
        /// To override the contents of this collection use [`set_embed_host_domains`](Self::set_embed_host_domains).
        ///
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn embed_host_domains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed_host_domains(input.into());
            self
        }
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn set_embed_host_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed_host_domains(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
