// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateApplicationFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateApplicationFleetError {
    /// Kind of error that occurred.
    pub kind: AssociateApplicationFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateApplicationFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateApplicationFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateApplicationFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateApplicationFleetErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateApplicationFleetErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            AssociateApplicationFleetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateApplicationFleetErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            AssociateApplicationFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateApplicationFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateApplicationFleetError {
    fn code(&self) -> Option<&str> {
        AssociateApplicationFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateApplicationFleetError {
    /// Creates a new `AssociateApplicationFleetError`.
    pub fn new(kind: AssociateApplicationFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateApplicationFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateApplicationFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateApplicationFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateApplicationFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateApplicationFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApplicationFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApplicationFleetErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApplicationFleetErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApplicationFleetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApplicationFleetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApplicationFleetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApplicationFleetErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApplicationFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApplicationFleetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateApplicationFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateApplicationFleetErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            AssociateApplicationFleetErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            AssociateApplicationFleetErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateApplicationFleetErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            AssociateApplicationFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateApplicationFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateFleetError {
    /// Kind of error that occurred.
    pub kind: AssociateFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateFleetErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            AssociateFleetErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            AssociateFleetErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            AssociateFleetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateFleetErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            AssociateFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateFleetError {
    fn code(&self) -> Option<&str> {
        AssociateFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateFleetError {
    /// Creates a new `AssociateFleetError`.
    pub fn new(kind: AssociateFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateFleetErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFleetErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateFleetErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFleetErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateFleetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFleetErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateFleetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFleetErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateFleetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for AssociateFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateFleetErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            AssociateFleetErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            AssociateFleetErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            AssociateFleetErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateFleetErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            AssociateFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchAssociateUserStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAssociateUserStackError {
    /// Kind of error that occurred.
    pub kind: BatchAssociateUserStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAssociateUserStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAssociateUserStackErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAssociateUserStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAssociateUserStackErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateUserStackErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            BatchAssociateUserStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchAssociateUserStackError {
    fn code(&self) -> Option<&str> {
        BatchAssociateUserStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAssociateUserStackError {
    /// Creates a new `BatchAssociateUserStackError`.
    pub fn new(kind: BatchAssociateUserStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAssociateUserStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAssociateUserStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAssociateUserStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAssociateUserStackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchAssociateUserStackErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateUserStackErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchAssociateUserStackErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchAssociateUserStackErrorKind::OperationNotPermittedException(_)
        )
    }
}
impl std::error::Error for BatchAssociateUserStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAssociateUserStackErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            BatchAssociateUserStackErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            BatchAssociateUserStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDisassociateUserStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisassociateUserStackError {
    /// Kind of error that occurred.
    pub kind: BatchDisassociateUserStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisassociateUserStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisassociateUserStackErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisassociateUserStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisassociateUserStackErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateUserStackErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            BatchDisassociateUserStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDisassociateUserStackError {
    fn code(&self) -> Option<&str> {
        BatchDisassociateUserStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisassociateUserStackError {
    /// Creates a new `BatchDisassociateUserStackError`.
    pub fn new(kind: BatchDisassociateUserStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisassociateUserStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisassociateUserStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisassociateUserStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisassociateUserStackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDisassociateUserStackErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateUserStackErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDisassociateUserStackErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDisassociateUserStackErrorKind::OperationNotPermittedException(_)
        )
    }
}
impl std::error::Error for BatchDisassociateUserStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisassociateUserStackErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateUserStackErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            BatchDisassociateUserStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyImageError {
    /// Kind of error that occurred.
    pub kind: CopyImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyImageErrorKind {
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyImageErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            CopyImageErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            CopyImageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CopyImageErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CopyImageErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            CopyImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CopyImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyImageError {
    fn code(&self) -> Option<&str> {
        CopyImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyImageError {
    /// Creates a new `CopyImageError`.
    pub fn new(kind: CopyImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyImageErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyImageErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyImageErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyImageErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyImageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CopyImageErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CopyImageErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyImageErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyImageErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyImageErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, CopyImageErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for CopyImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyImageErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            CopyImageErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            CopyImageErrorKind::LimitExceededException(_inner) => Some(_inner),
            CopyImageErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CopyImageErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            CopyImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CopyImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAppBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAppBlockError {
    /// Kind of error that occurred.
    pub kind: CreateAppBlockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAppBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAppBlockErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAppBlockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAppBlockErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateAppBlockErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAppBlockErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateAppBlockErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateAppBlockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAppBlockError {
    fn code(&self) -> Option<&str> {
        CreateAppBlockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAppBlockError {
    /// Creates a new `CreateAppBlockError`.
    pub fn new(kind: CreateAppBlockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAppBlockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAppBlockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAppBlockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAppBlockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAppBlockErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppBlockErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppBlockErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppBlockErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppBlockErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppBlockErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAppBlockErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAppBlockErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateAppBlockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAppBlockErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateAppBlockErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAppBlockErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateAppBlockErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateAppBlockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApplicationError {
    /// Kind of error that occurred.
    pub kind: CreateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApplicationErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApplicationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApplicationError {
    fn code(&self) -> Option<&str> {
        CreateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApplicationError {
    /// Creates a new `CreateApplicationError`.
    pub fn new(kind: CreateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApplicationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateApplicationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateApplicationErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDirectoryConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDirectoryConfigError {
    /// Kind of error that occurred.
    pub kind: CreateDirectoryConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDirectoryConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDirectoryConfigErrorKind {
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDirectoryConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDirectoryConfigErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            CreateDirectoryConfigErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            CreateDirectoryConfigErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateDirectoryConfigErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateDirectoryConfigErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateDirectoryConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDirectoryConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDirectoryConfigError {
    fn code(&self) -> Option<&str> {
        CreateDirectoryConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDirectoryConfigError {
    /// Creates a new `CreateDirectoryConfigError`.
    pub fn new(kind: CreateDirectoryConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDirectoryConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDirectoryConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDirectoryConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDirectoryConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDirectoryConfigErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryConfigErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDirectoryConfigErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryConfigErrorKind::InvalidRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDirectoryConfigErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryConfigErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDirectoryConfigErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryConfigErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDirectoryConfigErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryConfigErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDirectoryConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDirectoryConfigErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateDirectoryConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDirectoryConfigErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            CreateDirectoryConfigErrorKind::InvalidRoleException(_inner) => Some(_inner),
            CreateDirectoryConfigErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateDirectoryConfigErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateDirectoryConfigErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateDirectoryConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDirectoryConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFleetError {
    /// Kind of error that occurred.
    pub kind: CreateFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are being throttled by Amazon EC2. Try again later.</p>
    RequestLimitExceededException(crate::error::RequestLimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFleetErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::RequestLimitExceededException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFleetError {
    fn code(&self) -> Option<&str> {
        CreateFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFleetError {
    /// Creates a new `CreateFleetError`.
    pub fn new(kind: CreateFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::InvalidRoleException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateFleetErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::RequestLimitExceededException`.
    pub fn is_request_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::RequestLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFleetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFleetErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateFleetErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            CreateFleetErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            CreateFleetErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateFleetErrorKind::InvalidRoleException(_inner) => Some(_inner),
            CreateFleetErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateFleetErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateFleetErrorKind::RequestLimitExceededException(_inner) => Some(_inner),
            CreateFleetErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateFleetErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            CreateFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateImageBuilderError {
    /// Kind of error that occurred.
    pub kind: CreateImageBuilderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateImageBuilderErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are being throttled by Amazon EC2. Try again later.</p>
    RequestLimitExceededException(crate::error::RequestLimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateImageBuilderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateImageBuilderErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            CreateImageBuilderErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::RequestLimitExceededException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateImageBuilderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateImageBuilderError {
    fn code(&self) -> Option<&str> {
        CreateImageBuilderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateImageBuilderError {
    /// Creates a new `CreateImageBuilderError`.
    pub fn new(kind: CreateImageBuilderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateImageBuilderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateImageBuilderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateImageBuilderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateImageBuilderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::InvalidRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::RequestLimitExceededException`.
    pub fn is_request_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::RequestLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateImageBuilderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateImageBuilderErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            CreateImageBuilderErrorKind::InvalidRoleException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::RequestLimitExceededException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateImageBuilderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateImageBuilderStreamingURL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateImageBuilderStreamingURLError {
    /// Kind of error that occurred.
    pub kind: CreateImageBuilderStreamingURLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateImageBuilderStreamingURL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateImageBuilderStreamingURLErrorKind {
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateImageBuilderStreamingURLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateImageBuilderStreamingURLErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            CreateImageBuilderStreamingURLErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateImageBuilderStreamingURLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateImageBuilderStreamingURLError {
    fn code(&self) -> Option<&str> {
        CreateImageBuilderStreamingURLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateImageBuilderStreamingURLError {
    /// Creates a new `CreateImageBuilderStreamingURLError`.
    pub fn new(
        kind: CreateImageBuilderStreamingURLErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateImageBuilderStreamingURLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateImageBuilderStreamingURLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateImageBuilderStreamingURLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateImageBuilderStreamingURLErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateImageBuilderStreamingURLErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderStreamingURLErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateImageBuilderStreamingURLErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateImageBuilderStreamingURLErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateImageBuilderStreamingURLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateImageBuilderStreamingURLErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            CreateImageBuilderStreamingURLErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateImageBuilderStreamingURLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStackError {
    /// Kind of error that occurred.
    pub kind: CreateStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStackErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStackErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStackError {
    fn code(&self) -> Option<&str> {
        CreateStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStackError {
    /// Creates a new `CreateStackError`.
    pub fn new(kind: CreateStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(&self.kind, CreateStackErrorKind::InvalidRoleException(_))
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateStackErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStackErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStackErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateStackErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            CreateStackErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateStackErrorKind::InvalidRoleException(_inner) => Some(_inner),
            CreateStackErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateStackErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateStackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateStreamingURL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateStreamingURLError {
    /// Kind of error that occurred.
    pub kind: CreateStreamingURLErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateStreamingURL` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateStreamingURLErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateStreamingURLError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateStreamingURLErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            CreateStreamingURLErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateStreamingURLErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            CreateStreamingURLErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateStreamingURLErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateStreamingURLError {
    fn code(&self) -> Option<&str> {
        CreateStreamingURLError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateStreamingURLError {
    /// Creates a new `CreateStreamingURLError`.
    pub fn new(kind: CreateStreamingURLErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateStreamingURLError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateStreamingURLErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateStreamingURLError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateStreamingURLErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateStreamingURLErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingURLErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingURLErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingURLErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingURLErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingURLErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateStreamingURLErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateStreamingURLErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateStreamingURLError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateStreamingURLErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            CreateStreamingURLErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateStreamingURLErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            CreateStreamingURLErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateStreamingURLErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUpdatedImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUpdatedImageError {
    /// Kind of error that occurred.
    pub kind: CreateUpdatedImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUpdatedImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUpdatedImageErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUpdatedImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUpdatedImageErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateUpdatedImageErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            CreateUpdatedImageErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            CreateUpdatedImageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUpdatedImageErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateUpdatedImageErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateUpdatedImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUpdatedImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUpdatedImageError {
    fn code(&self) -> Option<&str> {
        CreateUpdatedImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUpdatedImageError {
    /// Creates a new `CreateUpdatedImageError`.
    pub fn new(kind: CreateUpdatedImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUpdatedImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUpdatedImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUpdatedImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUpdatedImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUpdatedImageErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedImageErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedImageErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedImageErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedImageErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedImageErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedImageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedImageErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedImageErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedImageErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedImageErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedImageErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUpdatedImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUpdatedImageErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateUpdatedImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUpdatedImageErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateUpdatedImageErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            CreateUpdatedImageErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            CreateUpdatedImageErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUpdatedImageErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateUpdatedImageErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateUpdatedImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUpdatedImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUsageReportSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUsageReportSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateUsageReportSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUsageReportSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUsageReportSubscriptionErrorKind {
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUsageReportSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUsageReportSubscriptionErrorKind::InvalidAccountStatusException(_inner) => {
                _inner.fmt(f)
            }
            CreateUsageReportSubscriptionErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            CreateUsageReportSubscriptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUsageReportSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUsageReportSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateUsageReportSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUsageReportSubscriptionError {
    /// Creates a new `CreateUsageReportSubscriptionError`.
    pub fn new(
        kind: CreateUsageReportSubscriptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUsageReportSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUsageReportSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUsageReportSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUsageReportSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUsageReportSubscriptionErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageReportSubscriptionErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUsageReportSubscriptionErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageReportSubscriptionErrorKind::InvalidRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUsageReportSubscriptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageReportSubscriptionErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateUsageReportSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUsageReportSubscriptionErrorKind::InvalidAccountStatusException(_inner) => {
                Some(_inner)
            }
            CreateUsageReportSubscriptionErrorKind::InvalidRoleException(_inner) => Some(_inner),
            CreateUsageReportSubscriptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUsageReportSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            CreateUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            CreateUserErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAppBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAppBlockError {
    /// Kind of error that occurred.
    pub kind: DeleteAppBlockErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAppBlock` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAppBlockErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAppBlockError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAppBlockErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteAppBlockErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteAppBlockErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAppBlockErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAppBlockError {
    fn code(&self) -> Option<&str> {
        DeleteAppBlockError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAppBlockError {
    /// Creates a new `DeleteAppBlockError`.
    pub fn new(kind: DeleteAppBlockErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAppBlockError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAppBlockErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAppBlockError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAppBlockErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAppBlockErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppBlockErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppBlockErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppBlockErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAppBlockErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAppBlockErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteAppBlockError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAppBlockErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteAppBlockErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteAppBlockErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAppBlockErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApplicationError {
    /// Kind of error that occurred.
    pub kind: DeleteApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApplicationErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApplicationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApplicationError {
    fn code(&self) -> Option<&str> {
        DeleteApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApplicationError {
    /// Creates a new `DeleteApplicationError`.
    pub fn new(kind: DeleteApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApplicationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDirectoryConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDirectoryConfigError {
    /// Kind of error that occurred.
    pub kind: DeleteDirectoryConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDirectoryConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDirectoryConfigErrorKind {
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDirectoryConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDirectoryConfigErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteDirectoryConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDirectoryConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDirectoryConfigError {
    fn code(&self) -> Option<&str> {
        DeleteDirectoryConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDirectoryConfigError {
    /// Creates a new `DeleteDirectoryConfigError`.
    pub fn new(kind: DeleteDirectoryConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDirectoryConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDirectoryConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDirectoryConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDirectoryConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDirectoryConfigErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryConfigErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDirectoryConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDirectoryConfigErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDirectoryConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDirectoryConfigErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteDirectoryConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDirectoryConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFleetError {
    /// Kind of error that occurred.
    pub kind: DeleteFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFleetErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFleetError {
    fn code(&self) -> Option<&str> {
        DeleteFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFleetError {
    /// Creates a new `DeleteFleetError`.
    pub fn new(kind: DeleteFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteFleetErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFleetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFleetErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteFleetErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteImageError {
    /// Kind of error that occurred.
    pub kind: DeleteImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteImageErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteImageErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteImageErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteImageErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteImageErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteImageError {
    fn code(&self) -> Option<&str> {
        DeleteImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteImageError {
    /// Creates a new `DeleteImageError`.
    pub fn new(kind: DeleteImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteImageErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImageErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImageErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImageErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImageErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteImageErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteImageErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImageErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteImageErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteImageErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteImageErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteImageErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteImageBuilderError {
    /// Kind of error that occurred.
    pub kind: DeleteImageBuilderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteImageBuilderErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteImageBuilderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteImageBuilderErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteImageBuilderErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DeleteImageBuilderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteImageBuilderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteImageBuilderError {
    fn code(&self) -> Option<&str> {
        DeleteImageBuilderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteImageBuilderError {
    /// Creates a new `DeleteImageBuilderError`.
    pub fn new(kind: DeleteImageBuilderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteImageBuilderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteImageBuilderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteImageBuilderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteImageBuilderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteImageBuilderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImageBuilderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImageBuilderErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImageBuilderErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImageBuilderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImageBuilderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteImageBuilderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteImageBuilderErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteImageBuilderErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DeleteImageBuilderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteImageBuilderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteImagePermissionsError {
    /// Kind of error that occurred.
    pub kind: DeleteImagePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteImagePermissionsErrorKind {
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteImagePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteImagePermissionsErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            DeleteImagePermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteImagePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteImagePermissionsError {
    fn code(&self) -> Option<&str> {
        DeleteImagePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteImagePermissionsError {
    /// Creates a new `DeleteImagePermissionsError`.
    pub fn new(kind: DeleteImagePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteImagePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteImagePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteImagePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteImagePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteImagePermissionsErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImagePermissionsErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteImagePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteImagePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteImagePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteImagePermissionsErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            DeleteImagePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteImagePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteStackError {
    /// Kind of error that occurred.
    pub kind: DeleteStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteStackErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteStackErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteStackErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteStackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteStackError {
    fn code(&self) -> Option<&str> {
        DeleteStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteStackError {
    /// Creates a new `DeleteStackError`.
    pub fn new(kind: DeleteStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteStackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteStackErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteStackErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteStackErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteStackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteStackErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteStackErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteStackErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteStackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUsageReportSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUsageReportSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteUsageReportSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUsageReportSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUsageReportSubscriptionErrorKind {
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUsageReportSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUsageReportSubscriptionErrorKind::InvalidAccountStatusException(_inner) => {
                _inner.fmt(f)
            }
            DeleteUsageReportSubscriptionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteUsageReportSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUsageReportSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteUsageReportSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUsageReportSubscriptionError {
    /// Creates a new `DeleteUsageReportSubscriptionError`.
    pub fn new(
        kind: DeleteUsageReportSubscriptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUsageReportSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUsageReportSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUsageReportSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUsageReportSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUsageReportSubscriptionErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsageReportSubscriptionErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUsageReportSubscriptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsageReportSubscriptionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteUsageReportSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUsageReportSubscriptionErrorKind::InvalidAccountStatusException(_inner) => {
                Some(_inner)
            }
            DeleteUsageReportSubscriptionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteUsageReportSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAppBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAppBlocksError {
    /// Kind of error that occurred.
    pub kind: DescribeAppBlocksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAppBlocks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAppBlocksErrorKind {
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAppBlocksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAppBlocksErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DescribeAppBlocksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAppBlocksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAppBlocksError {
    fn code(&self) -> Option<&str> {
        DescribeAppBlocksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAppBlocksError {
    /// Creates a new `DescribeAppBlocksError`.
    pub fn new(kind: DescribeAppBlocksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAppBlocksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAppBlocksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAppBlocksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAppBlocksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAppBlocksErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppBlocksErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAppBlocksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAppBlocksErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeAppBlocksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAppBlocksErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DescribeAppBlocksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAppBlocksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplicationFleetAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationFleetAssociationsError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationFleetAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplicationFleetAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationFleetAssociationsErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationFleetAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationFleetAssociationsErrorKind::InvalidParameterCombinationException(
                _inner,
            ) => _inner.fmt(f),
            DescribeApplicationFleetAssociationsErrorKind::OperationNotPermittedException(
                _inner,
            ) => _inner.fmt(f),
            DescribeApplicationFleetAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationFleetAssociationsError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationFleetAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationFleetAssociationsError {
    /// Creates a new `DescribeApplicationFleetAssociationsError`.
    pub fn new(
        kind: DescribeApplicationFleetAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationFleetAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationFleetAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationFleetAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationFleetAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApplicationFleetAssociationsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationFleetAssociationsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationFleetAssociationsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationFleetAssociationsErrorKind::OperationNotPermittedException(_)
        )
    }
}
impl std::error::Error for DescribeApplicationFleetAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationFleetAssociationsErrorKind::InvalidParameterCombinationException(
                _inner,
            ) => Some(_inner),
            DescribeApplicationFleetAssociationsErrorKind::OperationNotPermittedException(
                _inner,
            ) => Some(_inner),
            DescribeApplicationFleetAssociationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicationsError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicationsErrorKind {
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicationsErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DescribeApplicationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeApplicationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicationsError {
    fn code(&self) -> Option<&str> {
        DescribeApplicationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicationsError {
    /// Creates a new `DescribeApplicationsError`.
    pub fn new(kind: DescribeApplicationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApplicationsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationsErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicationsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeApplicationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicationsErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DescribeApplicationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeApplicationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDirectoryConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDirectoryConfigsError {
    /// Kind of error that occurred.
    pub kind: DescribeDirectoryConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDirectoryConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDirectoryConfigsErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDirectoryConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDirectoryConfigsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDirectoryConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDirectoryConfigsError {
    fn code(&self) -> Option<&str> {
        DescribeDirectoryConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDirectoryConfigsError {
    /// Creates a new `DescribeDirectoryConfigsError`.
    pub fn new(kind: DescribeDirectoryConfigsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDirectoryConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDirectoryConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDirectoryConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDirectoryConfigsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDirectoryConfigsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDirectoryConfigsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeDirectoryConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDirectoryConfigsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDirectoryConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFleetsError {
    /// Kind of error that occurred.
    pub kind: DescribeFleetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFleetsErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFleetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFleetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeFleetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFleetsError {
    fn code(&self) -> Option<&str> {
        DescribeFleetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFleetsError {
    /// Creates a new `DescribeFleetsError`.
    pub fn new(kind: DescribeFleetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFleetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFleetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFleetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFleetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFleetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFleetsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeFleetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFleetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeFleetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImageBuilders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImageBuildersError {
    /// Kind of error that occurred.
    pub kind: DescribeImageBuildersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImageBuilders` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImageBuildersErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImageBuildersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImageBuildersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeImageBuildersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImageBuildersError {
    fn code(&self) -> Option<&str> {
        DescribeImageBuildersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImageBuildersError {
    /// Creates a new `DescribeImageBuildersError`.
    pub fn new(kind: DescribeImageBuildersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImageBuildersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImageBuildersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImageBuildersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImageBuildersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImageBuildersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImageBuildersErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeImageBuildersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImageBuildersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeImageBuildersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImagePermissionsError {
    /// Kind of error that occurred.
    pub kind: DescribeImagePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImagePermissionsErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImagePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImagePermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeImagePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImagePermissionsError {
    fn code(&self) -> Option<&str> {
        DescribeImagePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImagePermissionsError {
    /// Creates a new `DescribeImagePermissionsError`.
    pub fn new(kind: DescribeImagePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImagePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImagePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImagePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImagePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImagePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeImagePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImagePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeImagePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeImagesError {
    /// Kind of error that occurred.
    pub kind: DescribeImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeImagesErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeImagesErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeImagesError {
    fn code(&self) -> Option<&str> {
        DescribeImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeImagesError {
    /// Creates a new `DescribeImagesError`.
    pub fn new(kind: DescribeImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeImagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeImagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeImagesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeImagesErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeImagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSessionsError {
    /// Kind of error that occurred.
    pub kind: DescribeSessionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSessions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSessionsErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSessionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSessionsErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSessionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSessionsError {
    fn code(&self) -> Option<&str> {
        DescribeSessionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSessionsError {
    /// Creates a new `DescribeSessionsError`.
    pub fn new(kind: DescribeSessionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSessionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSessionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSessionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSessionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSessionsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSessionsErrorKind::InvalidParameterCombinationException(_)
        )
    }
}
impl std::error::Error for DescribeSessionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSessionsErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeSessionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStacksError {
    /// Kind of error that occurred.
    pub kind: DescribeStacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStacksErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStacksErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeStacksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStacksError {
    fn code(&self) -> Option<&str> {
        DescribeStacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStacksError {
    /// Creates a new `DescribeStacksError`.
    pub fn new(kind: DescribeStacksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStacksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeStacksErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeStacksErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeStacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStacksErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeStacksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUsageReportSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUsageReportSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeUsageReportSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUsageReportSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUsageReportSubscriptionsErrorKind {
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUsageReportSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUsageReportSubscriptionsErrorKind::InvalidAccountStatusException(_inner) => {
                _inner.fmt(f)
            }
            DescribeUsageReportSubscriptionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeUsageReportSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUsageReportSubscriptionsError {
    fn code(&self) -> Option<&str> {
        DescribeUsageReportSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUsageReportSubscriptionsError {
    /// Creates a new `DescribeUsageReportSubscriptionsError`.
    pub fn new(
        kind: DescribeUsageReportSubscriptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUsageReportSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUsageReportSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUsageReportSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUsageReportSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUsageReportSubscriptionsErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsageReportSubscriptionsErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUsageReportSubscriptionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsageReportSubscriptionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeUsageReportSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUsageReportSubscriptionsErrorKind::InvalidAccountStatusException(_inner) => {
                Some(_inner)
            }
            DescribeUsageReportSubscriptionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeUsageReportSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUsersError {
    /// Kind of error that occurred.
    pub kind: DescribeUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUsersErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUsersErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            DescribeUsersErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DescribeUsersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUsersError {
    fn code(&self) -> Option<&str> {
        DescribeUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUsersError {
    /// Creates a new `DescribeUsersError`.
    pub fn new(kind: DescribeUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUsersErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsersErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUsersErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsersErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUsersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsersErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUsersErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            DescribeUsersErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DescribeUsersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserStackAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserStackAssociationsError {
    /// Kind of error that occurred.
    pub kind: DescribeUserStackAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserStackAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserStackAssociationsErrorKind {
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserStackAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserStackAssociationsErrorKind::InvalidParameterCombinationException(
                _inner,
            ) => _inner.fmt(f),
            DescribeUserStackAssociationsErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeUserStackAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserStackAssociationsError {
    fn code(&self) -> Option<&str> {
        DescribeUserStackAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserStackAssociationsError {
    /// Creates a new `DescribeUserStackAssociationsError`.
    pub fn new(
        kind: DescribeUserStackAssociationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserStackAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserStackAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserStackAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserStackAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserStackAssociationsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserStackAssociationsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserStackAssociationsErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserStackAssociationsErrorKind::OperationNotPermittedException(_)
        )
    }
}
impl std::error::Error for DescribeUserStackAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserStackAssociationsErrorKind::InvalidParameterCombinationException(
                _inner,
            ) => Some(_inner),
            DescribeUserStackAssociationsErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            DescribeUserStackAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableUserError {
    /// Kind of error that occurred.
    pub kind: DisableUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableUserErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableUserError {
    fn code(&self) -> Option<&str> {
        DisableUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableUserError {
    /// Creates a new `DisableUserError`.
    pub fn new(kind: DisableUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableUserErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisableUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateApplicationFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateApplicationFleetError {
    /// Kind of error that occurred.
    pub kind: DisassociateApplicationFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateApplicationFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateApplicationFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateApplicationFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateApplicationFleetErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateApplicationFleetErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateApplicationFleetErrorKind::OperationNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateApplicationFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateApplicationFleetError {
    fn code(&self) -> Option<&str> {
        DisassociateApplicationFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateApplicationFleetError {
    /// Creates a new `DisassociateApplicationFleetError`.
    pub fn new(kind: DisassociateApplicationFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateApplicationFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateApplicationFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateApplicationFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateApplicationFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateApplicationFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApplicationFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateApplicationFleetErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApplicationFleetErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateApplicationFleetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApplicationFleetErrorKind::OperationNotPermittedException(_)
        )
    }
}
impl std::error::Error for DisassociateApplicationFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateApplicationFleetErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DisassociateApplicationFleetErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DisassociateApplicationFleetErrorKind::OperationNotPermittedException(_inner) => {
                Some(_inner)
            }
            DisassociateApplicationFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateFleetError {
    /// Kind of error that occurred.
    pub kind: DisassociateFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateFleetErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DisassociateFleetErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            DisassociateFleetErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DisassociateFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateFleetError {
    fn code(&self) -> Option<&str> {
        DisassociateFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateFleetError {
    /// Creates a new `DisassociateFleetError`.
    pub fn new(kind: DisassociateFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFleetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFleetErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFleetErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFleetErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFleetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateFleetErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DisassociateFleetErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            DisassociateFleetErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DisassociateFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableUserError {
    /// Kind of error that occurred.
    pub kind: EnableUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableUserErrorKind {
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableUserErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableUserError {
    fn code(&self) -> Option<&str> {
        EnableUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableUserError {
    /// Creates a new `EnableUserError`.
    pub fn new(kind: EnableUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableUserErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableUserErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for EnableUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableUserErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            EnableUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExpireSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExpireSessionError {
    /// Kind of error that occurred.
    pub kind: ExpireSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExpireSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExpireSessionErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExpireSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExpireSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExpireSessionError {
    fn code(&self) -> Option<&str> {
        ExpireSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExpireSessionError {
    /// Creates a new `ExpireSessionError`.
    pub fn new(kind: ExpireSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExpireSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExpireSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExpireSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExpireSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ExpireSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExpireSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociatedFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociatedFleetsError {
    /// Kind of error that occurred.
    pub kind: ListAssociatedFleetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociatedFleets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociatedFleetsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociatedFleetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociatedFleetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssociatedFleetsError {
    fn code(&self) -> Option<&str> {
        ListAssociatedFleetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociatedFleetsError {
    /// Creates a new `ListAssociatedFleetsError`.
    pub fn new(kind: ListAssociatedFleetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociatedFleetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociatedFleetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociatedFleetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociatedFleetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListAssociatedFleetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociatedFleetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociatedStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociatedStacksError {
    /// Kind of error that occurred.
    pub kind: ListAssociatedStacksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociatedStacks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociatedStacksErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociatedStacksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociatedStacksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssociatedStacksError {
    fn code(&self) -> Option<&str> {
        ListAssociatedStacksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociatedStacksError {
    /// Creates a new `ListAssociatedStacksError`.
    pub fn new(kind: ListAssociatedStacksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociatedStacksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociatedStacksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociatedStacksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociatedStacksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListAssociatedStacksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociatedStacksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFleetError {
    /// Kind of error that occurred.
    pub kind: StartFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are being throttled by Amazon EC2. Try again later.</p>
    RequestLimitExceededException(crate::error::RequestLimitExceededException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFleetErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::RequestLimitExceededException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFleetError {
    fn code(&self) -> Option<&str> {
        StartFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFleetError {
    /// Creates a new `StartFleetError`.
    pub fn new(kind: StartFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(&self.kind, StartFleetErrorKind::InvalidRoleException(_))
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StartFleetErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::RequestLimitExceededException`.
    pub fn is_request_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetErrorKind::RequestLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFleetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFleetErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            StartFleetErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            StartFleetErrorKind::InvalidRoleException(_inner) => Some(_inner),
            StartFleetErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartFleetErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            StartFleetErrorKind::RequestLimitExceededException(_inner) => Some(_inner),
            StartFleetErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            StartFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartImageBuilderError {
    /// Kind of error that occurred.
    pub kind: StartImageBuilderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartImageBuilderErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartImageBuilderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartImageBuilderErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            StartImageBuilderErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            StartImageBuilderErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            StartImageBuilderErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            StartImageBuilderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartImageBuilderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartImageBuilderError {
    fn code(&self) -> Option<&str> {
        StartImageBuilderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartImageBuilderError {
    /// Creates a new `StartImageBuilderError`.
    pub fn new(kind: StartImageBuilderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartImageBuilderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartImageBuilderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartImageBuilderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartImageBuilderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartImageBuilderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageBuilderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageBuilderErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageBuilderErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageBuilderErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageBuilderErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageBuilderErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageBuilderErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartImageBuilderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartImageBuilderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartImageBuilderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartImageBuilderErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            StartImageBuilderErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            StartImageBuilderErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            StartImageBuilderErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            StartImageBuilderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartImageBuilderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopFleetError {
    /// Kind of error that occurred.
    pub kind: StopFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopFleetErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            StopFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopFleetError {
    fn code(&self) -> Option<&str> {
        StopFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopFleetError {
    /// Creates a new `StopFleetError`.
    pub fn new(kind: StopFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopFleetErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for StopFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopFleetErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            StopFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopImageBuilderError {
    /// Kind of error that occurred.
    pub kind: StopImageBuilderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopImageBuilder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopImageBuilderErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopImageBuilderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopImageBuilderErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            StopImageBuilderErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            StopImageBuilderErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopImageBuilderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopImageBuilderError {
    fn code(&self) -> Option<&str> {
        StopImageBuilderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopImageBuilderError {
    /// Creates a new `StopImageBuilderError`.
    pub fn new(kind: StopImageBuilderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopImageBuilderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopImageBuilderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopImageBuilderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopImageBuilderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopImageBuilderErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopImageBuilderErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `StopImageBuilderErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopImageBuilderErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `StopImageBuilderErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopImageBuilderErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopImageBuilderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopImageBuilderErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            StopImageBuilderErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            StopImageBuilderErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopImageBuilderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            TagResourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApplicationError {
    /// Kind of error that occurred.
    pub kind: UpdateApplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApplicationErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApplicationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateApplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApplicationError {
    fn code(&self) -> Option<&str> {
        UpdateApplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApplicationError {
    /// Creates a new `UpdateApplicationError`.
    pub fn new(kind: UpdateApplicationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApplicationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApplicationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApplicationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateApplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApplicationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateApplicationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDirectoryConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDirectoryConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateDirectoryConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDirectoryConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDirectoryConfigErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDirectoryConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDirectoryConfigErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDirectoryConfigErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            UpdateDirectoryConfigErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateDirectoryConfigErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateDirectoryConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDirectoryConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDirectoryConfigError {
    fn code(&self) -> Option<&str> {
        UpdateDirectoryConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDirectoryConfigError {
    /// Creates a new `UpdateDirectoryConfigError`.
    pub fn new(kind: UpdateDirectoryConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDirectoryConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDirectoryConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDirectoryConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDirectoryConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDirectoryConfigErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDirectoryConfigErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDirectoryConfigErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDirectoryConfigErrorKind::InvalidRoleException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDirectoryConfigErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDirectoryConfigErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDirectoryConfigErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDirectoryConfigErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDirectoryConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDirectoryConfigErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateDirectoryConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDirectoryConfigErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateDirectoryConfigErrorKind::InvalidRoleException(_inner) => Some(_inner),
            UpdateDirectoryConfigErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateDirectoryConfigErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateDirectoryConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDirectoryConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFleetError {
    /// Kind of error that occurred.
    pub kind: UpdateFleetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFleet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFleetErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are being throttled by Amazon EC2. Try again later.</p>
    RequestLimitExceededException(crate::error::RequestLimitExceededException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFleetErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::RequestLimitExceededException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFleetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFleetError {
    fn code(&self) -> Option<&str> {
        UpdateFleetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFleetError {
    /// Creates a new `UpdateFleetError`.
    pub fn new(kind: UpdateFleetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFleetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFleetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFleetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFleetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(&self.kind, UpdateFleetErrorKind::InvalidRoleException(_))
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateFleetErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::RequestLimitExceededException`.
    pub fn is_request_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::RequestLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateFleetErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFleetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFleetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateFleetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFleetErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateFleetErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            UpdateFleetErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            UpdateFleetErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UpdateFleetErrorKind::InvalidRoleException(_inner) => Some(_inner),
            UpdateFleetErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateFleetErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateFleetErrorKind::RequestLimitExceededException(_inner) => Some(_inner),
            UpdateFleetErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateFleetErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            UpdateFleetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFleetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateImagePermissionsError {
    /// Kind of error that occurred.
    pub kind: UpdateImagePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateImagePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateImagePermissionsErrorKind {
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource exists and is not in use, but isn't available.</p>
    ResourceNotAvailableException(crate::error::ResourceNotAvailableException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateImagePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateImagePermissionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateImagePermissionsErrorKind::ResourceNotAvailableException(_inner) => _inner.fmt(f),
            UpdateImagePermissionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateImagePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateImagePermissionsError {
    fn code(&self) -> Option<&str> {
        UpdateImagePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateImagePermissionsError {
    /// Creates a new `UpdateImagePermissionsError`.
    pub fn new(kind: UpdateImagePermissionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateImagePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateImagePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateImagePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateImagePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateImagePermissionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateImagePermissionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateImagePermissionsErrorKind::ResourceNotAvailableException`.
    pub fn is_resource_not_available_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateImagePermissionsErrorKind::ResourceNotAvailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateImagePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateImagePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateImagePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateImagePermissionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateImagePermissionsErrorKind::ResourceNotAvailableException(_inner) => Some(_inner),
            UpdateImagePermissionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateImagePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateStackError {
    /// Kind of error that occurred.
    pub kind: UpdateStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateStackErrorKind {
    /// <p>An API error occurred. Wait a few minutes and try again.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>The image can't be updated because it's not compatible for updates.</p>
    IncompatibleImageException(crate::error::IncompatibleImageException),
    /// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
    InvalidAccountStatusException(crate::error::InvalidAccountStatusException),
    /// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The specified role is invalid.</p>
    InvalidRoleException(crate::error::InvalidRoleException),
    /// <p>The requested limit exceeds the permitted limit for an account.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The attempted operation is not permitted.</p>
    OperationNotPermittedException(crate::error::OperationNotPermittedException),
    /// <p>The specified resource is in use.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateStackErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::IncompatibleImageException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::InvalidAccountStatusException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::InvalidRoleException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::OperationNotPermittedException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateStackError {
    fn code(&self) -> Option<&str> {
        UpdateStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateStackError {
    /// Creates a new `UpdateStackError`.
    pub fn new(kind: UpdateStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateStackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::IncompatibleImageException`.
    pub fn is_incompatible_image_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::IncompatibleImageException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::InvalidAccountStatusException`.
    pub fn is_invalid_account_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::InvalidAccountStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::InvalidRoleException`.
    pub fn is_invalid_role_exception(&self) -> bool {
        matches!(&self.kind, UpdateStackErrorKind::InvalidRoleException(_))
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateStackErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::OperationNotPermittedException`.
    pub fn is_operation_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::OperationNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, UpdateStackErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `UpdateStackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateStackErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateStackErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateStackErrorKind::IncompatibleImageException(_inner) => Some(_inner),
            UpdateStackErrorKind::InvalidAccountStatusException(_inner) => Some(_inner),
            UpdateStackErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            UpdateStackErrorKind::InvalidRoleException(_inner) => Some(_inner),
            UpdateStackErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateStackErrorKind::OperationNotPermittedException(_inner) => Some(_inner),
            UpdateStackErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateStackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The specified resource is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The attempted operation is not permitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationNotPermittedException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationNotPermittedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationNotPermittedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationNotPermittedException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationNotPermittedException {}
/// See [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
pub mod operation_not_permitted_exception {
    /// A builder for [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
        pub fn build(self) -> crate::error::OperationNotPermittedException {
            crate::error::OperationNotPermittedException {
                message: self.message,
            }
        }
    }
}
impl OperationNotPermittedException {
    /// Creates a new builder-style object to manufacture [`OperationNotPermittedException`](crate::error::OperationNotPermittedException)
    pub fn builder() -> crate::error::operation_not_permitted_exception::Builder {
        crate::error::operation_not_permitted_exception::Builder::default()
    }
}

/// <p>The requested limit exceeds the permitted limit for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified role is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRoleException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRoleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRoleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRoleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRoleException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRoleException {}
/// See [`InvalidRoleException`](crate::error::InvalidRoleException)
pub mod invalid_role_exception {
    /// A builder for [`InvalidRoleException`](crate::error::InvalidRoleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRoleException`](crate::error::InvalidRoleException)
        pub fn build(self) -> crate::error::InvalidRoleException {
            crate::error::InvalidRoleException {
                message: self.message,
            }
        }
    }
}
impl InvalidRoleException {
    /// Creates a new builder-style object to manufacture [`InvalidRoleException`](crate::error::InvalidRoleException)
    pub fn builder() -> crate::error::invalid_role_exception::Builder {
        crate::error::invalid_role_exception::Builder::default()
    }
}

/// <p>Indicates an incorrect combination of parameters, or a missing parameter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterCombinationException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterCombinationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterCombinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterCombinationException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterCombinationException {}
/// See [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
pub mod invalid_parameter_combination_exception {
    /// A builder for [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
        pub fn build(self) -> crate::error::InvalidParameterCombinationException {
            crate::error::InvalidParameterCombinationException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterCombinationException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    pub fn builder() -> crate::error::invalid_parameter_combination_exception::Builder {
        crate::error::invalid_parameter_combination_exception::Builder::default()
    }
}

/// <p>The resource cannot be created because your AWS account is suspended. For assistance, contact AWS Support. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAccountStatusException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAccountStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAccountStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAccountStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAccountStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAccountStatusException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAccountStatusException {}
/// See [`InvalidAccountStatusException`](crate::error::InvalidAccountStatusException)
pub mod invalid_account_status_exception {
    /// A builder for [`InvalidAccountStatusException`](crate::error::InvalidAccountStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAccountStatusException`](crate::error::InvalidAccountStatusException)
        pub fn build(self) -> crate::error::InvalidAccountStatusException {
            crate::error::InvalidAccountStatusException {
                message: self.message,
            }
        }
    }
}
impl InvalidAccountStatusException {
    /// Creates a new builder-style object to manufacture [`InvalidAccountStatusException`](crate::error::InvalidAccountStatusException)
    pub fn builder() -> crate::error::invalid_account_status_exception::Builder {
        crate::error::invalid_account_status_exception::Builder::default()
    }
}

/// <p>The image can't be updated because it's not compatible for updates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleImageException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatibleImageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleImageException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleImageException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleImageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatibleImageException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleImageException {}
/// See [`IncompatibleImageException`](crate::error::IncompatibleImageException)
pub mod incompatible_image_exception {
    /// A builder for [`IncompatibleImageException`](crate::error::IncompatibleImageException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleImageException`](crate::error::IncompatibleImageException)
        pub fn build(self) -> crate::error::IncompatibleImageException {
            crate::error::IncompatibleImageException {
                message: self.message,
            }
        }
    }
}
impl IncompatibleImageException {
    /// Creates a new builder-style object to manufacture [`IncompatibleImageException`](crate::error::IncompatibleImageException)
    pub fn builder() -> crate::error::incompatible_image_exception::Builder {
        crate::error::incompatible_image_exception::Builder::default()
    }
}

/// <p>An API error occurred. Wait a few minutes and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The specified resource exists and is not in use, but isn't available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotAvailableException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotAvailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotAvailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotAvailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotAvailableException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotAvailableException {}
/// See [`ResourceNotAvailableException`](crate::error::ResourceNotAvailableException)
pub mod resource_not_available_exception {
    /// A builder for [`ResourceNotAvailableException`](crate::error::ResourceNotAvailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotAvailableException`](crate::error::ResourceNotAvailableException)
        pub fn build(self) -> crate::error::ResourceNotAvailableException {
            crate::error::ResourceNotAvailableException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotAvailableException {
    /// Creates a new builder-style object to manufacture [`ResourceNotAvailableException`](crate::error::ResourceNotAvailableException)
    pub fn builder() -> crate::error::resource_not_available_exception::Builder {
        crate::error::resource_not_available_exception::Builder::default()
    }
}

/// <p>AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are being throttled by Amazon EC2. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestLimitExceededException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestLimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestLimitExceededException {}
/// See [`RequestLimitExceededException`](crate::error::RequestLimitExceededException)
pub mod request_limit_exceeded_exception {
    /// A builder for [`RequestLimitExceededException`](crate::error::RequestLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestLimitExceededException`](crate::error::RequestLimitExceededException)
        pub fn build(self) -> crate::error::RequestLimitExceededException {
            crate::error::RequestLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl RequestLimitExceededException {
    /// Creates a new builder-style object to manufacture [`RequestLimitExceededException`](crate::error::RequestLimitExceededException)
    pub fn builder() -> crate::error::request_limit_exceeded_exception::Builder {
        crate::error::request_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    /// <p>The error message in the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message in the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message in the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
