// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes a stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Stack {
    /// <p>The ARN of the stack.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the stack.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The stack name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The time the stack was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The storage connectors to enable.</p>
    pub storage_connectors: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
    /// <p>The URL that users are redirected to after their streaming session ends.</p>
    pub redirect_url: std::option::Option<std::string::String>,
    /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    pub feedback_url: std::option::Option<std::string::String>,
    /// <p>The errors for the stack.</p>
    pub stack_errors: std::option::Option<std::vec::Vec<crate::model::StackError>>,
    /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default these actions are enabled.</p>
    pub user_settings: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
    /// <p>The persistent application settings for users of the stack.</p>
    pub application_settings: std::option::Option<crate::model::ApplicationSettingsResponse>,
    /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints. </p>
    pub access_endpoints: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
    /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.</p>
    pub embed_host_domains: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Stack {
    /// <p>The ARN of the stack.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the stack.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The stack name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The time the stack was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The storage connectors to enable.</p>
    pub fn storage_connectors(&self) -> std::option::Option<&[crate::model::StorageConnector]> {
        self.storage_connectors.as_deref()
    }
    /// <p>The URL that users are redirected to after their streaming session ends.</p>
    pub fn redirect_url(&self) -> std::option::Option<&str> {
        self.redirect_url.as_deref()
    }
    /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
    pub fn feedback_url(&self) -> std::option::Option<&str> {
        self.feedback_url.as_deref()
    }
    /// <p>The errors for the stack.</p>
    pub fn stack_errors(&self) -> std::option::Option<&[crate::model::StackError]> {
        self.stack_errors.as_deref()
    }
    /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default these actions are enabled.</p>
    pub fn user_settings(&self) -> std::option::Option<&[crate::model::UserSetting]> {
        self.user_settings.as_deref()
    }
    /// <p>The persistent application settings for users of the stack.</p>
    pub fn application_settings(
        &self,
    ) -> std::option::Option<&crate::model::ApplicationSettingsResponse> {
        self.application_settings.as_ref()
    }
    /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints. </p>
    pub fn access_endpoints(&self) -> std::option::Option<&[crate::model::AccessEndpoint]> {
        self.access_endpoints.as_deref()
    }
    /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.</p>
    pub fn embed_host_domains(&self) -> std::option::Option<&[std::string::String]> {
        self.embed_host_domains.as_deref()
    }
}
impl std::fmt::Debug for Stack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Stack");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field("created_time", &self.created_time);
        formatter.field("storage_connectors", &self.storage_connectors);
        formatter.field("redirect_url", &self.redirect_url);
        formatter.field("feedback_url", &self.feedback_url);
        formatter.field("stack_errors", &self.stack_errors);
        formatter.field("user_settings", &self.user_settings);
        formatter.field("application_settings", &self.application_settings);
        formatter.field("access_endpoints", &self.access_endpoints);
        formatter.field("embed_host_domains", &self.embed_host_domains);
        formatter.finish()
    }
}
/// See [`Stack`](crate::model::Stack)
pub mod stack {
    /// A builder for [`Stack`](crate::model::Stack)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) storage_connectors:
            std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        pub(crate) redirect_url: std::option::Option<std::string::String>,
        pub(crate) feedback_url: std::option::Option<std::string::String>,
        pub(crate) stack_errors: std::option::Option<std::vec::Vec<crate::model::StackError>>,
        pub(crate) user_settings: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        pub(crate) application_settings:
            std::option::Option<crate::model::ApplicationSettingsResponse>,
        pub(crate) access_endpoints:
            std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        pub(crate) embed_host_domains: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the stack.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the stack.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The stack name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The stack name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The time the stack was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time the stack was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Appends an item to `storage_connectors`.
        ///
        /// To override the contents of this collection use [`set_storage_connectors`](Self::set_storage_connectors).
        ///
        /// <p>The storage connectors to enable.</p>
        pub fn storage_connectors(
            mut self,
            input: impl Into<crate::model::StorageConnector>,
        ) -> Self {
            let mut v = self.storage_connectors.unwrap_or_default();
            v.push(input.into());
            self.storage_connectors = Some(v);
            self
        }
        /// <p>The storage connectors to enable.</p>
        pub fn set_storage_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        ) -> Self {
            self.storage_connectors = input;
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn redirect_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.redirect_url = Some(input.into());
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn set_redirect_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.redirect_url = input;
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn feedback_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.feedback_url = Some(input.into());
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn set_feedback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feedback_url = input;
            self
        }
        /// Appends an item to `stack_errors`.
        ///
        /// To override the contents of this collection use [`set_stack_errors`](Self::set_stack_errors).
        ///
        /// <p>The errors for the stack.</p>
        pub fn stack_errors(mut self, input: impl Into<crate::model::StackError>) -> Self {
            let mut v = self.stack_errors.unwrap_or_default();
            v.push(input.into());
            self.stack_errors = Some(v);
            self
        }
        /// <p>The errors for the stack.</p>
        pub fn set_stack_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackError>>,
        ) -> Self {
            self.stack_errors = input;
            self
        }
        /// Appends an item to `user_settings`.
        ///
        /// To override the contents of this collection use [`set_user_settings`](Self::set_user_settings).
        ///
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default these actions are enabled.</p>
        pub fn user_settings(mut self, input: impl Into<crate::model::UserSetting>) -> Self {
            let mut v = self.user_settings.unwrap_or_default();
            v.push(input.into());
            self.user_settings = Some(v);
            self
        }
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default these actions are enabled.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        ) -> Self {
            self.user_settings = input;
            self
        }
        /// <p>The persistent application settings for users of the stack.</p>
        pub fn application_settings(
            mut self,
            input: crate::model::ApplicationSettingsResponse,
        ) -> Self {
            self.application_settings = Some(input);
            self
        }
        /// <p>The persistent application settings for users of the stack.</p>
        pub fn set_application_settings(
            mut self,
            input: std::option::Option<crate::model::ApplicationSettingsResponse>,
        ) -> Self {
            self.application_settings = input;
            self
        }
        /// Appends an item to `access_endpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints. </p>
        pub fn access_endpoints(mut self, input: impl Into<crate::model::AccessEndpoint>) -> Self {
            let mut v = self.access_endpoints.unwrap_or_default();
            v.push(input.into());
            self.access_endpoints = Some(v);
            self
        }
        /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints. </p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.access_endpoints = input;
            self
        }
        /// Appends an item to `embed_host_domains`.
        ///
        /// To override the contents of this collection use [`set_embed_host_domains`](Self::set_embed_host_domains).
        ///
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.</p>
        pub fn embed_host_domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.embed_host_domains.unwrap_or_default();
            v.push(input.into());
            self.embed_host_domains = Some(v);
            self
        }
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.</p>
        pub fn set_embed_host_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.embed_host_domains = input;
            self
        }
        /// Consumes the builder and constructs a [`Stack`](crate::model::Stack)
        pub fn build(self) -> crate::model::Stack {
            crate::model::Stack {
                arn: self.arn,
                name: self.name,
                description: self.description,
                display_name: self.display_name,
                created_time: self.created_time,
                storage_connectors: self.storage_connectors,
                redirect_url: self.redirect_url,
                feedback_url: self.feedback_url,
                stack_errors: self.stack_errors,
                user_settings: self.user_settings,
                application_settings: self.application_settings,
                access_endpoints: self.access_endpoints,
                embed_host_domains: self.embed_host_domains,
            }
        }
    }
}
impl Stack {
    /// Creates a new builder-style object to manufacture [`Stack`](crate::model::Stack)
    pub fn builder() -> crate::model::stack::Builder {
        crate::model::stack::Builder::default()
    }
}

/// <p>Describes an interface VPC endpoint (interface endpoint) that lets you create a private connection between the virtual private cloud (VPC) that you specify and AppStream 2.0. When you specify an interface endpoint for a stack, users of the stack can connect to AppStream 2.0 only through that endpoint. When you specify an interface endpoint for an image builder, administrators can connect to the image builder only through that endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessEndpoint {
    /// <p>The type of interface endpoint.</p>
    pub endpoint_type: std::option::Option<crate::model::AccessEndpointType>,
    /// <p>The identifier (ID) of the VPC in which the interface endpoint is used.</p>
    pub vpce_id: std::option::Option<std::string::String>,
}
impl AccessEndpoint {
    /// <p>The type of interface endpoint.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&crate::model::AccessEndpointType> {
        self.endpoint_type.as_ref()
    }
    /// <p>The identifier (ID) of the VPC in which the interface endpoint is used.</p>
    pub fn vpce_id(&self) -> std::option::Option<&str> {
        self.vpce_id.as_deref()
    }
}
impl std::fmt::Debug for AccessEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessEndpoint");
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("vpce_id", &self.vpce_id);
        formatter.finish()
    }
}
/// See [`AccessEndpoint`](crate::model::AccessEndpoint)
pub mod access_endpoint {
    /// A builder for [`AccessEndpoint`](crate::model::AccessEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_type: std::option::Option<crate::model::AccessEndpointType>,
        pub(crate) vpce_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of interface endpoint.</p>
        pub fn endpoint_type(mut self, input: crate::model::AccessEndpointType) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of interface endpoint.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::AccessEndpointType>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The identifier (ID) of the VPC in which the interface endpoint is used.</p>
        pub fn vpce_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpce_id = Some(input.into());
            self
        }
        /// <p>The identifier (ID) of the VPC in which the interface endpoint is used.</p>
        pub fn set_vpce_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpce_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessEndpoint`](crate::model::AccessEndpoint)
        pub fn build(self) -> crate::model::AccessEndpoint {
            crate::model::AccessEndpoint {
                endpoint_type: self.endpoint_type,
                vpce_id: self.vpce_id,
            }
        }
    }
}
impl AccessEndpoint {
    /// Creates a new builder-style object to manufacture [`AccessEndpoint`](crate::model::AccessEndpoint)
    pub fn builder() -> crate::model::access_endpoint::Builder {
        crate::model::access_endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessEndpointType {
    #[allow(missing_docs)] // documentation missing in model
    Streaming,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessEndpointType {
    fn from(s: &str) -> Self {
        match s {
            "STREAMING" => AccessEndpointType::Streaming,
            other => AccessEndpointType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessEndpointType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessEndpointType::from(s))
    }
}
impl AccessEndpointType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessEndpointType::Streaming => "STREAMING",
            AccessEndpointType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STREAMING"]
    }
}
impl AsRef<str> for AccessEndpointType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the persistent application settings for users of a stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSettingsResponse {
    /// <p>Specifies whether persistent application settings are enabled for users during their streaming sessions.</p>
    pub enabled: bool,
    /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored.</p>
    pub settings_group: std::option::Option<std::string::String>,
    /// <p>The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
    /// </p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
}
impl ApplicationSettingsResponse {
    /// <p>Specifies whether persistent application settings are enabled for users during their streaming sessions.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored.</p>
    pub fn settings_group(&self) -> std::option::Option<&str> {
        self.settings_group.as_deref()
    }
    /// <p>The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
    /// </p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
}
impl std::fmt::Debug for ApplicationSettingsResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSettingsResponse");
        formatter.field("enabled", &self.enabled);
        formatter.field("settings_group", &self.settings_group);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.finish()
    }
}
/// See [`ApplicationSettingsResponse`](crate::model::ApplicationSettingsResponse)
pub mod application_settings_response {
    /// A builder for [`ApplicationSettingsResponse`](crate::model::ApplicationSettingsResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) settings_group: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies whether persistent application settings are enabled for users during their streaming sessions.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether persistent application settings are enabled for users during their streaming sessions.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored.</p>
        pub fn settings_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.settings_group = Some(input.into());
            self
        }
        /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored.</p>
        pub fn set_settings_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.settings_group = input;
            self
        }
        /// <p>The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
        /// </p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The S3 bucket where users’ persistent application settings are stored. When persistent application settings are enabled for the first time for an account in an AWS Region, an S3 bucket is created. The bucket is unique to the AWS account and the Region.
        /// </p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSettingsResponse`](crate::model::ApplicationSettingsResponse)
        pub fn build(self) -> crate::model::ApplicationSettingsResponse {
            crate::model::ApplicationSettingsResponse {
                enabled: self.enabled.unwrap_or_default(),
                settings_group: self.settings_group,
                s3_bucket_name: self.s3_bucket_name,
            }
        }
    }
}
impl ApplicationSettingsResponse {
    /// Creates a new builder-style object to manufacture [`ApplicationSettingsResponse`](crate::model::ApplicationSettingsResponse)
    pub fn builder() -> crate::model::application_settings_response::Builder {
        crate::model::application_settings_response::Builder::default()
    }
}

/// <p>Describes an action and whether the action is enabled or disabled for users during their streaming sessions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserSetting {
    /// <p>The action that is enabled or disabled.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>Indicates whether the action is enabled or disabled.</p>
    pub permission: std::option::Option<crate::model::Permission>,
}
impl UserSetting {
    /// <p>The action that is enabled or disabled.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>Indicates whether the action is enabled or disabled.</p>
    pub fn permission(&self) -> std::option::Option<&crate::model::Permission> {
        self.permission.as_ref()
    }
}
impl std::fmt::Debug for UserSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserSetting");
        formatter.field("action", &self.action);
        formatter.field("permission", &self.permission);
        formatter.finish()
    }
}
/// See [`UserSetting`](crate::model::UserSetting)
pub mod user_setting {
    /// A builder for [`UserSetting`](crate::model::UserSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) permission: std::option::Option<crate::model::Permission>,
    }
    impl Builder {
        /// <p>The action that is enabled or disabled.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that is enabled or disabled.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>Indicates whether the action is enabled or disabled.</p>
        pub fn permission(mut self, input: crate::model::Permission) -> Self {
            self.permission = Some(input);
            self
        }
        /// <p>Indicates whether the action is enabled or disabled.</p>
        pub fn set_permission(
            mut self,
            input: std::option::Option<crate::model::Permission>,
        ) -> Self {
            self.permission = input;
            self
        }
        /// Consumes the builder and constructs a [`UserSetting`](crate::model::UserSetting)
        pub fn build(self) -> crate::model::UserSetting {
            crate::model::UserSetting {
                action: self.action,
                permission: self.permission,
            }
        }
    }
}
impl UserSetting {
    /// Creates a new builder-style object to manufacture [`UserSetting`](crate::model::UserSetting)
    pub fn builder() -> crate::model::user_setting::Builder {
        crate::model::user_setting::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Permission {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Permission {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Permission::Disabled,
            "ENABLED" => Permission::Enabled,
            other => Permission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Permission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Permission::from(s))
    }
}
impl Permission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Permission::Disabled => "DISABLED",
            Permission::Enabled => "ENABLED",
            Permission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for Permission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Action {
    #[allow(missing_docs)] // documentation missing in model
    ClipboardCopyFromLocalDevice,
    #[allow(missing_docs)] // documentation missing in model
    ClipboardCopyToLocalDevice,
    #[allow(missing_docs)] // documentation missing in model
    DomainPasswordSignin,
    #[allow(missing_docs)] // documentation missing in model
    DomainSmartCardSignin,
    #[allow(missing_docs)] // documentation missing in model
    FileDownload,
    #[allow(missing_docs)] // documentation missing in model
    FileUpload,
    #[allow(missing_docs)] // documentation missing in model
    PrintingToLocalDevice,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Action {
    fn from(s: &str) -> Self {
        match s {
            "CLIPBOARD_COPY_FROM_LOCAL_DEVICE" => Action::ClipboardCopyFromLocalDevice,
            "CLIPBOARD_COPY_TO_LOCAL_DEVICE" => Action::ClipboardCopyToLocalDevice,
            "DOMAIN_PASSWORD_SIGNIN" => Action::DomainPasswordSignin,
            "DOMAIN_SMART_CARD_SIGNIN" => Action::DomainSmartCardSignin,
            "FILE_DOWNLOAD" => Action::FileDownload,
            "FILE_UPLOAD" => Action::FileUpload,
            "PRINTING_TO_LOCAL_DEVICE" => Action::PrintingToLocalDevice,
            other => Action::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Action {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Action::from(s))
    }
}
impl Action {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Action::ClipboardCopyFromLocalDevice => "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
            Action::ClipboardCopyToLocalDevice => "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
            Action::DomainPasswordSignin => "DOMAIN_PASSWORD_SIGNIN",
            Action::DomainSmartCardSignin => "DOMAIN_SMART_CARD_SIGNIN",
            Action::FileDownload => "FILE_DOWNLOAD",
            Action::FileUpload => "FILE_UPLOAD",
            Action::PrintingToLocalDevice => "PRINTING_TO_LOCAL_DEVICE",
            Action::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
            "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
            "DOMAIN_PASSWORD_SIGNIN",
            "DOMAIN_SMART_CARD_SIGNIN",
            "FILE_DOWNLOAD",
            "FILE_UPLOAD",
            "PRINTING_TO_LOCAL_DEVICE",
        ]
    }
}
impl AsRef<str> for Action {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a stack error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StackError {
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::StackErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl StackError {
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::StackErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for StackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StackError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`StackError`](crate::model::StackError)
pub mod stack_error {
    /// A builder for [`StackError`](crate::model::StackError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::StackErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::StackErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::StackErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`StackError`](crate::model::StackError)
        pub fn build(self) -> crate::model::StackError {
            crate::model::StackError {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl StackError {
    /// Creates a new builder-style object to manufacture [`StackError`](crate::model::StackError)
    pub fn builder() -> crate::model::stack_error::Builder {
        crate::model::stack_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    StorageConnectorError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "INTERNAL_SERVICE_ERROR" => StackErrorCode::InternalServiceError,
            "STORAGE_CONNECTOR_ERROR" => StackErrorCode::StorageConnectorError,
            other => StackErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackErrorCode::from(s))
    }
}
impl StackErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackErrorCode::InternalServiceError => "INTERNAL_SERVICE_ERROR",
            StackErrorCode::StorageConnectorError => "STORAGE_CONNECTOR_ERROR",
            StackErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERNAL_SERVICE_ERROR", "STORAGE_CONNECTOR_ERROR"]
    }
}
impl AsRef<str> for StackErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a connector that enables persistent storage for users.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageConnector {
    /// <p>The type of storage connector.</p>
    pub connector_type: std::option::Option<crate::model::StorageConnectorType>,
    /// <p>The ARN of the storage connector.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>The names of the domains for the account.</p>
    pub domains: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl StorageConnector {
    /// <p>The type of storage connector.</p>
    pub fn connector_type(&self) -> std::option::Option<&crate::model::StorageConnectorType> {
        self.connector_type.as_ref()
    }
    /// <p>The ARN of the storage connector.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>The names of the domains for the account.</p>
    pub fn domains(&self) -> std::option::Option<&[std::string::String]> {
        self.domains.as_deref()
    }
}
impl std::fmt::Debug for StorageConnector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageConnector");
        formatter.field("connector_type", &self.connector_type);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("domains", &self.domains);
        formatter.finish()
    }
}
/// See [`StorageConnector`](crate::model::StorageConnector)
pub mod storage_connector {
    /// A builder for [`StorageConnector`](crate::model::StorageConnector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_type: std::option::Option<crate::model::StorageConnectorType>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) domains: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of storage connector.</p>
        pub fn connector_type(mut self, input: crate::model::StorageConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p>The type of storage connector.</p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::StorageConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p>The ARN of the storage connector.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The ARN of the storage connector.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>The names of the domains for the account.</p>
        pub fn domains(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>The names of the domains for the account.</p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageConnector`](crate::model::StorageConnector)
        pub fn build(self) -> crate::model::StorageConnector {
            crate::model::StorageConnector {
                connector_type: self.connector_type,
                resource_identifier: self.resource_identifier,
                domains: self.domains,
            }
        }
    }
}
impl StorageConnector {
    /// Creates a new builder-style object to manufacture [`StorageConnector`](crate::model::StorageConnector)
    pub fn builder() -> crate::model::storage_connector::Builder {
        crate::model::storage_connector::Builder::default()
    }
}

/// <p>The type of storage connector.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageConnectorType {
    #[allow(missing_docs)] // documentation missing in model
    GoogleDrive,
    #[allow(missing_docs)] // documentation missing in model
    Homefolders,
    #[allow(missing_docs)] // documentation missing in model
    OneDrive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageConnectorType {
    fn from(s: &str) -> Self {
        match s {
            "GOOGLE_DRIVE" => StorageConnectorType::GoogleDrive,
            "HOMEFOLDERS" => StorageConnectorType::Homefolders,
            "ONE_DRIVE" => StorageConnectorType::OneDrive,
            other => StorageConnectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageConnectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageConnectorType::from(s))
    }
}
impl StorageConnectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageConnectorType::GoogleDrive => "GOOGLE_DRIVE",
            StorageConnectorType::Homefolders => "HOMEFOLDERS",
            StorageConnectorType::OneDrive => "ONE_DRIVE",
            StorageConnectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GOOGLE_DRIVE", "HOMEFOLDERS", "ONE_DRIVE"]
    }
}
impl AsRef<str> for StorageConnectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The persistent application settings for users of a stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplicationSettings {
    /// <p>Enables or disables persistent application settings for users during their streaming sessions. </p>
    pub enabled: bool,
    /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same persistent application settings to be used across multiple stacks by specifying the same settings group for each stack. </p>
    pub settings_group: std::option::Option<std::string::String>,
}
impl ApplicationSettings {
    /// <p>Enables or disables persistent application settings for users during their streaming sessions. </p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same persistent application settings to be used across multiple stacks by specifying the same settings group for each stack. </p>
    pub fn settings_group(&self) -> std::option::Option<&str> {
        self.settings_group.as_deref()
    }
}
impl std::fmt::Debug for ApplicationSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplicationSettings");
        formatter.field("enabled", &self.enabled);
        formatter.field("settings_group", &self.settings_group);
        formatter.finish()
    }
}
/// See [`ApplicationSettings`](crate::model::ApplicationSettings)
pub mod application_settings {
    /// A builder for [`ApplicationSettings`](crate::model::ApplicationSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) settings_group: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Enables or disables persistent application settings for users during their streaming sessions. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Enables or disables persistent application settings for users during their streaming sessions. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same persistent application settings to be used across multiple stacks by specifying the same settings group for each stack. </p>
        pub fn settings_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.settings_group = Some(input.into());
            self
        }
        /// <p>The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same persistent application settings to be used across multiple stacks by specifying the same settings group for each stack. </p>
        pub fn set_settings_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.settings_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplicationSettings`](crate::model::ApplicationSettings)
        pub fn build(self) -> crate::model::ApplicationSettings {
            crate::model::ApplicationSettings {
                enabled: self.enabled.unwrap_or_default(),
                settings_group: self.settings_group,
            }
        }
    }
}
impl ApplicationSettings {
    /// Creates a new builder-style object to manufacture [`ApplicationSettings`](crate::model::ApplicationSettings)
    pub fn builder() -> crate::model::application_settings::Builder {
        crate::model::application_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StackAttribute {
    #[allow(missing_docs)] // documentation missing in model
    AccessEndpoints,
    #[allow(missing_docs)] // documentation missing in model
    EmbedHostDomains,
    #[allow(missing_docs)] // documentation missing in model
    FeedbackUrl,
    #[allow(missing_docs)] // documentation missing in model
    IamRoleArn,
    #[allow(missing_docs)] // documentation missing in model
    RedirectUrl,
    #[allow(missing_docs)] // documentation missing in model
    StorageConnectors,
    #[allow(missing_docs)] // documentation missing in model
    StorageConnectorGoogleDrive,
    #[allow(missing_docs)] // documentation missing in model
    StorageConnectorHomefolders,
    #[allow(missing_docs)] // documentation missing in model
    StorageConnectorOneDrive,
    #[allow(missing_docs)] // documentation missing in model
    ThemeName,
    #[allow(missing_docs)] // documentation missing in model
    UserSettings,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StackAttribute {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_ENDPOINTS" => StackAttribute::AccessEndpoints,
            "EMBED_HOST_DOMAINS" => StackAttribute::EmbedHostDomains,
            "FEEDBACK_URL" => StackAttribute::FeedbackUrl,
            "IAM_ROLE_ARN" => StackAttribute::IamRoleArn,
            "REDIRECT_URL" => StackAttribute::RedirectUrl,
            "STORAGE_CONNECTORS" => StackAttribute::StorageConnectors,
            "STORAGE_CONNECTOR_GOOGLE_DRIVE" => StackAttribute::StorageConnectorGoogleDrive,
            "STORAGE_CONNECTOR_HOMEFOLDERS" => StackAttribute::StorageConnectorHomefolders,
            "STORAGE_CONNECTOR_ONE_DRIVE" => StackAttribute::StorageConnectorOneDrive,
            "THEME_NAME" => StackAttribute::ThemeName,
            "USER_SETTINGS" => StackAttribute::UserSettings,
            other => StackAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StackAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StackAttribute::from(s))
    }
}
impl StackAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StackAttribute::AccessEndpoints => "ACCESS_ENDPOINTS",
            StackAttribute::EmbedHostDomains => "EMBED_HOST_DOMAINS",
            StackAttribute::FeedbackUrl => "FEEDBACK_URL",
            StackAttribute::IamRoleArn => "IAM_ROLE_ARN",
            StackAttribute::RedirectUrl => "REDIRECT_URL",
            StackAttribute::StorageConnectors => "STORAGE_CONNECTORS",
            StackAttribute::StorageConnectorGoogleDrive => "STORAGE_CONNECTOR_GOOGLE_DRIVE",
            StackAttribute::StorageConnectorHomefolders => "STORAGE_CONNECTOR_HOMEFOLDERS",
            StackAttribute::StorageConnectorOneDrive => "STORAGE_CONNECTOR_ONE_DRIVE",
            StackAttribute::ThemeName => "THEME_NAME",
            StackAttribute::UserSettings => "USER_SETTINGS",
            StackAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_ENDPOINTS",
            "EMBED_HOST_DOMAINS",
            "FEEDBACK_URL",
            "IAM_ROLE_ARN",
            "REDIRECT_URL",
            "STORAGE_CONNECTORS",
            "STORAGE_CONNECTOR_GOOGLE_DRIVE",
            "STORAGE_CONNECTOR_HOMEFOLDERS",
            "STORAGE_CONNECTOR_ONE_DRIVE",
            "THEME_NAME",
            "USER_SETTINGS",
        ]
    }
}
impl AsRef<str> for StackAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the permissions for an image. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImagePermissions {
    /// <p>Indicates whether the image can be used for a fleet.</p>
    pub allow_fleet: std::option::Option<bool>,
    /// <p>Indicates whether the image can be used for an image builder.</p>
    pub allow_image_builder: std::option::Option<bool>,
}
impl ImagePermissions {
    /// <p>Indicates whether the image can be used for a fleet.</p>
    pub fn allow_fleet(&self) -> std::option::Option<bool> {
        self.allow_fleet
    }
    /// <p>Indicates whether the image can be used for an image builder.</p>
    pub fn allow_image_builder(&self) -> std::option::Option<bool> {
        self.allow_image_builder
    }
}
impl std::fmt::Debug for ImagePermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImagePermissions");
        formatter.field("allow_fleet", &self.allow_fleet);
        formatter.field("allow_image_builder", &self.allow_image_builder);
        formatter.finish()
    }
}
/// See [`ImagePermissions`](crate::model::ImagePermissions)
pub mod image_permissions {
    /// A builder for [`ImagePermissions`](crate::model::ImagePermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allow_fleet: std::option::Option<bool>,
        pub(crate) allow_image_builder: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether the image can be used for a fleet.</p>
        pub fn allow_fleet(mut self, input: bool) -> Self {
            self.allow_fleet = Some(input);
            self
        }
        /// <p>Indicates whether the image can be used for a fleet.</p>
        pub fn set_allow_fleet(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_fleet = input;
            self
        }
        /// <p>Indicates whether the image can be used for an image builder.</p>
        pub fn allow_image_builder(mut self, input: bool) -> Self {
            self.allow_image_builder = Some(input);
            self
        }
        /// <p>Indicates whether the image can be used for an image builder.</p>
        pub fn set_allow_image_builder(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_image_builder = input;
            self
        }
        /// Consumes the builder and constructs a [`ImagePermissions`](crate::model::ImagePermissions)
        pub fn build(self) -> crate::model::ImagePermissions {
            crate::model::ImagePermissions {
                allow_fleet: self.allow_fleet,
                allow_image_builder: self.allow_image_builder,
            }
        }
    }
}
impl ImagePermissions {
    /// Creates a new builder-style object to manufacture [`ImagePermissions`](crate::model::ImagePermissions)
    pub fn builder() -> crate::model::image_permissions::Builder {
        crate::model::image_permissions::Builder::default()
    }
}

/// <p>Describes a fleet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Fleet {
    /// <p>The Amazon Resource Name (ARN) for the fleet.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the fleet.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The fleet name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the image used to create the fleet.</p>
    pub image_name: std::option::Option<std::string::String>,
    /// <p>The ARN for the public, private, or shared image.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>    
    /// <ul>
    /// <li>
    /// <p>stream.standard.small</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.medium</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.3xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.6xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.large</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-desktop.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.16xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.16xlarge</p>
    /// </li>
    /// </ul>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The fleet type.</p>
    /// <dl>
    /// <dt>ALWAYS_ON</dt>
    /// <dd>
    /// <p>Provides users with instant-on access to their apps.
    /// You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
    /// </dd>
    /// <dt>ON_DEMAND</dt>
    /// <dd>
    /// <p>Provide users with access to applications after they connect, which takes one to two minutes.
    /// You are charged for instance streaming when users are connected and a
    /// small hourly fee for instances that are not streaming apps.</p>
    /// </dd>
    /// </dl>
    pub fleet_type: std::option::Option<crate::model::FleetType>,
    /// <p>The capacity status for the fleet.</p>
    pub compute_capacity_status: std::option::Option<crate::model::ComputeCapacityStatus>,
    /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance. </p>
    /// <p>Specify a value between 600 and 360000.</p>
    pub max_user_duration_in_seconds: std::option::Option<i32>,
    /// <p>The amount of time that a streaming session remains active after users disconnect. If they try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.</p>
    /// <p>Specify a value between 60 and 360000.</p>
    pub disconnect_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The current state for the fleet.</p>
    pub state: std::option::Option<crate::model::FleetState>,
    /// <p>The VPC configuration for the fleet.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>The time the fleet was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The fleet errors.</p>
    pub fleet_errors: std::option::Option<std::vec::Vec<crate::model::FleetError>>,
    /// <p>Indicates whether default internet access is enabled for the fleet.</p>
    pub enable_default_internet_access: std::option::Option<bool>,
    /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
    pub domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
    /// <p>The amount of time that users can be idle (inactive) before they are disconnected
    /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
    /// interval begins. Users are notified before they are disconnected due to inactivity. If
    /// users try to reconnect to the streaming session before the time interval specified in
    /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
    /// previous session. Users are considered idle when they stop providing keyboard or mouse
    /// input during their streaming session. File uploads and downloads, audio in, audio out,
    /// and pixels changing do not qualify as user activity. If users continue to be idle after
    /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
    /// disconnected.</p>
    /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
    ///
    /// <note>
    /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
    /// </note>
    pub idle_disconnect_timeout_in_seconds: std::option::Option<i32>,
    /// <p>The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
    ///
    /// <p>The default value is <code>APP</code>.</p>
    pub stream_view: std::option::Option<crate::model::StreamView>,
}
impl Fleet {
    /// <p>The Amazon Resource Name (ARN) for the fleet.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the fleet.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The fleet name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the image used to create the fleet.</p>
    pub fn image_name(&self) -> std::option::Option<&str> {
        self.image_name.as_deref()
    }
    /// <p>The ARN for the public, private, or shared image.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>    
    /// <ul>
    /// <li>
    /// <p>stream.standard.small</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.medium</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.3xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.6xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.large</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-desktop.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.16xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.16xlarge</p>
    /// </li>
    /// </ul>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The fleet type.</p>
    /// <dl>
    /// <dt>ALWAYS_ON</dt>
    /// <dd>
    /// <p>Provides users with instant-on access to their apps.
    /// You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
    /// </dd>
    /// <dt>ON_DEMAND</dt>
    /// <dd>
    /// <p>Provide users with access to applications after they connect, which takes one to two minutes.
    /// You are charged for instance streaming when users are connected and a
    /// small hourly fee for instances that are not streaming apps.</p>
    /// </dd>
    /// </dl>
    pub fn fleet_type(&self) -> std::option::Option<&crate::model::FleetType> {
        self.fleet_type.as_ref()
    }
    /// <p>The capacity status for the fleet.</p>
    pub fn compute_capacity_status(
        &self,
    ) -> std::option::Option<&crate::model::ComputeCapacityStatus> {
        self.compute_capacity_status.as_ref()
    }
    /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance. </p>
    /// <p>Specify a value between 600 and 360000.</p>
    pub fn max_user_duration_in_seconds(&self) -> std::option::Option<i32> {
        self.max_user_duration_in_seconds
    }
    /// <p>The amount of time that a streaming session remains active after users disconnect. If they try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.</p>
    /// <p>Specify a value between 60 and 360000.</p>
    pub fn disconnect_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.disconnect_timeout_in_seconds
    }
    /// <p>The current state for the fleet.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::FleetState> {
        self.state.as_ref()
    }
    /// <p>The VPC configuration for the fleet.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>The time the fleet was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The fleet errors.</p>
    pub fn fleet_errors(&self) -> std::option::Option<&[crate::model::FleetError]> {
        self.fleet_errors.as_deref()
    }
    /// <p>Indicates whether default internet access is enabled for the fleet.</p>
    pub fn enable_default_internet_access(&self) -> std::option::Option<bool> {
        self.enable_default_internet_access
    }
    /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
    pub fn domain_join_info(&self) -> std::option::Option<&crate::model::DomainJoinInfo> {
        self.domain_join_info.as_ref()
    }
    /// <p>The amount of time that users can be idle (inactive) before they are disconnected
    /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
    /// interval begins. Users are notified before they are disconnected due to inactivity. If
    /// users try to reconnect to the streaming session before the time interval specified in
    /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
    /// previous session. Users are considered idle when they stop providing keyboard or mouse
    /// input during their streaming session. File uploads and downloads, audio in, audio out,
    /// and pixels changing do not qualify as user activity. If users continue to be idle after
    /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
    /// disconnected.</p>
    /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
    ///
    /// <note>
    /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
    /// </note>
    pub fn idle_disconnect_timeout_in_seconds(&self) -> std::option::Option<i32> {
        self.idle_disconnect_timeout_in_seconds
    }
    /// <p>The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
    ///
    /// <p>The default value is <code>APP</code>.</p>
    pub fn stream_view(&self) -> std::option::Option<&crate::model::StreamView> {
        self.stream_view.as_ref()
    }
}
impl std::fmt::Debug for Fleet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Fleet");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("description", &self.description);
        formatter.field("image_name", &self.image_name);
        formatter.field("image_arn", &self.image_arn);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("fleet_type", &self.fleet_type);
        formatter.field("compute_capacity_status", &self.compute_capacity_status);
        formatter.field(
            "max_user_duration_in_seconds",
            &self.max_user_duration_in_seconds,
        );
        formatter.field(
            "disconnect_timeout_in_seconds",
            &self.disconnect_timeout_in_seconds,
        );
        formatter.field("state", &self.state);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("created_time", &self.created_time);
        formatter.field("fleet_errors", &self.fleet_errors);
        formatter.field(
            "enable_default_internet_access",
            &self.enable_default_internet_access,
        );
        formatter.field("domain_join_info", &self.domain_join_info);
        formatter.field(
            "idle_disconnect_timeout_in_seconds",
            &self.idle_disconnect_timeout_in_seconds,
        );
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("stream_view", &self.stream_view);
        formatter.finish()
    }
}
/// See [`Fleet`](crate::model::Fleet)
pub mod fleet {
    /// A builder for [`Fleet`](crate::model::Fleet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) image_name: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) fleet_type: std::option::Option<crate::model::FleetType>,
        pub(crate) compute_capacity_status:
            std::option::Option<crate::model::ComputeCapacityStatus>,
        pub(crate) max_user_duration_in_seconds: std::option::Option<i32>,
        pub(crate) disconnect_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::FleetState>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) fleet_errors: std::option::Option<std::vec::Vec<crate::model::FleetError>>,
        pub(crate) enable_default_internet_access: std::option::Option<bool>,
        pub(crate) domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
        pub(crate) idle_disconnect_timeout_in_seconds: std::option::Option<i32>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) stream_view: std::option::Option<crate::model::StreamView>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the fleet.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the fleet.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_name = Some(input.into());
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_name = input;
            self
        }
        /// <p>The ARN for the public, private, or shared image.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the public, private, or shared image.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>    
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>    
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>ALWAYS_ON</dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps.
        /// You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>ON_DEMAND</dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes.
        /// You are charged for instance streaming when users are connected and a
        /// small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn fleet_type(mut self, input: crate::model::FleetType) -> Self {
            self.fleet_type = Some(input);
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>ALWAYS_ON</dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps.
        /// You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>ON_DEMAND</dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes.
        /// You are charged for instance streaming when users are connected and a
        /// small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn set_fleet_type(
            mut self,
            input: std::option::Option<crate::model::FleetType>,
        ) -> Self {
            self.fleet_type = input;
            self
        }
        /// <p>The capacity status for the fleet.</p>
        pub fn compute_capacity_status(
            mut self,
            input: crate::model::ComputeCapacityStatus,
        ) -> Self {
            self.compute_capacity_status = Some(input);
            self
        }
        /// <p>The capacity status for the fleet.</p>
        pub fn set_compute_capacity_status(
            mut self,
            input: std::option::Option<crate::model::ComputeCapacityStatus>,
        ) -> Self {
            self.compute_capacity_status = input;
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance. </p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn max_user_duration_in_seconds(mut self, input: i32) -> Self {
            self.max_user_duration_in_seconds = Some(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance. </p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn set_max_user_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.max_user_duration_in_seconds = input;
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If they try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.</p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.disconnect_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If they try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance.</p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn set_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.disconnect_timeout_in_seconds = input;
            self
        }
        /// <p>The current state for the fleet.</p>
        pub fn state(mut self, input: crate::model::FleetState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state for the fleet.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::FleetState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The VPC configuration for the fleet.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration for the fleet.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The time the fleet was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time the fleet was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Appends an item to `fleet_errors`.
        ///
        /// To override the contents of this collection use [`set_fleet_errors`](Self::set_fleet_errors).
        ///
        /// <p>The fleet errors.</p>
        pub fn fleet_errors(mut self, input: impl Into<crate::model::FleetError>) -> Self {
            let mut v = self.fleet_errors.unwrap_or_default();
            v.push(input.into());
            self.fleet_errors = Some(v);
            self
        }
        /// <p>The fleet errors.</p>
        pub fn set_fleet_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetError>>,
        ) -> Self {
            self.fleet_errors = input;
            self
        }
        /// <p>Indicates whether default internet access is enabled for the fleet.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.enable_default_internet_access = Some(input);
            self
        }
        /// <p>Indicates whether default internet access is enabled for the fleet.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_default_internet_access = input;
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.domain_join_info = Some(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.domain_join_info = input;
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected
        /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
        /// interval begins. Users are notified before they are disconnected due to inactivity. If
        /// users try to reconnect to the streaming session before the time interval specified in
        /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
        /// previous session. Users are considered idle when they stop providing keyboard or mouse
        /// input during their streaming session. File uploads and downloads, audio in, audio out,
        /// and pixels changing do not qualify as user activity. If users continue to be idle after
        /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
        /// disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
        ///
        /// <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn idle_disconnect_timeout_in_seconds(mut self, input: i32) -> Self {
            self.idle_disconnect_timeout_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected
        /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
        /// interval begins. Users are notified before they are disconnected due to inactivity. If
        /// users try to reconnect to the streaming session before the time interval specified in
        /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
        /// previous session. Users are considered idle when they stop providing keyboard or mouse
        /// input during their streaming session. File uploads and downloads, audio in, audio out,
        /// and pixels changing do not qualify as user activity. If users continue to be idle after
        /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
        /// disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
        ///
        /// <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn set_idle_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.idle_disconnect_timeout_in_seconds = input;
            self
        }
        /// <p>The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        ///
        /// <p>The default value is <code>APP</code>.</p>
        pub fn stream_view(mut self, input: crate::model::StreamView) -> Self {
            self.stream_view = Some(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        ///
        /// <p>The default value is <code>APP</code>.</p>
        pub fn set_stream_view(
            mut self,
            input: std::option::Option<crate::model::StreamView>,
        ) -> Self {
            self.stream_view = input;
            self
        }
        /// Consumes the builder and constructs a [`Fleet`](crate::model::Fleet)
        pub fn build(self) -> crate::model::Fleet {
            crate::model::Fleet {
                arn: self.arn,
                name: self.name,
                display_name: self.display_name,
                description: self.description,
                image_name: self.image_name,
                image_arn: self.image_arn,
                instance_type: self.instance_type,
                fleet_type: self.fleet_type,
                compute_capacity_status: self.compute_capacity_status,
                max_user_duration_in_seconds: self.max_user_duration_in_seconds,
                disconnect_timeout_in_seconds: self.disconnect_timeout_in_seconds,
                state: self.state,
                vpc_config: self.vpc_config,
                created_time: self.created_time,
                fleet_errors: self.fleet_errors,
                enable_default_internet_access: self.enable_default_internet_access,
                domain_join_info: self.domain_join_info,
                idle_disconnect_timeout_in_seconds: self.idle_disconnect_timeout_in_seconds,
                iam_role_arn: self.iam_role_arn,
                stream_view: self.stream_view,
            }
        }
    }
}
impl Fleet {
    /// Creates a new builder-style object to manufacture [`Fleet`](crate::model::Fleet)
    pub fn builder() -> crate::model::fleet::Builder {
        crate::model::fleet::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StreamView {
    #[allow(missing_docs)] // documentation missing in model
    App,
    #[allow(missing_docs)] // documentation missing in model
    Desktop,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StreamView {
    fn from(s: &str) -> Self {
        match s {
            "APP" => StreamView::App,
            "DESKTOP" => StreamView::Desktop,
            other => StreamView::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StreamView {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StreamView::from(s))
    }
}
impl StreamView {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StreamView::App => "APP",
            StreamView::Desktop => "DESKTOP",
            StreamView::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APP", "DESKTOP"]
    }
}
impl AsRef<str> for StreamView {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainJoinInfo {
    /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
    pub directory_name: std::option::Option<std::string::String>,
    /// <p>The distinguished name of the organizational unit for computer accounts.</p>
    pub organizational_unit_distinguished_name: std::option::Option<std::string::String>,
}
impl DomainJoinInfo {
    /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
    pub fn directory_name(&self) -> std::option::Option<&str> {
        self.directory_name.as_deref()
    }
    /// <p>The distinguished name of the organizational unit for computer accounts.</p>
    pub fn organizational_unit_distinguished_name(&self) -> std::option::Option<&str> {
        self.organizational_unit_distinguished_name.as_deref()
    }
}
impl std::fmt::Debug for DomainJoinInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainJoinInfo");
        formatter.field("directory_name", &self.directory_name);
        formatter.field(
            "organizational_unit_distinguished_name",
            &self.organizational_unit_distinguished_name,
        );
        formatter.finish()
    }
}
/// See [`DomainJoinInfo`](crate::model::DomainJoinInfo)
pub mod domain_join_info {
    /// A builder for [`DomainJoinInfo`](crate::model::DomainJoinInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_name: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_name = Some(input.into());
            self
        }
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// <p>The distinguished name of the organizational unit for computer accounts.</p>
        pub fn organizational_unit_distinguished_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = Some(input.into());
            self
        }
        /// <p>The distinguished name of the organizational unit for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.organizational_unit_distinguished_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainJoinInfo`](crate::model::DomainJoinInfo)
        pub fn build(self) -> crate::model::DomainJoinInfo {
            crate::model::DomainJoinInfo {
                directory_name: self.directory_name,
                organizational_unit_distinguished_name: self.organizational_unit_distinguished_name,
            }
        }
    }
}
impl DomainJoinInfo {
    /// Creates a new builder-style object to manufacture [`DomainJoinInfo`](crate::model::DomainJoinInfo)
    pub fn builder() -> crate::model::domain_join_info::Builder {
        crate::model::domain_join_info::Builder::default()
    }
}

/// <p>Describes a fleet error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FleetError {
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::FleetErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FleetError {
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::FleetErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FleetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FleetError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FleetError`](crate::model::FleetError)
pub mod fleet_error {
    /// A builder for [`FleetError`](crate::model::FleetError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::FleetErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::FleetErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::FleetErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FleetError`](crate::model::FleetError)
        pub fn build(self) -> crate::model::FleetError {
            crate::model::FleetError {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl FleetError {
    /// Creates a new builder-style object to manufacture [`FleetError`](crate::model::FleetError)
    pub fn builder() -> crate::model::fleet_error::Builder {
        crate::model::fleet_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorAccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorDsMachineAccountQuotaExceeded,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorFileNotFound,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorInvalidParameter,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorLogonFailure,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorMoreData,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorNotSupported,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinErrorNoSuchDomain,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinInternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinNerrInvalidWorkgroupName,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinNerrPasswordExpired,
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinNerrWorkstationNotStarted,
    #[allow(missing_docs)] // documentation missing in model
    FleetInstanceProvisioningFailure,
    #[allow(missing_docs)] // documentation missing in model
    FleetStopped,
    #[allow(missing_docs)] // documentation missing in model
    IamServiceRoleIsMissing,
    #[allow(missing_docs)] // documentation missing in model
    IamServiceRoleMissingDescribeSecurityGroupsAction,
    #[allow(missing_docs)] // documentation missing in model
    IamServiceRoleMissingDescribeSubnetAction,
    #[allow(missing_docs)] // documentation missing in model
    IamServiceRoleMissingEniCreateAction,
    #[allow(missing_docs)] // documentation missing in model
    IamServiceRoleMissingEniDeleteAction,
    #[allow(missing_docs)] // documentation missing in model
    IamServiceRoleMissingEniDescribeAction,
    #[allow(missing_docs)] // documentation missing in model
    IgwNotAttached,
    #[allow(missing_docs)] // documentation missing in model
    ImageNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    InvalidSubnetConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    MachineRoleIsMissing,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterfaceLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    SecurityGroupsNotFound,
    #[allow(missing_docs)] // documentation missing in model
    StsDisabledInRegion,
    #[allow(missing_docs)] // documentation missing in model
    SubnetHasInsufficientIpAddresses,
    #[allow(missing_docs)] // documentation missing in model
    SubnetNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "DOMAIN_JOIN_ERROR_ACCESS_DENIED" => FleetErrorCode::DomainJoinErrorAccessDenied,
            "DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED" => {
                FleetErrorCode::DomainJoinErrorDsMachineAccountQuotaExceeded
            }
            "DOMAIN_JOIN_ERROR_FILE_NOT_FOUND" => FleetErrorCode::DomainJoinErrorFileNotFound,
            "DOMAIN_JOIN_ERROR_INVALID_PARAMETER" => {
                FleetErrorCode::DomainJoinErrorInvalidParameter
            }
            "DOMAIN_JOIN_ERROR_LOGON_FAILURE" => FleetErrorCode::DomainJoinErrorLogonFailure,
            "DOMAIN_JOIN_ERROR_MORE_DATA" => FleetErrorCode::DomainJoinErrorMoreData,
            "DOMAIN_JOIN_ERROR_NOT_SUPPORTED" => FleetErrorCode::DomainJoinErrorNotSupported,
            "DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN" => FleetErrorCode::DomainJoinErrorNoSuchDomain,
            "DOMAIN_JOIN_INTERNAL_SERVICE_ERROR" => FleetErrorCode::DomainJoinInternalServiceError,
            "DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME" => {
                FleetErrorCode::DomainJoinNerrInvalidWorkgroupName
            }
            "DOMAIN_JOIN_NERR_PASSWORD_EXPIRED" => FleetErrorCode::DomainJoinNerrPasswordExpired,
            "DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED" => {
                FleetErrorCode::DomainJoinNerrWorkstationNotStarted
            }
            "FLEET_INSTANCE_PROVISIONING_FAILURE" => {
                FleetErrorCode::FleetInstanceProvisioningFailure
            }
            "FLEET_STOPPED" => FleetErrorCode::FleetStopped,
            "IAM_SERVICE_ROLE_IS_MISSING" => FleetErrorCode::IamServiceRoleIsMissing,
            "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION" => {
                FleetErrorCode::IamServiceRoleMissingDescribeSecurityGroupsAction
            }
            "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION" => {
                FleetErrorCode::IamServiceRoleMissingDescribeSubnetAction
            }
            "IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION" => {
                FleetErrorCode::IamServiceRoleMissingEniCreateAction
            }
            "IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION" => {
                FleetErrorCode::IamServiceRoleMissingEniDeleteAction
            }
            "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION" => {
                FleetErrorCode::IamServiceRoleMissingEniDescribeAction
            }
            "IGW_NOT_ATTACHED" => FleetErrorCode::IgwNotAttached,
            "IMAGE_NOT_FOUND" => FleetErrorCode::ImageNotFound,
            "INTERNAL_SERVICE_ERROR" => FleetErrorCode::InternalServiceError,
            "INVALID_SUBNET_CONFIGURATION" => FleetErrorCode::InvalidSubnetConfiguration,
            "MACHINE_ROLE_IS_MISSING" => FleetErrorCode::MachineRoleIsMissing,
            "NETWORK_INTERFACE_LIMIT_EXCEEDED" => FleetErrorCode::NetworkInterfaceLimitExceeded,
            "SECURITY_GROUPS_NOT_FOUND" => FleetErrorCode::SecurityGroupsNotFound,
            "STS_DISABLED_IN_REGION" => FleetErrorCode::StsDisabledInRegion,
            "SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES" => {
                FleetErrorCode::SubnetHasInsufficientIpAddresses
            }
            "SUBNET_NOT_FOUND" => FleetErrorCode::SubnetNotFound,
            other => FleetErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetErrorCode::from(s))
    }
}
impl FleetErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetErrorCode::DomainJoinErrorAccessDenied => "DOMAIN_JOIN_ERROR_ACCESS_DENIED",
            FleetErrorCode::DomainJoinErrorDsMachineAccountQuotaExceeded => {
                "DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"
            }
            FleetErrorCode::DomainJoinErrorFileNotFound => "DOMAIN_JOIN_ERROR_FILE_NOT_FOUND",
            FleetErrorCode::DomainJoinErrorInvalidParameter => {
                "DOMAIN_JOIN_ERROR_INVALID_PARAMETER"
            }
            FleetErrorCode::DomainJoinErrorLogonFailure => "DOMAIN_JOIN_ERROR_LOGON_FAILURE",
            FleetErrorCode::DomainJoinErrorMoreData => "DOMAIN_JOIN_ERROR_MORE_DATA",
            FleetErrorCode::DomainJoinErrorNotSupported => "DOMAIN_JOIN_ERROR_NOT_SUPPORTED",
            FleetErrorCode::DomainJoinErrorNoSuchDomain => "DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN",
            FleetErrorCode::DomainJoinInternalServiceError => "DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
            FleetErrorCode::DomainJoinNerrInvalidWorkgroupName => {
                "DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"
            }
            FleetErrorCode::DomainJoinNerrPasswordExpired => "DOMAIN_JOIN_NERR_PASSWORD_EXPIRED",
            FleetErrorCode::DomainJoinNerrWorkstationNotStarted => {
                "DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"
            }
            FleetErrorCode::FleetInstanceProvisioningFailure => {
                "FLEET_INSTANCE_PROVISIONING_FAILURE"
            }
            FleetErrorCode::FleetStopped => "FLEET_STOPPED",
            FleetErrorCode::IamServiceRoleIsMissing => "IAM_SERVICE_ROLE_IS_MISSING",
            FleetErrorCode::IamServiceRoleMissingDescribeSecurityGroupsAction => {
                "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"
            }
            FleetErrorCode::IamServiceRoleMissingDescribeSubnetAction => {
                "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"
            }
            FleetErrorCode::IamServiceRoleMissingEniCreateAction => {
                "IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"
            }
            FleetErrorCode::IamServiceRoleMissingEniDeleteAction => {
                "IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"
            }
            FleetErrorCode::IamServiceRoleMissingEniDescribeAction => {
                "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"
            }
            FleetErrorCode::IgwNotAttached => "IGW_NOT_ATTACHED",
            FleetErrorCode::ImageNotFound => "IMAGE_NOT_FOUND",
            FleetErrorCode::InternalServiceError => "INTERNAL_SERVICE_ERROR",
            FleetErrorCode::InvalidSubnetConfiguration => "INVALID_SUBNET_CONFIGURATION",
            FleetErrorCode::MachineRoleIsMissing => "MACHINE_ROLE_IS_MISSING",
            FleetErrorCode::NetworkInterfaceLimitExceeded => "NETWORK_INTERFACE_LIMIT_EXCEEDED",
            FleetErrorCode::SecurityGroupsNotFound => "SECURITY_GROUPS_NOT_FOUND",
            FleetErrorCode::StsDisabledInRegion => "STS_DISABLED_IN_REGION",
            FleetErrorCode::SubnetHasInsufficientIpAddresses => {
                "SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"
            }
            FleetErrorCode::SubnetNotFound => "SUBNET_NOT_FOUND",
            FleetErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DOMAIN_JOIN_ERROR_ACCESS_DENIED",
            "DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED",
            "DOMAIN_JOIN_ERROR_FILE_NOT_FOUND",
            "DOMAIN_JOIN_ERROR_INVALID_PARAMETER",
            "DOMAIN_JOIN_ERROR_LOGON_FAILURE",
            "DOMAIN_JOIN_ERROR_MORE_DATA",
            "DOMAIN_JOIN_ERROR_NOT_SUPPORTED",
            "DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN",
            "DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
            "DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME",
            "DOMAIN_JOIN_NERR_PASSWORD_EXPIRED",
            "DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED",
            "FLEET_INSTANCE_PROVISIONING_FAILURE",
            "FLEET_STOPPED",
            "IAM_SERVICE_ROLE_IS_MISSING",
            "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION",
            "IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION",
            "IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION",
            "IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION",
            "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION",
            "IGW_NOT_ATTACHED",
            "IMAGE_NOT_FOUND",
            "INTERNAL_SERVICE_ERROR",
            "INVALID_SUBNET_CONFIGURATION",
            "MACHINE_ROLE_IS_MISSING",
            "NETWORK_INTERFACE_LIMIT_EXCEEDED",
            "SECURITY_GROUPS_NOT_FOUND",
            "STS_DISABLED_IN_REGION",
            "SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES",
            "SUBNET_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for FleetErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes VPC configuration information for fleets and image builders.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfig {
    /// <p>The identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance. Fleet instances use one or more subnets. Image builder instances use one subnet.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifiers of the security groups for the fleet or image builder.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfig {
    /// <p>The identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance. Fleet instances use one or more subnets. Image builder instances use one subnet.</p>
    pub fn subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_ids.as_deref()
    }
    /// <p>The identifiers of the security groups for the fleet or image builder.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfig");
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcConfig`](crate::model::VpcConfig)
pub mod vpc_config {
    /// A builder for [`VpcConfig`](crate::model::VpcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance. Fleet instances use one or more subnets. Image builder instances use one subnet.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance. Fleet instances use one or more subnets. Image builder instances use one subnet.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>The identifiers of the security groups for the fleet or image builder.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>The identifiers of the security groups for the fleet or image builder.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfig`](crate::model::VpcConfig)
        pub fn build(self) -> crate::model::VpcConfig {
            crate::model::VpcConfig {
                subnet_ids: self.subnet_ids,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcConfig {
    /// Creates a new builder-style object to manufacture [`VpcConfig`](crate::model::VpcConfig)
    pub fn builder() -> crate::model::vpc_config::Builder {
        crate::model::vpc_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetState {
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetState {
    fn from(s: &str) -> Self {
        match s {
            "RUNNING" => FleetState::Running,
            "STARTING" => FleetState::Starting,
            "STOPPED" => FleetState::Stopped,
            "STOPPING" => FleetState::Stopping,
            other => FleetState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetState::from(s))
    }
}
impl FleetState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetState::Running => "RUNNING",
            FleetState::Starting => "STARTING",
            FleetState::Stopped => "STOPPED",
            FleetState::Stopping => "STOPPING",
            FleetState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RUNNING", "STARTING", "STOPPED", "STOPPING"]
    }
}
impl AsRef<str> for FleetState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the capacity status for a fleet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComputeCapacityStatus {
    /// <p>The desired number of streaming instances.</p>
    pub desired: std::option::Option<i32>,
    /// <p>The total number of simultaneous streaming instances that are running.</p>
    pub running: std::option::Option<i32>,
    /// <p>The number of instances in use for streaming.</p>
    pub in_use: std::option::Option<i32>,
    /// <p>The number of currently available instances that can be used to stream
    /// sessions.</p>
    pub available: std::option::Option<i32>,
}
impl ComputeCapacityStatus {
    /// <p>The desired number of streaming instances.</p>
    pub fn desired(&self) -> std::option::Option<i32> {
        self.desired
    }
    /// <p>The total number of simultaneous streaming instances that are running.</p>
    pub fn running(&self) -> std::option::Option<i32> {
        self.running
    }
    /// <p>The number of instances in use for streaming.</p>
    pub fn in_use(&self) -> std::option::Option<i32> {
        self.in_use
    }
    /// <p>The number of currently available instances that can be used to stream
    /// sessions.</p>
    pub fn available(&self) -> std::option::Option<i32> {
        self.available
    }
}
impl std::fmt::Debug for ComputeCapacityStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComputeCapacityStatus");
        formatter.field("desired", &self.desired);
        formatter.field("running", &self.running);
        formatter.field("in_use", &self.in_use);
        formatter.field("available", &self.available);
        formatter.finish()
    }
}
/// See [`ComputeCapacityStatus`](crate::model::ComputeCapacityStatus)
pub mod compute_capacity_status {
    /// A builder for [`ComputeCapacityStatus`](crate::model::ComputeCapacityStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) desired: std::option::Option<i32>,
        pub(crate) running: std::option::Option<i32>,
        pub(crate) in_use: std::option::Option<i32>,
        pub(crate) available: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The desired number of streaming instances.</p>
        pub fn desired(mut self, input: i32) -> Self {
            self.desired = Some(input);
            self
        }
        /// <p>The desired number of streaming instances.</p>
        pub fn set_desired(mut self, input: std::option::Option<i32>) -> Self {
            self.desired = input;
            self
        }
        /// <p>The total number of simultaneous streaming instances that are running.</p>
        pub fn running(mut self, input: i32) -> Self {
            self.running = Some(input);
            self
        }
        /// <p>The total number of simultaneous streaming instances that are running.</p>
        pub fn set_running(mut self, input: std::option::Option<i32>) -> Self {
            self.running = input;
            self
        }
        /// <p>The number of instances in use for streaming.</p>
        pub fn in_use(mut self, input: i32) -> Self {
            self.in_use = Some(input);
            self
        }
        /// <p>The number of instances in use for streaming.</p>
        pub fn set_in_use(mut self, input: std::option::Option<i32>) -> Self {
            self.in_use = input;
            self
        }
        /// <p>The number of currently available instances that can be used to stream
        /// sessions.</p>
        pub fn available(mut self, input: i32) -> Self {
            self.available = Some(input);
            self
        }
        /// <p>The number of currently available instances that can be used to stream
        /// sessions.</p>
        pub fn set_available(mut self, input: std::option::Option<i32>) -> Self {
            self.available = input;
            self
        }
        /// Consumes the builder and constructs a [`ComputeCapacityStatus`](crate::model::ComputeCapacityStatus)
        pub fn build(self) -> crate::model::ComputeCapacityStatus {
            crate::model::ComputeCapacityStatus {
                desired: self.desired,
                running: self.running,
                in_use: self.in_use,
                available: self.available,
            }
        }
    }
}
impl ComputeCapacityStatus {
    /// Creates a new builder-style object to manufacture [`ComputeCapacityStatus`](crate::model::ComputeCapacityStatus)
    pub fn builder() -> crate::model::compute_capacity_status::Builder {
        crate::model::compute_capacity_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetType {
    #[allow(missing_docs)] // documentation missing in model
    AlwaysOn,
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetType {
    fn from(s: &str) -> Self {
        match s {
            "ALWAYS_ON" => FleetType::AlwaysOn,
            "ON_DEMAND" => FleetType::OnDemand,
            other => FleetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetType::from(s))
    }
}
impl FleetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetType::AlwaysOn => "ALWAYS_ON",
            FleetType::OnDemand => "ON_DEMAND",
            FleetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALWAYS_ON", "ON_DEMAND"]
    }
}
impl AsRef<str> for FleetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The fleet attribute.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FleetAttribute {
    #[allow(missing_docs)] // documentation missing in model
    DomainJoinInfo,
    #[allow(missing_docs)] // documentation missing in model
    IamRoleArn,
    #[allow(missing_docs)] // documentation missing in model
    VpcConfiguration,
    #[allow(missing_docs)] // documentation missing in model
    VpcConfigurationSecurityGroupIds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FleetAttribute {
    fn from(s: &str) -> Self {
        match s {
            "DOMAIN_JOIN_INFO" => FleetAttribute::DomainJoinInfo,
            "IAM_ROLE_ARN" => FleetAttribute::IamRoleArn,
            "VPC_CONFIGURATION" => FleetAttribute::VpcConfiguration,
            "VPC_CONFIGURATION_SECURITY_GROUP_IDS" => {
                FleetAttribute::VpcConfigurationSecurityGroupIds
            }
            other => FleetAttribute::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FleetAttribute {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FleetAttribute::from(s))
    }
}
impl FleetAttribute {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FleetAttribute::DomainJoinInfo => "DOMAIN_JOIN_INFO",
            FleetAttribute::IamRoleArn => "IAM_ROLE_ARN",
            FleetAttribute::VpcConfiguration => "VPC_CONFIGURATION",
            FleetAttribute::VpcConfigurationSecurityGroupIds => {
                "VPC_CONFIGURATION_SECURITY_GROUP_IDS"
            }
            FleetAttribute::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DOMAIN_JOIN_INFO",
            "IAM_ROLE_ARN",
            "VPC_CONFIGURATION",
            "VPC_CONFIGURATION_SECURITY_GROUP_IDS",
        ]
    }
}
impl AsRef<str> for FleetAttribute {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the capacity for a fleet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ComputeCapacity {
    /// <p>The desired number of streaming instances.</p>
    pub desired_instances: std::option::Option<i32>,
}
impl ComputeCapacity {
    /// <p>The desired number of streaming instances.</p>
    pub fn desired_instances(&self) -> std::option::Option<i32> {
        self.desired_instances
    }
}
impl std::fmt::Debug for ComputeCapacity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ComputeCapacity");
        formatter.field("desired_instances", &self.desired_instances);
        formatter.finish()
    }
}
/// See [`ComputeCapacity`](crate::model::ComputeCapacity)
pub mod compute_capacity {
    /// A builder for [`ComputeCapacity`](crate::model::ComputeCapacity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) desired_instances: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The desired number of streaming instances.</p>
        pub fn desired_instances(mut self, input: i32) -> Self {
            self.desired_instances = Some(input);
            self
        }
        /// <p>The desired number of streaming instances.</p>
        pub fn set_desired_instances(mut self, input: std::option::Option<i32>) -> Self {
            self.desired_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`ComputeCapacity`](crate::model::ComputeCapacity)
        pub fn build(self) -> crate::model::ComputeCapacity {
            crate::model::ComputeCapacity {
                desired_instances: self.desired_instances,
            }
        }
    }
}
impl ComputeCapacity {
    /// Creates a new builder-style object to manufacture [`ComputeCapacity`](crate::model::ComputeCapacity)
    pub fn builder() -> crate::model::compute_capacity::Builder {
        crate::model::compute_capacity::Builder::default()
    }
}

/// <p>Describes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DirectoryConfig {
    /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
    pub directory_name: std::option::Option<std::string::String>,
    /// <p>The distinguished names of the organizational units for computer accounts.</p>
    pub organizational_unit_distinguished_names:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    pub service_account_credentials: std::option::Option<crate::model::ServiceAccountCredentials>,
    /// <p>The time the directory configuration was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DirectoryConfig {
    /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
    pub fn directory_name(&self) -> std::option::Option<&str> {
        self.directory_name.as_deref()
    }
    /// <p>The distinguished names of the organizational units for computer accounts.</p>
    pub fn organizational_unit_distinguished_names(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.organizational_unit_distinguished_names.as_deref()
    }
    /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
    pub fn service_account_credentials(
        &self,
    ) -> std::option::Option<&crate::model::ServiceAccountCredentials> {
        self.service_account_credentials.as_ref()
    }
    /// <p>The time the directory configuration was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
}
impl std::fmt::Debug for DirectoryConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DirectoryConfig");
        formatter.field("directory_name", &self.directory_name);
        formatter.field(
            "organizational_unit_distinguished_names",
            &self.organizational_unit_distinguished_names,
        );
        formatter.field(
            "service_account_credentials",
            &self.service_account_credentials,
        );
        formatter.field("created_time", &self.created_time);
        formatter.finish()
    }
}
/// See [`DirectoryConfig`](crate::model::DirectoryConfig)
pub mod directory_config {
    /// A builder for [`DirectoryConfig`](crate::model::DirectoryConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_name: std::option::Option<std::string::String>,
        pub(crate) organizational_unit_distinguished_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) service_account_credentials:
            std::option::Option<crate::model::ServiceAccountCredentials>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn directory_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_name = Some(input.into());
            self
        }
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_name = input;
            self
        }
        /// Appends an item to `organizational_unit_distinguished_names`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_distinguished_names`](Self::set_organizational_unit_distinguished_names).
        ///
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn organizational_unit_distinguished_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .organizational_unit_distinguished_names
                .unwrap_or_default();
            v.push(input.into());
            self.organizational_unit_distinguished_names = Some(v);
            self
        }
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.organizational_unit_distinguished_names = input;
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn service_account_credentials(
            mut self,
            input: crate::model::ServiceAccountCredentials,
        ) -> Self {
            self.service_account_credentials = Some(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn set_service_account_credentials(
            mut self,
            input: std::option::Option<crate::model::ServiceAccountCredentials>,
        ) -> Self {
            self.service_account_credentials = input;
            self
        }
        /// <p>The time the directory configuration was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time the directory configuration was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DirectoryConfig`](crate::model::DirectoryConfig)
        pub fn build(self) -> crate::model::DirectoryConfig {
            crate::model::DirectoryConfig {
                directory_name: self.directory_name,
                organizational_unit_distinguished_names: self
                    .organizational_unit_distinguished_names,
                service_account_credentials: self.service_account_credentials,
                created_time: self.created_time,
            }
        }
    }
}
impl DirectoryConfig {
    /// Creates a new builder-style object to manufacture [`DirectoryConfig`](crate::model::DirectoryConfig)
    pub fn builder() -> crate::model::directory_config::Builder {
        crate::model::directory_config::Builder::default()
    }
}

/// <p>Describes the credentials for the service account used by the fleet or image builder to connect to the directory.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceAccountCredentials {
    /// <p>The user name of the account. This account must have the following privileges: create computer objects,
    /// join computers to the domain, and change/reset the password on descendant computer objects for the
    /// organizational units specified.</p>
    pub account_name: std::option::Option<std::string::String>,
    /// <p>The password for the account.</p>
    pub account_password: std::option::Option<std::string::String>,
}
impl ServiceAccountCredentials {
    /// <p>The user name of the account. This account must have the following privileges: create computer objects,
    /// join computers to the domain, and change/reset the password on descendant computer objects for the
    /// organizational units specified.</p>
    pub fn account_name(&self) -> std::option::Option<&str> {
        self.account_name.as_deref()
    }
    /// <p>The password for the account.</p>
    pub fn account_password(&self) -> std::option::Option<&str> {
        self.account_password.as_deref()
    }
}
impl std::fmt::Debug for ServiceAccountCredentials {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceAccountCredentials");
        formatter.field("account_name", &"*** Sensitive Data Redacted ***");
        formatter.field("account_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ServiceAccountCredentials`](crate::model::ServiceAccountCredentials)
pub mod service_account_credentials {
    /// A builder for [`ServiceAccountCredentials`](crate::model::ServiceAccountCredentials)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_name: std::option::Option<std::string::String>,
        pub(crate) account_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name of the account. This account must have the following privileges: create computer objects,
        /// join computers to the domain, and change/reset the password on descendant computer objects for the
        /// organizational units specified.</p>
        pub fn account_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_name = Some(input.into());
            self
        }
        /// <p>The user name of the account. This account must have the following privileges: create computer objects,
        /// join computers to the domain, and change/reset the password on descendant computer objects for the
        /// organizational units specified.</p>
        pub fn set_account_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_name = input;
            self
        }
        /// <p>The password for the account.</p>
        pub fn account_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_password = Some(input.into());
            self
        }
        /// <p>The password for the account.</p>
        pub fn set_account_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_password = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceAccountCredentials`](crate::model::ServiceAccountCredentials)
        pub fn build(self) -> crate::model::ServiceAccountCredentials {
            crate::model::ServiceAccountCredentials {
                account_name: self.account_name,
                account_password: self.account_password,
            }
        }
    }
}
impl ServiceAccountCredentials {
    /// Creates a new builder-style object to manufacture [`ServiceAccountCredentials`](crate::model::ServiceAccountCredentials)
    pub fn builder() -> crate::model::service_account_credentials::Builder {
        crate::model::service_account_credentials::Builder::default()
    }
}

/// <p>Describes a virtual machine that is used to create an image. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageBuilder {
    /// <p>The name of the image builder.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN for the image builder.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the image from which this builder was created.</p>
    pub image_arn: std::option::Option<std::string::String>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The image builder name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The VPC configuration of the image builder.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>The instance type for the image builder. The following instance types are available:</p>   
    /// <ul>
    /// <li>
    /// <p>stream.standard.small</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.medium</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.3xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.6xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.large</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-desktop.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.16xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.16xlarge</p>
    /// </li>
    /// </ul>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The operating system platform of the image builder.</p>
    pub platform: std::option::Option<crate::model::PlatformType>,
    /// <p>The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The state of the image builder.</p>
    pub state: std::option::Option<crate::model::ImageBuilderState>,
    /// <p>The reason why the last state change occurred.</p>
    pub state_change_reason: std::option::Option<crate::model::ImageBuilderStateChangeReason>,
    /// <p>The time stamp when the image builder was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Enables or disables default internet access for the image builder.</p>
    pub enable_default_internet_access: std::option::Option<bool>,
    /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
    pub domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
    /// <p>Describes the network details of the fleet or image builder instance.</p>
    pub network_access_configuration: std::option::Option<crate::model::NetworkAccessConfiguration>,
    /// <p>The image builder errors.</p>
    pub image_builder_errors: std::option::Option<std::vec::Vec<crate::model::ResourceError>>,
    /// <p>The version of the AppStream 2.0 agent that is currently being used by the image builder. </p>
    pub appstream_agent_version: std::option::Option<std::string::String>,
    /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.</p>
    pub access_endpoints: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
}
impl ImageBuilder {
    /// <p>The name of the image builder.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN for the image builder.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN of the image from which this builder was created.</p>
    pub fn image_arn(&self) -> std::option::Option<&str> {
        self.image_arn.as_deref()
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The image builder name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The VPC configuration of the image builder.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>The instance type for the image builder. The following instance types are available:</p>   
    /// <ul>
    /// <li>
    /// <p>stream.standard.small</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.medium</p>
    /// </li>
    /// <li>
    /// <p>stream.standard.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.large</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.compute.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.large</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.3xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.6xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.memory.z1d.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.large</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-design.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-desktop.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.2xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.12xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics.g4dn.16xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>stream.graphics-pro.16xlarge</p>
    /// </li>
    /// </ul>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The operating system platform of the image builder.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::PlatformType> {
        self.platform.as_ref()
    }
    /// <p>The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
    ///
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The state of the image builder.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ImageBuilderState> {
        self.state.as_ref()
    }
    /// <p>The reason why the last state change occurred.</p>
    pub fn state_change_reason(
        &self,
    ) -> std::option::Option<&crate::model::ImageBuilderStateChangeReason> {
        self.state_change_reason.as_ref()
    }
    /// <p>The time stamp when the image builder was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>Enables or disables default internet access for the image builder.</p>
    pub fn enable_default_internet_access(&self) -> std::option::Option<bool> {
        self.enable_default_internet_access
    }
    /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
    pub fn domain_join_info(&self) -> std::option::Option<&crate::model::DomainJoinInfo> {
        self.domain_join_info.as_ref()
    }
    /// <p>Describes the network details of the fleet or image builder instance.</p>
    pub fn network_access_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NetworkAccessConfiguration> {
        self.network_access_configuration.as_ref()
    }
    /// <p>The image builder errors.</p>
    pub fn image_builder_errors(&self) -> std::option::Option<&[crate::model::ResourceError]> {
        self.image_builder_errors.as_deref()
    }
    /// <p>The version of the AppStream 2.0 agent that is currently being used by the image builder. </p>
    pub fn appstream_agent_version(&self) -> std::option::Option<&str> {
        self.appstream_agent_version.as_deref()
    }
    /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.</p>
    pub fn access_endpoints(&self) -> std::option::Option<&[crate::model::AccessEndpoint]> {
        self.access_endpoints.as_deref()
    }
}
impl std::fmt::Debug for ImageBuilder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageBuilder");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("image_arn", &self.image_arn);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("platform", &self.platform);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("state", &self.state);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("created_time", &self.created_time);
        formatter.field(
            "enable_default_internet_access",
            &self.enable_default_internet_access,
        );
        formatter.field("domain_join_info", &self.domain_join_info);
        formatter.field(
            "network_access_configuration",
            &self.network_access_configuration,
        );
        formatter.field("image_builder_errors", &self.image_builder_errors);
        formatter.field("appstream_agent_version", &self.appstream_agent_version);
        formatter.field("access_endpoints", &self.access_endpoints);
        formatter.finish()
    }
}
/// See [`ImageBuilder`](crate::model::ImageBuilder)
pub mod image_builder {
    /// A builder for [`ImageBuilder`](crate::model::ImageBuilder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) image_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::PlatformType>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ImageBuilderState>,
        pub(crate) state_change_reason:
            std::option::Option<crate::model::ImageBuilderStateChangeReason>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) enable_default_internet_access: std::option::Option<bool>,
        pub(crate) domain_join_info: std::option::Option<crate::model::DomainJoinInfo>,
        pub(crate) network_access_configuration:
            std::option::Option<crate::model::NetworkAccessConfiguration>,
        pub(crate) image_builder_errors:
            std::option::Option<std::vec::Vec<crate::model::ResourceError>>,
        pub(crate) appstream_agent_version: std::option::Option<std::string::String>,
        pub(crate) access_endpoints:
            std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
    }
    impl Builder {
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN for the image builder.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN for the image builder.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN of the image from which this builder was created.</p>
        pub fn image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the image from which this builder was created.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image_arn = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The VPC configuration of the image builder.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>The VPC configuration of the image builder.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The instance type for the image builder. The following instance types are available:</p>   
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type for the image builder. The following instance types are available:</p>   
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The operating system platform of the image builder.</p>
        pub fn platform(mut self, input: crate::model::PlatformType) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The operating system platform of the image builder.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformType>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that is applied to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The state of the image builder.</p>
        pub fn state(mut self, input: crate::model::ImageBuilderState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the image builder.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ImageBuilderState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason why the last state change occurred.</p>
        pub fn state_change_reason(
            mut self,
            input: crate::model::ImageBuilderStateChangeReason,
        ) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>The reason why the last state change occurred.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::ImageBuilderStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// <p>The time stamp when the image builder was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time stamp when the image builder was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn enable_default_internet_access(mut self, input: bool) -> Self {
            self.enable_default_internet_access = Some(input);
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_default_internet_access = input;
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, input: crate::model::DomainJoinInfo) -> Self {
            self.domain_join_info = Some(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.domain_join_info = input;
            self
        }
        /// <p>Describes the network details of the fleet or image builder instance.</p>
        pub fn network_access_configuration(
            mut self,
            input: crate::model::NetworkAccessConfiguration,
        ) -> Self {
            self.network_access_configuration = Some(input);
            self
        }
        /// <p>Describes the network details of the fleet or image builder instance.</p>
        pub fn set_network_access_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkAccessConfiguration>,
        ) -> Self {
            self.network_access_configuration = input;
            self
        }
        /// Appends an item to `image_builder_errors`.
        ///
        /// To override the contents of this collection use [`set_image_builder_errors`](Self::set_image_builder_errors).
        ///
        /// <p>The image builder errors.</p>
        pub fn image_builder_errors(
            mut self,
            input: impl Into<crate::model::ResourceError>,
        ) -> Self {
            let mut v = self.image_builder_errors.unwrap_or_default();
            v.push(input.into());
            self.image_builder_errors = Some(v);
            self
        }
        /// <p>The image builder errors.</p>
        pub fn set_image_builder_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceError>>,
        ) -> Self {
            self.image_builder_errors = input;
            self
        }
        /// <p>The version of the AppStream 2.0 agent that is currently being used by the image builder. </p>
        pub fn appstream_agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.appstream_agent_version = Some(input.into());
            self
        }
        /// <p>The version of the AppStream 2.0 agent that is currently being used by the image builder. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.appstream_agent_version = input;
            self
        }
        /// Appends an item to `access_endpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, input: impl Into<crate::model::AccessEndpoint>) -> Self {
            let mut v = self.access_endpoints.unwrap_or_default();
            v.push(input.into());
            self.access_endpoints = Some(v);
            self
        }
        /// <p>The list of virtual private cloud (VPC) interface endpoint objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.access_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageBuilder`](crate::model::ImageBuilder)
        pub fn build(self) -> crate::model::ImageBuilder {
            crate::model::ImageBuilder {
                name: self.name,
                arn: self.arn,
                image_arn: self.image_arn,
                description: self.description,
                display_name: self.display_name,
                vpc_config: self.vpc_config,
                instance_type: self.instance_type,
                platform: self.platform,
                iam_role_arn: self.iam_role_arn,
                state: self.state,
                state_change_reason: self.state_change_reason,
                created_time: self.created_time,
                enable_default_internet_access: self.enable_default_internet_access,
                domain_join_info: self.domain_join_info,
                network_access_configuration: self.network_access_configuration,
                image_builder_errors: self.image_builder_errors,
                appstream_agent_version: self.appstream_agent_version,
                access_endpoints: self.access_endpoints,
            }
        }
    }
}
impl ImageBuilder {
    /// Creates a new builder-style object to manufacture [`ImageBuilder`](crate::model::ImageBuilder)
    pub fn builder() -> crate::model::image_builder::Builder {
        crate::model::image_builder::Builder::default()
    }
}

/// <p>Describes a resource error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceError {
    /// <p>The error code.</p>
    pub error_code: std::option::Option<crate::model::FleetErrorCode>,
    /// <p>The error message.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>The time the error occurred.</p>
    pub error_timestamp: std::option::Option<aws_smithy_types::DateTime>,
}
impl ResourceError {
    /// <p>The error code.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::FleetErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>The time the error occurred.</p>
    pub fn error_timestamp(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.error_timestamp.as_ref()
    }
}
impl std::fmt::Debug for ResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("error_timestamp", &self.error_timestamp);
        formatter.finish()
    }
}
/// See [`ResourceError`](crate::model::ResourceError)
pub mod resource_error {
    /// A builder for [`ResourceError`](crate::model::ResourceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::FleetErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) error_timestamp: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: crate::model::FleetErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::FleetErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>The time the error occurred.</p>
        pub fn error_timestamp(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.error_timestamp = Some(input);
            self
        }
        /// <p>The time the error occurred.</p>
        pub fn set_error_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.error_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceError`](crate::model::ResourceError)
        pub fn build(self) -> crate::model::ResourceError {
            crate::model::ResourceError {
                error_code: self.error_code,
                error_message: self.error_message,
                error_timestamp: self.error_timestamp,
            }
        }
    }
}
impl ResourceError {
    /// Creates a new builder-style object to manufacture [`ResourceError`](crate::model::ResourceError)
    pub fn builder() -> crate::model::resource_error::Builder {
        crate::model::resource_error::Builder::default()
    }
}

/// <p>Describes the network details of the fleet or image builder instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkAccessConfiguration {
    /// <p>The private IP address of the elastic network interface that is attached to instances in your VPC.</p>
    pub eni_private_ip_address: std::option::Option<std::string::String>,
    /// <p>The resource identifier of the elastic network interface that is attached to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource identifier.</p>
    pub eni_id: std::option::Option<std::string::String>,
}
impl NetworkAccessConfiguration {
    /// <p>The private IP address of the elastic network interface that is attached to instances in your VPC.</p>
    pub fn eni_private_ip_address(&self) -> std::option::Option<&str> {
        self.eni_private_ip_address.as_deref()
    }
    /// <p>The resource identifier of the elastic network interface that is attached to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource identifier.</p>
    pub fn eni_id(&self) -> std::option::Option<&str> {
        self.eni_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkAccessConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkAccessConfiguration");
        formatter.field("eni_private_ip_address", &self.eni_private_ip_address);
        formatter.field("eni_id", &self.eni_id);
        formatter.finish()
    }
}
/// See [`NetworkAccessConfiguration`](crate::model::NetworkAccessConfiguration)
pub mod network_access_configuration {
    /// A builder for [`NetworkAccessConfiguration`](crate::model::NetworkAccessConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eni_private_ip_address: std::option::Option<std::string::String>,
        pub(crate) eni_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The private IP address of the elastic network interface that is attached to instances in your VPC.</p>
        pub fn eni_private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address of the elastic network interface that is attached to instances in your VPC.</p>
        pub fn set_eni_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eni_private_ip_address = input;
            self
        }
        /// <p>The resource identifier of the elastic network interface that is attached to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource identifier.</p>
        pub fn eni_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.eni_id = Some(input.into());
            self
        }
        /// <p>The resource identifier of the elastic network interface that is attached to instances in your VPC. All network interfaces have the eni-xxxxxxxx resource identifier.</p>
        pub fn set_eni_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eni_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkAccessConfiguration`](crate::model::NetworkAccessConfiguration)
        pub fn build(self) -> crate::model::NetworkAccessConfiguration {
            crate::model::NetworkAccessConfiguration {
                eni_private_ip_address: self.eni_private_ip_address,
                eni_id: self.eni_id,
            }
        }
    }
}
impl NetworkAccessConfiguration {
    /// Creates a new builder-style object to manufacture [`NetworkAccessConfiguration`](crate::model::NetworkAccessConfiguration)
    pub fn builder() -> crate::model::network_access_configuration::Builder {
        crate::model::network_access_configuration::Builder::default()
    }
}

/// <p>Describes the reason why the last image builder state change occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageBuilderStateChangeReason {
    /// <p>The state change reason code.</p>
    pub code: std::option::Option<crate::model::ImageBuilderStateChangeReasonCode>,
    /// <p>The state change reason message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ImageBuilderStateChangeReason {
    /// <p>The state change reason code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ImageBuilderStateChangeReasonCode> {
        self.code.as_ref()
    }
    /// <p>The state change reason message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ImageBuilderStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageBuilderStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ImageBuilderStateChangeReason`](crate::model::ImageBuilderStateChangeReason)
pub mod image_builder_state_change_reason {
    /// A builder for [`ImageBuilderStateChangeReason`](crate::model::ImageBuilderStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ImageBuilderStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state change reason code.</p>
        pub fn code(mut self, input: crate::model::ImageBuilderStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The state change reason code.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::ImageBuilderStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The state change reason message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The state change reason message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageBuilderStateChangeReason`](crate::model::ImageBuilderStateChangeReason)
        pub fn build(self) -> crate::model::ImageBuilderStateChangeReason {
            crate::model::ImageBuilderStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ImageBuilderStateChangeReason {
    /// Creates a new builder-style object to manufacture [`ImageBuilderStateChangeReason`](crate::model::ImageBuilderStateChangeReason)
    pub fn builder() -> crate::model::image_builder_state_change_reason::Builder {
        crate::model::image_builder_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageBuilderStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    ImageUnavailable,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageBuilderStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "IMAGE_UNAVAILABLE" => ImageBuilderStateChangeReasonCode::ImageUnavailable,
            "INTERNAL_ERROR" => ImageBuilderStateChangeReasonCode::InternalError,
            other => ImageBuilderStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageBuilderStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageBuilderStateChangeReasonCode::from(s))
    }
}
impl ImageBuilderStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageBuilderStateChangeReasonCode::ImageUnavailable => "IMAGE_UNAVAILABLE",
            ImageBuilderStateChangeReasonCode::InternalError => "INTERNAL_ERROR",
            ImageBuilderStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IMAGE_UNAVAILABLE", "INTERNAL_ERROR"]
    }
}
impl AsRef<str> for ImageBuilderStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageBuilderState {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingQualification,
    #[allow(missing_docs)] // documentation missing in model
    Rebooting,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Snapshotting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    #[allow(missing_docs)] // documentation missing in model
    UpdatingAgent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageBuilderState {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => ImageBuilderState::Deleting,
            "FAILED" => ImageBuilderState::Failed,
            "PENDING" => ImageBuilderState::Pending,
            "PENDING_QUALIFICATION" => ImageBuilderState::PendingQualification,
            "REBOOTING" => ImageBuilderState::Rebooting,
            "RUNNING" => ImageBuilderState::Running,
            "SNAPSHOTTING" => ImageBuilderState::Snapshotting,
            "STOPPED" => ImageBuilderState::Stopped,
            "STOPPING" => ImageBuilderState::Stopping,
            "UPDATING" => ImageBuilderState::Updating,
            "UPDATING_AGENT" => ImageBuilderState::UpdatingAgent,
            other => ImageBuilderState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageBuilderState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageBuilderState::from(s))
    }
}
impl ImageBuilderState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageBuilderState::Deleting => "DELETING",
            ImageBuilderState::Failed => "FAILED",
            ImageBuilderState::Pending => "PENDING",
            ImageBuilderState::PendingQualification => "PENDING_QUALIFICATION",
            ImageBuilderState::Rebooting => "REBOOTING",
            ImageBuilderState::Running => "RUNNING",
            ImageBuilderState::Snapshotting => "SNAPSHOTTING",
            ImageBuilderState::Stopped => "STOPPED",
            ImageBuilderState::Stopping => "STOPPING",
            ImageBuilderState::Updating => "UPDATING",
            ImageBuilderState::UpdatingAgent => "UPDATING_AGENT",
            ImageBuilderState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETING",
            "FAILED",
            "PENDING",
            "PENDING_QUALIFICATION",
            "REBOOTING",
            "RUNNING",
            "SNAPSHOTTING",
            "STOPPED",
            "STOPPING",
            "UPDATING",
            "UPDATING_AGENT",
        ]
    }
}
impl AsRef<str> for ImageBuilderState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlatformType {
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux2,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2016,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2019,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlatformType {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_LINUX2" => PlatformType::AmazonLinux2,
            "WINDOWS" => PlatformType::Windows,
            "WINDOWS_SERVER_2016" => PlatformType::WindowsServer2016,
            "WINDOWS_SERVER_2019" => PlatformType::WindowsServer2019,
            other => PlatformType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlatformType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlatformType::from(s))
    }
}
impl PlatformType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlatformType::AmazonLinux2 => "AMAZON_LINUX2",
            PlatformType::Windows => "WINDOWS",
            PlatformType::WindowsServer2016 => "WINDOWS_SERVER_2016",
            PlatformType::WindowsServer2019 => "WINDOWS_SERVER_2019",
            PlatformType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMAZON_LINUX2",
            "WINDOWS",
            "WINDOWS_SERVER_2016",
            "WINDOWS_SERVER_2019",
        ]
    }
}
impl AsRef<str> for PlatformType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationType {
    #[allow(missing_docs)] // documentation missing in model
    Api,
    #[allow(missing_docs)] // documentation missing in model
    Saml,
    #[allow(missing_docs)] // documentation missing in model
    Userpool,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationType {
    fn from(s: &str) -> Self {
        match s {
            "API" => AuthenticationType::Api,
            "SAML" => AuthenticationType::Saml,
            "USERPOOL" => AuthenticationType::Userpool,
            other => AuthenticationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationType::from(s))
    }
}
impl AuthenticationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationType::Api => "API",
            AuthenticationType::Saml => "SAML",
            AuthenticationType::Userpool => "USERPOOL",
            AuthenticationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["API", "SAML", "USERPOOL"]
    }
}
impl AsRef<str> for AuthenticationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a user in the user pool and the associated stack.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserStackAssociation {
    /// <p>The name of the stack that is associated with the user.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The email address of the user who is associated with the stack.</p>
    ///
    /// <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The authentication type for the user.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>Specifies whether a welcome email is sent to a user after the user is created in the user pool.</p>
    pub send_email_notification: bool,
}
impl UserStackAssociation {
    /// <p>The name of the stack that is associated with the user.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The email address of the user who is associated with the stack.</p>
    ///
    /// <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The authentication type for the user.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>Specifies whether a welcome email is sent to a user after the user is created in the user pool.</p>
    pub fn send_email_notification(&self) -> bool {
        self.send_email_notification
    }
}
impl std::fmt::Debug for UserStackAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserStackAssociation");
        formatter.field("stack_name", &self.stack_name);
        formatter.field("user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field("send_email_notification", &self.send_email_notification);
        formatter.finish()
    }
}
/// See [`UserStackAssociation`](crate::model::UserStackAssociation)
pub mod user_stack_association {
    /// A builder for [`UserStackAssociation`](crate::model::UserStackAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) send_email_notification: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The authentication type for the user.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the user.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>Specifies whether a welcome email is sent to a user after the user is created in the user pool.</p>
        pub fn send_email_notification(mut self, input: bool) -> Self {
            self.send_email_notification = Some(input);
            self
        }
        /// <p>Specifies whether a welcome email is sent to a user after the user is created in the user pool.</p>
        pub fn set_send_email_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.send_email_notification = input;
            self
        }
        /// Consumes the builder and constructs a [`UserStackAssociation`](crate::model::UserStackAssociation)
        pub fn build(self) -> crate::model::UserStackAssociation {
            crate::model::UserStackAssociation {
                stack_name: self.stack_name,
                user_name: self.user_name,
                authentication_type: self.authentication_type,
                send_email_notification: self.send_email_notification.unwrap_or_default(),
            }
        }
    }
}
impl UserStackAssociation {
    /// Creates a new builder-style object to manufacture [`UserStackAssociation`](crate::model::UserStackAssociation)
    pub fn builder() -> crate::model::user_stack_association::Builder {
        crate::model::user_stack_association::Builder::default()
    }
}

/// <p>Describes a user in the user pool.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct User {
    /// <p>The ARN of the user.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The email address of the user.</p>
    ///
    /// <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether the user in the user pool is enabled.</p>
    pub enabled: bool,
    /// <p>The status of the user in the user pool. The status can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>UNCONFIRMED – The user is created but not confirmed.</p>
    /// </li>
    /// <li>
    /// <p>CONFIRMED – The user is confirmed.</p>
    /// </li>
    /// <li>
    /// <p>ARCHIVED – The user is no longer active.</p>
    /// </li>
    /// <li>
    /// <p>COMPROMISED – The user is disabled because of a potential security threat.</p>
    /// </li>
    /// <li>
    /// <p>UNKNOWN – The user status is not known.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The first name, or given name, of the user.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The last name, or surname, of the user.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The date and time the user was created in the user pool.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The authentication type for the user.</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
}
impl User {
    /// <p>The ARN of the user.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The email address of the user.</p>
    ///
    /// <note>
    /// <p>Users' email addresses are case-sensitive.</p>
    /// </note>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>Specifies whether the user in the user pool is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The status of the user in the user pool. The status can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>UNCONFIRMED – The user is created but not confirmed.</p>
    /// </li>
    /// <li>
    /// <p>CONFIRMED – The user is confirmed.</p>
    /// </li>
    /// <li>
    /// <p>ARCHIVED – The user is no longer active.</p>
    /// </li>
    /// <li>
    /// <p>COMPROMISED – The user is disabled because of a potential security threat.</p>
    /// </li>
    /// <li>
    /// <p>UNKNOWN – The user status is not known.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The first name, or given name, of the user.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>The last name, or surname, of the user.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>The date and time the user was created in the user pool.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The authentication type for the user.</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
}
impl std::fmt::Debug for User {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("User");
        formatter.field("arn", &self.arn);
        formatter.field("user_name", &"*** Sensitive Data Redacted ***");
        formatter.field("enabled", &self.enabled);
        formatter.field("status", &self.status);
        formatter.field("first_name", &"*** Sensitive Data Redacted ***");
        formatter.field("last_name", &"*** Sensitive Data Redacted ***");
        formatter.field("created_time", &self.created_time);
        formatter.field("authentication_type", &self.authentication_type);
        formatter.finish()
    }
}
/// See [`User`](crate::model::User)
pub mod user {
    /// A builder for [`User`](crate::model::User)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
    }
    impl Builder {
        /// <p>The ARN of the user.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the user.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>Specifies whether the user in the user pool is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Specifies whether the user in the user pool is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The status of the user in the user pool. The status can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>UNCONFIRMED – The user is created but not confirmed.</p>
        /// </li>
        /// <li>
        /// <p>CONFIRMED – The user is confirmed.</p>
        /// </li>
        /// <li>
        /// <p>ARCHIVED – The user is no longer active.</p>
        /// </li>
        /// <li>
        /// <p>COMPROMISED – The user is disabled because of a potential security threat.</p>
        /// </li>
        /// <li>
        /// <p>UNKNOWN – The user status is not known.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the user in the user pool. The status can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>UNCONFIRMED – The user is created but not confirmed.</p>
        /// </li>
        /// <li>
        /// <p>CONFIRMED – The user is confirmed.</p>
        /// </li>
        /// <li>
        /// <p>ARCHIVED – The user is no longer active.</p>
        /// </li>
        /// <li>
        /// <p>COMPROMISED – The user is disabled because of a potential security threat.</p>
        /// </li>
        /// <li>
        /// <p>UNKNOWN – The user status is not known.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The date and time the user was created in the user pool.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The date and time the user was created in the user pool.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The authentication type for the user.</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication type for the user.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// Consumes the builder and constructs a [`User`](crate::model::User)
        pub fn build(self) -> crate::model::User {
            crate::model::User {
                arn: self.arn,
                user_name: self.user_name,
                enabled: self.enabled.unwrap_or_default(),
                status: self.status,
                first_name: self.first_name,
                last_name: self.last_name,
                created_time: self.created_time,
                authentication_type: self.authentication_type,
            }
        }
    }
}
impl User {
    /// Creates a new builder-style object to manufacture [`User`](crate::model::User)
    pub fn builder() -> crate::model::user::Builder {
        crate::model::user::Builder::default()
    }
}

/// <p>Describes information about the usage report subscription.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageReportSubscription {
    /// <p>The Amazon S3 bucket where generated reports are stored.</p>
    ///
    /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
    /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
    /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
    /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
    /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The schedule for generating usage reports.</p>
    pub schedule: std::option::Option<crate::model::UsageReportSchedule>,
    /// <p>The time when the last usage report was generated.</p>
    pub last_generated_report_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The errors that were returned if usage reports couldn't be generated.</p>
    pub subscription_errors:
        std::option::Option<std::vec::Vec<crate::model::LastReportGenerationExecutionError>>,
}
impl UsageReportSubscription {
    /// <p>The Amazon S3 bucket where generated reports are stored.</p>
    ///
    /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
    /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
    /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
    /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
    /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The schedule for generating usage reports.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::UsageReportSchedule> {
        self.schedule.as_ref()
    }
    /// <p>The time when the last usage report was generated.</p>
    pub fn last_generated_report_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_generated_report_date.as_ref()
    }
    /// <p>The errors that were returned if usage reports couldn't be generated.</p>
    pub fn subscription_errors(
        &self,
    ) -> std::option::Option<&[crate::model::LastReportGenerationExecutionError]> {
        self.subscription_errors.as_deref()
    }
}
impl std::fmt::Debug for UsageReportSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageReportSubscription");
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("schedule", &self.schedule);
        formatter.field(
            "last_generated_report_date",
            &self.last_generated_report_date,
        );
        formatter.field("subscription_errors", &self.subscription_errors);
        formatter.finish()
    }
}
/// See [`UsageReportSubscription`](crate::model::UsageReportSubscription)
pub mod usage_report_subscription {
    /// A builder for [`UsageReportSubscription`](crate::model::UsageReportSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::UsageReportSchedule>,
        pub(crate) last_generated_report_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) subscription_errors:
            std::option::Option<std::vec::Vec<crate::model::LastReportGenerationExecutionError>>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket where generated reports are stored.</p>
        ///
        /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
        /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
        /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
        /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
        /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket where generated reports are stored.</p>
        ///
        /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
        /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
        /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
        /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
        /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The schedule for generating usage reports.</p>
        pub fn schedule(mut self, input: crate::model::UsageReportSchedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule for generating usage reports.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::UsageReportSchedule>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The time when the last usage report was generated.</p>
        pub fn last_generated_report_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_generated_report_date = Some(input);
            self
        }
        /// <p>The time when the last usage report was generated.</p>
        pub fn set_last_generated_report_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_generated_report_date = input;
            self
        }
        /// Appends an item to `subscription_errors`.
        ///
        /// To override the contents of this collection use [`set_subscription_errors`](Self::set_subscription_errors).
        ///
        /// <p>The errors that were returned if usage reports couldn't be generated.</p>
        pub fn subscription_errors(
            mut self,
            input: impl Into<crate::model::LastReportGenerationExecutionError>,
        ) -> Self {
            let mut v = self.subscription_errors.unwrap_or_default();
            v.push(input.into());
            self.subscription_errors = Some(v);
            self
        }
        /// <p>The errors that were returned if usage reports couldn't be generated.</p>
        pub fn set_subscription_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LastReportGenerationExecutionError>,
            >,
        ) -> Self {
            self.subscription_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageReportSubscription`](crate::model::UsageReportSubscription)
        pub fn build(self) -> crate::model::UsageReportSubscription {
            crate::model::UsageReportSubscription {
                s3_bucket_name: self.s3_bucket_name,
                schedule: self.schedule,
                last_generated_report_date: self.last_generated_report_date,
                subscription_errors: self.subscription_errors,
            }
        }
    }
}
impl UsageReportSubscription {
    /// Creates a new builder-style object to manufacture [`UsageReportSubscription`](crate::model::UsageReportSubscription)
    pub fn builder() -> crate::model::usage_report_subscription::Builder {
        crate::model::usage_report_subscription::Builder::default()
    }
}

/// <p>Describes the error that is returned when a usage report can't be generated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LastReportGenerationExecutionError {
    /// <p>The error code for the error that is returned when a usage report can't be generated.</p>
    pub error_code: std::option::Option<crate::model::UsageReportExecutionErrorCode>,
    /// <p>The error message for the error that is returned when a usage report can't be generated.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl LastReportGenerationExecutionError {
    /// <p>The error code for the error that is returned when a usage report can't be generated.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::UsageReportExecutionErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message for the error that is returned when a usage report can't be generated.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for LastReportGenerationExecutionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LastReportGenerationExecutionError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`LastReportGenerationExecutionError`](crate::model::LastReportGenerationExecutionError)
pub mod last_report_generation_execution_error {
    /// A builder for [`LastReportGenerationExecutionError`](crate::model::LastReportGenerationExecutionError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::UsageReportExecutionErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code for the error that is returned when a usage report can't be generated.</p>
        pub fn error_code(mut self, input: crate::model::UsageReportExecutionErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code for the error that is returned when a usage report can't be generated.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::UsageReportExecutionErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message for the error that is returned when a usage report can't be generated.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message for the error that is returned when a usage report can't be generated.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`LastReportGenerationExecutionError`](crate::model::LastReportGenerationExecutionError)
        pub fn build(self) -> crate::model::LastReportGenerationExecutionError {
            crate::model::LastReportGenerationExecutionError {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl LastReportGenerationExecutionError {
    /// Creates a new builder-style object to manufacture [`LastReportGenerationExecutionError`](crate::model::LastReportGenerationExecutionError)
    pub fn builder() -> crate::model::last_report_generation_execution_error::Builder {
        crate::model::last_report_generation_execution_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageReportExecutionErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    #[allow(missing_docs)] // documentation missing in model
    InternalServiceError,
    #[allow(missing_docs)] // documentation missing in model
    ResourceNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageReportExecutionErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => UsageReportExecutionErrorCode::AccessDenied,
            "INTERNAL_SERVICE_ERROR" => UsageReportExecutionErrorCode::InternalServiceError,
            "RESOURCE_NOT_FOUND" => UsageReportExecutionErrorCode::ResourceNotFound,
            other => UsageReportExecutionErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageReportExecutionErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageReportExecutionErrorCode::from(s))
    }
}
impl UsageReportExecutionErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageReportExecutionErrorCode::AccessDenied => "ACCESS_DENIED",
            UsageReportExecutionErrorCode::InternalServiceError => "INTERNAL_SERVICE_ERROR",
            UsageReportExecutionErrorCode::ResourceNotFound => "RESOURCE_NOT_FOUND",
            UsageReportExecutionErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCESS_DENIED",
            "INTERNAL_SERVICE_ERROR",
            "RESOURCE_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for UsageReportExecutionErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageReportSchedule {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageReportSchedule {
    fn from(s: &str) -> Self {
        match s {
            "DAILY" => UsageReportSchedule::Daily,
            other => UsageReportSchedule::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageReportSchedule {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageReportSchedule::from(s))
    }
}
impl UsageReportSchedule {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageReportSchedule::Daily => "DAILY",
            UsageReportSchedule::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAILY"]
    }
}
impl AsRef<str> for UsageReportSchedule {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a streaming session.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Session {
    /// <p>The identifier of the streaming session.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The identifier of the user for whom the session was created.</p>
    pub user_id: std::option::Option<std::string::String>,
    /// <p>The name of the stack for the streaming session.</p>
    pub stack_name: std::option::Option<std::string::String>,
    /// <p>The name of the fleet for the streaming session.</p>
    pub fleet_name: std::option::Option<std::string::String>,
    /// <p>The current state of the streaming session.</p>
    pub state: std::option::Option<crate::model::SessionState>,
    /// <p>Specifies whether a user is connected to the streaming session.</p>
    pub connection_state: std::option::Option<crate::model::SessionConnectionState>,
    /// <p>The time when a streaming instance is dedicated for the user.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the streaming session is set to expire. This time is based on the <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming session can run. A streaming session might end earlier than the time specified in <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the user chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the user chooses to end his or her session, the streaming instance is terminated and the streaming session ends.</p>
    pub max_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The authentication method. The user is authenticated using a streaming URL
    /// (<code>API</code>) or SAML 2.0 federation (<code>SAML</code>).</p>
    pub authentication_type: std::option::Option<crate::model::AuthenticationType>,
    /// <p>The network details for the streaming session.</p>
    pub network_access_configuration: std::option::Option<crate::model::NetworkAccessConfiguration>,
}
impl Session {
    /// <p>The identifier of the streaming session.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The identifier of the user for whom the session was created.</p>
    pub fn user_id(&self) -> std::option::Option<&str> {
        self.user_id.as_deref()
    }
    /// <p>The name of the stack for the streaming session.</p>
    pub fn stack_name(&self) -> std::option::Option<&str> {
        self.stack_name.as_deref()
    }
    /// <p>The name of the fleet for the streaming session.</p>
    pub fn fleet_name(&self) -> std::option::Option<&str> {
        self.fleet_name.as_deref()
    }
    /// <p>The current state of the streaming session.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::SessionState> {
        self.state.as_ref()
    }
    /// <p>Specifies whether a user is connected to the streaming session.</p>
    pub fn connection_state(&self) -> std::option::Option<&crate::model::SessionConnectionState> {
        self.connection_state.as_ref()
    }
    /// <p>The time when a streaming instance is dedicated for the user.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The time when the streaming session is set to expire. This time is based on the <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming session can run. A streaming session might end earlier than the time specified in <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the user chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the user chooses to end his or her session, the streaming instance is terminated and the streaming session ends.</p>
    pub fn max_expiration_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.max_expiration_time.as_ref()
    }
    /// <p>The authentication method. The user is authenticated using a streaming URL
    /// (<code>API</code>) or SAML 2.0 federation (<code>SAML</code>).</p>
    pub fn authentication_type(&self) -> std::option::Option<&crate::model::AuthenticationType> {
        self.authentication_type.as_ref()
    }
    /// <p>The network details for the streaming session.</p>
    pub fn network_access_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NetworkAccessConfiguration> {
        self.network_access_configuration.as_ref()
    }
}
impl std::fmt::Debug for Session {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Session");
        formatter.field("id", &self.id);
        formatter.field("user_id", &self.user_id);
        formatter.field("stack_name", &self.stack_name);
        formatter.field("fleet_name", &self.fleet_name);
        formatter.field("state", &self.state);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("start_time", &self.start_time);
        formatter.field("max_expiration_time", &self.max_expiration_time);
        formatter.field("authentication_type", &self.authentication_type);
        formatter.field(
            "network_access_configuration",
            &self.network_access_configuration,
        );
        formatter.finish()
    }
}
/// See [`Session`](crate::model::Session)
pub mod session {
    /// A builder for [`Session`](crate::model::Session)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) stack_name: std::option::Option<std::string::String>,
        pub(crate) fleet_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::SessionState>,
        pub(crate) connection_state: std::option::Option<crate::model::SessionConnectionState>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) max_expiration_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) authentication_type: std::option::Option<crate::model::AuthenticationType>,
        pub(crate) network_access_configuration:
            std::option::Option<crate::model::NetworkAccessConfiguration>,
    }
    impl Builder {
        /// <p>The identifier of the streaming session.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the streaming session.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The identifier of the user for whom the session was created.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user for whom the session was created.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The name of the stack for the streaming session.</p>
        pub fn stack_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stack_name = Some(input.into());
            self
        }
        /// <p>The name of the stack for the streaming session.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stack_name = input;
            self
        }
        /// <p>The name of the fleet for the streaming session.</p>
        pub fn fleet_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.fleet_name = Some(input.into());
            self
        }
        /// <p>The name of the fleet for the streaming session.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fleet_name = input;
            self
        }
        /// <p>The current state of the streaming session.</p>
        pub fn state(mut self, input: crate::model::SessionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the streaming session.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::SessionState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Specifies whether a user is connected to the streaming session.</p>
        pub fn connection_state(mut self, input: crate::model::SessionConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>Specifies whether a user is connected to the streaming session.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::SessionConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The time when a streaming instance is dedicated for the user.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time when a streaming instance is dedicated for the user.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time when the streaming session is set to expire. This time is based on the <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming session can run. A streaming session might end earlier than the time specified in <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the user chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the user chooses to end his or her session, the streaming instance is terminated and the streaming session ends.</p>
        pub fn max_expiration_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.max_expiration_time = Some(input);
            self
        }
        /// <p>The time when the streaming session is set to expire. This time is based on the <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming session can run. A streaming session might end earlier than the time specified in <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the user chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the user chooses to end his or her session, the streaming instance is terminated and the streaming session ends.</p>
        pub fn set_max_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.max_expiration_time = input;
            self
        }
        /// <p>The authentication method. The user is authenticated using a streaming URL
        /// (<code>API</code>) or SAML 2.0 federation (<code>SAML</code>).</p>
        pub fn authentication_type(mut self, input: crate::model::AuthenticationType) -> Self {
            self.authentication_type = Some(input);
            self
        }
        /// <p>The authentication method. The user is authenticated using a streaming URL
        /// (<code>API</code>) or SAML 2.0 federation (<code>SAML</code>).</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.authentication_type = input;
            self
        }
        /// <p>The network details for the streaming session.</p>
        pub fn network_access_configuration(
            mut self,
            input: crate::model::NetworkAccessConfiguration,
        ) -> Self {
            self.network_access_configuration = Some(input);
            self
        }
        /// <p>The network details for the streaming session.</p>
        pub fn set_network_access_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkAccessConfiguration>,
        ) -> Self {
            self.network_access_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Session`](crate::model::Session)
        pub fn build(self) -> crate::model::Session {
            crate::model::Session {
                id: self.id,
                user_id: self.user_id,
                stack_name: self.stack_name,
                fleet_name: self.fleet_name,
                state: self.state,
                connection_state: self.connection_state,
                start_time: self.start_time,
                max_expiration_time: self.max_expiration_time,
                authentication_type: self.authentication_type,
                network_access_configuration: self.network_access_configuration,
            }
        }
    }
}
impl Session {
    /// Creates a new builder-style object to manufacture [`Session`](crate::model::Session)
    pub fn builder() -> crate::model::session::Builder {
        crate::model::session::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SessionConnectionState {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    NotConnected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SessionConnectionState {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => SessionConnectionState::Connected,
            "NOT_CONNECTED" => SessionConnectionState::NotConnected,
            other => SessionConnectionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SessionConnectionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SessionConnectionState::from(s))
    }
}
impl SessionConnectionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SessionConnectionState::Connected => "CONNECTED",
            SessionConnectionState::NotConnected => "NOT_CONNECTED",
            SessionConnectionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTED", "NOT_CONNECTED"]
    }
}
impl AsRef<str> for SessionConnectionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Possible values for the state of a streaming session.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SessionState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SessionState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => SessionState::Active,
            "EXPIRED" => SessionState::Expired,
            "PENDING" => SessionState::Pending,
            other => SessionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SessionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SessionState::from(s))
    }
}
impl SessionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SessionState::Active => "ACTIVE",
            SessionState::Expired => "EXPIRED",
            SessionState::Pending => "PENDING",
            SessionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "EXPIRED", "PENDING"]
    }
}
impl AsRef<str> for SessionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Image {
    /// <p>The name of the image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the image.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the image from which this image was created.</p>
    pub base_image_arn: std::option::Option<std::string::String>,
    /// <p>The image name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The image starts in the <code>PENDING</code> state. If image creation succeeds, the
    /// state is <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.</p>
    pub state: std::option::Option<crate::model::ImageState>,
    /// <p>Indicates whether the image is public or private.</p>
    pub visibility: std::option::Option<crate::model::VisibilityType>,
    /// <p>Indicates whether an image builder can be launched from this image.</p>
    pub image_builder_supported: bool,
    /// <p>The name of the image builder that was used to create the private image. If the image is shared, this value is null.</p>
    pub image_builder_name: std::option::Option<std::string::String>,
    /// <p>The operating system platform of the image.</p>
    pub platform: std::option::Option<crate::model::PlatformType>,
    /// <p>The description to display.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The reason why the last state change occurred.</p>
    pub state_change_reason: std::option::Option<crate::model::ImageStateChangeReason>,
    /// <p>The applications associated with the image.</p>
    pub applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
    /// <p>The time the image was created.</p>
    pub created_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The release date of the public base image.
    /// For private images, this date is the release date of the base image from which the image was created.</p>
    pub public_base_image_released_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The version of the AppStream 2.0 agent to use for instances that are launched from this image. </p>
    pub appstream_agent_version: std::option::Option<std::string::String>,
    /// <p>The permissions to provide to the destination AWS account for the specified image.</p>
    pub image_permissions: std::option::Option<crate::model::ImagePermissions>,
    /// <p>Describes the errors that are returned when a new image can't be created.</p>
    pub image_errors: std::option::Option<std::vec::Vec<crate::model::ResourceError>>,
}
impl Image {
    /// <p>The name of the image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the image.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The ARN of the image from which this image was created.</p>
    pub fn base_image_arn(&self) -> std::option::Option<&str> {
        self.base_image_arn.as_deref()
    }
    /// <p>The image name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The image starts in the <code>PENDING</code> state. If image creation succeeds, the
    /// state is <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.</p>
    pub fn state(&self) -> std::option::Option<&crate::model::ImageState> {
        self.state.as_ref()
    }
    /// <p>Indicates whether the image is public or private.</p>
    pub fn visibility(&self) -> std::option::Option<&crate::model::VisibilityType> {
        self.visibility.as_ref()
    }
    /// <p>Indicates whether an image builder can be launched from this image.</p>
    pub fn image_builder_supported(&self) -> bool {
        self.image_builder_supported
    }
    /// <p>The name of the image builder that was used to create the private image. If the image is shared, this value is null.</p>
    pub fn image_builder_name(&self) -> std::option::Option<&str> {
        self.image_builder_name.as_deref()
    }
    /// <p>The operating system platform of the image.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::PlatformType> {
        self.platform.as_ref()
    }
    /// <p>The description to display.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The reason why the last state change occurred.</p>
    pub fn state_change_reason(
        &self,
    ) -> std::option::Option<&crate::model::ImageStateChangeReason> {
        self.state_change_reason.as_ref()
    }
    /// <p>The applications associated with the image.</p>
    pub fn applications(&self) -> std::option::Option<&[crate::model::Application]> {
        self.applications.as_deref()
    }
    /// <p>The time the image was created.</p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_time.as_ref()
    }
    /// <p>The release date of the public base image.
    /// For private images, this date is the release date of the base image from which the image was created.</p>
    pub fn public_base_image_released_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.public_base_image_released_date.as_ref()
    }
    /// <p>The version of the AppStream 2.0 agent to use for instances that are launched from this image. </p>
    pub fn appstream_agent_version(&self) -> std::option::Option<&str> {
        self.appstream_agent_version.as_deref()
    }
    /// <p>The permissions to provide to the destination AWS account for the specified image.</p>
    pub fn image_permissions(&self) -> std::option::Option<&crate::model::ImagePermissions> {
        self.image_permissions.as_ref()
    }
    /// <p>Describes the errors that are returned when a new image can't be created.</p>
    pub fn image_errors(&self) -> std::option::Option<&[crate::model::ResourceError]> {
        self.image_errors.as_deref()
    }
}
impl std::fmt::Debug for Image {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Image");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("base_image_arn", &self.base_image_arn);
        formatter.field("display_name", &self.display_name);
        formatter.field("state", &self.state);
        formatter.field("visibility", &self.visibility);
        formatter.field("image_builder_supported", &self.image_builder_supported);
        formatter.field("image_builder_name", &self.image_builder_name);
        formatter.field("platform", &self.platform);
        formatter.field("description", &self.description);
        formatter.field("state_change_reason", &self.state_change_reason);
        formatter.field("applications", &self.applications);
        formatter.field("created_time", &self.created_time);
        formatter.field(
            "public_base_image_released_date",
            &self.public_base_image_released_date,
        );
        formatter.field("appstream_agent_version", &self.appstream_agent_version);
        formatter.field("image_permissions", &self.image_permissions);
        formatter.field("image_errors", &self.image_errors);
        formatter.finish()
    }
}
/// See [`Image`](crate::model::Image)
pub mod image {
    /// A builder for [`Image`](crate::model::Image)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) base_image_arn: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ImageState>,
        pub(crate) visibility: std::option::Option<crate::model::VisibilityType>,
        pub(crate) image_builder_supported: std::option::Option<bool>,
        pub(crate) image_builder_name: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::PlatformType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state_change_reason: std::option::Option<crate::model::ImageStateChangeReason>,
        pub(crate) applications: std::option::Option<std::vec::Vec<crate::model::Application>>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) public_base_image_released_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) appstream_agent_version: std::option::Option<std::string::String>,
        pub(crate) image_permissions: std::option::Option<crate::model::ImagePermissions>,
        pub(crate) image_errors: std::option::Option<std::vec::Vec<crate::model::ResourceError>>,
    }
    impl Builder {
        /// <p>The name of the image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the image.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the image.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ARN of the image from which this image was created.</p>
        pub fn base_image_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_image_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the image from which this image was created.</p>
        pub fn set_base_image_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_image_arn = input;
            self
        }
        /// <p>The image name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The image name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The image starts in the <code>PENDING</code> state. If image creation succeeds, the
        /// state is <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.</p>
        pub fn state(mut self, input: crate::model::ImageState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The image starts in the <code>PENDING</code> state. If image creation succeeds, the
        /// state is <code>AVAILABLE</code>. If image creation fails, the state is <code>FAILED</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ImageState>) -> Self {
            self.state = input;
            self
        }
        /// <p>Indicates whether the image is public or private.</p>
        pub fn visibility(mut self, input: crate::model::VisibilityType) -> Self {
            self.visibility = Some(input);
            self
        }
        /// <p>Indicates whether the image is public or private.</p>
        pub fn set_visibility(
            mut self,
            input: std::option::Option<crate::model::VisibilityType>,
        ) -> Self {
            self.visibility = input;
            self
        }
        /// <p>Indicates whether an image builder can be launched from this image.</p>
        pub fn image_builder_supported(mut self, input: bool) -> Self {
            self.image_builder_supported = Some(input);
            self
        }
        /// <p>Indicates whether an image builder can be launched from this image.</p>
        pub fn set_image_builder_supported(mut self, input: std::option::Option<bool>) -> Self {
            self.image_builder_supported = input;
            self
        }
        /// <p>The name of the image builder that was used to create the private image. If the image is shared, this value is null.</p>
        pub fn image_builder_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_builder_name = Some(input.into());
            self
        }
        /// <p>The name of the image builder that was used to create the private image. If the image is shared, this value is null.</p>
        pub fn set_image_builder_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_builder_name = input;
            self
        }
        /// <p>The operating system platform of the image.</p>
        pub fn platform(mut self, input: crate::model::PlatformType) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The operating system platform of the image.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformType>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The reason why the last state change occurred.</p>
        pub fn state_change_reason(mut self, input: crate::model::ImageStateChangeReason) -> Self {
            self.state_change_reason = Some(input);
            self
        }
        /// <p>The reason why the last state change occurred.</p>
        pub fn set_state_change_reason(
            mut self,
            input: std::option::Option<crate::model::ImageStateChangeReason>,
        ) -> Self {
            self.state_change_reason = input;
            self
        }
        /// Appends an item to `applications`.
        ///
        /// To override the contents of this collection use [`set_applications`](Self::set_applications).
        ///
        /// <p>The applications associated with the image.</p>
        pub fn applications(mut self, input: impl Into<crate::model::Application>) -> Self {
            let mut v = self.applications.unwrap_or_default();
            v.push(input.into());
            self.applications = Some(v);
            self
        }
        /// <p>The applications associated with the image.</p>
        pub fn set_applications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Application>>,
        ) -> Self {
            self.applications = input;
            self
        }
        /// <p>The time the image was created.</p>
        pub fn created_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>The time the image was created.</p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>The release date of the public base image.
        /// For private images, this date is the release date of the base image from which the image was created.</p>
        pub fn public_base_image_released_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.public_base_image_released_date = Some(input);
            self
        }
        /// <p>The release date of the public base image.
        /// For private images, this date is the release date of the base image from which the image was created.</p>
        pub fn set_public_base_image_released_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.public_base_image_released_date = input;
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for instances that are launched from this image. </p>
        pub fn appstream_agent_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.appstream_agent_version = Some(input.into());
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for instances that are launched from this image. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.appstream_agent_version = input;
            self
        }
        /// <p>The permissions to provide to the destination AWS account for the specified image.</p>
        pub fn image_permissions(mut self, input: crate::model::ImagePermissions) -> Self {
            self.image_permissions = Some(input);
            self
        }
        /// <p>The permissions to provide to the destination AWS account for the specified image.</p>
        pub fn set_image_permissions(
            mut self,
            input: std::option::Option<crate::model::ImagePermissions>,
        ) -> Self {
            self.image_permissions = input;
            self
        }
        /// Appends an item to `image_errors`.
        ///
        /// To override the contents of this collection use [`set_image_errors`](Self::set_image_errors).
        ///
        /// <p>Describes the errors that are returned when a new image can't be created.</p>
        pub fn image_errors(mut self, input: impl Into<crate::model::ResourceError>) -> Self {
            let mut v = self.image_errors.unwrap_or_default();
            v.push(input.into());
            self.image_errors = Some(v);
            self
        }
        /// <p>Describes the errors that are returned when a new image can't be created.</p>
        pub fn set_image_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceError>>,
        ) -> Self {
            self.image_errors = input;
            self
        }
        /// Consumes the builder and constructs a [`Image`](crate::model::Image)
        pub fn build(self) -> crate::model::Image {
            crate::model::Image {
                name: self.name,
                arn: self.arn,
                base_image_arn: self.base_image_arn,
                display_name: self.display_name,
                state: self.state,
                visibility: self.visibility,
                image_builder_supported: self.image_builder_supported.unwrap_or_default(),
                image_builder_name: self.image_builder_name,
                platform: self.platform,
                description: self.description,
                state_change_reason: self.state_change_reason,
                applications: self.applications,
                created_time: self.created_time,
                public_base_image_released_date: self.public_base_image_released_date,
                appstream_agent_version: self.appstream_agent_version,
                image_permissions: self.image_permissions,
                image_errors: self.image_errors,
            }
        }
    }
}
impl Image {
    /// Creates a new builder-style object to manufacture [`Image`](crate::model::Image)
    pub fn builder() -> crate::model::image::Builder {
        crate::model::image::Builder::default()
    }
}

/// <p>Describes an application in the application catalog.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Application {
    /// <p>The name of the application.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The application name to display.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The URL for the application icon. This URL might be time-limited.</p>
    pub icon_url: std::option::Option<std::string::String>,
    /// <p>The path to the application executable in the instance.</p>
    pub launch_path: std::option::Option<std::string::String>,
    /// <p>The arguments that are passed to the application at launch.</p>
    pub launch_parameters: std::option::Option<std::string::String>,
    /// <p>If there is a problem, the application can be disabled after image creation.</p>
    pub enabled: bool,
    /// <p>Additional attributes that describe the application.</p>
    pub metadata:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl Application {
    /// <p>The name of the application.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The application name to display.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The URL for the application icon. This URL might be time-limited.</p>
    pub fn icon_url(&self) -> std::option::Option<&str> {
        self.icon_url.as_deref()
    }
    /// <p>The path to the application executable in the instance.</p>
    pub fn launch_path(&self) -> std::option::Option<&str> {
        self.launch_path.as_deref()
    }
    /// <p>The arguments that are passed to the application at launch.</p>
    pub fn launch_parameters(&self) -> std::option::Option<&str> {
        self.launch_parameters.as_deref()
    }
    /// <p>If there is a problem, the application can be disabled after image creation.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>Additional attributes that describe the application.</p>
    pub fn metadata(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.metadata.as_ref()
    }
}
impl std::fmt::Debug for Application {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Application");
        formatter.field("name", &self.name);
        formatter.field("display_name", &self.display_name);
        formatter.field("icon_url", &self.icon_url);
        formatter.field("launch_path", &self.launch_path);
        formatter.field("launch_parameters", &self.launch_parameters);
        formatter.field("enabled", &self.enabled);
        formatter.field("metadata", &self.metadata);
        formatter.finish()
    }
}
/// See [`Application`](crate::model::Application)
pub mod application {
    /// A builder for [`Application`](crate::model::Application)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) icon_url: std::option::Option<std::string::String>,
        pub(crate) launch_path: std::option::Option<std::string::String>,
        pub(crate) launch_parameters: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) metadata: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the application.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the application.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The application name to display.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The application name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The URL for the application icon. This URL might be time-limited.</p>
        pub fn icon_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.icon_url = Some(input.into());
            self
        }
        /// <p>The URL for the application icon. This URL might be time-limited.</p>
        pub fn set_icon_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.icon_url = input;
            self
        }
        /// <p>The path to the application executable in the instance.</p>
        pub fn launch_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_path = Some(input.into());
            self
        }
        /// <p>The path to the application executable in the instance.</p>
        pub fn set_launch_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.launch_path = input;
            self
        }
        /// <p>The arguments that are passed to the application at launch.</p>
        pub fn launch_parameters(mut self, input: impl Into<std::string::String>) -> Self {
            self.launch_parameters = Some(input.into());
            self
        }
        /// <p>The arguments that are passed to the application at launch.</p>
        pub fn set_launch_parameters(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.launch_parameters = input;
            self
        }
        /// <p>If there is a problem, the application can be disabled after image creation.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>If there is a problem, the application can be disabled after image creation.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Adds a key-value pair to `metadata`.
        ///
        /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
        ///
        /// <p>Additional attributes that describe the application.</p>
        pub fn metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.metadata.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.metadata = Some(hash_map);
            self
        }
        /// <p>Additional attributes that describe the application.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`Application`](crate::model::Application)
        pub fn build(self) -> crate::model::Application {
            crate::model::Application {
                name: self.name,
                display_name: self.display_name,
                icon_url: self.icon_url,
                launch_path: self.launch_path,
                launch_parameters: self.launch_parameters,
                enabled: self.enabled.unwrap_or_default(),
                metadata: self.metadata,
            }
        }
    }
}
impl Application {
    /// Creates a new builder-style object to manufacture [`Application`](crate::model::Application)
    pub fn builder() -> crate::model::application::Builder {
        crate::model::application::Builder::default()
    }
}

/// <p>Describes the reason why the last image state change occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageStateChangeReason {
    /// <p>The state change reason code.</p>
    pub code: std::option::Option<crate::model::ImageStateChangeReasonCode>,
    /// <p>The state change reason message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ImageStateChangeReason {
    /// <p>The state change reason code.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ImageStateChangeReasonCode> {
        self.code.as_ref()
    }
    /// <p>The state change reason message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ImageStateChangeReason {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageStateChangeReason");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ImageStateChangeReason`](crate::model::ImageStateChangeReason)
pub mod image_state_change_reason {
    /// A builder for [`ImageStateChangeReason`](crate::model::ImageStateChangeReason)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ImageStateChangeReasonCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state change reason code.</p>
        pub fn code(mut self, input: crate::model::ImageStateChangeReasonCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The state change reason code.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::ImageStateChangeReasonCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The state change reason message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The state change reason message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageStateChangeReason`](crate::model::ImageStateChangeReason)
        pub fn build(self) -> crate::model::ImageStateChangeReason {
            crate::model::ImageStateChangeReason {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ImageStateChangeReason {
    /// Creates a new builder-style object to manufacture [`ImageStateChangeReason`](crate::model::ImageStateChangeReason)
    pub fn builder() -> crate::model::image_state_change_reason::Builder {
        crate::model::image_state_change_reason::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageStateChangeReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    ImageBuilderNotAvailable,
    #[allow(missing_docs)] // documentation missing in model
    ImageCopyFailure,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageStateChangeReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "IMAGE_BUILDER_NOT_AVAILABLE" => ImageStateChangeReasonCode::ImageBuilderNotAvailable,
            "IMAGE_COPY_FAILURE" => ImageStateChangeReasonCode::ImageCopyFailure,
            "INTERNAL_ERROR" => ImageStateChangeReasonCode::InternalError,
            other => ImageStateChangeReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageStateChangeReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageStateChangeReasonCode::from(s))
    }
}
impl ImageStateChangeReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageStateChangeReasonCode::ImageBuilderNotAvailable => "IMAGE_BUILDER_NOT_AVAILABLE",
            ImageStateChangeReasonCode::ImageCopyFailure => "IMAGE_COPY_FAILURE",
            ImageStateChangeReasonCode::InternalError => "INTERNAL_ERROR",
            ImageStateChangeReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "IMAGE_BUILDER_NOT_AVAILABLE",
            "IMAGE_COPY_FAILURE",
            "INTERNAL_ERROR",
        ]
    }
}
impl AsRef<str> for ImageStateChangeReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VisibilityType {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    #[allow(missing_docs)] // documentation missing in model
    Shared,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VisibilityType {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => VisibilityType::Private,
            "PUBLIC" => VisibilityType::Public,
            "SHARED" => VisibilityType::Shared,
            other => VisibilityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VisibilityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VisibilityType::from(s))
    }
}
impl VisibilityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VisibilityType::Private => "PRIVATE",
            VisibilityType::Public => "PUBLIC",
            VisibilityType::Shared => "SHARED",
            VisibilityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC", "SHARED"]
    }
}
impl AsRef<str> for VisibilityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Copying,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Importing,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ImageState::Available,
            "COPYING" => ImageState::Copying,
            "CREATING" => ImageState::Creating,
            "DELETING" => ImageState::Deleting,
            "FAILED" => ImageState::Failed,
            "IMPORTING" => ImageState::Importing,
            "PENDING" => ImageState::Pending,
            other => ImageState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageState::from(s))
    }
}
impl ImageState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageState::Available => "AVAILABLE",
            ImageState::Copying => "COPYING",
            ImageState::Creating => "CREATING",
            ImageState::Deleting => "DELETING",
            ImageState::Failed => "FAILED",
            ImageState::Importing => "IMPORTING",
            ImageState::Pending => "PENDING",
            ImageState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "COPYING",
            "CREATING",
            "DELETING",
            "FAILED",
            "IMPORTING",
            "PENDING",
        ]
    }
}
impl AsRef<str> for ImageState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the permissions that are available to the specified AWS account for a shared image.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharedImagePermissions {
    /// <p>The 12-digit identifier of the AWS account with which the image is shared.</p>
    pub shared_account_id: std::option::Option<std::string::String>,
    /// <p>Describes the permissions for a shared image.</p>
    pub image_permissions: std::option::Option<crate::model::ImagePermissions>,
}
impl SharedImagePermissions {
    /// <p>The 12-digit identifier of the AWS account with which the image is shared.</p>
    pub fn shared_account_id(&self) -> std::option::Option<&str> {
        self.shared_account_id.as_deref()
    }
    /// <p>Describes the permissions for a shared image.</p>
    pub fn image_permissions(&self) -> std::option::Option<&crate::model::ImagePermissions> {
        self.image_permissions.as_ref()
    }
}
impl std::fmt::Debug for SharedImagePermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharedImagePermissions");
        formatter.field("shared_account_id", &self.shared_account_id);
        formatter.field("image_permissions", &self.image_permissions);
        formatter.finish()
    }
}
/// See [`SharedImagePermissions`](crate::model::SharedImagePermissions)
pub mod shared_image_permissions {
    /// A builder for [`SharedImagePermissions`](crate::model::SharedImagePermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) shared_account_id: std::option::Option<std::string::String>,
        pub(crate) image_permissions: std::option::Option<crate::model::ImagePermissions>,
    }
    impl Builder {
        /// <p>The 12-digit identifier of the AWS account with which the image is shared.</p>
        pub fn shared_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.shared_account_id = Some(input.into());
            self
        }
        /// <p>The 12-digit identifier of the AWS account with which the image is shared.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shared_account_id = input;
            self
        }
        /// <p>Describes the permissions for a shared image.</p>
        pub fn image_permissions(mut self, input: crate::model::ImagePermissions) -> Self {
            self.image_permissions = Some(input);
            self
        }
        /// <p>Describes the permissions for a shared image.</p>
        pub fn set_image_permissions(
            mut self,
            input: std::option::Option<crate::model::ImagePermissions>,
        ) -> Self {
            self.image_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`SharedImagePermissions`](crate::model::SharedImagePermissions)
        pub fn build(self) -> crate::model::SharedImagePermissions {
            crate::model::SharedImagePermissions {
                shared_account_id: self.shared_account_id,
                image_permissions: self.image_permissions,
            }
        }
    }
}
impl SharedImagePermissions {
    /// Creates a new builder-style object to manufacture [`SharedImagePermissions`](crate::model::SharedImagePermissions)
    pub fn builder() -> crate::model::shared_image_permissions::Builder {
        crate::model::shared_image_permissions::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageAction {
    #[allow(missing_docs)] // documentation missing in model
    Resend,
    #[allow(missing_docs)] // documentation missing in model
    Suppress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageAction {
    fn from(s: &str) -> Self {
        match s {
            "RESEND" => MessageAction::Resend,
            "SUPPRESS" => MessageAction::Suppress,
            other => MessageAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageAction::from(s))
    }
}
impl MessageAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageAction::Resend => "RESEND",
            MessageAction::Suppress => "SUPPRESS",
            MessageAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RESEND", "SUPPRESS"]
    }
}
impl AsRef<str> for MessageAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the error that is returned when a user can’t be associated with or disassociated from a stack. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserStackAssociationError {
    /// <p>Information about the user and associated stack.</p>
    pub user_stack_association: std::option::Option<crate::model::UserStackAssociation>,
    /// <p>The error code for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
    pub error_code: std::option::Option<crate::model::UserStackAssociationErrorCode>,
    /// <p>The error message for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl UserStackAssociationError {
    /// <p>Information about the user and associated stack.</p>
    pub fn user_stack_association(
        &self,
    ) -> std::option::Option<&crate::model::UserStackAssociation> {
        self.user_stack_association.as_ref()
    }
    /// <p>The error code for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::UserStackAssociationErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The error message for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for UserStackAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserStackAssociationError");
        formatter.field("user_stack_association", &self.user_stack_association);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UserStackAssociationError`](crate::model::UserStackAssociationError)
pub mod user_stack_association_error {
    /// A builder for [`UserStackAssociationError`](crate::model::UserStackAssociationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_stack_association: std::option::Option<crate::model::UserStackAssociation>,
        pub(crate) error_code: std::option::Option<crate::model::UserStackAssociationErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about the user and associated stack.</p>
        pub fn user_stack_association(mut self, input: crate::model::UserStackAssociation) -> Self {
            self.user_stack_association = Some(input);
            self
        }
        /// <p>Information about the user and associated stack.</p>
        pub fn set_user_stack_association(
            mut self,
            input: std::option::Option<crate::model::UserStackAssociation>,
        ) -> Self {
            self.user_stack_association = input;
            self
        }
        /// <p>The error code for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
        pub fn error_code(mut self, input: crate::model::UserStackAssociationErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The error code for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::UserStackAssociationErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message for the error that is returned when a user can’t be associated with or disassociated from a stack.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserStackAssociationError`](crate::model::UserStackAssociationError)
        pub fn build(self) -> crate::model::UserStackAssociationError {
            crate::model::UserStackAssociationError {
                user_stack_association: self.user_stack_association,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl UserStackAssociationError {
    /// Creates a new builder-style object to manufacture [`UserStackAssociationError`](crate::model::UserStackAssociationError)
    pub fn builder() -> crate::model::user_stack_association_error::Builder {
        crate::model::user_stack_association_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserStackAssociationErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    DirectoryNotFound,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    StackNotFound,
    #[allow(missing_docs)] // documentation missing in model
    UserNameNotFound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserStackAssociationErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "DIRECTORY_NOT_FOUND" => UserStackAssociationErrorCode::DirectoryNotFound,
            "INTERNAL_ERROR" => UserStackAssociationErrorCode::InternalError,
            "STACK_NOT_FOUND" => UserStackAssociationErrorCode::StackNotFound,
            "USER_NAME_NOT_FOUND" => UserStackAssociationErrorCode::UserNameNotFound,
            other => UserStackAssociationErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserStackAssociationErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserStackAssociationErrorCode::from(s))
    }
}
impl UserStackAssociationErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserStackAssociationErrorCode::DirectoryNotFound => "DIRECTORY_NOT_FOUND",
            UserStackAssociationErrorCode::InternalError => "INTERNAL_ERROR",
            UserStackAssociationErrorCode::StackNotFound => "STACK_NOT_FOUND",
            UserStackAssociationErrorCode::UserNameNotFound => "USER_NAME_NOT_FOUND",
            UserStackAssociationErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DIRECTORY_NOT_FOUND",
            "INTERNAL_ERROR",
            "STACK_NOT_FOUND",
            "USER_NAME_NOT_FOUND",
        ]
    }
}
impl AsRef<str> for UserStackAssociationErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
