// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon AppStream
///
/// Client for invoking operations on Amazon AppStream. Each operation on Amazon AppStream is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appstream::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appstream::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appstream::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateFleet` operation.
    ///
    /// See [`AssociateFleet`](crate::client::fluent_builders::AssociateFleet) for more information about the
    /// operation and its arguments.
    pub fn associate_fleet(&self) -> fluent_builders::AssociateFleet<C, M, R> {
        fluent_builders::AssociateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchAssociateUserStack` operation.
    ///
    /// See [`BatchAssociateUserStack`](crate::client::fluent_builders::BatchAssociateUserStack) for more information about the
    /// operation and its arguments.
    pub fn batch_associate_user_stack(&self) -> fluent_builders::BatchAssociateUserStack<C, M, R> {
        fluent_builders::BatchAssociateUserStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDisassociateUserStack` operation.
    ///
    /// See [`BatchDisassociateUserStack`](crate::client::fluent_builders::BatchDisassociateUserStack) for more information about the
    /// operation and its arguments.
    pub fn batch_disassociate_user_stack(
        &self,
    ) -> fluent_builders::BatchDisassociateUserStack<C, M, R> {
        fluent_builders::BatchDisassociateUserStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyImage` operation.
    ///
    /// See [`CopyImage`](crate::client::fluent_builders::CopyImage) for more information about the
    /// operation and its arguments.
    pub fn copy_image(&self) -> fluent_builders::CopyImage<C, M, R> {
        fluent_builders::CopyImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDirectoryConfig` operation.
    ///
    /// See [`CreateDirectoryConfig`](crate::client::fluent_builders::CreateDirectoryConfig) for more information about the
    /// operation and its arguments.
    pub fn create_directory_config(&self) -> fluent_builders::CreateDirectoryConfig<C, M, R> {
        fluent_builders::CreateDirectoryConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFleet` operation.
    ///
    /// See [`CreateFleet`](crate::client::fluent_builders::CreateFleet) for more information about the
    /// operation and its arguments.
    pub fn create_fleet(&self) -> fluent_builders::CreateFleet<C, M, R> {
        fluent_builders::CreateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImageBuilder` operation.
    ///
    /// See [`CreateImageBuilder`](crate::client::fluent_builders::CreateImageBuilder) for more information about the
    /// operation and its arguments.
    pub fn create_image_builder(&self) -> fluent_builders::CreateImageBuilder<C, M, R> {
        fluent_builders::CreateImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateImageBuilderStreamingURL` operation.
    ///
    /// See [`CreateImageBuilderStreamingURL`](crate::client::fluent_builders::CreateImageBuilderStreamingURL) for more information about the
    /// operation and its arguments.
    pub fn create_image_builder_streaming_url(
        &self,
    ) -> fluent_builders::CreateImageBuilderStreamingURL<C, M, R> {
        fluent_builders::CreateImageBuilderStreamingURL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStack` operation.
    ///
    /// See [`CreateStack`](crate::client::fluent_builders::CreateStack) for more information about the
    /// operation and its arguments.
    pub fn create_stack(&self) -> fluent_builders::CreateStack<C, M, R> {
        fluent_builders::CreateStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateStreamingURL` operation.
    ///
    /// See [`CreateStreamingURL`](crate::client::fluent_builders::CreateStreamingURL) for more information about the
    /// operation and its arguments.
    pub fn create_streaming_url(&self) -> fluent_builders::CreateStreamingURL<C, M, R> {
        fluent_builders::CreateStreamingURL::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUpdatedImage` operation.
    ///
    /// See [`CreateUpdatedImage`](crate::client::fluent_builders::CreateUpdatedImage) for more information about the
    /// operation and its arguments.
    pub fn create_updated_image(&self) -> fluent_builders::CreateUpdatedImage<C, M, R> {
        fluent_builders::CreateUpdatedImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUsageReportSubscription` operation.
    ///
    /// See [`CreateUsageReportSubscription`](crate::client::fluent_builders::CreateUsageReportSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_usage_report_subscription(
        &self,
    ) -> fluent_builders::CreateUsageReportSubscription<C, M, R> {
        fluent_builders::CreateUsageReportSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDirectoryConfig` operation.
    ///
    /// See [`DeleteDirectoryConfig`](crate::client::fluent_builders::DeleteDirectoryConfig) for more information about the
    /// operation and its arguments.
    pub fn delete_directory_config(&self) -> fluent_builders::DeleteDirectoryConfig<C, M, R> {
        fluent_builders::DeleteDirectoryConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFleet` operation.
    ///
    /// See [`DeleteFleet`](crate::client::fluent_builders::DeleteFleet) for more information about the
    /// operation and its arguments.
    pub fn delete_fleet(&self) -> fluent_builders::DeleteFleet<C, M, R> {
        fluent_builders::DeleteFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImage` operation.
    ///
    /// See [`DeleteImage`](crate::client::fluent_builders::DeleteImage) for more information about the
    /// operation and its arguments.
    pub fn delete_image(&self) -> fluent_builders::DeleteImage<C, M, R> {
        fluent_builders::DeleteImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImageBuilder` operation.
    ///
    /// See [`DeleteImageBuilder`](crate::client::fluent_builders::DeleteImageBuilder) for more information about the
    /// operation and its arguments.
    pub fn delete_image_builder(&self) -> fluent_builders::DeleteImageBuilder<C, M, R> {
        fluent_builders::DeleteImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteImagePermissions` operation.
    ///
    /// See [`DeleteImagePermissions`](crate::client::fluent_builders::DeleteImagePermissions) for more information about the
    /// operation and its arguments.
    pub fn delete_image_permissions(&self) -> fluent_builders::DeleteImagePermissions<C, M, R> {
        fluent_builders::DeleteImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteStack` operation.
    ///
    /// See [`DeleteStack`](crate::client::fluent_builders::DeleteStack) for more information about the
    /// operation and its arguments.
    pub fn delete_stack(&self) -> fluent_builders::DeleteStack<C, M, R> {
        fluent_builders::DeleteStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUsageReportSubscription` operation.
    ///
    /// See [`DeleteUsageReportSubscription`](crate::client::fluent_builders::DeleteUsageReportSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_usage_report_subscription(
        &self,
    ) -> fluent_builders::DeleteUsageReportSubscription<C, M, R> {
        fluent_builders::DeleteUsageReportSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDirectoryConfigs` operation.
    ///
    /// See [`DescribeDirectoryConfigs`](crate::client::fluent_builders::DescribeDirectoryConfigs) for more information about the
    /// operation and its arguments.
    pub fn describe_directory_configs(&self) -> fluent_builders::DescribeDirectoryConfigs<C, M, R> {
        fluent_builders::DescribeDirectoryConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFleets` operation.
    ///
    /// See [`DescribeFleets`](crate::client::fluent_builders::DescribeFleets) for more information about the
    /// operation and its arguments.
    pub fn describe_fleets(&self) -> fluent_builders::DescribeFleets<C, M, R> {
        fluent_builders::DescribeFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImageBuilders` operation.
    ///
    /// See [`DescribeImageBuilders`](crate::client::fluent_builders::DescribeImageBuilders) for more information about the
    /// operation and its arguments.
    pub fn describe_image_builders(&self) -> fluent_builders::DescribeImageBuilders<C, M, R> {
        fluent_builders::DescribeImageBuilders::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImagePermissions` operation.
    ///
    /// See [`DescribeImagePermissions`](crate::client::fluent_builders::DescribeImagePermissions) for more information about the
    /// operation and its arguments.
    pub fn describe_image_permissions(&self) -> fluent_builders::DescribeImagePermissions<C, M, R> {
        fluent_builders::DescribeImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeImages` operation.
    ///
    /// See [`DescribeImages`](crate::client::fluent_builders::DescribeImages) for more information about the
    /// operation and its arguments.
    pub fn describe_images(&self) -> fluent_builders::DescribeImages<C, M, R> {
        fluent_builders::DescribeImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSessions` operation.
    ///
    /// See [`DescribeSessions`](crate::client::fluent_builders::DescribeSessions) for more information about the
    /// operation and its arguments.
    pub fn describe_sessions(&self) -> fluent_builders::DescribeSessions<C, M, R> {
        fluent_builders::DescribeSessions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStacks` operation.
    ///
    /// See [`DescribeStacks`](crate::client::fluent_builders::DescribeStacks) for more information about the
    /// operation and its arguments.
    pub fn describe_stacks(&self) -> fluent_builders::DescribeStacks<C, M, R> {
        fluent_builders::DescribeStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUsageReportSubscriptions` operation.
    ///
    /// See [`DescribeUsageReportSubscriptions`](crate::client::fluent_builders::DescribeUsageReportSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn describe_usage_report_subscriptions(
        &self,
    ) -> fluent_builders::DescribeUsageReportSubscriptions<C, M, R> {
        fluent_builders::DescribeUsageReportSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUsers` operation.
    ///
    /// See [`DescribeUsers`](crate::client::fluent_builders::DescribeUsers) for more information about the
    /// operation and its arguments.
    pub fn describe_users(&self) -> fluent_builders::DescribeUsers<C, M, R> {
        fluent_builders::DescribeUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUserStackAssociations` operation.
    ///
    /// See [`DescribeUserStackAssociations`](crate::client::fluent_builders::DescribeUserStackAssociations) for more information about the
    /// operation and its arguments.
    pub fn describe_user_stack_associations(
        &self,
    ) -> fluent_builders::DescribeUserStackAssociations<C, M, R> {
        fluent_builders::DescribeUserStackAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableUser` operation.
    ///
    /// See [`DisableUser`](crate::client::fluent_builders::DisableUser) for more information about the
    /// operation and its arguments.
    pub fn disable_user(&self) -> fluent_builders::DisableUser<C, M, R> {
        fluent_builders::DisableUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateFleet` operation.
    ///
    /// See [`DisassociateFleet`](crate::client::fluent_builders::DisassociateFleet) for more information about the
    /// operation and its arguments.
    pub fn disassociate_fleet(&self) -> fluent_builders::DisassociateFleet<C, M, R> {
        fluent_builders::DisassociateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableUser` operation.
    ///
    /// See [`EnableUser`](crate::client::fluent_builders::EnableUser) for more information about the
    /// operation and its arguments.
    pub fn enable_user(&self) -> fluent_builders::EnableUser<C, M, R> {
        fluent_builders::EnableUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExpireSession` operation.
    ///
    /// See [`ExpireSession`](crate::client::fluent_builders::ExpireSession) for more information about the
    /// operation and its arguments.
    pub fn expire_session(&self) -> fluent_builders::ExpireSession<C, M, R> {
        fluent_builders::ExpireSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociatedFleets` operation.
    ///
    /// See [`ListAssociatedFleets`](crate::client::fluent_builders::ListAssociatedFleets) for more information about the
    /// operation and its arguments.
    pub fn list_associated_fleets(&self) -> fluent_builders::ListAssociatedFleets<C, M, R> {
        fluent_builders::ListAssociatedFleets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociatedStacks` operation.
    ///
    /// See [`ListAssociatedStacks`](crate::client::fluent_builders::ListAssociatedStacks) for more information about the
    /// operation and its arguments.
    pub fn list_associated_stacks(&self) -> fluent_builders::ListAssociatedStacks<C, M, R> {
        fluent_builders::ListAssociatedStacks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFleet` operation.
    ///
    /// See [`StartFleet`](crate::client::fluent_builders::StartFleet) for more information about the
    /// operation and its arguments.
    pub fn start_fleet(&self) -> fluent_builders::StartFleet<C, M, R> {
        fluent_builders::StartFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartImageBuilder` operation.
    ///
    /// See [`StartImageBuilder`](crate::client::fluent_builders::StartImageBuilder) for more information about the
    /// operation and its arguments.
    pub fn start_image_builder(&self) -> fluent_builders::StartImageBuilder<C, M, R> {
        fluent_builders::StartImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopFleet` operation.
    ///
    /// See [`StopFleet`](crate::client::fluent_builders::StopFleet) for more information about the
    /// operation and its arguments.
    pub fn stop_fleet(&self) -> fluent_builders::StopFleet<C, M, R> {
        fluent_builders::StopFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopImageBuilder` operation.
    ///
    /// See [`StopImageBuilder`](crate::client::fluent_builders::StopImageBuilder) for more information about the
    /// operation and its arguments.
    pub fn stop_image_builder(&self) -> fluent_builders::StopImageBuilder<C, M, R> {
        fluent_builders::StopImageBuilder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDirectoryConfig` operation.
    ///
    /// See [`UpdateDirectoryConfig`](crate::client::fluent_builders::UpdateDirectoryConfig) for more information about the
    /// operation and its arguments.
    pub fn update_directory_config(&self) -> fluent_builders::UpdateDirectoryConfig<C, M, R> {
        fluent_builders::UpdateDirectoryConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFleet` operation.
    ///
    /// See [`UpdateFleet`](crate::client::fluent_builders::UpdateFleet) for more information about the
    /// operation and its arguments.
    pub fn update_fleet(&self) -> fluent_builders::UpdateFleet<C, M, R> {
        fluent_builders::UpdateFleet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateImagePermissions` operation.
    ///
    /// See [`UpdateImagePermissions`](crate::client::fluent_builders::UpdateImagePermissions) for more information about the
    /// operation and its arguments.
    pub fn update_image_permissions(&self) -> fluent_builders::UpdateImagePermissions<C, M, R> {
        fluent_builders::UpdateImagePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateStack` operation.
    ///
    /// See [`UpdateStack`](crate::client::fluent_builders::UpdateStack) for more information about the
    /// operation and its arguments.
    pub fn update_stack(&self) -> fluent_builders::UpdateStack<C, M, R> {
        fluent_builders::UpdateStack::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateFleet`.
    ///
    /// <p>Associates the specified fleet with the specified stack.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_fleet_input::Builder,
    }
    impl<C, M, R> AssociateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateFleetInputOperationOutputAlias,
                crate::output::AssociateFleetOutput,
                crate::error::AssociateFleetError,
                crate::input::AssociateFleetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet. </p>
        pub fn fleet_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(inp);
            self
        }
        /// <p>The name of the fleet. </p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateUserStack`.
    ///
    /// <p>Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchAssociateUserStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_associate_user_stack_input::Builder,
    }
    impl<C, M, R> BatchAssociateUserStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchAssociateUserStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateUserStackOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchAssociateUserStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchAssociateUserStackInputOperationOutputAlias,
                crate::output::BatchAssociateUserStackOutput,
                crate::error::BatchAssociateUserStackError,
                crate::input::BatchAssociateUserStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UserStackAssociations`.
        ///
        /// To override the contents of this collection use [`set_user_stack_associations`](Self::set_user_stack_associations).
        ///
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn user_stack_associations(
            mut self,
            inp: impl Into<crate::model::UserStackAssociation>,
        ) -> Self {
            self.inner = self.inner.user_stack_associations(inp);
            self
        }
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn set_user_stack_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_user_stack_associations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateUserStack`.
    ///
    /// <p>Disassociates the specified users from the specified stacks.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDisassociateUserStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_disassociate_user_stack_input::Builder,
    }
    impl<C, M, R> BatchDisassociateUserStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDisassociateUserStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateUserStackOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDisassociateUserStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDisassociateUserStackInputOperationOutputAlias,
                crate::output::BatchDisassociateUserStackOutput,
                crate::error::BatchDisassociateUserStackError,
                crate::input::BatchDisassociateUserStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `UserStackAssociations`.
        ///
        /// To override the contents of this collection use [`set_user_stack_associations`](Self::set_user_stack_associations).
        ///
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn user_stack_associations(
            mut self,
            inp: impl Into<crate::model::UserStackAssociation>,
        ) -> Self {
            self.inner = self.inner.user_stack_associations(inp);
            self
        }
        /// <p>The list of UserStackAssociation objects.</p>
        pub fn set_user_stack_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        ) -> Self {
            self.inner = self.inner.set_user_stack_associations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyImage`.
    ///
    /// <p>Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_image_input::Builder,
    }
    impl<C, M, R> CopyImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyImageInputOperationOutputAlias,
                crate::output::CopyImageOutput,
                crate::error::CopyImageError,
                crate::input::CopyImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image to copy.</p>
        pub fn source_image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_image_name(inp);
            self
        }
        /// <p>The name of the image to copy.</p>
        pub fn set_source_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_image_name(input);
            self
        }
        /// <p>The name that the image will have when it is copied to the destination.</p>
        pub fn destination_image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_image_name(inp);
            self
        }
        /// <p>The name that the image will have when it is copied to the destination.</p>
        pub fn set_destination_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_image_name(input);
            self
        }
        /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
        pub fn destination_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(inp);
            self
        }
        /// <p>The destination region to which the image will be copied. This parameter is required, even if you are copying an image within the same region.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p>The description that the image will have when it is copied to the destination.</p>
        pub fn destination_image_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_image_description(inp);
            self
        }
        /// <p>The description that the image will have when it is copied to the destination.</p>
        pub fn set_destination_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_image_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDirectoryConfig`.
    ///
    /// <p>Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDirectoryConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_directory_config_input::Builder,
    }
    impl<C, M, R> CreateDirectoryConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDirectoryConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDirectoryConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDirectoryConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDirectoryConfigInputOperationOutputAlias,
                crate::output::CreateDirectoryConfigOutput,
                crate::error::CreateDirectoryConfigError,
                crate::input::CreateDirectoryConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn directory_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_name(inp);
            self
        }
        /// <p>The fully qualified name of the directory (for example, corp.example.com).</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_name(input);
            self
        }
        /// Appends an item to `OrganizationalUnitDistinguishedNames`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_distinguished_names`](Self::set_organizational_unit_distinguished_names).
        ///
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn organizational_unit_distinguished_names(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organizational_unit_distinguished_names(inp);
            self
        }
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_organizational_unit_distinguished_names(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn service_account_credentials(
            mut self,
            inp: crate::model::ServiceAccountCredentials,
        ) -> Self {
            self.inner = self.inner.service_account_credentials(inp);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn set_service_account_credentials(
            mut self,
            input: std::option::Option<crate::model::ServiceAccountCredentials>,
        ) -> Self {
            self.inner = self.inner.set_service_account_credentials(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFleet`.
    ///
    /// <p>Creates a fleet. A fleet consists of streaming instances that run a specified image.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_fleet_input::Builder,
    }
    impl<C, M, R> CreateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFleetInputOperationOutputAlias,
                crate::output::CreateFleetOutput,
                crate::error::CreateFleetError,
                crate::input::CreateFleetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the fleet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(inp);
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(inp);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>    
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn instance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(inp);
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>    
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>ALWAYS_ON</dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps.
        /// You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>ON_DEMAND</dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes.
        /// You are charged for instance streaming when users are connected and a
        /// small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn fleet_type(mut self, inp: crate::model::FleetType) -> Self {
            self.inner = self.inner.fleet_type(inp);
            self
        }
        /// <p>The fleet type.</p>
        /// <dl>
        /// <dt>ALWAYS_ON</dt>
        /// <dd>
        /// <p>Provides users with instant-on access to their apps.
        /// You are charged for all running instances in your fleet, even if no users are streaming apps.</p>
        /// </dd>
        /// <dt>ON_DEMAND</dt>
        /// <dd>
        /// <p>Provide users with access to applications after they connect, which takes one to two minutes.
        /// You are charged for instance streaming when users are connected and a
        /// small hourly fee for instances that are not streaming apps.</p>
        /// </dd>
        /// </dl>
        pub fn set_fleet_type(
            mut self,
            input: std::option::Option<crate::model::FleetType>,
        ) -> Self {
            self.inner = self.inner.set_fleet_type(input);
            self
        }
        /// <p>The desired capacity for the fleet.</p>
        pub fn compute_capacity(mut self, inp: crate::model::ComputeCapacity) -> Self {
            self.inner = self.inner.compute_capacity(inp);
            self
        }
        /// <p>The desired capacity for the fleet.</p>
        pub fn set_compute_capacity(
            mut self,
            input: std::option::Option<crate::model::ComputeCapacity>,
        ) -> Self {
            self.inner = self.inner.set_compute_capacity(input);
            self
        }
        /// <p>The VPC configuration for the fleet.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>The VPC configuration for the fleet.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn max_user_duration_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_user_duration_in_seconds(inp);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn set_max_user_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_user_duration_in_seconds(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn disconnect_timeout_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.disconnect_timeout_in_seconds(inp);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn set_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn enable_default_internet_access(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_default_internet_access(inp);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_default_internet_access(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, inp: crate::model::DomainJoinInfo) -> Self {
            self.inner = self.inner.domain_join_info(inp);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.inner = self.inner.set_domain_join_info(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to associate with the fleet. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected
        /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
        /// interval begins. Users are notified before they are disconnected due to inactivity. If
        /// they try to reconnect to the streaming session before the time interval specified in
        /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
        /// previous session. Users are considered idle when they stop providing keyboard or mouse
        /// input during their streaming session. File uploads and downloads, audio in, audio out,
        /// and pixels changing do not qualify as user activity. If users continue to be idle after
        /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
        /// disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
        /// <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn idle_disconnect_timeout_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.idle_disconnect_timeout_in_seconds(inp);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected
        /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
        /// interval begins. Users are notified before they are disconnected due to inactivity. If
        /// they try to reconnect to the streaming session before the time interval specified in
        /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
        /// previous session. Users are considered idle when they stop providing keyboard or mouse
        /// input during their streaming session. File uploads and downloads, audio in, audio out,
        /// and pixels changing do not qualify as user activity. If users continue to be idle after
        /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
        /// disconnected.</p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
        /// <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn set_idle_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_idle_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        ///
        /// <p>The default value is <code>APP</code>.</p>
        pub fn stream_view(mut self, inp: crate::model::StreamView) -> Self {
            self.inner = self.inner.stream_view(inp);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        ///
        /// <p>The default value is <code>APP</code>.</p>
        pub fn set_stream_view(
            mut self,
            input: std::option::Option<crate::model::StreamView>,
        ) -> Self {
            self.inner = self.inner.set_stream_view(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImageBuilder`.
    ///
    /// <p>Creates an image builder. An image builder is a virtual machine that is used to create an image.</p>
    /// <p>The initial state of the builder is <code>PENDING</code>. When it is ready, the state is <code>RUNNING</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_builder_input::Builder,
    }
    impl<C, M, R> CreateImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageBuilderInputOperationOutputAlias,
                crate::output::CreateImageBuilderOutput,
                crate::error::CreateImageBuilderError,
                crate::input::CreateImageBuilderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique name for the image builder.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the image used to create the image builder.</p>
        pub fn image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(inp);
            self
        }
        /// <p>The name of the image used to create the image builder.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(inp);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>   
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn instance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(inp);
            self
        }
        /// <p>The instance type to use when launching the image builder. The following instance types are available:</p>   
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The image builder name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>The VPC configuration for the image builder. You can specify only one subnet.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the image builder. To assume a role, the image builder calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn enable_default_internet_access(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_default_internet_access(inp);
            self
        }
        /// <p>Enables or disables default internet access for the image builder.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_default_internet_access(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, inp: crate::model::DomainJoinInfo) -> Self {
            self.inner = self.inner.domain_join_info(inp);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.inner = self.inner.set_domain_join_info(input);
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn appstream_agent_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.appstream_agent_version(inp);
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_appstream_agent_version(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to associate with the image builder. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `AccessEndpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, inp: impl Into<crate::model::AccessEndpoint>) -> Self {
            self.inner = self.inner.access_endpoints(inp);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Administrators can connect to the image builder only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_access_endpoints(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateImageBuilderStreamingURL`.
    ///
    /// <p>Creates a URL to start an image builder streaming session.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateImageBuilderStreamingURL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_image_builder_streaming_url_input::Builder,
    }
    impl<C, M, R> CreateImageBuilderStreamingURL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateImageBuilderStreamingURL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateImageBuilderStreamingUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateImageBuilderStreamingURLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateImageBuilderStreamingUrlInputOperationOutputAlias,
                crate::output::CreateImageBuilderStreamingUrlOutput,
                crate::error::CreateImageBuilderStreamingURLError,
                crate::input::CreateImageBuilderStreamingUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds.
        /// Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
        pub fn validity(mut self, inp: i64) -> Self {
            self.inner = self.inner.validity(inp);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds.
        /// Specify a value between 1 and 604800 seconds. The default is 3600 seconds.</p>
        pub fn set_validity(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStack`.
    ///
    /// <p>Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_stack_input::Builder,
    }
    impl<C, M, R> CreateStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStackOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStackInputOperationOutputAlias,
                crate::output::CreateStackOutput,
                crate::error::CreateStackError,
                crate::input::CreateStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The stack name to display.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The stack name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// Appends an item to `StorageConnectors`.
        ///
        /// To override the contents of this collection use [`set_storage_connectors`](Self::set_storage_connectors).
        ///
        /// <p>The storage connectors to enable.</p>
        pub fn storage_connectors(
            mut self,
            inp: impl Into<crate::model::StorageConnector>,
        ) -> Self {
            self.inner = self.inner.storage_connectors(inp);
            self
        }
        /// <p>The storage connectors to enable.</p>
        pub fn set_storage_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        ) -> Self {
            self.inner = self.inner.set_storage_connectors(input);
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn redirect_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.redirect_url(inp);
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn set_redirect_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_redirect_url(input);
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn feedback_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feedback_url(inp);
            self
        }
        /// <p>The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn set_feedback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feedback_url(input);
            self
        }
        /// Appends an item to `UserSettings`.
        ///
        /// To override the contents of this collection use [`set_user_settings`](Self::set_user_settings).
        ///
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
        pub fn user_settings(mut self, inp: impl Into<crate::model::UserSetting>) -> Self {
            self.inner = self.inner.user_settings(inp);
            self
        }
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled. </p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        ) -> Self {
            self.inner = self.inner.set_user_settings(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn application_settings(mut self, inp: crate::model::ApplicationSettings) -> Self {
            self.inner = self.inner.application_settings(inp);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn set_application_settings(
            mut self,
            input: std::option::Option<crate::model::ApplicationSettings>,
        ) -> Self {
            self.inner = self.inner.set_application_settings(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        ///
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to associate with the stack. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        ///
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `AccessEndpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, inp: impl Into<crate::model::AccessEndpoint>) -> Self {
            self.inner = self.inner.access_endpoints(inp);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_access_endpoints(input);
            self
        }
        /// Appends an item to `EmbedHostDomains`.
        ///
        /// To override the contents of this collection use [`set_embed_host_domains`](Self::set_embed_host_domains).
        ///
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn embed_host_domains(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed_host_domains(inp);
            self
        }
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn set_embed_host_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed_host_domains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateStreamingURL`.
    ///
    /// <p>Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateStreamingURL<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_streaming_url_input::Builder,
    }
    impl<C, M, R> CreateStreamingURL<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateStreamingURL`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateStreamingUrlOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateStreamingURLError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateStreamingUrlInputOperationOutputAlias,
                crate::output::CreateStreamingUrlOutput,
                crate::error::CreateStreamingURLError,
                crate::input::CreateStreamingUrlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(inp);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The name of the application to launch after the session starts. This is the name that you specified
        /// as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
        pub fn application_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.application_id(inp);
            self
        }
        /// <p>The name of the application to launch after the session starts. This is the name that you specified
        /// as <b>Name</b> in the Image Assistant. If your fleet is enabled for the <b>Desktop</b> stream view, you can also choose to launch directly to the operating system desktop. To do so, specify <b>Desktop</b>.</p>
        pub fn set_application_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_application_id(input);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds.
        /// Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
        pub fn validity(mut self, inp: i64) -> Self {
            self.inner = self.inner.validity(inp);
            self
        }
        /// <p>The time that the streaming URL will be valid, in seconds.
        /// Specify a value between 1 and 604800 seconds. The default is 60 seconds.</p>
        pub fn set_validity(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
        /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn session_context(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_context(inp);
            self
        }
        /// <p>The session context. For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters">Session Context</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_session_context(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_session_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUpdatedImage`.
    ///
    /// <p>Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.</p>
    ///
    /// <p>For more information, see the "Update an Image by Using
    /// Managed AppStream 2.0 Image Updates" section in <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html">Administer Your AppStream 2.0 Images</a>, in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUpdatedImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_updated_image_input::Builder,
    }
    impl<C, M, R> CreateUpdatedImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUpdatedImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUpdatedImageOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUpdatedImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUpdatedImageInputOperationOutputAlias,
                crate::output::CreateUpdatedImageOutput,
                crate::error::CreateUpdatedImageError,
                crate::input::CreateUpdatedImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image to update.</p>
        pub fn existing_image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.existing_image_name(inp);
            self
        }
        /// <p>The name of the image to update.</p>
        pub fn set_existing_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_existing_image_name(input);
            self
        }
        /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
        pub fn new_image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_image_name(inp);
            self
        }
        /// <p>The name of the new image. The name must be unique within the AWS account and Region.</p>
        pub fn set_new_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_image_name(input);
            self
        }
        /// <p>The description to display for the new image.</p>
        pub fn new_image_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_image_description(inp);
            self
        }
        /// <p>The description to display for the new image.</p>
        pub fn set_new_image_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_image_description(input);
            self
        }
        /// <p>The name to display for the new image.</p>
        pub fn new_image_display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_image_display_name(inp);
            self
        }
        /// <p>The name to display for the new image.</p>
        pub fn set_new_image_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_image_display_name(input);
            self
        }
        /// Adds a key-value pair to `newImageTags`.
        ///
        /// To override the contents of this collection use [`set_new_image_tags`](Self::set_new_image_tags).
        ///
        /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn new_image_tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.new_image_tags(k, v);
            self
        }
        /// <p>The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_new_image_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_new_image_tags(input);
            self
        }
        /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of creating a new updated image without displaying whether image updates are available.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsageReportSubscription`.
    ///
    /// <p>Creates a usage report subscription. Usage reports are generated daily.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUsageReportSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_usage_report_subscription_input::Builder,
    }
    impl<C, M, R> CreateUsageReportSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUsageReportSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsageReportSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsageReportSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUsageReportSubscriptionInputOperationOutputAlias,
                crate::output::CreateUsageReportSubscriptionOutput,
                crate::error::CreateUsageReportSubscriptionError,
                crate::input::CreateUsageReportSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a new user in the user pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
        /// </note>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p>
        ///
        /// <note>
        /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
        /// </note>
        pub fn message_action(mut self, inp: crate::model::MessageAction) -> Self {
            self.inner = self.inner.message_action(inp);
            self
        }
        /// <p>The action to take for the welcome email that is sent to a user after the user is created in the user pool. If you specify SUPPRESS, no email is sent. If you specify RESEND, do not specify the first name or last name of the user. If the value is null, the email is sent. </p>
        ///
        /// <note>
        /// <p>The temporary password in the welcome email is valid for only 7 days. If users don’t set their passwords within 7 days, you must send them a new welcome email.</p>
        /// </note>
        pub fn set_message_action(
            mut self,
            input: std::option::Option<crate::model::MessageAction>,
        ) -> Self {
            self.inner = self.inner.set_message_action(input);
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn first_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(inp);
            self
        }
        /// <p>The first name, or given name, of the user.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn last_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(inp);
            self
        }
        /// <p>The last name, or surname, of the user.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL. </p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL. </p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDirectoryConfig`.
    ///
    /// <p>Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDirectoryConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_directory_config_input::Builder,
    }
    impl<C, M, R> DeleteDirectoryConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDirectoryConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDirectoryConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDirectoryConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDirectoryConfigInputOperationOutputAlias,
                crate::output::DeleteDirectoryConfigOutput,
                crate::error::DeleteDirectoryConfigError,
                crate::input::DeleteDirectoryConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the directory configuration.</p>
        pub fn directory_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_name(inp);
            self
        }
        /// <p>The name of the directory configuration.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFleet`.
    ///
    /// <p>Deletes the specified fleet.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_fleet_input::Builder,
    }
    impl<C, M, R> DeleteFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFleetInputOperationOutputAlias,
                crate::output::DeleteFleetOutput,
                crate::error::DeleteFleetError,
                crate::input::DeleteFleetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImage`.
    ///
    /// <p>Deletes the specified image. You cannot delete an image when it is in use.  
    /// After you delete an image, you cannot provision new capacity using the image.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteImage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_input::Builder,
    }
    impl<C, M, R> DeleteImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageInputOperationOutputAlias,
                crate::output::DeleteImageOutput,
                crate::error::DeleteImageError,
                crate::input::DeleteImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImageBuilder`.
    ///
    /// <p>Deletes the specified image builder and releases the capacity.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_builder_input::Builder,
    }
    impl<C, M, R> DeleteImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImageBuilderInputOperationOutputAlias,
                crate::output::DeleteImageBuilderOutput,
                crate::error::DeleteImageBuilderError,
                crate::input::DeleteImageBuilderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteImagePermissions`.
    ///
    /// <p>Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteImagePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_image_permissions_input::Builder,
    }
    impl<C, M, R> DeleteImagePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteImagePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteImagePermissionsInputOperationOutputAlias,
                crate::output::DeleteImagePermissionsOutput,
                crate::error::DeleteImagePermissionsError,
                crate::input::DeleteImagePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the private image.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the private image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
        pub fn shared_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_account_id(inp);
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which to delete image permissions.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteStack`.
    ///
    /// <p>Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_stack_input::Builder,
    }
    impl<C, M, R> DeleteStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteStackOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteStackInputOperationOutputAlias,
                crate::output::DeleteStackOutput,
                crate::error::DeleteStackError,
                crate::input::DeleteStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsageReportSubscription`.
    ///
    /// <p>Disables usage report generation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUsageReportSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_usage_report_subscription_input::Builder,
    }
    impl<C, M, R> DeleteUsageReportSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUsageReportSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsageReportSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsageReportSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUsageReportSubscriptionInputOperationOutputAlias,
                crate::output::DeleteUsageReportSubscriptionOutput,
                crate::error::DeleteUsageReportSubscriptionError,
                crate::input::DeleteUsageReportSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user from the user pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDirectoryConfigs`.
    ///
    /// <p>Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
    /// </p>
    /// <p>Although the response syntax in this topic includes the account password, this password is not returned in the actual response.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDirectoryConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_directory_configs_input::Builder,
    }
    impl<C, M, R> DescribeDirectoryConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDirectoryConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDirectoryConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDirectoryConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDirectoryConfigsInputOperationOutputAlias,
                crate::output::DescribeDirectoryConfigsOutput,
                crate::error::DescribeDirectoryConfigsError,
                crate::input::DescribeDirectoryConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `DirectoryNames`.
        ///
        /// To override the contents of this collection use [`set_directory_names`](Self::set_directory_names).
        ///
        /// <p>The directory names.</p>
        pub fn directory_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_names(inp);
            self
        }
        /// <p>The directory names.</p>
        pub fn set_directory_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_directory_names(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFleets`.
    ///
    /// <p>Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeFleets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_fleets_input::Builder,
    }
    impl<C, M, R> DescribeFleets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFleetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFleetsInputOperationOutputAlias,
                crate::output::DescribeFleetsOutput,
                crate::error::DescribeFleetsError,
                crate::input::DescribeFleetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the fleets to describe.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>The names of the fleets to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImageBuilders`.
    ///
    /// <p>Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImageBuilders<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_builders_input::Builder,
    }
    impl<C, M, R> DescribeImageBuilders<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImageBuilders`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImageBuildersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImageBuildersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImageBuildersInputOperationOutputAlias,
                crate::output::DescribeImageBuildersOutput,
                crate::error::DescribeImageBuildersError,
                crate::input::DescribeImageBuildersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the image builders to describe.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>The names of the image builders to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImagePermissions`.
    ///
    /// <p>Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImagePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_image_permissions_input::Builder,
    }
    impl<C, M, R> DescribeImagePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImagePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImagePermissionsInputOperationOutputAlias,
                crate::output::DescribeImagePermissionsOutput,
                crate::error::DescribeImagePermissionsError,
                crate::input::DescribeImagePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the private image for which to describe permissions. The image must be one that you own. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `SharedAwsAccountIds`.
        ///
        /// To override the contents of this collection use [`set_shared_aws_account_ids`](Self::set_shared_aws_account_ids).
        ///
        /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
        pub fn shared_aws_account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_aws_account_ids(inp);
            self
        }
        /// <p>The 12-digit identifier of one or more AWS accounts with which the image is shared.</p>
        pub fn set_shared_aws_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_shared_aws_account_ids(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeImages`.
    ///
    /// <p>Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeImages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_images_input::Builder,
    }
    impl<C, M, R> DescribeImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeImagesInputOperationOutputAlias,
                crate::output::DescribeImagesOutput,
                crate::error::DescribeImagesError,
                crate::input::DescribeImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the public or private images to describe.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>The names of the public or private images to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// Appends an item to `Arns`.
        ///
        /// To override the contents of this collection use [`set_arns`](Self::set_arns).
        ///
        /// <p>The ARNs of the public, private, and shared images to describe.</p>
        pub fn arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arns(inp);
            self
        }
        /// <p>The ARNs of the public, private, and shared images to describe.</p>
        pub fn set_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_arns(input);
            self
        }
        /// <p>The type of image (public, private, or shared) to describe. </p>
        pub fn r#type(mut self, inp: crate::model::VisibilityType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of image (public, private, or shared) to describe. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::VisibilityType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSessions`.
    ///
    /// <p>Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet,
    /// only streaming sessions for that user are described. If an authentication type is not provided,
    /// the default is to authenticate users using a streaming URL.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSessions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_sessions_input::Builder,
    }
    impl<C, M, R> DescribeSessions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSessions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSessionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSessionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSessionsInputOperationOutputAlias,
                crate::output::DescribeSessionsOutput,
                crate::error::DescribeSessionsError,
                crate::input::DescribeSessionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack. This value is case-sensitive.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack. This value is case-sensitive.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The name of the fleet. This value is case-sensitive.</p>
        pub fn fleet_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(inp);
            self
        }
        /// <p>The name of the fleet. This value is case-sensitive.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The user identifier (ID). If you specify a user ID, you must also specify the authentication type.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The size of each page of results. The default value is 20 and the maximum value is 50.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The authentication method. Specify <code>API</code> for a user
        /// authenticated using a streaming URL or <code>SAML</code> for a SAML federated user.
        /// The default is to authenticate users using a streaming URL.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication method. Specify <code>API</code> for a user
        /// authenticated using a streaming URL or <code>SAML</code> for a SAML federated user.
        /// The default is to authenticate users using a streaming URL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStacks`.
    ///
    /// <p>Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStacks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_stacks_input::Builder,
    }
    impl<C, M, R> DescribeStacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStacksInputOperationOutputAlias,
                crate::output::DescribeStacksOutput,
                crate::error::DescribeStacksError,
                crate::input::DescribeStacksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names of the stacks to describe.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>The names of the stacks to describe.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsageReportSubscriptions`.
    ///
    /// <p>Retrieves a list that describes one or more usage report subscriptions.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUsageReportSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_usage_report_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeUsageReportSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUsageReportSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsageReportSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsageReportSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUsageReportSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeUsageReportSubscriptionsOutput,
                crate::error::DescribeUsageReportSubscriptionsError,
                crate::input::DescribeUsageReportSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsers`.
    ///
    /// <p>Retrieves a list that describes one or more specified users in the user pool.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_users_input::Builder,
    }
    impl<C, M, R> DescribeUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUsersInputOperationOutputAlias,
                crate::output::DescribeUsersOutput,
                crate::error::DescribeUsersError,
                crate::input::DescribeUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication type for the users in the user pool to describe. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserStackAssociations`.
    ///
    /// <p>Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:</p>
    /// <ul>
    /// <li>
    /// <p>The stack name</p>
    /// </li>
    /// <li>
    /// <p>The user name (email address of the user associated with the stack) and the authentication type for the user</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUserStackAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_stack_associations_input::Builder,
    }
    impl<C, M, R> DescribeUserStackAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserStackAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserStackAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserStackAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserStackAssociationsInputOperationOutputAlias,
                crate::output::DescribeUserStackAssociationsOutput,
                crate::error::DescribeUserStackAssociationsError,
                crate::input::DescribeUserStackAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack that is associated with the user.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The email address of the user who is associated with the stack.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication type for the user who is associated with the stack. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum size of each page of results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableUser`.
    ///
    /// <p>Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user. </p>
    #[derive(std::fmt::Debug)]
    pub struct DisableUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_user_input::Builder,
    }
    impl<C, M, R> DisableUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableUserInputOperationOutputAlias,
                crate::output::DisableUserOutput,
                crate::error::DisableUserError,
                crate::input::DisableUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive.</p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFleet`.
    ///
    /// <p>Disassociates the specified fleet from the specified stack.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_fleet_input::Builder,
    }
    impl<C, M, R> DisassociateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFleetInputOperationOutputAlias,
                crate::output::DisassociateFleetOutput,
                crate::error::DisassociateFleetError,
                crate::input::DisassociateFleetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(inp);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableUser`.
    ///
    /// <p>Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableUser<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_user_input::Builder,
    }
    impl<C, M, R> EnableUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableUserOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableUserInputOperationOutputAlias,
                crate::output::EnableUserOutput,
                crate::error::EnableUserError,
                crate::input::EnableUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
        /// </note>
        pub fn user_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_name(inp);
            self
        }
        /// <p>The email address of the user.</p>
        ///
        /// <note>
        /// <p>Users' email addresses are case-sensitive. During login, if they specify an email address that doesn't use the same capitalization as the email address specified when their user pool account was created, a "user does not exist" error message displays. </p>
        /// </note>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_name(input);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn authentication_type(mut self, inp: crate::model::AuthenticationType) -> Self {
            self.inner = self.inner.authentication_type(inp);
            self
        }
        /// <p>The authentication type for the user. You must specify USERPOOL.</p>
        pub fn set_authentication_type(
            mut self,
            input: std::option::Option<crate::model::AuthenticationType>,
        ) -> Self {
            self.inner = self.inner.set_authentication_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExpireSession`.
    ///
    /// <p>Immediately stops the specified streaming session.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExpireSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::expire_session_input::Builder,
    }
    impl<C, M, R> ExpireSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExpireSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExpireSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExpireSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExpireSessionInputOperationOutputAlias,
                crate::output::ExpireSessionOutput,
                crate::error::ExpireSessionError,
                crate::input::ExpireSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the streaming session.</p>
        pub fn session_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.session_id(inp);
            self
        }
        /// <p>The identifier of the streaming session.</p>
        pub fn set_session_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_session_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedFleets`.
    ///
    /// <p>Retrieves the name of the fleet that is associated with the specified stack.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociatedFleets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_fleets_input::Builder,
    }
    impl<C, M, R> ListAssociatedFleets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedFleets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedFleetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedFleetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedFleetsInputOperationOutputAlias,
                crate::output::ListAssociatedFleetsOutput,
                crate::error::ListAssociatedFleetsError,
                crate::input::ListAssociatedFleetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the stack.</p>
        pub fn stack_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stack_name(inp);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_stack_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stack_name(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedStacks`.
    ///
    /// <p>Retrieves the name of the stack with which the specified fleet is associated.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociatedStacks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_stacks_input::Builder,
    }
    impl<C, M, R> ListAssociatedStacks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedStacks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedStacksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAssociatedStacksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociatedStacksInputOperationOutputAlias,
                crate::output::ListAssociatedStacksOutput,
                crate::error::ListAssociatedStacksError,
                crate::input::ListAssociatedStacksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn fleet_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.fleet_name(inp);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_fleet_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_fleet_name(input);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFleet`.
    ///
    /// <p>Starts the specified fleet.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_fleet_input::Builder,
    }
    impl<C, M, R> StartFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFleetInputOperationOutputAlias,
                crate::output::StartFleetOutput,
                crate::error::StartFleetError,
                crate::input::StartFleetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartImageBuilder`.
    ///
    /// <p>Starts the specified image builder.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_image_builder_input::Builder,
    }
    impl<C, M, R> StartImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::StartImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartImageBuilderInputOperationOutputAlias,
                crate::output::StartImageBuilderOutput,
                crate::error::StartImageBuilderError,
                crate::input::StartImageBuilderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn appstream_agent_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.appstream_agent_version(inp);
            self
        }
        /// <p>The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream 2.0 agent, specify [LATEST]. </p>
        pub fn set_appstream_agent_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_appstream_agent_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFleet`.
    ///
    /// <p>Stops the specified fleet.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_fleet_input::Builder,
    }
    impl<C, M, R> StopFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopFleetInputOperationOutputAlias,
                crate::output::StopFleetOutput,
                crate::error::StopFleetError,
                crate::input::StopFleetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the fleet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopImageBuilder`.
    ///
    /// <p>Stops the specified image builder.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopImageBuilder<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_image_builder_input::Builder,
    }
    impl<C, M, R> StopImageBuilder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopImageBuilder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopImageBuilderOutput,
            aws_smithy_http::result::SdkError<crate::error::StopImageBuilderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopImageBuilderInputOperationOutputAlias,
                crate::output::StopImageBuilderOutput,
                crate::error::StopImageBuilderError,
                crate::input::StopImageBuilderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image builder.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the image builder.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.</p>
    /// <p>Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
    /// this operation updates its value.</p>
    ///
    /// <p>To list the current tags for your resources, use <a>ListTagsForResource</a>.
    /// To disassociate tags from your resources, use <a>UntagResource</a>.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to associate. A tag is a key-value pair, and the value is optional. For example, Environment=Test. If you do not specify a value, Environment=. </p>
        ///
        /// <p>If you do not specify a value, the value is set to an empty string.</p>
        ///
        /// <p>Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special characters: </p>
        /// <p>_ . : / = + \ - @</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Disassociates one or more specified tags from the specified AppStream 2.0 resource.</p>
    /// <p>To list the current tags for your resources, use <a>ListTagsForResource</a>.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys for the tags to disassociate.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys for the tags to disassociate.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDirectoryConfig`.
    ///
    /// <p>Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDirectoryConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_directory_config_input::Builder,
    }
    impl<C, M, R> UpdateDirectoryConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDirectoryConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDirectoryConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDirectoryConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDirectoryConfigInputOperationOutputAlias,
                crate::output::UpdateDirectoryConfigOutput,
                crate::error::UpdateDirectoryConfigError,
                crate::input::UpdateDirectoryConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Directory Config object.</p>
        pub fn directory_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_name(inp);
            self
        }
        /// <p>The name of the Directory Config object.</p>
        pub fn set_directory_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_name(input);
            self
        }
        /// Appends an item to `OrganizationalUnitDistinguishedNames`.
        ///
        /// To override the contents of this collection use [`set_organizational_unit_distinguished_names`](Self::set_organizational_unit_distinguished_names).
        ///
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn organizational_unit_distinguished_names(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.organizational_unit_distinguished_names(inp);
            self
        }
        /// <p>The distinguished names of the organizational units for computer accounts.</p>
        pub fn set_organizational_unit_distinguished_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self
                .inner
                .set_organizational_unit_distinguished_names(input);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn service_account_credentials(
            mut self,
            inp: crate::model::ServiceAccountCredentials,
        ) -> Self {
            self.inner = self.inner.service_account_credentials(inp);
            self
        }
        /// <p>The credentials for the service account used by the fleet or image builder to connect to the directory.</p>
        pub fn set_service_account_credentials(
            mut self,
            input: std::option::Option<crate::model::ServiceAccountCredentials>,
        ) -> Self {
            self.inner = self.inner.set_service_account_credentials(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFleet`.
    ///
    /// <p>Updates the specified fleet.</p>
    /// <p>If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name.
    /// If the fleet is in the <code>RUNNING</code> state, you can update the <code>DisplayName</code>, <code>ComputeCapacity</code>, <code>ImageARN</code>, <code>ImageName</code>, <code>IdleDisconnectTimeoutInSeconds</code>, and <code>DisconnectTimeoutInSeconds</code> attributes.
    /// If the fleet is in the <code>STARTING</code> or <code>STOPPING</code> state, you can't update it.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFleet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_fleet_input::Builder,
    }
    impl<C, M, R> UpdateFleet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFleet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFleetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFleetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFleetInputOperationOutputAlias,
                crate::output::UpdateFleetOutput,
                crate::error::UpdateFleetError,
                crate::input::UpdateFleetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_name(inp);
            self
        }
        /// <p>The name of the image used to create the fleet.</p>
        pub fn set_image_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_name(input);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn image_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_arn(inp);
            self
        }
        /// <p>The ARN of the public, private, or shared image to use.</p>
        pub fn set_image_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image_arn(input);
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A unique name for the fleet.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn instance_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_type(inp);
            self
        }
        /// <p>The instance type to use when launching fleet instances. The following instance types are available:</p>
        /// <ul>
        /// <li>
        /// <p>stream.standard.small</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.medium</p>
        /// </li>
        /// <li>
        /// <p>stream.standard.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.large</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.compute.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.large</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.3xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.6xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.memory.z1d.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.large</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-design.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-desktop.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.2xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.12xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics.g4dn.16xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.4xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.8xlarge</p>
        /// </li>
        /// <li>
        /// <p>stream.graphics-pro.16xlarge</p>
        /// </li>
        /// </ul>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_type(input);
            self
        }
        /// <p>The desired capacity for the fleet.</p>
        pub fn compute_capacity(mut self, inp: crate::model::ComputeCapacity) -> Self {
            self.inner = self.inner.compute_capacity(inp);
            self
        }
        /// <p>The desired capacity for the fleet.</p>
        pub fn set_compute_capacity(
            mut self,
            input: std::option::Option<crate::model::ComputeCapacity>,
        ) -> Self {
            self.inner = self.inner.set_compute_capacity(input);
            self
        }
        /// <p>The VPC configuration for the fleet.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>The VPC configuration for the fleet.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn max_user_duration_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_user_duration_in_seconds(inp);
            self
        }
        /// <p>The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.</p>
        /// <p>Specify a value between 600 and 360000.</p>
        pub fn set_max_user_duration_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_user_duration_in_seconds(input);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn disconnect_timeout_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.disconnect_timeout_in_seconds(inp);
            self
        }
        /// <p>The amount of time that a streaming session remains active after users disconnect. If users try to reconnect to the streaming session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new streaming instance. </p>
        /// <p>Specify a value between 60 and 360000.</p>
        pub fn set_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_disconnect_timeout_in_seconds(input);
            self
        }
        /// <p>Deletes the VPC association for the specified fleet.</p>
        pub fn delete_vpc_config(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_vpc_config(inp);
            self
        }
        /// <p>Deletes the VPC association for the specified fleet.</p>
        pub fn set_delete_vpc_config(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_vpc_config(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The fleet name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn enable_default_internet_access(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_default_internet_access(inp);
            self
        }
        /// <p>Enables or disables default internet access for the fleet.</p>
        pub fn set_enable_default_internet_access(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_default_internet_access(input);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn domain_join_info(mut self, inp: crate::model::DomainJoinInfo) -> Self {
            self.inner = self.inner.domain_join_info(inp);
            self
        }
        /// <p>The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. </p>
        pub fn set_domain_join_info(
            mut self,
            input: std::option::Option<crate::model::DomainJoinInfo>,
        ) -> Self {
            self.inner = self.inner.set_domain_join_info(input);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected
        /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
        /// interval begins. Users are notified before they are disconnected due to inactivity. If
        /// users try to reconnect to the streaming session before the time interval specified in
        /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
        /// previous session. Users are considered idle when they stop providing keyboard or mouse
        /// input during their streaming session. File uploads and downloads, audio in, audio out,
        /// and pixels changing do not qualify as user activity. If users continue to be idle after
        /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
        /// disconnected. </p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
        ///
        /// <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn idle_disconnect_timeout_in_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.idle_disconnect_timeout_in_seconds(inp);
            self
        }
        /// <p>The amount of time that users can be idle (inactive) before they are disconnected
        /// from their streaming session and the <code>DisconnectTimeoutInSeconds</code> time
        /// interval begins. Users are notified before they are disconnected due to inactivity. If
        /// users try to reconnect to the streaming session before the time interval specified in
        /// <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
        /// previous session. Users are considered idle when they stop providing keyboard or mouse
        /// input during their streaming session. File uploads and downloads, audio in, audio out,
        /// and pixels changing do not qualify as user activity. If users continue to be idle after
        /// the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are
        /// disconnected. </p>
        /// <p>To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value between 60 and 3600. The default value is 0.</p>
        ///
        /// <note>
        /// <p>If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of inactivity. </p>
        /// </note>
        pub fn set_idle_disconnect_timeout_in_seconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_idle_disconnect_timeout_in_seconds(input);
            self
        }
        /// Appends an item to `AttributesToDelete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The fleet attributes to delete.</p>
        pub fn attributes_to_delete(
            mut self,
            inp: impl Into<crate::model::FleetAttribute>,
        ) -> Self {
            self.inner = self.inner.attributes_to_delete(inp);
            self
        }
        /// <p>The fleet attributes to delete.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FleetAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_delete(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn iam_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To assume a role, a fleet instance calls the AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
        ///
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html">Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.</p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role_arn(input);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        ///
        /// <p>The default value is <code>APP</code>.</p>
        pub fn stream_view(mut self, inp: crate::model::StreamView) -> Self {
            self.inner = self.inner.stream_view(inp);
            self
        }
        /// <p>The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system displays.</p>
        ///
        /// <p>The default value is <code>APP</code>.</p>
        pub fn set_stream_view(
            mut self,
            input: std::option::Option<crate::model::StreamView>,
        ) -> Self {
            self.inner = self.inner.set_stream_view(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateImagePermissions`.
    ///
    /// <p>Adds or updates permissions for the specified private image. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateImagePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_image_permissions_input::Builder,
    }
    impl<C, M, R> UpdateImagePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateImagePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateImagePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateImagePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateImagePermissionsInputOperationOutputAlias,
                crate::output::UpdateImagePermissionsOutput,
                crate::error::UpdateImagePermissionsError,
                crate::input::UpdateImagePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the private image.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the private image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
        pub fn shared_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.shared_account_id(inp);
            self
        }
        /// <p>The 12-digit identifier of the AWS account for which you want add or update image permissions.</p>
        pub fn set_shared_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_shared_account_id(input);
            self
        }
        /// <p>The permissions for the image.</p>
        pub fn image_permissions(mut self, inp: crate::model::ImagePermissions) -> Self {
            self.inner = self.inner.image_permissions(inp);
            self
        }
        /// <p>The permissions for the image.</p>
        pub fn set_image_permissions(
            mut self,
            input: std::option::Option<crate::model::ImagePermissions>,
        ) -> Self {
            self.inner = self.inner.set_image_permissions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateStack`.
    ///
    /// <p>Updates the specified fields for the specified stack.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateStack<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_stack_input::Builder,
    }
    impl<C, M, R> UpdateStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateStackOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateStackInputOperationOutputAlias,
                crate::output::UpdateStackOutput,
                crate::error::UpdateStackError,
                crate::input::UpdateStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The stack name to display.</p>
        pub fn display_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.display_name(inp);
            self
        }
        /// <p>The stack name to display.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_display_name(input);
            self
        }
        /// <p>The description to display.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description to display.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `StorageConnectors`.
        ///
        /// To override the contents of this collection use [`set_storage_connectors`](Self::set_storage_connectors).
        ///
        /// <p>The storage connectors to enable.</p>
        pub fn storage_connectors(
            mut self,
            inp: impl Into<crate::model::StorageConnector>,
        ) -> Self {
            self.inner = self.inner.storage_connectors(inp);
            self
        }
        /// <p>The storage connectors to enable.</p>
        pub fn set_storage_connectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StorageConnector>>,
        ) -> Self {
            self.inner = self.inner.set_storage_connectors(input);
            self
        }
        /// <p>Deletes the storage connectors currently enabled for the stack.</p>
        pub fn delete_storage_connectors(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_storage_connectors(inp);
            self
        }
        /// <p>Deletes the storage connectors currently enabled for the stack.</p>
        pub fn set_delete_storage_connectors(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_storage_connectors(input);
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn redirect_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.redirect_url(inp);
            self
        }
        /// <p>The URL that users are redirected to after their streaming session ends.</p>
        pub fn set_redirect_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_redirect_url(input);
            self
        }
        /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn feedback_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feedback_url(inp);
            self
        }
        /// <p>The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.</p>
        pub fn set_feedback_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feedback_url(input);
            self
        }
        /// Appends an item to `AttributesToDelete`.
        ///
        /// To override the contents of this collection use [`set_attributes_to_delete`](Self::set_attributes_to_delete).
        ///
        /// <p>The stack attributes to delete.</p>
        pub fn attributes_to_delete(
            mut self,
            inp: impl Into<crate::model::StackAttribute>,
        ) -> Self {
            self.inner = self.inner.attributes_to_delete(inp);
            self
        }
        /// <p>The stack attributes to delete.</p>
        pub fn set_attributes_to_delete(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StackAttribute>>,
        ) -> Self {
            self.inner = self.inner.set_attributes_to_delete(input);
            self
        }
        /// Appends an item to `UserSettings`.
        ///
        /// To override the contents of this collection use [`set_user_settings`](Self::set_user_settings).
        ///
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
        pub fn user_settings(mut self, inp: impl Into<crate::model::UserSetting>) -> Self {
            self.inner = self.inner.user_settings(inp);
            self
        }
        /// <p>The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.</p>
        pub fn set_user_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserSetting>>,
        ) -> Self {
            self.inner = self.inner.set_user_settings(input);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn application_settings(mut self, inp: crate::model::ApplicationSettings) -> Self {
            self.inner = self.inner.application_settings(inp);
            self
        }
        /// <p>The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.</p>
        pub fn set_application_settings(
            mut self,
            input: std::option::Option<crate::model::ApplicationSettings>,
        ) -> Self {
            self.inner = self.inner.set_application_settings(input);
            self
        }
        /// Appends an item to `AccessEndpoints`.
        ///
        /// To override the contents of this collection use [`set_access_endpoints`](Self::set_access_endpoints).
        ///
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn access_endpoints(mut self, inp: impl Into<crate::model::AccessEndpoint>) -> Self {
            self.inner = self.inner.access_endpoints(inp);
            self
        }
        /// <p>The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.</p>
        pub fn set_access_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccessEndpoint>>,
        ) -> Self {
            self.inner = self.inner.set_access_endpoints(input);
            self
        }
        /// Appends an item to `EmbedHostDomains`.
        ///
        /// To override the contents of this collection use [`set_embed_host_domains`](Self::set_embed_host_domains).
        ///
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn embed_host_domains(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.embed_host_domains(inp);
            self
        }
        /// <p>The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions. </p>
        pub fn set_embed_host_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_embed_host_domains(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
