// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateStackOutput {
    /// <p>Information about the stack.</p>
    pub stack: std::option::Option<crate::model::Stack>,
}
impl UpdateStackOutput {
    /// <p>Information about the stack.</p>
    pub fn stack(&self) -> std::option::Option<&crate::model::Stack> {
        self.stack.as_ref()
    }
}
impl std::fmt::Debug for UpdateStackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateStackOutput");
        formatter.field("stack", &self.stack);
        formatter.finish()
    }
}
/// See [`UpdateStackOutput`](crate::output::UpdateStackOutput)
pub mod update_stack_output {
    /// A builder for [`UpdateStackOutput`](crate::output::UpdateStackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack: std::option::Option<crate::model::Stack>,
    }
    impl Builder {
        /// <p>Information about the stack.</p>
        pub fn stack(mut self, input: crate::model::Stack) -> Self {
            self.stack = Some(input);
            self
        }
        /// <p>Information about the stack.</p>
        pub fn set_stack(mut self, input: std::option::Option<crate::model::Stack>) -> Self {
            self.stack = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateStackOutput`](crate::output::UpdateStackOutput)
        pub fn build(self) -> crate::output::UpdateStackOutput {
            crate::output::UpdateStackOutput { stack: self.stack }
        }
    }
}
impl UpdateStackOutput {
    /// Creates a new builder-style object to manufacture [`UpdateStackOutput`](crate::output::UpdateStackOutput)
    pub fn builder() -> crate::output::update_stack_output::Builder {
        crate::output::update_stack_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateImagePermissionsOutput {}
impl std::fmt::Debug for UpdateImagePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateImagePermissionsOutput");
        formatter.finish()
    }
}
/// See [`UpdateImagePermissionsOutput`](crate::output::UpdateImagePermissionsOutput)
pub mod update_image_permissions_output {
    /// A builder for [`UpdateImagePermissionsOutput`](crate::output::UpdateImagePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateImagePermissionsOutput`](crate::output::UpdateImagePermissionsOutput)
        pub fn build(self) -> crate::output::UpdateImagePermissionsOutput {
            crate::output::UpdateImagePermissionsOutput {}
        }
    }
}
impl UpdateImagePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`UpdateImagePermissionsOutput`](crate::output::UpdateImagePermissionsOutput)
    pub fn builder() -> crate::output::update_image_permissions_output::Builder {
        crate::output::update_image_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFleetOutput {
    /// <p>Information about the fleet.</p>
    pub fleet: std::option::Option<crate::model::Fleet>,
}
impl UpdateFleetOutput {
    /// <p>Information about the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&crate::model::Fleet> {
        self.fleet.as_ref()
    }
}
impl std::fmt::Debug for UpdateFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFleetOutput");
        formatter.field("fleet", &self.fleet);
        formatter.finish()
    }
}
/// See [`UpdateFleetOutput`](crate::output::UpdateFleetOutput)
pub mod update_fleet_output {
    /// A builder for [`UpdateFleetOutput`](crate::output::UpdateFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<crate::model::Fleet>,
    }
    impl Builder {
        /// <p>Information about the fleet.</p>
        pub fn fleet(mut self, input: crate::model::Fleet) -> Self {
            self.fleet = Some(input);
            self
        }
        /// <p>Information about the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<crate::model::Fleet>) -> Self {
            self.fleet = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFleetOutput`](crate::output::UpdateFleetOutput)
        pub fn build(self) -> crate::output::UpdateFleetOutput {
            crate::output::UpdateFleetOutput { fleet: self.fleet }
        }
    }
}
impl UpdateFleetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFleetOutput`](crate::output::UpdateFleetOutput)
    pub fn builder() -> crate::output::update_fleet_output::Builder {
        crate::output::update_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDirectoryConfigOutput {
    /// <p>Information about the Directory Config object.</p>
    pub directory_config: std::option::Option<crate::model::DirectoryConfig>,
}
impl UpdateDirectoryConfigOutput {
    /// <p>Information about the Directory Config object.</p>
    pub fn directory_config(&self) -> std::option::Option<&crate::model::DirectoryConfig> {
        self.directory_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateDirectoryConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDirectoryConfigOutput");
        formatter.field("directory_config", &self.directory_config);
        formatter.finish()
    }
}
/// See [`UpdateDirectoryConfigOutput`](crate::output::UpdateDirectoryConfigOutput)
pub mod update_directory_config_output {
    /// A builder for [`UpdateDirectoryConfigOutput`](crate::output::UpdateDirectoryConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_config: std::option::Option<crate::model::DirectoryConfig>,
    }
    impl Builder {
        /// <p>Information about the Directory Config object.</p>
        pub fn directory_config(mut self, input: crate::model::DirectoryConfig) -> Self {
            self.directory_config = Some(input);
            self
        }
        /// <p>Information about the Directory Config object.</p>
        pub fn set_directory_config(
            mut self,
            input: std::option::Option<crate::model::DirectoryConfig>,
        ) -> Self {
            self.directory_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDirectoryConfigOutput`](crate::output::UpdateDirectoryConfigOutput)
        pub fn build(self) -> crate::output::UpdateDirectoryConfigOutput {
            crate::output::UpdateDirectoryConfigOutput {
                directory_config: self.directory_config,
            }
        }
    }
}
impl UpdateDirectoryConfigOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDirectoryConfigOutput`](crate::output::UpdateDirectoryConfigOutput)
    pub fn builder() -> crate::output::update_directory_config_output::Builder {
        crate::output::update_directory_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub image_builder: std::option::Option<crate::model::ImageBuilder>,
}
impl StopImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub fn image_builder(&self) -> std::option::Option<&crate::model::ImageBuilder> {
        self.image_builder.as_ref()
    }
}
impl std::fmt::Debug for StopImageBuilderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopImageBuilderOutput");
        formatter.field("image_builder", &self.image_builder);
        formatter.finish()
    }
}
/// See [`StopImageBuilderOutput`](crate::output::StopImageBuilderOutput)
pub mod stop_image_builder_output {
    /// A builder for [`StopImageBuilderOutput`](crate::output::StopImageBuilderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_builder: std::option::Option<crate::model::ImageBuilder>,
    }
    impl Builder {
        /// <p>Information about the image builder.</p>
        pub fn image_builder(mut self, input: crate::model::ImageBuilder) -> Self {
            self.image_builder = Some(input);
            self
        }
        /// <p>Information about the image builder.</p>
        pub fn set_image_builder(
            mut self,
            input: std::option::Option<crate::model::ImageBuilder>,
        ) -> Self {
            self.image_builder = input;
            self
        }
        /// Consumes the builder and constructs a [`StopImageBuilderOutput`](crate::output::StopImageBuilderOutput)
        pub fn build(self) -> crate::output::StopImageBuilderOutput {
            crate::output::StopImageBuilderOutput {
                image_builder: self.image_builder,
            }
        }
    }
}
impl StopImageBuilderOutput {
    /// Creates a new builder-style object to manufacture [`StopImageBuilderOutput`](crate::output::StopImageBuilderOutput)
    pub fn builder() -> crate::output::stop_image_builder_output::Builder {
        crate::output::stop_image_builder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFleetOutput {}
impl std::fmt::Debug for StopFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFleetOutput");
        formatter.finish()
    }
}
/// See [`StopFleetOutput`](crate::output::StopFleetOutput)
pub mod stop_fleet_output {
    /// A builder for [`StopFleetOutput`](crate::output::StopFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StopFleetOutput`](crate::output::StopFleetOutput)
        pub fn build(self) -> crate::output::StopFleetOutput {
            crate::output::StopFleetOutput {}
        }
    }
}
impl StopFleetOutput {
    /// Creates a new builder-style object to manufacture [`StopFleetOutput`](crate::output::StopFleetOutput)
    pub fn builder() -> crate::output::stop_fleet_output::Builder {
        crate::output::stop_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub image_builder: std::option::Option<crate::model::ImageBuilder>,
}
impl StartImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub fn image_builder(&self) -> std::option::Option<&crate::model::ImageBuilder> {
        self.image_builder.as_ref()
    }
}
impl std::fmt::Debug for StartImageBuilderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartImageBuilderOutput");
        formatter.field("image_builder", &self.image_builder);
        formatter.finish()
    }
}
/// See [`StartImageBuilderOutput`](crate::output::StartImageBuilderOutput)
pub mod start_image_builder_output {
    /// A builder for [`StartImageBuilderOutput`](crate::output::StartImageBuilderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_builder: std::option::Option<crate::model::ImageBuilder>,
    }
    impl Builder {
        /// <p>Information about the image builder.</p>
        pub fn image_builder(mut self, input: crate::model::ImageBuilder) -> Self {
            self.image_builder = Some(input);
            self
        }
        /// <p>Information about the image builder.</p>
        pub fn set_image_builder(
            mut self,
            input: std::option::Option<crate::model::ImageBuilder>,
        ) -> Self {
            self.image_builder = input;
            self
        }
        /// Consumes the builder and constructs a [`StartImageBuilderOutput`](crate::output::StartImageBuilderOutput)
        pub fn build(self) -> crate::output::StartImageBuilderOutput {
            crate::output::StartImageBuilderOutput {
                image_builder: self.image_builder,
            }
        }
    }
}
impl StartImageBuilderOutput {
    /// Creates a new builder-style object to manufacture [`StartImageBuilderOutput`](crate::output::StartImageBuilderOutput)
    pub fn builder() -> crate::output::start_image_builder_output::Builder {
        crate::output::start_image_builder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFleetOutput {}
impl std::fmt::Debug for StartFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFleetOutput");
        formatter.finish()
    }
}
/// See [`StartFleetOutput`](crate::output::StartFleetOutput)
pub mod start_fleet_output {
    /// A builder for [`StartFleetOutput`](crate::output::StartFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`StartFleetOutput`](crate::output::StartFleetOutput)
        pub fn build(self) -> crate::output::StartFleetOutput {
            crate::output::StartFleetOutput {}
        }
    }
}
impl StartFleetOutput {
    /// Creates a new builder-style object to manufacture [`StartFleetOutput`](crate::output::StartFleetOutput)
    pub fn builder() -> crate::output::start_fleet_output::Builder {
        crate::output::start_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The information about the tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The information about the tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The information about the tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The information about the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedStacksOutput {
    /// <p>The name of the stack.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedStacksOutput {
    /// <p>The name of the stack.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedStacksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedStacksOutput");
        formatter.field("names", &self.names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociatedStacksOutput`](crate::output::ListAssociatedStacksOutput)
pub mod list_associated_stacks_output {
    /// A builder for [`ListAssociatedStacksOutput`](crate::output::ListAssociatedStacksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The name of the stack.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The name of the stack.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedStacksOutput`](crate::output::ListAssociatedStacksOutput)
        pub fn build(self) -> crate::output::ListAssociatedStacksOutput {
            crate::output::ListAssociatedStacksOutput {
                names: self.names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociatedStacksOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociatedStacksOutput`](crate::output::ListAssociatedStacksOutput)
    pub fn builder() -> crate::output::list_associated_stacks_output::Builder {
        crate::output::list_associated_stacks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedFleetsOutput {
    /// <p>The name of the fleet.</p>
    pub names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedFleetsOutput {
    /// <p>The name of the fleet.</p>
    pub fn names(&self) -> std::option::Option<&[std::string::String]> {
        self.names.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedFleetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedFleetsOutput");
        formatter.field("names", &self.names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociatedFleetsOutput`](crate::output::ListAssociatedFleetsOutput)
pub mod list_associated_fleets_output {
    /// A builder for [`ListAssociatedFleetsOutput`](crate::output::ListAssociatedFleetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The name of the fleet.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.names.unwrap_or_default();
            v.push(input.into());
            self.names = Some(v);
            self
        }
        /// <p>The name of the fleet.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.names = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedFleetsOutput`](crate::output::ListAssociatedFleetsOutput)
        pub fn build(self) -> crate::output::ListAssociatedFleetsOutput {
            crate::output::ListAssociatedFleetsOutput {
                names: self.names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociatedFleetsOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociatedFleetsOutput`](crate::output::ListAssociatedFleetsOutput)
    pub fn builder() -> crate::output::list_associated_fleets_output::Builder {
        crate::output::list_associated_fleets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExpireSessionOutput {}
impl std::fmt::Debug for ExpireSessionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExpireSessionOutput");
        formatter.finish()
    }
}
/// See [`ExpireSessionOutput`](crate::output::ExpireSessionOutput)
pub mod expire_session_output {
    /// A builder for [`ExpireSessionOutput`](crate::output::ExpireSessionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ExpireSessionOutput`](crate::output::ExpireSessionOutput)
        pub fn build(self) -> crate::output::ExpireSessionOutput {
            crate::output::ExpireSessionOutput {}
        }
    }
}
impl ExpireSessionOutput {
    /// Creates a new builder-style object to manufacture [`ExpireSessionOutput`](crate::output::ExpireSessionOutput)
    pub fn builder() -> crate::output::expire_session_output::Builder {
        crate::output::expire_session_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableUserOutput {}
impl std::fmt::Debug for EnableUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableUserOutput");
        formatter.finish()
    }
}
/// See [`EnableUserOutput`](crate::output::EnableUserOutput)
pub mod enable_user_output {
    /// A builder for [`EnableUserOutput`](crate::output::EnableUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`EnableUserOutput`](crate::output::EnableUserOutput)
        pub fn build(self) -> crate::output::EnableUserOutput {
            crate::output::EnableUserOutput {}
        }
    }
}
impl EnableUserOutput {
    /// Creates a new builder-style object to manufacture [`EnableUserOutput`](crate::output::EnableUserOutput)
    pub fn builder() -> crate::output::enable_user_output::Builder {
        crate::output::enable_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFleetOutput {}
impl std::fmt::Debug for DisassociateFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFleetOutput");
        formatter.finish()
    }
}
/// See [`DisassociateFleetOutput`](crate::output::DisassociateFleetOutput)
pub mod disassociate_fleet_output {
    /// A builder for [`DisassociateFleetOutput`](crate::output::DisassociateFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateFleetOutput`](crate::output::DisassociateFleetOutput)
        pub fn build(self) -> crate::output::DisassociateFleetOutput {
            crate::output::DisassociateFleetOutput {}
        }
    }
}
impl DisassociateFleetOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateFleetOutput`](crate::output::DisassociateFleetOutput)
    pub fn builder() -> crate::output::disassociate_fleet_output::Builder {
        crate::output::disassociate_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableUserOutput {}
impl std::fmt::Debug for DisableUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableUserOutput");
        formatter.finish()
    }
}
/// See [`DisableUserOutput`](crate::output::DisableUserOutput)
pub mod disable_user_output {
    /// A builder for [`DisableUserOutput`](crate::output::DisableUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableUserOutput`](crate::output::DisableUserOutput)
        pub fn build(self) -> crate::output::DisableUserOutput {
            crate::output::DisableUserOutput {}
        }
    }
}
impl DisableUserOutput {
    /// Creates a new builder-style object to manufacture [`DisableUserOutput`](crate::output::DisableUserOutput)
    pub fn builder() -> crate::output::disable_user_output::Builder {
        crate::output::disable_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUserStackAssociationsOutput {
    /// <p>The UserStackAssociation objects.</p>
    pub user_stack_associations:
        std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeUserStackAssociationsOutput {
    /// <p>The UserStackAssociation objects.</p>
    pub fn user_stack_associations(
        &self,
    ) -> std::option::Option<&[crate::model::UserStackAssociation]> {
        self.user_stack_associations.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeUserStackAssociationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUserStackAssociationsOutput");
        formatter.field("user_stack_associations", &self.user_stack_associations);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeUserStackAssociationsOutput`](crate::output::DescribeUserStackAssociationsOutput)
pub mod describe_user_stack_associations_output {
    /// A builder for [`DescribeUserStackAssociationsOutput`](crate::output::DescribeUserStackAssociationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_stack_associations:
            std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `user_stack_associations`.
        ///
        /// To override the contents of this collection use [`set_user_stack_associations`](Self::set_user_stack_associations).
        ///
        /// <p>The UserStackAssociation objects.</p>
        pub fn user_stack_associations(
            mut self,
            input: impl Into<crate::model::UserStackAssociation>,
        ) -> Self {
            let mut v = self.user_stack_associations.unwrap_or_default();
            v.push(input.into());
            self.user_stack_associations = Some(v);
            self
        }
        /// <p>The UserStackAssociation objects.</p>
        pub fn set_user_stack_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociation>>,
        ) -> Self {
            self.user_stack_associations = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserStackAssociationsOutput`](crate::output::DescribeUserStackAssociationsOutput)
        pub fn build(self) -> crate::output::DescribeUserStackAssociationsOutput {
            crate::output::DescribeUserStackAssociationsOutput {
                user_stack_associations: self.user_stack_associations,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeUserStackAssociationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUserStackAssociationsOutput`](crate::output::DescribeUserStackAssociationsOutput)
    pub fn builder() -> crate::output::describe_user_stack_associations_output::Builder {
        crate::output::describe_user_stack_associations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsersOutput {
    /// <p>Information about users in the user pool.</p>
    pub users: std::option::Option<std::vec::Vec<crate::model::User>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeUsersOutput {
    /// <p>Information about users in the user pool.</p>
    pub fn users(&self) -> std::option::Option<&[crate::model::User]> {
        self.users.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsersOutput");
        formatter.field("users", &self.users);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
pub mod describe_users_output {
    /// A builder for [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) users: std::option::Option<std::vec::Vec<crate::model::User>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `users`.
        ///
        /// To override the contents of this collection use [`set_users`](Self::set_users).
        ///
        /// <p>Information about users in the user pool.</p>
        pub fn users(mut self, input: impl Into<crate::model::User>) -> Self {
            let mut v = self.users.unwrap_or_default();
            v.push(input.into());
            self.users = Some(v);
            self
        }
        /// <p>Information about users in the user pool.</p>
        pub fn set_users(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::User>>,
        ) -> Self {
            self.users = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
        pub fn build(self) -> crate::output::DescribeUsersOutput {
            crate::output::DescribeUsersOutput {
                users: self.users,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeUsersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUsersOutput`](crate::output::DescribeUsersOutput)
    pub fn builder() -> crate::output::describe_users_output::Builder {
        crate::output::describe_users_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsageReportSubscriptionsOutput {
    /// <p>Information about the usage report subscription.</p>
    pub usage_report_subscriptions:
        std::option::Option<std::vec::Vec<crate::model::UsageReportSubscription>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeUsageReportSubscriptionsOutput {
    /// <p>Information about the usage report subscription.</p>
    pub fn usage_report_subscriptions(
        &self,
    ) -> std::option::Option<&[crate::model::UsageReportSubscription]> {
        self.usage_report_subscriptions.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsageReportSubscriptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsageReportSubscriptionsOutput");
        formatter.field(
            "usage_report_subscriptions",
            &self.usage_report_subscriptions,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeUsageReportSubscriptionsOutput`](crate::output::DescribeUsageReportSubscriptionsOutput)
pub mod describe_usage_report_subscriptions_output {
    /// A builder for [`DescribeUsageReportSubscriptionsOutput`](crate::output::DescribeUsageReportSubscriptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_report_subscriptions:
            std::option::Option<std::vec::Vec<crate::model::UsageReportSubscription>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `usage_report_subscriptions`.
        ///
        /// To override the contents of this collection use [`set_usage_report_subscriptions`](Self::set_usage_report_subscriptions).
        ///
        /// <p>Information about the usage report subscription.</p>
        pub fn usage_report_subscriptions(
            mut self,
            input: impl Into<crate::model::UsageReportSubscription>,
        ) -> Self {
            let mut v = self.usage_report_subscriptions.unwrap_or_default();
            v.push(input.into());
            self.usage_report_subscriptions = Some(v);
            self
        }
        /// <p>Information about the usage report subscription.</p>
        pub fn set_usage_report_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageReportSubscription>>,
        ) -> Self {
            self.usage_report_subscriptions = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsageReportSubscriptionsOutput`](crate::output::DescribeUsageReportSubscriptionsOutput)
        pub fn build(self) -> crate::output::DescribeUsageReportSubscriptionsOutput {
            crate::output::DescribeUsageReportSubscriptionsOutput {
                usage_report_subscriptions: self.usage_report_subscriptions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeUsageReportSubscriptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUsageReportSubscriptionsOutput`](crate::output::DescribeUsageReportSubscriptionsOutput)
    pub fn builder() -> crate::output::describe_usage_report_subscriptions_output::Builder {
        crate::output::describe_usage_report_subscriptions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStacksOutput {
    /// <p>Information about the stacks.</p>
    pub stacks: std::option::Option<std::vec::Vec<crate::model::Stack>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeStacksOutput {
    /// <p>Information about the stacks.</p>
    pub fn stacks(&self) -> std::option::Option<&[crate::model::Stack]> {
        self.stacks.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeStacksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStacksOutput");
        formatter.field("stacks", &self.stacks);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeStacksOutput`](crate::output::DescribeStacksOutput)
pub mod describe_stacks_output {
    /// A builder for [`DescribeStacksOutput`](crate::output::DescribeStacksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stacks: std::option::Option<std::vec::Vec<crate::model::Stack>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `stacks`.
        ///
        /// To override the contents of this collection use [`set_stacks`](Self::set_stacks).
        ///
        /// <p>Information about the stacks.</p>
        pub fn stacks(mut self, input: impl Into<crate::model::Stack>) -> Self {
            let mut v = self.stacks.unwrap_or_default();
            v.push(input.into());
            self.stacks = Some(v);
            self
        }
        /// <p>Information about the stacks.</p>
        pub fn set_stacks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Stack>>,
        ) -> Self {
            self.stacks = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStacksOutput`](crate::output::DescribeStacksOutput)
        pub fn build(self) -> crate::output::DescribeStacksOutput {
            crate::output::DescribeStacksOutput {
                stacks: self.stacks,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeStacksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStacksOutput`](crate::output::DescribeStacksOutput)
    pub fn builder() -> crate::output::describe_stacks_output::Builder {
        crate::output::describe_stacks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSessionsOutput {
    /// <p>Information about the streaming sessions.</p>
    pub sessions: std::option::Option<std::vec::Vec<crate::model::Session>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeSessionsOutput {
    /// <p>Information about the streaming sessions.</p>
    pub fn sessions(&self) -> std::option::Option<&[crate::model::Session]> {
        self.sessions.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeSessionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSessionsOutput");
        formatter.field("sessions", &self.sessions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
pub mod describe_sessions_output {
    /// A builder for [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sessions: std::option::Option<std::vec::Vec<crate::model::Session>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `sessions`.
        ///
        /// To override the contents of this collection use [`set_sessions`](Self::set_sessions).
        ///
        /// <p>Information about the streaming sessions.</p>
        pub fn sessions(mut self, input: impl Into<crate::model::Session>) -> Self {
            let mut v = self.sessions.unwrap_or_default();
            v.push(input.into());
            self.sessions = Some(v);
            self
        }
        /// <p>Information about the streaming sessions.</p>
        pub fn set_sessions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Session>>,
        ) -> Self {
            self.sessions = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
        pub fn build(self) -> crate::output::DescribeSessionsOutput {
            crate::output::DescribeSessionsOutput {
                sessions: self.sessions,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeSessionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSessionsOutput`](crate::output::DescribeSessionsOutput)
    pub fn builder() -> crate::output::describe_sessions_output::Builder {
        crate::output::describe_sessions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagesOutput {
    /// <p>Information about the images.</p>
    pub images: std::option::Option<std::vec::Vec<crate::model::Image>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImagesOutput {
    /// <p>Information about the images.</p>
    pub fn images(&self) -> std::option::Option<&[crate::model::Image]> {
        self.images.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagesOutput");
        formatter.field("images", &self.images);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
pub mod describe_images_output {
    /// A builder for [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) images: std::option::Option<std::vec::Vec<crate::model::Image>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `images`.
        ///
        /// To override the contents of this collection use [`set_images`](Self::set_images).
        ///
        /// <p>Information about the images.</p>
        pub fn images(mut self, input: impl Into<crate::model::Image>) -> Self {
            let mut v = self.images.unwrap_or_default();
            v.push(input.into());
            self.images = Some(v);
            self
        }
        /// <p>Information about the images.</p>
        pub fn set_images(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Image>>,
        ) -> Self {
            self.images = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
        pub fn build(self) -> crate::output::DescribeImagesOutput {
            crate::output::DescribeImagesOutput {
                images: self.images,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeImagesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImagesOutput`](crate::output::DescribeImagesOutput)
    pub fn builder() -> crate::output::describe_images_output::Builder {
        crate::output::describe_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImagePermissionsOutput {
    /// <p>The name of the private image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The permissions for a private image that you own. </p>
    pub shared_image_permissions_list:
        std::option::Option<std::vec::Vec<crate::model::SharedImagePermissions>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImagePermissionsOutput {
    /// <p>The name of the private image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The permissions for a private image that you own. </p>
    pub fn shared_image_permissions_list(
        &self,
    ) -> std::option::Option<&[crate::model::SharedImagePermissions]> {
        self.shared_image_permissions_list.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImagePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImagePermissionsOutput");
        formatter.field("name", &self.name);
        formatter.field(
            "shared_image_permissions_list",
            &self.shared_image_permissions_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeImagePermissionsOutput`](crate::output::DescribeImagePermissionsOutput)
pub mod describe_image_permissions_output {
    /// A builder for [`DescribeImagePermissionsOutput`](crate::output::DescribeImagePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) shared_image_permissions_list:
            std::option::Option<std::vec::Vec<crate::model::SharedImagePermissions>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the private image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the private image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `shared_image_permissions_list`.
        ///
        /// To override the contents of this collection use [`set_shared_image_permissions_list`](Self::set_shared_image_permissions_list).
        ///
        /// <p>The permissions for a private image that you own. </p>
        pub fn shared_image_permissions_list(
            mut self,
            input: impl Into<crate::model::SharedImagePermissions>,
        ) -> Self {
            let mut v = self.shared_image_permissions_list.unwrap_or_default();
            v.push(input.into());
            self.shared_image_permissions_list = Some(v);
            self
        }
        /// <p>The permissions for a private image that you own. </p>
        pub fn set_shared_image_permissions_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SharedImagePermissions>>,
        ) -> Self {
            self.shared_image_permissions_list = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImagePermissionsOutput`](crate::output::DescribeImagePermissionsOutput)
        pub fn build(self) -> crate::output::DescribeImagePermissionsOutput {
            crate::output::DescribeImagePermissionsOutput {
                name: self.name,
                shared_image_permissions_list: self.shared_image_permissions_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeImagePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImagePermissionsOutput`](crate::output::DescribeImagePermissionsOutput)
    pub fn builder() -> crate::output::describe_image_permissions_output::Builder {
        crate::output::describe_image_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeImageBuildersOutput {
    /// <p>Information about the image builders.</p>
    pub image_builders: std::option::Option<std::vec::Vec<crate::model::ImageBuilder>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeImageBuildersOutput {
    /// <p>Information about the image builders.</p>
    pub fn image_builders(&self) -> std::option::Option<&[crate::model::ImageBuilder]> {
        self.image_builders.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeImageBuildersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeImageBuildersOutput");
        formatter.field("image_builders", &self.image_builders);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeImageBuildersOutput`](crate::output::DescribeImageBuildersOutput)
pub mod describe_image_builders_output {
    /// A builder for [`DescribeImageBuildersOutput`](crate::output::DescribeImageBuildersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_builders: std::option::Option<std::vec::Vec<crate::model::ImageBuilder>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `image_builders`.
        ///
        /// To override the contents of this collection use [`set_image_builders`](Self::set_image_builders).
        ///
        /// <p>Information about the image builders.</p>
        pub fn image_builders(mut self, input: impl Into<crate::model::ImageBuilder>) -> Self {
            let mut v = self.image_builders.unwrap_or_default();
            v.push(input.into());
            self.image_builders = Some(v);
            self
        }
        /// <p>Information about the image builders.</p>
        pub fn set_image_builders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ImageBuilder>>,
        ) -> Self {
            self.image_builders = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeImageBuildersOutput`](crate::output::DescribeImageBuildersOutput)
        pub fn build(self) -> crate::output::DescribeImageBuildersOutput {
            crate::output::DescribeImageBuildersOutput {
                image_builders: self.image_builders,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeImageBuildersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeImageBuildersOutput`](crate::output::DescribeImageBuildersOutput)
    pub fn builder() -> crate::output::describe_image_builders_output::Builder {
        crate::output::describe_image_builders_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFleetsOutput {
    /// <p>Information about the fleets.</p>
    pub fleets: std::option::Option<std::vec::Vec<crate::model::Fleet>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeFleetsOutput {
    /// <p>Information about the fleets.</p>
    pub fn fleets(&self) -> std::option::Option<&[crate::model::Fleet]> {
        self.fleets.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeFleetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFleetsOutput");
        formatter.field("fleets", &self.fleets);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeFleetsOutput`](crate::output::DescribeFleetsOutput)
pub mod describe_fleets_output {
    /// A builder for [`DescribeFleetsOutput`](crate::output::DescribeFleetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleets: std::option::Option<std::vec::Vec<crate::model::Fleet>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `fleets`.
        ///
        /// To override the contents of this collection use [`set_fleets`](Self::set_fleets).
        ///
        /// <p>Information about the fleets.</p>
        pub fn fleets(mut self, input: impl Into<crate::model::Fleet>) -> Self {
            let mut v = self.fleets.unwrap_or_default();
            v.push(input.into());
            self.fleets = Some(v);
            self
        }
        /// <p>Information about the fleets.</p>
        pub fn set_fleets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Fleet>>,
        ) -> Self {
            self.fleets = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFleetsOutput`](crate::output::DescribeFleetsOutput)
        pub fn build(self) -> crate::output::DescribeFleetsOutput {
            crate::output::DescribeFleetsOutput {
                fleets: self.fleets,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeFleetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFleetsOutput`](crate::output::DescribeFleetsOutput)
    pub fn builder() -> crate::output::describe_fleets_output::Builder {
        crate::output::describe_fleets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDirectoryConfigsOutput {
    /// <p>Information about the directory configurations. Note that although the response syntax in this topic includes the account password, this password is not returned in the actual response. </p>
    pub directory_configs: std::option::Option<std::vec::Vec<crate::model::DirectoryConfig>>,
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDirectoryConfigsOutput {
    /// <p>Information about the directory configurations. Note that although the response syntax in this topic includes the account password, this password is not returned in the actual response. </p>
    pub fn directory_configs(&self) -> std::option::Option<&[crate::model::DirectoryConfig]> {
        self.directory_configs.as_deref()
    }
    /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDirectoryConfigsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDirectoryConfigsOutput");
        formatter.field("directory_configs", &self.directory_configs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDirectoryConfigsOutput`](crate::output::DescribeDirectoryConfigsOutput)
pub mod describe_directory_configs_output {
    /// A builder for [`DescribeDirectoryConfigsOutput`](crate::output::DescribeDirectoryConfigsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_configs:
            std::option::Option<std::vec::Vec<crate::model::DirectoryConfig>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `directory_configs`.
        ///
        /// To override the contents of this collection use [`set_directory_configs`](Self::set_directory_configs).
        ///
        /// <p>Information about the directory configurations. Note that although the response syntax in this topic includes the account password, this password is not returned in the actual response. </p>
        pub fn directory_configs(
            mut self,
            input: impl Into<crate::model::DirectoryConfig>,
        ) -> Self {
            let mut v = self.directory_configs.unwrap_or_default();
            v.push(input.into());
            self.directory_configs = Some(v);
            self
        }
        /// <p>Information about the directory configurations. Note that although the response syntax in this topic includes the account password, this password is not returned in the actual response. </p>
        pub fn set_directory_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DirectoryConfig>>,
        ) -> Self {
            self.directory_configs = input;
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDirectoryConfigsOutput`](crate::output::DescribeDirectoryConfigsOutput)
        pub fn build(self) -> crate::output::DescribeDirectoryConfigsOutput {
            crate::output::DescribeDirectoryConfigsOutput {
                directory_configs: self.directory_configs,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDirectoryConfigsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDirectoryConfigsOutput`](crate::output::DescribeDirectoryConfigsOutput)
    pub fn builder() -> crate::output::describe_directory_configs_output::Builder {
        crate::output::describe_directory_configs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUserOutput {}
impl std::fmt::Debug for DeleteUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUserOutput");
        formatter.finish()
    }
}
/// See [`DeleteUserOutput`](crate::output::DeleteUserOutput)
pub mod delete_user_output {
    /// A builder for [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUserOutput`](crate::output::DeleteUserOutput)
        pub fn build(self) -> crate::output::DeleteUserOutput {
            crate::output::DeleteUserOutput {}
        }
    }
}
impl DeleteUserOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUserOutput`](crate::output::DeleteUserOutput)
    pub fn builder() -> crate::output::delete_user_output::Builder {
        crate::output::delete_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUsageReportSubscriptionOutput {}
impl std::fmt::Debug for DeleteUsageReportSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUsageReportSubscriptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteUsageReportSubscriptionOutput`](crate::output::DeleteUsageReportSubscriptionOutput)
pub mod delete_usage_report_subscription_output {
    /// A builder for [`DeleteUsageReportSubscriptionOutput`](crate::output::DeleteUsageReportSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUsageReportSubscriptionOutput`](crate::output::DeleteUsageReportSubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteUsageReportSubscriptionOutput {
            crate::output::DeleteUsageReportSubscriptionOutput {}
        }
    }
}
impl DeleteUsageReportSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUsageReportSubscriptionOutput`](crate::output::DeleteUsageReportSubscriptionOutput)
    pub fn builder() -> crate::output::delete_usage_report_subscription_output::Builder {
        crate::output::delete_usage_report_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteStackOutput {}
impl std::fmt::Debug for DeleteStackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteStackOutput");
        formatter.finish()
    }
}
/// See [`DeleteStackOutput`](crate::output::DeleteStackOutput)
pub mod delete_stack_output {
    /// A builder for [`DeleteStackOutput`](crate::output::DeleteStackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteStackOutput`](crate::output::DeleteStackOutput)
        pub fn build(self) -> crate::output::DeleteStackOutput {
            crate::output::DeleteStackOutput {}
        }
    }
}
impl DeleteStackOutput {
    /// Creates a new builder-style object to manufacture [`DeleteStackOutput`](crate::output::DeleteStackOutput)
    pub fn builder() -> crate::output::delete_stack_output::Builder {
        crate::output::delete_stack_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImagePermissionsOutput {}
impl std::fmt::Debug for DeleteImagePermissionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImagePermissionsOutput");
        formatter.finish()
    }
}
/// See [`DeleteImagePermissionsOutput`](crate::output::DeleteImagePermissionsOutput)
pub mod delete_image_permissions_output {
    /// A builder for [`DeleteImagePermissionsOutput`](crate::output::DeleteImagePermissionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteImagePermissionsOutput`](crate::output::DeleteImagePermissionsOutput)
        pub fn build(self) -> crate::output::DeleteImagePermissionsOutput {
            crate::output::DeleteImagePermissionsOutput {}
        }
    }
}
impl DeleteImagePermissionsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImagePermissionsOutput`](crate::output::DeleteImagePermissionsOutput)
    pub fn builder() -> crate::output::delete_image_permissions_output::Builder {
        crate::output::delete_image_permissions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub image_builder: std::option::Option<crate::model::ImageBuilder>,
}
impl DeleteImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub fn image_builder(&self) -> std::option::Option<&crate::model::ImageBuilder> {
        self.image_builder.as_ref()
    }
}
impl std::fmt::Debug for DeleteImageBuilderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageBuilderOutput");
        formatter.field("image_builder", &self.image_builder);
        formatter.finish()
    }
}
/// See [`DeleteImageBuilderOutput`](crate::output::DeleteImageBuilderOutput)
pub mod delete_image_builder_output {
    /// A builder for [`DeleteImageBuilderOutput`](crate::output::DeleteImageBuilderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_builder: std::option::Option<crate::model::ImageBuilder>,
    }
    impl Builder {
        /// <p>Information about the image builder.</p>
        pub fn image_builder(mut self, input: crate::model::ImageBuilder) -> Self {
            self.image_builder = Some(input);
            self
        }
        /// <p>Information about the image builder.</p>
        pub fn set_image_builder(
            mut self,
            input: std::option::Option<crate::model::ImageBuilder>,
        ) -> Self {
            self.image_builder = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageBuilderOutput`](crate::output::DeleteImageBuilderOutput)
        pub fn build(self) -> crate::output::DeleteImageBuilderOutput {
            crate::output::DeleteImageBuilderOutput {
                image_builder: self.image_builder,
            }
        }
    }
}
impl DeleteImageBuilderOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImageBuilderOutput`](crate::output::DeleteImageBuilderOutput)
    pub fn builder() -> crate::output::delete_image_builder_output::Builder {
        crate::output::delete_image_builder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteImageOutput {
    /// <p>Information about the image.</p>
    pub image: std::option::Option<crate::model::Image>,
}
impl DeleteImageOutput {
    /// <p>Information about the image.</p>
    pub fn image(&self) -> std::option::Option<&crate::model::Image> {
        self.image.as_ref()
    }
}
impl std::fmt::Debug for DeleteImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteImageOutput");
        formatter.field("image", &self.image);
        formatter.finish()
    }
}
/// See [`DeleteImageOutput`](crate::output::DeleteImageOutput)
pub mod delete_image_output {
    /// A builder for [`DeleteImageOutput`](crate::output::DeleteImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<crate::model::Image>,
    }
    impl Builder {
        /// <p>Information about the image.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.image = Some(input);
            self
        }
        /// <p>Information about the image.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.image = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteImageOutput`](crate::output::DeleteImageOutput)
        pub fn build(self) -> crate::output::DeleteImageOutput {
            crate::output::DeleteImageOutput { image: self.image }
        }
    }
}
impl DeleteImageOutput {
    /// Creates a new builder-style object to manufacture [`DeleteImageOutput`](crate::output::DeleteImageOutput)
    pub fn builder() -> crate::output::delete_image_output::Builder {
        crate::output::delete_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFleetOutput {}
impl std::fmt::Debug for DeleteFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFleetOutput");
        formatter.finish()
    }
}
/// See [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
pub mod delete_fleet_output {
    /// A builder for [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
        pub fn build(self) -> crate::output::DeleteFleetOutput {
            crate::output::DeleteFleetOutput {}
        }
    }
}
impl DeleteFleetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFleetOutput`](crate::output::DeleteFleetOutput)
    pub fn builder() -> crate::output::delete_fleet_output::Builder {
        crate::output::delete_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDirectoryConfigOutput {}
impl std::fmt::Debug for DeleteDirectoryConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDirectoryConfigOutput");
        formatter.finish()
    }
}
/// See [`DeleteDirectoryConfigOutput`](crate::output::DeleteDirectoryConfigOutput)
pub mod delete_directory_config_output {
    /// A builder for [`DeleteDirectoryConfigOutput`](crate::output::DeleteDirectoryConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDirectoryConfigOutput`](crate::output::DeleteDirectoryConfigOutput)
        pub fn build(self) -> crate::output::DeleteDirectoryConfigOutput {
            crate::output::DeleteDirectoryConfigOutput {}
        }
    }
}
impl DeleteDirectoryConfigOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryConfigOutput`](crate::output::DeleteDirectoryConfigOutput)
    pub fn builder() -> crate::output::delete_directory_config_output::Builder {
        crate::output::delete_directory_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUserOutput {}
impl std::fmt::Debug for CreateUserOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUserOutput");
        formatter.finish()
    }
}
/// See [`CreateUserOutput`](crate::output::CreateUserOutput)
pub mod create_user_output {
    /// A builder for [`CreateUserOutput`](crate::output::CreateUserOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateUserOutput`](crate::output::CreateUserOutput)
        pub fn build(self) -> crate::output::CreateUserOutput {
            crate::output::CreateUserOutput {}
        }
    }
}
impl CreateUserOutput {
    /// Creates a new builder-style object to manufacture [`CreateUserOutput`](crate::output::CreateUserOutput)
    pub fn builder() -> crate::output::create_user_output::Builder {
        crate::output::create_user_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUsageReportSubscriptionOutput {
    /// <p>The Amazon S3 bucket where generated reports are stored.</p>
    ///
    /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
    /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
    /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
    /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
    /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The schedule for generating usage reports.</p>
    pub schedule: std::option::Option<crate::model::UsageReportSchedule>,
}
impl CreateUsageReportSubscriptionOutput {
    /// <p>The Amazon S3 bucket where generated reports are stored.</p>
    ///
    /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
    /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
    /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
    /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
    /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>The schedule for generating usage reports.</p>
    pub fn schedule(&self) -> std::option::Option<&crate::model::UsageReportSchedule> {
        self.schedule.as_ref()
    }
}
impl std::fmt::Debug for CreateUsageReportSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUsageReportSubscriptionOutput");
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("schedule", &self.schedule);
        formatter.finish()
    }
}
/// See [`CreateUsageReportSubscriptionOutput`](crate::output::CreateUsageReportSubscriptionOutput)
pub mod create_usage_report_subscription_output {
    /// A builder for [`CreateUsageReportSubscriptionOutput`](crate::output::CreateUsageReportSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) schedule: std::option::Option<crate::model::UsageReportSchedule>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket where generated reports are stored.</p>
        ///
        /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
        /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
        /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
        /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
        /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket where generated reports are stored.</p>
        ///
        /// <p>If you enabled on-instance session scripts and Amazon S3 logging for your session script
        /// configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is
        /// unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0
        /// uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts,
        /// when you enable usage reports, AppStream 2.0 creates a new S3 bucket.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>The schedule for generating usage reports.</p>
        pub fn schedule(mut self, input: crate::model::UsageReportSchedule) -> Self {
            self.schedule = Some(input);
            self
        }
        /// <p>The schedule for generating usage reports.</p>
        pub fn set_schedule(
            mut self,
            input: std::option::Option<crate::model::UsageReportSchedule>,
        ) -> Self {
            self.schedule = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUsageReportSubscriptionOutput`](crate::output::CreateUsageReportSubscriptionOutput)
        pub fn build(self) -> crate::output::CreateUsageReportSubscriptionOutput {
            crate::output::CreateUsageReportSubscriptionOutput {
                s3_bucket_name: self.s3_bucket_name,
                schedule: self.schedule,
            }
        }
    }
}
impl CreateUsageReportSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateUsageReportSubscriptionOutput`](crate::output::CreateUsageReportSubscriptionOutput)
    pub fn builder() -> crate::output::create_usage_report_subscription_output::Builder {
        crate::output::create_usage_report_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUpdatedImageOutput {
    /// <p>Describes an image.</p>
    pub image: std::option::Option<crate::model::Image>,
    /// <p>Indicates whether a new image can be created.</p>
    pub can_update_image: bool,
}
impl CreateUpdatedImageOutput {
    /// <p>Describes an image.</p>
    pub fn image(&self) -> std::option::Option<&crate::model::Image> {
        self.image.as_ref()
    }
    /// <p>Indicates whether a new image can be created.</p>
    pub fn can_update_image(&self) -> bool {
        self.can_update_image
    }
}
impl std::fmt::Debug for CreateUpdatedImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUpdatedImageOutput");
        formatter.field("image", &self.image);
        formatter.field("can_update_image", &self.can_update_image);
        formatter.finish()
    }
}
/// See [`CreateUpdatedImageOutput`](crate::output::CreateUpdatedImageOutput)
pub mod create_updated_image_output {
    /// A builder for [`CreateUpdatedImageOutput`](crate::output::CreateUpdatedImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<crate::model::Image>,
        pub(crate) can_update_image: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Describes an image.</p>
        pub fn image(mut self, input: crate::model::Image) -> Self {
            self.image = Some(input);
            self
        }
        /// <p>Describes an image.</p>
        pub fn set_image(mut self, input: std::option::Option<crate::model::Image>) -> Self {
            self.image = input;
            self
        }
        /// <p>Indicates whether a new image can be created.</p>
        pub fn can_update_image(mut self, input: bool) -> Self {
            self.can_update_image = Some(input);
            self
        }
        /// <p>Indicates whether a new image can be created.</p>
        pub fn set_can_update_image(mut self, input: std::option::Option<bool>) -> Self {
            self.can_update_image = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUpdatedImageOutput`](crate::output::CreateUpdatedImageOutput)
        pub fn build(self) -> crate::output::CreateUpdatedImageOutput {
            crate::output::CreateUpdatedImageOutput {
                image: self.image,
                can_update_image: self.can_update_image.unwrap_or_default(),
            }
        }
    }
}
impl CreateUpdatedImageOutput {
    /// Creates a new builder-style object to manufacture [`CreateUpdatedImageOutput`](crate::output::CreateUpdatedImageOutput)
    pub fn builder() -> crate::output::create_updated_image_output::Builder {
        crate::output::create_updated_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStreamingUrlOutput {
    /// <p>The URL to start the AppStream 2.0 streaming session.</p>
    pub streaming_url: std::option::Option<std::string::String>,
    /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
    pub expires: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateStreamingUrlOutput {
    /// <p>The URL to start the AppStream 2.0 streaming session.</p>
    pub fn streaming_url(&self) -> std::option::Option<&str> {
        self.streaming_url.as_deref()
    }
    /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
    pub fn expires(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expires.as_ref()
    }
}
impl std::fmt::Debug for CreateStreamingUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStreamingUrlOutput");
        formatter.field("streaming_url", &self.streaming_url);
        formatter.field("expires", &self.expires);
        formatter.finish()
    }
}
/// See [`CreateStreamingUrlOutput`](crate::output::CreateStreamingUrlOutput)
pub mod create_streaming_url_output {
    /// A builder for [`CreateStreamingUrlOutput`](crate::output::CreateStreamingUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_url: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The URL to start the AppStream 2.0 streaming session.</p>
        pub fn streaming_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_url = Some(input.into());
            self
        }
        /// <p>The URL to start the AppStream 2.0 streaming session.</p>
        pub fn set_streaming_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_url = input;
            self
        }
        /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
        pub fn expires(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStreamingUrlOutput`](crate::output::CreateStreamingUrlOutput)
        pub fn build(self) -> crate::output::CreateStreamingUrlOutput {
            crate::output::CreateStreamingUrlOutput {
                streaming_url: self.streaming_url,
                expires: self.expires,
            }
        }
    }
}
impl CreateStreamingUrlOutput {
    /// Creates a new builder-style object to manufacture [`CreateStreamingUrlOutput`](crate::output::CreateStreamingUrlOutput)
    pub fn builder() -> crate::output::create_streaming_url_output::Builder {
        crate::output::create_streaming_url_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateStackOutput {
    /// <p>Information about the stack.</p>
    pub stack: std::option::Option<crate::model::Stack>,
}
impl CreateStackOutput {
    /// <p>Information about the stack.</p>
    pub fn stack(&self) -> std::option::Option<&crate::model::Stack> {
        self.stack.as_ref()
    }
}
impl std::fmt::Debug for CreateStackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateStackOutput");
        formatter.field("stack", &self.stack);
        formatter.finish()
    }
}
/// See [`CreateStackOutput`](crate::output::CreateStackOutput)
pub mod create_stack_output {
    /// A builder for [`CreateStackOutput`](crate::output::CreateStackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stack: std::option::Option<crate::model::Stack>,
    }
    impl Builder {
        /// <p>Information about the stack.</p>
        pub fn stack(mut self, input: crate::model::Stack) -> Self {
            self.stack = Some(input);
            self
        }
        /// <p>Information about the stack.</p>
        pub fn set_stack(mut self, input: std::option::Option<crate::model::Stack>) -> Self {
            self.stack = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateStackOutput`](crate::output::CreateStackOutput)
        pub fn build(self) -> crate::output::CreateStackOutput {
            crate::output::CreateStackOutput { stack: self.stack }
        }
    }
}
impl CreateStackOutput {
    /// Creates a new builder-style object to manufacture [`CreateStackOutput`](crate::output::CreateStackOutput)
    pub fn builder() -> crate::output::create_stack_output::Builder {
        crate::output::create_stack_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageBuilderStreamingUrlOutput {
    /// <p>The URL to start the AppStream 2.0 streaming session.</p>
    pub streaming_url: std::option::Option<std::string::String>,
    /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
    pub expires: std::option::Option<aws_smithy_types::Instant>,
}
impl CreateImageBuilderStreamingUrlOutput {
    /// <p>The URL to start the AppStream 2.0 streaming session.</p>
    pub fn streaming_url(&self) -> std::option::Option<&str> {
        self.streaming_url.as_deref()
    }
    /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
    pub fn expires(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expires.as_ref()
    }
}
impl std::fmt::Debug for CreateImageBuilderStreamingUrlOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageBuilderStreamingUrlOutput");
        formatter.field("streaming_url", &self.streaming_url);
        formatter.field("expires", &self.expires);
        formatter.finish()
    }
}
/// See [`CreateImageBuilderStreamingUrlOutput`](crate::output::CreateImageBuilderStreamingUrlOutput)
pub mod create_image_builder_streaming_url_output {
    /// A builder for [`CreateImageBuilderStreamingUrlOutput`](crate::output::CreateImageBuilderStreamingUrlOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) streaming_url: std::option::Option<std::string::String>,
        pub(crate) expires: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The URL to start the AppStream 2.0 streaming session.</p>
        pub fn streaming_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_url = Some(input.into());
            self
        }
        /// <p>The URL to start the AppStream 2.0 streaming session.</p>
        pub fn set_streaming_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.streaming_url = input;
            self
        }
        /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
        pub fn expires(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires = Some(input);
            self
        }
        /// <p>The elapsed time, in seconds after the Unix epoch, when this URL expires.</p>
        pub fn set_expires(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageBuilderStreamingUrlOutput`](crate::output::CreateImageBuilderStreamingUrlOutput)
        pub fn build(self) -> crate::output::CreateImageBuilderStreamingUrlOutput {
            crate::output::CreateImageBuilderStreamingUrlOutput {
                streaming_url: self.streaming_url,
                expires: self.expires,
            }
        }
    }
}
impl CreateImageBuilderStreamingUrlOutput {
    /// Creates a new builder-style object to manufacture [`CreateImageBuilderStreamingUrlOutput`](crate::output::CreateImageBuilderStreamingUrlOutput)
    pub fn builder() -> crate::output::create_image_builder_streaming_url_output::Builder {
        crate::output::create_image_builder_streaming_url_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub image_builder: std::option::Option<crate::model::ImageBuilder>,
}
impl CreateImageBuilderOutput {
    /// <p>Information about the image builder.</p>
    pub fn image_builder(&self) -> std::option::Option<&crate::model::ImageBuilder> {
        self.image_builder.as_ref()
    }
}
impl std::fmt::Debug for CreateImageBuilderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateImageBuilderOutput");
        formatter.field("image_builder", &self.image_builder);
        formatter.finish()
    }
}
/// See [`CreateImageBuilderOutput`](crate::output::CreateImageBuilderOutput)
pub mod create_image_builder_output {
    /// A builder for [`CreateImageBuilderOutput`](crate::output::CreateImageBuilderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_builder: std::option::Option<crate::model::ImageBuilder>,
    }
    impl Builder {
        /// <p>Information about the image builder.</p>
        pub fn image_builder(mut self, input: crate::model::ImageBuilder) -> Self {
            self.image_builder = Some(input);
            self
        }
        /// <p>Information about the image builder.</p>
        pub fn set_image_builder(
            mut self,
            input: std::option::Option<crate::model::ImageBuilder>,
        ) -> Self {
            self.image_builder = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateImageBuilderOutput`](crate::output::CreateImageBuilderOutput)
        pub fn build(self) -> crate::output::CreateImageBuilderOutput {
            crate::output::CreateImageBuilderOutput {
                image_builder: self.image_builder,
            }
        }
    }
}
impl CreateImageBuilderOutput {
    /// Creates a new builder-style object to manufacture [`CreateImageBuilderOutput`](crate::output::CreateImageBuilderOutput)
    pub fn builder() -> crate::output::create_image_builder_output::Builder {
        crate::output::create_image_builder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFleetOutput {
    /// <p>Information about the fleet.</p>
    pub fleet: std::option::Option<crate::model::Fleet>,
}
impl CreateFleetOutput {
    /// <p>Information about the fleet.</p>
    pub fn fleet(&self) -> std::option::Option<&crate::model::Fleet> {
        self.fleet.as_ref()
    }
}
impl std::fmt::Debug for CreateFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFleetOutput");
        formatter.field("fleet", &self.fleet);
        formatter.finish()
    }
}
/// See [`CreateFleetOutput`](crate::output::CreateFleetOutput)
pub mod create_fleet_output {
    /// A builder for [`CreateFleetOutput`](crate::output::CreateFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fleet: std::option::Option<crate::model::Fleet>,
    }
    impl Builder {
        /// <p>Information about the fleet.</p>
        pub fn fleet(mut self, input: crate::model::Fleet) -> Self {
            self.fleet = Some(input);
            self
        }
        /// <p>Information about the fleet.</p>
        pub fn set_fleet(mut self, input: std::option::Option<crate::model::Fleet>) -> Self {
            self.fleet = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFleetOutput`](crate::output::CreateFleetOutput)
        pub fn build(self) -> crate::output::CreateFleetOutput {
            crate::output::CreateFleetOutput { fleet: self.fleet }
        }
    }
}
impl CreateFleetOutput {
    /// Creates a new builder-style object to manufacture [`CreateFleetOutput`](crate::output::CreateFleetOutput)
    pub fn builder() -> crate::output::create_fleet_output::Builder {
        crate::output::create_fleet_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDirectoryConfigOutput {
    /// <p>Information about the directory configuration.</p>
    pub directory_config: std::option::Option<crate::model::DirectoryConfig>,
}
impl CreateDirectoryConfigOutput {
    /// <p>Information about the directory configuration.</p>
    pub fn directory_config(&self) -> std::option::Option<&crate::model::DirectoryConfig> {
        self.directory_config.as_ref()
    }
}
impl std::fmt::Debug for CreateDirectoryConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDirectoryConfigOutput");
        formatter.field("directory_config", &self.directory_config);
        formatter.finish()
    }
}
/// See [`CreateDirectoryConfigOutput`](crate::output::CreateDirectoryConfigOutput)
pub mod create_directory_config_output {
    /// A builder for [`CreateDirectoryConfigOutput`](crate::output::CreateDirectoryConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) directory_config: std::option::Option<crate::model::DirectoryConfig>,
    }
    impl Builder {
        /// <p>Information about the directory configuration.</p>
        pub fn directory_config(mut self, input: crate::model::DirectoryConfig) -> Self {
            self.directory_config = Some(input);
            self
        }
        /// <p>Information about the directory configuration.</p>
        pub fn set_directory_config(
            mut self,
            input: std::option::Option<crate::model::DirectoryConfig>,
        ) -> Self {
            self.directory_config = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDirectoryConfigOutput`](crate::output::CreateDirectoryConfigOutput)
        pub fn build(self) -> crate::output::CreateDirectoryConfigOutput {
            crate::output::CreateDirectoryConfigOutput {
                directory_config: self.directory_config,
            }
        }
    }
}
impl CreateDirectoryConfigOutput {
    /// Creates a new builder-style object to manufacture [`CreateDirectoryConfigOutput`](crate::output::CreateDirectoryConfigOutput)
    pub fn builder() -> crate::output::create_directory_config_output::Builder {
        crate::output::create_directory_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyImageOutput {
    /// <p>The name of the destination image.</p>
    pub destination_image_name: std::option::Option<std::string::String>,
}
impl CopyImageOutput {
    /// <p>The name of the destination image.</p>
    pub fn destination_image_name(&self) -> std::option::Option<&str> {
        self.destination_image_name.as_deref()
    }
}
impl std::fmt::Debug for CopyImageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyImageOutput");
        formatter.field("destination_image_name", &self.destination_image_name);
        formatter.finish()
    }
}
/// See [`CopyImageOutput`](crate::output::CopyImageOutput)
pub mod copy_image_output {
    /// A builder for [`CopyImageOutput`](crate::output::CopyImageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_image_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the destination image.</p>
        pub fn destination_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_image_name = Some(input.into());
            self
        }
        /// <p>The name of the destination image.</p>
        pub fn set_destination_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_image_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyImageOutput`](crate::output::CopyImageOutput)
        pub fn build(self) -> crate::output::CopyImageOutput {
            crate::output::CopyImageOutput {
                destination_image_name: self.destination_image_name,
            }
        }
    }
}
impl CopyImageOutput {
    /// Creates a new builder-style object to manufacture [`CopyImageOutput`](crate::output::CopyImageOutput)
    pub fn builder() -> crate::output::copy_image_output::Builder {
        crate::output::copy_image_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateUserStackOutput {
    /// <p>The list of UserStackAssociationError objects.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::UserStackAssociationError>>,
}
impl BatchDisassociateUserStackOutput {
    /// <p>The list of UserStackAssociationError objects.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::UserStackAssociationError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateUserStackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDisassociateUserStackOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDisassociateUserStackOutput`](crate::output::BatchDisassociateUserStackOutput)
pub mod batch_disassociate_user_stack_output {
    /// A builder for [`BatchDisassociateUserStackOutput`](crate::output::BatchDisassociateUserStackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::UserStackAssociationError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The list of UserStackAssociationError objects.</p>
        pub fn errors(mut self, input: impl Into<crate::model::UserStackAssociationError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>The list of UserStackAssociationError objects.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociationError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateUserStackOutput`](crate::output::BatchDisassociateUserStackOutput)
        pub fn build(self) -> crate::output::BatchDisassociateUserStackOutput {
            crate::output::BatchDisassociateUserStackOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDisassociateUserStackOutput {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateUserStackOutput`](crate::output::BatchDisassociateUserStackOutput)
    pub fn builder() -> crate::output::batch_disassociate_user_stack_output::Builder {
        crate::output::batch_disassociate_user_stack_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateUserStackOutput {
    /// <p>The list of UserStackAssociationError objects.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::UserStackAssociationError>>,
}
impl BatchAssociateUserStackOutput {
    /// <p>The list of UserStackAssociationError objects.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::UserStackAssociationError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateUserStackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchAssociateUserStackOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchAssociateUserStackOutput`](crate::output::BatchAssociateUserStackOutput)
pub mod batch_associate_user_stack_output {
    /// A builder for [`BatchAssociateUserStackOutput`](crate::output::BatchAssociateUserStackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::UserStackAssociationError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>The list of UserStackAssociationError objects.</p>
        pub fn errors(mut self, input: impl Into<crate::model::UserStackAssociationError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>The list of UserStackAssociationError objects.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserStackAssociationError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateUserStackOutput`](crate::output::BatchAssociateUserStackOutput)
        pub fn build(self) -> crate::output::BatchAssociateUserStackOutput {
            crate::output::BatchAssociateUserStackOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchAssociateUserStackOutput {
    /// Creates a new builder-style object to manufacture [`BatchAssociateUserStackOutput`](crate::output::BatchAssociateUserStackOutput)
    pub fn builder() -> crate::output::batch_associate_user_stack_output::Builder {
        crate::output::batch_associate_user_stack_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateFleetOutput {}
impl std::fmt::Debug for AssociateFleetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateFleetOutput");
        formatter.finish()
    }
}
/// See [`AssociateFleetOutput`](crate::output::AssociateFleetOutput)
pub mod associate_fleet_output {
    /// A builder for [`AssociateFleetOutput`](crate::output::AssociateFleetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateFleetOutput`](crate::output::AssociateFleetOutput)
        pub fn build(self) -> crate::output::AssociateFleetOutput {
            crate::output::AssociateFleetOutput {}
        }
    }
}
impl AssociateFleetOutput {
    /// Creates a new builder-style object to manufacture [`AssociateFleetOutput`](crate::output::AssociateFleetOutput)
    pub fn builder() -> crate::output::associate_fleet_output::Builder {
        crate::output::associate_fleet_output::Builder::default()
    }
}
