// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_fleet`](crate::client::Client::associate_fleet).
///
/// See [`crate::client::fluent_builders::AssociateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateFleet {
    _private: (),
}
impl AssociateFleet {
    /// Creates a new builder-style object to manufacture [`AssociateFleetInput`](crate::input::AssociateFleetInput)
    pub fn builder() -> crate::input::associate_fleet_input::Builder {
        crate::input::associate_fleet_input::Builder::default()
    }
    /// Creates a new `AssociateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateFleet {
    type Output =
        std::result::Result<crate::output::AssociateFleetOutput, crate::error::AssociateFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_fleet_error(response)
        } else {
            crate::operation_deser::parse_associate_fleet_response(response)
        }
    }
}

/// Operation shape for `BatchAssociateUserStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_associate_user_stack`](crate::client::Client::batch_associate_user_stack).
///
/// See [`crate::client::fluent_builders::BatchAssociateUserStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchAssociateUserStack {
    _private: (),
}
impl BatchAssociateUserStack {
    /// Creates a new builder-style object to manufacture [`BatchAssociateUserStackInput`](crate::input::BatchAssociateUserStackInput)
    pub fn builder() -> crate::input::batch_associate_user_stack_input::Builder {
        crate::input::batch_associate_user_stack_input::Builder::default()
    }
    /// Creates a new `BatchAssociateUserStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchAssociateUserStack {
    type Output = std::result::Result<
        crate::output::BatchAssociateUserStackOutput,
        crate::error::BatchAssociateUserStackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_associate_user_stack_error(response)
        } else {
            crate::operation_deser::parse_batch_associate_user_stack_response(response)
        }
    }
}

/// Operation shape for `BatchDisassociateUserStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_disassociate_user_stack`](crate::client::Client::batch_disassociate_user_stack).
///
/// See [`crate::client::fluent_builders::BatchDisassociateUserStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDisassociateUserStack {
    _private: (),
}
impl BatchDisassociateUserStack {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateUserStackInput`](crate::input::BatchDisassociateUserStackInput)
    pub fn builder() -> crate::input::batch_disassociate_user_stack_input::Builder {
        crate::input::batch_disassociate_user_stack_input::Builder::default()
    }
    /// Creates a new `BatchDisassociateUserStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDisassociateUserStack {
    type Output = std::result::Result<
        crate::output::BatchDisassociateUserStackOutput,
        crate::error::BatchDisassociateUserStackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_disassociate_user_stack_error(response)
        } else {
            crate::operation_deser::parse_batch_disassociate_user_stack_response(response)
        }
    }
}

/// Operation shape for `CopyImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_image`](crate::client::Client::copy_image).
///
/// See [`crate::client::fluent_builders::CopyImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyImage {
    _private: (),
}
impl CopyImage {
    /// Creates a new builder-style object to manufacture [`CopyImageInput`](crate::input::CopyImageInput)
    pub fn builder() -> crate::input::copy_image_input::Builder {
        crate::input::copy_image_input::Builder::default()
    }
    /// Creates a new `CopyImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyImage {
    type Output = std::result::Result<crate::output::CopyImageOutput, crate::error::CopyImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_image_error(response)
        } else {
            crate::operation_deser::parse_copy_image_response(response)
        }
    }
}

/// Operation shape for `CreateDirectoryConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_directory_config`](crate::client::Client::create_directory_config).
///
/// See [`crate::client::fluent_builders::CreateDirectoryConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDirectoryConfig {
    _private: (),
}
impl CreateDirectoryConfig {
    /// Creates a new builder-style object to manufacture [`CreateDirectoryConfigInput`](crate::input::CreateDirectoryConfigInput)
    pub fn builder() -> crate::input::create_directory_config_input::Builder {
        crate::input::create_directory_config_input::Builder::default()
    }
    /// Creates a new `CreateDirectoryConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDirectoryConfig {
    type Output = std::result::Result<
        crate::output::CreateDirectoryConfigOutput,
        crate::error::CreateDirectoryConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_directory_config_error(response)
        } else {
            crate::operation_deser::parse_create_directory_config_response(response)
        }
    }
}

/// Operation shape for `CreateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_fleet`](crate::client::Client::create_fleet).
///
/// See [`crate::client::fluent_builders::CreateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFleet {
    _private: (),
}
impl CreateFleet {
    /// Creates a new builder-style object to manufacture [`CreateFleetInput`](crate::input::CreateFleetInput)
    pub fn builder() -> crate::input::create_fleet_input::Builder {
        crate::input::create_fleet_input::Builder::default()
    }
    /// Creates a new `CreateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFleet {
    type Output =
        std::result::Result<crate::output::CreateFleetOutput, crate::error::CreateFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_fleet_error(response)
        } else {
            crate::operation_deser::parse_create_fleet_response(response)
        }
    }
}

/// Operation shape for `CreateImageBuilder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image_builder`](crate::client::Client::create_image_builder).
///
/// See [`crate::client::fluent_builders::CreateImageBuilder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImageBuilder {
    _private: (),
}
impl CreateImageBuilder {
    /// Creates a new builder-style object to manufacture [`CreateImageBuilderInput`](crate::input::CreateImageBuilderInput)
    pub fn builder() -> crate::input::create_image_builder_input::Builder {
        crate::input::create_image_builder_input::Builder::default()
    }
    /// Creates a new `CreateImageBuilder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImageBuilder {
    type Output = std::result::Result<
        crate::output::CreateImageBuilderOutput,
        crate::error::CreateImageBuilderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_builder_error(response)
        } else {
            crate::operation_deser::parse_create_image_builder_response(response)
        }
    }
}

/// Operation shape for `CreateImageBuilderStreamingURL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_image_builder_streaming_url`](crate::client::Client::create_image_builder_streaming_url).
///
/// See [`crate::client::fluent_builders::CreateImageBuilderStreamingURL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateImageBuilderStreamingURL {
    _private: (),
}
impl CreateImageBuilderStreamingURL {
    /// Creates a new builder-style object to manufacture [`CreateImageBuilderStreamingUrlInput`](crate::input::CreateImageBuilderStreamingUrlInput)
    pub fn builder() -> crate::input::create_image_builder_streaming_url_input::Builder {
        crate::input::create_image_builder_streaming_url_input::Builder::default()
    }
    /// Creates a new `CreateImageBuilderStreamingURL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateImageBuilderStreamingURL {
    type Output = std::result::Result<
        crate::output::CreateImageBuilderStreamingUrlOutput,
        crate::error::CreateImageBuilderStreamingURLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_image_builder_streaming_url_error(response)
        } else {
            crate::operation_deser::parse_create_image_builder_streaming_url_response(response)
        }
    }
}

/// Operation shape for `CreateStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_stack`](crate::client::Client::create_stack).
///
/// See [`crate::client::fluent_builders::CreateStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStack {
    _private: (),
}
impl CreateStack {
    /// Creates a new builder-style object to manufacture [`CreateStackInput`](crate::input::CreateStackInput)
    pub fn builder() -> crate::input::create_stack_input::Builder {
        crate::input::create_stack_input::Builder::default()
    }
    /// Creates a new `CreateStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStack {
    type Output =
        std::result::Result<crate::output::CreateStackOutput, crate::error::CreateStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_stack_error(response)
        } else {
            crate::operation_deser::parse_create_stack_response(response)
        }
    }
}

/// Operation shape for `CreateStreamingURL`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_streaming_url`](crate::client::Client::create_streaming_url).
///
/// See [`crate::client::fluent_builders::CreateStreamingURL`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateStreamingURL {
    _private: (),
}
impl CreateStreamingURL {
    /// Creates a new builder-style object to manufacture [`CreateStreamingUrlInput`](crate::input::CreateStreamingUrlInput)
    pub fn builder() -> crate::input::create_streaming_url_input::Builder {
        crate::input::create_streaming_url_input::Builder::default()
    }
    /// Creates a new `CreateStreamingURL` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateStreamingURL {
    type Output = std::result::Result<
        crate::output::CreateStreamingUrlOutput,
        crate::error::CreateStreamingURLError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_streaming_url_error(response)
        } else {
            crate::operation_deser::parse_create_streaming_url_response(response)
        }
    }
}

/// Operation shape for `CreateUpdatedImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_updated_image`](crate::client::Client::create_updated_image).
///
/// See [`crate::client::fluent_builders::CreateUpdatedImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUpdatedImage {
    _private: (),
}
impl CreateUpdatedImage {
    /// Creates a new builder-style object to manufacture [`CreateUpdatedImageInput`](crate::input::CreateUpdatedImageInput)
    pub fn builder() -> crate::input::create_updated_image_input::Builder {
        crate::input::create_updated_image_input::Builder::default()
    }
    /// Creates a new `CreateUpdatedImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUpdatedImage {
    type Output = std::result::Result<
        crate::output::CreateUpdatedImageOutput,
        crate::error::CreateUpdatedImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_updated_image_error(response)
        } else {
            crate::operation_deser::parse_create_updated_image_response(response)
        }
    }
}

/// Operation shape for `CreateUsageReportSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_usage_report_subscription`](crate::client::Client::create_usage_report_subscription).
///
/// See [`crate::client::fluent_builders::CreateUsageReportSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUsageReportSubscription {
    _private: (),
}
impl CreateUsageReportSubscription {
    /// Creates a new builder-style object to manufacture [`CreateUsageReportSubscriptionInput`](crate::input::CreateUsageReportSubscriptionInput)
    pub fn builder() -> crate::input::create_usage_report_subscription_input::Builder {
        crate::input::create_usage_report_subscription_input::Builder::default()
    }
    /// Creates a new `CreateUsageReportSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUsageReportSubscription {
    type Output = std::result::Result<
        crate::output::CreateUsageReportSubscriptionOutput,
        crate::error::CreateUsageReportSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_usage_report_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_usage_report_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_user`](crate::client::Client::create_user).
///
/// See [`crate::client::fluent_builders::CreateUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateUser {
    _private: (),
}
impl CreateUser {
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
    /// Creates a new `CreateUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateUser {
    type Output =
        std::result::Result<crate::output::CreateUserOutput, crate::error::CreateUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_user_error(response)
        } else {
            crate::operation_deser::parse_create_user_response(response)
        }
    }
}

/// Operation shape for `DeleteDirectoryConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_directory_config`](crate::client::Client::delete_directory_config).
///
/// See [`crate::client::fluent_builders::DeleteDirectoryConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDirectoryConfig {
    _private: (),
}
impl DeleteDirectoryConfig {
    /// Creates a new builder-style object to manufacture [`DeleteDirectoryConfigInput`](crate::input::DeleteDirectoryConfigInput)
    pub fn builder() -> crate::input::delete_directory_config_input::Builder {
        crate::input::delete_directory_config_input::Builder::default()
    }
    /// Creates a new `DeleteDirectoryConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDirectoryConfig {
    type Output = std::result::Result<
        crate::output::DeleteDirectoryConfigOutput,
        crate::error::DeleteDirectoryConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_directory_config_error(response)
        } else {
            crate::operation_deser::parse_delete_directory_config_response(response)
        }
    }
}

/// Operation shape for `DeleteFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_fleet`](crate::client::Client::delete_fleet).
///
/// See [`crate::client::fluent_builders::DeleteFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFleet {
    _private: (),
}
impl DeleteFleet {
    /// Creates a new builder-style object to manufacture [`DeleteFleetInput`](crate::input::DeleteFleetInput)
    pub fn builder() -> crate::input::delete_fleet_input::Builder {
        crate::input::delete_fleet_input::Builder::default()
    }
    /// Creates a new `DeleteFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFleet {
    type Output =
        std::result::Result<crate::output::DeleteFleetOutput, crate::error::DeleteFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_fleet_error(response)
        } else {
            crate::operation_deser::parse_delete_fleet_response(response)
        }
    }
}

/// Operation shape for `DeleteImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image`](crate::client::Client::delete_image).
///
/// See [`crate::client::fluent_builders::DeleteImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImage {
    _private: (),
}
impl DeleteImage {
    /// Creates a new builder-style object to manufacture [`DeleteImageInput`](crate::input::DeleteImageInput)
    pub fn builder() -> crate::input::delete_image_input::Builder {
        crate::input::delete_image_input::Builder::default()
    }
    /// Creates a new `DeleteImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImage {
    type Output =
        std::result::Result<crate::output::DeleteImageOutput, crate::error::DeleteImageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_error(response)
        } else {
            crate::operation_deser::parse_delete_image_response(response)
        }
    }
}

/// Operation shape for `DeleteImageBuilder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image_builder`](crate::client::Client::delete_image_builder).
///
/// See [`crate::client::fluent_builders::DeleteImageBuilder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImageBuilder {
    _private: (),
}
impl DeleteImageBuilder {
    /// Creates a new builder-style object to manufacture [`DeleteImageBuilderInput`](crate::input::DeleteImageBuilderInput)
    pub fn builder() -> crate::input::delete_image_builder_input::Builder {
        crate::input::delete_image_builder_input::Builder::default()
    }
    /// Creates a new `DeleteImageBuilder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImageBuilder {
    type Output = std::result::Result<
        crate::output::DeleteImageBuilderOutput,
        crate::error::DeleteImageBuilderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_builder_error(response)
        } else {
            crate::operation_deser::parse_delete_image_builder_response(response)
        }
    }
}

/// Operation shape for `DeleteImagePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_image_permissions`](crate::client::Client::delete_image_permissions).
///
/// See [`crate::client::fluent_builders::DeleteImagePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteImagePermissions {
    _private: (),
}
impl DeleteImagePermissions {
    /// Creates a new builder-style object to manufacture [`DeleteImagePermissionsInput`](crate::input::DeleteImagePermissionsInput)
    pub fn builder() -> crate::input::delete_image_permissions_input::Builder {
        crate::input::delete_image_permissions_input::Builder::default()
    }
    /// Creates a new `DeleteImagePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteImagePermissions {
    type Output = std::result::Result<
        crate::output::DeleteImagePermissionsOutput,
        crate::error::DeleteImagePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_image_permissions_error(response)
        } else {
            crate::operation_deser::parse_delete_image_permissions_response(response)
        }
    }
}

/// Operation shape for `DeleteStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_stack`](crate::client::Client::delete_stack).
///
/// See [`crate::client::fluent_builders::DeleteStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteStack {
    _private: (),
}
impl DeleteStack {
    /// Creates a new builder-style object to manufacture [`DeleteStackInput`](crate::input::DeleteStackInput)
    pub fn builder() -> crate::input::delete_stack_input::Builder {
        crate::input::delete_stack_input::Builder::default()
    }
    /// Creates a new `DeleteStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteStack {
    type Output =
        std::result::Result<crate::output::DeleteStackOutput, crate::error::DeleteStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_stack_error(response)
        } else {
            crate::operation_deser::parse_delete_stack_response(response)
        }
    }
}

/// Operation shape for `DeleteUsageReportSubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_usage_report_subscription`](crate::client::Client::delete_usage_report_subscription).
///
/// See [`crate::client::fluent_builders::DeleteUsageReportSubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUsageReportSubscription {
    _private: (),
}
impl DeleteUsageReportSubscription {
    /// Creates a new builder-style object to manufacture [`DeleteUsageReportSubscriptionInput`](crate::input::DeleteUsageReportSubscriptionInput)
    pub fn builder() -> crate::input::delete_usage_report_subscription_input::Builder {
        crate::input::delete_usage_report_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteUsageReportSubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUsageReportSubscription {
    type Output = std::result::Result<
        crate::output::DeleteUsageReportSubscriptionOutput,
        crate::error::DeleteUsageReportSubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_usage_report_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_usage_report_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_user`](crate::client::Client::delete_user).
///
/// See [`crate::client::fluent_builders::DeleteUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteUser {
    _private: (),
}
impl DeleteUser {
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
    /// Creates a new `DeleteUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteUser {
    type Output =
        std::result::Result<crate::output::DeleteUserOutput, crate::error::DeleteUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_user_error(response)
        } else {
            crate::operation_deser::parse_delete_user_response(response)
        }
    }
}

/// Operation shape for `DescribeDirectoryConfigs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_directory_configs`](crate::client::Client::describe_directory_configs).
///
/// See [`crate::client::fluent_builders::DescribeDirectoryConfigs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDirectoryConfigs {
    _private: (),
}
impl DescribeDirectoryConfigs {
    /// Creates a new builder-style object to manufacture [`DescribeDirectoryConfigsInput`](crate::input::DescribeDirectoryConfigsInput)
    pub fn builder() -> crate::input::describe_directory_configs_input::Builder {
        crate::input::describe_directory_configs_input::Builder::default()
    }
    /// Creates a new `DescribeDirectoryConfigs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDirectoryConfigs {
    type Output = std::result::Result<
        crate::output::DescribeDirectoryConfigsOutput,
        crate::error::DescribeDirectoryConfigsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_directory_configs_error(response)
        } else {
            crate::operation_deser::parse_describe_directory_configs_response(response)
        }
    }
}

/// Operation shape for `DescribeFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_fleets`](crate::client::Client::describe_fleets).
///
/// See [`crate::client::fluent_builders::DescribeFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFleets {
    _private: (),
}
impl DescribeFleets {
    /// Creates a new builder-style object to manufacture [`DescribeFleetsInput`](crate::input::DescribeFleetsInput)
    pub fn builder() -> crate::input::describe_fleets_input::Builder {
        crate::input::describe_fleets_input::Builder::default()
    }
    /// Creates a new `DescribeFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFleets {
    type Output =
        std::result::Result<crate::output::DescribeFleetsOutput, crate::error::DescribeFleetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_fleets_error(response)
        } else {
            crate::operation_deser::parse_describe_fleets_response(response)
        }
    }
}

/// Operation shape for `DescribeImageBuilders`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_builders`](crate::client::Client::describe_image_builders).
///
/// See [`crate::client::fluent_builders::DescribeImageBuilders`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImageBuilders {
    _private: (),
}
impl DescribeImageBuilders {
    /// Creates a new builder-style object to manufacture [`DescribeImageBuildersInput`](crate::input::DescribeImageBuildersInput)
    pub fn builder() -> crate::input::describe_image_builders_input::Builder {
        crate::input::describe_image_builders_input::Builder::default()
    }
    /// Creates a new `DescribeImageBuilders` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImageBuilders {
    type Output = std::result::Result<
        crate::output::DescribeImageBuildersOutput,
        crate::error::DescribeImageBuildersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_builders_error(response)
        } else {
            crate::operation_deser::parse_describe_image_builders_response(response)
        }
    }
}

/// Operation shape for `DescribeImagePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_image_permissions`](crate::client::Client::describe_image_permissions).
///
/// See [`crate::client::fluent_builders::DescribeImagePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImagePermissions {
    _private: (),
}
impl DescribeImagePermissions {
    /// Creates a new builder-style object to manufacture [`DescribeImagePermissionsInput`](crate::input::DescribeImagePermissionsInput)
    pub fn builder() -> crate::input::describe_image_permissions_input::Builder {
        crate::input::describe_image_permissions_input::Builder::default()
    }
    /// Creates a new `DescribeImagePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImagePermissions {
    type Output = std::result::Result<
        crate::output::DescribeImagePermissionsOutput,
        crate::error::DescribeImagePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_image_permissions_error(response)
        } else {
            crate::operation_deser::parse_describe_image_permissions_response(response)
        }
    }
}

/// Operation shape for `DescribeImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_images`](crate::client::Client::describe_images).
///
/// See [`crate::client::fluent_builders::DescribeImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeImages {
    _private: (),
}
impl DescribeImages {
    /// Creates a new builder-style object to manufacture [`DescribeImagesInput`](crate::input::DescribeImagesInput)
    pub fn builder() -> crate::input::describe_images_input::Builder {
        crate::input::describe_images_input::Builder::default()
    }
    /// Creates a new `DescribeImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeImages {
    type Output =
        std::result::Result<crate::output::DescribeImagesOutput, crate::error::DescribeImagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_images_error(response)
        } else {
            crate::operation_deser::parse_describe_images_response(response)
        }
    }
}

/// Operation shape for `DescribeSessions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_sessions`](crate::client::Client::describe_sessions).
///
/// See [`crate::client::fluent_builders::DescribeSessions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSessions {
    _private: (),
}
impl DescribeSessions {
    /// Creates a new builder-style object to manufacture [`DescribeSessionsInput`](crate::input::DescribeSessionsInput)
    pub fn builder() -> crate::input::describe_sessions_input::Builder {
        crate::input::describe_sessions_input::Builder::default()
    }
    /// Creates a new `DescribeSessions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSessions {
    type Output = std::result::Result<
        crate::output::DescribeSessionsOutput,
        crate::error::DescribeSessionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_sessions_error(response)
        } else {
            crate::operation_deser::parse_describe_sessions_response(response)
        }
    }
}

/// Operation shape for `DescribeStacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_stacks`](crate::client::Client::describe_stacks).
///
/// See [`crate::client::fluent_builders::DescribeStacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeStacks {
    _private: (),
}
impl DescribeStacks {
    /// Creates a new builder-style object to manufacture [`DescribeStacksInput`](crate::input::DescribeStacksInput)
    pub fn builder() -> crate::input::describe_stacks_input::Builder {
        crate::input::describe_stacks_input::Builder::default()
    }
    /// Creates a new `DescribeStacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeStacks {
    type Output =
        std::result::Result<crate::output::DescribeStacksOutput, crate::error::DescribeStacksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_stacks_error(response)
        } else {
            crate::operation_deser::parse_describe_stacks_response(response)
        }
    }
}

/// Operation shape for `DescribeUsageReportSubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_usage_report_subscriptions`](crate::client::Client::describe_usage_report_subscriptions).
///
/// See [`crate::client::fluent_builders::DescribeUsageReportSubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUsageReportSubscriptions {
    _private: (),
}
impl DescribeUsageReportSubscriptions {
    /// Creates a new builder-style object to manufacture [`DescribeUsageReportSubscriptionsInput`](crate::input::DescribeUsageReportSubscriptionsInput)
    pub fn builder() -> crate::input::describe_usage_report_subscriptions_input::Builder {
        crate::input::describe_usage_report_subscriptions_input::Builder::default()
    }
    /// Creates a new `DescribeUsageReportSubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUsageReportSubscriptions {
    type Output = std::result::Result<
        crate::output::DescribeUsageReportSubscriptionsOutput,
        crate::error::DescribeUsageReportSubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_usage_report_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_describe_usage_report_subscriptions_response(response)
        }
    }
}

/// Operation shape for `DescribeUsers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_users`](crate::client::Client::describe_users).
///
/// See [`crate::client::fluent_builders::DescribeUsers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUsers {
    _private: (),
}
impl DescribeUsers {
    /// Creates a new builder-style object to manufacture [`DescribeUsersInput`](crate::input::DescribeUsersInput)
    pub fn builder() -> crate::input::describe_users_input::Builder {
        crate::input::describe_users_input::Builder::default()
    }
    /// Creates a new `DescribeUsers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUsers {
    type Output =
        std::result::Result<crate::output::DescribeUsersOutput, crate::error::DescribeUsersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_users_error(response)
        } else {
            crate::operation_deser::parse_describe_users_response(response)
        }
    }
}

/// Operation shape for `DescribeUserStackAssociations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_user_stack_associations`](crate::client::Client::describe_user_stack_associations).
///
/// See [`crate::client::fluent_builders::DescribeUserStackAssociations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeUserStackAssociations {
    _private: (),
}
impl DescribeUserStackAssociations {
    /// Creates a new builder-style object to manufacture [`DescribeUserStackAssociationsInput`](crate::input::DescribeUserStackAssociationsInput)
    pub fn builder() -> crate::input::describe_user_stack_associations_input::Builder {
        crate::input::describe_user_stack_associations_input::Builder::default()
    }
    /// Creates a new `DescribeUserStackAssociations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeUserStackAssociations {
    type Output = std::result::Result<
        crate::output::DescribeUserStackAssociationsOutput,
        crate::error::DescribeUserStackAssociationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_user_stack_associations_error(response)
        } else {
            crate::operation_deser::parse_describe_user_stack_associations_response(response)
        }
    }
}

/// Operation shape for `DisableUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_user`](crate::client::Client::disable_user).
///
/// See [`crate::client::fluent_builders::DisableUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableUser {
    _private: (),
}
impl DisableUser {
    /// Creates a new builder-style object to manufacture [`DisableUserInput`](crate::input::DisableUserInput)
    pub fn builder() -> crate::input::disable_user_input::Builder {
        crate::input::disable_user_input::Builder::default()
    }
    /// Creates a new `DisableUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableUser {
    type Output =
        std::result::Result<crate::output::DisableUserOutput, crate::error::DisableUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_user_error(response)
        } else {
            crate::operation_deser::parse_disable_user_response(response)
        }
    }
}

/// Operation shape for `DisassociateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_fleet`](crate::client::Client::disassociate_fleet).
///
/// See [`crate::client::fluent_builders::DisassociateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFleet {
    _private: (),
}
impl DisassociateFleet {
    /// Creates a new builder-style object to manufacture [`DisassociateFleetInput`](crate::input::DisassociateFleetInput)
    pub fn builder() -> crate::input::disassociate_fleet_input::Builder {
        crate::input::disassociate_fleet_input::Builder::default()
    }
    /// Creates a new `DisassociateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFleet {
    type Output = std::result::Result<
        crate::output::DisassociateFleetOutput,
        crate::error::DisassociateFleetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_fleet_error(response)
        } else {
            crate::operation_deser::parse_disassociate_fleet_response(response)
        }
    }
}

/// Operation shape for `EnableUser`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_user`](crate::client::Client::enable_user).
///
/// See [`crate::client::fluent_builders::EnableUser`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableUser {
    _private: (),
}
impl EnableUser {
    /// Creates a new builder-style object to manufacture [`EnableUserInput`](crate::input::EnableUserInput)
    pub fn builder() -> crate::input::enable_user_input::Builder {
        crate::input::enable_user_input::Builder::default()
    }
    /// Creates a new `EnableUser` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableUser {
    type Output =
        std::result::Result<crate::output::EnableUserOutput, crate::error::EnableUserError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_user_error(response)
        } else {
            crate::operation_deser::parse_enable_user_response(response)
        }
    }
}

/// Operation shape for `ExpireSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`expire_session`](crate::client::Client::expire_session).
///
/// See [`crate::client::fluent_builders::ExpireSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExpireSession {
    _private: (),
}
impl ExpireSession {
    /// Creates a new builder-style object to manufacture [`ExpireSessionInput`](crate::input::ExpireSessionInput)
    pub fn builder() -> crate::input::expire_session_input::Builder {
        crate::input::expire_session_input::Builder::default()
    }
    /// Creates a new `ExpireSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExpireSession {
    type Output =
        std::result::Result<crate::output::ExpireSessionOutput, crate::error::ExpireSessionError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_expire_session_error(response)
        } else {
            crate::operation_deser::parse_expire_session_response(response)
        }
    }
}

/// Operation shape for `ListAssociatedFleets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_associated_fleets`](crate::client::Client::list_associated_fleets).
///
/// See [`crate::client::fluent_builders::ListAssociatedFleets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociatedFleets {
    _private: (),
}
impl ListAssociatedFleets {
    /// Creates a new builder-style object to manufacture [`ListAssociatedFleetsInput`](crate::input::ListAssociatedFleetsInput)
    pub fn builder() -> crate::input::list_associated_fleets_input::Builder {
        crate::input::list_associated_fleets_input::Builder::default()
    }
    /// Creates a new `ListAssociatedFleets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssociatedFleets {
    type Output = std::result::Result<
        crate::output::ListAssociatedFleetsOutput,
        crate::error::ListAssociatedFleetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_associated_fleets_error(response)
        } else {
            crate::operation_deser::parse_list_associated_fleets_response(response)
        }
    }
}

/// Operation shape for `ListAssociatedStacks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_associated_stacks`](crate::client::Client::list_associated_stacks).
///
/// See [`crate::client::fluent_builders::ListAssociatedStacks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociatedStacks {
    _private: (),
}
impl ListAssociatedStacks {
    /// Creates a new builder-style object to manufacture [`ListAssociatedStacksInput`](crate::input::ListAssociatedStacksInput)
    pub fn builder() -> crate::input::list_associated_stacks_input::Builder {
        crate::input::list_associated_stacks_input::Builder::default()
    }
    /// Creates a new `ListAssociatedStacks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssociatedStacks {
    type Output = std::result::Result<
        crate::output::ListAssociatedStacksOutput,
        crate::error::ListAssociatedStacksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_associated_stacks_error(response)
        } else {
            crate::operation_deser::parse_list_associated_stacks_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `StartFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_fleet`](crate::client::Client::start_fleet).
///
/// See [`crate::client::fluent_builders::StartFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartFleet {
    _private: (),
}
impl StartFleet {
    /// Creates a new builder-style object to manufacture [`StartFleetInput`](crate::input::StartFleetInput)
    pub fn builder() -> crate::input::start_fleet_input::Builder {
        crate::input::start_fleet_input::Builder::default()
    }
    /// Creates a new `StartFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartFleet {
    type Output =
        std::result::Result<crate::output::StartFleetOutput, crate::error::StartFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_fleet_error(response)
        } else {
            crate::operation_deser::parse_start_fleet_response(response)
        }
    }
}

/// Operation shape for `StartImageBuilder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_image_builder`](crate::client::Client::start_image_builder).
///
/// See [`crate::client::fluent_builders::StartImageBuilder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartImageBuilder {
    _private: (),
}
impl StartImageBuilder {
    /// Creates a new builder-style object to manufacture [`StartImageBuilderInput`](crate::input::StartImageBuilderInput)
    pub fn builder() -> crate::input::start_image_builder_input::Builder {
        crate::input::start_image_builder_input::Builder::default()
    }
    /// Creates a new `StartImageBuilder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartImageBuilder {
    type Output = std::result::Result<
        crate::output::StartImageBuilderOutput,
        crate::error::StartImageBuilderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_image_builder_error(response)
        } else {
            crate::operation_deser::parse_start_image_builder_response(response)
        }
    }
}

/// Operation shape for `StopFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_fleet`](crate::client::Client::stop_fleet).
///
/// See [`crate::client::fluent_builders::StopFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopFleet {
    _private: (),
}
impl StopFleet {
    /// Creates a new builder-style object to manufacture [`StopFleetInput`](crate::input::StopFleetInput)
    pub fn builder() -> crate::input::stop_fleet_input::Builder {
        crate::input::stop_fleet_input::Builder::default()
    }
    /// Creates a new `StopFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopFleet {
    type Output = std::result::Result<crate::output::StopFleetOutput, crate::error::StopFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_fleet_error(response)
        } else {
            crate::operation_deser::parse_stop_fleet_response(response)
        }
    }
}

/// Operation shape for `StopImageBuilder`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_image_builder`](crate::client::Client::stop_image_builder).
///
/// See [`crate::client::fluent_builders::StopImageBuilder`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopImageBuilder {
    _private: (),
}
impl StopImageBuilder {
    /// Creates a new builder-style object to manufacture [`StopImageBuilderInput`](crate::input::StopImageBuilderInput)
    pub fn builder() -> crate::input::stop_image_builder_input::Builder {
        crate::input::stop_image_builder_input::Builder::default()
    }
    /// Creates a new `StopImageBuilder` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopImageBuilder {
    type Output = std::result::Result<
        crate::output::StopImageBuilderOutput,
        crate::error::StopImageBuilderError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_image_builder_error(response)
        } else {
            crate::operation_deser::parse_stop_image_builder_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDirectoryConfig`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_directory_config`](crate::client::Client::update_directory_config).
///
/// See [`crate::client::fluent_builders::UpdateDirectoryConfig`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDirectoryConfig {
    _private: (),
}
impl UpdateDirectoryConfig {
    /// Creates a new builder-style object to manufacture [`UpdateDirectoryConfigInput`](crate::input::UpdateDirectoryConfigInput)
    pub fn builder() -> crate::input::update_directory_config_input::Builder {
        crate::input::update_directory_config_input::Builder::default()
    }
    /// Creates a new `UpdateDirectoryConfig` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDirectoryConfig {
    type Output = std::result::Result<
        crate::output::UpdateDirectoryConfigOutput,
        crate::error::UpdateDirectoryConfigError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_directory_config_error(response)
        } else {
            crate::operation_deser::parse_update_directory_config_response(response)
        }
    }
}

/// Operation shape for `UpdateFleet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_fleet`](crate::client::Client::update_fleet).
///
/// See [`crate::client::fluent_builders::UpdateFleet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFleet {
    _private: (),
}
impl UpdateFleet {
    /// Creates a new builder-style object to manufacture [`UpdateFleetInput`](crate::input::UpdateFleetInput)
    pub fn builder() -> crate::input::update_fleet_input::Builder {
        crate::input::update_fleet_input::Builder::default()
    }
    /// Creates a new `UpdateFleet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFleet {
    type Output =
        std::result::Result<crate::output::UpdateFleetOutput, crate::error::UpdateFleetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_fleet_error(response)
        } else {
            crate::operation_deser::parse_update_fleet_response(response)
        }
    }
}

/// Operation shape for `UpdateImagePermissions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_image_permissions`](crate::client::Client::update_image_permissions).
///
/// See [`crate::client::fluent_builders::UpdateImagePermissions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateImagePermissions {
    _private: (),
}
impl UpdateImagePermissions {
    /// Creates a new builder-style object to manufacture [`UpdateImagePermissionsInput`](crate::input::UpdateImagePermissionsInput)
    pub fn builder() -> crate::input::update_image_permissions_input::Builder {
        crate::input::update_image_permissions_input::Builder::default()
    }
    /// Creates a new `UpdateImagePermissions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateImagePermissions {
    type Output = std::result::Result<
        crate::output::UpdateImagePermissionsOutput,
        crate::error::UpdateImagePermissionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_image_permissions_error(response)
        } else {
            crate::operation_deser::parse_update_image_permissions_response(response)
        }
    }
}

/// Operation shape for `UpdateStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_stack`](crate::client::Client::update_stack).
///
/// See [`crate::client::fluent_builders::UpdateStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateStack {
    _private: (),
}
impl UpdateStack {
    /// Creates a new builder-style object to manufacture [`UpdateStackInput`](crate::input::UpdateStackInput)
    pub fn builder() -> crate::input::update_stack_input::Builder {
        crate::input::update_stack_input::Builder::default()
    }
    /// Creates a new `UpdateStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateStack {
    type Output =
        std::result::Result<crate::output::UpdateStackOutput, crate::error::UpdateStackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_stack_error(response)
        } else {
            crate::operation_deser::parse_update_stack_response(response)
        }
    }
}
