// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateCustomDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_custom_domain`](crate::client::Client::associate_custom_domain).
///
/// See [`crate::client::fluent_builders::AssociateCustomDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateCustomDomain {
    _private: (),
}
impl AssociateCustomDomain {
    /// Creates a new builder-style object to manufacture [`AssociateCustomDomainInput`](crate::input::AssociateCustomDomainInput)
    pub fn builder() -> crate::input::associate_custom_domain_input::Builder {
        crate::input::associate_custom_domain_input::Builder::default()
    }
    /// Creates a new `AssociateCustomDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateCustomDomain {
    type Output = std::result::Result<
        crate::output::AssociateCustomDomainOutput,
        crate::error::AssociateCustomDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_custom_domain_error(response)
        } else {
            crate::operation_deser::parse_associate_custom_domain_response(response)
        }
    }
}

/// Operation shape for `CreateAutoScalingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_auto_scaling_configuration`](crate::client::Client::create_auto_scaling_configuration).
///
/// See [`crate::client::fluent_builders::CreateAutoScalingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAutoScalingConfiguration {
    _private: (),
}
impl CreateAutoScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateAutoScalingConfigurationInput`](crate::input::CreateAutoScalingConfigurationInput)
    pub fn builder() -> crate::input::create_auto_scaling_configuration_input::Builder {
        crate::input::create_auto_scaling_configuration_input::Builder::default()
    }
    /// Creates a new `CreateAutoScalingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAutoScalingConfiguration {
    type Output = std::result::Result<
        crate::output::CreateAutoScalingConfigurationOutput,
        crate::error::CreateAutoScalingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_auto_scaling_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_auto_scaling_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_connection`](crate::client::Client::create_connection).
///
/// See [`crate::client::fluent_builders::CreateConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateConnection {
    _private: (),
}
impl CreateConnection {
    /// Creates a new builder-style object to manufacture [`CreateConnectionInput`](crate::input::CreateConnectionInput)
    pub fn builder() -> crate::input::create_connection_input::Builder {
        crate::input::create_connection_input::Builder::default()
    }
    /// Creates a new `CreateConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateConnection {
    type Output = std::result::Result<
        crate::output::CreateConnectionOutput,
        crate::error::CreateConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_connection_error(response)
        } else {
            crate::operation_deser::parse_create_connection_response(response)
        }
    }
}

/// Operation shape for `CreateService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_service`](crate::client::Client::create_service).
///
/// See [`crate::client::fluent_builders::CreateService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateService {
    _private: (),
}
impl CreateService {
    /// Creates a new builder-style object to manufacture [`CreateServiceInput`](crate::input::CreateServiceInput)
    pub fn builder() -> crate::input::create_service_input::Builder {
        crate::input::create_service_input::Builder::default()
    }
    /// Creates a new `CreateService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateService {
    type Output =
        std::result::Result<crate::output::CreateServiceOutput, crate::error::CreateServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_service_error(response)
        } else {
            crate::operation_deser::parse_create_service_response(response)
        }
    }
}

/// Operation shape for `CreateVpcConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_vpc_connector`](crate::client::Client::create_vpc_connector).
///
/// See [`crate::client::fluent_builders::CreateVpcConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateVpcConnector {
    _private: (),
}
impl CreateVpcConnector {
    /// Creates a new builder-style object to manufacture [`CreateVpcConnectorInput`](crate::input::CreateVpcConnectorInput)
    pub fn builder() -> crate::input::create_vpc_connector_input::Builder {
        crate::input::create_vpc_connector_input::Builder::default()
    }
    /// Creates a new `CreateVpcConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateVpcConnector {
    type Output = std::result::Result<
        crate::output::CreateVpcConnectorOutput,
        crate::error::CreateVpcConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_vpc_connector_error(response)
        } else {
            crate::operation_deser::parse_create_vpc_connector_response(response)
        }
    }
}

/// Operation shape for `DeleteAutoScalingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_auto_scaling_configuration`](crate::client::Client::delete_auto_scaling_configuration).
///
/// See [`crate::client::fluent_builders::DeleteAutoScalingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAutoScalingConfiguration {
    _private: (),
}
impl DeleteAutoScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteAutoScalingConfigurationInput`](crate::input::DeleteAutoScalingConfigurationInput)
    pub fn builder() -> crate::input::delete_auto_scaling_configuration_input::Builder {
        crate::input::delete_auto_scaling_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteAutoScalingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAutoScalingConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteAutoScalingConfigurationOutput,
        crate::error::DeleteAutoScalingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_auto_scaling_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_auto_scaling_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_connection`](crate::client::Client::delete_connection).
///
/// See [`crate::client::fluent_builders::DeleteConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteConnection {
    _private: (),
}
impl DeleteConnection {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
    /// Creates a new `DeleteConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteConnection {
    type Output = std::result::Result<
        crate::output::DeleteConnectionOutput,
        crate::error::DeleteConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_connection_error(response)
        } else {
            crate::operation_deser::parse_delete_connection_response(response)
        }
    }
}

/// Operation shape for `DeleteService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_service`](crate::client::Client::delete_service).
///
/// See [`crate::client::fluent_builders::DeleteService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteService {
    _private: (),
}
impl DeleteService {
    /// Creates a new builder-style object to manufacture [`DeleteServiceInput`](crate::input::DeleteServiceInput)
    pub fn builder() -> crate::input::delete_service_input::Builder {
        crate::input::delete_service_input::Builder::default()
    }
    /// Creates a new `DeleteService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteService {
    type Output =
        std::result::Result<crate::output::DeleteServiceOutput, crate::error::DeleteServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_service_error(response)
        } else {
            crate::operation_deser::parse_delete_service_response(response)
        }
    }
}

/// Operation shape for `DeleteVpcConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_vpc_connector`](crate::client::Client::delete_vpc_connector).
///
/// See [`crate::client::fluent_builders::DeleteVpcConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteVpcConnector {
    _private: (),
}
impl DeleteVpcConnector {
    /// Creates a new builder-style object to manufacture [`DeleteVpcConnectorInput`](crate::input::DeleteVpcConnectorInput)
    pub fn builder() -> crate::input::delete_vpc_connector_input::Builder {
        crate::input::delete_vpc_connector_input::Builder::default()
    }
    /// Creates a new `DeleteVpcConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteVpcConnector {
    type Output = std::result::Result<
        crate::output::DeleteVpcConnectorOutput,
        crate::error::DeleteVpcConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_vpc_connector_error(response)
        } else {
            crate::operation_deser::parse_delete_vpc_connector_response(response)
        }
    }
}

/// Operation shape for `DescribeAutoScalingConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_auto_scaling_configuration`](crate::client::Client::describe_auto_scaling_configuration).
///
/// See [`crate::client::fluent_builders::DescribeAutoScalingConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAutoScalingConfiguration {
    _private: (),
}
impl DescribeAutoScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingConfigurationInput`](crate::input::DescribeAutoScalingConfigurationInput)
    pub fn builder() -> crate::input::describe_auto_scaling_configuration_input::Builder {
        crate::input::describe_auto_scaling_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeAutoScalingConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAutoScalingConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeAutoScalingConfigurationOutput,
        crate::error::DescribeAutoScalingConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_auto_scaling_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_auto_scaling_configuration_response(response)
        }
    }
}

/// Operation shape for `DescribeCustomDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_custom_domains`](crate::client::Client::describe_custom_domains).
///
/// See [`crate::client::fluent_builders::DescribeCustomDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCustomDomains {
    _private: (),
}
impl DescribeCustomDomains {
    /// Creates a new builder-style object to manufacture [`DescribeCustomDomainsInput`](crate::input::DescribeCustomDomainsInput)
    pub fn builder() -> crate::input::describe_custom_domains_input::Builder {
        crate::input::describe_custom_domains_input::Builder::default()
    }
    /// Creates a new `DescribeCustomDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCustomDomains {
    type Output = std::result::Result<
        crate::output::DescribeCustomDomainsOutput,
        crate::error::DescribeCustomDomainsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_custom_domains_error(response)
        } else {
            crate::operation_deser::parse_describe_custom_domains_response(response)
        }
    }
}

/// Operation shape for `DescribeService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_service`](crate::client::Client::describe_service).
///
/// See [`crate::client::fluent_builders::DescribeService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeService {
    _private: (),
}
impl DescribeService {
    /// Creates a new builder-style object to manufacture [`DescribeServiceInput`](crate::input::DescribeServiceInput)
    pub fn builder() -> crate::input::describe_service_input::Builder {
        crate::input::describe_service_input::Builder::default()
    }
    /// Creates a new `DescribeService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeService {
    type Output = std::result::Result<
        crate::output::DescribeServiceOutput,
        crate::error::DescribeServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_service_error(response)
        } else {
            crate::operation_deser::parse_describe_service_response(response)
        }
    }
}

/// Operation shape for `DescribeVpcConnector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_vpc_connector`](crate::client::Client::describe_vpc_connector).
///
/// See [`crate::client::fluent_builders::DescribeVpcConnector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeVpcConnector {
    _private: (),
}
impl DescribeVpcConnector {
    /// Creates a new builder-style object to manufacture [`DescribeVpcConnectorInput`](crate::input::DescribeVpcConnectorInput)
    pub fn builder() -> crate::input::describe_vpc_connector_input::Builder {
        crate::input::describe_vpc_connector_input::Builder::default()
    }
    /// Creates a new `DescribeVpcConnector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeVpcConnector {
    type Output = std::result::Result<
        crate::output::DescribeVpcConnectorOutput,
        crate::error::DescribeVpcConnectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_vpc_connector_error(response)
        } else {
            crate::operation_deser::parse_describe_vpc_connector_response(response)
        }
    }
}

/// Operation shape for `DisassociateCustomDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_custom_domain`](crate::client::Client::disassociate_custom_domain).
///
/// See [`crate::client::fluent_builders::DisassociateCustomDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateCustomDomain {
    _private: (),
}
impl DisassociateCustomDomain {
    /// Creates a new builder-style object to manufacture [`DisassociateCustomDomainInput`](crate::input::DisassociateCustomDomainInput)
    pub fn builder() -> crate::input::disassociate_custom_domain_input::Builder {
        crate::input::disassociate_custom_domain_input::Builder::default()
    }
    /// Creates a new `DisassociateCustomDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateCustomDomain {
    type Output = std::result::Result<
        crate::output::DisassociateCustomDomainOutput,
        crate::error::DisassociateCustomDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_custom_domain_error(response)
        } else {
            crate::operation_deser::parse_disassociate_custom_domain_response(response)
        }
    }
}

/// Operation shape for `ListAutoScalingConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_auto_scaling_configurations`](crate::client::Client::list_auto_scaling_configurations).
///
/// See [`crate::client::fluent_builders::ListAutoScalingConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAutoScalingConfigurations {
    _private: (),
}
impl ListAutoScalingConfigurations {
    /// Creates a new builder-style object to manufacture [`ListAutoScalingConfigurationsInput`](crate::input::ListAutoScalingConfigurationsInput)
    pub fn builder() -> crate::input::list_auto_scaling_configurations_input::Builder {
        crate::input::list_auto_scaling_configurations_input::Builder::default()
    }
    /// Creates a new `ListAutoScalingConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAutoScalingConfigurations {
    type Output = std::result::Result<
        crate::output::ListAutoScalingConfigurationsOutput,
        crate::error::ListAutoScalingConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_auto_scaling_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_auto_scaling_configurations_response(response)
        }
    }
}

/// Operation shape for `ListConnections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_connections`](crate::client::Client::list_connections).
///
/// See [`crate::client::fluent_builders::ListConnections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListConnections {
    _private: (),
}
impl ListConnections {
    /// Creates a new builder-style object to manufacture [`ListConnectionsInput`](crate::input::ListConnectionsInput)
    pub fn builder() -> crate::input::list_connections_input::Builder {
        crate::input::list_connections_input::Builder::default()
    }
    /// Creates a new `ListConnections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListConnections {
    type Output = std::result::Result<
        crate::output::ListConnectionsOutput,
        crate::error::ListConnectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_connections_error(response)
        } else {
            crate::operation_deser::parse_list_connections_response(response)
        }
    }
}

/// Operation shape for `ListOperations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_operations`](crate::client::Client::list_operations).
///
/// See [`crate::client::fluent_builders::ListOperations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOperations {
    _private: (),
}
impl ListOperations {
    /// Creates a new builder-style object to manufacture [`ListOperationsInput`](crate::input::ListOperationsInput)
    pub fn builder() -> crate::input::list_operations_input::Builder {
        crate::input::list_operations_input::Builder::default()
    }
    /// Creates a new `ListOperations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOperations {
    type Output =
        std::result::Result<crate::output::ListOperationsOutput, crate::error::ListOperationsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_operations_error(response)
        } else {
            crate::operation_deser::parse_list_operations_response(response)
        }
    }
}

/// Operation shape for `ListServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_services`](crate::client::Client::list_services).
///
/// See [`crate::client::fluent_builders::ListServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListServices {
    _private: (),
}
impl ListServices {
    /// Creates a new builder-style object to manufacture [`ListServicesInput`](crate::input::ListServicesInput)
    pub fn builder() -> crate::input::list_services_input::Builder {
        crate::input::list_services_input::Builder::default()
    }
    /// Creates a new `ListServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListServices {
    type Output =
        std::result::Result<crate::output::ListServicesOutput, crate::error::ListServicesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_services_error(response)
        } else {
            crate::operation_deser::parse_list_services_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListVpcConnectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_vpc_connectors`](crate::client::Client::list_vpc_connectors).
///
/// See [`crate::client::fluent_builders::ListVpcConnectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListVpcConnectors {
    _private: (),
}
impl ListVpcConnectors {
    /// Creates a new builder-style object to manufacture [`ListVpcConnectorsInput`](crate::input::ListVpcConnectorsInput)
    pub fn builder() -> crate::input::list_vpc_connectors_input::Builder {
        crate::input::list_vpc_connectors_input::Builder::default()
    }
    /// Creates a new `ListVpcConnectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListVpcConnectors {
    type Output = std::result::Result<
        crate::output::ListVpcConnectorsOutput,
        crate::error::ListVpcConnectorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_vpc_connectors_error(response)
        } else {
            crate::operation_deser::parse_list_vpc_connectors_response(response)
        }
    }
}

/// Operation shape for `PauseService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`pause_service`](crate::client::Client::pause_service).
///
/// See [`crate::client::fluent_builders::PauseService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PauseService {
    _private: (),
}
impl PauseService {
    /// Creates a new builder-style object to manufacture [`PauseServiceInput`](crate::input::PauseServiceInput)
    pub fn builder() -> crate::input::pause_service_input::Builder {
        crate::input::pause_service_input::Builder::default()
    }
    /// Creates a new `PauseService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PauseService {
    type Output =
        std::result::Result<crate::output::PauseServiceOutput, crate::error::PauseServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_pause_service_error(response)
        } else {
            crate::operation_deser::parse_pause_service_response(response)
        }
    }
}

/// Operation shape for `ResumeService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`resume_service`](crate::client::Client::resume_service).
///
/// See [`crate::client::fluent_builders::ResumeService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResumeService {
    _private: (),
}
impl ResumeService {
    /// Creates a new builder-style object to manufacture [`ResumeServiceInput`](crate::input::ResumeServiceInput)
    pub fn builder() -> crate::input::resume_service_input::Builder {
        crate::input::resume_service_input::Builder::default()
    }
    /// Creates a new `ResumeService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResumeService {
    type Output =
        std::result::Result<crate::output::ResumeServiceOutput, crate::error::ResumeServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_resume_service_error(response)
        } else {
            crate::operation_deser::parse_resume_service_response(response)
        }
    }
}

/// Operation shape for `StartDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_deployment`](crate::client::Client::start_deployment).
///
/// See [`crate::client::fluent_builders::StartDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartDeployment {
    _private: (),
}
impl StartDeployment {
    /// Creates a new builder-style object to manufacture [`StartDeploymentInput`](crate::input::StartDeploymentInput)
    pub fn builder() -> crate::input::start_deployment_input::Builder {
        crate::input::start_deployment_input::Builder::default()
    }
    /// Creates a new `StartDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartDeployment {
    type Output = std::result::Result<
        crate::output::StartDeploymentOutput,
        crate::error::StartDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_deployment_error(response)
        } else {
            crate::operation_deser::parse_start_deployment_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service`](crate::client::Client::update_service).
///
/// See [`crate::client::fluent_builders::UpdateService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateService {
    _private: (),
}
impl UpdateService {
    /// Creates a new builder-style object to manufacture [`UpdateServiceInput`](crate::input::UpdateServiceInput)
    pub fn builder() -> crate::input::update_service_input::Builder {
        crate::input::update_service_input::Builder::default()
    }
    /// Creates a new `UpdateService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateService {
    type Output =
        std::result::Result<crate::output::UpdateServiceOutput, crate::error::UpdateServiceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_error(response)
        } else {
            crate::operation_deser::parse_update_service_response(response)
        }
    }
}
