// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes an App Runner service. It can describe a service in any state, including deleted services.</p>
/// <p>This type contains the full information about a service, including configuration details. It's returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html">CreateService</a>, <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html">DescribeService</a>, and <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html">DeleteService</a> actions. A subset of this information is returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html">ListServices</a> action using the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ServiceSummary.html">ServiceSummary</a> type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Service {
    /// <p>The customer-provided service name.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of this service.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
    pub service_url: std::option::Option<std::string::String>,
    /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the App Runner service was last updated at. It's in the Unix time stamp format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the App Runner service was deleted. It's in the Unix time stamp format.</p>
    pub deleted_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of the App Runner service. These particular values mean the following.</p>
    /// <ul>
    /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
    /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ServiceStatus>,
    /// <p>The source deployed to the App Runner service. It can be a code or an image repository.</p>
    pub source_configuration: std::option::Option<crate::model::SourceConfiguration>,
    /// <p>The runtime configuration of instances (scaling units) of this service.</p>
    pub instance_configuration: std::option::Option<crate::model::InstanceConfiguration>,
    /// <p>The encryption key that App Runner uses to encrypt the service logs and the copy of the source repository that App Runner maintains for the service. It can be either a customer-provided encryption key or an Amazon Web Services managed key.</p>
    pub encryption_configuration: std::option::Option<crate::model::EncryptionConfiguration>,
    /// <p>The settings for the health check that App Runner performs to monitor the health of this service.</p>
    pub health_check_configuration: std::option::Option<crate::model::HealthCheckConfiguration>,
    /// <p>Summary information for the App Runner automatic scaling configuration resource that's associated with this service.</p>
    pub auto_scaling_configuration_summary:
        std::option::Option<crate::model::AutoScalingConfigurationSummary>,
    /// <p>Configuration settings related to network traffic of the web application that this service runs.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
}
impl Service {
    /// <p>The customer-provided service name.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of this service.</p>
    pub fn service_arn(&self) -> std::option::Option<&str> {
        self.service_arn.as_deref()
    }
    /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
    pub fn service_url(&self) -> std::option::Option<&str> {
        self.service_url.as_deref()
    }
    /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the App Runner service was last updated at. It's in the Unix time stamp format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The time when the App Runner service was deleted. It's in the Unix time stamp format.</p>
    pub fn deleted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deleted_at.as_ref()
    }
    /// <p>The current state of the App Runner service. These particular values mean the following.</p>
    /// <ul>
    /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
    /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ServiceStatus> {
        self.status.as_ref()
    }
    /// <p>The source deployed to the App Runner service. It can be a code or an image repository.</p>
    pub fn source_configuration(&self) -> std::option::Option<&crate::model::SourceConfiguration> {
        self.source_configuration.as_ref()
    }
    /// <p>The runtime configuration of instances (scaling units) of this service.</p>
    pub fn instance_configuration(
        &self,
    ) -> std::option::Option<&crate::model::InstanceConfiguration> {
        self.instance_configuration.as_ref()
    }
    /// <p>The encryption key that App Runner uses to encrypt the service logs and the copy of the source repository that App Runner maintains for the service. It can be either a customer-provided encryption key or an Amazon Web Services managed key.</p>
    pub fn encryption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::EncryptionConfiguration> {
        self.encryption_configuration.as_ref()
    }
    /// <p>The settings for the health check that App Runner performs to monitor the health of this service.</p>
    pub fn health_check_configuration(
        &self,
    ) -> std::option::Option<&crate::model::HealthCheckConfiguration> {
        self.health_check_configuration.as_ref()
    }
    /// <p>Summary information for the App Runner automatic scaling configuration resource that's associated with this service.</p>
    pub fn auto_scaling_configuration_summary(
        &self,
    ) -> std::option::Option<&crate::model::AutoScalingConfigurationSummary> {
        self.auto_scaling_configuration_summary.as_ref()
    }
    /// <p>Configuration settings related to network traffic of the web application that this service runs.</p>
    pub fn network_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NetworkConfiguration> {
        self.network_configuration.as_ref()
    }
}
impl std::fmt::Debug for Service {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Service");
        formatter.field("service_name", &self.service_name);
        formatter.field("service_id", &self.service_id);
        formatter.field("service_arn", &self.service_arn);
        formatter.field("service_url", &self.service_url);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("deleted_at", &self.deleted_at);
        formatter.field("status", &self.status);
        formatter.field("source_configuration", &self.source_configuration);
        formatter.field("instance_configuration", &self.instance_configuration);
        formatter.field("encryption_configuration", &self.encryption_configuration);
        formatter.field(
            "health_check_configuration",
            &self.health_check_configuration,
        );
        formatter.field(
            "auto_scaling_configuration_summary",
            &self.auto_scaling_configuration_summary,
        );
        formatter.field("network_configuration", &self.network_configuration);
        formatter.finish()
    }
}
/// See [`Service`](crate::model::Service)
pub mod service {
    /// A builder for [`Service`](crate::model::Service)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) service_url: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deleted_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ServiceStatus>,
        pub(crate) source_configuration: std::option::Option<crate::model::SourceConfiguration>,
        pub(crate) instance_configuration: std::option::Option<crate::model::InstanceConfiguration>,
        pub(crate) encryption_configuration:
            std::option::Option<crate::model::EncryptionConfiguration>,
        pub(crate) health_check_configuration:
            std::option::Option<crate::model::HealthCheckConfiguration>,
        pub(crate) auto_scaling_configuration_summary:
            std::option::Option<crate::model::AutoScalingConfigurationSummary>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    }
    impl Builder {
        /// <p>The customer-provided service name.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The customer-provided service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this service.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this service.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
        pub fn service_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_url = Some(input.into());
            self
        }
        /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
        pub fn set_service_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_url = input;
            self
        }
        /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the App Runner service was last updated at. It's in the Unix time stamp format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time when the App Runner service was last updated at. It's in the Unix time stamp format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The time when the App Runner service was deleted. It's in the Unix time stamp format.</p>
        pub fn deleted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deleted_at = Some(input);
            self
        }
        /// <p>The time when the App Runner service was deleted. It's in the Unix time stamp format.</p>
        pub fn set_deleted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deleted_at = input;
            self
        }
        /// <p>The current state of the App Runner service. These particular values mean the following.</p>
        /// <ul>
        /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
        /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ServiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the App Runner service. These particular values mean the following.</p>
        /// <ul>
        /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. To troubleshoot this failure, read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
        /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ServiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The source deployed to the App Runner service. It can be a code or an image repository.</p>
        pub fn source_configuration(mut self, input: crate::model::SourceConfiguration) -> Self {
            self.source_configuration = Some(input);
            self
        }
        /// <p>The source deployed to the App Runner service. It can be a code or an image repository.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.source_configuration = input;
            self
        }
        /// <p>The runtime configuration of instances (scaling units) of this service.</p>
        pub fn instance_configuration(
            mut self,
            input: crate::model::InstanceConfiguration,
        ) -> Self {
            self.instance_configuration = Some(input);
            self
        }
        /// <p>The runtime configuration of instances (scaling units) of this service.</p>
        pub fn set_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceConfiguration>,
        ) -> Self {
            self.instance_configuration = input;
            self
        }
        /// <p>The encryption key that App Runner uses to encrypt the service logs and the copy of the source repository that App Runner maintains for the service. It can be either a customer-provided encryption key or an Amazon Web Services managed key.</p>
        pub fn encryption_configuration(
            mut self,
            input: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.encryption_configuration = Some(input);
            self
        }
        /// <p>The encryption key that App Runner uses to encrypt the service logs and the copy of the source repository that App Runner maintains for the service. It can be either a customer-provided encryption key or an Amazon Web Services managed key.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.encryption_configuration = input;
            self
        }
        /// <p>The settings for the health check that App Runner performs to monitor the health of this service.</p>
        pub fn health_check_configuration(
            mut self,
            input: crate::model::HealthCheckConfiguration,
        ) -> Self {
            self.health_check_configuration = Some(input);
            self
        }
        /// <p>The settings for the health check that App Runner performs to monitor the health of this service.</p>
        pub fn set_health_check_configuration(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfiguration>,
        ) -> Self {
            self.health_check_configuration = input;
            self
        }
        /// <p>Summary information for the App Runner automatic scaling configuration resource that's associated with this service.</p>
        pub fn auto_scaling_configuration_summary(
            mut self,
            input: crate::model::AutoScalingConfigurationSummary,
        ) -> Self {
            self.auto_scaling_configuration_summary = Some(input);
            self
        }
        /// <p>Summary information for the App Runner automatic scaling configuration resource that's associated with this service.</p>
        pub fn set_auto_scaling_configuration_summary(
            mut self,
            input: std::option::Option<crate::model::AutoScalingConfigurationSummary>,
        ) -> Self {
            self.auto_scaling_configuration_summary = input;
            self
        }
        /// <p>Configuration settings related to network traffic of the web application that this service runs.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>Configuration settings related to network traffic of the web application that this service runs.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Service`](crate::model::Service)
        pub fn build(self) -> crate::model::Service {
            crate::model::Service {
                service_name: self.service_name,
                service_id: self.service_id,
                service_arn: self.service_arn,
                service_url: self.service_url,
                created_at: self.created_at,
                updated_at: self.updated_at,
                deleted_at: self.deleted_at,
                status: self.status,
                source_configuration: self.source_configuration,
                instance_configuration: self.instance_configuration,
                encryption_configuration: self.encryption_configuration,
                health_check_configuration: self.health_check_configuration,
                auto_scaling_configuration_summary: self.auto_scaling_configuration_summary,
                network_configuration: self.network_configuration,
            }
        }
    }
}
impl Service {
    /// Creates a new builder-style object to manufacture [`Service`](crate::model::Service)
    pub fn builder() -> crate::model::service::Builder {
        crate::model::service::Builder::default()
    }
}

/// <p>Describes configuration settings related to network traffic of an App Runner service. Consists of embedded objects for each configurable network feature.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkConfiguration {
    /// <p>Network configuration settings for outbound message traffic.</p>
    pub egress_configuration: std::option::Option<crate::model::EgressConfiguration>,
}
impl NetworkConfiguration {
    /// <p>Network configuration settings for outbound message traffic.</p>
    pub fn egress_configuration(&self) -> std::option::Option<&crate::model::EgressConfiguration> {
        self.egress_configuration.as_ref()
    }
}
impl std::fmt::Debug for NetworkConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkConfiguration");
        formatter.field("egress_configuration", &self.egress_configuration);
        formatter.finish()
    }
}
/// See [`NetworkConfiguration`](crate::model::NetworkConfiguration)
pub mod network_configuration {
    /// A builder for [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) egress_configuration: std::option::Option<crate::model::EgressConfiguration>,
    }
    impl Builder {
        /// <p>Network configuration settings for outbound message traffic.</p>
        pub fn egress_configuration(mut self, input: crate::model::EgressConfiguration) -> Self {
            self.egress_configuration = Some(input);
            self
        }
        /// <p>Network configuration settings for outbound message traffic.</p>
        pub fn set_egress_configuration(
            mut self,
            input: std::option::Option<crate::model::EgressConfiguration>,
        ) -> Self {
            self.egress_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkConfiguration`](crate::model::NetworkConfiguration)
        pub fn build(self) -> crate::model::NetworkConfiguration {
            crate::model::NetworkConfiguration {
                egress_configuration: self.egress_configuration,
            }
        }
    }
}
impl NetworkConfiguration {
    /// Creates a new builder-style object to manufacture [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    pub fn builder() -> crate::model::network_configuration::Builder {
        crate::model::network_configuration::Builder::default()
    }
}

/// <p>Describes configuration settings related to outbound network traffic of an App Runner service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EgressConfiguration {
    /// <p>The type of egress configuration.</p>
    /// <p>Set to <code>DEFAULT</code> for access to resources hosted on public networks.</p>
    /// <p>Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.</p>
    pub egress_type: std::option::Option<crate::model::EgressType>,
    /// <p>The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when <code>EgressType = VPC</code>.</p>
    pub vpc_connector_arn: std::option::Option<std::string::String>,
}
impl EgressConfiguration {
    /// <p>The type of egress configuration.</p>
    /// <p>Set to <code>DEFAULT</code> for access to resources hosted on public networks.</p>
    /// <p>Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.</p>
    pub fn egress_type(&self) -> std::option::Option<&crate::model::EgressType> {
        self.egress_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when <code>EgressType = VPC</code>.</p>
    pub fn vpc_connector_arn(&self) -> std::option::Option<&str> {
        self.vpc_connector_arn.as_deref()
    }
}
impl std::fmt::Debug for EgressConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EgressConfiguration");
        formatter.field("egress_type", &self.egress_type);
        formatter.field("vpc_connector_arn", &self.vpc_connector_arn);
        formatter.finish()
    }
}
/// See [`EgressConfiguration`](crate::model::EgressConfiguration)
pub mod egress_configuration {
    /// A builder for [`EgressConfiguration`](crate::model::EgressConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) egress_type: std::option::Option<crate::model::EgressType>,
        pub(crate) vpc_connector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of egress configuration.</p>
        /// <p>Set to <code>DEFAULT</code> for access to resources hosted on public networks.</p>
        /// <p>Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.</p>
        pub fn egress_type(mut self, input: crate::model::EgressType) -> Self {
            self.egress_type = Some(input);
            self
        }
        /// <p>The type of egress configuration.</p>
        /// <p>Set to <code>DEFAULT</code> for access to resources hosted on public networks.</p>
        /// <p>Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.</p>
        pub fn set_egress_type(
            mut self,
            input: std::option::Option<crate::model::EgressType>,
        ) -> Self {
            self.egress_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when <code>EgressType = VPC</code>.</p>
        pub fn vpc_connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner service. Only valid when <code>EgressType = VPC</code>.</p>
        pub fn set_vpc_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_connector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EgressConfiguration`](crate::model::EgressConfiguration)
        pub fn build(self) -> crate::model::EgressConfiguration {
            crate::model::EgressConfiguration {
                egress_type: self.egress_type,
                vpc_connector_arn: self.vpc_connector_arn,
            }
        }
    }
}
impl EgressConfiguration {
    /// Creates a new builder-style object to manufacture [`EgressConfiguration`](crate::model::EgressConfiguration)
    pub fn builder() -> crate::model::egress_configuration::Builder {
        crate::model::egress_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EgressType {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Vpc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EgressType {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => EgressType::Default,
            "VPC" => EgressType::Vpc,
            other => EgressType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EgressType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EgressType::from(s))
    }
}
impl EgressType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EgressType::Default => "DEFAULT",
            EgressType::Vpc => "VPC",
            EgressType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "VPC"]
    }
}
impl AsRef<str> for EgressType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information about an App Runner automatic scaling configuration resource.</p>
/// <p>This type contains limited information about an auto scaling configuration. It includes only identification information, without configuration details. It's returned by the <code>ListAutoScalingConfigurations</code> action. Complete configuration information is returned by the <code>CreateAutoScalingConfiguration</code>, <code>DescribeAutoScalingConfiguration</code>, and <code>DeleteAutoScalingConfiguration</code> actions using the <code>AutoScalingConfiguration</code> type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingConfigurationSummary {
    /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
    pub auto_scaling_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
    pub auto_scaling_configuration_name: std::option::Option<std::string::String>,
    /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.</p>
    pub auto_scaling_configuration_revision: i32,
}
impl AutoScalingConfigurationSummary {
    /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
    pub fn auto_scaling_configuration_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_configuration_arn.as_deref()
    }
    /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
    pub fn auto_scaling_configuration_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_configuration_name.as_deref()
    }
    /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.</p>
    pub fn auto_scaling_configuration_revision(&self) -> i32 {
        self.auto_scaling_configuration_revision
    }
}
impl std::fmt::Debug for AutoScalingConfigurationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingConfigurationSummary");
        formatter.field(
            "auto_scaling_configuration_arn",
            &self.auto_scaling_configuration_arn,
        );
        formatter.field(
            "auto_scaling_configuration_name",
            &self.auto_scaling_configuration_name,
        );
        formatter.field(
            "auto_scaling_configuration_revision",
            &self.auto_scaling_configuration_revision,
        );
        formatter.finish()
    }
}
/// See [`AutoScalingConfigurationSummary`](crate::model::AutoScalingConfigurationSummary)
pub mod auto_scaling_configuration_summary {
    /// A builder for [`AutoScalingConfigurationSummary`](crate::model::AutoScalingConfigurationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_configuration_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_configuration_revision: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
        pub fn auto_scaling_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
        pub fn set_auto_scaling_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_arn = input;
            self
        }
        /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
        pub fn auto_scaling_configuration_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_name = Some(input.into());
            self
        }
        /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
        pub fn set_auto_scaling_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_name = input;
            self
        }
        /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.</p>
        pub fn auto_scaling_configuration_revision(mut self, input: i32) -> Self {
            self.auto_scaling_configuration_revision = Some(input);
            self
        }
        /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.</p>
        pub fn set_auto_scaling_configuration_revision(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.auto_scaling_configuration_revision = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingConfigurationSummary`](crate::model::AutoScalingConfigurationSummary)
        pub fn build(self) -> crate::model::AutoScalingConfigurationSummary {
            crate::model::AutoScalingConfigurationSummary {
                auto_scaling_configuration_arn: self.auto_scaling_configuration_arn,
                auto_scaling_configuration_name: self.auto_scaling_configuration_name,
                auto_scaling_configuration_revision: self
                    .auto_scaling_configuration_revision
                    .unwrap_or_default(),
            }
        }
    }
}
impl AutoScalingConfigurationSummary {
    /// Creates a new builder-style object to manufacture [`AutoScalingConfigurationSummary`](crate::model::AutoScalingConfigurationSummary)
    pub fn builder() -> crate::model::auto_scaling_configuration_summary::Builder {
        crate::model::auto_scaling_configuration_summary::Builder::default()
    }
}

/// <p>Describes the settings for the health check that App Runner performs to monitor the health of a service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HealthCheckConfiguration {
    /// <p>The IP protocol that App Runner uses to perform health checks for your service.</p>
    /// <p>If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP path specified by <code>Path</code>.</p>
    /// <p>Default: <code>TCP</code> </p>
    pub protocol: std::option::Option<crate::model::HealthCheckProtocol>,
    /// <p>The URL that health check requests are sent to.</p>
    /// <p> <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.</p>
    /// <p>Default: <code>"/"</code> </p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The time interval, in seconds, between health checks.</p>
    /// <p>Default: <code>5</code> </p>
    pub interval: std::option::Option<i32>,
    /// <p>The time, in seconds, to wait for a health check response before deciding it failed.</p>
    /// <p>Default: <code>2</code> </p>
    pub timeout: std::option::Option<i32>,
    /// <p>The number of consecutive checks that must succeed before App Runner decides that the service is healthy.</p>
    /// <p>Default: <code>1</code> </p>
    pub healthy_threshold: std::option::Option<i32>,
    /// <p>The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.</p>
    /// <p>Default: <code>5</code> </p>
    pub unhealthy_threshold: std::option::Option<i32>,
}
impl HealthCheckConfiguration {
    /// <p>The IP protocol that App Runner uses to perform health checks for your service.</p>
    /// <p>If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP path specified by <code>Path</code>.</p>
    /// <p>Default: <code>TCP</code> </p>
    pub fn protocol(&self) -> std::option::Option<&crate::model::HealthCheckProtocol> {
        self.protocol.as_ref()
    }
    /// <p>The URL that health check requests are sent to.</p>
    /// <p> <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.</p>
    /// <p>Default: <code>"/"</code> </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The time interval, in seconds, between health checks.</p>
    /// <p>Default: <code>5</code> </p>
    pub fn interval(&self) -> std::option::Option<i32> {
        self.interval
    }
    /// <p>The time, in seconds, to wait for a health check response before deciding it failed.</p>
    /// <p>Default: <code>2</code> </p>
    pub fn timeout(&self) -> std::option::Option<i32> {
        self.timeout
    }
    /// <p>The number of consecutive checks that must succeed before App Runner decides that the service is healthy.</p>
    /// <p>Default: <code>1</code> </p>
    pub fn healthy_threshold(&self) -> std::option::Option<i32> {
        self.healthy_threshold
    }
    /// <p>The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.</p>
    /// <p>Default: <code>5</code> </p>
    pub fn unhealthy_threshold(&self) -> std::option::Option<i32> {
        self.unhealthy_threshold
    }
}
impl std::fmt::Debug for HealthCheckConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HealthCheckConfiguration");
        formatter.field("protocol", &self.protocol);
        formatter.field("path", &self.path);
        formatter.field("interval", &self.interval);
        formatter.field("timeout", &self.timeout);
        formatter.field("healthy_threshold", &self.healthy_threshold);
        formatter.field("unhealthy_threshold", &self.unhealthy_threshold);
        formatter.finish()
    }
}
/// See [`HealthCheckConfiguration`](crate::model::HealthCheckConfiguration)
pub mod health_check_configuration {
    /// A builder for [`HealthCheckConfiguration`](crate::model::HealthCheckConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<crate::model::HealthCheckProtocol>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) interval: std::option::Option<i32>,
        pub(crate) timeout: std::option::Option<i32>,
        pub(crate) healthy_threshold: std::option::Option<i32>,
        pub(crate) unhealthy_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The IP protocol that App Runner uses to perform health checks for your service.</p>
        /// <p>If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP path specified by <code>Path</code>.</p>
        /// <p>Default: <code>TCP</code> </p>
        pub fn protocol(mut self, input: crate::model::HealthCheckProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The IP protocol that App Runner uses to perform health checks for your service.</p>
        /// <p>If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP path specified by <code>Path</code>.</p>
        /// <p>Default: <code>TCP</code> </p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::HealthCheckProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The URL that health check requests are sent to.</p>
        /// <p> <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.</p>
        /// <p>Default: <code>"/"</code> </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The URL that health check requests are sent to.</p>
        /// <p> <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.</p>
        /// <p>Default: <code>"/"</code> </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The time interval, in seconds, between health checks.</p>
        /// <p>Default: <code>5</code> </p>
        pub fn interval(mut self, input: i32) -> Self {
            self.interval = Some(input);
            self
        }
        /// <p>The time interval, in seconds, between health checks.</p>
        /// <p>Default: <code>5</code> </p>
        pub fn set_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.interval = input;
            self
        }
        /// <p>The time, in seconds, to wait for a health check response before deciding it failed.</p>
        /// <p>Default: <code>2</code> </p>
        pub fn timeout(mut self, input: i32) -> Self {
            self.timeout = Some(input);
            self
        }
        /// <p>The time, in seconds, to wait for a health check response before deciding it failed.</p>
        /// <p>Default: <code>2</code> </p>
        pub fn set_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout = input;
            self
        }
        /// <p>The number of consecutive checks that must succeed before App Runner decides that the service is healthy.</p>
        /// <p>Default: <code>1</code> </p>
        pub fn healthy_threshold(mut self, input: i32) -> Self {
            self.healthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive checks that must succeed before App Runner decides that the service is healthy.</p>
        /// <p>Default: <code>1</code> </p>
        pub fn set_healthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_threshold = input;
            self
        }
        /// <p>The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.</p>
        /// <p>Default: <code>5</code> </p>
        pub fn unhealthy_threshold(mut self, input: i32) -> Self {
            self.unhealthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.</p>
        /// <p>Default: <code>5</code> </p>
        pub fn set_unhealthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`HealthCheckConfiguration`](crate::model::HealthCheckConfiguration)
        pub fn build(self) -> crate::model::HealthCheckConfiguration {
            crate::model::HealthCheckConfiguration {
                protocol: self.protocol,
                path: self.path,
                interval: self.interval,
                timeout: self.timeout,
                healthy_threshold: self.healthy_threshold,
                unhealthy_threshold: self.unhealthy_threshold,
            }
        }
    }
}
impl HealthCheckConfiguration {
    /// Creates a new builder-style object to manufacture [`HealthCheckConfiguration`](crate::model::HealthCheckConfiguration)
    pub fn builder() -> crate::model::health_check_configuration::Builder {
        crate::model::health_check_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HealthCheckProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HealthCheckProtocol {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => HealthCheckProtocol::Http,
            "TCP" => HealthCheckProtocol::Tcp,
            other => HealthCheckProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HealthCheckProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HealthCheckProtocol::from(s))
    }
}
impl HealthCheckProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HealthCheckProtocol::Http => "HTTP",
            HealthCheckProtocol::Tcp => "TCP",
            HealthCheckProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "TCP"]
    }
}
impl AsRef<str> for HealthCheckProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a custom encryption key that App Runner uses to encrypt copies of the source repository and service logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncryptionConfiguration {
    /// <p>The ARN of the KMS key that's used for encryption.</p>
    pub kms_key: std::option::Option<std::string::String>,
}
impl EncryptionConfiguration {
    /// <p>The ARN of the KMS key that's used for encryption.</p>
    pub fn kms_key(&self) -> std::option::Option<&str> {
        self.kms_key.as_deref()
    }
}
impl std::fmt::Debug for EncryptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncryptionConfiguration");
        formatter.field("kms_key", &self.kms_key);
        formatter.finish()
    }
}
/// See [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
pub mod encryption_configuration {
    /// A builder for [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the KMS key that's used for encryption.</p>
        pub fn kms_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key = Some(input.into());
            self
        }
        /// <p>The ARN of the KMS key that's used for encryption.</p>
        pub fn set_kms_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key = input;
            self
        }
        /// Consumes the builder and constructs a [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
        pub fn build(self) -> crate::model::EncryptionConfiguration {
            crate::model::EncryptionConfiguration {
                kms_key: self.kms_key,
            }
        }
    }
}
impl EncryptionConfiguration {
    /// Creates a new builder-style object to manufacture [`EncryptionConfiguration`](crate::model::EncryptionConfiguration)
    pub fn builder() -> crate::model::encryption_configuration::Builder {
        crate::model::encryption_configuration::Builder::default()
    }
}

/// <p>Describes the runtime configuration of an App Runner service instance (scaling unit).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceConfiguration {
    /// <p>The number of CPU units reserved for each instance of your App Runner service.</p>
    /// <p>Default: <code>1 vCPU</code> </p>
    pub cpu: std::option::Option<std::string::String>,
    /// <p>The amount of memory, in MB or GB, reserved for each instance of your App Runner service.</p>
    /// <p>Default: <code>2 GB</code> </p>
    pub memory: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any Amazon Web Services APIs.</p>
    pub instance_role_arn: std::option::Option<std::string::String>,
}
impl InstanceConfiguration {
    /// <p>The number of CPU units reserved for each instance of your App Runner service.</p>
    /// <p>Default: <code>1 vCPU</code> </p>
    pub fn cpu(&self) -> std::option::Option<&str> {
        self.cpu.as_deref()
    }
    /// <p>The amount of memory, in MB or GB, reserved for each instance of your App Runner service.</p>
    /// <p>Default: <code>2 GB</code> </p>
    pub fn memory(&self) -> std::option::Option<&str> {
        self.memory.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any Amazon Web Services APIs.</p>
    pub fn instance_role_arn(&self) -> std::option::Option<&str> {
        self.instance_role_arn.as_deref()
    }
}
impl std::fmt::Debug for InstanceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceConfiguration");
        formatter.field("cpu", &self.cpu);
        formatter.field("memory", &self.memory);
        formatter.field("instance_role_arn", &self.instance_role_arn);
        formatter.finish()
    }
}
/// See [`InstanceConfiguration`](crate::model::InstanceConfiguration)
pub mod instance_configuration {
    /// A builder for [`InstanceConfiguration`](crate::model::InstanceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu: std::option::Option<std::string::String>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) instance_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of CPU units reserved for each instance of your App Runner service.</p>
        /// <p>Default: <code>1 vCPU</code> </p>
        pub fn cpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.cpu = Some(input.into());
            self
        }
        /// <p>The number of CPU units reserved for each instance of your App Runner service.</p>
        /// <p>Default: <code>1 vCPU</code> </p>
        pub fn set_cpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cpu = input;
            self
        }
        /// <p>The amount of memory, in MB or GB, reserved for each instance of your App Runner service.</p>
        /// <p>Default: <code>2 GB</code> </p>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The amount of memory, in MB or GB, reserved for each instance of your App Runner service.</p>
        /// <p>Default: <code>2 GB</code> </p>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any Amazon Web Services APIs.</p>
        pub fn instance_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any Amazon Web Services APIs.</p>
        pub fn set_instance_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceConfiguration`](crate::model::InstanceConfiguration)
        pub fn build(self) -> crate::model::InstanceConfiguration {
            crate::model::InstanceConfiguration {
                cpu: self.cpu,
                memory: self.memory,
                instance_role_arn: self.instance_role_arn,
            }
        }
    }
}
impl InstanceConfiguration {
    /// Creates a new builder-style object to manufacture [`InstanceConfiguration`](crate::model::InstanceConfiguration)
    pub fn builder() -> crate::model::instance_configuration::Builder {
        crate::model::instance_configuration::Builder::default()
    }
}

/// <p>Describes the source deployed to an App Runner service. It can be a code or an image repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceConfiguration {
    /// <p>The description of a source code repository.</p>
    /// <p>You must provide either this member or <code>ImageRepository</code> (but not both).</p>
    pub code_repository: std::option::Option<crate::model::CodeRepository>,
    /// <p>The description of a source image repository.</p>
    /// <p>You must provide either this member or <code>CodeRepository</code> (but not both).</p>
    pub image_repository: std::option::Option<crate::model::ImageRepository>,
    /// <p>If <code>true</code>, continuous integration from the source repository is enabled for the App Runner service. Each repository change (including any source code commit or new image version) starts a deployment.</p>
    /// <p>Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that's in an Amazon Web Services account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).</p>
    pub auto_deployments_enabled: std::option::Option<bool>,
    /// <p>Describes the resources that are needed to authenticate access to some source repositories.</p>
    pub authentication_configuration:
        std::option::Option<crate::model::AuthenticationConfiguration>,
}
impl SourceConfiguration {
    /// <p>The description of a source code repository.</p>
    /// <p>You must provide either this member or <code>ImageRepository</code> (but not both).</p>
    pub fn code_repository(&self) -> std::option::Option<&crate::model::CodeRepository> {
        self.code_repository.as_ref()
    }
    /// <p>The description of a source image repository.</p>
    /// <p>You must provide either this member or <code>CodeRepository</code> (but not both).</p>
    pub fn image_repository(&self) -> std::option::Option<&crate::model::ImageRepository> {
        self.image_repository.as_ref()
    }
    /// <p>If <code>true</code>, continuous integration from the source repository is enabled for the App Runner service. Each repository change (including any source code commit or new image version) starts a deployment.</p>
    /// <p>Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that's in an Amazon Web Services account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).</p>
    pub fn auto_deployments_enabled(&self) -> std::option::Option<bool> {
        self.auto_deployments_enabled
    }
    /// <p>Describes the resources that are needed to authenticate access to some source repositories.</p>
    pub fn authentication_configuration(
        &self,
    ) -> std::option::Option<&crate::model::AuthenticationConfiguration> {
        self.authentication_configuration.as_ref()
    }
}
impl std::fmt::Debug for SourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceConfiguration");
        formatter.field("code_repository", &self.code_repository);
        formatter.field("image_repository", &self.image_repository);
        formatter.field("auto_deployments_enabled", &self.auto_deployments_enabled);
        formatter.field(
            "authentication_configuration",
            &self.authentication_configuration,
        );
        formatter.finish()
    }
}
/// See [`SourceConfiguration`](crate::model::SourceConfiguration)
pub mod source_configuration {
    /// A builder for [`SourceConfiguration`](crate::model::SourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code_repository: std::option::Option<crate::model::CodeRepository>,
        pub(crate) image_repository: std::option::Option<crate::model::ImageRepository>,
        pub(crate) auto_deployments_enabled: std::option::Option<bool>,
        pub(crate) authentication_configuration:
            std::option::Option<crate::model::AuthenticationConfiguration>,
    }
    impl Builder {
        /// <p>The description of a source code repository.</p>
        /// <p>You must provide either this member or <code>ImageRepository</code> (but not both).</p>
        pub fn code_repository(mut self, input: crate::model::CodeRepository) -> Self {
            self.code_repository = Some(input);
            self
        }
        /// <p>The description of a source code repository.</p>
        /// <p>You must provide either this member or <code>ImageRepository</code> (but not both).</p>
        pub fn set_code_repository(
            mut self,
            input: std::option::Option<crate::model::CodeRepository>,
        ) -> Self {
            self.code_repository = input;
            self
        }
        /// <p>The description of a source image repository.</p>
        /// <p>You must provide either this member or <code>CodeRepository</code> (but not both).</p>
        pub fn image_repository(mut self, input: crate::model::ImageRepository) -> Self {
            self.image_repository = Some(input);
            self
        }
        /// <p>The description of a source image repository.</p>
        /// <p>You must provide either this member or <code>CodeRepository</code> (but not both).</p>
        pub fn set_image_repository(
            mut self,
            input: std::option::Option<crate::model::ImageRepository>,
        ) -> Self {
            self.image_repository = input;
            self
        }
        /// <p>If <code>true</code>, continuous integration from the source repository is enabled for the App Runner service. Each repository change (including any source code commit or new image version) starts a deployment.</p>
        /// <p>Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that's in an Amazon Web Services account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).</p>
        pub fn auto_deployments_enabled(mut self, input: bool) -> Self {
            self.auto_deployments_enabled = Some(input);
            self
        }
        /// <p>If <code>true</code>, continuous integration from the source repository is enabled for the App Runner service. Each repository change (including any source code commit or new image version) starts a deployment.</p>
        /// <p>Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR repository that's in an Amazon Web Services account other than the one that the service is in. App Runner sets to <code>true</code> in all other cases (which currently include a source code repository or a source image using a same-account ECR repository).</p>
        pub fn set_auto_deployments_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_deployments_enabled = input;
            self
        }
        /// <p>Describes the resources that are needed to authenticate access to some source repositories.</p>
        pub fn authentication_configuration(
            mut self,
            input: crate::model::AuthenticationConfiguration,
        ) -> Self {
            self.authentication_configuration = Some(input);
            self
        }
        /// <p>Describes the resources that are needed to authenticate access to some source repositories.</p>
        pub fn set_authentication_configuration(
            mut self,
            input: std::option::Option<crate::model::AuthenticationConfiguration>,
        ) -> Self {
            self.authentication_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceConfiguration`](crate::model::SourceConfiguration)
        pub fn build(self) -> crate::model::SourceConfiguration {
            crate::model::SourceConfiguration {
                code_repository: self.code_repository,
                image_repository: self.image_repository,
                auto_deployments_enabled: self.auto_deployments_enabled,
                authentication_configuration: self.authentication_configuration,
            }
        }
    }
}
impl SourceConfiguration {
    /// Creates a new builder-style object to manufacture [`SourceConfiguration`](crate::model::SourceConfiguration)
    pub fn builder() -> crate::model::source_configuration::Builder {
        crate::model::source_configuration::Builder::default()
    }
}

/// <p>Describes resources needed to authenticate access to some source repositories. The specific resource depends on the repository provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository. It's required for GitHub code repositories.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository. It's required for ECR image repositories (but not for ECR Public repositories).</p>
    pub access_role_arn: std::option::Option<std::string::String>,
}
impl AuthenticationConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository. It's required for GitHub code repositories.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository. It's required for ECR image repositories (but not for ECR Public repositories).</p>
    pub fn access_role_arn(&self) -> std::option::Option<&str> {
        self.access_role_arn.as_deref()
    }
}
impl std::fmt::Debug for AuthenticationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationConfiguration");
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("access_role_arn", &self.access_role_arn);
        formatter.finish()
    }
}
/// See [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
pub mod authentication_configuration {
    /// A builder for [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) access_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository. It's required for GitHub code repositories.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner connection that enables the App Runner service to connect to a source repository. It's required for GitHub code repositories.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository. It's required for ECR image repositories (but not for ECR Public repositories).</p>
        pub fn access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that grants the App Runner service access to a source repository. It's required for ECR image repositories (but not for ECR Public repositories).</p>
        pub fn set_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
        pub fn build(self) -> crate::model::AuthenticationConfiguration {
            crate::model::AuthenticationConfiguration {
                connection_arn: self.connection_arn,
                access_role_arn: self.access_role_arn,
            }
        }
    }
}
impl AuthenticationConfiguration {
    /// Creates a new builder-style object to manufacture [`AuthenticationConfiguration`](crate::model::AuthenticationConfiguration)
    pub fn builder() -> crate::model::authentication_configuration::Builder {
        crate::model::authentication_configuration::Builder::default()
    }
}

/// <p>Describes a source image repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageRepository {
    /// <p>The identifier of an image.</p>
    /// <p>For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an image</a> in the <i>Amazon ECR User Guide</i>.</p>
    pub image_identifier: std::option::Option<std::string::String>,
    /// <p>Configuration for running the identified image.</p>
    pub image_configuration: std::option::Option<crate::model::ImageConfiguration>,
    /// <p>The type of the image repository. This reflects the repository provider and whether the repository is private or public.</p>
    pub image_repository_type: std::option::Option<crate::model::ImageRepositoryType>,
}
impl ImageRepository {
    /// <p>The identifier of an image.</p>
    /// <p>For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an image</a> in the <i>Amazon ECR User Guide</i>.</p>
    pub fn image_identifier(&self) -> std::option::Option<&str> {
        self.image_identifier.as_deref()
    }
    /// <p>Configuration for running the identified image.</p>
    pub fn image_configuration(&self) -> std::option::Option<&crate::model::ImageConfiguration> {
        self.image_configuration.as_ref()
    }
    /// <p>The type of the image repository. This reflects the repository provider and whether the repository is private or public.</p>
    pub fn image_repository_type(&self) -> std::option::Option<&crate::model::ImageRepositoryType> {
        self.image_repository_type.as_ref()
    }
}
impl std::fmt::Debug for ImageRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageRepository");
        formatter.field("image_identifier", &self.image_identifier);
        formatter.field("image_configuration", &self.image_configuration);
        formatter.field("image_repository_type", &self.image_repository_type);
        formatter.finish()
    }
}
/// See [`ImageRepository`](crate::model::ImageRepository)
pub mod image_repository {
    /// A builder for [`ImageRepository`](crate::model::ImageRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image_identifier: std::option::Option<std::string::String>,
        pub(crate) image_configuration: std::option::Option<crate::model::ImageConfiguration>,
        pub(crate) image_repository_type: std::option::Option<crate::model::ImageRepositoryType>,
    }
    impl Builder {
        /// <p>The identifier of an image.</p>
        /// <p>For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an image</a> in the <i>Amazon ECR User Guide</i>.</p>
        pub fn image_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of an image.</p>
        /// <p>For an image in Amazon Elastic Container Registry (Amazon ECR), this is an image name. For the image name format, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an image</a> in the <i>Amazon ECR User Guide</i>.</p>
        pub fn set_image_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_identifier = input;
            self
        }
        /// <p>Configuration for running the identified image.</p>
        pub fn image_configuration(mut self, input: crate::model::ImageConfiguration) -> Self {
            self.image_configuration = Some(input);
            self
        }
        /// <p>Configuration for running the identified image.</p>
        pub fn set_image_configuration(
            mut self,
            input: std::option::Option<crate::model::ImageConfiguration>,
        ) -> Self {
            self.image_configuration = input;
            self
        }
        /// <p>The type of the image repository. This reflects the repository provider and whether the repository is private or public.</p>
        pub fn image_repository_type(mut self, input: crate::model::ImageRepositoryType) -> Self {
            self.image_repository_type = Some(input);
            self
        }
        /// <p>The type of the image repository. This reflects the repository provider and whether the repository is private or public.</p>
        pub fn set_image_repository_type(
            mut self,
            input: std::option::Option<crate::model::ImageRepositoryType>,
        ) -> Self {
            self.image_repository_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageRepository`](crate::model::ImageRepository)
        pub fn build(self) -> crate::model::ImageRepository {
            crate::model::ImageRepository {
                image_identifier: self.image_identifier,
                image_configuration: self.image_configuration,
                image_repository_type: self.image_repository_type,
            }
        }
    }
}
impl ImageRepository {
    /// Creates a new builder-style object to manufacture [`ImageRepository`](crate::model::ImageRepository)
    pub fn builder() -> crate::model::image_repository::Builder {
        crate::model::image_repository::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImageRepositoryType {
    #[allow(missing_docs)] // documentation missing in model
    Ecr,
    #[allow(missing_docs)] // documentation missing in model
    EcrPublic,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImageRepositoryType {
    fn from(s: &str) -> Self {
        match s {
            "ECR" => ImageRepositoryType::Ecr,
            "ECR_PUBLIC" => ImageRepositoryType::EcrPublic,
            other => ImageRepositoryType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImageRepositoryType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImageRepositoryType::from(s))
    }
}
impl ImageRepositoryType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImageRepositoryType::Ecr => "ECR",
            ImageRepositoryType::EcrPublic => "ECR_PUBLIC",
            ImageRepositoryType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ECR", "ECR_PUBLIC"]
    }
}
impl AsRef<str> for ImageRepositoryType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the configuration that App Runner uses to run an App Runner service using an image pulled from a source image repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageConfiguration {
    /// <p>Environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
    pub runtime_environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An optional command that App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.</p>
    pub start_command: std::option::Option<std::string::String>,
    /// <p>The port that your application listens to in the container.</p>
    /// <p>Default: <code>8080</code> </p>
    pub port: std::option::Option<std::string::String>,
}
impl ImageConfiguration {
    /// <p>Environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
    pub fn runtime_environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.runtime_environment_variables.as_ref()
    }
    /// <p>An optional command that App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.</p>
    pub fn start_command(&self) -> std::option::Option<&str> {
        self.start_command.as_deref()
    }
    /// <p>The port that your application listens to in the container.</p>
    /// <p>Default: <code>8080</code> </p>
    pub fn port(&self) -> std::option::Option<&str> {
        self.port.as_deref()
    }
}
impl std::fmt::Debug for ImageConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageConfiguration");
        formatter.field(
            "runtime_environment_variables",
            &self.runtime_environment_variables,
        );
        formatter.field("start_command", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.finish()
    }
}
/// See [`ImageConfiguration`](crate::model::ImageConfiguration)
pub mod image_configuration {
    /// A builder for [`ImageConfiguration`](crate::model::ImageConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) runtime_environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) start_command: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `runtime_environment_variables`.
        ///
        /// To override the contents of this collection use [`set_runtime_environment_variables`](Self::set_runtime_environment_variables).
        ///
        /// <p>Environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
        pub fn runtime_environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.runtime_environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.runtime_environment_variables = Some(hash_map);
            self
        }
        /// <p>Environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
        pub fn set_runtime_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.runtime_environment_variables = input;
            self
        }
        /// <p>An optional command that App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.</p>
        pub fn start_command(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_command = Some(input.into());
            self
        }
        /// <p>An optional command that App Runner runs to start the application in the source image. If specified, this command overrides the Docker image’s default start command.</p>
        pub fn set_start_command(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_command = input;
            self
        }
        /// <p>The port that your application listens to in the container.</p>
        /// <p>Default: <code>8080</code> </p>
        pub fn port(mut self, input: impl Into<std::string::String>) -> Self {
            self.port = Some(input.into());
            self
        }
        /// <p>The port that your application listens to in the container.</p>
        /// <p>Default: <code>8080</code> </p>
        pub fn set_port(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.port = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageConfiguration`](crate::model::ImageConfiguration)
        pub fn build(self) -> crate::model::ImageConfiguration {
            crate::model::ImageConfiguration {
                runtime_environment_variables: self.runtime_environment_variables,
                start_command: self.start_command,
                port: self.port,
            }
        }
    }
}
impl ImageConfiguration {
    /// Creates a new builder-style object to manufacture [`ImageConfiguration`](crate::model::ImageConfiguration)
    pub fn builder() -> crate::model::image_configuration::Builder {
        crate::model::image_configuration::Builder::default()
    }
}

/// <p>Describes a source code repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeRepository {
    /// <p>The location of the repository that contains the source code.</p>
    pub repository_url: std::option::Option<std::string::String>,
    /// <p>The version that should be used within the source code repository.</p>
    pub source_code_version: std::option::Option<crate::model::SourceCodeVersion>,
    /// <p>Configuration for building and running the service from a source code repository.</p>
    pub code_configuration: std::option::Option<crate::model::CodeConfiguration>,
}
impl CodeRepository {
    /// <p>The location of the repository that contains the source code.</p>
    pub fn repository_url(&self) -> std::option::Option<&str> {
        self.repository_url.as_deref()
    }
    /// <p>The version that should be used within the source code repository.</p>
    pub fn source_code_version(&self) -> std::option::Option<&crate::model::SourceCodeVersion> {
        self.source_code_version.as_ref()
    }
    /// <p>Configuration for building and running the service from a source code repository.</p>
    pub fn code_configuration(&self) -> std::option::Option<&crate::model::CodeConfiguration> {
        self.code_configuration.as_ref()
    }
}
impl std::fmt::Debug for CodeRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeRepository");
        formatter.field("repository_url", &self.repository_url);
        formatter.field("source_code_version", &self.source_code_version);
        formatter.field("code_configuration", &self.code_configuration);
        formatter.finish()
    }
}
/// See [`CodeRepository`](crate::model::CodeRepository)
pub mod code_repository {
    /// A builder for [`CodeRepository`](crate::model::CodeRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_url: std::option::Option<std::string::String>,
        pub(crate) source_code_version: std::option::Option<crate::model::SourceCodeVersion>,
        pub(crate) code_configuration: std::option::Option<crate::model::CodeConfiguration>,
    }
    impl Builder {
        /// <p>The location of the repository that contains the source code.</p>
        pub fn repository_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_url = Some(input.into());
            self
        }
        /// <p>The location of the repository that contains the source code.</p>
        pub fn set_repository_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_url = input;
            self
        }
        /// <p>The version that should be used within the source code repository.</p>
        pub fn source_code_version(mut self, input: crate::model::SourceCodeVersion) -> Self {
            self.source_code_version = Some(input);
            self
        }
        /// <p>The version that should be used within the source code repository.</p>
        pub fn set_source_code_version(
            mut self,
            input: std::option::Option<crate::model::SourceCodeVersion>,
        ) -> Self {
            self.source_code_version = input;
            self
        }
        /// <p>Configuration for building and running the service from a source code repository.</p>
        pub fn code_configuration(mut self, input: crate::model::CodeConfiguration) -> Self {
            self.code_configuration = Some(input);
            self
        }
        /// <p>Configuration for building and running the service from a source code repository.</p>
        pub fn set_code_configuration(
            mut self,
            input: std::option::Option<crate::model::CodeConfiguration>,
        ) -> Self {
            self.code_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeRepository`](crate::model::CodeRepository)
        pub fn build(self) -> crate::model::CodeRepository {
            crate::model::CodeRepository {
                repository_url: self.repository_url,
                source_code_version: self.source_code_version,
                code_configuration: self.code_configuration,
            }
        }
    }
}
impl CodeRepository {
    /// Creates a new builder-style object to manufacture [`CodeRepository`](crate::model::CodeRepository)
    pub fn builder() -> crate::model::code_repository::Builder {
        crate::model::code_repository::Builder::default()
    }
}

/// <p>Describes the configuration that App Runner uses to build and run an App Runner service from a source code repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeConfiguration {
    /// <p>The source of the App Runner configuration. Values are interpreted as follows:</p>
    /// <ul>
    /// <li> <p> <code>REPOSITORY</code> – App Runner reads configuration values from the <code>apprunner.yaml</code> file in the source code repository and ignores <code>CodeConfigurationValues</code>.</p> </li>
    /// <li> <p> <code>API</code> – App Runner uses configuration values provided in <code>CodeConfigurationValues</code> and ignores the <code>apprunner.yaml</code> file in the source code repository.</p> </li>
    /// </ul>
    pub configuration_source: std::option::Option<crate::model::ConfigurationSource>,
    /// <p>The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).</p>
    pub code_configuration_values: std::option::Option<crate::model::CodeConfigurationValues>,
}
impl CodeConfiguration {
    /// <p>The source of the App Runner configuration. Values are interpreted as follows:</p>
    /// <ul>
    /// <li> <p> <code>REPOSITORY</code> – App Runner reads configuration values from the <code>apprunner.yaml</code> file in the source code repository and ignores <code>CodeConfigurationValues</code>.</p> </li>
    /// <li> <p> <code>API</code> – App Runner uses configuration values provided in <code>CodeConfigurationValues</code> and ignores the <code>apprunner.yaml</code> file in the source code repository.</p> </li>
    /// </ul>
    pub fn configuration_source(&self) -> std::option::Option<&crate::model::ConfigurationSource> {
        self.configuration_source.as_ref()
    }
    /// <p>The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).</p>
    pub fn code_configuration_values(
        &self,
    ) -> std::option::Option<&crate::model::CodeConfigurationValues> {
        self.code_configuration_values.as_ref()
    }
}
impl std::fmt::Debug for CodeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeConfiguration");
        formatter.field("configuration_source", &self.configuration_source);
        formatter.field("code_configuration_values", &self.code_configuration_values);
        formatter.finish()
    }
}
/// See [`CodeConfiguration`](crate::model::CodeConfiguration)
pub mod code_configuration {
    /// A builder for [`CodeConfiguration`](crate::model::CodeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_source: std::option::Option<crate::model::ConfigurationSource>,
        pub(crate) code_configuration_values:
            std::option::Option<crate::model::CodeConfigurationValues>,
    }
    impl Builder {
        /// <p>The source of the App Runner configuration. Values are interpreted as follows:</p>
        /// <ul>
        /// <li> <p> <code>REPOSITORY</code> – App Runner reads configuration values from the <code>apprunner.yaml</code> file in the source code repository and ignores <code>CodeConfigurationValues</code>.</p> </li>
        /// <li> <p> <code>API</code> – App Runner uses configuration values provided in <code>CodeConfigurationValues</code> and ignores the <code>apprunner.yaml</code> file in the source code repository.</p> </li>
        /// </ul>
        pub fn configuration_source(mut self, input: crate::model::ConfigurationSource) -> Self {
            self.configuration_source = Some(input);
            self
        }
        /// <p>The source of the App Runner configuration. Values are interpreted as follows:</p>
        /// <ul>
        /// <li> <p> <code>REPOSITORY</code> – App Runner reads configuration values from the <code>apprunner.yaml</code> file in the source code repository and ignores <code>CodeConfigurationValues</code>.</p> </li>
        /// <li> <p> <code>API</code> – App Runner uses configuration values provided in <code>CodeConfigurationValues</code> and ignores the <code>apprunner.yaml</code> file in the source code repository.</p> </li>
        /// </ul>
        pub fn set_configuration_source(
            mut self,
            input: std::option::Option<crate::model::ConfigurationSource>,
        ) -> Self {
            self.configuration_source = input;
            self
        }
        /// <p>The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).</p>
        pub fn code_configuration_values(
            mut self,
            input: crate::model::CodeConfigurationValues,
        ) -> Self {
            self.code_configuration_values = Some(input);
            self
        }
        /// <p>The basic configuration for building and running the App Runner service. Use it to quickly launch an App Runner service without providing a <code>apprunner.yaml</code> file in the source code repository (or ignoring the file if it exists).</p>
        pub fn set_code_configuration_values(
            mut self,
            input: std::option::Option<crate::model::CodeConfigurationValues>,
        ) -> Self {
            self.code_configuration_values = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeConfiguration`](crate::model::CodeConfiguration)
        pub fn build(self) -> crate::model::CodeConfiguration {
            crate::model::CodeConfiguration {
                configuration_source: self.configuration_source,
                code_configuration_values: self.code_configuration_values,
            }
        }
    }
}
impl CodeConfiguration {
    /// Creates a new builder-style object to manufacture [`CodeConfiguration`](crate::model::CodeConfiguration)
    pub fn builder() -> crate::model::code_configuration::Builder {
        crate::model::code_configuration::Builder::default()
    }
}

/// <p>Describes the basic configuration needed for building and running an App Runner service. This type doesn't support the full set of possible configuration options. Fur full configuration capabilities, use a <code>apprunner.yaml</code> file in the source code repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeConfigurationValues {
    /// <p>A runtime environment type for building and running an App Runner service. It represents a programming language runtime.</p>
    pub runtime: std::option::Option<crate::model::Runtime>,
    /// <p>The command App Runner runs to build your application.</p>
    pub build_command: std::option::Option<std::string::String>,
    /// <p>The command App Runner runs to start your application.</p>
    pub start_command: std::option::Option<std::string::String>,
    /// <p>The port that your application listens to in the container.</p>
    /// <p>Default: <code>8080</code> </p>
    pub port: std::option::Option<std::string::String>,
    /// <p>The environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
    pub runtime_environment_variables:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CodeConfigurationValues {
    /// <p>A runtime environment type for building and running an App Runner service. It represents a programming language runtime.</p>
    pub fn runtime(&self) -> std::option::Option<&crate::model::Runtime> {
        self.runtime.as_ref()
    }
    /// <p>The command App Runner runs to build your application.</p>
    pub fn build_command(&self) -> std::option::Option<&str> {
        self.build_command.as_deref()
    }
    /// <p>The command App Runner runs to start your application.</p>
    pub fn start_command(&self) -> std::option::Option<&str> {
        self.start_command.as_deref()
    }
    /// <p>The port that your application listens to in the container.</p>
    /// <p>Default: <code>8080</code> </p>
    pub fn port(&self) -> std::option::Option<&str> {
        self.port.as_deref()
    }
    /// <p>The environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
    pub fn runtime_environment_variables(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.runtime_environment_variables.as_ref()
    }
}
impl std::fmt::Debug for CodeConfigurationValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeConfigurationValues");
        formatter.field("runtime", &self.runtime);
        formatter.field("build_command", &"*** Sensitive Data Redacted ***");
        formatter.field("start_command", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field(
            "runtime_environment_variables",
            &self.runtime_environment_variables,
        );
        formatter.finish()
    }
}
/// See [`CodeConfigurationValues`](crate::model::CodeConfigurationValues)
pub mod code_configuration_values {
    /// A builder for [`CodeConfigurationValues`](crate::model::CodeConfigurationValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) runtime: std::option::Option<crate::model::Runtime>,
        pub(crate) build_command: std::option::Option<std::string::String>,
        pub(crate) start_command: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<std::string::String>,
        pub(crate) runtime_environment_variables: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A runtime environment type for building and running an App Runner service. It represents a programming language runtime.</p>
        pub fn runtime(mut self, input: crate::model::Runtime) -> Self {
            self.runtime = Some(input);
            self
        }
        /// <p>A runtime environment type for building and running an App Runner service. It represents a programming language runtime.</p>
        pub fn set_runtime(mut self, input: std::option::Option<crate::model::Runtime>) -> Self {
            self.runtime = input;
            self
        }
        /// <p>The command App Runner runs to build your application.</p>
        pub fn build_command(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_command = Some(input.into());
            self
        }
        /// <p>The command App Runner runs to build your application.</p>
        pub fn set_build_command(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.build_command = input;
            self
        }
        /// <p>The command App Runner runs to start your application.</p>
        pub fn start_command(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_command = Some(input.into());
            self
        }
        /// <p>The command App Runner runs to start your application.</p>
        pub fn set_start_command(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.start_command = input;
            self
        }
        /// <p>The port that your application listens to in the container.</p>
        /// <p>Default: <code>8080</code> </p>
        pub fn port(mut self, input: impl Into<std::string::String>) -> Self {
            self.port = Some(input.into());
            self
        }
        /// <p>The port that your application listens to in the container.</p>
        /// <p>Default: <code>8080</code> </p>
        pub fn set_port(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.port = input;
            self
        }
        /// Adds a key-value pair to `runtime_environment_variables`.
        ///
        /// To override the contents of this collection use [`set_runtime_environment_variables`](Self::set_runtime_environment_variables).
        ///
        /// <p>The environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
        pub fn runtime_environment_variables(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.runtime_environment_variables.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.runtime_environment_variables = Some(hash_map);
            self
        }
        /// <p>The environment variables that are available to your running App Runner service. An array of key-value pairs. Keys with a prefix of <code>AWSAPPRUNNER</code> are reserved for system use and aren't valid.</p>
        pub fn set_runtime_environment_variables(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.runtime_environment_variables = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeConfigurationValues`](crate::model::CodeConfigurationValues)
        pub fn build(self) -> crate::model::CodeConfigurationValues {
            crate::model::CodeConfigurationValues {
                runtime: self.runtime,
                build_command: self.build_command,
                start_command: self.start_command,
                port: self.port,
                runtime_environment_variables: self.runtime_environment_variables,
            }
        }
    }
}
impl CodeConfigurationValues {
    /// Creates a new builder-style object to manufacture [`CodeConfigurationValues`](crate::model::CodeConfigurationValues)
    pub fn builder() -> crate::model::code_configuration_values::Builder {
        crate::model::code_configuration_values::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Runtime {
    #[allow(missing_docs)] // documentation missing in model
    Nodejs12,
    #[allow(missing_docs)] // documentation missing in model
    Python3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Runtime {
    fn from(s: &str) -> Self {
        match s {
            "NODEJS_12" => Runtime::Nodejs12,
            "PYTHON_3" => Runtime::Python3,
            other => Runtime::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Runtime {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Runtime::from(s))
    }
}
impl Runtime {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Runtime::Nodejs12 => "NODEJS_12",
            Runtime::Python3 => "PYTHON_3",
            Runtime::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NODEJS_12", "PYTHON_3"]
    }
}
impl AsRef<str> for Runtime {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConfigurationSource {
    #[allow(missing_docs)] // documentation missing in model
    Api,
    #[allow(missing_docs)] // documentation missing in model
    Repository,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConfigurationSource {
    fn from(s: &str) -> Self {
        match s {
            "API" => ConfigurationSource::Api,
            "REPOSITORY" => ConfigurationSource::Repository,
            other => ConfigurationSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConfigurationSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConfigurationSource::from(s))
    }
}
impl ConfigurationSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConfigurationSource::Api => "API",
            ConfigurationSource::Repository => "REPOSITORY",
            ConfigurationSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["API", "REPOSITORY"]
    }
}
impl AsRef<str> for ConfigurationSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Identifies a version of code that App Runner refers to within a source code repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceCodeVersion {
    /// <p>The type of version identifier.</p>
    /// <p>For a git-based repository, branches represent versions.</p>
    pub r#type: std::option::Option<crate::model::SourceCodeVersionType>,
    /// <p>A source code version.</p>
    /// <p>For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.</p>
    pub value: std::option::Option<std::string::String>,
}
impl SourceCodeVersion {
    /// <p>The type of version identifier.</p>
    /// <p>For a git-based repository, branches represent versions.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SourceCodeVersionType> {
        self.r#type.as_ref()
    }
    /// <p>A source code version.</p>
    /// <p>For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SourceCodeVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceCodeVersion");
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SourceCodeVersion`](crate::model::SourceCodeVersion)
pub mod source_code_version {
    /// A builder for [`SourceCodeVersion`](crate::model::SourceCodeVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SourceCodeVersionType>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of version identifier.</p>
        /// <p>For a git-based repository, branches represent versions.</p>
        pub fn r#type(mut self, input: crate::model::SourceCodeVersionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of version identifier.</p>
        /// <p>For a git-based repository, branches represent versions.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::SourceCodeVersionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A source code version.</p>
        /// <p>For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A source code version.</p>
        /// <p>For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceCodeVersion`](crate::model::SourceCodeVersion)
        pub fn build(self) -> crate::model::SourceCodeVersion {
            crate::model::SourceCodeVersion {
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl SourceCodeVersion {
    /// Creates a new builder-style object to manufacture [`SourceCodeVersion`](crate::model::SourceCodeVersion)
    pub fn builder() -> crate::model::source_code_version::Builder {
        crate::model::source_code_version::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceCodeVersionType {
    #[allow(missing_docs)] // documentation missing in model
    Branch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceCodeVersionType {
    fn from(s: &str) -> Self {
        match s {
            "BRANCH" => SourceCodeVersionType::Branch,
            other => SourceCodeVersionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceCodeVersionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceCodeVersionType::from(s))
    }
}
impl SourceCodeVersionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceCodeVersionType::Branch => "BRANCH",
            SourceCodeVersionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BRANCH"]
    }
}
impl AsRef<str> for SourceCodeVersionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceStatus {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    OperationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceStatus {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => ServiceStatus::CreateFailed,
            "DELETED" => ServiceStatus::Deleted,
            "DELETE_FAILED" => ServiceStatus::DeleteFailed,
            "OPERATION_IN_PROGRESS" => ServiceStatus::OperationInProgress,
            "PAUSED" => ServiceStatus::Paused,
            "RUNNING" => ServiceStatus::Running,
            other => ServiceStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceStatus::from(s))
    }
}
impl ServiceStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceStatus::CreateFailed => "CREATE_FAILED",
            ServiceStatus::Deleted => "DELETED",
            ServiceStatus::DeleteFailed => "DELETE_FAILED",
            ServiceStatus::OperationInProgress => "OPERATION_IN_PROGRESS",
            ServiceStatus::Paused => "PAUSED",
            ServiceStatus::Running => "RUNNING",
            ServiceStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "DELETED",
            "DELETE_FAILED",
            "OPERATION_IN_PROGRESS",
            "PAUSED",
            "RUNNING",
        ]
    }
}
impl AsRef<str> for ServiceStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a tag that is applied to an App Runner resource. A tag is a metadata item consisting of a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key of the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of the tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Describes an App Runner VPC connector resource. A VPC connector describes the Amazon Virtual Private Cloud (Amazon VPC) that an App Runner service is associated with, and the subnets and security group that are used.</p>
/// <p>Multiple revisions of a connector might have the same <code>Name</code> and different <code>Revision</code> values.</p> <note>
/// <p>At this time, App Runner supports only one revision per name.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConnector {
    /// <p>The customer-provided VPC connector name.</p>
    pub vpc_connector_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of this VPC connector.</p>
    pub vpc_connector_arn: std::option::Option<std::string::String>,
    /// <p>The revision of this VPC connector. It's unique among all the active connectors (<code>"Status": "ACTIVE"</code>) that share the same <code>Name</code>.</p> <note>
    /// <p>At this time, App Runner supports only one revision per name.</p>
    /// </note>
    pub vpc_connector_revision: i32,
    /// <p>A list of IDs of subnets that App Runner uses for your service. All IDs are of subnets of a single Amazon VPC.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of IDs of security groups that App Runner uses for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The current state of the VPC connector. If the status of a connector revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive connector revisions are permanently removed some time after they are deleted.</p>
    pub status: std::option::Option<crate::model::VpcConnectorStatus>,
    /// <p>The time when the VPC connector was created. It's in Unix time stamp format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the VPC connector was deleted. It's in Unix time stamp format.</p>
    pub deleted_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl VpcConnector {
    /// <p>The customer-provided VPC connector name.</p>
    pub fn vpc_connector_name(&self) -> std::option::Option<&str> {
        self.vpc_connector_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of this VPC connector.</p>
    pub fn vpc_connector_arn(&self) -> std::option::Option<&str> {
        self.vpc_connector_arn.as_deref()
    }
    /// <p>The revision of this VPC connector. It's unique among all the active connectors (<code>"Status": "ACTIVE"</code>) that share the same <code>Name</code>.</p> <note>
    /// <p>At this time, App Runner supports only one revision per name.</p>
    /// </note>
    pub fn vpc_connector_revision(&self) -> i32 {
        self.vpc_connector_revision
    }
    /// <p>A list of IDs of subnets that App Runner uses for your service. All IDs are of subnets of a single Amazon VPC.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
    /// <p>A list of IDs of security groups that App Runner uses for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.</p>
    pub fn security_groups(&self) -> std::option::Option<&[std::string::String]> {
        self.security_groups.as_deref()
    }
    /// <p>The current state of the VPC connector. If the status of a connector revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive connector revisions are permanently removed some time after they are deleted.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::VpcConnectorStatus> {
        self.status.as_ref()
    }
    /// <p>The time when the VPC connector was created. It's in Unix time stamp format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the VPC connector was deleted. It's in Unix time stamp format.</p>
    pub fn deleted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deleted_at.as_ref()
    }
}
impl std::fmt::Debug for VpcConnector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConnector");
        formatter.field("vpc_connector_name", &self.vpc_connector_name);
        formatter.field("vpc_connector_arn", &self.vpc_connector_arn);
        formatter.field("vpc_connector_revision", &self.vpc_connector_revision);
        formatter.field("subnets", &self.subnets);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("deleted_at", &self.deleted_at);
        formatter.finish()
    }
}
/// See [`VpcConnector`](crate::model::VpcConnector)
pub mod vpc_connector {
    /// A builder for [`VpcConnector`](crate::model::VpcConnector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_connector_name: std::option::Option<std::string::String>,
        pub(crate) vpc_connector_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_connector_revision: std::option::Option<i32>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<crate::model::VpcConnectorStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deleted_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The customer-provided VPC connector name.</p>
        pub fn vpc_connector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_connector_name = Some(input.into());
            self
        }
        /// <p>The customer-provided VPC connector name.</p>
        pub fn set_vpc_connector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_connector_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this VPC connector.</p>
        pub fn vpc_connector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_connector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this VPC connector.</p>
        pub fn set_vpc_connector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_connector_arn = input;
            self
        }
        /// <p>The revision of this VPC connector. It's unique among all the active connectors (<code>"Status": "ACTIVE"</code>) that share the same <code>Name</code>.</p> <note>
        /// <p>At this time, App Runner supports only one revision per name.</p>
        /// </note>
        pub fn vpc_connector_revision(mut self, input: i32) -> Self {
            self.vpc_connector_revision = Some(input);
            self
        }
        /// <p>The revision of this VPC connector. It's unique among all the active connectors (<code>"Status": "ACTIVE"</code>) that share the same <code>Name</code>.</p> <note>
        /// <p>At this time, App Runner supports only one revision per name.</p>
        /// </note>
        pub fn set_vpc_connector_revision(mut self, input: std::option::Option<i32>) -> Self {
            self.vpc_connector_revision = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of IDs of subnets that App Runner uses for your service. All IDs are of subnets of a single Amazon VPC.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>A list of IDs of subnets that App Runner uses for your service. All IDs are of subnets of a single Amazon VPC.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>A list of IDs of security groups that App Runner uses for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>A list of IDs of security groups that App Runner uses for access to Amazon Web Services resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>The current state of the VPC connector. If the status of a connector revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive connector revisions are permanently removed some time after they are deleted.</p>
        pub fn status(mut self, input: crate::model::VpcConnectorStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the VPC connector. If the status of a connector revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive connector revisions are permanently removed some time after they are deleted.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::VpcConnectorStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The time when the VPC connector was created. It's in Unix time stamp format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the VPC connector was created. It's in Unix time stamp format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the VPC connector was deleted. It's in Unix time stamp format.</p>
        pub fn deleted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deleted_at = Some(input);
            self
        }
        /// <p>The time when the VPC connector was deleted. It's in Unix time stamp format.</p>
        pub fn set_deleted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deleted_at = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConnector`](crate::model::VpcConnector)
        pub fn build(self) -> crate::model::VpcConnector {
            crate::model::VpcConnector {
                vpc_connector_name: self.vpc_connector_name,
                vpc_connector_arn: self.vpc_connector_arn,
                vpc_connector_revision: self.vpc_connector_revision.unwrap_or_default(),
                subnets: self.subnets,
                security_groups: self.security_groups,
                status: self.status,
                created_at: self.created_at,
                deleted_at: self.deleted_at,
            }
        }
    }
}
impl VpcConnector {
    /// Creates a new builder-style object to manufacture [`VpcConnector`](crate::model::VpcConnector)
    pub fn builder() -> crate::model::vpc_connector::Builder {
        crate::model::vpc_connector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VpcConnectorStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VpcConnectorStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => VpcConnectorStatus::Active,
            "INACTIVE" => VpcConnectorStatus::Inactive,
            other => VpcConnectorStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VpcConnectorStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VpcConnectorStatus::from(s))
    }
}
impl VpcConnectorStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VpcConnectorStatus::Active => "ACTIVE",
            VpcConnectorStatus::Inactive => "INACTIVE",
            VpcConnectorStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for VpcConnectorStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information for an App Runner service.</p>
/// <p>This type contains limited information about a service. It doesn't include configuration details. It's returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html">ListServices</a> action. Complete service information is returned by the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html">CreateService</a>, <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html">DescribeService</a>, and <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html">DeleteService</a> actions using the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_Service.html">Service</a> type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSummary {
    /// <p>The customer-provided service name.</p>
    pub service_name: std::option::Option<std::string::String>,
    /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
    pub service_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of this service.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
    pub service_url: std::option::Option<std::string::String>,
    /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the App Runner service was last updated. It's in theUnix time stamp format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current state of the App Runner service. These particular values mean the following.</p>
    /// <ul>
    /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
    /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ServiceStatus>,
}
impl ServiceSummary {
    /// <p>The customer-provided service name.</p>
    pub fn service_name(&self) -> std::option::Option<&str> {
        self.service_name.as_deref()
    }
    /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
    pub fn service_id(&self) -> std::option::Option<&str> {
        self.service_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of this service.</p>
    pub fn service_arn(&self) -> std::option::Option<&str> {
        self.service_arn.as_deref()
    }
    /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
    pub fn service_url(&self) -> std::option::Option<&str> {
        self.service_url.as_deref()
    }
    /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the App Runner service was last updated. It's in theUnix time stamp format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
    /// <p>The current state of the App Runner service. These particular values mean the following.</p>
    /// <ul>
    /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
    /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::ServiceStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ServiceSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSummary");
        formatter.field("service_name", &self.service_name);
        formatter.field("service_id", &self.service_id);
        formatter.field("service_arn", &self.service_arn);
        formatter.field("service_url", &self.service_url);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ServiceSummary`](crate::model::ServiceSummary)
pub mod service_summary {
    /// A builder for [`ServiceSummary`](crate::model::ServiceSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_id: std::option::Option<std::string::String>,
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) service_url: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::ServiceStatus>,
    }
    impl Builder {
        /// <p>The customer-provided service name.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The customer-provided service name.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
        pub fn service_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_id = Some(input.into());
            self
        }
        /// <p>An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.</p>
        pub fn set_service_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this service.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this service.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
        pub fn service_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_url = Some(input.into());
            self
        }
        /// <p>A subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.</p>
        pub fn set_service_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_url = input;
            self
        }
        /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the App Runner service was created. It's in the Unix time stamp format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the App Runner service was last updated. It's in theUnix time stamp format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time when the App Runner service was last updated. It's in theUnix time stamp format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// <p>The current state of the App Runner service. These particular values mean the following.</p>
        /// <ul>
        /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
        /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ServiceStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the App Runner service. These particular values mean the following.</p>
        /// <ul>
        /// <li> <p> <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any parameters that need to be fixed, and retry the call to create the service.</p> <p>The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the failure, delete the service.</p> </li>
        /// <li> <p> <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service deletion call to ensure that all related resources are removed.</p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ServiceStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSummary`](crate::model::ServiceSummary)
        pub fn build(self) -> crate::model::ServiceSummary {
            crate::model::ServiceSummary {
                service_name: self.service_name,
                service_id: self.service_id,
                service_arn: self.service_arn,
                service_url: self.service_url,
                created_at: self.created_at,
                updated_at: self.updated_at,
                status: self.status,
            }
        }
    }
}
impl ServiceSummary {
    /// Creates a new builder-style object to manufacture [`ServiceSummary`](crate::model::ServiceSummary)
    pub fn builder() -> crate::model::service_summary::Builder {
        crate::model::service_summary::Builder::default()
    }
}

/// <p>Provides summary information for an operation that occurred on an App Runner service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationSummary {
    /// <p>A unique ID of this operation. It's unique in the scope of the App Runner service.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The type of operation. It indicates a specific action that occured.</p>
    pub r#type: std::option::Option<crate::model::OperationType>,
    /// <p>The current state of the operation.</p>
    pub status: std::option::Option<crate::model::OperationStatus>,
    /// <p>The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The time when the operation started. It's in the Unix time stamp format.</p>
    pub started_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the operation ended. It's in the Unix time stamp format.</p>
    pub ended_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the operation was last updated. It's in the Unix time stamp format.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl OperationSummary {
    /// <p>A unique ID of this operation. It's unique in the scope of the App Runner service.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The type of operation. It indicates a specific action that occured.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::OperationType> {
        self.r#type.as_ref()
    }
    /// <p>The current state of the operation.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::OperationStatus> {
        self.status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The time when the operation started. It's in the Unix time stamp format.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.started_at.as_ref()
    }
    /// <p>The time when the operation ended. It's in the Unix time stamp format.</p>
    pub fn ended_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.ended_at.as_ref()
    }
    /// <p>The time when the operation was last updated. It's in the Unix time stamp format.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for OperationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationSummary");
        formatter.field("id", &self.id);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("started_at", &self.started_at);
        formatter.field("ended_at", &self.ended_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`OperationSummary`](crate::model::OperationSummary)
pub mod operation_summary {
    /// A builder for [`OperationSummary`](crate::model::OperationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::OperationType>,
        pub(crate) status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) ended_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique ID of this operation. It's unique in the scope of the App Runner service.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A unique ID of this operation. It's unique in the scope of the App Runner service.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The type of operation. It indicates a specific action that occured.</p>
        pub fn r#type(mut self, input: crate::model::OperationType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of operation. It indicates a specific action that occured.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::OperationType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The current state of the operation.</p>
        pub fn status(mut self, input: crate::model::OperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the operation.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that the operation acted on (for example, an App Runner service).</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The time when the operation started. It's in the Unix time stamp format.</p>
        pub fn started_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The time when the operation started. It's in the Unix time stamp format.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The time when the operation ended. It's in the Unix time stamp format.</p>
        pub fn ended_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.ended_at = Some(input);
            self
        }
        /// <p>The time when the operation ended. It's in the Unix time stamp format.</p>
        pub fn set_ended_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.ended_at = input;
            self
        }
        /// <p>The time when the operation was last updated. It's in the Unix time stamp format.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The time when the operation was last updated. It's in the Unix time stamp format.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationSummary`](crate::model::OperationSummary)
        pub fn build(self) -> crate::model::OperationSummary {
            crate::model::OperationSummary {
                id: self.id,
                r#type: self.r#type,
                status: self.status,
                target_arn: self.target_arn,
                started_at: self.started_at,
                ended_at: self.ended_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl OperationSummary {
    /// Creates a new builder-style object to manufacture [`OperationSummary`](crate::model::OperationSummary)
    pub fn builder() -> crate::model::operation_summary::Builder {
        crate::model::operation_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    RollbackFailed,
    #[allow(missing_docs)] // documentation missing in model
    RollbackInProgress,
    #[allow(missing_docs)] // documentation missing in model
    RollbackSucceeded,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => OperationStatus::Failed,
            "IN_PROGRESS" => OperationStatus::InProgress,
            "PENDING" => OperationStatus::Pending,
            "ROLLBACK_FAILED" => OperationStatus::RollbackFailed,
            "ROLLBACK_IN_PROGRESS" => OperationStatus::RollbackInProgress,
            "ROLLBACK_SUCCEEDED" => OperationStatus::RollbackSucceeded,
            "SUCCEEDED" => OperationStatus::Succeeded,
            other => OperationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationStatus::from(s))
    }
}
impl OperationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationStatus::Failed => "FAILED",
            OperationStatus::InProgress => "IN_PROGRESS",
            OperationStatus::Pending => "PENDING",
            OperationStatus::RollbackFailed => "ROLLBACK_FAILED",
            OperationStatus::RollbackInProgress => "ROLLBACK_IN_PROGRESS",
            OperationStatus::RollbackSucceeded => "ROLLBACK_SUCCEEDED",
            OperationStatus::Succeeded => "SUCCEEDED",
            OperationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "ROLLBACK_FAILED",
            "ROLLBACK_IN_PROGRESS",
            "ROLLBACK_SUCCEEDED",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for OperationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationType {
    #[allow(missing_docs)] // documentation missing in model
    CreateService,
    #[allow(missing_docs)] // documentation missing in model
    DeleteService,
    #[allow(missing_docs)] // documentation missing in model
    PauseService,
    #[allow(missing_docs)] // documentation missing in model
    ResumeService,
    #[allow(missing_docs)] // documentation missing in model
    StartDeployment,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationType {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_SERVICE" => OperationType::CreateService,
            "DELETE_SERVICE" => OperationType::DeleteService,
            "PAUSE_SERVICE" => OperationType::PauseService,
            "RESUME_SERVICE" => OperationType::ResumeService,
            "START_DEPLOYMENT" => OperationType::StartDeployment,
            other => OperationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationType::from(s))
    }
}
impl OperationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationType::CreateService => "CREATE_SERVICE",
            OperationType::DeleteService => "DELETE_SERVICE",
            OperationType::PauseService => "PAUSE_SERVICE",
            OperationType::ResumeService => "RESUME_SERVICE",
            OperationType::StartDeployment => "START_DEPLOYMENT",
            OperationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_SERVICE",
            "DELETE_SERVICE",
            "PAUSE_SERVICE",
            "RESUME_SERVICE",
            "START_DEPLOYMENT",
        ]
    }
}
impl AsRef<str> for OperationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides summary information about an App Runner connection resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionSummary {
    /// <p>The customer-provided connection name.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of this connection.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The source repository provider.</p>
    pub provider_type: std::option::Option<crate::model::ProviderType>,
    /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
    pub status: std::option::Option<crate::model::ConnectionStatus>,
    /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl ConnectionSummary {
    /// <p>The customer-provided connection name.</p>
    pub fn connection_name(&self) -> std::option::Option<&str> {
        self.connection_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of this connection.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The source repository provider.</p>
    pub fn provider_type(&self) -> std::option::Option<&crate::model::ProviderType> {
        self.provider_type.as_ref()
    }
    /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ConnectionStatus> {
        self.status.as_ref()
    }
    /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for ConnectionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionSummary");
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`ConnectionSummary`](crate::model::ConnectionSummary)
pub mod connection_summary {
    /// A builder for [`ConnectionSummary`](crate::model::ConnectionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::ProviderType>,
        pub(crate) status: std::option::Option<crate::model::ConnectionStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The customer-provided connection name.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The customer-provided connection name.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The source repository provider.</p>
        pub fn provider_type(mut self, input: crate::model::ProviderType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>The source repository provider.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
        pub fn status(mut self, input: crate::model::ConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionSummary`](crate::model::ConnectionSummary)
        pub fn build(self) -> crate::model::ConnectionSummary {
            crate::model::ConnectionSummary {
                connection_name: self.connection_name,
                connection_arn: self.connection_arn,
                provider_type: self.provider_type,
                status: self.status,
                created_at: self.created_at,
            }
        }
    }
}
impl ConnectionSummary {
    /// Creates a new builder-style object to manufacture [`ConnectionSummary`](crate::model::ConnectionSummary)
    pub fn builder() -> crate::model::connection_summary::Builder {
        crate::model::connection_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    PendingHandshake,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => ConnectionStatus::Available,
            "DELETED" => ConnectionStatus::Deleted,
            "ERROR" => ConnectionStatus::Error,
            "PENDING_HANDSHAKE" => ConnectionStatus::PendingHandshake,
            other => ConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionStatus::from(s))
    }
}
impl ConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionStatus::Available => "AVAILABLE",
            ConnectionStatus::Deleted => "DELETED",
            ConnectionStatus::Error => "ERROR",
            ConnectionStatus::PendingHandshake => "PENDING_HANDSHAKE",
            ConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "DELETED", "ERROR", "PENDING_HANDSHAKE"]
    }
}
impl AsRef<str> for ConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProviderType {
    #[allow(missing_docs)] // documentation missing in model
    Github,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProviderType {
    fn from(s: &str) -> Self {
        match s {
            "GITHUB" => ProviderType::Github,
            other => ProviderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProviderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProviderType::from(s))
    }
}
impl ProviderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProviderType::Github => "GITHUB",
            ProviderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GITHUB"]
    }
}
impl AsRef<str> for ProviderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a custom domain that's associated with an App Runner service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomDomain {
    /// <p>An associated custom domain endpoint. It can be a root domain (for example, <code>example.com</code>), a subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>When <code>true</code>, the subdomain <code>www.<i>DomainName</i> </code> is associated with the App Runner service in addition to the base domain.</p>
    pub enable_www_subdomain: std::option::Option<bool>,
    /// <p>A list of certificate CNAME records that's used for this domain name.</p>
    pub certificate_validation_records:
        std::option::Option<std::vec::Vec<crate::model::CertificateValidationRecord>>,
    /// <p>The current state of the domain name association.</p>
    pub status: std::option::Option<crate::model::CustomDomainAssociationStatus>,
}
impl CustomDomain {
    /// <p>An associated custom domain endpoint. It can be a root domain (for example, <code>example.com</code>), a subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>When <code>true</code>, the subdomain <code>www.<i>DomainName</i> </code> is associated with the App Runner service in addition to the base domain.</p>
    pub fn enable_www_subdomain(&self) -> std::option::Option<bool> {
        self.enable_www_subdomain
    }
    /// <p>A list of certificate CNAME records that's used for this domain name.</p>
    pub fn certificate_validation_records(
        &self,
    ) -> std::option::Option<&[crate::model::CertificateValidationRecord]> {
        self.certificate_validation_records.as_deref()
    }
    /// <p>The current state of the domain name association.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CustomDomainAssociationStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CustomDomain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomDomain");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("enable_www_subdomain", &self.enable_www_subdomain);
        formatter.field(
            "certificate_validation_records",
            &self.certificate_validation_records,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CustomDomain`](crate::model::CustomDomain)
pub mod custom_domain {
    /// A builder for [`CustomDomain`](crate::model::CustomDomain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) enable_www_subdomain: std::option::Option<bool>,
        pub(crate) certificate_validation_records:
            std::option::Option<std::vec::Vec<crate::model::CertificateValidationRecord>>,
        pub(crate) status: std::option::Option<crate::model::CustomDomainAssociationStatus>,
    }
    impl Builder {
        /// <p>An associated custom domain endpoint. It can be a root domain (for example, <code>example.com</code>), a subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>An associated custom domain endpoint. It can be a root domain (for example, <code>example.com</code>), a subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>When <code>true</code>, the subdomain <code>www.<i>DomainName</i> </code> is associated with the App Runner service in addition to the base domain.</p>
        pub fn enable_www_subdomain(mut self, input: bool) -> Self {
            self.enable_www_subdomain = Some(input);
            self
        }
        /// <p>When <code>true</code>, the subdomain <code>www.<i>DomainName</i> </code> is associated with the App Runner service in addition to the base domain.</p>
        pub fn set_enable_www_subdomain(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_www_subdomain = input;
            self
        }
        /// Appends an item to `certificate_validation_records`.
        ///
        /// To override the contents of this collection use [`set_certificate_validation_records`](Self::set_certificate_validation_records).
        ///
        /// <p>A list of certificate CNAME records that's used for this domain name.</p>
        pub fn certificate_validation_records(
            mut self,
            input: crate::model::CertificateValidationRecord,
        ) -> Self {
            let mut v = self.certificate_validation_records.unwrap_or_default();
            v.push(input);
            self.certificate_validation_records = Some(v);
            self
        }
        /// <p>A list of certificate CNAME records that's used for this domain name.</p>
        pub fn set_certificate_validation_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CertificateValidationRecord>>,
        ) -> Self {
            self.certificate_validation_records = input;
            self
        }
        /// <p>The current state of the domain name association.</p>
        pub fn status(mut self, input: crate::model::CustomDomainAssociationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the domain name association.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CustomDomainAssociationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomDomain`](crate::model::CustomDomain)
        pub fn build(self) -> crate::model::CustomDomain {
            crate::model::CustomDomain {
                domain_name: self.domain_name,
                enable_www_subdomain: self.enable_www_subdomain,
                certificate_validation_records: self.certificate_validation_records,
                status: self.status,
            }
        }
    }
}
impl CustomDomain {
    /// Creates a new builder-style object to manufacture [`CustomDomain`](crate::model::CustomDomain)
    pub fn builder() -> crate::model::custom_domain::Builder {
        crate::model::custom_domain::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomDomainAssociationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    BindingCertificate,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    DeleteFailed,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    PendingCertificateDnsValidation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomDomainAssociationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => CustomDomainAssociationStatus::Active,
            "BINDING_CERTIFICATE" => CustomDomainAssociationStatus::BindingCertificate,
            "CREATE_FAILED" => CustomDomainAssociationStatus::CreateFailed,
            "CREATING" => CustomDomainAssociationStatus::Creating,
            "DELETE_FAILED" => CustomDomainAssociationStatus::DeleteFailed,
            "DELETING" => CustomDomainAssociationStatus::Deleting,
            "PENDING_CERTIFICATE_DNS_VALIDATION" => {
                CustomDomainAssociationStatus::PendingCertificateDnsValidation
            }
            other => CustomDomainAssociationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomDomainAssociationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomDomainAssociationStatus::from(s))
    }
}
impl CustomDomainAssociationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomDomainAssociationStatus::Active => "ACTIVE",
            CustomDomainAssociationStatus::BindingCertificate => "BINDING_CERTIFICATE",
            CustomDomainAssociationStatus::CreateFailed => "CREATE_FAILED",
            CustomDomainAssociationStatus::Creating => "CREATING",
            CustomDomainAssociationStatus::DeleteFailed => "DELETE_FAILED",
            CustomDomainAssociationStatus::Deleting => "DELETING",
            CustomDomainAssociationStatus::PendingCertificateDnsValidation => {
                "PENDING_CERTIFICATE_DNS_VALIDATION"
            }
            CustomDomainAssociationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "BINDING_CERTIFICATE",
            "CREATE_FAILED",
            "CREATING",
            "DELETE_FAILED",
            "DELETING",
            "PENDING_CERTIFICATE_DNS_VALIDATION",
        ]
    }
}
impl AsRef<str> for CustomDomainAssociationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a certificate CNAME record to add to your DNS. For more information, see <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html">AssociateCustomDomain</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateValidationRecord {
    /// <p>The certificate CNAME record name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The record type, always <code>CNAME</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The certificate CNAME record value.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after App Runner completes validation with your DNS.</p>
    pub status: std::option::Option<crate::model::CertificateValidationRecordStatus>,
}
impl CertificateValidationRecord {
    /// <p>The certificate CNAME record name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The record type, always <code>CNAME</code>.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The certificate CNAME record value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after App Runner completes validation with your DNS.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::CertificateValidationRecordStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CertificateValidationRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateValidationRecord");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CertificateValidationRecord`](crate::model::CertificateValidationRecord)
pub mod certificate_validation_record {
    /// A builder for [`CertificateValidationRecord`](crate::model::CertificateValidationRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CertificateValidationRecordStatus>,
    }
    impl Builder {
        /// <p>The certificate CNAME record name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The certificate CNAME record name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The record type, always <code>CNAME</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The record type, always <code>CNAME</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The certificate CNAME record value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The certificate CNAME record value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after App Runner completes validation with your DNS.</p>
        pub fn status(mut self, input: crate::model::CertificateValidationRecordStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after App Runner completes validation with your DNS.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateValidationRecordStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateValidationRecord`](crate::model::CertificateValidationRecord)
        pub fn build(self) -> crate::model::CertificateValidationRecord {
            crate::model::CertificateValidationRecord {
                name: self.name,
                r#type: self.r#type,
                value: self.value,
                status: self.status,
            }
        }
    }
}
impl CertificateValidationRecord {
    /// Creates a new builder-style object to manufacture [`CertificateValidationRecord`](crate::model::CertificateValidationRecord)
    pub fn builder() -> crate::model::certificate_validation_record::Builder {
        crate::model::certificate_validation_record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateValidationRecordStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateValidationRecordStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => CertificateValidationRecordStatus::Failed,
            "PENDING_VALIDATION" => CertificateValidationRecordStatus::PendingValidation,
            "SUCCESS" => CertificateValidationRecordStatus::Success,
            other => CertificateValidationRecordStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateValidationRecordStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateValidationRecordStatus::from(s))
    }
}
impl CertificateValidationRecordStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateValidationRecordStatus::Failed => "FAILED",
            CertificateValidationRecordStatus::PendingValidation => "PENDING_VALIDATION",
            CertificateValidationRecordStatus::Success => "SUCCESS",
            CertificateValidationRecordStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING_VALIDATION", "SUCCESS"]
    }
}
impl AsRef<str> for CertificateValidationRecordStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an App Runner automatic scaling configuration resource.</p>
/// <p>A higher <code>MinSize</code> increases the spread of your App Runner service over more Availability Zones in the Amazon Web Services Region. The tradeoff is a higher minimal cost.</p>
/// <p>A lower <code>MaxSize</code> controls your cost. The tradeoff is lower responsiveness during peak demand.</p>
/// <p>Multiple revisions of a configuration might have the same <code>AutoScalingConfigurationName</code> and different <code>AutoScalingConfigurationRevision</code> values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoScalingConfiguration {
    /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
    pub auto_scaling_configuration_arn: std::option::Option<std::string::String>,
    /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
    pub auto_scaling_configuration_name: std::option::Option<std::string::String>,
    /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) that share the same <code>AutoScalingConfigurationName</code>.</p>
    pub auto_scaling_configuration_revision: i32,
    /// <p>It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all configurations that share the same <code>Name</code>. It's set to <code>false</code> otherwise.</p>
    pub latest: bool,
    /// <p>The current state of the auto scaling configuration. If the status of a configuration revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.</p>
    pub status: std::option::Option<crate::model::AutoScalingConfigurationStatus>,
    /// <p>The maximum number of concurrent requests that an instance processes. If the number of concurrent requests exceeds this limit, App Runner scales the service up.</p>
    pub max_concurrency: i32,
    /// <p>The minimum number of instances that App Runner provisions for a service. The service always has at least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p>
    /// <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p>
    pub min_size: i32,
    /// <p>The maximum number of instances that a service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p>
    pub max_size: i32,
    /// <p>The time when the auto scaling configuration was created. It's in Unix time stamp format.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the auto scaling configuration was deleted. It's in Unix time stamp format.</p>
    pub deleted_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl AutoScalingConfiguration {
    /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
    pub fn auto_scaling_configuration_arn(&self) -> std::option::Option<&str> {
        self.auto_scaling_configuration_arn.as_deref()
    }
    /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
    pub fn auto_scaling_configuration_name(&self) -> std::option::Option<&str> {
        self.auto_scaling_configuration_name.as_deref()
    }
    /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) that share the same <code>AutoScalingConfigurationName</code>.</p>
    pub fn auto_scaling_configuration_revision(&self) -> i32 {
        self.auto_scaling_configuration_revision
    }
    /// <p>It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all configurations that share the same <code>Name</code>. It's set to <code>false</code> otherwise.</p>
    pub fn latest(&self) -> bool {
        self.latest
    }
    /// <p>The current state of the auto scaling configuration. If the status of a configuration revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AutoScalingConfigurationStatus> {
        self.status.as_ref()
    }
    /// <p>The maximum number of concurrent requests that an instance processes. If the number of concurrent requests exceeds this limit, App Runner scales the service up.</p>
    pub fn max_concurrency(&self) -> i32 {
        self.max_concurrency
    }
    /// <p>The minimum number of instances that App Runner provisions for a service. The service always has at least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p>
    /// <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p>
    pub fn min_size(&self) -> i32 {
        self.min_size
    }
    /// <p>The maximum number of instances that a service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p>
    pub fn max_size(&self) -> i32 {
        self.max_size
    }
    /// <p>The time when the auto scaling configuration was created. It's in Unix time stamp format.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The time when the auto scaling configuration was deleted. It's in Unix time stamp format.</p>
    pub fn deleted_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.deleted_at.as_ref()
    }
}
impl std::fmt::Debug for AutoScalingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoScalingConfiguration");
        formatter.field(
            "auto_scaling_configuration_arn",
            &self.auto_scaling_configuration_arn,
        );
        formatter.field(
            "auto_scaling_configuration_name",
            &self.auto_scaling_configuration_name,
        );
        formatter.field(
            "auto_scaling_configuration_revision",
            &self.auto_scaling_configuration_revision,
        );
        formatter.field("latest", &self.latest);
        formatter.field("status", &self.status);
        formatter.field("max_concurrency", &self.max_concurrency);
        formatter.field("min_size", &self.min_size);
        formatter.field("max_size", &self.max_size);
        formatter.field("created_at", &self.created_at);
        formatter.field("deleted_at", &self.deleted_at);
        formatter.finish()
    }
}
/// See [`AutoScalingConfiguration`](crate::model::AutoScalingConfiguration)
pub mod auto_scaling_configuration {
    /// A builder for [`AutoScalingConfiguration`](crate::model::AutoScalingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_configuration_name: std::option::Option<std::string::String>,
        pub(crate) auto_scaling_configuration_revision: std::option::Option<i32>,
        pub(crate) latest: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::AutoScalingConfigurationStatus>,
        pub(crate) max_concurrency: std::option::Option<i32>,
        pub(crate) min_size: std::option::Option<i32>,
        pub(crate) max_size: std::option::Option<i32>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deleted_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
        pub fn auto_scaling_configuration_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this auto scaling configuration.</p>
        pub fn set_auto_scaling_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_arn = input;
            self
        }
        /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
        pub fn auto_scaling_configuration_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_name = Some(input.into());
            self
        }
        /// <p>The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.</p>
        pub fn set_auto_scaling_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auto_scaling_configuration_name = input;
            self
        }
        /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) that share the same <code>AutoScalingConfigurationName</code>.</p>
        pub fn auto_scaling_configuration_revision(mut self, input: i32) -> Self {
            self.auto_scaling_configuration_revision = Some(input);
            self
        }
        /// <p>The revision of this auto scaling configuration. It's unique among all the active configurations (<code>"Status": "ACTIVE"</code>) that share the same <code>AutoScalingConfigurationName</code>.</p>
        pub fn set_auto_scaling_configuration_revision(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.auto_scaling_configuration_revision = input;
            self
        }
        /// <p>It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all configurations that share the same <code>Name</code>. It's set to <code>false</code> otherwise.</p>
        pub fn latest(mut self, input: bool) -> Self {
            self.latest = Some(input);
            self
        }
        /// <p>It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all configurations that share the same <code>Name</code>. It's set to <code>false</code> otherwise.</p>
        pub fn set_latest(mut self, input: std::option::Option<bool>) -> Self {
            self.latest = input;
            self
        }
        /// <p>The current state of the auto scaling configuration. If the status of a configuration revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.</p>
        pub fn status(mut self, input: crate::model::AutoScalingConfigurationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the auto scaling configuration. If the status of a configuration revision is <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed some time after they are deleted.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AutoScalingConfigurationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of concurrent requests that an instance processes. If the number of concurrent requests exceeds this limit, App Runner scales the service up.</p>
        pub fn max_concurrency(mut self, input: i32) -> Self {
            self.max_concurrency = Some(input);
            self
        }
        /// <p>The maximum number of concurrent requests that an instance processes. If the number of concurrent requests exceeds this limit, App Runner scales the service up.</p>
        pub fn set_max_concurrency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_concurrency = input;
            self
        }
        /// <p>The minimum number of instances that App Runner provisions for a service. The service always has at least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p>
        /// <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p>
        pub fn min_size(mut self, input: i32) -> Self {
            self.min_size = Some(input);
            self
        }
        /// <p>The minimum number of instances that App Runner provisions for a service. The service always has at least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p>
        /// <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_size = input;
            self
        }
        /// <p>The maximum number of instances that a service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p>
        pub fn max_size(mut self, input: i32) -> Self {
            self.max_size = Some(input);
            self
        }
        /// <p>The maximum number of instances that a service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_size = input;
            self
        }
        /// <p>The time when the auto scaling configuration was created. It's in Unix time stamp format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the auto scaling configuration was created. It's in Unix time stamp format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time when the auto scaling configuration was deleted. It's in Unix time stamp format.</p>
        pub fn deleted_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.deleted_at = Some(input);
            self
        }
        /// <p>The time when the auto scaling configuration was deleted. It's in Unix time stamp format.</p>
        pub fn set_deleted_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.deleted_at = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoScalingConfiguration`](crate::model::AutoScalingConfiguration)
        pub fn build(self) -> crate::model::AutoScalingConfiguration {
            crate::model::AutoScalingConfiguration {
                auto_scaling_configuration_arn: self.auto_scaling_configuration_arn,
                auto_scaling_configuration_name: self.auto_scaling_configuration_name,
                auto_scaling_configuration_revision: self
                    .auto_scaling_configuration_revision
                    .unwrap_or_default(),
                latest: self.latest.unwrap_or_default(),
                status: self.status,
                max_concurrency: self.max_concurrency.unwrap_or_default(),
                min_size: self.min_size.unwrap_or_default(),
                max_size: self.max_size.unwrap_or_default(),
                created_at: self.created_at,
                deleted_at: self.deleted_at,
            }
        }
    }
}
impl AutoScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`AutoScalingConfiguration`](crate::model::AutoScalingConfiguration)
    pub fn builder() -> crate::model::auto_scaling_configuration::Builder {
        crate::model::auto_scaling_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoScalingConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoScalingConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AutoScalingConfigurationStatus::Active,
            "INACTIVE" => AutoScalingConfigurationStatus::Inactive,
            other => AutoScalingConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoScalingConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoScalingConfigurationStatus::from(s))
    }
}
impl AutoScalingConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoScalingConfigurationStatus::Active => "ACTIVE",
            AutoScalingConfigurationStatus::Inactive => "INACTIVE",
            AutoScalingConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for AutoScalingConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an App Runner connection resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The customer-provided connection name.</p>
    pub connection_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of this connection.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The source repository provider.</p>
    pub provider_type: std::option::Option<crate::model::ProviderType>,
    /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
    pub status: std::option::Option<crate::model::ConnectionStatus>,
    /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl Connection {
    /// <p>The customer-provided connection name.</p>
    pub fn connection_name(&self) -> std::option::Option<&str> {
        self.connection_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of this connection.</p>
    pub fn connection_arn(&self) -> std::option::Option<&str> {
        self.connection_arn.as_deref()
    }
    /// <p>The source repository provider.</p>
    pub fn provider_type(&self) -> std::option::Option<&crate::model::ProviderType> {
        self.provider_type.as_ref()
    }
    /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ConnectionStatus> {
        self.status.as_ref()
    }
    /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("connection_name", &self.connection_name);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("provider_type", &self.provider_type);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_name: std::option::Option<std::string::String>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) provider_type: std::option::Option<crate::model::ProviderType>,
        pub(crate) status: std::option::Option<crate::model::ConnectionStatus>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The customer-provided connection name.</p>
        pub fn connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_name = Some(input.into());
            self
        }
        /// <p>The customer-provided connection name.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of this connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The source repository provider.</p>
        pub fn provider_type(mut self, input: crate::model::ProviderType) -> Self {
            self.provider_type = Some(input);
            self
        }
        /// <p>The source repository provider.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.provider_type = input;
            self
        }
        /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
        pub fn status(mut self, input: crate::model::ConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the connection to create an App Runner service.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The App Runner connection creation time, expressed as a Unix time stamp.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                connection_name: self.connection_name,
                connection_arn: self.connection_arn,
                provider_type: self.provider_type,
                status: self.status,
                created_at: self.created_at,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}
