// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceOutput {
    /// <p>A description of the App Runner service updated by this request. All configuration values in the returned <code>Service</code> structure reflect
    /// configuration changes that are being applied by this request.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
    /// the operation's progress.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceOutput");
        formatter.field("service", &self.service);
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
pub mod update_service_output {
    /// A builder for [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the App Runner service updated by this request. All configuration values in the returned <code>Service</code> structure reflect
        /// configuration changes that are being applied by this request.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A description of the App Runner service updated by this request. All configuration values in the returned <code>Service</code> structure reflect
        /// configuration changes that are being applied by this request.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
        pub fn build(self) -> crate::output::UpdateServiceOutput {
            crate::output::UpdateServiceOutput {
                service: self.service,
                operation_id: self.operation_id,
            }
        }
    }
}
impl UpdateServiceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateServiceOutput`](crate::output::UpdateServiceOutput)
    pub fn builder() -> crate::output::update_service_output::Builder {
        crate::output::update_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDeploymentOutput {
    /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
    /// the operation's progress.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartDeploymentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeploymentOutput");
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
pub mod start_deployment_output {
    /// A builder for [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
        pub fn build(self) -> crate::output::StartDeploymentOutput {
            crate::output::StartDeploymentOutput {
                operation_id: self.operation_id,
            }
        }
    }
}
impl StartDeploymentOutput {
    /// Creates a new builder-style object to manufacture [`StartDeploymentOutput`](crate::output::StartDeploymentOutput)
    pub fn builder() -> crate::output::start_deployment_output::Builder {
        crate::output::start_deployment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResumeServiceOutput {
    /// <p>A description of the App Runner service that this request just resumed.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
    /// the operation's progress.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResumeServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResumeServiceOutput");
        formatter.field("service", &self.service);
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`ResumeServiceOutput`](crate::output::ResumeServiceOutput)
pub mod resume_service_output {
    /// A builder for [`ResumeServiceOutput`](crate::output::ResumeServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the App Runner service that this request just resumed.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A description of the App Runner service that this request just resumed.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeServiceOutput`](crate::output::ResumeServiceOutput)
        pub fn build(self) -> crate::output::ResumeServiceOutput {
            crate::output::ResumeServiceOutput {
                service: self.service,
                operation_id: self.operation_id,
            }
        }
    }
}
impl ResumeServiceOutput {
    /// Creates a new builder-style object to manufacture [`ResumeServiceOutput`](crate::output::ResumeServiceOutput)
    pub fn builder() -> crate::output::resume_service_output::Builder {
        crate::output::resume_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PauseServiceOutput {
    /// <p>A description of the App Runner service that this request just paused.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
    /// the operation's progress.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PauseServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PauseServiceOutput");
        formatter.field("service", &self.service);
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`PauseServiceOutput`](crate::output::PauseServiceOutput)
pub mod pause_service_output {
    /// A builder for [`PauseServiceOutput`](crate::output::PauseServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the App Runner service that this request just paused.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A description of the App Runner service that this request just paused.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PauseServiceOutput`](crate::output::PauseServiceOutput)
        pub fn build(self) -> crate::output::PauseServiceOutput {
            crate::output::PauseServiceOutput {
                service: self.service,
                operation_id: self.operation_id,
            }
        }
    }
}
impl PauseServiceOutput {
    /// Creates a new builder-style object to manufacture [`PauseServiceOutput`](crate::output::PauseServiceOutput)
    pub fn builder() -> crate::output::pause_service_output::Builder {
        crate::output::pause_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of the tag key-value pairs that are associated with the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of the tag key-value pairs that are associated with the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of the tag key-value pairs that are associated with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListServicesOutput {
    /// <p>A list of service summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>
    pub service_summary_list: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
    /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListServicesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListServicesOutput");
        formatter.field("service_summary_list", &self.service_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListServicesOutput`](crate::output::ListServicesOutput)
pub mod list_services_output {
    /// A builder for [`ListServicesOutput`](crate::output::ListServicesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `service_summary_list`.
        ///
        /// To override the contents of this collection use [`set_service_summary_list`](Self::set_service_summary_list).
        ///
        /// <p>A list of service summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>
        pub fn service_summary_list(
            mut self,
            input: impl Into<crate::model::ServiceSummary>,
        ) -> Self {
            let mut v = self.service_summary_list.unwrap_or_default();
            v.push(input.into());
            self.service_summary_list = Some(v);
            self
        }
        /// <p>A list of service summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each call.</p>
        pub fn set_service_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ServiceSummary>>,
        ) -> Self {
            self.service_summary_list = input;
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListServicesOutput`](crate::output::ListServicesOutput)
        pub fn build(self) -> crate::output::ListServicesOutput {
            crate::output::ListServicesOutput {
                service_summary_list: self.service_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListServicesOutput {
    /// Creates a new builder-style object to manufacture [`ListServicesOutput`](crate::output::ListServicesOutput)
    pub fn builder() -> crate::output::list_services_output::Builder {
        crate::output::list_services_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOperationsOutput {
    /// <p>A list of operation summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each
    /// call.</p>
    pub operation_summary_list: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
    /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListOperationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOperationsOutput");
        formatter.field("operation_summary_list", &self.operation_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListOperationsOutput`](crate::output::ListOperationsOutput)
pub mod list_operations_output {
    /// A builder for [`ListOperationsOutput`](crate::output::ListOperationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_summary_list:
            std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `operation_summary_list`.
        ///
        /// To override the contents of this collection use [`set_operation_summary_list`](Self::set_operation_summary_list).
        ///
        /// <p>A list of operation summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each
        /// call.</p>
        pub fn operation_summary_list(
            mut self,
            input: impl Into<crate::model::OperationSummary>,
        ) -> Self {
            let mut v = self.operation_summary_list.unwrap_or_default();
            v.push(input.into());
            self.operation_summary_list = Some(v);
            self
        }
        /// <p>A list of operation summary information records. In a paginated request, the request returns up to <code>MaxResults</code> records for each
        /// call.</p>
        pub fn set_operation_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OperationSummary>>,
        ) -> Self {
            self.operation_summary_list = input;
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOperationsOutput`](crate::output::ListOperationsOutput)
        pub fn build(self) -> crate::output::ListOperationsOutput {
            crate::output::ListOperationsOutput {
                operation_summary_list: self.operation_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListOperationsOutput {
    /// Creates a new builder-style object to manufacture [`ListOperationsOutput`](crate::output::ListOperationsOutput)
    pub fn builder() -> crate::output::list_operations_output::Builder {
        crate::output::list_operations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListConnectionsOutput {
    /// <p>A list of summary information records for connections. In a paginated request, the request returns up to <code>MaxResults</code> records for each
    /// call.</p>
    pub connection_summary_list:
        std::option::Option<std::vec::Vec<crate::model::ConnectionSummary>>,
    /// <p>The token that you can pass in a subsequent request to get the next result page. Returned in a paginated request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListConnectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListConnectionsOutput");
        formatter.field("connection_summary_list", &self.connection_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
pub mod list_connections_output {
    /// A builder for [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_summary_list:
            std::option::Option<std::vec::Vec<crate::model::ConnectionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `connection_summary_list`.
        ///
        /// To override the contents of this collection use [`set_connection_summary_list`](Self::set_connection_summary_list).
        ///
        /// <p>A list of summary information records for connections. In a paginated request, the request returns up to <code>MaxResults</code> records for each
        /// call.</p>
        pub fn connection_summary_list(
            mut self,
            input: impl Into<crate::model::ConnectionSummary>,
        ) -> Self {
            let mut v = self.connection_summary_list.unwrap_or_default();
            v.push(input.into());
            self.connection_summary_list = Some(v);
            self
        }
        /// <p>A list of summary information records for connections. In a paginated request, the request returns up to <code>MaxResults</code> records for each
        /// call.</p>
        pub fn set_connection_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectionSummary>>,
        ) -> Self {
            self.connection_summary_list = input;
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. Returned in a paginated request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. Returned in a paginated request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
        pub fn build(self) -> crate::output::ListConnectionsOutput {
            crate::output::ListConnectionsOutput {
                connection_summary_list: self.connection_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListConnectionsOutput {
    /// Creates a new builder-style object to manufacture [`ListConnectionsOutput`](crate::output::ListConnectionsOutput)
    pub fn builder() -> crate::output::list_connections_output::Builder {
        crate::output::list_connections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAutoScalingConfigurationsOutput {
    /// <p>A list of summary information records for auto scaling configurations. In a paginated request, the request returns up to <code>MaxResults</code>
    /// records for each call.</p>
    pub auto_scaling_configuration_summary_list:
        std::option::Option<std::vec::Vec<crate::model::AutoScalingConfigurationSummary>>,
    /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListAutoScalingConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAutoScalingConfigurationsOutput");
        formatter.field(
            "auto_scaling_configuration_summary_list",
            &self.auto_scaling_configuration_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAutoScalingConfigurationsOutput`](crate::output::ListAutoScalingConfigurationsOutput)
pub mod list_auto_scaling_configurations_output {
    /// A builder for [`ListAutoScalingConfigurationsOutput`](crate::output::ListAutoScalingConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_configuration_summary_list:
            std::option::Option<std::vec::Vec<crate::model::AutoScalingConfigurationSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `auto_scaling_configuration_summary_list`.
        ///
        /// To override the contents of this collection use [`set_auto_scaling_configuration_summary_list`](Self::set_auto_scaling_configuration_summary_list).
        ///
        /// <p>A list of summary information records for auto scaling configurations. In a paginated request, the request returns up to <code>MaxResults</code>
        /// records for each call.</p>
        pub fn auto_scaling_configuration_summary_list(
            mut self,
            input: impl Into<crate::model::AutoScalingConfigurationSummary>,
        ) -> Self {
            let mut v = self
                .auto_scaling_configuration_summary_list
                .unwrap_or_default();
            v.push(input.into());
            self.auto_scaling_configuration_summary_list = Some(v);
            self
        }
        /// <p>A list of summary information records for auto scaling configurations. In a paginated request, the request returns up to <code>MaxResults</code>
        /// records for each call.</p>
        pub fn set_auto_scaling_configuration_summary_list(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::AutoScalingConfigurationSummary>,
            >,
        ) -> Self {
            self.auto_scaling_configuration_summary_list = input;
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAutoScalingConfigurationsOutput`](crate::output::ListAutoScalingConfigurationsOutput)
        pub fn build(self) -> crate::output::ListAutoScalingConfigurationsOutput {
            crate::output::ListAutoScalingConfigurationsOutput {
                auto_scaling_configuration_summary_list: self
                    .auto_scaling_configuration_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAutoScalingConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAutoScalingConfigurationsOutput`](crate::output::ListAutoScalingConfigurationsOutput)
    pub fn builder() -> crate::output::list_auto_scaling_configurations_output::Builder {
        crate::output::list_auto_scaling_configurations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateCustomDomainOutput {
    /// <p>The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to this target name.</p>
    pub dns_target: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated from.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>A description of the domain name that's being disassociated.</p>
    pub custom_domain: std::option::Option<crate::model::CustomDomain>,
}
impl std::fmt::Debug for DisassociateCustomDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateCustomDomainOutput");
        formatter.field("dns_target", &self.dns_target);
        formatter.field("service_arn", &self.service_arn);
        formatter.field("custom_domain", &self.custom_domain);
        formatter.finish()
    }
}
/// See [`DisassociateCustomDomainOutput`](crate::output::DisassociateCustomDomainOutput)
pub mod disassociate_custom_domain_output {
    /// A builder for [`DisassociateCustomDomainOutput`](crate::output::DisassociateCustomDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_target: std::option::Option<std::string::String>,
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) custom_domain: std::option::Option<crate::model::CustomDomain>,
    }
    impl Builder {
        /// <p>The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to this target name.</p>
        pub fn dns_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_target = Some(input.into());
            self
        }
        /// <p>The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to this target name.</p>
        pub fn set_dns_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_target = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated from.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated from.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// <p>A description of the domain name that's being disassociated.</p>
        pub fn custom_domain(mut self, input: crate::model::CustomDomain) -> Self {
            self.custom_domain = Some(input);
            self
        }
        /// <p>A description of the domain name that's being disassociated.</p>
        pub fn set_custom_domain(
            mut self,
            input: std::option::Option<crate::model::CustomDomain>,
        ) -> Self {
            self.custom_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateCustomDomainOutput`](crate::output::DisassociateCustomDomainOutput)
        pub fn build(self) -> crate::output::DisassociateCustomDomainOutput {
            crate::output::DisassociateCustomDomainOutput {
                dns_target: self.dns_target,
                service_arn: self.service_arn,
                custom_domain: self.custom_domain,
            }
        }
    }
}
impl DisassociateCustomDomainOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateCustomDomainOutput`](crate::output::DisassociateCustomDomainOutput)
    pub fn builder() -> crate::output::disassociate_custom_domain_output::Builder {
        crate::output::disassociate_custom_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeServiceOutput {
    /// <p>A full description of the App Runner service that you specified in this request.</p>
    pub service: std::option::Option<crate::model::Service>,
}
impl std::fmt::Debug for DescribeServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeServiceOutput");
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`DescribeServiceOutput`](crate::output::DescribeServiceOutput)
pub mod describe_service_output {
    /// A builder for [`DescribeServiceOutput`](crate::output::DescribeServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
    }
    impl Builder {
        /// <p>A full description of the App Runner service that you specified in this request.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A full description of the App Runner service that you specified in this request.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeServiceOutput`](crate::output::DescribeServiceOutput)
        pub fn build(self) -> crate::output::DescribeServiceOutput {
            crate::output::DescribeServiceOutput {
                service: self.service,
            }
        }
    }
}
impl DescribeServiceOutput {
    /// Creates a new builder-style object to manufacture [`DescribeServiceOutput`](crate::output::DescribeServiceOutput)
    pub fn builder() -> crate::output::describe_service_output::Builder {
        crate::output::describe_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomDomainsOutput {
    /// <p>The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this target name.</p>
    pub dns_target: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to describe.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>A list of descriptions of custom domain names that are associated with the service. In a paginated request, the request returns up to
    /// <code>MaxResults</code> records per call.</p>
    pub custom_domains: std::option::Option<std::vec::Vec<crate::model::CustomDomain>>,
    /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCustomDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomDomainsOutput");
        formatter.field("dns_target", &self.dns_target);
        formatter.field("service_arn", &self.service_arn);
        formatter.field("custom_domains", &self.custom_domains);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeCustomDomainsOutput`](crate::output::DescribeCustomDomainsOutput)
pub mod describe_custom_domains_output {
    /// A builder for [`DescribeCustomDomainsOutput`](crate::output::DescribeCustomDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_target: std::option::Option<std::string::String>,
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) custom_domains: std::option::Option<std::vec::Vec<crate::model::CustomDomain>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this target name.</p>
        pub fn dns_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_target = Some(input.into());
            self
        }
        /// <p>The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this target name.</p>
        pub fn set_dns_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_target = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to describe.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to describe.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// Appends an item to `custom_domains`.
        ///
        /// To override the contents of this collection use [`set_custom_domains`](Self::set_custom_domains).
        ///
        /// <p>A list of descriptions of custom domain names that are associated with the service. In a paginated request, the request returns up to
        /// <code>MaxResults</code> records per call.</p>
        pub fn custom_domains(mut self, input: impl Into<crate::model::CustomDomain>) -> Self {
            let mut v = self.custom_domains.unwrap_or_default();
            v.push(input.into());
            self.custom_domains = Some(v);
            self
        }
        /// <p>A list of descriptions of custom domain names that are associated with the service. In a paginated request, the request returns up to
        /// <code>MaxResults</code> records per call.</p>
        pub fn set_custom_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomDomain>>,
        ) -> Self {
            self.custom_domains = input;
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomDomainsOutput`](crate::output::DescribeCustomDomainsOutput)
        pub fn build(self) -> crate::output::DescribeCustomDomainsOutput {
            crate::output::DescribeCustomDomainsOutput {
                dns_target: self.dns_target,
                service_arn: self.service_arn,
                custom_domains: self.custom_domains,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeCustomDomainsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCustomDomainsOutput`](crate::output::DescribeCustomDomainsOutput)
    pub fn builder() -> crate::output::describe_custom_domains_output::Builder {
        crate::output::describe_custom_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAutoScalingConfigurationOutput {
    /// <p>A full description of the App Runner auto scaling configuration that you specified in this request.</p>
    pub auto_scaling_configuration: std::option::Option<crate::model::AutoScalingConfiguration>,
}
impl std::fmt::Debug for DescribeAutoScalingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAutoScalingConfigurationOutput");
        formatter.field(
            "auto_scaling_configuration",
            &self.auto_scaling_configuration,
        );
        formatter.finish()
    }
}
/// See [`DescribeAutoScalingConfigurationOutput`](crate::output::DescribeAutoScalingConfigurationOutput)
pub mod describe_auto_scaling_configuration_output {
    /// A builder for [`DescribeAutoScalingConfigurationOutput`](crate::output::DescribeAutoScalingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_configuration:
            std::option::Option<crate::model::AutoScalingConfiguration>,
    }
    impl Builder {
        /// <p>A full description of the App Runner auto scaling configuration that you specified in this request.</p>
        pub fn auto_scaling_configuration(
            mut self,
            input: crate::model::AutoScalingConfiguration,
        ) -> Self {
            self.auto_scaling_configuration = Some(input);
            self
        }
        /// <p>A full description of the App Runner auto scaling configuration that you specified in this request.</p>
        pub fn set_auto_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoScalingConfiguration>,
        ) -> Self {
            self.auto_scaling_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAutoScalingConfigurationOutput`](crate::output::DescribeAutoScalingConfigurationOutput)
        pub fn build(self) -> crate::output::DescribeAutoScalingConfigurationOutput {
            crate::output::DescribeAutoScalingConfigurationOutput {
                auto_scaling_configuration: self.auto_scaling_configuration,
            }
        }
    }
}
impl DescribeAutoScalingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAutoScalingConfigurationOutput`](crate::output::DescribeAutoScalingConfigurationOutput)
    pub fn builder() -> crate::output::describe_auto_scaling_configuration_output::Builder {
        crate::output::describe_auto_scaling_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteServiceOutput {
    /// <p>A description of the App Runner service that this request just deleted.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
    /// the operation's progress.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteServiceOutput");
        formatter.field("service", &self.service);
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
pub mod delete_service_output {
    /// A builder for [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the App Runner service that this request just deleted.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A description of the App Runner service that this request just deleted.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a>ListOperations</a> call to track
        /// the operation's progress.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
        pub fn build(self) -> crate::output::DeleteServiceOutput {
            crate::output::DeleteServiceOutput {
                service: self.service,
                operation_id: self.operation_id,
            }
        }
    }
}
impl DeleteServiceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteServiceOutput`](crate::output::DeleteServiceOutput)
    pub fn builder() -> crate::output::delete_service_output::Builder {
        crate::output::delete_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionOutput {
    /// <p>A description of the App Runner connection that this request just deleted.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl std::fmt::Debug for DeleteConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
pub mod delete_connection_output {
    /// A builder for [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>A description of the App Runner connection that this request just deleted.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>A description of the App Runner connection that this request just deleted.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
        pub fn build(self) -> crate::output::DeleteConnectionOutput {
            crate::output::DeleteConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl DeleteConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteConnectionOutput`](crate::output::DeleteConnectionOutput)
    pub fn builder() -> crate::output::delete_connection_output::Builder {
        crate::output::delete_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAutoScalingConfigurationOutput {
    /// <p>A description of the App Runner auto scaling configuration that this request just deleted.</p>
    pub auto_scaling_configuration: std::option::Option<crate::model::AutoScalingConfiguration>,
}
impl std::fmt::Debug for DeleteAutoScalingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAutoScalingConfigurationOutput");
        formatter.field(
            "auto_scaling_configuration",
            &self.auto_scaling_configuration,
        );
        formatter.finish()
    }
}
/// See [`DeleteAutoScalingConfigurationOutput`](crate::output::DeleteAutoScalingConfigurationOutput)
pub mod delete_auto_scaling_configuration_output {
    /// A builder for [`DeleteAutoScalingConfigurationOutput`](crate::output::DeleteAutoScalingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_configuration:
            std::option::Option<crate::model::AutoScalingConfiguration>,
    }
    impl Builder {
        /// <p>A description of the App Runner auto scaling configuration that this request just deleted.</p>
        pub fn auto_scaling_configuration(
            mut self,
            input: crate::model::AutoScalingConfiguration,
        ) -> Self {
            self.auto_scaling_configuration = Some(input);
            self
        }
        /// <p>A description of the App Runner auto scaling configuration that this request just deleted.</p>
        pub fn set_auto_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoScalingConfiguration>,
        ) -> Self {
            self.auto_scaling_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAutoScalingConfigurationOutput`](crate::output::DeleteAutoScalingConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteAutoScalingConfigurationOutput {
            crate::output::DeleteAutoScalingConfigurationOutput {
                auto_scaling_configuration: self.auto_scaling_configuration,
            }
        }
    }
}
impl DeleteAutoScalingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAutoScalingConfigurationOutput`](crate::output::DeleteAutoScalingConfigurationOutput)
    pub fn builder() -> crate::output::delete_auto_scaling_configuration_output::Builder {
        crate::output::delete_auto_scaling_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateServiceOutput {
    /// <p>A description of the App Runner service that's created by this request.</p>
    pub service: std::option::Option<crate::model::Service>,
    /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to track the operation's progress.</p>
    pub operation_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateServiceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateServiceOutput");
        formatter.field("service", &self.service);
        formatter.field("operation_id", &self.operation_id);
        formatter.finish()
    }
}
/// See [`CreateServiceOutput`](crate::output::CreateServiceOutput)
pub mod create_service_output {
    /// A builder for [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<crate::model::Service>,
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A description of the App Runner service that's created by this request.</p>
        pub fn service(mut self, input: crate::model::Service) -> Self {
            self.service = Some(input);
            self
        }
        /// <p>A description of the App Runner service that's created by this request.</p>
        pub fn set_service(mut self, input: std::option::Option<crate::model::Service>) -> Self {
            self.service = input;
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to track the operation's progress.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the asynchronous operation that this request started. You can use it combined with the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to track the operation's progress.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateServiceOutput`](crate::output::CreateServiceOutput)
        pub fn build(self) -> crate::output::CreateServiceOutput {
            crate::output::CreateServiceOutput {
                service: self.service,
                operation_id: self.operation_id,
            }
        }
    }
}
impl CreateServiceOutput {
    /// Creates a new builder-style object to manufacture [`CreateServiceOutput`](crate::output::CreateServiceOutput)
    pub fn builder() -> crate::output::create_service_output::Builder {
        crate::output::create_service_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOutput {
    /// <p>A description of the App Runner connection that's created by this request.</p>
    pub connection: std::option::Option<crate::model::Connection>,
}
impl std::fmt::Debug for CreateConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOutput");
        formatter.field("connection", &self.connection);
        formatter.finish()
    }
}
/// See [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
pub mod create_connection_output {
    /// A builder for [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection: std::option::Option<crate::model::Connection>,
    }
    impl Builder {
        /// <p>A description of the App Runner connection that's created by this request.</p>
        pub fn connection(mut self, input: crate::model::Connection) -> Self {
            self.connection = Some(input);
            self
        }
        /// <p>A description of the App Runner connection that's created by this request.</p>
        pub fn set_connection(
            mut self,
            input: std::option::Option<crate::model::Connection>,
        ) -> Self {
            self.connection = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
        pub fn build(self) -> crate::output::CreateConnectionOutput {
            crate::output::CreateConnectionOutput {
                connection: self.connection,
            }
        }
    }
}
impl CreateConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOutput`](crate::output::CreateConnectionOutput)
    pub fn builder() -> crate::output::create_connection_output::Builder {
        crate::output::create_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAutoScalingConfigurationOutput {
    /// <p>A description of the App Runner auto scaling configuration that's created by this request.</p>
    pub auto_scaling_configuration: std::option::Option<crate::model::AutoScalingConfiguration>,
}
impl std::fmt::Debug for CreateAutoScalingConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAutoScalingConfigurationOutput");
        formatter.field(
            "auto_scaling_configuration",
            &self.auto_scaling_configuration,
        );
        formatter.finish()
    }
}
/// See [`CreateAutoScalingConfigurationOutput`](crate::output::CreateAutoScalingConfigurationOutput)
pub mod create_auto_scaling_configuration_output {
    /// A builder for [`CreateAutoScalingConfigurationOutput`](crate::output::CreateAutoScalingConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_scaling_configuration:
            std::option::Option<crate::model::AutoScalingConfiguration>,
    }
    impl Builder {
        /// <p>A description of the App Runner auto scaling configuration that's created by this request.</p>
        pub fn auto_scaling_configuration(
            mut self,
            input: crate::model::AutoScalingConfiguration,
        ) -> Self {
            self.auto_scaling_configuration = Some(input);
            self
        }
        /// <p>A description of the App Runner auto scaling configuration that's created by this request.</p>
        pub fn set_auto_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::AutoScalingConfiguration>,
        ) -> Self {
            self.auto_scaling_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAutoScalingConfigurationOutput`](crate::output::CreateAutoScalingConfigurationOutput)
        pub fn build(self) -> crate::output::CreateAutoScalingConfigurationOutput {
            crate::output::CreateAutoScalingConfigurationOutput {
                auto_scaling_configuration: self.auto_scaling_configuration,
            }
        }
    }
}
impl CreateAutoScalingConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateAutoScalingConfigurationOutput`](crate::output::CreateAutoScalingConfigurationOutput)
    pub fn builder() -> crate::output::create_auto_scaling_configuration_output::Builder {
        crate::output::create_auto_scaling_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateCustomDomainOutput {
    /// <p>The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name.</p>
    pub dns_target: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is associated.</p>
    pub service_arn: std::option::Option<std::string::String>,
    /// <p>A description of the domain name that's being associated.</p>
    pub custom_domain: std::option::Option<crate::model::CustomDomain>,
}
impl std::fmt::Debug for AssociateCustomDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateCustomDomainOutput");
        formatter.field("dns_target", &self.dns_target);
        formatter.field("service_arn", &self.service_arn);
        formatter.field("custom_domain", &self.custom_domain);
        formatter.finish()
    }
}
/// See [`AssociateCustomDomainOutput`](crate::output::AssociateCustomDomainOutput)
pub mod associate_custom_domain_output {
    /// A builder for [`AssociateCustomDomainOutput`](crate::output::AssociateCustomDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_target: std::option::Option<std::string::String>,
        pub(crate) service_arn: std::option::Option<std::string::String>,
        pub(crate) custom_domain: std::option::Option<crate::model::CustomDomain>,
    }
    impl Builder {
        /// <p>The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name.</p>
        pub fn dns_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_target = Some(input.into());
            self
        }
        /// <p>The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name.</p>
        pub fn set_dns_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_target = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is associated.</p>
        pub fn service_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is associated.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_arn = input;
            self
        }
        /// <p>A description of the domain name that's being associated.</p>
        pub fn custom_domain(mut self, input: crate::model::CustomDomain) -> Self {
            self.custom_domain = Some(input);
            self
        }
        /// <p>A description of the domain name that's being associated.</p>
        pub fn set_custom_domain(
            mut self,
            input: std::option::Option<crate::model::CustomDomain>,
        ) -> Self {
            self.custom_domain = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateCustomDomainOutput`](crate::output::AssociateCustomDomainOutput)
        pub fn build(self) -> crate::output::AssociateCustomDomainOutput {
            crate::output::AssociateCustomDomainOutput {
                dns_target: self.dns_target,
                service_arn: self.service_arn,
                custom_domain: self.custom_domain,
            }
        }
    }
}
impl AssociateCustomDomainOutput {
    /// Creates a new builder-style object to manufacture [`AssociateCustomDomainOutput`](crate::output::AssociateCustomDomainOutput)
    pub fn builder() -> crate::output::associate_custom_domain_output::Builder {
        crate::output::associate_custom_domain_output::Builder::default()
    }
}
