// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateCustomDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateCustomDomainError {
    /// Kind of error that occurred.
    pub kind: AssociateCustomDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateCustomDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateCustomDomainErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateCustomDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateCustomDomainErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            AssociateCustomDomainErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateCustomDomainErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            AssociateCustomDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateCustomDomainError {
    fn code(&self) -> Option<&str> {
        AssociateCustomDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateCustomDomainError {
    /// Creates a new `AssociateCustomDomainError`.
    pub fn new(kind: AssociateCustomDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateCustomDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateCustomDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateCustomDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateCustomDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AssociateCustomDomainErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomDomainErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `AssociateCustomDomainErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomDomainErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `AssociateCustomDomainErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCustomDomainErrorKind::InvalidStateException(_)
        )
    }
}
impl std::error::Error for AssociateCustomDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateCustomDomainErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            AssociateCustomDomainErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateCustomDomainErrorKind::InvalidStateException(_inner) => Some(_inner),
            AssociateCustomDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAutoScalingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAutoScalingConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateAutoScalingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAutoScalingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAutoScalingConfigurationErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>App Runner can't create this resource. You've reached your account quota for this resource type.</p>
    /// <p>For App Runner per-resource quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/apprunner.html">App Runner endpoints and quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAutoScalingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAutoScalingConfigurationErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            CreateAutoScalingConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreateAutoScalingConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateAutoScalingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAutoScalingConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateAutoScalingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAutoScalingConfigurationError {
    /// Creates a new `CreateAutoScalingConfigurationError`.
    pub fn new(
        kind: CreateAutoScalingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAutoScalingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAutoScalingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAutoScalingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAutoScalingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateAutoScalingConfigurationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoScalingConfigurationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateAutoScalingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoScalingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateAutoScalingConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAutoScalingConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
}
impl std::error::Error for CreateAutoScalingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAutoScalingConfigurationErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            CreateAutoScalingConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            CreateAutoScalingConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateAutoScalingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectionErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>App Runner can't create this resource. You've reached your account quota for this resource type.</p>
    /// <p>For App Runner per-resource quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/apprunner.html">App Runner endpoints and quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectionErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectionError {
    fn code(&self) -> Option<&str> {
        CreateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectionError {
    /// Creates a new `CreateConnectionError`.
    pub fn new(kind: CreateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateConnectionErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateConnectionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateConnectionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::ServiceQuotaExceededException(_)
        )
    }
}
impl std::error::Error for CreateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectionErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateConnectionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateConnectionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateServiceError {
    /// Kind of error that occurred.
    pub kind: CreateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateServiceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>App Runner can't create this resource. You've reached your account quota for this resource type.</p>
    /// <p>For App Runner per-resource quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/apprunner.html">App Runner endpoints and quotas</a> in the
    /// <i>Amazon Web Services General Reference</i>.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateServiceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateServiceError {
    fn code(&self) -> Option<&str> {
        CreateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateServiceError {
    /// Creates a new `CreateServiceError`.
    pub fn new(kind: CreateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateServiceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `CreateServiceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `CreateServiceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateServiceErrorKind::ServiceQuotaExceededException(_)
        )
    }
}
impl std::error::Error for CreateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateServiceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateServiceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateServiceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAutoScalingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAutoScalingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteAutoScalingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAutoScalingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAutoScalingConfigurationErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAutoScalingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAutoScalingConfigurationErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAutoScalingConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAutoScalingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAutoScalingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAutoScalingConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteAutoScalingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAutoScalingConfigurationError {
    /// Creates a new `DeleteAutoScalingConfigurationError`.
    pub fn new(
        kind: DeleteAutoScalingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAutoScalingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAutoScalingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAutoScalingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAutoScalingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteAutoScalingConfigurationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoScalingConfigurationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAutoScalingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoScalingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteAutoScalingConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoScalingConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteAutoScalingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAutoScalingConfigurationErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DeleteAutoScalingConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DeleteAutoScalingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteAutoScalingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectionErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectionErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectionError {
    /// Creates a new `DeleteConnectionError`.
    pub fn new(kind: DeleteConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteConnectionErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConnectionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectionErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteServiceError {
    /// Kind of error that occurred.
    pub kind: DeleteServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteServiceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteServiceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteServiceError {
    fn code(&self) -> Option<&str> {
        DeleteServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteServiceError {
    /// Creates a new `DeleteServiceError`.
    pub fn new(kind: DeleteServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteServiceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DeleteServiceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteServiceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, DeleteServiceErrorKind::InvalidStateException(_))
    }
    /// Returns true if the error kind is `DeleteServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteServiceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteServiceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteServiceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteServiceErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeleteServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAutoScalingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAutoScalingConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeAutoScalingConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAutoScalingConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAutoScalingConfigurationErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAutoScalingConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAutoScalingConfigurationErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAutoScalingConfigurationErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAutoScalingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAutoScalingConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAutoScalingConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeAutoScalingConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAutoScalingConfigurationError {
    /// Creates a new `DescribeAutoScalingConfigurationError`.
    pub fn new(
        kind: DescribeAutoScalingConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAutoScalingConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAutoScalingConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAutoScalingConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAutoScalingConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeAutoScalingConfigurationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingConfigurationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAutoScalingConfigurationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingConfigurationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeAutoScalingConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAutoScalingConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeAutoScalingConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAutoScalingConfigurationErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DescribeAutoScalingConfigurationErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeAutoScalingConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAutoScalingConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomDomainsError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomDomainsErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomDomainsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DescribeCustomDomainsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeCustomDomainsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeCustomDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomDomainsError {
    fn code(&self) -> Option<&str> {
        DescribeCustomDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomDomainsError {
    /// Creates a new `DescribeCustomDomainsError`.
    pub fn new(kind: DescribeCustomDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeCustomDomainsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomDomainsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomDomainsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomDomainsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeCustomDomainsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomDomainsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCustomDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomDomainsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DescribeCustomDomainsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeCustomDomainsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeCustomDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeServiceError {
    /// Kind of error that occurred.
    pub kind: DescribeServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeServiceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeServiceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DescribeServiceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeServiceError {
    fn code(&self) -> Option<&str> {
        DescribeServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeServiceError {
    /// Creates a new `DescribeServiceError`.
    pub fn new(kind: DescribeServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeServiceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DescribeServiceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DescribeServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeServiceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeServiceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DescribeServiceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateCustomDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateCustomDomainError {
    /// Kind of error that occurred.
    pub kind: DisassociateCustomDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateCustomDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateCustomDomainErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateCustomDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateCustomDomainErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateCustomDomainErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateCustomDomainErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DisassociateCustomDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateCustomDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateCustomDomainError {
    fn code(&self) -> Option<&str> {
        DisassociateCustomDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateCustomDomainError {
    /// Creates a new `DisassociateCustomDomainError`.
    pub fn new(kind: DisassociateCustomDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateCustomDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateCustomDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateCustomDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateCustomDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DisassociateCustomDomainErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomDomainErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateCustomDomainErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomDomainErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateCustomDomainErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomDomainErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `DisassociateCustomDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCustomDomainErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisassociateCustomDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateCustomDomainErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            DisassociateCustomDomainErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateCustomDomainErrorKind::InvalidStateException(_inner) => Some(_inner),
            DisassociateCustomDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateCustomDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAutoScalingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAutoScalingConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListAutoScalingConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAutoScalingConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAutoScalingConfigurationsErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAutoScalingConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAutoScalingConfigurationsErrorKind::InternalServiceErrorException(_inner) => {
                _inner.fmt(f)
            }
            ListAutoScalingConfigurationsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListAutoScalingConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAutoScalingConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListAutoScalingConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAutoScalingConfigurationsError {
    /// Creates a new `ListAutoScalingConfigurationsError`.
    pub fn new(
        kind: ListAutoScalingConfigurationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAutoScalingConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAutoScalingConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAutoScalingConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAutoScalingConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAutoScalingConfigurationsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAutoScalingConfigurationsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListAutoScalingConfigurationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAutoScalingConfigurationsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListAutoScalingConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAutoScalingConfigurationsErrorKind::InternalServiceErrorException(_inner) => {
                Some(_inner)
            }
            ListAutoScalingConfigurationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAutoScalingConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConnectionsError {
    /// Kind of error that occurred.
    pub kind: ListConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConnectionsErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConnectionsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListConnectionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConnectionsError {
    fn code(&self) -> Option<&str> {
        ListConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConnectionsError {
    /// Creates a new `ListConnectionsError`.
    pub fn new(kind: ListConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListConnectionsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectionsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListConnectionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListConnectionsErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConnectionsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListConnectionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOperationsError {
    /// Kind of error that occurred.
    pub kind: ListOperationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOperationsErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOperationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOperationsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListOperationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListOperationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListOperationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOperationsError {
    fn code(&self) -> Option<&str> {
        ListOperationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOperationsError {
    /// Creates a new `ListOperationsError`.
    pub fn new(kind: ListOperationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOperationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOperationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOperationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOperationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListOperationsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOperationsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListOperationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOperationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListOperationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOperationsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListOperationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOperationsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListOperationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListOperationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListOperationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListServicesError {
    /// Kind of error that occurred.
    pub kind: ListServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListServicesErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListServicesErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListServicesError {
    fn code(&self) -> Option<&str> {
        ListServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListServicesError {
    /// Creates a new `ListServicesError`.
    pub fn new(kind: ListServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListServicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListServicesErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListServicesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListServicesErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListServicesErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListServicesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidStateException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PauseService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PauseServiceError {
    /// Kind of error that occurred.
    pub kind: PauseServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PauseService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PauseServiceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PauseServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PauseServiceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            PauseServiceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            PauseServiceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            PauseServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PauseServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PauseServiceError {
    fn code(&self) -> Option<&str> {
        PauseServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PauseServiceError {
    /// Creates a new `PauseServiceError`.
    pub fn new(kind: PauseServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PauseServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PauseServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PauseServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PauseServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PauseServiceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PauseServiceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `PauseServiceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PauseServiceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `PauseServiceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, PauseServiceErrorKind::InvalidStateException(_))
    }
    /// Returns true if the error kind is `PauseServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PauseServiceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PauseServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PauseServiceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            PauseServiceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            PauseServiceErrorKind::InvalidStateException(_inner) => Some(_inner),
            PauseServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PauseServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResumeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResumeServiceError {
    /// Kind of error that occurred.
    pub kind: ResumeServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResumeService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResumeServiceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResumeServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResumeServiceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ResumeServiceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ResumeServiceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ResumeServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResumeServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResumeServiceError {
    fn code(&self) -> Option<&str> {
        ResumeServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResumeServiceError {
    /// Creates a new `ResumeServiceError`.
    pub fn new(kind: ResumeServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResumeServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResumeServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResumeServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResumeServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ResumeServiceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeServiceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `ResumeServiceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeServiceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `ResumeServiceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, ResumeServiceErrorKind::InvalidStateException(_))
    }
    /// Returns true if the error kind is `ResumeServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeServiceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ResumeServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResumeServiceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ResumeServiceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ResumeServiceErrorKind::InvalidStateException(_inner) => Some(_inner),
            ResumeServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResumeServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDeploymentError {
    /// Kind of error that occurred.
    pub kind: StartDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDeploymentErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDeploymentErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDeploymentError {
    fn code(&self) -> Option<&str> {
        StartDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDeploymentError {
    /// Creates a new `StartDeploymentError`.
    pub fn new(kind: StartDeploymentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartDeploymentErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `StartDeploymentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `StartDeploymentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartDeploymentErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDeploymentErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            StartDeploymentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartDeploymentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidStateException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InvalidStateException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceErrorKind {
    /// <p>An unexpected service exception occurred.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>You can't perform this action when the resource is in its current state.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceError {
    fn code(&self) -> Option<&str> {
        UpdateServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceError {
    /// Creates a new `UpdateServiceError`.
    pub fn new(kind: UpdateServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateServiceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns true if the error kind is `UpdateServiceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(&self.kind, UpdateServiceErrorKind::InvalidStateException(_))
    }
    /// Returns true if the error kind is `UpdateServiceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UpdateServiceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateServiceErrorKind::InvalidStateException(_inner) => Some(_inner),
            UpdateServiceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>A resource doesn't exist for the specified Amazon Resource Name (ARN) in your Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>You can't perform this action when the resource is in its current state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateException {}
/// See [`InvalidStateException`](crate::error::InvalidStateException)
pub mod invalid_state_exception {
    /// A builder for [`InvalidStateException`](crate::error::InvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateException`](crate::error::InvalidStateException)
        pub fn build(self) -> crate::error::InvalidStateException {
            crate::error::InvalidStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateException {
    /// Creates a new builder-style object to manufacture [`InvalidStateException`](crate::error::InvalidStateException)
    pub fn builder() -> crate::error::invalid_state_exception::Builder {
        crate::error::invalid_state_exception::Builder::default()
    }
}

/// <p>One or more input parameters aren't valid. Refer to the API action's document page, correct the input parameters, and try the action again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>An unexpected service exception occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceErrorException {}
/// See [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
pub mod internal_service_error_exception {
    /// A builder for [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
        pub fn build(self) -> crate::error::InternalServiceErrorException {
            crate::error::InternalServiceErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    pub fn builder() -> crate::error::internal_service_error_exception::Builder {
        crate::error::internal_service_error_exception::Builder::default()
    }
}

/// <p>App Runner can't create this resource. You've reached your account quota for this resource type.</p>
/// <p>For App Runner per-resource quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/apprunner.html">App Runner endpoints and quotas</a> in the
/// <i>Amazon Web Services General Reference</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
