// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AppRunner`.
///
/// This client allows ergonomic access to a `AppRunner`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateCustomDomain` operation.
    ///
    /// See [`AssociateCustomDomain`](crate::client::fluent_builders::AssociateCustomDomain) for more information about the
    /// operation and its arguments.
    pub fn associate_custom_domain(&self) -> fluent_builders::AssociateCustomDomain<C, M, R> {
        fluent_builders::AssociateCustomDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAutoScalingConfiguration` operation.
    ///
    /// See [`CreateAutoScalingConfiguration`](crate::client::fluent_builders::CreateAutoScalingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_auto_scaling_configuration(
        &self,
    ) -> fluent_builders::CreateAutoScalingConfiguration<C, M, R> {
        fluent_builders::CreateAutoScalingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnection` operation.
    ///
    /// See [`CreateConnection`](crate::client::fluent_builders::CreateConnection) for more information about the
    /// operation and its arguments.
    pub fn create_connection(&self) -> fluent_builders::CreateConnection<C, M, R> {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateService` operation.
    ///
    /// See [`CreateService`](crate::client::fluent_builders::CreateService) for more information about the
    /// operation and its arguments.
    pub fn create_service(&self) -> fluent_builders::CreateService<C, M, R> {
        fluent_builders::CreateService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAutoScalingConfiguration` operation.
    ///
    /// See [`DeleteAutoScalingConfiguration`](crate::client::fluent_builders::DeleteAutoScalingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_auto_scaling_configuration(
        &self,
    ) -> fluent_builders::DeleteAutoScalingConfiguration<C, M, R> {
        fluent_builders::DeleteAutoScalingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnection` operation.
    ///
    /// See [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection<C, M, R> {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteService` operation.
    ///
    /// See [`DeleteService`](crate::client::fluent_builders::DeleteService) for more information about the
    /// operation and its arguments.
    pub fn delete_service(&self) -> fluent_builders::DeleteService<C, M, R> {
        fluent_builders::DeleteService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAutoScalingConfiguration` operation.
    ///
    /// See [`DescribeAutoScalingConfiguration`](crate::client::fluent_builders::DescribeAutoScalingConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_auto_scaling_configuration(
        &self,
    ) -> fluent_builders::DescribeAutoScalingConfiguration<C, M, R> {
        fluent_builders::DescribeAutoScalingConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCustomDomains` operation.
    ///
    /// See [`DescribeCustomDomains`](crate::client::fluent_builders::DescribeCustomDomains) for more information about the
    /// operation and its arguments.
    pub fn describe_custom_domains(&self) -> fluent_builders::DescribeCustomDomains<C, M, R> {
        fluent_builders::DescribeCustomDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeService` operation.
    ///
    /// See [`DescribeService`](crate::client::fluent_builders::DescribeService) for more information about the
    /// operation and its arguments.
    pub fn describe_service(&self) -> fluent_builders::DescribeService<C, M, R> {
        fluent_builders::DescribeService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateCustomDomain` operation.
    ///
    /// See [`DisassociateCustomDomain`](crate::client::fluent_builders::DisassociateCustomDomain) for more information about the
    /// operation and its arguments.
    pub fn disassociate_custom_domain(&self) -> fluent_builders::DisassociateCustomDomain<C, M, R> {
        fluent_builders::DisassociateCustomDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAutoScalingConfigurations` operation.
    ///
    /// See [`ListAutoScalingConfigurations`](crate::client::fluent_builders::ListAutoScalingConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_auto_scaling_configurations(
        &self,
    ) -> fluent_builders::ListAutoScalingConfigurations<C, M, R> {
        fluent_builders::ListAutoScalingConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnections` operation.
    ///
    /// See [`ListConnections`](crate::client::fluent_builders::ListConnections) for more information about the
    /// operation and its arguments.
    pub fn list_connections(&self) -> fluent_builders::ListConnections<C, M, R> {
        fluent_builders::ListConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOperations` operation.
    ///
    /// See [`ListOperations`](crate::client::fluent_builders::ListOperations) for more information about the
    /// operation and its arguments.
    pub fn list_operations(&self) -> fluent_builders::ListOperations<C, M, R> {
        fluent_builders::ListOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListServices` operation.
    ///
    /// See [`ListServices`](crate::client::fluent_builders::ListServices) for more information about the
    /// operation and its arguments.
    pub fn list_services(&self) -> fluent_builders::ListServices<C, M, R> {
        fluent_builders::ListServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PauseService` operation.
    ///
    /// See [`PauseService`](crate::client::fluent_builders::PauseService) for more information about the
    /// operation and its arguments.
    pub fn pause_service(&self) -> fluent_builders::PauseService<C, M, R> {
        fluent_builders::PauseService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResumeService` operation.
    ///
    /// See [`ResumeService`](crate::client::fluent_builders::ResumeService) for more information about the
    /// operation and its arguments.
    pub fn resume_service(&self) -> fluent_builders::ResumeService<C, M, R> {
        fluent_builders::ResumeService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartDeployment` operation.
    ///
    /// See [`StartDeployment`](crate::client::fluent_builders::StartDeployment) for more information about the
    /// operation and its arguments.
    pub fn start_deployment(&self) -> fluent_builders::StartDeployment<C, M, R> {
        fluent_builders::StartDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateService` operation.
    ///
    /// See [`UpdateService`](crate::client::fluent_builders::UpdateService) for more information about the
    /// operation and its arguments.
    pub fn update_service(&self) -> fluent_builders::UpdateService<C, M, R> {
        fluent_builders::UpdateService::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateCustomDomain`.
    ///
    /// <p>Associate your own domain name with the App Runner subdomain URL of your App Runner service.</p>
    /// <p>After you call <code>AssociateCustomDomain</code> and receive a successful response, use the information in the <a>CustomDomain</a> record
    /// that's returned to add CNAME records to your Domain Name System (DNS). For each mapped domain name, add a mapping to the target App Runner subdomain and one or
    /// more certificate validation records. App Runner then performs DNS validation to verify that you own or control the domain name that you associated. App Runner tracks
    /// domain validity in a certificate stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide">AWS Certificate Manager (ACM)</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateCustomDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_custom_domain_input::Builder,
    }
    impl<C, M, R> AssociateCustomDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateCustomDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateCustomDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateCustomDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateCustomDomainInputOperationOutputAlias,
                crate::output::AssociateCustomDomainOutput,
                crate::error::AssociateCustomDomainError,
                crate::input::AssociateCustomDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain name with.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain name with.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
        /// <p>A custom domain endpoint to associate. Specify a root domain (for example, <code>example.com</code>), a subdomain (for example,
        /// <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>A custom domain endpoint to associate. Specify a root domain (for example, <code>example.com</code>), a subdomain (for example,
        /// <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for example, <code>*.example.com</code>).</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Set to <code>true</code> to associate the subdomain <code>www.<i>DomainName</i>
        /// </code> with the App Runner service in addition to the base
        /// domain.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn enable_www_subdomain(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_www_subdomain(inp);
            self
        }
        /// <p>Set to <code>true</code> to associate the subdomain <code>www.<i>DomainName</i>
        /// </code> with the App Runner service in addition to the base
        /// domain.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_enable_www_subdomain(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_www_subdomain(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAutoScalingConfiguration`.
    ///
    /// <p>Create an App Runner automatic scaling configuration resource. App Runner requires this resource
    /// when you create App Runner services that require non-default auto scaling settings. You can share an
    /// auto scaling configuration across multiple services.</p>
    /// <p>Create multiple revisions of a configuration by using the same <code>AutoScalingConfigurationName</code> and different
    /// <code>AutoScalingConfigurationRevision</code> values. When you create a service, you can set it to use the latest active revision of an auto scaling
    /// configuration or a specific revision.</p>
    /// <p>Configure a higher <code>MinSize</code> to increase the spread of your App Runner service over more Availability Zones in the Amazon Web Services Region. The tradeoff is
    /// a higher minimal cost.</p>
    /// <p>Configure a lower <code>MaxSize</code> to control your cost. The tradeoff is lower responsiveness during peak demand.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAutoScalingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_auto_scaling_configuration_input::Builder,
    }
    impl<C, M, R> CreateAutoScalingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAutoScalingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAutoScalingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAutoScalingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAutoScalingConfigurationInputOperationOutputAlias,
                crate::output::CreateAutoScalingConfigurationOutput,
                crate::error::CreateAutoScalingConfigurationError,
                crate::input::CreateAutoScalingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the auto scaling configuration. When you use it for the first time in an Amazon Web Services Region, App Runner creates revision number <code>1</code> of this
        /// name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.</p>
        pub fn auto_scaling_configuration_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_scaling_configuration_name(inp);
            self
        }
        /// <p>A name for the auto scaling configuration. When you use it for the first time in an Amazon Web Services Region, App Runner creates revision number <code>1</code> of this
        /// name. When you use the same name in subsequent calls, App Runner creates incremental revisions of the configuration.</p>
        pub fn set_auto_scaling_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_configuration_name(input);
            self
        }
        /// <p>The maximum number of concurrent requests that you want an instance to process. If the number of concurrent requests exceeds this limit, App Runner scales
        /// up your service.</p>
        /// <p>Default: <code>100</code>
        /// </p>
        pub fn max_concurrency(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_concurrency(inp);
            self
        }
        /// <p>The maximum number of concurrent requests that you want an instance to process. If the number of concurrent requests exceeds this limit, App Runner scales
        /// up your service.</p>
        /// <p>Default: <code>100</code>
        /// </p>
        pub fn set_max_concurrency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_concurrency(input);
            self
        }
        /// <p>The minimum number of instances that App Runner provisions for your service. The service always has at least <code>MinSize</code> provisioned instances.
        /// Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to
        /// be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p>
        /// <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        pub fn min_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.min_size(inp);
            self
        }
        /// <p>The minimum number of instances that App Runner provisions for your service. The service always has at least <code>MinSize</code> provisioned instances.
        /// Some of them actively serve traffic. The rest of them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to
        /// be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.</p>
        /// <p>App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same capacity for both old and new code.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        pub fn set_min_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_size(input);
            self
        }
        /// <p>The maximum number of instances that your service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p>
        /// <p>Default: <code>25</code>
        /// </p>
        pub fn max_size(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_size(inp);
            self
        }
        /// <p>The maximum number of instances that your service scales up to. At most <code>MaxSize</code> instances actively serve traffic for your service.</p>
        /// <p>Default: <code>25</code>
        /// </p>
        pub fn set_max_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_size(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Create an App Runner connection resource. App Runner requires a connection resource when you create App Runner services that access private repositories from
    /// certain third-party providers. You can share a connection across multiple services.</p>
    /// <p>A connection resource is needed to access GitHub repositories. GitHub requires a user interface approval process through the App Runner console before you
    /// can use the connection.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl<C, M, R> CreateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectionInputOperationOutputAlias,
                crate::output::CreateConnectionOutput,
                crate::error::CreateConnectionError,
                crate::input::CreateConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the new connection. It must be unique across all App Runner connections for the Amazon Web Services account in the Amazon Web Services Region.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>A name for the new connection. It must be unique across all App Runner connections for the Amazon Web Services account in the Amazon Web Services Region.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The source repository provider.</p>
        pub fn provider_type(mut self, inp: crate::model::ProviderType) -> Self {
            self.inner = self.inner.provider_type(inp);
            self
        }
        /// <p>The source repository provider.</p>
        pub fn set_provider_type(
            mut self,
            input: std::option::Option<crate::model::ProviderType>,
        ) -> Self {
            self.inner = self.inner.set_provider_type(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of metadata items that you can associate with your connection resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of metadata items that you can associate with your connection resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateService`.
    ///
    /// <p>Create an App Runner service. After the service is created, the action also automatically starts a deployment.</p>
    /// <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to track the operation's progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_service_input::Builder,
    }
    impl<C, M, R> CreateService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateServiceInputOperationOutputAlias,
                crate::output::CreateServiceOutput,
                crate::error::CreateServiceError,
                crate::input::CreateServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the new service. It must be unique across all the running App Runner services in your Amazon Web Services account in the Amazon Web Services Region.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>A name for the new service. It must be unique across all the running App Runner services in your Amazon Web Services account in the Amazon Web Services Region.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The source to deploy to the App Runner service. It can be a code or an image repository.</p>
        pub fn source_configuration(mut self, inp: crate::model::SourceConfiguration) -> Self {
            self.inner = self.inner.source_configuration(inp);
            self
        }
        /// <p>The source to deploy to the App Runner service. It can be a code or an image repository.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_source_configuration(input);
            self
        }
        /// <p>The runtime configuration of instances (scaling units) of the App Runner service.</p>
        pub fn instance_configuration(mut self, inp: crate::model::InstanceConfiguration) -> Self {
            self.inner = self.inner.instance_configuration(inp);
            self
        }
        /// <p>The runtime configuration of instances (scaling units) of the App Runner service.</p>
        pub fn set_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_instance_configuration(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional list of metadata items that you can associate with your service resource. A tag is a key-value pair.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An optional list of metadata items that you can associate with your service resource. A tag is a key-value pair.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default,
        /// App Runner uses an Amazon Web Services managed CMK.</p>
        pub fn encryption_configuration(
            mut self,
            inp: crate::model::EncryptionConfiguration,
        ) -> Self {
            self.inner = self.inner.encryption_configuration(inp);
            self
        }
        /// <p>An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default,
        /// App Runner uses an Amazon Web Services managed CMK.</p>
        pub fn set_encryption_configuration(
            mut self,
            input: std::option::Option<crate::model::EncryptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_encryption_configuration(input);
            self
        }
        /// <p>The settings for the health check that App Runner performs to monitor the health of your service.</p>
        pub fn health_check_configuration(
            mut self,
            inp: crate::model::HealthCheckConfiguration,
        ) -> Self {
            self.inner = self.inner.health_check_configuration(inp);
            self
        }
        /// <p>The settings for the health check that App Runner performs to monitor the health of your service.</p>
        pub fn set_health_check_configuration(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_health_check_configuration(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner
        /// associates the latest revision of a default auto scaling configuration.</p>
        pub fn auto_scaling_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_scaling_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner
        /// associates the latest revision of a default auto scaling configuration.</p>
        pub fn set_auto_scaling_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAutoScalingConfiguration`.
    ///
    /// <p>Delete an App Runner automatic scaling configuration resource. You can delete a specific revision or the latest active revision. You can't delete a
    /// configuration that's used by one or more App Runner services.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAutoScalingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_auto_scaling_configuration_input::Builder,
    }
    impl<C, M, R> DeleteAutoScalingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAutoScalingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAutoScalingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAutoScalingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAutoScalingConfigurationInputOperationOutputAlias,
                crate::output::DeleteAutoScalingConfigurationOutput,
                crate::error::DeleteAutoScalingConfigurationError,
                crate::input::DeleteAutoScalingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to delete.</p>
        /// <p>The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either <code>.../<i>name</i>
        /// </code> or
        /// <code>.../<i>name</i>/<i>revision</i>
        /// </code>. If a revision isn't specified, the latest active revision is deleted.</p>
        pub fn auto_scaling_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_scaling_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want to delete.</p>
        /// <p>The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either <code>.../<i>name</i>
        /// </code> or
        /// <code>.../<i>name</i>/<i>revision</i>
        /// </code>. If a revision isn't specified, the latest active revision is deleted.</p>
        pub fn set_auto_scaling_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Delete an App Runner connection. You must first ensure that there are no running App Runner services that use this connection. If there are any, the
    /// <code>DeleteConnection</code> action fails.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl<C, M, R> DeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionInputOperationOutputAlias,
                crate::output::DeleteConnectionOutput,
                crate::error::DeleteConnectionError,
                crate::input::DeleteConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner connection that you want to delete.</p>
        pub fn connection_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner connection that you want to delete.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteService`.
    ///
    /// <p>Delete an App Runner service.</p>
    /// <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a>
    /// call to track the operation's progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_service_input::Builder,
    }
    impl<C, M, R> DeleteService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteServiceInputOperationOutputAlias,
                crate::output::DeleteServiceOutput,
                crate::error::DeleteServiceError,
                crate::input::DeleteServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to delete.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to delete.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAutoScalingConfiguration`.
    ///
    /// <p>Return a full description of an App Runner automatic scaling configuration resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAutoScalingConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_auto_scaling_configuration_input::Builder,
    }
    impl<C, M, R> DescribeAutoScalingConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAutoScalingConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAutoScalingConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAutoScalingConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAutoScalingConfigurationInputOperationOutputAlias,
                crate::output::DescribeAutoScalingConfigurationOutput,
                crate::error::DescribeAutoScalingConfigurationError,
                crate::input::DescribeAutoScalingConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want a description for.</p>
        /// <p>The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either <code>.../<i>name</i>
        /// </code> or
        /// <code>.../<i>name</i>/<i>revision</i>
        /// </code>. If a revision isn't specified, the latest active revision is
        /// described.</p>
        pub fn auto_scaling_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_scaling_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner auto scaling configuration that you want a description for.</p>
        /// <p>The ARN can be a full auto scaling configuration ARN, or a partial ARN ending with either <code>.../<i>name</i>
        /// </code> or
        /// <code>.../<i>name</i>/<i>revision</i>
        /// </code>. If a revision isn't specified, the latest active revision is
        /// described.</p>
        pub fn set_auto_scaling_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCustomDomains`.
    ///
    /// <p>Return a description of custom domain names that are associated with an App Runner service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCustomDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_custom_domains_input::Builder,
    }
    impl<C, M, R> DescribeCustomDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCustomDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCustomDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCustomDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCustomDomainsInputOperationOutputAlias,
                crate::output::DescribeCustomDomainsOutput,
                crate::error::DescribeCustomDomainsError,
                crate::input::DescribeCustomDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want associated custom domain names to be described for.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want associated custom domain names to be described for.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
        /// <p>A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones that are specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones that are specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that each response (result page) can include. It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that each response (result page) can include. It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeService`.
    ///
    /// <p>Return a full description of an App Runner service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_service_input::Builder,
    }
    impl<C, M, R> DescribeService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeServiceInputOperationOutputAlias,
                crate::output::DescribeServiceOutput,
                crate::error::DescribeServiceError,
                crate::input::DescribeServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want a description for.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want a description for.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateCustomDomain`.
    ///
    /// <p>Disassociate a custom domain name from an App Runner service.</p>
    /// <p>Certificates tracking domain validity are associated with a custom domain and are stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide">AWS
    /// Certificate Manager (ACM)</a>. These certificates aren't deleted as part of this action. App Runner delays certificate deletion for
    /// 30 days after a domain is disassociated from your service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateCustomDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_custom_domain_input::Builder,
    }
    impl<C, M, R> DisassociateCustomDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateCustomDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateCustomDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateCustomDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateCustomDomainInputOperationOutputAlias,
                crate::output::DisassociateCustomDomainOutput,
                crate::error::DisassociateCustomDomainError,
                crate::input::DisassociateCustomDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to disassociate a custom domain name from.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to disassociate a custom domain name from.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
        /// <p>The domain name that you want to disassociate from the App Runner service.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name that you want to disassociate from the App Runner service.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAutoScalingConfigurations`.
    ///
    /// <p>Returns a list of App Runner automatic scaling configurations in your Amazon Web Services account. You can query the revisions for a specific configuration name or
    /// the revisions for all configurations in your account. You can optionally query only the latest revision of each requested name.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAutoScalingConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_auto_scaling_configurations_input::Builder,
    }
    impl<C, M, R> ListAutoScalingConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAutoScalingConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAutoScalingConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAutoScalingConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAutoScalingConfigurationsInputOperationOutputAlias,
                crate::output::ListAutoScalingConfigurationsOutput,
                crate::error::ListAutoScalingConfigurationsError,
                crate::input::ListAutoScalingConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the App Runner auto scaling configuration that you want to list. If specified, App Runner lists revisions that share this name. If not specified, App Runner
        /// returns revisions of all configurations.</p>
        pub fn auto_scaling_configuration_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_scaling_configuration_name(inp);
            self
        }
        /// <p>The name of the App Runner auto scaling configuration that you want to list. If specified, App Runner lists revisions that share this name. If not specified, App Runner
        /// returns revisions of all configurations.</p>
        pub fn set_auto_scaling_configuration_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_configuration_name(input);
            self
        }
        /// <p>Set to <code>true</code> to list only the latest revision for each requested configuration name.</p>
        /// <p>Keep as <code>false</code> to list all revisions for each requested configuration name.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn latest_only(mut self, inp: bool) -> Self {
            self.inner = self.inner.latest_only(inp);
            self
        }
        /// <p>Set to <code>true</code> to list only the latest revision for each requested configuration name.</p>
        /// <p>Keep as <code>false</code> to list all revisions for each requested configuration name.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_latest_only(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_latest_only(input);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones that are specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones that are specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnections`.
    ///
    /// <p>Returns a list of App Runner connections that are associated with your Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connections_input::Builder,
    }
    impl<C, M, R> ListConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectionsInputOperationOutputAlias,
                crate::output::ListConnectionsOutput,
                crate::error::ListConnectionsError,
                crate::input::ListConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>If specified, only this connection is returned. If not specified, the result isn't filtered by name.</p>
        pub fn connection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_name(inp);
            self
        }
        /// <p>If specified, only this connection is returned. If not specified, the result isn't filtered by name.</p>
        pub fn set_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_name(input);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). Used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). Used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOperations`.
    ///
    /// <p>Return a list of operations that occurred on an App Runner service.</p>
    /// <p>The resulting list of <a>OperationSummary</a> objects is sorted in reverse chronological order. The first object on the list represents the
    /// last started operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_operations_input::Builder,
    }
    impl<C, M, R> ListOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOperationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOperationsInputOperationOutputAlias,
                crate::output::ListOperationsOutput,
                crate::error::ListOperationsError,
                crate::input::ListOperationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want a list of operations for.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want a list of operations for.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
        /// <p>A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token from a previous result page. It's used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListServices`.
    ///
    /// <p>Returns a list of running App Runner services in your Amazon Web Services account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListServices<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_services_input::Builder,
    }
    impl<C, M, R> ListServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListServicesInputOperationOutputAlias,
                crate::output::ListServicesOutput,
                crate::error::ListServicesError,
                crate::input::ListServicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>A token from a previous result page. Used for a paginated request. The request retrieves the next result page. All other parameter values must be
        /// identical to the ones specified in the initial request.</p>
        /// <p>If you don't specify <code>NextToken</code>, the request retrieves the first result page.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to include in each response (result page). It's used for a paginated request.</p>
        /// <p>If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List tags that are associated with for an App Runner resource. The response contains a list of tag key-value pairs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that a tag list is requested for.</p>
        /// <p>It must be the ARN of an App Runner resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that a tag list is requested for.</p>
        /// <p>It must be the ARN of an App Runner resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PauseService`.
    ///
    /// <p>Pause an active App Runner service. App Runner reduces compute capacity for the service to zero and loses state (for example, ephemeral storage is
    /// removed).</p>
    /// <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a>
    /// call to track the operation's progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct PauseService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::pause_service_input::Builder,
    }
    impl<C, M, R> PauseService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PauseService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PauseServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::PauseServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PauseServiceInputOperationOutputAlias,
                crate::output::PauseServiceOutput,
                crate::error::PauseServiceError,
                crate::input::PauseServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to pause.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to pause.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResumeService`.
    ///
    /// <p>Resume an active App Runner service. App Runner provisions compute capacity for the service.</p>
    /// <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a>
    /// call to track the operation's progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResumeService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resume_service_input::Builder,
    }
    impl<C, M, R> ResumeService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResumeService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResumeServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::ResumeServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResumeServiceInputOperationOutputAlias,
                crate::output::ResumeServiceOutput,
                crate::error::ResumeServiceError,
                crate::input::ResumeServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to resume.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to resume.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartDeployment`.
    ///
    /// <p>Initiate a manual deployment of the latest commit in a source code repository or the latest image in a source image repository to an App Runner
    /// service.</p>
    /// <p>For a source code repository, App Runner retrieves the commit and builds a Docker image. For a source image repository, App Runner retrieves the latest Docker
    /// image. In both cases, App Runner then deploys the new image to your service and starts a new container instance.</p>
    /// <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a>
    /// call to track the operation's progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_deployment_input::Builder,
    }
    impl<C, M, R> StartDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartDeploymentInputOperationOutputAlias,
                crate::output::StartDeploymentOutput,
                crate::error::StartDeploymentError,
                crate::input::StartDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to manually deploy to.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to manually deploy to.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Add tags to, or update the tag values of, an App Runner resource. A tag is a key-value pair.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to update tags for.</p>
        /// <p>It must be the ARN of an App Runner resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to update tags for.</p>
        /// <p>It must be the ARN of an App Runner resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key-value pairs to add or update. If a key is new to the resource, the tag is added with the provided value. If a key is already
        /// associated with the resource, the value of the tag is updated.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag key-value pairs to add or update. If a key is new to the resource, the tag is added with the provided value. If a key is already
        /// associated with the resource, the value of the tag is updated.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Remove tags from an App Runner resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        /// <p>It must be the ARN of an App Runner resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        /// <p>It must be the ARN of an App Runner resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of tag keys that you want to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of tag keys that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateService`.
    ///
    /// <p>Update an App Runner service. You can update the source configuration and instance configuration of the service. You can also update the ARN of the auto
    /// scaling configuration resource that's associated with the service. However, you can't change the name or the encryption configuration of the service.
    /// These can be set only when you create the service.</p>
    /// <p>To update the tags applied to your service, use the separate actions <a>TagResource</a> and <a>UntagResource</a>.</p>
    /// <p>This is an asynchronous operation. On a successful call, you can use the returned <code>OperationId</code> and the <a>ListOperations</a>
    /// call to track the operation's progress.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateService<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_input::Builder,
    }
    impl<C, M, R> UpdateService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceInputOperationOutputAlias,
                crate::output::UpdateServiceOutput,
                crate::error::UpdateServiceError,
                crate::input::UpdateServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to update.</p>
        pub fn service_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the App Runner service that you want to update.</p>
        pub fn set_service_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_arn(input);
            self
        }
        /// <p>The source configuration to apply to the App Runner service.</p>
        /// <p>You can change the configuration of the code or image repository that the service uses. However, you can't switch from code to image or the other way
        /// around. This means that you must provide the same structure member of <code>SourceConfiguration</code> that you originally included when you created the
        /// service. Specifically, you can include either <code>CodeRepository</code> or <code>ImageRepository</code>. To update the source configuration, set the
        /// values to members of the structure that you include.</p>
        pub fn source_configuration(mut self, inp: crate::model::SourceConfiguration) -> Self {
            self.inner = self.inner.source_configuration(inp);
            self
        }
        /// <p>The source configuration to apply to the App Runner service.</p>
        /// <p>You can change the configuration of the code or image repository that the service uses. However, you can't switch from code to image or the other way
        /// around. This means that you must provide the same structure member of <code>SourceConfiguration</code> that you originally included when you created the
        /// service. Specifically, you can include either <code>CodeRepository</code> or <code>ImageRepository</code>. To update the source configuration, set the
        /// values to members of the structure that you include.</p>
        pub fn set_source_configuration(
            mut self,
            input: std::option::Option<crate::model::SourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_source_configuration(input);
            self
        }
        /// <p>The runtime configuration to apply to instances (scaling units) of the App Runner service.</p>
        pub fn instance_configuration(mut self, inp: crate::model::InstanceConfiguration) -> Self {
            self.inner = self.inner.instance_configuration(inp);
            self
        }
        /// <p>The runtime configuration to apply to instances (scaling units) of the App Runner service.</p>
        pub fn set_instance_configuration(
            mut self,
            input: std::option::Option<crate::model::InstanceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_instance_configuration(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.</p>
        pub fn auto_scaling_configuration_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.auto_scaling_configuration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to associate with your service.</p>
        pub fn set_auto_scaling_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_auto_scaling_configuration_arn(input);
            self
        }
        /// <p>The settings for the health check that App Runner performs to monitor the health of your service.</p>
        pub fn health_check_configuration(
            mut self,
            inp: crate::model::HealthCheckConfiguration,
        ) -> Self {
            self.inner = self.inner.health_check_configuration(inp);
            self
        }
        /// <p>The settings for the health check that App Runner performs to monitor the health of your service.</p>
        pub fn set_health_check_configuration(
            mut self,
            input: std::option::Option<crate::model::HealthCheckConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_health_check_configuration(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
