// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS App Mesh
///
/// Client for invoking operations on AWS App Mesh. Each operation on AWS App Mesh is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_appmesh::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_appmesh::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_appmesh::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateGatewayRoute`](crate::client::fluent_builders::CreateGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_route_name(impl Into<String>)`](crate::client::fluent_builders::CreateGatewayRoute::gateway_route_name) / [`set_gateway_route_name(Option<String>)`](crate::client::fluent_builders::CreateGatewayRoute::set_gateway_route_name): <p>The name to use for the gateway route.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::CreateGatewayRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::CreateGatewayRoute::set_mesh_name): <p>The name of the service mesh to create the gateway route in.</p>
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::CreateGatewayRoute::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::CreateGatewayRoute::set_virtual_gateway_name): <p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>
    ///   - [`spec(GatewayRouteSpec)`](crate::client::fluent_builders::CreateGatewayRoute::spec) / [`set_spec(Option<GatewayRouteSpec>)`](crate::client::fluent_builders::CreateGatewayRoute::set_spec): <p>The gateway route specification to apply.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::CreateGatewayRoute::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::CreateGatewayRoute::set_tags): <p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateGatewayRoute::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateGatewayRoute::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::CreateGatewayRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::CreateGatewayRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`CreateGatewayRouteOutput`](crate::output::CreateGatewayRouteOutput) with field(s):
    ///   - [`gateway_route(Option<GatewayRouteData>)`](crate::output::CreateGatewayRouteOutput::gateway_route): <p>The full description of your gateway route following the create call.</p>
    /// - On failure, responds with [`SdkError<CreateGatewayRouteError>`](crate::error::CreateGatewayRouteError)
    pub fn create_gateway_route(&self) -> fluent_builders::CreateGatewayRoute {
        fluent_builders::CreateGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMesh`](crate::client::fluent_builders::CreateMesh) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::CreateMesh::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::CreateMesh::set_mesh_name): <p>The name to use for the service mesh.</p>
    ///   - [`spec(MeshSpec)`](crate::client::fluent_builders::CreateMesh::spec) / [`set_spec(Option<MeshSpec>)`](crate::client::fluent_builders::CreateMesh::set_spec): <p>The service mesh specification to apply.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::CreateMesh::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::CreateMesh::set_tags): <p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateMesh::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateMesh::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    /// - On success, responds with [`CreateMeshOutput`](crate::output::CreateMeshOutput) with field(s):
    ///   - [`mesh(Option<MeshData>)`](crate::output::CreateMeshOutput::mesh): <p>The full description of your service mesh following the create call.</p>
    /// - On failure, responds with [`SdkError<CreateMeshError>`](crate::error::CreateMeshError)
    pub fn create_mesh(&self) -> fluent_builders::CreateMesh {
        fluent_builders::CreateMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoute`](crate::client::fluent_builders::CreateRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`route_name(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::route_name) / [`set_route_name(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_route_name): <p>The name to use for the route.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_mesh_name): <p>The name of the service mesh to create the route in.</p>
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_virtual_router_name): <p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>
    ///   - [`spec(RouteSpec)`](crate::client::fluent_builders::CreateRoute::spec) / [`set_spec(Option<RouteSpec>)`](crate::client::fluent_builders::CreateRoute::set_spec): <p>The route specification to apply.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::CreateRoute::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::CreateRoute::set_tags): <p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::CreateRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::CreateRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`CreateRouteOutput`](crate::output::CreateRouteOutput) with field(s):
    ///   - [`route(Option<RouteData>)`](crate::output::CreateRouteOutput::route): <p>The full description of your mesh following the create call.</p>
    /// - On failure, responds with [`SdkError<CreateRouteError>`](crate::error::CreateRouteError)
    pub fn create_route(&self) -> fluent_builders::CreateRoute {
        fluent_builders::CreateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVirtualGateway`](crate::client::fluent_builders::CreateVirtualGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualGateway::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualGateway::set_virtual_gateway_name): <p>The name to use for the virtual gateway.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualGateway::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualGateway::set_mesh_name): <p>The name of the service mesh to create the virtual gateway in.</p>
    ///   - [`spec(VirtualGatewaySpec)`](crate::client::fluent_builders::CreateVirtualGateway::spec) / [`set_spec(Option<VirtualGatewaySpec>)`](crate::client::fluent_builders::CreateVirtualGateway::set_spec): <p>The virtual gateway specification to apply.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::CreateVirtualGateway::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::CreateVirtualGateway::set_tags): <p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualGateway::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVirtualGateway::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualGateway::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::CreateVirtualGateway::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`CreateVirtualGatewayOutput`](crate::output::CreateVirtualGatewayOutput) with field(s):
    ///   - [`virtual_gateway(Option<VirtualGatewayData>)`](crate::output::CreateVirtualGatewayOutput::virtual_gateway): <p>The full description of your virtual gateway following the create call.</p>
    /// - On failure, responds with [`SdkError<CreateVirtualGatewayError>`](crate::error::CreateVirtualGatewayError)
    pub fn create_virtual_gateway(&self) -> fluent_builders::CreateVirtualGateway {
        fluent_builders::CreateVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVirtualNode`](crate::client::fluent_builders::CreateVirtualNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_node_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualNode::virtual_node_name) / [`set_virtual_node_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualNode::set_virtual_node_name): <p>The name to use for the virtual node.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualNode::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualNode::set_mesh_name): <p>The name of the service mesh to create the virtual node in.</p>
    ///   - [`spec(VirtualNodeSpec)`](crate::client::fluent_builders::CreateVirtualNode::spec) / [`set_spec(Option<VirtualNodeSpec>)`](crate::client::fluent_builders::CreateVirtualNode::set_spec): <p>The virtual node specification to apply.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::CreateVirtualNode::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::CreateVirtualNode::set_tags): <p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualNode::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVirtualNode::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualNode::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::CreateVirtualNode::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`CreateVirtualNodeOutput`](crate::output::CreateVirtualNodeOutput) with field(s):
    ///   - [`virtual_node(Option<VirtualNodeData>)`](crate::output::CreateVirtualNodeOutput::virtual_node): <p>The full description of your virtual node following the create call.</p>
    /// - On failure, responds with [`SdkError<CreateVirtualNodeError>`](crate::error::CreateVirtualNodeError)
    pub fn create_virtual_node(&self) -> fluent_builders::CreateVirtualNode {
        fluent_builders::CreateVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVirtualRouter`](crate::client::fluent_builders::CreateVirtualRouter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualRouter::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualRouter::set_virtual_router_name): <p>The name to use for the virtual router.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualRouter::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualRouter::set_mesh_name): <p>The name of the service mesh to create the virtual router in.</p>
    ///   - [`spec(VirtualRouterSpec)`](crate::client::fluent_builders::CreateVirtualRouter::spec) / [`set_spec(Option<VirtualRouterSpec>)`](crate::client::fluent_builders::CreateVirtualRouter::set_spec): <p>The virtual router specification to apply.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::CreateVirtualRouter::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::CreateVirtualRouter::set_tags): <p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualRouter::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVirtualRouter::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualRouter::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::CreateVirtualRouter::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`CreateVirtualRouterOutput`](crate::output::CreateVirtualRouterOutput) with field(s):
    ///   - [`virtual_router(Option<VirtualRouterData>)`](crate::output::CreateVirtualRouterOutput::virtual_router): <p>The full description of your virtual router following the create call.</p>
    /// - On failure, responds with [`SdkError<CreateVirtualRouterError>`](crate::error::CreateVirtualRouterError)
    pub fn create_virtual_router(&self) -> fluent_builders::CreateVirtualRouter {
        fluent_builders::CreateVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVirtualService`](crate::client::fluent_builders::CreateVirtualService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_service_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualService::virtual_service_name) / [`set_virtual_service_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualService::set_virtual_service_name): <p>The name to use for the virtual service.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualService::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::CreateVirtualService::set_mesh_name): <p>The name of the service mesh to create the virtual service in.</p>
    ///   - [`spec(VirtualServiceSpec)`](crate::client::fluent_builders::CreateVirtualService::spec) / [`set_spec(Option<VirtualServiceSpec>)`](crate::client::fluent_builders::CreateVirtualService::set_spec): <p>The virtual service specification to apply.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::CreateVirtualService::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::CreateVirtualService::set_tags): <p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualService::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVirtualService::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::CreateVirtualService::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::CreateVirtualService::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`CreateVirtualServiceOutput`](crate::output::CreateVirtualServiceOutput) with field(s):
    ///   - [`virtual_service(Option<VirtualServiceData>)`](crate::output::CreateVirtualServiceOutput::virtual_service): <p>The full description of your virtual service following the create call.</p>
    /// - On failure, responds with [`SdkError<CreateVirtualServiceError>`](crate::error::CreateVirtualServiceError)
    pub fn create_virtual_service(&self) -> fluent_builders::CreateVirtualService {
        fluent_builders::CreateVirtualService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGatewayRoute`](crate::client::fluent_builders::DeleteGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_route_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::gateway_route_name) / [`set_gateway_route_name(Option<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::set_gateway_route_name): <p>The name of the gateway route to delete.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::set_mesh_name): <p>The name of the service mesh to delete the gateway route from.</p>
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::set_virtual_gateway_name): <p>The name of the virtual gateway to delete the route from.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DeleteGatewayRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DeleteGatewayRouteOutput`](crate::output::DeleteGatewayRouteOutput) with field(s):
    ///   - [`gateway_route(Option<GatewayRouteData>)`](crate::output::DeleteGatewayRouteOutput::gateway_route): <p>The gateway route that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteGatewayRouteError>`](crate::error::DeleteGatewayRouteError)
    pub fn delete_gateway_route(&self) -> fluent_builders::DeleteGatewayRoute {
        fluent_builders::DeleteGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMesh`](crate::client::fluent_builders::DeleteMesh) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DeleteMesh::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DeleteMesh::set_mesh_name): <p>The name of the service mesh to delete.</p>
    /// - On success, responds with [`DeleteMeshOutput`](crate::output::DeleteMeshOutput) with field(s):
    ///   - [`mesh(Option<MeshData>)`](crate::output::DeleteMeshOutput::mesh): <p>The service mesh that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteMeshError>`](crate::error::DeleteMeshError)
    pub fn delete_mesh(&self) -> fluent_builders::DeleteMesh {
        fluent_builders::DeleteMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRoute`](crate::client::fluent_builders::DeleteRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`route_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::route_name) / [`set_route_name(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_route_name): <p>The name of the route to delete.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_mesh_name): <p>The name of the service mesh to delete the route in.</p>
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_virtual_router_name): <p>The name of the virtual router to delete the route in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DeleteRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DeleteRouteOutput`](crate::output::DeleteRouteOutput) with field(s):
    ///   - [`route(Option<RouteData>)`](crate::output::DeleteRouteOutput::route): <p>The route that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteRouteError>`](crate::error::DeleteRouteError)
    pub fn delete_route(&self) -> fluent_builders::DeleteRoute {
        fluent_builders::DeleteRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVirtualGateway`](crate::client::fluent_builders::DeleteVirtualGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualGateway::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualGateway::set_virtual_gateway_name): <p>The name of the virtual gateway to delete.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualGateway::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualGateway::set_mesh_name): <p>The name of the service mesh to delete the virtual gateway from.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualGateway::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DeleteVirtualGateway::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DeleteVirtualGatewayOutput`](crate::output::DeleteVirtualGatewayOutput) with field(s):
    ///   - [`virtual_gateway(Option<VirtualGatewayData>)`](crate::output::DeleteVirtualGatewayOutput::virtual_gateway): <p>The virtual gateway that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteVirtualGatewayError>`](crate::error::DeleteVirtualGatewayError)
    pub fn delete_virtual_gateway(&self) -> fluent_builders::DeleteVirtualGateway {
        fluent_builders::DeleteVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVirtualNode`](crate::client::fluent_builders::DeleteVirtualNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_node_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualNode::virtual_node_name) / [`set_virtual_node_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualNode::set_virtual_node_name): <p>The name of the virtual node to delete.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualNode::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualNode::set_mesh_name): <p>The name of the service mesh to delete the virtual node in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualNode::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DeleteVirtualNode::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DeleteVirtualNodeOutput`](crate::output::DeleteVirtualNodeOutput) with field(s):
    ///   - [`virtual_node(Option<VirtualNodeData>)`](crate::output::DeleteVirtualNodeOutput::virtual_node): <p>The virtual node that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteVirtualNodeError>`](crate::error::DeleteVirtualNodeError)
    pub fn delete_virtual_node(&self) -> fluent_builders::DeleteVirtualNode {
        fluent_builders::DeleteVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVirtualRouter`](crate::client::fluent_builders::DeleteVirtualRouter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualRouter::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualRouter::set_virtual_router_name): <p>The name of the virtual router to delete.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualRouter::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualRouter::set_mesh_name): <p>The name of the service mesh to delete the virtual router in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualRouter::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DeleteVirtualRouter::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DeleteVirtualRouterOutput`](crate::output::DeleteVirtualRouterOutput) with field(s):
    ///   - [`virtual_router(Option<VirtualRouterData>)`](crate::output::DeleteVirtualRouterOutput::virtual_router): <p>The virtual router that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteVirtualRouterError>`](crate::error::DeleteVirtualRouterError)
    pub fn delete_virtual_router(&self) -> fluent_builders::DeleteVirtualRouter {
        fluent_builders::DeleteVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVirtualService`](crate::client::fluent_builders::DeleteVirtualService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_service_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualService::virtual_service_name) / [`set_virtual_service_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualService::set_virtual_service_name): <p>The name of the virtual service to delete.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualService::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DeleteVirtualService::set_mesh_name): <p>The name of the service mesh to delete the virtual service in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteVirtualService::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DeleteVirtualService::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DeleteVirtualServiceOutput`](crate::output::DeleteVirtualServiceOutput) with field(s):
    ///   - [`virtual_service(Option<VirtualServiceData>)`](crate::output::DeleteVirtualServiceOutput::virtual_service): <p>The virtual service that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteVirtualServiceError>`](crate::error::DeleteVirtualServiceError)
    pub fn delete_virtual_service(&self) -> fluent_builders::DeleteVirtualService {
        fluent_builders::DeleteVirtualService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGatewayRoute`](crate::client::fluent_builders::DescribeGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_route_name(impl Into<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::gateway_route_name) / [`set_gateway_route_name(Option<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::set_gateway_route_name): <p>The name of the gateway route to describe.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::set_mesh_name): <p>The name of the service mesh that the gateway route resides in.</p>
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::set_virtual_gateway_name): <p>The name of the virtual gateway that the gateway route is associated with.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DescribeGatewayRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DescribeGatewayRouteOutput`](crate::output::DescribeGatewayRouteOutput) with field(s):
    ///   - [`gateway_route(Option<GatewayRouteData>)`](crate::output::DescribeGatewayRouteOutput::gateway_route): <p>The full description of your gateway route.</p>
    /// - On failure, responds with [`SdkError<DescribeGatewayRouteError>`](crate::error::DescribeGatewayRouteError)
    pub fn describe_gateway_route(&self) -> fluent_builders::DescribeGatewayRoute {
        fluent_builders::DescribeGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMesh`](crate::client::fluent_builders::DescribeMesh) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DescribeMesh::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DescribeMesh::set_mesh_name): <p>The name of the service mesh to describe.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeMesh::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DescribeMesh::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DescribeMeshOutput`](crate::output::DescribeMeshOutput) with field(s):
    ///   - [`mesh(Option<MeshData>)`](crate::output::DescribeMeshOutput::mesh): <p>The full description of your service mesh.</p>
    /// - On failure, responds with [`SdkError<DescribeMeshError>`](crate::error::DescribeMeshError)
    pub fn describe_mesh(&self) -> fluent_builders::DescribeMesh {
        fluent_builders::DescribeMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRoute`](crate::client::fluent_builders::DescribeRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`route_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRoute::route_name) / [`set_route_name(Option<String>)`](crate::client::fluent_builders::DescribeRoute::set_route_name): <p>The name of the route to describe.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DescribeRoute::set_mesh_name): <p>The name of the service mesh that the route resides in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DescribeRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRoute::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::DescribeRoute::set_virtual_router_name): <p>The name of the virtual router that the route is associated with.</p>
    /// - On success, responds with [`DescribeRouteOutput`](crate::output::DescribeRouteOutput) with field(s):
    ///   - [`route(Option<RouteData>)`](crate::output::DescribeRouteOutput::route): <p>The full description of your route.</p>
    /// - On failure, responds with [`SdkError<DescribeRouteError>`](crate::error::DescribeRouteError)
    pub fn describe_route(&self) -> fluent_builders::DescribeRoute {
        fluent_builders::DescribeRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVirtualGateway`](crate::client::fluent_builders::DescribeVirtualGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualGateway::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualGateway::set_virtual_gateway_name): <p>The name of the virtual gateway to describe.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualGateway::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualGateway::set_mesh_name): <p>The name of the service mesh that the gateway route resides in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualGateway::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DescribeVirtualGateway::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DescribeVirtualGatewayOutput`](crate::output::DescribeVirtualGatewayOutput) with field(s):
    ///   - [`virtual_gateway(Option<VirtualGatewayData>)`](crate::output::DescribeVirtualGatewayOutput::virtual_gateway): <p>The full description of your virtual gateway.</p>
    /// - On failure, responds with [`SdkError<DescribeVirtualGatewayError>`](crate::error::DescribeVirtualGatewayError)
    pub fn describe_virtual_gateway(&self) -> fluent_builders::DescribeVirtualGateway {
        fluent_builders::DescribeVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVirtualNode`](crate::client::fluent_builders::DescribeVirtualNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_node_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualNode::virtual_node_name) / [`set_virtual_node_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualNode::set_virtual_node_name): <p>The name of the virtual node to describe.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualNode::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualNode::set_mesh_name): <p>The name of the service mesh that the virtual node resides in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualNode::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DescribeVirtualNode::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DescribeVirtualNodeOutput`](crate::output::DescribeVirtualNodeOutput) with field(s):
    ///   - [`virtual_node(Option<VirtualNodeData>)`](crate::output::DescribeVirtualNodeOutput::virtual_node): <p>The full description of your virtual node.</p>
    /// - On failure, responds with [`SdkError<DescribeVirtualNodeError>`](crate::error::DescribeVirtualNodeError)
    pub fn describe_virtual_node(&self) -> fluent_builders::DescribeVirtualNode {
        fluent_builders::DescribeVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVirtualRouter`](crate::client::fluent_builders::DescribeVirtualRouter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualRouter::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualRouter::set_virtual_router_name): <p>The name of the virtual router to describe.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualRouter::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualRouter::set_mesh_name): <p>The name of the service mesh that the virtual router resides in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualRouter::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DescribeVirtualRouter::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DescribeVirtualRouterOutput`](crate::output::DescribeVirtualRouterOutput) with field(s):
    ///   - [`virtual_router(Option<VirtualRouterData>)`](crate::output::DescribeVirtualRouterOutput::virtual_router): <p>The full description of your virtual router.</p>
    /// - On failure, responds with [`SdkError<DescribeVirtualRouterError>`](crate::error::DescribeVirtualRouterError)
    pub fn describe_virtual_router(&self) -> fluent_builders::DescribeVirtualRouter {
        fluent_builders::DescribeVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVirtualService`](crate::client::fluent_builders::DescribeVirtualService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_service_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualService::virtual_service_name) / [`set_virtual_service_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualService::set_virtual_service_name): <p>The name of the virtual service to describe.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualService::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::DescribeVirtualService::set_mesh_name): <p>The name of the service mesh that the virtual service resides in.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeVirtualService::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::DescribeVirtualService::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`DescribeVirtualServiceOutput`](crate::output::DescribeVirtualServiceOutput) with field(s):
    ///   - [`virtual_service(Option<VirtualServiceData>)`](crate::output::DescribeVirtualServiceOutput::virtual_service): <p>The full description of your virtual service.</p>
    /// - On failure, responds with [`SdkError<DescribeVirtualServiceError>`](crate::error::DescribeVirtualServiceError)
    pub fn describe_virtual_service(&self) -> fluent_builders::DescribeVirtualService {
        fluent_builders::DescribeVirtualService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGatewayRoutes`](crate::client::fluent_builders::ListGatewayRoutes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGatewayRoutes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::ListGatewayRoutes::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::ListGatewayRoutes::set_mesh_name): <p>The name of the service mesh to list gateway routes in.</p>
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::ListGatewayRoutes::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::ListGatewayRoutes::set_virtual_gateway_name): <p>The name of the virtual gateway to list gateway routes in.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGatewayRoutes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGatewayRoutes::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListGatewayRoutes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListGatewayRoutes::set_limit): <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::ListGatewayRoutes::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::ListGatewayRoutes::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`ListGatewayRoutesOutput`](crate::output::ListGatewayRoutesOutput) with field(s):
    ///   - [`gateway_routes(Option<Vec<GatewayRouteRef>>)`](crate::output::ListGatewayRoutesOutput::gateway_routes): <p>The list of existing gateway routes for the specified service mesh and virtual gateway.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGatewayRoutesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListGatewayRoutes</code> request. When the results of a <code>ListGatewayRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListGatewayRoutesError>`](crate::error::ListGatewayRoutesError)
    pub fn list_gateway_routes(&self) -> fluent_builders::ListGatewayRoutes {
        fluent_builders::ListGatewayRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMeshes`](crate::client::fluent_builders::ListMeshes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMeshes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMeshes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMeshes::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>   <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>  </note>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListMeshes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListMeshes::set_limit): <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListMeshesOutput`](crate::output::ListMeshesOutput) with field(s):
    ///   - [`meshes(Option<Vec<MeshRef>>)`](crate::output::ListMeshesOutput::meshes): <p>The list of existing service meshes.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMeshesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListMeshes</code> request. When the results of a <code>ListMeshes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListMeshesError>`](crate::error::ListMeshesError)
    pub fn list_meshes(&self) -> fluent_builders::ListMeshes {
        fluent_builders::ListMeshes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRoutes`](crate::client::fluent_builders::ListRoutes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRoutes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::ListRoutes::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::ListRoutes::set_mesh_name): <p>The name of the service mesh to list routes in.</p>
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::ListRoutes::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::ListRoutes::set_virtual_router_name): <p>The name of the virtual router to list routes in.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRoutes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRoutes::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListRoutes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListRoutes::set_limit): <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::ListRoutes::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::ListRoutes::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`ListRoutesOutput`](crate::output::ListRoutesOutput) with field(s):
    ///   - [`routes(Option<Vec<RouteRef>>)`](crate::output::ListRoutesOutput::routes): <p>The list of existing routes for the specified service mesh and virtual router.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRoutesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListRoutes</code> request. When the results of a <code>ListRoutes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListRoutesError>`](crate::error::ListRoutesError)
    pub fn list_routes(&self) -> fluent_builders::ListRoutes {
        fluent_builders::ListRoutes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTagsForResource::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListTagsForResource::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListTagsForResource::set_limit): <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<TagRef>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags for the resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListTagsForResource</code> request. When the results of a <code>ListTagsForResource</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVirtualGateways`](crate::client::fluent_builders::ListVirtualGateways) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVirtualGateways::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::ListVirtualGateways::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::ListVirtualGateways::set_mesh_name): <p>The name of the service mesh to list virtual gateways in.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVirtualGateways::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVirtualGateways::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListVirtualGateways::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListVirtualGateways::set_limit): <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::ListVirtualGateways::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::ListVirtualGateways::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`ListVirtualGatewaysOutput`](crate::output::ListVirtualGatewaysOutput) with field(s):
    ///   - [`virtual_gateways(Option<Vec<VirtualGatewayRef>>)`](crate::output::ListVirtualGatewaysOutput::virtual_gateways): <p>The list of existing virtual gateways for the specified service mesh.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVirtualGatewaysOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListVirtualGateways</code> request. When the results of a <code>ListVirtualGateways</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListVirtualGatewaysError>`](crate::error::ListVirtualGatewaysError)
    pub fn list_virtual_gateways(&self) -> fluent_builders::ListVirtualGateways {
        fluent_builders::ListVirtualGateways::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVirtualNodes`](crate::client::fluent_builders::ListVirtualNodes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVirtualNodes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::ListVirtualNodes::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::ListVirtualNodes::set_mesh_name): <p>The name of the service mesh to list virtual nodes in.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVirtualNodes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVirtualNodes::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListVirtualNodes::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListVirtualNodes::set_limit): <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::ListVirtualNodes::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::ListVirtualNodes::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`ListVirtualNodesOutput`](crate::output::ListVirtualNodesOutput) with field(s):
    ///   - [`virtual_nodes(Option<Vec<VirtualNodeRef>>)`](crate::output::ListVirtualNodesOutput::virtual_nodes): <p>The list of existing virtual nodes for the specified service mesh.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVirtualNodesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code> request. When the results of a <code>ListVirtualNodes</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListVirtualNodesError>`](crate::error::ListVirtualNodesError)
    pub fn list_virtual_nodes(&self) -> fluent_builders::ListVirtualNodes {
        fluent_builders::ListVirtualNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVirtualRouters`](crate::client::fluent_builders::ListVirtualRouters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVirtualRouters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::ListVirtualRouters::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::ListVirtualRouters::set_mesh_name): <p>The name of the service mesh to list virtual routers in.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVirtualRouters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVirtualRouters::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListVirtualRouters::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListVirtualRouters::set_limit): <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::ListVirtualRouters::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::ListVirtualRouters::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`ListVirtualRoutersOutput`](crate::output::ListVirtualRoutersOutput) with field(s):
    ///   - [`virtual_routers(Option<Vec<VirtualRouterRef>>)`](crate::output::ListVirtualRoutersOutput::virtual_routers): <p>The list of existing virtual routers for the specified service mesh.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVirtualRoutersOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListVirtualRouters</code> request. When the results of a <code>ListVirtualRouters</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListVirtualRoutersError>`](crate::error::ListVirtualRoutersError)
    pub fn list_virtual_routers(&self) -> fluent_builders::ListVirtualRouters {
        fluent_builders::ListVirtualRouters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListVirtualServices`](crate::client::fluent_builders::ListVirtualServices) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListVirtualServices::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::ListVirtualServices::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::ListVirtualServices::set_mesh_name): <p>The name of the service mesh to list virtual services in.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListVirtualServices::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListVirtualServices::set_next_token): <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::ListVirtualServices::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::ListVirtualServices::set_limit): <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::ListVirtualServices::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::ListVirtualServices::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`ListVirtualServicesOutput`](crate::output::ListVirtualServicesOutput) with field(s):
    ///   - [`virtual_services(Option<Vec<VirtualServiceRef>>)`](crate::output::ListVirtualServicesOutput::virtual_services): <p>The list of existing virtual services for the specified service mesh.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListVirtualServicesOutput::next_token): <p>The <code>nextToken</code> value to include in a future <code>ListVirtualServices</code> request. When the results of a <code>ListVirtualServices</code> request exceed <code>limit</code>, you can use this value to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
    /// - On failure, responds with [`SdkError<ListVirtualServicesError>`](crate::error::ListVirtualServicesError)
    pub fn list_virtual_services(&self) -> fluent_builders::ListVirtualServices {
        fluent_builders::ListVirtualServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
    ///   - [`tags(Vec<TagRef>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<TagRef>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The keys of the tags to be removed.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGatewayRoute`](crate::client::fluent_builders::UpdateGatewayRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`gateway_route_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::gateway_route_name) / [`set_gateway_route_name(Option<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::set_gateway_route_name): <p>The name of the gateway route to update.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::set_mesh_name): <p>The name of the service mesh that the gateway route resides in.</p>
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::set_virtual_gateway_name): <p>The name of the virtual gateway that the gateway route is associated with.</p>
    ///   - [`spec(GatewayRouteSpec)`](crate::client::fluent_builders::UpdateGatewayRoute::spec) / [`set_spec(Option<GatewayRouteSpec>)`](crate::client::fluent_builders::UpdateGatewayRoute::set_spec): <p>The new gateway route specification to apply. This overwrites the existing data.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::UpdateGatewayRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`UpdateGatewayRouteOutput`](crate::output::UpdateGatewayRouteOutput) with field(s):
    ///   - [`gateway_route(Option<GatewayRouteData>)`](crate::output::UpdateGatewayRouteOutput::gateway_route): <p>A full description of the gateway route that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateGatewayRouteError>`](crate::error::UpdateGatewayRouteError)
    pub fn update_gateway_route(&self) -> fluent_builders::UpdateGatewayRoute {
        fluent_builders::UpdateGatewayRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMesh`](crate::client::fluent_builders::UpdateMesh) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::UpdateMesh::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::UpdateMesh::set_mesh_name): <p>The name of the service mesh to update.</p>
    ///   - [`spec(MeshSpec)`](crate::client::fluent_builders::UpdateMesh::spec) / [`set_spec(Option<MeshSpec>)`](crate::client::fluent_builders::UpdateMesh::set_spec): <p>The service mesh specification to apply.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateMesh::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateMesh::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    /// - On success, responds with [`UpdateMeshOutput`](crate::output::UpdateMeshOutput) with field(s):
    ///   - [`mesh(Option<MeshData>)`](crate::output::UpdateMeshOutput::mesh): <p>An object that represents a service mesh returned by a describe operation.</p>
    /// - On failure, responds with [`SdkError<UpdateMeshError>`](crate::error::UpdateMeshError)
    pub fn update_mesh(&self) -> fluent_builders::UpdateMesh {
        fluent_builders::UpdateMesh::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoute`](crate::client::fluent_builders::UpdateRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`route_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::route_name) / [`set_route_name(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_route_name): <p>The name of the route to update.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_mesh_name): <p>The name of the service mesh that the route resides in.</p>
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_virtual_router_name): <p>The name of the virtual router that the route is associated with.</p>
    ///   - [`spec(RouteSpec)`](crate::client::fluent_builders::UpdateRoute::spec) / [`set_spec(Option<RouteSpec>)`](crate::client::fluent_builders::UpdateRoute::set_spec): <p>The new route specification to apply. This overwrites the existing data.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateRoute::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::UpdateRoute::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`UpdateRouteOutput`](crate::output::UpdateRouteOutput) with field(s):
    ///   - [`route(Option<RouteData>)`](crate::output::UpdateRouteOutput::route): <p>A full description of the route that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateRouteError>`](crate::error::UpdateRouteError)
    pub fn update_route(&self) -> fluent_builders::UpdateRoute {
        fluent_builders::UpdateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVirtualGateway`](crate::client::fluent_builders::UpdateVirtualGateway) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_gateway_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::virtual_gateway_name) / [`set_virtual_gateway_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::set_virtual_gateway_name): <p>The name of the virtual gateway to update.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::set_mesh_name): <p>The name of the service mesh that the virtual gateway resides in.</p>
    ///   - [`spec(VirtualGatewaySpec)`](crate::client::fluent_builders::UpdateVirtualGateway::spec) / [`set_spec(Option<VirtualGatewaySpec>)`](crate::client::fluent_builders::UpdateVirtualGateway::set_spec): <p>The new virtual gateway specification to apply. This overwrites the existing data.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::UpdateVirtualGateway::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`UpdateVirtualGatewayOutput`](crate::output::UpdateVirtualGatewayOutput) with field(s):
    ///   - [`virtual_gateway(Option<VirtualGatewayData>)`](crate::output::UpdateVirtualGatewayOutput::virtual_gateway): <p>A full description of the virtual gateway that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateVirtualGatewayError>`](crate::error::UpdateVirtualGatewayError)
    pub fn update_virtual_gateway(&self) -> fluent_builders::UpdateVirtualGateway {
        fluent_builders::UpdateVirtualGateway::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVirtualNode`](crate::client::fluent_builders::UpdateVirtualNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_node_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualNode::virtual_node_name) / [`set_virtual_node_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualNode::set_virtual_node_name): <p>The name of the virtual node to update.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualNode::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualNode::set_mesh_name): <p>The name of the service mesh that the virtual node resides in.</p>
    ///   - [`spec(VirtualNodeSpec)`](crate::client::fluent_builders::UpdateVirtualNode::spec) / [`set_spec(Option<VirtualNodeSpec>)`](crate::client::fluent_builders::UpdateVirtualNode::set_spec): <p>The new virtual node specification to apply. This overwrites the existing data.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualNode::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateVirtualNode::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualNode::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::UpdateVirtualNode::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`UpdateVirtualNodeOutput`](crate::output::UpdateVirtualNodeOutput) with field(s):
    ///   - [`virtual_node(Option<VirtualNodeData>)`](crate::output::UpdateVirtualNodeOutput::virtual_node): <p>A full description of the virtual node that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateVirtualNodeError>`](crate::error::UpdateVirtualNodeError)
    pub fn update_virtual_node(&self) -> fluent_builders::UpdateVirtualNode {
        fluent_builders::UpdateVirtualNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVirtualRouter`](crate::client::fluent_builders::UpdateVirtualRouter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_router_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::virtual_router_name) / [`set_virtual_router_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::set_virtual_router_name): <p>The name of the virtual router to update.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::set_mesh_name): <p>The name of the service mesh that the virtual router resides in.</p>
    ///   - [`spec(VirtualRouterSpec)`](crate::client::fluent_builders::UpdateVirtualRouter::spec) / [`set_spec(Option<VirtualRouterSpec>)`](crate::client::fluent_builders::UpdateVirtualRouter::set_spec): <p>The new virtual router specification to apply. This overwrites the existing data.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::UpdateVirtualRouter::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`UpdateVirtualRouterOutput`](crate::output::UpdateVirtualRouterOutput) with field(s):
    ///   - [`virtual_router(Option<VirtualRouterData>)`](crate::output::UpdateVirtualRouterOutput::virtual_router): <p>A full description of the virtual router that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateVirtualRouterError>`](crate::error::UpdateVirtualRouterError)
    pub fn update_virtual_router(&self) -> fluent_builders::UpdateVirtualRouter {
        fluent_builders::UpdateVirtualRouter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateVirtualService`](crate::client::fluent_builders::UpdateVirtualService) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`virtual_service_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualService::virtual_service_name) / [`set_virtual_service_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualService::set_virtual_service_name): <p>The name of the virtual service to update.</p>
    ///   - [`mesh_name(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualService::mesh_name) / [`set_mesh_name(Option<String>)`](crate::client::fluent_builders::UpdateVirtualService::set_mesh_name): <p>The name of the service mesh that the virtual service resides in.</p>
    ///   - [`spec(VirtualServiceSpec)`](crate::client::fluent_builders::UpdateVirtualService::spec) / [`set_spec(Option<VirtualServiceSpec>)`](crate::client::fluent_builders::UpdateVirtualService::set_spec): <p>The new virtual service specification to apply. This overwrites the existing data.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualService::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateVirtualService::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    ///   - [`mesh_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateVirtualService::mesh_owner) / [`set_mesh_owner(Option<String>)`](crate::client::fluent_builders::UpdateVirtualService::set_mesh_owner): <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    /// - On success, responds with [`UpdateVirtualServiceOutput`](crate::output::UpdateVirtualServiceOutput) with field(s):
    ///   - [`virtual_service(Option<VirtualServiceData>)`](crate::output::UpdateVirtualServiceOutput::virtual_service): <p>A full description of the virtual service that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateVirtualServiceError>`](crate::error::UpdateVirtualServiceError)
    pub fn update_virtual_service(&self) -> fluent_builders::UpdateVirtualService {
        fluent_builders::UpdateVirtualService::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateGatewayRoute`.
    ///
    /// <p>Creates a gateway route.</p>
    /// <p>A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route matches a request, it can distribute traffic to a target virtual service.</p>
    /// <p>For more information about gateway routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGatewayRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_gateway_route_input::Builder,
    }
    impl CreateGatewayRoute {
        /// Creates a new `CreateGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGatewayRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the gateway route.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(input.into());
            self
        }
        /// <p>The name to use for the gateway route.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh to create the gateway route in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to create the gateway route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The gateway route specification to apply.</p>
        pub fn spec(mut self, input: crate::model::GatewayRouteSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The gateway route specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMesh`.
    ///
    /// <p>Creates a service mesh.</p>
    /// <p> A service mesh is a logical boundary for network traffic between services that are represented by resources within the mesh. After you create your service mesh, you can create virtual services, virtual nodes, virtual routers, and routes to distribute traffic between the applications in your mesh.</p>
    /// <p>For more information about service meshes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/meshes.html">Service meshes</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMesh {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_mesh_input::Builder,
    }
    impl CreateMesh {
        /// Creates a new `CreateMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMeshError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the service mesh.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name to use for the service mesh.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn spec(mut self, input: crate::model::MeshSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::MeshSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoute`.
    ///
    /// <p>Creates a route that is associated with a virtual router.</p>
    /// <p> You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or more virtual nodes.</p>
    /// <p>For more information about routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_route_input::Builder,
    }
    impl CreateRoute {
        /// Creates a new `CreateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the route.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(input.into());
            self
        }
        /// <p>The name to use for the route.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh to create the route in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to create the route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The route specification to apply.</p>
        pub fn spec(mut self, input: crate::model::RouteSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The route specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::RouteSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualGateway`.
    ///
    /// <p>Creates a virtual gateway.</p>
    /// <p>A virtual gateway allows resources outside your mesh to communicate to resources that are inside your mesh. The virtual gateway represents an Envoy proxy running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2 instance. Unlike a virtual node, which represents an Envoy running with an application, a virtual gateway represents Envoy deployed by itself.</p>
    /// <p>For more information about virtual gateways, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html">Virtual gateways</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVirtualGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_virtual_gateway_input::Builder,
    }
    impl CreateVirtualGateway {
        /// Creates a new `CreateVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual gateway.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name to use for the virtual gateway.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual gateway in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual gateway in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual gateway specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualGatewaySpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The virtual gateway specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewaySpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualNode`.
    ///
    /// <p>Creates a virtual node within a service mesh.</p>
    /// <p> A virtual node acts as a logical pointer to a particular task group, such as an Amazon ECS service or a Kubernetes deployment. When you create a virtual node, you can specify the service discovery information for your task group, and whether the proxy running in a task group will communicate with other proxies using Transport Layer Security (TLS).</p>
    /// <p>You define a <code>listener</code> for any inbound traffic that your virtual node expects. Any virtual service that your virtual node expects to communicate to is specified as a <code>backend</code>.</p>
    /// <p>The response metadata for your new virtual node contains the <code>arn</code> that is associated with the virtual node. Set this value to the full ARN; for example, <code>arn:aws:appmesh:us-west-2:123456789012:myMesh/default/virtualNode/myApp</code>) as the <code>APPMESH_RESOURCE_ARN</code> environment variable for your task group's Envoy proxy container in your task definition or pod spec. This is then mapped to the <code>node.id</code> and <code>node.cluster</code> Envoy parameters.</p> <note>
    /// <p>By default, App Mesh uses the name of the resource you specified in <code>APPMESH_RESOURCE_ARN</code> when Envoy is referring to itself in metrics and traces. You can override this behavior by setting the <code>APPMESH_RESOURCE_CLUSTER</code> environment variable with your own name.</p>
    /// </note>
    /// <p>For more information about virtual nodes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html">Virtual nodes</a>. You must be using <code>1.15.0</code> or later of the Envoy image when setting these variables. For more information aboutApp Mesh Envoy variables, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html">Envoy image</a> in the AWS App Mesh User Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVirtualNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_virtual_node_input::Builder,
    }
    impl CreateVirtualNode {
        /// Creates a new `CreateVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual node.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(input.into());
            self
        }
        /// <p>The name to use for the virtual node.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual node in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual node in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual node specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualNodeSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The virtual node specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualRouter`.
    ///
    /// <p>Creates a virtual router within a service mesh.</p>
    /// <p>Specify a <code>listener</code> for any inbound traffic that your virtual router receives. Create a virtual router for each protocol and port that you need to route. Virtual routers handle traffic for one or more virtual services within your mesh. After you create your virtual router, create and associate routes for your virtual router that direct incoming requests to different virtual nodes.</p>
    /// <p>For more information about virtual routers, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_routers.html">Virtual routers</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVirtualRouter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_virtual_router_input::Builder,
    }
    impl CreateVirtualRouter {
        /// Creates a new `CreateVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualRouterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual router.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name to use for the virtual router.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual router in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual router in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual router specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualRouterSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The virtual router specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVirtualService`.
    ///
    /// <p>Creates a virtual service within a service mesh.</p>
    /// <p>A virtual service is an abstraction of a real service that is provided by a virtual node directly or indirectly by means of a virtual router. Dependent services call your virtual service by its <code>virtualServiceName</code>, and those requests are routed to the virtual node or virtual router that is specified as the provider for the virtual service.</p>
    /// <p>For more information about virtual services, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html">Virtual services</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVirtualService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_virtual_service_input::Builder,
    }
    impl CreateVirtualService {
        /// Creates a new `CreateVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVirtualServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for the virtual service.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(input.into());
            self
        }
        /// <p>The name to use for the virtual service.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh to create the virtual service in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual service in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The virtual service specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualServiceSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The virtual service specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGatewayRoute`.
    ///
    /// <p>Deletes an existing gateway route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGatewayRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_gateway_route_input::Builder,
    }
    impl DeleteGatewayRoute {
        /// Creates a new `DeleteGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGatewayRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the gateway route to delete.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(input.into());
            self
        }
        /// <p>The name of the gateway route to delete.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the gateway route from.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the gateway route from.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway to delete the route from.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway to delete the route from.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMesh`.
    ///
    /// <p>Deletes an existing service mesh.</p>
    /// <p>You must delete all resources (virtual services, routes, virtual routers, and virtual nodes) in the service mesh before you can delete the mesh itself.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMesh {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_mesh_input::Builder,
    }
    impl DeleteMesh {
        /// Creates a new `DeleteMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMeshError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to delete.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to delete.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRoute`.
    ///
    /// <p>Deletes an existing route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_route_input::Builder,
    }
    impl DeleteRoute {
        /// Creates a new `DeleteRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route to delete.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(input.into());
            self
        }
        /// <p>The name of the route to delete.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the route in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router to delete the route in.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router to delete the route in.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualGateway`.
    ///
    /// <p>Deletes an existing virtual gateway. You cannot delete a virtual gateway if any gateway routes are associated to it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVirtualGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_virtual_gateway_input::Builder,
    }
    impl DeleteVirtualGateway {
        /// Creates a new `DeleteVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual gateway to delete.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway to delete.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual gateway from.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual gateway from.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualNode`.
    ///
    /// <p>Deletes an existing virtual node.</p>
    /// <p>You must delete any virtual services that list a virtual node as a service provider before you can delete the virtual node itself.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVirtualNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_virtual_node_input::Builder,
    }
    impl DeleteVirtualNode {
        /// Creates a new `DeleteVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual node to delete.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(input.into());
            self
        }
        /// <p>The name of the virtual node to delete.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual node in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual node in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualRouter`.
    ///
    /// <p>Deletes an existing virtual router.</p>
    /// <p>You must delete any routes associated with the virtual router before you can delete the router itself.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVirtualRouter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_virtual_router_input::Builder,
    }
    impl DeleteVirtualRouter {
        /// Creates a new `DeleteVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualRouterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual router to delete.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router to delete.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual router in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual router in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVirtualService`.
    ///
    /// <p>Deletes an existing virtual service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVirtualService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_virtual_service_input::Builder,
    }
    impl DeleteVirtualService {
        /// Creates a new `DeleteVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVirtualServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual service to delete.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(input.into());
            self
        }
        /// <p>The name of the virtual service to delete.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh to delete the virtual service in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual service in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGatewayRoute`.
    ///
    /// <p>Describes an existing gateway route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGatewayRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_gateway_route_input::Builder,
    }
    impl DescribeGatewayRoute {
        /// Creates a new `DescribeGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGatewayRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the gateway route to describe.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(input.into());
            self
        }
        /// <p>The name of the gateway route to describe.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMesh`.
    ///
    /// <p>Describes an existing service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMesh {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_mesh_input::Builder,
    }
    impl DescribeMesh {
        /// Creates a new `DescribeMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMeshError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to describe.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to describe.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRoute`.
    ///
    /// <p>Describes an existing route.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_route_input::Builder,
    }
    impl DescribeRoute {
        /// Creates a new `DescribeRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route to describe.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(input.into());
            self
        }
        /// <p>The name of the route to describe.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualGateway`.
    ///
    /// <p>Describes an existing virtual gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVirtualGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_virtual_gateway_input::Builder,
    }
    impl DescribeVirtualGateway {
        /// Creates a new `DescribeVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual gateway to describe.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway to describe.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualNode`.
    ///
    /// <p>Describes an existing virtual node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVirtualNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_virtual_node_input::Builder,
    }
    impl DescribeVirtualNode {
        /// Creates a new `DescribeVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual node to describe.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(input.into());
            self
        }
        /// <p>The name of the virtual node to describe.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualRouter`.
    ///
    /// <p>Describes an existing virtual router.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVirtualRouter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_virtual_router_input::Builder,
    }
    impl DescribeVirtualRouter {
        /// Creates a new `DescribeVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualRouterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual router to describe.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router to describe.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVirtualService`.
    ///
    /// <p>Describes an existing virtual service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVirtualService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_virtual_service_input::Builder,
    }
    impl DescribeVirtualService {
        /// Creates a new `DescribeVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVirtualServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual service to describe.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(input.into());
            self
        }
        /// <p>The name of the virtual service to describe.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGatewayRoutes`.
    ///
    /// <p>Returns a list of existing gateway routes that are associated to a virtual gateway.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGatewayRoutes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_gateway_routes_input::Builder,
    }
    impl ListGatewayRoutes {
        /// Creates a new `ListGatewayRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGatewayRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGatewayRoutesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGatewayRoutesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGatewayRoutesPaginator {
            crate::paginator::ListGatewayRoutesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the service mesh to list gateway routes in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to list gateway routes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway to list gateway routes in.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway to list gateway routes in.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMeshes`.
    ///
    /// <p>Returns a list of existing service meshes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMeshes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_meshes_input::Builder,
    }
    impl ListMeshes {
        /// Creates a new `ListMeshes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMeshesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMeshesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMeshesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMeshesPaginator {
            crate::paginator::ListMeshesPaginator::new(self.handle, self.inner)
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutes`.
    ///
    /// <p>Returns a list of existing routes in a service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRoutes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_routes_input::Builder,
    }
    impl ListRoutes {
        /// Creates a new `ListRoutes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoutesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRoutesPaginator {
            crate::paginator::ListRoutesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the service mesh to list routes in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to list routes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router to list routes in.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router to list routes in.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>List the tags for an App Mesh resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTagsForResourcePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTagsForResourcePaginator {
            crate::paginator::ListTagsForResourcePaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualGateways`.
    ///
    /// <p>Returns a list of existing virtual gateways in a service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVirtualGateways {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_virtual_gateways_input::Builder,
    }
    impl ListVirtualGateways {
        /// Creates a new `ListVirtualGateways`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualGatewaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualGatewaysError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVirtualGatewaysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVirtualGatewaysPaginator {
            crate::paginator::ListVirtualGatewaysPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the service mesh to list virtual gateways in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual gateways in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualNodes`.
    ///
    /// <p>Returns a list of existing virtual nodes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVirtualNodes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_virtual_nodes_input::Builder,
    }
    impl ListVirtualNodes {
        /// Creates a new `ListVirtualNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualNodesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVirtualNodesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVirtualNodesPaginator {
            crate::paginator::ListVirtualNodesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the service mesh to list virtual nodes in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual nodes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualRouters`.
    ///
    /// <p>Returns a list of existing virtual routers in a service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVirtualRouters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_virtual_routers_input::Builder,
    }
    impl ListVirtualRouters {
        /// Creates a new `ListVirtualRouters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualRoutersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualRoutersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVirtualRoutersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVirtualRoutersPaginator {
            crate::paginator::ListVirtualRoutersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the service mesh to list virtual routers in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual routers in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListVirtualServices`.
    ///
    /// <p>Returns a list of existing virtual services in a service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListVirtualServices {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_virtual_services_input::Builder,
    }
    impl ListVirtualServices {
        /// Creates a new `ListVirtualServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListVirtualServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListVirtualServicesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListVirtualServicesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListVirtualServicesPaginator {
            crate::paginator::ListVirtualServicesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the service mesh to list virtual services in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual services in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags associated with that resource are also deleted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes specified tags from a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGatewayRoute`.
    ///
    /// <p>Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGatewayRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_gateway_route_input::Builder,
    }
    impl UpdateGatewayRoute {
        /// Creates a new `UpdateGatewayRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGatewayRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGatewayRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the gateway route to update.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gateway_route_name(input.into());
            self
        }
        /// <p>The name of the gateway route to update.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_gateway_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::GatewayRouteSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMesh`.
    ///
    /// <p>Updates an existing service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMesh {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_mesh_input::Builder,
    }
    impl UpdateMesh {
        /// Creates a new `UpdateMesh`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMeshOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMeshError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the service mesh to update.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh to update.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn spec(mut self, input: crate::model::MeshSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::MeshSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoute`.
    ///
    /// <p>Updates an existing route for a specified service mesh and virtual router.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_route_input::Builder,
    }
    impl UpdateRoute {
        /// Creates a new `UpdateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route to update.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.route_name(input.into());
            self
        }
        /// <p>The name of the route to update.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_route_name(input);
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The new route specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::RouteSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The new route specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::RouteSpec>) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualGateway`.
    ///
    /// <p>Updates an existing virtual gateway in a specified service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVirtualGateway {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_virtual_gateway_input::Builder,
    }
    impl UpdateVirtualGateway {
        /// Creates a new `UpdateVirtualGateway`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualGatewayOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualGatewayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual gateway to update.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_gateway_name(input.into());
            self
        }
        /// <p>The name of the virtual gateway to update.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_gateway_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual gateway specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualGatewaySpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The new virtual gateway specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewaySpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualNode`.
    ///
    /// <p>Updates an existing virtual node in a specified service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVirtualNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_virtual_node_input::Builder,
    }
    impl UpdateVirtualNode {
        /// Creates a new `UpdateVirtualNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual node to update.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_node_name(input.into());
            self
        }
        /// <p>The name of the virtual node to update.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_node_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualNodeSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualRouter`.
    ///
    /// <p>Updates an existing virtual router in a specified service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVirtualRouter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_virtual_router_input::Builder,
    }
    impl UpdateVirtualRouter {
        /// Creates a new `UpdateVirtualRouter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualRouterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualRouterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual router to update.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_router_name(input.into());
            self
        }
        /// <p>The name of the virtual router to update.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_router_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualRouterSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateVirtualService`.
    ///
    /// <p>Updates an existing virtual service in a specified service mesh.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateVirtualService {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_virtual_service_input::Builder,
    }
    impl UpdateVirtualService {
        /// Creates a new `UpdateVirtualService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateVirtualServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateVirtualServiceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the virtual service to update.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.virtual_service_name(input.into());
            self
        }
        /// <p>The name of the virtual service to update.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_virtual_service_name(input);
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_name(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_name(input);
            self
        }
        /// <p>The new virtual service specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualServiceSpec) -> Self {
            self.inner = self.inner.spec(input);
            self
        }
        /// <p>The new virtual service specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceSpec>,
        ) -> Self {
            self.inner = self.inner.set_spec(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mesh_owner(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_mesh_owner(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
