// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateGatewayRouteInput`](crate::input::CreateGatewayRouteInput)
pub mod create_gateway_route_input {
    /// A builder for [`CreateGatewayRouteInput`](crate::input::CreateGatewayRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::GatewayRouteSpec>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the gateway route.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_route_name = Some(input.into());
            self
        }
        /// <p>The name to use for the gateway route.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_route_name = input;
            self
        }
        /// <p>The name of the service mesh to create the gateway route in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to create the gateway route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The gateway route specification to apply.</p>
        pub fn spec(mut self, input: crate::model::GatewayRouteSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The gateway route specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGatewayRouteInput`](crate::input::CreateGatewayRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGatewayRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGatewayRouteInput {
                gateway_route_name: self.gateway_route_name,
                mesh_name: self.mesh_name,
                virtual_gateway_name: self.virtual_gateway_name,
                spec: self.spec,
                tags: self.tags,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGatewayRouteInputOperationOutputAlias = crate::operation::CreateGatewayRoute;
#[doc(hidden)]
pub type CreateGatewayRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGatewayRouteInput {
    /// Consumes the builder and constructs an Operation<[`CreateGatewayRoute`](crate::operation::CreateGatewayRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGatewayRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGatewayRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.mesh_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_1, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_2 = &_input.virtual_gateway_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_2, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes", meshName = mesh_name, virtualGatewayName = virtual_gateway_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateGatewayRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_3) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_3));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGatewayRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_gateway_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGatewayRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGatewayRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGatewayRouteInput`](crate::input::CreateGatewayRouteInput)
    pub fn builder() -> crate::input::create_gateway_route_input::Builder {
        crate::input::create_gateway_route_input::Builder::default()
    }
}

/// See [`CreateMeshInput`](crate::input::CreateMeshInput)
pub mod create_mesh_input {
    /// A builder for [`CreateMeshInput`](crate::input::CreateMeshInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::MeshSpec>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the service mesh.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name to use for the service mesh.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn spec(mut self, input: crate::model::MeshSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::MeshSpec>) -> Self {
            self.spec = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMeshInput`](crate::input::CreateMeshInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMeshInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMeshInput {
                mesh_name: self.mesh_name,
                spec: self.spec,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMeshInputOperationOutputAlias = crate::operation::CreateMesh;
#[doc(hidden)]
pub type CreateMeshInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMeshInput {
    /// Consumes the builder and constructs an Operation<[`CreateMesh`](crate::operation::CreateMesh)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMesh,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMeshInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v20190125/meshes").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMeshInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_mesh(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMesh::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMesh",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMeshInput`](crate::input::CreateMeshInput)
    pub fn builder() -> crate::input::create_mesh_input::Builder {
        crate::input::create_mesh_input::Builder::default()
    }
}

/// See [`CreateRouteInput`](crate::input::CreateRouteInput)
pub mod create_route_input {
    /// A builder for [`CreateRouteInput`](crate::input::CreateRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::RouteSpec>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the route.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_name = Some(input.into());
            self
        }
        /// <p>The name to use for the route.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_name = input;
            self
        }
        /// <p>The name of the service mesh to create the route in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to create the route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The route specification to apply.</p>
        pub fn spec(mut self, input: crate::model::RouteSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The route specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::RouteSpec>) -> Self {
            self.spec = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteInput`](crate::input::CreateRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRouteInput {
                route_name: self.route_name,
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                spec: self.spec,
                tags: self.tags,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRouteInputOperationOutputAlias = crate::operation::CreateRoute;
#[doc(hidden)]
pub type CreateRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRouteInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoute`](crate::operation::CreateRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.mesh_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_4, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_5 = &_input.virtual_router_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_5, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
                    meshName = mesh_name,
                    virtualRouterName = virtual_router_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_6) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_6));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRouteInput`](crate::input::CreateRouteInput)
    pub fn builder() -> crate::input::create_route_input::Builder {
        crate::input::create_route_input::Builder::default()
    }
}

/// See [`CreateVirtualGatewayInput`](crate::input::CreateVirtualGatewayInput)
pub mod create_virtual_gateway_input {
    /// A builder for [`CreateVirtualGatewayInput`](crate::input::CreateVirtualGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualGatewaySpec>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the virtual gateway.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name to use for the virtual gateway.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The name of the service mesh to create the virtual gateway in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual gateway in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The virtual gateway specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualGatewaySpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The virtual gateway specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewaySpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualGatewayInput`](crate::input::CreateVirtualGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVirtualGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVirtualGatewayInput {
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                tags: self.tags,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVirtualGatewayInputOperationOutputAlias = crate::operation::CreateVirtualGateway;
#[doc(hidden)]
pub type CreateVirtualGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVirtualGatewayInput {
    /// Consumes the builder and constructs an Operation<[`CreateVirtualGateway`](crate::operation::CreateVirtualGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVirtualGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateVirtualGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.mesh_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_7, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualGateways",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateVirtualGatewayInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_8) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_8));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateVirtualGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_virtual_gateway(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVirtualGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVirtualGateway",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateVirtualGatewayInput`](crate::input::CreateVirtualGatewayInput)
    pub fn builder() -> crate::input::create_virtual_gateway_input::Builder {
        crate::input::create_virtual_gateway_input::Builder::default()
    }
}

/// See [`CreateVirtualNodeInput`](crate::input::CreateVirtualNodeInput)
pub mod create_virtual_node_input {
    /// A builder for [`CreateVirtualNodeInput`](crate::input::CreateVirtualNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualNodeSpec>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the virtual node.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node_name = Some(input.into());
            self
        }
        /// <p>The name to use for the virtual node.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_node_name = input;
            self
        }
        /// <p>The name of the service mesh to create the virtual node in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual node in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The virtual node specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualNodeSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The virtual node specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualNodeInput`](crate::input::CreateVirtualNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVirtualNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVirtualNodeInput {
                virtual_node_name: self.virtual_node_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                tags: self.tags,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVirtualNodeInputOperationOutputAlias = crate::operation::CreateVirtualNode;
#[doc(hidden)]
pub type CreateVirtualNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVirtualNodeInput {
    /// Consumes the builder and constructs an Operation<[`CreateVirtualNode`](crate::operation::CreateVirtualNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVirtualNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateVirtualNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.mesh_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_9, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualNodes",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateVirtualNodeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_10) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_10));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateVirtualNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_virtual_node(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVirtualNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVirtualNode",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateVirtualNodeInput`](crate::input::CreateVirtualNodeInput)
    pub fn builder() -> crate::input::create_virtual_node_input::Builder {
        crate::input::create_virtual_node_input::Builder::default()
    }
}

/// See [`CreateVirtualRouterInput`](crate::input::CreateVirtualRouterInput)
pub mod create_virtual_router_input {
    /// A builder for [`CreateVirtualRouterInput`](crate::input::CreateVirtualRouterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualRouterSpec>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the virtual router.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name to use for the virtual router.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The name of the service mesh to create the virtual router in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual router in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The virtual router specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualRouterSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The virtual router specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualRouterInput`](crate::input::CreateVirtualRouterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVirtualRouterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVirtualRouterInput {
                virtual_router_name: self.virtual_router_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                tags: self.tags,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVirtualRouterInputOperationOutputAlias = crate::operation::CreateVirtualRouter;
#[doc(hidden)]
pub type CreateVirtualRouterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVirtualRouterInput {
    /// Consumes the builder and constructs an Operation<[`CreateVirtualRouter`](crate::operation::CreateVirtualRouter)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVirtualRouter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateVirtualRouterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.mesh_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_11, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualRouters",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateVirtualRouterInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_12) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_12));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateVirtualRouterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_virtual_router(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVirtualRouter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVirtualRouter",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateVirtualRouterInput`](crate::input::CreateVirtualRouterInput)
    pub fn builder() -> crate::input::create_virtual_router_input::Builder {
        crate::input::create_virtual_router_input::Builder::default()
    }
}

/// See [`CreateVirtualServiceInput`](crate::input::CreateVirtualServiceInput)
pub mod create_virtual_service_input {
    /// A builder for [`CreateVirtualServiceInput`](crate::input::CreateVirtualServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualServiceSpec>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name to use for the virtual service.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name to use for the virtual service.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// <p>The name of the service mesh to create the virtual service in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to create the virtual service in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The virtual service specification to apply.</p>
        pub fn spec(mut self, input: crate::model::VirtualServiceSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The virtual service specification to apply.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVirtualServiceInput`](crate::input::CreateVirtualServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVirtualServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVirtualServiceInput {
                virtual_service_name: self.virtual_service_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                tags: self.tags,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVirtualServiceInputOperationOutputAlias = crate::operation::CreateVirtualService;
#[doc(hidden)]
pub type CreateVirtualServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVirtualServiceInput {
    /// Consumes the builder and constructs an Operation<[`CreateVirtualService`](crate::operation::CreateVirtualService)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVirtualService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateVirtualServiceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.mesh_name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_13, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualServices",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::CreateVirtualServiceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_14) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_14));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateVirtualServiceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_virtual_service(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVirtualService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVirtualService",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateVirtualServiceInput`](crate::input::CreateVirtualServiceInput)
    pub fn builder() -> crate::input::create_virtual_service_input::Builder {
        crate::input::create_virtual_service_input::Builder::default()
    }
}

/// See [`DeleteGatewayRouteInput`](crate::input::DeleteGatewayRouteInput)
pub mod delete_gateway_route_input {
    /// A builder for [`DeleteGatewayRouteInput`](crate::input::DeleteGatewayRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the gateway route to delete.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_route_name = Some(input.into());
            self
        }
        /// <p>The name of the gateway route to delete.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_route_name = input;
            self
        }
        /// <p>The name of the service mesh to delete the gateway route from.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the gateway route from.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual gateway to delete the route from.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway to delete the route from.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGatewayRouteInput`](crate::input::DeleteGatewayRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGatewayRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGatewayRouteInput {
                gateway_route_name: self.gateway_route_name,
                mesh_name: self.mesh_name,
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGatewayRouteInputOperationOutputAlias = crate::operation::DeleteGatewayRoute;
#[doc(hidden)]
pub type DeleteGatewayRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGatewayRouteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGatewayRoute`](crate::operation::DeleteGatewayRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGatewayRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGatewayRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.mesh_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_15, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_16 = &_input.virtual_gateway_name;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_16, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_17 = &_input.gateway_route_name;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_route_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let gateway_route_name = aws_smithy_http::label::fmt_string(input_17, false);
                if gateway_route_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_route_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}", meshName = mesh_name, virtualGatewayName = virtual_gateway_name, gatewayRouteName = gateway_route_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteGatewayRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_18) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_18));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGatewayRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGatewayRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGatewayRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGatewayRouteInput`](crate::input::DeleteGatewayRouteInput)
    pub fn builder() -> crate::input::delete_gateway_route_input::Builder {
        crate::input::delete_gateway_route_input::Builder::default()
    }
}

/// See [`DeleteMeshInput`](crate::input::DeleteMeshInput)
pub mod delete_mesh_input {
    /// A builder for [`DeleteMeshInput`](crate::input::DeleteMeshInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to delete.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to delete.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMeshInput`](crate::input::DeleteMeshInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMeshInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMeshInput {
                mesh_name: self.mesh_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMeshInputOperationOutputAlias = crate::operation::DeleteMesh;
#[doc(hidden)]
pub type DeleteMeshInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMeshInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMesh`](crate::operation::DeleteMesh)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMesh,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMeshInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.mesh_name;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_19, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}", meshName = mesh_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMeshInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMesh::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMesh",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMeshInput`](crate::input::DeleteMeshInput)
    pub fn builder() -> crate::input::delete_mesh_input::Builder {
        crate::input::delete_mesh_input::Builder::default()
    }
}

/// See [`DeleteRouteInput`](crate::input::DeleteRouteInput)
pub mod delete_route_input {
    /// A builder for [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the route to delete.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_name = Some(input.into());
            self
        }
        /// <p>The name of the route to delete.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_name = input;
            self
        }
        /// <p>The name of the service mesh to delete the route in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the route in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual router to delete the route in.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router to delete the route in.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteInput`](crate::input::DeleteRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRouteInput {
                route_name: self.route_name,
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRouteInputOperationOutputAlias = crate::operation::DeleteRoute;
#[doc(hidden)]
pub type DeleteRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRouteInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRoute`](crate::operation::DeleteRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.mesh_name;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_20, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.virtual_router_name;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_21, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_22 = &_input.route_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_name = aws_smithy_http::label::fmt_string(input_22, false);
                if route_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}", meshName = mesh_name, virtualRouterName = virtual_router_name, routeName = route_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_23) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_23));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRouteInput`](crate::input::DeleteRouteInput)
    pub fn builder() -> crate::input::delete_route_input::Builder {
        crate::input::delete_route_input::Builder::default()
    }
}

/// See [`DeleteVirtualGatewayInput`](crate::input::DeleteVirtualGatewayInput)
pub mod delete_virtual_gateway_input {
    /// A builder for [`DeleteVirtualGatewayInput`](crate::input::DeleteVirtualGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual gateway to delete.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway to delete.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The name of the service mesh to delete the virtual gateway from.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual gateway from.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualGatewayInput`](crate::input::DeleteVirtualGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVirtualGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVirtualGatewayInput {
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVirtualGatewayInputOperationOutputAlias = crate::operation::DeleteVirtualGateway;
#[doc(hidden)]
pub type DeleteVirtualGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVirtualGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVirtualGateway`](crate::operation::DeleteVirtualGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVirtualGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVirtualGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.mesh_name;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_24, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_25 = &_input.virtual_gateway_name;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_25, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
                    meshName = mesh_name,
                    virtualGatewayName = virtual_gateway_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteVirtualGatewayInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_26) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_26));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVirtualGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVirtualGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVirtualGateway",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVirtualGatewayInput`](crate::input::DeleteVirtualGatewayInput)
    pub fn builder() -> crate::input::delete_virtual_gateway_input::Builder {
        crate::input::delete_virtual_gateway_input::Builder::default()
    }
}

/// See [`DeleteVirtualNodeInput`](crate::input::DeleteVirtualNodeInput)
pub mod delete_virtual_node_input {
    /// A builder for [`DeleteVirtualNodeInput`](crate::input::DeleteVirtualNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual node to delete.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual node to delete.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_node_name = input;
            self
        }
        /// <p>The name of the service mesh to delete the virtual node in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual node in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualNodeInput`](crate::input::DeleteVirtualNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVirtualNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVirtualNodeInput {
                virtual_node_name: self.virtual_node_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVirtualNodeInputOperationOutputAlias = crate::operation::DeleteVirtualNode;
#[doc(hidden)]
pub type DeleteVirtualNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVirtualNodeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVirtualNode`](crate::operation::DeleteVirtualNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVirtualNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVirtualNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.mesh_name;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_27, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_28 = &_input.virtual_node_name;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_node_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_node_name = aws_smithy_http::label::fmt_string(input_28, false);
                if virtual_node_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_node_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
                    meshName = mesh_name,
                    virtualNodeName = virtual_node_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteVirtualNodeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_29) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_29));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVirtualNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVirtualNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVirtualNode",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVirtualNodeInput`](crate::input::DeleteVirtualNodeInput)
    pub fn builder() -> crate::input::delete_virtual_node_input::Builder {
        crate::input::delete_virtual_node_input::Builder::default()
    }
}

/// See [`DeleteVirtualRouterInput`](crate::input::DeleteVirtualRouterInput)
pub mod delete_virtual_router_input {
    /// A builder for [`DeleteVirtualRouterInput`](crate::input::DeleteVirtualRouterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual router to delete.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router to delete.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The name of the service mesh to delete the virtual router in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual router in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualRouterInput`](crate::input::DeleteVirtualRouterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVirtualRouterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVirtualRouterInput {
                virtual_router_name: self.virtual_router_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVirtualRouterInputOperationOutputAlias = crate::operation::DeleteVirtualRouter;
#[doc(hidden)]
pub type DeleteVirtualRouterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVirtualRouterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVirtualRouter`](crate::operation::DeleteVirtualRouter)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVirtualRouter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVirtualRouterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.mesh_name;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_30, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_31 = &_input.virtual_router_name;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_31, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
                    meshName = mesh_name,
                    virtualRouterName = virtual_router_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteVirtualRouterInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_32) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVirtualRouterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVirtualRouter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVirtualRouter",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVirtualRouterInput`](crate::input::DeleteVirtualRouterInput)
    pub fn builder() -> crate::input::delete_virtual_router_input::Builder {
        crate::input::delete_virtual_router_input::Builder::default()
    }
}

/// See [`DeleteVirtualServiceInput`](crate::input::DeleteVirtualServiceInput)
pub mod delete_virtual_service_input {
    /// A builder for [`DeleteVirtualServiceInput`](crate::input::DeleteVirtualServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual service to delete.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual service to delete.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// <p>The name of the service mesh to delete the virtual service in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to delete the virtual service in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVirtualServiceInput`](crate::input::DeleteVirtualServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVirtualServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVirtualServiceInput {
                virtual_service_name: self.virtual_service_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVirtualServiceInputOperationOutputAlias = crate::operation::DeleteVirtualService;
#[doc(hidden)]
pub type DeleteVirtualServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVirtualServiceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVirtualService`](crate::operation::DeleteVirtualService)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVirtualService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteVirtualServiceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.mesh_name;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_33, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_34 = &_input.virtual_service_name;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_service_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_service_name = aws_smithy_http::label::fmt_string(input_34, false);
                if virtual_service_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_service_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
                    meshName = mesh_name,
                    virtualServiceName = virtual_service_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteVirtualServiceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_35) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_35));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteVirtualServiceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVirtualService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVirtualService",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteVirtualServiceInput`](crate::input::DeleteVirtualServiceInput)
    pub fn builder() -> crate::input::delete_virtual_service_input::Builder {
        crate::input::delete_virtual_service_input::Builder::default()
    }
}

/// See [`DescribeGatewayRouteInput`](crate::input::DescribeGatewayRouteInput)
pub mod describe_gateway_route_input {
    /// A builder for [`DescribeGatewayRouteInput`](crate::input::DescribeGatewayRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the gateway route to describe.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_route_name = Some(input.into());
            self
        }
        /// <p>The name of the gateway route to describe.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_route_name = input;
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGatewayRouteInput`](crate::input::DescribeGatewayRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGatewayRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGatewayRouteInput {
                gateway_route_name: self.gateway_route_name,
                mesh_name: self.mesh_name,
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGatewayRouteInputOperationOutputAlias = crate::operation::DescribeGatewayRoute;
#[doc(hidden)]
pub type DescribeGatewayRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGatewayRouteInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGatewayRoute`](crate::operation::DescribeGatewayRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGatewayRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeGatewayRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.mesh_name;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_36, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.virtual_gateway_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_37, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_38 = &_input.gateway_route_name;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_route_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let gateway_route_name = aws_smithy_http::label::fmt_string(input_38, false);
                if gateway_route_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_route_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}", meshName = mesh_name, virtualGatewayName = virtual_gateway_name, gatewayRouteName = gateway_route_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeGatewayRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_39) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_39));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeGatewayRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGatewayRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGatewayRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeGatewayRouteInput`](crate::input::DescribeGatewayRouteInput)
    pub fn builder() -> crate::input::describe_gateway_route_input::Builder {
        crate::input::describe_gateway_route_input::Builder::default()
    }
}

/// See [`DescribeMeshInput`](crate::input::DescribeMeshInput)
pub mod describe_mesh_input {
    /// A builder for [`DescribeMeshInput`](crate::input::DescribeMeshInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to describe.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to describe.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMeshInput`](crate::input::DescribeMeshInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMeshInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMeshInput {
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMeshInputOperationOutputAlias = crate::operation::DescribeMesh;
#[doc(hidden)]
pub type DescribeMeshInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMeshInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMesh`](crate::operation::DescribeMesh)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMesh,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeMeshInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.mesh_name;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_40, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}", meshName = mesh_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeMeshInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_41) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_41));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeMeshInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMesh::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMesh",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeMeshInput`](crate::input::DescribeMeshInput)
    pub fn builder() -> crate::input::describe_mesh_input::Builder {
        crate::input::describe_mesh_input::Builder::default()
    }
}

/// See [`DescribeRouteInput`](crate::input::DescribeRouteInput)
pub mod describe_route_input {
    /// A builder for [`DescribeRouteInput`](crate::input::DescribeRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the route to describe.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_name = Some(input.into());
            self
        }
        /// <p>The name of the route to describe.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_name = input;
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRouteInput`](crate::input::DescribeRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRouteInput {
                route_name: self.route_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
                virtual_router_name: self.virtual_router_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRouteInputOperationOutputAlias = crate::operation::DescribeRoute;
#[doc(hidden)]
pub type DescribeRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRouteInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRoute`](crate::operation::DescribeRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.mesh_name;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_42, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_43 = &_input.virtual_router_name;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_43, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_44 = &_input.route_name;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_name = aws_smithy_http::label::fmt_string(input_44, false);
                if route_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}", meshName = mesh_name, virtualRouterName = virtual_router_name, routeName = route_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_45) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_45));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRouteInput`](crate::input::DescribeRouteInput)
    pub fn builder() -> crate::input::describe_route_input::Builder {
        crate::input::describe_route_input::Builder::default()
    }
}

/// See [`DescribeVirtualGatewayInput`](crate::input::DescribeVirtualGatewayInput)
pub mod describe_virtual_gateway_input {
    /// A builder for [`DescribeVirtualGatewayInput`](crate::input::DescribeVirtualGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual gateway to describe.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway to describe.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualGatewayInput`](crate::input::DescribeVirtualGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVirtualGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVirtualGatewayInput {
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVirtualGatewayInputOperationOutputAlias = crate::operation::DescribeVirtualGateway;
#[doc(hidden)]
pub type DescribeVirtualGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVirtualGatewayInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVirtualGateway`](crate::operation::DescribeVirtualGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVirtualGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeVirtualGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.mesh_name;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_46, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_47 = &_input.virtual_gateway_name;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_47, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
                    meshName = mesh_name,
                    virtualGatewayName = virtual_gateway_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeVirtualGatewayInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_48) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_48));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeVirtualGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVirtualGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVirtualGateway",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeVirtualGatewayInput`](crate::input::DescribeVirtualGatewayInput)
    pub fn builder() -> crate::input::describe_virtual_gateway_input::Builder {
        crate::input::describe_virtual_gateway_input::Builder::default()
    }
}

/// See [`DescribeVirtualNodeInput`](crate::input::DescribeVirtualNodeInput)
pub mod describe_virtual_node_input {
    /// A builder for [`DescribeVirtualNodeInput`](crate::input::DescribeVirtualNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual node to describe.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual node to describe.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_node_name = input;
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualNodeInput`](crate::input::DescribeVirtualNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVirtualNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVirtualNodeInput {
                virtual_node_name: self.virtual_node_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVirtualNodeInputOperationOutputAlias = crate::operation::DescribeVirtualNode;
#[doc(hidden)]
pub type DescribeVirtualNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVirtualNodeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVirtualNode`](crate::operation::DescribeVirtualNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVirtualNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeVirtualNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_49 = &_input.mesh_name;
                let input_49 = input_49.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_49, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_50 = &_input.virtual_node_name;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_node_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_node_name = aws_smithy_http::label::fmt_string(input_50, false);
                if virtual_node_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_node_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
                    meshName = mesh_name,
                    virtualNodeName = virtual_node_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeVirtualNodeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_51) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_51));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeVirtualNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVirtualNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVirtualNode",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeVirtualNodeInput`](crate::input::DescribeVirtualNodeInput)
    pub fn builder() -> crate::input::describe_virtual_node_input::Builder {
        crate::input::describe_virtual_node_input::Builder::default()
    }
}

/// See [`DescribeVirtualRouterInput`](crate::input::DescribeVirtualRouterInput)
pub mod describe_virtual_router_input {
    /// A builder for [`DescribeVirtualRouterInput`](crate::input::DescribeVirtualRouterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual router to describe.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router to describe.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualRouterInput`](crate::input::DescribeVirtualRouterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVirtualRouterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVirtualRouterInput {
                virtual_router_name: self.virtual_router_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVirtualRouterInputOperationOutputAlias = crate::operation::DescribeVirtualRouter;
#[doc(hidden)]
pub type DescribeVirtualRouterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVirtualRouterInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVirtualRouter`](crate::operation::DescribeVirtualRouter)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVirtualRouter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeVirtualRouterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.mesh_name;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_52, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_53 = &_input.virtual_router_name;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_53, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
                    meshName = mesh_name,
                    virtualRouterName = virtual_router_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeVirtualRouterInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_54) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_54));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeVirtualRouterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVirtualRouter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVirtualRouter",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeVirtualRouterInput`](crate::input::DescribeVirtualRouterInput)
    pub fn builder() -> crate::input::describe_virtual_router_input::Builder {
        crate::input::describe_virtual_router_input::Builder::default()
    }
}

/// See [`DescribeVirtualServiceInput`](crate::input::DescribeVirtualServiceInput)
pub mod describe_virtual_service_input {
    /// A builder for [`DescribeVirtualServiceInput`](crate::input::DescribeVirtualServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual service to describe.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual service to describe.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVirtualServiceInput`](crate::input::DescribeVirtualServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVirtualServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVirtualServiceInput {
                virtual_service_name: self.virtual_service_name,
                mesh_name: self.mesh_name,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVirtualServiceInputOperationOutputAlias = crate::operation::DescribeVirtualService;
#[doc(hidden)]
pub type DescribeVirtualServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVirtualServiceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVirtualService`](crate::operation::DescribeVirtualService)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVirtualService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeVirtualServiceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_55 = &_input.mesh_name;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_55, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_56 = &_input.virtual_service_name;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_service_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_service_name = aws_smithy_http::label::fmt_string(input_56, false);
                if virtual_service_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_service_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
                    meshName = mesh_name,
                    virtualServiceName = virtual_service_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DescribeVirtualServiceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_57) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_57));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeVirtualServiceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVirtualService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVirtualService",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeVirtualServiceInput`](crate::input::DescribeVirtualServiceInput)
    pub fn builder() -> crate::input::describe_virtual_service_input::Builder {
        crate::input::describe_virtual_service_input::Builder::default()
    }
}

/// See [`ListGatewayRoutesInput`](crate::input::ListGatewayRoutesInput)
pub mod list_gateway_routes_input {
    /// A builder for [`ListGatewayRoutesInput`](crate::input::ListGatewayRoutesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to list gateway routes in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to list gateway routes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual gateway to list gateway routes in.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway to list gateway routes in.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGatewayRoutesInput`](crate::input::ListGatewayRoutesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGatewayRoutesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGatewayRoutesInput {
                mesh_name: self.mesh_name,
                virtual_gateway_name: self.virtual_gateway_name,
                next_token: self.next_token,
                limit: self.limit,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGatewayRoutesInputOperationOutputAlias = crate::operation::ListGatewayRoutes;
#[doc(hidden)]
pub type ListGatewayRoutesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGatewayRoutesInput {
    /// Consumes the builder and constructs an Operation<[`ListGatewayRoutes`](crate::operation::ListGatewayRoutes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGatewayRoutes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGatewayRoutesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.mesh_name;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_58, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_59 = &_input.virtual_gateway_name;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_59, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes", meshName = mesh_name, virtualGatewayName = virtual_gateway_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListGatewayRoutesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_60) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_60));
                }
                if let Some(inner_61) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_61).encode(),
                    );
                }
                if let Some(inner_62) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_62));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGatewayRoutesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGatewayRoutes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGatewayRoutes",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGatewayRoutesInput`](crate::input::ListGatewayRoutesInput)
    pub fn builder() -> crate::input::list_gateway_routes_input::Builder {
        crate::input::list_gateway_routes_input::Builder::default()
    }
}

/// See [`ListMeshesInput`](crate::input::ListMeshesInput)
pub mod list_meshes_input {
    /// A builder for [`ListMeshesInput`](crate::input::ListMeshesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
        /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
        /// </note>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMeshesInput`](crate::input::ListMeshesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMeshesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMeshesInput {
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMeshesInputOperationOutputAlias = crate::operation::ListMeshes;
#[doc(hidden)]
pub type ListMeshesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMeshesInput {
    /// Consumes the builder and constructs an Operation<[`ListMeshes`](crate::operation::ListMeshes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMeshes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMeshesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v20190125/meshes").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListMeshesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_63) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_63));
                }
                if let Some(inner_64) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_64).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMeshesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMeshes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMeshes",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMeshesInput`](crate::input::ListMeshesInput)
    pub fn builder() -> crate::input::list_meshes_input::Builder {
        crate::input::list_meshes_input::Builder::default()
    }
}

/// See [`ListRoutesInput`](crate::input::ListRoutesInput)
pub mod list_routes_input {
    /// A builder for [`ListRoutesInput`](crate::input::ListRoutesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to list routes in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to list routes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual router to list routes in.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router to list routes in.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutesInput`](crate::input::ListRoutesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRoutesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRoutesInput {
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                next_token: self.next_token,
                limit: self.limit,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRoutesInputOperationOutputAlias = crate::operation::ListRoutes;
#[doc(hidden)]
pub type ListRoutesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRoutesInput {
    /// Consumes the builder and constructs an Operation<[`ListRoutes`](crate::operation::ListRoutes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoutes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRoutesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_65 = &_input.mesh_name;
                let input_65 = input_65.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_65, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_66 = &_input.virtual_router_name;
                let input_66 = input_66.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_66, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes",
                    meshName = mesh_name,
                    virtualRouterName = virtual_router_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListRoutesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_67) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_67));
                }
                if let Some(inner_68) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_68).encode(),
                    );
                }
                if let Some(inner_69) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_69));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRoutesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRoutes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRoutes",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRoutesInput`](crate::input::ListRoutesInput)
    pub fn builder() -> crate::input::list_routes_input::Builder {
        crate::input::list_routes_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v20190125/tags").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListTagsForResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_70) = &_input.resource_arn {
                    query.push_kv(
                        "resourceArn",
                        &aws_smithy_http::query::fmt_string(&inner_70),
                    );
                }
                if let Some(inner_71) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_71));
                }
                if let Some(inner_72) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_72).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListVirtualGatewaysInput`](crate::input::ListVirtualGatewaysInput)
pub mod list_virtual_gateways_input {
    /// A builder for [`ListVirtualGatewaysInput`](crate::input::ListVirtualGatewaysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to list virtual gateways in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual gateways in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualGatewaysInput`](crate::input::ListVirtualGatewaysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVirtualGatewaysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVirtualGatewaysInput {
                mesh_name: self.mesh_name,
                next_token: self.next_token,
                limit: self.limit,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVirtualGatewaysInputOperationOutputAlias = crate::operation::ListVirtualGateways;
#[doc(hidden)]
pub type ListVirtualGatewaysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListVirtualGatewaysInput {
    /// Consumes the builder and constructs an Operation<[`ListVirtualGateways`](crate::operation::ListVirtualGateways)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVirtualGateways,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListVirtualGatewaysInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_73 = &_input.mesh_name;
                let input_73 = input_73.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_73, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualGateways",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListVirtualGatewaysInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_74) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_74));
                }
                if let Some(inner_75) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_75).encode(),
                    );
                }
                if let Some(inner_76) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_76));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListVirtualGatewaysInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVirtualGateways::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVirtualGateways",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListVirtualGatewaysInput`](crate::input::ListVirtualGatewaysInput)
    pub fn builder() -> crate::input::list_virtual_gateways_input::Builder {
        crate::input::list_virtual_gateways_input::Builder::default()
    }
}

/// See [`ListVirtualNodesInput`](crate::input::ListVirtualNodesInput)
pub mod list_virtual_nodes_input {
    /// A builder for [`ListVirtualNodesInput`](crate::input::ListVirtualNodesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to list virtual nodes in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual nodes in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualNodesInput`](crate::input::ListVirtualNodesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVirtualNodesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVirtualNodesInput {
                mesh_name: self.mesh_name,
                next_token: self.next_token,
                limit: self.limit,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVirtualNodesInputOperationOutputAlias = crate::operation::ListVirtualNodes;
#[doc(hidden)]
pub type ListVirtualNodesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListVirtualNodesInput {
    /// Consumes the builder and constructs an Operation<[`ListVirtualNodes`](crate::operation::ListVirtualNodes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVirtualNodes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListVirtualNodesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_77 = &_input.mesh_name;
                let input_77 = input_77.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_77, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualNodes",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListVirtualNodesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_78) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_78));
                }
                if let Some(inner_79) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_79).encode(),
                    );
                }
                if let Some(inner_80) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_80));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListVirtualNodesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVirtualNodes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVirtualNodes",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListVirtualNodesInput`](crate::input::ListVirtualNodesInput)
    pub fn builder() -> crate::input::list_virtual_nodes_input::Builder {
        crate::input::list_virtual_nodes_input::Builder::default()
    }
}

/// See [`ListVirtualRoutersInput`](crate::input::ListVirtualRoutersInput)
pub mod list_virtual_routers_input {
    /// A builder for [`ListVirtualRoutersInput`](crate::input::ListVirtualRoutersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to list virtual routers in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual routers in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualRoutersInput`](crate::input::ListVirtualRoutersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVirtualRoutersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVirtualRoutersInput {
                mesh_name: self.mesh_name,
                next_token: self.next_token,
                limit: self.limit,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVirtualRoutersInputOperationOutputAlias = crate::operation::ListVirtualRouters;
#[doc(hidden)]
pub type ListVirtualRoutersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListVirtualRoutersInput {
    /// Consumes the builder and constructs an Operation<[`ListVirtualRouters`](crate::operation::ListVirtualRouters)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVirtualRouters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListVirtualRoutersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_81 = &_input.mesh_name;
                let input_81 = input_81.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_81, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualRouters",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListVirtualRoutersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_82) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_82));
                }
                if let Some(inner_83) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_83).encode(),
                    );
                }
                if let Some(inner_84) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_84));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListVirtualRoutersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVirtualRouters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVirtualRouters",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListVirtualRoutersInput`](crate::input::ListVirtualRoutersInput)
    pub fn builder() -> crate::input::list_virtual_routers_input::Builder {
        crate::input::list_virtual_routers_input::Builder::default()
    }
}

/// See [`ListVirtualServicesInput`](crate::input::ListVirtualServicesInput)
pub mod list_virtual_services_input {
    /// A builder for [`ListVirtualServicesInput`](crate::input::ListVirtualServicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to list virtual services in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to list virtual services in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`ListVirtualServicesInput`](crate::input::ListVirtualServicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListVirtualServicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListVirtualServicesInput {
                mesh_name: self.mesh_name,
                next_token: self.next_token,
                limit: self.limit,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type ListVirtualServicesInputOperationOutputAlias = crate::operation::ListVirtualServices;
#[doc(hidden)]
pub type ListVirtualServicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListVirtualServicesInput {
    /// Consumes the builder and constructs an Operation<[`ListVirtualServices`](crate::operation::ListVirtualServices)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListVirtualServices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListVirtualServicesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_85 = &_input.mesh_name;
                let input_85 = input_85.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_85, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualServices",
                    meshName = mesh_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListVirtualServicesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_86) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_86));
                }
                if let Some(inner_87) = &_input.limit {
                    query.push_kv(
                        "limit",
                        aws_smithy_types::primitive::Encoder::from(*inner_87).encode(),
                    );
                }
                if let Some(inner_88) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_88));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListVirtualServicesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListVirtualServices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListVirtualServices",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListVirtualServicesInput`](crate::input::ListVirtualServicesInput)
    pub fn builder() -> crate::input::list_virtual_services_input::Builder {
        crate::input::list_virtual_services_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn tags(mut self, input: crate::model::TagRef) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v20190125/tag").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::TagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_89) = &_input.resource_arn {
                    query.push_kv(
                        "resourceArn",
                        &aws_smithy_http::query::fmt_string(&inner_89),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The keys of the tags to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The keys of the tags to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/v20190125/untag").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_90) = &_input.resource_arn {
                    query.push_kv(
                        "resourceArn",
                        &aws_smithy_http::query::fmt_string(&inner_90),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateGatewayRouteInput`](crate::input::UpdateGatewayRouteInput)
pub mod update_gateway_route_input {
    /// A builder for [`UpdateGatewayRouteInput`](crate::input::UpdateGatewayRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gateway_route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::GatewayRouteSpec>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the gateway route to update.</p>
        pub fn gateway_route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway_route_name = Some(input.into());
            self
        }
        /// <p>The name of the gateway route to update.</p>
        pub fn set_gateway_route_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.gateway_route_name = input;
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the gateway route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::GatewayRouteSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::GatewayRouteSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGatewayRouteInput`](crate::input::UpdateGatewayRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGatewayRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGatewayRouteInput {
                gateway_route_name: self.gateway_route_name,
                mesh_name: self.mesh_name,
                virtual_gateway_name: self.virtual_gateway_name,
                spec: self.spec,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGatewayRouteInputOperationOutputAlias = crate::operation::UpdateGatewayRoute;
#[doc(hidden)]
pub type UpdateGatewayRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGatewayRouteInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGatewayRoute`](crate::operation::UpdateGatewayRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGatewayRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateGatewayRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_91 = &_input.mesh_name;
                let input_91 = input_91.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_91, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_92 = &_input.virtual_gateway_name;
                let input_92 = input_92.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_92, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_93 = &_input.gateway_route_name;
                let input_93 = input_93.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_route_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let gateway_route_name = aws_smithy_http::label::fmt_string(input_93, false);
                if gateway_route_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "gateway_route_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}", meshName = mesh_name, virtualGatewayName = virtual_gateway_name, gatewayRouteName = gateway_route_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateGatewayRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_94) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_94));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateGatewayRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_gateway_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGatewayRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGatewayRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateGatewayRouteInput`](crate::input::UpdateGatewayRouteInput)
    pub fn builder() -> crate::input::update_gateway_route_input::Builder {
        crate::input::update_gateway_route_input::Builder::default()
    }
}

/// See [`UpdateMeshInput`](crate::input::UpdateMeshInput)
pub mod update_mesh_input {
    /// A builder for [`UpdateMeshInput`](crate::input::UpdateMeshInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::MeshSpec>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the service mesh to update.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh to update.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn spec(mut self, input: crate::model::MeshSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The service mesh specification to apply.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::MeshSpec>) -> Self {
            self.spec = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMeshInput`](crate::input::UpdateMeshInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMeshInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMeshInput {
                mesh_name: self.mesh_name,
                spec: self.spec,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMeshInputOperationOutputAlias = crate::operation::UpdateMesh;
#[doc(hidden)]
pub type UpdateMeshInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMeshInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMesh`](crate::operation::UpdateMesh)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMesh,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateMeshInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_95 = &_input.mesh_name;
                let input_95 = input_95.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_95, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}", meshName = mesh_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateMeshInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_mesh(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMesh::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMesh",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateMeshInput`](crate::input::UpdateMeshInput)
    pub fn builder() -> crate::input::update_mesh_input::Builder {
        crate::input::update_mesh_input::Builder::default()
    }
}

/// See [`UpdateRouteInput`](crate::input::UpdateRouteInput)
pub mod update_route_input {
    /// A builder for [`UpdateRouteInput`](crate::input::UpdateRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::RouteSpec>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the route to update.</p>
        pub fn route_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.route_name = Some(input.into());
            self
        }
        /// <p>The name of the route to update.</p>
        pub fn set_route_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.route_name = input;
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the route resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router that the route is associated with.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The new route specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::RouteSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The new route specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(mut self, input: std::option::Option<crate::model::RouteSpec>) -> Self {
            self.spec = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteInput`](crate::input::UpdateRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRouteInput {
                route_name: self.route_name,
                mesh_name: self.mesh_name,
                virtual_router_name: self.virtual_router_name,
                spec: self.spec,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRouteInputOperationOutputAlias = crate::operation::UpdateRoute;
#[doc(hidden)]
pub type UpdateRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRouteInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRoute`](crate::operation::UpdateRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_96 = &_input.mesh_name;
                let input_96 = input_96.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_96, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_97 = &_input.virtual_router_name;
                let input_97 = input_97.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_97, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_98 = &_input.route_name;
                let input_98 = input_98.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let route_name = aws_smithy_http::label::fmt_string(input_98, false);
                if route_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "route_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}", meshName = mesh_name, virtualRouterName = virtual_router_name, routeName = route_name).expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateRouteInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_99) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_99));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRoute",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRouteInput`](crate::input::UpdateRouteInput)
    pub fn builder() -> crate::input::update_route_input::Builder {
        crate::input::update_route_input::Builder::default()
    }
}

/// See [`UpdateVirtualGatewayInput`](crate::input::UpdateVirtualGatewayInput)
pub mod update_virtual_gateway_input {
    /// A builder for [`UpdateVirtualGatewayInput`](crate::input::UpdateVirtualGatewayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_gateway_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualGatewaySpec>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual gateway to update.</p>
        pub fn virtual_gateway_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_gateway_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual gateway to update.</p>
        pub fn set_virtual_gateway_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_gateway_name = input;
            self
        }
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual gateway resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The new virtual gateway specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualGatewaySpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The new virtual gateway specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualGatewaySpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualGatewayInput`](crate::input::UpdateVirtualGatewayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVirtualGatewayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVirtualGatewayInput {
                virtual_gateway_name: self.virtual_gateway_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVirtualGatewayInputOperationOutputAlias = crate::operation::UpdateVirtualGateway;
#[doc(hidden)]
pub type UpdateVirtualGatewayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVirtualGatewayInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVirtualGateway`](crate::operation::UpdateVirtualGateway)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVirtualGateway,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateVirtualGatewayInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_100 = &_input.mesh_name;
                let input_100 = input_100.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_100, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_101 = &_input.virtual_gateway_name;
                let input_101 = input_101.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_gateway_name = aws_smithy_http::label::fmt_string(input_101, false);
                if virtual_gateway_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_gateway_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
                    meshName = mesh_name,
                    virtualGatewayName = virtual_gateway_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateVirtualGatewayInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_102) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_102));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateVirtualGatewayInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_virtual_gateway(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVirtualGateway::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVirtualGateway",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateVirtualGatewayInput`](crate::input::UpdateVirtualGatewayInput)
    pub fn builder() -> crate::input::update_virtual_gateway_input::Builder {
        crate::input::update_virtual_gateway_input::Builder::default()
    }
}

/// See [`UpdateVirtualNodeInput`](crate::input::UpdateVirtualNodeInput)
pub mod update_virtual_node_input {
    /// A builder for [`UpdateVirtualNodeInput`](crate::input::UpdateVirtualNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_node_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualNodeSpec>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual node to update.</p>
        pub fn virtual_node_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_node_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual node to update.</p>
        pub fn set_virtual_node_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_node_name = input;
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual node resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualNodeSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualNodeSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualNodeInput`](crate::input::UpdateVirtualNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVirtualNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVirtualNodeInput {
                virtual_node_name: self.virtual_node_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVirtualNodeInputOperationOutputAlias = crate::operation::UpdateVirtualNode;
#[doc(hidden)]
pub type UpdateVirtualNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVirtualNodeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVirtualNode`](crate::operation::UpdateVirtualNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVirtualNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateVirtualNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_103 = &_input.mesh_name;
                let input_103 = input_103.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_103, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_104 = &_input.virtual_node_name;
                let input_104 = input_104.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_node_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_node_name = aws_smithy_http::label::fmt_string(input_104, false);
                if virtual_node_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_node_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}",
                    meshName = mesh_name,
                    virtualNodeName = virtual_node_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateVirtualNodeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_105) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_105));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateVirtualNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_virtual_node(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVirtualNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVirtualNode",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateVirtualNodeInput`](crate::input::UpdateVirtualNodeInput)
    pub fn builder() -> crate::input::update_virtual_node_input::Builder {
        crate::input::update_virtual_node_input::Builder::default()
    }
}

/// See [`UpdateVirtualRouterInput`](crate::input::UpdateVirtualRouterInput)
pub mod update_virtual_router_input {
    /// A builder for [`UpdateVirtualRouterInput`](crate::input::UpdateVirtualRouterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_router_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualRouterSpec>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual router to update.</p>
        pub fn virtual_router_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_router_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual router to update.</p>
        pub fn set_virtual_router_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_router_name = input;
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual router resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualRouterSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualRouterSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualRouterInput`](crate::input::UpdateVirtualRouterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVirtualRouterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVirtualRouterInput {
                virtual_router_name: self.virtual_router_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVirtualRouterInputOperationOutputAlias = crate::operation::UpdateVirtualRouter;
#[doc(hidden)]
pub type UpdateVirtualRouterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVirtualRouterInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVirtualRouter`](crate::operation::UpdateVirtualRouter)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVirtualRouter,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateVirtualRouterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_106 = &_input.mesh_name;
                let input_106 = input_106.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_106, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_107 = &_input.virtual_router_name;
                let input_107 = input_107.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_router_name = aws_smithy_http::label::fmt_string(input_107, false);
                if virtual_router_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_router_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
                    meshName = mesh_name,
                    virtualRouterName = virtual_router_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateVirtualRouterInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_108) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_108));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateVirtualRouterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_virtual_router(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVirtualRouter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVirtualRouter",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateVirtualRouterInput`](crate::input::UpdateVirtualRouterInput)
    pub fn builder() -> crate::input::update_virtual_router_input::Builder {
        crate::input::update_virtual_router_input::Builder::default()
    }
}

/// See [`UpdateVirtualServiceInput`](crate::input::UpdateVirtualServiceInput)
pub mod update_virtual_service_input {
    /// A builder for [`UpdateVirtualServiceInput`](crate::input::UpdateVirtualServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) virtual_service_name: std::option::Option<std::string::String>,
        pub(crate) mesh_name: std::option::Option<std::string::String>,
        pub(crate) spec: std::option::Option<crate::model::VirtualServiceSpec>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) mesh_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the virtual service to update.</p>
        pub fn virtual_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.virtual_service_name = Some(input.into());
            self
        }
        /// <p>The name of the virtual service to update.</p>
        pub fn set_virtual_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.virtual_service_name = input;
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn mesh_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_name = Some(input.into());
            self
        }
        /// <p>The name of the service mesh that the virtual service resides in.</p>
        pub fn set_mesh_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_name = input;
            self
        }
        /// <p>The new virtual service specification to apply. This overwrites the existing data.</p>
        pub fn spec(mut self, input: crate::model::VirtualServiceSpec) -> Self {
            self.spec = Some(input);
            self
        }
        /// <p>The new virtual service specification to apply. This overwrites the existing data.</p>
        pub fn set_spec(
            mut self,
            input: std::option::Option<crate::model::VirtualServiceSpec>,
        ) -> Self {
            self.spec = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn mesh_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.mesh_owner = Some(input.into());
            self
        }
        /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
        pub fn set_mesh_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mesh_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateVirtualServiceInput`](crate::input::UpdateVirtualServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateVirtualServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateVirtualServiceInput {
                virtual_service_name: self.virtual_service_name,
                mesh_name: self.mesh_name,
                spec: self.spec,
                client_token: self.client_token,
                mesh_owner: self.mesh_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateVirtualServiceInputOperationOutputAlias = crate::operation::UpdateVirtualService;
#[doc(hidden)]
pub type UpdateVirtualServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateVirtualServiceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateVirtualService`](crate::operation::UpdateVirtualService)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateVirtualService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateVirtualServiceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_109 = &_input.mesh_name;
                let input_109 = input_109.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let mesh_name = aws_smithy_http::label::fmt_string(input_109, false);
                if mesh_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "mesh_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_110 = &_input.virtual_service_name;
                let input_110 = input_110.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_service_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let virtual_service_name = aws_smithy_http::label::fmt_string(input_110, false);
                if virtual_service_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "virtual_service_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}",
                    meshName = mesh_name,
                    virtualServiceName = virtual_service_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UpdateVirtualServiceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_111) = &_input.mesh_owner {
                    query.push_kv("meshOwner", &aws_smithy_http::query::fmt_string(&inner_111));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateVirtualServiceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_virtual_service(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateVirtualService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateVirtualService",
            "appmesh",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateVirtualServiceInput`](crate::input::UpdateVirtualServiceInput)
    pub fn builder() -> crate::input::update_virtual_service_input::Builder {
        crate::input::update_virtual_service_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMeshesInput {
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
    /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
}
impl ListMeshesInput {
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListMeshes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
    /// <p>This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.</p>
    /// </note>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned by <code>ListMeshes</code> in paginated output. When you use this parameter, <code>ListMeshes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListMeshes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListMeshes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListMeshesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMeshesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMeshInput {
    /// <p>The name to use for the service mesh.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The service mesh specification to apply.</p>
    pub spec: std::option::Option<crate::model::MeshSpec>,
    /// <p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateMeshInput {
    /// <p>The name to use for the service mesh.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The service mesh specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::MeshSpec> {
        self.spec.as_ref()
    }
    /// <p>Optional metadata that you can apply to the service mesh to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateMeshInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMeshInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMeshInput {
    /// <p>The name of the service mesh to delete.</p>
    pub mesh_name: std::option::Option<std::string::String>,
}
impl DeleteMeshInput {
    /// <p>The name of the service mesh to delete.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteMeshInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMeshInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMeshInput {
    /// <p>The name of the service mesh to update.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The service mesh specification to apply.</p>
    pub spec: std::option::Option<crate::model::MeshSpec>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateMeshInput {
    /// <p>The name of the service mesh to update.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The service mesh specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::MeshSpec> {
        self.spec.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateMeshInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMeshInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMeshInput {
    /// <p>The name of the service mesh to describe.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DescribeMeshInput {
    /// <p>The name of the service mesh to describe.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DescribeMeshInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMeshInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualServicesInput {
    /// <p>The name of the service mesh to list virtual services in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl ListVirtualServicesInput {
    /// <p>The name of the service mesh to list virtual services in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualServices</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned by <code>ListVirtualServices</code> in paginated output. When you use this parameter, <code>ListVirtualServices</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualServices</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualServices</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualServicesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualServicesInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualServiceInput {
    /// <p>The name to use for the virtual service.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to create the virtual service in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The virtual service specification to apply.</p>
    pub spec: std::option::Option<crate::model::VirtualServiceSpec>,
    /// <p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl CreateVirtualServiceInput {
    /// <p>The name to use for the virtual service.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
    /// <p>The name of the service mesh to create the virtual service in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The virtual service specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualServiceSpec> {
        self.spec.as_ref()
    }
    /// <p>Optional metadata that you can apply to the virtual service to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for CreateVirtualServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualServiceInput");
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualServiceInput {
    /// <p>The name of the virtual service to delete.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to delete the virtual service in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DeleteVirtualServiceInput {
    /// <p>The name of the virtual service to delete.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
    /// <p>The name of the service mesh to delete the virtual service in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DeleteVirtualServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualServiceInput");
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualServiceInput {
    /// <p>The name of the virtual service to update.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The new virtual service specification to apply. This overwrites the existing data.</p>
    pub spec: std::option::Option<crate::model::VirtualServiceSpec>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl UpdateVirtualServiceInput {
    /// <p>The name of the virtual service to update.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The new virtual service specification to apply. This overwrites the existing data.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualServiceSpec> {
        self.spec.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for UpdateVirtualServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualServiceInput");
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualServiceInput {
    /// <p>The name of the virtual service to describe.</p>
    pub virtual_service_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DescribeVirtualServiceInput {
    /// <p>The name of the virtual service to describe.</p>
    pub fn virtual_service_name(&self) -> std::option::Option<&str> {
        self.virtual_service_name.as_deref()
    }
    /// <p>The name of the service mesh that the virtual service resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DescribeVirtualServiceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualServiceInput");
        formatter.field("virtual_service_name", &self.virtual_service_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualRoutersInput {
    /// <p>The name of the service mesh to list virtual routers in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl ListVirtualRoutersInput {
    /// <p>The name of the service mesh to list virtual routers in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualRouters</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned by <code>ListVirtualRouters</code> in paginated output. When you use this parameter, <code>ListVirtualRouters</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualRouters</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualRouters</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualRoutersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualRoutersInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualRouterInput {
    /// <p>The name to use for the virtual router.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to create the virtual router in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The virtual router specification to apply.</p>
    pub spec: std::option::Option<crate::model::VirtualRouterSpec>,
    /// <p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl CreateVirtualRouterInput {
    /// <p>The name to use for the virtual router.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The name of the service mesh to create the virtual router in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The virtual router specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualRouterSpec> {
        self.spec.as_ref()
    }
    /// <p>Optional metadata that you can apply to the virtual router to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for CreateVirtualRouterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualRouterInput");
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualRouterInput {
    /// <p>The name of the virtual router to delete.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to delete the virtual router in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DeleteVirtualRouterInput {
    /// <p>The name of the virtual router to delete.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The name of the service mesh to delete the virtual router in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DeleteVirtualRouterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualRouterInput");
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualRouterInput {
    /// <p>The name of the virtual router to update.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
    pub spec: std::option::Option<crate::model::VirtualRouterSpec>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl UpdateVirtualRouterInput {
    /// <p>The name of the virtual router to update.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The new virtual router specification to apply. This overwrites the existing data.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualRouterSpec> {
        self.spec.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for UpdateVirtualRouterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualRouterInput");
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualRouterInput {
    /// <p>The name of the virtual router to describe.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DescribeVirtualRouterInput {
    /// <p>The name of the virtual router to describe.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The name of the service mesh that the virtual router resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DescribeVirtualRouterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualRouterInput");
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRoutesInput {
    /// <p>The name of the service mesh to list routes in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual router to list routes in.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl ListRoutesInput {
    /// <p>The name of the service mesh to list routes in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual router to list routes in.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for ListRoutesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRoutesInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteInput {
    /// <p>The name to use for the route.</p>
    pub route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to create the route in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The route specification to apply.</p>
    pub spec: std::option::Option<crate::model::RouteSpec>,
    /// <p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl CreateRouteInput {
    /// <p>The name to use for the route.</p>
    pub fn route_name(&self) -> std::option::Option<&str> {
        self.route_name.as_deref()
    }
    /// <p>The name of the service mesh to create the route in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual router in which to create the route. If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The route specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::RouteSpec> {
        self.spec.as_ref()
    }
    /// <p>Optional metadata that you can apply to the route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for CreateRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteInput");
        formatter.field("route_name", &self.route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("spec", &self.spec);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteInput {
    /// <p>The name of the route to delete.</p>
    pub route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to delete the route in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual router to delete the route in.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DeleteRouteInput {
    /// <p>The name of the route to delete.</p>
    pub fn route_name(&self) -> std::option::Option<&str> {
        self.route_name.as_deref()
    }
    /// <p>The name of the service mesh to delete the route in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual router to delete the route in.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DeleteRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteInput");
        formatter.field("route_name", &self.route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteInput {
    /// <p>The name of the route to update.</p>
    pub route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the route resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual router that the route is associated with.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
    /// <p>The new route specification to apply. This overwrites the existing data.</p>
    pub spec: std::option::Option<crate::model::RouteSpec>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl UpdateRouteInput {
    /// <p>The name of the route to update.</p>
    pub fn route_name(&self) -> std::option::Option<&str> {
        self.route_name.as_deref()
    }
    /// <p>The name of the service mesh that the route resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual router that the route is associated with.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
    /// <p>The new route specification to apply. This overwrites the existing data.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::RouteSpec> {
        self.spec.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for UpdateRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteInput");
        formatter.field("route_name", &self.route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.field("spec", &self.spec);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRouteInput {
    /// <p>The name of the route to describe.</p>
    pub route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the route resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
    /// <p>The name of the virtual router that the route is associated with.</p>
    pub virtual_router_name: std::option::Option<std::string::String>,
}
impl DescribeRouteInput {
    /// <p>The name of the route to describe.</p>
    pub fn route_name(&self) -> std::option::Option<&str> {
        self.route_name.as_deref()
    }
    /// <p>The name of the service mesh that the route resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
    /// <p>The name of the virtual router that the route is associated with.</p>
    pub fn virtual_router_name(&self) -> std::option::Option<&str> {
        self.virtual_router_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRouteInput");
        formatter.field("route_name", &self.route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.field("virtual_router_name", &self.virtual_router_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualNodesInput {
    /// <p>The name of the service mesh to list virtual nodes in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl ListVirtualNodesInput {
    /// <p>The name of the service mesh to list virtual nodes in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualNodes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned by <code>ListVirtualNodes</code> in paginated output. When you use this parameter, <code>ListVirtualNodes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualNodes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualNodes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualNodesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualNodesInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualNodeInput {
    /// <p>The name to use for the virtual node.</p>
    pub virtual_node_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to create the virtual node in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The virtual node specification to apply.</p>
    pub spec: std::option::Option<crate::model::VirtualNodeSpec>,
    /// <p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl CreateVirtualNodeInput {
    /// <p>The name to use for the virtual node.</p>
    pub fn virtual_node_name(&self) -> std::option::Option<&str> {
        self.virtual_node_name.as_deref()
    }
    /// <p>The name of the service mesh to create the virtual node in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The virtual node specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualNodeSpec> {
        self.spec.as_ref()
    }
    /// <p>Optional metadata that you can apply to the virtual node to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for CreateVirtualNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualNodeInput");
        formatter.field("virtual_node_name", &self.virtual_node_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

/// <p>Deletes a virtual node input.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualNodeInput {
    /// <p>The name of the virtual node to delete.</p>
    pub virtual_node_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to delete the virtual node in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DeleteVirtualNodeInput {
    /// <p>The name of the virtual node to delete.</p>
    pub fn virtual_node_name(&self) -> std::option::Option<&str> {
        self.virtual_node_name.as_deref()
    }
    /// <p>The name of the service mesh to delete the virtual node in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DeleteVirtualNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualNodeInput");
        formatter.field("virtual_node_name", &self.virtual_node_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualNodeInput {
    /// <p>The name of the virtual node to update.</p>
    pub virtual_node_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
    pub spec: std::option::Option<crate::model::VirtualNodeSpec>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl UpdateVirtualNodeInput {
    /// <p>The name of the virtual node to update.</p>
    pub fn virtual_node_name(&self) -> std::option::Option<&str> {
        self.virtual_node_name.as_deref()
    }
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The new virtual node specification to apply. This overwrites the existing data.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualNodeSpec> {
        self.spec.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for UpdateVirtualNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualNodeInput");
        formatter.field("virtual_node_name", &self.virtual_node_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualNodeInput {
    /// <p>The name of the virtual node to describe.</p>
    pub virtual_node_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DescribeVirtualNodeInput {
    /// <p>The name of the virtual node to describe.</p>
    pub fn virtual_node_name(&self) -> std::option::Option<&str> {
        self.virtual_node_name.as_deref()
    }
    /// <p>The name of the service mesh that the virtual node resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DescribeVirtualNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualNodeInput");
        formatter.field("virtual_node_name", &self.virtual_node_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListVirtualGatewaysInput {
    /// <p>The name of the service mesh to list virtual gateways in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl ListVirtualGatewaysInput {
    /// <p>The name of the service mesh to list virtual gateways in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListVirtualGateways</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned by <code>ListVirtualGateways</code> in paginated output. When you use this parameter, <code>ListVirtualGateways</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListVirtualGateways</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListVirtualGateways</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for ListVirtualGatewaysInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListVirtualGatewaysInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateVirtualGatewayInput {
    /// <p>The name to use for the virtual gateway.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to create the virtual gateway in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The virtual gateway specification to apply.</p>
    pub spec: std::option::Option<crate::model::VirtualGatewaySpec>,
    /// <p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl CreateVirtualGatewayInput {
    /// <p>The name to use for the virtual gateway.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The name of the service mesh to create the virtual gateway in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The virtual gateway specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualGatewaySpec> {
        self.spec.as_ref()
    }
    /// <p>Optional metadata that you can apply to the virtual gateway to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for CreateVirtualGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateVirtualGatewayInput");
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteVirtualGatewayInput {
    /// <p>The name of the virtual gateway to delete.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to delete the virtual gateway from.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DeleteVirtualGatewayInput {
    /// <p>The name of the virtual gateway to delete.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The name of the service mesh to delete the virtual gateway from.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DeleteVirtualGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteVirtualGatewayInput");
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateVirtualGatewayInput {
    /// <p>The name of the virtual gateway to update.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the virtual gateway resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The new virtual gateway specification to apply. This overwrites the existing data.</p>
    pub spec: std::option::Option<crate::model::VirtualGatewaySpec>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl UpdateVirtualGatewayInput {
    /// <p>The name of the virtual gateway to update.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The name of the service mesh that the virtual gateway resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The new virtual gateway specification to apply. This overwrites the existing data.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::VirtualGatewaySpec> {
        self.spec.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for UpdateVirtualGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateVirtualGatewayInput");
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("spec", &self.spec);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeVirtualGatewayInput {
    /// <p>The name of the virtual gateway to describe.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the gateway route resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DescribeVirtualGatewayInput {
    /// <p>The name of the virtual gateway to describe.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The name of the service mesh that the gateway route resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DescribeVirtualGatewayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeVirtualGatewayInput");
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGatewayRoutesInput {
    /// <p>The name of the service mesh to list gateway routes in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual gateway to list gateway routes in.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl ListGatewayRoutesInput {
    /// <p>The name of the service mesh to list gateway routes in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual gateway to list gateway routes in.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListGatewayRoutes</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results returned by <code>ListGatewayRoutes</code> in paginated output. When you use this parameter, <code>ListGatewayRoutes</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListGatewayRoutes</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListGatewayRoutes</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for ListGatewayRoutesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGatewayRoutesInput");
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGatewayRouteInput {
    /// <p>The name to use for the gateway route.</p>
    pub gateway_route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to create the gateway route in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The gateway route specification to apply.</p>
    pub spec: std::option::Option<crate::model::GatewayRouteSpec>,
    /// <p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl CreateGatewayRouteInput {
    /// <p>The name to use for the gateway route.</p>
    pub fn gateway_route_name(&self) -> std::option::Option<&str> {
        self.gateway_route_name.as_deref()
    }
    /// <p>The name of the service mesh to create the gateway route in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual gateway to associate the gateway route with. If the virtual gateway is in a shared mesh, then you must be the owner of the virtual gateway resource.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The gateway route specification to apply.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::GatewayRouteSpec> {
        self.spec.as_ref()
    }
    /// <p>Optional metadata that you can apply to the gateway route to assist with categorization and organization. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for CreateGatewayRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGatewayRouteInput");
        formatter.field("gateway_route_name", &self.gateway_route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("spec", &self.spec);
        formatter.field("tags", &self.tags);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGatewayRouteInput {
    /// <p>The name of the gateway route to delete.</p>
    pub gateway_route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh to delete the gateway route from.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual gateway to delete the route from.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DeleteGatewayRouteInput {
    /// <p>The name of the gateway route to delete.</p>
    pub fn gateway_route_name(&self) -> std::option::Option<&str> {
        self.gateway_route_name.as_deref()
    }
    /// <p>The name of the service mesh to delete the gateway route from.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual gateway to delete the route from.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DeleteGatewayRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGatewayRouteInput");
        formatter.field("gateway_route_name", &self.gateway_route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGatewayRouteInput {
    /// <p>The name of the gateway route to update.</p>
    pub gateway_route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the gateway route resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
    pub spec: std::option::Option<crate::model::GatewayRouteSpec>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl UpdateGatewayRouteInput {
    /// <p>The name of the gateway route to update.</p>
    pub fn gateway_route_name(&self) -> std::option::Option<&str> {
        self.gateway_route_name.as_deref()
    }
    /// <p>The name of the service mesh that the gateway route resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The new gateway route specification to apply. This overwrites the existing data.</p>
    pub fn spec(&self) -> std::option::Option<&crate::model::GatewayRouteSpec> {
        self.spec.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters, numbers, hyphens, and underscores are allowed.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for UpdateGatewayRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGatewayRouteInput");
        formatter.field("gateway_route_name", &self.gateway_route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("spec", &self.spec);
        formatter.field("client_token", &self.client_token);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGatewayRouteInput {
    /// <p>The name of the gateway route to describe.</p>
    pub gateway_route_name: std::option::Option<std::string::String>,
    /// <p>The name of the service mesh that the gateway route resides in.</p>
    pub mesh_name: std::option::Option<std::string::String>,
    /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
    pub virtual_gateway_name: std::option::Option<std::string::String>,
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub mesh_owner: std::option::Option<std::string::String>,
}
impl DescribeGatewayRouteInput {
    /// <p>The name of the gateway route to describe.</p>
    pub fn gateway_route_name(&self) -> std::option::Option<&str> {
        self.gateway_route_name.as_deref()
    }
    /// <p>The name of the service mesh that the gateway route resides in.</p>
    pub fn mesh_name(&self) -> std::option::Option<&str> {
        self.mesh_name.as_deref()
    }
    /// <p>The name of the virtual gateway that the gateway route is associated with.</p>
    pub fn virtual_gateway_name(&self) -> std::option::Option<&str> {
        self.virtual_gateway_name.as_deref()
    }
    /// <p>The AWS IAM account ID of the service mesh owner. If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.</p>
    pub fn mesh_owner(&self) -> std::option::Option<&str> {
        self.mesh_owner.as_deref()
    }
}
impl std::fmt::Debug for DescribeGatewayRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGatewayRouteInput");
        formatter.field("gateway_route_name", &self.gateway_route_name);
        formatter.field("mesh_name", &self.mesh_name);
        formatter.field("virtual_gateway_name", &self.virtual_gateway_name);
        formatter.field("mesh_owner", &self.mesh_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The keys of the tags to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to delete tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The keys of the tags to be removed.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagRef>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to add tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagRef]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub limit: std::option::Option<i32>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) that identifies the resource to list the tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The <code>nextToken</code> value returned from a previous paginated <code>ListTagsForResource</code> request where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of tag results returned by <code>ListTagsForResource</code> in paginated output. When this parameter is used, <code>ListTagsForResource</code> returns only <code>limit</code> results in a single page along with a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListTagsForResource</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter, <code>ListTagsForResource</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}
