// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGatewayRouteError {
    /// Kind of error that occurred.
    pub kind: CreateGatewayRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGatewayRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGatewayRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGatewayRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateGatewayRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGatewayRouteError {
    fn code(&self) -> Option<&str> {
        CreateGatewayRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateGatewayRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateGatewayRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateGatewayRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateGatewayRouteError {
    /// Creates a new `CreateGatewayRouteError`.
    pub fn new(kind: CreateGatewayRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGatewayRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGatewayRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGatewayRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGatewayRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGatewayRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGatewayRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateGatewayRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGatewayRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::ConflictException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateGatewayRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMeshError {
    /// Kind of error that occurred.
    pub kind: CreateMeshErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMeshErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMeshError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMeshErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateMeshErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMeshError {
    fn code(&self) -> Option<&str> {
        CreateMeshError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateMeshErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateMeshErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateMeshErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateMeshError {
    /// Creates a new `CreateMeshError`.
    pub fn new(kind: CreateMeshErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMeshError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMeshErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMeshError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMeshErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateMeshErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateMeshErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateMeshErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeshErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateMeshErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateMeshErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMeshErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMeshErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, CreateMeshErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for CreateMeshError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMeshErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateMeshErrorKind::ConflictException(_inner) => Some(_inner),
            CreateMeshErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateMeshErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateMeshErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateMeshErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateMeshErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateMeshErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateMeshErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRouteError {
    /// Kind of error that occurred.
    pub kind: CreateRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRouteError {
    fn code(&self) -> Option<&str> {
        CreateRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateRouteError {
    /// Creates a new `CreateRouteError`.
    pub fn new(kind: CreateRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateRouteErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateRouteErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateRouteErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVirtualGatewayError {
    /// Kind of error that occurred.
    pub kind: CreateVirtualGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVirtualGatewayErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVirtualGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVirtualGatewayErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateVirtualGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVirtualGatewayError {
    fn code(&self) -> Option<&str> {
        CreateVirtualGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateVirtualGatewayErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualGatewayErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualGatewayErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateVirtualGatewayError {
    /// Creates a new `CreateVirtualGatewayError`.
    pub fn new(kind: CreateVirtualGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVirtualGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVirtualGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVirtualGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVirtualGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualGatewayErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualGatewayErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateVirtualGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVirtualGatewayErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::ConflictException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateVirtualGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVirtualNodeError {
    /// Kind of error that occurred.
    pub kind: CreateVirtualNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVirtualNodeErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVirtualNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVirtualNodeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateVirtualNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVirtualNodeError {
    fn code(&self) -> Option<&str> {
        CreateVirtualNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateVirtualNodeErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualNodeErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualNodeErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateVirtualNodeError {
    /// Creates a new `CreateVirtualNodeError`.
    pub fn new(kind: CreateVirtualNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVirtualNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVirtualNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVirtualNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVirtualNodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualNodeErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateVirtualNodeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualNodeErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualNodeErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualNodeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateVirtualNodeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualNodeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualNodeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualNodeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateVirtualNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVirtualNodeErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::ConflictException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateVirtualNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVirtualRouterError {
    /// Kind of error that occurred.
    pub kind: CreateVirtualRouterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVirtualRouterErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVirtualRouterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVirtualRouterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateVirtualRouterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVirtualRouterError {
    fn code(&self) -> Option<&str> {
        CreateVirtualRouterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateVirtualRouterErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualRouterErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualRouterErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateVirtualRouterError {
    /// Creates a new `CreateVirtualRouterError`.
    pub fn new(kind: CreateVirtualRouterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVirtualRouterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVirtualRouterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVirtualRouterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVirtualRouterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualRouterErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualRouterErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateVirtualRouterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVirtualRouterErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::ConflictException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateVirtualRouterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateVirtualServiceError {
    /// Kind of error that occurred.
    pub kind: CreateVirtualServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateVirtualServiceErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateVirtualServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateVirtualServiceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateVirtualServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateVirtualServiceError {
    fn code(&self) -> Option<&str> {
        CreateVirtualServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            CreateVirtualServiceErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualServiceErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            CreateVirtualServiceErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl CreateVirtualServiceError {
    /// Creates a new `CreateVirtualServiceError`.
    pub fn new(kind: CreateVirtualServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateVirtualServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateVirtualServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateVirtualServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateVirtualServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateVirtualServiceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateVirtualServiceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateVirtualServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateVirtualServiceErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::ConflictException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateVirtualServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGatewayRouteError {
    /// Kind of error that occurred.
    pub kind: DeleteGatewayRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGatewayRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGatewayRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGatewayRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteGatewayRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteGatewayRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteGatewayRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteGatewayRouteErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteGatewayRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteGatewayRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteGatewayRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGatewayRouteError {
    fn code(&self) -> Option<&str> {
        DeleteGatewayRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteGatewayRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteGatewayRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteGatewayRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteGatewayRouteError {
    /// Creates a new `DeleteGatewayRouteError`.
    pub fn new(kind: DeleteGatewayRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGatewayRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGatewayRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGatewayRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGatewayRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGatewayRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayRouteErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGatewayRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayRouteErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGatewayRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGatewayRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayRouteErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGatewayRouteErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayRouteErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGatewayRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGatewayRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGatewayRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteGatewayRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGatewayRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteGatewayRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteGatewayRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteGatewayRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteGatewayRouteErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteGatewayRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteGatewayRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteGatewayRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMeshError {
    /// Kind of error that occurred.
    pub kind: DeleteMeshErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMeshErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMeshError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMeshErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteMeshErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteMeshErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteMeshErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteMeshErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteMeshErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteMeshErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteMeshErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMeshError {
    fn code(&self) -> Option<&str> {
        DeleteMeshError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteMeshErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteMeshErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteMeshErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteMeshError {
    /// Creates a new `DeleteMeshError`.
    pub fn new(kind: DeleteMeshErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMeshError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMeshErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMeshError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMeshErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMeshErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeshErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeshErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeshErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeshErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMeshErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMeshErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeshErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeshErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeshErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteMeshErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMeshErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMeshErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, DeleteMeshErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for DeleteMeshError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMeshErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteMeshErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteMeshErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteMeshErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteMeshErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteMeshErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteMeshErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteMeshErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRouteError {
    /// Kind of error that occurred.
    pub kind: DeleteRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRouteError {
    fn code(&self) -> Option<&str> {
        DeleteRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteRouteError {
    /// Creates a new `DeleteRouteError`.
    pub fn new(kind: DeleteRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(&self.kind, DeleteRouteErrorKind::ResourceInUseException(_))
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRouteErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVirtualGatewayError {
    /// Kind of error that occurred.
    pub kind: DeleteVirtualGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVirtualGatewayErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVirtualGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVirtualGatewayErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVirtualGatewayErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVirtualGatewayErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteVirtualGatewayErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVirtualGatewayErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVirtualGatewayErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVirtualGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVirtualGatewayError {
    fn code(&self) -> Option<&str> {
        DeleteVirtualGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteVirtualGatewayErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualGatewayErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualGatewayErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteVirtualGatewayError {
    /// Creates a new `DeleteVirtualGatewayError`.
    pub fn new(kind: DeleteVirtualGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVirtualGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVirtualGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVirtualGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVirtualGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVirtualGatewayErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualGatewayErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualGatewayErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualGatewayErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualGatewayErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualGatewayErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualGatewayErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualGatewayErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualGatewayErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualGatewayErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualGatewayErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualGatewayErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualGatewayErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualGatewayErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteVirtualGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVirtualGatewayErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVirtualGatewayErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVirtualGatewayErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteVirtualGatewayErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVirtualGatewayErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVirtualGatewayErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVirtualGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVirtualNodeError {
    /// Kind of error that occurred.
    pub kind: DeleteVirtualNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVirtualNodeErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVirtualNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVirtualNodeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVirtualNodeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVirtualNodeErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteVirtualNodeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVirtualNodeErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteVirtualNodeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVirtualNodeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVirtualNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVirtualNodeError {
    fn code(&self) -> Option<&str> {
        DeleteVirtualNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteVirtualNodeErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualNodeErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualNodeErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteVirtualNodeError {
    /// Creates a new `DeleteVirtualNodeError`.
    pub fn new(kind: DeleteVirtualNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVirtualNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVirtualNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVirtualNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVirtualNodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVirtualNodeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualNodeErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualNodeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualNodeErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualNodeErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualNodeErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualNodeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteVirtualNodeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteVirtualNodeErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualNodeErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualNodeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualNodeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualNodeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualNodeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteVirtualNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVirtualNodeErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVirtualNodeErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVirtualNodeErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteVirtualNodeErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVirtualNodeErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteVirtualNodeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVirtualNodeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVirtualNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVirtualRouterError {
    /// Kind of error that occurred.
    pub kind: DeleteVirtualRouterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVirtualRouterErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVirtualRouterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVirtualRouterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVirtualRouterErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVirtualRouterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteVirtualRouterErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVirtualRouterErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteVirtualRouterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVirtualRouterErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVirtualRouterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVirtualRouterError {
    fn code(&self) -> Option<&str> {
        DeleteVirtualRouterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteVirtualRouterErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualRouterErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualRouterErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteVirtualRouterError {
    /// Creates a new `DeleteVirtualRouterError`.
    pub fn new(kind: DeleteVirtualRouterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVirtualRouterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVirtualRouterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVirtualRouterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVirtualRouterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVirtualRouterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualRouterErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualRouterErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualRouterErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualRouterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualRouterErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualRouterErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualRouterErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualRouterErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualRouterErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualRouterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualRouterErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualRouterErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualRouterErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteVirtualRouterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVirtualRouterErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVirtualRouterErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVirtualRouterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteVirtualRouterErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVirtualRouterErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteVirtualRouterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVirtualRouterErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVirtualRouterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteVirtualServiceError {
    /// Kind of error that occurred.
    pub kind: DeleteVirtualServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteVirtualServiceErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteVirtualServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteVirtualServiceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteVirtualServiceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteVirtualServiceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteVirtualServiceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteVirtualServiceErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteVirtualServiceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteVirtualServiceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteVirtualServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteVirtualServiceError {
    fn code(&self) -> Option<&str> {
        DeleteVirtualServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DeleteVirtualServiceErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualServiceErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DeleteVirtualServiceErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DeleteVirtualServiceError {
    /// Creates a new `DeleteVirtualServiceError`.
    pub fn new(kind: DeleteVirtualServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteVirtualServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteVirtualServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteVirtualServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteVirtualServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteVirtualServiceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualServiceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualServiceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualServiceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualServiceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualServiceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualServiceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualServiceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualServiceErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualServiceErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualServiceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualServiceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteVirtualServiceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteVirtualServiceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteVirtualServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteVirtualServiceErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteVirtualServiceErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteVirtualServiceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteVirtualServiceErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteVirtualServiceErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteVirtualServiceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteVirtualServiceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteVirtualServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGatewayRouteError {
    /// Kind of error that occurred.
    pub kind: DescribeGatewayRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGatewayRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGatewayRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGatewayRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeGatewayRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeGatewayRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeGatewayRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeGatewayRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeGatewayRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeGatewayRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGatewayRouteError {
    fn code(&self) -> Option<&str> {
        DescribeGatewayRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeGatewayRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeGatewayRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeGatewayRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeGatewayRouteError {
    /// Creates a new `DescribeGatewayRouteError`.
    pub fn new(kind: DescribeGatewayRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGatewayRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGatewayRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGatewayRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGatewayRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGatewayRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayRouteErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGatewayRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayRouteErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGatewayRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGatewayRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayRouteErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGatewayRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeGatewayRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGatewayRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeGatewayRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGatewayRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeGatewayRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeGatewayRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeGatewayRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeGatewayRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeGatewayRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeGatewayRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMeshError {
    /// Kind of error that occurred.
    pub kind: DescribeMeshErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMeshErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMeshError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMeshErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeMeshErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeMeshErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeMeshErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeMeshErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeMeshErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeMeshErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMeshError {
    fn code(&self) -> Option<&str> {
        DescribeMeshError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeMeshErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeMeshErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeMeshErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeMeshError {
    /// Creates a new `DescribeMeshError`.
    pub fn new(kind: DescribeMeshErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMeshError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMeshErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMeshError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMeshErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMeshErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeMeshErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeMeshErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeMeshErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeMeshErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMeshErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMeshErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeMeshErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeMeshErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMeshErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMeshErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMeshErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeMeshError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMeshErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeMeshErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeMeshErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeMeshErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeMeshErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeMeshErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeMeshErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRouteError {
    /// Kind of error that occurred.
    pub kind: DescribeRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRouteError {
    fn code(&self) -> Option<&str> {
        DescribeRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeRouteError {
    /// Creates a new `DescribeRouteError`.
    pub fn new(kind: DescribeRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeRouteErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeRouteErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeRouteErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVirtualGatewayError {
    /// Kind of error that occurred.
    pub kind: DescribeVirtualGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVirtualGatewayErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVirtualGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVirtualGatewayErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewayErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewayErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewayErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewayErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeVirtualGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVirtualGatewayError {
    fn code(&self) -> Option<&str> {
        DescribeVirtualGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeVirtualGatewayErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualGatewayErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualGatewayErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeVirtualGatewayError {
    /// Creates a new `DescribeVirtualGatewayError`.
    pub fn new(kind: DescribeVirtualGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVirtualGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVirtualGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVirtualGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVirtualGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVirtualGatewayErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewayErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualGatewayErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewayErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualGatewayErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewayErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualGatewayErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewayErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualGatewayErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewayErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualGatewayErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualGatewayErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeVirtualGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVirtualGatewayErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeVirtualGatewayErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeVirtualGatewayErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeVirtualGatewayErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeVirtualGatewayErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeVirtualGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVirtualNodeError {
    /// Kind of error that occurred.
    pub kind: DescribeVirtualNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVirtualNodeErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVirtualNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVirtualNodeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeVirtualNodeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeVirtualNodeErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeVirtualNodeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeVirtualNodeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeVirtualNodeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeVirtualNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVirtualNodeError {
    fn code(&self) -> Option<&str> {
        DescribeVirtualNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeVirtualNodeErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualNodeErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualNodeErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeVirtualNodeError {
    /// Creates a new `DescribeVirtualNodeError`.
    pub fn new(kind: DescribeVirtualNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVirtualNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVirtualNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVirtualNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVirtualNodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVirtualNodeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualNodeErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualNodeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualNodeErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualNodeErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualNodeErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualNodeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualNodeErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualNodeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualNodeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualNodeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualNodeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeVirtualNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVirtualNodeErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeVirtualNodeErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeVirtualNodeErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeVirtualNodeErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeVirtualNodeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeVirtualNodeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeVirtualNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVirtualRouterError {
    /// Kind of error that occurred.
    pub kind: DescribeVirtualRouterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVirtualRouterErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVirtualRouterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVirtualRouterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeVirtualRouterErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeVirtualRouterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeVirtualRouterErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeVirtualRouterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeVirtualRouterErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeVirtualRouterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVirtualRouterError {
    fn code(&self) -> Option<&str> {
        DescribeVirtualRouterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeVirtualRouterErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualRouterErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualRouterErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeVirtualRouterError {
    /// Creates a new `DescribeVirtualRouterError`.
    pub fn new(kind: DescribeVirtualRouterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVirtualRouterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVirtualRouterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVirtualRouterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVirtualRouterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVirtualRouterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualRouterErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualRouterErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualRouterErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualRouterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualRouterErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualRouterErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualRouterErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualRouterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualRouterErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualRouterErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualRouterErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeVirtualRouterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVirtualRouterErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeVirtualRouterErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeVirtualRouterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeVirtualRouterErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeVirtualRouterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeVirtualRouterErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeVirtualRouterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeVirtualServiceError {
    /// Kind of error that occurred.
    pub kind: DescribeVirtualServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeVirtualServiceErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeVirtualServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeVirtualServiceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeVirtualServiceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeVirtualServiceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeVirtualServiceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeVirtualServiceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeVirtualServiceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeVirtualServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeVirtualServiceError {
    fn code(&self) -> Option<&str> {
        DescribeVirtualServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            DescribeVirtualServiceErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualServiceErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            DescribeVirtualServiceErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl DescribeVirtualServiceError {
    /// Creates a new `DescribeVirtualServiceError`.
    pub fn new(kind: DescribeVirtualServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeVirtualServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeVirtualServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeVirtualServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeVirtualServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeVirtualServiceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualServiceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualServiceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualServiceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualServiceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualServiceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualServiceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualServiceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualServiceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualServiceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeVirtualServiceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeVirtualServiceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeVirtualServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeVirtualServiceErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeVirtualServiceErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeVirtualServiceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeVirtualServiceErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeVirtualServiceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeVirtualServiceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeVirtualServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListGatewayRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListGatewayRoutesError {
    /// Kind of error that occurred.
    pub kind: ListGatewayRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListGatewayRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListGatewayRoutesErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListGatewayRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListGatewayRoutesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListGatewayRoutesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListGatewayRoutesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListGatewayRoutesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListGatewayRoutesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListGatewayRoutesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListGatewayRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListGatewayRoutesError {
    fn code(&self) -> Option<&str> {
        ListGatewayRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListGatewayRoutesErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListGatewayRoutesErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListGatewayRoutesErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListGatewayRoutesError {
    /// Creates a new `ListGatewayRoutesError`.
    pub fn new(kind: ListGatewayRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListGatewayRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListGatewayRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListGatewayRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListGatewayRoutesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListGatewayRoutesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewayRoutesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGatewayRoutesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewayRoutesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGatewayRoutesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewayRoutesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGatewayRoutesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListGatewayRoutesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListGatewayRoutesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewayRoutesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListGatewayRoutesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListGatewayRoutesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListGatewayRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListGatewayRoutesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListGatewayRoutesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListGatewayRoutesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListGatewayRoutesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListGatewayRoutesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListGatewayRoutesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListGatewayRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMeshes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMeshesError {
    /// Kind of error that occurred.
    pub kind: ListMeshesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMeshes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMeshesErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMeshesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMeshesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListMeshesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListMeshesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListMeshesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListMeshesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListMeshesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListMeshesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMeshesError {
    fn code(&self) -> Option<&str> {
        ListMeshesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListMeshesErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListMeshesErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListMeshesErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListMeshesError {
    /// Creates a new `ListMeshesError`.
    pub fn new(kind: ListMeshesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMeshesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMeshesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMeshesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMeshesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMeshesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListMeshesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListMeshesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListMeshesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListMeshesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeshesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeshesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListMeshesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListMeshesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMeshesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMeshesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListMeshesErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListMeshesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMeshesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListMeshesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListMeshesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListMeshesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListMeshesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListMeshesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListMeshesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoutesError {
    /// Kind of error that occurred.
    pub kind: ListRoutesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoutes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoutesErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoutesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoutesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListRoutesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoutesError {
    fn code(&self) -> Option<&str> {
        ListRoutesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListRoutesErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListRoutesErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListRoutesErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListRoutesError {
    /// Creates a new `ListRoutesError`.
    pub fn new(kind: ListRoutesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoutesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoutesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoutesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoutesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListRoutesErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListRoutesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoutesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListRoutesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListRoutesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListRoutesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListRoutesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListRoutesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListRoutesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListTagsForResourceErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListTagsForResourceErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVirtualGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVirtualGatewaysError {
    /// Kind of error that occurred.
    pub kind: ListVirtualGatewaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVirtualGateways` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVirtualGatewaysErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVirtualGatewaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVirtualGatewaysErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListVirtualGatewaysErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListVirtualGatewaysErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListVirtualGatewaysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListVirtualGatewaysErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListVirtualGatewaysErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListVirtualGatewaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVirtualGatewaysError {
    fn code(&self) -> Option<&str> {
        ListVirtualGatewaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListVirtualGatewaysErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualGatewaysErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualGatewaysErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListVirtualGatewaysError {
    /// Creates a new `ListVirtualGatewaysError`.
    pub fn new(kind: ListVirtualGatewaysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVirtualGatewaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVirtualGatewaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVirtualGatewaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVirtualGatewaysErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListVirtualGatewaysErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualGatewaysErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualGatewaysErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualGatewaysErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualGatewaysErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualGatewaysErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualGatewaysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualGatewaysErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualGatewaysErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualGatewaysErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualGatewaysErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualGatewaysErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListVirtualGatewaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVirtualGatewaysErrorKind::BadRequestException(_inner) => Some(_inner),
            ListVirtualGatewaysErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListVirtualGatewaysErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListVirtualGatewaysErrorKind::NotFoundException(_inner) => Some(_inner),
            ListVirtualGatewaysErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListVirtualGatewaysErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListVirtualGatewaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVirtualNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVirtualNodesError {
    /// Kind of error that occurred.
    pub kind: ListVirtualNodesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVirtualNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVirtualNodesErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVirtualNodesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVirtualNodesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListVirtualNodesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListVirtualNodesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListVirtualNodesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListVirtualNodesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListVirtualNodesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListVirtualNodesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVirtualNodesError {
    fn code(&self) -> Option<&str> {
        ListVirtualNodesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListVirtualNodesErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualNodesErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualNodesErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListVirtualNodesError {
    /// Creates a new `ListVirtualNodesError`.
    pub fn new(kind: ListVirtualNodesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVirtualNodesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVirtualNodesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVirtualNodesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVirtualNodesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListVirtualNodesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualNodesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualNodesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListVirtualNodesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListVirtualNodesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualNodesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualNodesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListVirtualNodesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListVirtualNodesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualNodesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualNodesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualNodesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListVirtualNodesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVirtualNodesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListVirtualNodesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListVirtualNodesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListVirtualNodesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListVirtualNodesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListVirtualNodesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListVirtualNodesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVirtualRouters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVirtualRoutersError {
    /// Kind of error that occurred.
    pub kind: ListVirtualRoutersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVirtualRouters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVirtualRoutersErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVirtualRoutersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVirtualRoutersErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListVirtualRoutersErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListVirtualRoutersErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListVirtualRoutersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListVirtualRoutersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListVirtualRoutersErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListVirtualRoutersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVirtualRoutersError {
    fn code(&self) -> Option<&str> {
        ListVirtualRoutersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListVirtualRoutersErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualRoutersErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualRoutersErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListVirtualRoutersError {
    /// Creates a new `ListVirtualRoutersError`.
    pub fn new(kind: ListVirtualRoutersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVirtualRoutersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVirtualRoutersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVirtualRoutersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVirtualRoutersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListVirtualRoutersErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualRoutersErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualRoutersErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualRoutersErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualRoutersErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualRoutersErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualRoutersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualRoutersErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualRoutersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualRoutersErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualRoutersErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualRoutersErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListVirtualRoutersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVirtualRoutersErrorKind::BadRequestException(_inner) => Some(_inner),
            ListVirtualRoutersErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListVirtualRoutersErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListVirtualRoutersErrorKind::NotFoundException(_inner) => Some(_inner),
            ListVirtualRoutersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListVirtualRoutersErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListVirtualRoutersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListVirtualServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListVirtualServicesError {
    /// Kind of error that occurred.
    pub kind: ListVirtualServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListVirtualServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListVirtualServicesErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListVirtualServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListVirtualServicesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListVirtualServicesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListVirtualServicesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListVirtualServicesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListVirtualServicesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListVirtualServicesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListVirtualServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListVirtualServicesError {
    fn code(&self) -> Option<&str> {
        ListVirtualServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            ListVirtualServicesErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualServicesErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            ListVirtualServicesErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl ListVirtualServicesError {
    /// Creates a new `ListVirtualServicesError`.
    pub fn new(kind: ListVirtualServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListVirtualServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListVirtualServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListVirtualServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListVirtualServicesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListVirtualServicesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualServicesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualServicesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualServicesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualServicesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualServicesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualServicesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualServicesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualServicesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualServicesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListVirtualServicesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListVirtualServicesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListVirtualServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListVirtualServicesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListVirtualServicesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListVirtualServicesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListVirtualServicesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListVirtualServicesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListVirtualServicesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListVirtualServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The request exceeds the maximum allowed number of tags allowed per resource. The current limit is 50 user tags per resource. You must reduce the number of tags in the request. None of the tags in this request were applied.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            TagResourceErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            TagResourceErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            TagResourceErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UntagResourceErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UntagResourceErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateGatewayRouteError {
    /// Kind of error that occurred.
    pub kind: UpdateGatewayRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateGatewayRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateGatewayRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateGatewayRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateGatewayRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateGatewayRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateGatewayRouteError {
    fn code(&self) -> Option<&str> {
        UpdateGatewayRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateGatewayRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateGatewayRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateGatewayRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateGatewayRouteError {
    /// Creates a new `UpdateGatewayRouteError`.
    pub fn new(kind: UpdateGatewayRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateGatewayRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateGatewayRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateGatewayRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateGatewayRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateGatewayRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateGatewayRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateGatewayRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateGatewayRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateGatewayRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMeshError {
    /// Kind of error that occurred.
    pub kind: UpdateMeshErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMesh` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMeshErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMeshError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMeshErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateMeshErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMeshErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateMeshErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateMeshErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateMeshErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateMeshErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateMeshErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMeshError {
    fn code(&self) -> Option<&str> {
        UpdateMeshError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateMeshErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateMeshErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateMeshErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateMeshError {
    /// Creates a new `UpdateMeshError`.
    pub fn new(kind: UpdateMeshErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMeshError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMeshErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMeshError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMeshErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMeshErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateMeshErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateMeshErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateMeshErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateMeshErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateMeshErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateMeshErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMeshErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMeshErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateMeshErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateMeshErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMeshErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMeshErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, UpdateMeshErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for UpdateMeshError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMeshErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateMeshErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMeshErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateMeshErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateMeshErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateMeshErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateMeshErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateMeshErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRouteError {
    /// Kind of error that occurred.
    pub kind: UpdateRouteErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRouteErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRouteError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRouteErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateRouteErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRouteError {
    fn code(&self) -> Option<&str> {
        UpdateRouteError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateRouteErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateRouteErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateRouteErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateRouteError {
    /// Creates a new `UpdateRouteError`.
    pub fn new(kind: UpdateRouteErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRouteError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRouteErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRouteError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRouteErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateRouteErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRouteErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRouteErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateRouteError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRouteErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateRouteErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRouteErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateRouteErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateRouteErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateRouteErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateRouteErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateRouteErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateRouteErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVirtualGatewayError {
    /// Kind of error that occurred.
    pub kind: UpdateVirtualGatewayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVirtualGateway` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVirtualGatewayErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVirtualGatewayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVirtualGatewayErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVirtualGatewayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVirtualGatewayError {
    fn code(&self) -> Option<&str> {
        UpdateVirtualGatewayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateVirtualGatewayErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualGatewayErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualGatewayErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateVirtualGatewayError {
    /// Creates a new `UpdateVirtualGatewayError`.
    pub fn new(kind: UpdateVirtualGatewayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVirtualGatewayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVirtualGatewayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVirtualGatewayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVirtualGatewayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualGatewayErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualGatewayErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateVirtualGatewayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVirtualGatewayErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVirtualGatewayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVirtualNodeError {
    /// Kind of error that occurred.
    pub kind: UpdateVirtualNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVirtualNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVirtualNodeErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVirtualNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVirtualNodeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVirtualNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVirtualNodeError {
    fn code(&self) -> Option<&str> {
        UpdateVirtualNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateVirtualNodeErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualNodeErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualNodeErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateVirtualNodeError {
    /// Creates a new `UpdateVirtualNodeError`.
    pub fn new(kind: UpdateVirtualNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVirtualNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVirtualNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVirtualNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVirtualNodeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualNodeErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateVirtualNodeErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualNodeErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualNodeErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualNodeErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateVirtualNodeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualNodeErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualNodeErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualNodeErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateVirtualNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVirtualNodeErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVirtualNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVirtualRouterError {
    /// Kind of error that occurred.
    pub kind: UpdateVirtualRouterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVirtualRouter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVirtualRouterErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVirtualRouterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVirtualRouterErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVirtualRouterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVirtualRouterError {
    fn code(&self) -> Option<&str> {
        UpdateVirtualRouterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateVirtualRouterErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualRouterErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualRouterErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateVirtualRouterError {
    /// Creates a new `UpdateVirtualRouterError`.
    pub fn new(kind: UpdateVirtualRouterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVirtualRouterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVirtualRouterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVirtualRouterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVirtualRouterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualRouterErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualRouterErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateVirtualRouterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVirtualRouterErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVirtualRouterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateVirtualServiceError {
    /// Kind of error that occurred.
    pub kind: UpdateVirtualServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateVirtualService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateVirtualServiceErrorKind {
    /// <p>The request syntax was malformed. Check your request syntax and try again.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>You don't have permissions to perform this action.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The request has failed due to a temporary failure of the service.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateVirtualServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateVirtualServiceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateVirtualServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateVirtualServiceError {
    fn code(&self) -> Option<&str> {
        UpdateVirtualServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        match &self.kind {
            UpdateVirtualServiceErrorKind::InternalServerErrorException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualServiceErrorKind::ServiceUnavailableException(inner) => {
                Some(inner.retryable_error_kind())
            }
            UpdateVirtualServiceErrorKind::TooManyRequestsException(inner) => {
                Some(inner.retryable_error_kind())
            }
            _ => None,
        }
    }
}
impl UpdateVirtualServiceError {
    /// Creates a new `UpdateVirtualServiceError`.
    pub fn new(kind: UpdateVirtualServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateVirtualServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateVirtualServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateVirtualServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateVirtualServiceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateVirtualServiceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateVirtualServiceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateVirtualServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateVirtualServiceErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateVirtualServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The maximum request rate permitted by the App Mesh APIs has been exceeded for your account. For best results, use an increasing or variable sleep interval between requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ThrottlingError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The request has failed due to a temporary failure of the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>The specified resource doesn't exist. Check your request syntax and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns `Some(ErrorKind)` if the error is retryable. Otherwise, returns `None`.
    pub fn retryable_error_kind(&self) -> aws_smithy_types::retry::ErrorKind {
        aws_smithy_types::retry::ErrorKind::ServerError
    }
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>You don't have permissions to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>The request syntax was malformed. Check your request syntax and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>You have exceeded a service limit for your account. For more information, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/service-quotas.html">Service Limits</a> in the <i>AWS App Mesh User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request contains a client token that was used for a previous update resource call with different specifications. Try the request again with a new client token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You can't delete the specified resource because it's in use or required by another resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>The request exceeds the maximum allowed number of tags allowed per resource. The current limit is 50 user tags per resource. You must reduce the number of tags in the request. None of the tags in this request were applied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}
